/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import javax.sql.DataSource;
import quickfix.JdbcUtil;
import quickfix.MemoryStore;
import quickfix.MessageStore;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SystemTime;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JdbcStore
implements MessageStore {
    private static final String DEFAULT_SESSION_TABLE_NAME = "sessions";
    private static final String DEFAULT_MESSAGE_TABLE_NAME = "messages";
    private final MemoryStore cache = new MemoryStore();
    private final boolean extendedSessionIdSupported;
    private final DataSource dataSource;
    private final SessionID sessionID;
    private final String sessionTableName;
    private final String messageTableName;
    private final String defaultSessionIdPropertyValue;
    private String SQL_UPDATE_SEQNUMS;
    private String SQL_INSERT_SESSION;
    private String SQL_GET_SEQNUMS;
    private String SQL_UPDATE_MESSAGE;
    private String SQL_INSERT_MESSAGE;
    private String SQL_GET_MESSAGES;
    private String SQL_UPDATE_SESSION;
    private String SQL_DELETE_MESSAGES;

    public JdbcStore(SessionSettings settings, SessionID sessionID, DataSource ds) throws Exception {
        this.sessionID = sessionID;
        this.sessionTableName = settings.isSetting(sessionID, "JdbcStoreSessionsTableName") ? settings.getString(sessionID, "JdbcStoreSessionsTableName") : DEFAULT_SESSION_TABLE_NAME;
        this.messageTableName = settings.isSetting(sessionID, "JdbcStoreMessagesTableName") ? settings.getString(sessionID, "JdbcStoreMessagesTableName") : DEFAULT_MESSAGE_TABLE_NAME;
        this.defaultSessionIdPropertyValue = settings.isSetting(sessionID, "JdbcSessionIdDefaultPropertyValue") ? settings.getString(sessionID, "JdbcSessionIdDefaultPropertyValue") : "";
        this.dataSource = ds == null ? JdbcUtil.getDataSource(settings, sessionID) : ds;
        this.extendedSessionIdSupported = JdbcUtil.determineSessionIdSupport(this.dataSource, this.sessionTableName);
        this.setSqlStrings();
        this.loadCache();
    }

    private final void setSqlStrings() {
        String idWhereClause = JdbcUtil.getIDWhereClause(this.extendedSessionIdSupported);
        String idColumns = JdbcUtil.getIDColumns(this.extendedSessionIdSupported);
        String idPlaceholders = JdbcUtil.getIDPlaceholders(this.extendedSessionIdSupported);
        this.SQL_UPDATE_SEQNUMS = new StringBuffer().append("UPDATE ").append(this.sessionTableName).append(" SET incoming_seqnum=?, ").append("outgoing_seqnum=? WHERE ").append(idWhereClause).toString();
        this.SQL_INSERT_SESSION = new StringBuffer().append("INSERT INTO ").append(this.sessionTableName).append(" (").append(idColumns).append(", creation_time,incoming_seqnum, outgoing_seqnum) VALUES (").append(idPlaceholders).append(",?,?,?)").toString();
        this.SQL_GET_SEQNUMS = new StringBuffer().append("SELECT creation_time, incoming_seqnum, outgoing_seqnum FROM ").append(this.sessionTableName).append(" WHERE ").append(idWhereClause).toString();
        this.SQL_UPDATE_MESSAGE = new StringBuffer().append("UPDATE ").append(this.messageTableName).append(" SET message=? ").append("WHERE ").append(idWhereClause).append(" and msgseqnum=?").toString();
        this.SQL_INSERT_MESSAGE = new StringBuffer().append("INSERT INTO ").append(this.messageTableName).append(" (").append(idColumns).append(", msgseqnum,message) VALUES (").append(idPlaceholders).append(",?,?)").toString();
        this.SQL_GET_MESSAGES = new StringBuffer().append("SELECT message FROM ").append(this.messageTableName).append(" WHERE  ").append(idWhereClause).append(" and msgseqnum>=? and msgseqnum<=? ").append("ORDER BY msgseqnum").toString();
        this.SQL_UPDATE_SESSION = new StringBuffer().append("UPDATE ").append(this.sessionTableName).append(" SET creation_time=?, ").append("incoming_seqnum=?, outgoing_seqnum=? ").append("WHERE ").append(idWhereClause).toString();
        this.SQL_DELETE_MESSAGES = new StringBuffer().append("DELETE FROM ").append(this.messageTableName).append(" WHERE ").append(idWhereClause).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache() throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement insert;
        PreparedStatement query;
        Connection connection;
        block3: {
            connection = null;
            query = null;
            insert = null;
            rs = null;
            try {
                connection = this.dataSource.getConnection();
                query = connection.prepareStatement(this.SQL_GET_SEQNUMS);
                this.setSessionIdParameters(query, 1);
                rs = query.executeQuery();
                if (rs.next()) {
                    this.cache.setCreationTime(SystemTime.getUtcCalendar(rs.getTimestamp(1)));
                    this.cache.setNextTargetMsgSeqNum(rs.getInt(2));
                    this.cache.setNextSenderMsgSeqNum(rs.getInt(3));
                    break block3;
                }
                insert = connection.prepareStatement(this.SQL_INSERT_SESSION);
                int offset = this.setSessionIdParameters(insert, 1);
                insert.setTimestamp(offset++, new Timestamp(this.cache.getCreationTime().getTime()));
                insert.setInt(offset++, this.cache.getNextTargetMsgSeqNum());
                insert.setInt(offset, this.cache.getNextSenderMsgSeqNum());
                insert.execute();
            }
            catch (Throwable throwable) {
                JdbcUtil.close(this.sessionID, rs);
                JdbcUtil.close(this.sessionID, query);
                JdbcUtil.close(this.sessionID, insert);
                JdbcUtil.close(this.sessionID, connection);
                throw throwable;
            }
        }
        JdbcUtil.close(this.sessionID, rs);
        JdbcUtil.close(this.sessionID, query);
        JdbcUtil.close(this.sessionID, insert);
        JdbcUtil.close(this.sessionID, connection);
    }

    private int setSessionIdParameters(PreparedStatement query, int offset) throws SQLException {
        return JdbcUtil.setSessionIdParameters(this.sessionID, query, offset, this.extendedSessionIdSupported, this.defaultSessionIdPropertyValue);
    }

    @Override
    public Date getCreationTime() throws IOException {
        return this.cache.getCreationTime();
    }

    @Override
    public int getNextSenderMsgSeqNum() throws IOException {
        return this.cache.getNextSenderMsgSeqNum();
    }

    @Override
    public int getNextTargetMsgSeqNum() throws IOException {
        return this.cache.getNextTargetMsgSeqNum();
    }

    @Override
    public void incrNextSenderMsgSeqNum() throws IOException {
        this.cache.incrNextSenderMsgSeqNum();
        this.setNextSenderMsgSeqNum(this.cache.getNextSenderMsgSeqNum());
    }

    @Override
    public void incrNextTargetMsgSeqNum() throws IOException {
        this.cache.incrNextTargetMsgSeqNum();
        this.setNextTargetMsgSeqNum(this.cache.getNextTargetMsgSeqNum());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reset() throws IOException {
        this.cache.reset();
        Connection connection = null;
        PreparedStatement deleteMessages = null;
        PreparedStatement updateTime = null;
        try {
            connection = this.dataSource.getConnection();
            deleteMessages = connection.prepareStatement(this.SQL_DELETE_MESSAGES);
            this.setSessionIdParameters(deleteMessages, 1);
            deleteMessages.execute();
            updateTime = connection.prepareStatement(this.SQL_UPDATE_SESSION);
            updateTime.setTimestamp(1, new Timestamp(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis()));
            updateTime.setInt(2, this.getNextTargetMsgSeqNum());
            updateTime.setInt(3, this.getNextSenderMsgSeqNum());
            this.setSessionIdParameters(updateTime, 4);
            updateTime.execute();
        }
        catch (SQLException e) {
            try {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
                catch (IOException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(this.sessionID, deleteMessages);
                JdbcUtil.close(this.sessionID, updateTime);
                JdbcUtil.close(this.sessionID, connection);
                throw throwable;
            }
        }
        JdbcUtil.close(this.sessionID, deleteMessages);
        JdbcUtil.close(this.sessionID, updateTime);
        JdbcUtil.close(this.sessionID, connection);
    }

    @Override
    public void get(int startSequence, int endSequence, Collection<String> messages) throws IOException {
        Connection connection = null;
        PreparedStatement query = null;
        ResultSet rs = null;
        try {
            connection = this.dataSource.getConnection();
            query = connection.prepareStatement(this.SQL_GET_MESSAGES);
            int offset = this.setSessionIdParameters(query, 1);
            query.setInt(offset++, startSequence);
            query.setInt(offset, endSequence);
            rs = query.executeQuery();
            while (rs.next()) {
                String message = rs.getString(1);
                messages.add(message);
            }
        }
        catch (SQLException e) {
            try {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(this.sessionID, rs);
                JdbcUtil.close(this.sessionID, query);
                JdbcUtil.close(this.sessionID, connection);
                throw throwable;
            }
        }
        JdbcUtil.close(this.sessionID, rs);
        JdbcUtil.close(this.sessionID, query);
        JdbcUtil.close(this.sessionID, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(int sequence, String message) throws IOException {
        Connection connection = null;
        PreparedStatement insert = null;
        ResultSet rs = null;
        try {
            connection = this.dataSource.getConnection();
            insert = connection.prepareStatement(this.SQL_INSERT_MESSAGE);
            int offset = this.setSessionIdParameters(insert, 1);
            insert.setInt(offset++, sequence);
            insert.setString(offset, message);
            insert.execute();
        }
        catch (SQLException ex) {
            if (connection != null) {
                PreparedStatement update = null;
                try {
                    update = connection.prepareStatement(this.SQL_UPDATE_MESSAGE);
                    update.setString(1, message);
                    int offset = this.setSessionIdParameters(update, 2);
                    update.setInt(offset, sequence);
                    boolean status = update.execute();
                    boolean bl = !status ? update.getUpdateCount() > 0 : false;
                    return bl;
                }
                catch (SQLException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
                finally {
                    JdbcUtil.close(this.sessionID, update);
                }
            }
        }
        finally {
            JdbcUtil.close(this.sessionID, rs);
            JdbcUtil.close(this.sessionID, insert);
            JdbcUtil.close(this.sessionID, connection);
        }
        return true;
    }

    @Override
    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.cache.setNextSenderMsgSeqNum(next);
        this.storeSequenceNumbers();
    }

    @Override
    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.cache.setNextTargetMsgSeqNum(next);
        this.storeSequenceNumbers();
    }

    private void storeSequenceNumbers() throws IOException {
        Connection connection = null;
        PreparedStatement update = null;
        try {
            connection = this.dataSource.getConnection();
            update = connection.prepareStatement(this.SQL_UPDATE_SEQNUMS);
            update.setInt(1, this.cache.getNextTargetMsgSeqNum());
            update.setInt(2, this.cache.getNextSenderMsgSeqNum());
            this.setSessionIdParameters(update, 3);
            update.execute();
        }
        catch (SQLException e) {
            try {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(this.sessionID, update);
                JdbcUtil.close(this.sessionID, connection);
                throw throwable;
            }
        }
        JdbcUtil.close(this.sessionID, update);
        JdbcUtil.close(this.sessionID, connection);
    }

    @Override
    public void refresh() throws IOException {
        try {
            this.loadCache();
        }
        catch (SQLException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    DataSource getDataSource() {
        return this.dataSource;
    }
}

