/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.mbean.connector;

import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.quickfixj.QFJException;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.quickfixj.jmx.JmxExporter;
import org.quickfixj.jmx.mbean.ObjectNameFactory;
import org.quickfixj.jmx.mbean.connector.ConnectorAdmin;
import org.quickfixj.jmx.mbean.connector.SocketAcceptorAdmin;
import org.quickfixj.jmx.mbean.connector.SocketInitiatorAdmin;
import org.quickfixj.jmx.mbean.session.SessionJmxExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Acceptor;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.mina.SessionConnector;
import quickfix.mina.acceptor.AbstractSocketAcceptor;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class ConnectorJmxExporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SessionJmxExporter sessionExporter = new SessionJmxExporter();
    private static final AtomicInteger connectorIdCounter = new AtomicInteger();

    public void export(JmxExporter jmxExporter, SessionConnector connector) {
        this.export(jmxExporter, connector, Integer.toString(connectorIdCounter.incrementAndGet()));
    }

    public void export(JmxExporter jmxExporter, SessionConnector connector, String connectorId) {
        try {
            ConnectorAdmin connectorAdmin;
            if (connector instanceof AbstractSocketAcceptor) {
                connectorAdmin = new SocketAcceptorAdmin((AbstractSocketAcceptor)connector, this.sessionExporter);
            } else if (connector instanceof AbstractSocketInitiator) {
                connectorAdmin = new SocketInitiatorAdmin((AbstractSocketInitiator)connector, this.sessionExporter);
            } else {
                throw new QFJException("Unknown connector type: " + connector.getClass().getName());
            }
            ObjectName connectorName = this.getConnectorName(connector, connectorId);
            jmxExporter.registerMBean(connectorAdmin, connectorName);
            ArrayList<SessionID> sessionIDs = connector.getSessions();
            for (int i = 0; i < sessionIDs.size(); ++i) {
                SessionID sessionID = sessionIDs.get(i);
                this.sessionExporter.export(jmxExporter, Session.lookupSession(sessionID), connectorName, connector.getSettings());
            }
        }
        catch (Exception e) {
            this.log.error("Failed to export connector MBean", (Throwable)e);
        }
    }

    private ObjectName getConnectorName(SessionConnector connector, String connectorId) throws MalformedObjectNameException {
        ObjectNameFactory nameFactory = new ObjectNameFactory();
        nameFactory.addProperty("type", "Connector");
        nameFactory.addProperty("role", connector instanceof Acceptor ? "Acceptor" : "Initiator");
        nameFactory.addProperty("id", connectorId);
        return nameFactory.createName();
    }

    public ObjectName lookupSessionName(SessionID sessionID) {
        return this.sessionExporter.getSessionName(sessionID);
    }
}

