/*
 * hicumL2V2p31n.defs.h - device definition header
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 */

#ifndef __hicumL2V2p31n_DEFS_H__
#define __hicumL2V2p31n_DEFS_H__

// required properties
PROP_REQ [] = {
  { "c10", PROP_REAL, { 2.0E-30, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "qp0", PROP_REAL, { 2.0E-14, PROP_NO_STR }, PROP_RNGXI (0, 1) },
  { "ich", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "hf0", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "hfe", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "hfc", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "hjei", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGII (0, 100) },
  { "ahjei", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 100) },
  { "rhjei", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "hjci", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGII (0, 100) },
  { "ibeis", PROP_REAL, { 1.0E-18, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "mbei", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "ireis", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "mrei", PROP_REAL, { 2.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "ibeps", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "mbep", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "ireps", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "mrep", PROP_REAL, { 2.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "mcf", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "tbhrec", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "ibcis", PROP_REAL, { 1.0E-16, PROP_NO_STR }, PROP_RNGII (0, 1.0) },
  { "mbci", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "ibcxs", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1.0) },
  { "mbcx", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "ibets", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "abet", PROP_REAL, { 40, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "tunode", PROP_INT, { 1, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "favl", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "qavl", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "alfav", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "alqav", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "rbi0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "rbx", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "fgeo", PROP_REAL, { 0.6557, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "fdqr0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (-0.5, 100) },
  { "fcrbi", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "fqi", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "re", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "rcx", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "itss", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1.0) },
  { "msf", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "iscs", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1.0) },
  { "msc", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "tsf", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "rsu", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "csu", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "cjei0", PROP_REAL, { 1.0E-20, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "vdei", PROP_REAL, { 0.9, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "zei", PROP_REAL, { 0.5, PROP_NO_STR }, PROP_RNGXI (0, 1) },
  { "ajei", PROP_REAL, { 2.5, PROP_NO_STR }, PROP_MIN_VAL (1) },
  { "cjep0", PROP_REAL, { 1.0E-20, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "vdep", PROP_REAL, { 0.9, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "zep", PROP_REAL, { 0.5, PROP_NO_STR }, PROP_RNGXI (0, 1) },
  { "ajep", PROP_REAL, { 2.5, PROP_NO_STR }, PROP_MIN_VAL (1) },
  { "cjci0", PROP_REAL, { 1.0E-20, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "vdci", PROP_REAL, { 0.7, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "zci", PROP_REAL, { 0.4, PROP_NO_STR }, PROP_RNGXI (0, 1) },
  { "vptci", PROP_REAL, { 100, PROP_NO_STR }, PROP_RNGXI (0, 100) },
  { "cjcx0", PROP_REAL, { 1.0E-20, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "vdcx", PROP_REAL, { 0.7, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "zcx", PROP_REAL, { 0.4, PROP_NO_STR }, PROP_RNGXI (0, 1) },
  { "vptcx", PROP_REAL, { 100, PROP_NO_STR }, PROP_RNGXI (0, 100) },
  { "fbcpar", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "fbepar", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "cjs0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "vds", PROP_REAL, { 0.6, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "zs", PROP_REAL, { 0.5, PROP_NO_STR }, PROP_RNGXI (0, 1) },
  { "vpts", PROP_REAL, { 100, PROP_NO_STR }, PROP_RNGXI (0, 100) },
  { "t0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "dt0h", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "tbvl", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "tef0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "gtfe", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "thcs", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "ahc", PROP_REAL, { 0.1, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "fthc", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "rci0", PROP_REAL, { 150, PROP_NO_STR }, PROP_MIN_VALX (0) },
  { "vlim", PROP_REAL, { 0.5, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "vces", PROP_REAL, { 0.1, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "vpt", PROP_REAL, { 100.0, PROP_NO_STR }, PROP_MIN_VALX (0) },
  { "tr", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "vcbar", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "icbar", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "acbar", PROP_REAL, { 0.01, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "delck", PROP_REAL, { 2.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "cbepar", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "cbcpar", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "alqf", PROP_REAL, { 0.167, PROP_NO_STR }, PROP_RNGXI (0, 1) },
  { "alit", PROP_REAL, { 0.333, PROP_NO_STR }, PROP_RNGXI (0, 1) },
  { "flnqs", PROP_INT, { 0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "kf", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "af", PROP_REAL, { 2.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "cfbe", PROP_INT, { -1, PROP_NO_STR }, PROP_RNGII (-2, -1) },
  { "flcono", PROP_INT, { 0, PROP_NO_STR }, PROP_RNGII (0, 1) },
  { "kfre", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "afre", PROP_REAL, { 2.0, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "latb", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "latl", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "vgb", PROP_REAL, { 1.17, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "alt0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "kt0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "zetaci", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "alvs", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "alces", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "zetarbi", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "zetarbx", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "zetarcx", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "zetare", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "zetacx", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "vge", PROP_REAL, { 1.17, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "vgc", PROP_REAL, { 1.17, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "vgs", PROP_REAL, { 1.17, PROP_NO_STR }, PROP_RNGXI (0, 10) },
  { "f1vg", PROP_REAL, { -1.02377e-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "f2vg", PROP_REAL, { 4.3215e-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "zetact", PROP_REAL, { 3.0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "zetabet", PROP_REAL, { 3.5, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "alb", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "dvgbe", PROP_REAL, { 0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "zetahjei", PROP_REAL, { 1, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "zetavgbe", PROP_REAL, { 1, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "flsh", PROP_INT, { 0, PROP_NO_STR }, PROP_RNGII (0, 2) },
  { "rth", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "zetarth", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "alrth", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_RNGII (-10, 10) },
  { "cth", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "flcomp", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_MIN_VAL (0) },
  { "tnom", PROP_REAL, { 27.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "dt", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  PROP_NO_PROP };

// optional properties
PROP_OPT [] = {
  { "Temp", PROP_REAL, { 27.0, PROP_NO_STR }, PROP_MIN_VAL (K) },
  PROP_NO_PROP };

// device definition
struct define_t hicumL2V2p31n::cirdef =
  { "hicumL2V2p31n",
    5, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR, PROP_DEF };

#endif /* __hicumL2V2p31n_DEFS_H__ */
