# qmake include file to handle C# compilation

isEmpty(CSC) {
    system( csc -help &>/dev/null ) {
        CSC = csc
    } else {
        system( mcs -help &>/dev/null ) {
            CSC = mcs
        }  else {
            system( cscc -help &>/dev/null ) {
                CSC = cscc
            } else {
                message("No C-Sharp compiler found")
            }
        }
    }
}

message(CSC = $$CSC)

# Check for optimization requested
contains(CONFIG, optimize) {
    CS_OPTS *= -optimize+
}

# Check for unsafe code requested
contains(CONFIG, unsafe) {
    CS_OPTS *= -unsafe+
}

# Select target type for -target:X
dll {
    CS_OPTS *= -target:library
} else {
    CS_OPTS *= -target:exe
}

CS_OPTS *= $$join(NOWARN, " -nowarn:", "-nowarn:")
CS_OPTS *= $$join(CS_REFS, " -r:", "-r:")


QMAKE_CLEAN *= *.dll *.exe

csharp.target = $$TARGET
csharp.commands = $$CSC -out:$${TARGET} $${CS_OPTS} $${CS_SOURCES}

QMAKE_EXTRA_UNIX_TARGETS += csharp
