// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only

#include "qquicklayeritem_p.h"
#include <QtQuick/private/qquickitem_p.h>

QT_BEGIN_NAMESPACE

/*!
    \qmltype LayerItem
    \inqmlmodule Qt.labs.lottieqt.VectorImageHelpers
    \brief An Item that provides access to its transformation matrix as a property.

    The LayerItem type maintains a \c transformMatrix property, which at any time will contain the
    combination of the item's own transform with all its ancestors' transforms. It is used in
    particular to support linked transforms in certain vector graphics formats. As any type in
    the \c VectorImageHelpers module, it is only intended to be used in code generated by
    \l VectorImage and related tools.
*/
QQuickLayerItem::QQuickLayerItem(QQuickItem *parent)
    : QQuickItem(parent)
{
}

/*!
    \qmlproperty matrix4x4 Qt.labs.lottieqt.VectorImageHelpers::LayerItem::transformMatrix

    The result of combining this item's transform with the transforms of its entire
    ancestor chain.
*/
QMatrix4x4 QQuickLayerItem::transformMatrix()
{
    Q_D(const QQuickItem);
    if (m_transformDirty) {
        m_transformDirty = false;
        QTransform xf;
        d->itemToParentTransform(&xf);
        m_transform = xf;
    }
    return m_transform;
}

void QQuickLayerItem::itemChange(ItemChange change, const ItemChangeData &value)
{
    if (change == ItemTransformHasChanged) {
        m_transformDirty = true;
        emit transformMatrixChanged();
    }

    QQuickItem::itemChange(change, value);
}

QT_END_NAMESPACE

#include <moc_qquicklayeritem_p.cpp>
