#!/bin/bash
#
# Copyright 2015 Google Inc. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Note: This script requires the Android NDK and Android SDK to be installed.
#       It also requires an Android device to be connected for installing and
#       running the applicaton.

sampledir=$(readlink -fn `dirname $0`)
currentdir=$(readlink -fn `pwd`)

if [[ "$sampledir" != "$currentdir" ]]; then
  echo Error: This script must be run from inside the $sampledir directory.
  echo You executed it from the $currentdir directory.
  exit 1
fi

# Execute `build_apk.sh` to build and run the android app.
cd android
./build_apk.sh

# Cleanup the temporary files.
rm build.xml local.properties proguard-project.txt project.properties
rm -rf bin libs obj
