/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.base.CaseFormat;
import com.google.common.primitives.Ints;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocNodeImpl;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocLexer;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class AbstractJavadocCheck
extends Check {
    public static final String PARSE_ERROR_MESSAGE_KEY = "javadoc.parse.error";
    public static final String UNRECOGNIZED_ANTLR_ERROR_MESSAGE_KEY = "javadoc.unrecognized.antlr.error";
    private static final Map<String, ParseStatus> TREE_CACHE = new HashMap<String, ParseStatus>();
    private final DescriptiveErrorListener errorListener = new DescriptiveErrorListener();
    private DetailAST blockCommentAst;

    public abstract int[] getDefaultJavadocTokens();

    public void beginJavadocTree(DetailNode rootAst) {
    }

    public void finishJavadocTree(DetailNode rootAst) {
    }

    public void visitJavadocToken(DetailNode ast) {
    }

    public void leaveJavadocToken(DetailNode ast) {
    }

    @Override
    public final int[] getDefaultTokens() {
        return new int[]{145};
    }

    @Override
    public final int[] getAcceptableTokens() {
        return super.getAcceptableTokens();
    }

    @Override
    public final int[] getRequiredTokens() {
        return super.getRequiredTokens();
    }

    @Override
    public final boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public final void beginTree(DetailAST rootAST) {
        TREE_CACHE.clear();
    }

    @Override
    public final void finishTree(DetailAST rootAST) {
        TREE_CACHE.clear();
    }

    @Override
    public final void leaveToken(DetailAST ast) {
    }

    @Override
    public final void visitToken(DetailAST blockCommentAst) {
        if (JavadocUtils.isJavadocComment(blockCommentAst)) {
            ParseStatus ps;
            this.blockCommentAst = blockCommentAst;
            String treeCacheKey = blockCommentAst.getLineNo() + ":" + blockCommentAst.getColumnNo();
            if (TREE_CACHE.containsKey(treeCacheKey)) {
                ps = TREE_CACHE.get(treeCacheKey);
            } else {
                ps = this.parseJavadocAsDetailNode(blockCommentAst);
                TREE_CACHE.put(treeCacheKey, ps);
            }
            if (ps.getParseErrorMessage() == null) {
                this.processTree(ps.getTree());
            } else {
                ParseErrorMessage parseErrorMessage = ps.getParseErrorMessage();
                this.log(parseErrorMessage.getLineNumber(), parseErrorMessage.getMessageKey(), parseErrorMessage.getMessageArguments());
            }
        }
    }

    protected DetailAST getBlockCommentAst() {
        return this.blockCommentAst;
    }

    private ParseStatus parseJavadocAsDetailNode(DetailAST javadocCommentAst) {
        ParseErrorMessage parseErrorMessage;
        ParseTree parseTree;
        ParseStatus result;
        block5: {
            String javadocComment = JavadocUtils.getJavadocCommentContent(javadocCommentAst);
            this.errorListener.setOffset(javadocCommentAst.getLineNo() - 1);
            result = new ParseStatus();
            parseTree = null;
            parseErrorMessage = null;
            try {
                parseTree = this.parseJavadocAsParseTree(javadocComment);
            }
            catch (IOException e) {
                parseErrorMessage = new ParseErrorMessage(javadocCommentAst.getLineNo(), PARSE_ERROR_MESSAGE_KEY, javadocCommentAst.getColumnNo(), e.getMessage());
            }
            catch (ParseCancellationException e) {
                parseErrorMessage = this.errorListener.getErrorMessage();
                if (parseErrorMessage != null) break block5;
                parseErrorMessage = new ParseErrorMessage(javadocCommentAst.getLineNo(), UNRECOGNIZED_ANTLR_ERROR_MESSAGE_KEY, javadocCommentAst.getColumnNo(), e.getMessage());
            }
        }
        if (parseErrorMessage == null) {
            DetailNode tree = this.convertParseTree2DetailNode(parseTree);
            result.setTree(tree);
        } else {
            result.setParseErrorMessage(parseErrorMessage);
        }
        return result;
    }

    private DetailNode convertParseTree2DetailNode(ParseTree rootParseTree) {
        ParseTree currentParseTreeNode = rootParseTree;
        JavadocNodeImpl rootJavadocNode = this.createJavadocNode(currentParseTreeNode, null, -1);
        int childCount = currentParseTreeNode.getChildCount();
        JavadocNodeImpl[] children = (JavadocNodeImpl[])rootJavadocNode.getChildren();
        for (int i = 0; i < childCount; ++i) {
            JavadocNodeImpl child;
            children[i] = child = this.createJavadocNode(currentParseTreeNode.getChild(i), rootJavadocNode, i);
        }
        JavadocNodeImpl currentJavadocParent = rootJavadocNode;
        ParseTree currentParseTreeParent = currentParseTreeNode;
        while (currentJavadocParent != null) {
            children = (JavadocNodeImpl[])currentJavadocParent.getChildren();
            childCount = children.length;
            for (int i = 0; i < childCount; ++i) {
                JavadocNodeImpl currentJavadocNode = children[i];
                ParseTree currentParseTreeNodeChild = currentParseTreeParent.getChild(i);
                JavadocNodeImpl[] subChildren = (JavadocNodeImpl[])currentJavadocNode.getChildren();
                for (int j = 0; j < subChildren.length; ++j) {
                    JavadocNodeImpl child;
                    subChildren[j] = child = this.createJavadocNode(currentParseTreeNodeChild.getChild(j), currentJavadocNode, j);
                }
            }
            if (childCount > 0) {
                currentJavadocParent = children[0];
                currentParseTreeParent = currentParseTreeParent.getChild(0);
                continue;
            }
            JavadocNodeImpl nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(currentJavadocParent);
            ParseTree nextParseTreeSibling = AbstractJavadocCheck.getNextSibling(currentParseTreeParent);
            if (nextJavadocSibling == null) {
                JavadocNodeImpl tempJavadocParent = (JavadocNodeImpl)currentJavadocParent.getParent();
                ParseTree tempParseTreeParent = currentParseTreeParent.getParent();
                while (nextJavadocSibling == null && tempJavadocParent != null) {
                    nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(tempJavadocParent);
                    nextParseTreeSibling = AbstractJavadocCheck.getNextSibling(tempParseTreeParent);
                    tempJavadocParent = (JavadocNodeImpl)tempJavadocParent.getParent();
                    tempParseTreeParent = tempParseTreeParent.getParent();
                }
            }
            currentJavadocParent = nextJavadocSibling;
            currentParseTreeParent = nextParseTreeSibling;
        }
        return rootJavadocNode;
    }

    private JavadocNodeImpl createJavadocNode(ParseTree parseTree, DetailNode parent, int index) {
        JavadocNodeImpl node = new JavadocNodeImpl();
        node.setText(parseTree.getText());
        node.setColumnNumber(AbstractJavadocCheck.getColumn(parseTree));
        node.setLineNumber(AbstractJavadocCheck.getLine(parseTree) + this.blockCommentAst.getLineNo());
        node.setIndex(index);
        node.setType(AbstractJavadocCheck.getTokenType(parseTree));
        node.setParent(parent);
        node.setChildren(new JavadocNodeImpl[parseTree.getChildCount()]);
        return node;
    }

    private static ParseTree getNextSibling(ParseTree node) {
        if (node.getParent() == null) {
            return null;
        }
        ParseTree parent = node.getParent();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ParseTree currentNode = parent.getChild(i);
            if (!currentNode.equals(node)) continue;
            if (i == childCount - 1) {
                return null;
            }
            return parent.getChild(i + 1);
        }
        return null;
    }

    private static int getTokenType(ParseTree node) {
        int tokenType = Integer.MIN_VALUE;
        if (node.getChildCount() == 0) {
            tokenType = ((TerminalNode)node).getSymbol().getType();
        } else {
            String className = AbstractJavadocCheck.getNodeClassNameWithoutContext(node);
            String typeName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, className);
            tokenType = JavadocUtils.getTokenId(typeName);
        }
        return tokenType;
    }

    private static String getNodeClassNameWithoutContext(ParseTree node) {
        String className = node.getClass().getSimpleName();
        int contextLength = 7;
        return className.substring(0, className.length() - 7);
    }

    private static int getLine(ParseTree tree) {
        if (tree instanceof TerminalNode) {
            return ((TerminalNode)tree).getSymbol().getLine() - 1;
        }
        ParserRuleContext rule = (ParserRuleContext)tree;
        return rule.start.getLine() - 1;
    }

    private static int getColumn(ParseTree tree) {
        if (tree instanceof TerminalNode) {
            return ((TerminalNode)tree).getSymbol().getCharPositionInLine();
        }
        ParserRuleContext rule = (ParserRuleContext)tree;
        return rule.start.getCharPositionInLine();
    }

    private ParseTree parseJavadocAsParseTree(String blockComment) throws IOException {
        Charset utf8Charset = Charset.forName("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(blockComment.getBytes(utf8Charset));
        ANTLRInputStream input = new ANTLRInputStream(in);
        JavadocLexer lexer = new JavadocLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(this.errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavadocParser parser = new JavadocParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(this.errorListener);
        parser.setErrorHandler(new BailErrorStrategy());
        return parser.javadoc();
    }

    private void processTree(DetailNode root) {
        this.beginJavadocTree(root);
        this.walk(root);
        this.finishJavadocTree(root);
    }

    private void walk(DetailNode root) {
        int[] defaultTokenTypes = this.getDefaultJavadocTokens();
        if (defaultTokenTypes == null) {
            return;
        }
        DetailNode curNode = root;
        while (curNode != null) {
            boolean waitsFor = Ints.contains(defaultTokenTypes, curNode.getType());
            if (waitsFor) {
                this.visitJavadocToken(curNode);
            }
            DetailNode toVisit = JavadocUtils.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                if (waitsFor) {
                    this.leaveJavadocToken(curNode);
                }
                if ((toVisit = JavadocUtils.getNextSibling(curNode)) != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    private static class ParseErrorMessage {
        private int lineNumber;
        private String messageKey;
        private Object[] messageArguments;

        public ParseErrorMessage(int lineNumber, String messageKey, Object ... messageArguments) {
            this.lineNumber = lineNumber;
            this.messageKey = messageKey;
            this.messageArguments = messageArguments;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public Object[] getMessageArguments() {
            return this.messageArguments;
        }
    }

    private static class ParseStatus {
        private DetailNode tree;
        private ParseErrorMessage parseErrorMessage;

        private ParseStatus() {
        }

        public DetailNode getTree() {
            return this.tree;
        }

        public void setTree(DetailNode tree) {
            this.tree = tree;
        }

        public ParseErrorMessage getParseErrorMessage() {
            return this.parseErrorMessage;
        }

        public void setParseErrorMessage(ParseErrorMessage parseErrorMessage) {
            this.parseErrorMessage = parseErrorMessage;
        }
    }

    static class DescriptiveErrorListener
    extends BaseErrorListener {
        private static final String JAVADOC_PARSE_TOKEN_ERROR = "javadoc.parse.token.error";
        private static final String JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
        private static final String JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
        private static final String JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
        private int offset;
        private ParseErrorMessage errorMessage;

        DescriptiveErrorListener() {
        }

        public ParseErrorMessage getErrorMessage() {
            return this.errorMessage;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            int lineNumber = this.offset + line;
            Token token = (Token)offendingSymbol;
            if (JAVADOC_MISSED_HTML_CLOSE.equals(msg)) {
                this.errorMessage = new ParseErrorMessage(lineNumber, JAVADOC_MISSED_HTML_CLOSE, charPositionInLine, token.getText());
                throw new ParseCancellationException();
            }
            if (JAVADOC_WRONG_SINGLETON_TAG.equals(msg)) {
                this.errorMessage = new ParseErrorMessage(lineNumber, JAVADOC_WRONG_SINGLETON_TAG, charPositionInLine, token.getText());
                throw new ParseCancellationException();
            }
            RuleContext ruleContext = ex.getCtx();
            if (ruleContext != null) {
                int ruleIndex = ex.getCtx().getRuleIndex();
                String ruleName = recognizer.getRuleNames()[ruleIndex];
                String upperCaseRuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ruleName);
                this.errorMessage = new ParseErrorMessage(lineNumber, JAVADOC_PARSE_RULE_ERROR, charPositionInLine, msg, upperCaseRuleName);
            } else {
                this.errorMessage = new ParseErrorMessage(lineNumber, JAVADOC_PARSE_TOKEN_ERROR, charPositionInLine, msg, charPositionInLine);
            }
        }
    }
}

