# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'daemon_controller_guid': '655bd819-c08c-4b04-80c2-f160739ff6ef',
    'rdp_desktop_session_guid': '6a7699f0-ee43-43e7-aa30-a6738f9bd470',
    'remoting_base_sources': [
      'base/auto_thread.cc',
      'base/auto_thread.h',
      'base/auto_thread_task_runner.cc',
      'base/auto_thread_task_runner.h',
      'base/buffered_socket_writer.cc',
      'base/buffered_socket_writer.h',
      'base/capabilities.cc',
      'base/capabilities.h',
      'base/chromium_url_request.cc',
      'base/chromium_url_request.h',
      'base/chromoting_event.cc',
      'base/chromoting_event.h',
      'base/compound_buffer.cc',
      'base/compound_buffer.h',
      'base/constants.cc',
      'base/constants.h',
      'base/rate_counter.cc',
      'base/rate_counter.h',
      'base/rsa_key_pair.cc',
      'base/rsa_key_pair.h',
      'base/running_samples.cc',
      'base/running_samples.h',
      'base/scoped_sc_handle_win.h',
      'base/socket_reader.cc',
      'base/socket_reader.h',
      'base/telemetry_log_writer.cc',
      'base/telemetry_log_writer.h',
      'base/typed_buffer.h',
      'base/url_request.h',
      'base/url_request_context_getter.cc',
      'base/url_request_context_getter.h',
      'base/util.cc',
      'base/util.h',
      'base/vlog_net_log.cc',
      'base/vlog_net_log.h',
    ],
    'remoting_codec_sources': [
      'codec/audio_decoder.cc',
      'codec/audio_decoder.h',
      'codec/audio_decoder_opus.cc',
      'codec/audio_decoder_opus.h',
      'codec/audio_decoder_verbatim.cc',
      'codec/audio_decoder_verbatim.h',
      'codec/audio_encoder.h',
      'codec/audio_encoder_opus.cc',
      'codec/audio_encoder_opus.h',
      'codec/audio_encoder_verbatim.cc',
      'codec/audio_encoder_verbatim.h',
      'codec/scoped_vpx_codec.cc',
      'codec/scoped_vpx_codec.h',
      'codec/video_decoder.h',
      'codec/video_decoder_verbatim.cc',
      'codec/video_decoder_verbatim.h',
      'codec/video_decoder_vpx.cc',
      'codec/video_decoder_vpx.h',
      'codec/video_encoder.h',
      'codec/video_encoder.cc',
      'codec/video_encoder_helper.cc',
      'codec/video_encoder_helper.h',
      'codec/video_encoder_verbatim.cc',
      'codec/video_encoder_verbatim.h',
      'codec/video_encoder_vpx.cc',
      'codec/video_encoder_vpx.h',
      'codec/webrtc_video_encoder_vpx.cc',
      'codec/webrtc_video_encoder_vpx.h',
    ],
    'remoting_protocol_sources': [
      'protocol/audio_reader.cc',
      'protocol/audio_reader.h',
      'protocol/audio_stub.h',
      'protocol/audio_writer.cc',
      'protocol/audio_writer.h',
      'protocol/auth_util.cc',
      'protocol/auth_util.h',
      'protocol/authenticator.cc',
      'protocol/authenticator.h',
      'protocol/capability_names.h',
      'protocol/channel_authenticator.h',
      'protocol/channel_dispatcher_base.cc',
      'protocol/channel_dispatcher_base.h',
      'protocol/channel_multiplexer.cc',
      'protocol/channel_multiplexer.h',
      'protocol/channel_socket_adapter.cc',
      'protocol/channel_socket_adapter.h',
      'protocol/client_authentication_config.cc',
      'protocol/client_authentication_config.h',
      'protocol/client_control_dispatcher.cc',
      'protocol/client_control_dispatcher.h',
      'protocol/client_event_dispatcher.cc',
      'protocol/client_event_dispatcher.h',
      'protocol/client_stub.h',
      'protocol/client_video_dispatcher.cc',
      'protocol/client_video_dispatcher.h',
      'protocol/clipboard_echo_filter.cc',
      'protocol/clipboard_echo_filter.h',
      'protocol/clipboard_filter.cc',
      'protocol/clipboard_filter.h',
      'protocol/clipboard_stub.h',
      'protocol/clipboard_thread_proxy.cc',
      'protocol/clipboard_thread_proxy.h',
      'protocol/connection_to_client.h',
      'protocol/connection_to_host.cc',
      'protocol/connection_to_host.h',
      'protocol/content_description.cc',
      'protocol/content_description.h',
      'protocol/datagram_channel_factory.h',
      'protocol/errors.cc',
      'protocol/errors.h',
      'protocol/frame_consumer.h',
      'protocol/frame_stats.cc',
      'protocol/frame_stats.h',
      'protocol/host_control_dispatcher.cc',
      'protocol/host_control_dispatcher.h',
      'protocol/host_event_dispatcher.cc',
      'protocol/host_event_dispatcher.h',
      'protocol/host_stub.h',
      'protocol/host_video_dispatcher.cc',
      'protocol/host_video_dispatcher.h',
      'protocol/http_ice_config_request.cc',
      'protocol/http_ice_config_request.h',
      'protocol/ice_config.cc',
      'protocol/ice_config.h',
      'protocol/ice_config_request.h',
      'protocol/ice_connection_to_host.cc',
      'protocol/ice_connection_to_host.h',
      'protocol/ice_transport.cc',
      'protocol/ice_transport.h',
      'protocol/ice_transport_channel.cc',
      'protocol/ice_transport_channel.h',
      'protocol/input_event_tracker.cc',
      'protocol/input_event_tracker.h',
      'protocol/input_filter.cc',
      'protocol/input_filter.h',
      'protocol/input_stub.h',
      'protocol/it2me_host_authenticator_factory.cc',
      'protocol/it2me_host_authenticator_factory.h',
      'protocol/jingle_info_request.cc',
      'protocol/jingle_info_request.h',
      'protocol/jingle_messages.cc',
      'protocol/jingle_messages.h',
      'protocol/jingle_session.cc',
      'protocol/jingle_session.h',
      'protocol/jingle_session_manager.cc',
      'protocol/jingle_session_manager.h',
      'protocol/me2me_host_authenticator_factory.cc',
      'protocol/me2me_host_authenticator_factory.h',
      'protocol/message_decoder.cc',
      'protocol/message_decoder.h',
      'protocol/message_pipe.h',
      'protocol/message_reader.cc',
      'protocol/message_reader.h',
      'protocol/message_serialization.cc',
      'protocol/message_serialization.h',
      'protocol/monitored_video_stub.cc',
      'protocol/monitored_video_stub.h',
      'protocol/mouse_input_filter.cc',
      'protocol/mouse_input_filter.h',
      'protocol/name_value_map.h',
      'protocol/negotiating_authenticator_base.cc',
      'protocol/negotiating_authenticator_base.h',
      'protocol/negotiating_client_authenticator.cc',
      'protocol/negotiating_client_authenticator.h',
      'protocol/negotiating_host_authenticator.cc',
      'protocol/negotiating_host_authenticator.h',
      'protocol/network_settings.h',
      'protocol/p2p_datagram_socket.h',
      'protocol/p2p_stream_socket.h',
      'protocol/pairing_authenticator_base.cc',
      'protocol/pairing_authenticator_base.h',
      'protocol/pairing_client_authenticator.cc',
      'protocol/pairing_client_authenticator.h',
      'protocol/pairing_host_authenticator.cc',
      'protocol/pairing_host_authenticator.h',
      'protocol/pairing_registry.cc',
      'protocol/pairing_registry.h',
      'protocol/performance_tracker.cc',
      'protocol/performance_tracker.h',
      'protocol/port_allocator.cc',
      'protocol/port_allocator.h',
      'protocol/port_allocator_factory.h',
      'protocol/port_range.cc',
      'protocol/port_range.h',
      'protocol/pseudotcp_adapter.cc',
      'protocol/pseudotcp_adapter.h',
      'protocol/pseudotcp_channel_factory.cc',
      'protocol/pseudotcp_channel_factory.h',
      'protocol/rejecting_authenticator.cc',
      'protocol/rejecting_authenticator.h',
      'protocol/secure_channel_factory.cc',
      'protocol/secure_channel_factory.h',
      'protocol/session.h',
      'protocol/session_config.cc',
      'protocol/session_config.h',
      'protocol/session_manager.h',
      'protocol/socket_util.cc',
      'protocol/socket_util.h',
      'protocol/spake2_authenticator.cc',
      'protocol/spake2_authenticator.h',
      'protocol/ssl_hmac_channel_authenticator.cc',
      'protocol/ssl_hmac_channel_authenticator.h',
      'protocol/stream_channel_factory.h',
      'protocol/stream_message_pipe_adapter.cc',
      'protocol/stream_message_pipe_adapter.h',
      'protocol/third_party_authenticator_base.cc',
      'protocol/third_party_authenticator_base.h',
      'protocol/third_party_client_authenticator.cc',
      'protocol/third_party_client_authenticator.h',
      'protocol/third_party_host_authenticator.cc',
      'protocol/third_party_host_authenticator.h',
      'protocol/token_validator.h',
      'protocol/transport.cc',
      'protocol/transport.h',
      'protocol/transport_context.cc',
      'protocol/transport_context.h',
      'protocol/v2_authenticator.cc',
      'protocol/v2_authenticator.h',
      'protocol/video_renderer.h',
      'protocol/video_stub.h',
    ],

    # Files in protocol that don't compile for NaCl.
    'remoting_protocol_nonnacl_sources': [
      'protocol/capture_scheduler.cc',
      'protocol/capture_scheduler.h',
      'protocol/chromium_port_allocator_factory.cc',
      'protocol/chromium_port_allocator_factory.h',
      'protocol/chromium_socket_factory.cc',
      'protocol/chromium_socket_factory.h',
      'protocol/ice_connection_to_client.cc',
      'protocol/ice_connection_to_client.h',
      'protocol/video_frame_pump.cc',
      'protocol/video_frame_pump.h',
      'protocol/webrtc_connection_to_client.cc',
      'protocol/webrtc_connection_to_client.h',
      'protocol/webrtc_connection_to_host.cc',
      'protocol/webrtc_connection_to_host.h',
      'protocol/webrtc_data_stream_adapter.cc',
      'protocol/webrtc_data_stream_adapter.h',
      'protocol/webrtc_dummy_video_capturer.cc',
      'protocol/webrtc_dummy_video_capturer.h',
      'protocol/webrtc_video_encoder_factory.cc',
      'protocol/webrtc_video_encoder_factory.h',
      'protocol/webrtc_transport.cc',
      'protocol/webrtc_transport.h',
      'protocol/webrtc_video_stream.cc',
      'protocol/webrtc_video_stream.h',
      'protocol/webrtc_video_renderer_adapter.cc',
      'protocol/webrtc_video_renderer_adapter.h',
    ],

    'remoting_signaling_sources': [
      'signaling/iq_sender.cc',
      'signaling/iq_sender.h',
      'signaling/jid_util.cc',
      'signaling/jid_util.h',
      'signaling/log_to_server.cc',
      'signaling/log_to_server.h',
      'signaling/push_notification_subscriber.cc',
      'signaling/push_notification_subscriber.h',
      'signaling/server_log_entry.cc',
      'signaling/server_log_entry.h',
      'signaling/signal_strategy.h',
      'signaling/xmpp_signal_strategy.cc',
      'signaling/xmpp_signal_strategy.h',
      'signaling/xmpp_stream_parser.cc',
      'signaling/xmpp_stream_parser.h',
      'signaling/xmpp_login_handler.cc',
      'signaling/xmpp_login_handler.h',
    ],

    'remoting_client_sources': [
      'client/audio_consumer.h',
      'client/audio_decode_scheduler.cc',
      'client/audio_decode_scheduler.h',
      'client/audio_player.cc',
      'client/audio_player.h',
      'client/chromoting_client.cc',
      'client/chromoting_client.h',
      'client/client_context.cc',
      'client/client_context.h',
      'client/client_status_logger.cc',
      'client/client_status_logger.h',
      'client/client_telemetry_logger.cc',
      'client/client_telemetry_logger.h',
      'client/client_user_interface.h',
      'client/empty_cursor_filter.cc',
      'client/empty_cursor_filter.h',
      'client/key_event_mapper.cc',
      'client/key_event_mapper.h',
      'client/normalizing_input_filter_cros.cc',
      'client/normalizing_input_filter_cros.h',
      'client/normalizing_input_filter_mac.cc',
      'client/normalizing_input_filter_mac.h',
      'client/normalizing_input_filter_win.cc',
      'client/normalizing_input_filter_win.h',
      'client/server_log_entry_client.cc',
      'client/server_log_entry_client.h',
      'client/software_video_renderer.cc',
      'client/software_video_renderer.h',
      'client/touch_input_scaler.cc',
      'client/touch_input_scaler.h',
    ],

    'remoting_client_standalone_sources': [
      'client/chromoting_client_runtime.cc',
      'client/chromoting_client_runtime.h',
    ],

    'remoting_client_plugin_sources': [
      'client/plugin/chromoting_instance.cc',
      'client/plugin/chromoting_instance.h',
      'client/plugin/delegating_signal_strategy.cc',
      'client/plugin/delegating_signal_strategy.h',
      'client/plugin/pepper_address_resolver.cc',
      'client/plugin/pepper_address_resolver.h',
      'client/plugin/pepper_audio_player.cc',
      'client/plugin/pepper_audio_player.h',
      'client/plugin/pepper_cursor_setter.cc',
      'client/plugin/pepper_cursor_setter.h',
      'client/plugin/pepper_input_handler.cc',
      'client/plugin/pepper_input_handler.h',
      'client/plugin/pepper_module.cc',
      'client/plugin/pepper_mouse_locker.cc',
      'client/plugin/pepper_mouse_locker.h',
      'client/plugin/pepper_network_manager.cc',
      'client/plugin/pepper_network_manager.h',
      'client/plugin/pepper_packet_socket_factory.cc',
      'client/plugin/pepper_packet_socket_factory.h',
      'client/plugin/pepper_main_thread_task_runner.cc',
      'client/plugin/pepper_main_thread_task_runner.h',
      'client/plugin/pepper_port_allocator_factory.cc',
      'client/plugin/pepper_port_allocator_factory.h',
      'client/plugin/pepper_url_request.cc',
      'client/plugin/pepper_url_request.h',
      'client/plugin/pepper_util.cc',
      'client/plugin/pepper_util.h',
      'client/plugin/pepper_video_renderer.h',
      'client/plugin/pepper_video_renderer_2d.cc',
      'client/plugin/pepper_video_renderer_2d.h',
      'client/plugin/pepper_video_renderer_3d.cc',
      'client/plugin/pepper_video_renderer_3d.h',
    ],
  }
}
