// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Generated 2016-07-06T19:18:28Z

#include "components/autofill/core/browser/address_rewriter.h"

namespace autofill {
namespace internal {
namespace {

const Rule kRules_AD[] = {
    {"\\bparroquia\\s+de\\s+andorra\\s+la\\s+vella\\b", "07"},
    {"\\bprincipat\\s+de\\s+andorra\\b", "07"},
    {"\\bprincipal\\s+de\\s+andorra\\b", "07"},
    {"\\bsant\\s+julia\\s+de\\s+loria\\b", "jl"},
    {"\\bescaldes\\s+engordany\\b", "08"},
    {"\\bandorra\\s+la\\s+vella\\b", "07"},
    {"\\bcarrer\\s+del\\b", ""},
    {"\\bla\\s+massana\\b", "04"},
    {"\\bsant\\s+julia\\b", "jl"},
    {"\\bcarrer\\s+de\\b", ""},
    {"\\bandorra\\b", "07"},
    {"\\bcanillo\\b", "02"},
    {"\\bmassana\\b", "04"},
    {"\\bencamp\\b", "03"},
    {"\\bordino\\b", "05"},
    {"\\bc\\s+del\\b", ""},
    {"\\bc\\s+de\\b", ""},
    {"\\ban\\b", "07"},
    {"\\bca\\b", "02"},
    {"\\ben\\b", "03"},
    {"\\bee\\b", "08"},
    {"\\bma\\b", "04"},
    {"\\bor\\b", "05"},
    {"\\b06\\b", "jl"},
    {"\\bad\\b", "07"},
};

const Rule kRules_AR[] = {
    {"\\btierra\\s+del\\s+fuego\\s+antartida\\s+e\\s+islas\\s+del\\s+"
     "atlantico\\s+sur\\b",
     "tierra del fuego"},
    {"\\bciudad\\s+autonoma\\s+de\\s+buenos\\s+aires\\b", "caba"},
    {"\\bla\\s+ciudad\\s+de\\s+buenos\\s+aires\\b", "caba"},
    {"\\bcapital\\s+federal\\b", "caba"},
    {"\\bdiecisiete\\b", "17"},
    {"\\bdiecinueve\\b", "19"},
    {"\\bdieciseis\\b", "16"},
    {"\\bdieciocho\\b", "18"},
    {"\\bboulevard\\b", "bv"},
    {"\\bargentina\\b", "ar"},
    {"\\bprimera\\b", "1a"},
    {"\\bsegunda\\b", "2a"},
    {"\\btercera\\b", "3a"},
    {"\\bseptima\\b", "7a"},
    {"\\bcatorce\\b", "14"},
    {"\\bavenida\\b", "av"},
    {"\\bcuarta\\b", "4a"},
    {"\\bquinta\\b", "5a"},
    {"\\boctava\\b", "8a"},
    {"\\bcuatro\\b", "4"},
    {"\\bquince\\b", "15"},
    {"\\bveinte\\b", "20"},
    {"\\bpasaje\\b", "pje"},
    {"\\bsexta\\b", "6a"},
    {"\\bcinco\\b", "5"},
    {"\\bsiete\\b", "7"},
    {"\\bnueve\\b", "9"},
    {"\\btrece\\b", "13"},
    {"\\btres\\b", "3"},
    {"\\bseis\\b", "6"},
    {"\\bocho\\b", "8"},
    {"\\bdiez\\b", "10"},
    {"\\bonce\\b", "11"},
    {"\\bdoce\\b", "12"},
    {"\\buno\\b", "1"},
    {"\\bdos\\b", "2"},
    {"\\blos\\b", ""},
    {"\\blas\\b", ""},
    {"\\bdel\\b", ""},
    {"\\ble\\b", ""},
    {"\\bel\\b", ""},
    {"\\bde\\b", ""},
};

const Rule kRules_AU[] = {
    {"\\baustralian\\s+capital\\s+territory\\b", "act"},
    {"\\bjervis\\s+bay\\s+territory\\b", "jbt"},
    {"\\bnorthern\\s+territory\\b", "nt"},
    {"\\bwestern\\s+australia\\b", "wa"},
    {"\\bnew\\s+south\\s+wales\\b", "nsw"},
    {"\\bsouth\\s+australia\\b", "sa"},
    {"\\bqueensland\\b", "qld"},
    {"\\bboulevard\\b", "blvd"},
    {"\\baustralia\\b", "au"},
    {"\\bcrescent\\b", "cres"},
    {"\\bvictoria\\b", "vic"},
    {"\\btasmania\\b", "tas"},
    {"\\bparkway\\b", "pkwy"},
    {"\\bhighway\\b", "hwy"},
    {"\\bavenue\\b", "ave"},
    {"\\bstreet\\b", "st"},
    {"\\bparade\\b", "pde"},
    {"\\bcommon\\b", "comm"},
    {"\\bau\\-vic\\b", "vic"},
    {"\\ba\\.c\\.t\\.\\b", "act"},
    {"\\bau\\-act\\b", "act"},
    {"\\bj\\.b\\.t\\.\\b", "jbt"},
    {"\\bau\\-jbt\\b", "jbt"},
    {"\\bn\\.s\\.w\\.\\b", "nsw"},
    {"\\bau\\-nsw\\b", "nsw"},
    {"\\bau\\-qld\\b", "qld"},
    {"\\bau\\-tas\\b", "tas"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bthree\\b", "3"},
    {"\\bseven\\b", "7"},
    {"\\beight\\b", "8"},
    {"\\bmount\\b", "mt"},
    {"\\bsaint\\b", "st"},
    {"\\bpoint\\b", "pt"},
    {"\\bcourt\\b", "ct"},
    {"\\bplace\\b", "pl"},
    {"\\bdrive\\b", "dr"},
    {"\\ba\\.c\\.t\\b", "act"},
    {"\\bj\\.b\\.t\\b", "jbt"},
    {"\\bn\\.s\\.w\\b", "nsw"},
    {"\\bau\\-nt\\b", "nt"},
    {"\\bau\\-wa\\b", "wa"},
    {"\\bau\\-sa\\b", "sa"},
    {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},
    {"\\bfour\\b", "4"},
    {"\\bfive\\b", "5"},
    {"\\bnine\\b", "9"},
    {"\\broad\\b", "rd"},
    {"\\blane\\b", "ln"},
    {"\\bn\\.t\\.\\b", "nt"},
    {"\\bw\\.a\\.\\b", "wa"},
    {"\\bs\\.a\\.\\b", "sa"},
    {"\\bnth\\b", "n"},
    {"\\bsth\\b", "s"},
    {"\\bone\\b", "1"},
    {"\\btwo\\b", "2"},
    {"\\bsix\\b", "6"},
    {"\\bten\\b", "10"},
    {"\\bmt\\.\\b", "mt"},
    {"\\bst\\.\\b", "st"},
    {"\\bpt\\.\\b", "pt"},
    {"\\bn\\.t\\b", "nt"},
    {"\\bw\\.a\\b", "wa"},
    {"\\bs\\.a\\b", "sa"},
    {"\\baus\\b", "au"},
    {"\\bn\\.\\b", "n"},
    {"\\bs\\.\\b", "s"},
    {"\\be\\.\\b", "e"},
    {"\\bw\\.\\b", "w"},
};

const Rule kRules_BE[] = {
    {"\\barrondissement\\s+administratif\\s+de\\b", ""},
    {"\\barrondissement\\s+administratif\\s+d\\b", ""},
    {"\\bbrussels\\s+hoofdstedelijk\\s+gewest\\b", "brussel"},
    {"\\bbrussel\\s+hoofdstedelijk\\s+gewest\\b", "brussel"},
    {"\\bregion\\s+de\\s+bruxelles\\s+capitale\\b", "brussel"},
    {"\\bseptieme\\s+division\\s+francaise\\b", "7eme division frcse"},
    {"\\bonze\\s+lieve\\s+heersebeestjes\\b", "onze lieve heersbeestjes"},
    {"\\bregion\\s+brussel\\s+hauptstadt\\b", "brussel"},
    {"\\balbert\\s+en\\s+marie\\s+louise\\b", "a & m l"},
    {"\\balbert\\s+et\\s+marie\\s+louise\\b", "a & m l"},
    {"\\bandree\\s+payfa\\s+fosseprez\\b", "a payfa fosseprez"},
    {"\\bseptieme\\s+d\\s+i\\s+francaise\\b", "7eme division frcse"},
    {"\\bwereldtentoonstellings\\b", "wereldtentoonstelings"},
    {"\\bberchem\\s+sainte\\s+agathe\\b", "st agatha berchem"},
    {"\\bsaint\\s+josse\\s+ten\\s+noode\\b", "saint josse"},
    {"\\bflandres\\s+occidentales\\b", "westflandern"},
    {"\\bhenri\\s+victor\\s+wolvens\\b", "h v wolvens"},
    {"\\bjoseph\\s+van\\s+boterdael\\b", "joseph van boterdae"},
    {"\\bmarilyn\\s+monroegaarde\\b", "marilyn monroe"},
    {"\\bflandre\\s+occidentales\\b", "westflandern"},
    {"\\bflandres\\s+occidentale\\b", "westflandern"},
    {"\\bwoluwe\\s+saint\\s+pierre\\b", "st pieters woluwe"},
    {"\\bflandres\\s+orientales\\b", "ostflandern"},
    {"\\bflandre\\s+occidentale\\b", "westflandern"},
    {"\\bhendrik\\s+conscience\\b", "henri conscience"},
    {"\\bleonoardo\\s+da\\s+vinci\\b", "leonard de vinci"},
    {"\\bbruxelles\\s+capitale\\b", "brussel"},
    {"\\bwallonische\\s+region\\b", "wallonie"},
    {"\\bflandre\\s+orientales\\b", "ostflandern"},
    {"\\bflandres\\s+orientale\\b", "ostflandern"},
    {"\\bwallonisch\\s+brabant\\b", "waals brabant"},
    {"\\bbischoffsheimlaan\\b", "bischoffsheim"},
    {"\\bbrouck\\s+du\\s+tilleul\\b", "brouck au tilleul"},
    {"\\bleonardo\\s+da\\s+vinci\\b", "leonard de vinci"},
    {"\\bflandre\\s+orientale\\b", "ostflandern"},
    {"\\barmand\\s+scheitler\\b", "armand scheiter"},
    {"\\bhenri\\s+wafelaerts\\b", "henri wafelaert"},
    {"\\bpierre\\s+hauwaerts\\b", "pieter hauwaerts"},
    {"\\brennequin\\s+sualem\\b", "renkin sualem"},
    {"\\bregion\\s+wallonien\\b", "wallonie"},
    {"\\bflamische\\s+region\\b", "vlaams gewest"},
    {"\\bflamisch\\s+brabant\\b", "vlaams brabant"},
    {"\\baugust\\s+de\\s+boeck\\b", "a de boeck"},
    {"\\bgodefroid\\s+kurth\\b", "godfroid kurth"},
    {"\\bbruxelles\\s+ville\\b", "brussel"},
    {"\\bregion\\s+wallonne\\b", "wallonie"},
    {"\\bregion\\s+flamande\\b", "vlaams gewest"},
    {"\\bflamisch\\s+region\\b", "vlaams gewest"},
    {"\\bbrabant\\s+flamand\\b", "vlaams brabant"},
    {"\\boost\\s+vlaanderen\\b", "ostflandern"},
    {"\\bwest\\s+vlaanderen\\b", "westflandern"},
    {"\\blimburg\\s+stirum\\b", "limburg strium"},
    {"\\barrondissement\\b", ""},
    {"\\bbrabant\\s+wallon\\b", "waals brabant"},
    {"\\bmichel\\s+angelo\\b", "michel ange"},
    {"\\bpater\\s+damiaan\\b", "pater damian"},
    {"\\bsualem\\s+renkin\\b", "renkin sualem"},
    {"\\bde\\s+ribaucourt\\b", "ribaucourt"},
    {"\\bprofondeville\\b", "profondville"},
    {"\\bsint\\s+lenaarts\\b", "sint lenaerts"},
    {"\\bdendermondse\\b", "dendermonde"},
    {"\\bminnezangers\\b", "menestrelen"},
    {"\\bvooruitgangs\\b", "vooruitgang"},
    {"\\bwaals\\s+gewest\\b", "wallonie"},
    {"\\bjette\\s+jetse\\b", "jette"},
    {"\\bi\\s+urbanisme\\b", "l urbanisme"},
    {"\\bpuits\\s+no\\s+iv\\b", "puits n4"},
    {"\\bterhulpense\\b", "terhulpse"},
    {"\\bcortenbergh\\b", "cortenberg"},
    {"\\bprovince\\s+de\\b", ""},
    {"\\bprovince\\s+du\\b", ""},
    {"\\blanguesdoc\\b", "languedoc"},
    {"\\bpuit\\s+no\\s+iv\\b", "puits n4"},
    {"\\bvan\\s+volxem\\b", "volxem"},
    {"\\bprovince\\s+d\\b", ""},
    {"\\bhenegouwen\\b", "hainaut"},
    {"\\bluxembourg\\b", "luxemburg"},
    {"\\bboulevard\\b", "bd"},
    {"\\bluitenant\\b", "liutenant"},
    {"\\bwestphael\\b", "wesphal"},
    {"\\bbruxelles\\b", "brussel"},
    {"\\bwallonien\\b", "wallonie"},
    {"\\bantwerpen\\b", "anvers"},
    {"\\bchaussee\\b", "chee"},
    {"\\bsteenweg\\b", "stwg"},
    {"\\bterrasse\\b", "tsse"},
    {"\\bwestphal\\b", "wesphal"},
    {"\\bbrussels\\b", "brussel"},
    {"\\blimbourg\\b", "limburg"},
    {"\\bhennegau\\b", "hainaut"},
    {"\\bbelgique\\b", "be"},
    {"\\bavenues\\b", "av"},
    {"\\bimpasse\\b", "imp"},
    {"\\bstrasse\\b", "str"},
    {"\\bjettese\\b", "jetse"},
    {"\\bde\\s+wand\\b", "wand"},
    {"\\bprovinz\\b", ""},
    {"\\bluttich\\b", "luik"},
    {"\\bbelgium\\b", "be"},
    {"\\bbelgien\\b", "be"},
    {"\\bsainte\\b", "st"},
    {"\\ballees\\b", "all"},
    {"\\bavenue\\b", "av"},
    {"\\bcentre\\b", "ctre"},
    {"\\bsquare\\b", "sq"},
    {"\\bstraat\\b", "str"},
    {"\\bbelgie\\b", "be"},
    {"\\bsaint\\b", "st"},
    {"\\bsankt\\b", "st"},
    {"\\ballee\\b", "all"},
    {"\\bplace\\b", "pl"},
    {"\\bplatz\\b", "pl"},
    {"\\bplein\\b", "pl"},
    {"\\bpiein\\b", "pl"},
    {"\\broute\\b", "rte"},
    {"\\bthier\\b", "their"},
    {"\\bnamur\\b", "namen"},
    {"\\bliege\\b", "luik"},
    {"\\bsint\\b", "st"},
    {"\\bste\\b", "st"},
    {"\\bdes\\b", "d"},
    {"\\brue\\b", "r"},
    {"\\bde\\b", "d"},
    {"\\bdu\\b", "d"},
};

const Rule kRules_BR[] = {
    {"\\brio\\s+grande\\s+do\\s+norte\\b", "rn"},
    {"\\bmato\\s+grosso\\s+do\\s+sul\\b", "ms"},
    {"\\brio\\s+grande\\s+do\\s+sul\\b", "rs"},
    {"\\bdistrito\\s+federal\\b", "df"},
    {"\\bdecimo\\s+primeiro\\b", "11"},
    {"\\bdecimo\\s+terceiro\\b", "13"},
    {"\\bvinte\\s+e\\s+quatro\\b", "24"},
    {"\\bespirito\\s+santo\\b", "es"},
    {"\\brio\\s+de\\s+janeiro\\b", "rj"},
    {"\\bsanta\\s+catarina\\b", "sc"},
    {"\\bdecimo\\s+quarto\\b", "14"},
    {"\\bdecimo\\s+quinto\\b", "15"},
    {"\\bdecimo\\s+setimo\\b", "17"},
    {"\\bdecimo\\s+oitavo\\b", "18"},
    {"\\bvinte\\s+e\\s+cinco\\b", "25"},
    {"\\bdecimo\\s+sexto\\b", "16"},
    {"\\bvinte\\s+e\\s+dois\\b", "22"},
    {"\\bvinte\\s+e\\s+tres\\b", "23"},
    {"\\bvinte\\s+e\\s+seis\\b", "26"},
    {"\\bvinte\\s+e\\s+sete\\b", "27"},
    {"\\bvinte\\s+e\\s+oito\\b", "28"},
    {"\\bvinte\\s+e\\s+nove\\b", "29"},
    {"\\bminas\\s+gerais\\b", "mg"},
    {"\\bdecimo\\s+nono\\b", "19"},
    {"\\bmato\\s+grosso\\b", "mt"},
    {"\\bvinte\\s+e\\s+um\\b", "21"},
    {"\\bgovernador\\b", "gov"},
    {"\\bpresidente\\b", "pres"},
    {"\\bcomandante\\b", "com"},
    {"\\bpernambuco\\b", "pe"},
    {"\\bduodecimo\\b", "12"},
    {"\\bdezesseis\\b", "16"},
    {"\\bdezessete\\b", "17"},
    {"\\bcinquenta\\b", "50"},
    {"\\brepublica\\b", "rep"},
    {"\\bprofessor\\b", "prof"},
    {"\\bsao\\s+paulo\\b", "sp"},
    {"\\btocantins\\b", "to"},
    {"\\bprimeiro\\b", "i"},
    {"\\bterceiro\\b", "3"},
    {"\\bdezenove\\b", "19"},
    {"\\bvigesimo\\b", "20"},
    {"\\bquarenta\\b", "40"},
    {"\\bsessenta\\b", "60"},
    {"\\bprincesa\\b", "prsa"},
    {"\\bsargento\\b", "sct"},
    {"\\bamazonas\\b", "am"},
    {"\\bmaranhao\\b", "ma"},
    {"\\brondonia\\b", "ro"},
    {"\\bsegundo\\b", "2"},
    {"\\bcatorze\\b", "14"},
    {"\\bdezoito\\b", "18"},
    {"\\bsetenta\\b", "70"},
    {"\\boitenta\\b", "80"},
    {"\\bnoventa\\b", "90"},
    {"\\bsenador\\b", "sen"},
    {"\\bcoronel\\b", "cel"},
    {"\\bavenida\\b", "av"},
    {"\\bestrada\\b", "estr"},
    {"\\balameda\\b", "al"},
    {"\\balagoas\\b", "al"},
    {"\\bparaiba\\b", "pb"},
    {"\\broraima\\b", "rr"},
    {"\\bsergipe\\b", "se"},
    {"\\bquarto\\b", "4"},
    {"\\bquatro\\b", "4"},
    {"\\bquinto\\b", "5"},
    {"\\bsetimo\\b", "7"},
    {"\\boitavo\\b", "8"},
    {"\\bdecimo\\b", "x"},
    {"\\bquinze\\b", "15"},
    {"\\btrinta\\b", "30"},
    {"\\bprincs\\b", "prsa"},
    {"\\bdoutor\\b", "dr"},
    {"\\bparana\\b", "pr"},
    {"\\bbrazil\\b", "b"},
    {"\\bbrasil\\b", "b"},
    {"\\bnorte\\b", "n"},
    {"\\boeste\\b", "w"},
    {"\\bcinco\\b", "5"},
    {"\\bsexto\\b", "6"},
    {"\\btreze\\b", "13"},
    {"\\bvinte\\b", "20"},
    {"\\bbarao\\b", "b"},
    {"\\bduque\\b", "dq"},
    {"\\bsanta\\b", "sta"},
    {"\\bconde\\b", "cde"},
    {"\\bpadre\\b", "pe"},
    {"\\bviela\\b", "vl"},
    {"\\bamapa\\b", "ap"},
    {"\\bbahia\\b", "ba"},
    {"\\bceara\\b", "ce"},
    {"\\bgoias\\b", "go"},
    {"\\bpiaui\\b", "pi"},
    {"\\beste\\b", "e"},
    {"\\bviii\\b", "8"},
    {"\\bdois\\b", "2"},
    {"\\btres\\b", "3"},
    {"\\bseis\\b", "6"},
    {"\\bsete\\b", "7"},
    {"\\boito\\b", "8"},
    {"\\bnono\\b", "9"},
    {"\\bnove\\b", "9"},
    {"\\bonze\\b", "11"},
    {"\\bdoze\\b", "12"},
    {"\\bacre\\b", "ac"},
    {"\\bbaia\\b", "ba"},
    {"\\bpara\\b", "pa"},
    {"\\bsala\\b", "s"},
    {"\\blote\\b", "lt"},
    {"\\bsul\\b", "s"},
    {"\\biii\\b", "3"},
    {"\\bvii\\b", "7"},
    {"\\bdez\\b", "x"},
    {"\\bcem\\b", "100"},
    {"\\bsan\\b", "s"},
    {"\\bsgt\\b", "sct"},
    {"\\bdos\\b", ""},
    {"\\bdas\\b", ""},
    {"\\brua\\b", "r"},
    {"\\bii\\b", "2"},
    {"\\biv\\b", "4"},
    {"\\bvi\\b", "6"},
    {"\\bix\\b", "9"},
    {"\\b10\\b", "x"},
    {"\\bum\\b", "i"},
    {"\\bbr\\b", "b"},
    {"\\bdo\\b", ""},
    {"\\bde\\b", ""},
    {"\\bda\\b", ""},
    {"\\bel\\b", ""},
    {"\\bve\\b", "vl"},
    {"\\bsl\\b", "s"},
    {"\\b1\\b", "i"},
    {"\\bv\\b", "5"},
};

const Rule kRules_CA[] = {
    {"\\bdsl\\s+de\\s+grand\\s+sault\\s+falls\\s+grand\\s+sault\\s+grand\\s+"
     "falls\\b",
     "grand falls"},
    {"\\bsainte\\s+catherine\\s+de\\s+la\\s+jacques\\s+cartier\\b",
     "ste catherine de la j cartier"},
    {"\\bmadawaska\\s+maliseet\\s+frst\\s+nation\\b", "madawaska"},
    {"\\bregional\\s+county\\s+municipality\\b", ""},
    {"\\bshediac\\s+bridge\\s+shediac\\s+river\\b", "shediac bridge"},
    {"\\bnewfoundland\\s+and\\s+labrador\\b", "nl"},
    {"\\bterritoires\\s+du\\s+nord\\s+ouest\\b", "nt"},
    {"\\bregional\\s+municipality\\s+of\\b", ""},
    {"\\bdsl\\s+de\\s+grand\\s+sault\\s+falls\\b", "grand falls"},
    {"\\bgrand\\s+sault\\s+grand\\s+falls\\b", "grand falls"},
    {"\\bterre\\s+neuve\\s+et\\s+labrador\\b", "nl"},
    {"\\bbay\\s+de\\s+verde\\s+peninsula\\b", "bvd"},
    {"\\bregional\\s+municipality\\b", ""},
    {"\\bnorthwest\\s+territories\\b", "nt"},
    {"\\bile\\s+du\\s+prince\\s+edouard\\b", "pe"},
    {"\\bregional\\s+district\\s+of\\b", ""},
    {"\\bcolombie\\s+britannique\\b", "bc"},
    {"\\bprince\\s+edward\\s+island\\b", "pe"},
    {"\\bhead\\s+of\\s+bay\\s+despoir\\b", "head bay d\'espoir"},
    {"\\bfrench\\s+village\\s+york\\b", "french village"},
    {"\\bterritoire\\s+du\\s+yukon\\b", "yt"},
    {"\\bregional\\s+district\\b", ""},
    {"\\bnouveau\\s+brunswick\\b", "nb"},
    {"\\bcanton\\s+stanstead\\b", "stanstead"},
    {"\\bmd\\s+of\\s+bonnyville\\b", "bonnyville"},
    {"\\bbritish\\s+columbia\\b", "bc"},
    {"\\bst\\s+george\\s+brant\\b", "saint george"},
    {"\\bnouvelle\\s+ecosse\\b", "ns"},
    {"\\byukon\\s+territory\\b", "yt"},
    {"\\bsackville\\s+road\\b", "sackville"},
    {"\\bchisholm\\s+mills\\b", "chisholm"},
    {"\\bnational\\s+park\\b", ""},
    {"\\bplacentia\\s+bay\\b", "pb"},
    {"\\bnew\\s+brunswick\\b", "nb"},
    {"\\bmetropolitan\\b", ""},
    {"\\bbeaver\\s+brook\\b", "beaverbrook"},
    {"\\brichibouctou\\b", "richibucto"},
    {"\\bnewfoundland\\b", "nl"},
    {"\\bsaskatchewan\\b", "sk"},
    {"\\bsubdivision\\b", "subdiv"},
    {"\\btownship\\s+of\\b", ""},
    {"\\btrinity\\s+bay\\b", "tb"},
    {"\\bfortune\\s+bay\\b", "fb"},
    {"\\bsutton\\s+west\\b", "sutton"},
    {"\\bterre\\s+neuve\\b", "nl"},
    {"\\bnova\\s+scotia\\b", "ns"},
    {"\\bconcession\\b", "conc"},
    {"\\bcul\\-de\\-sac\\b", "cds"},
    {"\\bcul\\s+de\\s+sac\\b", "cds"},
    {"\\bexpressway\\b", "expy"},
    {"\\brond\\-point\\b", "rdpt"},
    {"\\brond\\s+point\\b", "rdpt"},
    {"\\bnorth\\s+side\\b", "northside"},
    {"\\bbelliveaus\\b", "belliveau"},
    {"\\bmackinnons\\b", "mckinnons"},
    {"\\bpine\\s+ridge\\b", "pineridge"},
    {"\\bde\\s+riviere\\b", "riviere"},
    {"\\balternate\\b", "alt"},
    {"\\bautoroute\\b", "aut"},
    {"\\bcarrefour\\b", "carref"},
    {"\\bcroissant\\b", "crois"},
    {"\\bdiversion\\b", "divers"},
    {"\\bechangeur\\b", "ech"},
    {"\\besplanade\\b", "espl"},
    {"\\bextension\\b", "exten"},
    {"\\bhighlands\\b", "hghlds"},
    {"\\bpromenade\\b", "prom"},
    {"\\bturnabout\\b", "trnabt"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bcounty\\s+of\\b", ""},
    {"\\bhalf\\s+moon\\b", "halfmoon"},
    {"\\bkuskanook\\b", "kuskonook"},
    {"\\bbusiness\\b", "bus"},
    {"\\bcrescent\\b", "cres"},
    {"\\bcrossing\\b", "cross"},
    {"\\bmountain\\b", "mtn"},
    {"\\bterrasse\\b", "tsse"},
    {"\\btownline\\b", "tline"},
    {"\\bjunction\\b", ""},
    {"\\btownship\\b", ""},
    {"\\boak\\s+hill\\b", "oakhill"},
    {"\\bpleasent\\b", "pleasant"},
    {"\\bmanitoba\\b", "mb"},
    {"\\bhighway\\b", "hwy"},
    {"\\bby\\s+pass\\b", "bypass"},
    {"\\bcircuit\\b", "circt"},
    {"\\bcorners\\b", "crnrs"},
    {"\\bestates\\b", "estate"},
    {"\\bfreeway\\b", "fwy"},
    {"\\bgardens\\b", "gdns"},
    {"\\bgrounds\\b", "grnds"},
    {"\\bharbour\\b", "harbr"},
    {"\\bheights\\b", "hts"},
    {"\\bimpasse\\b", "imp"},
    {"\\blanding\\b", "landng"},
    {"\\blookout\\b", "lkout"},
    {"\\borchard\\b", "orch"},
    {"\\bparkway\\b", "pky"},
    {"\\bpassage\\b", "pass"},
    {"\\bpathway\\b", "ptway"},
    {"\\bplateau\\b", "plat"},
    {"\\bterrace\\b", "terr"},
    {"\\bthicket\\b", "thick"},
    {"\\bvillage\\b", ""},
    {"\\bsentier\\b", "sent"},
    {"\\bcity\\s+of\\b", ""},
    {"\\btown\\s+of\\b", ""},
    {"\\bstation\\b", ""},
    {"\\breserve\\b", ""},
    {"\\bnarrows\\b", ""},
    {"\\bl\'islet\\b", ""},
    {"\\bkeenans\\b", "keenan"},
    {"\\bla\\s+have\\b", "lahave"},
    {"\\bherbert\\b", "hebert"},
    {"\\balberta\\b", "ab"},
    {"\\bnunavut\\b", "nu"},
    {"\\bontario\\b", "on"},
    {"\\bsainte\\b", ""},
    {"\\bl\'isle\\b", "isle"},
    {"\\bavenue\\b", "av"},
    {"\\bcentre\\b", ""},
    {"\\bcenter\\b", ""},
    {"\\bcircle\\b", "cir"},
    {"\\bharbor\\b", "harbr"},
    {"\\bisland\\b", ""},
    {"\\blimits\\b", "lmts"},
    {"\\bpointe\\b", "pte"},
    {"\\bruelle\\b", "rle"},
    {"\\bsquare\\b", "sq"},
    {"\\bstreet\\b", ""},
    {"\\bchemin\\b", "ch"},
    {"\\bcanton\\b", ""},
    {"\\bsiding\\b", ""},
    {"\\bvalley\\b", ""},
    {"\\bcounty\\b", ""},
    {"\\bsmiths\\b", "smith"},
    {"\\bbakers\\b", "baker"},
    {"\\bmackay\\b", "mckay"},
    {"\\bmcgrey\\b", "mcgray"},
    {"\\bquebec\\b", "qc"},
    {"\\bcanada\\b", "ca"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bouest\\b", "o"},
    {"\\bsaint\\b", ""},
    {"\\bmount\\b", "mt"},
    {"\\bpoint\\b", "pt"},
    {"\\bcarre\\b", "car"},
    {"\\bclose\\b", "cl"},
    {"\\bcourt\\b", "crt"},
    {"\\bdrive\\b", "dr"},
    {"\\bgrove\\b", "grv"},
    {"\\bplace\\b", "pl"},
    {"\\brange\\b", "rg"},
    {"\\broute\\b", "rt"},
    {"\\btrail\\b", "trl"},
    {"\\bmetro\\b", ""},
    {"\\bforks\\b", ""},
    {"\\bmanns\\b", "mann"},
    {"\\bfirst\\b", "fst"},
    {"\\byukon\\b", "yt"},
    {"\\bnord\\b", "n"},
    {"\\beast\\b", ""},
    {"\\bwest\\b", "o"},
    {"\\bcove\\b", ""},
    {"\\blane\\b", "ln"},
    {"\\bpark\\b", ""},
    {"\\bpkwy\\b", "pky"},
    {"\\broad\\b", ""},
    {"\\bboul\\b", "blvd"},
    {"\\bcity\\b", ""},
    {"\\blake\\b", ""},
    {"\\bfrst\\b", "fst"},
    {"\\bnth\\b", "n"},
    {"\\bsth\\b", "s"},
    {"\\bsud\\b", "s"},
    {"\\best\\b", ""},
    {"\\bere\\b", ""},
    {"\\bste\\b", ""},
    {"\\bave\\b", "av"},
    {"\\bbay\\b", ""},
    {"\\bctr\\b", ""},
    {"\\bile\\b", ""},
    {"\\brte\\b", "rt"},
    {"\\bdes\\b", ""},
    {"\\bcbd\\b", ""},
    {"\\bsal\\b", ""},
    {"\\bblp\\b", ""},
    {"\\bbdv\\b", ""},
    {"\\blab\\b", ""},
    {"\\bndb\\b", ""},
    {"\\bsmb\\b", ""},
    {"\\bont\\b", "on"},
    {"\\bpei\\b", "pe"},
    {"\\bcan\\b", "ca"},
    {"\\bst\\b", ""},
    {"\\bnd\\b", ""},
    {"\\brd\\b", ""},
    {"\\bth\\b", ""},
    {"\\ber\\b", ""},
    {"\\bre\\b", ""},
    {"\\bpk\\b", ""},
    {"\\bd\'\\b", ""},
    {"\\bde\\b", ""},
    {"\\bdu\\b", ""},
    {"\\bcb\\b", ""},
    {"\\bbb\\b", ""},
    {"\\bco\\b", ""},
    {"\\bfn\\b", ""},
    {"\\bgb\\b", ""},
    {"\\bwb\\b", ""},
    {"\\be\\b", ""},
    {"\\bw\\b", "o"},
    {"\\bc\\b", ""},
    {"\\bd\\b", ""},
};

const Rule kRules_CH[] = {
    {"\\bappenzell\\s+rhodes\\s+exterieures\\b", "ar"},
    {"\\bappenzell\\s+ausserrhoden\\b", "ar"},
    {"\\bappenzell\\s+innerrhoden\\b", "ai"},
    {"\\bjura\\s+north\\s+vaudois\\b", "jura nord vaudois"},
    {"\\bprettigovia\\s+davos\\b", "davos"},
    {"\\bbasel\\s+landschaft\\b", "bl"},
    {"\\bsankt\\s+silvester\\b", "st silvester"},
    {"\\bprattigau\\s+davos\\b", "davos"},
    {"\\bsankt\\s+stephan\\b", "st stephan"},
    {"\\bbale\\s+campagne\\b", "bl"},
    {"\\bbasilea\\s+citta\\b", "bs"},
    {"\\bwallis\\s+valais\\b", "vs"},
    {"\\bdix\\s+septieme\\b", "17"},
    {"\\bdix\\s+huitieme\\b", "18"},
    {"\\bdix\\s+neuvieme\\b", "19"},
    {"\\bsankt\\s+gallen\\b", "sg"},
    {"\\bsaint\\s+gallen\\b", "sg"},
    {"\\bschaffhausen\\b", "sh"},
    {"\\bquatorzieme\\b", "14"},
    {"\\bwinterthour\\b", "winterthur"},
    {"\\bsan\\s+nazzaro\\b", "s nazzaro"},
    {"\\bsan\\s+vittore\\b", "s vittore"},
    {"\\bbelinzonese\\b", "bellinzone"},
    {"\\bsankt\\s+gallo\\b", "sg"},
    {"\\bsaint\\s+gallo\\b", "sg"},
    {"\\bbasel\\s+stadt\\b", "bs"},
    {"\\bschaffhouse\\b", "sh"},
    {"\\bswitzerland\\b", "ch"},
    {"\\benclave\\s+de\\b", ""},
    {"\\bbellinzona\\b", "bellinzone"},
    {"\\bsankt\\s+gall\\b", "sg"},
    {"\\bst\\.\\s+gallen\\b", "sg"},
    {"\\bsaint\\s+gall\\b", "sg"},
    {"\\bsan\\s+gallen\\b", "sg"},
    {"\\bbasel\\s+land\\b", "bl"},
    {"\\bbale\\s+ville\\b", "bs"},
    {"\\bbasel\\s+stad\\b", "bs"},
    {"\\bbasel\\s+city\\b", "bs"},
    {"\\bbazel\\s+stad\\b", "bs"},
    {"\\bgraubunden\\b", "gr"},
    {"\\bwaadt\\s+vaud\\b", "vd"},
    {"\\bvaud\\s+waadt\\b", "vd"},
    {"\\btroisieme\\b", "3"},
    {"\\bquatrieme\\b", "4"},
    {"\\bcinquieme\\b", "5"},
    {"\\btreizieme\\b", "13"},
    {"\\bquinzieme\\b", "xv"},
    {"\\bvingtieme\\b", "xx"},
    {"\\blaufental\\b", "laufon"},
    {"\\bst\\s+gallen\\b", "sg"},
    {"\\bst\\.\\s+gallo\\b", "sg"},
    {"\\bsan\\s+gallo\\b", "sg"},
    {"\\bneuenburg\\b", "ne"},
    {"\\bneuchatel\\b", "ne"},
    {"\\bnidwalden\\b", "nw"},
    {"\\bsciaffusa\\b", "sh"},
    {"\\bsolothurn\\b", "so"},
    {"\\bthurgovie\\b", "tg"},
    {"\\bthurgovia\\b", "tg"},
    {"\\bpremiere\\b", "i"},
    {"\\bdeuxieme\\b", "2"},
    {"\\bseptieme\\b", "7"},
    {"\\bhuitieme\\b", "8"},
    {"\\bneuvieme\\b", "9"},
    {"\\bdouzieme\\b", "12"},
    {"\\bseizieme\\b", "16"},
    {"\\bmaloggia\\b", "maloja"},
    {"\\bgessenay\\b", "saanen"},
    {"\\bst\\s+gallo\\b", "sg"},
    {"\\bst\\.\\s+gall\\b", "sg"},
    {"\\bsan\\s+gall\\b", "sg"},
    {"\\bd\\\\\'uster\\b", "uster"},
    {"\\bzofingen\\b", "zofingue"},
    {"\\bfreiburg\\b", "fr"},
    {"\\bfribourg\\b", "fr"},
    {"\\bfriburgo\\b", "fr"},
    {"\\bgrigioni\\b", "gr"},
    {"\\bnidvaldo\\b", "nw"},
    {"\\bobwalden\\b", "ow"},
    {"\\bturgovia\\b", "tg"},
    {"\\bsixieme\\b", "6"},
    {"\\bdixieme\\b", "x"},
    {"\\bonzieme\\b", "xi"},
    {"\\bzuerich\\b", "zh"},
    {"\\bturicum\\b", "zh"},
    {"\\blucerne\\b", "lu"},
    {"\\bst\\s+gall\\b", "sg"},
    {"\\bargovia\\b", "ag"},
    {"\\bargovie\\b", "ag"},
    {"\\bfriburg\\b", "fr"},
    {"\\bginevra\\b", "ge"},
    {"\\bglarona\\b", "gl"},
    {"\\bgrisons\\b", "gr"},
    {"\\blucerna\\b", "lu"},
    {"\\bnidwald\\b", "nw"},
    {"\\bobvaldo\\b", "ow"},
    {"\\bsoleure\\b", "so"},
    {"\\bsoletta\\b", "so"},
    {"\\bschwytz\\b", "sz"},
    {"\\bthurgau\\b", "tg"},
    {"\\bvallese\\b", "vs"},
    {"\\bvallais\\b", "vs"},
    {"\\bschweiz\\b", "ch"},
    {"\\bsainte\\b", ""},
    {"\\bregion\\b", ""},
    {"\\bzurich\\b", "zh"},
    {"\\bbienne\\b", "biel"},
    {"\\bbienna\\b", "biel"},
    {"\\bbrigue\\b", "brig"},
    {"\\blaufen\\b", "laufon"},
    {"\\bthoune\\b", "thun"},
    {"\\bzurigo\\b", "zh"},
    {"\\baargau\\b", "ag"},
    {"\\bgeneve\\b", "ge"},
    {"\\bgeneva\\b", "ge"},
    {"\\bglarus\\b", "gl"},
    {"\\bglaris\\b", "gl"},
    {"\\bluzern\\b", "lu"},
    {"\\bobwald\\b", "ow"},
    {"\\bschwyz\\b", "sz"},
    {"\\bsvitto\\b", "sz"},
    {"\\btessin\\b", "ti"},
    {"\\bticino\\b", "ti"},
    {"\\bwallis\\b", "vs"},
    {"\\bvalais\\b", "vs"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bouest\\b", "o"},
    {"\\bsaint\\b", ""},
    {"\\bmount\\b", "mt"},
    {"\\bxviii\\b", "18"},
    {"\\bde\\s+la\\b", ""},
    {"\\bde\\s+l\'\\b", ""},
    {"\\bet\\s+du\\b", ""},
    {"\\bstadt\\b", ""},
    {"\\baaray\\b", "aarau"},
    {"\\bberna\\b", "be"},
    {"\\bberne\\b", "be"},
    {"\\bbriga\\b", "brig"},
    {"\\bviege\\b", "visp"},
    {"\\bgiura\\b", "ju"},
    {"\\bwaadt\\b", "vd"},
    {"\\bnord\\b", "n"},
    {"\\bwest\\b", "o"},
    {"\\bieme\\b", ""},
    {"\\bviii\\b", "8"},
    {"\\bxiii\\b", "13"},
    {"\\bxvii\\b", "17"},
    {"\\bstad\\b", ""},
    {"\\bbern\\b", "be"},
    {"\\bgenf\\b", "ge"},
    {"\\bjura\\b", "ju"},
    {"\\bvaud\\b", "vd"},
    {"\\bzugo\\b", "zg"},
    {"\\bzoug\\b", "zg"},
    {"\\bsud\\b", "s"},
    {"\\best\\b", ""},
    {"\\bere\\b", ""},
    {"\\beme\\b", ""},
    {"\\bste\\b", ""},
    {"\\bmte\\b", "mt"},
    {"\\biii\\b", "3"},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\bxvi\\b", "16"},
    {"\\bxix\\b", "19"},
    {"\\bdes\\b", ""},
    {"\\bles\\b", ""},
    {"\\bsur\\b", ""},
    {"\\buri\\b", "ur"},
    {"\\bzug\\b", "zg"},
    {"\\bst\\b", ""},
    {"\\bnd\\b", ""},
    {"\\brd\\b", ""},
    {"\\bth\\b", ""},
    {"\\ber\\b", ""},
    {"\\bre\\b", ""},
    {"\\bii\\b", "2"},
    {"\\biv\\b", "4"},
    {"\\bvi\\b", "6"},
    {"\\bix\\b", "9"},
    {"\\b10\\b", "x"},
    {"\\b11\\b", "xi"},
    {"\\b15\\b", "xv"},
    {"\\b20\\b", "xx"},
    {"\\bdu\\b", ""},
    {"\\bde\\b", ""},
    {"\\bd\'\\b", ""},
    {"\\bla\\b", ""},
    {"\\ble\\b", ""},
    {"\\bl\'\\b", ""},
    {"\\bof\\b", ""},
    {"\\ben\\b", ""},
    {"\\bin\\b", ""},
    {"\\be\\b", ""},
    {"\\bw\\b", "o"},
    {"\\b1\\b", "i"},
    {"\\bv\\b", "5"},
};

const Rule kRules_CL[] = {
    {"\\baisen\\s+del\\s+general\\s+carlos\\s+ibanez\\s+del\\s+campo\\b", "11"},
    {"\\blibertador\\s+general\\s+bernardo\\s+o\'higgins\\b", "6"},
    {"\\bmetropolitana\\s+de\\s+santiago\\s+de\\s+chile\\b", "rm"},
    {"\\bmagallanes\\s+y\\s+la\\s+antartica\\s+chilena\\b", "12"},
    {"\\bmetropolitana\\s+de\\s+santiago\\b", "rm"},
    {"\\barica\\s+y\\s+parinacota\\b", "xv"},
    {"\\bmetropolitana\\b", "rm"},
    {"\\bla\\s+araucania\\b", "9"},
    {"\\bantofagasta\\b", "2"},
    {"\\bvalparaiso\\b", "v"},
    {"\\blos\\s+lagos\\b", "x"},
    {"\\btarapaca\\b", "i"},
    {"\\bcoquimbo\\b", "4"},
    {"\\blos\\s+rios\\b", "14"},
    {"\\batacama\\b", "3"},
    {"\\bbio\\s+bio\\b", "8"},
    {"\\bmaule\\b", "7"},
    {"\\bchile\\b", "cl"},
    {"\\bviii\\b", "8"},
    {"\\biii\\b", "3"},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\bii\\b", "2"},
    {"\\biv\\b", "4"},
    {"\\bvi\\b", "6"},
    {"\\bix\\b", "9"},
    {"\\b10\\b", "x"},
    {"\\bxi\\b", "11"},
    {"\\b15\\b", "xv"},
    {"\\b1\\b", "i"},
    {"\\b5\\b", "v"},
};

const Rule kRules_CO[] = {
    {"\\bcolombia\\b", "co"},
    {"\\bcolumbia\\b", "co"},
};

const Rule kRules_DE[] = {
    {"\\bfederal\\s+republic\\s+of\\s+germany\\b", "de"},
    {"\\bbundesrepublik\\s+deutschland\\b", "de"},
    {"\\bfreie\\s+hansestadt\\s+bremen\\b", "hb"},
    {"\\bmecklenburg\\s+vorpommern\\b", "mv"},
    {"\\bnorth\\s+rhine\\s+westphalia\\b", "nw"},
    {"\\brhineland\\s+palatinate\\b", "rp"},
    {"\\bnordrhein\\s+westfalen\\b", "nw"},
    {"\\bschleswig\\s+holstein\\b", "sh"},
    {"\\bbaden\\s+wurttemberg\\b", "bw"},
    {"\\bregionalverband\\b", ""},
    {"\\brheinland\\s+pfalz\\b", "rp"},
    {"\\bsachsen\\s+anhalt\\b", "st"},
    {"\\bniedersachsen\\b", "ni"},
    {"\\bsaxony\\s+anhalt\\b", "st"},
    {"\\bstadtverband\\b", ""},
    {"\\blower\\s+saxony\\b", "ni"},
    {"\\bbrandenburg\\b", "bb"},
    {"\\bdeutschland\\b", "de"},
    {"\\blandkreis\\b", ""},
    {"\\bthuringia\\b", "th"},
    {"\\bthuringen\\b", "th"},
    {"\\bsaarland\\b", "sl"},
    {"\\bstrasse\\b", "str"},
    {"\\bcologne\\b", "koln"},
    {"\\bbavaria\\b", "by"},
    {"\\bhamburg\\b", "hh"},
    {"\\bsachsen\\b", "sn"},
    {"\\bgermany\\b", "de"},
    {"\\bsudost\\b", "se"},
    {"\\bbayern\\b", "by"},
    {"\\bberlin\\b", "be"},
    {"\\bbremen\\b", "hb"},
    {"\\bhessen\\b", "he"},
    {"\\bsaxony\\b", "sn"},
    {"\\bsankt\\b", "st"},
    {"\\bstadt\\b", ""},
    {"\\bhesse\\b", "he"},
    {"\\bnord\\b", "n"},
    {"\\bwest\\b", "w"},
    {"\\bsud\\b", "s"},
    {"\\bost\\b", "o"},
};

const Rule kRules_DK[] = {
    {"\\bgrabrodrestraede\\b", "grabrodrestr"},
    {"\\barnold\\s+nielsens\\b", "arn nielsens"},
    {"\\bhaveforeningen\\b", "haveforening"},
    {"\\bmunicipality\\b", ""},
    {"\\btengslemark\\b", "tengslemrk"},
    {"\\bbispebjergs\\b", "bispebjerg"},
    {"\\bboulevard\\b", "boul"},
    {"\\blillerod\\b", "allerod"},
    {"\\bpladsen\\b", "plads"},
    {"\\bkvarter\\b", "kvater"},
    {"\\bkommune\\b", ""},
    {"\\bdenmark\\b", "dk"},
    {"\\bdanmark\\b", "dk"},
    {"\\bsondre\\b", "s"},
    {"\\bnummer\\b", "nr"},
    {"\\bgammel\\b", "gl"},
    {"\\blokken\\b", "lokke"},
    {"\\bboulev\\b", "boul"},
    {"\\bnorre\\b", "n"},
    {"\\bsankt\\b", "skt"},
    {"\\bgamle\\b", "gl"},
    {"\\bnord\\b", "n"},
    {"\\bvest\\b", "v"},
    {"\\bndr\\b", "n"},
    {"\\bsyd\\b", "s"},
    {"\\bsdr\\b", "s"},
    {"\\bost\\b", "o"},
    {"\\bsct\\b", "skt"},
};

const Rule kRules_ES[] = {
    {"\\bsanta\\s+cruz\\s+de\\s+tenerife\\b", "tf"},
    {"\\bbalearic\\s+islands\\b", "pm"},
    {"\\bislas\\s+baleares\\b", "pm"},
    {"\\billes\\s+balears\\b", "pm"},
    {"\\bciudad\\s+real\\b", "cr"},
    {"\\bguadalajara\\b", "gu"},
    {"\\bla\\s+corunna\\b", "c"},
    {"\\bla\\s+corunya\\b", "c"},
    {"\\blas\\s+palmas\\b", "gc"},
    {"\\bpontevedra\\b", "po"},
    {"\\bvalladolid\\b", "va"},
    {"\\besplugues\\b", "esplugas"},
    {"\\bla\\s+coruna\\b", "c"},
    {"\\bbarcelona\\b", "b"},
    {"\\bcantabria\\b", "s"},
    {"\\bcastellon\\b", "cs"},
    {"\\bguipuscoa\\b", "ss"},
    {"\\bguipuzcoa\\b", "ss"},
    {"\\bsalamanca\\b", "sa"},
    {"\\btarragona\\b", "t"},
    {"\\bsaragossa\\b", "z"},
    {"\\ba\\s+coruna\\b", "c"},
    {"\\balbacete\\b", "ab"},
    {"\\balicante\\b", ""},
    {"\\basturias\\b", "o"},
    {"\\bcastello\\b", "cs"},
    {"\\bgipuzkoa\\b", "ss"},
    {"\\bla\\s+rioja\\b", "lo"},
    {"\\bnafarroa\\b", "na"},
    {"\\bpalencia\\b", "p"},
    {"\\bvalencia\\b", "v"},
    {"\\bzaragoza\\b", "z"},
    {"\\bavenida\\b", "av"},
    {"\\balacant\\b", ""},
    {"\\balmeria\\b", ""},
    {"\\bbadajoz\\b", "ba"},
    {"\\bvizcaya\\b", "bi"},
    {"\\bbizkaia\\b", "bi"},
    {"\\bcaceres\\b", "cc"},
    {"\\bcordoba\\b", "co"},
    {"\\bcordova\\b", "co"},
    {"\\bgranada\\b", "gr"},
    {"\\bnavarre\\b", "na"},
    {"\\bnavarra\\b", "na"},
    {"\\bourense\\b", "or"},
    {"\\bsegovia\\b", "sg"},
    {"\\bseville\\b", "se"},
    {"\\bsevilla\\b", "se"},
    {"\\bmadrid\\b", "m"},
    {"\\bcoruna\\b", "c"},
    {"\\bbiscay\\b", "bi"},
    {"\\bburgos\\b", "bu"},
    {"\\bcuenca\\b", "cu"},
    {"\\bgerona\\b", "gi"},
    {"\\bgirona\\b", "gi"},
    {"\\bhuelva\\b", "h"},
    {"\\bhuesca\\b", "hu"},
    {"\\blerida\\b", ""},
    {"\\blleida\\b", ""},
    {"\\bmalaga\\b", "ma"},
    {"\\bmurcia\\b", "mu"},
    {"\\borense\\b", "or"},
    {"\\bteruel\\b", "te"},
    {"\\btoledo\\b", "to"},
    {"\\bzamora\\b", "za"},
    {"\\bespana\\b", "es"},
    {"\\bnorth\\b", "n"},
    {"\\bnorte\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\boeste\\b", "o"},
    {"\\balava\\b", "vi"},
    {"\\baraba\\b", "vi"},
    {"\\bavila\\b", "av"},
    {"\\bcadiz\\b", "ca"},
    {"\\bsoria\\b", "so"},
    {"\\bspain\\b", "es"},
    {"\\beast\\b", "e"},
    {"\\beste\\b", "e"},
    {"\\bwest\\b", "o"},
    {"\\bjaen\\b", "j"},
    {"\\bleon\\b", "le"},
    {"\\blugo\\b", "lu"},
    {"\\bsur\\b", "s"},
    {"\\bdel\\b", ""},
    {"\\bdal\\b", ""},
    {"\\blos\\b", ""},
    {"\\blas\\b", ""},
    {"\\bles\\b", ""},
    {"\\bc\\/\\.\\b", "c"},
    {"\\bc\\.\\/\\b", "c"},
    {"\\bde\\b", ""},
    {"\\ben\\b", ""},
    {"\\bof\\b", ""},
    {"\\bal\\b", ""},
    {"\\bel\\b", ""},
    {"\\bla\\b", ""},
    {"\\bc\\/\\b", "c"},
    {"\\ba\\b", ""},
    {"\\bd\\b", ""},
    {"\\bl\\b", ""},
};

const Rule kRules_FR[] = {
    {"\\bprovence\\s+alpes\\s+cote\\s+d\\s+azur\\b", "u"},
    {"\\balpes\\s+de\\s+haute\\s+provence\\b", "04"},
    {"\\barnouville\\s+les\\s+gonesse\\b", "arnouville"},
    {"\\bterritoire\\s+de\\s+belfort\\b", "90"},
    {"\\bpyrenees\\s+atlantiques\\b", "64"},
    {"\\blanguedoc\\s+roussillon\\b", "k"},
    {"\\bpyrenees\\s+orientales\\b", "66"},
    {"\\bmeurthe\\s+et\\s+moselle\\b", "54"},
    {"\\bnord\\s+pas\\s+de\\s+calais\\b", "o"},
    {"\\bcharente\\s+maritime\\b", "17"},
    {"\\bseine\\s+saint\\s+denis\\b", "93"},
    {"\\bchampagne\\s+ardenne\\b", "g"},
    {"\\bbouches\\s+du\\s+rhone\\b", "13"},
    {"\\bloire\\s+atlantique\\b", "44"},
    {"\\bpays\\s+de\\s+la\\s+loire\\b", "r"},
    {"\\bpoitou\\s+charentes\\b", "t"},
    {"\\balpes\\s+maritimes\\b", "06"},
    {"\\bille\\s+et\\s+vilaine\\b", "35"},
    {"\\btarn\\s+et\\s+garonne\\b", "82"},
    {"\\bbasse\\s+normandie\\b", "p"},
    {"\\bhaute\\s+normandie\\b", "q"},
    {"\\bdepartementale\\b", "d"},
    {"\\bindre\\s+et\\s+loire\\b", "37"},
    {"\\blot\\s+et\\s+garonne\\b", "47"},
    {"\\bmaine\\s+et\\s+loire\\b", "49"},
    {"\\bhaute\\s+pyrenees\\b", "65"},
    {"\\bsaone\\s+et\\s+loire\\b", "71"},
    {"\\bseine\\s+maritime\\b", "76"},
    {"\\bhauts\\s+de\\s+seine\\b", "92"},
    {"\\blower\\s+normandy\\b", "p"},
    {"\\bupper\\s+normandy\\b", "q"},
    {"\\bdepartemental\\b", "d"},
    {"\\bcotes\\s+d\\s+armor\\b", "22"},
    {"\\bhaute\\s+garonne\\b", "31"},
    {"\\bpas\\s+de\\s+calais\\b", "62"},
    {"\\bseine\\s+et\\s+mame\\b", "77"},
    {"\\bfranche\\s+comte\\b", "i"},
    {"\\bile\\s+de\\s+france\\b", "j"},
    {"\\bmidi\\s+pyrenees\\b", "n"},
    {"\\bdix\\s+septieme\\b", "17"},
    {"\\bdix\\s+huitieme\\b", "18"},
    {"\\bdix\\s+neuvieme\\b", "19"},
    {"\\bcorse\\s+du\\s+sud\\b", "2a"},
    {"\\beure\\s+et\\s+loir\\b", "28"},
    {"\\bloir\\s+et\\s+cher\\b", "41"},
    {"\\bhaute\\s+savoie\\b", "74"},
    {"\\bhaute\\s+vienne\\b", "87"},
    {"\\bval\\s+de\\s+marne\\b", "94"},
    {"\\bquatorzieme\\b", "14"},
    {"\\bcouffouleux\\b", "coufouleux"},
    {"\\bhaute\\s+alpes\\b", "05"},
    {"\\bhaute\\s+corse\\b", "2b"},
    {"\\bhaute\\s+loire\\b", "43"},
    {"\\bhaute\\s+marne\\b", "52"},
    {"\\bpuy\\s+de\\s+dome\\b", "63"},
    {"\\bhaute\\s+saone\\b", "70"},
    {"\\bdeux\\s+sevres\\b", "79"},
    {"\\brhone\\s+alpes\\b", "5"},
    {"\\benclave\\s+de\\b", ""},
    {"\\bval\\s+d\\s+oise\\b", "95"},
    {"\\bacquitaine\\b", "b"},
    {"\\btroisieme\\b", "3"},
    {"\\bquatrieme\\b", "4"},
    {"\\bcinquieme\\b", "5"},
    {"\\btreizieme\\b", "13"},
    {"\\bquinzieme\\b", "xv"},
    {"\\bvingtieme\\b", "20"},
    {"\\bboulevard\\b", "bd"},
    {"\\bnationale\\b", "n"},
    {"\\bcote\\s+d\\s+or\\b", "21"},
    {"\\bfinistere\\b", "29"},
    {"\\bmoribihan\\b", "56"},
    {"\\bhaut\\s+rhin\\b", "68"},
    {"\\baquitaine\\b", "b"},
    {"\\bbourgogne\\b", "d"},
    {"\\bpremiere\\b", "i"},
    {"\\bdeuxieme\\b", "2"},
    {"\\bseptieme\\b", "7"},
    {"\\bhuitieme\\b", "8"},
    {"\\bneuvieme\\b", "9"},
    {"\\bdouzieme\\b", "12"},
    {"\\bseizieme\\b", "16"},
    {"\\bla\\s+croix\\b", "lacroix"},
    {"\\ballemont\\b", "allemond"},
    {"\\bardennes\\b", "08"},
    {"\\baveryron\\b", "12"},
    {"\\bcalvados\\b", "14"},
    {"\\bcharente\\b", "16"},
    {"\\bdordogne\\b", "24"},
    {"\\bbas\\s+rhin\\b", "67"},
    {"\\byvelines\\b", "78"},
    {"\\bvaucluse\\b", "84"},
    {"\\bauvergne\\b", "c"},
    {"\\bburgundy\\b", "d"},
    {"\\bbretagne\\b", ""},
    {"\\bbrittany\\b", ""},
    {"\\blimousin\\b", "l"},
    {"\\blorraine\\b", "m"},
    {"\\bpicardie\\b", "s"},
    {"\\bsixieme\\b", "6"},
    {"\\bdixieme\\b", "x"},
    {"\\bonzieme\\b", "xi"},
    {"\\bpicardy\\b", "s"},
    {"\\bardeche\\b", "07"},
    {"\\bcorreze\\b", "19"},
    {"\\bgironde\\b", "33"},
    {"\\bherault\\b", "34"},
    {"\\bmayenne\\b", "53"},
    {"\\bmoselle\\b", "57"},
    {"\\bessonne\\b", "91"},
    {"\\bcorsica\\b", "h"},
    {"\\bsainte\\b", ""},
    {"\\bgrande\\b", "gr"},
    {"\\bavenue\\b", "ave"},
    {"\\bregion\\b", ""},
    {"\\ballier\\b", "03"},
    {"\\bariege\\b", "09"},
    {"\\bcreuse\\b", "23"},
    {"\\blandes\\b", "40"},
    {"\\bloiret\\b", "45"},
    {"\\blozere\\b", "48"},
    {"\\bmanche\\b", "50"},
    {"\\bnievre\\b", "58"},
    {"\\bsarthe\\b", "72"},
    {"\\bsavoie\\b", "73"},
    {"\\bvendee\\b", "85"},
    {"\\bvienne\\b", "86"},
    {"\\bvosges\\b", "88"},
    {"\\balsace\\b", "a"},
    {"\\bcentre\\b", "f"},
    {"\\bfrance\\b", "fr"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bouest\\b", "o"},
    {"\\bsaint\\b", ""},
    {"\\bmount\\b", "mt"},
    {"\\bxviii\\b", "18"},
    {"\\bde\\s+la\\b", ""},
    {"\\bde\\s+l\'\\b", ""},
    {"\\bet\\s+du\\b", ""},
    {"\\bgrand\\b", "gr"},
    {"\\bvilla\\b", "vil"},
    {"\\bparis\\b", ""},
    {"\\baisne\\b", "02"},
    {"\\bdoubs\\b", "25"},
    {"\\bdrome\\b", "26"},
    {"\\bindre\\b", "36"},
    {"\\bisere\\b", "38"},
    {"\\bloire\\b", "42"},
    {"\\bmarne\\b", "51"},
    {"\\bmeuse\\b", "55"},
    {"\\brhone\\b", "69"},
    {"\\bsomme\\b", "80"},
    {"\\byonne\\b", "89"},
    {"\\bcorse\\b", "h"},
    {"\\bnord\\b", "n"},
    {"\\bwest\\b", "o"},
    {"\\bieme\\b", ""},
    {"\\bviii\\b", "8"},
    {"\\bxiii\\b", "13"},
    {"\\bxvii\\b", "17"},
    {"\\bcher\\b", "18"},
    {"\\beure\\b", "27"},
    {"\\bgard\\b", "30"},
    {"\\bgers\\b", "32"},
    {"\\bjura\\b", "39"},
    {"\\boise\\b", "60"},
    {"\\borne\\b", "61"},
    {"\\btarn\\b", "81"},
    {"\\bsud\\b", "s"},
    {"\\best\\b", ""},
    {"\\bere\\b", ""},
    {"\\beme\\b", ""},
    {"\\bste\\b", ""},
    {"\\bmte\\b", "mt"},
    {"\\biii\\b", "3"},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\bxvi\\b", "16"},
    {"\\bxix\\b", "19"},
    {"\\bdes\\b", ""},
    {"\\bles\\b", ""},
    {"\\bsur\\b", ""},
    {"\\bgde\\b", "gr"},
    {"\\bain\\b", "01"},
    {"\\blot\\b", "46"},
    {"\\bvar\\b", "83"},
    {"\\bst\\b", ""},
    {"\\bnd\\b", ""},
    {"\\brd\\b", ""},
    {"\\bth\\b", ""},
    {"\\ber\\b", ""},
    {"\\bre\\b", ""},
    {"\\bii\\b", "2"},
    {"\\biv\\b", "4"},
    {"\\bvi\\b", "6"},
    {"\\bix\\b", "9"},
    {"\\b10\\b", "x"},
    {"\\b11\\b", "xi"},
    {"\\b15\\b", "xv"},
    {"\\bxx\\b", "20"},
    {"\\bdu\\b", ""},
    {"\\bde\\b", ""},
    {"\\bd\'\\b", ""},
    {"\\bla\\b", ""},
    {"\\ble\\b", ""},
    {"\\bl\'\\b", ""},
    {"\\bof\\b", ""},
    {"\\ben\\b", ""},
    {"\\bin\\b", ""},
    {"\\bgd\\b", "gr"},
    {"\\b59\\b", "n"},
    {"\\b75\\b", ""},
    {"\\be\\b", ""},
    {"\\bw\\b", "o"},
    {"\\b1\\b", "i"},
    {"\\bv\\b", "5"},
};

const Rule kRules_GB[] = {
    {"\\bbath\\s+and\\s+north\\s+east\\s+somerset\\b", "gb-bas"},
    {"\\bdungannon\\s+and\\s+south\\s+tyrone\\b", "gb-dgn"},
    {"\\bcheshire\\s+west\\s+and\\s+chester\\b", "gb-chw"},
    {"\\bnewry\\s+and\\s+mourne\\s+district\\b", "gb-nym"},
    {"\\beast\\s+riding\\s+of\\s+yorkshire\\b", "gb-ery"},
    {"\\bmetropolitan\\s+borough\\s+of\\b", ""},
    {"\\bnorth\\s+east\\s+lincolnshire\\b", "gb-nel"},
    {"\\bhammersmith\\s+and\\s+fulham\\b", "gb-hmf"},
    {"\\bkensington\\s+and\\s+chelsea\\b", "gb-kec"},
    {"\\bwindsor\\s+and\\s+maidenhead\\b", "gb-wnm"},
    {"\\bblackburn\\s+with\\s+darwen\\b", "gb-bbd"},
    {"\\bsouth\\s+gloucestershire\\b", "gb-sgc"},
    {"\\bdumfries\\s+and\\s+galloway\\b", "gb-dgy"},
    {"\\bthe\\s+vale\\s+of\\s+glamorgan\\b", "gb-vgl"},
    {"\\bbarking\\s+and\\s+dagenham\\b", "gb-bdg"},
    {"\\bkingston\\s+upon\\s+thames\\b", "gb-ktt"},
    {"\\brichmond\\s+upon\\s+thames\\b", "gb-ric"},
    {"\\bcentral\\s+bedfordshire\\b", "gb-cbf"},
    {"\\bredcar\\s+and\\s+cleveland\\b", "gb-rcc"},
    {"\\bthe\\s+scottish\\s+borders\\b", "gb-scb"},
    {"\\brhondda\\,\\s+cynon\\,\\s+taff\\b", "gb-rct"},
    {"\\bnewcastle\\s+upon\\s+tyne\\b", "gb-net"},
    {"\\beast\\s+dunbartonshire\\b", "gb-edu"},
    {"\\bwest\\s+dunbartonshire\\b", "gb-wdu"},
    {"\\bliverpool\\s+district\\b", "gb-liv"},
    {"\\bkingston\\s+upon\\s+hull\\b", "gb-khl"},
    {"\\bnorth\\s+lincolnshire\\b", "gb-nln"},
    {"\\btelford\\s+and\\s+wrekin\\b", "gb-tfw"},
    {"\\blondon\\s+borough\\s+of\\b", ""},
    {"\\bkirklees\\s+district\\b", "gb-kir"},
    {"\\bbrighton\\s+and\\s+hove\\b", "gb-bnh"},
    {"\\beast\\s+renfrewshire\\b", "gb-erw"},
    {"\\bcity\\s+of\\s+edinburgh\\b", "gb-edh"},
    {"\\bnorth\\s+lanarkshire\\b", "gb-nlk"},
    {"\\bperth\\s+and\\s+kinross\\b", "gb-pkn"},
    {"\\bsouth\\s+lanarkshire\\b", "gb-slk"},
    {"\\bneath\\s+port\\s+talbot\\b", "gb-ntl"},
    {"\\bnorthamptonshire\\b", "gb-nth"},
    {"\\bbracknell\\s+forest\\b", "gb-brc"},
    {"\\bstockton\\-on\\-tees\\b", "gb-stt"},
    {"\\bclackmannanshire\\b", "gb-clk"},
    {"\\bshetland\\s+islands\\b", "gb-zet"},
    {"\\bisle\\s+of\\s+anglesey\\b", "gb-agy"},
    {"\\bnorthern\\s+ireland\\b", "n.i."},
    {"\\bbuckinghamshire\\b", "gb-bkm"},
    {"\\bgloucestershire\\b", "gb-gls"},
    {"\\bnorth\\s+yorkshire\\b", "gb-nyk"},
    {"\\bnottinghamshire\\b", "gb-ntt"},
    {"\\bsefton\\s+district\\b", "gb-sft"},
    {"\\bcity\\s+of\\s+bristol\\b", "gb-bst"},
    {"\\bsouthend\\-on\\-sea\\b", "gb-sos"},
    {"\\bargyll\\s+and\\s+bute\\b", "gb-agb"},
    {"\\bcarmarthenshire\\b", "gb-cmn"},
    {"\\bcambridgeshire\\b", "gb-cam"},
    {"\\bleicestershire\\b", "gb-lec"},
    {"\\bworcestershire\\b", "gb-wor"},
    {"\\bwaltham\\s+forest\\b", "gb-wft"},
    {"\\bleeds\\s+district\\b", "gb-lds"},
    {"\\bnorth\\s+tyneside\\b", "gb-nty"},
    {"\\bsouth\\s+tyneside\\b", "gb-sty"},
    {"\\bnorth\\s+somerset\\b", "gb-nsm"},
    {"\\bnorthumberland\\b", "gb-nbl"},
    {"\\bstoke\\-on\\-trent\\b", "gb-ste"},
    {"\\bwest\\s+berkshire\\b", "gb-wbk"},
    {"\\bcity\\s+of\\s+london\\b", "gb-lnd"},
    {"\\bnorth\\s+ayrshire\\b", "gb-nay"},
    {"\\borkney\\s+islands\\b", "gb-ork"},
    {"\\bsouth\\s+ayrshire\\b", "gb-say"},
    {"\\bmerthyr\\s+tydfil\\b", "gb-mty"},
    {"\\bhertfordshire\\b", "gb-hrt"},
    {"\\bstaffordshire\\b", "gb-sts"},
    {"\\btower\\s+hamlets\\b", "gb-twh"},
    {"\\bwolverhampton\\b", "gb-wlv"},
    {"\\bcheshire\\s+east\\b", "gb-che"},
    {"\\bcounty\\s+durham\\b", "gb-dur"},
    {"\\bherefordshire\\b", "gb-hef"},
    {"\\bisle\\s+of\\s+wight\\b", "gb-iow"},
    {"\\bmiddlesbrough\\b", "gb-mdb"},
    {"\\bmilton\\s+keynes\\b", "gb-mik"},
    {"\\bcarrickfergus\\b", "gb-ckf"},
    {"\\baberdeen\\s+city\\b", "gb-abe"},
    {"\\baberdeenshire\\b", "gb-abd"},
    {"\\beast\\s+ayrshire\\b", "gb-eay"},
    {"\\bblaenau\\s+gwent\\b", "gb-bgw"},
    {"\\bmonmouthshire\\b", "gb-mon"},
    {"\\bpembrokeshire\\b", "gb-pem"},
    {"\\blincolnshire\\b", "gb-lin"},
    {"\\bwarwickshire\\b", "gb-war"},
    {"\\bpeterborough\\b", "gb-pte"},
    {"\\bnewtownabbey\\b", "gb-nta"},
    {"\\beast\\s+lothian\\b", "gb-eln"},
    {"\\bglasgow\\s+city\\b", "gb-glg"},
    {"\\brenfrewshire\\b", "gb-rfw"},
    {"\\bwest\\s+lothian\\b", "gb-wln"},
    {"\\bdenbighshire\\b", "gb-den"},
    {"\\bfulmodestone\\b", "fulmodeston"},
    {"\\beast\\s+sussex\\b", "gb-esx"},
    {"\\boxfordshire\\b", "gb-oxf"},
    {"\\bwest\\s+sussex\\b", "gb-wsx"},
    {"\\bwestminster\\b", "gb-wsm"},
    {"\\bbournemouth\\b", "gb-bmh"},
    {"\\bsouthampton\\b", "gb-sth"},
    {"\\bcastlereagh\\b", "gb-csr"},
    {"\\bmagherafelt\\b", "gb-mft"},
    {"\\bdundee\\s+city\\b", "gb-dnd"},
    {"\\beilean\\s+siar\\b", "gb-els"},
    {"\\bdunnamanagh\\b", "dunamanagh"},
    {"\\bking\'s\\s+stag\\b", "king stag"},
    {"\\bborough\\s+of\\b", ""},
    {"\\bderbyshire\\b", "gb-dby"},
    {"\\blancashire\\b", "gb-lan"},
    {"\\bhillingdon\\b", "gb-hil"},
    {"\\bwandsworth\\b", "gb-wnd"},
    {"\\bbirmingham\\b", "gb-bir"},
    {"\\bcalderdale\\b", "gb-cld"},
    {"\\bmanchester\\b", "gb-man"},
    {"\\bst\\.\\s+helens\\b", "gb-shn"},
    {"\\bsunderland\\b", "gb-snd"},
    {"\\bdarlington\\b", "gb-dal"},
    {"\\bhartlepool\\b", "gb-hpl"},
    {"\\bnottingham\\b", "gb-ngm"},
    {"\\bportsmouth\\b", "gb-por"},
    {"\\bshropshire\\b", "gb-shr"},
    {"\\bwarrington\\b", "gb-wrt"},
    {"\\bballymoney\\b", "gb-bly"},
    {"\\bnorth\\s+down\\b", "gb-ndn"},
    {"\\binverclyde\\b", "gb-ivc"},
    {"\\bmidlothian\\b", "gb-mln"},
    {"\\bcaerphilly\\b", "gb-cay"},
    {"\\bceredigion\\b", "gb-cgn"},
    {"\\bflintshire\\b", "gb-fln"},
    {"\\bgroes\\-lwyd\\b", "groesllwyd"},
    {"\\bculnacnock\\b", "culnacnoc"},
    {"\\bn\\.\\s+ireland\\b", "n.i."},
    {"\\bboulevard\\b", "blvd"},
    {"\\bhampshire\\b", "gb-ham"},
    {"\\bgreenwich\\b", "gb-gre"},
    {"\\bislington\\b", "gb-isl"},
    {"\\bredbridge\\b", "gb-rdb"},
    {"\\bsouthwark\\b", "gb-swk"},
    {"\\bdoncaster\\b", "gb-dnc"},
    {"\\bgateshead\\b", "gb-gat"},
    {"\\brotherham\\b", "gb-rot"},
    {"\\bsheffield\\b", "gb-shf"},
    {"\\bstockport\\b", "gb-skp"},
    {"\\bwakefield\\b", "gb-wkf"},
    {"\\bblackpool\\b", "gb-bpl"},
    {"\\bleicester\\b", "gb-lce"},
    {"\\bwiltshire\\b", "gb-wil"},
    {"\\bwokingham\\b", "gb-wok"},
    {"\\bballymena\\b", "gb-bla"},
    {"\\bbanbridge\\b", "gb-bnb"},
    {"\\bcoleraine\\b", "gb-clr"},
    {"\\bcookstown\\b", "gb-ckt"},
    {"\\bcraigavon\\b", "gb-cgv"},
    {"\\bfermanagh\\b", "gb-fer"},
    {"\\bn\\.ireland\\b", "n.i."},
    {"\\bn\\s+ireland\\b", "n.i."},
    {"\\bcrescent\\b", "cres"},
    {"\\bdistrict\\b", ""},
    {"\\bsomerset\\b", "gb-som"},
    {"\\bharingey\\b", "gb-hry"},
    {"\\bhavering\\b", "gb-hav"},
    {"\\bhounslow\\b", "gb-hns"},
    {"\\blewisham\\b", "gb-lew"},
    {"\\bbarnsley\\b", "gb-bns"},
    {"\\bbradford\\b", "gb-brd"},
    {"\\bcoventry\\b", "gb-cov"},
    {"\\bknowsley\\b", "gb-kwl"},
    {"\\brochdale\\b", "gb-rch"},
    {"\\bsandwell\\b", "gb-saw"},
    {"\\bsolihull\\b", "gb-sol"},
    {"\\btameside\\b", "gb-tam"},
    {"\\btrafford\\b", "gb-trf"},
    {"\\bcornwall\\b", "gb-con"},
    {"\\bplymouth\\b", "gb-ply"},
    {"\\bthurrock\\b", "gb-thr"},
    {"\\blimavady\\b", "gb-lmv"},
    {"\\bstrabane\\b", "gb-stb"},
    {"\\bhighland\\b", "gb-hld"},
    {"\\bstirling\\b", "gb-stg"},
    {"\\bbridgend\\b", "gb-bge"},
    {"\\bcheshire\\b", "gb-chs"},
    {"\\bhare\\s+law\\b", "harelaw"},
    {"\\bscotland\\b", "gb-sct"},
    {"\\bparkway\\b", "pkwy"},
    {"\\bhighway\\b", "hwy"},
    {"\\bcity\\s+of\\b", ""},
    {"\\bcumbria\\b", "gb-cma"},
    {"\\bnorfolk\\b", "gb-nfk"},
    {"\\bsuffolk\\b", "gb-sfk"},
    {"\\bbromley\\b", "gb-bry"},
    {"\\bcroydon\\b", "gb-cry"},
    {"\\benfield\\b", "gb-enf"},
    {"\\bhackney\\b", "gb-hck"},
    {"\\blambeth\\b", "gb-lbh"},
    {"\\bsalford\\b", "gb-slf"},
    {"\\bwalsall\\b", "gb-wll"},
    {"\\bbedford\\b", "gb-bdf"},
    {"\\breading\\b", "gb-rdg"},
    {"\\brutland\\b", "gb-rut"},
    {"\\bswindon\\b", "gb-swd"},
    {"\\bbelfast\\b", "gb-bfs"},
    {"\\blisburn\\b", "gb-lsb"},
    {"\\bfalkirk\\b", "gb-fal"},
    {"\\bcardiff\\b", "gb-crf"},
    {"\\bgwynedd\\b", "gb-gwn"},
    {"\\bnewport\\b", "gb-nwp"},
    {"\\bswansea\\b", "gb-swa"},
    {"\\btorfaen\\b", "gb-tof"},
    {"\\bwrexham\\b", "gb-wrx"},
    {"\\bengland\\b", "eng"},
    {"\\bavenue\\b", "ave"},
    {"\\bstreet\\b", "st"},
    {"\\bparade\\b", "pde"},
    {"\\bcommon\\b", "comm"},
    {"\\bgb\\-dev\\b", "devon"},
    {"\\bgb\\-dor\\b", "dorset"},
    {"\\bgb\\-ess\\b", "essex"},
    {"\\bgb\\-ken\\b", "kent"},
    {"\\bsurrey\\b", "gb-sry"},
    {"\\bbarnet\\b", "gb-bne"},
    {"\\bgb\\-bex\\b", "bexley"},
    {"\\bgb\\-ben\\b", "brent"},
    {"\\bcamden\\b", "gb-cmd"},
    {"\\bealing\\b", "gb-eal"},
    {"\\bgb\\-hrw\\b", "harrow"},
    {"\\bgb\\-mrt\\b", "merton"},
    {"\\bgb\\-nwm\\b", "newham"},
    {"\\bgb\\-stn\\b", "sutton"},
    {"\\bgb\\-bol\\b", "bolton"},
    {"\\bgb\\-bur\\b", "bury"},
    {"\\bdudley\\b", "gb-dud"},
    {"\\bgb\\-old\\b", "oldham"},
    {"\\bgb\\-wgn\\b", "wigan"},
    {"\\bwirral\\b", "gb-wrl"},
    {"\\bgb\\-der\\b", "derby"},
    {"\\bgb\\-hal\\b", "halton"},
    {"\\bgb\\-lut\\b", "luton"},
    {"\\bgb\\-mdw\\b", "medway"},
    {"\\bgb\\-pol\\b", "poole"},
    {"\\bslough\\b", "gb-slg"},
    {"\\bgb\\-tob\\b", "torbay"},
    {"\\bgb\\-yor\\b", "york"},
    {"\\bantrim\\b", "gb-ant"},
    {"\\bgb\\-ard\\b", "ards"},
    {"\\bgb\\-arm\\b", "armagh"},
    {"\\bgb\\-dry\\b", "derry"},
    {"\\bgb\\-dow\\b", "down"},
    {"\\bgb\\-lrn\\b", "larne"},
    {"\\bgb\\-myl\\b", "moyle"},
    {"\\bgb\\-omh\\b", "omagh"},
    {"\\bgb\\-ans\\b", "angus"},
    {"\\bgb\\-fif\\b", "fife"},
    {"\\bgb\\-mry\\b", "moray"},
    {"\\bgb\\-cwy\\b", "conwy"},
    {"\\bgb\\-pow\\b", "powys"},
    {"\\bgb\\-eng\\b", "eng"},
    {"\\bgb\\-wls\\b", "wales"},
    {"\\bgb\\-nir\\b", "n.i."},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bmount\\b", "mt"},
    {"\\bsaint\\b", "st"},
    {"\\bpoint\\b", "pt"},
    {"\\bcourt\\b", "ct"},
    {"\\bplace\\b", "pl"},
    {"\\bdrive\\b", "dr"},
    {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},
    {"\\broad\\b", "rd"},
    {"\\blane\\b", "ln"},
    {"\\bu\\.k\\.\\b", "gb"},
    {"\\bg\\.b\\.\\b", "gb"},
    {"\\bnth\\b", "n"},
    {"\\bsth\\b", "s"},
    {"\\bmt\\.\\b", "mt"},
    {"\\bst\\.\\b", "st"},
    {"\\bpt\\.\\b", "pt"},
    {"\\bu\\.k\\b", "gb"},
    {"\\bg\\.b\\b", "gb"},
    {"\\bn\\.\\b", "n"},
    {"\\bs\\.\\b", "s"},
    {"\\be\\.\\b", "e"},
    {"\\bw\\.\\b", "w"},
    {"\\buk\\b", "gb"},
};

const Rule kRules_GR[] = {
    {"\\banatoliki\\s+makedonia\\s+kai\\s+thraki\\b", "a"},
    {"\\baitolia\\s+kai\\s+akarnania\\b", "01"},
    {"\\bkentriki\\s+makedonia\\b", "b"},
    {"\\bdytiki\\s+makedonia\\b", "c"},
    {"\\baitoloakarnania\\b", "01"},
    {"\\bdytiki\\s+ellada\\b", "g"},
    {"\\bsterea\\s+ellada\\b", "h"},
    {"\\bvoreio\\s+aigaio\\b", "k"},
    {"\\bnotio\\s+aigaio\\b", "l"},
    {"\\bpeloponnisos\\b", "j"},
    {"\\bthessaloniki\\b", "54"},
    {"\\bmetamorfossi\\b", "metamorfosi"},
    {"\\bionia\\s+nisia\\b", "f"},
    {"\\bdodekanisos\\b", "81"},
    {"\\bkaissariani\\b", "kesariani"},
    {"\\banatolikos\\b", "e"},
    {"\\bperifereia\\b", "periphery"},
    {"\\bchalkidiki\\b", "64"},
    {"\\bkefallonia\\b", "23"},
    {"\\bthesprotia\\b", "32"},
    {"\\bnomarchia\\b", "nomo"},
    {"\\bthessalia\\b", "e"},
    {"\\bevrytania\\b", "05"},
    {"\\bfthiotida\\b", "06"},
    {"\\bkorinthia\\b", "15"},
    {"\\bzakynthos\\b", "21"},
    {"\\bagio\\s+oros\\b", "69"},
    {"\\bcholargos\\b", "holargos"},
    {"\\bargolida\\b", "11"},
    {"\\bioannina\\b", "33"},
    {"\\birakleio\\b", "91"},
    {"\\bkarditsa\\b", "41"},
    {"\\bkastoria\\b", "56"},
    {"\\bkyklades\\b", "82"},
    {"\\bmagnisia\\b", "43"},
    {"\\bmessinia\\b", "17"},
    {"\\brethymno\\b", "93"},
    {"\\brethymni\\b", "93"},
    {"\\bchaidari\\b", "haidari"},
    {"\\bmaroussi\\b", "marousi"},
    {"\\bkifissia\\b", "kifisia"},
    {"\\bchalkida\\b", "halkida"},
    {"\\bvoreioy\\b", "n"},
    {"\\banatoli\\b", "e"},
    {"\\bdytikos\\b", "w"},
    {"\\bipeiros\\b", "d"},
    {"\\barkadia\\b", "12"},
    {"\\bflorina\\b", "63"},
    {"\\bgrevena\\b", "51"},
    {"\\bimathia\\b", "53"},
    {"\\bkerkyra\\b", "22"},
    {"\\blakonia\\b", "16"},
    {"\\blasithi\\b", "92"},
    {"\\blefkada\\b", "24"},
    {"\\bpreveza\\b", "34"},
    {"\\btrikala\\b", "44"},
    {"\\bvoiotia\\b", "03"},
    {"\\bpiraeus\\b", "pireas"},
    {"\\bpapagos\\b", "papagou"},
    {"\\bvoreio\\b", "n"},
    {"\\bnotioy\\b", "s"},
    {"\\battiki\\b", "i"},
    {"\\bachaia\\b", "13"},
    {"\\bchania\\b", "94"},
    {"\\bevvoia\\b", "04"},
    {"\\bfokida\\b", "07"},
    {"\\bkavala\\b", "55"},
    {"\\bkilkis\\b", "57"},
    {"\\bkozani\\b", "58"},
    {"\\blarisa\\b", "42"},
    {"\\blesvos\\b", "83"},
    {"\\bpieria\\b", "61"},
    {"\\brodopi\\b", "73"},
    {"\\bserres\\b", "62"},
    {"\\bxanthi\\b", "72"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bnotio\\b", "s"},
    {"\\bkriti\\b", "m"},
    {"\\bchios\\b", "85"},
    {"\\bdrama\\b", "52"},
    {"\\bevros\\b", "71"},
    {"\\bileia\\b", "14"},
    {"\\bpella\\b", "59"},
    {"\\bsamos\\b", "84"},
    {"\\bhania\\b", "94"},
    {"\\bkato\\b", "s"},
    {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},
    {"\\bdysi\\b", "w"},
    {"\\barta\\b", "31"},
    {"\\bhios\\b", "85"},
    {"\\bano\\b", "n"},
    {"\\ba\\s+1\\b", "i"},
};

const Rule kRules_HK[] = {
    {"\\bboulevard\\b", "blvd"}, {"\\bhong\\s+kong\\b", "hk"},
    {"\\bjunction\\b", "jct"},   {"\\bcrescent\\b", "cres"},
    {"\\bdistrict\\b", ""},      {"\\bhongkong\\b", "hk"},
    {"\\bcentral\\b", "c"},      {"\\bseventh\\b", "7"},
    {"\\bparkway\\b", "pkwy"},   {"\\bhighway\\b", "hwy"},
    {"\\bsecond\\b", "2"},       {"\\bfourth\\b", "4"},
    {"\\beighth\\b", "8"},       {"\\bavenue\\b", "ave"},
    {"\\bstreet\\b", "st"},      {"\\bparade\\b", "pde"},
    {"\\bcommon\\b", "comm"},    {"\\bcenter\\b", "centre"},
    {"\\bnorth\\b", "n"},        {"\\bsouth\\b", "s"},
    {"\\bfirst\\b", "1"},        {"\\bthird\\b", "3"},
    {"\\bthree\\b", "3"},        {"\\bfifth\\b", "5"},
    {"\\bsixth\\b", "6"},        {"\\bseven\\b", "7"},
    {"\\beight\\b", "8"},        {"\\bninth\\b", "9"},
    {"\\btenth\\b", "10"},       {"\\bmount\\b", "mt"},
    {"\\bsaint\\b", "st"},       {"\\bpoint\\b", "pt"},
    {"\\bcourt\\b", "ct"},       {"\\bplace\\b", "pl"},
    {"\\bdrive\\b", "dr"},       {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},         {"\\bfour\\b", "4"},
    {"\\bfive\\b", "5"},         {"\\bnine\\b", "9"},
    {"\\broad\\b", "rd"},        {"\\blane\\b", "ln"},
    {"\\bnth\\b", "n"},          {"\\bsth\\b", "s"},
    {"\\bone\\b", "1"},          {"\\btwo\\b", "2"},
    {"\\bsix\\b", "6"},          {"\\bten\\b", "10"},
    {"\\bh\\s+k\\b", "hk"},
};

const Rule kRules_ID[] = {
    {"\\bspecial\\s+region\\s+of\\s+yogyakarta\\b", "yo"},
    {"\\bnanggroe\\s+aceh\\s+darussalam\\b", "ac"},
    {"\\bnaggroe\\s+aceh\\s+darussalam\\b", "ac"},
    {"\\bbangka\\s+belitung\\s+islands\\b", "bb"},
    {"\\bspecial\\s+region\\s+of\\s+papua\\b", "pa"},
    {"\\bspecial\\s+region\\s+of\\s+aceh\\b", "ac"},
    {"\\bcentral\\s+kalimantan\\b", "kt"},
    {"\\bsoutheast\\s+sulawesi\\b", "sg"},
    {"\\bcentral\\s+sulawesi\\b", "st"},
    {"\\bbangka\\s+belitung\\b", "bb"},
    {"\\bjakarta\\s+pusat\\b", "jk"},
    {"\\bjakarta\\s+utara\\b", "jk"},
    {"\\bcentral\\s+java\\b", "jt"},
    {"\\briau\\s+islands\\b", "kr"},
    {"\\bjawa\\s+tengah\\b", "jt"},
    {"\\bdki\\s+jakarta\\b", "jk"},
    {"\\byogyakarta\\b", "yo"},
    {"\\bgorontalo\\b", "go"},
    {"\\bindonesia\\b", "id"},
    {"\\bnational\\b", "nasional"},
    {"\\bbengkulu\\b", "be"},
    {"\\bselatan\\b", "s"},
    {"\\bjakarta\\b", "jk"},
    {"\\blampung\\b", "la"},
    {"\\bbanten\\b", "bt"},
    {"\\bmaluku\\b", "ma"},
    {"\\bnumber\\b", "#"},
    {"\\bnorth\\b", "n"},
    {"\\butara\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\btimur\\b", "e"},
    {"\\bbarat\\b", "w"},
    {"\\bxviii\\b", "18"},
    {"\\bjalan\\b", "jl"},
    {"\\bjambi\\b", "ja"},
    {"\\bpapua\\b", "pa"},
    {"\\bblock\\b", "blk"},
    {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},
    {"\\bviii\\b", "8"},
    {"\\bxiii\\b", "13"},
    {"\\bxvii\\b", "17"},
    {"\\bjln\\.\\b", "jl"},
    {"\\broad\\b", "rd"},
    {"\\baceh\\b", "ac"},
    {"\\bbali\\b", "ba"},
    {"\\briau\\b", "ri"},
    {"\\bblok\\b", "blk"},
    {"\\bblk\\.\\b", "blk"},
    {"\\biii\\b", "3"},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\bxvi\\b", "16"},
    {"\\bxix\\b", "19"},
    {"\\bjl\\.\\b", "jl"},
    {"\\bjln\\b", "jl"},
    {"\\bnum\\b", "#"},
    {"\\bno\\.\\b", "#"},
    {"\\bii\\b", "2"},
    {"\\biv\\b", "4"},
    {"\\bvi\\b", "6"},
    {"\\bix\\b", "9"},
    {"\\b10\\b", "x"},
    {"\\b11\\b", "xi"},
    {"\\b15\\b", "xv"},
    {"\\b20\\b", "xx"},
    {"\\bno\\b", "#"},
    {"\\bi\\b", "1"},
    {"\\bv\\b", "5"},
};

const Rule kRules_IE[] = {
    {"\\broscommon\\b", "rn"}, {"\\btipperary\\b", "ty"},
    {"\\bwaterford\\b", "wd"}, {"\\bwestmeath\\b", "wh"},
    {"\\bkilkenny\\b", "kk"},  {"\\blimerick\\b", "lk"},
    {"\\blongford\\b", "ld"},  {"\\bmonaghan\\b", "mn"},
    {"\\bterrace\\b", "tce"},  {"\\bdonegal\\b", "dl"},
    {"\\bkildare\\b", "ke"},   {"\\bleitrim\\b", "lm"},
    {"\\bwexford\\b", "wx"},   {"\\bwicklow\\b", "ww"},
    {"\\bireland\\b", "ie"},   {"\\bavenue\\b", "ave"},
    {"\\bcenter\\b", "cntr"},  {"\\bstreet\\b", "st"},
    {"\\bcounty\\b", "co"},    {"\\bcarlow\\b", "cw"},
    {"\\bdublin\\b", "d"},     {"\\bgalway\\b", "g"},
    {"\\blaoise\\b", "ls"},    {"\\boffaly\\b", "oy"},
    {"\\bnorth\\b", "n"},      {"\\bsouth\\b", "s"},
    {"\\bsaint\\b", "st"},     {"\\bcourt\\b", "ct"},
    {"\\bdrive\\b", "dr"},     {"\\bplace\\b", "pl"},
    {"\\bcavan\\b", "cn"},     {"\\bclare\\b", "ce"},
    {"\\bkerry\\b", "ky"},     {"\\blaois\\b", "ls"},
    {"\\blouth\\b", "lh"},     {"\\bmeath\\b", "mh"},
    {"\\bsligo\\b", "so"},     {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},       {"\\blane\\b", "ln"},
    {"\\broad\\b", "rd"},      {"\\bwalk\\b", "wk"},
    {"\\byard\\b", "yd"},      {"\\bcork\\b", "co"},
    {"\\bmayo\\b", "mo"},      {"\\bway\\b", "wy"},
    {"\\bdn\\b", "d"},         {"\\bta\\b", "ty"},
    {"\\bgy\\b", "g"},         {"\\bck\\b", "co"},
};

const Rule kRules_IN[] = {
    {"\\bthiruvananthapuram\\b", "tvpm"},
    {"\\bazimabad\\s+kusumpur\\b", "patna"},
    {"\\btiruvananthapuram\\b", "tvpm"},
    {"\\bjammu\\s+and\\s+kashmir\\b", "j&k"},
    {"\\bchandigarh\\s+city\\b", "ch"},
    {"\\bjammu\\s+\\&\\s+kashmir\\b", "j&k"},
    {"\\bgovt\\s+of\\s+india\\b", "goi"},
    {"\\binternational\\b", "intl"},
    {"\\bvisakhapatnam\\b", "vskp"},
    {"\\bchikmagaluru\\b", "chicmagalur"},
    {"\\bchickmagalur\\b", "chicmagalur"},
    {"\\bpataliputra\\b", "patna"},
    {"\\bchikmagalur\\b", "chicmagalur"},
    {"\\branga\\s+reddy\\b", "rangareddi"},
    {"\\bcross\\-roads\\b", "xrd"},
    {"\\bgovernment\\b", "goi"},
    {"\\buniversity\\b", "uni"},
    {"\\bpatliputra\\b", "patna"},
    {"\\bvijayawada\\b", "bza"},
    {"\\bchandigarh\\b", "ch"},
    {"\\bcross\\-road\\b", "xrd"},
    {"\\bcrossroads\\b", "xrd"},
    {"\\bcrossroad\\b", "xrd"},
    {"\\bbangalore\\b", "blr"},
    {"\\bbengaluru\\b", "blr"},
    {"\\bhyderabad\\b", "hyd"},
    {"\\bahmedabad\\b", "ahd"},
    {"\\bvijaywada\\b", "bza"},
    {"\\bchar\\-rast\\b", "chaurah"},
    {"\\bchaurasta\\b", "chaurah"},
    {"\\bchourasta\\b", "chaurah"},
    {"\\bi\\.n\\.d\\.i\\.a\\b", "in"},
    {"\\bcrossrds\\b", "xrd"},
    {"\\bcalcutta\\b", "kol"},
    {"\\bkolkatta\\b", "kol"},
    {"\\bvaranasi\\b", "benaras"},
    {"\\bjunction\\b", "jn."},
    {"\\bcrossing\\b", "xrd"},
    {"\\bchowrast\\b", "chaurah"},
    {"\\bchourast\\b", "chaurah"},
    {"\\bseventh\\b", "7"},
    {"\\bcollege\\b", "clg"},
    {"\\bgateway\\b", "gtwy"},
    {"\\bheights\\b", "hts"},
    {"\\bcrossrd\\b", "xrd"},
    {"\\bx\\s+roads\\b", "xrd"},
    {"\\bkolkata\\b", "kol"},
    {"\\bkolkota\\b", "kol"},
    {"\\bchennai\\b", "che"},
    {"\\bamdavad\\b", "ahd"},
    {"\\bbanaras\\b", "benaras"},
    {"\\bkeralam\\b", "kl"},
    {"\\bvruttha\\b", "cir."},
    {"\\bsecond\\b", "2"},
    {"\\bfourth\\b", "4"},
    {"\\beighth\\b", "8"},
    {"\\bcentre\\b", "ctr"},
    {"\\bcenter\\b", "ctr"},
    {"\\bforest\\b", "frst"},
    {"\\bgarden\\b", "gdn"},
    {"\\bgatway\\b", "gtwy"},
    {"\\bgatewy\\b", "gtwy"},
    {"\\bheight\\b", "hts"},
    {"\\bx\\s+road\\b", "xrd"},
    {"\\bxroads\\b", "xrd"},
    {"\\bstreet\\b", "st"},
    {"\\braasta\\b", "rasta"},
    {"\\bnumber\\b", "#"},
    {"\\bmumbai\\b", "bom"},
    {"\\bbombay\\b", "bom"},
    {"\\bmadras\\b", "che"},
    {"\\bkerala\\b", "kl"},
    {"\\bchowdi\\b", "chok"},
    {"\\bcircle\\b", "cir."},
    {"\\bkavala\\b", "jn."},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bfirst\\b", "1"},
    {"\\bthird\\b", "3"},
    {"\\bfifth\\b", "5"},
    {"\\bsixth\\b", "6"},
    {"\\bninth\\b", "9"},
    {"\\btenth\\b", "10"},
    {"\\bcnter\\b", "ctr"},
    {"\\bcentr\\b", "ctr"},
    {"\\bgardn\\b", "gdn"},
    {"\\bgrden\\b", "gdn"},
    {"\\bgtway\\b", "gtwy"},
    {"\\bxroad\\b", "xrd"},
    {"\\broute\\b", "rt"},
    {"\\bgalli\\b", "gali"},
    {"\\bpally\\b", "palli"},
    {"\\bdelhi\\b", "del"},
    {"\\bvizag\\b", "vskp"},
    {"\\bj\\s+\\&\\s+k\\b", "j&k"},
    {"\\bchowk\\b", "chok"},
    {"\\bchauk\\b", "chok"},
    {"\\bchouk\\b", "chok"},
    {"\\bround\\b", "cir."},
    {"\\bnaaka\\b", "jn."},
    {"\\bmukku\\b", "jn."},
    {"\\bindia\\b", "in"},
    {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},
    {"\\bcntr\\b", "ctr"},
    {"\\bcent\\b", "ctr"},
    {"\\bgrdn\\b", "gdn"},
    {"\\bhgts\\b", "hts"},
    {"\\bhght\\b", "hts"},
    {"\\buniv\\b", "uni"},
    {"\\bxrds\\b", "xrd"},
    {"\\broad\\b", "rd"},
    {"\\bstr\\.\\b", "st"},
    {"\\bgarh\\b", "gad"},
    {"\\bpeth\\b", "pet"},
    {"\\bj\\s+\\&k\\b", "j&k"},
    {"\\bjct\\.\\b", "jn."},
    {"\\bjnct\\b", "jn."},
    {"\\bx\\-rd\\b", "xrd"},
    {"\\brnd\\.\\b", "cir."},
    {"\\bcen\\b", "ctr"},
    {"\\bst\\.\\b", "st"},
    {"\\bstr\\b", "st"},
    {"\\brte\\b", "rt"},
    {"\\bnum\\b", "#"},
    {"\\bno\\.\\b", "#"},
    {"\\bmum\\b", "bom"},
    {"\\bcha\\b", "ch"},
    {"\\bno\\b", "#"},
};

const Rule kRules_IT[] = {
    {"\\bfriuli\\s+venezia\\s+giulia\\b", "36"},
    {"\\bbarletta\\s+andria\\s+trani\\b", "bt"},
    {"\\bverbano\\s+cusio\\s+ossola\\b", "vb"},
    {"\\btrentino\\s+alto\\s+adige\\b", "32"},
    {"\\bstrada\\s+provinciale\\b", "sp"},
    {"\\btrentino\\s+sudtirol\\b", "32"},
    {"\\bcarbonia\\s+iglesias\\b", "ci"},
    {"\\bventiquattresimo\\b", "24"},
    {"\\bstrada\\s+regionale\\b", "sr"},
    {"\\bquattordicesimo\\b", "14"},
    {"\\bdiciassettesimo\\b", "17"},
    {"\\bventicinquesimo\\b", "25"},
    {"\\bstrada\\s+comunale\\b", "sc"},
    {"\\bmedio\\s+campidano\\b", "vs"},
    {"\\bmonza\\s+e\\s+brianza\\b", "mb"},
    {"\\bpesaro\\s+e\\s+urbino\\b", "pu"},
    {"\\breggio\\s+calabria\\b", "rc"},
    {"\\bdiciannovesimo\\b", "19"},
    {"\\bventisettesimo\\b", "27"},
    {"\\bstrada\\s+statali\\b", "ss"},
    {"\\bemilia\\s+romagna\\b", "45"},
    {"\\bvallee\\s+d\\s+aoste\\b", "23"},
    {"\\bventitreesimo\\b", "23"},
    {"\\bventinovesimo\\b", "29"},
    {"\\bvalle\\s+d\\s+aosta\\b", "23"},
    {"\\bascoli\\s+piceno\\b", "ap"},
    {"\\bcaltanissetta\\b", "cl"},
    {"\\bmassa\\s+carrara\\b", "ms"},
    {"\\breggio\\s+emilia\\b", "re"},
    {"\\bvibo\\s+valentia\\b", "vv"},
    {"\\bventiquattro\\b", "24"},
    {"\\bquindicesimo\\b", "xv"},
    {"\\bdiciottesimo\\b", "18"},
    {"\\bventiduesimo\\b", "22"},
    {"\\bventottesimo\\b", "28"},
    {"\\bforli\\s+cesena\\b", "fc"},
    {"\\bolbia\\s+tempio\\b", "ot"},
    {"\\bquattordici\\b", "14"},
    {"\\bdiciassette\\b", "17"},
    {"\\bventicinque\\b", "25"},
    {"\\btredicesimo\\b", "13"},
    {"\\bventunesimo\\b", "21"},
    {"\\bventisesimo\\b", "26"},
    {"\\bvalle\\s+aosta\\b", "23"},
    {"\\balessandria\\b", ""},
    {"\\bdiciannove\\b", "19"},
    {"\\bventisette\\b", "27"},
    {"\\bundicesimo\\b", "xi"},
    {"\\bdodicesimo\\b", "12"},
    {"\\bsedicesimo\\b", "16"},
    {"\\btrentesimo\\b", "30"},
    {"\\breggimento\\b", "rgt"},
    {"\\bbasilicata\\b", "77"},
    {"\\bcampobasso\\b", "cb"},
    {"\\bventinove\\b", "29"},
    {"\\bventesimo\\b", "20"},
    {"\\blombardia\\b", "25"},
    {"\\bagrigento\\b", "ag"},
    {"\\bbenevento\\b", "bn"},
    {"\\bcatanzaro\\b", "cz"},
    {"\\bfrosinone\\b", "fr"},
    {"\\bla\\s+spezia\\b", "sp"},
    {"\\bogliastra\\b", "og"},
    {"\\bpordenone\\b", "pn"},
    {"\\bquindici\\b", "xv"},
    {"\\bdiciotto\\b", "18"},
    {"\\bventidue\\b", "22"},
    {"\\bventitre\\b", "23"},
    {"\\bventisei\\b", "26"},
    {"\\bventotto\\b", "28"},
    {"\\btraversa\\b", "trav"},
    {"\\bcalabria\\b", "78"},
    {"\\bcampania\\b", "72"},
    {"\\bpiemonte\\b", "21"},
    {"\\bsardegna\\b", "88"},
    {"\\bavellino\\b", "av"},
    {"\\bbrindisi\\b", "br"},
    {"\\bcagliari\\b", "ca"},
    {"\\bgrosseto\\b", "gr"},
    {"\\bl\\s+aquila\\b", "aq"},
    {"\\bmacerata\\b", "mc"},
    {"\\boristano\\b", "or"},
    {"\\bpiacenza\\b", "pc"},
    {"\\bsiracusa\\b", "sr"},
    {"\\bvercelli\\b", "vc"},
    {"\\bquattro\\b", "4"},
    {"\\btredici\\b", "13"},
    {"\\bventuno\\b", "21"},
    {"\\bsecondo\\b", "2"},
    {"\\bsettimo\\b", "7"},
    {"\\babruzzo\\b", "65"},
    {"\\bliguria\\b", "42"},
    {"\\bsicilia\\b", "82"},
    {"\\btoscana\\b", "52"},
    {"\\bbelluno\\b", "bl"},
    {"\\bbergamo\\b", "bg"},
    {"\\bbologna\\b", "bo"},
    {"\\bbolzano\\b", "bz"},
    {"\\bbrescia\\b", "bs"},
    {"\\bcaserta\\b", "ce"},
    {"\\bcatania\\b", "ct"},
    {"\\bcosenza\\b", "cs"},
    {"\\bcremona\\b", "cr"},
    {"\\bcrotone\\b", "kr"},
    {"\\bferrara\\b", "fe"},
    {"\\bfirenze\\b", "fi"},
    {"\\bgorizia\\b", "go"},
    {"\\bimperia\\b", "im"},
    {"\\bisernia\\b", "is"},
    {"\\blivorno\\b", "li"},
    {"\\bmantova\\b", "mn"},
    {"\\bmessina\\b", "me"},
    {"\\bpalermo\\b", "pa"},
    {"\\bperugia\\b", "pg"},
    {"\\bpescara\\b", "pe"},
    {"\\bpistoia\\b", "pt"},
    {"\\bpotenza\\b", "pz"},
    {"\\bravenna\\b", "ra"},
    {"\\bsalerno\\b", "sa"},
    {"\\bsassari\\b", "ss"},
    {"\\bsondrio\\b", "so"},
    {"\\btaranto\\b", "ta"},
    {"\\btrapani\\b", "tp"},
    {"\\btreviso\\b", "tv"},
    {"\\btrieste\\b", "ts"},
    {"\\bvenezia\\b", "ve"},
    {"\\bvicenza\\b", "6"},
    {"\\bviterbo\\b", "vt"},
    {"\\bxxviii\\b", "28"},
    {"\\bcinque\\b", "5"},
    {"\\bundici\\b", "xi"},
    {"\\bdodici\\b", "12"},
    {"\\bsedici\\b", "16"},
    {"\\btrenta\\b", "30"},
    {"\\bquarto\\b", "4"},
    {"\\bquinto\\b", "5"},
    {"\\bottavo\\b", "8"},
    {"\\bdecimo\\b", "x"},
    {"\\bmarche\\b", "57"},
    {"\\bmolise\\b", "67"},
    {"\\bpuglia\\b", "75"},
    {"\\bumbria\\b", "55"},
    {"\\bveneto\\b", "34"},
    {"\\bancona\\b", "an"},
    {"\\barezzo\\b", "ar"},
    {"\\bbiella\\b", "bi"},
    {"\\bchieti\\b", "ch"},
    {"\\bfoggia\\b", "fg"},
    {"\\bgenova\\b", "ge"},
    {"\\blatina\\b", "lt"},
    {"\\bmatera\\b", "mt"},
    {"\\bmilano\\b", "mi"},
    {"\\bmodena\\b", "mo"},
    {"\\bnapoli\\b", "na"},
    {"\\bnovara\\b", "no"},
    {"\\bpadova\\b", "pd"},
    {"\\bragusa\\b", "rg"},
    {"\\brimini\\b", "rn"},
    {"\\brovigo\\b", "ro"},
    {"\\bsavona\\b", "sv"},
    {"\\bteramo\\b", "te"},
    {"\\btorino\\b", "to"},
    {"\\btrento\\b", "tn"},
    {"\\bvarese\\b", "va"},
    {"\\bverona\\b", "vr"},
    {"\\bitalia\\b", "it"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bovest\\b", "o"},
    {"\\bxviii\\b", "18"},
    {"\\bxxiii\\b", "23"},
    {"\\bxxvii\\b", "27"},
    {"\\bsette\\b", "7"},
    {"\\bdieci\\b", "x"},
    {"\\bventi\\b", "20"},
    {"\\bprimo\\b", ""},
    {"\\bterzo\\b", "3"},
    {"\\bsesto\\b", "6"},
    {"\\bdallo\\b", ""},
    {"\\bdello\\b", ""},
    {"\\bnello\\b", ""},
    {"\\bsullo\\b", ""},
    {"\\bdagli\\b", ""},
    {"\\bdegli\\b", ""},
    {"\\bnegli\\b", ""},
    {"\\bsugli\\b", ""},
    {"\\bdalla\\b", ""},
    {"\\bdella\\b", ""},
    {"\\bnella\\b", ""},
    {"\\bsulla\\b", ""},
    {"\\bdalle\\b", ""},
    {"\\bdelle\\b", ""},
    {"\\bnelle\\b", ""},
    {"\\bsulle\\b", ""},
    {"\\blazio\\b", "62"},
    {"\\baosta\\b", "ao"},
    {"\\baoste\\b", "ao"},
    {"\\bbozen\\b", "bz"},
    {"\\bcuneo\\b", "cn"},
    {"\\bfermo\\b", "fm"},
    {"\\blecce\\b", ""},
    {"\\blecco\\b", "lc"},
    {"\\blucca\\b", "lu"},
    {"\\bnuoro\\b", "nu"},
    {"\\bparma\\b", "pr"},
    {"\\bpavia\\b", "pv"},
    {"\\bprato\\b", "po"},
    {"\\brieti\\b", "ri"},
    {"\\bsiena\\b", "si"},
    {"\\bterni\\b", "tr"},
    {"\\budine\\b", "ud"},
    {"\\bitaly\\b", "it"},
    {"\\bnord\\b", "n"},
    {"\\beast\\b", "e"},
    {"\\bwest\\b", "o"},
    {"\\bviii\\b", "8"},
    {"\\bxiii\\b", "13"},
    {"\\bxvii\\b", "17"},
    {"\\bxxii\\b", "22"},
    {"\\bxxiv\\b", "24"},
    {"\\bxxvi\\b", "26"},
    {"\\bxxix\\b", "29"},
    {"\\botto\\b", "8"},
    {"\\bnove\\b", "9"},
    {"\\bnono\\b", "9"},
    {"\\ballo\\b", ""},
    {"\\bdall\\b", ""},
    {"\\bdell\\b", ""},
    {"\\bnell\\b", ""},
    {"\\bsull\\b", ""},
    {"\\bagli\\b", ""},
    {"\\balla\\b", ""},
    {"\\balle\\b", ""},
    {"\\basti\\b", "at"},
    {"\\bbari\\b", "ba"},
    {"\\bcomo\\b", "co"},
    {"\\benna\\b", ""},
    {"\\blodi\\b", ""},
    {"\\bpisa\\b", "pi"},
    {"\\broma\\b", "rm"},
    {"\\bsud\\b", "s"},
    {"\\best\\b", "e"},
    {"\\biii\\b", "3"},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\bxvi\\b", "16"},
    {"\\bxix\\b", "19"},
    {"\\bxxi\\b", "21"},
    {"\\bxxv\\b", "25"},
    {"\\bxxx\\b", "30"},
    {"\\buno\\b", ""},
    {"\\bdue\\b", "2"},
    {"\\btre\\b", "3"},
    {"\\bsei\\b", "6"},
    {"\\bdal\\b", ""},
    {"\\bdel\\b", ""},
    {"\\bnel\\b", ""},
    {"\\bsul\\b", ""},
    {"\\ball\\b", ""},
    {"\\bdai\\b", ""},
    {"\\bdei\\b", ""},
    {"\\bnei\\b", ""},
    {"\\bsui\\b", ""},
    {"\\bgli\\b", ""},
    {"\\bles\\b", ""},
    {"\\bii\\b", "2"},
    {"\\biv\\b", "4"},
    {"\\bvi\\b", "6"},
    {"\\bix\\b", "9"},
    {"\\b10\\b", "x"},
    {"\\b11\\b", "xi"},
    {"\\b15\\b", "xv"},
    {"\\bxx\\b", "20"},
    {"\\bda\\b", ""},
    {"\\bdi\\b", ""},
    {"\\bin\\b", ""},
    {"\\bsu\\b", ""},
    {"\\bal\\b", ""},
    {"\\bai\\b", ""},
    {"\\bil\\b", ""},
    {"\\blo\\b", ""},
    {"\\bla\\b", ""},
    {"\\ble\\b", ""},
    {"\\ben\\b", ""},
    {"\\bw\\b", "o"},
    {"\\bi\\b", ""},
    {"\\bv\\b", "5"},
    {"\\ba\\b", ""},
    {"\\bd\\b", ""},
    {"\\bl\\b", ""},
};

const Rule kRules_LU[] = {
    {"\\berpeldange\\s+\\-\\s+lez\\s+\\-\\s+bous\\b", "erpeldange"},
    {"\\bhostert\\s+niederanven\\b", "hostert"},
    {"\\bgoebelsmuehle\\b", "goebelsmuhle"},
    {"\\bbuederscheid\\b", "buderscheid"},
    {"\\bschwebsingen\\b", "schwebsange"},
    {"\\brammeldange\\b", "rameldange"},
    {"\\blexembourg\\b", "lu"},
    {"\\bcul\\-de\\-sac\\b", "cds"},
    {"\\bcul\\s+de\\s+sac\\b", "cds"},
    {"\\brond\\-point\\b", "rdpt"},
    {"\\bgeyershaff\\b", "geyershof"},
    {"\\bluxembourg\\b", "lu"},
    {"\\bluxemburg\\b", "lu"},
    {"\\bboulevard\\b", "boul"},
    {"\\bcarrefour\\b", "carref"},
    {"\\bcroissant\\b", "crois"},
    {"\\bdiversion\\b", "divers"},
    {"\\bechangeur\\b", "ech"},
    {"\\besplanade\\b", "esp"},
    {"\\bpromenade\\b", "prom"},
    {"\\bterrasse\\b", "tsse"},
    {"\\bcapellen\\b", "cap"},
    {"\\bstrasse\\b", "str"},
    {"\\bcircuit\\b", "circt"},
    {"\\bimpasse\\b", "imp"},
    {"\\bplateau\\b", "plat"},
    {"\\bsentier\\b", "sent"},
    {"\\bavenue\\b", "av"},
    {"\\bcentre\\b", "c"},
    {"\\bcenter\\b", "c"},
    {"\\bchemin\\b", "ch"},
    {"\\bpointe\\b", "pte"},
    {"\\bruelle\\b", "rle"},
    {"\\bcarre\\b", "car"},
    {"\\bcourt\\b", "crt"},
    {"\\bdrive\\b", "dr"},
    {"\\bpoint\\b", "pt"},
    {"\\broute\\b", "rte"},
    {"\\bespl\\b", "esp"},
    {"\\bave\\b", "av"},
    {"\\bctr\\b", "c"},
    {"\\brue\\b", "r"},
    {"\\bdes\\b", ""},
    {"\\blux\\b", "lu"},
    {"\\bde\\b", ""},
    {"\\bdu\\b", ""},
    {"\\bd\\b", ""},
};

const Rule kRules_MX[] = {
    {"\\bcoahuila\\s+de\\s+zaragoza\\b", "coahuila"},
    {"\\bbaja\\s+california\\s+sur\\b", "b c s"},
    {"\\bestado\\s+de\\s+mexico\\b", "me"},
    {"\\bbaja\\s+california\\b", "b c"},
    {"\\baguascalientes\\b", "ag"},
    {"\\bveracruz\\s+llave\\b", "veracruz"},
    {"\\bprolongacion\\b", "prol"},
    {"\\bquintana\\s+roo\\b", "qr"},
    {"\\bdiecisiete\\b", "17"},
    {"\\bdiecinueve\\b", "19"},
    {"\\bgobernador\\b", "gob"},
    {"\\blicenciado\\b", "lic"},
    {"\\bpresbitero\\b", "pbro"},
    {"\\bsan\\s+isidro\\b", "s isidro"},
    {"\\bseptiembre\\b", "sept"},
    {"\\bguanajuato\\b", "gt"},
    {"\\bdieciseis\\b", "16"},
    {"\\bdieciocho\\b", "18"},
    {"\\bfrancisco\\b", "fco"},
    {"\\bingeniero\\b", "ing"},
    {"\\brepublica\\b", "rep"},
    {"\\bponiente\\b", "pte"},
    {"\\bprofesor\\b", "prof"},
    {"\\barticulo\\b", "art"},
    {"\\bhacienda\\b", "hda"},
    {"\\bsan\\s+juan\\b", "s juan"},
    {"\\bguerrero\\b", "gr"},
    {"\\boriente\\b", "ote"},
    {"\\bprimera\\b", "1a"},
    {"\\bsegunda\\b", "2a"},
    {"\\btercera\\b", "3a"},
    {"\\bseptima\\b", "7a"},
    {"\\bcatorce\\b", "14"},
    {"\\bcaptain\\b", "cap"},
    {"\\bgeneral\\b", "gral"},
    {"\\bfebrero\\b", "feb"},
    {"\\bprivada\\b", "priv"},
    {"\\bavenida\\b", "av"},
    {"\\bhidalgo\\b", "hg"},
    {"\\bjalisco\\b", "ja"},
    {"\\bsinaloa\\b", "si"},
    {"\\bcuarta\\b", "4a"},
    {"\\bquinta\\b", "5a"},
    {"\\boctava\\b", "8a"},
    {"\\bcuatro\\b", "4"},
    {"\\bquince\\b", "15"},
    {"\\bveinte\\b", "20"},
    {"\\bdoctor\\b", "dr"},
    {"\\bciudad\\b", "cd"},
    {"\\bpuerto\\b", "pto"},
    {"\\bmexico\\b", "me"},
    {"\\bmx\\s+mex\\b", "me"},
    {"\\boaxaca\\b", "oa"},
    {"\\bpuebla\\b", "pu"},
    {"\\bnorte\\b", "nte"},
    {"\\boeste\\b", "pte"},
    {"\\bsexta\\b", "6a"},
    {"\\bcinco\\b", "5"},
    {"\\bsiete\\b", "7"},
    {"\\bnueve\\b", "9"},
    {"\\btrece\\b", "13"},
    {"\\bmaria\\b", "ma"},
    {"\\bsanta\\b", "sta"},
    {"\\bq\\s+roo\\b", "qr"},
    {"\\beste\\b", "ote"},
    {"\\btres\\b", "3"},
    {"\\bseis\\b", "6"},
    {"\\bocho\\b", "8"},
    {"\\bdiez\\b", "10"},
    {"\\bonce\\b", "11"},
    {"\\bdoce\\b", "12"},
    {"\\buno\\b", "1"},
    {"\\bdos\\b", "2"},
    {"\\blos\\b", ""},
    {"\\blas\\b", ""},
    {"\\bdel\\b", ""},
    {"\\bags\\b", "ag"},
    {"\\bq\\s+r\\b", "qr"},
    {"\\ble\\b", ""},
    {"\\bel\\b", ""},
    {"\\bde\\b", ""},
    {"\\bmx\\b", "me"},
};

const Rule kRules_MY[] = {
    {"\\bmalaysia\\b", "my"},
};

const Rule kRules_NL[] = {
    {"\\bwesterhaar\\s+vriezenveensewijk\\b", "westerhaar-vriezenv wijk"},
    {"\\bnoord\\-brabant\\b", "nb"},
    {"\\bnoord\\-holland\\b", "nh"},
    {"\\bnoord\\s+brabant\\b", "nb"},
    {"\\bnoord\\s+holland\\b", "nh"},
    {"\\bburgemeester\\b", "burg"},
    {"\\bs\\s+gravenhage\\b", "sgravenhage"},
    {"\\balphen\\s+chaam\\b", "ac"},
    {"\\bnoordbrabant\\b", "nb"},
    {"\\bzuid\\-holland\\b", "zh"},
    {"\\bzuid\\s+holland\\b", "zh"},
    {"\\bmonseigneur\\b", "mgr"},
    {"\\bnordholland\\b", "nh"},
    {"\\bzuidholland\\b", "zh"},
    {"\\bnetherlands\\b", "nl"},
    {"\\bnoordzijde\\b", "nz"},
    {"\\bgelderland\\b", "ge"},
    {"\\boverijssel\\b", "ov"},
    {"\\bprofessor\\b", "prof"},
    {"\\bzuidzijde\\b", "zz"},
    {"\\boostzijde\\b", "oz"},
    {"\\bwestzijde\\b", "wz"},
    {"\\brotterdam\\b", "rt"},
    {"\\bflevoland\\b", "fl"},
    {"\\bfriesland\\b", "fr"},
    {"\\bgroningen\\b", "gr"},
    {"\\bnederland\\b", "nl"},
    {"\\bdominee\\b", "ds"},
    {"\\bmeester\\b", "mr"},
    {"\\bzevende\\b", "7"},
    {"\\bachtste\\b", "8"},
    {"\\bnegende\\b", "9"},
    {"\\baan\\s+den\\b", "ad"},
    {"\\bdrenthe\\b", "dr"},
    {"\\blimburg\\b", "l"},
    {"\\butrecht\\b", "u"},
    {"\\bzeeland\\b", "z"},
    {"\\bdoctor\\b", "dr"},
    {"\\beerste\\b", "1"},
    {"\\btweede\\b", "2"},
    {"\\bvierde\\b", "4"},
    {"\\bvijfde\\b", "5"},
    {"\\bstraat\\b", "str"},
    {"\\baan\\s+de\\b", "ad"},
    {"\\bderde\\b", "3"},
    {"\\bzesde\\b", "6"},
    {"\\bnl\\-dr\\b", "dr"},
    {"\\bnl\\-fl\\b", "fl"},
    {"\\bnl\\-fr\\b", "fr"},
    {"\\bnl\\-ge\\b", "ge"},
    {"\\bnl\\-gr\\b", "gr"},
    {"\\bnl\\-li\\b", "l"},
    {"\\bnl\\-nb\\b", "nb"},
    {"\\bnl\\-nh\\b", "nh"},
    {"\\bnl\\-ov\\b", "ov"},
    {"\\bnl\\-zh\\b", "zh"},
    {"\\bnl\\-ut\\b", "u"},
    {"\\bnl\\-ze\\b", "z"},
    {"\\bsint\\b", "st"},
    {"\\bn\\s+z\\b", "nz"},
    {"\\bz\\s+z\\b", "zz"},
    {"\\bo\\s+z\\b", "oz"},
    {"\\bw\\s+z\\b", "wz"},
    {"\\ba\\s+d\\b", "ad"},
    {"\\bgld\\b", "ge"},
    {"\\bzld\\b", "z"},
    {"\\bgl\\b", "ge"},
    {"\\bgn\\b", "gr"},
    {"\\bli\\b", "l"},
    {"\\blb\\b", "l"},
    {"\\but\\b", "u"},
    {"\\bze\\b", "z"},
    {"\\bzl\\b", "z"},
    {"\\b\\#\\b", ""},
};

const Rule kRules_NZ[] = {
    {"\\brural\\s+delivery\\b", ""},
    {"\\bocean\\s+beach\\b", "oceanbeach"},
    {"\\blong\\s+beach\\b", "longbeach"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bcrescent\\b", "cres"},
    {"\\bhighway\\b", "hwy"},
    {"\\bparkway\\b", "pkwy"},
    {"\\bheights\\b", "hts"},
    {"\\bavenue\\b", "ave"},
    {"\\bstreet\\b", "st"},
    {"\\bparade\\b", "pde"},
    {"\\bcommon\\b", "comm"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bmount\\b", "mt"},
    {"\\bsaint\\b", "st"},
    {"\\bpoint\\b", "pt"},
    {"\\bcourt\\b", "ct"},
    {"\\bplace\\b", "pl"},
    {"\\bdrive\\b", "dr"},
    {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},
    {"\\broad\\b", "rd"},
    {"\\blane\\b", "ln"},
    {"\\bn\\.z\\.\\b", "nz"},
    {"\\bnth\\b", "n"},
    {"\\bsth\\b", "s"},
    {"\\bmt\\.\\b", "mt"},
    {"\\bst\\.\\b", "st"},
    {"\\bpt\\.\\b", "pt"},
    {"\\bn\\.z\\b", "nz"},
    {"\\bn\\.\\b", "n"},
    {"\\bs\\.\\b", "s"},
    {"\\be\\.\\b", "e"},
    {"\\bw\\.\\b", "w"},
};

const Rule kRules_PE[] = {
    {"\\bavenida\\b", "av"}, {"\\bperu\\b", "pe"}, {"\\blos\\b", ""},
    {"\\blas\\b", ""},       {"\\bdel\\b", ""},    {"\\ble\\b", ""},
    {"\\bel\\b", ""},        {"\\bde\\b", ""},
};

const Rule kRules_PH[] = {
    {"\\bphilippines\\b", "ph"}, {"\\bboulevard\\b", "blvd"},
    {"\\bcaptain\\b", "cap"},    {"\\bgeneral\\b", "gen"},
    {"\\bstreet\\b", "st"},      {"\\bavenue\\b", "av"},
    {"\\bdoctor\\b", "dr"},      {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},        {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},         {"\\broad\\b", "rd"},
    {"\\bave\\b", "av"},
};

const Rule kRules_PL[] = {
    {"\\bkuyavian\\s+pomeranian\\b", "kp"},
    {"\\bzachodniopomorskie\\b", "zp"},
    {"\\bwarmian\\s+masurian\\b", "wn"},
    {"\\bwest\\s+pomeranian\\b", "zp"},
    {"\\bgreater\\s+poland\\b", "wp"},
    {"\\blower\\s+silesian\\b", "ds"},
    {"\\bswietokrzyskie\\b", "sk"},
    {"\\blesser\\s+poland\\b", "mp"},
    {"\\bsubcarpathian\\b", "pk"},
    {"\\bwielkopolskie\\b", "wp"},
    {"\\bdolnoslaskie\\b", "ds"},
    {"\\bpodkarpackie\\b", "pk"},
    {"\\bmalopolskie\\b", "mp"},
    {"\\bmazowieckie\\b", "ma"},
    {"\\bpomeranian\\b", "pm"},
    {"\\bmarszalek\\b", "marsz"},
    {"\\bpodlaskie\\b", "pd"},
    {"\\blubelskie\\b", "lu"},
    {"\\bpomorskie\\b", "pm"},
    {"\\bwarminsko\\b", "wn"},
    {"\\bpoludnie\\b", "south"},
    {"\\bwschodni\\b", "w"},
    {"\\bzachodni\\b", "z"},
    {"\\bmasovian\\b", "ma"},
    {"\\bsilesian\\b", "sl"},
    {"\\bkujawsko\\b", "kp"},
    {"\\blubuskie\\b", "lb"},
    {"\\bopolskie\\b", "op"},
    {"\\bosiedle\\b", "os"},
    {"\\bsilesia\\b", "sl"},
    {"\\blodzkie\\b", "ld"},
    {"\\bslaskie\\b", "sl"},
    {"\\bpolnoc\\b", "north"},
    {"\\bwschod\\b", "w"},
    {"\\bzachod\\b", "z"},
    {"\\blublin\\b", "lu"},
    {"\\blubusz\\b", "lb"},
    {"\\bpoland\\b", "pl"},
    {"\\bopole\\b", "op"},
    {"\\beast\\b", "w"},
    {"\\bwest\\b", "z"},
    {"\\blodz\\b", "ld"},
    {"\\bwlkp\\b", "wp"},
};

const Rule kRules_PR[] = {
    {"\\bsan\\s+juan\\s+antiguo\\b", "old san juan"},
    {"\\bpuerto\\s+rico\\b", "pr"},
    {"\\bcarretera\\b", "carr"},
    {"\\bmal\\s+paso\\b", "malpaso"},
    {"\\bavenida\\b", "av"},
    {"\\bbulevar\\b", "blvd"},
    {"\\bcamino\\b", "cm"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bsaint\\b", "st"},
    {"\\bcalle\\b", "cll"},
    {"\\bplaza\\b", "plz"},
    {"\\bpaseo\\b", "pso"},
    {"\\bcourt\\b", "ct"},
    {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},
    {"\\bave\\.\\b", "av"},
    {"\\blane\\b", "ln"},
    {"\\broad\\b", "rd"},
    {"\\bp\\.r\\.\\b", "pr"},
    {"\\bnth\\b", "n"},
    {"\\bsth\\b", "s"},
    {"\\bst\\.\\b", "st"},
    {"\\bave\\b", "av"},
    {"\\bcam\\b", "cm"},
    {"\\bp\\.r\\b", "pr"},
    {"\\bn\\.\\b", "n"},
    {"\\bs\\.\\b", "s"},
    {"\\be\\.\\b", "e"},
    {"\\bw\\.\\b", "w"},
};

const Rule kRules_PT[] = {
    {"\\bestrada\\s+nacional\\b", "n"},
    {"\\bviana\\s+do\\s+castelo\\b", "18"},
    {"\\bcastelo\\s+branco\\b", "09"},
    {"\\bportalegre\\b", "08"},
    {"\\bvila\\s+real\\b", "15"},
    {"\\bbraganca\\b", "14"},
    {"\\bsantarem\\b", "03"},
    {"\\bportugal\\b", "pt"},
    {"\\bcoimbra\\b", "11"},
    {"\\bsetubal\\b", "04"},
    {"\\bdoctor\\b", "dr"},
    {"\\bdoutor\\b", "dr"},
    {"\\baveiro\\b", "12"},
    {"\\bguarda\\b", "10"},
    {"\\bleiria\\b", "02"},
    {"\\blisbon\\b", "01"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bbraga\\b", "17"},
    {"\\bevora\\b", "07"},
    {"\\bporto\\b", "16"},
    {"\\bviseu\\b", "13"},
    {"\\bwest\\b", "w"},
    {"\\bbeja\\b", "05"},
    {"\\bfaro\\b", "06"},
    {"\\bsao\\b", "s"},
    {"\\bdos\\b", ""},
    {"\\bdas\\b", ""},
    {"\\bdo\\b", ""},
    {"\\bde\\b", ""},
    {"\\bda\\b", ""},
    {"\\ben\\b", "n"},
    {"\\bem\\b", "m"},
    {"\\be\\b", ""},
};

const Rule kRules_RO[] = {
    {"\\bromania\\b", "ro"},
};

const Rule kRules_RU[] = {
    {"\\bнабережная\\b", "наб"}, {"\\bтерритория\\b", "тер"},
    {"\\bавтодорога\\b", "а/д"}, {"\\bпереулок\\b", "пер"},
    {"\\bпроспект\\b", "пр"},    {"\\bбульвар\\b", "б-р"},
    {"\\bквартал\\b", "кв-л"},   {"\\bплощадь\\b", "пл"},
    {"\\bроссия\\b", "ru"},      {"\\brussia\\b", "ru"},
    {"\\bпроезд\\b", "пр-д"},    {"\\bдорога\\b", "дор"},
    {"\\bшоссе\\b", "ш"},        {"\\bлиния\\b", "лин"},
    {"\\bулица\\b", "ул"},       {"\\bбульв\\b", "б-р"},
    {"\\bпросп\\b", "пр"},       {"\\bпр\\-кт\\b", "пр"},
    {"\\bтупик\\b", "туп"},      {"\\bпрот\\b", "пр"},
    {"\\bбул\\b", "б-р"},
};

const Rule kRules_SE[] = {
    {"\\bvastra\\s+goetalands\\b", "o"},
    {"\\bvastra\\s+goetaland\\b", "o"},
    {"\\bvasternorrlands\\b", "y"},
    {"\\boestergoetlands\\b", "e"},
    {"\\bvasternorrland\\b", "y"},
    {"\\boestergoetland\\b", "e"},
    {"\\bvastergoetland\\b", "e"},
    {"\\bsodermanlands\\b", "d"},
    {"\\bvasterbottens\\b", "ac"},
    {"\\bjoenkoepings\\b", "f"},
    {"\\bsodermanland\\b", "d"},
    {"\\bvasterbotten\\b", "ac"},
    {"\\bvastmanlands\\b", "u"},
    {"\\bjoenkoeping\\b", "f"},
    {"\\bnorrbottens\\b", "bd"},
    {"\\bvastmanland\\b", "u"},
    {"\\bgavleborgs\\b", "x"},
    {"\\bkronobergs\\b", "g"},
    {"\\bnorrbotten\\b", "bd"},
    {"\\bstockholms\\b", "ab"},
    {"\\bgavleborg\\b", "x"},
    {"\\bjamtlands\\b", "z"},
    {"\\bkronoberg\\b", "g"},
    {"\\bstockholm\\b", "ab"},
    {"\\bvarmlands\\b", "s"},
    {"\\bblekinge\\b", "k"},
    {"\\bdalarnas\\b", "w"},
    {"\\bgotlands\\b", "i"},
    {"\\bhallands\\b", "n"},
    {"\\bjamtland\\b", "z"},
    {"\\bvarmland\\b", "s"},
    {"\\boerebros\\b", "t"},
    {"\\bdalarna\\b", "w"},
    {"\\bgotland\\b", "i"},
    {"\\bhalland\\b", "n"},
    {"\\buppsala\\b", "c"},
    {"\\boerebro\\b", "t"},
    {"\\bsverige\\b", "se"},
    {"\\bsoeder\\b", "s"},
    {"\\bkalmar\\b", "h"},
    {"\\bsweden\\b", "se"},
    {"\\bskane\\b", "m"},
    {"\\bnorr\\b", "n"},
    {"\\boest\\b", "o"},
    {"\\bvast\\b", "v"},
};

const Rule kRules_TH[] = {
    {"\\bประเทศไทย\\b", "th"},
    {"\\bthailand\\b", "th"},
};

const Rule kRules_TR[] = {
    {"\\bturkiye\\b", "tr"},
    {"\\bturkey\\b", "tr"},
};

const Rule kRules_US[] = {
    {"\\bjoint\\s+base\\s+elmendorf\\s+richardson\\b", "jber"},
    {"\\bwashington\\s+district\\s+of\\s+columbia\\b", "dc"},
    {"\\bjoint\\s+base\\s+pearl\\s+harbor\\s+hickam\\b", "jbphh"},
    {"\\bfederated\\s+states\\s+of\\s+micronesia\\b", "fm"},
    {"\\bnational\\s+forest\\s+development\\b", "nat for dev"},
    {"\\bmartin\\s+luther\\s+king\\s+junior\\b", "mlk"},
    {"\\bnational\\s+for\\s+development\\b", "nat for dev"},
    {"\\bmarine\\s+corps\\s+base\\s+hawaii\\b", "mcbh kanehoe bay"},
    {"\\bnorthern\\s+mariana\\s+islands\\b", "mp"},
    {"\\barmed\\s+forces\\s+middle\\s+east\\b", "ae"},
    {"\\bunited\\s+states\\s+of\\s+america\\b", "us"},
    {"\\bnat\\s+forest\\s+development\\b", "nat for dev"},
    {"\\bmartin\\s+luther\\s+king\\s+jnr\\b", "mlk"},
    {"\\bmartin\\s+luther\\s+king\\s+jr\\b", "mlk"},
    {"\\barmed\\s+forces\\s+americas\\b", "aa"},
    {"\\bdistrict\\s+of\\s+columbia\\b", "dc"},
    {"\\barmed\\s+forces\\s+pacific\\b", "ap"},
    {"\\bnat\\s+for\\s+development\\b", "nat for dev"},
    {"\\bnational\\s+forest\\s+dev\\b", "nat for dev"},
    {"\\barmed\\s+forces\\s+africa\\b", "ae"},
    {"\\barmed\\s+forces\\s+canada\\b", "ae"},
    {"\\barmed\\s+forces\\s+europe\\b", "ae"},
    {"\\bmartin\\s+luther\\s+king\\b", "mlk"},
    {"\\bjoint\\s+reserve\\s+base\\b", "jrb"},
    {"\\blincolns\\s+new\\s+salem\\b", "lincoln nw sl"},
    {"\\bmetropolitan\\s+area\\b", ""},
    {"\\bnational\\s+monument\\b", "national mo"},
    {"\\bnational\\s+for\\s+dev\\b", "nat for dev"},
    {"\\bfrancis\\s+e\\s+warren\\b", "fe warren"},
    {"\\bcolorado\\s+springs\\b", "co spgs"},
    {"\\bdist\\s+of\\s+columbia\\b", "dc"},
    {"\\bwashington\\s+state\\b", "wa"},
    {"\\bmarshall\\s+islands\\b", "mh"},
    {"\\bcharlottesville\\b", "charlottesvle"},
    {"\\badministration\\b", "admn"},
    {"\\bfarm\\s+to\\s+market\\b", "fm"},
    {"\\bnat\\s+forest\\s+dev\\b", "nat for dev"},
    {"\\bforest\\s+service\\b", "frst srvc"},
    {"\\bjohn\\s+f\\s+kennedy\\b", "jfk"},
    {"\\bair\\s+force\\s+base\\b", "afb"},
    {"\\bbradford\\s+woods\\b", "bradfordwoods"},
    {"\\bcrawfordsville\\b", "crawfordsvlle"},
    {"\\bfredericksburg\\b", "fredericksbrg"},
    {"\\bhendersonville\\b", "hendersonvlle"},
    {"\\bjeffersonville\\b", "jeffersonvlle"},
    {"\\bmechanicsville\\b", "mechanicsvlle"},
    {"\\bnorthumberland\\b", "northumberlnd"},
    {"\\bsalt\\s+lake\\s+city\\b", "slc"},
    {"\\bchristiansberg\\b", "christiansbrg"},
    {"\\blittle\\s+diomede\\b", "diomede"},
    {"\\bwashington\\s+d\\s+c\\b", "dc"},
    {"\\bnew\\s+york\\s+state\\b", "ny"},
    {"\\bnorth\\s+carolina\\b", "nc"},
    {"\\bsouth\\s+carolina\\b", "sc"},
    {"\\bvirgin\\s+islands\\b", "vi"},
    {"\\bamerican\\s+samoa\\b", "as"},
    {"\\binternational\\b", "intl"},
    {"\\barmy\\s+airfield\\b", "army af"},
    {"\\bnew\\s+york\\s+city\\b", "ny"},
    {"\\bjf\\s+kennedy\\s+ap\\b", "jfk airport"},
    {"\\bnational\\s+park\\b", "ntpk"},
    {"\\bwashington\\s+dc\\b", "dc"},
    {"\\bnew\\s+hampshire\\b", "nh"},
    {"\\bwest\\s+virginia\\b", "wv"},
    {"\\bmassachusetts\\b", "ma"},
    {"\\bunited\\s+states\\b", "us"},
    {"\\bfrst\\s+service\\b", "frst srvc"},
    {"\\bservice\\s+road\\b", "service rd"},
    {"\\bbristle\\s+cone\\b", "bristlecone"},
    {"\\bswan\\s+quarter\\b", "swanquarter"},
    {"\\bminers\\s+mills\\b", "miners mill"},
    {"\\bnorth\\s+dakota\\b", "nd"},
    {"\\brhode\\s+island\\b", "ri"},
    {"\\bsouth\\s+dakota\\b", "sd"},
    {"\\bpennsylvania\\b", "pa"},
    {"\\brural\\s+route\\b", "rr"},
    {"\\bforest\\s+srvc\\b", "frst srvc"},
    {"\\bbloomington\\b", "blmngtn"},
    {"\\bfrenchville\\b", "frnchvl"},
    {"\\bgood\\s+fellow\\b", "goodfellow"},
    {"\\bclutch\\s+city\\b", "houston"},
    {"\\blos\\s+angeles\\b", "la"},
    {"\\bloxahatchee\\b", "lox"},
    {"\\bobservatory\\b", "obs"},
    {"\\bspringfield\\b", "spfld"},
    {"\\byellowstone\\b", "yelwstn"},
    {"\\bchevy\\s+chase\\b", "chevy chs"},
    {"\\bhigh\\s+bridge\\b", "highbridge"},
    {"\\bpuerto\\s+rico\\b", "pr"},
    {"\\bconnecticut\\b", "ct"},
    {"\\bmississippi\\b", "ms"},
    {"\\bcrossroads\\b", "xrds"},
    {"\\bextensions\\b", "exts"},
    {"\\bplantation\\b", "plt"},
    {"\\buniversity\\b", "univ"},
    {"\\bexpressway\\b", "exp"},
    {"\\bthroughway\\b", "trwy"},
    {"\\btrafficway\\b", "trfy"},
    {"\\balpen\\s+glow\\b", "alpenglow"},
    {"\\bambassador\\b", "amb"},
    {"\\bbernardino\\b", "bernrdno"},
    {"\\bbloomfield\\b", "bloomfld"},
    {"\\bcapistrano\\b", "capo"},
    {"\\bcincinnati\\b", "cin"},
    {"\\bcottonwood\\b", "ctwd"},
    {"\\bfarmington\\b", "farmingtn"},
    {"\\bpittsburgh\\b", "pgh"},
    {"\\bprovidence\\b", "providnce"},
    {"\\bsouth\\s+lake\\b", "southlake"},
    {"\\bwest\\s+point\\b", "westpoint"},
    {"\\bbrownstown\\b", "brownstwn"},
    {"\\bburlington\\b", "burlngtn"},
    {"\\bchristmass\\b", "chirstmas"},
    {"\\bnew\\s+jersey\\b", "nj"},
    {"\\bnew\\s+mexico\\b", "nm"},
    {"\\bcalifornia\\b", "ca"},
    {"\\bwashington\\b", "wa"},
    {"\\bcrossroad\\b", "xrd"},
    {"\\bhighlands\\b", "hlds"},
    {"\\bjunctions\\b", "jcts"},
    {"\\bmountains\\b", "mtns"},
    {"\\bboulevard\\b", "boul"},
    {"\\bextension\\b", "ext"},
    {"\\bstravenue\\b", "stra"},
    {"\\bunderpass\\b", "upas"},
    {"\\bchair\\s+bar\\b", "chairbar"},
    {"\\btown\\s+line\\b", "t l"},
    {"\\bterritory\\b", ""},
    {"\\bbellerose\\b", "bellrs"},
    {"\\bchicester\\b", "chicstr"},
    {"\\bcity\\s+base\\b", "cb"},
    {"\\bcleveland\\b", "cleve"},
    {"\\bcommunity\\b", "cmnty"},
    {"\\bfairmount\\b", "fairmt"},
    {"\\bfernandez\\b", "fdez"},
    {"\\bfrancisco\\b", "fran"},
    {"\\bho\'olehua\\b", "hoolehua"},
    {"\\blexington\\b", "lxngtn"},
    {"\\bmilwaukee\\b", "milw"},
    {"\\brichfield\\b", "richfld"},
    {"\\bwashingtn\\b", "wa"},
    {"\\bburlingtn\\b", "burlngtn"},
    {"\\bhomestead\\b", "hmstd"},
    {"\\blouisiana\\b", "la"},
    {"\\bminnesota\\b", "mn"},
    {"\\btennessee\\b", ""},
    {"\\bwisconsin\\b", "wi"},
    {"\\bcauseway\\b", "cswy"},
    {"\\bcrossrds\\b", "xrds"},
    {"\\bjunction\\b", "jt"},
    {"\\bmountain\\b", "mnt"},
    {"\\bnational\\b", "nl"},
    {"\\bparkways\\b", "pkwys"},
    {"\\bvilliage\\b", "vil"},
    {"\\bvillages\\b", "vlgs"},
    {"\\bcrescent\\b", "cres"},
    {"\\bmotorway\\b", "mtwy"},
    {"\\boverpass\\b", "opas"},
    {"\\bturnpike\\b", "tpk"},
    {"\\bcrossing\\b", "xing"},
    {"\\bbullrush\\b", "bulrush"},
    {"\\bmichelle\\b", "michele"},
    {"\\btownline\\b", "t l"},
    {"\\bdowntown\\b", ""},
    {"\\btownship\\b", "tw"},
    {"\\bcottonwd\\b", "ctwd"},
    {"\\bhartford\\b", "hartfrd"},
    {"\\bla\\s+salle\\b", "lasalle"},
    {"\\bnew\\s+york\\b", "ny"},
    {"\\brichland\\b", "richlnd"},
    {"\\bbig\\s+bend\\b", "bg bnd"},
    {"\\bblooming\\b", "blmng"},
    {"\\barkansas\\b", "ar"},
    {"\\bcolorado\\b", "co"},
    {"\\bdelaware\\b", "de"},
    {"\\billinois\\b", "il"},
    {"\\bkentucky\\b", "ky"},
    {"\\bmaryland\\b", "md"},
    {"\\bmichigan\\b", "mi"},
    {"\\bmissouri\\b", "mo"},
    {"\\bnebraska\\b", "ne"},
    {"\\boklahoma\\b", "ok"},
    {"\\bvirginia\\b", "va"},
    {"\\bseventh\\b", "7"},
    {"\\bcausway\\b", "cswy"},
    {"\\bcenters\\b", "ctrs"},
    {"\\bcircles\\b", "cirs"},
    {"\\bcollege\\b", "clg"},
    {"\\bcorners\\b", "cors"},
    {"\\bcountry\\b", "cntry"},
    {"\\bcrossrd\\b", "xrd"},
    {"\\bestates\\b", "ests"},
    {"\\bgardens\\b", "gdns"},
    {"\\bgateway\\b", "gtwy"},
    {"\\bharbors\\b", "hbrs"},
    {"\\bheights\\b", "ht"},
    {"\\bhollows\\b", "hllw"},
    {"\\bislands\\b", "is"},
    {"\\blanding\\b", "lndg"},
    {"\\bmeadows\\b", "mdws"},
    {"\\bmission\\b", "msn"},
    {"\\bmountin\\b", "mnt"},
    {"\\borchard\\b", "orch"},
    {"\\bplaines\\b", "plns"},
    {"\\bprairie\\b", "pr"},
    {"\\branches\\b", "rnchs"},
    {"\\branchos\\b", "rnchs"},
    {"\\bsprings\\b", "spg"},
    {"\\bsquares\\b", "sqs"},
    {"\\bstation\\b", "sta"},
    {"\\bstreets\\b", "sts"},
    {"\\bterrace\\b", "ter"},
    {"\\bvalleys\\b", "vlys"},
    {"\\bvillage\\b", "vil"},
    {"\\bhighway\\b", "hwy"},
    {"\\bexpress\\b", "exp"},
    {"\\bcrecent\\b", "cres"},
    {"\\bcresent\\b", "cres"},
    {"\\bfreeway\\b", "fwy"},
    {"\\bjuncton\\b", "jt"},
    {"\\bparkway\\b", "pky"},
    {"\\bpassage\\b", "psge"},
    {"\\bstraven\\b", "stra"},
    {"\\bstrvnue\\b", "stra"},
    {"\\btunnels\\b", "tunl"},
    {"\\bviaduct\\b", "via"},
    {"\\bcrssing\\b", "xing"},
    {"\\bavenida\\b", "av"},
    {"\\bcapital\\b", "capitol"},
    {"\\bcolonel\\b", "col"},
    {"\\bcentral\\b", ""},
    {"\\btownshp\\b", "tw"},
    {"\\bchicago\\b", "chgo"},
    {"\\bjohnson\\b", "jhnsn"},
    {"\\bphoenix\\b", "phx"},
    {"\\bwshngtn\\b", "wa"},
    {"\\bwilliam\\b", "wm"},
    {"\\bpotsdam\\b", "potsdm"},
    {"\\balabama\\b", "al"},
    {"\\barizona\\b", "az"},
    {"\\bflorida\\b", "fl"},
    {"\\bgeorgia\\b", "ga"},
    {"\\bindiana\\b", "in"},
    {"\\bmontana\\b", "mt"},
    {"\\bvermont\\b", "vt"},
    {"\\bwyoming\\b", "wy"},
    {"\\bamerica\\b", "us"},
    {"\\bsecond\\b", "2"},
    {"\\bfourth\\b", "4"},
    {"\\beighth\\b", "8"},
    {"\\bbarrio\\b", "bo"},
    {"\\bbluffs\\b", "blfs"},
    {"\\bbottom\\b", "bot"},
    {"\\bbranch\\b", "br"},
    {"\\bbridge\\b", "brg"},
    {"\\bbrooks\\b", "brks"},
    {"\\bcanyon\\b", "cyn"},
    {"\\bcentre\\b", "ctr"},
    {"\\bcenter\\b", "ctr"},
    {"\\bcliffs\\b", "clfs"},
    {"\\bcommon\\b", "cmn"},
    {"\\bcorner\\b", "cor"},
    {"\\bcourse\\b", "crse"},
    {"\\bcourts\\b", "cts"},
    {"\\bxroads\\b", "xrds"},
    {"\\bdivide\\b", "dv"},
    {"\\bdrives\\b", "drs"},
    {"\\bestate\\b", "est"},
    {"\\bfields\\b", "flds"},
    {"\\bforest\\b", "frst"},
    {"\\bforges\\b", "frgs"},
    {"\\bgarden\\b", "gdn"},
    {"\\bgatway\\b", "gtwy"},
    {"\\bgatewy\\b", "gtwy"},
    {"\\bgreens\\b", "grns"},
    {"\\bgroves\\b", "grvs"},
    {"\\bharbor\\b", "hbr"},
    {"\\bheight\\b", "ht"},
    {"\\bhollow\\b", "hllw"},
    {"\\bisland\\b", "is"},
    {"\\bislnds\\b", "is"},
    {"\\bknolls\\b", "knls"},
    {"\\blights\\b", "lgts"},
    {"\\blittle\\b", "ltl"},
    {"\\bmanors\\b", "mnrs"},
    {"\\bmeadow\\b", "mdw"},
    {"\\bmedows\\b", "mdws"},
    {"\\bmiddle\\b", "mid"},
    {"\\bmntain\\b", "mnt"},
    {"\\borchrd\\b", "orch"},
    {"\\bplains\\b", "plns"},
    {"\\bpoints\\b", "pts"},
    {"\\bpuerto\\b", "pto"},
    {"\\bquarry\\b", "qry"},
    {"\\branchs\\b", "rnchs"},
    {"\\brancho\\b", "rncho"},
    {"\\brapids\\b", "rpds"},
    {"\\bridges\\b", "rdgs"},
    {"\\bshoals\\b", "shls"},
    {"\\bshores\\b", "shrs"},
    {"\\bshoars\\b", "shrs"},
    {"\\bspring\\b", "spg"},
    {"\\bsprngs\\b", "spg"},
    {"\\bsquare\\b", "sq"},
    {"\\bstream\\b", "strm"},
    {"\\bstreme\\b", "strm"},
    {"\\bsumitt\\b", "smt"},
    {"\\bsummit\\b", "smt"},
    {"\\btrails\\b", "tr"},
    {"\\bunions\\b", "uns"},
    {"\\bvalley\\b", "vl"},
    {"\\bvillag\\b", "vil"},
    {"\\bwaters\\b", "wtr"},
    {"\\bschool\\b", "sch"},
    {"\\blagoon\\b", "lagn"},
    {"\\bavenue\\b", "av"},
    {"\\bhighwy\\b", "hwy"},
    {"\\bcircle\\b", "cir"},
    {"\\barcade\\b", "arc"},
    {"\\bbypass\\b", "byp"},
    {"\\bcrscnt\\b", "cres"},
    {"\\bcrsent\\b", "cres"},
    {"\\bextnsn\\b", "ext"},
    {"\\bfreewy\\b", "fwy"},
    {"\\bjunctn\\b", "jt"},
    {"\\bjction\\b", "jt"},
    {"\\bparkwy\\b", "pky"},
    {"\\bradial\\b", "rad"},
    {"\\bradiel\\b", "rad"},
    {"\\bskyway\\b", "skwy"},
    {"\\bstrave\\b", "stra"},
    {"\\bstravn\\b", "stra"},
    {"\\bstreet\\b", "st"},
    {"\\btraces\\b", "trce"},
    {"\\btracks\\b", "trk"},
    {"\\bturnpk\\b", "tpk"},
    {"\\btunnel\\b", "tunl"},
    {"\\bviadct\\b", "via"},
    {"\\bcrssng\\b", "xing"},
    {"\\bcamino\\b", "cm"},
    {"\\bcarlan\\b", "carlin"},
    {"\\bsenior\\b", "sr"},
    {"\\bsydney\\b", "sidney"},
    {"\\bcounty\\b", ""},
    {"\\bparish\\b", ""},
    {"\\btwnshp\\b", "tw"},
    {"\\bcorpus\\b", "crp"},
    {"\\bobispo\\b", "obisp"},
    {"\\bdesert\\b", "dsrt"},
    {"\\balaska\\b", "ak"},
    {"\\bhawaii\\b", "hi"},
    {"\\bkansas\\b", "ks"},
    {"\\bnevada\\b", "nv"},
    {"\\boregon\\b", "or"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bfirst\\b", "1"},
    {"\\bthird\\b", "3"},
    {"\\bthree\\b", "3"},
    {"\\bfifth\\b", "5"},
    {"\\bsixth\\b", "6"},
    {"\\bseven\\b", "7"},
    {"\\beight\\b", "8"},
    {"\\bninth\\b", "9"},
    {"\\btenth\\b", "10"},
    {"\\bmount\\b", "mt"},
    {"\\bsaint\\b", "st"},
    {"\\bannex\\b", "anx"},
    {"\\bbayoo\\b", "byu"},
    {"\\bbayou\\b", "byu"},
    {"\\bbeach\\b", "bch"},
    {"\\bblack\\b", "blk"},
    {"\\bbluff\\b", "blf"},
    {"\\bbottm\\b", "bot"},
    {"\\bbrnch\\b", "br"},
    {"\\bbrdge\\b", "brg"},
    {"\\bbrook\\b", "brk"},
    {"\\bburgs\\b", "bgs"},
    {"\\bcanyn\\b", "cyn"},
    {"\\bcnter\\b", "ctr"},
    {"\\bcentr\\b", "ctr"},
    {"\\bcliff\\b", "clf"},
    {"\\bcoves\\b", "cvs"},
    {"\\bcreek\\b", "ck"},
    {"\\bcrest\\b", "crst"},
    {"\\bxroad\\b", "xrd"},
    {"\\bcurve\\b", "curv"},
    {"\\bfalls\\b", "fls"},
    {"\\bfield\\b", "fld"},
    {"\\bflats\\b", "flts"},
    {"\\bfords\\b", "frds"},
    {"\\bforge\\b", "frg"},
    {"\\bforks\\b", "fks"},
    {"\\bgardn\\b", "gdn"},
    {"\\bgrden\\b", "gdn"},
    {"\\bgrdns\\b", "gdns"},
    {"\\bgtway\\b", "gtwy"},
    {"\\bglens\\b", "glns"},
    {"\\bgrand\\b", "grnd"},
    {"\\bgreen\\b", "grn"},
    {"\\bgrove\\b", "grv"},
    {"\\bharbr\\b", "hbr"},
    {"\\bhrbor\\b", "hbr"},
    {"\\bhaven\\b", "hvn"},
    {"\\bhills\\b", "hl"},
    {"\\bholws\\b", "hllw"},
    {"\\bhouse\\b", "hse"},
    {"\\binlet\\b", "inlt"},
    {"\\bislnd\\b", "is"},
    {"\\bisles\\b", "isle"},
    {"\\bjctns\\b", "jcts"},
    {"\\bknoll\\b", "knl"},
    {"\\blakes\\b", "lks"},
    {"\\blndng\\b", "lndg"},
    {"\\blight\\b", "lgt"},
    {"\\blocks\\b", "lcks"},
    {"\\blodge\\b", "ldg"},
    {"\\blower\\b", "lo"},
    {"\\bmanor\\b", "mnr"},
    {"\\bmills\\b", "mls"},
    {"\\bmissn\\b", "msn"},
    {"\\bmntns\\b", "mtns"},
    {"\\bplace\\b", "pl"},
    {"\\bpalms\\b", "plms"},
    {"\\bpines\\b", "pnes"},
    {"\\bplain\\b", "pln"},
    {"\\bpoint\\b", "pt"},
    {"\\bports\\b", "prts"},
    {"\\bponds\\b", "pnds"},
    {"\\branch\\b", "rch"},
    {"\\brapid\\b", "rpd"},
    {"\\bridge\\b", "rdg"},
    {"\\briver\\b", "rvr"},
    {"\\broads\\b", "rds"},
    {"\\bshoal\\b", "shl"},
    {"\\bshore\\b", "shr"},
    {"\\bshoar\\b", "shr"},
    {"\\bspace\\b", "sp"},
    {"\\bsprng\\b", "spg"},
    {"\\bspngs\\b", "spg"},
    {"\\bsprgs\\b", "spg"},
    {"\\bstatn\\b", "sta"},
    {"\\bsumit\\b", "smt"},
    {"\\btrail\\b", "tr"},
    {"\\bunion\\b", "un"},
    {"\\bvally\\b", "vl"},
    {"\\bviews\\b", "vws"},
    {"\\bvillg\\b", "vil"},
    {"\\bville\\b", "vl"},
    {"\\bvista\\b", "vis"},
    {"\\bwells\\b", "wls"},
    {"\\bwoods\\b", "wds"},
    {"\\bworks\\b", "wks"},
    {"\\broute\\b", "rt"},
    {"\\bavnue\\b", "av"},
    {"\\bavenu\\b", "av"},
    {"\\bhiway\\b", "hwy"},
    {"\\bcrcle\\b", "cir"},
    {"\\bcircl\\b", "cir"},
    {"\\balley\\b", "aly"},
    {"\\ballee\\b", "aly"},
    {"\\bboulv\\b", "boul"},
    {"\\bbypas\\b", "byp"},
    {"\\bcourt\\b", "ct"},
    {"\\bcrsnt\\b", "cres"},
    {"\\bdrive\\b", "dr"},
    {"\\bfrway\\b", "fwy"},
    {"\\bferry\\b", "fry"},
    {"\\blanes\\b", "la"},
    {"\\bloops\\b", "loop"},
    {"\\bpkway\\b", "pky"},
    {"\\bpaths\\b", "path"},
    {"\\bpikes\\b", "pike"},
    {"\\bplaza\\b", "plz"},
    {"\\bstrvn\\b", "stra"},
    {"\\bstrav\\b", "stra"},
    {"\\btrace\\b", "trce"},
    {"\\btrack\\b", "trk"},
    {"\\btrnpk\\b", "tpk"},
    {"\\btunls\\b", "tunl"},
    {"\\btunel\\b", "tunl"},
    {"\\btunnl\\b", "tunl"},
    {"\\bcalle\\b", "cll"},
    {"\\bpaseo\\b", "pso"},
    {"\\bm\\s+l\\s+k\\b", "mlk"},
    {"\\bverdi\\b", "verde"},
    {"\\ba\\s+f\\s+b\\b", "afb"},
    {"\\bcalif\\b", "ca"},
    {"\\bdepot\\b", "dep"},
    {"\\bn\\s+y\\s+c\\b", "ny"},
    {"\\bidaho\\b", "id"},
    {"\\bmaine\\b", "me"},
    {"\\btexas\\b", "tx"},
    {"\\bpalau\\b", "pw"},
    {"\\bu\\s+s\\s+a\\b", "us"},
    {"\\beast\\b", "e"},
    {"\\bwest\\b", "w"},
    {"\\bfour\\b", "4"},
    {"\\bfive\\b", "5"},
    {"\\bnine\\b", "9"},
    {"\\banex\\b", "anx"},
    {"\\bbend\\b", "bnd"},
    {"\\bbluf\\b", "blf"},
    {"\\bburg\\b", "bg"},
    {"\\bcamp\\b", "cp"},
    {"\\bcnyn\\b", "cyn"},
    {"\\bcape\\b", "cpe"},
    {"\\bcntr\\b", "ctr"},
    {"\\bcent\\b", "ctr"},
    {"\\bclub\\b", "clb"},
    {"\\bcove\\b", "cv"},
    {"\\bdale\\b", "dl"},
    {"\\bflat\\b", "flt"},
    {"\\bford\\b", "frd"},
    {"\\bfarm\\b", "frm"},
    {"\\bforg\\b", "frg"},
    {"\\bfork\\b", "frk"},
    {"\\bfrks\\b", "fks"},
    {"\\bfort\\b", "ft"},
    {"\\bgrdn\\b", "gdn"},
    {"\\bglen\\b", "gln"},
    {"\\bharb\\b", "hbr"},
    {"\\bhavn\\b", "hvn"},
    {"\\bhgts\\b", "ht"},
    {"\\bhght\\b", "ht"},
    {"\\bhill\\b", "hl"},
    {"\\bholw\\b", "hllw"},
    {"\\bjnct\\b", "jt"},
    {"\\bkeys\\b", "kys"},
    {"\\bknol\\b", "knl"},
    {"\\blake\\b", "lk"},
    {"\\blitl\\b", "ltl"},
    {"\\bloaf\\b", "lf"},
    {"\\block\\b", "lck"},
    {"\\bldge\\b", "ldg"},
    {"\\blodg\\b", "ldg"},
    {"\\bmile\\b", "mle"},
    {"\\bmill\\b", "ml"},
    {"\\bmssn\\b", "msn"},
    {"\\bmntn\\b", "mnt"},
    {"\\bmtin\\b", "mnt"},
    {"\\bneck\\b", "nck"},
    {"\\boval\\b", "ovl"},
    {"\\bpalm\\b", "plm"},
    {"\\bpark\\b", "pk"},
    {"\\bpass\\b", "ps"},
    {"\\bpine\\b", "pne"},
    {"\\bport\\b", "prt"},
    {"\\brnch\\b", "rch"},
    {"\\brest\\b", "rst"},
    {"\\brdge\\b", "rdg"},
    {"\\brivr\\b", "rvr"},
    {"\\bspng\\b", "spg"},
    {"\\bsprg\\b", "spg"},
    {"\\bspgs\\b", "spg"},
    {"\\bsqre\\b", "sq"},
    {"\\bsqrs\\b", "sqs"},
    {"\\btrls\\b", "tr"},
    {"\\bvlly\\b", "vl"},
    {"\\bview\\b", "vw"},
    {"\\bvill\\b", "vil"},
    {"\\bvist\\b", "vis"},
    {"\\bvsta\\b", "vis"},
    {"\\bwell\\b", "wl"},
    {"\\broad\\b", "rd"},
    {"\\baven\\b", "av"},
    {"\\bhiwy\\b", "hwy"},
    {"\\bhway\\b", "hwy"},
    {"\\bexpr\\b", "exp"},
    {"\\bexpw\\b", "exp"},
    {"\\bexpy\\b", "exp"},
    {"\\bcirc\\b", "cir"},
    {"\\bcrcl\\b", "cir"},
    {"\\bally\\b", "aly"},
    {"\\bblvd\\b", "boul"},
    {"\\bbypa\\b", "byp"},
    {"\\bbyps\\b", "byp"},
    {"\\bdriv\\b", "dr"},
    {"\\bextn\\b", "ext"},
    {"\\bfrwy\\b", "fwy"},
    {"\\bfrry\\b", "fry"},
    {"\\bgrov\\b", "grv"},
    {"\\bjctn\\b", "jt"},
    {"\\blane\\b", "la"},
    {"\\bpkwy\\b", "pky"},
    {"\\bplza\\b", "plz"},
    {"\\bradl\\b", "rad"},
    {"\\bstrt\\b", "st"},
    {"\\bterr\\b", "ter"},
    {"\\btrks\\b", "trk"},
    {"\\btrak\\b", "trk"},
    {"\\btrpk\\b", "tpk"},
    {"\\btpke\\b", "tpk"},
    {"\\bvdct\\b", "via"},
    {"\\bx\\s+rd\\b", "xrd"},
    {"\\btwln\\b", "t l"},
    {"\\btown\\b", ""},
    {"\\btwsp\\b", "tw"},
    {"\\bcity\\b", "cy"},
    {"\\bbing\\b", "byng"},
    {"\\bcolo\\b", "co"},
    {"\\bariz\\b", "az"},
    {"\\bconn\\b", "ct"},
    {"\\biowa\\b", "ia"},
    {"\\bkans\\b", "ks"},
    {"\\bmass\\b", "ma"},
    {"\\bmich\\b", "mi"},
    {"\\bminn\\b", "mn"},
    {"\\bmiss\\b", "ms"},
    {"\\bnebr\\b", "ne"},
    {"\\bohio\\b", "oh"},
    {"\\bokla\\b", "ok"},
    {"\\boreg\\b", "or"},
    {"\\btenn\\b", ""},
    {"\\butah\\b", "ut"},
    {"\\bwash\\b", "wa"},
    {"\\bguam\\b", "gu"},
    {"\\bnth\\b", "n"},
    {"\\bsth\\b", "s"},
    {"\\bone\\b", "1"},
    {"\\btwo\\b", "2"},
    {"\\bsix\\b", "6"},
    {"\\bten\\b", "10"},
    {"\\bbtm\\b", "bot"},
    {"\\bcmp\\b", "cp"},
    {"\\bcen\\b", "ctr"},
    {"\\bcrk\\b", "ck"},
    {"\\bdam\\b", "dm"},
    {"\\bdiv\\b", "dv"},
    {"\\bdvd\\b", "dv"},
    {"\\bfrt\\b", "ft"},
    {"\\bhei\\b", "ht"},
    {"\\bhts\\b", "ht"},
    {"\\bhls\\b", "hl"},
    {"\\bisl\\b", "is"},
    {"\\biss\\b", "is"},
    {"\\bjct\\b", "jt"},
    {"\\bkey\\b", "ky"},
    {"\\blke\\b", "lk"},
    {"\\blwr\\b", "lo"},
    {"\\bmtn\\b", "mnt"},
    {"\\bntl\\b", "nl"},
    {"\\bprk\\b", "pk"},
    {"\\bprr\\b", "pr"},
    {"\\briv\\b", "rvr"},
    {"\\bsan\\b", "sn"},
    {"\\bspr\\b", "spg"},
    {"\\bsqr\\b", "sq"},
    {"\\bsqu\\b", "sq"},
    {"\\bstn\\b", "sta"},
    {"\\btrl\\b", "tr"},
    {"\\bvly\\b", "vl"},
    {"\\bvlg\\b", "vil"},
    {"\\bvst\\b", "vis"},
    {"\\brte\\b", "rt"},
    {"\\bave\\b", "av"},
    {"\\bavn\\b", "av"},
    {"\\bcrt\\b", "ct"},
    {"\\bdrv\\b", "dr"},
    {"\\bstr\\b", "st"},
    {"\\bway\\b", "wy"},
    {"\\bcam\\b", "cm"},
    {"\\btwp\\b", "tw"},
    {"\\bcty\\b", "cy"},
    {"\\bdpt\\b", "dep"},
    {"\\bl\\s+a\\b", "la"},
    {"\\bnyc\\b", "ny"},
    {"\\bd\\s+c\\b", "dc"},
    {"\\bn\\s+h\\b", "nh"},
    {"\\bn\\s+j\\b", "nj"},
    {"\\bn\\s+m\\b", "nm"},
    {"\\bnys\\b", "ny"},
    {"\\bn\\s+y\\b", "ny"},
    {"\\bn\\s+c\\b", "nc"},
    {"\\bn\\s+d\\b", "nd"},
    {"\\bp\\s+r\\b", "pr"},
    {"\\br\\s+i\\b", "ri"},
    {"\\bs\\s+c\\b", "sc"},
    {"\\bs\\s+d\\b", "sd"},
    {"\\bv\\s+i\\b", "vi"},
    {"\\bw\\s+v\\b", "wv"},
    {"\\bala\\b", "al"},
    {"\\bfla\\b", "fl"},
    {"\\bill\\b", "il"},
    {"\\bind\\b", "in"},
    {"\\bkan\\b", "ks"},
    {"\\bneb\\b", "ne"},
    {"\\bnev\\b", "nv"},
    {"\\bore\\b", "or"},
    {"\\bwis\\b", "wi"},
    {"\\bwva\\b", "wv"},
    {"\\busa\\b", "us"},
    {"\\bu\\s+s\\b", "us"},
    {"\\bcr\\b", "ck"},
    {"\\bvy\\b", "vl"},
    {"\\bln\\b", "la"},
    {"\\btp\\b", "tw"},
    {"\\btn\\b", ""},
    {"\\b\\#\\b", ""},
};

const Rule kRules_VN[] = {
    {"\\bthi\\s+tran\\s+van\\s+dien\\b", "ttvan dien"},
    {"\\bho\\s+chi\\s+minh\\s+city\\b", "hcm"},
    {"\\bho\\s+chi\\s+minh\\b", "hcm"},
    {"\\bthanh\\s+pho\\b", "tp"},
    {"\\btpha\\s+noi\\b", "ha noi"},
    {"\\bthi\\s+tran\\b", "tt"},
    {"\\bviet\\s+nam\\b", "vn"},
    {"\\bvietnam\\b", "vn"},
    {"\\bphuong\\b", "p"},
    {"\\bthi\\s+xa\\b", "tx"},
    {"\\bhuyen\\b", "h"},
    {"\\bhcmc\\b", "hcm"},
    {"\\bquan\\b", "q"},
    {"\\bt\\.p\\.\\b", "tp"},
    {"\\btinh\\b", "t"},
    {"\\bph\\.\\b", "p"},
    {"\\btp\\.\\b", "tp"},
    {"\\btt\\.\\b", "tt"},
    {"\\btx\\.\\b", "tx"},
    {"\\bh\\.\\b", "h"},
    {"\\bp\\.\\b", "p"},
    {"\\bq\\.\\b", "q"},
    {"\\bt\\.\\b", "t"},
    {"\\bx\\.\\b", "x"},
    {"\\bxa\\b", "x"},
};

const Rule kRules_ZA[] = {
    {"\\brepublic\\s+of\\s+south\\s+africa\\b", "za"},
    {"\\bkwazulu\\s+natal\\b", "zn"},
    {"\\bnorthern\\s+cape\\b", "nc"},
    {"\\beastern\\s+cape\\b", "ec"},
    {"\\bkwazulunatal\\b", "zn"},
    {"\\bwestern\\s+cape\\b", "wc"},
    {"\\bsouth\\s+africa\\b", "za"},
    {"\\bfree\\s+state\\b", "fs"},
    {"\\bmpumalanga\\b", "mp"},
    {"\\bnorth\\s+west\\b", "nw"},
    {"\\bnoord\\s+kaap\\b", "nc"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bfreestate\\b", "fs"},
    {"\\boos\\s+kaap\\b", "ec"},
    {"\\bvrystaat\\b", "fs"},
    {"\\bnoordwes\\b", "nw"},
    {"\\bwes\\s+kaap\\b", "wc"},
    {"\\bhighway\\b", "hwy"},
    {"\\bgauteng\\b", "gp"},
    {"\\blimpopo\\b", "lp"},
    {"\\bstreet\\b", "st"},
    {"\\bavenue\\b", "ave"},
    {"\\bsaint\\b", "st"},
    {"\\bdrive\\b", "dr"},
    {"\\bnatal\\b", "zn"},
    {"\\broad\\b", "rd"},
    {"\\bkzn\\b", "zn"},
    {"\\bgt\\b", "gp"},
    {"\\bnl\\b", "zn"},
    {"\\bsa\\b", "za"},
};

}  // namespace

const RegionInfo kRuleTable[] = {
    {"AD", kRules_AD, sizeof(kRules_AD) / sizeof(kRules_AD[0])},
    {"AR", kRules_AR, sizeof(kRules_AR) / sizeof(kRules_AR[0])},
    {"AU", kRules_AU, sizeof(kRules_AU) / sizeof(kRules_AU[0])},
    {"BE", kRules_BE, sizeof(kRules_BE) / sizeof(kRules_BE[0])},
    {"BR", kRules_BR, sizeof(kRules_BR) / sizeof(kRules_BR[0])},
    {"CA", kRules_CA, sizeof(kRules_CA) / sizeof(kRules_CA[0])},
    {"CH", kRules_CH, sizeof(kRules_CH) / sizeof(kRules_CH[0])},
    {"CL", kRules_CL, sizeof(kRules_CL) / sizeof(kRules_CL[0])},
    {"CO", kRules_CO, sizeof(kRules_CO) / sizeof(kRules_CO[0])},
    {"DE", kRules_DE, sizeof(kRules_DE) / sizeof(kRules_DE[0])},
    {"DK", kRules_DK, sizeof(kRules_DK) / sizeof(kRules_DK[0])},
    {"ES", kRules_ES, sizeof(kRules_ES) / sizeof(kRules_ES[0])},
    {"FR", kRules_FR, sizeof(kRules_FR) / sizeof(kRules_FR[0])},
    {"GB", kRules_GB, sizeof(kRules_GB) / sizeof(kRules_GB[0])},
    {"GR", kRules_GR, sizeof(kRules_GR) / sizeof(kRules_GR[0])},
    {"HK", kRules_HK, sizeof(kRules_HK) / sizeof(kRules_HK[0])},
    {"ID", kRules_ID, sizeof(kRules_ID) / sizeof(kRules_ID[0])},
    {"IE", kRules_IE, sizeof(kRules_IE) / sizeof(kRules_IE[0])},
    {"IN", kRules_IN, sizeof(kRules_IN) / sizeof(kRules_IN[0])},
    {"IT", kRules_IT, sizeof(kRules_IT) / sizeof(kRules_IT[0])},
    {"LU", kRules_LU, sizeof(kRules_LU) / sizeof(kRules_LU[0])},
    {"MX", kRules_MX, sizeof(kRules_MX) / sizeof(kRules_MX[0])},
    {"MY", kRules_MY, sizeof(kRules_MY) / sizeof(kRules_MY[0])},
    {"NL", kRules_NL, sizeof(kRules_NL) / sizeof(kRules_NL[0])},
    {"NZ", kRules_NZ, sizeof(kRules_NZ) / sizeof(kRules_NZ[0])},
    {"PE", kRules_PE, sizeof(kRules_PE) / sizeof(kRules_PE[0])},
    {"PH", kRules_PH, sizeof(kRules_PH) / sizeof(kRules_PH[0])},
    {"PL", kRules_PL, sizeof(kRules_PL) / sizeof(kRules_PL[0])},
    {"PR", kRules_PR, sizeof(kRules_PR) / sizeof(kRules_PR[0])},
    {"PT", kRules_PT, sizeof(kRules_PT) / sizeof(kRules_PT[0])},
    {"RO", kRules_RO, sizeof(kRules_RO) / sizeof(kRules_RO[0])},
    {"RU", kRules_RU, sizeof(kRules_RU) / sizeof(kRules_RU[0])},
    {"SE", kRules_SE, sizeof(kRules_SE) / sizeof(kRules_SE[0])},
    {"TH", kRules_TH, sizeof(kRules_TH) / sizeof(kRules_TH[0])},
    {"TR", kRules_TR, sizeof(kRules_TR) / sizeof(kRules_TR[0])},
    {"US", kRules_US, sizeof(kRules_US) / sizeof(kRules_US[0])},
    {"VN", kRules_VN, sizeof(kRules_VN) / sizeof(kRules_VN[0])},
    {"ZA", kRules_ZA, sizeof(kRules_ZA) / sizeof(kRules_ZA[0])},
};

const size_t kRuleTableSize = sizeof(kRuleTable)/sizeof(kRuleTable[0]);
}  // namespace internal
}  // namespace autofill
