/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.common.base.Joiner;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;

public final class MethodAnnotationChecker
extends ContextTrackingChecker {
    private static final Pattern PARAM_PATTERN = Pattern.compile("^[^@\n]*@param\\s+(\\{.+\\}\\s+)?([^\\s]+).*$", 8);
    private static final Pattern INVALID_RETURN_PATTERN = Pattern.compile("^[^@\n]*(@)return(?:s.*|\\s+[^{]*)$", 8);
    private final Set<FunctionRecord> valueReturningFunctions = new HashSet<FunctionRecord>();
    private final Set<FunctionRecord> throwingFunctions = new HashSet<FunctionRecord>();

    @Override
    public void enterNode(Node node) {
        switch (node.getType()) {
            case 105: {
                this.handleFunction(node);
                break;
            }
            case 4: {
                this.handleReturn(node);
                break;
            }
            case 49: {
                this.handleThrow();
                break;
            }
        }
    }

    private void handleFunction(Node node) {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null || functionRecord.parameterNames.size() == 0) {
            return;
        }
        Object[] objectArray = this.getNonAnnotatedParamData(functionRecord);
        if (objectArray.length > 0 && functionRecord.parameterNames.size() != objectArray.length) {
            this.reportErrorAtOffset(functionRecord.info.getOriginalCommentPosition(), String.format("No @param JSDoc tag found for parameters: [%s]", Joiner.on(',').join(objectArray)));
        }
    }

    private String[] getNonAnnotatedParamData(FunctionRecord functionRecord) {
        String string;
        if (functionRecord.info == null) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < functionRecord.parameterNames.size(); ++i) {
            string = functionRecord.parameterNames.get(i);
            if (hashSet.add(string)) continue;
            this.reportErrorAtNodeStart(functionRecord.functionNode, String.format("Duplicate function argument name: %s", string));
        }
        Matcher matcher = PARAM_PATTERN.matcher(functionRecord.info.getOriginalCommentString());
        while (matcher.find()) {
            string = matcher.group(1);
            if (string == null) {
                this.reportErrorAtOffset(functionRecord.info.getOriginalCommentPosition() + matcher.start(2), String.format("Invalid @param annotation found - should be \"@param {<type>} paramName\"", new Object[0]));
                continue;
            }
            hashSet.remove(matcher.group(2));
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private void handleReturn(Node node) {
        if (node.getFirstChild() == null || AstUtil.parentOfType(node, 86) != null) {
            return;
        }
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null) {
            return;
        }
        Node node2 = MethodAnnotationChecker.getFunctionNameNode(functionRecord.functionNode);
        if (node2 == null) {
            return;
        }
        this.valueReturningFunctions.add(functionRecord);
    }

    private void handleThrow() {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null) {
            return;
        }
        Node node = MethodAnnotationChecker.getFunctionNameNode(functionRecord.functionNode);
        if (node == null) {
            return;
        }
        this.throwingFunctions.add(functionRecord);
    }

    @Override
    public void leaveNode(Node node) {
        if (node.getType() != 105) {
            return;
        }
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord != null) {
            this.checkFunctionAnnotation(functionRecord);
        }
    }

    private void checkFunctionAnnotation(FunctionRecord functionRecord) {
        String string = this.getFunctionName(functionRecord.functionNode);
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("\\.");
        boolean bl = !(string = stringArray[stringArray.length - 1]).startsWith("_") && (functionRecord.isTopLevelFunction() || functionRecord.enclosingType != null && MethodAnnotationChecker.isPlainTopLevelFunction(functionRecord.enclosingFunctionRecord));
        boolean bl2 = this.valueReturningFunctions.contains(functionRecord);
        boolean bl3 = functionRecord.enclosingType != null && functionRecord.enclosingType.isInterface();
        int n = MethodAnnotationChecker.invalidReturnAnnotationIndex(functionRecord.info);
        if (n != -1) {
            String string2 = bl2 || bl3 ? "should be \"@return {<type>}\"" : "please remove, as function does not return value";
            this.getContext().reportErrorAtOffset(functionRecord.info.getOriginalCommentPosition() + n, String.format("invalid return type annotation found - %s", string2));
            return;
        }
        Node node = MethodAnnotationChecker.getFunctionNameNode(functionRecord.functionNode);
        if (node == null) {
            return;
        }
        if (bl2) {
            if (!functionRecord.isConstructor() && !functionRecord.hasReturnAnnotation() && bl) {
                this.reportErrorAtNodeStart(node, "@return annotation is required for API functions that return value");
            }
        } else if (functionRecord.hasReturnAnnotation() && !bl3 && !this.throwingFunctions.contains(functionRecord)) {
            this.reportErrorAtNodeStart(node, "@return annotation found, yet function does not return value");
        }
    }

    private static boolean isPlainTopLevelFunction(FunctionRecord functionRecord) {
        return functionRecord != null && functionRecord.isTopLevelFunction() && functionRecord.enclosingType == null && !functionRecord.isConstructor();
    }

    private String getFunctionName(Node node) {
        Node node2 = MethodAnnotationChecker.getFunctionNameNode(node);
        return node2 == null ? null : this.getState().getNodeText(node2);
    }

    private static int invalidReturnAnnotationIndex(JSDocInfo jSDocInfo) {
        if (jSDocInfo == null) {
            return -1;
        }
        Matcher matcher = INVALID_RETURN_PATTERN.matcher(jSDocInfo.getOriginalCommentString());
        return matcher.find() ? matcher.start(1) : -1;
    }

    private static Node getFunctionNameNode(Node node) {
        return AstUtil.getFunctionNameNode(node);
    }
}

