/*
 * Copyright 2015 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

// Auto-generated by create_test_font.cpp

static SkTestFontData gTestFonts[] = {
    {    LiberationMonoNormalPoints, LiberationMonoNormalVerbs, LiberationMonoNormalCharCodes,
         LiberationMonoNormalCharCodesCount, LiberationMonoNormalWidths,
         LiberationMonoNormalMetrics, "Toy Liberation Mono", SkTypeface::kNormal, NULL
    },
    {    LiberationMonoBoldPoints, LiberationMonoBoldVerbs, LiberationMonoBoldCharCodes,
         LiberationMonoBoldCharCodesCount, LiberationMonoBoldWidths,
         LiberationMonoBoldMetrics, "Toy Liberation Mono", SkTypeface::kBold, NULL
    },
    {    LiberationMonoItalicPoints, LiberationMonoItalicVerbs, LiberationMonoItalicCharCodes,
         LiberationMonoItalicCharCodesCount, LiberationMonoItalicWidths,
         LiberationMonoItalicMetrics, "Toy Liberation Mono", SkTypeface::kItalic, NULL
    },
    {    LiberationMonoBoldItalicPoints, LiberationMonoBoldItalicVerbs, LiberationMonoBoldItalicCharCodes,
         LiberationMonoBoldItalicCharCodesCount, LiberationMonoBoldItalicWidths,
         LiberationMonoBoldItalicMetrics, "Toy Liberation Mono", SkTypeface::kBoldItalic, NULL
    },
    {    LiberationSansNormalPoints, LiberationSansNormalVerbs, LiberationSansNormalCharCodes,
         LiberationSansNormalCharCodesCount, LiberationSansNormalWidths,
         LiberationSansNormalMetrics, "Toy Liberation Sans", SkTypeface::kNormal, NULL
    },
    {    LiberationSansBoldPoints, LiberationSansBoldVerbs, LiberationSansBoldCharCodes,
         LiberationSansBoldCharCodesCount, LiberationSansBoldWidths,
         LiberationSansBoldMetrics, "Toy Liberation Sans", SkTypeface::kBold, NULL
    },
    {    LiberationSansItalicPoints, LiberationSansItalicVerbs, LiberationSansItalicCharCodes,
         LiberationSansItalicCharCodesCount, LiberationSansItalicWidths,
         LiberationSansItalicMetrics, "Toy Liberation Sans", SkTypeface::kItalic, NULL
    },
    {    LiberationSansBoldItalicPoints, LiberationSansBoldItalicVerbs, LiberationSansBoldItalicCharCodes,
         LiberationSansBoldItalicCharCodesCount, LiberationSansBoldItalicWidths,
         LiberationSansBoldItalicMetrics, "Toy Liberation Sans", SkTypeface::kBoldItalic, NULL
    },
    {    LiberationSerifNormalPoints, LiberationSerifNormalVerbs, LiberationSerifNormalCharCodes,
         LiberationSerifNormalCharCodesCount, LiberationSerifNormalWidths,
         LiberationSerifNormalMetrics, "Toy Liberation Serif", SkTypeface::kNormal, NULL
    },
    {    LiberationSerifBoldPoints, LiberationSerifBoldVerbs, LiberationSerifBoldCharCodes,
         LiberationSerifBoldCharCodesCount, LiberationSerifBoldWidths,
         LiberationSerifBoldMetrics, "Toy Liberation Serif", SkTypeface::kBold, NULL
    },
    {    LiberationSerifItalicPoints, LiberationSerifItalicVerbs, LiberationSerifItalicCharCodes,
         LiberationSerifItalicCharCodesCount, LiberationSerifItalicWidths,
         LiberationSerifItalicMetrics, "Toy Liberation Serif", SkTypeface::kItalic, NULL
    },
    {    LiberationSerifBoldItalicPoints, LiberationSerifBoldItalicVerbs, LiberationSerifBoldItalicCharCodes,
         LiberationSerifBoldItalicCharCodesCount, LiberationSerifBoldItalicWidths,
         LiberationSerifBoldItalicMetrics, "Toy Liberation Serif", SkTypeface::kBoldItalic, NULL
    },
};

const int gTestFontsCount = (int) SK_ARRAY_COUNT(gTestFonts);

struct SubFont {
    const char* fName;
    SkTypeface::Style fStyle;
    SkTestFontData& fFont;
    const char* fFile;
};

const SubFont gSubFonts[] = {
    { "monospace", SkTypeface::kNormal, gTestFonts[0], "LiberationMono-Regular.ttf" },
    { "monospace", SkTypeface::kBold, gTestFonts[1], "LiberationMono-Bold.ttf" },
    { "monospace", SkTypeface::kItalic, gTestFonts[2], "LiberationMono-Italic.ttf" },
    { "monospace", SkTypeface::kBoldItalic, gTestFonts[3], "LiberationMono-BoldItalic.ttf" },
    { "sans-serif", SkTypeface::kNormal, gTestFonts[4], "LiberationSans-Regular.ttf" },
    { "sans-serif", SkTypeface::kBold, gTestFonts[5], "LiberationSans-Bold.ttf" },
    { "sans-serif", SkTypeface::kItalic, gTestFonts[6], "LiberationSans-Italic.ttf" },
    { "sans-serif", SkTypeface::kBoldItalic, gTestFonts[7], "LiberationSans-BoldItalic.ttf" },
    { "serif", SkTypeface::kNormal, gTestFonts[8], "LiberationSerif-Regular.ttf" },
    { "serif", SkTypeface::kBold, gTestFonts[9], "LiberationSerif-Bold.ttf" },
    { "serif", SkTypeface::kItalic, gTestFonts[10], "LiberationSerif-Italic.ttf" },
    { "serif", SkTypeface::kBoldItalic, gTestFonts[11], "LiberationSerif-BoldItalic.ttf" },
    { "Toy Liberation Mono", SkTypeface::kNormal, gTestFonts[0], "LiberationMono-Regular.ttf" },
    { "Toy Liberation Mono", SkTypeface::kBold, gTestFonts[1], "LiberationMono-Bold.ttf" },
    { "Toy Liberation Mono", SkTypeface::kItalic, gTestFonts[2], "LiberationMono-Italic.ttf" },
    { "Toy Liberation Mono", SkTypeface::kBoldItalic, gTestFonts[3], "LiberationMono-BoldItalic.ttf" },
    { "Toy Liberation Sans", SkTypeface::kNormal, gTestFonts[4], "LiberationSans-Regular.ttf" },
    { "Toy Liberation Sans", SkTypeface::kBold, gTestFonts[5], "LiberationSans-Bold.ttf" },
    { "Toy Liberation Sans", SkTypeface::kItalic, gTestFonts[6], "LiberationSans-Italic.ttf" },
    { "Toy Liberation Sans", SkTypeface::kBoldItalic, gTestFonts[7], "LiberationSans-BoldItalic.ttf" },
    { "Toy Liberation Serif", SkTypeface::kNormal, gTestFonts[8], "LiberationSerif-Regular.ttf" },
    { "Toy Liberation Serif", SkTypeface::kBold, gTestFonts[9], "LiberationSerif-Bold.ttf" },
    { "Toy Liberation Serif", SkTypeface::kItalic, gTestFonts[10], "LiberationSerif-Italic.ttf" },
    { "Toy Liberation Serif", SkTypeface::kBoldItalic, gTestFonts[11], "LiberationSerif-BoldItalic.ttf" },
};

const int gSubFontsCount = (int) SK_ARRAY_COUNT(gSubFonts);

const int gDefaultFontIndex = 4;
