

  /**
   * Use `Polymer.NeonSharedElementAnimationBehavior` to implement shared element animations.
   * @polymerBehavior
   */
  Polymer.NeonSharedElementAnimationBehavior = [Polymer.NeonAnimationBehavior, {

    properties: {

      /**
       * Cached copy of shared elements.
       */
      sharedElements: {
        type: Object
      }

    },

    /**
     * Finds shared elements based on `config`.
     */
    findSharedElements: function(config) {
      var fromPage = config.fromPage;
      var toPage = config.toPage;
      if (!fromPage || !toPage) {
        console.warn(this.is + ':', !fromPage ? 'fromPage' : 'toPage', 'is undefined!');
        return null;
      };

      if (!fromPage.sharedElements || !toPage.sharedElements) {
        console.warn(this.is + ':', 'sharedElements are undefined for', !fromPage.sharedElements ? fromPage : toPage);
        return null;
      };

      var from = fromPage.sharedElements[config.id]
      var to = toPage.sharedElements[config.id];

      if (!from || !to) {
        console.warn(this.is + ':', 'sharedElement with id', config.id, 'not found in', !from ? fromPage : toPage);
        return null;
      }

      this.sharedElements = {
        from: from,
        to: to
      };
      return this.sharedElements;
    }

  }];

