// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// WARNING this file was generated by generate_nacl_bindings.py
// Do not edit by hand.

#include <stdio.h>
#include <string.h>

#include "mojo/public/c/system/core.h"
#include "mojo/public/platform/nacl/mojo_irt.h"
#include "native_client/src/public/chrome_main.h"
#include "native_client/src/public/imc_syscalls.h"
#include "native_client/src/public/imc_types.h"
#include "native_client/src/public/irt_core.h"

#define NACL_MOJO_DESC (NACL_CHROME_DESC_BASE + 3)

static void DoMojoCall(uint32_t params[], nacl_abi_size_t num_params) {
  struct NaClAbiNaClImcMsgIoVec iov[1] = {
    {params, num_params}
  };
  struct NaClAbiNaClImcMsgHdr msgh = {iov, 1, NULL, 0};
  // Note: return value unchecked.  We're relying on the result parameter being
  // unmodified - if the syscall fails, the Mojo function will return whatever
  // the result parameter was initialized to before this function was called.
  imc_sendmsg(NACL_MOJO_DESC, &msgh, 0);
}

static MojoResult irt_MojoCreateSharedBuffer(
    const struct MojoCreateSharedBufferOptions* options,
    uint64_t num_bytes,
    MojoHandle* shared_buffer_handle) {
  uint32_t params[5];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 0;
  params[1] = (uint32_t)(options);
  params[2] = (uint32_t)(&num_bytes);
  params[3] = (uint32_t)(shared_buffer_handle);
  params[4] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoDuplicateBufferHandle(
    MojoHandle buffer_handle,
    const struct MojoDuplicateBufferHandleOptions* options,
    MojoHandle* new_buffer_handle) {
  uint32_t params[5];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 1;
  params[1] = (uint32_t)(&buffer_handle);
  params[2] = (uint32_t)(options);
  params[3] = (uint32_t)(new_buffer_handle);
  params[4] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoMapBuffer(
    MojoHandle buffer_handle,
    uint64_t offset,
    uint64_t num_bytes,
    void** buffer,
    MojoMapBufferFlags flags) {
  uint32_t params[7];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 2;
  params[1] = (uint32_t)(&buffer_handle);
  params[2] = (uint32_t)(&offset);
  params[3] = (uint32_t)(&num_bytes);
  params[4] = (uint32_t)(buffer);
  params[5] = (uint32_t)(&flags);
  params[6] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoUnmapBuffer(void* buffer) {
  uint32_t params[3];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 3;
  params[1] = (uint32_t)(&buffer);
  params[2] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoCreateDataPipe(
    const struct MojoCreateDataPipeOptions* options,
    MojoHandle* data_pipe_producer_handle,
    MojoHandle* data_pipe_consumer_handle) {
  uint32_t params[5];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 4;
  params[1] = (uint32_t)(options);
  params[2] = (uint32_t)(data_pipe_producer_handle);
  params[3] = (uint32_t)(data_pipe_consumer_handle);
  params[4] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoWriteData(
    MojoHandle data_pipe_producer_handle,
    const void* elements,
    uint32_t* num_bytes,
    MojoWriteDataFlags flags) {
  uint32_t params[6];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 5;
  params[1] = (uint32_t)(&data_pipe_producer_handle);
  params[2] = (uint32_t)(elements);
  params[3] = (uint32_t)(num_bytes);
  params[4] = (uint32_t)(&flags);
  params[5] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoBeginWriteData(
    MojoHandle data_pipe_producer_handle,
    void** buffer,
    uint32_t* buffer_num_bytes,
    MojoWriteDataFlags flags) {
  uint32_t params[6];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 6;
  params[1] = (uint32_t)(&data_pipe_producer_handle);
  params[2] = (uint32_t)(buffer);
  params[3] = (uint32_t)(buffer_num_bytes);
  params[4] = (uint32_t)(&flags);
  params[5] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoEndWriteData(
    MojoHandle data_pipe_producer_handle,
    uint32_t num_bytes_written) {
  uint32_t params[4];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 7;
  params[1] = (uint32_t)(&data_pipe_producer_handle);
  params[2] = (uint32_t)(&num_bytes_written);
  params[3] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoReadData(
    MojoHandle data_pipe_consumer_handle,
    void* elements,
    uint32_t* num_bytes,
    MojoReadDataFlags flags) {
  uint32_t params[6];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 8;
  params[1] = (uint32_t)(&data_pipe_consumer_handle);
  params[2] = (uint32_t)(elements);
  params[3] = (uint32_t)(num_bytes);
  params[4] = (uint32_t)(&flags);
  params[5] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoBeginReadData(
    MojoHandle data_pipe_consumer_handle,
    const void** buffer,
    uint32_t* buffer_num_bytes,
    MojoReadDataFlags flags) {
  uint32_t params[6];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 9;
  params[1] = (uint32_t)(&data_pipe_consumer_handle);
  params[2] = (uint32_t)(buffer);
  params[3] = (uint32_t)(buffer_num_bytes);
  params[4] = (uint32_t)(&flags);
  params[5] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoEndReadData(
    MojoHandle data_pipe_consumer_handle,
    uint32_t num_bytes_read) {
  uint32_t params[4];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 10;
  params[1] = (uint32_t)(&data_pipe_consumer_handle);
  params[2] = (uint32_t)(&num_bytes_read);
  params[3] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoTimeTicks irt_MojoGetTimeTicksNow() {
  uint32_t params[2];
  MojoTimeTicks result = 0;
  params[0] = 11;
  params[1] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoClose(MojoHandle handle) {
  uint32_t params[3];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 12;
  params[1] = (uint32_t)(&handle);
  params[2] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoWait(
    MojoHandle handle,
    MojoHandleSignals signals,
    MojoDeadline deadline,
    struct MojoHandleSignalsState* signals_state) {
  uint32_t params[6];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 13;
  params[1] = (uint32_t)(&handle);
  params[2] = (uint32_t)(&signals);
  params[3] = (uint32_t)(&deadline);
  params[4] = (uint32_t)(signals_state);
  params[5] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoWaitMany(
    const MojoHandle* handles,
    const MojoHandleSignals* signals,
    uint32_t num_handles,
    MojoDeadline deadline,
    uint32_t* result_index,
    struct MojoHandleSignalsState* signals_states) {
  uint32_t params[8];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 14;
  params[1] = (uint32_t)(handles);
  params[2] = (uint32_t)(signals);
  params[3] = (uint32_t)(&num_handles);
  params[4] = (uint32_t)(&deadline);
  params[5] = (uint32_t)(result_index);
  params[6] = (uint32_t)(signals_states);
  params[7] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoCreateMessagePipe(
    const struct MojoCreateMessagePipeOptions* options,
    MojoHandle* message_pipe_handle0,
    MojoHandle* message_pipe_handle1) {
  uint32_t params[5];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 15;
  params[1] = (uint32_t)(options);
  params[2] = (uint32_t)(message_pipe_handle0);
  params[3] = (uint32_t)(message_pipe_handle1);
  params[4] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoWriteMessage(
    MojoHandle message_pipe_handle,
    const void* bytes,
    uint32_t num_bytes,
    const MojoHandle* handles,
    uint32_t num_handles,
    MojoWriteMessageFlags flags) {
  uint32_t params[8];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 16;
  params[1] = (uint32_t)(&message_pipe_handle);
  params[2] = (uint32_t)(bytes);
  params[3] = (uint32_t)(&num_bytes);
  params[4] = (uint32_t)(handles);
  params[5] = (uint32_t)(&num_handles);
  params[6] = (uint32_t)(&flags);
  params[7] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt_MojoReadMessage(
    MojoHandle message_pipe_handle,
    void* bytes,
    uint32_t* num_bytes,
    MojoHandle* handles,
    uint32_t* num_handles,
    MojoReadMessageFlags flags) {
  uint32_t params[8];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 17;
  params[1] = (uint32_t)(&message_pipe_handle);
  params[2] = (uint32_t)(bytes);
  params[3] = (uint32_t)(num_bytes);
  params[4] = (uint32_t)(handles);
  params[5] = (uint32_t)(num_handles);
  params[6] = (uint32_t)(&flags);
  params[7] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

static MojoResult irt__MojoGetInitialHandle(MojoHandle* handle) {
  uint32_t params[3];
  MojoResult result = MOJO_RESULT_INVALID_ARGUMENT;
  params[0] = 18;
  params[1] = (uint32_t)(handle);
  params[2] = (uint32_t)(&result);
  DoMojoCall(params, sizeof(params));
  return result;
};

struct nacl_irt_mojo kIrtMojo = {
  &irt_MojoCreateSharedBuffer,
  &irt_MojoDuplicateBufferHandle,
  &irt_MojoMapBuffer,
  &irt_MojoUnmapBuffer,
  &irt_MojoCreateDataPipe,
  &irt_MojoWriteData,
  &irt_MojoBeginWriteData,
  &irt_MojoEndWriteData,
  &irt_MojoReadData,
  &irt_MojoBeginReadData,
  &irt_MojoEndReadData,
  &irt_MojoGetTimeTicksNow,
  &irt_MojoClose,
  &irt_MojoWait,
  &irt_MojoWaitMany,
  &irt_MojoCreateMessagePipe,
  &irt_MojoWriteMessage,
  &irt_MojoReadMessage,
  &irt__MojoGetInitialHandle,
};


size_t mojo_irt_query(const char* interface_ident,
                      void* table,
                      size_t tablesize) {
  static const size_t size = sizeof(kIrtMojo);
  if (0 == strcmp(interface_ident, NACL_IRT_MOJO_v0_1)) {
    if (size <= tablesize) {
      memcpy(table, &kIrtMojo, size);
      return size;
    }
  }
  return 0;
}
