# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'daemon_controller_guid': '655bd819-c08c-4b04-80c2-f160739ff6ef',
    'rdp_desktop_session_guid': '6a7699f0-ee43-43e7-aa30-a6738f9bd470',
    'remoting_base_sources': [
      'base/auto_thread.cc',
      'base/auto_thread.h',
      'base/auto_thread_task_runner.cc',
      'base/auto_thread_task_runner.h',
      'base/buffered_socket_writer.cc',
      'base/buffered_socket_writer.h',
      'base/capabilities.cc',
      'base/capabilities.h',
      'base/compound_buffer.cc',
      'base/compound_buffer.h',
      'base/constants.cc',
      'base/constants.h',
      'base/plugin_thread_task_runner.cc',
      'base/plugin_thread_task_runner.h',
      'base/rate_counter.cc',
      'base/rate_counter.h',
      'base/resources.h',
      'base/resources_linux.cc',
      'base/resources_mac.cc',
      'base/resources_win.cc',
      'base/rsa_key_pair.cc',
      'base/rsa_key_pair.h',
      'base/running_average.cc',
      'base/running_average.h',
      'base/scoped_sc_handle_win.h',
      'base/service_urls.cc',
      'base/service_urls.h',
      'base/socket_reader.cc',
      'base/socket_reader.h',
      'base/typed_buffer.h',
      'base/url_request_context_getter.cc',
      'base/url_request_context_getter.h',
      'base/util.cc',
      'base/util.h',
      'base/vlog_net_log.cc',
      'base/vlog_net_log.h',
    ],
    'remoting_codec_sources': [
      'codec/audio_decoder.cc',
      'codec/audio_decoder.h',
      'codec/audio_decoder_opus.cc',
      'codec/audio_decoder_opus.h',
      'codec/audio_decoder_verbatim.cc',
      'codec/audio_decoder_verbatim.h',
      'codec/audio_encoder.h',
      'codec/audio_encoder_opus.cc',
      'codec/audio_encoder_opus.h',
      'codec/audio_encoder_verbatim.cc',
      'codec/audio_encoder_verbatim.h',
      'codec/scoped_vpx_codec.cc',
      'codec/scoped_vpx_codec.h',
      'codec/video_decoder.h',
      'codec/video_decoder_verbatim.cc',
      'codec/video_decoder_verbatim.h',
      'codec/video_decoder_vpx.cc',
      'codec/video_decoder_vpx.h',
      'codec/video_encoder.h',
      'codec/video_encoder_helper.cc',
      'codec/video_encoder_helper.h',
      'codec/video_encoder_verbatim.cc',
      'codec/video_encoder_verbatim.h',
      'codec/video_encoder_vpx.cc',
      'codec/video_encoder_vpx.h',
    ],

    'remoting_protocol_sources': [
      'protocol/audio_reader.cc',
      'protocol/audio_reader.h',
      'protocol/audio_stub.h',
      'protocol/audio_writer.cc',
      'protocol/audio_writer.h',
      'protocol/auth_util.cc',
      'protocol/auth_util.h',
      'protocol/authentication_method.cc',
      'protocol/authentication_method.h',
      'protocol/authenticator.cc',
      'protocol/authenticator.h',
      'protocol/capability_names.h',
      'protocol/channel_authenticator.h',
      'protocol/channel_dispatcher_base.cc',
      'protocol/channel_dispatcher_base.h',
      'protocol/channel_multiplexer.cc',
      'protocol/channel_multiplexer.h',
      'protocol/channel_socket_adapter.cc',
      'protocol/channel_socket_adapter.h',
      'protocol/chromium_port_allocator.cc',
      'protocol/chromium_port_allocator.h',
      'protocol/chromium_socket_factory.cc',
      'protocol/chromium_socket_factory.h',
      'protocol/client_control_dispatcher.cc',
      'protocol/client_control_dispatcher.h',
      'protocol/client_event_dispatcher.cc',
      'protocol/client_event_dispatcher.h',
      'protocol/client_stub.h',
      'protocol/client_video_dispatcher.cc',
      'protocol/client_video_dispatcher.h',
      'protocol/clipboard_echo_filter.cc',
      'protocol/clipboard_echo_filter.h',
      'protocol/clipboard_filter.cc',
      'protocol/clipboard_filter.h',
      'protocol/clipboard_stub.h',
      'protocol/clipboard_thread_proxy.cc',
      'protocol/clipboard_thread_proxy.h',
      'protocol/connection_to_client.cc',
      'protocol/connection_to_client.h',
      'protocol/connection_to_host.h',
      'protocol/connection_to_host_impl.cc',
      'protocol/connection_to_host_impl.h',
      'protocol/content_description.cc',
      'protocol/content_description.h',
      'protocol/datagram_channel_factory.h',
      'protocol/errors.h',
      'protocol/host_control_dispatcher.cc',
      'protocol/host_control_dispatcher.h',
      'protocol/host_event_dispatcher.cc',
      'protocol/host_event_dispatcher.h',
      'protocol/host_stub.h',
      'protocol/host_video_dispatcher.cc',
      'protocol/host_video_dispatcher.h',
      'protocol/input_event_tracker.cc',
      'protocol/input_event_tracker.h',
      'protocol/input_filter.cc',
      'protocol/input_filter.h',
      'protocol/input_stub.h',
      'protocol/it2me_host_authenticator_factory.cc',
      'protocol/it2me_host_authenticator_factory.h',
      'protocol/jingle_messages.cc',
      'protocol/jingle_messages.h',
      'protocol/jingle_session.cc',
      'protocol/jingle_session.h',
      'protocol/jingle_session_manager.cc',
      'protocol/jingle_session_manager.h',
      'protocol/libjingle_transport_factory.cc',
      'protocol/libjingle_transport_factory.h',
      'protocol/me2me_host_authenticator_factory.cc',
      'protocol/me2me_host_authenticator_factory.h',
      'protocol/message_decoder.cc',
      'protocol/message_decoder.h',
      'protocol/message_reader.cc',
      'protocol/message_reader.h',
      'protocol/message_serialization.cc',
      'protocol/message_serialization.h',
      'protocol/monitored_video_stub.cc',
      'protocol/monitored_video_stub.h',
      'protocol/mouse_input_filter.cc',
      'protocol/mouse_input_filter.h',
      'protocol/name_value_map.h',
      'protocol/negotiating_authenticator_base.cc',
      'protocol/negotiating_authenticator_base.h',
      'protocol/negotiating_client_authenticator.cc',
      'protocol/negotiating_client_authenticator.h',
      'protocol/negotiating_host_authenticator.cc',
      'protocol/negotiating_host_authenticator.h',
      'protocol/network_settings.h',
      'protocol/pairing_authenticator_base.cc',
      'protocol/pairing_authenticator_base.h',
      'protocol/pairing_client_authenticator.cc',
      'protocol/pairing_client_authenticator.h',
      'protocol/pairing_host_authenticator.cc',
      'protocol/pairing_host_authenticator.h',
      'protocol/pairing_registry.cc',
      'protocol/pairing_registry.h',
      'protocol/port_range.cc',
      'protocol/port_range.h',
      'protocol/pseudotcp_adapter.cc',
      'protocol/pseudotcp_adapter.h',
      'protocol/pseudotcp_channel_factory.cc',
      'protocol/pseudotcp_channel_factory.h',
      'protocol/secure_channel_factory.cc',
      'protocol/secure_channel_factory.h',
      'protocol/session.h',
      'protocol/session_config.cc',
      'protocol/session_config.h',
      'protocol/session_manager.h',
      'protocol/socket_util.cc',
      'protocol/socket_util.h',
      'protocol/ssl_hmac_channel_authenticator.cc',
      'protocol/ssl_hmac_channel_authenticator.h',
      'protocol/stream_channel_factory.h',
      'protocol/third_party_authenticator_base.cc',
      'protocol/third_party_authenticator_base.h',
      'protocol/third_party_client_authenticator.cc',
      'protocol/third_party_client_authenticator.h',
      'protocol/third_party_host_authenticator.cc',
      'protocol/third_party_host_authenticator.h',
      'protocol/token_validator.h',
      'protocol/transport.cc',
      'protocol/transport.h',
      'protocol/usb_key_codes.h',
      'protocol/v2_authenticator.cc',
      'protocol/v2_authenticator.h',
      'protocol/video_stub.h',
      'signaling/iq_sender.cc',
      'signaling/iq_sender.h',
      'signaling/jid_util.cc',
      'signaling/jid_util.h',
      'signaling/jingle_info_request.cc',
      'signaling/jingle_info_request.h',
      'signaling/log_to_server.cc',
      'signaling/log_to_server.h',
      'signaling/push_notification_subscriber.cc',
      'signaling/push_notification_subscriber.h',
      'signaling/server_log_entry.cc',
      'signaling/server_log_entry.h',
      'signaling/signal_strategy.h',
      'signaling/xmpp_signal_strategy.cc',
      'signaling/xmpp_signal_strategy.h',
      'signaling/xmpp_stream_parser.cc',
      'signaling/xmpp_stream_parser.h',
      'signaling/xmpp_login_handler.cc',
      'signaling/xmpp_login_handler.h',
    ],

    'remoting_client_sources': [
      'client/audio_decode_scheduler.cc',
      'client/audio_decode_scheduler.h',
      'client/audio_player.cc',
      'client/audio_player.h',
      'client/chromoting_client.cc',
      'client/chromoting_client.h',
      'client/chromoting_stats.cc',
      'client/chromoting_stats.h',
      'client/client_context.cc',
      'client/client_context.h',
      'client/client_status_logger.cc',
      'client/client_status_logger.h',
      'client/client_user_interface.h',
      'client/frame_consumer.h',
      'client/frame_consumer_proxy.cc',
      'client/frame_consumer_proxy.h',
      'client/frame_producer.h',
      'client/key_event_mapper.cc',
      'client/key_event_mapper.h',
      'client/server_log_entry_client.cc',
      'client/server_log_entry_client.h',
      'client/software_video_renderer.cc',
      'client/software_video_renderer.h',
      'client/token_fetcher_proxy.cc',
      'client/token_fetcher_proxy.h',
      'client/video_renderer.h',
    ],

    'remoting_client_plugin_sources': [
      'client/plugin/chromoting_instance.cc',
      'client/plugin/chromoting_instance.h',
      'client/plugin/delegating_signal_strategy.cc',
      'client/plugin/delegating_signal_strategy.h',
      'client/plugin/empty_cursor_filter.cc',
      'client/plugin/empty_cursor_filter.h',
      'client/plugin/normalizing_input_filter_cros.cc',
      'client/plugin/normalizing_input_filter_cros.h',
      'client/plugin/normalizing_input_filter_mac.cc',
      'client/plugin/normalizing_input_filter_mac.h',
      'client/plugin/pepper_address_resolver.cc',
      'client/plugin/pepper_address_resolver.h',
      'client/plugin/pepper_audio_player.cc',
      'client/plugin/pepper_audio_player.h',
      'client/plugin/pepper_cursor_setter.cc',
      'client/plugin/pepper_cursor_setter.h',
      'client/plugin/pepper_input_handler.cc',
      'client/plugin/pepper_input_handler.h',
      'client/plugin/pepper_mouse_locker.cc',
      'client/plugin/pepper_mouse_locker.h',
      'client/plugin/pepper_network_manager.cc',
      'client/plugin/pepper_network_manager.h',
      'client/plugin/pepper_packet_socket_factory.cc',
      'client/plugin/pepper_packet_socket_factory.h',
      'client/plugin/pepper_plugin_thread_delegate.cc',
      'client/plugin/pepper_plugin_thread_delegate.h',
      'client/plugin/pepper_port_allocator.cc',
      'client/plugin/pepper_port_allocator.h',
      'client/plugin/pepper_util.cc',
      'client/plugin/pepper_util.h',
      'client/plugin/pepper_video_renderer.h',
      'client/plugin/pepper_video_renderer_2d.cc',
      'client/plugin/pepper_video_renderer_2d.h',
      'client/plugin/pepper_video_renderer_3d.cc',
      'client/plugin/pepper_video_renderer_3d.h',
      'client/plugin/touch_input_scaler.cc',
      'client/plugin/touch_input_scaler.h',
    ],
  }
}
