// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_ACCESSIBILITY_BROWSER_ACCESSIBILITY_MAC_H_
#define CONTENT_BROWSER_ACCESSIBILITY_BROWSER_ACCESSIBILITY_MAC_H_

#include <map>
#include <utility>
#include <vector>

#include "content/browser/accessibility/browser_accessibility.h"

@class BrowserAccessibilityCocoa;

namespace content {

class BrowserAccessibilityMac : public BrowserAccessibility {
 public:
  // BrowserAccessibility overrides.
  void NativeReleaseReference() override;
  bool IsNative() const override;
  void OnDataChanged() override;

  // The BrowserAccessibilityCocoa associated with us.
  BrowserAccessibilityCocoa* native_view() const {
    return browser_accessibility_cocoa_;
  }

  // Detach the BrowserAccessibilityCocoa object and then recreate it.
  // This is only used to work around VoiceOver bugs by forcing VoiceOver
  // to rebuild its internal state.
  void RecreateNativeObject();

 private:
  // This gives BrowserAccessibility::Create access to the class constructor.
  friend class BrowserAccessibility;

  BrowserAccessibilityMac();

  // Allows access to the BrowserAccessibilityCocoa which wraps this.
  // BrowserAccessibility.
  // We own this object until our manager calls ReleaseReference;
  // thereafter, the cocoa object owns us.
  BrowserAccessibilityCocoa* browser_accessibility_cocoa_;
  DISALLOW_COPY_AND_ASSIGN(BrowserAccessibilityMac);
};

}  // namespace content

#endif  // CONTENT_BROWSER_ACCESSIBILITY_BROWSER_ACCESSIBILITY_MAC_H_
