/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.checks.imports.Guard;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgControl;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ImportControlLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Import Control 1.0//EN";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Import Control 1.1//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_0.dtd";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_1.dtd";
    private final Deque<PkgControl> stack = new ArrayDeque<PkgControl>();
    private static final Map<String, String> DTD_RESOURCE_BY_ID = new HashMap<String, String>();

    private ImportControlLoader() throws ParserConfigurationException, SAXException {
        super(DTD_RESOURCE_BY_ID);
    }

    @Override
    public void startElement(String namespaceURI, String locqName, String qName, Attributes atts) throws SAXException {
        if ("import-control".equals(qName)) {
            String pkg = this.safeGet(atts, "pkg");
            this.stack.push(new PkgControl(pkg));
        } else if ("subpackage".equals(qName)) {
            assert (!this.stack.isEmpty());
            String name = this.safeGet(atts, "name");
            this.stack.push(new PkgControl(this.stack.peek(), name));
        } else if ("allow".equals(qName) || "disallow".equals(qName)) {
            Guard g;
            boolean regex;
            assert (!this.stack.isEmpty());
            boolean isAllow = "allow".equals(qName);
            boolean isLocalOnly = atts.getValue("local-only") != null;
            String pkg = atts.getValue("pkg");
            boolean bl = regex = atts.getValue("regex") != null;
            if (pkg != null) {
                boolean exactMatch = atts.getValue("exact-match") != null;
                g = new Guard(isAllow, isLocalOnly, pkg, exactMatch, regex);
            } else {
                String clazz = this.safeGet(atts, "class");
                g = new Guard(isAllow, isLocalOnly, clazz, regex);
            }
            PkgControl pc = this.stack.peek();
            pc.addGuard(g);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if ("subpackage".equals(qName)) {
            assert (this.stack.size() > 1);
            this.stack.pop();
        }
    }

    static PkgControl load(URI uri) throws CheckstyleException {
        InputStream is = null;
        try {
            is = uri.toURL().openStream();
        }
        catch (MalformedURLException e) {
            throw new CheckstyleException("syntax error in url " + uri, e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to find " + uri, e);
        }
        InputSource source = new InputSource(is);
        return ImportControlLoader.load(source, uri);
    }

    private static PkgControl load(InputSource source, URI uri) throws CheckstyleException {
        try {
            ImportControlLoader loader = new ImportControlLoader();
            loader.parseInputSource(source);
            return loader.getRoot();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new CheckstyleException("unable to parse " + uri + " - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read " + uri, e);
        }
    }

    private PkgControl getRoot() {
        assert (this.stack.size() == 1);
        return this.stack.peek();
    }

    private String safeGet(Attributes atts, String name) throws SAXException {
        String retVal = atts.getValue(name);
        if (retVal == null) {
            throw new SAXException("missing attribute " + name);
        }
        return retVal;
    }

    static {
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
    }
}

