/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.SortedSet;

public class IndentLevel {
    private final SortedSet<Integer> mLevels = Sets.newTreeSet();

    public IndentLevel(int aIndent) {
        this.mLevels.add(aIndent);
    }

    public IndentLevel(IndentLevel aBase, int ... aOffsets) {
        for (Integer base : aBase.mLevels) {
            for (int offset : aOffsets) {
                this.mLevels.add(base + offset);
            }
        }
    }

    public final boolean isMultiLevel() {
        return this.mLevels.size() > 1;
    }

    public boolean accept(int aIndent) {
        return this.mLevels.contains(aIndent);
    }

    public boolean gt(int aIndent) {
        return this.mLevels.first() > aIndent;
    }

    public void addAcceptedIndent(int aIndent) {
        this.mLevels.add(aIndent);
    }

    public void addAcceptedIndent(IndentLevel aIndent) {
        this.mLevels.addAll(aIndent.mLevels);
    }

    public int getFirstIndentLevel() {
        return this.mLevels.first();
    }

    public int getLastIndentLevel() {
        return this.mLevels.last();
    }

    public String toString() {
        return Joiner.on(", ").join(this.mLevels);
    }
}

