/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import java.util.Set;

public final class ParameterAssignmentCheck
extends Check {
    private final FastStack<Set<String>> mParameterNamesStack = FastStack.newInstance();
    private Set<String> mParameterNames;

    public int[] getDefaultTokens() {
        return new int[]{8, 9, 81, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 131, 25, 132, 26};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST aRootAST) {
        this.mParameterNamesStack.clear();
        this.mParameterNames = null;
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: {
                this.visitMethodDef(aAST);
                break;
            }
            case 81: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                this.visitAssign(aAST);
                break;
            }
            case 25: 
            case 26: 
            case 131: 
            case 132: {
                this.visitIncDec(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: {
                this.leaveMethodDef();
                break;
            }
            case 25: 
            case 26: 
            case 81: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 131: 
            case 132: {
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void visitAssign(DetailAST aAST) {
        this.checkIdent(aAST);
    }

    private void visitIncDec(DetailAST aAST) {
        this.checkIdent(aAST);
    }

    private void checkIdent(DetailAST aAST) {
        DetailAST identAST;
        if (this.mParameterNames != null && !this.mParameterNames.isEmpty() && (identAST = aAST.getFirstChild()) != null && identAST.getType() == 59 && this.mParameterNames.contains(identAST.getText())) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "parameter.assignment", identAST.getText());
        }
    }

    private void visitMethodDef(DetailAST aAST) {
        this.mParameterNamesStack.push(this.mParameterNames);
        this.mParameterNames = Sets.newHashSet();
        this.visitMethodParameters(aAST.findFirstToken(20));
    }

    private void leaveMethodDef() {
        this.mParameterNames = this.mParameterNamesStack.pop();
    }

    private void visitMethodParameters(DetailAST aAST) {
        for (DetailAST parameterDefAST = aAST.findFirstToken(21); parameterDefAST != null; parameterDefAST = parameterDefAST.getNextSibling()) {
            if (parameterDefAST.getType() != 21) continue;
            DetailAST param = parameterDefAST.findFirstToken(59);
            this.mParameterNames.add(param.getText());
        }
    }
}

