/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Utils {
    private static final ConcurrentMap<String, Pattern> CREATED_RES = Maps.newConcurrentMap();
    private static final Log EXCEPTION_LOG = LogFactory.getLog("com.puppycrawl.tools.checkstyle.ExceptionLog");

    private Utils() {
    }

    public static Log getExceptionLogger() {
        return EXCEPTION_LOG;
    }

    public static boolean whitespaceBefore(int aIndex, String aLine) {
        for (int i = 0; i < aIndex; ++i) {
            if (Character.isWhitespace(aLine.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int lengthMinusTrailingWhitespace(String aLine) {
        int len = aLine.length();
        for (int i = len - 1; i >= 0 && Character.isWhitespace(aLine.charAt(i)); --i) {
            --len;
        }
        return len;
    }

    public static int lengthExpandedTabs(String aString, int aToIdx, int aTabWidth) {
        int len = 0;
        char[] chars = aString.toCharArray();
        for (int idx = 0; idx < aToIdx; ++idx) {
            if (chars[idx] == '\t') {
                len = (len / aTabWidth + 1) * aTabWidth;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static Pattern getPattern(String aPattern) throws PatternSyntaxException {
        return Utils.getPattern(aPattern, 0);
    }

    public static Pattern getPattern(String aPattern, int aCompileFlags) throws PatternSyntaxException {
        String key = aPattern + ":flags-" + aCompileFlags;
        Pattern retVal = (Pattern)CREATED_RES.get(key);
        if (retVal == null) {
            retVal = Pattern.compile(aPattern, aCompileFlags);
            CREATED_RES.putIfAbsent(key, retVal);
        }
        return retVal;
    }

    @Deprecated
    public static String[] getLines(String aFileName) throws IOException {
        return Utils.getLines(aFileName, System.getProperty("file.encoding", "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String[] getLines(String aFileName, String aCharsetName) throws IOException {
        ArrayList<String> lines = Lists.newArrayList();
        FileInputStream fr = new FileInputStream(aFileName);
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(new InputStreamReader((InputStream)fr, aCharsetName));
        }
        catch (UnsupportedEncodingException ex) {
            fr.close();
            String message = "unsupported charset: " + ex.getMessage();
            throw new UnsupportedEncodingException(message);
        }
        try {
            String l;
            while ((l = lnr.readLine()) != null) {
                lines.add(l);
            }
        }
        finally {
            Utils.closeQuietly(lnr);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static Pattern createPattern(String aPattern) throws ConversionException {
        Pattern retVal = null;
        try {
            retVal = Utils.getPattern(aPattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("Failed to initialise regexp expression " + aPattern, e);
        }
        return retVal;
    }

    public static String baseClassname(String aType) {
        int i = aType.lastIndexOf(".");
        return i == -1 ? aType : aType.substring(i + 1);
    }

    public static String getStrippedFileName(String aBasedir, String aFileName) {
        String stripped;
        if (aBasedir == null || !aFileName.startsWith(aBasedir)) {
            stripped = aFileName;
        } else {
            int skipSep = aBasedir.endsWith(File.separator) ? 0 : 1;
            stripped = aFileName.substring(aBasedir.length() + skipSep);
        }
        return stripped;
    }

    public static void closeQuietly(Closeable aShutting) {
        if (null != aShutting) {
            try {
                aShutting.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

