/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.closure.compiler;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.ChromePassConfig;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chromium.closure.compiler.ChromeCodingConvention;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Runner {
    protected final Flags flags = new Flags();
    private final PrintStream err;
    private boolean isConfigValid;

    public Runner(String[] stringArray, PrintStream printStream) {
        this.err = printStream;
        List<String> list = this.processArgs(stringArray);
        CmdLineParser cmdLineParser = new CmdLineParser(this.flags);
        this.isConfigValid = true;
        try {
            cmdLineParser.parseArgument(list.toArray(new String[0]));
            if (this.flags.compilerArgsFile == null) {
                this.isConfigValid = false;
            }
        }
        catch (CmdLineException cmdLineException) {
            printStream.println(cmdLineException.getMessage());
            this.isConfigValid = false;
        }
        if (!this.isConfigValid) {
            cmdLineParser.printUsage(printStream);
        }
    }

    private List<String> processArgs(String[] stringArray) {
        Pattern pattern = Pattern.compile("(--[a-zA-Z_]+)=(.*)");
        Pattern pattern2 = Pattern.compile("^['\"](.*)['\"]$");
        ArrayList<String> arrayList = Lists.newArrayList();
        for (String string : stringArray) {
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                arrayList.add(matcher.group(1));
                String string2 = matcher.group(2);
                Matcher matcher2 = pattern2.matcher(string2);
                if (matcher2.matches()) {
                    arrayList.add(matcher2.group(1));
                    continue;
                }
                arrayList.add(string2);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean shouldRunCompiler() {
        return this.isConfigValid;
    }

    protected void logError(String string, Exception exception) {
        this.err.println("ERROR: " + string);
        if (exception != null) {
            exception.printStackTrace(this.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        List<CompilerInstanceDescriptor> list = this.getDescriptors();
        if (list == null) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(list.size(), Runtime.getRuntime().availableProcessors() / 2 + 1));
        try {
            this.runWithExecutor(list, executorService);
        }
        finally {
            executorService.shutdown();
        }
    }

    private void runWithExecutor(List<CompilerInstanceDescriptor> list, ExecutorService executorService) {
        CompilerRunner compilerRunner;
        ArrayList<Future<CompilerRunner>> arrayList = new ArrayList<Future<CompilerRunner>>(list.size());
        for (CompilerInstanceDescriptor object : list) {
            compilerRunner = new CompilerRunner(object, new ByteArrayOutputStream(512));
            arrayList.add(executorService.submit(compilerRunner));
        }
        for (Future future : arrayList) {
            try {
                compilerRunner = (CompilerRunner)future.get();
                compilerRunner.errStream.flush();
                System.err.println(compilerRunner.errStream.toString("UTF-8"));
                if (compilerRunner.result == 0) continue;
                System.exit(compilerRunner.result);
            }
            catch (Exception exception) {
                System.err.println("ERROR: " + exception.getMessage());
                System.exit(1);
            }
        }
        System.exit(0);
    }

    private List<CompilerInstanceDescriptor> getDescriptors() {
        ArrayList<CompilerInstanceDescriptor> arrayList = new ArrayList<CompilerInstanceDescriptor>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.flags.compilerArgsFile), "UTF-8"));){
            int n = 0;
            while (true) {
                ++n;
                String string = bufferedReader.readLine();
                if (string == null) {
                    break;
                }
                if (string.length() == 0) continue;
                String[] stringArray = string.split(" +", 2);
                if (stringArray.length != 2) {
                    this.logError(String.format("Line %d does not contain module name and compiler arguments", n), null);
                    continue;
                }
                arrayList.add(new CompilerInstanceDescriptor(stringArray[0], stringArray[1]));
            }
        }
        catch (IOException iOException) {
            this.logError("Failed to read compiler arguments file", iOException);
            return null;
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        Runner runner = new Runner(stringArray, System.err);
        if (runner.shouldRunCompiler()) {
            runner.run();
        } else {
            System.exit(-1);
        }
    }

    private static class CompilerInstanceDescriptor {
        private final String moduleName;
        private final String commandLine;

        public CompilerInstanceDescriptor(String string, String string2) {
            this.moduleName = string;
            this.commandLine = string2;
        }
    }

    private static class Flags {
        @Option(name="--compiler-args-file", usage="Full path to file containing compiler arguments (one line per instance)")
        private String compilerArgsFile = null;

        private Flags() {
        }
    }

    private static class CompilerRunner
    implements Callable<CompilerRunner> {
        private final CompilerInstanceDescriptor descriptor;
        private final ByteArrayOutputStream errStream;
        private int result;

        public CompilerRunner(CompilerInstanceDescriptor compilerInstanceDescriptor, ByteArrayOutputStream byteArrayOutputStream) {
            this.descriptor = compilerInstanceDescriptor;
            this.errStream = byteArrayOutputStream;
        }

        @Override
        public CompilerRunner call() throws Exception {
            PrintStream printStream = new PrintStream((OutputStream)this.errStream, false, "UTF-8");
            LocalCommandLineRunner localCommandLineRunner = new LocalCommandLineRunner(this.prepareArgs(), System.out, printStream);
            if (!localCommandLineRunner.shouldRunCompiler()) {
                this.result = -1;
            }
            this.result = localCommandLineRunner.execute();
            return this;
        }

        private String[] prepareArgs() {
            return this.descriptor.commandLine.split(" +");
        }
    }

    private static class LocalCommandLineRunner
    extends CommandLineRunner {
        protected LocalCommandLineRunner(String[] stringArray, PrintStream printStream, PrintStream printStream2) {
            super(stringArray, printStream, printStream2);
        }

        @Override
        protected CompilerOptions createOptions() {
            CompilerOptions compilerOptions = super.createOptions();
            compilerOptions.setIdeMode(true);
            compilerOptions.setExtraAnnotationNames(Collections.singletonList("suppressReceiverCheck"));
            return compilerOptions;
        }

        @Override
        protected void setRunOptions(CompilerOptions compilerOptions) throws AbstractCommandLineRunner.FlagUsageException, IOException {
            super.setRunOptions(compilerOptions);
            compilerOptions.setCodingConvention(new ChromeCodingConvention());
            ((Compiler)this.getCompiler()).setPassConfig(new ChromePassConfig(compilerOptions));
        }

        int execute() {
            int n = 0;
            int n2 = 1;
            try {
                for (int i = 0; i < n2 && n == 0; ++i) {
                    n = this.doRun();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                n = -2;
            }
            return n;
        }
    }
}

