/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.closure.compiler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ChromeCodingConvention
extends CodingConventions.Proxy {
    private final Set<String> indirectlyDeclaredProperties;

    public ChromeCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public ChromeCodingConvention(CodingConvention codingConvention) {
        super(codingConvention);
        HashSet<String> hashSet = Sets.newHashSet("instance_", "getInstance");
        hashSet.addAll(codingConvention.getIndirectlyDeclaredProperties());
        this.indirectlyDeclaredProperties = ImmutableSet.copyOf(hashSet);
    }

    @Override
    public String getSingletonGetterClassName(Node node) {
        Node node2 = node.getFirstChild();
        if (!node2.matchesQualifiedName("cr.addSingletonGetter") || node.getChildCount() != 2) {
            return super.getSingletonGetterClassName(node);
        }
        return node2.getNext().getQualifiedName();
    }

    @Override
    public void applySingletonGetter(FunctionType functionType, FunctionType functionType2, ObjectType objectType) {
        super.applySingletonGetter(functionType, functionType2, objectType);
        functionType.defineDeclaredProperty("getInstance", functionType2, functionType.getSource());
        functionType.defineDeclaredProperty("instance_", objectType, functionType.getSource());
    }

    @Override
    public Collection<String> getIndirectlyDeclaredProperties() {
        return this.indirectlyDeclaredProperties;
    }

    @Override
    public Collection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
        return ImmutableList.of(new CodingConvention.AssertionFunctionSpec("assert"), new ClosureCodingConvention.AssertInstanceofSpec("cr.ui.decorate"));
    }
}

