/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.play_billing;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.InAppMessageResult;
import com.android.billingclient.api.Purchase;
import com.google.android.gms.internal.play_billing.zza;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public final class zzb {
    public static final int zza = Runtime.getRuntime().availableProcessors();

    private static int zzl(Bundle bundle, String string) {
        if (bundle == null) {
            zzb.zzj(string, "Unexpected null bundle received!");
            return 0;
        }
        return bundle.getInt("IN_APP_MESSAGE_RESPONSE_CODE", 0);
    }

    public static int zza(Intent intent, String string) {
        string = "ProxyBillingActivity";
        if (intent == null) {
            zzb.zzj(string, "Got null intent!");
            return 0;
        }
        return zzb.zzl(intent.getExtras(), string);
    }

    public static int zzb(Bundle object, String string) {
        if (object == null) {
            zzb.zzj(string, "Unexpected null bundle received!");
            return 6;
        }
        if ((object = object.get("RESPONSE_CODE")) == null) {
            zzb.zzi(string, "getResponseCodeFromBundle() got null response code, assuming OK");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        object = String.valueOf(object.getClass().getName());
        zzb.zzj(string, "Unexpected type for bundle response code: ".concat((String)object));
        return 6;
    }

    public static Bundle zzc(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        if (bl) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        return bundle;
    }

    public static BillingResult zzd(Intent intent, String string) {
        if (intent == null) {
            zzb.zzj("BillingHelper", "Got null intent!");
            BillingResult.Builder builder = BillingResult.newBuilder();
            builder.setResponseCode(6);
            builder.setDebugMessage("An internal error occurred.");
            return builder.build();
        }
        BillingResult.Builder builder = BillingResult.newBuilder();
        builder.setResponseCode(zzb.zzb(intent.getExtras(), string));
        builder.setDebugMessage(zzb.zzf(intent.getExtras(), string));
        return builder.build();
    }

    public static InAppMessageResult zze(Bundle bundle, String string) {
        if (bundle == null) {
            return new InAppMessageResult(0, null);
        }
        return new InAppMessageResult(zzb.zzl(bundle, "BillingClient"), bundle.getString("IN_APP_MESSAGE_PURCHASE_TOKEN"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Purchase zzm(String object, String string) {
        if (object == null || string == null) {
            zzb.zzi("BillingHelper", "Received a null purchase data.");
            return null;
        }
        try {
            Purchase purchase = new Purchase((String)object, string);
            return purchase;
        }
        catch (JSONException jSONException) {
            object = "Got JSONException while parsing purchase data: ".concat(((Object)((Object)jSONException)).toString());
            zzb.zzj("BillingHelper", (String)object);
            return null;
        }
    }

    public static String zzf(Bundle object, String string) {
        String string2 = "";
        if (object == null) {
            zzb.zzj(string, "Unexpected null bundle received!");
            return string2;
        }
        if ((object = object.get("DEBUG_MESSAGE")) == null) {
            zzb.zzi(string, "getDebugMessageFromBundle() got null response code, assuming OK");
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        object = String.valueOf(object.getClass().getName());
        zzb.zzj(string, "Unexpected type for debug message: ".concat((String)object));
        return string2;
    }

    public static String zzg(int n) {
        return com.google.android.gms.internal.play_billing.zza.zza(n).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static List zzh(Bundle object) {
        Object object2 = object;
        ArrayList arrayList = object2.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
        ArrayList arrayList2 = object2.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
        ArrayList<Purchase> arrayList3 = new ArrayList<Purchase>();
        if (arrayList == null || arrayList2 == null) {
            Purchase purchase = zzb.zzm(object.getString("INAPP_PURCHASE_DATA"), object.getString("INAPP_DATA_SIGNATURE"));
            if (purchase == null) {
                zzb.zzi("BillingHelper", "Couldn't find single purchase data as well.");
                return null;
            }
            arrayList3.add(purchase);
            return arrayList3;
        } else {
            void var0_4;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Found purchase list of ");
            stringBuilder.append(arrayList.size());
            stringBuilder.append(" items");
            String string = stringBuilder.toString();
            zzb.zzi("BillingHelper", string);
            boolean bl = false;
            while (var0_4 < arrayList.size() && var0_4 < arrayList2.size()) {
                Purchase purchase = zzb.zzm((String)arrayList.get((int)var0_4), (String)arrayList2.get((int)var0_4));
                if (purchase != null) {
                    arrayList3.add(purchase);
                }
                ++var0_4;
            }
        }
        return arrayList3;
    }

    public static void zzi(String string, String string2) {
        if (Log.isLoggable((String)string, (int)2)) {
            if (!string2.isEmpty()) {
                int n;
                for (int i = 40000; !string2.isEmpty() && i > 0; i -= n) {
                    n = Math.min(string2.length(), Math.min(4000, i));
                    Log.v((String)string, (String)string2.substring(0, n));
                    string2 = string2.substring(n);
                }
            } else {
                Log.v((String)string, (String)string2);
                return;
            }
        }
    }

    public static void zzj(String string, String string2) {
        if (Log.isLoggable((String)string, (int)5)) {
            Log.w((String)string, (String)string2);
            return;
        }
    }

    public static void zzk(String string, String string2, Throwable throwable) {
        if (Log.isLoggable((String)string, (int)5)) {
            Log.w((String)string, (String)string2, (Throwable)throwable);
            return;
        }
    }
}

