/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.8
import Qt.labs.handlers 1.0

Rectangle {
    id: root
    width: 500
    height: 480
    objectName: "root"
    color: "#222222"

    Flickable {
        anchors.fill: parent
        anchors.margins: 10
        anchors.topMargin: 40
        contentHeight: 600
        contentWidth: 600
//        pressDelay: TODO

        Row {
            spacing: 6
            Slider {
                label: "DragHandler"
                objectName: "Slider"
                value: 49; width: 100; height: 400
            }
            Column {
                spacing: 6
                TapHandlerButton {
                    objectName: "DragThreshold"
                    label: "DragThreshold"
                    gesturePolicy: TapHandler.DragThreshold
                }
                TapHandlerButton {
                    objectName: "WithinBounds"
                    label: "WithinBounds"
                    gesturePolicy: TapHandler.WithinBounds
                }
                TapHandlerButton {
                    objectName: "ReleaseWithinBounds"
                    label: "ReleaseWithinBounds"
                    gesturePolicy: TapHandler.ReleaseWithinBounds // the default
                }
            }
            Column {
                spacing: 6
                Rectangle {
                    width: 50
                    height: 50
                    color: "aqua"
                    border.color: drag1.active ? "darkgreen" : "transparent"
                    border.width: 3
                    objectName: "drag"
                    DragHandler {
                        id: drag1
                    }
                    Text {
                        anchors.centerIn: parent
                        enabled: false
                        text: "drag"
                    }
                }
                Rectangle {
                    width: 50
                    height: 50
                    color: "aqua"
                    objectName: "tap"
                    border.color: tap1.isPressed ? "red" : "transparent"
                    border.width: 3
                    TapHandler {
                        id: tap1
                        gesturePolicy: TapHandler.DragThreshold
                    }
                    Text {
                        anchors.centerIn: parent
                        enabled: false
                        text: "tap"
                    }
                }
                Rectangle {
                    width: 50
                    height: 50
                    color: "aqua"
                    border.color: tap2.isPressed ? "red" : drag2.active ? "darkgreen" : "transparent"
                    border.width: 3
                    objectName: "dragAndTap"
                    DragHandler {
                        id: drag2
                    }
                    TapHandler {
                        id: tap2
                        gesturePolicy: TapHandler.DragThreshold
                    }
                    Text {
                        anchors.centerIn: parent
                        enabled: false
                        text: "drag\nand\ntap"
                    }
                }
                Rectangle {
                    width: 50
                    height: 50
                    color: "aqua"
                    border.color: tap3.isPressed ? "red" : drag3.active ? "darkgreen" : "transparent"
                    border.width: 3
                    objectName: "tapAndDrag"
                    TapHandler {
                        id: tap3
                        gesturePolicy: TapHandler.DragThreshold
                    }
                    DragHandler {
                        id: drag3
                    }
                    Text {
                        anchors.centerIn: parent
                        enabled: false
                        text: "tap\nand\ndrag"
                    }
                }
            }
        }
    }
}

