/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Author: Milian Wolff, KDAB (milian.wolff@kdab.com)
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#ifndef ANALYZER_VALGRIND_SUPPRESSIONDIALOG_H
#define ANALYZER_VALGRIND_SUPPRESSIONDIALOG_H

#include "xmlprotocol/error.h"

#include <utils/pathchooser.h>

#include <QDialog>

QT_BEGIN_NAMESPACE
class QPlainTextEdit;
class QDialogButtonBox;
QT_END_NAMESPACE

namespace Valgrind {
namespace Internal {

class MemcheckErrorView;
class ValgrindBaseSettings;

class SuppressionDialog : public QDialog
{
    Q_OBJECT

public:
    SuppressionDialog(MemcheckErrorView *view,
                      const QList<XmlProtocol::Error> &errors);
    static void maybeShow(MemcheckErrorView *view);

private slots:
    void validate();

private:
    void accept();
    void reject();

    MemcheckErrorView *m_view;
    ValgrindBaseSettings *m_settings;
    bool m_cleanupIfCanceled;
    QList<XmlProtocol::Error> m_errors;

    Utils::PathChooser *m_fileChooser;
    QPlainTextEdit *m_suppressionEdit;
    QDialogButtonBox *m_buttonBox;
};

} // namespace Internal
} // namespace Valgrind

#endif // ANALYZER_VALGRIND_SUPPRESSIONDIALOG_H
