/*---------------------------------------------------------------------------------
 * General-purpose scanner.
 *
 * Filename:    skanx.h 
 * Author:      Randall Gellens.
 * Version:     1.1
 * Last edited: 28 May, 1998
 *---------------------------------------------------------------------------------
 */

#ifndef __skanx__
#define __skanx__

#include "missing.h"

/*--------------------------------------------------------------------------------
 *                t y p e d e f s
 *--------------------------------------------------------------------------------
*/

typedef enum
    {
    tkEnd = 1,                  /* end-of-file */
    tkID,                       /* token starts with a letter */
    tkNum,                      /* token is a number */
    tkStr,                      /* token is a quoted string */
    tkSpec                      /* token is a special character */
    } token_type;

/* get_next_token flags */

#define gtkfBrkWS       0x0001  /* break on white space only */
#define gtkfNoNum       0x0002  /* digits are tkID, not tkNum */
#define gtkfDashOK      0x0004  /* IDs can contain dashes ("-") */
#define gtkfUnderOK     0x0008  /* IDs can contain underbars ("_") */
#define gtkfLeadDigOK   0x0010  /* IDs can start with digits */
#define gtkfNoQuotes    0x0020  /* treat quotes as any other special */

#define gtNormal          ( 0 ) /* no special handling */


          
/* scanner initializtion flags */
    /* none currently */

/* maximum backup depth
 *
 * define MAX_PARSER_BACKUP to be the depth you desire;
 * must define this in your code prior to including this file.
 */

#ifndef MAX_PARSER_BACKUP
#define MAX_PARSER_BACKUP    5  /* maximum depth we can back up */
#endif


typedef struct                  
    {
    char           *pTokenS;      /* points to start of token (not null-terminated) */
    char           *pTokenE;      /* points just past token */
    int             iTokenLen;    /* length of current token */
    long            lTokenVal;    /* value of token (integer or character) */
    token_type      TokenType;    /* what kind of token */
    char            cComment;     /* comment character, or 0 */
    char            cEscape;      /* escape sequences for strings, or 0 */
    int             flags;
    char           *history [MAX_PARSER_BACKUP];
    int             iHistX;       /* index into circular history table */
    } strParseLine;


/*--------------------------------------------------------------------------------
 *                m a c r o s
 *--------------------------------------------------------------------------------
*/

#define CHAR_IS_LETT(c)  ( (c>='A' && c<='Z') || (c>='a' && c<='z') )
#define CHAR_IS_DIGT(c)    (c>='0' && c<='9')
#define CHAR_IS_ALPH(c)  ( CHAR_IS_LETT(c) || CHAR_IS_DIGT(c)       )
#define CHAR_IS_SIGN(c)    (c=='-' || c=='+')

#define szTOKEN_TYPE_NAME(t)    szTokenTypeNames+(t*5)


/*--------------------------------------------------------------------------------
 *                p r o t o t y p e s
 *--------------------------------------------------------------------------------
*/


void        init_strParseLine(strParseLine *psPL, char cCom, char cEsc, int flags);
int         setup_new_line(strParseLine *psPL, char *pszLine);
token_type  get_next_token(strParseLine *psPL, unsigned short flags);
int         backup_token  (strParseLine *psPL, short iDepth);
int         check_token     (const char *psz, const strParseLine *psPL);
int         check_token_init(const char *psz, const strParseLine *psPL);
int         char_is_ws   (char  c);
char       *skip_ws      (char *p);
char       *skip_token_ws(char *p);
char       *skip_letters (char *p);
char       *skip_digits  (char *p);
char       *skip_alpha   (char *p);
char       *check_digits (char *p, int *fNonDig);
char       *check_id     (char *p, int *fNonDig, unsigned short flags);
char       *skip_quote   (char *p, char esc);
char       *get_string(strParseLine *psPL, int fEmptyOK);
long        get_integer(strParseLine *psPL);
char       *translate_esc(char *pStr, long iLen, char cEsc);


#endif