%global module_dir %{_libdir}/qore-modules/
%global user_module_dir %{_datadir}/qore-modules/

Name: qore
Version: 1.2.0
Release: 1%{?dist}
Summary: Multithreaded Programming Language

# see https://github.com/qorelanguage/qore/blob/develop/README-LICENSE for license info
License: LGPLv2+ or GPLv2+ or MIT
URL: https://qore.org
Source0: https://github.com/qorelanguage/qore/releases/download/release-%{version}/%{name}-%{version}.tar.bz2

Requires: libqore%{?_isa} = %{version}-%{release}
Requires: %{name}-stdlib%{?_isa} = %{version}-%{release}
BuildRequires: gcc-c++
BuildRequires: flex >= 2.5.31
BuildRequires: bison
BuildRequires: pcre-devel
BuildRequires: gmp-devel
BuildRequires: pkgconfig
BuildRequires: pkgconfig(openssl)
BuildRequires: pkgconfig(zlib)
BuildRequires: pkgconfig(mpfr)
BuildRequires: pkgconfig(bzip2)
BuildRequires: doxygen

%description
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

%package -n libqore
Summary: The libraries for the qore runtime and qore clients
Provides: qore-module(abi)%{?_isa} = 1.2
Provides: qore-module(abi)%{?_isa} = 1.1
Provides: qore-module(abi)%{?_isa} = 1.0

%description -n libqore
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides the qore library required for all clients using qore
functionality.

%files -n libqore
%{_libdir}/libqore.so.7.4.1
%{_libdir}/libqore.so.7
%license COPYING.LGPL COPYING.GPL COPYING.MIT README-LICENSE
%doc README.md README-MODULES RELEASE-NOTES AUTHORS ABOUT

%package stdlib
Summary: Standard library modules
Requires: libqore%{?_isa} = %{version}-%{release}
Recommends: %{name} = %{version}

%description stdlib
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides the Qore language standard library user and binary
modules.

%files stdlib
%{user_module_dir}
%{module_dir}
%license COPYING.MIT README-LICENSE

%package doc
Summary: API documentation, programming language reference, and Qore example programs
BuildArch: noarch
Recommends: %{name} = %{version}

%description doc
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides the HTML documentation for the Qore programming language
and also for user modules delivered with Qore and also example programs.

%files doc
%license COPYING.LGPL COPYING.GPL COPYING.MIT README-LICENSE
%doc docs/lang docs/modules/* examples/

%package devel
Summary: The header files needed to compile programs using the qore library
Requires: libqore%{?_isa} = %{version}-%{release}
Recommends: %{name}%{?_isa} = %{version}

%description devel
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides header files needed to compile client programs using the
Qore library.

%files devel
%{_bindir}/qpp
%{_bindir}/qdx
%{_bindir}/qjar
%{_libdir}/libqore.so
%{_libdir}/pkgconfig/qore.pc
%dir %{_libdir}/cmake
%{_libdir}/cmake/Qore/
%{_includedir}/qore/
%{_datarootdir}/qore/Doxyfile.in
%{_datarootdir}/qore/qore-logo-55x200.png
%license COPYING.LGPL COPYING.GPL COPYING.MIT README-LICENSE

%package devel-doc
Summary: C++ API documentation for the qore library
BuildArch: noarch
Recommends: %{name}-devel = %{version}

%description devel-doc
Qore is a scripting language supporting threading and embedded logic, designed
for applying a flexible scripting-based approach to enterprise interface
development but is also useful as a general purpose language.

This package provides HTML documentation for the C++ API for the Qore library.

%files devel-doc
%license COPYING.LGPL COPYING.GPL COPYING.MIT README-LICENSE
%doc docs/library/html/*

%package misc-tools
Summary: Miscellaneous user tools writen in Qore Programming Language
License: LGPLv2+ or GPLv2+ or MIT
Requires: %{name} = %{version}-%{release}
BuildArch: noarch

%description misc-tools
This package contains tool for working with:
 - REST APIs
 - SQL Databases

%files misc-tools
%{_bindir}/qdp
%{_bindir}/qget
%{_bindir}/rest
%{_bindir}/sfrest
%{_bindir}/saprest
%{_bindir}/sqlutil
%{_bindir}/schema-reverse
%license COPYING.LGPL COPYING.GPL COPYING.MIT README-LICENSE

%prep
%setup -q
# silence the executable warning for examples
find examples -type f -exec chmod -x {} \;

%build
export CXXFLAGS="%{optflags}"
%configure --disable-debug --disable-dependency-tracking
%make_build

%install
%make_install -p
mkdir -p $RPM_BUILD_ROOT%{module_dir}
rm $RPM_BUILD_ROOT%{_libdir}/libqore.la

%check
make check

%files
%{_bindir}/qore
%{_bindir}/qdbg
%{_bindir}/qdbg-server
%{_bindir}/qdbg-remote
%{_bindir}/qdbg-vsc-adapter
%{_mandir}/man1/qore.1.*

%changelog
* Fri Jan 21 2022 David Nichols <david@qore.org> 1.2.0-1
- updated version to 1.2.0-1
- updated libqore version to 7.4.1

* Sun Jan 9 2022 David Nichols <david@qore.org> 1.1.0-1
- updated version to 1.1.0-1
- updated libqore version to 7.4.0

* Wed Dec 15 2021 David Nichols <david@qore.org> 1.0.13-1
- updated version to 1.0.13-1
- updated libqore version to 7.3.0

* Thu Nov 25 2021 David Nichols <david@qore.org> 1.0.12-1
- updated version to 1.0.12-1
- updated libqore version to 7.2.3

* Sat Nov 20 2021 David Nichols <david@qore.org> 1.0.11-1
- updated version to 1.0.11-1

* Wed Oct 13 2021 David Nichols <david@qore.org> 1.0.10-1
- updated version to 1.0.10-1
- updated libqore version to 7.2.2

* Wed Oct 6 2021 David Nichols <david@qore.org> 1.0.9-1
- updated version to 1.0.9-1
- updated libqore version to 7.2.1

* Sun Oct 3 2021 David Nichols <david@qore.org> 1.0.8-1
- updated version to 1.0.8-1
- updated libqore version to 7.2.0

* Thu Sep 23 2021 David Nichols <david@qore.org> 1.0.7-1
- updated version to 1.0.7-1
- updated libqore version to 7.1.1

* Mon Sep 20 2021 David Nichols <david@qore.org> 1.0.6-1
- updated version to 1.0.6-1

* Thu Sep 16 2021 David Nichols <david@qore.org> 1.0.5-1
- updated version to 1.0.5-1

* Tue Sep 7 2021 David Nichols <david@qore.org> 1.0.4-1
- updated version to 1.0.4-1

* Sat Aug 16 2021 David Nichols <david@qore.org> 1.0.3-1
- updated version to 1.0.3-1
- updated libqore version to 7.1.0
- added module api 1.1

* Sat Jul 17 2021 David Nichols <david@qore.org> 1.0.2-1
- updated version to 1.0.2-1

* Thu Jul 1 2021 David Nichols <david@qore.org> 1.0.1-1
- updated version to 1.0.1-1
- updated libqore version to 7.0.1

* Thu Dec 31 2020 David Nichols <david@qore.org> 1.0-1
- updated version to 1.0-1
- updated libqore version to 7.0.0
- updated ABI version to 0.25; removed all others

* Mon Dec 21 2020 David Nichols <david@qore.org> 0.9.11-1
- updated version to 0.9.11-1

* Sun Nov 29 2020 David Nichols <david@qore.org> 0.9.10-1
- updated version to 0.9.10-1

* Mon Nov 16 2020 David Nichols <david@qore.org> 0.9.9-1
- updated version to 0.9.9-1

* Tue Nov 10 2020 David Nichols <david@qore.org> 0.9.8-1
- updated version to 0.9.8-1

* Fri Nov 6 2020 David Nichols <david@qore.org> 0.9.7-1
- updated version to 0.9.7-1

* Thu Oct 22 2020 David Nichols <david@qore.org> 0.9.6-1
- updated version to 0.9.6-1
- updated libqore version to 6.3.1

* Mon Aug 10 2020 David Nichols <david@qore.org> 0.9.5-1
- updated version to 0.9.5-1
- updated libqore version to 6.3.0

* Mon Aug 10 2020 David Nichols <david@qore.org> 0.9.4.6-3
- added Recommends: tags to libqore, doc, devel, devel-doc packages

* Wed Aug 5 2020 David Nichols <david@qore.org> 0.9.4.6-2
- updated version to 0.9.4.6-2
- fixed raw macros in the changelog
- removed duplicate slashes after $RPM_BUILD_ROOT
- added README-LICENSE to %%license entries; added license files to the qore-devel and qore-misc-tools packages

* Mon Aug 3 2020 David Nichols <david@qore.org> 0.9.4.6-1
- updated version to 0.9.4.6-1
- updated libqore version to 6.2.1
- replaced %%{_datarootdir} with %%{_datadir}
- reorganized initial tags
- added a commend about licensing
- removed /usr/bin/env requirement as it's provided by coreutils
- replaced BuildRequires lines with -devel with pkgconfig(foo)
- added requires for libqore and stdlib to main package
- removed Group tags
- removed Provides and Obsoletes tags for the libqore pkg
- use %%license for all license files
- added a fully-qualified file for Requires
- removed the abi requirement from the stdlib pkg
- fixed ownership of the module_dir and the cmake config dir
- fixed license definitions in subpkg
- removed obsolete references to %%defattr and ldconfig
- use %%make_build instead of a hardcoded make line
- use %%make_install -p instead of a hardcoded make install line
- added required BuildRequires for gcc-c++

* Wed May 20 2020 David Nichols <david@qore.org> 0.9.4.5-1
- updated version to 0.9.4.5-1

* Sun May 10 2020 David Nichols <david@qore.org> 0.9.4.4-1
- updated version to 0.9.4.4-1

* Sat Mar 28 2020 David Nichols <david@qore.org> 0.9.4.3-1
- updated version to 0.9.4.3-1

* Mon Mar 2 2020 David Nichols <david@qore.org> 0.9.4.2-1
- updated version to 0.9.4.2-1

* Wed Feb 12 2020 David Nichols <david@qore.org> 0.9.4.1-1
- updated version to 0.9.4.1-1

* Sat Sep 7 2019 David Nichols <david@qore.org> 0.9.4-1
- updated version to 0.9.4-1

* Tue Mar 26 2019 David Nichols <david@qore.org> 0.9.3-1
- updated version to 0.9.3-1

* Mon Mar 11 2019 David Nichols <david@qore.org> 0.9.2-1
- updated version to 0.9.2-1

* Fri Feb 15 2019 David Nichols <david@qore.org> 0.9.1-1
- updated version to 0.9.1-1

* Fri Nov 16 2018 David Nichols <david@qore.org> 0.9-1
- updated version to 0.9-1

* Wed Nov 14 2018 David Nichols <david@qore.org> 0.8.13.9-1
- updated version to 0.8.13.9-1

* Sat Oct 20 2018 David Nichols <david@qore.org> 0.8.13.8-1
- updated version to 0.8.13.8-1

* Tue Sep 11 2018 David Nichols <david@qore.org> 0.8.13.7-1
- updated version to 0.8.13.7-1

* Fri Jun 22 2018 David Nichols <david@qore.org> 0.8.13.6-1
- updated version to 0.8.13.6-1

* Tue May 15 2018 David Nichols <david@qore.org> 0.8.13.5-1
- updated version to 0.8.13.5-1

* Fri Apr 13 2018 David Nichols <david@qore.org> 0.8.13.4-1
- updated version to 0.8.13.4-1

* Thu Mar 22 2018 David Nichols <david@qore.org> 0.8.13.3-1
- updated version to 0.8.13.3-1

* Sat Dec 30 2017 David Nichols <david@qore.org> 0.8.13.2-1
- updated version to 0.8.13.2-1

* Fri Sep 29 2017 David Nichols <david@qore.org> 0.8.13.1-1
- updated version to 0.8.13.1-1

* Fri Aug 4 2017 David Nichols <david@qore.org> 0.8.13-1
- updated version to 0.8.13-1

* Thu Aug 3 2017 David Nichols <david@qore.org> 0.8.12.12-1
- updated to 0.8.12.12

* Thu Jun 15 2017 David Nichols <david@qore.org> 0.8.12.11-1
- updated to 0.8.12.11

* Thu Apr 13 2017 David Nichols <david@qore.org> 0.8.12.10-1
- updated to 0.8.12.10

* Thu Mar 16 2017 David Nichols <david@qore.org> 0.8.12.9-1
- updated to 0.8.12.9

* Tue Feb 21 2017 David Nichols <david@qore.org> 0.8.12.8-1
- updated to 0.8.12.8

* Sun Feb 12 2017 David Nichols <david@qore.org> 0.8.12.7-1
- updated to 0.8.12.7

* Wed Feb 1 2017 David Nichols <david@qore.org> 0.8.12.6-1
- updated to 0.8.12.6

* Wed Nov 23 2016 David Nichols <david@qore.org> 0.8.12.5-1
- updated to 0.8.12.5

* Fri Oct 21 2016 David Nichols <david@qore.org> 0.8.12.4-1
- updated to 0.8.12.4

* Tue Sep 27 2016 David Nichols <david@qore.org> 0.8.12.3-1
- updated to 0.8.12.3

* Sat Sep 10 2016 David Nichols <david@qore.org> 0.8.12.2-1
- updated to 0.8.12.2

* Wed Aug 17 2016 David Nichols <david@qore.org> 0.8.12.1-1
- updated to 0.8.12.1

* Wed Aug 12 2015 David Nichols <david@qore.org> 0.8.12-1
- updated version to 0.8.12-1

* Tue Jul 29 2014 David Nichols <david@qore.org> 0.8.11.1-7
- removed irrelevant license files from stdlib package, only the MIT license applies there

* Fri Jul 11 2014 David Nichols <david@qore.org> 0.8.11.1-6
- fixed doc and devel-doc file specs to fix packaging bugs for documentation

* Tue Jul 8 2014 David Nichols <david@qore.org> 0.8.11.1-4
- synced with upstream fixes for 64 bit ppc compilation and command-line enhancements for module directory handling

* Tue Jul 8 2014 David Nichols <david@qore.org> 0.8.11.1-4
- added a %%check section using the new "make check" target
- simplified spec due to upstream changes (moved test/ subdir to examples/ in upstream)

* Fri Jun 27 2014 David Nichols <david@qore.org> 0.8.11.1-3
- added license files and license READMEs to packages that can potentially be installed independently (doc and devel-doc)
- removed --disable-static from the configure call since it's the default
- created a new qore-stdlib package for noarch user module files in /usr/share, split from libqore
- removed ChangeLog from distribution sources

* Tue Jun 24 2014 David Nichols <david@qore.org> 0.8.11.1-2
- removed non-arch-specific library ABI Provides

* Mon Jun 23 2014 David Nichols <david@qore.org> 0.8.11.1-1
- added explicit versioned capability for library ABI compatibility for module RPMs
- added explicit versioned capability for libqore5 due to name change on fedora/rhel
- obsoletes previous versions of libqore5 in case of foreign RPM installation
- added %%{optflags} to configure
- updated license text in library source to reflect most liberal license option (MIT) with reference to LGPL and GPL options
- replaced GPL getopt_long.* files with BSD variants (not used on Linux builds)
- updated module and library ABI info
- moved user module directory to ${_datarootdir}
- moved module and user module directories to libqore package where they should be
- disabled dependency tracking in configure

* Sat Jun 21 2014 David Nichols <david@qore.org> 0.8.11-2
- fixed Source0 URL, optimized conditionals
- removed items related to other distributions such as *suse, removed old %%defines
- replaced %%define with %%global, removed obsolete RPM macros
- dropped obsolete BuildRequires, renamed libary from libqore5 -> libqore
- added %%configure macro, moved 64-bit handling to configure
- replaced hardcoded paths with standard macros
- aligned %%post and %%postun for libqore to Fedora standards
- simplified example directory move syntax since we are already in the primary builddir in %%setup
- moved %%configure call to %%build, added %%{?_smp_mflags} to make invokation
- fixed Group: Documentation for doc and devel-doc, removed dependencies on libqore
- fixed Group: System Environment/Libraries for libqore
- fixed Group: Develpment/Libraries for qore-devel
- added BuildArch: noarch to doc and devel-doc packages

* Sat May 31 2014 David Nichols <david@qore.org> 0.8.11-1
- updated to 0.8.11

* Wed Mar 12 2014 David Nichols <david@qore.org> 0.8.10-1
- updated to 0.8.10

* Fri Oct 04 2013 David Nichols <david@qore.org> 0.8.9-1
- updated to 0.8.9

* Sun Feb 24 2013 David Nichols <david@qore.org> 0.8.8-1
- updated to 0.8.8

* Wed Nov 21 2012 David Nichols <david@qore.org> 0.8.7-1
- updated to 0.8.7

* Fri Nov 9 2012 David Nichols <david@qore.org> 0.8.6.2-1
- updated to 0.8.6.2

* Sat Oct 27 2012 David Nichols <david@qore.org> 0.8.6.1-1
- updated to 0.8.6.1

* Sun Sep 2 2012 David Nichols <david@qore.org> 0.8.6-1
- updated to 0.8.6

* Wed May 23 2012 David Nichols <david@qore.org> 0.8.5-1
- updated to 0.8.5

* Tue May 22 2012 David Nichols <david@qore.org> 0.8.4-1
- updated for new doxygen-based documentation, added devel-doc pkg for API docs
- updated package descriptions

* Thu Oct 20 2011 David Nichols <david@qore.org> 0.8.4-1
- updated to 0.8.4

* Fri Oct 07 2011 Petr Vanek <petr.vanek@qoretechnologie-1s.com> 0.8.3-2
- pkg-config

* Sun Mar 6 2011 David Nichols <david@qore.org> 0.8.3-1
- updated to 0.8.3

* Sun Dec 26 2010 David Nichols <david@qore.org> 0.8.2-1
- updated to 0.8.2

* Tue Jun 15 2010 David Nichols <david@qore.org> 0.8.1-1
- updated to 0.8.1

* Wed Nov 18 2009 David Nichols <david_nichols@users.sourceforge.net> 0.8.0-1
- updated to 0.8.0

* Fri Nov 6 2009 David Nichols <david_nichols@users.sourceforge.net> 0.7.7-1
- updated to 0.7.7

* Mon Jul 13 2009 David Nichols <david_nichols@users.sourceforge.net> 0.7.6-1
- updated to 0.7.6

* Mon Jun 22 2009 David Nichols <david_nichols@users.sourceforge.net> 0.7.5-1
- updated to 0.7.5

* Wed Mar 4 2009 David Nichols <david_nichols@users.sourceforge.net> 0.7.4-1
- updated to 0.7.4

* Wed Dec 3 2008 David Nichols <david_nichols@users.sourceforge.net> 0.7.3-1
- updated to 0.7.3

* Wed Nov 26 2008 David Nichols <david_nichols@users.sourceforge.net> 0.7.2-2
- made libqore* the default name for lib package, removed la file

* Sun Nov 23 2008 David Nichols <david_nichols@users.sourceforge.net> 0.7.2-1
- updated to 0.7.2

* Tue Oct 7 2008 David Nichols <david_nichols@users.sourceforge.net> 0.7.0-7
- released 0.7.0

* Thu Sep 4 2008 David Nichols <david_nichols@users.sourceforge.net> 0.7.0-6
- removed all modules as they are now independent projects

* Tue Sep 2 2008 David Nichols <david_nichols@users.sourceforge.net> 0.7.0-5
- fixed dist tag for suse distributions
- updated for new module directory, added qore-module-api-* capability

* Thu Jun 12 2008 David Nichols <david_nichols@users.sourceforge.net> 0.7.0-4
- added new modules

* Mon Oct 22 2007 David Nichols <david_nichols@users.sourceforge.net> 0.7.0-3
- updated spec file with corrections from suse open build service

* Tue Jul 17 2007 David Nichols <david_nichols@users.sourceforge.net> 0.7.0-2
- updated library version to 3.1.0

* Sat Jul 14 2007 David Nichols <david_nichols@users.sourceforge.net> 0.7.0-1
- copied improvements from opensuse rpm and updated based on rpmlint output
- updated version to 0.7.0

* Thu Jun 14 2007 David Nichols <david_nichols@users.sourceforge.net> 0.6.2-4
- fixed spec file to support more architectures

* Wed Jun 13 2007 David Nichols <david_nichols@users.sourceforge.net> 0.6.2-3
- removed tibae module from spec file due to compiler requiremenets (g++-32)
- added pgsql module

* Tue Feb 20 2007 David Nichols <david_nichols@users.sourceforge.net> 0.6.2-2
- updated to libqore.so.3.0.0

* Sun Feb 11 2007 David Nichols <david_nichols@users.sourceforge.net> 0.6.2-1
- updated to 0.6.2 and libqore 1.1

* Tue Jan 30 2007 David Nichols <david_nichols@users.sourceforge.net> 0.6.1-1
- added tuxedo module

* Fri Jan 5 2007 David Nichols <david_nichols@users.sourceforge.net> 0.6.0-1
- updated libqore so version to 1.0.0

* Sat Nov 18 2006 David Nichols <david_nichols@users.sourceforge.net> 0.5.9-1
- updated descriptions
- changes to make spec file more release-agnostic (use of the dist tag in release)

* Wed Dec 7 2005 David Nichols <david_nichols@users.sourceforge.net> 0.5.8-1
- Initial rpm build
