Qore supports a simple event-\/handling mechanism to provide notification and details of socket and network events in higher-\/level classes. Classes currently supporting events are the \mbox{\hyperlink{class_qore_1_1_socket}{Socket}}, \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient}}, \mbox{\hyperlink{class_qore_1_1_ftp_client}{Ftp\+Client}}, and \mbox{\hyperlink{class_qore_1_1_file}{File}} classes.

See \mbox{\hyperlink{group__event__constants}{Event Constants}} for a list of all event constants; details about each event are documented in the following sections.

Event information is placed on the event queue (which must be a \mbox{\hyperlink{class_qore_1_1_thread_1_1_queue}{Queue}} object) in the form of a hash. Each event has the following standar keys\+:~\newline
{\bfseries{Event Hash Common Keys}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &This key holds the event code; see information for individual events in the following sections  \\\cline{1-2}
{\ttfamily source}  &This key holds the event source code  \\\cline{1-2}
{\ttfamily id}  &The value of this key is a unique integer that can be used to uniquely identify the object generating the event.  \\\cline{1-2}
\end{longtabu}


\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_PACKET_READ}{}\doxysection{EVENT\+\_\+\+PACKET\+\_\+\+READ}\label{event_handling_EVENT_PACKET_READ}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga021ba2dee5ccd3870ed42884f13a88d5}{Qore\+::\+EVENT\+\_\+\+PACKET\+\_\+\+READ}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after a network packet is received.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga021ba2dee5ccd3870ed42884f13a88d5}{Qore\+::\+EVENT\+\_\+\+PACKET\+\_\+\+READ}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
{\ttfamily read}  &The number of bytes read in the packet.  \\\cline{1-2}
{\ttfamily total\+\_\+read}  &The total number of bytes read in the read loop.  \\\cline{1-2}
{\ttfamily }\mbox{[}total\+\_\+to\+\_\+read\mbox{]} &The total number of bytes to read in the read loop (this key is only present if the total number of bytes to read is known).  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_PACKET_SENT}{}\doxysection{EVENT\+\_\+\+PACKET\+\_\+\+SENT}\label{event_handling_EVENT_PACKET_SENT}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gaf7edaaff31f786ccf7c426012fa00bb7}{Qore\+::\+EVENT\+\_\+\+PACKET\+\_\+\+SENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after a network packet is sent.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gaf7edaaff31f786ccf7c426012fa00bb7}{Qore\+::\+EVENT\+\_\+\+PACKET\+\_\+\+SENT}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
{\ttfamily socket}  &The file descriptor number of the socket.  \\\cline{1-2}
{\ttfamily sent}  &The number of bytes sent in the packet.  \\\cline{1-2}
{\ttfamily total\+\_\+sent}  &The total number of bytes sent in the send loop.  \\\cline{1-2}
{\ttfamily total\+\_\+to\+\_\+send}  &The total number of bytes to send in the send loop.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_CONTENT_LENGTH}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+CONTENT\+\_\+\+LENGTH}\label{event_handling_EVENT_HTTP_CONTENT_LENGTH}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gad0f50dae7f1bfedac9b8e9d8bf31c35b}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CONTENT\+\_\+\+LENGTH}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after an HTTP header is received containing a content length header line, but before the message body is received.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gad0f50dae7f1bfedac9b8e9d8bf31c35b}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CONTENT\+\_\+\+LENGTH}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
{\ttfamily len}  &The number of bytes given for the content length.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_CHUNKED_START}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+START}\label{event_handling_EVENT_HTTP_CHUNKED_START}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga618a2847b6cabc75e1e6ecdc40c88a7f}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+START}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised after receiving an HTTP header with the {\ttfamily Transfer-\/\+Encoding} header set to {\ttfamily chunked} and before the chunked data is read.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga618a2847b6cabc75e1e6ecdc40c88a7f}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+START}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the socket object.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_CHUNKED_END}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+END}\label{event_handling_EVENT_HTTP_CHUNKED_END}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gaa19880a65c20fe3f3cfb89f94b6ad960}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+END}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised after all chunked data is read from the socket.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gaa19880a65c20fe3f3cfb89f94b6ad960}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+END}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the socket object.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_REDIRECT}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+REDIRECT}\label{event_handling_EVENT_HTTP_REDIRECT}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga6d363c43f9023d8442fcc266db699eca}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+REDIRECT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised after a redirect response is received from an HTTP server.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga6d363c43f9023d8442fcc266db699eca}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+REDIRECT}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the socket object.  \\\cline{1-2}
{\ttfamily location}  &The redirect location given by the HTTP server  \\\cline{1-2}
{\ttfamily }\mbox{[}status\+\_\+message\mbox{]} &Any status message sent by the HTTP server; if no message was sent, then this key will not be present in the event hash.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_CHANNEL_CLOSED}{}\doxysection{EVENT\+\_\+\+CHANNEL\+\_\+\+CLOSED}\label{event_handling_EVENT_CHANNEL_CLOSED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga351b788677e1dfff0a791c79762a527e}{Qore\+::\+EVENT\+\_\+\+CHANNEL\+\_\+\+CLOSED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after the socket is closed.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga351b788677e1dfff0a791c79762a527e}{Qore\+::\+EVENT\+\_\+\+CHANNEL\+\_\+\+CLOSED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_DELETED}{}\doxysection{EVENT\+\_\+\+DELETED}\label{event_handling_EVENT_DELETED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga77ac8ca6dd3d9fd6fe51b1b0d82e26fe}{Qore\+::\+EVENT\+\_\+\+DELETED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised when the socket object is deleted.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga77ac8ca6dd3d9fd6fe51b1b0d82e26fe}{Qore\+::\+EVENT\+\_\+\+DELETED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_FTP_SEND_MESSAGE}{}\doxysection{EVENT\+\_\+\+FTP\+\_\+\+SEND\+\_\+\+MESSAGE}\label{event_handling_EVENT_FTP_SEND_MESSAGE}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga75776f172ec78925f339f9ddb6730646}{Qore\+::\+EVENT\+\_\+\+FTP\+\_\+\+SEND\+\_\+\+MESSAGE}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gadcdbe58f12675ffc88b9a7366b6bb93f}{Qore\+::\+SOURCE\+\_\+\+FTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately before a message is sent on the FTP control channel.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga75776f172ec78925f339f9ddb6730646}{Qore\+::\+EVENT\+\_\+\+FTP\+\_\+\+SEND\+\_\+\+MESSAGE}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gadcdbe58f12675ffc88b9a7366b6bb93f}{Qore\+::\+SOURCE\+\_\+\+FTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_ftp_client}{Ftp\+Client class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
{\ttfamily command}  &A string giving the FTP command sent (ex\+: {\ttfamily \char`\"{}\+RETR\char`\"{}}).  \\\cline{1-2}
{\ttfamily }\mbox{[}arg\mbox{]} &The argument to the command; if no argument is sent, then this key will not be present.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_FTP_MESSAGE_RECEIVED}{}\doxysection{EVENT\+\_\+\+FTP\+\_\+\+MESSAGE\+\_\+\+RECEIVED}\label{event_handling_EVENT_FTP_MESSAGE_RECEIVED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga3f65c01bb4a3b817d3cd8c8731b89b28}{Qore\+::\+EVENT\+\_\+\+FTP\+\_\+\+MESSAGE\+\_\+\+RECEIVED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gadcdbe58f12675ffc88b9a7366b6bb93f}{Qore\+::\+SOURCE\+\_\+\+FTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after a message is received on the FTP control channel.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga3f65c01bb4a3b817d3cd8c8731b89b28}{Qore\+::\+EVENT\+\_\+\+FTP\+\_\+\+MESSAGE\+\_\+\+RECEIVED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gadcdbe58f12675ffc88b9a7366b6bb93f}{Qore\+::\+SOURCE\+\_\+\+FTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_ftp_client}{Ftp\+Client class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
{\ttfamily command}  &A string giving the FTP command sent (ex\+: {\ttfamily \char`\"{}\+RETR\char`\"{}}).  \\\cline{1-2}
{\ttfamily }\mbox{[}arg\mbox{]} &The argument to the command; if no argument is sent, then this key will not be present.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HOSTNAME_LOOKUP}{}\doxysection{EVENT\+\_\+\+HOSTNAME\+\_\+\+LOOKUP}\label{event_handling_EVENT_HOSTNAME_LOOKUP}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gafd12bc810e5a9cbcb1ac885b233784da}{Qore\+::\+EVENT\+\_\+\+HOSTNAME\+\_\+\+LOOKUP}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately before a hostname lookup is made.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gafd12bc810e5a9cbcb1ac885b233784da}{Qore\+::\+EVENT\+\_\+\+HOSTNAME\+\_\+\+LOOKUP}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
{\ttfamily name}  &A string giving the name to be looked up.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HOSTNAME_RESOLVED}{}\doxysection{EVENT\+\_\+\+HOSTNAME\+\_\+\+RESOLVED}\label{event_handling_EVENT_HOSTNAME_RESOLVED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gabb61e0e324cd908e2543ce6d08330dd3}{Qore\+::\+EVENT\+\_\+\+HOSTNAME\+\_\+\+RESOLVED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after a successful hostname resolution.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gabb61e0e324cd908e2543ce6d08330dd3}{Qore\+::\+EVENT\+\_\+\+HOSTNAME\+\_\+\+RESOLVED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
{\ttfamily type}  &The type of address for the socket; one of the \mbox{\hyperlink{group__network__address__family__constants}{Network Address Family Constants}}  \\\cline{1-2}
{\ttfamily typename}  &A descriptive name for the address family (ex\+: {\ttfamily \char`\"{}ipv4\char`\"{}}, {\ttfamily \char`\"{}ipv6\char`\"{}})  \\\cline{1-2}
{\ttfamily address}  &A string giving the network address the name was resolved to.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_SEND_MESSAGE}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+SEND\+\_\+\+MESSAGE}\label{event_handling_EVENT_HTTP_SEND_MESSAGE}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga3b92fc4b13daef0ebe6ba6f9781bf2c1}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+SEND\+\_\+\+MESSAGE}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}} or \mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately before an HTTP message is sent.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga3b92fc4b13daef0ebe6ba6f9781bf2c1}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+SEND\+\_\+\+MESSAGE}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient class}}, or \mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily message}  &The first string in the HTTP message (ex\+: GET / HTTP/1.\+1).  \\\cline{1-2}
{\ttfamily headers}  &a hash of all headers to send in the message.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_MESSAGE_RECEIVED}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+MESSAGE\+\_\+\+RECEIVED}\label{event_handling_EVENT_HTTP_MESSAGE_RECEIVED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga1d16d8fddcca7cedd6f8b81ad26d9658}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+MESSAGE\+\_\+\+RECEIVED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}} or \mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after an HTTP message is received.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga1d16d8fddcca7cedd6f8b81ad26d9658}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+MESSAGE\+\_\+\+RECEIVED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient class}}, or \mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily headers}  &A hash of all headers received in the message, plus the following headers giving additional information about the message\+:~\newline
 -\/ {\ttfamily \char`\"{}http\+\_\+version\char`\"{}}\+: giving the HTTP protocol version in the message~\newline
 -\/ {\ttfamily \char`\"{}status\+\_\+code\char`\"{}}\+: giving the HTTP status code if the message is a response~\newline
 -\/ {\ttfamily \char`\"{}status\+\_\+message\char`\"{}}\+: giving any HTTP status message if the message is a response~\newline
 -\/ {\ttfamily \char`\"{}method\char`\"{}}\+: giving the HTTP method if the message is a request~\newline
 -\/ {\ttfamily \char`\"{}path\char`\"{}}\+: providing the path in request messages.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_FOOTERS_RECEIVED}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+FOOTERS\+\_\+\+RECEIVED}\label{event_handling_EVENT_HTTP_FOOTERS_RECEIVED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gaf76b16c6831986b699782098310efe9a}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+FOOTERS\+\_\+\+RECEIVED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after HTTP footers are received after receiving chunked data.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gaf76b16c6831986b699782098310efe9a}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+FOOTERS\+\_\+\+RECEIVED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient class}}  \\\cline{1-2}
{\ttfamily headers}  &A hash of all footers received in the message.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_CHUNKED_DATA_RECEIVED}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+DATA\+\_\+\+RECEIVED}\label{event_handling_EVENT_HTTP_CHUNKED_DATA_RECEIVED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gabe9ca24b827811f6440c3caac71bee75}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+DATA\+\_\+\+RECEIVED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after chunked data is received.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gabe9ca24b827811f6440c3caac71bee75}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+DATA\+\_\+\+RECEIVED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient class}}  \\\cline{1-2}
{\ttfamily read}  &An integer giving the number of bytes read in the chunk.  \\\cline{1-2}
{\ttfamily total\+\_\+read}  &An integer giving the total number of bytes of chunked data read in the current message.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_CHUNK_SIZE}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+CHUNK\+\_\+\+SIZE}\label{event_handling_EVENT_HTTP_CHUNK_SIZE}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gacb75168aba13cf548176914db6f5c4f5}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNK\+\_\+\+SIZE}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after chunk information is received providing the size of the next chunk.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gacb75168aba13cf548176914db6f5c4f5}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNK\+\_\+\+SIZE}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{HTTPClient class}}  \\\cline{1-2}
{\ttfamily size}  &An integer giving the number of bytes in the next chunk.  \\\cline{1-2}
{\ttfamily total\+\_\+read}  &An integer giving the total number of bytes of chunked data read in the current message.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_CONNECTING}{}\doxysection{EVENT\+\_\+\+CONNECTING}\label{event_handling_EVENT_CONNECTING}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gacac824e6e4f505757e01fb9d926d8490}{Qore\+::\+EVENT\+\_\+\+CONNECTING}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately before a socket connection is attempted.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gacac824e6e4f505757e01fb9d926d8490}{Qore\+::\+EVENT\+\_\+\+CONNECTING}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
{\ttfamily type}  &The type of address for the socket; one of the \mbox{\hyperlink{group__network__address__family__constants}{Network Address Family Constants}}  \\\cline{1-2}
{\ttfamily typename}  &A descriptive name for the address family (ex\+: {\ttfamily \char`\"{}ipv4\char`\"{}}, {\ttfamily \char`\"{}ipv6\char`\"{}})  \\\cline{1-2}
{\ttfamily address}  &A string giving the target address (ex\+: {\ttfamily \char`\"{}\+::1\char`\"{}}, {\ttfamily \char`\"{}192.\+168.\+20.\+4\char`\"{}})  \\\cline{1-2}
{\ttfamily target}  &The target address for the connection.  \\\cline{1-2}
{\ttfamily }\mbox{[}port\mbox{]} &The target port for the connection; if not applicable for the address family then this hash key is not included.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_CONNECTED}{}\doxysection{EVENT\+\_\+\+CONNECTED}\label{event_handling_EVENT_CONNECTED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gadbc9ff154373b63cc1845cd9b1cec056}{Qore\+::\+EVENT\+\_\+\+CONNECTED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after a socket connection is established.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gadbc9ff154373b63cc1845cd9b1cec056}{Qore\+::\+EVENT\+\_\+\+CONNECTED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_START_SSL}{}\doxysection{EVENT\+\_\+\+START\+\_\+\+SSL}\label{event_handling_EVENT_START_SSL}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gaf0777a5058274a3292ae6b9e2c84261f}{Qore\+::\+EVENT\+\_\+\+START\+\_\+\+SSL}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately before SSL negotiation is attempted.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gaf0777a5058274a3292ae6b9e2c84261f}{Qore\+::\+EVENT\+\_\+\+START\+\_\+\+SSL}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_SSL_ESTABLISHED}{}\doxysection{EVENT\+\_\+\+SSL\+\_\+\+ESTABLISHED}\label{event_handling_EVENT_SSL_ESTABLISHED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga8f000a2187f2161511f09b9e489c9680}{Qore\+::\+EVENT\+\_\+\+SSL\+\_\+\+ESTABLISHED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after SSL negotiation has been successfully established.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga8f000a2187f2161511f09b9e489c9680}{Qore\+::\+EVENT\+\_\+\+SSL\+\_\+\+ESTABLISHED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the underlying socket object  \\\cline{1-2}
{\ttfamily cipher}  &A string giving the name of the cipher algorithm used for the connection.  \\\cline{1-2}
{\ttfamily cipher\+\_\+version}  &A string giving the version of the cipher algorithm used for the connection.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_OPEN_FILE}{}\doxysection{EVENT\+\_\+\+OPEN\+\_\+\+FILE}\label{event_handling_EVENT_OPEN_FILE}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gab9e3b3325f2176a9fbc985d6560b9f08}{Qore\+::\+EVENT\+\_\+\+OPEN\+\_\+\+FILE}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1cea533c8658a47ddc7ece4cc71ea3a9}{Qore\+::\+SOURCE\+\_\+\+FILE}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately before a file is opened.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gab9e3b3325f2176a9fbc985d6560b9f08}{Qore\+::\+EVENT\+\_\+\+OPEN\+\_\+\+FILE}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1cea533c8658a47ddc7ece4cc71ea3a9}{Qore\+::\+SOURCE\+\_\+\+FILE}}, indicating the \mbox{\hyperlink{class_qore_1_1_file}{File class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the \mbox{\hyperlink{class_qore_1_1_file}{File}} object  \\\cline{1-2}
{\ttfamily filename}  &The file\textquotesingle{}s name.  \\\cline{1-2}
{\ttfamily flags}  &The flags used to open the file.  \\\cline{1-2}
{\ttfamily mode}  &The mode to open the file with.  \\\cline{1-2}
{\ttfamily encoding}  &The \mbox{\hyperlink{character_encoding}{character encoding}} given used for reading from or writing to the file.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_FILE_OPENED}{}\doxysection{EVENT\+\_\+\+FILE\+\_\+\+OPENED}\label{event_handling_EVENT_FILE_OPENED}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga83e323f4c6bb013dfefd51ad4482de19}{Qore\+::\+EVENT\+\_\+\+FILE\+\_\+\+OPENED}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1cea533c8658a47ddc7ece4cc71ea3a9}{Qore\+::\+SOURCE\+\_\+\+FILE}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after a file has been successfully opened.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga83e323f4c6bb013dfefd51ad4482de19}{Qore\+::\+EVENT\+\_\+\+FILE\+\_\+\+OPENED}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1cea533c8658a47ddc7ece4cc71ea3a9}{Qore\+::\+SOURCE\+\_\+\+FILE}}, indicating the \mbox{\hyperlink{class_qore_1_1_file}{File class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the \mbox{\hyperlink{class_qore_1_1_file}{File}} object  \\\cline{1-2}
{\ttfamily filename}  &The file\textquotesingle{}s name.  \\\cline{1-2}
{\ttfamily flags}  &The flags used to open the file.  \\\cline{1-2}
{\ttfamily mode}  &The mode to open the file with.  \\\cline{1-2}
{\ttfamily encoding}  &The \mbox{\hyperlink{character_encoding}{character encoding}} given used for reading from or writing to the file.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_DATA_READ}{}\doxysection{EVENT\+\_\+\+DATA\+\_\+\+READ}\label{event_handling_EVENT_DATA_READ}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gaa5c638cda1f133aaecff300db9f870d2}{Qore\+::\+EVENT\+\_\+\+DATA\+\_\+\+READ}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1cea533c8658a47ddc7ece4cc71ea3a9}{Qore\+::\+SOURCE\+\_\+\+FILE}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after data is read from a file.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gaa5c638cda1f133aaecff300db9f870d2}{Qore\+::\+EVENT\+\_\+\+DATA\+\_\+\+READ}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1cea533c8658a47ddc7ece4cc71ea3a9}{Qore\+::\+SOURCE\+\_\+\+FILE}}, indicating the \mbox{\hyperlink{class_qore_1_1_file}{File class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the \mbox{\hyperlink{class_qore_1_1_file}{File}} object  \\\cline{1-2}
{\ttfamily read}  &The number of bytes read from the file.  \\\cline{1-2}
{\ttfamily total\+\_\+read}  &The total number of bytes read in the read loop.  \\\cline{1-2}
{\ttfamily total\+\_\+to\+\_\+read}  &The total number of bytes to read in the read loop.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_DATA_WRITTEN}{}\doxysection{EVENT\+\_\+\+DATA\+\_\+\+WRITTEN}\label{event_handling_EVENT_DATA_WRITTEN}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gaa71090af36659667313c8c739002c263}{Qore\+::\+EVENT\+\_\+\+DATA\+\_\+\+WRITTEN}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1cea533c8658a47ddc7ece4cc71ea3a9}{Qore\+::\+SOURCE\+\_\+\+FILE}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised immediately after data is written to a file.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gaa71090af36659667313c8c739002c263}{Qore\+::\+EVENT\+\_\+\+DATA\+\_\+\+WRITTEN}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1cea533c8658a47ddc7ece4cc71ea3a9}{Qore\+::\+SOURCE\+\_\+\+FILE}}, indicating the \mbox{\hyperlink{class_qore_1_1_file}{File class}}  \\\cline{1-2}
{\ttfamily id}  &A unique integer ID for the \mbox{\hyperlink{class_qore_1_1_file}{File}} object  \\\cline{1-2}
{\ttfamily written}  &The number of bytes written to the file.  \\\cline{1-2}
{\ttfamily total\+\_\+written}  &The total number of bytes written in the write loop.  \\\cline{1-2}
{\ttfamily total\+\_\+to\+\_\+write}  &The total number of bytes to write in the write loop.  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_CHUNKED_DATA_READ}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+DATA\+\_\+\+READ}\label{event_handling_EVENT_HTTP_CHUNKED_DATA_READ}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga093cec6d88a60023236594cac4d5b19c}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+DATA\+\_\+\+READ}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised when HTTP chunked data is read if the event data flag is set in the call to set the event queue.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga093cec6d88a60023236594cac4d5b19c}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+DATA\+\_\+\+READ}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}} or \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{Qore\+::\+HTTPClient}} class \char`\"{}\+HTTPClient class\char`\"{}  \\\cline{1-2}
{\ttfamily data}  &a \mbox{\hyperlink{data_type_declarations_string_type}{string}} or \mbox{\hyperlink{data_type_declarations_binary_type}{binary}} value  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_CHUNKED_DATA_SENT}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+DATA\+\_\+\+SENT}\label{event_handling_EVENT_HTTP_CHUNKED_DATA_SENT}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga5ee5ae9464e8c883fb037cfe08631b47}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+DATA\+\_\+\+SENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised when HTTP chunked data is sent if the event data flag is set in the call to set the event queue.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga5ee5ae9464e8c883fb037cfe08631b47}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+DATA\+\_\+\+SENT}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}} or \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{Qore\+::\+HTTPClient}} class \char`\"{}\+HTTPClient class\char`\"{}  \\\cline{1-2}
{\ttfamily data}  &a \mbox{\hyperlink{data_type_declarations_string_type}{string}} or \mbox{\hyperlink{data_type_declarations_binary_type}{binary}} value  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_CHUNKED_FOOTERS_SENT}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+FOOTERS\+\_\+\+SENT}\label{event_handling_EVENT_HTTP_CHUNKED_FOOTERS_SENT}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga6d61f2f6079e62adc313fb3bf4c0c414}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+FOOTERS\+\_\+\+SENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised when HTTP footers are sent at the end of a chunked data transfer if the event data flag is set in the call to set the event queue.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga6d61f2f6079e62adc313fb3bf4c0c414}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+CHUNKED\+\_\+\+FOOTERS\+\_\+\+SENT}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}} or \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{Qore\+::\+HTTPClient}} class \char`\"{}\+HTTPClient class\char`\"{}  \\\cline{1-2}
{\ttfamily headers}  &a \mbox{\hyperlink{data_type_declarations_hash_type}{hash}} of chunked footers sent  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_SOCKET_DATA_READ}{}\doxysection{EVENT\+\_\+\+SOCKET\+\_\+\+DATA\+\_\+\+READ}\label{event_handling_EVENT_SOCKET_DATA_READ}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_ga895ad2bb875777a11a0a7613494ab791}{Qore\+::\+EVENT\+\_\+\+SOCKET\+\_\+\+DATA\+\_\+\+READ}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised when socket data is read if the event data flag is set in the call to set the event queue.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_ga895ad2bb875777a11a0a7613494ab791}{Qore\+::\+EVENT\+\_\+\+SOCKET\+\_\+\+DATA\+\_\+\+READ}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}} or \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{Qore\+::\+HTTPClient}} class \char`\"{}\+HTTPClient class\char`\"{}  \\\cline{1-2}
{\ttfamily data}  &a \mbox{\hyperlink{data_type_declarations_string_type}{string}} or \mbox{\hyperlink{data_type_declarations_binary_type}{binary}} value  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_SOCKET_DATA_SENT}{}\doxysection{EVENT\+\_\+\+SOCKET\+\_\+\+DATA\+\_\+\+SENT}\label{event_handling_EVENT_SOCKET_DATA_SENT}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gaf1b9c3c3f5dd24192e021b178fabccb9}{Qore\+::\+EVENT\+\_\+\+SOCKET\+\_\+\+DATA\+\_\+\+SENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised when socket data is sent if the event data flag is set in the call to set the event queue.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gaf1b9c3c3f5dd24192e021b178fabccb9}{Qore\+::\+EVENT\+\_\+\+SOCKET\+\_\+\+DATA\+\_\+\+SENT}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}} or \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{Qore\+::\+HTTPClient}} class \char`\"{}\+HTTPClient class\char`\"{}  \\\cline{1-2}
{\ttfamily data}  &a \mbox{\hyperlink{data_type_declarations_string_type}{string}} or \mbox{\hyperlink{data_type_declarations_binary_type}{binary}} value  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{event_handling_EVENT_HTTP_HEADERS_READ}{}\doxysection{EVENT\+\_\+\+HTTP\+\_\+\+HEADERS\+\_\+\+READ}\label{event_handling_EVENT_HTTP_HEADERS_READ}
\begin{DoxyParagraph}{Event}
\mbox{\hyperlink{group__event__constants_gac180096573633537266011b54a4eb7c2}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+HEADERS\+\_\+\+READ}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Source}
\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Description}
This event is raised when HTTP header data is read if the event data flag is set in the call to set the event queue.~\newline
~\newline
 The event hash contains the following keys\+:~\newline
 \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{2}{|X[-1]}|}
\hline
{\bfseries{Key}} &{\bfseries{Value}}  \\\cline{1-2}
\mbox{[}{\ttfamily arg}\mbox{]} &This key holds any argument provided when setting the event queue  \\\cline{1-2}
{\ttfamily event}  &\mbox{\hyperlink{group__event__constants_gac180096573633537266011b54a4eb7c2}{Qore\+::\+EVENT\+\_\+\+HTTP\+\_\+\+HEADERS\+\_\+\+READ}}  \\\cline{1-2}
{\ttfamily source}  &\mbox{\hyperlink{group__event__source__constants_ga1dc3f29ef71c6de5cc5114382c88755e}{Qore\+::\+SOURCE\+\_\+\+SOCKET}}, indicating the \mbox{\hyperlink{class_qore_1_1_socket}{Socket class}} or \mbox{\hyperlink{group__event__source__constants_gaca8f942512797c6750ee3d8b47328782}{Qore\+::\+SOURCE\+\_\+\+HTTPCLIENT}}, indicating the \mbox{\hyperlink{class_qore_1_1_h_t_t_p_client}{Qore\+::\+HTTPClient}} class \char`\"{}\+HTTPClient class\char`\"{}  \\\cline{1-2}
{\ttfamily data}  &a \mbox{\hyperlink{data_type_declarations_string_type}{string}} value  \\\cline{1-2}
\end{longtabu}

\end{DoxyParagraph}
