Starting in Qore 0.\+8.\+0, it is possible to restrict variables, class members, and function and method parameters to certain data types. This allows programmers to write safer code, as many more errors can be caught at parse time that would otherwise be caught at run time. Furthermore, providing type information to the parser allows Qore to implement performance optimizations by performing lookups and resolutions once at parse time rather than every time a variable or class member is accessed at run time.

When types are declared in a parameter list, functions and methods can be overloaded as well.

The types in the following table can be used as well as any class name or {\ttfamily \textquotesingle{}$\ast$classname\textquotesingle{}} (i.\+e. an asterix followed by the class name), meaning either the given class or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} (no value).

{\bfseries{Data Type Declaration Names}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_int_type}{int}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} &Restricts values \mbox{\hyperlink{basic_data_types_integer}{Integer}} values  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_float_type}{float}} &\mbox{\hyperlink{basic_data_types_float}{Float}} or \mbox{\hyperlink{basic_data_types_integer}{Integer}} &\mbox{\hyperlink{basic_data_types_float}{Float}} &Restricts values to \mbox{\hyperlink{basic_data_types_float}{Float}} values  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_number_type}{number}} &\mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, or \mbox{\hyperlink{basic_data_types_integer}{Integer}} &\mbox{\hyperlink{basic_data_types_number}{Number}} &Restricts values to \mbox{\hyperlink{basic_data_types_number}{Number}} values  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_bool_type}{bool}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} &Restricts values to \mbox{\hyperlink{basic_data_types_boolean}{Boolean}} values  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_string_type}{string}} &\mbox{\hyperlink{basic_data_types_string}{String}} &\mbox{\hyperlink{basic_data_types_string}{String}} &Restricts values to \mbox{\hyperlink{basic_data_types_string}{String}} values  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_date_type}{date}} &\mbox{\hyperlink{basic_data_types_date}{Date}} &\mbox{\hyperlink{basic_data_types_date}{Date}} &Restricts values to \mbox{\hyperlink{basic_data_types_date}{Date}} values; values may be either \mbox{\hyperlink{basic_data_types_absolute_dates}{absolute}} or \mbox{\hyperlink{basic_data_types_relative_dates}{relative}}  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_binary_type}{binary}} &\mbox{\hyperlink{basic_data_types_binary}{Binary}} &\mbox{\hyperlink{basic_data_types_binary}{Binary}} &Restricts values to \mbox{\hyperlink{basic_data_types_binary}{Binary}} values  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_hash_type}{hash}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} &Restricts values to \mbox{\hyperlink{container_data_types_hash}{Hash}} values without any key type information  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_hash_hashdecl_type}{hash$<$...$>$}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} &Restricts values to values of the referenced \mbox{\hyperlink{hashdecl}{type-\/safe hash}}  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_hash_complex_type}{hash$<$string, ...$>$}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} &Restricts key values to the declared type  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_list_type}{list}} &\mbox{\hyperlink{container_data_types_list}{List}} &\mbox{\hyperlink{container_data_types_list}{List}} &Restricts values to \mbox{\hyperlink{container_data_types_list}{List}} values  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_list_complex_type}{list$<$...$>$}} &\mbox{\hyperlink{container_data_types_list}{List}} &\mbox{\hyperlink{container_data_types_list}{List}} &Restricts list values to the declared type  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_object_type}{object}} &\mbox{\hyperlink{container_data_types_object}{Object}} &\mbox{\hyperlink{container_data_types_object}{Object}} &Restricts values to \mbox{\hyperlink{container_data_types_object}{Object}} values  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_classname_type}{object$<$...$>$}} &\mbox{\hyperlink{container_data_types_object}{Object}} &\mbox{\hyperlink{container_data_types_object}{Object}} &Restricts values to objects of the specific class  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_classname_type}{$<$classname$>$}} &\mbox{\hyperlink{container_data_types_object}{Object}} &\mbox{\hyperlink{container_data_types_object}{Object}} &Restricts values to objects of the specific class given; either the class name can be given (ex\+: \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} or a qualified path to the class\+: \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Qore\+::\+Thread\+::\+Mutex}})  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_null_type}{null}} &\mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_null}{NULL}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_null}{NULL}} type; this type has few (if any) practical applications and has been included for completeness\textquotesingle{} sake  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_nothing_type}{nothing}} &\mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} type; this type is mostly useful for declaring that a function or method returns no value  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_timeout_type}{timeout}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_date}{Date}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_date}{Date}} and converts dates to an integer value representing milliseconds and returns the integer; incoming integers are assumed to represent milliseconds  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_base64binary_type}{base64binary}} &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_float}{Float}} &Accepts \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts a base-\/64 encoded string to a binary value and returns the new value  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_hexbinary_type}{hexbinary}} &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_float}{Float}} &Accepts \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts a string of hex digits to a binary value and returns the new value  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softbinary_type}{softbinary}} &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_float}{Float}} &Accepts \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/binary values to a binary value and returns the new value  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softint_type}{softint}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/integer values to an integer and returns the integer  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softfloat_type}{softfloat}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_float}{Float}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/float values to a float and returns the new value  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softnumber_type}{softnumber}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_float}{Float}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/number values to a float and returns the new value  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softbool_type}{softbool}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/boolean values to a boolean and returns the new value  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softstring_type}{softstring}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_string}{String}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/string values to a string and returns the new value  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softdate_type}{softdate}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_date}{Date}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/date values to a date and returns the new value  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softlist_type}{softlist}} &all types &\mbox{\hyperlink{container_data_types_list}{List}} &Accepts all types; \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned as an empty list; a list is returned unchanged, and any other type is returned as the first element of a new list  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softlist_complex_type}{softlist$<$...$>$}} &all types &\mbox{\hyperlink{container_data_types_list}{List}} &Accepts all data types; \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned as an empty list; a list is returned with its elements processed by the subtype declaration, and any other type is returned as the first element of a new list, also processed by the subtype declaration  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_data_type}{data}} &\mbox{\hyperlink{basic_data_types_string}{String}} or \mbox{\hyperlink{basic_data_types_binary}{Binary}} &same as received &Restricts input to \mbox{\hyperlink{basic_data_types_string}{String}} and \mbox{\hyperlink{basic_data_types_binary}{Binary}} and returns the same type  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_code_type}{code}} &\mbox{\hyperlink{expressions_closure}{Closures}}, \mbox{\hyperlink{expressions_call_reference}{Call References}} &same as received &Restricts values to \mbox{\hyperlink{expressions_closure}{closures}} and \mbox{\hyperlink{expressions_call_reference}{call references}}  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_reference_type}{reference}} &\mbox{\hyperlink{lvalue_references}{References}} &the type the reference points to &Restricts values to references to lvalues  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_reference_complex_type}{reference$<$...$>$}} &\mbox{\hyperlink{lvalue_references}{References}} &the type given as an argument &Restricts values to references to lvalues compatible with the given type  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_int_or_nothing_type}{$\ast$int}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_integer}{Integer}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_float_or_nothing_type}{$\ast$float}} &\mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_float}{Float}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_float}{Float}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_number_or_nothing_type}{$\ast$number}} &\mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_number}{Number}} or \mbox{\hyperlink{basic_data_types_number}{Number}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_number}{Number}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_bool_or_nothing_type}{$\ast$bool}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_boolean}{Boolean}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_string_or_nothing_type}{$\ast$string}} &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_string}{String}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_string}{String}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_date_or_nothing_type}{$\ast$date}} &\mbox{\hyperlink{basic_data_types_date}{Date}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_date}{Date}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_date}{Date}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} type; values may be either absolute or relative date/time values; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_binary_or_nothing_type}{$\ast$binary}} &\mbox{\hyperlink{basic_data_types_binary}{Binary}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_binary}{Binary}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_binary}{Binary}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_hash_or_nothing_type}{$\ast$hash}} &\mbox{\hyperlink{container_data_types_hash}{Hash}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{container_data_types_hash}{Hash}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_hash_hashdecl_or_nothing_type}{$\ast$hash$<$...$>$}} &\mbox{\hyperlink{container_data_types_hash}{Hash}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to values of the referenced \mbox{\hyperlink{hashdecl}{type-\/safe hash}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_hash_complex_or_nothing_type}{$\ast$hash$<$string, ...$>$}} &\mbox{\hyperlink{container_data_types_hash}{Hash}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts key values to the declared complex hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_list_or_nothing_type}{$\ast$list}} &\mbox{\hyperlink{container_data_types_list}{List}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts either a \mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_list_complex_or_nothing_type}{$\ast$list$<$...$>$}} &\mbox{\hyperlink{container_data_types_list}{List}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts list values to the declared complex list type or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_object_or_nothing_type}{$\ast$object}} &\mbox{\hyperlink{container_data_types_object}{Object}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_object}{Object}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts either an \mbox{\hyperlink{container_data_types_object}{Object}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_classname_type_or_nothing}{$\ast$$<$classname$>$}} &\mbox{\hyperlink{container_data_types_object}{Object}} of the given class, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_object}{Object}} of the given class or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to objects of the specific class given or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; either the class name can be given (ex\+: \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{$\ast$\+Mutex}} or a qualified path to the class\+: \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{$\ast$\+Qore\+::Thread\+::Mutex}}); if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_classname_type_or_nothing}{$\ast$object$<$...$>$}} &\mbox{\hyperlink{container_data_types_object}{Object}} of the given class, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_object}{Object}} of the given class or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to objects of the specific class given or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_null_or_nothing_type}{$\ast$null}} &\mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts input to \mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and returns the same type  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_data_or_nothing_type}{$\ast$data}} &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_binary}{Binary}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_binary}{Binary}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts input to \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_binary}{Binary}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and returns the same type; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_code_or_nothing_type}{$\ast$code}} &\mbox{\hyperlink{expressions_closure}{Closures}}, \mbox{\hyperlink{expressions_call_reference}{Call References}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{expressions_closure}{Closures}}, \mbox{\hyperlink{expressions_call_reference}{Call References}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{expressions_closure}{closures}}, \mbox{\hyperlink{expressions_call_reference}{call references}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_timeout_or_nothing_type}{$\ast$timeout}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_date}{Date}} and converts dates to an integer value representing milliseconds and returns the integer; incoming integers are assumed to represent milliseconds. If no value or \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed, then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_reference_or_nothing_type}{$\ast$reference}} &\mbox{\hyperlink{lvalue_references}{References}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &the type the reference points to and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to references to lvalues and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_reference_complex_or_nothing_type}{$\ast$reference$<$...$>$}} &\mbox{\hyperlink{lvalue_references}{References}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &the type given as an argument and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to references to lvalues compatible with the given type and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softint_or_nothing_type}{$\ast$softint}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/integer values to an integer and returns the integer. If no value or \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed, then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softfloat_or_nothing_type}{$\ast$softfloat}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_float}{Float}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/float values to a float and returns the new value. If no value or \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed, then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softnumber_or_nothing_type}{$\ast$softnumber}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_number}{Number}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/number values to a number and returns the new value. If no value or \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed, then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softbool_or_nothing_type}{$\ast$softbool}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/boolean values to a boolean and returns the new value. If no value or \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed, then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softstring_or_nothing_type}{$\ast$softstring}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_string}{String}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/string values to a string and returns the new value. If no value or \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed, then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softdate_or_nothing_type}{$\ast$softdate}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_date}{Date}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} and converts non-\/date values to a date and returns the new value. If no value or \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed, then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softlist_or_nothing_type}{$\ast$softlist}} &all types &\mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts all types; \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and list values are returned as the same value; \mbox{\hyperlink{basic_data_types_null}{NULL}} is returned as \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}, any other type is returned as the first element of a new list  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_softlist_complex_or_nothing_type}{$\ast$softlist$<$...$>$}} &all types &\mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts all data types; \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and \mbox{\hyperlink{basic_data_types_null}{NULL}} are returned as \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; a list is returned with its elements processed by the declared subtype, and any other type is returned as the first element of a new list with its element processed by the declared subtype  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_any_type}{any}} &any &same as received &Provides no restrictions on the type of value it receives and returns the same value, however complex type information is stripped on assignment for backwards compatibility; note that the {\ttfamily any} type restriction is the same as using no type restriction; to assign any type without stripping complex types, use the \mbox{\hyperlink{data_type_declarations_auto_type}{auto}} type restriction instead  \\\cline{1-4}
\mbox{\hyperlink{data_type_declarations_auto_type}{auto}} &all data types &all data types &Provides no restrictions on the type of value it receives and returns the same value; does not strip complex types on assignment like \mbox{\hyperlink{data_type_declarations_any_type}{any}}  \\\cline{1-4}
\end{longtabu}


\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_int_type}{}\doxysection{int}\label{data_type_declarations_int_type}
{\bfseries{int Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily int}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_integer}{Integer}} type  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{int sub foo(int i) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} i;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_float_type}{}\doxysection{float}\label{data_type_declarations_float_type}
{\bfseries{float Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily float}  &\mbox{\hyperlink{basic_data_types_float}{Float}} or \mbox{\hyperlink{basic_data_types_integer}{Integer}} &\mbox{\hyperlink{basic_data_types_float}{Float}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_float}{Float}} type  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{float sub foo(float f = M\_PI) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} f;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_number_type}{}\doxysection{number}\label{data_type_declarations_number_type}
{\bfseries{number Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily number}  &\mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, or \mbox{\hyperlink{basic_data_types_integer}{Integer}} &\mbox{\hyperlink{basic_data_types_number}{Number}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_number}{Number}} type  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{number sub foo(number n = 2.35e40) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} n;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 introduced the number type
\end{DoxySince}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_bool_type}{}\doxysection{bool}\label{data_type_declarations_bool_type}
{\bfseries{bool Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily bool}  &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_boolean}{Boolean}} type  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool sub foo(bool b) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} b;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_string_type}{}\doxysection{string}\label{data_type_declarations_string_type}
{\bfseries{string Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily string}  &\mbox{\hyperlink{basic_data_types_string}{String}} &\mbox{\hyperlink{basic_data_types_string}{String}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_string}{String}} type  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{string sub foo(string str = \textcolor{stringliteral}{"{}bar"{}}) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} str;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_date_type}{}\doxysection{date}\label{data_type_declarations_date_type}
{\bfseries{date Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily date}  &\mbox{\hyperlink{basic_data_types_date}{Date}} &\mbox{\hyperlink{basic_data_types_date}{Date}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_date}{Date}} type; date/time values can be either \mbox{\hyperlink{basic_data_types_absolute_dates}{absolute}} or \mbox{\hyperlink{basic_data_types_relative_dates}{relative}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{date sub foo(date d = \mbox{\hyperlink{group__date__and__time__functions_ga61b29a943e0e85abdc9792a9434e5b39}{now\_us}}()) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} d;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_binary_type}{}\doxysection{binary}\label{data_type_declarations_binary_type}
{\bfseries{binary Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily binary}  &\mbox{\hyperlink{basic_data_types_binary}{Binary}} &\mbox{\hyperlink{basic_data_types_binary}{Binary}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_binary}{Binary}} type  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{binary sub foo(binary b) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} b;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_hash_type}{}\doxysection{hash}\label{data_type_declarations_hash_type}
{\bfseries{hash Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily hash}  &\mbox{\hyperlink{container_data_types_hash}{Hash}} (all) &\mbox{\hyperlink{container_data_types_hash}{Hash}} (untyped) &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{container_data_types_hash}{Hash}} type; if a typed hash is received, type information is removed for the lvalue assignment  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{hash sub foo(hash h = (\textcolor{stringliteral}{"{}foo"{}}: \textcolor{stringliteral}{"{}bar"{}}, \textcolor{stringliteral}{"{}x"{}}: 2)) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} h;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_hash_hashdecl_type}{}\doxysubsection{Type-\/\+Safe Hash Type}\label{data_type_declarations_hash_hashdecl_type}
{\bfseries{\mbox{\hyperlink{hashdecl}{hashdecl}} Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily hash}  &\mbox{\hyperlink{container_data_types_hash}{hash}}$<${\itshape \mbox{\hyperlink{hashdecl}{hashdecl}}$>$} &\mbox{\hyperlink{container_data_types_hash}{hash}}$<${\itshape \mbox{\hyperlink{hashdecl}{hashdecl}}$>$}$>$ &Restricts values to hashes created from the given \mbox{\hyperlink{hashdecl}{hashdecl}}  \\\cline{1-4}
\end{longtabu}


The hash type takes a single \mbox{\hyperlink{hashdecl}{type-\/safe hash}} name (or namespace-\/ prefixed path) in angle brackets after {\ttfamily \char`\"{}hash\char`\"{}} which results in a type declaration restricted to the declared \mbox{\hyperlink{hashdecl}{type-\/safe hash}} as in the following example.

\begin{DoxyParagraph}{Examples}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# hashdecl typed hash declaration}}
\DoxyCodeLine{hashdecl MyHash \{}
\DoxyCodeLine{    string foo = \textcolor{stringliteral}{"{}empty"{}};}
\DoxyCodeLine{    int x = 1;}
\DoxyCodeLine{\}}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# declaration and initialization to default key values}}
\DoxyCodeLine{hash<MyHash> h1();}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# declaration and initialization with explicit values}}
\DoxyCodeLine{hash<MyHash> h2((\textcolor{stringliteral}{"{}foo"{}}: \textcolor{stringliteral}{"{}string"{}}, \textcolor{stringliteral}{"{}x"{}}: 10));}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# declaration and initialization with the new operator}}
\DoxyCodeLine{hash<MyHash> h3 = new hash<MyHash>((\textcolor{stringliteral}{"{}foo"{}}: \textcolor{stringliteral}{"{}string"{}}, \textcolor{stringliteral}{"{}x"{}}: 10));}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# example of a function with a typed hash return type and parameter type}}
\DoxyCodeLine{hash<MyHash> sub foo(hash<MyHash> h = new hash<MyHash>(\textcolor{stringliteral}{"{}foo"{}}: \textcolor{stringliteral}{"{}bar"{}}, \textcolor{stringliteral}{"{}x"{}}: 2)) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} h;}
\DoxyCodeLine{\}}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# example of a function with a typed hash return type and a cast to a typed hash return type}}
\DoxyCodeLine{hash<MyHash> sub foo(int x) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} cast<hash<MyHash>>(get\_hash(x));}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
This type is supported at parse-\/time and at runtime; to convert such values to an untyped hash, assign it to a \mbox{\hyperlink{data_type_declarations_hash_type}{hash}} lvalue, use \mbox{\hyperlink{operators_cast}{cast$<$hash$>$(...)}} on the value, call the \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash()}} function on the value, or assign it to an untyped lvalue. Each of these options can be used to convert a type-\/safe hash to an untyped hash.

Complex type information is lost when assigning to an lvalue with a compatible but more generic type or by assigning to an untyped lvalue; this was necessary to allow complex types to be introduced in Qore without breaking backwards compatibility.

However, a special single argument, {\ttfamily \char`\"{}auto\char`\"{}}, allows for the lvalue to maintain the complex hash type as in the following example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{hash h0 = (\textcolor{stringliteral}{"{}a"{}}: 2, \textcolor{stringliteral}{"{}b"{}}: 3);}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}hash"{}}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, h0.fullType());}
\DoxyCodeLine{hash<auto> h1 = new hash<MyHash>();}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}hash<MyHash>"{}}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, h1.fullType());}

\end{DoxyCode}


\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{hashdecl}{Hashdecl\+: Type-\/\+Safe Hash Declarations}}
\item \mbox{\hyperlink{operators_new}{New Value Operator (new)}}
\item \mbox{\hyperlink{operators_cast}{Cast Operator (cast$<$$>$())}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\hypertarget{data_type_declarations_hash_complex_type}{}\doxysubsection{Hash With Declared Value Type}\label{data_type_declarations_hash_complex_type}
{\bfseries{Complex hash Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily hash}  &\mbox{\hyperlink{container_data_types_hash}{hash}}$<$string, {\itshape \mbox{\hyperlink{data_type_declarations}{type}}}$>$ &\mbox{\hyperlink{container_data_types_hash}{hash}}$<$string, {\itshape \mbox{\hyperlink{data_type_declarations}{type}}}$>$ &Restricts values to hashes with the given declared key type; use \mbox{\hyperlink{operators_cast}{cast$<$$>$(...)}} to convert values to this type at runtime.  \\\cline{1-4}
\end{longtabu}


The hash type also supports two arguments in angle brackets to specify the key and value types, however the key type currently must always be \mbox{\hyperlink{data_type_declarations_string_type}{string}}. This results in a hash where the keys and values must always be of the declared type. See the following example for more information.

\begin{DoxyParagraph}{Examples}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# 1: declaration and initialization (identical to 2 and 3)}}
\DoxyCodeLine{hash<string, int> h1((}
\DoxyCodeLine{    \textcolor{stringliteral}{"{}code"{}}: 500,}
\DoxyCodeLine{    \textcolor{stringliteral}{"{}type"{}}: 300,}
\DoxyCodeLine{    \textcolor{stringliteral}{"{}value"{}}: 0,}
\DoxyCodeLine{));}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# 2: declaration and initialization with the assignment operator (identical to 1 and 3)}}
\DoxyCodeLine{hash<string, int> h2 = (}
\DoxyCodeLine{    \textcolor{stringliteral}{"{}code"{}}: 500,}
\DoxyCodeLine{    \textcolor{stringliteral}{"{}type"{}}: 300,}
\DoxyCodeLine{    \textcolor{stringliteral}{"{}value"{}}: 0,}
\DoxyCodeLine{);}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# 3: declaration and initialization with the new operator (identical to 1 and 2)}}
\DoxyCodeLine{hash<string, int> h3 = new hash<string, int>((}
\DoxyCodeLine{    \textcolor{stringliteral}{"{}code"{}}: 500,}
\DoxyCodeLine{    \textcolor{stringliteral}{"{}type"{}}: 300,}
\DoxyCodeLine{    \textcolor{stringliteral}{"{}value"{}}: 0,}
\DoxyCodeLine{));}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# assignment from an untyped hash with the cast<> operator (can result in runtime type errors)}}
\DoxyCodeLine{hash<string, int> h4 = cast<hash<string, int>>(get\_hash());}

\end{DoxyCode}

\end{DoxyParagraph}
This type is supported at parse-\/time and at runtime; to convert such values to an untyped hash, assign it to a \mbox{\hyperlink{data_type_declarations_hash_type}{hash}} lvalue, use \mbox{\hyperlink{operators_cast}{cast$<$hash$>$(...)}} on the value, call the \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash()}} function on the value, or assign it to an untyped lvalue. Each of these options can be used to convert a type-\/safe hash to an untyped hash.

Complex type information is lost when assigning to an lvalue with a compatible but more generic type or by assigning to an untyped lvalue; this was necessary to allow complex types to be introduced in Qore without breaking backwards compatibility.

However, a special single argument, {\ttfamily \char`\"{}auto\char`\"{}}, allows for the lvalue to maintain the complex hash type as in the following example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{hash h0 = (\textcolor{stringliteral}{"{}a"{}}: 2, \textcolor{stringliteral}{"{}b"{}}: 3);}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}hash"{}}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, h0.fullType());}
\DoxyCodeLine{hash<auto> h1 = (\textcolor{stringliteral}{"{}a"{}}: 2, \textcolor{stringliteral}{"{}b"{}}: 3);}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}hash<string, int>"{}}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, h1.fullType());}

\end{DoxyCode}


\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{hashdecl}{Hashdecl\+: Type-\/\+Safe Hash Declarations}}
\item \mbox{\hyperlink{operators_new}{New Value Operator (new)}}
\item \mbox{\hyperlink{operators_cast}{Cast Operator (cast$<$$>$())}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_list_type}{}\doxysection{list}\label{data_type_declarations_list_type}
{\bfseries{list Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily list}  &\mbox{\hyperlink{container_data_types_list}{List}} &\mbox{\hyperlink{container_data_types_list}{List}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{container_data_types_list}{List}} type  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{list sub foo(list l = (\textcolor{stringliteral}{"{}foo"{}}, \textcolor{stringliteral}{"{}bar"{}})) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} l;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_list_complex_type}{}\doxysubsection{List With Declared Value Type}\label{data_type_declarations_list_complex_type}
{\bfseries{Complex list Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily list}  &\mbox{\hyperlink{container_data_types_list}{list}}$<${\itshape \mbox{\hyperlink{data_type_declarations}{type}}}$>$ &\mbox{\hyperlink{container_data_types_list}{list}}$<${\itshape \mbox{\hyperlink{data_type_declarations}{type}}}$>$ &Restricts values to lists with the given declared value type; use \mbox{\hyperlink{operators_cast}{cast$<$$>$(...)}} to convert values to this type at runtime.  \\\cline{1-4}
\end{longtabu}


The list type supports one type argument in angle brackets to specify the value type. This results in a list where the values must always be of the declared type. See the following example for more information.

\begin{DoxyParagraph}{Examples}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# 1: declaration and initialization (identical to 2 and 3)}}
\DoxyCodeLine{list<int> l1(500, 300, 0);}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# 2: declaration and initialization with the assignment operator (identical to 1 and 3)}}
\DoxyCodeLine{list<int> l2 = (500, 300, 0);}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# 3: declaration and initialization with the new operator (identical to 1 and 2)}}
\DoxyCodeLine{list<int> l3 = new list<int>(500, 300, 0);}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# assignment from an untyped list with the cast<> operator (can result in runtime type errors)}}
\DoxyCodeLine{list<int> l4 = cast<list<int>>(get\_list());}

\end{DoxyCode}

\end{DoxyParagraph}
This type is supported at parse-\/time and at runtime; to convert such values to an untyped list, assign it to a \mbox{\hyperlink{data_type_declarations_list_type}{list}} lvalue, use \mbox{\hyperlink{operators_cast}{cast$<$list$>$(...)}} on the value, call the \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list()}} function on the value, or assign it to an untyped lvalue. Each of these options can be used to convert a type-\/safe list to an untyped list.

Complex type information is lost when assigning to an lvalue with a compatible but more generic type or by assigning to an untyped lvalue; this was necessary to allow complex types to be introduced in Qore without breaking backwards compatibility.

However, a special single argument, {\ttfamily \char`\"{}auto\char`\"{}}, allows for the lvalue to maintain the complex list type as in the following example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{list l0 = (2, 3);}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}list"{}}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, l0.fullType());}
\DoxyCodeLine{list<auto> l1 = (2, 3);}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}list<int>"{}}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, l1.fullType());}

\end{DoxyCode}


\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{operators_new}{New Value Operator (new)}}
\item \mbox{\hyperlink{operators_cast}{Cast Operator (cast$<$$>$())}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_object_type}{}\doxysection{object}\label{data_type_declarations_object_type}
{\bfseries{object Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily object}  &\mbox{\hyperlink{container_data_types_object}{Object}} &\mbox{\hyperlink{container_data_types_object}{Object}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{container_data_types_object}{Object}} type; note that any class name can also be used as a type restriction directly  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{object sub foo(object o = new Mutex()) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} o;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_object_complex_type}{}\doxysubsection{Class-\/\+Specific Type Declaration}\label{data_type_declarations_object_complex_type}
{\bfseries{Complex object Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily object}  &\mbox{\hyperlink{container_data_types_object}{object}}$<${\itshape \mbox{\hyperlink{qore_classes}{class}}}$>$ &\mbox{\hyperlink{container_data_types_object}{object}}$<${\itshape \mbox{\hyperlink{qore_classes}{class}}}$>$ &Restricts values to objects of the given class  \\\cline{1-4}
\end{longtabu}


The object type declaration takes a single \mbox{\hyperlink{qore_classes}{class}} name (or namespace-\/ prefixed path) in angle brackets after {\ttfamily \char`\"{}object\char`\"{}} which results in a type declaration restricted to the declared \mbox{\hyperlink{qore_classes}{class}} as in the following example.

\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{object<MyClass> sub foo(MyClass o = new MyClass()) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} o;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
this type declaration is equivalent to using the class name by itself
\end{DoxyNote}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_classname_type}{}\doxysection{$<$classname$>$}\label{data_type_declarations_classname_type}
{\bfseries{$<$classname$>$ Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\itshape any class name} &\mbox{\hyperlink{container_data_types_object}{Object}} of the particular class given &\mbox{\hyperlink{container_data_types_object}{Object}} of the particular class given &Restricts values to objects of the particular class given; subclasses are also accepted  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{Mutex sub foo(Qore::Thread::Mutex m = new Mutex()) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} m;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_null_type}{}\doxysection{null}\label{data_type_declarations_null_type}
{\bfseries{null Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily null}  &\mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_null}{NULL}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_null}{NULL}} type; this type has few (if any) practical applications and has been included for completeness\textquotesingle{} sake  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# I don't know if this type has any useful/practical applications...}}
\DoxyCodeLine{null n = NULL;}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_nothing_type}{}\doxysection{nothing}\label{data_type_declarations_nothing_type}
{\bfseries{nothing Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily nothing}  &\mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} type; this type is mostly useful for declaring that a function or method returns no value  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{nothing sub bar() \{}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}foo\(\backslash\)n"{}});}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_timeout_type}{}\doxysection{timeout}\label{data_type_declarations_timeout_type}
{\bfseries{timeout Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily timeout}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_date}{Date}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_date}{Date}} values and converts dates to an integer value representing milliseconds and returns the integer; incoming integers are assumed to represent milliseconds  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{timeout sub foo(timeout to = 1250ms) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} to;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
Assigned variables of this type return integers where a single unit equals one millisecond; when an integer is converted to a date/time value, it is converted with a single unit equalling one second, therefore unexpected values can result when performing arithmetic operations with these values. Qore handles simple addition and subtraction correctly with mixed date/time values and timeout variables when the variable is used directly in the operation, but other operations will most likely not produce the expected results. It\textquotesingle{}s recommended to avoid doing direct arithmetic with timeout values for this reason.
\end{DoxyNote}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_base64binary_type}{}\doxysection{base64binary}\label{data_type_declarations_base64binary_type}
{\bfseries{base64binary Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily base64binary}  &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_binary}{Binary}} &\mbox{\hyperlink{basic_data_types_binary}{Binary}} &Accepts \mbox{\hyperlink{basic_data_types_string}{String}} values by converting base64-\/encoded strings to a binary value and returns the binary  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{base64binary sub foo(base64binary n = \textcolor{stringliteral}{"{}qw=="{}}) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} n;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
invalid base64-\/encoded strings cause an exception to be thrown
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{data_type_declarations_softbinary_type}{softbinary}}
\item \mbox{\hyperlink{data_type_declarations_hexbinary_type}{hexbinary}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 1.\+7 introduced the base64binary type
\end{DoxySince}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_hexbinary_type}{}\doxysection{hexbinary}\label{data_type_declarations_hexbinary_type}
{\bfseries{hexbinary Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily hexbinary}  &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_binary}{Binary}} &\mbox{\hyperlink{basic_data_types_binary}{Binary}} &Accepts \mbox{\hyperlink{basic_data_types_string}{String}} values by converting hex strings to a binary value and returns the binary  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{binary sub foo(hexbinary n = \textcolor{stringliteral}{"{}abcd"{}}) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} n;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
hex binary strings must have an even number of characters, any invalid characters cause an exception to be thrown
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{data_type_declarations_base64binary_type}{base64binary}}
\item \mbox{\hyperlink{data_type_declarations_softbinary_type}{softbinary}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 1.\+7 introduced the hexbinary type
\end{DoxySince}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softbinary_type}{}\doxysection{softbinary}\label{data_type_declarations_softbinary_type}
{\bfseries{softbinary Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily softbinary}  &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_binary}{Binary}} &\mbox{\hyperlink{basic_data_types_binary}{Binary}} &Accepts \mbox{\hyperlink{basic_data_types_string}{String}} values and converts non-\/binary values to a binary directly and returns the binary  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{softbinary sub foo(softbinary n = \textcolor{stringliteral}{"{}1000"{}}) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} n;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{data_type_declarations_base64binary_type}{base64binary}}
\item \mbox{\hyperlink{data_type_declarations_hexbinary_type}{hexbinary}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+9.\+5 introduced the softbinary type
\end{DoxySince}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softint_type}{}\doxysection{softint}\label{data_type_declarations_softint_type}
{\bfseries{softint Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily softint}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/integer values to an integer and returns the integer  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{softint sub foo(softint i = \textcolor{stringliteral}{"{}1000"{}}) \{}
\DoxyCodeLine{    \textcolor{comment}{\# note that "{}200"{} will be converted to an integer on return}}
\DoxyCodeLine{    \textcolor{keywordflow}{return} i > 500 ? \textcolor{stringliteral}{"{}200"{}} : i;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softfloat_type}{}\doxysection{softfloat}\label{data_type_declarations_softfloat_type}
{\bfseries{softfloat Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily softfloat}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_float}{Float}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/float values to a float and returns the float  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{softfloat sub foo(softfloat f = \textcolor{stringliteral}{"{}1000"{}}) \{}
\DoxyCodeLine{    \textcolor{comment}{\# note that "{}200"{} will be converted to a float on return}}
\DoxyCodeLine{    \textcolor{keywordflow}{return} f > 500.0 ? \textcolor{stringliteral}{"{}200"{}} : f;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softnumber_type}{}\doxysection{softnumber}\label{data_type_declarations_softnumber_type}
{\bfseries{softnumber Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily softnumber}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{data_type_declarations_number_type}{number}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/number values to a number and returns the number  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{softnumber sub foo(softnumber n = \textcolor{stringliteral}{"{}1000"{}}) \{}
\DoxyCodeLine{    \textcolor{comment}{\# note that "{}200"{} will be converted to a number on return}}
\DoxyCodeLine{    \textcolor{keywordflow}{return} n > 500.0n ? \textcolor{stringliteral}{"{}200"{}} : n;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 introduced the softnumber type
\end{DoxySince}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softbool_type}{}\doxysection{softbool}\label{data_type_declarations_softbool_type}
{\bfseries{softbool Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily softbool}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/boolean values to a boolean and returns the boolean  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{softbool b = \textcolor{stringliteral}{"{}0.5"{}};}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softstring_type}{}\doxysection{softstring}\label{data_type_declarations_softstring_type}
{\bfseries{softstring Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily softstring}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_string}{String}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/string values to a string and returns the string  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{softstring str = 200;}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softdate_type}{}\doxysection{softdate}\label{data_type_declarations_softdate_type}
{\bfseries{softdate Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily softdate}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, \mbox{\hyperlink{basic_data_types_null}{NULL}} &\mbox{\hyperlink{basic_data_types_date}{Date}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/date values to a date and returns the date  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{softdate d = \textcolor{stringliteral}{"{}2001-\/10-\/10T20:00:05 +04:00"{}};}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softlist_type}{}\doxysection{softlist}\label{data_type_declarations_softlist_type}
{\bfseries{softlist Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily softlist}  &all data types &\mbox{\hyperlink{container_data_types_list}{List}} &Accepts all data types; \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned as an empty list; a list is returned unchanged, and any other type is returned as the first element of a new list  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{softlist sub foo(softlist l) \{}
\DoxyCodeLine{    foreach any element \textcolor{keywordflow}{in} (\(\backslash\)l) \{}
\DoxyCodeLine{    \}}
\DoxyCodeLine{    \textcolor{keywordflow}{return} l;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_softlist_complex_type}{}\doxysubsection{Softlist With Declared Value Type}\label{data_type_declarations_softlist_complex_type}
{\bfseries{Complex list Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily softlist}  &all data types &\mbox{\hyperlink{container_data_types_list}{List}} &Accepts all data types; \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned as an empty list; a list is returned with its elements processed by the subtype declaration, and any other type is returned as the first element of a new list, also processed by the subtype declaration  \\\cline{1-4}
\end{longtabu}


The softlist type supports one type argument in angle brackets to specify the value type. This results in a list where the values must always be of the declared type. See the following example for more information.

\begin{DoxyParagraph}{Examples}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# 1: declaration and initialization (identical to 2 and 3)}}
\DoxyCodeLine{softlist<int> l1(500, 300, 0);}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# 2: declaration and initialization with the assignment operator (identical to 1 and 3)}}
\DoxyCodeLine{softlist<int> l2 = (500, 300, 0);}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# 3: declaration and initialization with the new operator (identical to 1 and 2)}}
\DoxyCodeLine{softlist<int> l3 = new list<int>(500, 300, 0);}
\DoxyCodeLine{}
\DoxyCodeLine{\textcolor{comment}{\# assignment from an untyped list with the cast<> operator (can result in runtime type errors)}}
\DoxyCodeLine{softlist<int> l4 = cast<list<int>>(get\_list());}

\end{DoxyCode}

\end{DoxyParagraph}
This type is supported at parse-\/time and at runtime; to convert such values to an untyped list, assign it to a \mbox{\hyperlink{data_type_declarations_list_type}{list}} lvalue, use \mbox{\hyperlink{operators_cast}{cast$<$list$>$(...)}} on the value, call the \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list()}} function on the value, or assign it to an untyped lvalue. Each of these options can be used to convert a type-\/safe list to an untyped list.

Complex type information is lost when assigning to an lvalue with a compatible but more generic type or by assigning to an untyped lvalue; this was necessary to allow complex types to be introduced in Qore without breaking backwards compatibility.

However, a special single argument, {\ttfamily \char`\"{}auto\char`\"{}}, allows for the lvalue to maintain the complex list type as in the following example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{softlist l0 = 1;}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}list"{}}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, l0.fullType());}
\DoxyCodeLine{softlist<auto> l1 = (1, );}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}list<int>"{}}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, l1.fullType());}

\end{DoxyCode}


\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{operators_new}{New Value Operator (new)}}
\item \mbox{\hyperlink{operators_cast}{Cast Operator (cast$<$$>$())}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+3 introduced the softlist type
\end{DoxySince}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_data_type}{}\doxysection{data}\label{data_type_declarations_data_type}
{\bfseries{data Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily data}  &\mbox{\hyperlink{basic_data_types_string}{String}} or \mbox{\hyperlink{basic_data_types_binary}{Binary}} &same as received &Restricts values to \mbox{\hyperlink{basic_data_types_string}{String}} and \mbox{\hyperlink{basic_data_types_binary}{Binary}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{data sub foo(data d) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} d;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_code_type}{}\doxysection{code}\label{data_type_declarations_code_type}
{\bfseries{code Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily code}  &\mbox{\hyperlink{expressions_closure}{Closures}}, \mbox{\hyperlink{expressions_call_reference}{Call References}} &same as received &Restricts values to \mbox{\hyperlink{expressions_closure}{Closures}} and \mbox{\hyperlink{expressions_call_reference}{Call References}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(code c) \{}
\DoxyCodeLine{    c();}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
that also {\ttfamily \char`\"{}closure\char`\"{}} and {\ttfamily \char`\"{}callref\char`\"{}} are accepted as synonyms for {\ttfamily \char`\"{}code\char`\"{}} (they are not more specific than {\ttfamily \char`\"{}code\char`\"{}} but rather provide identical type restrictions)
\end{DoxyNote}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_reference_type}{}\doxysection{reference}\label{data_type_declarations_reference_type}
{\bfseries{reference Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily reference}  &\mbox{\hyperlink{lvalue_references}{References}} &the type the reference points to &Requires a reference to an lvalue to be assigned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(reference f) \{}
\DoxyCodeLine{    f = 10;}
\DoxyCodeLine{\}}
\DoxyCodeLine{}
\DoxyCodeLine{int i;}
\DoxyCodeLine{foo(\(\backslash\)i);}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_reference_complex_type}{}\doxysubsection{Reference With Declared LValue Type}\label{data_type_declarations_reference_complex_type}
{\bfseries{Complex reference Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily reference}  &\mbox{\hyperlink{lvalue_references}{reference}}$<${\itshape \mbox{\hyperlink{data_type_declarations}{type}}}$>$ &type as given as the arg &Restricts values to references to lvalues with a type compatible to that given as the type argument  \\\cline{1-4}
\end{longtabu}


The reference type supports one type argument in angle brackets to specify a compatible lvalue type. See the following example for more information.

\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{int i = 0;}
\DoxyCodeLine{reference<int> r = \(\backslash\)i;}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_int_or_nothing_type}{}\doxysection{$\ast$int}\label{data_type_declarations_int_or_nothing_type}
{\bfseries{$\ast$int Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$int}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{basic_data_types_integer}{Integer}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*int sub foo(*int i) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} i;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_float_or_nothing_type}{}\doxysection{$\ast$float}\label{data_type_declarations_float_or_nothing_type}
{\bfseries{$\ast$float Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$float}  &\mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_float}{Float}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{basic_data_types_float}{Float}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*float sub foo(*float f) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} f;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_number_or_nothing_type}{}\doxysection{$\ast$number}\label{data_type_declarations_number_or_nothing_type}
{\bfseries{$\ast$number Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$number}  &\mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_number}{Number}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{basic_data_types_number}{Number}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*number sub foo(*number n) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} n;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 introduced the $\ast$number type
\end{DoxySince}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_bool_or_nothing_type}{}\doxysection{$\ast$bool}\label{data_type_declarations_bool_or_nothing_type}
{\bfseries{$\ast$bool Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$bool}  &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{basic_data_types_boolean}{Boolean}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*bool sub foo(*bool b) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} b;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_string_or_nothing_type}{}\doxysection{$\ast$string}\label{data_type_declarations_string_or_nothing_type}
{\bfseries{$\ast$string Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$string}  &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_string}{String}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{basic_data_types_string}{String}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string sub foo(*string str) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} str;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_date_or_nothing_type}{}\doxysection{$\ast$date}\label{data_type_declarations_date_or_nothing_type}
{\bfseries{$\ast$date Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$date}  &\mbox{\hyperlink{basic_data_types_date}{Date}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_date}{Date}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{basic_data_types_date}{Date}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*date sub foo(*date str) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} str;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_binary_or_nothing_type}{}\doxysection{$\ast$binary}\label{data_type_declarations_binary_or_nothing_type}
{\bfseries{$\ast$binary Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$binary}  &\mbox{\hyperlink{basic_data_types_binary}{Binary}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_binary}{Binary}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{basic_data_types_binary}{Binary}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*binary sub foo(*binary b) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} b;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_hash_or_nothing_type}{}\doxysection{$\ast$hash}\label{data_type_declarations_hash_or_nothing_type}
{\bfseries{$\ast$hash Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$hash}  &\mbox{\hyperlink{container_data_types_hash}{Hash}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{container_data_types_hash}{Hash}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*hash sub foo(*hash h) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} h;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_hash_hashdecl_or_nothing_type}{}\doxysubsection{$\ast$hash$<$...$>$}\label{data_type_declarations_hash_hashdecl_or_nothing_type}
{\bfseries{Complex Hashdecl or Nothing Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$hash$<$...$>$} &\mbox{\hyperlink{container_data_types_hash}{Hash}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to values of the referenced \mbox{\hyperlink{hashdecl}{type-\/safe hash}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*hash<MyHash> sub foo(*hash<MyHash> h) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} h;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_hash_complex_or_nothing_type}{}\doxysubsection{$\ast$hash$<$string, ...$>$}\label{data_type_declarations_hash_complex_or_nothing_type}
{\bfseries{Complex Hash or Nothing Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$hash$<$string, ...$>$} &\mbox{\hyperlink{container_data_types_hash}{Hash}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_hash}{Hash}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts key values to the declared complex hash or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*hash<string, int> sub foo(*hash<string, int> h) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} h;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_list_or_nothing_type}{}\doxysection{$\ast$list}\label{data_type_declarations_list_or_nothing_type}
{\bfseries{$\ast$list Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$list}  &\mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{container_data_types_list}{List}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*list sub foo(*list l) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} l;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_list_complex_or_nothing_type}{}\doxysubsection{$\ast$list$<$...$>$}\label{data_type_declarations_list_complex_or_nothing_type}
{\bfseries{Complex List or Nothing Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$list$<$...$>$} &\mbox{\hyperlink{container_data_types_list}{List}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts list values to the declared complex list type or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*list<int> sub foo(*list<int> l) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} l;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_object_or_nothing_type}{}\doxysection{$\ast$object}\label{data_type_declarations_object_or_nothing_type}
{\bfseries{$\ast$list Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$list}  &\mbox{\hyperlink{container_data_types_object}{Object}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_object}{Object}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{container_data_types_object}{Object}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*object sub foo(*object obj) \{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} obj;}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_classname_type_or_nothing}{}\doxysection{$\ast$$<$classname$>$}\label{data_type_declarations_classname_type_or_nothing}
{\bfseries{$\ast$$<$classname$>$ Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$}{\itshape any class name} &\mbox{\hyperlink{container_data_types_object}{Object}} of the particular class given, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{container_data_types_object}{Object}} of the particular class given or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to objects of the particular class given or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; subclasses are also accepted; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*Mutex m) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_null_or_nothing_type}{}\doxysection{$\ast$null}\label{data_type_declarations_null_or_nothing_type}
{\bfseries{null Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily null}  &\mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_null}{NULL}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to Qore\textquotesingle{}s \mbox{\hyperlink{basic_data_types_null}{NULL}} and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} types; this type has few (if any) practical applications and has been included for completeness\textquotesingle{} sake  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# I don't know if this type has any useful/practical applications...}}
\DoxyCodeLine{*null n = NULL;}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_data_or_nothing_type}{}\doxysection{$\ast$date}\label{data_type_declarations_data_or_nothing_type}
{\bfseries{$\ast$data Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$data}  &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_binary}{Binary}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_binary}{Binary}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_binary}{Binary}}, and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*data d) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_code_or_nothing_type}{}\doxysection{$\ast$code}\label{data_type_declarations_code_or_nothing_type}
{\bfseries{$\ast$code Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$code}  &\mbox{\hyperlink{expressions_closure}{Closures}}, \mbox{\hyperlink{expressions_call_reference}{Call References}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{expressions_closure}{Closures}}, \mbox{\hyperlink{expressions_call_reference}{Call References}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to \mbox{\hyperlink{expressions_closure}{Closures}}, \mbox{\hyperlink{expressions_call_reference}{Call References}}, and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*code c) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_timeout_or_nothing_type}{}\doxysection{$\ast$timeout}\label{data_type_declarations_timeout_or_nothing_type}
{\bfseries{$\ast$timeout Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$timeout}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &converts dates to an integer value representing milliseconds and returns the integer; incoming integers are assumed to represent milliseconds; also accepts \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*timeout c) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
Assigned variables of this type return integers where a single unit equals one millisecond; when an integer is converted to a date/time value, it is converted with a single unit equalling one second, therefore unexpected values can result when performing arithmetic operations with these values. Qore handles simple addition and subtraction correctly with mixed date/time values and timeout variables when the variable is used directly in the operation, but other operations will most likely not produce the expected results. It\textquotesingle{}s recommended to avoid doing direct arithmetic with timeout values for this reason.
\end{DoxyNote}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_reference_or_nothing_type}{}\doxysection{$\ast$reference}\label{data_type_declarations_reference_or_nothing_type}
{\bfseries{$\ast$reference Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily reference}  &\mbox{\hyperlink{lvalue_references}{References}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &the type the reference points to &Requires a reference to an lvalue to be assigned or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*reference f) \{}
\DoxyCodeLine{    f = 10;}
\DoxyCodeLine{\}}
\DoxyCodeLine{}
\DoxyCodeLine{int i;}
\DoxyCodeLine{foo(\(\backslash\)i);}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_reference_complex_or_nothing_type}{}\doxysubsection{$\ast$reference$<$...$>$}\label{data_type_declarations_reference_complex_or_nothing_type}
{\bfseries{complex Reference or Nothing Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$reference$<$...$>$} &\mbox{\hyperlink{lvalue_references}{References}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &the type given as an argument and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Restricts values to references to lvalues compatible with the given type and \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; if \mbox{\hyperlink{basic_data_types_null}{NULL}} is passed then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is returned  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*reference<int> f) \{}
\DoxyCodeLine{    f = 10;}
\DoxyCodeLine{\}}
\DoxyCodeLine{}
\DoxyCodeLine{int i;}
\DoxyCodeLine{foo(\(\backslash\)i);}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softint_or_nothing_type}{}\doxysection{$\ast$softint}\label{data_type_declarations_softint_or_nothing_type}
{\bfseries{$\ast$softint Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$softint}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_integer}{Integer}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/integer values to an integer and returns the integer; also accepts \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and \mbox{\hyperlink{basic_data_types_null}{NULL}} and returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*softint i) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softfloat_or_nothing_type}{}\doxysection{$\ast$softfloat}\label{data_type_declarations_softfloat_or_nothing_type}
{\bfseries{$\ast$softfloat Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$softfloat}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_float}{Float}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/float values to a float and returns the float; also accepts \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and \mbox{\hyperlink{basic_data_types_null}{NULL}} and returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*softfloat f) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softnumber_or_nothing_type}{}\doxysection{$\ast$softnumber}\label{data_type_declarations_softnumber_or_nothing_type}
{\bfseries{$\ast$softnumber Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$softnumber}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_number}{Number}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/number values to a number and returns the number; also accepts \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and \mbox{\hyperlink{basic_data_types_null}{NULL}} and returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*softnumber n) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 introduced the $\ast$softnumber type
\end{DoxySince}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softbool_or_nothing_type}{}\doxysection{$\ast$softbool}\label{data_type_declarations_softbool_or_nothing_type}
{\bfseries{$\ast$softbool Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$softbool}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_boolean}{Boolean}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/boolean values to a boolean and returns the boolean; also accepts \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and \mbox{\hyperlink{basic_data_types_null}{NULL}} and returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*softbool b) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softstring_or_nothing_type}{}\doxysection{$\ast$softstring}\label{data_type_declarations_softstring_or_nothing_type}
{\bfseries{$\ast$softstring Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$softstring}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_string}{String}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/string values to a string and returns the string; also accepts \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*softstring str) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softdate_or_nothing_type}{}\doxysection{$\ast$softdate}\label{data_type_declarations_softdate_or_nothing_type}
{\bfseries{$\ast$softdate Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$softdate}  &\mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, \mbox{\hyperlink{basic_data_types_null}{NULL}}, \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &\mbox{\hyperlink{basic_data_types_string}{String}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts \mbox{\hyperlink{basic_data_types_integer}{Integer}}, \mbox{\hyperlink{basic_data_types_float}{Float}}, \mbox{\hyperlink{basic_data_types_number}{Number}}, \mbox{\hyperlink{basic_data_types_boolean}{Boolean}}, \mbox{\hyperlink{basic_data_types_string}{String}}, \mbox{\hyperlink{basic_data_types_date}{Date}}, and \mbox{\hyperlink{basic_data_types_null}{NULL}} values and converts non-\/date values to a date and returns the date; also accepts \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and \mbox{\hyperlink{basic_data_types_null}{NULL}} and returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{sub foo(*softdate d) \{}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_softlist_or_nothing_type}{}\doxysection{$\ast$softlist}\label{data_type_declarations_softlist_or_nothing_type}
{\bfseries{$\ast$softlist Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$softlist}  &all data types &\mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts all data types; \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and \mbox{\hyperlink{basic_data_types_null}{NULL}} are returned as \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; a list is returned unchanged, and any other type is returned as the first element of a new list  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*softlist d = v;}

\end{DoxyCode}

\end{DoxyParagraph}
\hypertarget{data_type_declarations_softlist_complex_or_nothing_type}{}\doxysubsection{$\ast$softlist$<$...$>$}\label{data_type_declarations_softlist_complex_or_nothing_type}
{\bfseries{Complex Softlist or Nothing Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily $\ast$softlist}  &all data types &\mbox{\hyperlink{container_data_types_list}{List}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} &Accepts all data types; \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} and \mbox{\hyperlink{basic_data_types_null}{NULL}} are returned as \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}}; a list is returned with its elements processed by the declared subtype, and any other type is returned as the first element of a new list with its element processed by the declared subtype  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{*softlist<softint> sub foo() \{}
\DoxyCodeLine{    \textcolor{comment}{\# returns a list with 2 as the first element}}
\DoxyCodeLine{    \textcolor{keywordflow}{return} \textcolor{stringliteral}{"{}2"{}};}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+3 introduced the $\ast$softlist type
\end{DoxySince}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_any_type}{}\doxysection{any}\label{data_type_declarations_any_type}
{\bfseries{any Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily any}  &all data types &all data types &Provides no restrictions on the type of value it receives and returns the same value, however complex type information is stripped on assignment for backwards compatibility  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{any v = bar;}
\DoxyCodeLine{any l = (1, 2);}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}list"{} as the complex type info is stripped on assignment for backwards compatibility}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%s\(\backslash\)n"{}}, l.fullType());}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item The {\ttfamily any} type restriction is the same as using no type restriction
\item To assign any type without stripping complex types, use the \mbox{\hyperlink{data_type_declarations_auto_type}{auto}} type restriction instead
\item In general \mbox{\hyperlink{data_type_declarations_auto_type}{auto}} is recommended over {\ttfamily any} 
\end{DoxyItemize}
\end{DoxyNote}
\DoxyHorRuler{0}
 \hypertarget{data_type_declarations_auto_type}{}\doxysection{auto}\label{data_type_declarations_auto_type}
{\bfseries{auto Type Restriction}}  \tabulinesep=1mm
\begin{longtabu}spread 0pt [c]{*{4}{|X[-1]}|}
\hline
{\bfseries{Name}} &{\bfseries{Accepts Qore Type(s)}} &{\bfseries{Returns Qore Type(s)}} &{\bfseries{Description}}  \\\cline{1-4}
{\ttfamily auto}  &all data types &all data types &Provides no restrictions on the type of value it receives and returns the same value; does not strip complex types on assignment like \mbox{\hyperlink{data_type_declarations_any_type}{any}}  \\\cline{1-4}
\end{longtabu}


\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{auto v = bar;}
\DoxyCodeLine{auto l = (1, 2);}
\DoxyCodeLine{\textcolor{comment}{\# prints "{}list<int>"{}}}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%s\(\backslash\)n"{}}, l.fullType());}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyItemize}
\item In general {\ttfamily auto} is recommended over \mbox{\hyperlink{data_type_declarations_any_type}{any}} 
\end{DoxyItemize}