\begin{DoxyParagraph}{Description}
Constant definitions allow programmers to refer to values with Qore identifiers rather than using the value or the expression that generates the value.
\end{DoxyParagraph}
\begin{DoxyParagraph}{Constant Declaration Syntax}
{\ttfamily \mbox{[}\mbox{\hyperlink{qore_modules_mod_public}{public}}\mbox{]} {\bfseries{const}}} {\itshape \mbox{\hyperlink{qore_namespaces_namespace_paths}{\mbox{[}namespace\+\_\+path\+::\mbox{]}}}constant\+\_\+identifier} {\ttfamily =} {\itshape \mbox{\hyperlink{expressions}{initialization\+\_\+expression}}};
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{const PI\_SQUARED = \mbox{\hyperlink{group__math__functions_gaf2588c28291e1350f74db63b3e4a0a1a}{pow}}(Qore::M\_PI, 2);}

\end{DoxyCode}

\end{DoxyParagraph}
When defining a \mbox{\hyperlink{qore_modules_user_modules}{user module}}, constant definitions can be preceded by \mbox{\hyperlink{qore_modules_mod_public}{public}}, which means that the constant will be available (imported) in the \mbox{\hyperlink{class_qore_1_1_program}{Program}} object importing the module. Note that however the \mbox{\hyperlink{qore_modules_mod_public}{public}} keyword cannot be used when defining class constants in a public or private declaration block. See \mbox{\hyperlink{qore_modules_mod_public}{public}} for more information.

\begin{DoxySince}{Since}
0.\+8.\+1 The expression used to initialize a constant can be any valid \mbox{\hyperlink{expressions}{Qore expression}} as long as no variables are referenced.
\end{DoxySince}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item It is bad programming practice to assign a constant with an expression that has side effects. Furthermore if an expression used to initialize a constant throws an exception, that exception cannot be caught in the program being defined.
\item The order that constants are initialized and assigned does not necessarily correspond to declaration order, however constants may be defined using the values of other constants; if a circular reference is detected a parse exception is raised.
\item Constants are resolved in the second stage of parsing (during the parse commit stage, see also \mbox{\hyperlink{class_qore_1_1_program_a789d84e0f40137ad3b38064378b50e1b}{Program\+::parse\+Commit()}}
\item Classes can also declare constants; see \mbox{\hyperlink{qore_classes_class_constants}{Class Constants}} for more information. 
\end{DoxyItemize}
\end{DoxyNote}
