Builtin functions (and methods) can be tagged with flags that give some properties of the code to be executed as in the following sections.\hypertarget{code_flags_NOOP}{}\doxysection{NOOP}\label{code_flags_NOOP}
Code with this flag makes no calculations, but rather returns a constant value. This flag is given to function and method variants that return a default value depending on the type of argument(s). When variants with this flag are resolved at parse time, a \mbox{\hyperlink{warnings_call-with-type-errors}{call-\/with-\/type-\/errors}} warning is raised (assuming this warning is enabled).\hypertarget{code_flags_RUNTIME_NOOP}{}\doxysection{RUNTIME\+\_\+\+NOOP}\label{code_flags_RUNTIME_NOOP}
Code with this flag makes no calculations, but rather returns a constant value. This flag is given to function and method variants that return a default value depending on the type of argument(s). When variants with this flag are resolved at parse time, a \mbox{\hyperlink{warnings_call-with-type-errors}{call-\/with-\/type-\/errors}} warning is raised (assuming this warning is enabled), unless \mbox{\hyperlink{group__parse__options_ga66847391bb96dac88c3fee210720bbb3}{Qore\+::\+PO\+\_\+\+REQUIRE\+\_\+\+TYPES}} or \mbox{\hyperlink{group__parse__options_gac7875c0c85a64fa8b0d66fc634734957}{Qore\+::\+PO\+\_\+\+STRICT\+\_\+\+ARGS}} is set. If either \mbox{\hyperlink{group__parse__options_ga66847391bb96dac88c3fee210720bbb3}{Qore\+::\+PO\+\_\+\+REQUIRE\+\_\+\+TYPES}} or \mbox{\hyperlink{group__parse__options_gac7875c0c85a64fa8b0d66fc634734957}{Qore\+::\+PO\+\_\+\+STRICT\+\_\+\+ARGS}} is set, then these variants are inaccessible; resolving to a variant with this flag set at parse time or run time causes an exception to be thrown. These variants are included for backwards-\/compatibility with qore prior to version 0.\+8.\+0 for functions that would ignore type errors in arguments.\hypertarget{code_flags_CONSTANT}{}\doxysection{CONSTANT}\label{code_flags_CONSTANT}
This flag indicates that the function or method has no side effects and does not throw any exceptions (see also \mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}).\hypertarget{code_flags_RET_VALUE_ONLY}{}\doxysection{RET\+\_\+\+VALUE\+\_\+\+ONLY}\label{code_flags_RET_VALUE_ONLY}
This flag indicates that the function or method has no side effects but could throw an exception (see also \mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}).\hypertarget{code_flags_DEPRECATED}{}\doxysection{DEPRECATED}\label{code_flags_DEPRECATED}
Code with this flag is deprecated and may be removed in a future version of Qore; if a variant with this flag is resolved at parse time, a \mbox{\hyperlink{deprecated}{Deprecated List}} warning is raised (assuming this warning is enabled). 