\hypertarget{class_qore_1_1zzz8intzzz9}{}\doxysection{Qore\+::zzz8intzzz9 Class Reference}
\label{class_qore_1_1zzz8intzzz9}\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}}


Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{basic_data_types_integer}{integer values}}.  




Inheritance diagram for Qore\+::zzz8intzzz9\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a2853596aba431a8e4ad3e3e7e2417c37}{abs}} ()
\begin{DoxyCompactList}\small\item\em Returns the absolute value of the number. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a97747fdeeebc700bdf6c101f34d59d82}{encode\+Lsb}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9_a794caed9de093e89d88bfbe652e15a06}{size}}=4)
\begin{DoxyCompactList}\small\item\em returns a binary object with the integer encoded in the given number of bytes in least significant byte order \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a5b9876a1b6173efa7ae157ce1680871a}{encode\+Msb}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9_a794caed9de093e89d88bfbe652e15a06}{size}}=4)
\begin{DoxyCompactList}\small\item\em returns a binary object with the integer encoded in the given number of bytes in most significant byte order \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a4f4b203fef4e2ae785f838c98e5995be}{format}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} fmt)
\begin{DoxyCompactList}\small\item\em Returns a formatted string of the integer according to the format argument. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a52e3a4df1cf57a32686d651666a9643a}{format}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} prec=2, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} decimal\+\_\+sep=\char`\"{}.\char`\"{}, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} thousands\+\_\+sep=\char`\"{}\char`\"{})
\begin{DoxyCompactList}\small\item\em Returns a formatted string of the integer according to format arguments. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a48f2332ed8aba090985de5fee9375d65}{intp}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} by default. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_aa7540bc9c4c5e8b3ba79e853c462c863}{sign}} ()
\begin{DoxyCompactList}\small\item\em Returns -\/1 if the number is negative, 0 if it is zero, or 1 if it is positive. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_ab20434aada8c94c84fa4fcd9c84e330a}{strp}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} because integer values can be converted to strings. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a1a7c8f41ba26bec22c1a0f485d90a48a}{to\+Base}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} base=10)
\begin{DoxyCompactList}\small\item\em Converts the integer to a different {\bfseries{base}} (and returns it as a string). \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_ac442a991ff2423860f44768b9e961918}{to\+Unicode}} ()
\begin{DoxyCompactList}\small\item\em Returns a single character string in UTF-\/8 encoding for the integer value treated as a unicode value. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a3bd4fe812c0232129fed669206bbcf58}{type\+Code}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{group__type__code__constants_ga38fbe0c5cf4d846a91edea6486bdd5c2}{Qore\+::\+NT\+\_\+\+INT}}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_af1c9f6e10349f73724b4d2c5d31b1136}{val}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the int is non-\/zero, \mbox{\hyperlink{basic_data_types_False}{False}} if zero. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{basic_data_types_integer}{integer values}}. 

\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_a2853596aba431a8e4ad3e3e7e2417c37}\label{class_qore_1_1zzz8intzzz9_a2853596aba431a8e4ad3e3e7e2417c37}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!abs@{abs}}
\index{abs@{abs}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{abs()}{abs()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8intzzz9\+::abs (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the absolute value of the number. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{i = i.abs();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the absolute value of the number
\end{DoxyReturn}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__math__functions_ga38089899d2c160b300a0ae1864d62420}{abs(int)}}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_a97747fdeeebc700bdf6c101f34d59d82}\label{class_qore_1_1zzz8intzzz9_a97747fdeeebc700bdf6c101f34d59d82}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!encodeLsb@{encodeLsb}}
\index{encodeLsb@{encodeLsb}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{encodeLsb()}{encodeLsb()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} Qore\+::zzz8intzzz9\+::encode\+Lsb (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{size = {\ttfamily 4} }\end{DoxyParamCaption})}



returns a binary object with the integer encoded in the given number of bytes in least significant byte order 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{b += i.encodeLsb(8);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em size} & the size of the encoded binary object; must be 1, 2, 4, or 8 or a SIZE-\/\+ERROR exception is raised\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a binary object with the integer encoded in the given number of bytes in least significant byte order
\end{DoxyReturn}

\begin{DoxyExceptions}{Exceptions}
{\em SIZE-\/\+ERROR} & the argument is not 1, 2, 4, or 8 or the argument cannot fit in the number of bytes requested\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_a5b9876a1b6173efa7ae157ce1680871a}\label{class_qore_1_1zzz8intzzz9_a5b9876a1b6173efa7ae157ce1680871a}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!encodeMsb@{encodeMsb}}
\index{encodeMsb@{encodeMsb}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{encodeMsb()}{encodeMsb()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} Qore\+::zzz8intzzz9\+::encode\+Msb (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{size = {\ttfamily 4} }\end{DoxyParamCaption})}



returns a binary object with the integer encoded in the given number of bytes in most significant byte order 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{b += i.encodeMsb(8);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em size} & the size of the encoded binary object; must be 1, 2, 4, or 8 or a SIZE-\/\+ERROR exception is raised\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a binary object with the integer encoded in the given number of bytes in most significant byte order
\end{DoxyReturn}

\begin{DoxyExceptions}{Exceptions}
{\em SIZE-\/\+ERROR} & the argument is not 1, 2, 4, or 8 or the argument cannot fit in the number of bytes requested\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_a52e3a4df1cf57a32686d651666a9643a}\label{class_qore_1_1zzz8intzzz9_a52e3a4df1cf57a32686d651666a9643a}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!format@{format}}
\index{format@{format}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{format()}{format()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8intzzz9\+::format (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{prec = {\ttfamily 2},  }\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{decimal\+\_\+sep = {\ttfamily \char`\"{}.\char`\"{}},  }\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{thousands\+\_\+sep = {\ttfamily \char`\"{}\char`\"{}} }\end{DoxyParamCaption})}



Returns a formatted string of the integer according to format arguments. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em prec} & the number of digits after the decimal point; a negative value means to round that number of digits before the decimal place, note that a positive value here will result in the given number of zeros appearing after the decimal place \\
\hline
{\em decimal\+\_\+sep} & a single character that defines the decimal separator; an empty string means no decimal separator \\
\hline
{\em thousands\+\_\+sep} & a single character that defines the thousands and further separators every three digits before the decimal point; an empty string means no thousands separator\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a string representing the integer according to the format arguments as described above
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int i = -\/48392093894;}
\DoxyCodeLine{string nstr = i.format(3, \textcolor{stringliteral}{"{},"{}}, \textcolor{stringliteral}{"{}."{}}); \textcolor{comment}{\# returns "{}-\/48.392.093.894,000"{}}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a31013414002c3808718a217d8d488f7b}{Qore\+::zzz8numberzzz9\+::format(int, string, string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a0a1ed20b3cbe9a7d99681b2ee1b4802b}{Qore\+::zzz8floatzzz9\+::format(int, string, string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_acdcee3a4130b680892d915f3956f8199}{Qore\+::zzz8numberzzz9\+::format(string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a456f92c6ee27c0c772223745f918bcbc}{Qore\+::zzz8floatzzz9\+::format(string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a4f4b203fef4e2ae785f838c98e5995be}{Qore\+::zzz8intzzz9\+::format(string)}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_a4f4b203fef4e2ae785f838c98e5995be}\label{class_qore_1_1zzz8intzzz9_a4f4b203fef4e2ae785f838c98e5995be}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!format@{format}}
\index{format@{format}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{format()}{format()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8intzzz9\+::format (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{fmt }\end{DoxyParamCaption})}



Returns a formatted string of the integer according to the format argument. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em fmt} & the format string has the following format\+:~\newline
 {\itshape $<$thousands\+\_\+separator$>$}{\ttfamily \mbox{[}}{\itshape $<$decimal\+\_\+separator$>$\mbox{[}$<$decimals$>$\mbox{]}}{\ttfamily \mbox{]}}~\newline
 where\+:~\newline

\begin{DoxyItemize}
\item {\itshape thousands\+\_\+separator} and {\itshape decimal\+\_\+separator} are single characters defining the thousands and decimal separator characters respectively, and
\item {\itshape decimals} is one or more digits defining how may decimals should appear after the decimal point -\/ if this is non-\/zero then the decimals will all be {\ttfamily \char`\"{}0\char`\"{}}; a negative number means to round that number of digits before the decimal place
\end{DoxyItemize}\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a string of the integer according to a format string; if the format string does not follow the given format, then the number without formatting is returned
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int i = -\/48392093894;}
\DoxyCodeLine{string nstr = i.format(\textcolor{stringliteral}{"{}.,3"{}}); \textcolor{comment}{\# returns "{}-\/48.392.093.894,000"{}}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a456f92c6ee27c0c772223745f918bcbc}{Qore\+::zzz8floatzzz9\+::format(string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_acdcee3a4130b680892d915f3956f8199}{Qore\+::zzz8numberzzz9\+::format(string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8intzzz9_a52e3a4df1cf57a32686d651666a9643a}{Qore\+::zzz8intzzz9\+::format(int, string, string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a0a1ed20b3cbe9a7d99681b2ee1b4802b}{Qore\+::zzz8floatzzz9\+::format(int, string, string)}}
\item \mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_a31013414002c3808718a217d8d488f7b}{Qore\+::zzz8numberzzz9\+::format(int, string, string)}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_a48f2332ed8aba090985de5fee9375d65}\label{class_qore_1_1zzz8intzzz9_a48f2332ed8aba090985de5fee9375d65}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!intp@{intp}}
\index{intp@{intp}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{intp()}{intp()}}
{\footnotesize\ttfamily bool Qore\+::zzz8intzzz9\+::intp (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} by default. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} by default
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (n.intp())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: can be converted to an integer: \%d\(\backslash\)n"{}}, n, \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}(n));}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_aa7540bc9c4c5e8b3ba79e853c462c863}\label{class_qore_1_1zzz8intzzz9_aa7540bc9c4c5e8b3ba79e853c462c863}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!sign@{sign}}
\index{sign@{sign}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{sign()}{sign()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8intzzz9\+::sign (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns -\/1 if the number is negative, 0 if it is zero, or 1 if it is positive. 

\begin{DoxyReturn}{Returns}
-\/1 if the number is negative, 0 if it is zero, or 1 if it is positive
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}sign: \%d\(\backslash\)n"{}}, i.sign());}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_ab20434aada8c94c84fa4fcd9c84e330a}\label{class_qore_1_1zzz8intzzz9_ab20434aada8c94c84fa4fcd9c84e330a}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!strp@{strp}}
\index{strp@{strp}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{strp()}{strp()}}
{\footnotesize\ttfamily bool Qore\+::zzz8intzzz9\+::strp (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} because integer values can be converted to strings. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} because integer values can be converted to strings
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (n.strp())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: can be converted to a string: '\%s'\(\backslash\)n"{}}, n, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}(n));}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_a1a7c8f41ba26bec22c1a0f485d90a48a}\label{class_qore_1_1zzz8intzzz9_a1a7c8f41ba26bec22c1a0f485d90a48a}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!toBase@{toBase}}
\index{toBase@{toBase}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{toBase()}{toBase()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8intzzz9\+::to\+Base (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{base = {\ttfamily 10} }\end{DoxyParamCaption})}



Converts the integer to a different {\bfseries{base}} (and returns it as a string). 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em base} & the base to convert the integer to; this value must be 2 -\/ 36 inclusive or an {\ttfamily INVALID-\/\+BASE} exception will be thrown\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the converted value as a string
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{27.toBase(2));       // returns \textcolor{stringliteral}{"{}11011"{}}}
\DoxyCodeLine{033.toBase(2));      // returns \textcolor{stringliteral}{"{}11011"{}}}
\DoxyCodeLine{0x1B.toBase(2));     // returns \textcolor{stringliteral}{"{}11011"{}}}
\DoxyCodeLine{(-\/27).toBase(5));    // returns  \textcolor{stringliteral}{"{}-\/102"{}}}
\DoxyCodeLine{(-\/0x1B).toBase(5));  // returns  \textcolor{stringliteral}{"{}-\/102"{}}}
\DoxyCodeLine{27.toBase(8));       // returns    \textcolor{stringliteral}{"{}33"{}}}
\DoxyCodeLine{033.toBase(8));      // returns    \textcolor{stringliteral}{"{}33"{}}}
\DoxyCodeLine{27.toBase());        // returns    \textcolor{stringliteral}{"{}27"{}}}
\DoxyCodeLine{033.toBase());       // returns    \textcolor{stringliteral}{"{}27"{}}}
\DoxyCodeLine{0x1B.toBase());      // returns    \textcolor{stringliteral}{"{}27"{}}}
\DoxyCodeLine{(-\/27).toBase(13));   // returns   \textcolor{stringliteral}{"{}-\/21"{}}}
\DoxyCodeLine{27.toBase(16));      // returns    \textcolor{stringliteral}{"{}1B"{}}}
\DoxyCodeLine{0x1B.toBase(16));    // returns    \textcolor{stringliteral}{"{}1B"{}}}
\DoxyCodeLine{27.toBase(27));      // returns    \textcolor{stringliteral}{"{}10"{}}}
\DoxyCodeLine{27.toBase(28));      // returns     \textcolor{stringliteral}{"{}R"{}}}
\DoxyCodeLine{(-\/27).toBase(36));   // returns    \textcolor{stringliteral}{"{}-\/R"{}}}
\DoxyCodeLine{35.toBase(36));      // returns     \textcolor{stringliteral}{"{}Z"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em INVALID-\/\+BASE} & the base is invalid; must be 2 -\/ 36 inclusive\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8numberzzz9_ae6d52cb434c6eef372ef064852038f8a}{Qore\+::zzz8numberzzz9\+::to\+Base(int base)}} 

\mbox{\hyperlink{class_qore_1_1zzz8floatzzz9_a138a6d9c7f0c10546c96a875bc29d242}{Qore\+::zzz8floatzzz9\+::to\+Base(int base)}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_ac442a991ff2423860f44768b9e961918}\label{class_qore_1_1zzz8intzzz9_ac442a991ff2423860f44768b9e961918}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!toUnicode@{toUnicode}}
\index{toUnicode@{toUnicode}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{toUnicode()}{toUnicode()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8intzzz9\+::to\+Unicode (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a single character string in UTF-\/8 encoding for the integer value treated as a unicode value. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = 0x00f8.toUnicode()}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a single character string in UTF-\/8 encoding for the integer value treated as a unicode value
\end{DoxyReturn}
\begin{DoxyNote}{Note}
only the least-\/significant 4 bytes of the integer are used
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_a3bd4fe812c0232129fed669206bbcf58}\label{class_qore_1_1zzz8intzzz9_a3bd4fe812c0232129fed669206bbcf58}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!typeCode@{typeCode}}
\index{typeCode@{typeCode}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{typeCode()}{typeCode()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8intzzz9\+::type\+Code (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{group__type__code__constants_ga38fbe0c5cf4d846a91edea6486bdd5c2}{Qore\+::\+NT\+\_\+\+INT}}. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{group__type__code__constants_ga38fbe0c5cf4d846a91edea6486bdd5c2}{Qore\+::\+NT\+\_\+\+INT}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{switch (i.typeCode()) \{}
\DoxyCodeLine{    case NT\_INT:}
\DoxyCodeLine{        \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: is a int\(\backslash\)n"{}}, i);}
\DoxyCodeLine{        \textcolor{keywordflow}{break};}
\DoxyCodeLine{\}}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8intzzz9_af1c9f6e10349f73724b4d2c5d31b1136}\label{class_qore_1_1zzz8intzzz9_af1c9f6e10349f73724b4d2c5d31b1136}} 
\index{$\langle$int$\rangle$@{$\langle$int$\rangle$}!val@{val}}
\index{val@{val}!Qore::<int>@{$\langle$int$\rangle$}}
\doxysubsubsection{\texorpdfstring{val()}{val()}}
{\footnotesize\ttfamily bool Qore\+::zzz8intzzz9\+::val (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the int is non-\/zero, \mbox{\hyperlink{basic_data_types_False}{False}} if zero. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the int is non-\/zero, \mbox{\hyperlink{basic_data_types_False}{False}} if zero
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = i.val();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{parse_directives_perl-bool-eval}{\%perl-\/bool-\/eval}}
\item \mbox{\hyperlink{parse_directives_strict-bool-eval}{\%strict-\/bool-\/eval}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
