\hypertarget{class_qore_1_1zzz8binaryzzz9}{}\doxysection{Qore\+::zzz8binaryzzz9 Class Reference}
\label{class_qore_1_1zzz8binaryzzz9}\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}}


Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{basic_data_types_binary}{binary values}}.  




Inheritance diagram for Qore\+::zzz8binaryzzz9\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a566ff06c85ac36b352896f276b090e8f}{empty}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the binary object is empty (size = 0), \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a4bcd3dd7e317d56d4bb5135a58c47fb1}{find}} (data bin, softint byte\+\_\+pos=0)
\begin{DoxyCompactList}\small\item\em Retrieves the byte position of a sequence of bytes within a binary object. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a689c2d2bacc24aa2e286245269888729}{rfind}} (data bin, softint byte\+\_\+pos=-\/1)
\begin{DoxyCompactList}\small\item\em Retrieves the byte position of a sequence of bytes within a binary object searching from the end of the binary object. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a23f80283f3e64ad3e39ea5c51b7aec3e}{size}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of bytes in the binary object. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a8f51d2fc8bf3252af1c72a4d03e81c4f}{sizep}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} since binary objects can return a non-\/zero size. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} $>$ \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a7b9095703570b4cbbd90496367f47286}{split}} (data sep)
\begin{DoxyCompactList}\small\item\em Returns a list of binary objects representing each component of the binary object separated by the bytes identified by the separator argument, with the separator removed. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a5b99353f309cc3cdfd0fe7227d99eee5}{substr}} (softint start)
\begin{DoxyCompactList}\small\item\em Returns a portion of the binary data starting from an integer offset. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a87459df5b2a455d190644ae47a468791}{substr}} (softint start, softint len)
\begin{DoxyCompactList}\small\item\em Returns a portion of the binary data starting from an integer offset. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_ab30735fae927ea3be3e3a710574ff486}{to\+Base64}} (softint maxlinelen=-\/1)
\begin{DoxyCompactList}\small\item\em Returns the base64-\/encoded representation of the binary object. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_ada0665f689a4787b2697c1ff399b7cac}{to\+Hex}} ()
\begin{DoxyCompactList}\small\item\em returns a string of hexadecimal digits corresponding to the contents of the binary object; hex characters are always in lower case \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a9eff25da172a81558e0bfab828bf9919}{to\+MD5}} ()
\begin{DoxyCompactList}\small\item\em Returns the \href{http://en.wikipedia.org/wiki/MD5}{\texttt{ MD5 message digest}} of the binary data as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a3f9afb50f2f621c133f11330432561d6}{to\+SHA1}} ()
\begin{DoxyCompactList}\small\item\em Returns the \href{http://en.wikipedia.org/wiki/SHA-1}{\texttt{ SHA1}} message digest of the binary data as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a40a67a7f4d31d72c67f65a71f98e9618}{to\+SHA224}} ()
\begin{DoxyCompactList}\small\item\em Returns the SHA-\/224 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the binary data as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a3fad715400f0b1901a24e727b887d169}{to\+SHA256}} ()
\begin{DoxyCompactList}\small\item\em Returns the SHA-\/256 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the binary data as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a7fa8629838806509270b0a5d48415611}{to\+SHA384}} ()
\begin{DoxyCompactList}\small\item\em Returns the SHA-\/384 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the binary data as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_ab3a42f1beda2facfdbd32f465d9b8fe3}{to\+SHA512}} ()
\begin{DoxyCompactList}\small\item\em Returns the SHA-\/512 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the binary data as a hex string. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a06e153b81c1e46d58dc886b0e6183fc8}{to\+String}} (\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} encoding)
\begin{DoxyCompactList}\small\item\em Returns a string created from the binary data, taking an optional second argument giving the string encoding; if no second argument is passed then the \mbox{\hyperlink{character_encoding_default_encoding}{default character encoding}} is assumed. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a0e1c6cd63c6dfab74ff85b53a462b4ec}{type\+Code}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{group__type__code__constants_ga71eb237451170acbe0e778711f73c462}{Qore\+::\+NT\+\_\+\+BINARY}}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a7c76d2d0c0f1c731a80db3b3d8253cbd}{val}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_False}{False}} if the binary object is empty (size = 0), \mbox{\hyperlink{basic_data_types_True}{True}} if not. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
Methods in this pseudo-\/class can be executed on \mbox{\hyperlink{basic_data_types_binary}{binary values}}. 

\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a566ff06c85ac36b352896f276b090e8f}\label{class_qore_1_1zzz8binaryzzz9_a566ff06c85ac36b352896f276b090e8f}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!empty@{empty}}
\index{empty@{empty}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{empty()}{empty()}}
{\footnotesize\ttfamily bool Qore\+::zzz8binaryzzz9\+::empty (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the binary object is empty (size = 0), \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

The opposite of \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a7c76d2d0c0f1c731a80db3b3d8253cbd}{Qore\+::zzz8binaryzzz9\+::val()}}

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the binary object is empty (size = 0), \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = bin.empty();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a4bcd3dd7e317d56d4bb5135a58c47fb1}\label{class_qore_1_1zzz8binaryzzz9_a4bcd3dd7e317d56d4bb5135a58c47fb1}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!find@{find}}
\index{find@{find}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{find()}{find()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8binaryzzz9\+::find (\begin{DoxyParamCaption}\item[{data}]{bin,  }\item[{softint}]{byte\+\_\+pos = {\ttfamily 0} }\end{DoxyParamCaption})}



Retrieves the byte position of a sequence of bytes within a binary object. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int i = bin.find(bin2);}
\DoxyCodeLine{\textcolor{keywordflow}{if} (i == -\/1) \{}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}could not find \%y in \%y\(\backslash\)n"{}}, bin2, bin);}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em bin} & the byte sequence to find in the binary object \\
\hline
{\em byte\+\_\+pos} & the starting byte position for the search; if negative, then specifies an offset from the end of the current binary object\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the byte position of a sequence of bytes within a binary object, -\/1 is returned if the byte sequence is not found or if {\itshape byte\+\_\+pos} specifies a position beyond the end of the string
\end{DoxyReturn}
\begin{DoxyNote}{Note}
an empty {\itshape bin} argument always matches
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a689c2d2bacc24aa2e286245269888729}{Qore\+::zzz8binaryzzz9\+::rfind(data, softint)}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+9.\+1 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a689c2d2bacc24aa2e286245269888729}\label{class_qore_1_1zzz8binaryzzz9_a689c2d2bacc24aa2e286245269888729}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!rfind@{rfind}}
\index{rfind@{rfind}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{rfind()}{rfind()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8binaryzzz9\+::rfind (\begin{DoxyParamCaption}\item[{data}]{bin,  }\item[{softint}]{byte\+\_\+pos = {\ttfamily -\/1} }\end{DoxyParamCaption})}



Retrieves the byte position of a sequence of bytes within a binary object searching from the end of the binary object. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int i = bin.rfind(bin2);}
\DoxyCodeLine{\textcolor{keywordflow}{if} (i == -\/1) \{}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}could not find \%y in \%y\(\backslash\)n"{}}, bin2, bin);}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em bin} & the byte sequence to find in the binary object \\
\hline
{\em byte\+\_\+pos} & the starting byte position for the search; if negative, then specifies an offset from the end of the current binary object; if {\itshape byte\+\_\+pos} specifies a position beyond the end of the string, then the search starts from the end of the string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the byte position of a sequence of bytes within a binary object, -\/1 is returned if the byte sequence is not found
\end{DoxyReturn}
\begin{DoxyNote}{Note}
an empty {\itshape bin} argument always matches
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a4bcd3dd7e317d56d4bb5135a58c47fb1}{Qore\+::zzz8binaryzzz9\+::find(data, softint)}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+9.\+1 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a23f80283f3e64ad3e39ea5c51b7aec3e}\label{class_qore_1_1zzz8binaryzzz9_a23f80283f3e64ad3e39ea5c51b7aec3e}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!size@{size}}
\index{size@{size}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{size()}{size()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8binaryzzz9\+::size (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of bytes in the binary object. 

\begin{DoxyReturn}{Returns}
the number of bytes in the binary object
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int len = b.size();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a8f51d2fc8bf3252af1c72a4d03e81c4f}{Qore\+::zzz8binaryzzz9\+::sizep()}} 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a8f51d2fc8bf3252af1c72a4d03e81c4f}\label{class_qore_1_1zzz8binaryzzz9_a8f51d2fc8bf3252af1c72a4d03e81c4f}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!sizep@{sizep}}
\index{sizep@{sizep}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{sizep()}{sizep()}}
{\footnotesize\ttfamily bool Qore\+::zzz8binaryzzz9\+::sizep (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} since binary objects can return a non-\/zero size. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} since binary objects can return a non-\/zero size
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a23f80283f3e64ad3e39ea5c51b7aec3e}{Qore\+::zzz8binaryzzz9\+::size()}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a7b9095703570b4cbbd90496367f47286}\label{class_qore_1_1zzz8binaryzzz9_a7b9095703570b4cbbd90496367f47286}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!split@{split}}
\index{split@{split}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{split()}{split()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}$>$ Qore\+::zzz8binaryzzz9\+::split (\begin{DoxyParamCaption}\item[{data}]{sep }\end{DoxyParamCaption})}



Returns a list of binary objects representing each component of the binary object separated by the bytes identified by the separator argument, with the separator removed. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em sep} & the bytes that separate the fields\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a list of binary objects representing each component of the binary object separated by the bytes identified by the separator argument, with the separator removed
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{list<binary> l = bin.split(sep);}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_ga2230070c2f14ca70e63cf463f5d688c3}{split(data, binary)}}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a5b99353f309cc3cdfd0fe7227d99eee5}\label{class_qore_1_1zzz8binaryzzz9_a5b99353f309cc3cdfd0fe7227d99eee5}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!substr@{substr}}
\index{substr@{substr}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{substr()}{substr()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} Qore\+::zzz8binaryzzz9\+::substr (\begin{DoxyParamCaption}\item[{softint}]{start }\end{DoxyParamCaption})}



Returns a portion of the binary data starting from an integer offset. 

Arguments can be negative, giving offsets from the end of the data.

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em start} & The starting byte for the portion of the data where the first byte is at offset 0; if the offset is negative, it designates the number of bytes from the end of the data\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the portion of the data starting from an integer bte offset; the rest of the data is returned after this offset
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# get the last 10 bytes of a binary object}}
\DoxyCodeLine{binary b1 = b0.substr(-\/10);}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_ga8b90bec06c9dabd6d54fff51684f9da6}{Qore\+::substr(binary, softint)}}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a87459df5b2a455d190644ae47a468791}\label{class_qore_1_1zzz8binaryzzz9_a87459df5b2a455d190644ae47a468791}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!substr@{substr}}
\index{substr@{substr}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{substr()}{substr()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} Qore\+::zzz8binaryzzz9\+::substr (\begin{DoxyParamCaption}\item[{softint}]{start,  }\item[{softint}]{len }\end{DoxyParamCaption})}



Returns a portion of the binary data starting from an integer offset. 

Arguments can be negative, giving offsets from the end of the data.

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em start} & The starting byte for the portion of the data where the first byte is at offset 0; if the offset is negative, it designates the number of bytes from the end of the data \\
\hline
{\em len} & The maximum number of characters to copy; if this value is negative, the rest of the string from {\itshape start} will be copied to the substring, except without -\/ {\itshape len} characters from the end of the string\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the portion of the data starting from an integer bte offset; the rest of the data is returned after this offset
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# get the last 5 bytes of the last 10 bytes of a binary object}}
\DoxyCodeLine{binary b1 = b0.substr(-\/10, 5);}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__string__functions_gaf00ab0e1f2c880e0da287c102aca9873}{Qore\+::substr(binary, softint, softint)}}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_ab30735fae927ea3be3e3a710574ff486}\label{class_qore_1_1zzz8binaryzzz9_ab30735fae927ea3be3e3a710574ff486}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!toBase64@{toBase64}}
\index{toBase64@{toBase64}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{toBase64()}{toBase64()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8binaryzzz9\+::to\+Base64 (\begin{DoxyParamCaption}\item[{softint}]{maxlinelen = {\ttfamily -\/1} }\end{DoxyParamCaption})}



Returns the base64-\/encoded representation of the binary object. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string base64 = bin.toBase64(64);}

\end{DoxyCode}

\end{DoxyParagraph}
Implementation based on \href{http://www.ietf.org/rfc/rfc1421.txt}{\texttt{ RFC-\/1421}} and \href{http://www.ietf.org/rfc/rfc2045.txt}{\texttt{ RFC-\/2045}}


\begin{DoxyParams}{Parameters}
{\em maxlinelen} & the maximum length of a line in the resulting output string in bytes; if this value is $>$ 0 then output lines will be separated by CRLF characters\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the base64-\/encoded string of the data passed
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8
\end{DoxySince}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a13b13f9681a94272d0e16371d2f22d90}{Qore\+::zzz8stringzzz9\+::to\+Base64()}}
\item \mbox{\hyperlink{group__misc__functions_gaba5bd6118895a5f84c03c6a82968a37f}{make\+\_\+base64\+\_\+string(binary, softint)}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_ada0665f689a4787b2697c1ff399b7cac}\label{class_qore_1_1zzz8binaryzzz9_ada0665f689a4787b2697c1ff399b7cac}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!toHex@{toHex}}
\index{toHex@{toHex}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{toHex()}{toHex()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8binaryzzz9\+::to\+Hex (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



returns a string of hexadecimal digits corresponding to the contents of the binary object; hex characters are always in lower case 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = b.toHex();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a string of hexadecimal digits corresponding to the contents of the binary object; hex characters are always in lower case
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8
\end{DoxySince}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_af4a4f62237f079383098441132967527}{Qore\+::zzz8stringzzz9\+::to\+Hex()}}
\item \mbox{\hyperlink{group__misc__functions_gabc590f8b24ce809f2e5caa7b3ab7ed19}{Qore\+::make\+\_\+hex\+\_\+string(binary)}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a9eff25da172a81558e0bfab828bf9919}\label{class_qore_1_1zzz8binaryzzz9_a9eff25da172a81558e0bfab828bf9919}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!toMD5@{toMD5}}
\index{toMD5@{toMD5}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{toMD5()}{toMD5()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8binaryzzz9\+::to\+MD5 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the \href{http://en.wikipedia.org/wiki/MD5}{\texttt{ MD5 message digest}} of the binary data as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}5d41402abc4b2a76b9719d911017c592\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}(\textcolor{stringliteral}{"{}hello"{}}).toMD5(); \textcolor{comment}{\# returns "{}5d41402abc4b2a76b9719d911017c592"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em MD5-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item equivalent to \mbox{\hyperlink{group__digest__functions_ga78c973088de21a5aae0cd8c68fc3447c}{MD5()}}
\item the MD5 algorithm is not collision-\/resistant; it\textquotesingle{}s recommended to use another hash algorithm (like SHA-\/256) if cryptographic security is important
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_gafea2cdf61fc831e245ba21f9d8397a23}{MD5\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a2c63e2b65aafebf67928b88651d4cd39}{Qore\+::zzz8stringzzz9\+::to\+MD5()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a3f9afb50f2f621c133f11330432561d6}\label{class_qore_1_1zzz8binaryzzz9_a3f9afb50f2f621c133f11330432561d6}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!toSHA1@{toSHA1}}
\index{toSHA1@{toSHA1}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA1()}{toSHA1()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8binaryzzz9\+::to\+SHA1 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the \href{http://en.wikipedia.org/wiki/SHA-1}{\texttt{ SHA1}} message digest of the binary data as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}(\textcolor{stringliteral}{"{}hello"{}}).toSHA1(); \textcolor{comment}{\# returns "{}aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA1-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_gaa4c0459a185dd677765d7ef073bf32cb}{SHA1()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_ga64b4d9ca4dc8396ad3bf5b6e5fd6ac6b}{SHA1\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a577cc1e9e6cb2f001c36f35a4cff4b74}{Qore\+::zzz8stringzzz9\+::to\+SHA1()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a40a67a7f4d31d72c67f65a71f98e9618}\label{class_qore_1_1zzz8binaryzzz9_a40a67a7f4d31d72c67f65a71f98e9618}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!toSHA224@{toSHA224}}
\index{toSHA224@{toSHA224}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA224()}{toSHA224()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8binaryzzz9\+::to\+SHA224 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the SHA-\/224 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the binary data as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyParagraph}{Platform Availability\+:}
\mbox{\hyperlink{group__option__constants_gac2b845ff7b7e953d0ab2c7c0e33154fe}{Qore\+::\+Option\+::\+HAVE\+\_\+\+SHA224}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}ea09ae9cc6768c50fcee903ed054556e5bfc8347907f12598aa24193\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}(\textcolor{stringliteral}{"{}hello"{}}).toSHA224(\textcolor{stringliteral}{"{}hello"{}}); \textcolor{comment}{\# returns "{}ea09ae9cc6768c50fcee903ed054556e5bfc8347907f12598aa24193"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA224-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_ga31657accc4ffcdf966506bb07bc9a5f5}{SHA224()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_gad78d030a15fd77e92b6acbebf0f01c3b}{SHA224\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a3341bfb07348577260ece5244f958caf}{Qore\+::zzz8stringzzz9\+::to\+SHA224()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a3fad715400f0b1901a24e727b887d169}\label{class_qore_1_1zzz8binaryzzz9_a3fad715400f0b1901a24e727b887d169}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!toSHA256@{toSHA256}}
\index{toSHA256@{toSHA256}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA256()}{toSHA256()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8binaryzzz9\+::to\+SHA256 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the SHA-\/256 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the binary data as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyParagraph}{Platform Availability\+:}
\mbox{\hyperlink{group__option__constants_ga8bbafb0df946db4960ec53f1739352c2}{Qore\+::\+Option\+::\+HAVE\+\_\+\+SHA256}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}(\textcolor{stringliteral}{"{}hello"{}}).toSHA256(); \textcolor{comment}{\# returns "{}2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA256-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_ga2650a6a57142a6c971c583f85c102bef}{SHA256()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_ga3e79a4b0a0fcbc536472144fbcb60fd7}{SHA256\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a11a362bbdba504966590d68bc6839350}{Qore\+::zzz8stringzzz9\+::to\+SHA256()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a7fa8629838806509270b0a5d48415611}\label{class_qore_1_1zzz8binaryzzz9_a7fa8629838806509270b0a5d48415611}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!toSHA384@{toSHA384}}
\index{toSHA384@{toSHA384}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA384()}{toSHA384()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8binaryzzz9\+::to\+SHA384 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the SHA-\/384 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the binary data as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyParagraph}{Platform Availability\+:}
\mbox{\hyperlink{group__option__constants_gaefa59259c4fcbe89eaf1efa5364e0420}{Qore\+::\+Option\+::\+HAVE\+\_\+\+SHA384}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}59e1748777448c69de6b800d7a33bbfb9ff1b463e44354c3553bcdb9c666fa90125a3c79f90397bdf5f6a13de828684f\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}(\textcolor{stringliteral}{"{}hello"{}}).toSHA384(); \textcolor{comment}{\# returns "{}59e1748777448c69de6b800d7a33bbfb9ff1b463e44354c3553bcdb9c666fa90125a3c79f90397bdf5f6a13de828684f"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA384-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_gad1ac64eef1215b1da8be27c2cd3554d8}{SHA384()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_ga46725d7321778042e1acc9fc7e4f0842}{SHA384\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_ae572499e8fe84e24455806ba2556e5c5}{Qore\+::zzz8stringzzz9\+::to\+SHA384()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_ab3a42f1beda2facfdbd32f465d9b8fe3}\label{class_qore_1_1zzz8binaryzzz9_ab3a42f1beda2facfdbd32f465d9b8fe3}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!toSHA512@{toSHA512}}
\index{toSHA512@{toSHA512}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{toSHA512()}{toSHA512()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8binaryzzz9\+::to\+SHA512 (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the SHA-\/512 message digest (a variant of \href{http://en.wikipedia.org/wiki/SHA-2}{\texttt{ SHA-\/2}}) of the binary data as a hex string. 

The trailing null character is not included in the digest returned.

\begin{DoxyParagraph}{Platform Availability\+:}
\mbox{\hyperlink{group__option__constants_ga361d12136d30719ba4861fd892ee022f}{Qore\+::\+Option\+::\+HAVE\+\_\+\+SHA512}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a hex string of the digest (ex\+: {\ttfamily \char`\"{}9b71d224bd62f3785d96d46ad3ea3d73319bfbc2890caadae2dff72519673ca72323c3d99ba5c11d7c7acc6e14b8c5da0c4663475c2e5c3adef46f73bcdec043\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}(\textcolor{stringliteral}{"{}hello"{}}).toSHA512(); \textcolor{comment}{\# returns "{}9b71d224bd62f3785d96d46ad3ea3d73319bfbc2890caadae2dff72519673ca72323c3d99ba5c11d7c7acc6e14b8c5da0c4663475c2e5c3adef46f73bcdec043"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SHA512-\/\+DIGEST-\/\+ERROR} & error calculating digest (should not normally happen)\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{group__digest__functions_ga6f598af6d5f8eecd18e9b8048ca610b3}{SHA512()}}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{group__digest__functions_ga14a7dc1fd6565a0ffa61d2dc943ef3e1}{SHA512\+\_\+bin()}}
\item \mbox{\hyperlink{class_qore_1_1zzz8stringzzz9_a0a8b0fd0c6dc97af23ad50be3125cb4d}{Qore\+::zzz8stringzzz9\+::to\+SHA512()}}
\end{DoxyItemize}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a06e153b81c1e46d58dc886b0e6183fc8}\label{class_qore_1_1zzz8binaryzzz9_a06e153b81c1e46d58dc886b0e6183fc8}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!toString@{toString}}
\index{toString@{toString}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{toString()}{toString()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::zzz8binaryzzz9\+::to\+String (\begin{DoxyParamCaption}\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{encoding }\end{DoxyParamCaption})}



Returns a string created from the binary data, taking an optional second argument giving the string encoding; if no second argument is passed then the \mbox{\hyperlink{character_encoding_default_encoding}{default character encoding}} is assumed. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em encoding} & the character encoding tag for the string return value; if not present, the \mbox{\hyperlink{character_encoding_default_encoding}{default character encoding}} is assumed\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a string created from the binary data passed
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = b.toString(\textcolor{stringliteral}{"{}iso-\/8859-\/1"{}});}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+8 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a0e1c6cd63c6dfab74ff85b53a462b4ec}\label{class_qore_1_1zzz8binaryzzz9_a0e1c6cd63c6dfab74ff85b53a462b4ec}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!typeCode@{typeCode}}
\index{typeCode@{typeCode}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{typeCode()}{typeCode()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::zzz8binaryzzz9\+::type\+Code (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{group__type__code__constants_ga71eb237451170acbe0e778711f73c462}{Qore\+::\+NT\+\_\+\+BINARY}}. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{group__type__code__constants_ga71eb237451170acbe0e778711f73c462}{Qore\+::\+NT\+\_\+\+BINARY}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{switch (b.typeCode()) \{}
\DoxyCodeLine{    case NT\_BINARY:}
\DoxyCodeLine{        \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y: is a binary\(\backslash\)n"{}}, b);}
\DoxyCodeLine{        \textcolor{keywordflow}{break};}
\DoxyCodeLine{\}}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1zzz8binaryzzz9_a7c76d2d0c0f1c731a80db3b3d8253cbd}\label{class_qore_1_1zzz8binaryzzz9_a7c76d2d0c0f1c731a80db3b3d8253cbd}} 
\index{$\langle$binary$\rangle$@{$\langle$binary$\rangle$}!val@{val}}
\index{val@{val}!Qore::<binary>@{$\langle$binary$\rangle$}}
\doxysubsubsection{\texorpdfstring{val()}{val()}}
{\footnotesize\ttfamily bool Qore\+::zzz8binaryzzz9\+::val (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_False}{False}} if the binary object is empty (size = 0), \mbox{\hyperlink{basic_data_types_True}{True}} if not. 

The opposite of \mbox{\hyperlink{class_qore_1_1zzz8binaryzzz9_a566ff06c85ac36b352896f276b090e8f}{Qore\+::zzz8binaryzzz9\+::empty()}}

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_False}{False}} if the binary object is empty (size = 0), \mbox{\hyperlink{basic_data_types_True}{True}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = bin.val();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}

\begin{DoxyItemize}
\item \mbox{\hyperlink{parse_directives_perl-bool-eval}{\%perl-\/bool-\/eval}}
\item \mbox{\hyperlink{parse_directives_strict-bool-eval}{\%strict-\/bool-\/eval}} 
\end{DoxyItemize}
\end{DoxySeeAlso}
