\hypertarget{class_qore_1_1_tree_map}{}\doxysection{Qore\+::Tree\+Map Class Reference}
\label{class_qore_1_1_tree_map}\index{Qore::TreeMap@{Qore::TreeMap}}


A container for efficient path prefix lookup.  


\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_tree_map_a0be7e053d2e93d2f5c7dc2cce99a8ab7}{constructor}} ()
\begin{DoxyCompactList}\small\item\em Creates an empty \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} container. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_tree_map_aee07bf11ee6e9f95865a4264cb67ee6d}{copy}} ()
\begin{DoxyCompactList}\small\item\em Throws an exception; objects of this class cannot be copied. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_tree_map_ae57bf0e7907db4c578ae0d3c615cc259}{destructor}} ()
\begin{DoxyCompactList}\small\item\em Releases any resource held by the instance. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_tree_map_a53a50c34b01c6a0a4829f58243191175}{get}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} path, \+\_\+\+\_\+7\+\_\+ reference$<$ $\ast$\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} $>$ unmatched)
\begin{DoxyCompactList}\small\item\em Retrieves a value from the \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} and optionally returns the unmatched path suffix. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}} \mbox{\hyperlink{class_qore_1_1_tree_map_a254ba2807413529e2a7974ee113036d1}{get\+All}} ()
\begin{DoxyCompactList}\small\item\em Retrieves the entire \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} as a hash; returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} is empty. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_tree_map_a4bfaf979430e7cac9c265101f0d057dd}{put}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} path, auto value)
\begin{DoxyCompactList}\small\item\em Puts the mapping of {\ttfamily path} to {\ttfamily value} into the container. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_tree_map_af94e92646d416bb71b2c294d8f3a7ccd}{take}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} path)
\begin{DoxyCompactList}\small\item\em Removes a value from the \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} and returns the value removed. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
A container for efficient path prefix lookup. 

The primary use of this class is in Http\+Server for matching request URIs to handlers.

Example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{TreeMap tm();}
\DoxyCodeLine{}
\DoxyCodeLine{tm.put(\textcolor{stringliteral}{"{}path/to/resource"{}}, handler1);}
\DoxyCodeLine{tm.put(\textcolor{stringliteral}{"{}scripts"{}}, handler2);}
\DoxyCodeLine{tm.put(\textcolor{stringliteral}{"{}scripts/special"{}}, handler3);}
\DoxyCodeLine{}
\DoxyCodeLine{tm.get(\textcolor{stringliteral}{"{}path/to/resource/x"{}});           \textcolor{comment}{\# returns handler1}}
\DoxyCodeLine{tm.get(\textcolor{stringliteral}{"{}path/to/resource?arg=1"{}});       \textcolor{comment}{\# returns handler1}}
\DoxyCodeLine{tm.get(\textcolor{stringliteral}{"{}path/to/res"{}});                  \textcolor{comment}{\# returns NOTHING}}
\DoxyCodeLine{tm.get(\textcolor{stringliteral}{"{}path/to/resourcex"{}});            \textcolor{comment}{\# returns NOTHING}}
\DoxyCodeLine{tm.get(\textcolor{stringliteral}{"{}path"{}});                         \textcolor{comment}{\# returns NOTHING}}
\DoxyCodeLine{}
\DoxyCodeLine{tm.get(\textcolor{stringliteral}{"{}scripts/special/main.js"{}});      \textcolor{comment}{\# returns handler3}}
\DoxyCodeLine{tm.get(\textcolor{stringliteral}{"{}scripts/normal/main.js"{}});       \textcolor{comment}{\# returns handler2}}

\end{DoxyCode}
 

\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_tree_map_a0be7e053d2e93d2f5c7dc2cce99a8ab7}\label{class_qore_1_1_tree_map_a0be7e053d2e93d2f5c7dc2cce99a8ab7}} 
\index{Qore::TreeMap@{Qore::TreeMap}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::TreeMap@{Qore::TreeMap}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Tree\+Map\+::constructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Creates an empty \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} container. 

Creates an empty \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} container. \mbox{\Hypertarget{class_qore_1_1_tree_map_aee07bf11ee6e9f95865a4264cb67ee6d}\label{class_qore_1_1_tree_map_aee07bf11ee6e9f95865a4264cb67ee6d}} 
\index{Qore::TreeMap@{Qore::TreeMap}!copy@{copy}}
\index{copy@{copy}!Qore::TreeMap@{Qore::TreeMap}}
\doxysubsubsection{\texorpdfstring{copy()}{copy()}}
{\footnotesize\ttfamily Qore\+::\+Tree\+Map\+::copy (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Throws an exception; objects of this class cannot be copied. 


\begin{DoxyExceptions}{Exceptions}
{\em TREEMAP-\/\+COPY-\/\+ERROR} & objects of this class cannot be copied \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_tree_map_ae57bf0e7907db4c578ae0d3c615cc259}\label{class_qore_1_1_tree_map_ae57bf0e7907db4c578ae0d3c615cc259}} 
\index{Qore::TreeMap@{Qore::TreeMap}!destructor@{destructor}}
\index{destructor@{destructor}!Qore::TreeMap@{Qore::TreeMap}}
\doxysubsubsection{\texorpdfstring{destructor()}{destructor()}}
{\footnotesize\ttfamily Qore\+::\+Tree\+Map\+::destructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Releases any resource held by the instance. 

Releases any resource held by the instance. \mbox{\Hypertarget{class_qore_1_1_tree_map_a53a50c34b01c6a0a4829f58243191175}\label{class_qore_1_1_tree_map_a53a50c34b01c6a0a4829f58243191175}} 
\index{Qore::TreeMap@{Qore::TreeMap}!get@{get}}
\index{get@{get}!Qore::TreeMap@{Qore::TreeMap}}
\doxysubsubsection{\texorpdfstring{get()}{get()}}
{\footnotesize\ttfamily auto Qore\+::\+Tree\+Map\+::get (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{path,  }\item[{\+\_\+\+\_\+7\+\_\+ reference$<$ $\ast$\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} $>$}]{unmatched }\end{DoxyParamCaption})}



Retrieves a value from the \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} and optionally returns the unmatched path suffix. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{TreeMap tm();}
\DoxyCodeLine{tm.put(\textcolor{stringliteral}{"{}abc"{}}, \textcolor{stringliteral}{"{}1"{}});}
\DoxyCodeLine{tm.put(\textcolor{stringliteral}{"{}def/g/hi"{}}, \textcolor{stringliteral}{"{}5"{}});}
\DoxyCodeLine{}
\DoxyCodeLine{auto v;}
\DoxyCodeLine{*string unmatched;}
\DoxyCodeLine{\textcolor{comment}{\# returns "{}1"{}}}
\DoxyCodeLine{v = tm.get(\textcolor{stringliteral}{"{}abc"{}});}
\DoxyCodeLine{\textcolor{comment}{\# returns "{}1"{} and unmatched is "{}"{}}}
\DoxyCodeLine{v = tm.get(\textcolor{stringliteral}{"{}abc"{}}, \(\backslash\)unmatched);}
\DoxyCodeLine{\textcolor{comment}{\# returns "{}1"{} and unmatched is "{}cde/"{}}}
\DoxyCodeLine{v = tm.get(\textcolor{stringliteral}{"{}abc/cde/"{}}, \(\backslash\)unmatched);}
\DoxyCodeLine{*hash h;}
\DoxyCodeLine{v = tm.get(\textcolor{stringliteral}{"{}def/g/hi/five"{}}, \(\backslash\)h.unmatched);  \textcolor{comment}{\# returns "{}5"{} and h.unmatched is "{}five"{}}}

\end{DoxyCode}

\end{DoxyParagraph}
Looks for an entry whose key is the longest prefix of {\ttfamily path}.


\begin{DoxyParams}{Parameters}
{\em path} & the path to lookup \\
\hline
{\em unmatched} & an optional reference to the path suffix; if {\ttfamily path} is not found, then \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} is assigned to the reference\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the value pointed to by the longest prefix of {\ttfamily path} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no such mapping exists
\end{DoxyReturn}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_tree_map_a254ba2807413529e2a7974ee113036d1}\label{class_qore_1_1_tree_map_a254ba2807413529e2a7974ee113036d1}} 
\index{Qore::TreeMap@{Qore::TreeMap}!getAll@{getAll}}
\index{getAll@{getAll}!Qore::TreeMap@{Qore::TreeMap}}
\doxysubsubsection{\texorpdfstring{getAll()}{getAll()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}} Qore\+::\+Tree\+Map\+::get\+All (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Retrieves the entire \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} as a hash; returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} is empty. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the entire \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} as a hash; returns \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if the \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} is empty 
\end{DoxyReturn}
\mbox{\Hypertarget{class_qore_1_1_tree_map_a4bfaf979430e7cac9c265101f0d057dd}\label{class_qore_1_1_tree_map_a4bfaf979430e7cac9c265101f0d057dd}} 
\index{Qore::TreeMap@{Qore::TreeMap}!put@{put}}
\index{put@{put}!Qore::TreeMap@{Qore::TreeMap}}
\doxysubsubsection{\texorpdfstring{put()}{put()}}
{\footnotesize\ttfamily nothing Qore\+::\+Tree\+Map\+::put (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{path,  }\item[{auto}]{value }\end{DoxyParamCaption})}



Puts the mapping of {\ttfamily path} to {\ttfamily value} into the container. 


\begin{DoxyParams}{Parameters}
{\em path} & the path to which {\ttfamily value} will be mapped \\
\hline
{\em value} & the value to put into the \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}}\\
\hline
\end{DoxyParams}
\begin{DoxySeeAlso}{See also}
Tree\+Map\+::remove() 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_tree_map_af94e92646d416bb71b2c294d8f3a7ccd}\label{class_qore_1_1_tree_map_af94e92646d416bb71b2c294d8f3a7ccd}} 
\index{Qore::TreeMap@{Qore::TreeMap}!take@{take}}
\index{take@{take}!Qore::TreeMap@{Qore::TreeMap}}
\doxysubsubsection{\texorpdfstring{take()}{take()}}
{\footnotesize\ttfamily auto Qore\+::\+Tree\+Map\+::take (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{path }\end{DoxyParamCaption})}



Removes a value from the \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} and returns the value removed. 

{\ttfamily path} must be an exact match


\begin{DoxyParams}{Parameters}
{\em path} & the path to remove\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the value removed from the \mbox{\hyperlink{class_qore_1_1_tree_map}{Tree\+Map}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no exact match was found
\end{DoxyReturn}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_tree_map_a4bfaf979430e7cac9c265101f0d057dd}{Tree\+Map\+::put()}} 
\end{DoxySeeAlso}
