\hypertarget{class_qore_1_1_transform_output_stream}{}\doxysection{Qore\+::Transform\+Output\+Stream Class Reference}
\label{class_qore_1_1_transform_output_stream}\index{Qore::TransformOutputStream@{Qore::TransformOutputStream}}


This class implements the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} interface for writing bytes to another \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} while applying a transformation.  




Inheritance diagram for Qore\+::Transform\+Output\+Stream\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
nothing \mbox{\hyperlink{class_qore_1_1_transform_output_stream_a98abc28f6c173a87aa3d17fd69d904c6}{close}} ()
\begin{DoxyCompactList}\small\item\em Flushes any buffered (unwritten) bytes, closes the output stream and releases all resources. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_transform_output_stream_a0f96bdbd04643b84464b3ffa85bf22f0}{constructor}} (\mbox{\hyperlink{class_qore_1_1_output_stream}{Qore\+::\+Output\+Stream}} os, \mbox{\hyperlink{class_qore_1_1_transform}{Qore\+::\+Transform}} t)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_transform_output_stream}{Transform\+Output\+Stream}}. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_transform_output_stream_a76246b46d7e194e43a0e2dcc5161e1ae}{write}} (\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} data)
\begin{DoxyCompactList}\small\item\em Writes bytes to the output stream. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
This class implements the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} interface for writing bytes to another \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} while applying a transformation. 

\begin{DoxyNote}{Note}
stream classes are not designed to be accessed from multiple threads; they have been implemented without locking for fast and efficient use when used from a single thread. For methods that would be unsafe to use in another thread, any use of such methods in threads other than the thread where the constructor was called will cause a {\ttfamily STREAM-\/\+THREAD-\/\+ERROR} to be thrown, unless the stream is handed off to another thread using the \mbox{\hyperlink{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}{Stream\+Base\+::unassign\+Thread()}} method in the thread that currently owns the stream, and the \mbox{\hyperlink{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}{Stream\+Base\+::reassign\+Thread()}} method in the new thread.
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}} for a class that can be used to \mbox{\hyperlink{class_qore_1_1_transform_output_stream_a76246b46d7e194e43a0e2dcc5161e1ae}{write}} various kinds of data to an \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_transform_output_stream_a98abc28f6c173a87aa3d17fd69d904c6}\label{class_qore_1_1_transform_output_stream_a98abc28f6c173a87aa3d17fd69d904c6}} 
\index{Qore::TransformOutputStream@{Qore::TransformOutputStream}!close@{close}}
\index{close@{close}!Qore::TransformOutputStream@{Qore::TransformOutputStream}}
\doxysubsubsection{\texorpdfstring{close()}{close()}}
{\footnotesize\ttfamily nothing Qore\+::\+Transform\+Output\+Stream\+::close (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Flushes any buffered (unwritten) bytes, closes the output stream and releases all resources. 

Any methods called on a closed output stream will throw an exception.


\begin{DoxyExceptions}{Exceptions}
{\em OUTPUT-\/\+STREAM-\/\+CLOSED-\/\+ERROR} & the output stream has already been closed \\
\hline
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object \\
\hline
\end{DoxyExceptions}


Implements \mbox{\hyperlink{class_qore_1_1_output_stream_a2125e17612767b9636554b282638e883}{Qore\+::\+Output\+Stream}}.

\mbox{\Hypertarget{class_qore_1_1_transform_output_stream_a0f96bdbd04643b84464b3ffa85bf22f0}\label{class_qore_1_1_transform_output_stream_a0f96bdbd04643b84464b3ffa85bf22f0}} 
\index{Qore::TransformOutputStream@{Qore::TransformOutputStream}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::TransformOutputStream@{Qore::TransformOutputStream}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Transform\+Output\+Stream\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{class_qore_1_1_output_stream}{Qore\+::\+Output\+Stream}}}]{os,  }\item[{\mbox{\hyperlink{class_qore_1_1_transform}{Qore\+::\+Transform}}}]{t }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_transform_output_stream}{Transform\+Output\+Stream}}. 


\begin{DoxyParams}{Parameters}
{\em os} & the underlying \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} where the transformed data will be written to \\
\hline
{\em t} & the transformation to apply \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_transform_output_stream_a76246b46d7e194e43a0e2dcc5161e1ae}\label{class_qore_1_1_transform_output_stream_a76246b46d7e194e43a0e2dcc5161e1ae}} 
\index{Qore::TransformOutputStream@{Qore::TransformOutputStream}!write@{write}}
\index{write@{write}!Qore::TransformOutputStream@{Qore::TransformOutputStream}}
\doxysubsubsection{\texorpdfstring{write()}{write()}}
{\footnotesize\ttfamily nothing Qore\+::\+Transform\+Output\+Stream\+::write (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}}]{data }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Writes bytes to the output stream. 


\begin{DoxyParams}{Parameters}
{\em data} & the data to write\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em OUTPUT-\/\+STREAM-\/\+CLOSED-\/\+ERROR} & the output stream has already been closed \\
\hline
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object \\
\hline
\end{DoxyExceptions}


Implements \mbox{\hyperlink{class_qore_1_1_output_stream_a9054b0475c4829d10f956d8f6df6f2ac}{Qore\+::\+Output\+Stream}}.

