\hypertarget{class_qore_1_1_time_zone}{}\doxysection{Qore\+::Time\+Zone Class Reference}
\label{class_qore_1_1_time_zone}\index{Qore::TimeZone@{Qore::TimeZone}}


The \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} class provides access to time zone functionality.  




Inheritance diagram for Qore\+::Time\+Zone\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_time_zone_ac82e34e1f7c96d3aa5c0a071981a6f4f}{UTCOffset}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of seconds east of UTC for the zone; negative numbers indicate a zone west of UTC. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_time_zone_ab77972801cee2c9d116a9631dfd631d9}{constructor}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_time_zone_a84317e0b38d8536b73fcf475b28b50a5}{region}})
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object based on the region name (ex\+: {\ttfamily \char`\"{}\+America/\+Chicago\char`\"{}}) \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_time_zone_a836a8bc75f97c8415d402d1153bcf578}{constructor}} (softint seconds\+\_\+east)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object based on the number of seconds east of UTC (3600 = UTC +01) \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_time_zone_ab95aa62b0103ebda872a3c6b8c675ce2}{copy}} ()
\begin{DoxyCompactList}\small\item\em Creates a copy of the \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object. \end{DoxyCompactList}\item 
date \mbox{\hyperlink{class_qore_1_1_time_zone_afa23a3be62dcfc6712c168b3654a7b85}{date}} (softint secs, softint us=0)
\begin{DoxyCompactList}\small\item\em Returns the equivalent date in the time zone of the current object. \end{DoxyCompactList}\item 
date \mbox{\hyperlink{class_qore_1_1_time_zone_af148d835a7a7b8e01bd89f371d4227c7}{date}} (date d)
\begin{DoxyCompactList}\small\item\em Returns the equivalent date in the time zone of the current object. \end{DoxyCompactList}\item 
date \mbox{\hyperlink{class_qore_1_1_time_zone_a177b96464e04cdc717cd6adc51f83371}{date}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} dtstr)
\begin{DoxyCompactList}\small\item\em Returns the equivalent date in the time zone of the current object. \end{DoxyCompactList}\item 
date \mbox{\hyperlink{class_qore_1_1_time_zone_ab22bd3acfbfb1d7b7ce56f54c81897c7}{date}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} dtstr, \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} mask)
\begin{DoxyCompactList}\small\item\em Returns a \mbox{\hyperlink{basic_data_types_date}{date/time}} value in the current \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} corresponding to parsing a string argument according to a \mbox{\hyperlink{group__date__and__time__functions_date_mask}{format mask}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_time_zone_afa23a3be62dcfc6712c168b3654a7b85}{date}} \mbox{\hyperlink{class_qore_1_1_time_zone_a167a5a6a1b242a912ae51cbf1adea307}{date\+Ms}} (softint ms)
\begin{DoxyCompactList}\small\item\em Returns a date in the object\textquotesingle{}s zone based on an offsets in milliseconds from {\ttfamily 1970-\/01-\/01Z}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_time_zone_afa23a3be62dcfc6712c168b3654a7b85}{date}} \mbox{\hyperlink{class_qore_1_1_time_zone_a83f2b2cfdae00c84fd9476523990418f}{date\+Us}} (softint us)
\begin{DoxyCompactList}\small\item\em Returns a date in the object\textquotesingle{}s zone based on an offsets in microseconds from {\ttfamily 1970-\/01-\/01Z}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_time_zone_a9957690d95a39f692ce6860bcb202d45}{has\+DST}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the zone has daylight saving time rules, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_time_zone_a84317e0b38d8536b73fcf475b28b50a5}{region}} ()
\begin{DoxyCompactList}\small\item\em Returns the region name as a string; if the current zone is based on a UTC offset, then the UTC offset is returned as a string like {\ttfamily \char`\"{}+01\+:00\char`\"{}}. \end{DoxyCompactList}\end{DoxyCompactItemize}
\doxysubsection*{Static Public Member Functions}
\begin{DoxyCompactItemize}
\item 
static \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} \mbox{\hyperlink{class_qore_1_1_time_zone_a71965bdd73c4d8da8f5bb72d54606ccf}{get}} ()
\begin{DoxyCompactList}\small\item\em Returns a \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object for the current time zone. \end{DoxyCompactList}\item 
static nothing \mbox{\hyperlink{class_qore_1_1_time_zone_a7e12da4b71bf101c397f06123474403f}{set}} (\mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} zone)
\begin{DoxyCompactList}\small\item\em Sets the time zone for the current \mbox{\hyperlink{class_qore_1_1_program}{Program}} object from a \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object. \end{DoxyCompactList}\item 
static nothing \mbox{\hyperlink{class_qore_1_1_time_zone_a48adb2099dca02f0484925935e044220}{set\+Region}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_time_zone_a84317e0b38d8536b73fcf475b28b50a5}{region}})
\begin{DoxyCompactList}\small\item\em Sets the time zone for the current \mbox{\hyperlink{class_qore_1_1_program}{Program}} object from a time zone region name. \end{DoxyCompactList}\item 
static nothing \mbox{\hyperlink{class_qore_1_1_time_zone_ad9b04e2df42c21fd1d67ad7b2a1e7f3f}{set\+UTCOffset}} (softint seconds\+\_\+east)
\begin{DoxyCompactList}\small\item\em Sets the time zone for the current \mbox{\hyperlink{class_qore_1_1_program}{Program}} object from an integer offset in seconds east of UTC. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
The \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} class provides access to time zone functionality. 

\mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} objects based on zoneinfo region files (on UNIX) or registry information (on Windows) can have daylight savings time information; those based on UTC offsets have none.

The \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} class supports \mbox{\hyperlink{class_qore_1_1_serializable}{data serialization}}; deserialization can fail if the object is based on a region that is not present on the target machine. 

\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_time_zone_a836a8bc75f97c8415d402d1153bcf578}\label{class_qore_1_1_time_zone_a836a8bc75f97c8415d402d1153bcf578}} 
\index{Qore::TimeZone@{Qore::TimeZone}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily Qore\+::\+Time\+Zone\+::constructor (\begin{DoxyParamCaption}\item[{softint}]{seconds\+\_\+east }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object based on the number of seconds east of UTC (3600 = UTC +01) 


\begin{DoxyParams}{Parameters}
{\em seconds\+\_\+east} & The number of seconds east of UTC for the time zone; for zones west of UTC, use negative numbers\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{TimeZone tz(3600);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_ab77972801cee2c9d116a9631dfd631d9}\label{class_qore_1_1_time_zone_ab77972801cee2c9d116a9631dfd631d9}} 
\index{Qore::TimeZone@{Qore::TimeZone}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily Qore\+::\+Time\+Zone\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{region }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object based on the region name (ex\+: {\ttfamily \char`\"{}\+America/\+Chicago\char`\"{}}) 


\begin{DoxyParams}{Parameters}
{\em region} & The region name for the time zone (ex\+: {\ttfamily \char`\"{}\+America/\+Chicago\char`\"{}}); if the zoneinfo file for the region cannot be found or parsed (on UNIX) or if the registry entry cannot be found (on Windows), then an exception is thrown\\
\hline
\end{DoxyParams}
\begin{DoxyNote}{Note}
On Windows zoneinfo region names (ex\+: {\ttfamily \char`\"{}\+Europe/\+Prague\char`\"{}}) are converted to registry entries under {\ttfamily HKEY\+\_\+\+LOCAL\+\_\+\+MACHINE SOFTWARE\textbackslash{}Microsoft\textbackslash{}Windows NT\textbackslash{}Current\+Version\textbackslash{}Time Zones} (ex\+: {\ttfamily \char`\"{}\+Central Europe Standard Time\char`\"{}}); on Windows you can also pass a registry key directly (ex\+: {\ttfamily \char`\"{}\+Central Europe Standard Time\char`\"{}}) as the region, in this case it will be used to find the timezone info in registry, however the region name will then be converted to the first corresponding zoneinfo region according to alphabet (ex\+: {\ttfamily \char`\"{}\+Central Europe Standard Time\char`\"{}} -\/$>$ {\ttfamily \char`\"{}\+Europe/\+Belgrade\char`\"{}}); if an absolute path to a file is given as the argument, then a zoneinfo file is read and parsed from the given location
\end{DoxyNote}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{TimeZone tz(\textcolor{stringliteral}{"{}Europe/Prague"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em TZINFO-\/\+ERROR} & Unable to read zoneinfo file; invalid file magic; error parsing zoneinfo file, etc \\
\hline
{\em ILLEGAL-\/\+FILESYSTEM-\/\+ACCESS} & thrown if a path was passed for {\itshape region} and the \mbox{\hyperlink{group__parse__options_ga5e466ed886222f0b57b0a399b455be71}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+FILESYSTEM}} sandboxing restriction is set\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+12 an absolute path to a zoneinfo file can be provided if the \mbox{\hyperlink{group__parse__options_ga5e466ed886222f0b57b0a399b455be71}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+FILESYSTEM}} sandboxing restriction is not in place (checked at runtime if an absolute path is passed) 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_time_zone_ab95aa62b0103ebda872a3c6b8c675ce2}\label{class_qore_1_1_time_zone_ab95aa62b0103ebda872a3c6b8c675ce2}} 
\index{Qore::TimeZone@{Qore::TimeZone}!copy@{copy}}
\index{copy@{copy}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{copy()}{copy()}}
{\footnotesize\ttfamily Qore\+::\+Time\+Zone\+::copy (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Creates a copy of the \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{TimeZone newzone = tz.copy();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_af148d835a7a7b8e01bd89f371d4227c7}\label{class_qore_1_1_time_zone_af148d835a7a7b8e01bd89f371d4227c7}} 
\index{Qore::TimeZone@{Qore::TimeZone}!date@{date}}
\index{date@{date}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{date()}{date()}\hspace{0.1cm}{\footnotesize\ttfamily [1/4]}}
{\footnotesize\ttfamily date Qore\+::\+Time\+Zone\+::date (\begin{DoxyParamCaption}\item[{date}]{d }\end{DoxyParamCaption})}



Returns the equivalent date in the time zone of the current object. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em d} & A date that will be used to create the date in the time zone of the objects; the same point in time will be returned but in the time zone of the object\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{date dt = tz.date(2012-\/01-\/01T13:56:23+01:00);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_afa23a3be62dcfc6712c168b3654a7b85}\label{class_qore_1_1_time_zone_afa23a3be62dcfc6712c168b3654a7b85}} 
\index{Qore::TimeZone@{Qore::TimeZone}!date@{date}}
\index{date@{date}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{date()}{date()}\hspace{0.1cm}{\footnotesize\ttfamily [2/4]}}
{\footnotesize\ttfamily date Qore\+::\+Time\+Zone\+::date (\begin{DoxyParamCaption}\item[{softint}]{secs,  }\item[{softint}]{us = {\ttfamily 0} }\end{DoxyParamCaption})}



Returns the equivalent date in the time zone of the current object. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em secs} & offset are in seconds from 1970-\/01-\/01Z \\
\hline
{\em us} & offset are in microseconds from {\ttfamily 1970-\/01-\/01Z} \\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{date dt = tz.date(secs);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_a177b96464e04cdc717cd6adc51f83371}\label{class_qore_1_1_time_zone_a177b96464e04cdc717cd6adc51f83371}} 
\index{Qore::TimeZone@{Qore::TimeZone}!date@{date}}
\index{date@{date}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{date()}{date()}\hspace{0.1cm}{\footnotesize\ttfamily [3/4]}}
{\footnotesize\ttfamily date Qore\+::\+Time\+Zone\+::date (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{dtstr }\end{DoxyParamCaption})}



Returns the equivalent date in the time zone of the current object. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em dtstr} & The string to be used to return a date in the object\textquotesingle{}s time zone\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{date dt = tz.date(\textcolor{stringliteral}{"{}2012-\/01-\/01T13:56:23"{}});}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+4 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_time_zone_ab22bd3acfbfb1d7b7ce56f54c81897c7}\label{class_qore_1_1_time_zone_ab22bd3acfbfb1d7b7ce56f54c81897c7}} 
\index{Qore::TimeZone@{Qore::TimeZone}!date@{date}}
\index{date@{date}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{date()}{date()}\hspace{0.1cm}{\footnotesize\ttfamily [4/4]}}
{\footnotesize\ttfamily date Qore\+::\+Time\+Zone\+::date (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{dtstr,  }\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{mask }\end{DoxyParamCaption})}



Returns a \mbox{\hyperlink{basic_data_types_date}{date/time}} value in the current \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} corresponding to parsing a string argument according to a \mbox{\hyperlink{group__date__and__time__functions_date_mask}{format mask}}. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em dtstr} & a string giving a date \\
\hline
{\em mask} & the mask for the date value; see \mbox{\hyperlink{group__date__and__time__functions_date_mask}{Date Mask Format}} for information on the format of the \mbox{\hyperlink{group__date__and__time__functions_date_mask}{format mask}}\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the \mbox{\hyperlink{basic_data_types_date}{date/time}} value in the current \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} corresponding to parsing the {\itshape dtstr} string argument according to {\itshape mask} serving as a \mbox{\hyperlink{group__date__and__time__functions_date_mask}{format mask}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{TimeZone tz(\textcolor{stringliteral}{"{}Europe/London"{}});}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}\%y\(\backslash\)n"{}}, tz.date(\textcolor{stringliteral}{"{}05/02/2012"{}}, \textcolor{stringliteral}{"{}DD/MM/YYYY"{}})); \textcolor{comment}{\# outputs: 2012-\/02-\/05 00:00:00 Sun Z (GMT)}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em DATE-\/\+CONVERT-\/\+ERROR} & invalid mask specification\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
similar to but more useful than \mbox{\hyperlink{group__date__and__time__functions_gaa990826f93b4f22f786fcfe431c4886d}{Qore\+::date(string, string)}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_time_zone_a167a5a6a1b242a912ae51cbf1adea307}\label{class_qore_1_1_time_zone_a167a5a6a1b242a912ae51cbf1adea307}} 
\index{Qore::TimeZone@{Qore::TimeZone}!dateMs@{dateMs}}
\index{dateMs@{dateMs}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{dateMs()}{dateMs()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_time_zone_afa23a3be62dcfc6712c168b3654a7b85}{date}} Qore\+::\+Time\+Zone\+::date\+Ms (\begin{DoxyParamCaption}\item[{softint}]{ms }\end{DoxyParamCaption})}



Returns a date in the object\textquotesingle{}s zone based on an offsets in milliseconds from {\ttfamily 1970-\/01-\/01Z}. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em ms} & an offsets in milliseconds from {\ttfamily 1970-\/01-\/01Z} \\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a date in the object\textquotesingle{}s zone based on the given offsets in milliseconds from {\ttfamily 1970-\/01-\/01Z} 
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{date dt = tz.dateMs(offset\_ms);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_a83f2b2cfdae00c84fd9476523990418f}\label{class_qore_1_1_time_zone_a83f2b2cfdae00c84fd9476523990418f}} 
\index{Qore::TimeZone@{Qore::TimeZone}!dateUs@{dateUs}}
\index{dateUs@{dateUs}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{dateUs()}{dateUs()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_time_zone_afa23a3be62dcfc6712c168b3654a7b85}{date}} Qore\+::\+Time\+Zone\+::date\+Us (\begin{DoxyParamCaption}\item[{softint}]{us }\end{DoxyParamCaption})}



Returns a date in the object\textquotesingle{}s zone based on an offsets in microseconds from {\ttfamily 1970-\/01-\/01Z}. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em us} & an offsets in microseconds from {\ttfamily 1970-\/01-\/01Z} \\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a date in the object\textquotesingle{}s zone based on the given offsets in microseconds from {\ttfamily 1970-\/01-\/01Z} 
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{date dt = tz.dateUs(offset\_uss);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_a71965bdd73c4d8da8f5bb72d54606ccf}\label{class_qore_1_1_time_zone_a71965bdd73c4d8da8f5bb72d54606ccf}} 
\index{Qore::TimeZone@{Qore::TimeZone}!get@{get}}
\index{get@{get}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{get()}{get()}}
{\footnotesize\ttfamily static \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} Qore\+::\+Time\+Zone\+::get (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [static]}}



Returns a \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object for the current time zone. 

\begin{DoxyReturn}{Returns}
a \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object for the current time zone
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{TimeZone tz = TimeZone::get();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_a9957690d95a39f692ce6860bcb202d45}\label{class_qore_1_1_time_zone_a9957690d95a39f692ce6860bcb202d45}} 
\index{Qore::TimeZone@{Qore::TimeZone}!hasDST@{hasDST}}
\index{hasDST@{hasDST}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{hasDST()}{hasDST()}}
{\footnotesize\ttfamily bool Qore\+::\+Time\+Zone\+::has\+DST (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the zone has daylight saving time rules, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} objects based on zoneinfo region files (on UNIX) or registry information (on Windows) can have (but do not necessarily have) daylight savings time information; those based on UTC offsets have none

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the current zone has daylight saving time rules, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool hasdst = tz.hasDST();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_a84317e0b38d8536b73fcf475b28b50a5}\label{class_qore_1_1_time_zone_a84317e0b38d8536b73fcf475b28b50a5}} 
\index{Qore::TimeZone@{Qore::TimeZone}!region@{region}}
\index{region@{region}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{region()}{region()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+Time\+Zone\+::region (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the region name as a string; if the current zone is based on a UTC offset, then the UTC offset is returned as a string like {\ttfamily \char`\"{}+01\+:00\char`\"{}}. 

\begin{DoxyReturn}{Returns}
the region name as a string; if the current zone is based on a UTC offset, then the UTC offset is returned as a string like {\ttfamily \char`\"{}+01\+:00\char`\"{}} 
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string region = tz.region();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_a7e12da4b71bf101c397f06123474403f}\label{class_qore_1_1_time_zone_a7e12da4b71bf101c397f06123474403f}} 
\index{Qore::TimeZone@{Qore::TimeZone}!set@{set}}
\index{set@{set}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{set()}{set()}}
{\footnotesize\ttfamily static nothing Qore\+::\+Time\+Zone\+::set (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}}}]{zone }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [static]}}



Sets the time zone for the current \mbox{\hyperlink{class_qore_1_1_program}{Program}} object from a \mbox{\hyperlink{class_qore_1_1_time_zone}{Time\+Zone}} object. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_ga99046cc8285fb26438508cdf29b5771e}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+LOCALE\+\_\+\+CONTROL}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em zone} & the time zone to set\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{TimeZone tz(\textcolor{stringliteral}{"{}Europe/Prague"{}});}
\DoxyCodeLine{TimeZone::set(tz);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_a48adb2099dca02f0484925935e044220}\label{class_qore_1_1_time_zone_a48adb2099dca02f0484925935e044220}} 
\index{Qore::TimeZone@{Qore::TimeZone}!setRegion@{setRegion}}
\index{setRegion@{setRegion}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{setRegion()}{setRegion()}}
{\footnotesize\ttfamily static nothing Qore\+::\+Time\+Zone\+::set\+Region (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{region }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [static]}}



Sets the time zone for the current \mbox{\hyperlink{class_qore_1_1_program}{Program}} object from a time zone region name. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_ga99046cc8285fb26438508cdf29b5771e}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+LOCALE\+\_\+\+CONTROL}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em region} & the region name to set\\
\hline
\end{DoxyParams}
\begin{DoxyNote}{Note}
On Windows you can use both zoneinfo region names (ex\+: {\ttfamily \char`\"{}\+Europe/\+Prague\char`\"{}}) as well as the Windows registry keys under {\ttfamily HKEY\+\_\+\+LOCAL\+\_\+\+MACHINE SOFTWARE\textbackslash{}Microsoft\textbackslash{}Windows NT\textbackslash{}Current\+Version\textbackslash{}Time Zones} (ex\+: {\ttfamily \char`\"{}\+Central Europe Standard Time\char`\"{}}); note that in this case the Windows-\/style names will only be used to load the timezone info from registry and the name will then be converted to the first corresponding zoneinfo region according to alphabet (ex\+: {\ttfamily \char`\"{}\+Central Europe Standard Time\char`\"{}} -\/$>$ {\ttfamily \char`\"{}\+Europe/\+Belgrade\char`\"{}}).
\end{DoxyNote}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{TimeZone::setRegion(\textcolor{stringliteral}{"{}Europe/Prague"{}});}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_ad9b04e2df42c21fd1d67ad7b2a1e7f3f}\label{class_qore_1_1_time_zone_ad9b04e2df42c21fd1d67ad7b2a1e7f3f}} 
\index{Qore::TimeZone@{Qore::TimeZone}!setUTCOffset@{setUTCOffset}}
\index{setUTCOffset@{setUTCOffset}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{setUTCOffset()}{setUTCOffset()}}
{\footnotesize\ttfamily static nothing Qore\+::\+Time\+Zone\+::set\+UTCOffset (\begin{DoxyParamCaption}\item[{softint}]{seconds\+\_\+east }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [static]}}



Sets the time zone for the current \mbox{\hyperlink{class_qore_1_1_program}{Program}} object from an integer offset in seconds east of UTC. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_ga99046cc8285fb26438508cdf29b5771e}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+LOCALE\+\_\+\+CONTROL}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em seconds\+\_\+east} & the number of seconds east of UTC for the new time zone (negative numbers give seconds west of UTC)\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{TimeZone::setUTCOffset(3600);}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_time_zone_ac82e34e1f7c96d3aa5c0a071981a6f4f}\label{class_qore_1_1_time_zone_ac82e34e1f7c96d3aa5c0a071981a6f4f}} 
\index{Qore::TimeZone@{Qore::TimeZone}!UTCOffset@{UTCOffset}}
\index{UTCOffset@{UTCOffset}!Qore::TimeZone@{Qore::TimeZone}}
\doxysubsubsection{\texorpdfstring{UTCOffset()}{UTCOffset()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Time\+Zone\+::\+UTCOffset (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the number of seconds east of UTC for the zone; negative numbers indicate a zone west of UTC. 

\begin{DoxyReturn}{Returns}
the number of seconds east of UTC for the zone; negative numbers indicate a zone west of UTC
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int offset = tz.UTCOffset();}

\end{DoxyCode}
 
\end{DoxyParagraph}
