\hypertarget{class_qore_1_1_thread_1_1_auto_read_lock}{}\doxysection{Qore\+::Thread\+::Auto\+Read\+Lock Class Reference}
\label{class_qore_1_1_thread_1_1_auto_read_lock}\index{Qore::Thread::AutoReadLock@{Qore::Thread::AutoReadLock}}


A helper class for the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} class for exception-\/safe read lock handling.  


\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock_ac509ed11681dce1cf2dd2d09cc5f6650}{constructor}} (\mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} rwl)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object based on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} argument passed and immediately calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_ad8ab081b2f254129ec042d614fbb1485}{RWLock\+::read\+Lock()}} \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock_a1549404caafd7bfb69b0b8db92588711}{copy}} ()
\begin{DoxyCompactList}\small\item\em Throws an exception; objects of this class cannot be copied. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock_a410f4f725f6dc167882eae0ef6ebffa0}{destructor}} ()
\begin{DoxyCompactList}\small\item\em Calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a1a32805ce5cc129d2ed2bf96b01a7d4c}{RWLock\+::read\+Unlock()}} on the saved \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} and destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
A helper class for the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} class for exception-\/safe read lock handling. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}}
\end{DoxyParagraph}
\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} objects, when used along with a \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} object, allow Qore programmers to safely acquire and release a read lock, even if exceptions are thrown or return statements are executed in the block where the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object is created.

\mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} objects are helper objects that acquire a read lock for the lifetime of the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object. For this reason, it is only appropriate to assign an \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object to a local variable, so when the local variable goes out of scope, the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object will be deleted and the read lock will be automatically released.

For example\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{our RWLock rwl();}
\DoxyCodeLine{}
\DoxyCodeLine{sub check\_error(error) \{}
\DoxyCodeLine{    \textcolor{comment}{\# note that the read lock is acquired in the AutoReadLock constructor, and}}
\DoxyCodeLine{    \textcolor{comment}{\# the read lock will be released as soon as the block is exited below.}}
\DoxyCodeLine{    \textcolor{comment}{\# (with either the throw statement or the return statement)}}
\DoxyCodeLine{    AutoReadLock arl(rwl);}
\DoxyCodeLine{    \textcolor{keywordflow}{if} (error)}
\DoxyCodeLine{        throw \textcolor{stringliteral}{"{}ERROR"{}}, \textcolor{stringliteral}{"{}sorry, an error happened"{}};}
\DoxyCodeLine{}
\DoxyCodeLine{    \textcolor{keywordflow}{return} \textcolor{stringliteral}{"{}OK"{}};}
\DoxyCodeLine{\}}

\end{DoxyCode}


\begin{DoxyNote}{Note}
This class is not available with the \mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}} parse option 
\end{DoxyNote}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_read_lock_ac509ed11681dce1cf2dd2d09cc5f6650}\label{class_qore_1_1_thread_1_1_auto_read_lock_ac509ed11681dce1cf2dd2d09cc5f6650}} 
\index{Qore::Thread::AutoReadLock@{Qore::Thread::AutoReadLock}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::Thread::AutoReadLock@{Qore::Thread::AutoReadLock}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Auto\+Read\+Lock\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}}}]{rwl }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object based on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} argument passed and immediately calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_ad8ab081b2f254129ec042d614fbb1485}{RWLock\+::read\+Lock()}} 

Creates the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object based on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} argument passed. The \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object immediately calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_ad8ab081b2f254129ec042d614fbb1485}{RWLock\+::read\+Lock()}} on the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} object passed, and saves it so it can be released when the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object is destroyed.

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{AutoReadLock arl(rwlock);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em THREAD-\/\+DEADLOCK} & A deadlock was detected while trying to acquire the lock \\
\hline
{\em LOCK-\/\+ERROR} & \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_ad8ab081b2f254129ec042d614fbb1485}{RWLock\+::read\+Lock()}} called while already holding the write lock, object deleted in another thread, etc. \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_read_lock_a1549404caafd7bfb69b0b8db92588711}\label{class_qore_1_1_thread_1_1_auto_read_lock_a1549404caafd7bfb69b0b8db92588711}} 
\index{Qore::Thread::AutoReadLock@{Qore::Thread::AutoReadLock}!copy@{copy}}
\index{copy@{copy}!Qore::Thread::AutoReadLock@{Qore::Thread::AutoReadLock}}
\doxysubsubsection{\texorpdfstring{copy()}{copy()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Auto\+Read\+Lock\+::copy (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Throws an exception; objects of this class cannot be copied. 


\begin{DoxyExceptions}{Exceptions}
{\em AUTOREADLOCK-\/\+COPY-\/\+ERROR} & objects of this class cannot be copied \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_auto_read_lock_a410f4f725f6dc167882eae0ef6ebffa0}\label{class_qore_1_1_thread_1_1_auto_read_lock_a410f4f725f6dc167882eae0ef6ebffa0}} 
\index{Qore::Thread::AutoReadLock@{Qore::Thread::AutoReadLock}!destructor@{destructor}}
\index{destructor@{destructor}!Qore::Thread::AutoReadLock@{Qore::Thread::AutoReadLock}}
\doxysubsubsection{\texorpdfstring{destructor()}{destructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Auto\+Read\+Lock\+::destructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a1a32805ce5cc129d2ed2bf96b01a7d4c}{RWLock\+::read\+Unlock()}} on the saved \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} and destroys the \mbox{\hyperlink{class_qore_1_1_thread_1_1_auto_read_lock}{Auto\+Read\+Lock}} object. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{delete arl;}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em LOCK-\/\+ERROR} & \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock_a1a32805ce5cc129d2ed2bf96b01a7d4c}{RWLock\+::read\+Unlock()}} called while not holding the read lock, \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} object deleted in another thread, etc \\
\hline
\end{DoxyExceptions}
