\hypertarget{class_qore_1_1_thread_1_1_abstract_thread_resource}{}\doxysection{Qore\+::Thread\+::Abstract\+Thread\+Resource Class Reference}
\label{class_qore_1_1_thread_1_1_abstract_thread_resource}\index{Qore::Thread::AbstractThreadResource@{Qore::Thread::AbstractThreadResource}}


This class defines an abstract interface for thread resources.  


\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
abstract nothing \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_thread_resource_a0431f7384991eaf6900ee3a952b57f87}{cleanup}} ()
\begin{DoxyCompactList}\small\item\em This method is called by Qore itself when the thread resource is still allocated and requires cleanup. \end{DoxyCompactList}\item 
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_abstract_thread_resource_a7e00c385a55a0767c67fa2cee5c9324b}\label{class_qore_1_1_thread_1_1_abstract_thread_resource_a7e00c385a55a0767c67fa2cee5c9324b}} 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_thread_resource_a7e00c385a55a0767c67fa2cee5c9324b}{constructor}} ()
\begin{DoxyCompactList}\small\item\em Creates the internal thread resource object. \end{DoxyCompactList}\item 
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_abstract_thread_resource_aa76653f903110392dd38c73c8f2d6594}\label{class_qore_1_1_thread_1_1_abstract_thread_resource_aa76653f903110392dd38c73c8f2d6594}} 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_thread_resource_aa76653f903110392dd38c73c8f2d6594}{destructor}} ()
\begin{DoxyCompactList}\small\item\em removes the thread resource if set; if so then the \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_thread_resource_a0431f7384991eaf6900ee3a952b57f87}{cleanup()}} method is called \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
This class defines an abstract interface for thread resources. 

\begin{DoxyParagraph}{Overview}
Thread resources can be considered properties of a thread that need to be cleaned up when the thread exits or one of the thread cleanup functions is run\+:
\begin{DoxyItemize}
\item \mbox{\hyperlink{group__threading__functions_ga421dca39ccb55b191d5d09fd98c2075a}{Qore\+::throw\+\_\+thread\+\_\+resource\+\_\+exceptions()}}
\item \mbox{\hyperlink{group__threading__functions_ga4e62409b8a1b414276d033267e7299e4}{Qore\+::throw\+\_\+thread\+\_\+resource\+\_\+exceptions\+\_\+to\+\_\+mark()}}
\end{DoxyItemize}
\end{DoxyParagraph}
The following functions allow classes of this type to be set or removed as thread resources\+:
\begin{DoxyItemize}
\item \mbox{\hyperlink{group__threading__functions_ga1a1fbc371cfc8885ed78e4bff25d35b1}{Qore\+::set\+\_\+thread\+\_\+resource()}}
\item \mbox{\hyperlink{group__threading__functions_gadc994316e54fdf50111018de9bd15dc6}{Qore\+::remove\+\_\+thread\+\_\+resource()}}
\end{DoxyItemize}

If the thread resource is still set when the destructor is run, then the destructor frees the thread resource and calls \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_thread_resource_a0431f7384991eaf6900ee3a952b57f87}{cleanup()}}.

\begin{DoxyParagraph}{Example}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# this class starts a background thread in the constructor that is managed as a thread resource in the creating thread}}
\DoxyCodeLine{\textcolor{keyword}{class }ThreadResourceExample inherits AbstractThreadResource \{}
\DoxyCodeLine{    public \{\}}
\DoxyCodeLine{}
\DoxyCodeLine{    private \{}
\DoxyCodeLine{        Qore::Thread::Mutex m();}
\DoxyCodeLine{        Qore::Thread::Condition cond();}
\DoxyCodeLine{        Qore::Thread::Counter cnt();}
\DoxyCodeLine{        bool exit;}
\DoxyCodeLine{    \}}
\DoxyCodeLine{}
\DoxyCodeLine{    constructor() \{}
\DoxyCodeLine{        start();}
\DoxyCodeLine{    \}}
\DoxyCodeLine{}
\DoxyCodeLine{    synchronized private start() \{}
\DoxyCodeLine{        cnt.inc();}
\DoxyCodeLine{        \mbox{\hyperlink{group__threading__functions_ga1a1fbc371cfc8885ed78e4bff25d35b1}{set\_thread\_resource}}(self);}
\DoxyCodeLine{        on\_error \{}
\DoxyCodeLine{            cnt.dec();}
\DoxyCodeLine{            \mbox{\hyperlink{group__threading__functions_gadc994316e54fdf50111018de9bd15dc6}{remove\_thread\_resource}}(self);}
\DoxyCodeLine{        \}}
\DoxyCodeLine{        background waiter();}
\DoxyCodeLine{    \}}
\DoxyCodeLine{}
\DoxyCodeLine{    stop() \{}
\DoxyCodeLine{        \{}
\DoxyCodeLine{            m.lock();}
\DoxyCodeLine{            on\_exit m.unlock();}
\DoxyCodeLine{            exit = \textcolor{keyword}{True};}
\DoxyCodeLine{            cond.signal();}
\DoxyCodeLine{        \}}
\DoxyCodeLine{        cnt.waitForZero();}
\DoxyCodeLine{        \mbox{\hyperlink{group__threading__functions_gadc994316e54fdf50111018de9bd15dc6}{remove\_thread\_resource}}(self);}
\DoxyCodeLine{    \}}
\DoxyCodeLine{}
\DoxyCodeLine{    \textcolor{comment}{\# the cleanup routine stops the thread and throws an exception}}
\DoxyCodeLine{    cleanup() \{}
\DoxyCodeLine{        m.lock();}
\DoxyCodeLine{        on\_exit m.unlock();}
\DoxyCodeLine{        \textcolor{keywordflow}{if} (!exit) \{}
\DoxyCodeLine{            stop();}
\DoxyCodeLine{            throw \textcolor{stringliteral}{"{}THREAD-\/RESOURCE-\/ERROR"{}}, \mbox{\hyperlink{group__string__functions_ga7a74be141f814ef286046c367b21091c}{sprintf}}(\textcolor{stringliteral}{"{}the background thread was stopped during thread resource cleanup; call \%s::stop() before exiting the thread to avoid this exception"{}}, self.className());}
\DoxyCodeLine{        \}}
\DoxyCodeLine{    \}}
\DoxyCodeLine{}
\DoxyCodeLine{    \textcolor{comment}{\# the background thread simply waits for the exit condition}}
\DoxyCodeLine{    private waiter() \{}
\DoxyCodeLine{        on\_exit cnt.dec();}
\DoxyCodeLine{}
\DoxyCodeLine{        m.lock();}
\DoxyCodeLine{        on\_exit m.unlock();}
\DoxyCodeLine{        \textcolor{keywordflow}{while} (!exit)}
\DoxyCodeLine{            cond.wait(m);}
\DoxyCodeLine{    \}}
\DoxyCodeLine{\}    }

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{threading_thread_resources}{Thread Resources}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+12 
\end{DoxySince}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_abstract_thread_resource_a0431f7384991eaf6900ee3a952b57f87}\label{class_qore_1_1_thread_1_1_abstract_thread_resource_a0431f7384991eaf6900ee3a952b57f87}} 
\index{Qore::Thread::AbstractThreadResource@{Qore::Thread::AbstractThreadResource}!cleanup@{cleanup}}
\index{cleanup@{cleanup}!Qore::Thread::AbstractThreadResource@{Qore::Thread::AbstractThreadResource}}
\doxysubsubsection{\texorpdfstring{cleanup()}{cleanup()}}
{\footnotesize\ttfamily abstract nothing Qore\+::\+Thread\+::\+Abstract\+Thread\+Resource\+::cleanup (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [pure virtual]}}



This method is called by Qore itself when the thread resource is still allocated and requires cleanup. 

This method should clean up the resource and normally should throw an appropriate exception explaining\+:
\begin{DoxyItemize}
\item what the programming error was (ex\+: failing to unlock a lock before the thread exited)
\item what happened (ex\+: the lock was automatically released)
\item how to prevent it from happening in the future (ex\+: make sure and release the lock before exiting the thread)
\end{DoxyItemize}

This method is called in the following situations\+:
\begin{DoxyItemize}
\item \mbox{\hyperlink{group__threading__functions_ga421dca39ccb55b191d5d09fd98c2075a}{Qore\+::throw\+\_\+thread\+\_\+resource\+\_\+exceptions()}} is called and the current object is still set as a thread resource
\item \mbox{\hyperlink{group__threading__functions_ga4e62409b8a1b414276d033267e7299e4}{Qore\+::throw\+\_\+thread\+\_\+resource\+\_\+exceptions\+\_\+to\+\_\+mark()}} is called and the current object is set as a thread resource after the current mark set by \mbox{\hyperlink{group__threading__functions_gafa1c0f9e429a945b66fb261c7fa1b5bd}{Qore\+::mark\+\_\+thread\+\_\+resources()}}
\item the thread exits and the current object is still set as a thread resource
\end{DoxyItemize}

\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item thread resources are set with \mbox{\hyperlink{group__threading__functions_ga1a1fbc371cfc8885ed78e4bff25d35b1}{Qore\+::set\+\_\+thread\+\_\+resource()}} and removed with \mbox{\hyperlink{group__threading__functions_gadc994316e54fdf50111018de9bd15dc6}{Qore\+::remove\+\_\+thread\+\_\+resource()}}
\item if this method does not throw an exception, then thread resource cleanup for the object will be performed silently
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{threading_thread_resources}{Thread Resources}} 
\end{DoxySeeAlso}
