\hypertarget{class_qore_1_1_thread_1_1_abstract_smart_lock}{}\doxysection{Qore\+::Thread\+::Abstract\+Smart\+Lock Class Reference}
\label{class_qore_1_1_thread_1_1_abstract_smart_lock}\index{Qore::Thread::AbstractSmartLock@{Qore::Thread::AbstractSmartLock}}


The abstract base class for locks that support the internal API for use with the \mbox{\hyperlink{class_qore_1_1_thread_1_1_condition}{Condition}} class.  




Inheritance diagram for Qore\+::Thread\+::Abstract\+Smart\+Lock\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_smart_lock_af15ccf8b346a9f3abbbdc559d2f5e59b}{constructor}} ()
\begin{DoxyCompactList}\small\item\em Throws an exception if called directly; this class can only be instantiated by builtin subclasses. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_smart_lock_aaf6a2ecab96ad01d3ab0dbb81b63a363}{get\+Name}} ()
\begin{DoxyCompactList}\small\item\em Returns the name of the threading class directly inheriting this class. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_smart_lock_a4936d08a0508d61a41e8c685e2a03d72}{lock\+Owner}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the calling thread owns the lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_smart_lock_afafe6ef19203993a7c5dd87e00068325}{lock\+TID}} ()
\begin{DoxyCompactList}\small\item\em Returns the TID of the thread owning the lock or -\/1 if the lock is currently not acquired. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
The abstract base class for locks that support the internal API for use with the \mbox{\hyperlink{class_qore_1_1_thread_1_1_condition}{Condition}} class. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}}
\end{DoxyParagraph}
This is an abstract class to be inherited by builtin classes that implement the internal Qore API that allows them to be used by the \mbox{\hyperlink{class_qore_1_1_thread_1_1_condition}{Condition}} class. Currently the \mbox{\hyperlink{class_qore_1_1_thread_1_1_r_w_lock}{RWLock}} and \mbox{\hyperlink{class_qore_1_1_thread_1_1_mutex}{Mutex}} classes inherit this class.

This class cannot be instantiated directly and also cannot be directly inherited by user-\/defined classes.

\begin{DoxyNote}{Note}
This class is not available with the \mbox{\hyperlink{group__parse__options_gade963e1fbbd1f5b2c777df7221512a1b}{PO\+\_\+\+NO\+\_\+\+THREAD\+\_\+\+CLASSES}} parse option. 
\end{DoxyNote}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_abstract_smart_lock_af15ccf8b346a9f3abbbdc559d2f5e59b}\label{class_qore_1_1_thread_1_1_abstract_smart_lock_af15ccf8b346a9f3abbbdc559d2f5e59b}} 
\index{Qore::Thread::AbstractSmartLock@{Qore::Thread::AbstractSmartLock}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::Thread::AbstractSmartLock@{Qore::Thread::AbstractSmartLock}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Thread\+::\+Abstract\+Smart\+Lock\+::constructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Throws an exception if called directly; this class can only be instantiated by builtin subclasses. 


\begin{DoxyExceptions}{Exceptions}
{\em ABSTRACTSMARTLOCK-\/\+CONSTRUCTOR-\/\+ERROR} & this exception is thrown if this class is constructed directly (also if directly inherited by user classes) \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_abstract_smart_lock_aaf6a2ecab96ad01d3ab0dbb81b63a363}\label{class_qore_1_1_thread_1_1_abstract_smart_lock_aaf6a2ecab96ad01d3ab0dbb81b63a363}} 
\index{Qore::Thread::AbstractSmartLock@{Qore::Thread::AbstractSmartLock}!getName@{getName}}
\index{getName@{getName}!Qore::Thread::AbstractSmartLock@{Qore::Thread::AbstractSmartLock}}
\doxysubsubsection{\texorpdfstring{getName()}{getName()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+Thread\+::\+Abstract\+Smart\+Lock\+::get\+Name (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the name of the threading class directly inheriting this class. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string name = lock.getName();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the name of the threading class directly inheriting this class 
\end{DoxyReturn}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_abstract_smart_lock_a4936d08a0508d61a41e8c685e2a03d72}\label{class_qore_1_1_thread_1_1_abstract_smart_lock_a4936d08a0508d61a41e8c685e2a03d72}} 
\index{Qore::Thread::AbstractSmartLock@{Qore::Thread::AbstractSmartLock}!lockOwner@{lockOwner}}
\index{lockOwner@{lockOwner}!Qore::Thread::AbstractSmartLock@{Qore::Thread::AbstractSmartLock}}
\doxysubsubsection{\texorpdfstring{lockOwner()}{lockOwner()}}
{\footnotesize\ttfamily bool Qore\+::\+Thread\+::\+Abstract\+Smart\+Lock\+::lock\+Owner (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the calling thread owns the lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{comment}{\# only grab and release lock if we don't already own it}}
\DoxyCodeLine{bool lck = !lock.lockOwner();}
\DoxyCodeLine{\textcolor{keywordflow}{if} (lck)}
\DoxyCodeLine{    lock.lock();}
\DoxyCodeLine{on\_exit}
\DoxyCodeLine{    \textcolor{keywordflow}{if} (lck)}
\DoxyCodeLine{        lock.unlock();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the calling thread owns the lock, \mbox{\hyperlink{basic_data_types_False}{False}} if not 
\end{DoxyReturn}
\mbox{\Hypertarget{class_qore_1_1_thread_1_1_abstract_smart_lock_afafe6ef19203993a7c5dd87e00068325}\label{class_qore_1_1_thread_1_1_abstract_smart_lock_afafe6ef19203993a7c5dd87e00068325}} 
\index{Qore::Thread::AbstractSmartLock@{Qore::Thread::AbstractSmartLock}!lockTID@{lockTID}}
\index{lockTID@{lockTID}!Qore::Thread::AbstractSmartLock@{Qore::Thread::AbstractSmartLock}}
\doxysubsubsection{\texorpdfstring{lockTID()}{lockTID()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+Thread\+::\+Abstract\+Smart\+Lock\+::lock\+TID (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the TID of the thread owning the lock or -\/1 if the lock is currently not acquired. 

This method normally not useful in practice for anything except checking that the current thread owns the lock, in which case \mbox{\hyperlink{class_qore_1_1_thread_1_1_abstract_smart_lock_a4936d08a0508d61a41e8c685e2a03d72}{Abstract\+Smart\+Lock\+::lock\+Owner()}} is better, because if the lock is not owned by the current thread the lock ownership can change at any time.

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int tid = lock.lockTID();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the TID of the thread owning the lock or -\/1 if the lock is currently not acquired 
\end{DoxyReturn}
