\hypertarget{class_qore_1_1_string_input_stream}{}\doxysection{Qore\+::String\+Input\+Stream Class Reference}
\label{class_qore_1_1_string_input_stream}\index{Qore::StringInputStream@{Qore::StringInputStream}}


This class implements the \mbox{\hyperlink{class_qore_1_1_input_stream}{Input\+Stream}} interface for reading bytes from a \mbox{\hyperlink{basic_data_types_string}{String}} variable.  




Inheritance diagram for Qore\+::String\+Input\+Stream\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_string_input_stream_a45bd655f1cacfc10b0dfd458ffcfb022}{constructor}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} src)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_string_input_stream}{String\+Input\+Stream}} based on the \mbox{\hyperlink{basic_data_types_string}{String}} given. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_string_input_stream_ab814dfc069c4250121765bad4a033071}{get\+Encoding}} ()
\begin{DoxyCompactList}\small\item\em Returns the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_string_input_stream}{String\+Input\+Stream}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_string_input_stream_a226b6d889b17fe20a9d09aa81fe9b529}{peek}} ()
\begin{DoxyCompactList}\small\item\em Peeks the next byte available from the input stream; returns -\/1 if no more data available. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} \mbox{\hyperlink{class_qore_1_1_string_input_stream_a2ec22e63a510f7438cb677936a6dbc49}{read}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} limit)
\begin{DoxyCompactList}\small\item\em Reads bytes (up to a specified limit) from the input stream; returns \mbox{\hyperlink{basic_data_types_NOTHING}{NOTHING}} if there are no more bytes in the stream. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
This class implements the \mbox{\hyperlink{class_qore_1_1_input_stream}{Input\+Stream}} interface for reading bytes from a \mbox{\hyperlink{basic_data_types_string}{String}} variable. 

\begin{DoxySince}{Since}
Qore 0.\+8.\+13
\end{DoxySince}
\begin{DoxyParagraph}{Example\+: String\+Input\+Stream basic usage}

\begin{DoxyCode}{0}
\DoxyCodeLine{string src = \textcolor{stringliteral}{"{}abc"{}};}
\DoxyCodeLine{StringInputStream sis(src);}
\DoxyCodeLine{*binary b;}
\DoxyCodeLine{\textcolor{keywordflow}{while} (b = sis.read(2)) \{}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}read \%s\(\backslash\)n"{}}, \mbox{\hyperlink{group__misc__functions_gae7be18717b0ed9010c48166a437c35b4}{make\_hex\_string}}(b));}
\DoxyCodeLine{\}}
\DoxyCodeLine{}
\DoxyCodeLine{read 6162}
\DoxyCodeLine{read 63}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
stream classes are not designed to be accessed from multiple threads; they have been implemented without locking for fast and efficient use when used from a single thread. For methods that would be unsafe to use in another thread, any use of such methods in threads other than the thread where the constructor was called will cause a {\ttfamily STREAM-\/\+THREAD-\/\+ERROR} to be thrown, unless the stream is handed off to another thread using the \mbox{\hyperlink{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}{Stream\+Base\+::unassign\+Thread()}} method in the thread that currently owns the stream, and the \mbox{\hyperlink{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}{Stream\+Base\+::reassign\+Thread()}} method in the new thread.
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_reader}{Stream\+Reader}} for a class that can be used to \mbox{\hyperlink{class_qore_1_1_string_input_stream_a2ec22e63a510f7438cb677936a6dbc49}{read}} various kinds of data from an \mbox{\hyperlink{class_qore_1_1_input_stream}{Input\+Stream}} 
\end{DoxySeeAlso}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_string_input_stream_a45bd655f1cacfc10b0dfd458ffcfb022}\label{class_qore_1_1_string_input_stream_a45bd655f1cacfc10b0dfd458ffcfb022}} 
\index{Qore::StringInputStream@{Qore::StringInputStream}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::StringInputStream@{Qore::StringInputStream}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+String\+Input\+Stream\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{src }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_string_input_stream}{String\+Input\+Stream}} based on the \mbox{\hyperlink{basic_data_types_string}{String}} given. 


\begin{DoxyParams}{Parameters}
{\em src} & the \mbox{\hyperlink{basic_data_types_string}{String}} to read bytes from \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_string_input_stream_ab814dfc069c4250121765bad4a033071}\label{class_qore_1_1_string_input_stream_ab814dfc069c4250121765bad4a033071}} 
\index{Qore::StringInputStream@{Qore::StringInputStream}!getEncoding@{getEncoding}}
\index{getEncoding@{getEncoding}!Qore::StringInputStream@{Qore::StringInputStream}}
\doxysubsubsection{\texorpdfstring{getEncoding()}{getEncoding()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+String\+Input\+Stream\+::get\+Encoding (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_string_input_stream}{String\+Input\+Stream}}. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string src = \textcolor{stringliteral}{"{}xyz"{}};}
\DoxyCodeLine{StringInputStream is(src);}
\DoxyCodeLine{string encoding = is.getEncoding();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_string_input_stream}{String\+Input\+Stream}} 
\end{DoxyReturn}
\mbox{\Hypertarget{class_qore_1_1_string_input_stream_a226b6d889b17fe20a9d09aa81fe9b529}\label{class_qore_1_1_string_input_stream_a226b6d889b17fe20a9d09aa81fe9b529}} 
\index{Qore::StringInputStream@{Qore::StringInputStream}!peek@{peek}}
\index{peek@{peek}!Qore::StringInputStream@{Qore::StringInputStream}}
\doxysubsubsection{\texorpdfstring{peek()}{peek()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+String\+Input\+Stream\+::peek (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Peeks the next byte available from the input stream; returns -\/1 if no more data available. 

\begin{DoxyReturn}{Returns}
the next byte available from the input stream or -\/1 if no more data is available
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string src = \textcolor{stringliteral}{"{}xyz"{}};}
\DoxyCodeLine{StringInputStream is(src);}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}peek: \%d\(\backslash\)n"{}}, is.peek());}
\DoxyCodeLine{*binary b = is.read(3);}
\DoxyCodeLine{\mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}peek: \%d\(\backslash\)n"{}}, is.peek());}
\DoxyCodeLine{}
\DoxyCodeLine{peek 120}
\DoxyCodeLine{peek -\/1}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object \\
\hline
\end{DoxyExceptions}


Implements \mbox{\hyperlink{class_qore_1_1_input_stream_a165db4108c3a1f4bbb6b619972fd131c}{Qore\+::\+Input\+Stream}}.

\mbox{\Hypertarget{class_qore_1_1_string_input_stream_a2ec22e63a510f7438cb677936a6dbc49}\label{class_qore_1_1_string_input_stream_a2ec22e63a510f7438cb677936a6dbc49}} 
\index{Qore::StringInputStream@{Qore::StringInputStream}!read@{read}}
\index{read@{read}!Qore::StringInputStream@{Qore::StringInputStream}}
\doxysubsubsection{\texorpdfstring{read()}{read()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} Qore\+::\+String\+Input\+Stream\+::read (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{limit }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Reads bytes (up to a specified limit) from the input stream; returns \mbox{\hyperlink{basic_data_types_NOTHING}{NOTHING}} if there are no more bytes in the stream. 


\begin{DoxyParams}{Parameters}
{\em limit} & the maximum number of bytes to read \\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the read bytes (the length is between 1 and \`{}limit\`{} inclusive) or \mbox{\hyperlink{basic_data_types_NOTHING}{NOTHING}} if no more bytes are available
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string src = \textcolor{stringliteral}{"{}xyz"{}};}
\DoxyCodeLine{StringInputStream is(src);}
\DoxyCodeLine{*binary b;}
\DoxyCodeLine{\textcolor{keywordflow}{while} (b = is.read(2)) \{}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}read \%s\(\backslash\)n"{}}, \mbox{\hyperlink{group__misc__functions_gae7be18717b0ed9010c48166a437c35b4}{make\_hex\_string}}(b));}
\DoxyCodeLine{\}}
\DoxyCodeLine{}
\DoxyCodeLine{read 7879}
\DoxyCodeLine{read 7a}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em INPUT-\/\+STREAM-\/\+ERROR} & {\itshape limit} is not positive \\
\hline
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object \\
\hline
\end{DoxyExceptions}


Implements \mbox{\hyperlink{class_qore_1_1_input_stream_a74ba0bc85bb86988a0f8b3255d1dbf01}{Qore\+::\+Input\+Stream}}.

