\hypertarget{class_qore_1_1_stream_writer}{}\doxysection{Qore\+::Stream\+Writer Class Reference}
\label{class_qore_1_1_stream_writer}\index{Qore::StreamWriter@{Qore::StreamWriter}}


This class defines a stream writer for output streams.  


\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_stream_writer_ad36abd7aa5d58d5e8abb40badaa55299}{constructor}} (\mbox{\hyperlink{class_qore_1_1_output_stream}{Qore\+::\+Output\+Stream}} os, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} encoding)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}} for writing data to the given \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}}. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a2d07ac7783e3ff6db3adaa455fb68054}{f\+\_\+printf}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} fmt,...)
\begin{DoxyCompactList}\small\item\em Writes a formatted string with hard field widths to an output stream; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_aed4f874595474208e7f8b5561f081dad}{f\+\_\+vprintf}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} fmt, any fmt\+\_\+args)
\begin{DoxyCompactList}\small\item\em Writes a formatted string with hard field widths to an output stream, where the second argument is the formatting argument list; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_stream_writer_a1ff1c44aed52fcb6d925b6d9c72fb162}{get\+Encoding}} ()
\begin{DoxyCompactList}\small\item\em Returns the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} \mbox{\hyperlink{class_qore_1_1_stream_writer_a43a64e7d6774c777071fff39245477d6}{get\+Output\+Stream}} ()
\begin{DoxyCompactList}\small\item\em Returns the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} for the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a725a0b783c28f325cdd049c6d5585106}{print}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} str)
\begin{DoxyCompactList}\small\item\em Writes string data to an output stream; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a84e2fc7dc8253f96c00f79870f3c4bbb}{printf}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} fmt,...)
\begin{DoxyCompactList}\small\item\em Writes a formatted string with soft field widths to an output stream; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_ab7905ebc40095b30dfe9e78cbf43aca1}{vprintf}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} fmt, any fmt\+\_\+args)
\begin{DoxyCompactList}\small\item\em Writes a formatted string with soft field widths to an output stream, where the second argument is the formatting argument list; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a008eb323b5c9188dfd13a7ecab3f6bf4}{write}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} str)
\begin{DoxyCompactList}\small\item\em Writes a \mbox{\hyperlink{basic_data_types_string}{String}} to the output stream. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a8b76d2ba82556449be270bfe8c3305e8}{write}} (\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} b)
\begin{DoxyCompactList}\small\item\em Writes a \mbox{\hyperlink{basic_data_types_binary}{Binary}} to the output stream. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a61c9f957f77d9581aa4cf564ea8ed401}{writei1}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} c)
\begin{DoxyCompactList}\small\item\em Writes a 1-\/byte signed integer to the output stream. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a1a395f2c4fb63d4e6cf73c315db0659b}{writei2}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} s)
\begin{DoxyCompactList}\small\item\em Writes a 2-\/byte (16 bit) integer to the output stream in binary big-\/endian format. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_ac931e182331782a566d43367f6a8938d}{writei2\+LSB}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} s)
\begin{DoxyCompactList}\small\item\em Writes a 2-\/byte (16 bit) integer to the output stream in binary little-\/endian format. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a022545153475dedae473fa2b8fbab6a9}{writei4}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} i)
\begin{DoxyCompactList}\small\item\em Writes a 4-\/byte (32 bit) integer to the output stream in binary big-\/endian format. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_ac10f5b84b61825492495daf2cbc34b10}{writei4\+LSB}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} i)
\begin{DoxyCompactList}\small\item\em Writes a 4-\/byte (32 bit) integer to the output stream in binary little-\/endian format. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a34ebb9991cdafbf4ba5bf1c6007c6d59}{writei8}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} i)
\begin{DoxyCompactList}\small\item\em Writes an 8-\/byte (64 bit) integer to the output stream in binary big-\/endian format. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stream_writer_a4d3215bb7052b0bf78cf380004b9f3b9}{writei8\+LSB}} (\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} i)
\begin{DoxyCompactList}\small\item\em Writes an 8-\/byte (64 bit) integer to the output stream in binary little-\/endian format. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
This class defines a stream writer for output streams. 

\begin{DoxySince}{Since}
Qore 0.\+8.\+13
\end{DoxySince}
\begin{DoxyParagraph}{Example\+: Stream\+Writer basic usage}

\begin{DoxyCode}{0}
\DoxyCodeLine{FileOutputStream os(\textcolor{stringliteral}{"{}log.txt"{}});}
\DoxyCodeLine{StreamWriter sw(os, \textcolor{stringliteral}{"{}UTF-\/8"{}});}
\DoxyCodeLine{sw.print(\textcolor{stringliteral}{"{}Lorem ipsum.\(\backslash\)n"{}});}
\DoxyCodeLine{sw.printf(\textcolor{stringliteral}{"{}\%s: \%d\(\backslash\)n"{}}, \textcolor{stringliteral}{"{}The answer"{}}, 42);}
\DoxyCodeLine{sw.print(\textcolor{stringliteral}{"{}32-\/bit int values:\(\backslash\)n"{}});}
\DoxyCodeLine{sw.writei4(1337);}
\DoxyCodeLine{sw.writei4(0xf4f4);}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} 
\end{DoxySeeAlso}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_ad36abd7aa5d58d5e8abb40badaa55299}\label{class_qore_1_1_stream_writer_ad36abd7aa5d58d5e8abb40badaa55299}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}}
{\footnotesize\ttfamily Qore\+::\+Stream\+Writer\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{class_qore_1_1_output_stream}{Qore\+::\+Output\+Stream}}}]{os,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{encoding }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}} for writing data to the given \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}}. 


\begin{DoxyParams}{Parameters}
{\em os} & the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} for writing data \\
\hline
{\em encoding} & character encoding of the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}; all passed string data will be converted to this encoding before being written to the output stream; if not present, the \mbox{\hyperlink{character_encoding_default_encoding}{default character encoding}} is assumed \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a2d07ac7783e3ff6db3adaa455fb68054}\label{class_qore_1_1_stream_writer_a2d07ac7783e3ff6db3adaa455fb68054}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!f\_printf@{f\_printf}}
\index{f\_printf@{f\_printf}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{f\_printf()}{f\_printf()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::f\+\_\+printf (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{fmt,  }\item[{}]{... }\end{DoxyParamCaption})}



Writes a formatted string with hard field widths to an output stream; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. 

This method does not allow arguments to overrun field width specifiers in the format string.

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.f\_printf(\textcolor{stringliteral}{"{}\%5s\(\backslash\)n"{}}, \textcolor{stringliteral}{"{}hello there"{}}); \textcolor{comment}{\# outputs "{}hello\(\backslash\)n"{}, enforcing field width}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em fmt} & the format string; see \mbox{\hyperlink{group__string__functions_string_formatting}{String Formatting}} for more information about the format string\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & error converting from the string\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}}\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_writer_a84e2fc7dc8253f96c00f79870f3c4bbb}{Stream\+Writer\+::printf()}} for a similar method that does not enforce field widths 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_aed4f874595474208e7f8b5561f081dad}\label{class_qore_1_1_stream_writer_aed4f874595474208e7f8b5561f081dad}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!f\_vprintf@{f\_vprintf}}
\index{f\_vprintf@{f\_vprintf}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{f\_vprintf()}{f\_vprintf()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::f\+\_\+vprintf (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{fmt,  }\item[{any}]{fmt\+\_\+args }\end{DoxyParamCaption})}



Writes a formatted string with hard field widths to an output stream, where the second argument is the formatting argument list; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. 

This method does not allow arguments to overrun field width specifiers in the format string.

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.f\_vprintf(\textcolor{stringliteral}{"{}\%5s: \%d\(\backslash\)n"{}}, (\textcolor{stringliteral}{"{}hello there"{}}, 2)); \textcolor{comment}{\# outputs "{}hello: 2\(\backslash\)n"{}, enforcing field width}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em fmt} & the format string; see \mbox{\hyperlink{group__string__functions_string_formatting}{String Formatting}} for more information about the format string \\
\hline
{\em fmt\+\_\+args} & the single argument or list of arguments that will be used as the argument list for the format string. If a single argument is passed instead of a list, it will be used as the first argument as if a list were passed\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & error converting from the string\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}}\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_writer_a84e2fc7dc8253f96c00f79870f3c4bbb}{Stream\+Writer\+::printf()}} for a similar method that does not enforce field widths 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a1ff1c44aed52fcb6d925b6d9c72fb162}\label{class_qore_1_1_stream_writer_a1ff1c44aed52fcb6d925b6d9c72fb162}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!getEncoding@{getEncoding}}
\index{getEncoding@{getEncoding}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{getEncoding()}{getEncoding()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+Stream\+Writer\+::get\+Encoding (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
Returns the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}.

\begin{DoxyReturn}{Returns}
the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}} 
\end{DoxyReturn}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a43a64e7d6774c777071fff39245477d6}\label{class_qore_1_1_stream_writer_a43a64e7d6774c777071fff39245477d6}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!getOutputStream@{getOutputStream}}
\index{getOutputStream@{getOutputStream}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{getOutputStream()}{getOutputStream()}}
{\footnotesize\ttfamily \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} Qore\+::\+Stream\+Writer\+::get\+Output\+Stream (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} for the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}. 

Returns the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} for the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}.

\begin{DoxyReturn}{Returns}
the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} for the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}
\end{DoxyReturn}
\begin{DoxySince}{Since}
0.\+9.\+0 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a725a0b783c28f325cdd049c6d5585106}\label{class_qore_1_1_stream_writer_a725a0b783c28f325cdd049c6d5585106}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!print@{print}}
\index{print@{print}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{print()}{print()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::print (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{str }\end{DoxyParamCaption})}



Writes string data to an output stream; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.print(str);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em str} & the string to be written to the output stream; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & error converting from the string\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{class_qore_1_1_stream_writer_a008eb323b5c9188dfd13a7ecab3f6bf4}{write(string)}} 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a84e2fc7dc8253f96c00f79870f3c4bbb}\label{class_qore_1_1_stream_writer_a84e2fc7dc8253f96c00f79870f3c4bbb}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!printf@{printf}}
\index{printf@{printf}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{printf()}{printf()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::printf (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{fmt,  }\item[{}]{... }\end{DoxyParamCaption})}



Writes a formatted string with soft field widths to an output stream; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. 

This method will allow arguments to overrun field width specifiers in the format string.

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.printf(\textcolor{stringliteral}{"{}\%5s\(\backslash\)n"{}}, \textcolor{stringliteral}{"{}hello there"{}}); \textcolor{comment}{\# outputs "{}hello there\(\backslash\)n"{}, exceeding field width}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em fmt} & the format string; see \mbox{\hyperlink{group__string__functions_string_formatting}{String Formatting}} for more information about the format string\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & error converting from the string\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}}\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_writer_a2d07ac7783e3ff6db3adaa455fb68054}{Stream\+Writer\+::f\+\_\+printf()}} for a similar method that enforces field widths 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_ab7905ebc40095b30dfe9e78cbf43aca1}\label{class_qore_1_1_stream_writer_ab7905ebc40095b30dfe9e78cbf43aca1}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!vprintf@{vprintf}}
\index{vprintf@{vprintf}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{vprintf()}{vprintf()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::vprintf (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{fmt,  }\item[{any}]{fmt\+\_\+args }\end{DoxyParamCaption})}



Writes a formatted string with soft field widths to an output stream, where the second argument is the formatting argument list; string data is converted to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} if necessary before writing. 

This method will allow arguments to overrun field width specifiers in the format string.

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.vprintf(\textcolor{stringliteral}{"{}\%5s: \%d\(\backslash\)n"{}}, (\textcolor{stringliteral}{"{}hello there"{}}, 2)); \textcolor{comment}{\# outputs "{}hello there: 2\(\backslash\)n"{}, exceeding field width}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em fmt} & the format string; see \mbox{\hyperlink{group__string__functions_string_formatting}{String Formatting}} for more information about the format string \\
\hline
{\em fmt\+\_\+args} & the single argument or list of arguments that will be used as the argument list for the format string. If a single argument is passed instead of a list, it will be used as the first argument as if a list were passed\\
\hline
\end{DoxyParams}

\begin{DoxyExceptions}{Exceptions}
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & error converting from the string\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}} to the \mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}}\textquotesingle{}s \mbox{\hyperlink{character_encoding}{character encoding}}\\
\hline
\end{DoxyExceptions}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_writer_aed4f874595474208e7f8b5561f081dad}{Stream\+Writer\+::f\+\_\+vprintf()}} for a similar method that enforces field widths 
\end{DoxySeeAlso}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a8b76d2ba82556449be270bfe8c3305e8}\label{class_qore_1_1_stream_writer_a8b76d2ba82556449be270bfe8c3305e8}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!write@{write}}
\index{write@{write}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{write()}{write()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::write (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}}]{b }\end{DoxyParamCaption})}



Writes a \mbox{\hyperlink{basic_data_types_binary}{Binary}} to the output stream. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.write(<010203>);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em b} & the binary to write \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a008eb323b5c9188dfd13a7ecab3f6bf4}\label{class_qore_1_1_stream_writer_a008eb323b5c9188dfd13a7ecab3f6bf4}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!write@{write}}
\index{write@{write}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{write()}{write()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::write (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{str }\end{DoxyParamCaption})}



Writes a \mbox{\hyperlink{basic_data_types_string}{String}} to the output stream. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.write(\textcolor{stringliteral}{"{}string"{}});}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em str} & the string to write\\
\hline
\end{DoxyParams}
\begin{DoxyNote}{Note}
equivalent to \mbox{\hyperlink{class_qore_1_1_stream_writer_a725a0b783c28f325cdd049c6d5585106}{print(string)}} 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a61c9f957f77d9581aa4cf564ea8ed401}\label{class_qore_1_1_stream_writer_a61c9f957f77d9581aa4cf564ea8ed401}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!writei1@{writei1}}
\index{writei1@{writei1}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{writei1()}{writei1()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::writei1 (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{c }\end{DoxyParamCaption})}



Writes a 1-\/byte signed integer to the output stream. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.writei1(val);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em c} & the integer to write; only the least-\/significant 8 bits will be written to the file \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a1a395f2c4fb63d4e6cf73c315db0659b}\label{class_qore_1_1_stream_writer_a1a395f2c4fb63d4e6cf73c315db0659b}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!writei2@{writei2}}
\index{writei2@{writei2}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{writei2()}{writei2()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::writei2 (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{s }\end{DoxyParamCaption})}



Writes a 2-\/byte (16 bit) integer to the output stream in binary big-\/endian format. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.writei2(val);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em s} & the integer to write in binary big-\/endian format; only the least-\/significant 16 bits of the integer will be written to the file \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_ac931e182331782a566d43367f6a8938d}\label{class_qore_1_1_stream_writer_ac931e182331782a566d43367f6a8938d}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!writei2LSB@{writei2LSB}}
\index{writei2LSB@{writei2LSB}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{writei2LSB()}{writei2LSB()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::writei2\+LSB (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{s }\end{DoxyParamCaption})}



Writes a 2-\/byte (16 bit) integer to the output stream in binary little-\/endian format. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.writei2LSB(val);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em s} & the integer to write in binary little-\/endian format; only the least-\/significant 16 bits of the integer will be written to the file \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a022545153475dedae473fa2b8fbab6a9}\label{class_qore_1_1_stream_writer_a022545153475dedae473fa2b8fbab6a9}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!writei4@{writei4}}
\index{writei4@{writei4}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{writei4()}{writei4()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::writei4 (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{i }\end{DoxyParamCaption})}



Writes a 4-\/byte (32 bit) integer to the output stream in binary big-\/endian format. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.writei4(val);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em i} & the integer to write in binary big-\/endian format; only the least-\/significant 32 bits of the integer will be written to the file \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_ac10f5b84b61825492495daf2cbc34b10}\label{class_qore_1_1_stream_writer_ac10f5b84b61825492495daf2cbc34b10}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!writei4LSB@{writei4LSB}}
\index{writei4LSB@{writei4LSB}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{writei4LSB()}{writei4LSB()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::writei4\+LSB (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{i }\end{DoxyParamCaption})}



Writes a 4-\/byte (32 bit) integer to the output stream in binary little-\/endian format. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.writei4LSB(val);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em i} & the integer to write in binary little-\/endian format; only the least-\/significant 32 bits of the integer will be written to the file \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a34ebb9991cdafbf4ba5bf1c6007c6d59}\label{class_qore_1_1_stream_writer_a34ebb9991cdafbf4ba5bf1c6007c6d59}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!writei8@{writei8}}
\index{writei8@{writei8}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{writei8()}{writei8()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::writei8 (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{i }\end{DoxyParamCaption})}



Writes an 8-\/byte (64 bit) integer to the output stream in binary big-\/endian format. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.writei8(val);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em i} & the integer to write in binary big-\/endian format; only the least-\/significant 64 bits of the integer will be written to the file \\
\hline
\end{DoxyParams}
\mbox{\Hypertarget{class_qore_1_1_stream_writer_a4d3215bb7052b0bf78cf380004b9f3b9}\label{class_qore_1_1_stream_writer_a4d3215bb7052b0bf78cf380004b9f3b9}} 
\index{Qore::StreamWriter@{Qore::StreamWriter}!writei8LSB@{writei8LSB}}
\index{writei8LSB@{writei8LSB}!Qore::StreamWriter@{Qore::StreamWriter}}
\doxysubsubsection{\texorpdfstring{writei8LSB()}{writei8LSB()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stream\+Writer\+::writei8\+LSB (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}}}]{i }\end{DoxyParamCaption})}



Writes an 8-\/byte (64 bit) integer to the output stream in binary little-\/endian format. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{sw.writei8LSB(val);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em i} & the integer to write in binary little-\/endian format; only the least-\/significant 64 bits of the integer will be written to the file \\
\hline
\end{DoxyParams}
