\hypertarget{class_qore_1_1_stdout_output_stream}{}\doxysection{Qore\+::Stdout\+Output\+Stream Class Reference}
\label{class_qore_1_1_stdout_output_stream}\index{Qore::StdoutOutputStream@{Qore::StdoutOutputStream}}


This class implements the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} interface for writing bytes to the standard output stream {\ttfamily stdout}.  




Inheritance diagram for Qore\+::Stdout\+Output\+Stream\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
nothing \mbox{\hyperlink{class_qore_1_1_stdout_output_stream_ac343ce67083b91d78d59f6828e0be3fb}{close}} ()
\begin{DoxyCompactList}\small\item\em Does nothing since {\ttfamily stdout} cannot be closed. \end{DoxyCompactList}\item 
\mbox{\Hypertarget{class_qore_1_1_stdout_output_stream_ae431e6ac1c658a287949153bf441eef1}\label{class_qore_1_1_stdout_output_stream_ae431e6ac1c658a287949153bf441eef1}} 
\mbox{\hyperlink{class_qore_1_1_stdout_output_stream_ae431e6ac1c658a287949153bf441eef1}{constructor}} ()
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_stdout_output_stream}{Stdout\+Output\+Stream}}. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_stdout_output_stream_a83ad20353fe0e6333e41f9ace31ce802}{write}} (\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} data)
\begin{DoxyCompactList}\small\item\em Writes bytes to the output stream. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
This class implements the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} interface for writing bytes to the standard output stream {\ttfamily stdout}. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_gaa92bf6eafb76a4ccf1a0d0df45b13363}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+TERMINAL\+\_\+\+IO}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+: Stdout\+Output\+Stream basic usage}

\begin{DoxyCode}{0}
\DoxyCodeLine{StdoutOutputStream stdos();}
\DoxyCodeLine{stdos.write(<01>);}
\DoxyCodeLine{stdos.write(<0203>);}
\DoxyCodeLine{\textcolor{comment}{\# three bytes have been written to stdout: 01 02 03}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
stream classes are not designed to be accessed from multiple threads; they have been implemented without locking for fast and efficient use when used from a single thread. For methods that would be unsafe to use in another thread, any use of such methods in threads other than the thread where the constructor was called will cause a {\ttfamily STREAM-\/\+THREAD-\/\+ERROR} to be thrown, unless the stream is handed off to another thread using the \mbox{\hyperlink{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}{Stream\+Base\+::unassign\+Thread()}} method in the thread that currently owns the stream, and the \mbox{\hyperlink{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}{Stream\+Base\+::reassign\+Thread()}} method in the new thread.
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}} for a class that can be used to \mbox{\hyperlink{class_qore_1_1_stdout_output_stream_a83ad20353fe0e6333e41f9ace31ce802}{write}} various kinds of data to an \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_stdout_output_stream_ac343ce67083b91d78d59f6828e0be3fb}\label{class_qore_1_1_stdout_output_stream_ac343ce67083b91d78d59f6828e0be3fb}} 
\index{Qore::StdoutOutputStream@{Qore::StdoutOutputStream}!close@{close}}
\index{close@{close}!Qore::StdoutOutputStream@{Qore::StdoutOutputStream}}
\doxysubsubsection{\texorpdfstring{close()}{close()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stdout\+Output\+Stream\+::close (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Does nothing since {\ttfamily stdout} cannot be closed. 


\begin{DoxyExceptions}{Exceptions}
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object \\
\hline
\end{DoxyExceptions}


Implements \mbox{\hyperlink{class_qore_1_1_output_stream_a2125e17612767b9636554b282638e883}{Qore\+::\+Output\+Stream}}.

\mbox{\Hypertarget{class_qore_1_1_stdout_output_stream_a83ad20353fe0e6333e41f9ace31ce802}\label{class_qore_1_1_stdout_output_stream_a83ad20353fe0e6333e41f9ace31ce802}} 
\index{Qore::StdoutOutputStream@{Qore::StdoutOutputStream}!write@{write}}
\index{write@{write}!Qore::StdoutOutputStream@{Qore::StdoutOutputStream}}
\doxysubsubsection{\texorpdfstring{write()}{write()}}
{\footnotesize\ttfamily nothing Qore\+::\+Stdout\+Output\+Stream\+::write (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}}]{data }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Writes bytes to the output stream. 


\begin{DoxyParams}{Parameters}
{\em data} & the data to write\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{StdoutOutputStream stdos();}
\DoxyCodeLine{stdos.write(<01>);}
\DoxyCodeLine{stdos.write(<0203>);}
\DoxyCodeLine{\textcolor{comment}{\# three bytes have been written to stdout: 01 02 03}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object \\
\hline
\end{DoxyExceptions}


Implements \mbox{\hyperlink{class_qore_1_1_output_stream_a9054b0475c4829d10f956d8f6df6f2ac}{Qore\+::\+Output\+Stream}}.

