\hypertarget{class_qore_1_1_s_s_l_private_key}{}\doxysection{Qore\+::SSLPrivate\+Key Class Reference}
\label{class_qore_1_1_s_s_l_private_key}\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}


This class implements a container for private key data.  




Inheritance diagram for Qore\+::SSLPrivate\+Key\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
\mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_affdb0026e65213516c7d088074d1aec2}{constructor}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} pem, \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} pass)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key}{SSLPrivate\+Key}} object from the PEM-\/encoded text representation of the private key passed. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_a7310bce372479a38a90dbc521710256e}{constructor}} (\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} der)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key}{SSLPrivate\+Key}} object from the data argument passed. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_abc635ed38e5d73865bbc356267b6d26e}{copy}} ()
\begin{DoxyCompactList}\small\item\em Returns a copy of the private key object. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_aa21b2182522c30d4ce8fdd31479f946e}{get\+Bit\+Length}} ()
\begin{DoxyCompactList}\small\item\em Returns the bit length of the private key. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_af6efb915453871f442bed6554a30b156}{get\+DER}} ()
\begin{DoxyCompactList}\small\item\em Returns a binary object in DER format representing the private key. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_a80eea3bfa8f7b8b34bce84b1667d9106}{get\+Info}} ()
\begin{DoxyCompactList}\small\item\em Returns a hash of all information for the private key. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_a9e95fdac083338d89e1806a4409e6e22}{get\+PEM}} ()
\begin{DoxyCompactList}\small\item\em Returns a string in PEM format representing the private key. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_ab6a45cf567fddcc9c36e7d0fe2b956fb}{get\+Type}} ()
\begin{DoxyCompactList}\small\item\em Returns a string giving the algorithm used for the private key. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_a61566e34227646a2d1a6a992f5aeb994}{get\+Version}} ()
\begin{DoxyCompactList}\small\item\em Returns a constant value of 1; do not use; only included for backwards-\/compatibility. \end{DoxyCompactList}\end{DoxyCompactItemize}
\doxysubsection*{Additional Inherited Members}


\doxysubsection{Detailed Description}
This class implements a container for private key data. 

The \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key}{SSLPrivate\+Key}} class supports \mbox{\hyperlink{class_qore_1_1_serializable}{data serialization}}; note that the serialized data is a representation of the data that does not require a password, so for source data that requires a password to use, the serialized representation of the private key should be protected carefully (transmitted only in an encrypted stream) 

\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_s_s_l_private_key_a7310bce372479a38a90dbc521710256e}\label{class_qore_1_1_s_s_l_private_key_a7310bce372479a38a90dbc521710256e}} 
\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily Qore\+::\+SSLPrivate\+Key\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}}]{der }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key}{SSLPrivate\+Key}} object from the data argument passed. 


\begin{DoxyParams}{Parameters}
{\em der} & The DER-\/encoded binary representation of the private key\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{SSLPrivateKey key(der);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SSLPRIVATEKEY-\/\+CONSTRUCTOR-\/\+ERROR} & error in private key data \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_s_s_l_private_key_affdb0026e65213516c7d088074d1aec2}\label{class_qore_1_1_s_s_l_private_key_affdb0026e65213516c7d088074d1aec2}} 
\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily Qore\+::\+SSLPrivate\+Key\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{pem,  }\item[{\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{pass }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key}{SSLPrivate\+Key}} object from the PEM-\/encoded text representation of the private key passed. 


\begin{DoxyParams}{Parameters}
{\em pem} & The PEM-\/encoded text representation of the private key \\
\hline
{\em pass} & The optional password or passphrase for the private key\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{SSLPrivateKey key(pem);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SSLPRIVATEKEY-\/\+CONSTRUCTOR-\/\+ERROR} & error in private key data\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
0.\+8.\+4\+: the deprecated functionality where the if the string passed was less than 200 bytes long, it was assumed to be a file name has been removed; the string is assumed to be the PEM-\/encoded private key itself 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_s_l_private_key_abc635ed38e5d73865bbc356267b6d26e}\label{class_qore_1_1_s_s_l_private_key_abc635ed38e5d73865bbc356267b6d26e}} 
\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}!copy@{copy}}
\index{copy@{copy}!Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}
\doxysubsubsection{\texorpdfstring{copy()}{copy()}}
{\footnotesize\ttfamily Qore\+::\+SSLPrivate\+Key\+::copy (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a copy of the private key object. 

\begin{DoxySince}{Since}
Qore 0.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_s_l_private_key_aa21b2182522c30d4ce8fdd31479f946e}\label{class_qore_1_1_s_s_l_private_key_aa21b2182522c30d4ce8fdd31479f946e}} 
\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}!getBitLength@{getBitLength}}
\index{getBitLength@{getBitLength}!Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}
\doxysubsubsection{\texorpdfstring{getBitLength()}{getBitLength()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+SSLPrivate\+Key\+::get\+Bit\+Length (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the bit length of the private key. 

\begin{DoxyReturn}{Returns}
the bit length of the private key
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int len = key.getBitLength();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_s_l_private_key_af6efb915453871f442bed6554a30b156}\label{class_qore_1_1_s_s_l_private_key_af6efb915453871f442bed6554a30b156}} 
\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}!getDER@{getDER}}
\index{getDER@{getDER}!Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}
\doxysubsubsection{\texorpdfstring{getDER()}{getDER()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} Qore\+::\+SSLPrivate\+Key\+::get\+DER (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a binary object in DER format representing the private key. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{binary der = key.getDER();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
a binary object in DER format representing the private key
\end{DoxyReturn}
\begin{DoxyNote}{Note}
No password is required to use the DER data produced even if the object was originally created with a password
\end{DoxyNote}

\begin{DoxyExceptions}{Exceptions}
{\em SSLPRIVATEKEY-\/\+ERROR} & could not create DER data from private key data\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+9 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_s_l_private_key_a80eea3bfa8f7b8b34bce84b1667d9106}\label{class_qore_1_1_s_s_l_private_key_a80eea3bfa8f7b8b34bce84b1667d9106}} 
\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}!getInfo@{getInfo}}
\index{getInfo@{getInfo}!Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}
\doxysubsubsection{\texorpdfstring{getInfo()}{getInfo()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SSLPrivate\+Key\+::get\+Info (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a hash of all information for the private key. 

\begin{DoxyReturn}{Returns}
a hash of all information for the private key with the following keys\+:
\begin{DoxyItemize}
\item {\ttfamily \char`\"{}type\char`\"{}}\+: The type of private key (see \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_ab6a45cf567fddcc9c36e7d0fe2b956fb}{SSLPrivate\+Key\+::get\+Type()}})
\item {\ttfamily \char`\"{}version\char`\"{}}\+: The version of the private key (see \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_a61566e34227646a2d1a6a992f5aeb994}{SSLPrivate\+Key\+::get\+Version()}})
\item {\ttfamily \char`\"{}bit\+Length\char`\"{}}\+: The bit length of the private key (see \mbox{\hyperlink{class_qore_1_1_s_s_l_private_key_aa21b2182522c30d4ce8fdd31479f946e}{SSLPrivate\+Key\+::get\+Bit\+Length()}})
\end{DoxyItemize}
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{hash<auto> h = key.getInfo();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_s_l_private_key_a9e95fdac083338d89e1806a4409e6e22}\label{class_qore_1_1_s_s_l_private_key_a9e95fdac083338d89e1806a4409e6e22}} 
\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}!getPEM@{getPEM}}
\index{getPEM@{getPEM}!Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}
\doxysubsubsection{\texorpdfstring{getPEM()}{getPEM()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SSLPrivate\+Key\+::get\+PEM (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a string in PEM format representing the private key. 

\begin{DoxyReturn}{Returns}
a string in PEM format representing the private key
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string pem = key.getPEM();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
No password is required to use the PEM data produced even if the object was originally created with a password
\end{DoxyNote}

\begin{DoxyExceptions}{Exceptions}
{\em SSLPRIVATEKEY-\/\+ERROR} & could not create PEM string from private key data \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_s_s_l_private_key_ab6a45cf567fddcc9c36e7d0fe2b956fb}\label{class_qore_1_1_s_s_l_private_key_ab6a45cf567fddcc9c36e7d0fe2b956fb}} 
\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}!getType@{getType}}
\index{getType@{getType}!Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}
\doxysubsubsection{\texorpdfstring{getType()}{getType()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SSLPrivate\+Key\+::get\+Type (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a string giving the algorithm used for the private key. 

\begin{DoxyReturn}{Returns}
a string giving the algorithm used for the private key (ex\+: {\ttfamily \char`\"{}\+RSA\char`\"{}}, {\ttfamily \char`\"{}\+RSA2\char`\"{}}, {\ttfamily \char`\"{}\+DSA\char`\"{}}, {\ttfamily \char`\"{}\+DSA1\char`\"{}}, {\ttfamily \char`\"{}\+DSA2\char`\"{}}, {\ttfamily \char`\"{}\+DAS3\char`\"{}}, {\ttfamily \char`\"{}\+DAS4\char`\"{}}, {\ttfamily \char`\"{}\+DH\char`\"{}}, {\ttfamily \char`\"{}unknown\char`\"{}})
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{string str = pkey.getType();}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_s_l_private_key_a61566e34227646a2d1a6a992f5aeb994}\label{class_qore_1_1_s_s_l_private_key_a61566e34227646a2d1a6a992f5aeb994}} 
\index{Qore::SSLPrivateKey@{Qore::SSLPrivateKey}!getVersion@{getVersion}}
\index{getVersion@{getVersion}!Qore::SSLPrivateKey@{Qore::SSLPrivateKey}}
\doxysubsubsection{\texorpdfstring{getVersion()}{getVersion()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+SSLPrivate\+Key\+::get\+Version (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns a constant value of 1; do not use; only included for backwards-\/compatibility. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
The openssl library never put any usable value into the internal fields that were used to provide this information; newer versions of openssl do not expose this information at all, therefore this method now returns a constant value of 1 for backwards-\/compatibility.

\begin{DoxyReturn}{Returns}
a constant value of 1; do not use; only included for backwards-\/compatibility 
\end{DoxyReturn}
./../../lang/html/group__string__functions.html#gaff249219345cbb027c8868c82585383a',1,'trim()(Global Namespace)'],['../../../../lang/html/group__string__functions.html#gabcd44cef4eddf5659153a57bdc312db8',1,'trim(reference&lt; string &gt; str, *string chars)(Global Namespace)'],['../../../../lang/html/group__string__functions.html#gae8d314e819a299d46d181696600d4293',1,'trim(string str, *string chars)(Global Namespace)'],['../../../../lang/html/group__string__functions.html#gaff249219345cbb027c8868c82585383a',1,'Qore::trim()']]],
  ['true_2420',['True',['../../../../lang/html/group__boolean__constants.html#ga3ba2df91713a6249449347131ea526c3',1,'True()(Global Namespace)'],['../../../../lang/html/group__boolean__constants.html#ga3ba2df91713a6249449347131ea526c3',1,'Qore::True()']]],
  ['trunc_5fstr_2421',['trunc_str',['../../../../lang/html/group__string__functions.html#ga49c6b104180fd40bb21d164773df1f4b',1,'Qore::trunc_str()'],['../../../../lang/html/group__string__functions.html#ga49c6b104180fd40bb21d164773df1f4b',1,'trunc_str()(Global Namespace)']]],
  ['tryenter_2422',['tryEnter',['../../../../lang/html/class_qore_1_1_thread_1_1_gate.html#ae8358c58fb1eff5cddbc34cbec5e6d8d',1,'Qore::Thread::Gate']]],
  ['trygetfactorymodulename_2423',['tryGetFactoryModuleName',['../class_data_provider_1_1_data_provider.html#afe80962e2c26da9a0dc983c4f7e000d2',1,'DataProvider::DataProvider']]],
  ['trygetmodulename_2424',['tryGetModuleName',['../class_data_provider_1_1_data_provider.html#a77a891525c01253effabf83bd44e45da',1,'DataProvider::DataProvider']]],
  ['trygettypemodulename_2425',['tryGetTypeModuleName',['../class_data_provider_1_1_data_provider.html#adc280dc136ac627587a205f27ef16790',1,'DataProvider::DataProvider']]],
  ['tryload_2426',['tryLoad',['../class_data_provider_1_1_data_provider.html#aa1612ce3d5456b58d2b70d9381f53a6d',1,'DataProvider::DataProvider']]],
  ['tryloadproviderforconnectionfromenv_2427',['tryLoadProviderForConnectionFromEnv',['../class_data_provider_1_1_data_provider.html#abb70ac1224f226fd2d0849ff78584d37',1,'DataProvider::DataProvider']]],
  ['tryloadtypefrompath_2428',['tryLoadTypeFromPath',['../class_data_provider_1_1_data_provider.html#a1900b378d38dd703a8c4c61819138762',1,'DataProvider::DataProvider']]],
  ['trylock_2429',['trylock',['../../../../lang/html/class_qore_1_1_thread_1_1_auto_lock.html#ab016e55812b0814fedce775ea018f8ff',1,'Qore::Thread::AutoLock::trylock()'],['../../../../lang/html/class_qore_1_1_thread_1_1_mutex.html#abcc3818211d37882c0549bfcbe7c487b',1,'Qore::Thread::Mutex::trylock()']]],
  ['tryreadlock_2430',['tryReadLock',['../../../../lang/html/class_qore_1_1_thread_1_1_r_w_lock.html#ae6ae2fb6dadf5d144dbd7694c0ca0bfb',1,'Qore::Thread::RWLock']]],
  ['trywritelock_2431',['tryWriteLock',['../../../../lang/html/class_qore_1_1_thread_1_1_r_w_lock.html#a20b09807edecf2ee7591e90e16c4fe6c',1,'Qore::Thread::RWLock']]],
  ['type_2432',['type',['../class_data_provider_1_1_null_data_provider.html#afc8a2b75d57866ed6e11aed78b8061cf',1,'DataProvider::NullDataProvider::type()'],['../../../../lang/html/struct_qore_1_1_call_stack_info.html#aeb882a998726c6b430861b440ebd7af2',1,'Qore::CallStackInfo::type()'],['../../../../lang/html/group__type__conversion__functions.html#ga181e32c9bc8075431e88bb9bb56285a9',1,'type()(Global Namespace)'],['../../../../lang/html/group__type__conversion__functions.html#ga181e32c9bc8075431e88bb9bb56285a9',1,'Qore::type()'],['../class_data_provider_1_1_qore_data_type.html#a843543aa04701a42a74c0e77e58ec9b8',1,'DataProvider::QoreDataType::type()'],['../class_data_provider_1_1_qore_data_field.html#af156db89b1db883370d438914f65583c',1,'DataProvider::QoreDataField::type()'],['../class_data_provider_1_1_data_provider_type_entry.html#abb185e74fbe8d7d037fb5e6fb5074b81',1,'DataProvider::DataProviderTypeEntry::type()'],['../struct_data_provider_1_1_data_provider_type_option_info.html#ac594314905a68ff9b08028e927f1a40f',1,'DataProvider::DataProviderTypeOptionInfo::type()'],['../struct_data_provider_1_1_data_provider_info.html#a35b6587734a2c9d4b9e2a8b646a7b0b5',1,'DataProvider::DataProviderInfo::type()'],['../struct_data_provider_1_1_data_provider_expression_info.html#aa1f3001b5216af47c3f69cf9675471f2',1,'DataProvider::DataProviderExpressionInfo::type()'],['../../../../lang/html/struct_qore_1_1_exception_info.html#ac1fa44325ded882f0eda1572361870f9',1,'Qore::ExceptionInfo::type()'],['../../../../lang/html/class_qore_1_1zzz8valuezzz9.html#a333453fca3889bfa8d4159b921b1ab87',1,'Qore::&lt;value&gt;::type()'],['../../../../lang/html/struct_qore_1_1_dir_stat_info.html#a0cdf5dc6f82d812af5c1ef413b5d408a',1,'Qore::DirStatInfo::type()'],['../struct_data_provider_1_1_data_provider_signature_type_info.html#af2c7d8fb633831a49a5880944b848eba',1,'DataProvider::DataProviderSignatureTypeInfo::type()'],['../../../../lang/html/struct_qore_1_1_stat_info.html#a18cf1386b9853803830938518642797d',1,'Qore::StatInfo::type()'],['../struct_data_provider_1_1_data_provider_message_info.html#a483a1b102338e6e194098b6f4469911b',1,'DataProvider::DataProviderMessageInfo::type()'],['../struct_data_provider_1_1_data_field_info.html#a75b2087e43972fe2789242c31901ce8f',1,'DataProvider::DataFieldInfo::type()'],['../struct_data_provider_1_1_data_provider_summary_info.html#ac442d8846d619802fc28a3972b9d3e65',1,'DataProvider::DataProviderSummaryInfo::type()'],['../struct_data_provider_1_1_data_provider_option_info.html#a2dbe179269d7066a25ea25b580a0f728',1,'DataProvider::DataProviderOptionInfo::type()']]],
  ['type_20code_20constants_2433',['Type Code Constants',['../../../../lang/html/group__type__code__constants.html',1,'']]],
  ['type_20code_20map_20constants_2434',['Type Code Map Constants',['../../../../lang/html/group__type__code__map__constants.html',1,'']]],
  ['type_20conversion_20functions_2435',['Type Conversion Functions',['../../../../lang/html/group__type__conversion__functions.html',1,'']]],
  ['type_5fcache_2436',['type_cache',['../class_data_provider_1_1_data_provider.html#aa0ffb59b00a96d7789f3f7b629b3b96f',1,'DataProvider::DataProvider']]],
  ['type_5fchildren_2437',['type_children',['../class_data_provider_1_1_data_provider_type_entry.html#a6e921e5c359ded7bed04d524b8444279',1,'DataProvider::DataProviderTypeEntry']]],
  ['type_5fcode_2438',['type_code',['../struct_data_provider_1_1_data_provider_signature_type_info.html#aefde8e27cc3b669822c20380681663fc',1,'DataProvider::DataProviderSignatureTypeInfo']]],
  ['type_5fmodule_5fmap_2439',['type_module_map',['../class_data_provider_1_1_data_provider.html#a837b3f27ef4fd6bc9d520d2fd13827ab',1,'DataProvider::DataProvider']]],
  ['typecode_2440',['typeCode',['../../../../lang/html/class_qore_1_1zzz8boolzzz9.html#ab1dbc0ed03411f54af90e04a8172a56a',1,'Qore::&lt;bool&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8callrefzzz9.html#a97100bbe7d1e17609fabaeb48ca048c2',1,'Qore::&lt;callref&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8closurezzz9.html#ad79e74e23686d219752434cfebd2a876',1,'Qore::&lt;closure&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8binaryzzz9.html#a0e1c6cd63c6dfab74ff85b53a462b4ec',1,'Qore::&lt;binary&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8datezzz9.html#a7167b9d2407c8a6448f53e3ebc1670a1',1,'Qore::&lt;date&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8floatzzz9.html#a24f3f33fcd172c04cff733cc4f7628b5',1,'Qore::&lt;float&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8hashzzz9.html#af648c06c9cd615790aae13c7278efeee',1,'Qore::&lt;hash&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8intzzz9.html#a3bd4fe812c0232129fed669206bbcf58',1,'Qore::&lt;int&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8listzzz9.html#a6eedcfa07a8f8dcbe75eadcb3e5f607b',1,'Qore::&lt;list&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8nothingzzz9.html#ac5be3597199401b8a073c19ac7683bf0',1,'Qore::&lt;nothing&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8numberzzz9.html#ae2c7a3126a3d07d4657043b6f548b1a0',1,'Qore::&lt;number&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8objectzzz9.html#acc70957477ea8677a95ebeb04636459e',1,'Qore::&lt;object&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8stringzzz9.html#a4a3e3f0f6d983caea261935b2d3424f1',1,'Qore::&lt;string&gt;::typeCode()'],['../../../../lang/html/class_qore_1_1zzz8valuezzz9.html#a5e7d381ab49abebd0d0f045708482512',1,'Qore::&lt;value&gt;::typeCode()']]],
  ['typecode_2441',['typecode',['../../../../lang/html/struct_qore_1_1_call_stack_info.html#a6d8d1cc307ede76d91eb0f3ca905ca9b',1,'Qore::CallStackInfo']]],
  ['typecodemap_2442',['TypeCodeMap',['../../../../lang/html/group__type__code__map__constants.html#ga2a480ee5f1ba574e58391be1b3a0eb24',1,'TypeCodeMap()(Global Namespace)'],['../namespace_data_provider.html#a85f497b926e1454d778f3b3aeb4f4071',1,'DataProvider::TypeCodeMap()'],['../../../../lang/html/group__type__code__map__constants.html#ga2a480ee5f1ba574e58391be1b3a0eb24',1,'Qore::TypeCodeMap()']]],
  ['typemap_2443',['TypeMap',['../class_data_provider_1_1_data_provider.html#afde1b6e8a86538eecdaa1dbeeee13321',1,'DataProvider::DataProvider']]],
  ['typename_2444',['typename',['../../../../lang/html/group__type__conversion__functions.html#ga4e463159044f5ef430e729e8c686471c',1,'typename()(Global Namespace)'],['../../../../lang/html/group__type__conversion__functions.html#ga4e463159044f5ef430e729e8c686471c',1,'Qore::typename()']]],
  ['typenamemap_2445',['TypeNameMap',['../../../../lang/html/group__type__code__map__constants.html#gabd2d01582297bf26346d7fd7e81163cd',1,'TypeNameMap()(Global Namespace)'],['../../../../lang/html/group__type__code__map__constants.html#gabd2d01582297bf26346d7fd7e81163cd',1,'Qore::TypeNameMap()']]],
  ['types_5faccepted_2446',['types_accepted',['../struct_data_provider_1_1_data_type_info.html#abef42bc187f8c8a01606bcf5400b876e',1,'DataProvider::DataTypeInfo']]],
  ['types_5freturned_2447',['types_returned',['../struct_data_provider_1_1_data_type_info.html#a7a2e0ca24bb5f505633e01e192d66177',1,'DataProvider::DataTypeInfo']]]
];
