\hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{}\doxysection{Qore\+::SQL\+::SQLStatement Class Reference}
\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement}\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}


The \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} class provides the most flexibilty for executing \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} on a database server.  




Inheritance diagram for Qore\+::SQL\+::SQLStatement\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
bool \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab2435b87ba94bcd5b064084c0930d92c}{active}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the object is currently active and has a connection or transaction lock allocated to it, or \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a62e2cbca10b9b848b26fd7ebfa5dd753}{affected\+Rows}} ()
\begin{DoxyCompactList}\small\item\em Returns the number of rows affected by the last call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a3fe33af34dfcd763f12d406c91305916}{begin\+Transaction}} ()
\begin{DoxyCompactList}\small\item\em Manually starts a transaction and allocates a connection or grabs the transaction lock according to the object used in the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}} \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ae42a182f328c30f24a8092e5891631a3}{bind}} (...)
\begin{DoxyCompactList}\small\item\em Binds placeholder buffer specifications and values to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a6f55e9c97db5b359315ead0dc5b4effe}{bind\+Args}} (softlist$<$ auto $>$ vargs)
\begin{DoxyCompactList}\small\item\em Binds placeholder buffer specifications and values given as a list in the single argument to the method to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aacfe5d7ba6e1c1b6fcf5e7bc979c945f}{bind\+Placeholders}} (...)
\begin{DoxyCompactList}\small\item\em Binds placeholder buffer specifications to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_abcf1db95fb3e85e4677f141d9176b711}{bind\+Placeholders\+Args}} (softlist$<$ auto $>$ vargs)
\begin{DoxyCompactList}\small\item\em Binds placeholder buffer specifications given as a list in the single argument to the method to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab831457973f8279ce9783039cd5a720c}{bind\+Values}} (...)
\begin{DoxyCompactList}\small\item\em Binds values to value buffer specifications to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a01789f9ed02c8fc9e0b0493cf1823cb5}{bind\+Values\+Args}} (softlist$<$ auto $>$ vargs)
\begin{DoxyCompactList}\small\item\em Binds values to value buffer specifications given as a list in the single argument to the method to value buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a568ebcbb44ae14b127487524169b0d78}{close}} ()
\begin{DoxyCompactList}\small\item\em Closes the statement if it is open, however this method does not release the connection or transaction lock. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a4a5a12d0ca11cea1862152de47f0c812}{commit}} ()
\begin{DoxyCompactList}\small\item\em Commits the transaction, releases the connection or the transaction lock according to the object used in the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}, and closes the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{constructor}} (\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} ds)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} object based on the given \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object that provides the connection to the database. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af4ab2449388ac84f174e9ae2e9da2ce2}{constructor}} (\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} dsp)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} object based on the given \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object that provides the connection to the database. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a78fc987d855bd283c1ac4192743453cb}{copy}} ()
\begin{DoxyCompactList}\small\item\em Throws an exception; objects of this class cannot be copied. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a50d360812380f793b0b0ab7f0b181792}{current\+Thread\+In\+Transaction}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is in a transaction (i.\+e. holds the transaction lock), \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a22375c4a7755215cc53accc68b626ec7}{define}} ()
\begin{DoxyCompactList}\small\item\em Performs an explicit define operation on the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a1cc37a8464e3c8a6e50b08d366d3d629}{describe}} ()
\begin{DoxyCompactList}\small\item\em Describes columns in the statement result. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a235cd43bb5a46e9906c220d9caf0659a}{destructor}} ()
\begin{DoxyCompactList}\small\item\em Closes the statement if it is open and destroys the object. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{exec}} (...)
\begin{DoxyCompactList}\small\item\em Executes the bound statement with any bound buffers, also optionally allows binding placeholder buffer specifications and values to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} before executing the statement. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}{exec\+Args}} (softlist$<$ auto $>$ vargs)
\begin{DoxyCompactList}\small\item\em Executes the bound statement with any bound buffers, also optionally allows binding placeholder buffer specifications and values given as a list in the single argument to the method to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab889448c79985fc26e41b7e2086308df}{fetch\+Columns}} (softint rows=-\/1)
\begin{DoxyCompactList}\small\item\em Retrieves a block of rows as a hash of lists with the maximum number of rows determined by the argument passed; automatically advances the row pointer; with this call it is not necessary to call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}}. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab58ac988ce3517a88e3d25f5b5fbdb2b}{fetch\+Row}} ()
\begin{DoxyCompactList}\small\item\em Retrieves the current row as a hash where the keys are the column names and the values are the column values. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a9e36c9ff3e13b7bd65db1d67cd596e5a}{fetch\+Rows}} (softint rows=-\/1)
\begin{DoxyCompactList}\small\item\em Retrieves a block of rows as a list of hashes with the maximum number of rows determined by the argument passed; automatically advances the row pointer; with this call it is not necessary to call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a1aed9317985c27bfd7ca6ca2c07be32b}{get\+Output}} ()
\begin{DoxyCompactList}\small\item\em Retrieves output buffers as a hash; result sets will be returned as hashes of lists. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a5d4ec7e77c7bb751b7a49c7d8d6433e3}{get\+Output\+Rows}} ()
\begin{DoxyCompactList}\small\item\em Retrieves output buffers as a hash; result sets will be returned as lists of hashes. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a61c9cdf7687934dd54faf0c4cb5dd2c6}{get\+SQL}} ()
\begin{DoxyCompactList}\small\item\em Returns the current \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} string set with the call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} has been set. \end{DoxyCompactList}\item 
\+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$ auto $>$ \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a28e5fae36d515312aef330f8b26df817}{get\+Value}} ()
\begin{DoxyCompactList}\small\item\em Retrieves the current row as a hash where the keys are the column names and the values are the column values. \end{DoxyCompactList}\item 
auto \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af7fe60e95959cc5eb6cf0046adcb9ec6}{member\+Gate}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} key)
\begin{DoxyCompactList}\small\item\em This method allows \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} objects to be dereferenced directly as a hash for the current row being iterated, as member\+Gate methods are called implicitly when an unknown member is accessed from outside the class. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{next}} ()
\begin{DoxyCompactList}\small\item\em Increments the row pointer when retrieving rows from a select statement; returns \mbox{\hyperlink{basic_data_types_True}{True}} if there is a row to retrieve, \mbox{\hyperlink{basic_data_types_False}{False}} if not. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{prepare}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql,...)
\begin{DoxyCompactList}\small\item\em Saves an \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} statement that will be prepared and executed later, along with optional arguments. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{prepare\+Raw}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} sql)
\begin{DoxyCompactList}\small\item\em Saves an \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} statement that will be prepared and executed later. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a545ae07df1d373713d431515dc778ce1}{rollback}} ()
\begin{DoxyCompactList}\small\item\em Closes the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}}, performs a transaction rollback, and releases the connection or the transaction lock according to the object used in the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}, and closes the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a62c5937fb1ce112f54fdfe6f4f49ae24}{valid}} ()
\begin{DoxyCompactList}\small\item\em returns \mbox{\hyperlink{basic_data_types_True}{True}} if the object is currently pointing at a valid element, \mbox{\hyperlink{basic_data_types_False}{False}} if not (use when iterating with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}}) \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
The \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} class provides the most flexibilty for executing \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} on a database server. 

\begin{DoxyParagraph}{Restrictions\+:}
\mbox{\hyperlink{group__parse__options_gac496a9d9bcf9d5c626c8c267c73a83bc}{Qore\+::\+PO\+\_\+\+NO\+\_\+\+DATABASE}}
\end{DoxyParagraph}
This class allows statements to be executed and result sets to be iteratively returned in all formats supported by Qore (single row at a time as a hash or blocks of rows as either hashes of lists or lists of hashes). The same flexibility of choosing the output format for result sets also applies to output values from stored procedure or function execution, for example.

This class does not differentiate between executing select statements, stored procedures, functions, or other \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} code; the transaction lock for \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} objects and a dedicated connection for \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} objects is allocated to the object when the connection is necessary, and it is not automatically released by this class. The transaction lock or connection must be manually released by calling \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a4a5a12d0ca11cea1862152de47f0c812}{SQLStatement\+::commit()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a545ae07df1d373713d431515dc778ce1}{SQLStatement\+::rollback()}} (or the methods with the same name in the parent \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object).

Here is an example executing a select statement\+: 
\begin{DoxyCode}{0}
\DoxyCodeLine{\{}
\DoxyCodeLine{    SQLStatement stmt(ds);}
\DoxyCodeLine{    \textcolor{comment}{\# release transaction lock on exit}}
\DoxyCodeLine{    on\_exit stmt.commit();}
\DoxyCodeLine{    stmt.prepare(\textcolor{stringliteral}{"{}select * from table"{}});}
\DoxyCodeLine{    \textcolor{keywordflow}{while} (stmt.next()) \{}
\DoxyCodeLine{        hash<auto> row = stmt.fetchRow();}
\DoxyCodeLine{        do\_something(row);}
\DoxyCodeLine{    \}}
\DoxyCodeLine{\}}

\end{DoxyCode}


\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item Most commands are executed implicitly; for example, in the example above there is no call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} as it is executed implicitly in the initial call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}}.
\item Current column values in query results iterated with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} as above can also be dereferenced directly from the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} object by using the column name in lower case as a member name (using \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af7fe60e95959cc5eb6cf0046adcb9ec6}{SQLStatement\+::member\+Gate()}}, see that method for an example)
\item Query results can also be returned in blocks using \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a9e36c9ff3e13b7bd65db1d67cd596e5a}{SQLStatement\+::fetch\+Rows()}} and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab889448c79985fc26e41b7e2086308df}{SQLStatement\+::fetch\+Columns()}} (\char`\"{}rows\char`\"{} and \char`\"{}columns\char`\"{} in this case refer to the output data format; also using these methods there is no need to call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}})
\item When using an \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} object with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}}, the statement will be automatically closed when the connection is returned to the pool (for example, by committing or rolling back the transaction).
\end{DoxyItemize}
\end{DoxyNote}
The following methods are useful when executing all statements\+:
\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ae42a182f328c30f24a8092e5891631a3}{SQLStatement\+::bind()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a6f55e9c97db5b359315ead0dc5b4effe}{SQLStatement\+::bind\+Args()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aacfe5d7ba6e1c1b6fcf5e7bc979c945f}{SQLStatement\+::bind\+Placeholders()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_abcf1db95fb3e85e4677f141d9176b711}{SQLStatement\+::bind\+Placeholders\+Args()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab831457973f8279ce9783039cd5a720c}{SQLStatement\+::bind\+Values()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a01789f9ed02c8fc9e0b0493cf1823cb5}{SQLStatement\+::bind\+Values\+Args()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}{SQLStatement\+::exec\+Args()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a3fe33af34dfcd763f12d406c91305916}{SQLStatement\+::begin\+Transaction()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a4a5a12d0ca11cea1862152de47f0c812}{SQLStatement\+::commit()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a545ae07df1d373713d431515dc778ce1}{SQLStatement\+::rollback()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a568ebcbb44ae14b127487524169b0d78}{SQLStatement\+::close()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a61c9cdf7687934dd54faf0c4cb5dd2c6}{SQLStatement\+::get\+SQL()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab2435b87ba94bcd5b064084c0930d92c}{SQLStatement\+::active()}}
\end{DoxyItemize}

The following methods are useful when executing select statements\+:
\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab58ac988ce3517a88e3d25f5b5fbdb2b}{SQLStatement\+::fetch\+Row()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a9e36c9ff3e13b7bd65db1d67cd596e5a}{SQLStatement\+::fetch\+Rows()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab889448c79985fc26e41b7e2086308df}{SQLStatement\+::fetch\+Columns()}}
\end{DoxyItemize}

The following methods are useful when executing stored procedures, functions, or other non-\/select \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} statements\+:
\begin{DoxyItemize}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a1aed9317985c27bfd7ca6ca2c07be32b}{SQLStatement\+::get\+Output()}}
\item \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a5d4ec7e77c7bb751b7a49c7d8d6433e3}{SQLStatement\+::get\+Output\+Rows()}}
\end{DoxyItemize}

\begin{DoxyNote}{Note}
This class is not available with the \mbox{\hyperlink{group__parse__options_gac496a9d9bcf9d5c626c8c267c73a83bc}{PO\+\_\+\+NO\+\_\+\+DATABASE}} parse option 
\end{DoxyNote}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab2435b87ba94bcd5b064084c0930d92c}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab2435b87ba94bcd5b064084c0930d92c}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!active@{active}}
\index{active@{active}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{active()}{active()}}
{\footnotesize\ttfamily bool Qore\+::\+SQL\+::\+SQLStatement\+::active (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the object is currently active and has a connection or transaction lock allocated to it, or \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the object is currently active and has a connection or transaction lock allocated to it, or \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (stmt.active())}
\DoxyCodeLine{    stmt.commit();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_aa6e9c12936aca9c1c6b4eb151cd3d0a7}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a62e2cbca10b9b848b26fd7ebfa5dd753}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a62e2cbca10b9b848b26fd7ebfa5dd753}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!affectedRows@{affectedRows}}
\index{affectedRows@{affectedRows}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{affectedRows()}{affectedRows()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga2de8717e92c5f97ccc6511f6062d6502}{int}} Qore\+::\+SQL\+::\+SQLStatement\+::affected\+Rows (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns the number of rows affected by the last call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} 

\begin{DoxyReturn}{Returns}
the number of rows affected by the last call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{int rc = stmt.affectedRows();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed; see the relevant DBI driver docs for more information 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_af32268f269fc8e29cb4966ec70d40b26}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a3fe33af34dfcd763f12d406c91305916}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a3fe33af34dfcd763f12d406c91305916}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!beginTransaction@{beginTransaction}}
\index{beginTransaction@{beginTransaction}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{beginTransaction()}{beginTransaction()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::begin\+Transaction (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Manually starts a transaction and allocates a connection or grabs the transaction lock according to the object used in the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}} 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.beginTransaction();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a50fe98b66f009c1fce620ce42dc77c62}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ae42a182f328c30f24a8092e5891631a3}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ae42a182f328c30f24a8092e5891631a3}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!bind@{bind}}
\index{bind@{bind}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{bind()}{bind()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::bind (\begin{DoxyParamCaption}\item[{}]{... }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Binds placeholder buffer specifications and values to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} 

If the statement has not previously been prepared with the DB API, it will be implicitly prepared by this method call. This means that this call will cause a connection to be dedicated from a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object or the transaction lock to be grabbed with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object, depending on the argument to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}.

Arguments to buffer specifications must be given in the same order as declared in the string given to the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} method.

Any arguments previously bound will be released when this call is made.

\begin{DoxyNote}{Note}
You can also bind directly when calling \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}{SQLStatement\+::exec\+Args()}} as a shortcut as well, in which case it\textquotesingle{}s not necessary to make an extra call to this method.
\end{DoxyNote}

\begin{DoxyParams}{Parameters}
{\em ...} & Arguments to placeholder specifications (if required by the underlying DBI driver) and bind by value arguments\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}insert into table (id, name) values (\%v, \%v)"{}});}
\DoxyCodeLine{foreach hash<auto> h \textcolor{keywordflow}{in} (l) \{}
\DoxyCodeLine{    stmt.bind(h.id, h.name);}
\DoxyCodeLine{    stmt.exec();}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications; see the relevant DBI driver docs for more information
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a6f55e9c97db5b359315ead0dc5b4effe}{SQLStatement\+::bind\+Args()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aacfe5d7ba6e1c1b6fcf5e7bc979c945f}{SQLStatement\+::bind\+Placeholders()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_abcf1db95fb3e85e4677f141d9176b711}{SQLStatement\+::bind\+Placeholders\+Args()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab831457973f8279ce9783039cd5a720c}{SQLStatement\+::bind\+Values()}}, and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a01789f9ed02c8fc9e0b0493cf1823cb5}{SQLStatement\+::bind\+Values\+Args()}} 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a53fbcc157b43c9f733e738f033c5b133}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a6f55e9c97db5b359315ead0dc5b4effe}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a6f55e9c97db5b359315ead0dc5b4effe}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!bindArgs@{bindArgs}}
\index{bindArgs@{bindArgs}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{bindArgs()}{bindArgs()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::bind\+Args (\begin{DoxyParamCaption}\item[{softlist$<$ auto $>$}]{vargs }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Binds placeholder buffer specifications and values given as a list in the single argument to the method to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} 

If the statement has not previously been prepared with the DB API, it will be implicitly prepared by this method call. This means that this call will cause a connection to be dedicated from a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object or the transaction lock to be grabbed with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object, depending on the argument to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}.

Arguments to buffer specifications must be given in the same order as declared in the string given to the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} method.

Any arguments previously bound will be released when this call is made.

\begin{DoxyNote}{Note}
You can also bind directly when calling \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}{SQLStatement\+::exec\+Args()}} as a shortcut as well, in which case it\textquotesingle{}s not necessary to make an extra call to this method.
\end{DoxyNote}

\begin{DoxyParams}{Parameters}
{\em vargs} & Arguments to placeholder specifications (if required by the underlying DBI driver) and bind by value arguments\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}insert into table (id, name) values (\%v, \%v)"{}});}
\DoxyCodeLine{foreach hash<auto> h \textcolor{keywordflow}{in} (l) \{}
\DoxyCodeLine{    list<auto> args = (h.id, h.name);}
\DoxyCodeLine{    stmt.bindArgs(args);}
\DoxyCodeLine{    stmt.exec();}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications; see the relevant DBI driver docs for more information
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ae42a182f328c30f24a8092e5891631a3}{SQLStatement\+::bind()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aacfe5d7ba6e1c1b6fcf5e7bc979c945f}{SQLStatement\+::bind\+Placeholders()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_abcf1db95fb3e85e4677f141d9176b711}{SQLStatement\+::bind\+Placeholders\+Args()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab831457973f8279ce9783039cd5a720c}{SQLStatement\+::bind\+Values()}}, and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a01789f9ed02c8fc9e0b0493cf1823cb5}{SQLStatement\+::bind\+Values\+Args()}} 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_aecef7bdce44fb28daf3ffda44bd395b6}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aacfe5d7ba6e1c1b6fcf5e7bc979c945f}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aacfe5d7ba6e1c1b6fcf5e7bc979c945f}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!bindPlaceholders@{bindPlaceholders}}
\index{bindPlaceholders@{bindPlaceholders}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{bindPlaceholders()}{bindPlaceholders()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::bind\+Placeholders (\begin{DoxyParamCaption}\item[{}]{... }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Binds placeholder buffer specifications to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} 

If the statement has not previously been prepared with the DB API, it will be implicitly prepared by this method call. This means that this call will cause a connection to be dedicated from a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object or the transaction lock to be grabbed with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object, depending on the argument to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}.

Arguments to buffer specifications must be given in the same order as declared in the string given to the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} method. Only placeholder buffer specifications will be processed; value buffer specifications will be skipped by this method.

Any buffer specifications previously defined will be released when this call is made.

\begin{DoxyNote}{Note}
You can also bind buffer specifications directly when calling \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}{SQLStatement\+::exec\+Args()}} as a shortcut as well, in which case it\textquotesingle{}s not necessary to make an extra call to this method.~\newline
~\newline
 Not all DBI drivers require binding placeholders specification.
\end{DoxyNote}

\begin{DoxyParams}{Parameters}
{\em ...} & Arguments to placeholder specifications (if required by the underlying DBI driver)\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}begin select sysdate into :sd from dual"{}}, Type::Date); end;}
\DoxyCodeLine{stmt.bindPlaceholders(Type::Date);}
\DoxyCodeLine{date d = stmt.getOutput().sd;}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications; see the relevant DBI driver docs for more information
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ae42a182f328c30f24a8092e5891631a3}{SQLStatement\+::bind()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a6f55e9c97db5b359315ead0dc5b4effe}{SQLStatement\+::bind\+Args()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_abcf1db95fb3e85e4677f141d9176b711}{SQLStatement\+::bind\+Placeholders\+Args()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab831457973f8279ce9783039cd5a720c}{SQLStatement\+::bind\+Values()}}, and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a01789f9ed02c8fc9e0b0493cf1823cb5}{SQLStatement\+::bind\+Values\+Args()}} 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a0311c65d5483cd9cbaf48dc59f437895}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_abcf1db95fb3e85e4677f141d9176b711}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_abcf1db95fb3e85e4677f141d9176b711}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!bindPlaceholdersArgs@{bindPlaceholdersArgs}}
\index{bindPlaceholdersArgs@{bindPlaceholdersArgs}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{bindPlaceholdersArgs()}{bindPlaceholdersArgs()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::bind\+Placeholders\+Args (\begin{DoxyParamCaption}\item[{softlist$<$ auto $>$}]{vargs }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Binds placeholder buffer specifications given as a list in the single argument to the method to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} 

If the statement has not previously been prepared with the DB API, it will be implicitly prepared by this method call. This means that this call will cause a connection to be dedicated from a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object or the transaction lock to be grabbed with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object, depending on the argument to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}.

Arguments to buffer specifications must be given in the same order as declared in the string given to the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} method. Only placeholder buffer specifications will be processed; value buffer specifications will be skipped by this method.

Any buffer specifications previously defined will be released when this call is made.

\begin{DoxyNote}{Note}
You can also bind buffer specifications directly when calling \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}{SQLStatement\+::exec\+Args()}} as a shortcut as well, in which case it\textquotesingle{}s not necessary to make an extra call to this method.~\newline
~\newline
 Not all DBI drivers require binding placeholders specification.
\end{DoxyNote}

\begin{DoxyParams}{Parameters}
{\em vargs} & Arguments to placeholder specifications (if required by the underlying DBI driver)\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}begin select sysdate into :sd from dual"{}}, Type::Date); end;}
\DoxyCodeLine{list<auto> l = \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}(Type::Date);}
\DoxyCodeLine{stmt.bindPlaceholdersArgs(l);}
\DoxyCodeLine{date d = stmt.getOutput().sd;}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications; see the relevant DBI driver docs for more information
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ae42a182f328c30f24a8092e5891631a3}{SQLStatement\+::bind()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a6f55e9c97db5b359315ead0dc5b4effe}{SQLStatement\+::bind\+Args()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aacfe5d7ba6e1c1b6fcf5e7bc979c945f}{SQLStatement\+::bind\+Placeholders()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab831457973f8279ce9783039cd5a720c}{SQLStatement\+::bind\+Values()}}, and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a01789f9ed02c8fc9e0b0493cf1823cb5}{SQLStatement\+::bind\+Values\+Args()}} 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a515142e47a51687427a8e6715bc35a70}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab831457973f8279ce9783039cd5a720c}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab831457973f8279ce9783039cd5a720c}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!bindValues@{bindValues}}
\index{bindValues@{bindValues}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{bindValues()}{bindValues()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::bind\+Values (\begin{DoxyParamCaption}\item[{}]{... }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Binds values to value buffer specifications to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} 

If the statement has not previously been prepared with the DB API, it will be implicitly prepared by this method call. This means that this call will cause a connection to be dedicated from a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object or the transaction lock to be grabbed with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object, depending on the argument to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}.

Arguments to buffer specifications must be given in the same order as declared in the string given to the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} method.

Any values previously bound will be released when this call is made.

\begin{DoxyNote}{Note}
You can also bind directly when calling \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}{SQLStatement\+::exec\+Args()}} as a shortcut as well, in which case it\textquotesingle{}s not necessary to make an extra call to this method.
\end{DoxyNote}

\begin{DoxyParams}{Parameters}
{\em ...} & Arguments to bind by value arguments\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}insert into table (id, name) values (\%v, \%v)"{}});}
\DoxyCodeLine{foreach hash<auto> h \textcolor{keywordflow}{in} (l) \{}
\DoxyCodeLine{    stmt.bindValues(h.id, h.name);}
\DoxyCodeLine{    stmt.exec();}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications; see the relevant DBI driver docs for more information
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ae42a182f328c30f24a8092e5891631a3}{SQLStatement\+::bind()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a6f55e9c97db5b359315ead0dc5b4effe}{SQLStatement\+::bind\+Args()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aacfe5d7ba6e1c1b6fcf5e7bc979c945f}{SQLStatement\+::bind\+Placeholders()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_abcf1db95fb3e85e4677f141d9176b711}{SQLStatement\+::bind\+Placeholders\+Args()}}, and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a01789f9ed02c8fc9e0b0493cf1823cb5}{SQLStatement\+::bind\+Values\+Args()}}. 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_addf98ea5bdf907ae646a7f2f8e1607c0}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a01789f9ed02c8fc9e0b0493cf1823cb5}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a01789f9ed02c8fc9e0b0493cf1823cb5}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!bindValuesArgs@{bindValuesArgs}}
\index{bindValuesArgs@{bindValuesArgs}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{bindValuesArgs()}{bindValuesArgs()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::bind\+Values\+Args (\begin{DoxyParamCaption}\item[{softlist$<$ auto $>$}]{vargs }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Binds values to value buffer specifications given as a list in the single argument to the method to value buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} 

If the statement has not previously been prepared with the DB API, it will be implicitly prepared by this method call. This means that this call will cause a connection to be dedicated from a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object or the transaction lock to be grabbed with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object, depending on the argument to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}.

Arguments to buffer specifications must be given in the same order as declared in the string given to the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} method.

Any values previously bound will be released when this call is made.

\begin{DoxyNote}{Note}
You can also bind directly when calling \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}{SQLStatement\+::exec\+Args()}} as a shortcut as well, in which case it\textquotesingle{}s not necessary to make an extra call to this method.
\end{DoxyNote}

\begin{DoxyParams}{Parameters}
{\em vargs} & Arguments to bind by value arguments\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}insert into table (id, name) values (\%v, \%v)"{}});}
\DoxyCodeLine{foreach hash<auto> h \textcolor{keywordflow}{in} (l) \{}
\DoxyCodeLine{    list<auto> args = (h.id, h.name);}
\DoxyCodeLine{    stmt.bindValuesArgs(args);}
\DoxyCodeLine{    stmt.exec();}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications; see the relevant DBI driver docs for more information 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_ae80b0921b26b6455b85ae727e57b1fa0}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a568ebcbb44ae14b127487524169b0d78}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a568ebcbb44ae14b127487524169b0d78}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!close@{close}}
\index{close@{close}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{close()}{close()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::close (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Closes the statement if it is open, however this method does not release the connection or transaction lock. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.close();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a3be914ba53e691d4ee4655973de3718b}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a4a5a12d0ca11cea1862152de47f0c812}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a4a5a12d0ca11cea1862152de47f0c812}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!commit@{commit}}
\index{commit@{commit}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{commit()}{commit()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::commit (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Commits the transaction, releases the connection or the transaction lock according to the object used in the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}, and closes the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}}. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.commit();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
For possible exceptions; see DBI driver docs for the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a4a5a12d0ca11cea1862152de47f0c812}{commit()}} method 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a721847f8231a8e1539542dbe5bca606d}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+SQLStatement\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}}}]{ds }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} object based on the given \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object that provides the connection to the database. 

This method will throw an exception only if the object passed as an argument uses a driver that does not support the prepared statement interface added in Qore version 0.\+8.\+1.


\begin{DoxyParams}{Parameters}
{\em ds} & The \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object to use for the DB connection for the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} object\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{SQLStatement stmt(db);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & the DBI driver for the given object does not support the prepared statement API\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+1 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af4ab2449388ac84f174e9ae2e9da2ce2}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af4ab2449388ac84f174e9ae2e9da2ce2}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+SQLStatement\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}}}]{dsp }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} object based on the given \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object that provides the connection to the database. 

This method will throw an exception only if the object passed as an argument uses a driver that does not support the prepared statement interface added in Qore version 0.\+8.\+1.


\begin{DoxyParams}{Parameters}
{\em dsp} & The \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object to use for the DB connection for the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} object\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{SQLStatement stmt(db);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & the DBI driver for the given object does not support the prepared statement API\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 0.\+8.\+1 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a78fc987d855bd283c1ac4192743453cb}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a78fc987d855bd283c1ac4192743453cb}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!copy@{copy}}
\index{copy@{copy}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{copy()}{copy()}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+SQLStatement\+::copy (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Throws an exception; objects of this class cannot be copied. 


\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+COPY-\/\+ERROR} & \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} objects cannot be copied \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a50d360812380f793b0b0ab7f0b181792}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a50d360812380f793b0b0ab7f0b181792}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!currentThreadInTransaction@{currentThreadInTransaction}}
\index{currentThreadInTransaction@{currentThreadInTransaction}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{currentThreadInTransaction()}{currentThreadInTransaction()}}
{\footnotesize\ttfamily bool Qore\+::\+SQL\+::\+SQLStatement\+::current\+Thread\+In\+Transaction (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is in a transaction (i.\+e. holds the transaction lock), \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the current thread is in a transaction (i.\+e. holds the transaction lock), \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool b = stmt.currentThreadInTransaction();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxySince}{Since}
Qore 0.\+8.\+12 
\end{DoxySince}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_afb9a48701323d1c620f4bfcf40e4ba78}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a22375c4a7755215cc53accc68b626ec7}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a22375c4a7755215cc53accc68b626ec7}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!define@{define}}
\index{define@{define}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{define()}{define()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::define (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Performs an explicit define operation on the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}}. 

It is not encessary to call this method manually; define operations are implicitly executed when needed when retrieving values from a select statement

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\{}
\DoxyCodeLine{    SQLStatement stmt(ds);}
\DoxyCodeLine{    \textcolor{comment}{\# release transaction lock on exit}}
\DoxyCodeLine{    on\_exit stmt.commit();}
\DoxyCodeLine{    stmt.prepare(\textcolor{stringliteral}{"{}select * from table"{}});}
\DoxyCodeLine{    stmt.exec();}
\DoxyCodeLine{    stmt.define();}
\DoxyCodeLine{    \textcolor{comment}{\# note that the SQLStatement::next() would implicitly execute exec() and define()}}
\DoxyCodeLine{    \textcolor{keywordflow}{while} (stmt.next()) \{}
\DoxyCodeLine{        hash<auto> row = stmt.fetchRow();}
\DoxyCodeLine{        do\_something(row);}
\DoxyCodeLine{    \}}
\DoxyCodeLine{\}}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a7f767fcdc63e67b201acfa73cc3c5b82}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a1cc37a8464e3c8a6e50b08d366d3d629}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a1cc37a8464e3c8a6e50b08d366d3d629}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!describe@{describe}}
\index{describe@{describe}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{describe()}{describe()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+SQLStatement\+::describe (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Describes columns in the statement result. 

\begin{DoxyReturn}{Returns}
a hash with ({\itshape column\+\_\+name}\+: {\itshape description\+\_\+hash}) format, where each {\itshape description\+\_\+hash} has the following keys\+:
\begin{DoxyItemize}
\item {\ttfamily \char`\"{}name\char`\"{}}\+: (string) the column name
\item {\ttfamily \char`\"{}type\char`\"{}}\+: (integer) the column type code (as returned by \mbox{\hyperlink{class_qore_1_1zzz8valuezzz9_a5e7d381ab49abebd0d0f045708482512}{Qore\+::zzz8valuezzz9\+::type\+Code()}})
\item {\ttfamily \char`\"{}maxsize\char`\"{}}\+: (integer) the maximum size of the column
\item {\ttfamily \char`\"{}native\+\_\+type\char`\"{}}\+: (string) the database-\/specific name of the type
\item {\ttfamily \char`\"{}internal\+\_\+id\char`\"{}}\+: (integer) the database-\/specific type code of the type 
\end{DoxyItemize}
\end{DoxyReturn}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a4ace76d7521c621918188bb89c3c4288}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a235cd43bb5a46e9906c220d9caf0659a}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a235cd43bb5a46e9906c220d9caf0659a}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!destructor@{destructor}}
\index{destructor@{destructor}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{destructor()}{destructor()}}
{\footnotesize\ttfamily Qore\+::\+SQL\+::\+SQLStatement\+::destructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Closes the statement if it is open and destroys the object. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{delete stmt;}

\end{DoxyCode}
 
\end{DoxyParagraph}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!exec@{exec}}
\index{exec@{exec}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{exec()}{exec()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::exec (\begin{DoxyParamCaption}\item[{}]{... }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Executes the bound statement with any bound buffers, also optionally allows binding placeholder buffer specifications and values to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} before executing the statement. 

If the statement has not previously been prepared with the DB API, it will be implicitly prepared by this method call. This means that this call will cause a connection to be dedicated from a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object or the transaction lock to be grabbed with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object, depending on the argument to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}.

Optional arguments to buffer specifications must be given in the same order as declared in the string given to the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} method.

If bind arguments are provided, any arguments previously bound will be released when this call is made.

After calling this method to execute the statement, to retrieve information about the call or output values bound in the call, call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a62e2cbca10b9b848b26fd7ebfa5dd753}{SQLStatement\+::affected\+Rows()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a1aed9317985c27bfd7ca6ca2c07be32b}{SQLStatement\+::get\+Output()}}, or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a5d4ec7e77c7bb751b7a49c7d8d6433e3}{SQLStatement\+::get\+Output\+Rows()}} as needed.

To retrieve rows from a select statement call either \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab58ac988ce3517a88e3d25f5b5fbdb2b}{SQLStatement\+::fetch\+Row()}}, or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a9e36c9ff3e13b7bd65db1d67cd596e5a}{SQLStatement\+::fetch\+Rows()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab889448c79985fc26e41b7e2086308df}{SQLStatement\+::fetch\+Columns()}} as needed.


\begin{DoxyParams}{Parameters}
{\em ...} & Optional arguments to placeholder specifications (if required by the underlying DBI driver) and bind by value arguments can be given in the call to the method; if present, arguments are bound before the statement is executed\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}insert into table (id, name) values (\%v, \%v)"{}});}
\DoxyCodeLine{foreach hash<auto> h \textcolor{keywordflow}{in} (l) \{}
\DoxyCodeLine{    stmt.exec(h.id, h.name);}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}}; the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} uses a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} an the statement was prepared on another connection\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed; see the relevant DBI driver docs for more information
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}{SQLStatement\+::exec\+Args()}} 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a1fd3fd0ce29a4eb110dd6ff416195bda}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a58ffbb1fb12036db5027cf70918733b3}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!execArgs@{execArgs}}
\index{execArgs@{execArgs}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{execArgs()}{execArgs()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::exec\+Args (\begin{DoxyParamCaption}\item[{softlist$<$ auto $>$}]{vargs }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Executes the bound statement with any bound buffers, also optionally allows binding placeholder buffer specifications and values given as a list in the single argument to the method to buffers defined in \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} 

If the statement has not previously been prepared with the DB API, it will be implicitly prepared by this method call. This means that this call will cause a connection to be dedicated from a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} object or the transaction lock to be grabbed with a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource}{Datasource}} object, depending on the argument to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}.

Optional arguments to buffer specifications must be given in the same order as declared in the string given to the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} method.

If bind arguments are provided, any arguments previously bound will be released when this call is made.

After calling this method to execute the statement, to retrieve information about the call or output values bound in the call, call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a62e2cbca10b9b848b26fd7ebfa5dd753}{SQLStatement\+::affected\+Rows()}}, \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a1aed9317985c27bfd7ca6ca2c07be32b}{SQLStatement\+::get\+Output()}}, or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a5d4ec7e77c7bb751b7a49c7d8d6433e3}{SQLStatement\+::get\+Output\+Rows()}} as needed.

To retrieve rows from a select statement call either \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} and \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab58ac988ce3517a88e3d25f5b5fbdb2b}{SQLStatement\+::fetch\+Row()}}, or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a9e36c9ff3e13b7bd65db1d67cd596e5a}{SQLStatement\+::fetch\+Rows()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab889448c79985fc26e41b7e2086308df}{SQLStatement\+::fetch\+Columns()}} as needed.


\begin{DoxyParams}{Parameters}
{\em vargs} & Optional arguments to placeholder specifications (if required by the underlying DBI driver) and bind by value arguments can be given in the call to the method; if present, arguments are bound before the statement is executed\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}insert into table (id, name) values (\%v, \%v)"{}});}
\DoxyCodeLine{foreach hash<auto> h \textcolor{keywordflow}{in} (l) \{}
\DoxyCodeLine{    list<auto> args = (h.id, h.name);}
\DoxyCodeLine{    stmt.execArgs(args);}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}; the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} uses a \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} an the statement was prepared on another connection\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed; see the relevant DBI driver docs for more information
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af1633d031c7480fed7de638b21f9a087}{SQLStatement\+::exec()}} 
\end{DoxySeeAlso}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_aaf3f423da01bbe18b95eaf0cb53053f3}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab889448c79985fc26e41b7e2086308df}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab889448c79985fc26e41b7e2086308df}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!fetchColumns@{fetchColumns}}
\index{fetchColumns@{fetchColumns}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{fetchColumns()}{fetchColumns()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+SQLStatement\+::fetch\+Columns (\begin{DoxyParamCaption}\item[{softint}]{rows = {\ttfamily -\/1} }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Retrieves a block of rows as a hash of lists with the maximum number of rows determined by the argument passed; automatically advances the row pointer; with this call it is not necessary to call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}}. 

If the argument passed is omitted or less than or equal to zero, then all available rows from the current row position are retrieved, also if fewer rows are available than requested then only the rows available are retrieved.


\begin{DoxyParams}{Parameters}
{\em rows} & The maximum number of rows to retrieve, if this argument is omitted, negative, or equal to zero, then all available rows from the current row position are retrieved\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
a hash (giving column names) of lists (giving row values for each column) of data returned; each list will have at most {\itshape rows} elements (unless {\itshape rows} is negative, in which case all available rows are returned). If the total number of rows available is less than {\itshape rows} (if {\itshape rows} is positive), then the last data returned by this method may return short lists. If no more rows are available, then an empty hash is returned
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{hash<auto> h = stmt.fetchColumns(-\/1);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item There is no need to call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} when calling this method; the method automatically iterates through the given number of rows
\item Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed or when row values are retrieved; see the relevant DBI driver docs for more information 
\end{DoxyItemize}
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a9f8ed8237c4c866b657e492978aaa84d}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab58ac988ce3517a88e3d25f5b5fbdb2b}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab58ac988ce3517a88e3d25f5b5fbdb2b}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!fetchRow@{fetchRow}}
\index{fetchRow@{fetchRow}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{fetchRow()}{fetchRow()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+SQLStatement\+::fetch\+Row (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Retrieves the current row as a hash where the keys are the column names and the values are the column values. 

Use with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} to iterate through the results of a select statement one row at a time

\begin{DoxyReturn}{Returns}
the current row as a hash where the keys are the column names and the values are the column values
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{while} (stmt.next()) \{}
\DoxyCodeLine{    hash<auto> h = stmt.fetchRow();}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed or when row values are retrieved; see the relevant DBI driver docs for more information 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a0e26549aee530ea728ecb13b35f854f8}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a9e36c9ff3e13b7bd65db1d67cd596e5a}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a9e36c9ff3e13b7bd65db1d67cd596e5a}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!fetchRows@{fetchRows}}
\index{fetchRows@{fetchRows}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{fetchRows()}{fetchRows()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga4b52a1cbee7a3aed46c32cb0a938629c}{list}}$<$auto$>$ Qore\+::\+SQL\+::\+SQLStatement\+::fetch\+Rows (\begin{DoxyParamCaption}\item[{softint}]{rows = {\ttfamily -\/1} }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Retrieves a block of rows as a list of hashes with the maximum number of rows determined by the argument passed; automatically advances the row pointer; with this call it is not necessary to call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} 

If the argument passed is omitted or less than or equal to zero, then all available rows from the current row position are retrieved, also if fewer rows are available than requested then only the rows available are retrieved.

If no more rows are available then an empty list is returned.


\begin{DoxyParams}{Parameters}
{\em rows} & The maximum number of rows to retrieve, if this argument is omitted, negative, or equal to zero, then all available rows from the current row position are retrieved\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{list<auto> l = stmt.fetchRows(-\/1);}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item There is no need to call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} when calling this method; the method automatically iterates through the given number of rows
\item Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed or when row values are retrieved; see the relevant DBI driver docs for more information 
\end{DoxyItemize}
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a6534d93f4686c55e6700dd59188500eb}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a1aed9317985c27bfd7ca6ca2c07be32b}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a1aed9317985c27bfd7ca6ca2c07be32b}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!getOutput@{getOutput}}
\index{getOutput@{getOutput}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{getOutput()}{getOutput()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+SQLStatement\+::get\+Output (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Retrieves output buffers as a hash; result sets will be returned as hashes of lists. 

\begin{DoxyReturn}{Returns}
Returns a hash of output buffers; result sets will be returned as hashes of lists. Each key in the hash is the same as the name given to the placeholder specification in the call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{hash<auto> h = stmt.getOutput();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed or when output values are retrieved; see the relevant DBI driver docs for more information 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a677eeb9a87925099e2506db6a89fa998}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a5d4ec7e77c7bb751b7a49c7d8d6433e3}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a5d4ec7e77c7bb751b7a49c7d8d6433e3}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!getOutputRows@{getOutputRows}}
\index{getOutputRows@{getOutputRows}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{getOutputRows()}{getOutputRows()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+SQLStatement\+::get\+Output\+Rows (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Retrieves output buffers as a hash; result sets will be returned as lists of hashes. 

\begin{DoxyReturn}{Returns}
Retrieves output buffers as a hash; result sets will be returned as lists of hashes. Each key in the hash is the same as the name given to the placeholder specification in the call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{hash<auto> h = stmt.getOutputRows();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed or when output values are retrieved; see the relevant DBI driver docs for more information 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a746ce99d4d6453963e899390a8c8ea4c}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a61c9cdf7687934dd54faf0c4cb5dd2c6}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a61c9cdf7687934dd54faf0c4cb5dd2c6}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!getSQL@{getSQL}}
\index{getSQL@{getSQL}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{getSQL()}{getSQL()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+SQL\+::\+SQLStatement\+::get\+SQL (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Returns the current \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} string set with the call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} has been set. 

\begin{DoxyReturn}{Returns}
Returns the current \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} string set with the call to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}} or \mbox{\hyperlink{basic_data_types_nothing}{NOTHING}} if no \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} has been set
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{*string sql = stmt.getSQL();}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_aa351dd140d5e1a6147a3a34e92614493}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a28e5fae36d515312aef330f8b26df817}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a28e5fae36d515312aef330f8b26df817}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!getValue@{getValue}}
\index{getValue@{getValue}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{getValue()}{getValue()}}
{\footnotesize\ttfamily \+\_\+\+\_\+7\+\_\+ \mbox{\hyperlink{group__type__conversion__functions_ga0231dbb472dd230310af7c7c34f56e92}{hash}}$<$auto$>$ Qore\+::\+SQL\+::\+SQLStatement\+::get\+Value (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Retrieves the current row as a hash where the keys are the column names and the values are the column values. 

Use with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} to iterate through the results of a select statement one row at a time

\begin{DoxyReturn}{Returns}
the current row as a hash where the keys are the column names and the values are the column values
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{while} (stmt.next()) \{}
\DoxyCodeLine{    hash<auto> h = stmt.getValue();}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}

\begin{DoxyItemize}
\item Equivalent to \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab58ac988ce3517a88e3d25f5b5fbdb2b}{SQLStatement\+::fetch\+Row()}}
\item Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed or when row values are retrieved; see the relevant DBI driver docs for more information
\end{DoxyItemize}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+5 
\end{DoxySince}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a08e13d83166f84b2f3656e16c7008a7b}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af7fe60e95959cc5eb6cf0046adcb9ec6}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af7fe60e95959cc5eb6cf0046adcb9ec6}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!memberGate@{memberGate}}
\index{memberGate@{memberGate}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{memberGate()}{memberGate()}}
{\footnotesize\ttfamily auto Qore\+::\+SQL\+::\+SQLStatement\+::member\+Gate (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{key }\end{DoxyParamCaption})}



This method allows \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} objects to be dereferenced directly as a hash for the current row being iterated, as member\+Gate methods are called implicitly when an unknown member is accessed from outside the class. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}

\begin{DoxyParams}{Parameters}
{\em key} & the column name for the value to retrieve\\
\hline
\end{DoxyParams}
\begin{DoxyReturn}{Returns}
the current column value of the given row
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{SQLStatement stmt(ds);}
\DoxyCodeLine{\textcolor{comment}{\# release transaction lock on exit}}
\DoxyCodeLine{on\_exit stmt.commit();}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}select name, birthdate from table"{}});}
\DoxyCodeLine{\textcolor{keywordflow}{while} (stmt.next()) \{}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}name: \%s birthdate: \%y"{}}, stmt.name, stmt.birthdate);}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}} \\
\hline
{\em SQLSTATEMENT-\/\+ITERATION-\/\+ERROR} & Cannot dereference statement iteration context; make sure and call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}} before trying to dereference the current row being iterated \\
\hline
{\em ENCODING-\/\+CONVERSION-\/\+ERROR} & this error is thrown if the given key cannot be converted to the \mbox{\hyperlink{character_encoding_default_encoding}{default character encoding}} \\
\hline
{\em SQLSTATEMENT-\/\+COLUMN-\/\+ERROR} & The given column name does not exist in the current row data\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Column values can only be dereferenced using the automatic \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_af7fe60e95959cc5eb6cf0046adcb9ec6}{SQLStatement\+::member\+Gate()}} method while iterating a result set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}}; the hash that will be dereferenced is equivalent to that returned by \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab58ac988ce3517a88e3d25f5b5fbdb2b}{SQLStatement\+::fetch\+Row()}}
\end{DoxyNote}
\begin{DoxySince}{Since}
Qore 0.\+8.\+6 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!next@{next}}
\index{next@{next}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{next()}{next()}}
{\footnotesize\ttfamily bool Qore\+::\+SQL\+::\+SQLStatement\+::next (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Increments the row pointer when retrieving rows from a select statement; returns \mbox{\hyperlink{basic_data_types_True}{True}} if there is a row to retrieve, \mbox{\hyperlink{basic_data_types_False}{False}} if not. 

If this method returns True, then call \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ab58ac988ce3517a88e3d25f5b5fbdb2b}{SQLStatement\+::fetch\+Row()}} afterwards to retrieve the row

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if there is a row to retrieve, \mbox{\hyperlink{basic_data_types_False}{False}} if not (no more rows to be retrieved)
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{while} (stmt.next()) \{}
\DoxyCodeLine{    hash<auto> h = stmt.fetchRow();}
\DoxyCodeLine{\}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em SQLSTATEMENT-\/\+ERROR} & No SQL has been set with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}} or \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}\\
\hline
\end{DoxyExceptions}
\begin{DoxyNote}{Note}
Exceptions could be thrown by the DBI driver when the statement is prepared or when attempting to bind the given arguments to buffer specifications or when the statement is executed; see the relevant DBI driver docs for more information 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a45f7bd62a339149daa3f859012eb626f}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!prepare@{prepare}}
\index{prepare@{prepare}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{prepare()}{prepare()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::prepare (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql,  }\item[{}]{... }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Saves an \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} statement that will be prepared and executed later, along with optional arguments. 

The statement is actually only prepared when used for the first time, this is so that \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} objects created with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} objects use the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} more efficiently, as many drivers require the actual DB API prepare call to be made on the same connection as the connection the statement will be executed on as well.

\begin{DoxyNote}{Note}
This method parses the \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} string for placeholders and bind by value tokens ({\ttfamily \%v}); for a version of this method that does not parse the \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} string for placeholders and bind by value tokens, see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}{SQLStatement\+::prepare\+Raw()}}.
\end{DoxyNote}

\begin{DoxyParams}{Parameters}
{\em sql} & The \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} string to prepare for execution on the DB server\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepare(\textcolor{stringliteral}{"{}select * from table where id = \%v"{}});}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a480f30622fff523ee188297b1eebfa79}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_aa0dadef84dc71fa6bb0dd1cac491f100}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!prepareRaw@{prepareRaw}}
\index{prepareRaw@{prepareRaw}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{prepareRaw()}{prepareRaw()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::prepare\+Raw (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{sql }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Saves an \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} statement that will be prepared and executed later. 

The statement is actually only prepared when used for the first time, this is so that \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}} objects created with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} objects use the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_datasource_pool}{Datasource\+Pool}} more efficiently, as many drivers require the actual DB API prepare call to be made on the same connection as the connection the statement will be executed on as well.

\begin{DoxyNote}{Note}
This method does not parse the \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} string for placeholders and bind by value tokens ({\ttfamily \%v}); for a version of this method that does parse the \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} string for placeholders and bind by value tokens, see \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_ad05790f42e735a8ba687fcbc93d1480a}{SQLStatement\+::prepare()}}.
\end{DoxyNote}

\begin{DoxyParams}{Parameters}
{\em sql} & The \mbox{\hyperlink{namespace_qore_1_1_s_q_l}{SQL}} string to prepare for execution on the DB server\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.prepareRaw(\textcolor{stringliteral}{"{}select * from table"{}});}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_a0f5d70f9678cd823fb1eb7aa99052fdd}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a545ae07df1d373713d431515dc778ce1}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a545ae07df1d373713d431515dc778ce1}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!rollback@{rollback}}
\index{rollback@{rollback}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{rollback()}{rollback()}}
{\footnotesize\ttfamily nothing Qore\+::\+SQL\+::\+SQLStatement\+::rollback (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Closes the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}}, performs a transaction rollback, and releases the connection or the transaction lock according to the object used in the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a39bdf5cf150edd5d30f75719e3887a55}{SQLStatement\+::constructor()}}, and closes the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement}{SQLStatement}}. 

\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{stmt.rollback();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
For possible exceptions; see DBI driver docs for the \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a545ae07df1d373713d431515dc778ce1}{rollback()}} method 
\end{DoxyNote}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_ad243d89229ee65a43fe33d29137217c4}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

\mbox{\Hypertarget{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a62c5937fb1ce112f54fdfe6f4f49ae24}\label{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a62c5937fb1ce112f54fdfe6f4f49ae24}} 
\index{Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}!valid@{valid}}
\index{valid@{valid}!Qore::SQL::SQLStatement@{Qore::SQL::SQLStatement}}
\doxysubsubsection{\texorpdfstring{valid()}{valid()}}
{\footnotesize\ttfamily bool Qore\+::\+SQL\+::\+SQLStatement\+::valid (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



returns \mbox{\hyperlink{basic_data_types_True}{True}} if the object is currently pointing at a valid element, \mbox{\hyperlink{basic_data_types_False}{False}} if not (use when iterating with \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_s_q_l_statement_a34dfdc4d3aa9d3c38817931986506fbd}{SQLStatement\+::next()}}) 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the object is currently pointing at a valid element, \mbox{\hyperlink{basic_data_types_False}{False}} if not
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{\textcolor{keywordflow}{if} (i.valid())}
\DoxyCodeLine{    \mbox{\hyperlink{group__string__functions_ga32070517a9f8a70a32ef48f83a6f128e}{printf}}(\textcolor{stringliteral}{"{}current value: \%y\(\backslash\)n"{}}, i.getValue());}

\end{DoxyCode}
 
\end{DoxyParagraph}


Implements \mbox{\hyperlink{class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement_ac43800cdf66d8a1e021989194d330306}{Qore\+::\+SQL\+::\+Abstract\+SQLStatement}}.

