\hypertarget{class_qore_1_1_string_output_stream}{}\doxysection{Qore\+::String\+Output\+Stream Class Reference}
\label{class_qore_1_1_string_output_stream}\index{Qore::StringOutputStream@{Qore::StringOutputStream}}


This class implements the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} interface for writing bytes to a \mbox{\hyperlink{basic_data_types_string}{String}} buffer.  




Inheritance diagram for Qore\+::String\+Output\+Stream\+:
% FIG 0
\doxysubsection*{Public Member Functions}
\begin{DoxyCompactItemize}
\item 
nothing \mbox{\hyperlink{class_qore_1_1_string_output_stream_a9e72b18135630529612c2a1ab88a9706}{close}} ()
\begin{DoxyCompactList}\small\item\em Closes the output stream and releases any resources. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_string_output_stream_a6ab01cef4c8993f15fd3f33ff673f93d}{constructor}} ()
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{class_qore_1_1_string_output_stream_a7350dd527d6b743ced0d9f11ba403ec1}{constructor}} (\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} encoding)
\begin{DoxyCompactList}\small\item\em Creates the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}}. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_string_output_stream_a5d2573b4fcc5bda27e098eba27418d01}{get\+Data}} ()
\begin{DoxyCompactList}\small\item\em Returns the data written to the stream, clearing the internal buffer. \end{DoxyCompactList}\item 
\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} \mbox{\hyperlink{class_qore_1_1_string_output_stream_af3adfd7eb6cf48de3d2007e9484ad032}{get\+Encoding}} ()
\begin{DoxyCompactList}\small\item\em Returns the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}}. \end{DoxyCompactList}\item 
bool \mbox{\hyperlink{class_qore_1_1_string_output_stream_a47bdd9bdb29860476f1d93e2bd1391b5}{has\+Data}} ()
\begin{DoxyCompactList}\small\item\em Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the stream already has data. \end{DoxyCompactList}\item 
nothing \mbox{\hyperlink{class_qore_1_1_string_output_stream_ab7ac16ba46cae914c70145b8fcb3f0b4}{write}} (\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}} data)
\begin{DoxyCompactList}\small\item\em Writes bytes to the output stream. \end{DoxyCompactList}\end{DoxyCompactItemize}


\doxysubsection{Detailed Description}
This class implements the \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}} interface for writing bytes to a \mbox{\hyperlink{basic_data_types_string}{String}} buffer. 

\begin{DoxyParagraph}{Example\+: String\+Output\+Stream basic usage}

\begin{DoxyCode}{0}
\DoxyCodeLine{StringOutputStream sos();}
\DoxyCodeLine{sos.write(<41>);}
\DoxyCodeLine{sos.write(<42>);}
\DoxyCodeLine{sos.write(<43>);}
\DoxyCodeLine{sos.getData();      \textcolor{comment}{\# returns "{}ABC"{}}}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyNote}{Note}
stream classes are not designed to be accessed from multiple threads; they have been implemented without locking for fast and efficient use when used from a single thread. For methods that would be unsafe to use in another thread, any use of such methods in threads other than the thread where the constructor was called will cause a {\ttfamily STREAM-\/\+THREAD-\/\+ERROR} to be thrown, unless the stream is handed off to another thread using the \mbox{\hyperlink{class_qore_1_1_stream_base_a017fc847a42d5c670cb9640a94522666}{Stream\+Base\+::unassign\+Thread()}} method in the thread that currently owns the stream, and the \mbox{\hyperlink{class_qore_1_1_stream_base_ab6b33cb1944c46aca8e9984ddfd65452}{Stream\+Base\+::reassign\+Thread()}} method in the new thread.
\end{DoxyNote}
\begin{DoxySeeAlso}{See also}
\mbox{\hyperlink{class_qore_1_1_stream_writer}{Stream\+Writer}} for a class that can be used to \mbox{\hyperlink{class_qore_1_1_string_output_stream_ab7ac16ba46cae914c70145b8fcb3f0b4}{write}} various kinds of data to an \mbox{\hyperlink{class_qore_1_1_output_stream}{Output\+Stream}}
\end{DoxySeeAlso}
\begin{DoxySince}{Since}
Qore 0.\+8.\+13 
\end{DoxySince}


\doxysubsection{Member Function Documentation}
\mbox{\Hypertarget{class_qore_1_1_string_output_stream_a9e72b18135630529612c2a1ab88a9706}\label{class_qore_1_1_string_output_stream_a9e72b18135630529612c2a1ab88a9706}} 
\index{Qore::StringOutputStream@{Qore::StringOutputStream}!close@{close}}
\index{close@{close}!Qore::StringOutputStream@{Qore::StringOutputStream}}
\doxysubsubsection{\texorpdfstring{close()}{close()}}
{\footnotesize\ttfamily nothing Qore\+::\+String\+Output\+Stream\+::close (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Closes the output stream and releases any resources. 

Any methods called on a closed output stream will throw an exception.


\begin{DoxyExceptions}{Exceptions}
{\em OUTPUT-\/\+STREAM-\/\+CLOSED-\/\+ERROR} & the output stream has already been closed \\
\hline
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object \\
\hline
\end{DoxyExceptions}


Implements \mbox{\hyperlink{class_qore_1_1_output_stream_a2125e17612767b9636554b282638e883}{Qore\+::\+Output\+Stream}}.

\mbox{\Hypertarget{class_qore_1_1_string_output_stream_a6ab01cef4c8993f15fd3f33ff673f93d}\label{class_qore_1_1_string_output_stream_a6ab01cef4c8993f15fd3f33ff673f93d}} 
\index{Qore::StringOutputStream@{Qore::StringOutputStream}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::StringOutputStream@{Qore::StringOutputStream}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [1/2]}}
{\footnotesize\ttfamily Qore\+::\+String\+Output\+Stream\+::constructor (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}}. 

This variant assumes the \mbox{\hyperlink{character_encoding_default_encoding}{Default Character Encoding}} for the string

\begin{DoxyNote}{Note}
raw binary data is written to the output stream, so it\textquotesingle{}s up to the caller to ensure that only valid character data for the given encoding is written to the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}} object, otherwise a string with invalid character data will be returned by \mbox{\hyperlink{class_qore_1_1_string_output_stream_a5d2573b4fcc5bda27e098eba27418d01}{get\+Data()}} 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1_string_output_stream_a7350dd527d6b743ced0d9f11ba403ec1}\label{class_qore_1_1_string_output_stream_a7350dd527d6b743ced0d9f11ba403ec1}} 
\index{Qore::StringOutputStream@{Qore::StringOutputStream}!constructor@{constructor}}
\index{constructor@{constructor}!Qore::StringOutputStream@{Qore::StringOutputStream}}
\doxysubsubsection{\texorpdfstring{constructor()}{constructor()}\hspace{0.1cm}{\footnotesize\ttfamily [2/2]}}
{\footnotesize\ttfamily Qore\+::\+String\+Output\+Stream\+::constructor (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}}}]{encoding }\end{DoxyParamCaption})}



Creates the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}}. 


\begin{DoxyParams}{Parameters}
{\em encoding} & the encoding to tag the string data with\\
\hline
\end{DoxyParams}
\begin{DoxyNote}{Note}
raw binary data is written to the output stream, so it\textquotesingle{}s up to the caller to ensure that only valid character data for the given encoding is written to the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}} object, otherwise a string with invalid character data will be returned by \mbox{\hyperlink{class_qore_1_1_string_output_stream_a5d2573b4fcc5bda27e098eba27418d01}{get\+Data()}} 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1_string_output_stream_a5d2573b4fcc5bda27e098eba27418d01}\label{class_qore_1_1_string_output_stream_a5d2573b4fcc5bda27e098eba27418d01}} 
\index{Qore::StringOutputStream@{Qore::StringOutputStream}!getData@{getData}}
\index{getData@{getData}!Qore::StringOutputStream@{Qore::StringOutputStream}}
\doxysubsubsection{\texorpdfstring{getData()}{getData()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+String\+Output\+Stream\+::get\+Data (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the data written to the stream, clearing the internal buffer. 

\begin{DoxyReturn}{Returns}
the data written to the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}}
\end{DoxyReturn}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{StringOutputStream sos();}
\DoxyCodeLine{sos.write(<41>);}
\DoxyCodeLine{sos.write(<42>);}
\DoxyCodeLine{sos.write(<43>);}
\DoxyCodeLine{sos.getData();      \textcolor{comment}{\# returns "{}ABC"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em OUTPUT-\/\+STREAM-\/\+CLOSED-\/\+ERROR} & the output stream has already been closed \\
\hline
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object \\
\hline
\end{DoxyExceptions}
\mbox{\Hypertarget{class_qore_1_1_string_output_stream_af3adfd7eb6cf48de3d2007e9484ad032}\label{class_qore_1_1_string_output_stream_af3adfd7eb6cf48de3d2007e9484ad032}} 
\index{Qore::StringOutputStream@{Qore::StringOutputStream}!getEncoding@{getEncoding}}
\index{getEncoding@{getEncoding}!Qore::StringOutputStream@{Qore::StringOutputStream}}
\doxysubsubsection{\texorpdfstring{getEncoding()}{getEncoding()}}
{\footnotesize\ttfamily \mbox{\hyperlink{group__type__conversion__functions_gacf16b4126b795f4b6933ef3425cadae3}{string}} Qore\+::\+String\+Output\+Stream\+::get\+Encoding (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}}. 

\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_CONSTANT}{CONSTANT}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{StringOutputStream sos(\textcolor{stringliteral}{"{}latin1"{}});}
\DoxyCodeLine{string encoding = sos.getEncoding();}

\end{DoxyCode}

\end{DoxyParagraph}
\begin{DoxyReturn}{Returns}
the \mbox{\hyperlink{character_encoding}{character encoding}} for the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}}
\end{DoxyReturn}
\begin{DoxyNote}{Note}
raw binary data is written to the output stream, so it\textquotesingle{}s up to the caller to ensure that only valid character data for the given encoding is written to the \mbox{\hyperlink{class_qore_1_1_string_output_stream}{String\+Output\+Stream}} object, otherwise a string with invalid character data will be returned by \mbox{\hyperlink{class_qore_1_1_string_output_stream_a5d2573b4fcc5bda27e098eba27418d01}{get\+Data()}} 
\end{DoxyNote}
\mbox{\Hypertarget{class_qore_1_1_string_output_stream_a47bdd9bdb29860476f1d93e2bd1391b5}\label{class_qore_1_1_string_output_stream_a47bdd9bdb29860476f1d93e2bd1391b5}} 
\index{Qore::StringOutputStream@{Qore::StringOutputStream}!hasData@{hasData}}
\index{hasData@{hasData}!Qore::StringOutputStream@{Qore::StringOutputStream}}
\doxysubsubsection{\texorpdfstring{hasData()}{hasData()}}
{\footnotesize\ttfamily bool Qore\+::\+String\+Output\+Stream\+::has\+Data (\begin{DoxyParamCaption}{ }\end{DoxyParamCaption})}



Returns \mbox{\hyperlink{basic_data_types_True}{True}} if the stream already has data. 

\begin{DoxyReturn}{Returns}
\mbox{\hyperlink{basic_data_types_True}{True}} if the stream already has data
\end{DoxyReturn}
\begin{DoxyParagraph}{Code Flags\+:}
\mbox{\hyperlink{code_flags_RET_VALUE_ONLY}{RET\+\_\+\+VALUE\+\_\+\+ONLY}}
\end{DoxyParagraph}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{bool has\_data = sos.hasData();}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em OUTPUT-\/\+STREAM-\/\+CLOSED-\/\+ERROR} & the output stream has already been closed \\
\hline
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object\\
\hline
\end{DoxyExceptions}
\begin{DoxySince}{Since}
Qore 1.\+1 
\end{DoxySince}
\mbox{\Hypertarget{class_qore_1_1_string_output_stream_ab7ac16ba46cae914c70145b8fcb3f0b4}\label{class_qore_1_1_string_output_stream_ab7ac16ba46cae914c70145b8fcb3f0b4}} 
\index{Qore::StringOutputStream@{Qore::StringOutputStream}!write@{write}}
\index{write@{write}!Qore::StringOutputStream@{Qore::StringOutputStream}}
\doxysubsubsection{\texorpdfstring{write()}{write()}}
{\footnotesize\ttfamily nothing Qore\+::\+String\+Output\+Stream\+::write (\begin{DoxyParamCaption}\item[{\mbox{\hyperlink{group__type__conversion__functions_gaf11c7f5c43ced1e9b95bd2270ee87ed9}{binary}}}]{data }\end{DoxyParamCaption})\hspace{0.3cm}{\ttfamily [virtual]}}



Writes bytes to the output stream. 


\begin{DoxyParams}{Parameters}
{\em data} & the data to write\\
\hline
\end{DoxyParams}
\begin{DoxyParagraph}{Example\+:}

\begin{DoxyCode}{0}
\DoxyCodeLine{StringOutputStream sos();}
\DoxyCodeLine{sos.write(<41>);}
\DoxyCodeLine{sos.write(<42>);}
\DoxyCodeLine{sos.write(<43>);}
\DoxyCodeLine{sos.getData();      \textcolor{comment}{\# returns "{}ABC"{}}}

\end{DoxyCode}

\end{DoxyParagraph}

\begin{DoxyExceptions}{Exceptions}
{\em OUTPUT-\/\+STREAM-\/\+CLOSED-\/\+ERROR} & the output stream has already been closed \\
\hline
{\em STREAM-\/\+THREAD-\/\+ERROR} & this exception is thrown if this method is called from any thread other than the thread that created the object \\
\hline
\end{DoxyExceptions}


Implements \mbox{\hyperlink{class_qore_1_1_output_stream_a9054b0475c4829d10f956d8f6df6f2ac}{Qore\+::\+Output\+Stream}}.

