/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOK_RETURN = 258,
     TOK_RETURNS = 259,
     TOK_THREAD_LOCAL = 260,
     TOK_MY = 261,
     TOK_DO = 262,
     TOK_TRY = 263,
     TOK_THROW = 264,
     TOK_CATCH = 265,
     TOK_WHERE = 266,
     TOK_WHILE = 267,
     TOK_IF = 268,
     TOK_FOR = 269,
     TOK_SUB = 270,
     TOK_THREAD_EXIT = 271,
     TOK_BREAK = 272,
     TOK_CONTINUE = 273,
     TOK_CONTEXT_ROW = 274,
     TOK_FIND = 275,
     TOK_FOREACH = 276,
     TOK_IN = 277,
     TOK_DELETE = 278,
     TOK_REMOVE = 279,
     TOK_PRIVATE = 280,
     TOK_PRIVATEINTERNAL = 281,
     TOK_PRIVATEHIERARCHY = 282,
     TOK_PUBLIC = 283,
     TOK_SYNCHRONIZED = 284,
     TOK_DEPRECATED = 285,
     TOK_CONTEXT = 286,
     TOK_SORT_BY = 287,
     TOK_SORT_DESCENDING_BY = 288,
     TOK_SUB_CONTEXT = 289,
     TOK_CONST = 290,
     TOK_SUMMARIZE = 291,
     TOK_BY = 292,
     TOK_OUR = 293,
     TOK_RETHROW = 294,
     TOK_SWITCH = 295,
     TOK_CASE = 296,
     TOK_DEFAULT = 297,
     TOK_INHERITS = 298,
     TOK_ELSE = 299,
     TOK_STATIC = 300,
     TOK_NAMESPACE = 301,
     TOK_MODULE = 302,
     TOK_FINAL = 303,
     TOK_ABSTRACT = 304,
     TOK_HASHDECL = 305,
     TOK_TRANSIENT = 306,
     TOK_NULL = 307,
     TOK_NOTHING = 308,
     TOK_TRUE = 309,
     TOK_FALSE = 310,
     TOK_UNREFERENCE = 311,
     P_INCREMENT = 312,
     P_DECREMENT = 313,
     PLUS_EQUALS = 314,
     MINUS_EQUALS = 315,
     AND_EQUALS = 316,
     OR_EQUALS = 317,
     MODULA_EQUALS = 318,
     MULTIPLY_EQUALS = 319,
     DIVIDE_EQUALS = 320,
     XOR_EQUALS = 321,
     SHIFT_LEFT_EQUALS = 322,
     SHIFT_RIGHT_EQUALS = 323,
     TOK_UNSHIFT = 324,
     TOK_PUSH = 325,
     TOK_POP = 326,
     TOK_SHIFT = 327,
     TOK_CHOMP = 328,
     TOK_TRIM = 329,
     LOGICAL_AND = 330,
     LOGICAL_OR = 331,
     BROKEN_LOGICAL_OR = 332,
     BROKEN_BINARY_OR = 333,
     BROKEN_BINARY_XOR = 334,
     LOGICAL_EQ = 335,
     LOGICAL_NE = 336,
     LOGICAL_LE = 337,
     LOGICAL_GE = 338,
     LOGICAL_CMP = 339,
     ABSOLUTE_EQ = 340,
     ABSOLUTE_NE = 341,
     REGEX_MATCH = 342,
     REGEX_NMATCH = 343,
     TOK_EXISTS = 344,
     TOK_INSTANCEOF = 345,
     SHIFT_RIGHT = 346,
     SHIFT_LEFT = 347,
     TOK_ELEMENTS = 348,
     TOK_KEYS = 349,
     TOK_NEW = 350,
     TOK_BACKGROUND = 351,
     TOK_ON_EXIT = 352,
     TOK_ON_SUCCESS = 353,
     TOK_ON_ERROR = 354,
     TOK_MAP = 355,
     TOK_FOLDR = 356,
     TOK_FOLDL = 357,
     TOK_SELECT = 358,
     TOK_SPLICE = 359,
     TOK_EXTRACT = 360,
     IMPLICIT_ELEMENT = 361,
     NULL_COALESCING = 362,
     VALUE_COALESCING = 363,
     WEAK_ASSIGNMENT = 364,
     RANGE = 365,
     INTEGER = 366,
     QFLOAT = 367,
     NUMBER = 368,
     IDENTIFIER = 369,
     HASHDECL_IDENTIFIER_OPENCURLY = 370,
     ANGLE_IDENTIFIER = 371,
     VAR_REF = 372,
     BACKQUOTE = 373,
     SELF_REF = 374,
     KW_IDENTIFIER_OPENPAREN = 375,
     SCOPED_REF = 376,
     SCOPED_VREF = 377,
     CONTEXT_REF = 378,
     COMPLEX_CONTEXT_REF = 379,
     QORE_CAST = 380,
     QORE_OR_NOTHING_CAST = 381,
     CLASS_STRING = 382,
     DATETIME = 383,
     QUOTED_WORD = 384,
     BINARY = 385,
     REGEX_SUBST = 386,
     REGEX_TRANS = 387,
     CLASS_SCOPED_REF = 388,
     BASE_CLASS_CALL = 389,
     REGEX = 390,
     REGEX_EXTRACT = 391,
     IMPLICIT_ARG_REF = 392,
     DOT_KW_IDENTIFIER = 393,
     TRY_MODULE_ERROR = 394,
     IFX = 395,
     NEG = 396,
     UPLUS = 397
   };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_THREAD_LOCAL 260
#define TOK_MY 261
#define TOK_DO 262
#define TOK_TRY 263
#define TOK_THROW 264
#define TOK_CATCH 265
#define TOK_WHERE 266
#define TOK_WHILE 267
#define TOK_IF 268
#define TOK_FOR 269
#define TOK_SUB 270
#define TOK_THREAD_EXIT 271
#define TOK_BREAK 272
#define TOK_CONTINUE 273
#define TOK_CONTEXT_ROW 274
#define TOK_FIND 275
#define TOK_FOREACH 276
#define TOK_IN 277
#define TOK_DELETE 278
#define TOK_REMOVE 279
#define TOK_PRIVATE 280
#define TOK_PRIVATEINTERNAL 281
#define TOK_PRIVATEHIERARCHY 282
#define TOK_PUBLIC 283
#define TOK_SYNCHRONIZED 284
#define TOK_DEPRECATED 285
#define TOK_CONTEXT 286
#define TOK_SORT_BY 287
#define TOK_SORT_DESCENDING_BY 288
#define TOK_SUB_CONTEXT 289
#define TOK_CONST 290
#define TOK_SUMMARIZE 291
#define TOK_BY 292
#define TOK_OUR 293
#define TOK_RETHROW 294
#define TOK_SWITCH 295
#define TOK_CASE 296
#define TOK_DEFAULT 297
#define TOK_INHERITS 298
#define TOK_ELSE 299
#define TOK_STATIC 300
#define TOK_NAMESPACE 301
#define TOK_MODULE 302
#define TOK_FINAL 303
#define TOK_ABSTRACT 304
#define TOK_HASHDECL 305
#define TOK_TRANSIENT 306
#define TOK_NULL 307
#define TOK_NOTHING 308
#define TOK_TRUE 309
#define TOK_FALSE 310
#define TOK_UNREFERENCE 311
#define P_INCREMENT 312
#define P_DECREMENT 313
#define PLUS_EQUALS 314
#define MINUS_EQUALS 315
#define AND_EQUALS 316
#define OR_EQUALS 317
#define MODULA_EQUALS 318
#define MULTIPLY_EQUALS 319
#define DIVIDE_EQUALS 320
#define XOR_EQUALS 321
#define SHIFT_LEFT_EQUALS 322
#define SHIFT_RIGHT_EQUALS 323
#define TOK_UNSHIFT 324
#define TOK_PUSH 325
#define TOK_POP 326
#define TOK_SHIFT 327
#define TOK_CHOMP 328
#define TOK_TRIM 329
#define LOGICAL_AND 330
#define LOGICAL_OR 331
#define BROKEN_LOGICAL_OR 332
#define BROKEN_BINARY_OR 333
#define BROKEN_BINARY_XOR 334
#define LOGICAL_EQ 335
#define LOGICAL_NE 336
#define LOGICAL_LE 337
#define LOGICAL_GE 338
#define LOGICAL_CMP 339
#define ABSOLUTE_EQ 340
#define ABSOLUTE_NE 341
#define REGEX_MATCH 342
#define REGEX_NMATCH 343
#define TOK_EXISTS 344
#define TOK_INSTANCEOF 345
#define SHIFT_RIGHT 346
#define SHIFT_LEFT 347
#define TOK_ELEMENTS 348
#define TOK_KEYS 349
#define TOK_NEW 350
#define TOK_BACKGROUND 351
#define TOK_ON_EXIT 352
#define TOK_ON_SUCCESS 353
#define TOK_ON_ERROR 354
#define TOK_MAP 355
#define TOK_FOLDR 356
#define TOK_FOLDL 357
#define TOK_SELECT 358
#define TOK_SPLICE 359
#define TOK_EXTRACT 360
#define IMPLICIT_ELEMENT 361
#define NULL_COALESCING 362
#define VALUE_COALESCING 363
#define WEAK_ASSIGNMENT 364
#define RANGE 365
#define INTEGER 366
#define QFLOAT 367
#define NUMBER 368
#define IDENTIFIER 369
#define HASHDECL_IDENTIFIER_OPENCURLY 370
#define ANGLE_IDENTIFIER 371
#define VAR_REF 372
#define BACKQUOTE 373
#define SELF_REF 374
#define KW_IDENTIFIER_OPENPAREN 375
#define SCOPED_REF 376
#define SCOPED_VREF 377
#define CONTEXT_REF 378
#define COMPLEX_CONTEXT_REF 379
#define QORE_CAST 380
#define QORE_OR_NOTHING_CAST 381
#define CLASS_STRING 382
#define DATETIME 383
#define QUOTED_WORD 384
#define BINARY 385
#define REGEX_SUBST 386
#define REGEX_TRANS 387
#define CLASS_SCOPED_REF 388
#define BASE_CLASS_CALL 389
#define REGEX 390
#define REGEX_EXTRACT 391
#define IMPLICIT_ARG_REF 392
#define DOT_KW_IDENTIFIER 393
#define TRY_MODULE_ERROR 394
#define IFX 395
#define NEG 396
#define UPLUS 397




/* Copy the first part of user declarations.  */
#line 1 "parser.ypp"
 /* -*- mode: c++; indent-tabs-mode: nil -*-

    parser.ypp

    Qore Programming Language

    Copyright (C) 2003 - 2021 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

    Note that the Qore library is released under a choice of three open-source
    licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
    information.
*/

#include "qore/Qore.h"
#include "qore/intern/BreakStatement.h"
#include "qore/intern/ContinueStatement.h"
#include "qore/intern/ReturnStatement.h"
#include "qore/intern/RethrowStatement.h"
#include "qore/intern/ThreadExitStatement.h"
#include "qore/intern/ExpressionStatement.h"
#include "qore/intern/DoWhileStatement.h"
#include "qore/intern/SummarizeStatement.h"
#include "qore/intern/ContextStatement.h"
#include "qore/intern/IfStatement.h"
#include "qore/intern/WhileStatement.h"
#include "qore/intern/ForStatement.h"
#include "qore/intern/ForEachStatement.h"
#include "qore/intern/TryStatement.h"
#include "qore/intern/ThrowStatement.h"
#include "qore/intern/StatementBlock.h"
#include "qore/intern/ParserSupport.h"
#include "qore/intern/SwitchStatement.h"
#include "qore/intern/CaseNodeWithOperator.h"
#include "qore/intern/CaseNodeRegex.h"
#include "qore/intern/OnBlockExitStatement.h"
#include "qore/intern/ConstantList.h"
#include "qore/intern/GlobalVariableList.h"
#include "qore/intern/QoreNamespaceIntern.h"
#include "qore/intern/QoreParseHashNode.h"
#include "qore/intern/QoreParseListNode.h"
#include "qore/intern/ModuleInfo.h"

#include "parser.hpp"

#include "qore/intern/QoreClassIntern.h"
#include "qore/intern/QoreParseClass.h"
#include "qore/intern/qore_program_private.h"
#include "qore/intern/typed_hash_decl_private.h"
#include "qore/intern/qore_list_private.h"

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <memory>
#include <sstream>
#include <utility>
#include <vector>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                         \
    do {                                                        \
        if (N) {                                                \
            (Current).first_line = YYRHSLOC(Rhs, 1).first_line; \
            (Current).first_col  = YYRHSLOC(Rhs, 1).first_col;  \
            (Current).last_line  = YYRHSLOC(Rhs, N).last_line;  \
            (Current).last_col   = YYRHSLOC(Rhs, N).last_col;   \
        } else {                                                \
            (Current).first_line = (Current).last_line =        \
                YYRHSLOC(Rhs, 0).last_line;                     \
            (Current).first_col = (Current).last_col =          \
                YYRHSLOC(Rhs, 0).last_col;                      \
        }                                                       \
    } while (0)

// to fix the start location of an expression
static void fix_start_location(int val, QoreParserLocation& loc, QoreParserLocation& exp_loc) {
    if (!val) {
        loc.first_col = exp_loc.first_col;
        loc.first_line = exp_loc.first_line;
        loc.last_col = exp_loc.last_col;
        loc.last_line = exp_loc.last_line;
    }
}

static void fix_start_location(void* val, QoreParserLocation& loc, QoreParserLocation& exp_loc) {
    fix_start_location(val ? 1 : 0, loc, exp_loc);
}

class HashElement {
public:
    QoreValue key;
    QoreValue value;
    const QoreProgramLocation* loc;

    DLLLOCAL HashElement(QoreValue k, QoreValue v, int sl, int el) : key(k), value(v), loc(qore_program_private::get(*getProgram())->getLocation(sl, el)) {
        //traceout("HashElement::HashElement()");
    }

    DLLLOCAL ~HashElement() {
        key.discard(nullptr);
        value.discard(nullptr);
    }

    DLLLOCAL void addDelete(QoreParseHashNode* h) {
        h->add(key, value, loc);
        key.clear();
        value.clear();
        delete this;
    }
};

// for constant definitions
class ConstNode {
public:
    const QoreProgramLocation* loc;
    NamedScope name;
    QoreValue value;
    bool pub;

    DLLLOCAL ConstNode(const QoreProgramLocation* loc, char* n, QoreValue v, bool p = false) : loc(loc), name(n), value(v), pub(p) {
        // see if constant definitions are allowed
        if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
            parse_error(*loc, "illegal constant definition \"%s\" (conflicts with parse option PO_NO_CONSTANT_DEFS)", n);
    }
    DLLLOCAL QoreValue takeValue() {
        QoreValue rv = value;
        value.clear();
        return rv;
    }
    DLLLOCAL const char* getName() const {
        return name.getIdentifier();
    }
    DLLLOCAL bool isPublic() const {
        return pub;
    }
};

class ObjClassDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    QoreClass* oc;

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, NamedScope *n, QoreClass* o) : loc(loc), name(n), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, char* n, QoreClass* o) : loc(loc), name(new NamedScope(n)), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ~ObjClassDef() {
        delete name;
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a class may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your class");
    }
};

class HashDeclDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    TypedHashDecl* hashdecl;

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, NamedScope *n, typed_hash_decl_private* hp) :
            loc(loc), name(n), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, char* n, typed_hash_decl_private* hp) :
            loc(loc), name(new NamedScope(n)), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL ~HashDeclDef() {
        delete name;
        if (hashdecl)
            typed_hash_decl_private::get(*hashdecl)->deref();
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a hashdecl may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your hashdecl");
    }

    DLLLOCAL TypedHashDecl* takeHashDecl() {
        TypedHashDecl* rv = hashdecl;
        hashdecl = nullptr;
        return rv;
    }
};

class ParseUserFunctionBase {
public:
    const QoreProgramLocation* loc;
    UserFunctionVariant* variant;

    DLLLOCAL ParseUserFunctionBase(const QoreProgramLocation* loc, UserFunctionVariant* v) : loc(loc), variant(v) {
    }

    DLLLOCAL ~ParseUserFunctionBase() {
        if (variant)
            variant->deref();
    }

    DLLLOCAL void setPublic() {
        variant->setModulePublic();
    }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
    char* name;

    DLLLOCAL ParseUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL ~ParseUserFunction() {
        if (name)
            free(name);
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
            const char* nsn = ns.name.c_str();
            parse_error(*loc, "function '%s%s%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
        }

        delete this;
    }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
    NamedScope name;

    DLLLOCAL ParseScopedUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
            parse_error(*loc, "function '%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", name.ostr);

        delete this;
    }
};

struct GVarDecl {
    const QoreProgramLocation* loc;
    bool pub;

    DLLLOCAL GVarDecl(const QoreProgramLocation* loc, bool p) : loc(loc), pub(p) {
    }

    DLLLOCAL virtual ~GVarDecl() {
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

    DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
    char* name;
    const QoreTypeInfo* typeInfo;
    QoreParseTypeInfo* parseTypeInfo;
    qore_var_t type;

    DLLLOCAL GVarSingleDecl(const QoreProgramLocation* loc, char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti,
            bool p, bool bare, qore_var_t type = VT_GLOBAL) : GVarDecl(loc, p), name(n), typeInfo(ti), parseTypeInfo(pti),
            type(type) {
        //printd(5, "GVarSingleDecl::GVarSingleDecl() '%s' %d-%d\n", n, loc.start_line, loc.end_line);
        if (bare) {
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "%s variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set",
                    type == VT_GLOBAL ? "global" : "thread_local", n);
        } else {
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to %s variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set",
                    type == VT_GLOBAL ? "global" : "thread_local", n);
        }
        if (qore_program_private::get(*getProgram())->expression_mode) {
            parse_error(*loc, "%s variable declaration '%s' not allowed in expressions' is set",
                type == VT_GLOBAL ? "global" : "thread_local", n);
        }
    }

    DLLLOCAL virtual ~GVarSingleDecl() {
        if (name)
            free(name);

        delete parseTypeInfo;
    }

    DLLLOCAL char* takeName() {
        char* rv = name;
        name = 0;
        return rv;
    }

    DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        ns.parseAddGlobalVarDecl(loc, takeName(), typeInfo, takeParseTypeInfo(), pub, type);
        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        GlobalVarRefNode* gv = typeInfo
            ? new GlobalVarRefNode(loc, takeName(), typeInfo, type)
            : new GlobalVarRefNode(loc, takeName(), takeParseTypeInfo(), type);
        if (pub)
            gv->setPublic();

        delete this;
        return gv;
    }
};

struct GVarListDecl : public GVarDecl {
    QoreParseListNode* l;
    qore_var_t type;

    DLLLOCAL GVarListDecl(const QoreProgramLocation* loc, QoreParseListNode* list, bool p,
            qore_var_t type = VT_GLOBAL)
            : GVarDecl(loc, p), l(list), type(type) {
        bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                if (!bareok)
                    parse_error(*loc, "variable '%s' in %s variable declaration list declared without '$' " \
                        "prefix, but parse option 'allow-bare-refs' is not set", b->str,
                        type == VT_GLOBAL ? "global" : "thread_local");
            } else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (vrn->explicitScope()) {
                    if (vrn->getType() == VT_LOCAL)
                        parse_error(*loc, "illegal use of 'my %s' in %s variable declaration list", vrn->getName(),
                            type == VT_GLOBAL ? "global" : "thread_local");
                    else if (vrn->getType() == VT_GLOBAL)
                        parse_error(*loc, "illegal use of 'our %s' in %s variable declaration list", vrn->getName(),
                            type == VT_GLOBAL ? "global" : "thread_local");
                }
            } else
                parse_error(*loc, "element %d in list following '%s' is not a variable reference (%s)", i,
                    type == VT_GLOBAL ? "our" : "thread_local", n.getTypeName());
        }
    }

    DLLLOCAL virtual ~GVarListDecl() {
        if (l) {
            l->deref(nullptr);
        }
    }

    DLLLOCAL QoreParseListNode* takeList() {
        QoreParseListNode* rv = l;
        l = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                ns.parseAddGlobalVarDecl(loc, b->takeString(), 0, 0, pub, type);
            } else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
                    if (vrdn) {
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), vrdn->getTypeInfo(),
                            vrdn->takeParseTypeInfo(), pub, type);
                    } else {
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), 0, 0, pub, type);
                    }
                }
            }
        }

        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        l->setVariableList();
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue& n = vl[i];
            qore_type_t t = n.getType();
            VarRefNode* vrn = nullptr;
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                GlobalVarRefNode* v = new GlobalVarRefNode(loc, b->takeString(), (const QoreTypeInfo*)nullptr, type);
                b->deref();
                n = vrn = v;
            } else if (t == NT_VARREF) {
                vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    vrn->makeGlobal(type);
                    vrn->setExplicitScope();
                    //printd(5, "GVarListDecl::makeVar() '%s' t: %d set global with explicit scope\n",
                    //  vrn ? vrn->getName() : "n/a", type);
                }
            }

            if (vrn && pub)
                vrn->setPublic();
        }

        QoreParseListNode* rv = takeList();
        delete this;
        return rv;
    }
};

static int check_method(const QoreProgramLocation* loc, const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error(*loc, "%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error(*loc, "base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PUBLIC     (1 << 0)
#define OFM_PRIVATE    (1 << 1)
#define OFM_INTERNAL   (1 << 2)
#define OFM_SYNCED     (1 << 3)
#define OFM_STATIC     (1 << 4)
#define OFM_DEPRECATED (1 << 5)
#define OFM_FINAL      (1 << 6)
#define OFM_ABSTRACT   (1 << 7)

static inline MethodVariantBase* new_method_variant(const QoreProgramLocation* loc, const char* name, int mod, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) {
    //printd(5, "new_method_variant() '%s' b: %p\n", name, b);

    int64 flags = QCF_NO_FLAGS;

    if (get_pop_argv_ref())
        flags |= QCF_USES_EXTRA_ARGS;

    ClassAccess access = Public;
    if (mod & OFM_PRIVATE) {
        if (mod & OFM_INTERNAL)
            parse_error(*loc, "%s() methods cannot be both private:hierarchy and private:internal", name);
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Private;
    }
    else if (mod & OFM_INTERNAL) {
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Internal;
    }

    if (mod & OFM_DEPRECATED)
        flags |= QCF_DEPRECATED;

    if (!strcmp(name, "constructor")) {
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        return new UserConstructorVariant(access, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
    }
    if (bcal) {
        parse_error(*loc, "only constructors may have base class constructor arguments");
        delete bcal;
        bcal = 0;
    }
    if (!strcmp(name, "destructor")) {
        if (params) {
            parse_error(*loc, "parameters cannot be defined for destructors");
            params.discard(nullptr);
        }
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        if (access > Public)
            parse_error(*loc, "destructors cannot be private");
        return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
    }
    if (!strcmp(name, "copy")) {
        if (mod & OFM_FINAL) {
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        }
        if (mod & OFM_ABSTRACT) {
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        }
        return new UserCopyVariant(access, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
    }

    if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; they are not inherited anyway", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract; they are not inherited anyway", name);
    }

    if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
        parse_error(*loc, "method '%s()' is declared both final and abstract", name);

    return new UserMethodVariant(access, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
    const QoreProgramLocation* loc;
    MethodVariantBase* m;
    NamedScope name;
    bool static_flag;

    DLLLOCAL MethodDef(const QoreProgramLocation* loc, int mod, char* n, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : loc(loc), m(0), name(n), static_flag(mod & OFM_STATIC) {
        if (check_method(loc, name.getIdentifier(), bcal, returnTypeInfo)) {
            params.discard(nullptr);
            delete bcal;
            delete b;
            delete returnTypeInfo;
            return;
        }

        m = new_method_variant(loc, name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b);
    }

    DLLLOCAL ~MethodDef() {
        delete m;
    }

    DLLLOCAL void parseAddToClassAndDel() {
        if (m) {
            // if there are any errors, the function below will delete memory
            // the following method takes ownership of "m" unconditionally
            qore_root_ns_private::parseAddMethodToClass(loc, name, m, static_flag);
            m = 0;
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        // the following method takes ownership of "m" unconditionally
        ns.parseAddMethodToClass(loc, name, m, static_flag);
        m = 0;
    }
};

static QoreValue parse_hash_map(const QoreProgramLocation* loc, QoreParseHashNode* exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> exph(exp, nullptr);
    ReferenceHolder<> lh(l, nullptr);

    // check hash expression
    size_t len = exp->size();

    if (len == 0) {
        qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_INVALID_OPERATION, "INVALID-OPERATION",
                "empty hash as an argument to the hash map operator, this expression will always evaluate to an empty hash");
        return new QoreHashNode(autoTypeInfo);
    }

    if (len != 1) {
        parse_error(*loc, "invalid initial argument to hash map operator, expected a single key value pair; got %d hash elements instead", len);
        return QoreValue();
    }

    if (l->size() == 1) {
        QoreValue iter = l->shift();
        return new QoreHashMapOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter);
    }

    QoreValue iter = l->shift();
    QoreValue select = l->shift();
    return new QoreHashMapSelectOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter, select);
}

static AbstractQoreNode* parse_map(const QoreProgramLocation* loc, QoreValue exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> lh(l, 0);

    if (l->size() == 1) {
        QoreValue arg = l->shift();
        return new QoreMapOperatorNode(loc, exp, arg);
    }

    QoreValue iterator_exp = l->shift();
    QoreValue select_exp = l->shift();
    return new QoreMapSelectOperatorNode(loc, exp, iterator_exp, select_exp);
}

#define NSN_NONE     0
#define NSN_OCD      1
#define NSN_HASHDECL 2
#define NSN_CONST    3
#define NSN_NS       4
#define NSN_FUNC     5
#define NSN_SFUNC    6
#define NSN_VAR      7
#define NSN_METH     8

struct NSNode {
    int type;
    union {
        ObjClassDef* ocd;
        HashDeclDef* hashdecl;
        ConstNode* cn;
        QoreNamespace* ns;
        ParseUserFunction* func;
        ParseScopedUserFunction* sfunc;
        GVarDecl* gv;
        MethodDef* meth;
    } n;

    DLLLOCAL NSNode(ObjClassDef* o) { type = NSN_OCD; n.ocd = o; }
    DLLLOCAL NSNode(HashDeclDef* h) { type = NSN_HASHDECL; n.hashdecl = h; }
    DLLLOCAL NSNode(ConstNode* c) { type = NSN_CONST; n.cn = c; }
    DLLLOCAL NSNode(QoreNamespace* s) { type = NSN_NS; n.ns = s; }
    DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
        n.func = f;
    }
    DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
        n.sfunc = f;
    }

    DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
        n.gv = gv;
    }

    DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
        n.meth = m;
    }

    DLLLOCAL void deref() {
        switch (type) {
            case NSN_OCD:
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                delete n.hashdecl;
                break;
            case NSN_CONST:
                delete n.cn;
                break;
            case NSN_NS:
                delete n.ns;
                break;
            case NSN_FUNC:
                delete n.func;
                break;
            case NSN_SFUNC:
                delete n.sfunc;
                break;
            case NSN_VAR:
                delete n.gv;
                break;
            case NSN_METH:
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        switch (type) {
            case NSN_OCD:
                //printd(5, "ocd: %s %d-%d c: %d-%d\n", n.ocd->oc->getName(), n.ocd->loc.start_line, n.ocd->loc.end_line, qore_class_private::get(*n.ocd->oc)->loc.start_line, qore_class_private::get(*n.ocd->oc)->loc.end_line);
                ns.parseAddPendingClass(n.ocd->loc, *(n.ocd->name), n.ocd->oc);
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                ns.parseAddPendingHashDecl(n.hashdecl->loc, *(n.hashdecl->name), n.hashdecl->takeHashDecl());
                delete n.hashdecl;
                break;
            case NSN_CONST:
                ns.parseAddConstant(n.cn->loc, n.cn->name, n.cn->value, n.cn->pub);
                delete n.cn;
                break;
            case NSN_NS:
                ns.parseAddNamespace(n.ns);
                break;
            case NSN_FUNC:
                n.func->add(ns);
                break;
            case NSN_SFUNC:
                n.sfunc->add(ns);
                break;
            case NSN_VAR:
                n.gv->add(ns);
                break;
            case NSN_METH:
                n.meth->add(ns);
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
    DLLLOCAL void deref() {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->deref();

        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->add(ns);
    }
};

static QoreParseListNode* splice_expressions(QoreValue a1, QoreValue a2, const QoreProgramLocation* loc1, const QoreProgramLocation* loc2) {
    //tracein("splice_expressions()");
    if (a1.getType() == NT_PARSE_LIST) {
        QoreParseListNode* l = a1.get<QoreParseListNode>();
        if (!l->isFinalized()) {
            //printd(5, "LIST x\n");
            l->add(a2, loc2);
            return l;
        }
    }
    QoreParseListNode* l = new QoreParseListNode(qore_program_private::get(*getProgram())->getLocation(*loc1, loc2->start_line, loc2->end_line));
    l->add(a1, loc1);
    l->add(a2, loc2);
    return l;
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;
typedef std::pair<char*, HashDeclMemberInfo*> hashmem_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2
#define MI_HashMem 3

struct MemberInfo {
protected:
    DLLLOCAL MemberInfo(const QoreProgramLocation* loc) : loc(loc) {
    }

public:
    const QoreProgramLocation* loc;
    char* name;
    unsigned char type;
    union {
        QoreMemberInfo* memberInfo;
        QoreVarInfo* varInfo;
        HashDeclMemberInfo* hashMemberInfo;
        QoreSimpleValue exp;
    } u;

    DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : loc(mi->loc), name(n), type(MI_Member) {
        u.memberInfo = mi;
        if (!(mi && mi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*mi->loc, "member '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL MemberInfo(const QoreProgramLocation* loc, char* n, QoreValue exp) : loc(loc), name(n), type(MI_Constant) {
        u.exp = exp;
    }

    DLLLOCAL MemberInfo(char* n, HashDeclMemberInfo* mi) : loc(mi->loc), name(n), type(MI_HashMem) {
        u.hashMemberInfo = mi;
    }

    DLLLOCAL ~MemberInfo() {
        if (name)
            free(name);
        switch (type) {
            case MI_Member:
                delete u.memberInfo;
                break;
            case MI_Var:
                delete u.varInfo;
                break;
            case MI_HashMem:
                delete u.hashMemberInfo;
                break;
            case MI_Constant:
                u.exp.discard(nullptr);
                break;
        }
    }

    DLLLOCAL member_pair_t getPair() {
        assert(type == MI_Member);
        member_pair_t m = std::make_pair(name, u.memberInfo);
        name = nullptr;
        u.memberInfo = nullptr;
        return m;
    }

    DLLLOCAL var_pair_t getVarPair() {
        assert(type == MI_Var);
        var_pair_t m = std::make_pair(name, u.varInfo);
        name = nullptr;
        u.varInfo = nullptr;
        return m;
    }

    DLLLOCAL hashmem_pair_t getHashMemPair() {
        assert(type == MI_HashMem);
        hashmem_pair_t m = std::make_pair(name, u.hashMemberInfo);
        name = nullptr;
        u.hashMemberInfo = nullptr;
        return m;
    }

    DLLLOCAL QoreValue takeExp() {
        assert(type == MI_Constant);
        QoreValue rv = u.exp;
        u.exp.clear();
        return rv;
    }

    DLLLOCAL void setTransient() {
        assert(type == MI_Member);
        u.memberInfo->setTransient();
    }
};

struct ClassVarInfo : public MemberInfo {
    DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) : MemberInfo(vi->loc) {
        name = n;
        type = MI_Var;
        u.varInfo = vi;
        if (!(vi && vi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*vi->loc, "class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL char* takeName() {
        char* n = name;
        name = nullptr;
        return n;
    }
};

class MemberList {
protected:
    // for new class members
    QoreMemberMap mmap;
    // for new class constants
    ConstantList cmap;
    // for new class static variables
    QoreVarMap vmap;

    DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
    }

public:
    DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
        if (!member)
            return;

        if (member->type == MI_Member)
            mmap.addNoCheck(member->getPair());
        else if (member->type == MI_Constant)
            cmap.parseAdd(member->loc, member->name, member->takeExp());
        else
            vmap.addNoCheck(member->getVarPair());

        delete member;
    }

    DLLLOCAL ~MemberList() {
    }

    // takes over ownership of name and typeInfo
    DLLLOCAL int add(MemberInfo* member) {
        if (!member)
            return -1;

        if (member->type == MI_Member) {
            if (mmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate member declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            mmap.addNoCheck(member->getPair());
            delete member;
        } else if (member->type == MI_Constant) {
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate constant declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "constant declaration collides with static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new constant to list
            cmap.parseAdd(member->loc, member->name, member->takeExp());
            delete member;
        } else {
            assert(member->type == MI_Var);
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "duplicate static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "static class variable declaration collides with constant declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            vmap.addNoCheck(member->getVarPair());
            delete member;
        }

        return 0;
    }

    DLLLOCAL void merge(QoreClass* qc, ClassAccess access) {
        mmap.moveAllTo(qc, access);
        vmap.moveAllTo(qc, access);

        // merge constants
        qore_class_private::get(*qc)->parseAssimilateConstants(cmap, access);
    }
};

class EmptyMemberList : public MemberList {
public:
   DLLLOCAL EmptyMemberList() {
   }
};

struct ParserTypeStruct {
protected:
    DLLLOCAL ParserTypeStruct() {
    }

public:
    const QoreTypeInfo* typeInfo = nullptr;
    QoreParseTypeInfo* parseTypeInfo = nullptr;

    DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : parseTypeInfo(n_parseTypeInfo) {
    }

    DLLLOCAL ParserTypeStruct(char* id, bool or_nothing) : typeInfo(or_nothing ? getBuiltinUserOrNothingTypeInfo(id) : getBuiltinUserTypeInfo(id)) {
        //printd(0, "ParserTypeStruct::ParserTypeStruct('%s', %d) t: %p %s\n", id, or_nothing, typeInfo, QoreTypeInfo::getName(typeInfo));
        if (typeInfo) {
            free(id);
            return;
        }

        parseTypeInfo = new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL ~ParserTypeStruct() {
        delete parseTypeInfo;
    }

    DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
        return typeInfo;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static const QoreTypeInfo* getTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getTypeInfo() : nullptr;
    }

    DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static QoreParseTypeInfo* getParseTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getParseTypeInfo() : nullptr;
    }

    DLLLOCAL const char* getClassName() {
        assert(parseTypeInfo);
        return parseTypeInfo->cscope->ostr;
    }

    DLLLOCAL static ParserTypeStruct* getType(const QoreProgramLocation* loc, char* id, bool or_nothing) {
        return new ParserTypeStruct(getParseType(loc, id, or_nothing));
    }

    DLLLOCAL static void getSubTypes(const QoreProgramLocation* loc, const char* str, parse_type_vec_t& subtypes, bool raise_error = true) {
        QoreString buf;
        bool or_nothing = false;
        bool comma = false;

        const char* p = str;
        while (true) {
            if (*p == '\0') {
                if (buf.empty()) {
                    if (comma && raise_error)
                        parse_error(*loc, "empty subtype specification in type");
                }
                else
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                break;
            }
            switch (*p) {
                case '<': {
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    const char* e = strrchr(str, '>');
                    if (!e || e < p) {
                        if (raise_error)
                            parse_error(*loc, "unbalanced angle brackets in subtype specification in '%s'", str);
                        return;
                    }
                    buf.concat(p, e - p + 1);
                    //printd(5, "ST: '%s' (str: '%s') p: %p '%s'\n", buf.c_str(), str, p, p);
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                    buf.reset();
                    or_nothing = false;
                    //printd(5, "ST: p: %p -> %p\n", p, e);
                    p = e;
                    break;
                }
                case ',':
                    buf.trim();
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing, raise_error));
                    buf.reset();
                    or_nothing = false;
                    comma = true;
                break;
                case '*': {
                    if (buf.empty())
                        or_nothing = true;
                    else
                        buf.concat('*');
                    if (comma)
                        comma = false;
                    break;
                }
                case ' ':
                case '\t':
                    if (!buf.empty())
                        buf.concat(*p);
                    break;
                default:
                    buf.concat(*p);
                    if (comma)
                        comma = false;
                break;
            }
            ++p;
        }
    }

    DLLLOCAL static QoreParseTypeInfo* getParseType(const QoreProgramLocation* loc, char* id, bool or_nothing, bool raise_error = true) {
        //printd(0, "gPT() '%s'\n", id);
        char* p0 = strchr(id, '<');
        if (p0) {
            char* p1 = strrchr(id, '>');
            if (p1 > (p0 + 1)) {
                // terminate main type string
                *p0 = '\0';
                // terminate type args
                *p1 = '\0';

                parse_type_vec_t subtypes;
                getSubTypes(loc, p0 + 1, subtypes, raise_error);
                return new QoreParseTypeInfo(id, or_nothing, std::move(subtypes));
            }
        }
        return new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL static const QoreTypeInfo* getRuntimeType(const char* str) {
        assert(str);
        assert(str[0]);
        char* p;
        bool or_nothing;
        if (str[0] == '*') {
            or_nothing = true;
            p = strdup(str + 1);
        } else {
            or_nothing = false;
            p = strdup(str);
        }
        std::unique_ptr<QoreParseTypeInfo> pt(ParserTypeStruct::getParseType(&loc_builtin, p, or_nothing, false));
        return QoreParseTypeInfo::resolveRuntime(pt.get());
    }
};

const QoreTypeInfo* qore_get_type_from_string_intern(const char* str) {
    // issue #3318: does not use ProgramRuntimeParseAccessHelper as it is normally not needed, if this is
    // necessary, then the call to this function must be wrapped using this class
    return ParserTypeStruct::getRuntimeType(str);
}

static AbstractQoreNode* process_dot(int sline, int eline, QoreValue l, QoreValue r) {
    qore_type_t rtype = r.getType();
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    switch (rtype) {
        case NT_BAREWORD: {
            BarewordNode* b = r.get<BarewordNode>();
            if (!b->isFinalized()) {
                AbstractQoreNode* rv = new QoreHashObjectDereferenceOperatorNode(loc, l, b->makeQoreStringNode());
                b->deref();
                return rv;
            }
            break;
        }

        case NT_FUNCTION_CALL: {
            FunctionCallNode* f = r.get<FunctionCallNode>();
            assert(!f->getFunction());
            if (!f->isFinalized()) {
                MethodCallNode* m = new MethodCallNode(loc, f->takeName(), f->takeParseArgs());
                f->deref();

                return new QoreDotEvalOperatorNode(loc, l, m);
            }
            break;
        }
    }

    return new QoreHashObjectDereferenceOperatorNode(loc, l, r);
}

static int check_strong_encapsulation(const QoreProgramLocation* loc, const char* type, const char* name) {
    if (parse_check_parse_option(PO_STRONG_ENCAPSULATION)) {
        parse_error(*loc, "illegal out of line %s definition \"%s\" (conflicts with parse option PO_STRONG_ENCAPSULATION)", type, name);
        return -1;
    }
    return 0;
}

static int check_case(const QoreProgramLocation* loc, const char* op, QoreValue exp) {
    // ignore if NULL (= NOTHING)
    if (exp.hasEffect()) {
        if (op)
            parse_error(*loc, "case expression with '%s' needs run-time evaluation", op);
        else
            parse_error(*loc, "case expression needs run-time evaluation", op);
        return -1;
    }
    return 0;
}

static void check_funcmod(const QoreProgramLocation* loc, int mod) {
    if (mod & (OFM_PRIVATE|OFM_INTERNAL))
        parse_error(*loc, "illegal 'private' modifier in function declaration");
    if (mod & OFM_STATIC)
        parse_error(*loc, "illegal 'static' modifier in function declaration");
    if (mod & OFM_FINAL)
        parse_error(*loc, "illegal 'final' modifier in function declaration");
    if (mod & OFM_ABSTRACT)
        parse_error(*loc, "illegal 'abstract' modifier in function declaration");
}

static void check_classmod(const QoreProgramLocation* loc, int mod, QoreClass& qc) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in class declaration");
}

static void check_hashdeclmod(const QoreProgramLocation* loc, int mod, typed_hash_decl_private& hashdecl) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in hashdecl");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in hashdecl");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in hashdecl");
   if (mod & OFM_PUBLIC)
      hashdecl.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in hashdecl");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in hashdecl");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in hashdecl");
}

static void check_nsmod(const QoreProgramLocation* loc, int mod, qore_ns_private& ns) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // if pn is a function node it's effect actually cannot be evaluated
    // at this moment because the function flags have not yet been set
    // and so has_effect() always returns 'true'
    return pn ? pn->has_effect() : true;
}

bool node_has_effect_as_root(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffectAsRoot();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // the same comment as in the above function node_has_effect() applies also here
    return pn ? pn->has_effect_as_root() : true;
}

bool value_has_effect_as_root(const QoreValue& n) {
    return node_has_effect_as_root(n.getInternalNode());
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }

   DLLLOCAL ~MethodNode() {
      free(name);
      delete m;
   }

   DLLLOCAL void addAndDelete(QoreClass* qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }

   DLLLOCAL const QoreProgramLocation* getLoc() const {
      return m->getUserVariantBase()->getUserSignature()->getParseLocation();
   }
};

static QoreValue is_rewritable_op(QoreValue n) {
    qore_type_t nt = n.getType();
    if (nt == NT_OPERATOR) {
        QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n.getInternalNode());
        if (op)
            return op->getRight();
    }

    return QoreValue();
}

static QoreValue check_rewrite_list(QoreParseListNode* l) {
    if (!parse_check_parse_option(PO_BROKEN_LIST_PARSING))
        return l;

    // rewrite expression if it's a list without parentheses and
    // the first expression has one of the following operators:
    // =, +=, -=
    if (l->isFinalized())
        return l;

    QoreValue e0 = l->get(0);

    QoreValue r = is_rewritable_op(e0);
    if (!r.isNothing()) {
        QoreValue last = e0;
        QoreValue top = e0;
        while (true) {
            QoreValue nr = is_rewritable_op(r);
            if (nr.isNothing()) {
                break;
            }
            last = r;
            r = nr;
        }
        assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last.getInternalNode()));
        // take first element from list (the tree) and make it the new expression
        QoreBinaryLValueOperatorNode* op = last.get<QoreBinaryLValueOperatorNode>();
        l->swap(0, op->swapRight(l));
        return top;
    }

    return l;
}

// cannot be static
void ignore_return_value(QoreSimpleValue& n) {
    qore_type_t t = n.getType();
    if (t == NT_OPERATOR) {
        n.get<QoreOperatorNode>()->ignoreReturnValue();
    }
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}

static QoreOperatorNode* process_assignment(int sline, int eline, QoreValue $1, QoreValue $3) {
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    return ($1.getType() == NT_PARSE_LIST)
        ? static_cast<QoreOperatorNode*>(new QoreListAssignmentOperatorNode(loc, $1, $3))
        : static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
}

static QoreOperatorNode* process_weak_assignment(const QoreProgramLocation* loc, QoreValue $1, QoreValue $3) {
   if ($1.getType() == NT_LIST) {
       parse_error(*loc, "the ':=' operator is not valid with list assignments");
       return static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
   }
   return static_cast<QoreOperatorNode*>(new QoreWeakAssignmentOperatorNode(loc, $1, $3));
}

static AbstractQoreNode* processCall(int sline, int eline, QoreValue $1, QoreValue $3, const QoreProgramLocation* argloc) {
    AbstractQoreNode* $$;
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);

    //printd(5, "1: %s, 3: %s\n", $1.getTypeName(), $3.getTypeName());
    qore_type_t t = $1.getType();
    if (t == NT_BAREWORD) {
        BarewordNode* b = $1.get<BarewordNode>();
        // take string from node and delete node
        char* str = b->takeString();
        b->deref();
        printd(5, "parsing call %s() args: %s\n", str, $3.getTypeName());
        $$ = new FunctionCallNode(loc, str, make_args(argloc, $3));
    } else if (t == NT_CONSTANT) {
        ScopedRefNode* c = $1.get<ScopedRefNode>();
        // take NamedScope from node and delete node
        NamedScope *ns = c->takeName();
        c->deref();
        assert(ns->size() > 1);
        printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
        $$ = new StaticMethodCallNode(loc, ns, make_args(argloc, $3));
    } else if (t == NT_SELF_VARREF) {
        SelfVarrefNode* v = $1.get<SelfVarrefNode>();
        // take string from node and delete node
        char* str = v->takeString();
        v->deref();
        //printd(5, "parsing in-object method call %s()\n", str);
        $$ = new SelfFunctionCallNode(loc, str, make_args(argloc, $3));
    } else {
        QoreHashObjectDereferenceOperatorNode* hodon;

        if (t == NT_OPERATOR) {
            hodon = dynamic_cast<QoreHashObjectDereferenceOperatorNode*>($1.getInternalNode());
            if (hodon) {
                QoreValue r = hodon->getRight();
                if (r.getType() != NT_STRING)
                    hodon = nullptr;
            }
        } else
            hodon = nullptr;

        if (hodon) {
            // create an object method call node
            // take the string
            QoreStringNode* str = hodon->swapRight(QoreValue()).get<QoreStringNode>();
            assert(str->getEncoding() == QCS_DEFAULT);
            char* cstr = str->giveBuffer();
            assert(cstr);
            str->deref();

            MethodCallNode* mc = new MethodCallNode(loc, cstr, make_args(argloc, $3));

            // destroy the original operator and create a new operator object
            assert(hodon->is_unique());
            QoreValue l = hodon->swapLeft(QoreValue());
            hodon->deref(nullptr);

            $$ = new QoreDotEvalOperatorNode(loc, l, mc);
        } else {
            $$ = nullptr;
            if ($1.getType() == NT_VARREF) {
                VarRefNode* r = $1.get<VarRefNode>();
                qore_var_t vartype = r->getType();

                if (vartype != VT_UNRESOLVED) {
                    $$ = r->makeNewCall($3);
                    //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
                    if (!$$) {
                        parseException(*loc, "INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
                    }
                }
            }
            if (!$$) {
                $$ = new CallReferenceCallNode(loc, $1, make_args(argloc, $3));
                printd(5, "made new CallReferenceCallNode: %p exp: %s\n", $$, $1.getTypeName());
            }
        }
    }
    return $$;
}

static void check_operator(const QoreProgramLocation* loc, const QoreOperatorNode* n, const char* parent, const char* child) {
    if (parse_check_parse_option(PO_BROKEN_LOGIC_PRECEDENCE)) {
        if (!n->getInParentheses()) {
            qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_BROKEN_LOGIC_PRECEDENCE, "BROKEN-LOGIC-PRECEDENCE", "%s gets under %s in the parse tree as an impact of broken-logic-precedence flag being set - please consider using parenthesis to enforce the desired operator precedence", child, parent);
        }
    }
}

static void check_operator_log_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreLogicalOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "logical OR");
    }
}

static void check_operator_bin_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary OR");
    }
}

static void check_operator_bin_xor(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryXorOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary XOR");
    }
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 1540 "parser.ypp"
{
    QoreSimpleValue qv;
    bool b;
    int i4;
    int64 integer;
    double decimal;
    QoreStringNode* String;
    char* string;
    BinaryNode* binary;
    AbstractQoreNode* node;
    QoreParseHashNode* hash;
    QoreParseListNode* parse_list;
    AbstractStatement* statement;
    struct MemberInfo* memberinfo;
    struct ClassVarInfo* classvarinfo;
    StatementBlock *sblock;
    ContextModList* cmods;
    ContextMod *cmod;
    class HashElement* hashelement;
    QoreFunction* userfunc;
    struct MethodNode* methodnode;
    class MemberList* memberlist;
    QoreClass* qoreclass;
    typed_hash_decl_private* hashdeclpriv;
    class ConstNode* constnode;
    QoreNamespace *ns;
    struct NSNodeList* nsnlist;
    struct NSNode* nsn;
    class ObjClassDef* classdef;
    class HashDeclDef* hashdecldef;
    DateTimeNode* datetime;
    QoreRegexSubst* RegexSubst;
    QoreTransliteration* Trans;
    SwitchStatement* switchstmt;
    CaseNode* casenode;
    BCList* sclist;
    class BCNode* sclnode;
    BCAList* bcalist;
    BCANode* bcanode;
    NamedScope *nscope;
    QoreRegex* Regex;
    QoreImplicitArgumentNode* implicit_arg;
    RetTypeInfo* returnTypeInfo;
    struct ParserTypeStruct* parsertype;
    class ParseUserFunction* parsefunc;
    class ParseScopedUserFunction* sparsefunc;
    struct GVarDecl* gv;
    QoreNumberNode* num;
    TryModuleError* trymod;
    struct MethodDef* methoddef;
}
/* Line 193 of yacc.c.  */
#line 1961 "parser.cpp"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */
#line 1592 "parser.ypp"


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE* loc, yyscan_t scanner, const char* str) {
    //printd(5, "yyerror() location: %d:%d - %d:%d \"%s\"\n", loc->first_line, loc->first_col, loc->last_line, loc->last_col, str);
    const QoreProgramLocation* qloc = qore_program_private::get(*getProgram())->getLocation(loc->first_line, loc->last_line);
    parse_error(*qloc, "%s", str);
}



/* Line 216 of yacc.c.  */
#line 1999 "parser.cpp"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  215
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   13817

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  168
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  68
/* YYNRULES -- Number of rules.  */
#define YYNRULES  447
/* YYNRULES -- Number of states.  */
#define YYNSTATES  957

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   397

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   159,     2,     2,     2,   152,   147,     2,
     163,   166,   153,   150,   141,   151,   162,   154,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   144,   165,
     148,   142,   149,   143,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   161,   158,   167,   146,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   160,   145,   164,   157,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   155,   156
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    27,    31,    33,    38,    40,    42,    45,
      50,    51,    53,    58,    62,    67,    71,    76,    81,    87,
      92,    96,   101,   105,   110,   115,   121,   127,   131,   136,
     138,   141,   143,   145,   147,   149,   151,   153,   156,   158,
     160,   166,   173,   179,   186,   190,   193,   195,   197,   199,
     201,   204,   207,   208,   210,   212,   215,   221,   223,   226,
     230,   233,   236,   239,   243,   255,   263,   269,   277,   283,
     291,   301,   309,   312,   315,   318,   321,   323,   326,   327,
     330,   335,   340,   345,   347,   350,   358,   360,   363,   369,
     374,   380,   385,   391,   396,   402,   407,   413,   418,   424,
     429,   435,   440,   445,   449,   454,   458,   462,   465,   473,
     474,   476,   478,   485,   492,   499,   506,   511,   516,   522,
     528,   531,   532,   534,   538,   540,   542,   545,   548,   551,
     554,   557,   560,   563,   566,   568,   571,   575,   581,   588,
     590,   592,   594,   596,   598,   601,   604,   607,   610,   613,
     615,   617,   619,   622,   625,   628,   629,   631,   635,   640,
     644,   648,   653,   657,   661,   666,   670,   674,   679,   683,
     688,   692,   699,   705,   713,   717,   723,   730,   734,   740,
     747,   750,   755,   757,   759,   762,   764,   767,   770,   772,
     774,   778,   782,   784,   786,   789,   792,   795,   798,   800,
     808,   816,   824,   832,   841,   850,   859,   868,   876,   884,
     887,   888,   890,   894,   899,   904,   905,   907,   909,   912,
     914,   916,   918,   920,   922,   924,   926,   928,   930,   933,
     934,   941,   948,   956,   964,   972,   980,   989,   998,  1002,
    1005,  1009,  1012,  1014,  1018,  1021,  1025,  1029,  1033,  1036,
    1038,  1040,  1044,  1046,  1049,  1052,  1055,  1059,  1062,  1066,
    1071,  1073,  1075,  1077,  1079,  1081,  1090,  1093,  1096,  1099,
    1102,  1105,  1108,  1111,  1114,  1117,  1120,  1123,  1126,  1129,
    1132,  1135,  1138,  1141,  1146,  1150,  1152,  1155,  1158,  1161,
    1164,  1167,  1173,  1179,  1185,  1188,  1190,  1194,  1197,  1204,
    1211,  1219,  1227,  1229,  1231,  1234,  1237,  1242,  1247,  1249,
    1251,  1253,  1255,  1258,  1262,  1266,  1270,  1274,  1278,  1282,
    1286,  1290,  1294,  1298,  1302,  1306,  1310,  1314,  1318,  1324,
    1327,  1330,  1335,  1339,  1343,  1347,  1351,  1355,  1359,  1363,
    1367,  1371,  1375,  1379,  1383,  1387,  1391,  1395,  1399,  1403,
    1407,  1411,  1415,  1419,  1423,  1427,  1431,  1435,  1439,  1443,
    1447,  1451,  1457,  1463,  1468,  1473,  1478,  1482,  1486,  1489,
    1491,  1493,  1497,  1501,  1505,  1509,  1513,  1517,  1521,  1525,
    1529,  1533,  1537,  1541,  1545,  1549,  1553,  1559,  1562,  1565,
    1570,  1574,  1578,  1582,  1586,  1590,  1594,  1598,  1602,  1606,
    1610,  1614,  1618,  1622,  1626,  1630,  1634,  1638,  1642,  1646,
    1650,  1654,  1658,  1662,  1666,  1670,  1674,  1678,  1682,  1686,
    1692,  1698,  1703,  1708,  1713,  1717,  1721,  1724,  1726,  1729,
    1731,  1733,  1735,  1737,  1739,  1741,  1743,  1745
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     169,     0,    -1,   170,    -1,   169,   170,    -1,   223,    -1,
     224,    -1,   194,    -1,   193,    -1,   179,    -1,   178,    -1,
     215,    -1,   184,    -1,   160,   164,    -1,   160,   182,   164,
      -1,   175,    -1,    47,   160,   171,   164,    -1,   139,    -1,
     172,    -1,   171,   172,    -1,   114,   142,   232,   165,    -1,
      -1,    28,    -1,   173,    38,   201,   121,    -1,   173,    38,
     121,    -1,   173,    38,   201,   114,    -1,   173,    38,   114,
      -1,   173,    38,   202,   122,    -1,   173,    38,   202,   117,
      -1,   173,    38,   163,   225,   166,    -1,   173,     5,   201,
     121,    -1,   173,     5,   121,    -1,   173,     5,   201,   114,
      -1,   173,     5,   114,    -1,   173,     5,   202,   122,    -1,
     173,     5,   202,   117,    -1,   173,     5,   163,   225,   166,
      -1,   219,    46,   160,   176,   164,    -1,   219,    46,   165,
      -1,   219,    46,   160,   164,    -1,   177,    -1,   176,   177,
      -1,   179,    -1,   178,    -1,   194,    -1,   193,    -1,   223,
      -1,   224,    -1,   174,   165,    -1,   175,    -1,   215,    -1,
      35,   114,   142,   232,   165,    -1,    28,    35,   114,   142,
     232,   165,    -1,    35,   121,   142,   232,   165,    -1,    28,
      35,   121,   142,   232,   165,    -1,   160,   182,   164,    -1,
     160,   164,    -1,   184,    -1,   180,    -1,   184,    -1,   180,
      -1,   182,   180,    -1,   182,   184,    -1,    -1,   114,    -1,
     165,    -1,   233,   165,    -1,   121,   163,   192,   166,   165,
      -1,   191,    -1,    39,   165,    -1,     9,   232,   165,    -1,
      97,   181,    -1,    98,   181,    -1,    99,   181,    -1,    34,
     185,   181,    -1,    36,   183,   163,   232,   166,    37,   163,
     232,   166,   185,   181,    -1,    31,   183,   163,   232,   166,
     185,   181,    -1,    13,   163,   232,   166,   181,    -1,    13,
     163,   232,   166,   181,    44,   181,    -1,    12,   163,   232,
     166,   181,    -1,     7,   181,    12,   163,   232,   166,   165,
      -1,    14,   163,   192,   165,   192,   165,   192,   166,   181,
      -1,    21,   232,    22,   163,   232,   166,   181,    -1,   187,
     165,    -1,    16,   165,    -1,    17,   165,    -1,    18,   165,
      -1,   188,    -1,     1,   165,    -1,    -1,   185,   186,    -1,
      11,   163,   232,   166,    -1,    32,   163,   232,   166,    -1,
      33,   163,   232,   166,    -1,     3,    -1,     3,   232,    -1,
      40,   163,   232,   166,   160,   189,   164,    -1,   190,    -1,
     189,   190,    -1,    41,    83,   232,   144,   182,    -1,    41,
      83,   232,   144,    -1,    41,    82,   232,   144,   182,    -1,
      41,    82,   232,   144,    -1,    41,    80,   232,   144,   182,
      -1,    41,    80,   232,   144,    -1,    41,   148,   232,   144,
     182,    -1,    41,   148,   232,   144,    -1,    41,   149,   232,
     144,   182,    -1,    41,   149,   232,   144,    -1,    41,    87,
     135,   144,   182,    -1,    41,    87,   135,   144,    -1,    41,
      88,   135,   144,   182,    -1,    41,    88,   135,   144,    -1,
      41,   135,   144,   182,    -1,    41,   135,   144,    -1,    41,
     232,   144,   182,    -1,    41,   232,   144,    -1,    42,   144,
     182,    -1,    42,   144,    -1,     8,   181,    10,   163,   192,
     166,   181,    -1,    -1,   232,    -1,     1,    -1,   219,    50,
     114,   160,   198,   164,    -1,   219,    50,   121,   160,   198,
     164,    -1,   219,   127,   195,   160,   200,   164,    -1,   219,
     133,   195,   160,   200,   164,    -1,   219,   127,   195,   165,
      -1,   219,   133,   195,   165,    -1,   219,   127,   195,   160,
     164,    -1,   219,   133,   195,   160,   164,    -1,    43,   196,
      -1,    -1,   197,    -1,   196,   141,   197,    -1,   114,    -1,
     121,    -1,    28,   114,    -1,    28,   121,    -1,    25,   114,
      -1,    25,   121,    -1,    27,   114,    -1,    27,   121,    -1,
      26,   114,    -1,    26,   121,    -1,   199,    -1,   198,   199,
      -1,   201,   114,   165,    -1,   201,   114,   142,   232,   165,
      -1,   201,   114,   163,   192,   166,   165,    -1,   214,    -1,
     203,    -1,   204,    -1,   205,    -1,   178,    -1,   200,   214,
      -1,   200,   203,    -1,   200,   204,    -1,   200,   205,    -1,
     200,   178,    -1,   114,    -1,   121,    -1,   116,    -1,   153,
     114,    -1,   153,   121,    -1,   153,   116,    -1,    -1,   201,
      -1,    26,   211,   165,    -1,    26,   160,   212,   164,    -1,
      26,   160,   164,    -1,    25,   211,   165,    -1,    25,   160,
     212,   164,    -1,    25,   160,   164,    -1,    27,   211,   165,
      -1,    27,   160,   212,   164,    -1,    27,   160,   164,    -1,
      28,   211,   165,    -1,    28,   160,   212,   164,    -1,    28,
     160,   164,    -1,    45,   201,   114,   165,    -1,    45,   114,
     165,    -1,    45,   201,   114,   142,   232,   165,    -1,    45,
     114,   142,   232,   165,    -1,    45,   201,   114,   163,   192,
     166,   165,    -1,   202,   119,   165,    -1,   202,   119,   142,
     232,   165,    -1,   202,   119,   163,   192,   166,   165,    -1,
     201,   114,   165,    -1,   201,   114,   142,   232,   165,    -1,
     201,   114,   163,   192,   166,   165,    -1,   114,   165,    -1,
     114,   142,   232,   165,    -1,   206,    -1,   178,    -1,    51,
     207,    -1,   119,    -1,   119,   121,    -1,    51,   209,    -1,
     209,    -1,   210,    -1,   211,   141,   209,    -1,   211,   141,
     210,    -1,   207,    -1,   208,    -1,   212,   207,    -1,   212,
     208,    -1,   114,   163,    -1,    94,   163,    -1,   120,    -1,
     219,   213,   192,   166,   216,   222,   180,    -1,   219,   201,
     213,   192,   166,   216,   180,    -1,   219,   213,   192,   166,
     216,   222,   165,    -1,   219,   201,   213,   192,   166,   216,
     165,    -1,   220,   121,   163,   192,   166,   216,   222,   180,
      -1,   220,   201,   121,   163,   192,   166,   216,   180,    -1,
     220,   121,   163,   192,   166,   216,   222,   165,    -1,   220,
     201,   121,   163,   192,   166,   216,   165,    -1,   121,   163,
     192,   166,   216,   222,   180,    -1,   201,   121,   163,   192,
     166,   216,   180,    -1,   144,   217,    -1,    -1,   218,    -1,
     217,   141,   218,    -1,   114,   163,   192,   166,    -1,   121,
     163,   192,   166,    -1,    -1,   220,    -1,   221,    -1,   220,
     221,    -1,    25,    -1,    27,    -1,    26,    -1,    45,    -1,
      29,    -1,    30,    -1,    28,    -1,    48,    -1,    49,    -1,
       4,   202,    -1,    -1,    15,   213,   192,   166,   222,   180,
      -1,   201,    15,   213,   192,   166,   180,    -1,   220,    15,
     213,   192,   166,   222,   180,    -1,   220,   201,    15,   213,
     192,   166,   180,    -1,    15,   121,   163,   192,   166,   222,
     180,    -1,   201,    15,   121,   163,   192,   166,   180,    -1,
     220,    15,   121,   163,   192,   166,   222,   180,    -1,   220,
     201,    15,   121,   163,   192,   166,   180,    -1,   232,   141,
     232,    -1,   232,   141,    -1,   233,   141,   232,    -1,   233,
     141,    -1,   228,    -1,   227,   141,   228,    -1,   227,   141,
      -1,   232,   144,   232,    -1,   160,   227,   164,    -1,   115,
     227,   164,    -1,   115,   164,    -1,   235,    -1,   130,    -1,
     163,   227,   166,    -1,   121,    -1,   202,   117,    -1,   202,
     122,    -1,   201,   114,    -1,     6,   201,   114,    -1,     6,
     114,    -1,     6,   202,   117,    -1,     6,   163,   225,   166,
      -1,   174,    -1,   114,    -1,   123,    -1,    19,    -1,   124,
      -1,    20,   232,    22,   232,    11,   163,   232,   166,    -1,
      89,   232,    -1,    93,   232,    -1,    94,   232,    -1,    69,
     232,    -1,    72,   232,    -1,    70,   232,    -1,    71,   232,
      -1,    73,   232,    -1,    74,   232,    -1,   104,   232,    -1,
     105,   232,    -1,   100,   232,    -1,   101,   232,    -1,   102,
     232,    -1,   103,   232,    -1,    57,   232,    -1,    58,   232,
      -1,   134,   163,   192,   166,    -1,   120,   192,   166,    -1,
     119,    -1,   151,   232,    -1,   150,   232,    -1,   157,   232,
      -1,   159,   232,    -1,   158,   232,    -1,    95,   114,   163,
     192,   166,    -1,    95,   121,   163,   192,   166,    -1,    95,
     116,   163,   192,   166,    -1,    96,   232,    -1,   118,    -1,
     163,   232,   166,    -1,   163,   166,    -1,    15,   163,   192,
     166,   222,   180,    -1,   201,    15,   163,   192,   166,   180,
      -1,   220,    15,   163,   192,   166,   222,   180,    -1,   220,
     201,    15,   163,   192,   166,   180,    -1,   137,    -1,   106,
      -1,    23,   232,    -1,    24,   232,    -1,   125,   163,   232,
     166,    -1,   126,   163,   232,   166,    -1,   231,    -1,   225,
      -1,   229,    -1,   230,    -1,   160,   164,    -1,   232,    59,
     232,    -1,   232,    60,   232,    -1,   232,    61,   232,    -1,
     232,    62,   232,    -1,   232,    63,   232,    -1,   232,    64,
     232,    -1,   232,    65,   232,    -1,   232,    66,   232,    -1,
     232,    67,   232,    -1,   232,    68,   232,    -1,   232,   142,
     232,    -1,   232,   109,   232,    -1,   232,    90,   201,    -1,
     232,   107,   232,    -1,   232,   108,   232,    -1,   232,   143,
     232,   144,   232,    -1,   232,    57,    -1,   232,    58,    -1,
     232,   163,   192,   166,    -1,   232,    75,   232,    -1,   232,
      76,   232,    -1,   232,    77,   232,    -1,   232,    78,   232,
      -1,   232,    79,   232,    -1,   232,   145,   232,    -1,   232,
     147,   232,    -1,   232,   146,   232,    -1,   232,    87,   135,
      -1,   232,    88,   135,    -1,   232,    87,   131,    -1,   232,
      87,   132,    -1,   232,    87,   136,    -1,   232,   149,   232,
      -1,   232,   148,   232,    -1,   232,    84,   232,    -1,   232,
      80,   232,    -1,   232,    85,   232,    -1,   232,    86,   232,
      -1,   232,    81,   232,    -1,   232,    82,   232,    -1,   232,
      83,   232,    -1,   232,    92,   232,    -1,   232,    91,   232,
      -1,   232,   150,   232,    -1,   232,   151,   232,    -1,   232,
     152,   232,    -1,   232,   154,   232,    -1,   232,   153,   232,
      -1,   232,   161,   232,   110,   167,    -1,   232,   161,   110,
     232,   167,    -1,   232,   161,   110,   167,    -1,   232,   161,
     232,   167,    -1,   232,   160,   232,   164,    -1,   232,   110,
     232,    -1,   232,   162,   232,    -1,   232,   138,    -1,   231,
      -1,   226,    -1,   233,    59,   232,    -1,   233,    60,   232,
      -1,   233,    61,   232,    -1,   233,    62,   232,    -1,   233,
      63,   232,    -1,   233,    64,   232,    -1,   233,    65,   232,
      -1,   233,    66,   232,    -1,   233,    67,   232,    -1,   233,
      68,   232,    -1,   233,   142,   232,    -1,   233,   109,   232,
      -1,   233,    90,   201,    -1,   233,   107,   232,    -1,   233,
     108,   232,    -1,   233,   143,   232,   144,   232,    -1,   233,
      57,    -1,   233,    58,    -1,   233,   163,   192,   166,    -1,
     233,    75,   232,    -1,   233,    76,   232,    -1,   233,    77,
     232,    -1,   233,    78,   232,    -1,   233,    79,   232,    -1,
     233,   145,   232,    -1,   233,   147,   232,    -1,   233,   146,
     232,    -1,   233,    87,   135,    -1,   233,    88,   135,    -1,
     233,    87,   131,    -1,   233,    87,   132,    -1,   233,    87,
     136,    -1,   233,   149,   232,    -1,   233,   148,   232,    -1,
     233,    84,   232,    -1,   233,    80,   232,    -1,   233,    85,
     232,    -1,   233,    86,   232,    -1,   233,    81,   232,    -1,
     233,    82,   232,    -1,   233,    83,   232,    -1,   233,    92,
     232,    -1,   233,    91,   232,    -1,   233,   150,   232,    -1,
     233,   151,   232,    -1,   233,   152,   232,    -1,   233,   154,
     232,    -1,   233,   153,   232,    -1,   233,   161,   232,   110,
     167,    -1,   233,   161,   110,   232,   167,    -1,   233,   161,
     110,   167,    -1,   233,   161,   232,   167,    -1,   233,   160,
     232,   164,    -1,   233,   110,   232,    -1,   233,   162,   232,
      -1,   233,   138,    -1,   129,    -1,   129,   234,    -1,   112,
      -1,   111,    -1,   234,    -1,   128,    -1,   113,    -1,    53,
      -1,    52,    -1,    54,    -1,    55,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1856,  1856,  1857,  1861,  1864,  1869,  1877,  1881,  1887,
    1891,  1896,  1904,  1905,  1909,  1916,  1926,  1951,  1953,  1958,
    1972,  1973,  1979,  1988,  1995,  2002,  2007,  2016,  2023,  2028,
    2037,  2044,  2051,  2056,  2065,  2072,  2080,  2089,  2096,  2106,
    2111,  2119,  2124,  2127,  2135,  2138,  2141,  2146,  2149,  2157,
    2163,  2166,  2172,  2175,  2181,  2184,  2189,  2192,  2197,  2199,
    2201,  2203,  2209,  2210,  2214,  2215,  2245,  2252,  2254,  2257,
    2260,  2263,  2266,  2269,  2272,  2275,  2278,  2281,  2284,  2287,
    2290,  2293,  2296,  2297,  2305,  2308,  2311,  2312,  2317,  2318,
    2329,  2331,  2333,  2338,  2340,  2344,  2353,  2357,  2365,  2371,
    2377,  2383,  2389,  2395,  2401,  2407,  2413,  2419,  2425,  2430,
    2435,  2440,  2445,  2450,  2455,  2461,  2467,  2472,  2480,  2528,
    2529,  2530,  2534,  2540,  2549,  2556,  2565,  2574,  2585,  2594,
    2608,  2611,  2617,  2620,  2627,  2631,  2635,  2639,  2643,  2647,
    2651,  2655,  2659,  2663,  2670,  2678,  2694,  2699,  2704,  2731,
    2735,  2741,  2747,  2753,  2759,  2763,  2768,  2773,  2778,  2787,
    2790,  2793,  2797,  2800,  2803,  2811,  2812,  2818,  2819,  2820,
    2824,  2825,  2826,  2827,  2828,  2829,  2833,  2834,  2835,  2839,
    2844,  2848,  2854,  2858,  2881,  2889,  2897,  2922,  2929,  2936,
    2960,  2966,  2972,  2975,  2985,  2992,  2998,  3007,  3014,  3017,
    3020,  3024,  3031,  3034,  3037,  3041,  3048,  3051,  3054,  3060,
    3072,  3088,  3096,  3111,  3122,  3135,  3141,  3150,  3154,  3164,
    3167,  3173,  3176,  3183,  3187,  3195,  3196,  3201,  3202,  3212,
    3213,  3214,  3215,  3216,  3217,  3218,  3219,  3220,  3224,  3241,
    3247,  3253,  3263,  3275,  3293,  3299,  3309,  3321,  3339,  3344,
    3364,  3369,  3383,  3388,  3392,  3397,  3402,  3412,  3421,  3430,
    3432,  3434,  3436,  3441,  3456,  3468,  3475,  3484,  3495,  3512,
    3547,  3550,  3558,  3563,  3568,  3573,  3578,  3583,  3588,  3592,
    3606,  3610,  3624,  3628,  3632,  3636,  3660,  3684,  3712,  3728,
    3744,  3760,  3764,  3768,  3776,  3782,  3789,  3796,  3801,  3805,
    3809,  3840,  3847,  3854,  3861,  3875,  3881,  3898,  3904,  3909,
    3917,  3926,  3939,  3943,  3947,  3951,  3955,  3959,  3966,  3967,
    3968,  3969,  3970,  3971,  3972,  3973,  3974,  3975,  3976,  3977,
    3978,  3979,  3980,  3981,  3984,  3992,  3999,  4000,  4001,  4002,
    4003,  4004,  4005,  4010,  4011,  4012,  4013,  4018,  4019,  4025,
    4026,  4027,  4028,  4029,  4030,  4031,  4032,  4033,  4034,  4035,
    4036,  4037,  4038,  4039,  4040,  4041,  4042,  4043,  4044,  4045,
    4046,  4047,  4048,  4049,  4053,  4067,  4068,  4069,  4070,  4074,
    4075,  4076,  4077,  4078,  4079,  4080,  4081,  4082,  4083,  4084,
    4085,  4086,  4089,  4097,  4104,  4105,  4106,  4107,  4108,  4109,
    4110,  4115,  4116,  4117,  4118,  4123,  4124,  4130,  4131,  4132,
    4133,  4134,  4135,  4136,  4137,  4138,  4139,  4140,  4141,  4142,
    4143,  4144,  4145,  4146,  4147,  4148,  4149,  4150,  4151,  4152,
    4153,  4154,  4159,  4174,  4175,  4176,  4177,  4181,  4184,  4192,
    4193,  4194,  4195,  4196,  4197,  4198,  4199,  4200
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"",
  "\"thread_local\"", "\"my\"", "\"do\"", "\"try\"", "\"throw\"",
  "\"catch\"", "\"where\"", "\"while\"", "\"if\"", "\"for\"", "\"sub\"",
  "\"thread_exit\"", "\"break\"", "\"continue\"", "\"%%\"", "\"find\"",
  "\"foreach\"", "\"in\"", "\"delete\"", "\"remove\"", "\"private\"",
  "\"private:internal\"", "\"private:hierarchy\"", "\"public\"",
  "\"synchronized\"", "\"deprecated\"", "\"context\"", "\"sortBy\"",
  "\"sortDescendingBy\"", "\"subcontext\"", "\"const\"", "\"summarize\"",
  "\"by\"", "\"our\"", "\"rethrow\"", "\"switch\"", "\"case\"",
  "\"default\"", "\"inherits\"", "\"else\"", "\"static\"", "\"namespace\"",
  "\"module\"", "\"final\"", "\"abstract\"", "\"hashdecl\"",
  "\"transient\"", "\"NULL\"", "\"NOTHING\"", "\"True\"", "\"False\"",
  "\"unreference\"", "\"++ operator\"", "\"-- operator\"",
  "\"+= operator\"", "\"-= operator\"", "\"&= operator\"",
  "\"|= operator\"", "\"%= operator\"", "\"*= operator\"",
  "\"/= operator\"", "\"^= operator\"", "\"<<= operator\"",
  "\">>= operator\"", "\"unshift\"", "\"push\"", "\"pop\"", "\"shift\"",
  "\"chomp\"", "\"trim\"", "\"&& operator\"", "\"|| operator\"",
  "\"|| operator (compat)\"", "\"| operator (compat)\"",
  "\"^ operator (compat)\"", "\"== operator\"", "\"!= operator\"",
  "\"<= operator\"", "\">= operator\"", "\"<=> operator\"",
  "\"=== operator\"", "\"!== operator\"", "\"=~ operator\"",
  "\"!~ operator\"", "\"exists\"", "\"instanceof\"", "\">> operator\"",
  "\"<< operator\"", "\"elements\"", "\"keys\"", "\"new\"",
  "\"background\"", "\"on_exit\"", "\"on_success\"", "\"on_error\"",
  "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"", "\"splice\"",
  "\"extract\"", "\"$# operator\"", "\"?? operator\"", "\"?* operator\"",
  "\":= operator\"", "\".. operator\"", "\"integer value\"",
  "\"floating-point value\"", "\"arbitrary-precision number\"",
  "\"identifier\"", "\"typed hash identifier\"",
  "\"complex type identifier\"", "\"variable reference\"",
  "\"backquote expression\"", "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"cast (or nothing) operator\"",
  "\"simple class declaration\"", "\"date/time value\"",
  "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'|'",
  "'^'", "'&'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "UPLUS", "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'",
  "';'", "')'", "']'", "$accept", "top_level_commands",
  "top_level_command", "module_decls", "module_decl", "ppub", "gvardecl",
  "top_namespace_decl", "namespace_decls", "namespace_decl",
  "unscoped_const_decl", "scoped_const_decl", "block",
  "statement_or_block", "statements", "optname", "statement",
  "context_mods", "context_mod", "return_statement", "switch_statement",
  "case_block", "case_code", "try_statement", "myexp", "hashdecl_def",
  "class_def", "inheritance_list", "superclass_list", "superclass",
  "hashdecl_attrs", "hashdecl_member", "class_attributes", "uncqtypedef",
  "qtypedef", "internal_member_list", "private_member_list",
  "public_member_list", "classvardecl", "member2", "transient_member2",
  "member", "transient_member", "member_list", "member_list2",
  "ident_openparen", "inline_methoddef", "outofline_methoddef",
  "base_constructor_list", "base_constructors", "base_constructor",
  "nsc_modifiers", "method_modifiers", "method_modifier", "return_value",
  "sub_def", "scoped_sub_def", "list", "list_n", "hash", "hash_element",
  "alt_hash", "immediate_typed_hash", "exp_c", "exp", "exp_n", "string",
  "scalar", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    44,    61,    63,    58,   124,    94,    38,    60,    62,
      43,    45,    37,    42,    47,   396,   397,   126,    92,    33,
     123,    91,    46,    40,   125,    59,    41,    93
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   168,   169,   169,   170,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   171,   171,   172,
     173,   173,   174,   174,   174,   174,   174,   174,   174,   174,
     174,   174,   174,   174,   174,   174,   175,   175,   175,   176,
     176,   177,   177,   177,   177,   177,   177,   177,   177,   177,
     178,   178,   179,   179,   180,   180,   181,   181,   182,   182,
     182,   182,   183,   183,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   185,   185,
     186,   186,   186,   187,   187,   188,   189,   189,   190,   190,
     190,   190,   190,   190,   190,   190,   190,   190,   190,   190,
     190,   190,   190,   190,   190,   190,   190,   190,   191,   192,
     192,   192,   193,   193,   194,   194,   194,   194,   194,   194,
     195,   195,   196,   196,   197,   197,   197,   197,   197,   197,
     197,   197,   197,   197,   198,   198,   199,   199,   199,   200,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   201,
     201,   201,   201,   201,   201,   202,   202,   203,   203,   203,
     204,   204,   204,   204,   204,   204,   205,   205,   205,   206,
     206,   206,   206,   206,   207,   207,   207,   207,   207,   207,
     207,   207,   207,   207,   208,   209,   209,   210,   211,   211,
     211,   211,   212,   212,   212,   212,   213,   213,   213,   214,
     214,   214,   214,   215,   215,   215,   215,   215,   215,   216,
     216,   217,   217,   218,   218,   219,   219,   220,   220,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   222,   222,
     223,   223,   223,   223,   224,   224,   224,   224,   225,   225,
     226,   226,   227,   227,   227,   228,   229,   230,   230,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   234,   234,   235,
     235,   235,   235,   235,   235,   235,   235,   235
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     4,     1,     1,     2,     4,
       0,     1,     4,     3,     4,     3,     4,     4,     5,     4,
       3,     4,     3,     4,     4,     5,     5,     3,     4,     1,
       2,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       5,     6,     5,     6,     3,     2,     1,     1,     1,     1,
       2,     2,     0,     1,     1,     2,     5,     1,     2,     3,
       2,     2,     2,     3,    11,     7,     5,     7,     5,     7,
       9,     7,     2,     2,     2,     2,     1,     2,     0,     2,
       4,     4,     4,     1,     2,     7,     1,     2,     5,     4,
       5,     4,     5,     4,     5,     4,     5,     4,     5,     4,
       5,     4,     4,     3,     4,     3,     3,     2,     7,     0,
       1,     1,     6,     6,     6,     6,     4,     4,     5,     5,
       2,     0,     1,     3,     1,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     1,     2,     3,     5,     6,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     1,
       1,     1,     2,     2,     2,     0,     1,     3,     4,     3,
       3,     4,     3,     3,     4,     3,     3,     4,     3,     4,
       3,     6,     5,     7,     3,     5,     6,     3,     5,     6,
       2,     4,     1,     1,     2,     1,     2,     2,     1,     1,
       3,     3,     1,     1,     2,     2,     2,     2,     1,     7,
       7,     7,     7,     8,     8,     8,     8,     7,     7,     2,
       0,     1,     3,     4,     4,     0,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       6,     6,     7,     7,     7,     7,     8,     8,     3,     2,
       3,     2,     1,     3,     2,     3,     3,     3,     2,     1,
       1,     3,     1,     2,     2,     2,     3,     2,     3,     4,
       1,     1,     1,     1,     1,     8,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     4,     3,     1,     2,     2,     2,     2,
       2,     5,     5,     5,     2,     1,     3,     2,     6,     6,
       7,     7,     1,     1,     2,     2,     4,     4,     1,     1,
       1,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     5,     2,
       2,     4,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     5,     5,     4,     4,     4,     3,     3,     2,     1,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     5,     2,     2,     4,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       5,     4,     4,     4,     3,     3,     2,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,    20,   165,     0,     0,    20,     0,     0,     0,
       0,     0,     0,     0,   273,    20,    20,    20,    20,   229,
     231,   230,   235,   233,   234,    62,    88,     0,    62,     0,
       0,   232,     0,   236,   237,   445,   444,   446,   447,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
       0,    20,     0,     0,     0,    20,    20,    20,    20,    20,
      20,   313,   440,   439,   443,   271,   161,   305,   295,     0,
     262,   272,   274,     0,     0,   442,   437,   260,     0,   312,
      16,    20,    20,     0,    20,    20,    20,     0,    20,    64,
       0,     2,     0,   270,    14,     9,     8,    11,     0,    86,
      67,     7,     6,   166,     0,    10,     0,   226,   227,     4,
       5,   380,   379,     0,   441,   259,    87,     0,   235,    20,
     262,    20,   166,     0,   319,   320,   321,   318,    94,   267,
     160,    20,   166,     0,   262,     0,    57,     0,    56,     0,
       0,    20,    20,     0,     0,     0,   208,     0,     0,     0,
      83,    84,    85,     0,     0,   314,   315,     0,    63,     0,
       0,     0,     0,     0,    68,    20,     0,   291,   292,   279,
     281,   282,   280,   283,   284,   276,   277,   278,     0,     0,
       0,   304,    70,    71,    72,   287,   288,   289,   290,   285,
     286,   121,     0,   120,     0,    20,    20,   438,     0,   297,
     296,   162,   164,   163,   298,   300,   299,    12,    59,     0,
      58,   307,     0,   252,     0,     1,     3,   165,   165,    82,
       0,   265,     0,   263,   264,     0,     0,   131,   131,     0,
     235,   159,   160,     0,   228,   397,   398,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,     0,
       0,     0,    20,    20,    20,    20,    20,    20,   436,   251,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,     0,    65,   258,     0,     0,
     322,     0,     0,     0,     0,   339,   340,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,     0,
       0,     0,    20,    20,    20,    20,    20,    20,   378,   249,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,     0,   319,     0,   266,   268,
       0,    55,     0,     0,     0,    69,     0,     0,     0,   207,
     206,     0,     0,     0,    20,     0,     0,     0,    20,     0,
       0,     0,    73,    89,    20,    20,    20,     0,     0,     0,
      17,     0,     0,     0,   294,     0,     0,     0,     0,    13,
      60,    61,   254,   261,    20,   306,    32,    30,    20,   166,
       0,    25,    23,    20,   166,     0,     0,     0,     0,     0,
     225,    37,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   381,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   400,   401,   402,   403,   404,   416,   419,
     420,   421,   415,   417,   418,   410,   411,   408,   412,   409,
     393,   423,   422,   394,   395,   392,   434,   250,   391,     0,
     405,   407,   406,   414,   413,   424,   425,   426,   428,   427,
       0,    20,     0,   435,     0,   257,   256,     0,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   342,   343,
     344,   345,   346,   358,   361,   362,   363,   357,   359,   360,
     352,   353,   350,   354,   351,   335,   365,   364,   336,   337,
     334,   376,   248,   333,     0,   347,   349,   348,   356,   355,
     366,   367,   368,   370,   369,     0,    20,     0,   377,     0,
     269,     0,    54,    20,     0,     0,     0,     0,     0,   239,
     239,     0,    20,    20,    20,     0,    20,    20,    20,     0,
       0,     0,     0,    20,    15,    18,     0,     0,     0,   220,
     316,   317,   293,   253,   255,   319,    31,    29,    34,    33,
     319,    24,    22,    27,    26,     0,     0,     0,     0,     0,
     160,    38,     0,    48,   225,    39,    42,    41,    44,    43,
       0,    49,   226,    45,    46,     0,     0,     0,     0,     0,
       0,   134,   135,   130,   132,   225,   126,   225,   127,     0,
       0,     0,     0,     0,     0,     0,     0,    20,   433,   431,
       0,    20,   432,   399,    20,   375,   373,     0,    20,   374,
     341,     0,     0,     0,    78,    76,     0,   239,   165,     0,
       0,     0,     0,     0,     0,    88,     0,     0,     0,    50,
      52,     0,     0,     0,   301,   303,   302,     0,    66,   239,
      35,    28,     0,     0,     0,   220,     0,    47,    36,    40,
       0,     0,     0,     0,   144,     0,     0,   138,   139,   142,
     143,   140,   141,   136,   137,     0,   229,   231,   230,   235,
       0,   128,   153,   225,   150,   151,   152,   149,     0,   226,
     129,   225,     0,   239,   239,   220,     0,     0,     0,     0,
     396,   430,   429,   338,   372,   371,     0,     0,     0,     0,
       0,   166,   238,   308,   240,    20,     0,    51,    53,     0,
      90,    91,    92,     0,    20,     0,     0,    96,    19,     0,
       0,   219,   221,     0,     0,   309,   241,     0,     0,     0,
     122,   145,     0,   123,   133,     0,   195,   165,   198,   199,
       0,   165,     0,   165,     0,     0,   165,     0,   124,   158,
     155,   156,   157,   154,   159,     0,     0,   125,   239,     0,
       0,   239,     0,     0,     0,   220,    79,   118,    77,     0,
     244,     0,    81,    75,    20,    20,    20,    20,     0,     0,
       0,    20,    20,     0,     0,    95,    97,     0,     0,     0,
     217,   245,   218,   220,    20,     0,   146,   197,   196,     0,
       0,   165,   159,   172,   193,   166,     0,   192,   202,   203,
     165,     0,   170,   169,   165,   167,   175,   165,   173,   178,
     165,   176,     0,     0,     0,   310,   242,     0,     0,   311,
     243,     0,     0,   275,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
     159,     0,   194,    20,   190,     0,     0,   171,   204,   205,
     200,   201,   168,   174,   177,     0,   220,   246,   215,   213,
     247,   216,   214,    80,    88,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   223,   224,   147,     0,    20,   180,
       0,     0,    20,     0,   187,    20,     0,   184,   220,   239,
       0,     0,     0,     0,     0,     0,     0,     0,   148,     0,
      20,     0,   179,   191,     0,     0,     0,     0,     0,     0,
      74,   182,     0,     0,   188,     0,   185,     0,   212,   210,
     211,   209,   181,     0,   189,   186,   183
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    90,    91,   379,   380,    92,    93,    94,   584,   585,
     824,    96,   136,   137,   209,   159,   138,   160,   373,    98,
      99,   736,   737,   100,   192,   101,   102,   415,   603,   604,
     673,   674,   693,   122,   104,   694,   695,   696,   827,   828,
     829,   758,   759,   760,   830,   149,   697,   105,   659,   741,
     742,   106,   123,   108,   639,   109,   110,   124,   111,   212,
     213,   125,   126,   127,   193,   113,   114,   115
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -724
static const yytype_int16 yypact[] =
{
    1533,   -65,  6858,   524,  5815,  5815,  7883,   -31,    -1,    15,
     249,     9,    92,    94,  -724,  7883,  7883,  7883,  7883,  -724,
    -724,  -724,   376,  -724,  -724,    99,  -724,   238,    99,   153,
      68,  -724,    28,  -724,  -724,  -724,  -724,  -724,  -724,  7883,
    7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,
      87,  7883,  5815,  5815,  5815,  7883,  7883,  7883,  7883,  7883,
    7883,  -724,  -724,  -724,  -724,    21,  -724,  -724,  -724,  1369,
      35,  -724,  -724,   156,   194,  -724,   248,  -724,   226,  -724,
    -724,  7883,  7883,   471,  7883,  7883,  7883,  5155,  6709,  -724,
    1208,  -724,    24,  -724,  -724,  -724,  -724,  -724,   230,  -724,
    -724,  -724,  -724,    -5,    93,  -724,    48,   699,  -724,  -724,
    -724,  -724,  -724, 10414,  -724,  -724,  -724,   241,    76,  7153,
      37,  7299,    36,   992,  -724,  -724,  -724,  -724, 13010,   176,
    -724,  7883,   308,   327,    19,  5320,  -724,   438,  -724,   442,
   10523,  7883,  7883,  5976,   297,   303,  -724,   313,  1369,  1369,
    -724,  -724,  -724,  8106,  8213,   329,   329,   277,  -724,   331,
    1694,   356,   358,   345,  -724,  7883,   396,   573,   573, 13010,
   13010,   329,   329,   329,   329,  7961,   329,   329,   359,   372,
     380,   329,  -724,  -724,  -724, 13010, 13010, 13010, 13010, 13010,
   13010,  -724,   354, 13010,  1369,  7883,  7883,  -724,  1369,   329,
     329,  -724,  -724,  -724,   329,   329,   329,  -724,  -724,  5485,
    -724,  -724,   -51,  -724,  8764,  -724,  -724,   643,   644,  -724,
     286,  -724,   405,  -724,  -724,   196,   349,   526,   526,   436,
    -724,  -724,   423,    45,  -724,  -724,  -724,  7883,  7883,  7883,
    7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,
    7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,   652,
     404,   366,  7883,  7883,  7883,  7883,  7883,  7883,  -724,  7007,
    7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,
    7883,  7883,  7883,  7591,  7883,  1369,  -724,  -724,   -34, 12047,
    -724,    -4,   431,   454,   610,  -724,  -724,  7883,  7883,  7883,
    7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,
    7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,   687,
     512,   366,  7883,  7883,  7883,  7883,  7883,  7883,  -724,  7007,
    7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,  7883,
    7883,  7883,  7883,  7737,  7883,  1369,   489, 13010,  -724,  -724,
    1369,  -724,  5650,   511,   521,  -724,  8874,  8984,   510,  -724,
    -724,  1369,   522,   523,  7883,   529,   568,   576,  7883,   538,
     580,   592,  -724,  -724,  7883,  7883,  7883,  9094,   619,   -53,
    -724,  1369,  1369,  1369,  -724,   585,  9204,  9314,   597,  -724,
    -724,  -724,  7007,  -724,  7883,  -724,   351,   664,  7883,   383,
     362,   351,   664,  7883,   407,   430,   613,  1369,  1369,  1369,
     413,  -724,   620,   629,   357,   463,   479,   627,  1369,  1369,
    1369,   513,   639, 13117, 13117, 13117, 13117, 13117, 13117, 13117,
   13117, 13117, 13117, 13483, 13447, 13483, 13654, 13654,  7961,  7961,
    7961,  7961,  7961,  7961,  7961,  -724,  -724,  -724,  -724,  -724,
    -724,    66,    66, 13349, 13349, 13117, 13313, 13117, 13117, 12154,
   13569, 13605, 13654,  7961,  7961,   293,   293,   497,   329,   329,
   11831,  6125,  8320,  -724,   604,  -724,  -724,   640, 13117, 13117,
   13117, 13117, 13117, 13117, 13117, 13117, 13117, 13117, 13483, 13447,
   13483, 13654, 13654,  7961,  7961,  7961,  7961,  7961,  7961,  7961,
    -724,  -724,  -724,  -724,  -724,  -724,    66,    66, 13349, 13349,
   13117, 13313, 13117, 13117, 12261, 13569, 13605, 13654,  7961,  7961,
     293,   293,   497,   329,   329, 11939,  6271,  8431,  -724,   638,
    -724,   645,  -724,  7883,  1369,  5815,  5815,  5976,   650,   801,
     801,  7999,  7883,  7883,  7883,  9424,  7883,  7883,  7883, 10632,
   10741,  9534,   649,  7883,  -724,  -724,   651,   662,   663,    25,
    -724,  -724,  -724,  -724, 13117,   666,  -724,  -724,  -724,  -724,
     667,  -724,  -724,  -724,  -724,  1369,   670,   672,   674,   299,
     647,  -724,   665,  -724,   488,  -724,  -724,  -724,  -724,  -724,
      81,  -724,  1028,  -724,  -724,   366,   366,   411,   528,   569,
     588,  -724,  -724,   700,  -724,    43,  -724,   319,  -724,  1369,
     677,   678,   681,   685,  1369,  1369,  1369,  7883,  -724,  -724,
    8542,  6417,  -724,  -724,  7883,  -724,  -724,  8653,  6563,  -724,
    -724,   684,  9644,   688,  -724,   807,   690,   801,   366,   697,
     697,   695,  9754, 10850, 10959,  -724,  9864,  9974, 10084,  -724,
    -724,   822,   368, 11068,  -724,  -724,  -724,   624,  -724,   801,
    -724,  -724,   694,   697,   697,   717,  1369,  -724,  -724,  -724,
     559,   577,    84,   244,  -724,   749,   457,  -724,  -724,  -724,
    -724,  -724,  -724,  -724,  -724,   357,   -16,     8,    12,    70,
     750,  -724,  -724,   535,  -724,  -724,  -724,  -724,    71,   933,
    -724,   637,   708,   801,   801,   717,  1369,   710,   714,   715,
   13215,  -724,  -724, 13215,  -724,  -724,   720,  5815,  5815,  1369,
     697,  -724,  -724,  -724,  -724,  7883,  5815,  -724,  -724,  1694,
    -724,  -724,  -724,   719,  7445,   744,   -11,  -724,  -724,   726,
     727,   751,  -724,   697,   697,  -724,  -724,   697,   725,   599,
    -724,  -724,   260,  -724,  -724,   774,   773,   343,  -724,  -724,
     -19,   460,     6,   763,    14,   781,  1034,    56,  -724,  -724,
    -724,  -724,  -724,  -724,   303,   285,  1369,  -724,   801,   697,
     697,   801,   731,   697,   697,   717,  -724,  -724,  -724,   732,
    -724, 10194,  -724,  -724,  7883,  7883,  7883,  7883,   764,   765,
     760,  7883,  7883, 12368,  1855,  -724,  -724,  1369,  1369,   624,
    -724,  -724,  -724,   717,  7883,  1369,  -724,  -724,  -724,   870,
     385,   601,   -17,  -724,  -724,   795,   792,  -724,  -724,  -724,
    1248,    51,  -724,  -724,  1402,  -724,  -724,  1734,  -724,  -724,
    5855,  -724,  1369,   746,   697,  -724,  -724,   496,   697,  -724,
    -724,   556,  5815,  -724, 10304, 12475, 12582, 12689,   770,   771,
    2020, 12796, 12903,  2185,  2350,   769,   775,  -724, 11177,   776,
     211,   803,  -724,  7883,  -724,   425,   433,  -724,  -724,  -724,
    -724,  -724,  -724,  -724,  -724,   785,   717,  -724,  -724,  -724,
    -724,  -724,  -724,  -724,  -724,  2515,  2680,  2845,  3010,  3175,
    3340,  3505,  3670,  3835,  -724,  -724,  -724,   787,  7883,  -724,
     440, 11286,  7883,  1369,  -724,  7883,  1369,  -724,   717,   801,
    1694,  4000,  4165,  4330,  4495,  4660,  4825,  4990,  -724, 11395,
    7883,  1369,  -724,  -724, 11504,   788, 11613,   789,   607,   609,
    -724,  -724, 11722,   790,  -724,   799,  -724,   800,  -724,  -724,
    -724,  -724,  -724,   802,  -724,  -724,  -724
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -724,  -724,   839,  -724,   551,  -724,  -408,  -407,  -724,   352,
       7,  -404,   268,    13,   -29,   911,    74,  -636,  -724,  -724,
    -724,  -724,   204,  -724,   287,  -398,  -389,   729,  -724,   281,
     384,  -164,   361,     5,    16,  -608,  -567,  -277,  -724,   -84,
    -546,  -723,   148,  -255,  -155,  -196,  -264,  -388,  -601,  -724,
     174,  -487,    11,  -106,  -492,  -385,  -384,  -111,  -724,   -32,
     593,  -724,  -724,    23,    -2,  -724,   908,  -724
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -226
static const yytype_int16 yytable[] =
{
     128,   234,   582,   583,   140,   103,   587,    95,   132,   729,
     220,   107,   588,   153,   154,   155,   156,   234,   139,   133,
     346,   589,   591,   112,   408,   593,   594,   112,   112,   217,
     734,   735,   817,   419,  -160,   755,  -159,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   640,   181,
    -160,   292,  -160,   185,   186,   187,   188,   189,   190,   755,
     421,   378,   218,   755,   747,   182,   183,   184,   686,   687,
     688,   689,    23,    24,    97,   112,   112,   112,   690,   199,
     200,   -21,   204,   205,   206,   770,   214,   288,    31,   291,
     392,    33,    34,   770,   225,   103,   670,    95,   226,   749,
     116,   107,   755,   756,   781,   765,   352,   392,   880,   221,
     112,   554,   233,   112,   -21,   393,   222,   289,   698,   289,
     698,   755,   831,   295,   296,   873,   771,   756,   294,   347,
     475,   756,   141,  -160,   771,  -159,  -160,   392,  -159,   356,
     357,  -160,  -159,  -159,   757,   720,   832,   831,   874,  -160,
     221,  -160,  -160,   805,  -160,   831,  -160,  -160,   112,  -160,
     476,   210,   142,   377,    97,   144,   422,   743,   761,   657,
     756,   835,   763,   372,   150,   227,   582,   583,   143,   838,
     587,   228,   350,   112,   851,   774,   588,    66,   166,   756,
     658,   146,   130,   386,   387,   589,   591,   831,   194,   593,
     594,   178,   222,   179,   328,   422,   698,   691,   180,   210,
     223,   779,   780,   158,   698,   224,   337,   338,   339,   340,
     341,   841,   399,   404,    83,   615,   342,   343,   344,   345,
     766,   165,   112,   400,   405,   423,   424,   425,   426,   427,
     428,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   151,   920,   152,
     451,   452,   453,   454,   455,   456,   450,   457,   458,   459,
     460,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   472,   473,   391,   879,   919,   844,   565,   879,   847,
    -159,   879,   570,  -159,   879,   478,   479,   480,   481,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,   498,   499,   938,   164,   195,
     506,   507,   508,   509,   510,   511,   505,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   527,   528,   144,   686,   687,   688,   689,    23,    24,
     295,   296,   161,   908,   690,   208,   410,   196,   231,   162,
      66,   411,   541,   145,    31,   130,   545,    33,    34,   146,
     147,   819,   549,   550,   551,   112,   909,    76,   690,   144,
     144,   -21,   597,   598,   599,   600,   295,   296,   820,   198,
     289,   366,   564,   144,   821,   219,   347,    83,   367,   145,
     145,   347,   814,   208,   148,   146,   146,   406,   750,   734,
     735,   157,   148,   145,   -21,   590,   772,   586,   -20,   146,
     147,   592,   348,   815,   772,   816,   391,   939,   579,   773,
     358,   328,   762,   764,   767,   362,   363,   773,    19,    20,
      21,    22,    23,    24,   349,   339,   340,   341,    27,   407,
     353,   -20,   354,   342,   343,   344,   345,   822,    31,    66,
     359,    33,    34,   412,   130,  -159,   360,   328,  -159,   620,
     413,   601,  -159,  -159,   408,   419,   361,   390,   602,   568,
     231,   385,    66,   700,   569,   388,   234,   130,   819,   342,
     343,   344,   345,   -20,   368,   690,    83,   566,   374,   870,
     375,    66,   776,   579,   567,   820,   130,   823,   376,   751,
     378,   821,   751,    19,    20,    21,    22,    23,    24,    83,
     384,   571,   381,    27,   627,   677,   -20,   231,   572,    66,
     144,   632,   678,    31,   580,   382,    33,    34,    83,   449,
     642,   643,   644,   383,   646,   647,   648,   573,   634,   635,
     145,   653,   574,   615,   295,   296,   146,   417,   112,   112,
     686,   687,   688,   689,    23,    24,    83,   912,   409,   414,
     690,   231,   474,    66,   822,   915,    66,   581,   130,   842,
      31,   130,   930,    33,    34,   201,   420,   202,   913,   590,
     914,   586,   203,   234,   407,   592,   916,   672,   917,   418,
     675,   675,   231,   931,    66,   932,   834,   144,   837,   580,
      83,   840,   692,    83,   692,   710,   699,   418,   699,   511,
     390,   753,   713,   605,   833,   477,   511,   145,   606,   819,
    -226,  -226,   529,   146,   613,   328,   690,   531,   129,   607,
      66,    83,   679,   721,   608,   130,   820,   504,   538,   680,
     340,   341,   668,   144,   722,   530,   135,   342,   343,   344,
     345,   888,   686,   687,   688,   689,    23,    24,   556,   557,
     558,   144,   690,   145,   533,   537,   614,    83,   675,   146,
     406,   675,    31,   681,   534,    33,    34,   131,   539,   540,
     682,   145,   542,   144,   576,   577,   578,   146,   417,   768,
     769,   546,   683,   775,   699,   610,   611,   612,   769,   684,
     543,   328,   699,   145,   229,   822,   135,    66,   544,   146,
     613,   891,   130,   791,    19,    20,    21,   230,    23,    24,
     787,   788,   803,   342,   343,   344,   345,   872,   739,   792,
     112,   112,   793,   547,    31,   740,   878,    33,    34,   112,
     878,   559,   112,   878,    83,   548,   878,   396,   401,    66,
      66,   553,   825,   562,   397,   402,   825,   135,   825,   135,
     623,   825,   948,   826,   950,   864,   575,   826,  -160,   826,
     595,  -160,   826,   445,   446,  -160,  -160,   447,   448,   596,
     609,   819,   854,   855,   856,   857,    83,    83,   690,   861,
     862,   777,   616,   614,   630,   638,   398,   403,   820,   652,
     666,   631,   868,   231,   821,    66,   637,   654,   500,   501,
     232,   633,   502,   503,   636,   871,   825,   112,   655,   656,
     667,   900,   660,   661,   903,   825,   663,   826,   664,   825,
     665,   685,   825,   703,   704,   825,   826,   705,   706,   658,
     826,   718,    83,   826,   717,   719,   826,   135,   725,   733,
     744,   657,   662,   752,   161,   893,   921,   922,   923,   924,
     925,   911,   926,   927,   778,   112,   783,   822,   210,    66,
     784,   785,   794,   112,   130,   786,   112,   112,   804,   807,
     808,   813,   809,   756,   818,   366,   702,   848,   852,   858,
     859,   707,   708,   709,   860,   765,   929,   723,   724,   875,
     934,   876,   886,   936,   898,   899,    83,   910,   112,   112,
     112,   112,   112,   112,   112,   112,   112,   836,   942,   216,
     555,   745,   746,   940,   210,   904,   669,   210,   391,   163,
     806,   905,   907,   112,   112,   112,   112,   112,   112,   112,
     112,   918,   928,   748,   945,   947,   953,   416,    19,    20,
      21,   230,    23,    24,   954,   955,   754,   956,   701,   210,
     210,   210,   210,   210,   391,   210,   210,   391,    31,   881,
     676,    33,    34,   867,   197,   563,     0,     0,   790,     0,
       0,     0,     0,   782,     0,   391,   391,   391,   391,   391,
     391,   391,     0,     0,     0,     0,   789,   293,     0,     0,
       0,   810,   811,     0,     0,   812,     0,    19,    20,    21,
     230,    23,    24,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    31,     0,     0,
      33,    34,     0,   671,     0,     0,     0,   845,   846,     0,
       0,   849,   850,    19,    20,    21,   230,    23,    24,     0,
       0,     0,   819,   843,     0,     0,     0,     0,     0,   690,
       0,     0,   208,    31,     0,     0,    33,    34,     0,   820,
       0,     0,     0,     0,     0,   821,     0,     0,     0,     0,
       0,     0,     0,     0,   865,   866,     0,     0,     0,     0,
       0,     0,   869,     0,     0,     0,   231,     0,    66,     0,
       0,     0,   887,   130,     0,   889,   890,     0,     0,   892,
       0,     0,     0,     0,     0,     0,     0,     0,   208,   885,
       0,   208,   390,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   231,     0,    66,    83,     0,     0,   822,   232,
      66,     0,     0,     0,     0,   130,     0,     0,     0,     0,
       0,     0,     0,   208,   208,   208,   208,   208,   390,   208,
     208,   390,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    83,     0,     0,     0,     0,     0,    83,     0,   390,
     390,   390,   390,   390,   390,   390,     0,     0,   839,     0,
     935,     0,     0,   937,     0,     0,   949,   951,   215,     1,
       0,     2,     0,   -20,     3,     4,     5,     6,   943,     0,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
       0,     0,    26,    27,    28,     0,   -20,    29,    30,     0,
       0,     0,     0,    31,  -225,    32,    33,    34,  -225,     0,
      35,    36,    37,    38,     0,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   819,    41,    42,    43,
      44,    45,    46,   690,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   820,     0,     0,     0,    47,     0,   821,
       0,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,     0,     0,     0,     0,    62,
      63,    64,    65,     0,    66,  -165,    67,    68,    69,    70,
    -165,    71,    72,    73,    74,  -225,    75,    76,    77,     0,
       0,  -225,    78,     0,     0,    79,     0,    80,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    81,    82,
       0,    83,   822,     0,    66,    84,    85,    86,    87,   130,
     191,    88,     0,    89,   -20,     3,     0,     0,     0,     0,
       0,     0,     0,     0,   117,     0,     0,     0,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   118,    23,    24,
       0,    83,     0,     0,     0,     0,     0,   -20,     0,     0,
       0,     0,   877,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
     819,     0,     0,     0,     0,     0,     0,   690,    41,    42,
      43,    44,    45,    46,     0,     0,     0,   820,     0,     0,
       0,     0,     0,   821,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,     0,     0,     0,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,   119,    66,  -165,    67,    68,    69,
     120,  -165,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   822,     0,    66,    81,
      82,     0,    83,   130,     0,     0,    84,    85,    86,   121,
       0,     0,    88,     0,     1,  -119,     2,     0,   -20,     3,
       4,     5,     6,     0,     0,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    83,    17,    18,    19,    20,
      21,    22,    23,    24,    25,     0,   882,    26,    27,    28,
       0,   -20,    29,    30,     0,     0,     0,     0,    31,  -225,
      32,    33,    34,  -225,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,     0,    66,
    -165,    67,    68,    69,    70,  -165,    71,    72,    73,    74,
    -225,    75,    76,    77,     0,     0,  -225,    78,     0,     0,
      79,     0,    80,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,    87,     0,     1,    88,     2,    89,   -20,
       3,     4,     5,     6,     0,   369,     7,     8,     9,   117,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
      20,    21,   118,    23,    24,    25,   370,   371,    26,     0,
      28,     0,   -20,    29,    30,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,    37,    38,
       0,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   819,    41,    42,    43,    44,    45,    46,   690,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   820,
       0,     0,     0,    47,     0,   821,     0,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,     0,     0,     0,     0,    62,    63,    64,    65,     0,
      66,  -165,    67,    68,    69,   134,  -165,    71,    72,    73,
      74,     0,    75,    76,    77,     0,     0,     0,    78,     0,
       0,    79,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    81,    82,     0,    83,   822,     0,
      66,    84,    85,    86,   135,   130,     1,    88,     2,    89,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,    83,     0,    26,
       0,    28,     0,   -20,    29,    30,  -117,  -117,   883,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -117,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -113,  -113,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,  -113,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -115,  -115,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -115,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -116,  -116,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,  -116,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -103,  -103,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -103,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -101,  -101,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,  -101,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,   -99,   -99,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,   -99,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -109,  -109,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,  -109,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -111,  -111,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -111,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -112,  -112,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,  -112,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -105,  -105,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -105,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -107,  -107,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,  -107,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -114,  -114,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -114,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -102,  -102,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,  -102,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -100,  -100,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -100,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,   -98,   -98,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,   -98,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -108,  -108,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -108,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -110,  -110,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,  -110,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -104,  -104,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -104,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -106,  -106,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,  -106,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,   207,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,   351,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,   389,
      89,     1,     0,     2,     0,   -20,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   117,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   118,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,     0,    66,  -165,    67,    68,
      69,   134,  -165,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     135,     0,     0,    88,   532,    89,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   819,    41,    42,    43,    44,    45,    46,
     690,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     820,     0,     0,     0,    47,     0,   821,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -165,    67,    68,    69,   134,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,   822,
       0,    66,    84,    85,    86,   135,   130,   191,    88,     0,
      89,   -20,     3,     0,     0,     0,     0,     0,     0,     0,
       0,   117,     0,     0,     0,    14,    15,     0,     0,    17,
      18,    19,    20,    21,   118,    23,    24,     0,    83,     0,
       0,     0,     0,     0,   -20,     0,     0,     0,     0,   884,
       0,    31,     0,     0,    33,    34,     0,     0,    35,    36,
      37,    38,     0,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,    48,
      49,    50,    51,     0,     0,     0,    55,    56,    57,    58,
      59,    60,    61,     0,     0,     0,     0,    62,    63,    64,
      65,   119,    66,  -165,    67,    68,    69,   120,  -165,    71,
      72,    73,    74,     0,    75,    76,    77,     0,     0,     0,
      78,     0,     0,    79,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    81,    82,     0,    83,
       0,     3,     0,    84,    85,    86,   121,     0,     0,    88,
     117,  -119,     0,     0,    14,    15,     0,     0,    17,    18,
      19,    20,    21,   118,    23,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
     119,    66,  -165,    67,    68,    69,   120,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     3,    83,     0,
       0,     0,    84,    85,    86,   121,   117,     0,    88,     0,
      14,    15,   619,     0,    17,    18,    19,    20,    21,   118,
      23,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,     0,     0,
       0,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,   119,    66,  -165,    67,
      68,    69,   120,  -165,    71,    72,    73,    74,     0,    75,
      76,    77,     0,     0,     0,    78,     0,     0,    79,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    81,    82,     3,    83,     0,     0,     0,    84,    85,
      86,   121,   117,     0,    88,     0,    14,    15,   626,     0,
      17,    18,    19,    20,    21,   118,    23,    24,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,     0,     0,     0,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,   119,    66,  -165,    67,    68,    69,   120,  -165,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     3,
      83,     0,     0,     0,    84,    85,    86,   121,   117,     0,
      88,     0,    14,    15,   712,     0,    17,    18,    19,    20,
      21,   118,    23,    24,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,   119,    66,
    -165,    67,    68,    69,   120,  -165,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     3,    83,     0,     0,     0,
      84,    85,    86,   121,   117,     0,    88,     0,    14,    15,
     715,     0,    17,    18,    19,    20,    21,   118,    23,    24,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,     0,     0,     0,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,   119,    66,  -165,    67,    68,    69,
     120,  -165,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     0,    83,     0,     3,     0,    84,    85,    86,   121,
       0,     0,    88,   117,     0,   211,     0,    14,    15,     0,
       0,    17,    18,    19,    20,    21,   118,    23,    24,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,    37,    38,     0,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,    48,    49,    50,    51,     0,     0,     0,    55,    56,
      57,    58,    59,    60,    61,     0,     0,     0,     0,    62,
      63,    64,    65,   119,    66,  -165,    67,    68,    69,   120,
    -165,    71,    72,    73,    74,     0,    75,    76,    77,     0,
       0,     0,    78,     0,     0,    79,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    81,    82,
       0,    83,   -20,     3,     0,    84,    85,    86,   121,     0,
       0,    88,   117,   -93,     0,     0,    14,    15,     0,     0,
      17,    18,    19,    20,    21,   118,    23,    24,     0,     0,
       0,     0,     0,     0,     0,   -20,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,     0,     0,     0,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,   119,    66,  -165,    67,    68,    69,   120,  -165,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     3,
      83,     0,     0,     0,    84,    85,    86,   121,   117,     0,
      88,     0,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   118,    23,    24,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,   119,    66,
    -165,    67,    68,    69,   120,  -165,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     3,    83,     0,     0,     0,
      84,    85,    86,   121,   117,     0,    88,   287,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   118,    23,    24,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,     0,     0,     0,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,   119,    66,  -165,    67,    68,    69,
     120,  -165,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     3,    83,     0,     0,     0,    84,    85,    86,   121,
     117,     0,    88,   290,    14,    15,     0,     0,    17,    18,
      19,    20,    21,   118,    23,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,   795,     0,   796,   797,     0,
       0,     0,   798,   799,    47,     0,     0,     0,    48,    49,
      50,    51,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
     119,    66,  -165,    67,    68,    69,   120,  -165,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
     800,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   801,   802,    81,    82,     3,    83,     0,
       0,     0,    84,    85,    86,   121,   117,     0,    88,     0,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   118,
      23,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,     0,     0,
       0,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,   471,    62,    63,    64,    65,   119,    66,  -165,    67,
      68,    69,   120,  -165,    71,    72,    73,    74,     0,    75,
      76,    77,     0,     0,     0,    78,     0,     0,    79,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    81,    82,     3,    83,     0,     0,     0,    84,    85,
      86,   121,   117,     0,    88,     0,    14,    15,     0,     0,
      17,    18,    19,    20,    21,   118,    23,    24,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,     0,     0,     0,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,   526,    62,    63,
      64,    65,   119,    66,  -165,    67,    68,    69,   120,  -165,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     3,
      83,     0,     0,     0,    84,    85,    86,   121,   117,     0,
      88,     0,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   118,    23,    24,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,   119,    66,
    -165,    67,    68,    69,   120,  -165,    71,    72,    73,    74,
     641,    75,    76,    77,     0,     0,     0,    78,   295,   296,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,   121,     0,     0,    88,     0,     0,     0,
       0,   321,   322,   323,     0,     0,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,     0,     0,
       0,     0,     0,     0,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,     0,   321,
     322,   323,     0,     0,     0,     0,     0,     0,     0,   328,
       0,     0,     0,     0,     0,     0,   324,   325,   326,   327,
       0,   337,   338,   339,   340,   341,     0,     0,     0,     0,
       0,   342,   343,   344,   345,     0,     0,     0,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   328,     0,     0,
     329,   330,   331,     0,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,     0,     0,     0,     0,     0,   342,
     343,   344,   345,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,     0,     0,     0,     0,     0,
       0,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,     0,   321,   322,   323,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   324,   325,   326,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   365,     0,     0,     0,     0,
       0,     0,     0,     0,   328,     0,     0,   329,   330,   331,
       0,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,     0,     0,     0,     0,     0,   342,   343,   344,   345,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,     0,     0,     0,     0,     0,     0,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,     0,   321,   322,   323,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324,   325,   326,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,     0,     0,   329,   330,   331,     0,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,     0,   342,   343,   344,   345,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,     0,
       0,     0,     0,     0,     0,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,     0,
     321,   322,   323,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   324,   325,   326,
     621,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,     0,
       0,   329,   330,   331,     0,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,     0,
     342,   343,   344,   345,     0,     0,     0,   622,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
       0,     0,     0,     0,     0,     0,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
       0,   321,   322,   323,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   324,   325,
     326,   628,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
       0,     0,   329,   330,   331,     0,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,     0,     0,     0,     0,
       0,   342,   343,   344,   345,     0,     0,     0,   629,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,     0,     0,     0,     0,     0,     0,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,     0,   321,   322,   323,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   324,
     325,   326,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,     0,     0,   329,   330,   331,     0,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,     0,     0,     0,
       0,     0,   342,   343,   344,   345,     0,     0,     0,   711,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,     0,     0,     0,     0,     0,     0,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,     0,   321,   322,   323,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324,   325,   326,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,     0,     0,   329,   330,   331,     0,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,     0,   342,   343,   344,   345,     0,     0,     0,
     714,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,   394,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     395,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     535,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     536,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     552,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     560,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     561,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     645,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     651,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     716,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     726,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     730,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     731,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     732,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     853,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,     0,
     894,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,     0,     0,     0,     0,     0,     0,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,     0,   261,   262,   263,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   264,   265,   266,   267,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   268,     0,     0,   269,   270,   271,     0,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,     0,     0,     0,     0,     0,     0,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,     0,   321,   322,   323,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324,   325,   326,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,     0,     0,   329,   330,   331,     0,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,     0,   342,   343,   344,   345,     0,   355,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,     0,     0,     0,     0,     0,     0,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,     0,   321,   322,   323,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   324,
     325,   326,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,     0,     0,   329,   330,   331,     0,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,     0,     0,     0,
       0,     0,   342,   343,   344,   345,     0,   649,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
       0,     0,     0,     0,     0,     0,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
       0,   321,   322,   323,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   324,   325,
     326,   327,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
       0,     0,   329,   330,   331,     0,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,     0,     0,     0,     0,
       0,   342,   343,   344,   345,     0,   650,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,     0,
       0,     0,     0,     0,     0,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,     0,
     321,   322,   323,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   324,   325,   326,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,     0,
       0,   329,   330,   331,     0,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,     0,
     342,   343,   344,   345,     0,   727,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,     0,     0,
       0,     0,     0,     0,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,     0,   321,
     322,   323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   324,   325,   326,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,     0,     0,
     329,   330,   331,     0,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,     0,     0,     0,     0,     0,   342,
     343,   344,   345,     0,   728,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,     0,     0,     0,
       0,     0,     0,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,     0,   321,   322,
     323,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   324,   325,   326,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,     0,     0,   329,
     330,   331,     0,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,     0,   342,   343,
     344,   345,     0,   738,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,     0,     0,     0,     0,
       0,     0,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,     0,   321,   322,   323,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   324,   325,   326,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,     0,     0,   329,   330,
     331,     0,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,     0,     0,     0,     0,     0,   342,   343,   344,
     345,     0,   906,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,     0,     0,     0,     0,     0,
       0,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,     0,   321,   322,   323,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   324,   325,   326,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,     0,     0,   329,   330,   331,
       0,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,     0,     0,     0,     0,     0,   342,   343,   344,   345,
       0,   933,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,     0,     0,     0,     0,     0,     0,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,     0,   321,   322,   323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   324,   325,   326,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,     0,     0,   329,   330,   331,     0,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
       0,     0,     0,     0,     0,   342,   343,   344,   345,     0,
     941,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,     0,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,     0,   944,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,     0,     0,     0,     0,     0,     0,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,     0,   321,   322,   323,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324,   325,   326,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,     0,     0,   329,   330,   331,     0,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,     0,   342,   343,   344,   345,     0,   946,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,     0,     0,     0,     0,     0,     0,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,     0,   321,   322,   323,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   324,
     325,   326,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,     0,     0,   329,   330,   331,     0,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,     0,     0,     0,
       0,     0,   342,   343,   344,   345,     0,   952,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
       0,     0,     0,     0,     0,     0,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
       0,   321,   322,   323,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   324,   325,
     326,   327,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
       0,     0,   329,   330,   331,     0,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,     0,     0,     0,     0,
       0,   342,   343,   344,   345,   618,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,     0,     0,
       0,     0,     0,     0,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,     0,   321,
     322,   323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   324,   325,   326,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,     0,     0,
     329,   330,   331,     0,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,     0,     0,     0,     0,     0,   342,
     343,   344,   345,   625,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,     0,     0,     0,     0,
       0,     0,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,     0,   321,   322,   323,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   324,   325,   326,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,     0,     0,   329,   330,
     331,   394,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,     0,     0,     0,     0,     0,   342,   343,   344,
     345,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,     0,     0,     0,     0,     0,     0,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,     0,   321,   322,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,   325,   326,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,   329,   330,   331,   617,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
       0,     0,     0,     0,     0,     0,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
       0,   321,   322,   323,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   324,   325,
     326,   327,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
       0,     0,   329,   330,   331,   624,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,     0,     0,     0,     0,
       0,   342,   343,   344,   345,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,     0,     0,     0,
       0,     0,     0,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,     0,   321,   322,
     323,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   324,   325,   326,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,     0,     0,   329,
     330,   331,   863,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,     0,   342,   343,
     344,   345,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,     0,     0,     0,     0,     0,     0,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,     0,   321,   322,   323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   324,   325,   326,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,     0,     0,   329,   330,   331,   895,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
       0,     0,     0,     0,     0,   342,   343,   344,   345,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,     0,     0,     0,     0,     0,     0,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,     0,   321,   322,   323,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   324,
     325,   326,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,     0,     0,   329,   330,   331,   896,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,     0,     0,     0,
       0,     0,   342,   343,   344,   345,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,     0,     0,
       0,     0,     0,     0,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,     0,   321,
     322,   323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   324,   325,   326,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,     0,     0,
     329,   330,   331,   897,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,     0,     0,     0,     0,     0,   342,
     343,   344,   345,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,     0,     0,     0,     0,     0,
       0,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,     0,   321,   322,   323,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   324,   325,   326,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,     0,     0,   329,   330,   331,
     901,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,     0,     0,     0,     0,     0,   342,   343,   344,   345,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,     0,     0,     0,     0,     0,     0,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,     0,   321,   322,   323,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324,   325,   326,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,     0,     0,   329,   330,   331,   902,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,     0,   342,   343,   344,   345,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,     0,
       0,     0,     0,     0,     0,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,     0,
     321,   322,   323,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   324,   325,   326,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,     0,
       0,   329,   330,   331,     0,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,     0,
     342,   343,   344,   345,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,     0,     0,     0,     0,
       0,     0,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,     0,   321,   322,   323,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   324,   325,   326,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,     0,     0,     0,   330,
     331,     0,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   295,   296,     0,     0,     0,   342,   343,   344,
     345,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,     0,   321,   322,   323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   324,   325,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,     0,     0,     0,     0,   331,     0,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     295,   296,     0,     0,     0,   342,   343,   344,   345,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,     0,   321,   322,   323,   295,   296,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324,   325,     0,  -226,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,     0,   321,
     322,   323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,     0,     0,     0,     0,   324,   325,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,     0,   342,   343,   344,   345,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,     0,     0,
       0,     0,     0,     0,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   295,   296,     0,     0,     0,   342,
     343,   344,   345,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   307,     0,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,     0,   321,   322,   323,
     295,   296,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,     0,   321,   322,   323,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,     0,     0,     0,     0,
       0,     0,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,     0,     0,     0,     0,     0,   342,   343,   344,
     345,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,     0,     0,     0,     0,   295,   296,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,     0,   342,   343,   344,   345,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,     0,   321,
     322,   323,   295,   296,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,     0,   321,   322,   323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,     0,     0,
       0,   295,   296,     0,     0,   333,   334,   335,   336,   337,
     338,   339,   340,   341,     0,     0,     0,     0,     0,   342,
     343,   344,   345,     0,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   328,   321,   322,   323,     0,     0,     0,
       0,     0,   334,   335,   336,   337,   338,   339,   340,   341,
       0,     0,     0,     0,     0,   342,   343,   344,   345,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   335,   336,   337,   338,   339,   340,   341,     0,
       0,     0,     0,     0,   342,   343,   344,   345
};

static const yytype_int16 yycheck[] =
{
       2,   107,   410,   410,     6,     0,   410,     0,     3,   645,
      15,     0,   410,    15,    16,    17,    18,   123,     5,     3,
     131,   410,   410,     0,   220,   410,   410,     4,     5,     5,
      41,    42,   755,   229,    15,    51,    15,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,   540,    51,
      15,    15,    15,    55,    56,    57,    58,    59,    60,    51,
      15,   114,    38,    51,   665,    52,    53,    54,    25,    26,
      27,    28,    29,    30,     0,    52,    53,    54,    35,    81,
      82,     5,    84,    85,    86,   693,    88,   119,    45,   121,
     141,    48,    49,   701,    46,    90,    15,    90,    50,    15,
     165,    90,    51,   119,   705,    35,   135,   141,   831,   114,
      87,   164,   107,    90,    38,   166,   121,   119,   605,   121,
     607,    51,   141,    57,    58,   142,   693,   119,   123,   131,
     164,   119,   163,   114,   701,   114,   117,   141,   117,   141,
     142,   122,   121,   122,   160,   637,   165,   141,   165,   114,
     114,   114,   117,   164,   117,   141,   121,   122,   135,   122,
     164,    87,   163,   165,    90,    94,   121,   659,   160,   144,
     119,   165,   160,   160,   165,   127,   584,   584,   163,   165,
     584,   133,   163,   160,   785,   114,   584,   116,   160,   119,
     165,   120,   121,   195,   196,   584,   584,   141,   163,   584,
     584,   114,   121,   116,   138,   121,   693,   164,   121,   135,
     117,   703,   704,   114,   701,   122,   150,   151,   152,   153,
     154,   165,   217,   218,   153,   421,   160,   161,   162,   163,
     160,   163,   209,   217,   218,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   165,   894,   165,
     262,   263,   264,   265,   266,   267,   261,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   209,   830,   886,   778,   398,   834,   781,
     114,   837,   403,   117,   840,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   918,   165,   163,
     322,   323,   324,   325,   326,   327,   321,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,    94,    25,    26,    27,    28,    29,    30,
      57,    58,   114,   142,    35,    87,   160,   163,   114,   121,
     116,   165,   364,   114,    45,   121,   368,    48,    49,   120,
     121,    28,   374,   375,   376,   352,   165,   129,    35,    94,
      94,     5,    25,    26,    27,    28,    57,    58,    45,   163,
     392,   114,   394,    94,    51,   165,   398,   153,   121,   114,
     114,   403,   142,   135,   163,   120,   120,   121,   164,    41,
      42,    35,   163,   114,    38,   410,   693,   410,     5,   120,
     121,   410,   114,   163,   701,   165,   352,   919,    15,   693,
     143,   138,   687,   688,   689,   148,   149,   701,    25,    26,
      27,    28,    29,    30,   117,   152,   153,   154,    35,   163,
      12,    38,    10,   160,   161,   162,   163,   114,    45,   116,
     163,    48,    49,   114,   121,   114,   163,   138,   117,   471,
     121,   114,   121,   122,   670,   671,   163,   209,   121,   117,
     114,   194,   116,   164,   122,   198,   592,   121,    28,   160,
     161,   162,   163,     5,   163,    35,   153,   114,   142,   114,
     142,   116,   698,    15,   121,    45,   121,   164,   163,   673,
     114,    51,   676,    25,    26,    27,    28,    29,    30,   153,
     166,   114,   163,    35,   526,   114,    38,   114,   121,   116,
      94,   533,   121,    45,   121,   163,    48,    49,   153,   135,
     542,   543,   544,   163,   546,   547,   548,   117,   535,   536,
     114,   553,   122,   749,    57,    58,   120,   121,   535,   536,
      25,    26,    27,    28,    29,    30,   153,   142,   163,    43,
      35,   114,   285,   116,   114,   142,   116,   164,   121,   775,
      45,   121,   142,    48,    49,   114,   163,   116,   163,   584,
     165,   584,   121,   699,   163,   584,   163,   592,   165,   163,
     595,   596,   114,   163,   116,   165,   761,    94,   763,   121,
     153,   766,   605,   153,   607,   617,   605,   163,   607,   621,
     352,   164,   624,   160,   164,    15,   628,   114,   165,    28,
      57,    58,   345,   120,   121,   138,    35,   350,   114,   160,
     116,   153,   114,   638,   165,   121,    45,   135,   361,   121,
     153,   154,   164,    94,   638,   166,   160,   160,   161,   162,
     163,   165,    25,    26,    27,    28,    29,    30,   381,   382,
     383,    94,    35,   114,   163,   165,   163,   153,   673,   120,
     121,   676,    45,   114,   163,    48,    49,   163,   166,   166,
     121,   114,   163,    94,   407,   408,   409,   120,   121,   164,
     693,   163,   114,   698,   693,   418,   419,   420,   701,   121,
     142,   138,   701,   114,    15,   114,   160,   116,   142,   120,
     121,   165,   121,   725,    25,    26,    27,    28,    29,    30,
     717,   718,   734,   160,   161,   162,   163,   821,   114,   726,
     717,   718,   729,   163,    45,   121,   830,    48,    49,   726,
     834,   166,   729,   837,   153,   163,   840,   114,   114,   116,
     116,   142,   757,   166,   121,   121,   761,   160,   763,   160,
     166,   766,   165,   757,   165,   804,   163,   761,   114,   763,
     160,   117,   766,   131,   132,   121,   122,   135,   136,   160,
     163,    28,   794,   795,   796,   797,   153,   153,    35,   801,
     802,   164,   163,   163,   166,     4,   163,   163,    45,   160,
     163,   166,   814,   114,    51,   116,   166,   166,   131,   132,
     121,   534,   135,   136,   537,   820,   821,   804,   166,   166,
     165,   860,   166,   166,   863,   830,   166,   821,   166,   834,
     166,   141,   837,   166,   166,   840,   830,   166,   163,   165,
     834,    44,   153,   837,   166,   165,   840,   160,   163,    37,
     166,   144,   575,   114,   114,   852,   895,   896,   897,   898,
     899,   873,   901,   902,   166,   852,   166,   114,   804,   116,
     166,   166,   163,   860,   121,   165,   863,   864,   144,   163,
     163,   166,   141,   119,   121,   114,   609,   166,   166,   135,
     135,   614,   615,   616,   144,    35,   908,   639,   640,   114,
     912,   119,   166,   915,   144,   144,   153,   114,   895,   896,
     897,   898,   899,   900,   901,   902,   903,   164,   930,    90,
     379,   663,   664,   920,   860,   166,   584,   863,   864,    28,
     736,   166,   166,   920,   921,   922,   923,   924,   925,   926,
     927,   166,   165,   666,   166,   166,   166,   228,    25,    26,
      27,    28,    29,    30,   165,   165,   685,   165,   607,   895,
     896,   897,   898,   899,   900,   901,   902,   903,    45,   831,
     596,    48,    49,   809,    76,   392,    -1,    -1,   720,    -1,
      -1,    -1,    -1,   706,    -1,   921,   922,   923,   924,   925,
     926,   927,    -1,    -1,    -1,    -1,   719,    15,    -1,    -1,
      -1,   743,   744,    -1,    -1,   747,    -1,    25,    26,    27,
      28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    15,    -1,    -1,    -1,   779,   780,    -1,
      -1,   783,   784,    25,    26,    27,    28,    29,    30,    -1,
      -1,    -1,    28,   776,    -1,    -1,    -1,    -1,    -1,    35,
      -1,    -1,   804,    45,    -1,    -1,    48,    49,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    51,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   807,   808,    -1,    -1,    -1,    -1,
      -1,    -1,   815,    -1,    -1,    -1,   114,    -1,   116,    -1,
      -1,    -1,   844,   121,    -1,   847,   848,    -1,    -1,   851,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   860,   842,
      -1,   863,   864,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   114,    -1,   116,   153,    -1,    -1,   114,   121,
     116,    -1,    -1,    -1,    -1,   121,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   895,   896,   897,   898,   899,   900,   901,
     902,   903,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   153,    -1,    -1,    -1,    -1,    -1,   153,    -1,   921,
     922,   923,   924,   925,   926,   927,    -1,    -1,   164,    -1,
     913,    -1,    -1,   916,    -1,    -1,   938,   939,     0,     1,
      -1,     3,    -1,     5,     6,     7,     8,     9,   931,    -1,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    -1,    34,    35,    36,    -1,    38,    39,    40,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    -1,
      52,    53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    28,    69,    70,    71,
      72,    73,    74,    35,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    45,    -1,    -1,    -1,    89,    -1,    51,
      -1,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,
     112,   113,   114,    -1,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,    -1,
      -1,   133,   134,    -1,    -1,   137,    -1,   139,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,
      -1,   153,   114,    -1,   116,   157,   158,   159,   160,   121,
       1,   163,    -1,   165,     5,     6,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    15,    -1,    -1,    -1,    19,    20,
      -1,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,   153,    -1,    -1,    -1,    -1,    -1,    38,    -1,    -1,
      -1,    -1,   164,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      28,    -1,    -1,    -1,    -1,    -1,    -1,    35,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    45,    -1,    -1,
      -1,    -1,    -1,    51,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   114,    -1,   116,   150,
     151,    -1,   153,   121,    -1,    -1,   157,   158,   159,   160,
      -1,    -1,   163,    -1,     1,   166,     3,    -1,     5,     6,
       7,     8,     9,    -1,    -1,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,   153,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,   164,    34,    35,    36,
      -1,    38,    39,    40,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,    -1,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,    -1,    -1,   133,   134,    -1,    -1,
     137,    -1,   139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,
     157,   158,   159,   160,    -1,     1,   163,     3,   165,     5,
       6,     7,     8,     9,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    -1,    38,    39,    40,    -1,    -1,    -1,    -1,    45,
      -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,    55,
      -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    28,    69,    70,    71,    72,    73,    74,    35,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,
      -1,    -1,    -1,    89,    -1,    51,    -1,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,    -1,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   150,   151,    -1,   153,   114,    -1,
     116,   157,   158,   159,   160,   121,     1,   163,     3,   165,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,   153,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,   164,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    -1,    -1,   163,   164,
     165,     1,    -1,     3,    -1,     5,     6,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,
      40,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     150,   151,    -1,   153,    -1,    -1,    -1,   157,   158,   159,
     160,    -1,    -1,   163,   164,   165,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    28,    69,    70,    71,    72,    73,    74,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    -1,    89,    -1,    51,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,   114,
      -1,   116,   157,   158,   159,   160,   121,     1,   163,    -1,
     165,     5,     6,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    15,    -1,    -1,    -1,    19,    20,    -1,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,   153,    -1,
      -1,    -1,    -1,    -1,    38,    -1,    -1,    -1,    -1,   164,
      -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,
      54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,
      94,    95,    96,    -1,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   150,   151,    -1,   153,
      -1,     6,    -1,   157,   158,   159,   160,    -1,    -1,   163,
      15,   165,    -1,    -1,    19,    20,    -1,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    -1,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   151,     6,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    15,    -1,   163,    -1,
      19,    20,   167,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   150,   151,     6,   153,    -1,    -1,    -1,   157,   158,
     159,   160,    15,    -1,   163,    -1,    19,    20,   167,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    -1,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,     6,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    15,    -1,
     163,    -1,    19,    20,   167,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   150,   151,     6,   153,    -1,    -1,    -1,
     157,   158,   159,   160,    15,    -1,   163,    -1,    19,    20,
     167,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,
     151,    -1,   153,    -1,     6,    -1,   157,   158,   159,   160,
      -1,    -1,   163,    15,    -1,   166,    -1,    19,    20,    -1,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,
      52,    53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,
      -1,   153,     5,     6,    -1,   157,   158,   159,   160,    -1,
      -1,   163,    15,   165,    -1,    -1,    19,    20,    -1,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    38,    -1,    -1,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    -1,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,     6,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    15,    -1,
     163,    -1,    19,    20,    -1,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   150,   151,     6,   153,    -1,    -1,    -1,
     157,   158,   159,   160,    15,    -1,   163,   164,    19,    20,
      -1,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,   137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,
     151,     6,   153,    -1,    -1,    -1,   157,   158,   159,   160,
      15,    -1,   163,   164,    19,    20,    -1,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    80,    -1,    82,    83,    -1,
      -1,    -1,    87,    88,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    -1,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
     135,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,   151,     6,   153,    -1,
      -1,    -1,   157,   158,   159,   160,    15,    -1,   163,    -1,
      19,    20,    -1,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   150,   151,     6,   153,    -1,    -1,    -1,   157,   158,
     159,   160,    15,    -1,   163,    -1,    19,    20,    -1,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    -1,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,   151,     6,
     153,    -1,    -1,    -1,   157,   158,   159,   160,    15,    -1,
     163,    -1,    19,    20,    -1,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
      11,   128,   129,   130,    -1,    -1,    -1,   134,    57,    58,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   150,   151,    -1,   153,    -1,    -1,    -1,
     157,   158,   159,   160,    -1,    -1,   163,    -1,    -1,    -1,
      -1,    90,    91,    92,    -1,    -1,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,   150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,   162,   163,    -1,    -1,    -1,    22,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    22,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,   162,   163,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,    -1,    -1,   167,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,   162,   163,    -1,    -1,    -1,   167,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,   161,   162,   163,    -1,    -1,    -1,   167,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,    -1,
     167,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,   165,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,   162,   163,    -1,   165,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,   161,   162,   163,    -1,   165,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,   162,   163,    -1,   165,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    -1,   165,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,    -1,   165,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,
     162,   163,    -1,   165,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,
     163,    -1,   165,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,
      -1,   165,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,
     165,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,   165,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,   162,   163,    -1,   165,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,   161,   162,   163,    -1,   165,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,   162,   163,   164,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,   164,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,
     163,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,   162,   163,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,
     162,   163,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,   161,   162,   163,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,   162,   163,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,   162,   163,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,   142,
     143,    -1,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    57,    58,    -1,    -1,    -1,   160,   161,   162,
     163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,    -1,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,    -1,    -1,    -1,    -1,   143,    -1,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      57,    58,    -1,    -1,    -1,   160,   161,   162,   163,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,    -1,   110,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,    -1,    -1,   107,   108,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,   162,   163,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    57,    58,    -1,    -1,    -1,   160,
     161,   162,   163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,    -1,
      -1,    -1,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,   162,
     163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,    -1,    -1,    -1,    -1,    57,    58,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,   162,   163,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
      -1,    57,    58,    -1,    -1,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,   162,   163,    -1,    80,    81,    82,    83,    84,    85,
      86,    87,    88,   138,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,    -1,    -1,    -1,    -1,   160,   161,   162,   163,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,   162,   163
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     6,     7,     8,     9,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    34,    35,    36,    39,
      40,    45,    47,    48,    49,    52,    53,    54,    55,    57,
      58,    69,    70,    71,    72,    73,    74,    89,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   111,   112,   113,   114,   116,   118,   119,   120,
     121,   123,   124,   125,   126,   128,   129,   130,   134,   137,
     139,   150,   151,   153,   157,   158,   159,   160,   163,   165,
     169,   170,   173,   174,   175,   178,   179,   184,   187,   188,
     191,   193,   194,   201,   202,   215,   219,   220,   221,   223,
     224,   226,   231,   233,   234,   235,   165,    15,    28,   115,
     121,   160,   201,   220,   225,   229,   230,   231,   232,   114,
     121,   163,   201,   202,   121,   160,   180,   181,   184,   181,
     232,   163,   163,   163,    94,   114,   120,   121,   163,   213,
     165,   165,   165,   232,   232,   232,   232,    35,   114,   183,
     185,   114,   121,   183,   165,   163,   160,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   114,   116,
     121,   232,   181,   181,   181,   232,   232,   232,   232,   232,
     232,     1,   192,   232,   163,   163,   163,   234,   163,   232,
     232,   114,   116,   121,   232,   232,   232,   164,   180,   182,
     184,   166,   227,   228,   232,     0,   170,     5,    38,   165,
      15,   114,   121,   117,   122,    46,    50,   127,   133,    15,
      28,   114,   121,   201,   221,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    90,    91,    92,   107,   108,   109,   110,   138,   141,
     142,   143,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   160,   161,   162,   163,   165,   164,   227,   232,
     164,   227,    15,    15,   201,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    90,    91,    92,   107,   108,   109,   110,   138,   141,
     142,   143,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   160,   161,   162,   163,   225,   232,   114,   117,
     163,   164,   182,    12,    10,   165,   232,   232,   192,   163,
     163,   163,   192,   192,    22,    22,   114,   121,   163,    11,
      32,    33,   181,   186,   142,   142,   163,   232,   114,   171,
     172,   163,   163,   163,   166,   192,   232,   232,   192,   164,
     180,   184,   141,   166,   144,   166,   114,   121,   163,   201,
     202,   114,   121,   163,   201,   202,   121,   163,   213,   163,
     160,   165,   114,   121,    43,   195,   195,   121,   163,   213,
     163,    15,   121,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   131,   132,   135,   136,   135,
     201,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   110,   232,   232,   192,   164,   164,    15,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     131,   132,   135,   136,   135,   201,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   110,   232,   232,   192,
     166,   192,   164,   163,   163,   166,   166,   165,   192,   166,
     166,   232,   163,   142,   142,   232,   163,   163,   163,   232,
     232,   232,   166,   142,   164,   172,   192,   192,   192,   166,
     166,   166,   166,   228,   232,   225,   114,   121,   117,   122,
     225,   114,   121,   117,   122,   163,   192,   192,   192,    15,
     121,   164,   174,   175,   176,   177,   178,   179,   193,   194,
     201,   215,   220,   223,   224,   160,   160,    25,    26,    27,
      28,   114,   121,   196,   197,   160,   165,   160,   165,   163,
     192,   192,   192,   121,   163,   213,   163,   144,   164,   167,
     232,   110,   167,   166,   144,   164,   167,   232,   110,   167,
     166,   166,   232,   192,   181,   181,   192,   166,     4,   222,
     222,    11,   232,   232,   232,   166,   232,   232,   232,   165,
     165,   166,   160,   232,   166,   166,   166,   144,   165,   216,
     166,   166,   192,   166,   166,   166,   163,   165,   164,   177,
      15,    15,   201,   198,   199,   201,   198,   114,   121,   114,
     121,   114,   121,   114,   121,   141,    25,    26,    27,    28,
      35,   164,   178,   200,   203,   204,   205,   214,   219,   220,
     164,   200,   192,   166,   166,   166,   163,   192,   192,   192,
     232,   167,   167,   232,   167,   167,   166,   166,    44,   165,
     222,   201,   202,   180,   180,   163,   166,   165,   165,   185,
     166,   166,   166,    37,    41,    42,   189,   190,   165,   114,
     121,   217,   218,   222,   166,   180,   180,   216,   192,    15,
     164,   199,   114,   164,   197,    51,   119,   160,   209,   210,
     211,   160,   211,   160,   211,    35,   160,   211,   164,   178,
     203,   204,   205,   214,   114,   201,   213,   164,   166,   222,
     222,   216,   192,   166,   166,   166,   165,   181,   181,   192,
     180,   232,   181,   181,   163,    80,    82,    83,    87,    88,
     135,   148,   149,   232,   144,   164,   190,   163,   163,   141,
     180,   180,   180,   166,   142,   163,   165,   209,   121,    28,
      45,    51,   114,   164,   178,   201,   202,   206,   207,   208,
     212,   141,   165,   164,   212,   165,   164,   212,   165,   164,
     212,   165,   213,   192,   222,   180,   180,   222,   166,   180,
     180,   216,   166,   166,   232,   232,   232,   232,   135,   135,
     144,   232,   232,   144,   182,   192,   192,   218,   232,   192,
     114,   201,   207,   142,   165,   114,   119,   164,   207,   208,
     209,   210,   164,   164,   164,   192,   166,   180,   165,   180,
     180,   165,   180,   181,   166,   144,   144,   144,   144,   144,
     182,   144,   144,   182,   166,   166,   165,   166,   142,   165,
     114,   232,   142,   163,   165,   142,   163,   165,   166,   216,
     185,   182,   182,   182,   182,   182,   182,   182,   165,   232,
     142,   163,   165,   165,   232,   192,   232,   192,   216,   222,
     181,   165,   232,   192,   165,   166,   165,   166,   165,   180,
     165,   180,   165,   166,   165,   165,   165
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc, yyscanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (yylocationp);
  YYUSE (yyscanner);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
#else
static void
yy_reduce_print (yyvsp, yylsp, yyrule, yyscanner)
    YYSTYPE *yyvsp;
    YYLTYPE *yylsp;
    int yyrule;
    yyscan_t yyscanner;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       , &(yylsp[(yyi + 1) - (yynrhs)])		       , yyscanner);
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, yylsp, Rule, yyscanner); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp, yyscanner)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
    yyscan_t yyscanner;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {
      case 114: /* "\"identifier\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6392 "parser.cpp"
	break;
      case 115: /* "\"typed hash identifier\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6397 "parser.cpp"
	break;
      case 116: /* "\"complex type identifier\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6402 "parser.cpp"
	break;
      case 117: /* "\"variable reference\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6407 "parser.cpp"
	break;
      case 118: /* "\"backquote expression\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6412 "parser.cpp"
	break;
      case 119: /* "\"in-object member reference\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6417 "parser.cpp"
	break;
      case 120: /* "\"identifier or keyword used as function or method identifier\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6422 "parser.cpp"
	break;
      case 121: /* "\"namespace or class-scoped reference\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6427 "parser.cpp"
	break;
      case 122: /* "\"namespace-scoped global variable reference\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6432 "parser.cpp"
	break;
      case 123: /* "\"context reference\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6437 "parser.cpp"
	break;
      case 124: /* "\"named context reference\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6442 "parser.cpp"
	break;
      case 125: /* "\"cast operator\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6447 "parser.cpp"
	break;
      case 126: /* "\"cast (or nothing) operator\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6452 "parser.cpp"
	break;
      case 127: /* "\"simple class declaration\"" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6457 "parser.cpp"
	break;
      case 128: /* "\"date/time value\"" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->datetime)) (yyvaluep->datetime)->deref(); };
#line 6462 "parser.cpp"
	break;
      case 129: /* "\"quoted string\"" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->String)) (yyvaluep->String)->deref(); };
#line 6467 "parser.cpp"
	break;
      case 130: /* "\"binary constant value\"" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->binary)) (yyvaluep->binary)->deref(); };
#line 6472 "parser.cpp"
	break;
      case 131: /* "\"regular expression substitution expression\"" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->RegexSubst); };
#line 6477 "parser.cpp"
	break;
      case 132: /* "\"transliteration expression\"" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->Trans); };
#line 6482 "parser.cpp"
	break;
      case 133: /* "\"scoped class declaration\"" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->nscope); };
#line 6487 "parser.cpp"
	break;
      case 134: /* "\"call to base class method\"" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->nscope); };
#line 6492 "parser.cpp"
	break;
      case 135: /* "\"regular expression\"" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->Regex); };
#line 6497 "parser.cpp"
	break;
      case 136: /* "\"regular expression extraction expression\"" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->Regex); };
#line 6502 "parser.cpp"
	break;
      case 137: /* "\"implicit argument reference\"" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->implicit_arg)) (yyvaluep->implicit_arg)->deref(); };
#line 6507 "parser.cpp"
	break;
      case 138: /* "\"keyword used as hash key or object member reference\"" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->String)) (yyvaluep->String)->deref(); };
#line 6512 "parser.cpp"
	break;
      case 139: /* "\"%try-module error token\"" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->trymod); };
#line 6517 "parser.cpp"
	break;
      case 174: /* "gvardecl" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->gv); };
#line 6522 "parser.cpp"
	break;
      case 175: /* "top_namespace_decl" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->ns); };
#line 6527 "parser.cpp"
	break;
      case 176: /* "namespace_decls" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->nsnlist)) (yyvaluep->nsnlist)->deref(); };
#line 6532 "parser.cpp"
	break;
      case 177: /* "namespace_decl" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->nsn)) (yyvaluep->nsn)->deref(); };
#line 6537 "parser.cpp"
	break;
      case 178: /* "unscoped_const_decl" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->constnode); };
#line 6542 "parser.cpp"
	break;
      case 179: /* "scoped_const_decl" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->constnode); };
#line 6547 "parser.cpp"
	break;
      case 180: /* "block" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->sblock); };
#line 6552 "parser.cpp"
	break;
      case 181: /* "statement_or_block" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->sblock); };
#line 6557 "parser.cpp"
	break;
      case 182: /* "statements" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->sblock); };
#line 6562 "parser.cpp"
	break;
      case 183: /* "optname" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6567 "parser.cpp"
	break;
      case 184: /* "statement" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6572 "parser.cpp"
	break;
      case 185: /* "context_mods" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->cmods); };
#line 6577 "parser.cpp"
	break;
      case 186: /* "context_mod" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->cmod); };
#line 6582 "parser.cpp"
	break;
      case 187: /* "return_statement" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6587 "parser.cpp"
	break;
      case 188: /* "switch_statement" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6592 "parser.cpp"
	break;
      case 189: /* "case_block" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->switchstmt); };
#line 6597 "parser.cpp"
	break;
      case 190: /* "case_code" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->casenode); };
#line 6602 "parser.cpp"
	break;
      case 191: /* "try_statement" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->statement); };
#line 6607 "parser.cpp"
	break;
      case 192: /* "myexp" */
#line 1853 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6612 "parser.cpp"
	break;
      case 193: /* "hashdecl_def" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->hashdecldef); };
#line 6617 "parser.cpp"
	break;
      case 194: /* "class_def" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->classdef); };
#line 6622 "parser.cpp"
	break;
      case 195: /* "inheritance_list" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->sclist); };
#line 6627 "parser.cpp"
	break;
      case 196: /* "superclass_list" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->sclist); };
#line 6632 "parser.cpp"
	break;
      case 197: /* "superclass" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->sclnode); };
#line 6637 "parser.cpp"
	break;
      case 198: /* "hashdecl_attrs" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->hashdeclpriv)) (yyvaluep->hashdeclpriv)->deref(); };
#line 6642 "parser.cpp"
	break;
      case 199: /* "hashdecl_member" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6647 "parser.cpp"
	break;
      case 200: /* "class_attributes" */
#line 1849 "parser.ypp"
	{ qore_class_private::get(*(yyvaluep->qoreclass))->deref(true, true); };
#line 6652 "parser.cpp"
	break;
      case 201: /* "uncqtypedef" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->parsertype); };
#line 6657 "parser.cpp"
	break;
      case 202: /* "qtypedef" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->parsertype); };
#line 6662 "parser.cpp"
	break;
      case 203: /* "internal_member_list" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6667 "parser.cpp"
	break;
      case 204: /* "private_member_list" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6672 "parser.cpp"
	break;
      case 205: /* "public_member_list" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6677 "parser.cpp"
	break;
      case 206: /* "classvardecl" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->classvarinfo); };
#line 6682 "parser.cpp"
	break;
      case 207: /* "member2" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6687 "parser.cpp"
	break;
      case 208: /* "transient_member2" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6692 "parser.cpp"
	break;
      case 209: /* "member" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6697 "parser.cpp"
	break;
      case 210: /* "transient_member" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberinfo); };
#line 6702 "parser.cpp"
	break;
      case 211: /* "member_list" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6707 "parser.cpp"
	break;
      case 212: /* "member_list2" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->memberlist); };
#line 6712 "parser.cpp"
	break;
      case 213: /* "ident_openparen" */
#line 1850 "parser.ypp"
	{ free((yyvaluep->string)); };
#line 6717 "parser.cpp"
	break;
      case 214: /* "inline_methoddef" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->methodnode); };
#line 6722 "parser.cpp"
	break;
      case 215: /* "outofline_methoddef" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->methoddef); };
#line 6727 "parser.cpp"
	break;
      case 216: /* "base_constructor_list" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->bcalist); };
#line 6732 "parser.cpp"
	break;
      case 217: /* "base_constructors" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->bcalist); };
#line 6737 "parser.cpp"
	break;
      case 218: /* "base_constructor" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->bcanode); };
#line 6742 "parser.cpp"
	break;
      case 222: /* "return_value" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->returnTypeInfo); };
#line 6747 "parser.cpp"
	break;
      case 223: /* "sub_def" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->parsefunc); };
#line 6752 "parser.cpp"
	break;
      case 224: /* "scoped_sub_def" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->sparsefunc); };
#line 6757 "parser.cpp"
	break;
      case 225: /* "list" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->parse_list)) (yyvaluep->parse_list)->deref(); };
#line 6762 "parser.cpp"
	break;
      case 226: /* "list_n" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->parse_list)) (yyvaluep->parse_list)->deref(); };
#line 6767 "parser.cpp"
	break;
      case 227: /* "hash" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->hash); };
#line 6772 "parser.cpp"
	break;
      case 228: /* "hash_element" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->hashelement); };
#line 6777 "parser.cpp"
	break;
      case 229: /* "alt_hash" */
#line 1848 "parser.ypp"
	{ delete (yyvaluep->hash); };
#line 6782 "parser.cpp"
	break;
      case 230: /* "immediate_typed_hash" */
#line 1852 "parser.ypp"
	{ if ((yyvaluep->node)) (yyvaluep->node)->deref(nullptr); };
#line 6787 "parser.cpp"
	break;
      case 231: /* "exp_c" */
#line 1853 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6792 "parser.cpp"
	break;
      case 232: /* "exp" */
#line 1853 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6797 "parser.cpp"
	break;
      case 233: /* "exp_n" */
#line 1853 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6802 "parser.cpp"
	break;
      case 234: /* "string" */
#line 1851 "parser.ypp"
	{ if ((yyvaluep->String)) (yyvaluep->String)->deref(); };
#line 6807 "parser.cpp"
	break;
      case 235: /* "scalar" */
#line 1853 "parser.ypp"
	{ (yyvaluep->qv).discard(nullptr); };
#line 6812 "parser.cpp"
	break;

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (yyscan_t yyscanner);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (yyscan_t yyscanner)
#else
int
yyparse (yyscanner)
    yyscan_t yyscanner;
#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the look-ahead symbol.  */
YYLTYPE yylloc;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[2];

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
#if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 0;
#endif

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 1861 "parser.ypp"
    {
           (yyvsp[(1) - (1)].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 5:
#line 1864 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].sparsefunc)->loc, "function", (yyvsp[(1) - (1)].sparsefunc)->name.ostr);
           (yyvsp[(1) - (1)].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 6:
#line 1869 "parser.ypp"
    {
           qore_root_ns_private::parseAddClass((yyvsp[(1) - (1)].classdef)->loc, *((yyvsp[(1) - (1)].classdef)->name), (yyvsp[(1) - (1)].classdef)->oc);

           // see if class definitions are allowed
           if (parse_check_parse_option(PO_NO_CLASS_DEFS))
              parse_error(*(yyvsp[(1) - (1)].classdef)->loc, "illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
           delete (yyvsp[(1) - (1)].classdef);
        }
    break;

  case 7:
#line 1877 "parser.ypp"
    {
           qore_root_ns_private::parseAddHashDecl((yyvsp[(1) - (1)].hashdecldef)->loc, *((yyvsp[(1) - (1)].hashdecldef)->name), (yyvsp[(1) - (1)].hashdecldef)->takeHashDecl());
           delete (yyvsp[(1) - (1)].hashdecldef);
        }
    break;

  case 8:
#line 1881 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].constnode)->loc, "constant", (yyvsp[(1) - (1)].constnode)->name.ostr);
           qore_root_ns_private::parseAddConstant((yyvsp[(1) - (1)].constnode)->loc, *getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
           delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 9:
#line 1887 "parser.ypp"
    {
           qore_root_ns_private::parseAddConstant((yyvsp[(1) - (1)].constnode)->loc, *getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
           delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 10:
#line 1891 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].methoddef)->loc, "method", (yyvsp[(1) - (1)].methoddef)->name.ostr);
           (yyvsp[(1) - (1)].methoddef)->parseAddToClassAndDel();
        }
    break;

  case 11:
#line 1896 "parser.ypp"
    {
           if ((yyvsp[(1) - (1)].statement)) {
              if ((yyvsp[(1) - (1)].statement)->isParseDeclaration())
                 delete (yyvsp[(1) - (1)].statement);
              else
                 qore_program_private::addStatement(*(getProgram()), (yyvsp[(1) - (1)].statement));
           }
        }
    break;

  case 13:
#line 1905 "parser.ypp"
    {
            (yyvsp[(2) - (3)].sblock)->finalizeBlock((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            qore_program_private::addStatement(*(getProgram()), (yyvsp[(2) - (3)].sblock));
        }
    break;

  case 14:
#line 1909 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            qore_root_ns_private::parseAddNamespace((yyvsp[(1) - (1)].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
        }
    break;

  case 15:
#line 1916 "parser.ypp"
    {
            QoreModuleDefContext* qmd = get_module_def_context();
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");
            else {
                QoreUserModuleDefContextHelper* uqmd = static_cast<QoreUserModuleDefContextHelper*>(qmd);
                uqmd->close();
            }
            // registered internally
        }
    break;

  case 16:
#line 1926 "parser.ypp"
    {
            bool has_dollar = (yyvsp[(1) - (1)].trymod)->var[0] == '$';
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            if (!has_dollar) {
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS)) {
                    parse_error(*loc, "%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (1)].trymod)->var);
                }
            } else {
                (yyvsp[(1) - (1)].trymod)->fixName();
                if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].trymod)->var);
            }

            if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
                parse_error(*loc, "'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
            } else {
                VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode(loc, (yyvsp[(1) - (1)].trymod)->takeName());
                QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(loc, left, (yyvsp[(1) - (1)].trymod)->takeExceptionHash());
                qore_program_private::addStatement(*(getProgram()), new ExpressionStatement(loc, exp));
            }
            delete (yyvsp[(1) - (1)].trymod);
        }
    break;

  case 17:
#line 1951 "parser.ypp"
    {
        }
    break;

  case 18:
#line 1953 "parser.ypp"
    {
        }
    break;

  case 19:
#line 1958 "parser.ypp"
    {
            QoreModuleDefContext* qmd = get_module_def_context();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[(1) - (4)].string), (yyvsp[(3) - (4)].qv).getTypeName());
            else
                qmd->set(loc, (yyvsp[(1) - (4)].string), (yyvsp[(3) - (4)].qv));

            free((yyvsp[(1) - (4)].string));
            (yyvsp[(3) - (4)].qv).discard(nullptr);
        }
    break;

  case 20:
#line 1972 "parser.ypp"
    { (yyval.b) = false; }
    break;

  case 21:
#line 1973 "parser.ypp"
    {
           (yyval.b) = true;
        }
    break;

  case 22:
#line 1979 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[(4) - (4)].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 23:
#line 1988 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].b), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[(3) - (3)].string));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
        }
    break;

  case 24:
#line 1995 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 25:
#line 2002 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].b), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
        }
    break;

  case 26:
#line 2007 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[(4) - (4)].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 27:
#line 2016 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 28:
#line 2023 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].b), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].b) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            (yyval.gv) = new GVarListDecl(loc, (yyvsp[(4) - (5)].parse_list), (yyvsp[(1) - (5)].b));
        }
    break;

  case 29:
#line 2028 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "thread_local variable", (yyvsp[(4) - (4)].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true, VT_THREAD_LOCAL);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 30:
#line 2037 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].b), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "thread_local variable", (yyvsp[(3) - (3)].string));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true, VT_THREAD_LOCAL);
        }
    break;

  case 31:
#line 2044 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), true, VT_THREAD_LOCAL);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 32:
#line 2051 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].b), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].b) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true, VT_THREAD_LOCAL);
        }
    break;

  case 33:
#line 2056 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "thread_local variable", (yyvsp[(4) - (4)].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false, VT_THREAD_LOCAL);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 34:
#line 2065 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].b), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].b) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(3) - (4)].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[(4) - (4)].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[(3) - (4)].parsertype)), (yyvsp[(1) - (4)].b), false, VT_THREAD_LOCAL);
            delete (yyvsp[(3) - (4)].parsertype);
        }
    break;

  case 35:
#line 2072 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].b), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].b) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            (yyval.gv) = new GVarListDecl(loc, (yyvsp[(4) - (5)].parse_list), (yyvsp[(1) - (5)].b), VT_THREAD_LOCAL);
        }
    break;

  case 36:
#line 2080 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].i4), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].i4) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[(1) - (5)].i4), *p);
            (yyvsp[(4) - (5)].nsnlist)->add(*p);
            delete (yyvsp[(4) - (5)].nsnlist);
            (yyval.ns) = p->ns;
        }
    break;

  case 37:
#line 2089 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].i4), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].i4) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[(1) - (3)].i4), *p);
            (yyval.ns) = p->ns;
        }
    break;

  case 38:
#line 2096 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].i4), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].i4) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[(1) - (4)].i4), *p);
            (yyval.ns) = p->ns;
        }
    break;

  case 39:
#line 2106 "parser.ypp"
    {
           (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[(1) - (1)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(1) - (1)].nsn));
        }
    break;

  case 40:
#line 2111 "parser.ypp"
    {
           (yyval.nsnlist) = (yyvsp[(1) - (2)].nsnlist);
           if ((yyvsp[(2) - (2)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(2) - (2)].nsn));
        }
    break;

  case 41:
#line 2119 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].constnode)->loc, "constant", (yyvsp[(1) - (1)].constnode)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
        }
    break;

  case 42:
#line 2124 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
        }
    break;

  case 43:
#line 2127 "parser.ypp"
    {
            (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].classdef));
            // see if class definitions are allowed
            if (parse_check_parse_option(PO_NO_CLASS_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
                parse_error(*loc, "illegal class definition \"%s\" (conflicts with parse option PO_NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
            }
        }
    break;

  case 44:
#line 2135 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].hashdecldef));
        }
    break;

  case 45:
#line 2138 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].parsefunc));
        }
    break;

  case 46:
#line 2141 "parser.ypp"
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[(1) - (1)].sparsefunc)->loc, "function", (yyvsp[(1) - (1)].sparsefunc)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].sparsefunc));
        }
    break;

  case 47:
#line 2146 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (2)].gv));
        }
    break;

  case 48:
#line 2149 "parser.ypp"
    {
            (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
            }
        }
    break;

  case 49:
#line 2157 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].methoddef));
        }
    break;

  case 50:
#line 2163 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line), (yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].qv));
        }
    break;

  case 51:
#line 2166 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line), (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].qv), true);
        }
    break;

  case 52:
#line 2172 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line), (yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].qv));
        }
    break;

  case 53:
#line 2175 "parser.ypp"
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line), (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].qv), true);
        }
    break;

  case 54:
#line 2182 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(2) - (3)].sblock); }
    break;

  case 55:
#line 2185 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line); }
    break;

  case 56:
#line 2190 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 57:
#line 2193 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(1) - (1)].sblock); }
    break;

  case 58:
#line 2198 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 59:
#line 2200 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].sblock)); }
    break;

  case 60:
#line 2202 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].sblock)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 61:
#line 2204 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].statement)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 62:
#line 2209 "parser.ypp"
    { (yyval.string) = 0; }
    break;

  case 63:
#line 2210 "parser.ypp"
    { (yyval.string) = (yyvsp[(1) - (1)].string); }
    break;

  case 64:
#line 2214 "parser.ypp"
    { (yyval.statement) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line); }
    break;

  case 65:
#line 2215 "parser.ypp"
    {
            qore_program_private* pgm = qore_program_private::get(*getProgram());
            // if the expression has no effect and it's not a variable declaration
            qore_type_t t = (yyvsp[(1) - (2)].qv).getType();
            bool ok = false;
            if (t == NT_PARSE_LIST) {
                QoreParseListNode* l = (yyvsp[(1) - (2)].qv).get<QoreParseListNode>();
                // rewrite expression if it's a list without parentheses under certain conditions
                (yyvsp[(1) - (2)].qv).set(check_rewrite_list(l));

                if (l->isVariableList())
                    ok = true;
            }

            const QoreProgramLocation* loc = pgm->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);

            if (!ok) {
                if (!value_has_effect_as_root((yyvsp[(1) - (2)].qv)) && (t != NT_VARREF || !(yyvsp[(1) - (2)].qv).get<VarRefNode>()->parseIsDecl())) {
                    if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                        parse_error(*loc, "expression has no effect as top-level statement (%s)", (yyvsp[(1) - (2)].qv).getTypeName());
                    }
                } else if (!(yyvsp[(1) - (2)].qv).hasEffect() && (t != NT_VARREF || !(yyvsp[(1) - (2)].qv).get<VarRefNode>()->parseIsDecl())) {
                    parse_error(*loc, "statement has no effect (%s)", (yyvsp[(1) - (2)].qv).getTypeName());
                }
            }

            ignore_return_value((yyvsp[(1) - (2)].qv));
            (yyval.statement) = new ExpressionStatement(loc, (yyvsp[(1) - (2)].qv));
        }
    break;

  case 66:
#line 2245 "parser.ypp"
    {
            NamedScope *ns = new NamedScope((yyvsp[(1) - (5)].string));
            assert(ns->size() > 1);
            printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.statement) = new ExpressionStatement(loc, new StaticMethodCallNode(loc, ns, make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[(3) - (5)]).first_line, (yylsp[(3) - (5)]).last_line), (yyvsp[(3) - (5)].qv))));
        }
    break;

  case 67:
#line 2253 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 68:
#line 2254 "parser.ypp"
    {
           (yyval.statement) = new RethrowStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 69:
#line 2257 "parser.ypp"
    {
           (yyval.statement) = new ThrowStatement((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line, (yyvsp[(2) - (3)].qv));
        }
    break;

  case 70:
#line 2260 "parser.ypp"
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Unconditional);
        }
    break;

  case 71:
#line 2263 "parser.ypp"
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Success);
        }
    break;

  case 72:
#line 2266 "parser.ypp"
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Error);
        }
    break;

  case 73:
#line 2269 "parser.ypp"
    {
           (yyval.statement) = new ContextStatement((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, 0, 0, (yyvsp[(2) - (3)].cmods), (yyvsp[(3) - (3)].sblock));
        }
    break;

  case 74:
#line 2272 "parser.ypp"
    {
           (yyval.statement) = new SummarizeStatement((yylsp[(1) - (11)]).first_line, (yylsp[(11) - (11)]).last_line, (yyvsp[(2) - (11)].string), (yyvsp[(4) - (11)].qv), (yyvsp[(10) - (11)].cmods), (yyvsp[(11) - (11)].sblock), (yyvsp[(8) - (11)].qv));
        }
    break;

  case 75:
#line 2275 "parser.ypp"
    {
           (yyval.statement) = new ContextStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].string), (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].cmods), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 76:
#line 2278 "parser.ypp"
    {
           (yyval.statement) = new IfStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 77:
#line 2281 "parser.ypp"
    {
           (yyval.statement) = new IfStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(3) - (7)].qv), (yyvsp[(5) - (7)].sblock), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 78:
#line 2284 "parser.ypp"
    {
           (yyval.statement) = new WhileStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 79:
#line 2287 "parser.ypp"
    {
           (yyval.statement) = new DoWhileStatement((yylsp[(1) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].qv), (yyvsp[(2) - (7)].sblock));
        }
    break;

  case 80:
#line 2290 "parser.ypp"
    {
           (yyval.statement) = new ForStatement((yylsp[(1) - (9)]).first_line, (yylsp[(9) - (9)]).last_line, (yyvsp[(3) - (9)].qv), (yyvsp[(5) - (9)].qv), (yyvsp[(7) - (9)].qv), (yyvsp[(9) - (9)].sblock));
        }
    break;

  case 81:
#line 2293 "parser.ypp"
    {
           (yyval.statement) = new ForEachStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].qv), (yyvsp[(5) - (7)].qv), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 82:
#line 2296 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (2)].statement); }
    break;

  case 83:
#line 2297 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
            // see if thread exit is allowed
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL)) {
                parse_error(*loc, "illegal use of \"thread_exit\" (conflicts with parse option PO_NO_THREAD_CONTROL)");
            }
            (yyval.statement) = new ThreadExitStatement(loc);
        }
    break;

  case 84:
#line 2305 "parser.ypp"
    {
            (yyval.statement) = new BreakStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 85:
#line 2308 "parser.ypp"
    {
            (yyval.statement) = new ContinueStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
        }
    break;

  case 86:
#line 2311 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 87:
#line 2312 "parser.ypp"
    { (yyval.statement) = 0; }
    break;

  case 88:
#line 2317 "parser.ypp"
    { (yyval.cmods) = 0; }
    break;

  case 89:
#line 2318 "parser.ypp"
    {
           if (!(yyvsp[(1) - (2)].cmods))
              (yyval.cmods) = new ContextModList((yyvsp[(2) - (2)].cmod));
           else {
              (yyvsp[(1) - (2)].cmods)->addContextMod((yyvsp[(2) - (2)].cmod));
              (yyval.cmods) = (yyvsp[(1) - (2)].cmods);
           }
        }
    break;

  case 90:
#line 2330 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[(3) - (4)].qv)); }
    break;

  case 91:
#line 2332 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[(3) - (4)].qv)); }
    break;

  case 92:
#line 2334 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[(3) - (4)].qv)); }
    break;

  case 93:
#line 2338 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line); }
    break;

  case 94:
#line 2340 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].qv)); }
    break;

  case 95:
#line 2345 "parser.ypp"
    {
           (yyvsp[(6) - (7)].switchstmt)->setSwitch((yyvsp[(3) - (7)].qv));
           (yyval.statement) = (yyvsp[(6) - (7)].switchstmt);
           (yyval.statement)->finalizeBlock((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
        }
    break;

  case 96:
#line 2354 "parser.ypp"
    {
           (yyval.switchstmt) = new SwitchStatement((yyvsp[(1) - (1)].casenode));
        }
    break;

  case 97:
#line 2358 "parser.ypp"
    {
           (yyvsp[(1) - (2)].switchstmt)->addCase((yyvsp[(2) - (2)].casenode));
           (yyval.switchstmt) = (yyvsp[(1) - (2)].switchstmt);
        }
    break;

  case 98:
#line 2366 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, ">=", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
    break;

  case 99:
#line 2372 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, ">=", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
    break;

  case 100:
#line 2378 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, "<=", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
    break;

  case 101:
#line 2384 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, "<=", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
    break;

  case 102:
#line 2390 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, "==", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalEqualsOperatorNode::softEqual);
        }
    break;

  case 103:
#line 2396 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, "==", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalEqualsOperatorNode::softEqual);
        }
    break;

  case 104:
#line 2402 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, "<", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalLessThanOperatorNode::doLessThan);
        }
    break;

  case 105:
#line 2408 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, "<", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalLessThanOperatorNode::doLessThan);
        }
    break;

  case 106:
#line 2414 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            check_case(loc, ">", (yyvsp[(3) - (5)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].sblock), QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
    break;

  case 107:
#line 2420 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, ">", (yyvsp[(3) - (4)].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[(3) - (4)].qv), nullptr, QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
    break;

  case 108:
#line 2426 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 109:
#line 2431 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(3) - (4)].Regex), nullptr);
        }
    break;

  case 110:
#line 2436 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
        }
    break;

  case 111:
#line 2441 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[(3) - (4)].Regex), nullptr);
        }
    break;

  case 112:
#line 2446 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(2) - (4)].Regex), (yyvsp[(4) - (4)].sblock));
        }
    break;

  case 113:
#line 2451 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[(2) - (3)].Regex), nullptr);
        }
    break;

  case 114:
#line 2456 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            check_case(loc, 0, (yyvsp[(2) - (4)].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[(2) - (4)].qv), (yyvsp[(4) - (4)].sblock));
        }
    break;

  case 115:
#line 2462 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            check_case(loc, 0, (yyvsp[(2) - (3)].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[(2) - (3)].qv), nullptr);
        }
    break;

  case 116:
#line 2468 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), (yyvsp[(3) - (3)].sblock), true);
        }
    break;

  case 117:
#line 2473 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), nullptr, true);
        }
    break;

  case 118:
#line 2480 "parser.ypp"
    {
            char* param = 0;
            const QoreTypeInfo* typeInfo = nullptr;
            QoreParseTypeInfo* parseTypeInfo = nullptr;
            const QoreProgramLocation* loc =
                qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            bool missing_type_decl = true;
            if ((yyvsp[(5) - (7)].qv).getType() == NT_VARREF) {
                VarRefNode* varRefNode = (yyvsp[(5) - (7)].qv).get<VarRefNode>();
                param = varRefNode->takeName();
                if (varRefNode->isDecl()) {
                    VarRefDeclNode* varRefDeclNode = static_cast<VarRefDeclNode*>(varRefNode);
                    parseTypeInfo = varRefDeclNode->takeParseTypeInfo();
                    if (!parseTypeInfo)
                        typeInfo = varRefDeclNode->getTypeInfo();
                    missing_type_decl = false;
                }
            } else if ((yyvsp[(5) - (7)].qv).getType() == NT_BAREWORD) {
                param = (yyvsp[(5) - (7)].qv).get<BarewordNode>()->takeString();
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "local variable '%s' in catch parameter list declared without '$' prefix, but " \
                        "parse option 'allow-bare-refs' is not set", param);
            } else if ((yyvsp[(5) - (7)].qv)) {
                parse_error(*loc, "only one parameter accepted in catch block for exception hash");
                missing_type_decl = false;
            }
            if ((yyvsp[(5) - (7)].qv) && missing_type_decl) {
                int64 po = parse_get_parse_options();
                if (po & (PO_STRICT_TYPES|PO_REQUIRE_TYPES)) {
                    SimpleRefHolder<QoreStringNode> desc(new QoreStringNodeMaker("the catch block is missing a " \
                        "type declaration; the exception argument should be declared as 'hash<ExceptionInfo>' or " \
                        "with a compatible type"));
                    // issue #2943: raise an error for mixing string and non-scalar values with %strict-types
                    if (po & PO_STRICT_TYPES) {
                        desc->concat("; this is an error when %strict-types is in effect");
                        qore_program_private::makeParseException(getProgram(), *loc, "PARSE-TYPE-ERROR", desc.release());
                    } else {
                        qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_INVALID_CATCH,
                            "INVALID-CATCH", desc.release());
                    }
                }
            }
            (yyvsp[(5) - (7)].qv).discard(nullptr);
            const QoreProgramLocation* vloc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(5) - (7)].qv) ? (yylsp[(5) - (7)]).first_line : 0, (yyvsp[(5) - (7)].qv) ? (yylsp[(5) - (7)]).last_line : 0);
            (yyval.statement) = new TryStatement(loc, (yyvsp[(2) - (7)].sblock), (yyvsp[(7) - (7)].sblock), param, typeInfo, parseTypeInfo, vloc);
        }
    break;

  case 119:
#line 2528 "parser.ypp"
    { (yyval.qv).set(nullptr); }
    break;

  case 120:
#line 2529 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].qv)); }
    break;

  case 121:
#line 2530 "parser.ypp"
    { (yyval.qv).set(nullptr); }
    break;

  case 122:
#line 2534 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].i4), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            check_hashdeclmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].hashdeclpriv));
        }
    break;

  case 123:
#line 2540 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].i4), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            check_hashdeclmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].hashdeclpriv));
        }
    break;

  case 124:
#line 2549 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].i4), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            check_classmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
            qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (6)].string), (yyvsp[(5) - (6)].qoreclass));
        }
    break;

  case 125:
#line 2556 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].i4), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].i4) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[(2) - (6)].nscope)->ostr);
            check_classmod(loc, (yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (6)].nscope), (yyvsp[(5) - (6)].qoreclass));
            qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
        }
    break;

  case 126:
#line 2565 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].i4), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].i4) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[(1) - (4)].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (4)].string), qc);
        }
    break;

  case 127:
#line 2574 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (4)].i4), (yyloc), (yylsp[(2) - (4)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (4)].i4) ? (yylsp[(1) - (4)]).first_line : (yylsp[(2) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[(2) - (4)].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[(1) - (4)].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (4)].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
        }
    break;

  case 128:
#line 2585 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].i4), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].i4) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[(1) - (5)].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (5)].string), qc);
        }
    break;

  case 129:
#line 2594 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].i4), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].i4) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[(2) - (5)].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[(1) - (5)].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[(2) - (5)].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
        }
    break;

  case 130:
#line 2608 "parser.ypp"
    {
           (yyval.sclist) = (yyvsp[(2) - (2)].sclist);
        }
    break;

  case 131:
#line 2611 "parser.ypp"
    { // NOTHING
           (yyval.sclist) = 0;
        }
    break;

  case 132:
#line 2617 "parser.ypp"
    {
           (yyval.sclist) = new BCList((yyvsp[(1) - (1)].sclnode));
        }
    break;

  case 133:
#line 2620 "parser.ypp"
    {
           (yyvsp[(1) - (3)].sclist)->push_back((yyvsp[(3) - (3)].sclnode));
           (yyval.sclist) = (yyvsp[(1) - (3)].sclist);
        }
    break;

  case 134:
#line 2627 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(1) - (1)].string), Public);
        }
    break;

  case 135:
#line 2631 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(1) - (1)].string)), Public);
        }
    break;

  case 136:
#line 2635 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(2) - (2)].string), Public);
        }
    break;

  case 137:
#line 2639 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(2) - (2)].string)), Public);
        }
    break;

  case 138:
#line 2643 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(2) - (2)].string), Private);
        }
    break;

  case 139:
#line 2647 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(2) - (2)].string)), Private);
        }
    break;

  case 140:
#line 2651 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(2) - (2)].string), Private);
        }
    break;

  case 141:
#line 2655 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(2) - (2)].string)), Private);
        }
    break;

  case 142:
#line 2659 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[(2) - (2)].string), Internal);
        }
    break;

  case 143:
#line 2663 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[(2) - (2)].string)), Internal);
        }
    break;

  case 144:
#line 2670 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.hashdeclpriv) = new typed_hash_decl_private(loc);
            if ((yyvsp[(1) - (1)].memberinfo)) {
                (yyval.hashdeclpriv)->parseAdd((yyvsp[(1) - (1)].memberinfo)->getHashMemPair());
                delete (yyvsp[(1) - (1)].memberinfo);
            }
        }
    break;

  case 145:
#line 2678 "parser.ypp"
    {
            if ((yyvsp[(2) - (2)].memberinfo)) {
                if ((yyvsp[(1) - (2)].hashdeclpriv)->hasMember((yyvsp[(2) - (2)].memberinfo)->name)) {
                    parse_error(*(yyvsp[(2) - (2)].memberinfo)->loc, "duplicate hashdecl member declaration '%s'", (yyvsp[(2) - (2)].memberinfo)->name);
                } else {
                    // add new member to list
                    (yyvsp[(1) - (2)].hashdeclpriv)->parseAdd((yyvsp[(2) - (2)].memberinfo)->getHashMemPair());
                }
                delete (yyvsp[(2) - (2)].memberinfo);
            }

            (yyval.hashdeclpriv) = (yyvsp[(1) - (2)].hashdeclpriv);
        }
    break;

  case 146:
#line 2694 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (3)].parsertype))));
            delete (yyvsp[(1) - (3)].parsertype);
        }
    break;

  case 147:
#line 2699 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (5)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (5)].parsertype)), (yyvsp[(4) - (5)].qv)));
            delete (yyvsp[(1) - (5)].parsertype);
        }
    break;

  case 148:
#line 2704 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].parsertype) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype));

            if (!(yyvsp[(1) - (6)].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* aloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line);
                if (pti->subtypes.size()) {
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(aloc, (yyvsp[(4) - (6)].qv)));
                }
                else {
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(aloc, (yyvsp[(4) - (6)].qv)));
                }
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new HashDeclMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[(1) - (6)].parsertype);
        }
    break;

  case 149:
#line 2731 "parser.ypp"
    {
           (yyval.qoreclass) = new QoreParseClass((yyvsp[(1) - (1)].methodnode)->getLoc());
           (yyvsp[(1) - (1)].methodnode)->addAndDelete((yyval.qoreclass));
        }
    break;

  case 150:
#line 2735 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            (yyvsp[(1) - (1)].memberlist)->merge((yyval.qoreclass), Internal);
            delete (yyvsp[(1) - (1)].memberlist);
        }
    break;

  case 151:
#line 2741 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            (yyvsp[(1) - (1)].memberlist)->merge((yyval.qoreclass), Private);
            delete (yyvsp[(1) - (1)].memberlist);
        }
    break;

  case 152:
#line 2747 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            (yyvsp[(1) - (1)].memberlist)->merge((yyval.qoreclass), Public);
            delete (yyvsp[(1) - (1)].memberlist);
        }
    break;

  case 153:
#line 2753 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[(1) - (1)].constnode)->getName(), (yyvsp[(1) - (1)].constnode)->takeValue(), Public);
            delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 154:
#line 2759 "parser.ypp"
    {
            (yyvsp[(2) - (2)].methodnode)->addAndDelete((yyvsp[(1) - (2)].qoreclass));
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
        }
    break;

  case 155:
#line 2763 "parser.ypp"
    {
            (yyvsp[(2) - (2)].memberlist)->merge((yyvsp[(1) - (2)].qoreclass), Internal);
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
            delete (yyvsp[(2) - (2)].memberlist);
        }
    break;

  case 156:
#line 2768 "parser.ypp"
    {
            (yyvsp[(2) - (2)].memberlist)->merge((yyvsp[(1) - (2)].qoreclass), Private);
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
            delete (yyvsp[(2) - (2)].memberlist);
        }
    break;

  case 157:
#line 2773 "parser.ypp"
    {
            (yyvsp[(2) - (2)].memberlist)->merge((yyvsp[(1) - (2)].qoreclass), Public);
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
            delete (yyvsp[(2) - (2)].memberlist);
        }
    break;

  case 158:
#line 2778 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[(2) - (2)].constnode)->getName(), (yyvsp[(2) - (2)].constnode)->takeValue(), Public);
            (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
            delete (yyvsp[(2) - (2)].constnode);
        }
    break;

  case 159:
#line 2787 "parser.ypp"
    {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[(1) - (1)].string), false);
        }
    break;

  case 160:
#line 2790 "parser.ypp"
    {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[(1) - (1)].string), false));
        }
    break;

  case 161:
#line 2793 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[(1) - (1)].string), false);
        }
    break;

  case 162:
#line 2797 "parser.ypp"
    {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[(2) - (2)].string), true);
        }
    break;

  case 163:
#line 2800 "parser.ypp"
    {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[(2) - (2)].string), true));
        }
    break;

  case 164:
#line 2803 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[(2) - (2)].string), true);
        }
    break;

  case 165:
#line 2811 "parser.ypp"
    { (yyval.parsertype) = 0; }
    break;

  case 166:
#line 2812 "parser.ypp"
    {
           (yyval.parsertype) = (yyvsp[(1) - (1)].parsertype);
        }
    break;

  case 167:
#line 2818 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 168:
#line 2819 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 169:
#line 2820 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 170:
#line 2824 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 171:
#line 2825 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 172:
#line 2826 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 173:
#line 2827 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 174:
#line 2828 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 175:
#line 2829 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 176:
#line 2833 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 177:
#line 2834 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 178:
#line 2835 "parser.ypp"
    { (yyval.memberlist) = new EmptyMemberList; }
    break;

  case 179:
#line 2839 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (4)].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (4)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (4)].parsertype))));
            delete (yyvsp[(2) - (4)].parsertype);
        }
    break;

  case 180:
#line 2844 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (3)].string), new QoreVarInfo(loc));
        }
    break;

  case 181:
#line 2848 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (6)].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (6)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (6)].parsertype)), (yyvsp[(5) - (6)].qv)));
            //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
            delete (yyvsp[(2) - (6)].parsertype);
        }
    break;

  case 182:
#line 2854 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (5)].string), new QoreVarInfo(loc, nullptr, nullptr, (yyvsp[(4) - (5)].qv)));
        }
    break;

  case 183:
#line 2858 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(6) - (7)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype));

            if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[(5) - (7)].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[(5) - (7)].qv)));
            }

            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (7)].string), new QoreVarInfo(loc, t, pti, new_call));

            delete (yyvsp[(2) - (7)].parsertype);
        }
    break;

  case 184:
#line 2881 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (3)].parsertype), (yyloc), (yylsp[(2) - (3)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (3)].parsertype) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (3)].parsertype))));
            delete (yyvsp[(1) - (3)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (3)].string));
        }
    break;

  case 185:
#line 2889 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (5)].parsertype), (yyloc), (yylsp[(2) - (5)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (5)].parsertype) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (5)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (5)].parsertype)), (yyvsp[(4) - (5)].qv)));
            delete (yyvsp[(1) - (5)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (5)].string));
        }
    break;

  case 186:
#line 2897 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (6)].parsertype), (yyloc), (yylsp[(2) - (6)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (6)].parsertype) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = (yyvsp[(1) - (6)].parsertype) ? ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype)) : nullptr;

            if (!(yyvsp[(1) - (6)].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line);
                if (pti && pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[(4) - (6)].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[(4) - (6)].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[(1) - (6)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (6)].string));
        }
    break;

  case 187:
#line 2922 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (3)].parsertype))));
            delete (yyvsp[(1) - (3)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (3)].string));
        }
    break;

  case 188:
#line 2929 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[(1) - (5)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (5)].parsertype)), (yyvsp[(4) - (5)].qv)));
            delete (yyvsp[(1) - (5)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (5)].string));
        }
    break;

  case 189:
#line 2936 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(5) - (6)]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype));

            if (!(yyvsp[(1) - (6)].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[(4) - (6)].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[(4) - (6)].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[(1) - (6)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (6)].string));
        }
    break;

  case 190:
#line 2960 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo(loc));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (2)].string));
        }
    break;

  case 191:
#line 2966 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (4)].string), new QoreMemberInfo(loc, nullptr, nullptr, (yyvsp[(3) - (4)].qv)));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (4)].string));
        }
    break;

  case 192:
#line 2972 "parser.ypp"
    {
            (yyval.memberinfo) = (yyvsp[(1) - (1)].classvarinfo);
        }
    break;

  case 193:
#line 2975 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            if ((yyvsp[(1) - (1)].constnode)->pub)
                parse_error(*loc, "cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[(1) - (1)].constnode)->name.ostr);
            (yyval.memberinfo) = new MemberInfo(loc, (yyvsp[(1) - (1)].constnode)->name.takeName(), (yyvsp[(1) - (1)].constnode)->value);
            delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 194:
#line 2985 "parser.ypp"
    {
            (yyval.memberinfo) = (yyvsp[(2) - (2)].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
    break;

  case 195:
#line 2992 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (1)].string), new QoreMemberInfo(loc));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
        }
    break;

  case 196:
#line 2998 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo(loc, nullptr, new QoreParseTypeInfo((yyvsp[(2) - (2)].string))));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (2)].string));
        }
    break;

  case 197:
#line 3007 "parser.ypp"
    {
            (yyval.memberinfo) = (yyvsp[(2) - (2)].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
    break;

  case 198:
#line 3014 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 199:
#line 3017 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 200:
#line 3020 "parser.ypp"
    {
           (yyvsp[(1) - (3)].memberlist)->add((yyvsp[(3) - (3)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (3)].memberlist);
        }
    break;

  case 201:
#line 3024 "parser.ypp"
    {
           (yyvsp[(1) - (3)].memberlist)->add((yyvsp[(3) - (3)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (3)].memberlist);
        }
    break;

  case 202:
#line 3031 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 203:
#line 3034 "parser.ypp"
    {
           (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 204:
#line 3037 "parser.ypp"
    {
           (yyvsp[(1) - (2)].memberlist)->add((yyvsp[(2) - (2)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (2)].memberlist);
        }
    break;

  case 205:
#line 3041 "parser.ypp"
    {
           (yyvsp[(1) - (2)].memberlist)->add((yyvsp[(2) - (2)].memberinfo));
           (yyval.memberlist) = (yyvsp[(1) - (2)].memberlist);
        }
    break;

  case 206:
#line 3048 "parser.ypp"
    {
           (yyval.string) = (yyvsp[(1) - (2)].string);
        }
    break;

  case 207:
#line 3051 "parser.ypp"
    {
           (yyval.string) = strdup("keys");
        }
    break;

  case 208:
#line 3054 "parser.ypp"
    {
           (yyval.string) = (yyvsp[(1) - (1)].string);
        }
    break;

  case 209:
#line 3060 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (7)].i4), (yyloc), (yylsp[(2) - (7)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
                if ((yyvsp[(7) - (7)].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            check_method(loc, (yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), new_method_variant(loc, (yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].qv), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock)), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 210:
#line 3072 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (7)].i4), (yyloc), (yylsp[(2) - (7)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
                if ((yyvsp[(7) - (7)].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
            delete (yyvsp[(2) - (7)].parsertype);

            check_method(loc, (yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), new_method_variant(loc, (yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock)), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 211:
#line 3088 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (7)].i4), (yyloc), (yylsp[(2) - (7)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(6) - (7)]).last_line);
            if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            check_method(loc, (yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), new_method_variant(loc, (yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].qv), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), 0), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 212:
#line 3096 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (7)].i4), (yyloc), (yylsp[(2) - (7)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (7)].i4) ? (yylsp[(1) - (7)]).first_line : (yylsp[(2) - (7)]).first_line, (yylsp[(6) - (7)]).last_line);
            if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
            delete (yyvsp[(2) - (7)].parsertype);

            check_method(loc, (yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), new_method_variant(loc, (yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].bcalist), rt, 0), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 213:
#line 3111 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
                if ((yyvsp[(8) - (8)].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].qv), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(8) - (8)].sblock));
        }
    break;

  case 214:
#line 3122 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
                if ((yyvsp[(8) - (8)].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (8)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (8)].parsertype)));
            delete (yyvsp[(2) - (8)].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].qv), (yyvsp[(7) - (8)].bcalist), rt, (yyvsp[(8) - (8)].sblock));
        }
    break;

  case 215:
#line 3135 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(7) - (8)]).last_line);
            if (!((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].qv), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), 0);
        }
    break;

  case 216:
#line 3141 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(7) - (8)]).last_line);
            if (!((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (8)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (8)].parsertype)));
            delete (yyvsp[(2) - (8)].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].qv), (yyvsp[(7) - (8)].bcalist), rt, 0);
        }
    break;

  case 217:
#line 3150 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[(1) - (7)].string), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].qv), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 218:
#line 3154 "parser.ypp"
    {
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (7)].parsertype)));
            delete (yyvsp[(1) - (7)].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[(2) - (7)].string), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 219:
#line 3164 "parser.ypp"
    {
           (yyval.bcalist) = (yyvsp[(2) - (2)].bcalist);
        }
    break;

  case 220:
#line 3167 "parser.ypp"
    { // nothing
           (yyval.bcalist) = 0;
        }
    break;

  case 221:
#line 3173 "parser.ypp"
    {
           (yyval.bcalist) = new BCAList((yyvsp[(1) - (1)].bcanode));
        }
    break;

  case 222:
#line 3176 "parser.ypp"
    {
           (yyvsp[(1) - (3)].bcalist)->push_back((yyvsp[(3) - (3)].bcanode));
           (yyval.bcalist) = (yyvsp[(1) - (3)].bcalist);
        }
    break;

  case 223:
#line 3183 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.bcanode) = new BCANode((yyvsp[(1) - (4)].string), make_args(loc, (yyvsp[(3) - (4)].qv)), loc);
        }
    break;

  case 224:
#line 3187 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[(1) - (4)].string)), make_args(loc, (yyvsp[(3) - (4)].qv)), loc);
        }
    break;

  case 225:
#line 3195 "parser.ypp"
    { (yyval.i4) = 0; }
    break;

  case 226:
#line 3196 "parser.ypp"
    {
           (yyval.i4) = (yyvsp[(1) - (1)].i4);
        }
    break;

  case 227:
#line 3201 "parser.ypp"
    { (yyval.i4) = (yyvsp[(1) - (1)].i4); }
    break;

  case 228:
#line 3202 "parser.ypp"
    {
            if (((yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4)) == (yyvsp[(1) - (2)].i4)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
                parse_error(*loc, "modifier given twice");
            }
            (yyval.i4) = (yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4);
        }
    break;

  case 229:
#line 3212 "parser.ypp"
    { (yyval.i4) = OFM_PRIVATE; }
    break;

  case 230:
#line 3213 "parser.ypp"
    { (yyval.i4) = OFM_PRIVATE; }
    break;

  case 231:
#line 3214 "parser.ypp"
    { (yyval.i4) = OFM_INTERNAL; }
    break;

  case 232:
#line 3215 "parser.ypp"
    { (yyval.i4) = OFM_STATIC; }
    break;

  case 233:
#line 3216 "parser.ypp"
    { (yyval.i4) = OFM_SYNCED; }
    break;

  case 234:
#line 3217 "parser.ypp"
    { (yyval.i4) = OFM_DEPRECATED; }
    break;

  case 235:
#line 3218 "parser.ypp"
    { (yyval.i4) = OFM_PUBLIC; }
    break;

  case 236:
#line 3219 "parser.ypp"
    { (yyval.i4) = OFM_FINAL; }
    break;

  case 237:
#line 3220 "parser.ypp"
    { (yyval.i4) = OFM_ABSTRACT; }
    break;

  case 238:
#line 3224 "parser.ypp"
    {
            // see if the deprecated "returns" keyword can be used
            if (!parse_check_parse_option(PO_ALLOW_RETURNS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
                parse_error(*loc, "illegal use of the deprecated \"returns\" keyword (enable by setting parse option PO_ALLOW_RETURNS)");
            }

            if (!(yyvsp[(2) - (2)].parsertype)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
                parse_error(*loc, "missing type declaration after 'returns'");
                (yyval.returnTypeInfo) = 0;
            } else {
                (yyval.returnTypeInfo) = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (2)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (2)].parsertype)));
                delete (yyvsp[(2) - (2)].parsertype);
            }
        }
    break;

  case 239:
#line 3241 "parser.ypp"
    {
            (yyval.returnTypeInfo) = 0;
        }
    break;

  case 240:
#line 3247 "parser.ypp"
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(2) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].qv), (yyvsp[(5) - (6)].returnTypeInfo), false, flags));
        }
    break;

  case 241:
#line 3253 "parser.ypp"
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype)));
            delete (yyvsp[(1) - (6)].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(3) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].qv), rt, false, flags));
        }
    break;

  case 242:
#line 3263 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (7)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags));
            if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
    break;

  case 243:
#line 3275 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (7)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
            delete (yyvsp[(2) - (7)].parsertype);

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[(4) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].qv), rt, (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags));
            if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
    break;

  case 244:
#line 3293 "parser.ypp"
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(2) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].returnTypeInfo), false, flags));
        }
    break;

  case 245:
#line 3299 "parser.ypp"
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (7)].parsertype)));
            delete (yyvsp[(1) - (7)].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].qv), rt, false, flags));
        }
    break;

  case 246:
#line 3309 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (8)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(3) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].qv), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags));
            if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
    break;

  case 247:
#line 3321 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (8)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (8)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (8)].parsertype)));
            delete (yyvsp[(2) - (8)].parsertype);

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[(4) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(6) - (8)]).first_line, (yylsp[(6) - (8)]).last_line, (yyvsp[(6) - (8)].qv), rt, (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags));
            if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
    break;

  case 248:
#line 3339 "parser.ypp"
    {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv), loc1, loc3);
        }
    break;

  case 249:
#line 3344 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
            QoreParseListNode* l;
            if ((yyvsp[(1) - (2)].qv).getType() == NT_PARSE_LIST) {
                l = (yyvsp[(1) - (2)].qv).get<QoreParseListNode>();
                if (l->isFinalized()) {
                    QoreParseListNode* nl = new QoreParseListNode(loc);
                    nl->add(l, loc);
                    l = nl;
                }
            }
            else {
                l = new QoreParseListNode(loc);
                l->add((yyvsp[(1) - (2)].qv), loc);
            }
            (yyval.parse_list) = l;
        }
    break;

  case 250:
#line 3364 "parser.ypp"
    {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(1) - (3)]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv), loc1, loc3);
        }
    break;

  case 251:
#line 3369 "parser.ypp"
    {
            QoreParseListNode* l;
            if ((yyvsp[(1) - (2)].qv).getType() == NT_PARSE_LIST)
                l = (yyvsp[(1) - (2)].qv).get<QoreParseListNode>();
            else {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
                l = new QoreParseListNode(loc);
                l->add((yyvsp[(1) - (2)].qv), loc);
            }
            (yyval.parse_list) = l;
        }
    break;

  case 252:
#line 3383 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.hash) = new QoreParseHashNode(loc);
            (yyvsp[(1) - (1)].hashelement)->addDelete((yyval.hash));
        }
    break;

  case 253:
#line 3388 "parser.ypp"
    {
            (yyvsp[(3) - (3)].hashelement)->addDelete((yyvsp[(1) - (3)].hash));
            (yyval.hash) = (yyvsp[(1) - (3)].hash);
        }
    break;

  case 254:
#line 3393 "parser.ypp"
    { /* empty ',' on end of hash */ (yyval.hash) = (yyvsp[(1) - (2)].hash); }
    break;

  case 255:
#line 3398 "parser.ypp"
    { (yyval.hashelement) = new HashElement((yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv), (yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line); }
    break;

  case 256:
#line 3402 "parser.ypp"
    {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[(2) - (3)].hash)->setCurly();
            (yyvsp[(2) - (3)].hash)->finalizeBlock((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);

            (yyval.hash) = (yyvsp[(2) - (3)].hash);
        }
    break;

  case 257:
#line 3412 "parser.ypp"
    {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[(2) - (3)].hash)->setCurly();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[(1) - (3)].string));
            free((yyvsp[(1) - (3)].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), (yyvsp[(2) - (3)].hash));
        }
    break;

  case 258:
#line 3421 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[(1) - (2)].string));
            free((yyvsp[(1) - (2)].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), new QoreParseHashNode(loc, true));
        }
    break;

  case 259:
#line 3431 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].qv)); }
    break;

  case 260:
#line 3433 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].binary)); }
    break;

  case 261:
#line 3435 "parser.ypp"
    { (yyval.qv).set((yyvsp[(2) - (3)].hash)); }
    break;

  case 262:
#line 3437 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new ScopedRefNode(loc, (yyvsp[(1) - (1)].string)));
        }
    break;

  case 263:
#line 3441 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (2)].parsertype), (yyloc), (yylsp[(2) - (2)]));
            if (!(yyvsp[(1) - (2)].parsertype) && !strcmp((yyvsp[(2) - (2)].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (2)].parsertype) ? (yylsp[(1) - (2)]).first_line : (yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if ((yyvsp[(1) - (2)].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[(2) - (2)].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (2)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (2)].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[(2) - (2)].string), get_var_type()));

            delete (yyvsp[(1) - (2)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 264:
#line 3456 "parser.ypp"
    {
            fix_start_location((yyvsp[(1) - (2)].parsertype), (yyloc), (yylsp[(2) - (2)]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[(1) - (2)].parsertype) ? (yylsp[(1) - (2)]).first_line : (yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if ((yyvsp[(1) - (2)].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[(2) - (2)].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (2)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (2)].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[(2) - (2)].string), get_var_type()));

            delete (yyvsp[(1) - (2)].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 265:
#line 3468 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[(2) - (2)].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (2)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (2)].parsertype))));
            delete (yyvsp[(1) - (2)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 266:
#line 3475 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            VarRefDeclNode* v = new VarRefDeclNode(loc, (yyvsp[(3) - (3)].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (3)].parsertype)));
            v->setExplicitScope();
            (yyval.qv).set(v);
            delete (yyvsp[(2) - (3)].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(3) - (3)].string));
        }
    break;

  case 267:
#line 3484 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            // see if types are required
            if (parse_check_parse_option(PO_REQUIRE_TYPES))
                parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(2) - (2)].string));
            VarRefNode* v = new VarRefNode(loc, (yyvsp[(2) - (2)].string), VT_LOCAL);
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (2)].string));
        }
    break;

  case 268:
#line 3495 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            VarRefNode* v;
            if ((yyvsp[(2) - (3)].parsertype)) {
                v = new VarRefDeclNode(loc, (yyvsp[(3) - (3)].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[(2) - (3)].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (3)].parsertype)));
                delete (yyvsp[(2) - (3)].parsertype);
            } else {
                // see if types are required
                if (parse_check_parse_option(PO_REQUIRE_TYPES))
                    parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(3) - (3)].string));
                v = new VarRefNode(loc, (yyvsp[(3) - (3)].string), VT_LOCAL);
            }
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(3) - (3)].string));
        }
    break;

  case 269:
#line 3512 "parser.ypp"
    {
            (yyvsp[(3) - (4)].parse_list)->setVariableList();
            QoreParseListNode::nvec_t& vl = (yyvsp[(3) - (4)].parse_list)->getValues();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            for (unsigned i = 0; i < vl.size(); ++i) {
                QoreValue& n = vl[i];
                qore_type_t t = n.getType();
                if (t == NT_BAREWORD) {
                    BarewordNode* b = n.get<BarewordNode>();
                    if (parse_check_parse_option(PO_REQUIRE_TYPES))
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
                    if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                        parse_error(*loc, "local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
                    VarRefNode* v = new VarRefNode(loc, b->takeString(), VT_LOCAL);
                    v->setExplicitScope();
                    b->deref();
                    n = v;
                } else if (t == NT_VARREF) {
                    VarRefNode* v = n.get<VarRefNode>();
                    // see if types are required
                    if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
                    if (v->explicitScope()) {
                        if (v->getType() == VT_LOCAL)
                            parse_error(*loc, "illegal use of 'my %s' in local variable declaration list", v->getName());
                        else if (v->getType() == VT_GLOBAL)
                            parse_error(*loc, "illegal use of 'our %s' in local variable declaration list", v->getName());
                    } else
                        v->makeLocal();
                    v->setExplicitScope();
                } else
                    parse_error(*loc, "element %d in list following 'my' is not a variable reference (%s)", i, n.getTypeName());
            }
            (yyval.qv).set((yyvsp[(3) - (4)].parse_list));
        }
    break;

  case 270:
#line 3547 "parser.ypp"
    {
            (yyval.qv).set((yyvsp[(1) - (1)].gv)->makeVar());
        }
    break;

  case 271:
#line 3551 "parser.ypp"
    {
            if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[(1) - (1)].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new BarewordNode(loc, (yyvsp[(1) - (1)].string)));
        }
    break;

  case 272:
#line 3559 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new ContextrefNode(loc, (yyvsp[(1) - (1)].string)));
        }
    break;

  case 273:
#line 3564 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new ContextRowNode(loc));
        }
    break;

  case 274:
#line 3569 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new ComplexContextrefNode(loc, (yyvsp[(1) - (1)].string)));
        }
    break;

  case 275:
#line 3574 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (8)]).first_line, (yylsp[(8) - (8)]).last_line);
            (yyval.qv).set(new FindNode(loc, (yyvsp[(2) - (8)].qv), (yyvsp[(4) - (8)].qv), (yyvsp[(7) - (8)].qv)));
        }
    break;

  case 276:
#line 3579 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreExistsOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 277:
#line 3584 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreElementsOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 278:
#line 3588 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreKeysOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 279:
#line 3592 "parser.ypp"
    {  // unshift list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreUnshiftOperatorNode(loc, lv, l->shift()));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 280:
#line 3606 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreShiftOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 281:
#line 3610 "parser.ypp"
    {  // push lvalue-list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QorePushOperatorNode(loc, lv, l->shift()));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 282:
#line 3624 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QorePopOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 283:
#line 3628 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreChompOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 284:
#line 3632 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreTrimOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 285:
#line 3636 "parser.ypp"
    {  // splice lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreSpliceOperatorNode(loc, lv, l->shift(), l->shift(), l->shift()));
                discard(l, 0);
            }
        }
    break;

  case 286:
#line 3660 "parser.ypp"
    {  // extract lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreExtractOperatorNode(loc, lv, l->shift(), l->shift(), l->shift()));
                discard(l, 0);
            }
        }
    break;

  case 287:
#line 3684 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            int len = l ? (int)l->size() : 0;
            if (!l || len < 2 || len > 3) {
                parse_error(*loc, "invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else {
                // get first expression from list
                QoreValue exp = l->shift();
                qore_type_t t = exp.getType();
                (yyval.qv).set(nullptr);
                bool is_curly = false;
                if (t == NT_PARSE_HASH) {
                    QoreParseHashNode* phn = exp.get<QoreParseHashNode>();
                    if (phn->isCurly()) {
                        is_curly = true;
                        (yyval.qv).set(parse_hash_map(loc, phn, l));
                    }
                }

                if (!(yyval.qv) && !is_curly) {
                    (yyval.qv).set(parse_map(loc, exp, l));
                }
            }
        }
    break;

  case 288:
#line 3712 "parser.ypp"
    {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldrOperatorNode(loc, code_exp, arg));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 289:
#line 3728 "parser.ypp"
    {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldlOperatorNode(loc, code_exp, arg));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 290:
#line 3744 "parser.ypp"
    {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[(2) - (2)].qv).getType() == NT_PARSE_LIST ? (yyvsp[(2) - (2)].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", (yyvsp[(2) - (2)].qv).getTypeName());
                (yyvsp[(2) - (2)].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue arg = l->shift();
                QoreValue select_exp = l->shift();
                (yyval.qv).set(new QoreSelectOperatorNode(loc, arg, select_exp));
                (yyvsp[(2) - (2)].qv).discard(nullptr);
            }
        }
    break;

  case 291:
#line 3760 "parser.ypp"
    {  // pre-increment
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QorePreIncrementOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 292:
#line 3764 "parser.ypp"
    {  // pre-decrement
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QorePreDecrementOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 293:
#line 3768 "parser.ypp"
    {
            printd(5, "parsing in-object base class method call %s()\n", (yyvsp[(1) - (4)].nscope)->ostr);
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            if (!strcmp((yyvsp[(1) - (4)].nscope)->getIdentifier(), "copy"))
                parse_error(*loc, "illegal call to base class copy method '%s'", (yyvsp[(1) - (4)].nscope)->ostr);

            (yyval.qv).set(new SelfFunctionCallNode(loc, (yyvsp[(1) - (4)].nscope), make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(3) - (4)].qv))));
        }
    break;

  case 294:
#line 3776 "parser.ypp"
    {
            printd(5, "parsing call %s()\n", (yyvsp[(1) - (3)].string));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line);
            (yyval.qv).set(new FunctionCallNode(loc, (yyvsp[(1) - (3)].string), make_args(argsloc, (yyvsp[(2) - (3)].qv))));
        }
    break;

  case 295:
#line 3783 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new SelfVarrefNode(loc, (yyvsp[(1) - (1)].string)));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
        }
    break;

  case 296:
#line 3789 "parser.ypp"
    {
            // FIXME: need to expand constant expression checking to determine
            //        if the expression can throw an exception at run-time
            // first check for constant expressions
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreUnaryMinusOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 297:
#line 3797 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreUnaryPlusOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 298:
#line 3801 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreBinaryNotOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 299:
#line 3805 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreLogicalNotOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 300:
#line 3809 "parser.ypp"
    {
            qore_type_t t = (yyvsp[(2) - (2)].qv).getType();
            //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2.getTypeName());

            if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
                (yyval.qv).set((yyvsp[(2) - (2)].qv).get<FunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_SELF_CALL) {
                (yyval.qv).set((yyvsp[(2) - (2)].qv).get<SelfFunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_STATIC_METHOD_CALL) {
                (yyval.qv).set((yyvsp[(2) - (2)].qv).get<StaticMethodCallNode>()->makeReferenceNodeAndDeref());
            }
            else {
                bool make_ref = true;

                if (t == NT_OPERATOR) {
                    QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[(2) - (2)].qv).getInternalNode());
                    if (deon) {
                        (yyval.qv).set(deon->makeCallReference());
                        make_ref = false;
                    }
                }

                if (make_ref) {
                    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
                    //printd(5, "type=%s\n", $2.getTypeName());
                    (yyval.qv).set(new ParseReferenceNode(loc, (yyvsp[(2) - (2)].qv)));
                }
            }
        }
    break;

  case 301:
#line 3840 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[(2) - (5)].string)), make_args(argsloc, (yyvsp[(4) - (5)].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
    break;

  case 302:
#line 3847 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[(2) - (5)].string)), make_args(argsloc, (yyvsp[(4) - (5)].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
    break;

  case 303:
#line 3854 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[(4) - (5)]).first_line, (yylsp[(4) - (5)]).last_line);
            (yyval.qv).set(new ParseNewComplexTypeNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[(2) - (5)].string), false), make_args(argsloc, (yyvsp[(4) - (5)].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
    break;

  case 304:
#line 3861 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreBackgroundOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
            // check to see if the expression is legal
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
                parse_error(*loc, "illegal use of 'background' operator (conflicts with parse option PO_NO_THREAD_CONTROL)");
            else if (!value_has_effect_as_root((yyvsp[(2) - (2)].qv))) {
                if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                    parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[(2) - (2)].qv).getTypeName());
                }
            } else if (!(yyvsp[(2) - (2)].qv).hasEffect()) {
                parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[(2) - (2)].qv).getTypeName());
            }
        }
    break;

  case 305:
#line 3875 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new BackquoteNode(loc, (yyvsp[(1) - (1)].string)));
            if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
                parse_error(*loc, "illegal use of backquote operator (conflicts with parse option PO_NO_EXTERNAL_PROCESS)");
        }
    break;

  case 306:
#line 3881 "parser.ypp"
    {
            (yyval.qv).set((yyvsp[(2) - (3)].qv));
            switch ((yyvsp[(2) - (3)].qv).getType()) {
                case NT_PARSE_LIST:
                    (yyvsp[(2) - (3)].qv).get<QoreParseListNode>()->setFinalized();
                    break;
                case NT_FUNCTION_CALL:
                    (yyvsp[(2) - (3)].qv).get<FunctionCallNode>()->setFinalized();
                    break;
                case NT_BAREWORD:
                    (yyvsp[(2) - (3)].qv).get<BarewordNode>()->setFinalized();
                    break;
                case NT_OPERATOR:
                    (yyvsp[(2) - (3)].qv).get<QoreOperatorNode>()->setInParentheses();
                    break;
            }
        }
    break;

  case 307:
#line 3898 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            QoreParseListNode* l = new QoreParseListNode(loc);
            l->setFinalized();
            (yyval.qv).set(l);
        }
    break;

  case 308:
#line 3904 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].qv), (yyvsp[(5) - (6)].returnTypeInfo), false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
    break;

  case 309:
#line 3909 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (6)]).first_line, (yylsp[(6) - (6)]).last_line);
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(1) - (6)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(1) - (6)].parsertype)));
            delete (yyvsp[(1) - (6)].parsertype);

            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].qv), rt, false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
    break;

  case 310:
#line 3917 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (7)].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].qv), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags)));
        }
    break;

  case 311:
#line 3926 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line);
            check_funcmod(loc, (yyvsp[(1) - (7)].i4));

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[(2) - (7)].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[(2) - (7)].parsertype)));
            delete (yyvsp[(2) - (7)].parsertype);

            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].qv), rt, (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags)));
        }
    break;

  case 312:
#line 3939 "parser.ypp"
    {
            (yyval.qv).set((yyvsp[(1) - (1)].implicit_arg));
            inc_numeric_argv_ref();
        }
    break;

  case 313:
#line 3943 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
            (yyval.qv).set(new QoreImplicitElementNode(loc));
        }
    break;

  case 314:
#line 3947 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreDeleteOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 315:
#line 3951 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line);
            (yyval.qv).set(new QoreRemoveOperatorNode(loc, (yyvsp[(2) - (2)].qv)));
        }
    break;

  case 316:
#line 3955 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.qv).set(new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[(1) - (4)].string), false), (yyvsp[(3) - (4)].qv)));
        }
    break;

  case 317:
#line 3959 "parser.ypp"
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
            (yyval.qv).set(new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[(1) - (4)].string), true), (yyvsp[(3) - (4)].qv)));
        }
    break;

  case 318:
#line 3966 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].qv)); }
    break;

  case 319:
#line 3967 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].parse_list)); }
    break;

  case 320:
#line 3968 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].hash)); }
    break;

  case 321:
#line 3969 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].node)); }
    break;

  case 322:
#line 3970 "parser.ypp"
    { (yyval.qv).set(new QoreParseHashNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), true)); }
    break;

  case 323:
#line 3971 "parser.ypp"
    { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 324:
#line 3972 "parser.ypp"
    { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 325:
#line 3973 "parser.ypp"
    { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 326:
#line 3974 "parser.ypp"
    { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 327:
#line 3975 "parser.ypp"
    { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 328:
#line 3976 "parser.ypp"
    { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 329:
#line 3977 "parser.ypp"
    { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 330:
#line 3978 "parser.ypp"
    { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 331:
#line 3979 "parser.ypp"
    { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 332:
#line 3980 "parser.ypp"
    { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 333:
#line 3981 "parser.ypp"
    {
        (yyval.qv).set(process_assignment((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 334:
#line 3984 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 335:
#line 3992 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        (yyval.qv).set((yyvsp[(3) - (3)].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].parsertype)->getParseTypeInfo()));
        delete (yyvsp[(3) - (3)].parsertype);
    }
    break;

  case 336:
#line 3999 "parser.ypp"
    { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 337:
#line 4000 "parser.ypp"
    { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 338:
#line 4001 "parser.ypp"
    { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].qv))); }
    break;

  case 339:
#line 4002 "parser.ypp"
    { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv))); }
    break;

  case 340:
#line 4003 "parser.ypp"
    { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv))); }
    break;

  case 341:
#line 4004 "parser.ypp"
    { (yyval.qv).set(processCall((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line, (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line))); }
    break;

  case 342:
#line 4005 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_log_or(loc, (yyvsp[(1) - (3)].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 343:
#line 4010 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 344:
#line 4011 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 345:
#line 4012 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 346:
#line 4013 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_bin_or(loc, (yyvsp[(1) - (3)].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 347:
#line 4018 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 348:
#line 4019 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_bin_or(loc, (yyvsp[(1) - (3)].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[(1) - (3)].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 349:
#line 4025 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 350:
#line 4026 "parser.ypp"
    { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 351:
#line 4027 "parser.ypp"
    { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 352:
#line 4028 "parser.ypp"
    { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].RegexSubst))); }
    break;

  case 353:
#line 4029 "parser.ypp"
    { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Trans))); }
    break;

  case 354:
#line 4030 "parser.ypp"
    { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 355:
#line 4031 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 356:
#line 4032 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 357:
#line 4033 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 358:
#line 4034 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 359:
#line 4035 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 360:
#line 4036 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 361:
#line 4037 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 362:
#line 4038 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 363:
#line 4039 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 364:
#line 4040 "parser.ypp"
    { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 365:
#line 4041 "parser.ypp"
    { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 366:
#line 4042 "parser.ypp"
    { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 367:
#line 4043 "parser.ypp"
    { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 368:
#line 4044 "parser.ypp"
    { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 369:
#line 4045 "parser.ypp"
    { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 370:
#line 4046 "parser.ypp"
    { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 371:
#line 4047 "parser.ypp"
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), (yyvsp[(3) - (5)].qv), QoreValue())); }
    break;

  case 372:
#line 4048 "parser.ypp"
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), QoreValue(), (yyvsp[(4) - (5)].qv))); }
    break;

  case 373:
#line 4049 "parser.ypp"
    {
        parse_error(*qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(1) - (4)].qv), QoreValue(), QoreValue()));
    }
    break;

  case 374:
#line 4053 "parser.ypp"
    {
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[(3) - (4)].qv).getType() == NT_OPERATOR) {
            QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[(3) - (4)].qv).getInternalNode());
            if (ron) {
                std::unique_ptr<QoreRangeOperatorNode> holder(ron);
                (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line), (yyvsp[(1) - (4)].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
            }
        }
        if (!(yyval.qv)) {
            (yyval.qv).set(new QoreSquareBracketsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv)));
        }
    }
    break;

  case 375:
#line 4067 "parser.ypp"
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv))); }
    break;

  case 376:
#line 4068 "parser.ypp"
    { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 377:
#line 4069 "parser.ypp"
    { (yyval.qv).set(process_dot((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 378:
#line 4070 "parser.ypp"
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv), (yyvsp[(2) - (2)].String))); }
    break;

  case 379:
#line 4074 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].qv)); }
    break;

  case 380:
#line 4075 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].parse_list)); }
    break;

  case 381:
#line 4076 "parser.ypp"
    { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 382:
#line 4077 "parser.ypp"
    { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 383:
#line 4078 "parser.ypp"
    { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 384:
#line 4079 "parser.ypp"
    { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 385:
#line 4080 "parser.ypp"
    { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 386:
#line 4081 "parser.ypp"
    { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 387:
#line 4082 "parser.ypp"
    { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 388:
#line 4083 "parser.ypp"
    { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 389:
#line 4084 "parser.ypp"
    { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 390:
#line 4085 "parser.ypp"
    { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 391:
#line 4086 "parser.ypp"
    {
        (yyval.qv).set(process_assignment((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 392:
#line 4089 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 393:
#line 4097 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        (yyval.qv).set((yyvsp[(3) - (3)].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].parsertype)->getParseTypeInfo()));
        delete (yyvsp[(3) - (3)].parsertype);
    }
    break;

  case 394:
#line 4104 "parser.ypp"
    { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 395:
#line 4105 "parser.ypp"
    { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 396:
#line 4106 "parser.ypp"
    { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), (yyvsp[(3) - (5)].qv), (yyvsp[(5) - (5)].qv))); }
    break;

  case 397:
#line 4107 "parser.ypp"
    { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv))); }
    break;

  case 398:
#line 4108 "parser.ypp"
    { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv))); }
    break;

  case 399:
#line 4109 "parser.ypp"
    { (yyval.qv).set(processCall((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line, (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[(3) - (4)]).first_line, (yylsp[(3) - (4)]).last_line))); }
    break;

  case 400:
#line 4110 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_log_or(loc, (yyvsp[(1) - (3)].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 401:
#line 4115 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 402:
#line 4116 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 403:
#line 4117 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 404:
#line 4118 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_bin_or(loc, (yyvsp[(1) - (3)].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 405:
#line 4123 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 406:
#line 4124 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line);
        check_operator_bin_or(loc, (yyvsp[(1) - (3)].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[(1) - (3)].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv)));
    }
    break;

  case 407:
#line 4130 "parser.ypp"
    { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 408:
#line 4131 "parser.ypp"
    { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 409:
#line 4132 "parser.ypp"
    { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 410:
#line 4133 "parser.ypp"
    { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].RegexSubst))); }
    break;

  case 411:
#line 4134 "parser.ypp"
    { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Trans))); }
    break;

  case 412:
#line 4135 "parser.ypp"
    { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].Regex))); }
    break;

  case 413:
#line 4136 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 414:
#line 4137 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 415:
#line 4138 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 416:
#line 4139 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 417:
#line 4140 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 418:
#line 4141 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 419:
#line 4142 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 420:
#line 4143 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 421:
#line 4144 "parser.ypp"
    { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 422:
#line 4145 "parser.ypp"
    { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 423:
#line 4146 "parser.ypp"
    { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 424:
#line 4147 "parser.ypp"
    { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 425:
#line 4148 "parser.ypp"
    { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 426:
#line 4149 "parser.ypp"
    { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 427:
#line 4150 "parser.ypp"
    { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 428:
#line 4151 "parser.ypp"
    { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 429:
#line 4152 "parser.ypp"
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), (yyvsp[(3) - (5)].qv), QoreValue())); }
    break;

  case 430:
#line 4153 "parser.ypp"
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line), (yyvsp[(1) - (5)].qv), QoreValue(), (yyvsp[(4) - (5)].qv))); }
    break;

  case 431:
#line 4154 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
        parse_error(*loc, "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[(1) - (4)].qv), QoreValue(), QoreValue()));
    }
    break;

  case 432:
#line 4159 "parser.ypp"
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(4) - (4)]).last_line);
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[(3) - (4)].qv).getType() == NT_OPERATOR) {
            QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[(3) - (4)].qv).getInternalNode());
            if (ron) {
                std::unique_ptr<QoreRangeOperatorNode> holder(ron);
                (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[(1) - (4)].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
            }
        }
        if (!(yyval.qv)) {
            (yyval.qv).set(new QoreSquareBracketsOperatorNode(loc, (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv)));
        }
    }
    break;

  case 433:
#line 4174 "parser.ypp"
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (4)]).first_line, (yylsp[(3) - (4)]).last_line), (yyvsp[(1) - (4)].qv), (yyvsp[(3) - (4)].qv))); }
    break;

  case 434:
#line 4175 "parser.ypp"
    { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line), (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 435:
#line 4176 "parser.ypp"
    { (yyval.qv).set(process_dot((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(1) - (3)].qv), (yyvsp[(3) - (3)].qv))); }
    break;

  case 436:
#line 4177 "parser.ypp"
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line), (yyvsp[(1) - (2)].qv), (yyvsp[(2) - (2)].String))); }
    break;

  case 437:
#line 4181 "parser.ypp"
    {
           (yyval.String) = (yyvsp[(1) - (1)].String);
        }
    break;

  case 438:
#line 4184 "parser.ypp"
    {
            (yyval.String) = (yyvsp[(1) - (2)].String);
            (yyval.String)->concat((yyvsp[(2) - (2)].String));
            (yyvsp[(2) - (2)].String)->deref();
        }
    break;

  case 439:
#line 4192 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].decimal)); }
    break;

  case 440:
#line 4193 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].integer)); }
    break;

  case 441:
#line 4194 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].String)); }
    break;

  case 442:
#line 4195 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].datetime)); }
    break;

  case 443:
#line 4196 "parser.ypp"
    { (yyval.qv).set((yyvsp[(1) - (1)].num)); }
    break;

  case 444:
#line 4197 "parser.ypp"
    { (yyval.qv).set(nullptr); }
    break;

  case 445:
#line 4198 "parser.ypp"
    { (yyval.qv).set(&Null); }
    break;

  case 446:
#line 4199 "parser.ypp"
    { (yyval.qv).set(true); }
    break;

  case 447:
#line 4200 "parser.ypp"
    { (yyval.qv).set(false); }
    break;


/* Line 1267 of yacc.c.  */
#line 10995 "parser.cpp"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (&yylloc, yyscanner, yymsg);
	  }
	else
	  {
	    yyerror (&yylloc, yyscanner, YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, &yylloc, yyscanner);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the look-ahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, (yyerror_range - 1), 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, &yylloc, yyscanner);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 4203 "parser.ypp"


