/* A Bison parser, made by GNU Bison 3.5.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2019 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "parser.ypp"
 /* -*- mode: c++; indent-tabs-mode: nil -*-

    parser.ypp

    Qore Programming Language

    Copyright (C) 2003 - 2020 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

    Note that the Qore library is released under a choice of three open-source
    licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
    information.
*/

#include "qore/Qore.h"
#include "qore/intern/BreakStatement.h"
#include "qore/intern/ContinueStatement.h"
#include "qore/intern/ReturnStatement.h"
#include "qore/intern/RethrowStatement.h"
#include "qore/intern/ThreadExitStatement.h"
#include "qore/intern/ExpressionStatement.h"
#include "qore/intern/DoWhileStatement.h"
#include "qore/intern/SummarizeStatement.h"
#include "qore/intern/ContextStatement.h"
#include "qore/intern/IfStatement.h"
#include "qore/intern/WhileStatement.h"
#include "qore/intern/ForStatement.h"
#include "qore/intern/ForEachStatement.h"
#include "qore/intern/TryStatement.h"
#include "qore/intern/ThrowStatement.h"
#include "qore/intern/StatementBlock.h"
#include "qore/intern/ParserSupport.h"
#include "qore/intern/SwitchStatement.h"
#include "qore/intern/CaseNodeWithOperator.h"
#include "qore/intern/CaseNodeRegex.h"
#include "qore/intern/OnBlockExitStatement.h"
#include "qore/intern/ConstantList.h"
#include "qore/intern/GlobalVariableList.h"
#include "qore/intern/QoreNamespaceIntern.h"
#include "qore/intern/QoreParseHashNode.h"
#include "qore/intern/QoreParseListNode.h"
#include "qore/intern/ModuleInfo.h"

#include "parser.hpp"

#include "qore/intern/QoreClassIntern.h"
#include "qore/intern/qore_program_private.h"
#include "qore/intern/typed_hash_decl_private.h"
#include "qore/intern/qore_list_private.h"

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <memory>
#include <sstream>
#include <utility>
#include <vector>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                      \
   do                                                        \
      if (N) {                                               \
         (Current).first_line = YYRHSLOC(Rhs, 1).first_line; \
         (Current).first_col  = YYRHSLOC(Rhs, 1).first_col;  \
         (Current).last_line  = YYRHSLOC(Rhs, N).last_line;  \
         (Current).last_col   = YYRHSLOC(Rhs, N).last_col;   \
      }                                                      \
      else {                                                 \
         (Current).first_line = (Current).last_line =        \
            YYRHSLOC(Rhs, 0).last_line;                      \
         (Current).first_col = (Current).last_col =          \
            YYRHSLOC(Rhs, 0).last_col;                       \
      }                                                      \
   while (0)

class HashElement {
public:
    QoreValue key;
    QoreValue value;
    const QoreProgramLocation* loc;

    DLLLOCAL HashElement(QoreValue k, QoreValue v, int sl, int el) : key(k), value(v), loc(qore_program_private::get(*getProgram())->getLocation(sl, el)) {
        //traceout("HashElement::HashElement()");
    }

    DLLLOCAL ~HashElement() {
        key.discard(nullptr);
        value.discard(nullptr);
    }

    DLLLOCAL void addDelete(QoreParseHashNode* h) {
        h->add(key, value, loc);
        key.clear();
        value.clear();
        delete this;
    }
};

// for constant definitions
class ConstNode {
public:
    const QoreProgramLocation* loc;
    NamedScope name;
    QoreValue value;
    bool pub;

    DLLLOCAL ConstNode(const QoreProgramLocation* loc, char* n, QoreValue v, bool p = false) : loc(loc), name(n), value(v), pub(p) {
        // see if constant definitions are allowed
        if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
            parse_error(*loc, "illegal constant definition \"%s\" (conflicts with parse option PO_NO_CONSTANT_DEFS)", n);
    }
    DLLLOCAL QoreValue takeValue() {
        QoreValue rv = value;
        value.clear();
        return rv;
    }
    DLLLOCAL const char* getName() const {
        return name.getIdentifier();
    }
    DLLLOCAL bool isPublic() const {
        return pub;
    }
};

class ObjClassDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    QoreClass* oc;

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, NamedScope *n, QoreClass* o) : loc(loc), name(n), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, char* n, QoreClass* o) : loc(loc), name(new NamedScope(n)), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ~ObjClassDef() {
        delete name;
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a class may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your class");
    }
};

class HashDeclDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    TypedHashDecl* hashdecl;

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, NamedScope *n, typed_hash_decl_private* hp) :
            loc(loc), name(n), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, char* n, typed_hash_decl_private* hp) :
            loc(loc), name(new NamedScope(n)), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL ~HashDeclDef() {
        delete name;
        if (hashdecl)
            typed_hash_decl_private::get(*hashdecl)->deref();
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a hashdecl may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your hashdecl");
    }

    DLLLOCAL TypedHashDecl* takeHashDecl() {
        TypedHashDecl* rv = hashdecl;
        hashdecl = nullptr;
        return rv;
    }
};

class ParseUserFunctionBase {
public:
    const QoreProgramLocation* loc;
    UserFunctionVariant* variant;

    DLLLOCAL ParseUserFunctionBase(const QoreProgramLocation* loc, UserFunctionVariant* v) : loc(loc), variant(v) {
    }

    DLLLOCAL ~ParseUserFunctionBase() {
        if (variant)
            variant->deref();
    }

    DLLLOCAL void setPublic() {
        variant->setModulePublic();
    }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
    char* name;

    DLLLOCAL ParseUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL ~ParseUserFunction() {
        if (name)
            free(name);
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
            const char* nsn = ns.name.c_str();
            parse_error(*loc, "function '%s%s%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
        }

        delete this;
    }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
    NamedScope name;

    DLLLOCAL ParseScopedUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
            parse_error(*loc, "function '%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", name.ostr);

        delete this;
    }
};

struct GVarDecl {
    const QoreProgramLocation* loc;
    bool pub;

    DLLLOCAL GVarDecl(const QoreProgramLocation* loc, bool p) : loc(loc), pub(p) {
    }

    DLLLOCAL virtual ~GVarDecl() {
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

    DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
    char* name;
    const QoreTypeInfo* typeInfo;
    QoreParseTypeInfo* parseTypeInfo;

    DLLLOCAL GVarSingleDecl(const QoreProgramLocation* loc, char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti, bool p, bool bare) : GVarDecl(loc, p), name(n), typeInfo(ti), parseTypeInfo(pti) {
        //printd(5, "GVarSingleDecl::GVarSingleDecl() '%s' %d-%d\n", n, loc.start_line, loc.end_line);
        if (bare) {
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "global variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", n);
        } else {
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", n);
        }
        if (qore_program_private::get(*getProgram())->expression_mode) {
            parse_error(*loc, "global variable declaration '%s' not allowed in expressions' is set", n);
        }
    }

    DLLLOCAL virtual ~GVarSingleDecl() {
        if (name)
            free(name);

        delete parseTypeInfo;
    }

    DLLLOCAL char* takeName() {
        char* rv = name;
        name = 0;
        return rv;
    }

    DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        ns.parseAddGlobalVarDecl(loc, takeName(), typeInfo, takeParseTypeInfo(), pub);
        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        GlobalVarRefNode* gv = typeInfo
            ? new GlobalVarRefNode(loc, takeName(), typeInfo)
            : new GlobalVarRefNode(loc, takeName(), takeParseTypeInfo());
        if (pub)
            gv->setPublic();

        delete this;
        return gv;
    }
};

struct GVarListDecl : public GVarDecl {
    QoreParseListNode* l;

    DLLLOCAL GVarListDecl(const QoreProgramLocation* loc, QoreParseListNode* list, bool p) : GVarDecl(loc, p), l(list) {
        bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                if (!bareok)
                    parse_error(*loc, "global variable '%s' in global variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
            }
            else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (vrn->explicitScope()) {
                    if (vrn->getType() == VT_LOCAL)
                        parse_error(*loc, "illegal use of 'my %s' in global variable declaration list", vrn->getName());
                    else if (vrn->getType() == VT_GLOBAL)
                        parse_error(*loc, "illegal use of 'our %s' in global variable declaration list", vrn->getName());
                }
            }
            else
                parse_error(*loc, "element %d in list following 'our' is not a variable reference (%s)", i, n.getTypeName());
        }
    }

    DLLLOCAL virtual ~GVarListDecl() {
        if (l) {
            l->deref(nullptr);
        }
    }

    DLLLOCAL QoreParseListNode* takeList() {
        QoreParseListNode* rv = l;
        l = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                ns.parseAddGlobalVarDecl(loc, b->takeString(), 0, 0, pub);
            }
            else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
                    if (vrdn)
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), vrdn->getTypeInfo(), vrdn->takeParseTypeInfo(), pub);
                    else
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), 0, 0, pub);
                }
            }
        }

        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        l->setVariableList();
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue& n = vl[i];
            qore_type_t t = n.getType();
            VarRefNode* vrn = nullptr;
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                GlobalVarRefNode* v = new GlobalVarRefNode(loc, b->takeString());
                b->deref();
                n = vrn = v;
            }
            else if (t == NT_VARREF) {
                vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    vrn->makeGlobal();
                    vrn->setExplicitScope();
                }
            }

            if (vrn && pub)
                vrn->setPublic();
        }

        QoreParseListNode* rv = takeList();
        delete this;
        return rv;
    }
};

static int check_method(const QoreProgramLocation* loc, const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error(*loc, "%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error(*loc, "base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PUBLIC     (1 << 0)
#define OFM_PRIVATE    (1 << 1)
#define OFM_INTERNAL   (1 << 2)
#define OFM_SYNCED     (1 << 3)
#define OFM_STATIC     (1 << 4)
#define OFM_DEPRECATED (1 << 5)
#define OFM_FINAL      (1 << 6)
#define OFM_ABSTRACT   (1 << 7)

static inline MethodVariantBase* new_method_variant(const QoreProgramLocation* loc, const char* name, int mod, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) {
    //printd(5, "new_method_variant() '%s' b: %p\n", name, b);

    int64 flags = QCF_NO_FLAGS;

    if (get_pop_argv_ref())
        flags |= QCF_USES_EXTRA_ARGS;

    ClassAccess access = Public;
    if (mod & OFM_PRIVATE) {
        if (mod & OFM_INTERNAL)
            parse_error(*loc, "%s() methods cannot be both private:hierarchy and private:internal", name);
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Private;
    }
    else if (mod & OFM_INTERNAL) {
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Internal;
    }

    if (mod & OFM_DEPRECATED)
        flags |= QCF_DEPRECATED;

    if (!strcmp(name, "constructor")) {
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        return new UserConstructorVariant(access, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
    }
    if (bcal) {
        parse_error(*loc, "only constructors may have base class constructor arguments");
        delete bcal;
        bcal = 0;
    }
    if (!strcmp(name, "destructor")) {
        if (params) {
            parse_error(*loc, "parameters cannot be defined for destructors");
            params.discard(nullptr);
        }
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        if (access > Public)
            parse_error(*loc, "destructors cannot be private");
        return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
    }
    if (!strcmp(name, "copy")) {
        if (mod & OFM_FINAL) {
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        }
        if (mod & OFM_ABSTRACT) {
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        }
        return new UserCopyVariant(access, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
    }

    if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; they are not inherited anyway", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract; they are not inherited anyway", name);
    }

    if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
        parse_error(*loc, "method '%s()' is declared both final and abstract", name);

    return new UserMethodVariant(access, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
    const QoreProgramLocation* loc;
    MethodVariantBase* m;
    NamedScope name;
    bool static_flag;

    DLLLOCAL MethodDef(const QoreProgramLocation* loc, int mod, char* n, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : loc(loc), m(0), name(n), static_flag(mod & OFM_STATIC) {
        if (check_method(loc, name.getIdentifier(), bcal, returnTypeInfo)) {
            params.discard(nullptr);
            delete bcal;
            delete b;
            delete returnTypeInfo;
            return;
        }

        m = new_method_variant(loc, name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b);
    }

    DLLLOCAL ~MethodDef() {
        delete m;
    }

    DLLLOCAL void parseAddToClassAndDel() {
        if (m) {
            // if there are any errors, the function below will delete memory
            // the following method takes ownership of "m" unconditionally
            qore_root_ns_private::parseAddMethodToClass(loc, name, m, static_flag);
            m = 0;
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        // the following method takes ownership of "m" unconditionally
        ns.parseAddMethodToClass(loc, name, m, static_flag);
        m = 0;
    }
};

static QoreValue parse_hash_map(const QoreProgramLocation* loc, QoreParseHashNode* exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> exph(exp, nullptr);
    ReferenceHolder<> lh(l, nullptr);

    // check hash expression
    size_t len = exp->size();

    if (len == 0) {
        qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_INVALID_OPERATION, "INVALID-OPERATION",
                "empty hash as an argument to the hash map operator, this expression will always evaluate to an empty hash");
        return new QoreHashNode(autoTypeInfo);
    }

    if (len != 1) {
        parse_error(*loc, "invalid initial argument to hash map operator, expected a single key value pair; got %d hash elements instead", len);
        return QoreValue();
    }

    if (l->size() == 1) {
        QoreValue iter = l->shift();
        return new QoreHashMapOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter);
    }

    QoreValue iter = l->shift();
    QoreValue select = l->shift();
    return new QoreHashMapSelectOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter, select);
}

static AbstractQoreNode* parse_map(const QoreProgramLocation* loc, QoreValue exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> lh(l, 0);

    if (l->size() == 1) {
        QoreValue arg = l->shift();
        return new QoreMapOperatorNode(loc, exp, arg);
    }

    QoreValue iterator_exp = l->shift();
    QoreValue select_exp = l->shift();
    return new QoreMapSelectOperatorNode(loc, exp, iterator_exp, select_exp);
}

#define NSN_NONE     0
#define NSN_OCD      1
#define NSN_HASHDECL 2
#define NSN_CONST    3
#define NSN_NS       4
#define NSN_FUNC     5
#define NSN_SFUNC    6
#define NSN_VAR      7
#define NSN_METH     8

struct NSNode {
    int type;
    union {
        ObjClassDef* ocd;
        HashDeclDef* hashdecl;
        ConstNode* cn;
        QoreNamespace* ns;
        ParseUserFunction* func;
        ParseScopedUserFunction* sfunc;
        GVarDecl* gv;
        MethodDef* meth;
    } n;

    DLLLOCAL NSNode(ObjClassDef* o) { type = NSN_OCD; n.ocd = o; }
    DLLLOCAL NSNode(HashDeclDef* h) { type = NSN_HASHDECL; n.hashdecl = h; }
    DLLLOCAL NSNode(ConstNode* c) { type = NSN_CONST; n.cn = c; }
    DLLLOCAL NSNode(QoreNamespace* s) { type = NSN_NS; n.ns = s; }
    DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
        n.func = f;
    }
    DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
        n.sfunc = f;
    }

    DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
        n.gv = gv;
    }

    DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
        n.meth = m;
    }

    DLLLOCAL void deref() {
        switch (type) {
            case NSN_OCD:
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                delete n.hashdecl;
                break;
            case NSN_CONST:
                delete n.cn;
                break;
            case NSN_NS:
                delete n.ns;
                break;
            case NSN_FUNC:
                delete n.func;
                break;
            case NSN_SFUNC:
                delete n.sfunc;
                break;
            case NSN_VAR:
                delete n.gv;
                break;
            case NSN_METH:
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        switch (type) {
            case NSN_OCD:
                //printd(5, "ocd: %s %d-%d c: %d-%d\n", n.ocd->oc->getName(), n.ocd->loc.start_line, n.ocd->loc.end_line, qore_class_private::get(*n.ocd->oc)->loc.start_line, qore_class_private::get(*n.ocd->oc)->loc.end_line);
                ns.parseAddPendingClass(n.ocd->loc, *(n.ocd->name), n.ocd->oc);
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                ns.parseAddPendingHashDecl(n.hashdecl->loc, *(n.hashdecl->name), n.hashdecl->takeHashDecl());
                delete n.hashdecl;
                break;
            case NSN_CONST:
                ns.parseAddConstant(n.cn->loc, n.cn->name, n.cn->value, n.cn->pub);
                delete n.cn;
                break;
            case NSN_NS:
                ns.parseAddNamespace(n.ns);
                break;
            case NSN_FUNC:
                n.func->add(ns);
                break;
            case NSN_SFUNC:
                n.sfunc->add(ns);
                break;
            case NSN_VAR:
                n.gv->add(ns);
                break;
            case NSN_METH:
                n.meth->add(ns);
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
    DLLLOCAL void deref() {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->deref();

        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->add(ns);
    }
};

static QoreParseListNode* splice_expressions(QoreValue a1, QoreValue a2, const QoreProgramLocation* loc1, const QoreProgramLocation* loc2) {
    //tracein("splice_expressions()");
    if (a1.getType() == NT_PARSE_LIST) {
        QoreParseListNode* l = a1.get<QoreParseListNode>();
        if (!l->isFinalized()) {
            //printd(5, "LIST x\n");
            l->add(a2, loc2);
            return l;
        }
    }
    QoreParseListNode* l = new QoreParseListNode(qore_program_private::get(*getProgram())->getLocation(*loc1, loc2->start_line, loc2->end_line));
    l->add(a1, loc1);
    l->add(a2, loc2);
    return l;
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;
typedef std::pair<char*, HashDeclMemberInfo*> hashmem_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2
#define MI_HashMem 3

struct MemberInfo {
protected:
    DLLLOCAL MemberInfo(const QoreProgramLocation* loc) : loc(loc) {
    }

public:
    const QoreProgramLocation* loc;
    char* name;
    unsigned char type;
    union {
        QoreMemberInfo* memberInfo;
        QoreVarInfo* varInfo;
        HashDeclMemberInfo* hashMemberInfo;
        QoreSimpleValue exp;
    } u;

    DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : loc(mi->loc), name(n), type(MI_Member) {
        u.memberInfo = mi;
        if (!(mi && mi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*mi->loc, "member '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL MemberInfo(const QoreProgramLocation* loc, char* n, QoreValue exp) : loc(loc), name(n), type(MI_Constant) {
        u.exp = exp;
    }

    DLLLOCAL MemberInfo(char* n, HashDeclMemberInfo* mi) : loc(mi->loc), name(n), type(MI_HashMem) {
        u.hashMemberInfo = mi;
    }

    DLLLOCAL ~MemberInfo() {
        if (name)
            free(name);
        switch (type) {
            case MI_Member:
                delete u.memberInfo;
                break;
            case MI_Var:
                delete u.varInfo;
                break;
            case MI_HashMem:
                delete u.hashMemberInfo;
                break;
            case MI_Constant:
                u.exp.discard(nullptr);
                break;
        }
    }

    DLLLOCAL member_pair_t getPair() {
        assert(type == MI_Member);
        member_pair_t m = std::make_pair(name, u.memberInfo);
        name = nullptr;
        u.memberInfo = nullptr;
        return m;
    }

    DLLLOCAL var_pair_t getVarPair() {
        assert(type == MI_Var);
        var_pair_t m = std::make_pair(name, u.varInfo);
        name = nullptr;
        u.varInfo = nullptr;
        return m;
    }

    DLLLOCAL hashmem_pair_t getHashMemPair() {
        assert(type == MI_HashMem);
        hashmem_pair_t m = std::make_pair(name, u.hashMemberInfo);
        name = nullptr;
        u.hashMemberInfo = nullptr;
        return m;
    }

    DLLLOCAL QoreValue takeExp() {
        assert(type == MI_Constant);
        QoreValue rv = u.exp;
        u.exp.clear();
        return rv;
    }

    DLLLOCAL void setTransient() {
        assert(type == MI_Member);
        u.memberInfo->setTransient();
    }
};

struct ClassVarInfo : public MemberInfo {
    DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) : MemberInfo(vi->loc) {
        name = n;
        type = MI_Var;
        u.varInfo = vi;
        if (!(vi && vi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*vi->loc, "class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL char* takeName() {
        char* n = name;
        name = nullptr;
        return n;
    }
};

class MemberList {
protected:
    // for new class members
    QoreMemberMap mmap;
    // for new class constants
    ConstantList cmap;
    // for new class static variables
    QoreVarMap vmap;

    DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
    }

public:
    DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
        if (!member)
            return;

        if (member->type == MI_Member)
            mmap.addNoCheck(member->getPair());
        else if (member->type == MI_Constant)
            cmap.parseAdd(member->loc, member->name, member->takeExp());
        else
            vmap.addNoCheck(member->getVarPair());

        delete member;
    }

    DLLLOCAL ~MemberList() {
    }

    // takes over ownership of name and typeInfo
    DLLLOCAL int add(MemberInfo* member) {
        if (!member)
            return -1;

        if (member->type == MI_Member) {
            if (mmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate member declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            mmap.addNoCheck(member->getPair());
            delete member;
        } else if (member->type == MI_Constant) {
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate constant declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "constant declaration collides with static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new constant to list
            cmap.parseAdd(member->loc, member->name, member->takeExp());
            delete member;
        } else {
            assert(member->type == MI_Var);
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "duplicate static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "static class variable declaration collides with constant declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            vmap.addNoCheck(member->getVarPair());
            delete member;
        }

        return 0;
    }

    DLLLOCAL void merge(QoreClass* qc, ClassAccess access) {
        mmap.moveAllTo(qc, access);
        vmap.moveAllTo(qc, access);

        // merge constants
        qore_class_private::get(*qc)->parseAssimilateConstants(cmap, access);
    }
};

class EmptyMemberList : public MemberList {
public:
   DLLLOCAL EmptyMemberList() {
   }
};

struct ParserTypeStruct {
protected:
    DLLLOCAL ParserTypeStruct() {
    }

public:
    const QoreTypeInfo* typeInfo = nullptr;
    QoreParseTypeInfo* parseTypeInfo = nullptr;

    DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : parseTypeInfo(n_parseTypeInfo) {
    }

    DLLLOCAL ParserTypeStruct(char* id, bool or_nothing) : typeInfo(or_nothing ? getBuiltinUserOrNothingTypeInfo(id) : getBuiltinUserTypeInfo(id)) {
        //printd(0, "ParserTypeStruct::ParserTypeStruct('%s', %d) t: %p %s\n", id, or_nothing, typeInfo, QoreTypeInfo::getName(typeInfo));
        if (typeInfo) {
            free(id);
            return;
        }

        parseTypeInfo = new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL ~ParserTypeStruct() {
        delete parseTypeInfo;
    }

    DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
        return typeInfo;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static const QoreTypeInfo* getTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getTypeInfo() : nullptr;
    }

    DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static QoreParseTypeInfo* getParseTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getParseTypeInfo() : nullptr;
    }

    DLLLOCAL const char* getClassName() {
        assert(parseTypeInfo);
        return parseTypeInfo->cscope->ostr;
    }

    DLLLOCAL static ParserTypeStruct* getType(const QoreProgramLocation* loc, char* id, bool or_nothing) {
        return new ParserTypeStruct(getParseType(loc, id, or_nothing));
    }

    DLLLOCAL static void getSubTypes(const QoreProgramLocation* loc, const char* str, parse_type_vec_t& subtypes, bool raise_error = true) {
        QoreString buf;
        bool or_nothing = false;
        bool comma = false;

        const char* p = str;
        while (true) {
            if (*p == '\0') {
                if (buf.empty()) {
                    if (comma && raise_error)
                        parse_error(*loc, "empty subtype specification in type");
                }
                else
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                break;
            }
            switch (*p) {
                case '<': {
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    const char* e = strrchr(str, '>');
                    if (!e || e < p) {
                        if (raise_error)
                            parse_error(*loc, "unbalanced angle brackets in subtype specification in '%s'", str);
                        return;
                    }
                    buf.concat(p, e - p + 1);
                    //printd(5, "ST: '%s' (str: '%s') p: %p '%s'\n", buf.c_str(), str, p, p);
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                    buf.reset();
                    or_nothing = false;
                    //printd(5, "ST: p: %p -> %p\n", p, e);
                    p = e;
                    break;
                }
                case ',':
                    buf.trim();
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing, raise_error));
                    buf.reset();
                    or_nothing = false;
                    comma = true;
                break;
                case '*': {
                    if (buf.empty())
                        or_nothing = true;
                    else
                        buf.concat('*');
                    if (comma)
                        comma = false;
                    break;
                }
                case ' ':
                case '\t':
                    if (!buf.empty())
                        buf.concat(*p);
                    break;
                default:
                    buf.concat(*p);
                    if (comma)
                        comma = false;
                break;
            }
            ++p;
        }
    }

    DLLLOCAL static QoreParseTypeInfo* getParseType(const QoreProgramLocation* loc, char* id, bool or_nothing, bool raise_error = true) {
        //printd(0, "gPT() '%s'\n", id);
        char* p0 = strchr(id, '<');
        if (p0) {
            char* p1 = strrchr(id, '>');
            if (p1 > (p0 + 1)) {
                // terminate main type string
                *p0 = '\0';
                // terminate type args
                *p1 = '\0';

                parse_type_vec_t subtypes;
                getSubTypes(loc, p0 + 1, subtypes, raise_error);
                return new QoreParseTypeInfo(id, or_nothing, std::move(subtypes));
            }
        }
        return new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL static const QoreTypeInfo* getRuntimeType(const char* str) {
        assert(str);
        assert(str[0]);
        char* p;
        bool or_nothing;
        if (str[0] == '*') {
            or_nothing = true;
            p = strdup(str + 1);
        } else {
            or_nothing = false;
            p = strdup(str);
        }
        std::unique_ptr<QoreParseTypeInfo> pt(ParserTypeStruct::getParseType(&loc_builtin, p, or_nothing, false));
        return QoreParseTypeInfo::resolveRuntime(pt.get());
    }
};

const QoreTypeInfo* qore_get_type_from_string_intern(const char* str) {
    // issue #3318: does not use ProgramRuntimeParseAccessHelper as it is normally not needed, if this is
    // necessary, then the call to this function must be wrapped using this class
    return ParserTypeStruct::getRuntimeType(str);
}

static AbstractQoreNode* process_dot(int sline, int eline, QoreValue l, QoreValue r) {
    qore_type_t rtype = r.getType();
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    switch (rtype) {
        case NT_BAREWORD: {
            BarewordNode* b = r.get<BarewordNode>();
            if (!b->isFinalized()) {
                AbstractQoreNode* rv = new QoreHashObjectDereferenceOperatorNode(loc, l, b->makeQoreStringNode());
                b->deref();
                return rv;
            }
            break;
        }

        case NT_FUNCTION_CALL: {
            FunctionCallNode* f = r.get<FunctionCallNode>();
            assert(!f->getFunction());
            if (!f->isFinalized()) {
                MethodCallNode* m = new MethodCallNode(loc, f->takeName(), f->takeParseArgs());
                f->deref();

                return new QoreDotEvalOperatorNode(loc, l, m);
            }
            break;
        }
    }

    return new QoreHashObjectDereferenceOperatorNode(loc, l, r);
}

static int check_strong_encapsulation(const QoreProgramLocation* loc, const char* type, const char* name) {
    if (parse_check_parse_option(PO_STRONG_ENCAPSULATION)) {
        parse_error(*loc, "illegal out of line %s definition \"%s\" (conflicts with parse option PO_STRONG_ENCAPSULATION)", type, name);
        return -1;
    }
    return 0;
}

static int check_case(const QoreProgramLocation* loc, const char* op, QoreValue exp) {
    // ignore if NULL (= NOTHING)
    if (exp.hasEffect()) {
        if (op)
            parse_error(*loc, "case expression with '%s' needs run-time evaluation", op);
        else
            parse_error(*loc, "case expression needs run-time evaluation", op);
        return -1;
    }
    return 0;
}

static void check_funcmod(const QoreProgramLocation* loc, int mod) {
    if (mod & (OFM_PRIVATE|OFM_INTERNAL))
        parse_error(*loc, "illegal 'private' modifier in function declaration");
    if (mod & OFM_STATIC)
        parse_error(*loc, "illegal 'static' modifier in function declaration");
    if (mod & OFM_FINAL)
        parse_error(*loc, "illegal 'final' modifier in function declaration");
    if (mod & OFM_ABSTRACT)
        parse_error(*loc, "illegal 'abstract' modifier in function declaration");
}

static void check_classmod(const QoreProgramLocation* loc, int mod, QoreClass& qc) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in class declaration");
}

static void check_hashdeclmod(const QoreProgramLocation* loc, int mod, typed_hash_decl_private& hashdecl) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in hashdecl");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in hashdecl");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in hashdecl");
   if (mod & OFM_PUBLIC)
      hashdecl.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in hashdecl");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in hashdecl");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in hashdecl");
}

static void check_nsmod(const QoreProgramLocation* loc, int mod, qore_ns_private& ns) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // if pn is a function node it's effect actually cannot be evaluated
    // at this moment because the function flags have not yet been set
    // and so has_effect() always returns 'true'
    return pn ? pn->has_effect() : true;
}

bool node_has_effect_as_root(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffectAsRoot();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // the same comment as in the above function node_has_effect() applies also here
    return pn ? pn->has_effect_as_root() : true;
}

bool value_has_effect_as_root(const QoreValue& n) {
    return node_has_effect_as_root(n.getInternalNode());
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }

   DLLLOCAL ~MethodNode() {
      free(name);
      delete m;
   }

   DLLLOCAL void addAndDelete(QoreClass* qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }

   DLLLOCAL const QoreProgramLocation* getLoc() const {
      return m->getUserVariantBase()->getUserSignature()->getParseLocation();
   }
};

static QoreValue is_rewritable_op(QoreValue n) {
    qore_type_t nt = n.getType();
    if (nt == NT_OPERATOR) {
        QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n.getInternalNode());
        if (op)
            return op->getRight();
    }

    return QoreValue();
}

static QoreValue check_rewrite_list(QoreParseListNode* l) {
    if (!parse_check_parse_option(PO_BROKEN_LIST_PARSING))
        return l;

    // rewrite expression if it's a list without parentheses and
    // the first expression has one of the following operators:
    // =, +=, -=
    if (l->isFinalized())
        return l;

    QoreValue e0 = l->get(0);

    QoreValue r = is_rewritable_op(e0);
    if (!r.isNothing()) {
        QoreValue last = e0;
        QoreValue top = e0;
        while (true) {
            QoreValue nr = is_rewritable_op(r);
            if (nr.isNothing()) {
                break;
            }
            last = r;
            r = nr;
        }
        assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last.getInternalNode()));
        // take first element from list (the tree) and make it the new expression
        QoreBinaryLValueOperatorNode* op = last.get<QoreBinaryLValueOperatorNode>();
        l->swap(0, op->swapRight(l));
        return top;
    }

    return l;
}

// cannot be static
void ignore_return_value(QoreSimpleValue& n) {
    qore_type_t t = n.getType();
    if (t == NT_OPERATOR) {
        n.get<QoreOperatorNode>()->ignoreReturnValue();
    }
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}

static QoreOperatorNode* process_assignment(int sline, int eline, QoreValue $1, QoreValue $3) {
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    return ($1.getType() == NT_PARSE_LIST)
        ? static_cast<QoreOperatorNode*>(new QoreListAssignmentOperatorNode(loc, $1, $3))
        : static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
}

static QoreOperatorNode* process_weak_assignment(const QoreProgramLocation* loc, QoreValue $1, QoreValue $3) {
   if ($1.getType() == NT_LIST) {
       parse_error(*loc, "the ':=' operator is not valid with list assignments");
       return static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
   }
   return static_cast<QoreOperatorNode*>(new QoreWeakAssignmentOperatorNode(loc, $1, $3));
}

static AbstractQoreNode* processCall(int sline, int eline, QoreValue $1, QoreValue $3, const QoreProgramLocation* argloc) {
    AbstractQoreNode* $$;
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);

    //printd(5, "1: %s, 3: %s\n", $1.getTypeName(), $3.getTypeName());
    qore_type_t t = $1.getType();
    if (t == NT_BAREWORD) {
        BarewordNode* b = $1.get<BarewordNode>();
        // take string from node and delete node
        char* str = b->takeString();
        b->deref();
        printd(5, "parsing call %s() args: %s\n", str, $3.getTypeName());
        $$ = new FunctionCallNode(loc, str, make_args(argloc, $3));
    } else if (t == NT_CONSTANT) {
        ScopedRefNode* c = $1.get<ScopedRefNode>();
        // take NamedScope from node and delete node
        NamedScope *ns = c->takeName();
        c->deref();
        assert(ns->size() > 1);
        printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
        $$ = new StaticMethodCallNode(loc, ns, make_args(argloc, $3));
    } else if (t == NT_SELF_VARREF) {
        SelfVarrefNode* v = $1.get<SelfVarrefNode>();
        // take string from node and delete node
        char* str = v->takeString();
        v->deref();
        //printd(5, "parsing in-object method call %s()\n", str);
        $$ = new SelfFunctionCallNode(loc, str, make_args(argloc, $3));
    } else {
        QoreHashObjectDereferenceOperatorNode* hodon;

        if (t == NT_OPERATOR) {
            hodon = dynamic_cast<QoreHashObjectDereferenceOperatorNode*>($1.getInternalNode());
            if (hodon) {
                QoreValue r = hodon->getRight();
                if (r.getType() != NT_STRING)
                    hodon = nullptr;
            }
        } else
            hodon = nullptr;

        if (hodon) {
            // create an object method call node
            // take the string
            QoreStringNode* str = hodon->swapRight(QoreValue()).get<QoreStringNode>();
            assert(str->getEncoding() == QCS_DEFAULT);
            char* cstr = str->giveBuffer();
            assert(cstr);
            str->deref();

            MethodCallNode* mc = new MethodCallNode(loc, cstr, make_args(argloc, $3));

            // destroy the original operator and create a new operator object
            assert(hodon->is_unique());
            QoreValue l = hodon->swapLeft(QoreValue());
            hodon->deref(nullptr);

            $$ = new QoreDotEvalOperatorNode(loc, l, mc);
        } else {
            $$ = nullptr;
            if ($1.getType() == NT_VARREF) {
                VarRefNode* r = $1.get<VarRefNode>();
                qore_var_t vartype = r->getType();

                if (vartype != VT_UNRESOLVED) {
                    $$ = r->makeNewCall($3);
                    //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
                    if (!$$) {
                        parseException(*loc, "INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
                    }
                }
            }
            if (!$$) {
                $$ = new CallReferenceCallNode(loc, $1, make_args(argloc, $3));
                printd(5, "made new CallReferenceCallNode: %p exp: %s\n", $$, $1.getTypeName());
            }
        }
    }
    return $$;
}

static void check_operator(const QoreProgramLocation* loc, const QoreOperatorNode* n, const char* parent, const char* child) {
    if (parse_check_parse_option(PO_BROKEN_LOGIC_PRECEDENCE)) {
        if (!n->getInParentheses()) {
            qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_BROKEN_LOGIC_PRECEDENCE, "BROKEN-LOGIC-PRECEDENCE", "%s gets under %s in the parse tree as an impact of broken-logic-precedence flag being set - please consider using parenthesis to enforce the desired operator precedence", child, parent);
        }
    }
}

static void check_operator_log_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreLogicalOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "logical OR");
    }
}

static void check_operator_bin_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary OR");
    }
}

static void check_operator_bin_xor(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryXorOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary XOR");
    }
}


#line 1571 "parser.cpp"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_PARSER_HPP_INCLUDED
# define YY_YY_PARSER_HPP_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOK_RETURN = 258,
    TOK_RETURNS = 259,
    TOK_MY = 260,
    TOK_DO = 261,
    TOK_TRY = 262,
    TOK_THROW = 263,
    TOK_CATCH = 264,
    TOK_WHERE = 265,
    TOK_WHILE = 266,
    TOK_IF = 267,
    TOK_FOR = 268,
    TOK_SUB = 269,
    TOK_THREAD_EXIT = 270,
    TOK_BREAK = 271,
    TOK_CONTINUE = 272,
    TOK_CONTEXT_ROW = 273,
    TOK_FIND = 274,
    TOK_FOREACH = 275,
    TOK_IN = 276,
    TOK_DELETE = 277,
    TOK_REMOVE = 278,
    TOK_PRIVATE = 279,
    TOK_PRIVATEINTERNAL = 280,
    TOK_PRIVATEHIERARCHY = 281,
    TOK_PUBLIC = 282,
    TOK_SYNCHRONIZED = 283,
    TOK_DEPRECATED = 284,
    TOK_CONTEXT = 285,
    TOK_SORT_BY = 286,
    TOK_SORT_DESCENDING_BY = 287,
    TOK_SUB_CONTEXT = 288,
    TOK_CONST = 289,
    TOK_SUMMARIZE = 290,
    TOK_BY = 291,
    TOK_OUR = 292,
    TOK_RETHROW = 293,
    TOK_SWITCH = 294,
    TOK_CASE = 295,
    TOK_DEFAULT = 296,
    TOK_INHERITS = 297,
    TOK_ELSE = 298,
    TOK_STATIC = 299,
    TOK_NAMESPACE = 300,
    TOK_MODULE = 301,
    TOK_FINAL = 302,
    TOK_ABSTRACT = 303,
    TOK_HASHDECL = 304,
    TOK_TRANSIENT = 305,
    TOK_NULL = 306,
    TOK_NOTHING = 307,
    TOK_TRUE = 308,
    TOK_FALSE = 309,
    TOK_UNREFERENCE = 310,
    P_INCREMENT = 311,
    P_DECREMENT = 312,
    PLUS_EQUALS = 313,
    MINUS_EQUALS = 314,
    AND_EQUALS = 315,
    OR_EQUALS = 316,
    MODULA_EQUALS = 317,
    MULTIPLY_EQUALS = 318,
    DIVIDE_EQUALS = 319,
    XOR_EQUALS = 320,
    SHIFT_LEFT_EQUALS = 321,
    SHIFT_RIGHT_EQUALS = 322,
    TOK_UNSHIFT = 323,
    TOK_PUSH = 324,
    TOK_POP = 325,
    TOK_SHIFT = 326,
    TOK_CHOMP = 327,
    TOK_TRIM = 328,
    LOGICAL_AND = 329,
    LOGICAL_OR = 330,
    BROKEN_LOGICAL_OR = 331,
    BROKEN_BINARY_OR = 332,
    BROKEN_BINARY_XOR = 333,
    LOGICAL_EQ = 334,
    LOGICAL_NE = 335,
    LOGICAL_LE = 336,
    LOGICAL_GE = 337,
    LOGICAL_CMP = 338,
    ABSOLUTE_EQ = 339,
    ABSOLUTE_NE = 340,
    REGEX_MATCH = 341,
    REGEX_NMATCH = 342,
    TOK_EXISTS = 343,
    TOK_INSTANCEOF = 344,
    SHIFT_RIGHT = 345,
    SHIFT_LEFT = 346,
    TOK_ELEMENTS = 347,
    TOK_KEYS = 348,
    TOK_NEW = 349,
    TOK_BACKGROUND = 350,
    TOK_ON_EXIT = 351,
    TOK_ON_SUCCESS = 352,
    TOK_ON_ERROR = 353,
    TOK_MAP = 354,
    TOK_FOLDR = 355,
    TOK_FOLDL = 356,
    TOK_SELECT = 357,
    TOK_SPLICE = 358,
    TOK_EXTRACT = 359,
    IMPLICIT_ELEMENT = 360,
    NULL_COALESCING = 361,
    VALUE_COALESCING = 362,
    WEAK_ASSIGNMENT = 363,
    RANGE = 364,
    INTEGER = 365,
    QFLOAT = 366,
    NUMBER = 367,
    IDENTIFIER = 368,
    HASHDECL_IDENTIFIER_OPENCURLY = 369,
    ANGLE_IDENTIFIER = 370,
    VAR_REF = 371,
    BACKQUOTE = 372,
    SELF_REF = 373,
    KW_IDENTIFIER_OPENPAREN = 374,
    SCOPED_REF = 375,
    SCOPED_VREF = 376,
    CONTEXT_REF = 377,
    COMPLEX_CONTEXT_REF = 378,
    QORE_CAST = 379,
    QORE_OR_NOTHING_CAST = 380,
    CLASS_STRING = 381,
    DATETIME = 382,
    QUOTED_WORD = 383,
    BINARY = 384,
    REGEX_SUBST = 385,
    REGEX_TRANS = 386,
    CLASS_SCOPED_REF = 387,
    BASE_CLASS_CALL = 388,
    REGEX = 389,
    REGEX_EXTRACT = 390,
    IMPLICIT_ARG_REF = 391,
    DOT_KW_IDENTIFIER = 392,
    TRY_MODULE_ERROR = 393,
    IFX = 394,
    NEG = 395,
    UPLUS = 396
  };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_MY 260
#define TOK_DO 261
#define TOK_TRY 262
#define TOK_THROW 263
#define TOK_CATCH 264
#define TOK_WHERE 265
#define TOK_WHILE 266
#define TOK_IF 267
#define TOK_FOR 268
#define TOK_SUB 269
#define TOK_THREAD_EXIT 270
#define TOK_BREAK 271
#define TOK_CONTINUE 272
#define TOK_CONTEXT_ROW 273
#define TOK_FIND 274
#define TOK_FOREACH 275
#define TOK_IN 276
#define TOK_DELETE 277
#define TOK_REMOVE 278
#define TOK_PRIVATE 279
#define TOK_PRIVATEINTERNAL 280
#define TOK_PRIVATEHIERARCHY 281
#define TOK_PUBLIC 282
#define TOK_SYNCHRONIZED 283
#define TOK_DEPRECATED 284
#define TOK_CONTEXT 285
#define TOK_SORT_BY 286
#define TOK_SORT_DESCENDING_BY 287
#define TOK_SUB_CONTEXT 288
#define TOK_CONST 289
#define TOK_SUMMARIZE 290
#define TOK_BY 291
#define TOK_OUR 292
#define TOK_RETHROW 293
#define TOK_SWITCH 294
#define TOK_CASE 295
#define TOK_DEFAULT 296
#define TOK_INHERITS 297
#define TOK_ELSE 298
#define TOK_STATIC 299
#define TOK_NAMESPACE 300
#define TOK_MODULE 301
#define TOK_FINAL 302
#define TOK_ABSTRACT 303
#define TOK_HASHDECL 304
#define TOK_TRANSIENT 305
#define TOK_NULL 306
#define TOK_NOTHING 307
#define TOK_TRUE 308
#define TOK_FALSE 309
#define TOK_UNREFERENCE 310
#define P_INCREMENT 311
#define P_DECREMENT 312
#define PLUS_EQUALS 313
#define MINUS_EQUALS 314
#define AND_EQUALS 315
#define OR_EQUALS 316
#define MODULA_EQUALS 317
#define MULTIPLY_EQUALS 318
#define DIVIDE_EQUALS 319
#define XOR_EQUALS 320
#define SHIFT_LEFT_EQUALS 321
#define SHIFT_RIGHT_EQUALS 322
#define TOK_UNSHIFT 323
#define TOK_PUSH 324
#define TOK_POP 325
#define TOK_SHIFT 326
#define TOK_CHOMP 327
#define TOK_TRIM 328
#define LOGICAL_AND 329
#define LOGICAL_OR 330
#define BROKEN_LOGICAL_OR 331
#define BROKEN_BINARY_OR 332
#define BROKEN_BINARY_XOR 333
#define LOGICAL_EQ 334
#define LOGICAL_NE 335
#define LOGICAL_LE 336
#define LOGICAL_GE 337
#define LOGICAL_CMP 338
#define ABSOLUTE_EQ 339
#define ABSOLUTE_NE 340
#define REGEX_MATCH 341
#define REGEX_NMATCH 342
#define TOK_EXISTS 343
#define TOK_INSTANCEOF 344
#define SHIFT_RIGHT 345
#define SHIFT_LEFT 346
#define TOK_ELEMENTS 347
#define TOK_KEYS 348
#define TOK_NEW 349
#define TOK_BACKGROUND 350
#define TOK_ON_EXIT 351
#define TOK_ON_SUCCESS 352
#define TOK_ON_ERROR 353
#define TOK_MAP 354
#define TOK_FOLDR 355
#define TOK_FOLDL 356
#define TOK_SELECT 357
#define TOK_SPLICE 358
#define TOK_EXTRACT 359
#define IMPLICIT_ELEMENT 360
#define NULL_COALESCING 361
#define VALUE_COALESCING 362
#define WEAK_ASSIGNMENT 363
#define RANGE 364
#define INTEGER 365
#define QFLOAT 366
#define NUMBER 367
#define IDENTIFIER 368
#define HASHDECL_IDENTIFIER_OPENCURLY 369
#define ANGLE_IDENTIFIER 370
#define VAR_REF 371
#define BACKQUOTE 372
#define SELF_REF 373
#define KW_IDENTIFIER_OPENPAREN 374
#define SCOPED_REF 375
#define SCOPED_VREF 376
#define CONTEXT_REF 377
#define COMPLEX_CONTEXT_REF 378
#define QORE_CAST 379
#define QORE_OR_NOTHING_CAST 380
#define CLASS_STRING 381
#define DATETIME 382
#define QUOTED_WORD 383
#define BINARY 384
#define REGEX_SUBST 385
#define REGEX_TRANS 386
#define CLASS_SCOPED_REF 387
#define BASE_CLASS_CALL 388
#define REGEX 389
#define REGEX_EXTRACT 390
#define IMPLICIT_ARG_REF 391
#define DOT_KW_IDENTIFIER 392
#define TRY_MODULE_ERROR 393
#define IFX 394
#define NEG 395
#define UPLUS 396

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 1512 "parser.ypp"

    QoreSimpleValue qv;
    bool b;
    int i4;
    int64 integer;
    double decimal;
    QoreStringNode* String;
    char* string;
    BinaryNode* binary;
    AbstractQoreNode* node;
    QoreParseHashNode* hash;
    QoreParseListNode* parse_list;
    AbstractStatement* statement;
    struct MemberInfo* memberinfo;
    struct ClassVarInfo* classvarinfo;
    StatementBlock *sblock;
    ContextModList* cmods;
    ContextMod *cmod;
    class HashElement* hashelement;
    QoreFunction* userfunc;
    struct MethodNode* methodnode;
    class MemberList* memberlist;
    QoreClass* qoreclass;
    typed_hash_decl_private* hashdeclpriv;
    class ConstNode* constnode;
    QoreNamespace *ns;
    struct NSNodeList* nsnlist;
    struct NSNode* nsn;
    class ObjClassDef* classdef;
    class HashDeclDef* hashdecldef;
    DateTimeNode* datetime;
    QoreRegexSubst* RegexSubst;
    QoreTransliteration* Trans;
    SwitchStatement* switchstmt;
    CaseNode* casenode;
    BCList* sclist;
    class BCNode* sclnode;
    BCAList* bcalist;
    BCANode* bcanode;
    NamedScope *nscope;
    QoreRegex* Regex;
    QoreImplicitArgumentNode* implicit_arg;
    RetTypeInfo* returnTypeInfo;
    struct ParserTypeStruct* parsertype;
    class ParseUserFunction* parsefunc;
    class ParseScopedUserFunction* sparsefunc;
    struct GVarDecl* gv;
    QoreNumberNode* num;
    TryModuleError* trymod;
    struct MethodDef* methoddef;

#line 1957 "parser.cpp"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int yyparse (yyscan_t yyscanner);

#endif /* !YY_YY_PARSER_HPP_INCLUDED  */

/* Second part of user prologue.  */
#line 1564 "parser.ypp"


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE* loc, yyscan_t scanner, const char* str) {
    //printd(5, "yyerror() location: %d:%d - %d:%d \"%s\"\n", loc->first_line, loc->first_col, loc->last_line, loc->last_col, str);
    const QoreProgramLocation* qloc = qore_program_private::get(*getProgram())->getLocation(loc->first_line, loc->last_line);
    parse_error(*qloc, "%s", str);
}


#line 2000 "parser.cpp"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))

/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  215
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   13682

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  167
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  68
/* YYNRULES -- Number of rules.  */
#define YYNRULES  440
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  945

#define YYUNDEFTOK  2
#define YYMAXUTOK   396


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   158,     2,     2,     2,   151,   146,     2,
     162,   165,   152,   149,   140,   150,   161,   153,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   143,   164,
     147,   141,   148,   142,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   160,   157,   166,   145,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   159,   144,   163,   156,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   154,   155
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  1827,  1827,  1828,  1832,  1835,  1840,  1848,  1852,  1858,
    1862,  1867,  1875,  1876,  1880,  1887,  1897,  1922,  1924,  1929,
    1943,  1944,  1950,  1958,  1964,  1970,  1974,  1982,  1988,  1995,
    2003,  2009,  2018,  2023,  2031,  2036,  2039,  2047,  2050,  2053,
    2058,  2061,  2069,  2075,  2078,  2084,  2087,  2093,  2096,  2101,
    2104,  2109,  2111,  2113,  2115,  2121,  2122,  2126,  2127,  2157,
    2164,  2166,  2169,  2172,  2175,  2178,  2181,  2184,  2187,  2190,
    2193,  2196,  2199,  2202,  2205,  2208,  2209,  2217,  2220,  2223,
    2224,  2229,  2230,  2241,  2243,  2245,  2250,  2252,  2256,  2265,
    2269,  2277,  2283,  2289,  2295,  2301,  2307,  2313,  2319,  2325,
    2331,  2337,  2342,  2347,  2352,  2357,  2362,  2367,  2373,  2379,
    2384,  2392,  2419,  2420,  2421,  2425,  2430,  2438,  2444,  2452,
    2461,  2472,  2481,  2495,  2498,  2504,  2507,  2514,  2518,  2522,
    2526,  2530,  2534,  2538,  2542,  2546,  2550,  2557,  2565,  2582,
    2587,  2592,  2619,  2624,  2631,  2638,  2645,  2652,  2656,  2661,
    2666,  2671,  2680,  2683,  2686,  2690,  2693,  2696,  2704,  2705,
    2711,  2712,  2713,  2717,  2718,  2719,  2720,  2721,  2722,  2726,
    2727,  2728,  2732,  2737,  2741,  2747,  2751,  2774,  2781,  2788,
    2812,  2819,  2826,  2850,  2856,  2862,  2865,  2875,  2882,  2888,
    2897,  2904,  2907,  2910,  2914,  2921,  2924,  2927,  2931,  2938,
    2941,  2944,  2950,  2961,  2976,  2983,  2997,  3008,  3021,  3027,
    3036,  3040,  3050,  3053,  3059,  3062,  3069,  3073,  3081,  3082,
    3087,  3088,  3098,  3099,  3100,  3101,  3102,  3103,  3104,  3105,
    3106,  3110,  3127,  3133,  3139,  3149,  3161,  3179,  3185,  3195,
    3207,  3225,  3230,  3250,  3255,  3269,  3274,  3278,  3283,  3288,
    3298,  3307,  3316,  3318,  3320,  3322,  3327,  3341,  3352,  3359,
    3368,  3379,  3397,  3435,  3438,  3446,  3451,  3456,  3461,  3466,
    3471,  3476,  3480,  3494,  3498,  3512,  3516,  3520,  3524,  3548,
    3572,  3600,  3616,  3632,  3648,  3652,  3656,  3664,  3670,  3677,
    3684,  3689,  3693,  3697,  3728,  3735,  3742,  3749,  3763,  3769,
    3786,  3792,  3797,  3805,  3814,  3827,  3831,  3835,  3839,  3843,
    3847,  3854,  3855,  3856,  3857,  3858,  3859,  3860,  3861,  3862,
    3863,  3864,  3865,  3866,  3867,  3868,  3869,  3870,  3878,  3885,
    3886,  3887,  3888,  3889,  3890,  3891,  3896,  3897,  3898,  3899,
    3904,  3905,  3911,  3912,  3913,  3914,  3915,  3916,  3917,  3918,
    3919,  3920,  3921,  3922,  3923,  3924,  3925,  3926,  3927,  3928,
    3929,  3930,  3931,  3932,  3933,  3934,  3935,  3939,  3953,  3954,
    3955,  3956,  3960,  3961,  3962,  3963,  3964,  3965,  3966,  3967,
    3968,  3969,  3970,  3971,  3972,  3973,  3981,  3988,  3989,  3990,
    3991,  3992,  3993,  3994,  3999,  4000,  4001,  4002,  4007,  4008,
    4014,  4015,  4016,  4017,  4018,  4019,  4020,  4021,  4022,  4023,
    4024,  4025,  4026,  4027,  4028,  4029,  4030,  4031,  4032,  4033,
    4034,  4035,  4036,  4037,  4038,  4043,  4057,  4058,  4059,  4060,
    4064,  4067,  4075,  4076,  4077,  4078,  4079,  4080,  4081,  4082,
    4083
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"", "\"my\"",
  "\"do\"", "\"try\"", "\"throw\"", "\"catch\"", "\"where\"", "\"while\"",
  "\"if\"", "\"for\"", "\"sub\"", "\"thread_exit\"", "\"break\"",
  "\"continue\"", "\"%%\"", "\"find\"", "\"foreach\"", "\"in\"",
  "\"delete\"", "\"remove\"", "\"private\"", "\"private:internal\"",
  "\"private:hierarchy\"", "\"public\"", "\"synchronized\"",
  "\"deprecated\"", "\"context\"", "\"sortBy\"", "\"sortDescendingBy\"",
  "\"subcontext\"", "\"const\"", "\"summarize\"", "\"by\"", "\"our\"",
  "\"rethrow\"", "\"switch\"", "\"case\"", "\"default\"", "\"inherits\"",
  "\"else\"", "\"static\"", "\"namespace\"", "\"module\"", "\"final\"",
  "\"abstract\"", "\"hashdecl\"", "\"transient\"", "\"NULL\"",
  "\"NOTHING\"", "\"True\"", "\"False\"", "\"unreference\"",
  "\"++ operator\"", "\"-- operator\"", "\"+= operator\"",
  "\"-= operator\"", "\"&= operator\"", "\"|= operator\"",
  "\"%= operator\"", "\"*= operator\"", "\"/= operator\"",
  "\"^= operator\"", "\"<<= operator\"", "\">>= operator\"", "\"unshift\"",
  "\"push\"", "\"pop\"", "\"shift\"", "\"chomp\"", "\"trim\"",
  "\"&& operator\"", "\"|| operator\"", "\"|| operator (compat)\"",
  "\"| operator (compat)\"", "\"^ operator (compat)\"", "\"== operator\"",
  "\"!= operator\"", "\"<= operator\"", "\">= operator\"",
  "\"<=> operator\"", "\"=== operator\"", "\"!== operator\"",
  "\"=~ operator\"", "\"!~ operator\"", "\"exists\"", "\"instanceof\"",
  "\">> operator\"", "\"<< operator\"", "\"elements\"", "\"keys\"",
  "\"new\"", "\"background\"", "\"on_exit\"", "\"on_success\"",
  "\"on_error\"", "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"",
  "\"splice\"", "\"extract\"", "\"$# operator\"", "\"?? operator\"",
  "\"?* operator\"", "\":= operator\"", "\".. operator\"",
  "\"integer value\"", "\"floating-point value\"",
  "\"arbitrary-precision number\"", "\"identifier\"",
  "\"typed hash identifier\"", "\"complex type identifier\"",
  "\"variable reference\"", "\"backquote expression\"",
  "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "QORE_OR_NOTHING_CAST",
  "\"simple class declaration\"", "\"date/time value\"",
  "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'|'",
  "'^'", "'&'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "UPLUS", "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'",
  "';'", "')'", "']'", "$accept", "top_level_commands",
  "top_level_command", "module_decls", "module_decl", "ppub", "gvardecl",
  "top_namespace_decl", "namespace_decls", "namespace_decl",
  "unscoped_const_decl", "scoped_const_decl", "block",
  "statement_or_block", "statements", "optname", "statement",
  "context_mods", "context_mod", "return_statement", "switch_statement",
  "case_block", "case_code", "try_statement", "myexp", "hashdecl_def",
  "class_def", "inheritance_list", "superclass_list", "superclass",
  "hashdecl_attrs", "hashdecl_member", "class_attributes", "uncqtypedef",
  "qtypedef", "internal_member_list", "private_member_list",
  "public_member_list", "classvardecl", "member2", "transient_member2",
  "member", "transient_member", "member_list", "member_list2",
  "ident_openparen", "inline_methoddef", "outofline_methoddef",
  "base_constructor_list", "base_constructors", "base_constructor",
  "nsc_modifiers", "method_modifiers", "method_modifier", "return_value",
  "sub_def", "scoped_sub_def", "list", "list_n", "hash", "hash_element",
  "alt_hash", "immediate_typed_hash", "exp_c", "exp", "exp_n", "string",
  "scalar", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
      44,    61,    63,    58,   124,    94,    38,    60,    62,    43,
      45,    37,    42,    47,   395,   396,   126,    92,    33,   123,
      91,    46,    40,   125,    59,    41,    93
};
# endif

#define YYPACT_NINF (-666)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-219)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    1644,  -105,  6789,   232,  5900,  5900,  7754,   -99,   -93,   -46,
     249,   -39,     7,    11,  -666,  7754,  7754,  7754,  7754,  -666,
    -666,  -666,   326,  -666,  -666,    92,  -666,    76,    92,    50,
      56,  -666,   123,  -666,  -666,  -666,  -666,  -666,  -666,  7754,
    7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,
     347,  7754,  5900,  5900,  5900,  7754,  7754,  7754,  7754,  7754,
    7754,  -666,  -666,  -666,  -666,    10,  -666,  -666,  -666,  1481,
      46,  -666,  -666,   156,   181,  -666,    88,  -666,   182,  -666,
    -666,  7754,  7754,   436,  7754,  7754,  7754,  5244,  6673,  -666,
    1278,  -666,   338,  -666,  -666,  -666,  -666,  -666,   270,  -666,
    -666,  -666,  -666,    57,    71,  -666,   306,   544,  -666,  -666,
    -666,  -666,  -666, 10280,  -666,  -666,  -666,   299,   442,  6938,
      22,  7084,    47,   626,  -666,  -666,  -666,  -666, 12876,   272,
    -666,  7754,   380,   381,    20,  5408,  -666,   496,  -666,   487,
   10389,  7754,  7754,  6060,   346,   365,  -666,   368,  1481,  1481,
    -666,  -666,  -666,  7972,  8079,   632,   632,   233,  -666,   385,
    1804,   403,   440,   415,  -666,  7754,   486,   808,   808, 12876,
   12876,   632,   632,   632,   632,  7828,   632,   632,   443,   463,
     464,   632,  -666,  -666,  -666, 12876, 12876, 12876, 12876, 12876,
   12876,  -666,   433, 12876,  1481,  7754,  7754,  -666,  1481,   632,
     632,  -666,  -666,  -666,   632,   632,   632,  -666,  -666,  5572,
    -666,  -666,   -78,  -666,  8630,  -666,  -666,   444,  -666,   273,
    -666,   475,  -666,  -666,   259,   236,   596,   596,   324,  -666,
    -666,   482,    17,  -666,  -666,  -666,  7754,  7754,  7754,  7754,
    7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,
    7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,   432,   515,
     408,  7754,  7754,  7754,  7754,  7754,  7754,  -666,  7376,  7754,
    7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,
    7754,  7754,  7522,  7754,  1481,  -666,  -666,   -42, 11913,  -666,
      66,   500,   513,   651,  -666,  -666,  7754,  7754,  7754,  7754,
    7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,
    7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,   613,   542,
     408,  7754,  7754,  7754,  7754,  7754,  7754,  -666,  7376,  7754,
    7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,  7754,
    7754,  7754,  7638,  7754,  1481,   512, 12876,  -666,  -666,  1481,
    -666,  5736,   521,   522,  -666,  8740,  8850,   530,  -666,  -666,
    1481,   520,   539,  7754,   536,   571,   576,  7754,   560,   561,
     562,  -666,  -666,  7754,  7754,  7754,  8960,   584,   -61,  -666,
    1481,  1481,  1481,  -666,   566,  9070,  9180,   567,  -666,  -666,
    -666,  7376,  -666,  7754,  -666,   501,   526,  7754,   295,   349,
     564,  1481,  1481,  1481,   353,  -666,   574,   575,   263,   421,
     533,   573,  1481,  1481,  1481,   379,   580, 12983, 12983, 12983,
   12983, 12983, 12983, 12983, 12983, 12983, 12983, 13349, 13313, 13349,
   13520, 13520,  7828,  7828,  7828,  7828,  7828,  7828,  7828,  -666,
    -666,  -666,  -666,  -666,  -666,    51,    51, 13215, 13215, 12983,
   13179, 12983, 12983, 12020, 13435, 13471, 13520,  7828,  7828,   896,
     896,   519,   632,   632, 11697,  6209,  8186,  -666,   587,  -666,
    -666,   583, 12983, 12983, 12983, 12983, 12983, 12983, 12983, 12983,
   12983, 12983, 13349, 13313, 13349, 13520, 13520,  7828,  7828,  7828,
    7828,  7828,  7828,  7828,  -666,  -666,  -666,  -666,  -666,  -666,
      51,    51, 13215, 13215, 12983, 13179, 12983, 12983, 12127, 13435,
   13471, 13520,  7828,  7828,   896,   896,   519,   632,   632, 11805,
    6325,  8297,  -666,   590,  -666,   592,  -666,  7754,  1481,  5900,
    5900,  6060,   593,   732,   732,  7865,  7754,  7754,  7754,  9290,
    7754,  7754,  7754, 10498, 10607,  9400,   603,  7754,  -666,  -666,
     595,   598,   599,   -37,  -666,  -666,  -666,  -666, 12983,   606,
    -666,  -666,  -666,  -666,  1481,   608,   610,   611,   382,   589,
    -666,   602,  -666,   402,  -666,  -666,  -666,  -666,  -666,    37,
    -666,   968,  -666,  -666,   408,   408,   320,   411,   481,   503,
    -666,  -666,   628,  -666,   121,  -666,   430,  -666,  1481,   612,
     619,   620,   634,  1481,  1481,  1481,  7754,  -666,  -666,  8408,
    6441,  -666,  -666,  7754,  -666,  -666,  8519,  6557,  -666,  -666,
     633,  9510,   625,  -666,   755,   637,   732,   408,   645,   645,
     644,  9620, 10716, 10825,  -666,  9730,  9840,  9950,  -666,  -666,
     771,   251, 10934,  -666,  -666,  -666,   511,  -666,   732,  -666,
     647,   645,   645,   667,  1481,  -666,  -666,  -666,   490,   514,
      54,   244,  -666,   711,   374,  -666,  -666,  -666,  -666,  -666,
    -666,  -666,  -666,   263,   -25,   -17,   -15,    38,   713,  -666,
    -666,   456,  -666,  -666,  -666,  -666,   106,   792,  -666,   485,
     663,   732,   732,   667,  1481,   664,   666,   670, 13081,  -666,
    -666, 13081,  -666,  -666,   668,  5900,  5900,  1481,   645,  -666,
    -666,  -666,  -666,  7754,  5900,  -666,  -666,  1804,  -666,  -666,
    -666,   675,  7230,   699,   -11,  -666,  -666,   681,   684,   707,
    -666,   645,   645,  -666,  -666,   645,   685,   548,  -666,  -666,
     257,  -666,  -666,   731,   736,    65,  -666,  -666,   -70,   586,
     -67,   659,   -50,   738,   828,   -40,  -666,  -666,  -666,  -666,
    -666,  -666,   365,    -8,  1481,  -666,   732,   645,   645,   732,
     687,   645,   645,   667,  -666,  -666,  -666,   692,  -666, 10060,
    -666,  -666,  7754,  7754,  7754,  7754,   726,   727,   724,  7754,
    7754, 12234,  1964,  -666,  -666,  1481,  1481,   511,  -666,  -666,
    -666,   667,  7754,  1481,  -666,  -666,  -666,   834,   435,   601,
     152,  -666,  -666,   756,   752,  -666,  -666,  -666,   974,     0,
    -666,  -666,  1010,  -666,  -666,  1048,  -666,  -666,  1051,  -666,
    1481,   708,   645,  -666,  -666,   541,   645,  -666,  -666,   543,
    5900,  -666, 10170, 12341, 12448, 12555,   733,   734,  2128, 12662,
   12769,  2292,  2456,   714,   720,  -666, 11043,   723,   307,   776,
    -666,  7754,  -666,   258,   283,  -666,  -666,  -666,  -666,  -666,
    -666,  -666,  -666,   725,   667,  -666,  -666,  -666,  -666,  -666,
    -666,  -666,  -666,  2620,  2784,  2948,  3112,  3276,  3440,  3604,
    3768,  3932,  -666,  -666,  -666,   728,  7754,  -666,   420, 11152,
    7754,  1481,  -666,  7754,  1481,  -666,   667,   732,  1804,  4096,
    4260,  4424,  4588,  4752,  4916,  5080,  -666, 11261,  7754,  1481,
    -666,  -666, 11370,   735, 11479,   737,   549,   551,  -666,  -666,
   11588,   739,  -666,   729,  -666,   741,  -666,  -666,  -666,  -666,
    -666,   751,  -666,  -666,  -666
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,     0,   158,   158,     0,     0,   158,     0,     0,     0,
       0,     0,     0,     0,   266,   158,   158,   158,   158,   222,
     224,   223,   228,   226,   227,    55,    81,     0,    55,     0,
       0,   225,     0,   229,   230,   438,   437,   439,   440,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
       0,   158,     0,     0,     0,   158,   158,   158,   158,   158,
     158,   306,   433,   432,   436,   264,   154,   298,   288,     0,
     255,   265,   267,     0,     0,   435,   430,   253,     0,   305,
      16,   158,   158,     0,   158,   158,   158,     0,   158,    57,
       0,     2,     0,   263,    14,     9,     8,    11,     0,    79,
      60,     7,     6,   159,     0,    10,     0,   219,   220,     4,
       5,   373,   372,     0,   434,   252,    80,     0,   228,   158,
     255,   158,   159,     0,   312,   313,   314,   311,    87,   260,
     153,   158,   159,     0,   255,     0,    50,     0,    49,     0,
       0,   158,   158,     0,     0,     0,   201,     0,     0,     0,
      76,    77,    78,     0,     0,   307,   308,     0,    56,     0,
       0,     0,     0,     0,    61,   158,     0,   284,   285,   272,
     274,   275,   273,   276,   277,   269,   270,   271,     0,     0,
       0,   297,    63,    64,    65,   280,   281,   282,   283,   278,
     279,   114,     0,   113,     0,   158,   158,   431,     0,   290,
     289,   155,   157,   156,   291,   293,   292,    12,    52,     0,
      51,   300,     0,   245,     0,     1,     3,   158,    75,     0,
     258,     0,   256,   257,     0,     0,   124,   124,     0,   228,
     152,   153,     0,   221,   390,   391,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,     0,     0,
       0,   158,   158,   158,   158,   158,   158,   429,   244,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,     0,    58,   251,     0,     0,   315,
       0,     0,     0,     0,   332,   333,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,     0,     0,
       0,   158,   158,   158,   158,   158,   158,   371,   242,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,     0,   312,     0,   259,   261,     0,
      48,     0,     0,     0,    62,     0,     0,     0,   200,   199,
       0,     0,     0,   158,     0,     0,     0,   158,     0,     0,
       0,    66,    82,   158,   158,   158,     0,     0,     0,    17,
       0,     0,     0,   287,     0,     0,     0,     0,    13,    53,
      54,   247,   254,   158,   299,    25,    23,   158,   159,     0,
       0,     0,     0,     0,   218,    30,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   374,   375,   376,
     377,   378,   379,   380,   381,   382,   383,   393,   394,   395,
     396,   397,   409,   412,   413,   414,   408,   410,   411,   403,
     404,   401,   405,   402,   386,   416,   415,   387,   388,   385,
     427,   243,   384,     0,   398,   400,   399,   407,   406,   417,
     418,   419,   421,   420,     0,   158,     0,   428,     0,   250,
     249,     0,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   335,   336,   337,   338,   339,   351,   354,   355,
     356,   350,   352,   353,   345,   346,   343,   347,   344,   328,
     358,   357,   329,   330,   327,   369,   241,   326,     0,   340,
     342,   341,   349,   348,   359,   360,   361,   363,   362,     0,
     158,     0,   370,     0,   262,     0,    47,   158,     0,     0,
       0,     0,     0,   232,   232,     0,   158,   158,   158,     0,
     158,   158,   158,     0,     0,     0,     0,   158,    15,    18,
       0,     0,     0,   213,   309,   310,   286,   246,   248,   312,
      24,    22,    27,    26,     0,     0,     0,     0,     0,   153,
      31,     0,    41,   218,    32,    35,    34,    37,    36,     0,
      42,   219,    38,    39,     0,     0,     0,     0,     0,     0,
     127,   128,   123,   125,   218,   119,   218,   120,     0,     0,
       0,     0,     0,     0,     0,     0,   158,   426,   424,     0,
     158,   425,   392,   158,   368,   366,     0,   158,   367,   334,
       0,     0,     0,    71,    69,     0,   232,   158,     0,     0,
       0,     0,     0,     0,    81,     0,     0,     0,    43,    45,
       0,     0,     0,   294,   296,   295,     0,    59,   232,    28,
       0,     0,     0,   213,     0,    40,    29,    33,     0,     0,
       0,     0,   137,     0,     0,   131,   132,   135,   136,   133,
     134,   129,   130,     0,   222,   224,   223,   228,     0,   121,
     146,   218,   143,   144,   145,   142,     0,   219,   122,   218,
       0,   232,   232,   213,     0,     0,     0,     0,   389,   423,
     422,   331,   365,   364,     0,     0,     0,     0,     0,   159,
     231,   301,   233,   158,     0,    44,    46,     0,    83,    84,
      85,     0,   158,     0,     0,    89,    19,     0,     0,   212,
     214,     0,     0,   302,   234,     0,     0,     0,   115,   138,
       0,   116,   126,     0,   188,   158,   191,   192,     0,   158,
       0,   158,     0,     0,   158,     0,   117,   151,   148,   149,
     150,   147,   152,     0,     0,   118,   232,     0,     0,   232,
       0,     0,     0,   213,    72,   111,    70,     0,   237,     0,
      74,    68,   158,   158,   158,   158,     0,     0,     0,   158,
     158,     0,     0,    88,    90,     0,     0,     0,   210,   238,
     211,   213,   158,     0,   139,   190,   189,     0,     0,   158,
     152,   165,   186,   159,     0,   185,   195,   196,   158,     0,
     163,   162,   158,   160,   168,   158,   166,   171,   158,   169,
       0,     0,     0,   303,   235,     0,     0,   304,   236,     0,
       0,   268,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,   152,     0,
     187,   158,   183,     0,     0,   164,   197,   198,   193,   194,
     161,   167,   170,     0,   213,   239,   208,   206,   240,   209,
     207,    73,    81,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   216,   217,   140,     0,   158,   173,     0,     0,
     158,     0,   180,   158,     0,   177,   213,   232,     0,     0,
       0,     0,     0,     0,     0,     0,   141,     0,   158,     0,
     172,   184,     0,     0,     0,     0,     0,     0,    67,   175,
       0,     0,   181,     0,   178,     0,   205,   203,   204,   202,
     174,     0,   182,   179,   176
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -666,  -666,   801,  -666,   525,  -666,  -401,  -397,  -666,   344,
       1,  -394,   267,    13,    -3,   869,    74,  -625,  -666,  -666,
    -666,  -666,   175,  -666,   660,  -392,  -387,   693,  -666,   250,
     339,  -258,   331,     5,    16,  -600,  -458,  -331,  -666,   -23,
    -598,  -665,   109,  -224,   -91,  -217,  -277,  -383,  -589,  -666,
     132,  -474,     6,   -75,  -278,  -382,  -378,  -111,  -666,    32,
     555,  -666,  -666,    23,    -2,  -666,   854,  -666
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    90,    91,   378,   379,    92,    93,    94,   573,   574,
     812,    96,   136,   137,   209,   159,   138,   160,   372,    98,
      99,   724,   725,   100,   192,   101,   102,   409,   592,   593,
     661,   662,   681,   122,   104,   682,   683,   684,   815,   816,
     817,   746,   747,   748,   818,   149,   685,   105,   648,   729,
     730,   106,   123,   108,   628,   109,   110,   124,   111,   212,
     213,   125,   126,   127,   193,   113,   114,   115
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     128,    95,   402,   571,   140,   103,   107,   572,   132,   717,
     576,   413,   577,   153,   154,   155,   156,   578,   139,   133,
     345,   580,   582,   112,  -152,   743,   583,   112,   112,   722,
     723,   415,   233,   743,  -153,   743,  -153,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   233,   181,
     743,   658,   377,   185,   186,   187,   188,   189,   190,   116,
    -153,   291,   391,   141,   735,   182,   183,   184,   737,   142,
     819,   219,   753,   819,    97,   112,   112,   112,   805,   199,
     200,   758,   204,   205,   206,   144,   214,   392,   743,   758,
     819,    95,   807,   744,   820,   103,   107,   823,   391,   678,
     819,   744,   548,   744,   769,   145,   646,   294,   295,   808,
     112,   146,   232,   112,   826,   809,   143,   288,   744,   288,
     686,   469,   686,  -152,   829,   150,  -152,   647,   293,   346,
    -152,  -152,   351,  -153,   745,  -153,  -153,   416,  -153,   355,
     356,  -153,   749,  -153,   751,   674,   675,   676,   677,    23,
      24,   287,   793,   290,   868,   678,   744,   221,   112,  -153,
     220,   210,  -153,   376,    97,    31,  -153,  -153,    33,    34,
     220,   151,   571,   371,   416,   152,   572,   221,   810,   576,
      66,   577,   349,   112,   839,   130,   578,   222,   327,   161,
     580,   582,   223,   385,   386,   583,   162,   754,   604,   144,
     336,   337,   338,   339,   340,   158,   391,   686,   194,   210,
     341,   342,   343,   344,   164,   686,    76,    83,   165,   762,
     867,    66,   398,   759,   867,   146,   130,   867,   811,   470,
     867,   759,   112,   399,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,   428,   429,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   629,   908,    83,   445,
     446,   447,   448,   449,   450,   444,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     466,   467,   166,   390,   679,   907,   559,   586,   587,   588,
     589,   722,   723,   861,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   862,   926,   195,   500,
     501,   502,   503,   504,   505,   499,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     521,   522,   144,   196,   198,   129,   365,    66,   708,   406,
     760,   224,   130,   366,   208,   225,   407,   230,   760,    66,
     157,   535,   145,   -21,   130,   539,   144,   568,   146,   147,
     731,   543,   544,   545,   112,   217,   590,    19,    20,    21,
      22,    23,    24,   591,    83,  -152,   145,    27,  -152,   288,
     -20,   558,   146,   400,   131,   346,    83,    31,   802,   900,
      33,    34,   208,   739,   761,   575,   739,   738,   560,   579,
     581,   148,   761,   767,   768,   561,   568,   144,   404,   803,
     901,   804,   902,   405,   903,   390,    19,    20,    21,    22,
      23,    24,   226,   665,   218,   401,    27,   145,   227,   -20,
     666,   402,   413,   146,   411,   904,    31,   905,   896,    33,
      34,   750,   752,   755,   674,   675,   676,   677,    23,    24,
     178,   148,   179,   609,   678,   562,   230,   180,    66,   764,
     563,   897,   144,   569,    31,   144,   389,    33,    34,   -21,
     674,   675,   676,   677,    23,    24,   412,   230,   832,    66,
     678,   835,   145,   347,   130,   145,   353,   348,   146,   602,
      31,   146,   147,    33,    34,    83,   233,   352,   358,   674,
     675,   676,   677,    23,    24,   230,   570,    66,   616,   678,
     604,   230,   569,    66,   667,   621,    83,   359,   130,    31,
     360,   668,    33,    34,   631,   632,   633,   741,   635,   636,
     637,   603,   623,   624,   373,   642,   830,   367,   858,   201,
      66,   202,   112,   112,    83,   130,   203,   395,   228,    66,
      83,   918,   439,   440,   396,   656,   441,   442,    19,    20,
      21,   229,    23,    24,   575,   294,   295,   375,   579,   581,
     594,   374,   919,   144,   920,   595,   660,    83,    31,   663,
     663,    33,    34,   688,   669,   680,    83,   680,   383,   377,
     687,   670,   687,   145,   698,   380,   397,   144,   505,   146,
     400,   701,   233,   807,  -152,   505,   671,  -152,   389,   756,
     678,  -152,  -152,   672,   727,   381,   382,   145,   807,   927,
     808,   728,   709,   146,   411,   678,   809,   403,   408,  -153,
     292,   144,  -153,   710,   414,   808,  -153,  -153,   765,   443,
      19,    20,    21,   229,    23,    24,   327,   230,   822,    66,
     825,   145,   401,   828,   231,   471,   663,   146,   602,   663,
      31,   339,   340,    33,    34,   412,   498,   524,   341,   342,
     343,   344,   757,   527,   528,   533,   807,   687,   294,   295,
     757,   763,   596,   678,   531,   687,    83,   597,   536,   810,
     135,    66,   135,   808,   534,   876,   130,   879,   135,   809,
     135,   779,   537,   936,   810,   938,    66,   538,   775,   776,
     791,   130,   540,   541,   542,   547,   564,   780,   112,   112,
     781,   553,   556,   584,   585,   598,   627,   112,    83,   230,
     112,    66,   605,   494,   495,   603,   130,   496,   497,   821,
     813,   654,   612,    83,   813,   619,   813,   620,   626,   813,
     643,   814,   641,   644,   645,   814,   655,   814,   673,   327,
     814,   649,   810,   651,    66,   652,   653,   691,    83,   130,
     842,   843,   844,   845,   692,   693,   860,   849,   850,   852,
     705,   341,   342,   343,   344,   866,   694,   647,   706,   866,
     856,   707,   866,   357,   135,   866,   713,   721,   361,   362,
     646,    83,   732,   859,   813,   112,    19,    20,    21,   229,
      23,    24,   824,   813,   740,   814,   161,   813,   766,   771,
     813,   772,   774,   813,   814,   773,    31,   782,   814,    33,
      34,   814,   792,   795,   814,   888,   796,   797,   891,   744,
     801,   365,   836,   881,   384,   807,   806,   840,   387,   899,
     846,   847,   678,   112,  -219,  -219,   210,   848,   753,   863,
     864,   112,   808,   874,   112,   112,   886,   887,   809,   892,
     909,   910,   911,   912,   913,   893,   914,   915,   895,   898,
     906,   216,   916,   942,   917,   711,   712,   163,   922,   794,
     933,   924,   935,   549,   941,   943,   112,   112,   112,   112,
     112,   112,   112,   112,   112,   944,   930,   657,   733,   734,
     410,   928,   210,   742,   664,   210,   390,   689,   869,   855,
     197,   112,   112,   112,   112,   112,   112,   112,   112,     0,
       0,   810,     0,    66,   468,   327,   557,     0,   130,     0,
       0,     0,   294,   295,     0,     0,     0,   210,   210,   210,
     210,   210,   390,   210,   210,   390,     0,   341,   342,   343,
     344,     0,     0,     0,     0,   778,     0,     0,     0,     0,
      83,     0,   659,   390,   390,   390,   390,   390,   390,   390,
       0,   827,    19,    20,    21,   229,    23,    24,   798,   799,
       0,   807,   800,     0,   523,     0,     0,     0,   678,   525,
       0,     0,    31,     0,     0,    33,    34,     0,   808,     0,
     532,     0,     0,     0,   809,     0,     0,     0,     0,     0,
       0,     0,     0,   327,   833,   834,     0,   807,   837,   838,
     550,   551,   552,     0,   678,     0,     0,   338,   339,   340,
       0,     0,     0,     0,   808,   341,   342,   343,   344,   208,
     809,   565,   566,   567,     0,     0,     0,     0,     0,     0,
       0,     0,   599,   600,   601,   807,     0,     0,   807,     0,
       0,   230,   678,    66,     0,   678,     0,   810,   231,    66,
       0,     0,   808,     0,   130,   808,     0,     0,   809,   875,
       0,   809,   877,   878,     0,     0,   880,     0,     0,     0,
       0,     0,     0,     0,     0,   208,     0,     0,   208,   389,
      83,     0,     0,   810,     0,    66,    83,     0,     0,     0,
     130,     0,     0,     0,     0,     0,     0,   865,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     208,   208,   208,   208,   208,   389,   208,   208,   389,     0,
       0,   810,    83,    66,   810,     0,    66,     0,   130,     0,
       0,   130,     0,   870,     0,     0,   389,   389,   389,   389,
     389,   389,   389,     0,     0,     0,     0,     0,   622,     0,
       0,   625,     0,   937,   939,     0,     0,     0,     0,     0,
      83,     0,     0,    83,     0,     0,     0,     0,     0,     0,
       0,   871,     0,     0,   872,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   650,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   690,     0,
       0,     0,     0,   695,   696,   697,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,    22,    23,    24,    25,     0,
       0,    26,    27,    28,   736,   -20,    29,    30,     0,     0,
       0,     0,    31,  -218,    32,    33,    34,  -218,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,   770,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,   777,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -158,    67,    68,    69,    70,  -158,
      71,    72,    73,    74,  -218,    75,    76,    77,     0,     0,
    -218,    78,     0,     0,    79,     0,    80,     0,     0,     0,
       0,     0,     0,     0,   831,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,    87,     0,     0,
      88,     0,    89,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   853,   854,     0,     0,     0,
       0,     0,     0,   857,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   191,     0,     0,     0,     3,     0,     0,     0,
     873,     0,     0,     0,     0,   117,     0,     0,     0,    14,
      15,     0,     0,    17,    18,    19,    20,    21,   118,    23,
      24,     0,     0,     0,     0,     0,     0,     0,   -20,     0,
       0,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,   923,     0,     0,   925,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,     0,     0,   931,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,   119,    66,  -158,    67,    68,
      69,   120,  -158,    71,    72,    73,    74,     0,    75,    76,
      77,     0,     0,     0,    78,     0,     0,    79,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,     0,    83,     0,     0,     0,    84,    85,    86,
     121,     0,     0,    88,     0,     1,  -112,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,     0,     0,    26,    27,    28,
       0,   -20,    29,    30,     0,     0,     0,     0,    31,  -218,
      32,    33,    34,  -218,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,     0,    66,
    -158,    67,    68,    69,    70,  -158,    71,    72,    73,    74,
    -218,    75,    76,    77,     0,     0,  -218,    78,     0,     0,
      79,     0,    80,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,    87,     0,     1,    88,     2,    89,     3,
       4,     5,     6,     0,   368,     7,     8,     9,   117,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   118,    23,    24,    25,   369,   370,    26,     0,    28,
       0,   -20,    29,    30,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,     0,    66,
    -158,    67,    68,    69,   134,  -158,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,   135,     0,     1,    88,     2,    89,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   117,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   118,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,  -110,  -110,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,     0,    66,
    -158,    67,    68,    69,   134,  -158,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,   135,     0,     0,    88,  -110,    89,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -106,  -106,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -158,    67,    68,    69,   134,  -158,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -106,    89,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   117,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   118,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -108,  -108,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,     0,    66,  -158,    67,
      68,    69,   134,  -158,    71,    72,    73,    74,     0,    75,
      76,    77,     0,     0,     0,    78,     0,     0,    79,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    81,    82,     0,    83,     0,     0,     0,    84,    85,
      86,   135,     0,     0,    88,  -108,    89,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -109,  -109,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -158,    67,    68,    69,   134,  -158,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -109,
      89,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   117,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   118,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
     -96,   -96,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,     0,    66,  -158,    67,    68,    69,
     134,  -158,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     0,    83,     0,     0,     0,    84,    85,    86,   135,
       0,     0,    88,   -96,    89,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   117,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   118,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,   -94,   -94,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,     0,    66,
    -158,    67,    68,    69,   134,  -158,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,   135,     0,     0,    88,   -94,    89,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,   -92,   -92,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -158,    67,    68,    69,   134,  -158,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,   -92,    89,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   117,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   118,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -102,  -102,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,     0,    66,  -158,    67,
      68,    69,   134,  -158,    71,    72,    73,    74,     0,    75,
      76,    77,     0,     0,     0,    78,     0,     0,    79,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    81,    82,     0,    83,     0,     0,     0,    84,    85,
      86,   135,     0,     0,    88,  -102,    89,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -104,  -104,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -158,    67,    68,    69,   134,  -158,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,  -104,
      89,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   117,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   118,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
    -105,  -105,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,     0,    66,  -158,    67,    68,    69,
     134,  -158,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     0,    83,     0,     0,     0,    84,    85,    86,   135,
       0,     0,    88,  -105,    89,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   117,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   118,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,   -98,   -98,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,     0,    66,
    -158,    67,    68,    69,   134,  -158,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,   135,     0,     0,    88,   -98,    89,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -100,  -100,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -158,    67,    68,    69,   134,  -158,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -100,    89,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   117,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   118,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -107,  -107,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,     0,    66,  -158,    67,
      68,    69,   134,  -158,    71,    72,    73,    74,     0,    75,
      76,    77,     0,     0,     0,    78,     0,     0,    79,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    81,    82,     0,    83,     0,     0,     0,    84,    85,
      86,   135,     0,     0,    88,  -107,    89,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,   -95,   -95,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -158,    67,    68,    69,   134,  -158,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,   -95,
      89,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   117,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   118,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
     -93,   -93,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,     0,    66,  -158,    67,    68,    69,
     134,  -158,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     0,    83,     0,     0,     0,    84,    85,    86,   135,
       0,     0,    88,   -93,    89,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   117,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   118,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,   -91,   -91,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,     0,    66,
    -158,    67,    68,    69,   134,  -158,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,   135,     0,     0,    88,   -91,    89,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -101,  -101,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -158,    67,    68,    69,   134,  -158,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,  -101,    89,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   117,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   118,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -103,  -103,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,     0,    66,  -158,    67,
      68,    69,   134,  -158,    71,    72,    73,    74,     0,    75,
      76,    77,     0,     0,     0,    78,     0,     0,    79,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    81,    82,     0,    83,     0,     0,     0,    84,    85,
      86,   135,     0,     0,    88,  -103,    89,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,   -97,   -97,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -158,    67,    68,    69,   134,  -158,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,   -97,
      89,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   117,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   118,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
     -99,   -99,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,     0,    66,  -158,    67,    68,    69,
     134,  -158,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     0,    83,     0,     0,     0,    84,    85,    86,   135,
       0,     0,    88,   -99,    89,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   117,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   118,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,     0,    66,
    -158,    67,    68,    69,   134,  -158,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,   135,     0,     0,    88,   207,    89,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   117,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   118,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,     0,    66,  -158,    67,    68,    69,   134,  -158,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     0,
      83,     0,     0,     0,    84,    85,    86,   135,     0,     0,
      88,   350,    89,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   117,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   118,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,     0,    66,  -158,    67,
      68,    69,   134,  -158,    71,    72,    73,    74,     0,    75,
      76,    77,     0,     0,     0,    78,     0,     0,    79,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    81,    82,     0,    83,     0,     0,     0,    84,    85,
      86,   135,     0,     0,    88,   388,    89,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     117,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   118,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
       0,    66,  -158,    67,    68,    69,   134,  -158,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     0,    83,     0,
       0,     0,    84,    85,    86,   135,     0,     0,    88,   526,
      89,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   117,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   118,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,     0,    66,  -158,    67,    68,    69,
     134,  -158,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     0,    83,     0,     0,     0,    84,    85,    86,   135,
       0,   191,    88,     0,    89,     3,     0,     0,     0,     0,
       0,     0,     0,     0,   117,     0,     0,     0,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   118,    23,    24,
       0,     0,     0,     0,     0,     0,     0,   -20,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,     0,     0,     0,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,   119,    66,  -158,    67,    68,    69,
     120,  -158,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,     0,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,     0,    83,     0,     3,     0,    84,    85,    86,   121,
       0,     0,    88,   117,  -112,     0,     0,    14,    15,     0,
       0,    17,    18,    19,    20,    21,   118,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,    37,    38,     0,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,    48,    49,    50,    51,     0,     0,     0,    55,    56,
      57,    58,    59,    60,    61,     0,     0,     0,     0,    62,
      63,    64,    65,   119,    66,     0,    67,    68,    69,   120,
       3,    71,    72,    73,    74,     0,    75,    76,    77,   117,
       0,     0,    78,    14,    15,    79,     0,    17,    18,    19,
      20,    21,   118,    23,    24,     0,     0,     0,    81,    82,
       0,    83,   -20,     0,     0,    84,    85,    86,   121,    31,
       0,    88,    33,    34,     0,   608,    35,    36,    37,    38,
       0,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,     0,    48,    49,    50,
      51,     0,     0,     0,    55,    56,    57,    58,    59,    60,
      61,     0,     0,     0,     0,    62,    63,    64,    65,   119,
      66,     0,    67,    68,    69,   120,     3,    71,    72,    73,
      74,     0,    75,    76,    77,   117,     0,     0,    78,    14,
      15,    79,     0,    17,    18,    19,    20,    21,   118,    23,
      24,     0,     0,     0,    81,    82,     0,    83,   -20,     0,
       0,    84,    85,    86,   121,    31,     0,    88,    33,    34,
       0,   615,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,   119,    66,     0,    67,    68,
      69,   120,     3,    71,    72,    73,    74,     0,    75,    76,
      77,   117,     0,     0,    78,    14,    15,    79,     0,    17,
      18,    19,    20,    21,   118,    23,    24,     0,     0,     0,
      81,    82,     0,    83,   -20,     0,     0,    84,    85,    86,
     121,    31,     0,    88,    33,    34,     0,   700,    35,    36,
      37,    38,     0,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,    48,
      49,    50,    51,     0,     0,     0,    55,    56,    57,    58,
      59,    60,    61,     0,     0,     0,     0,    62,    63,    64,
      65,   119,    66,     0,    67,    68,    69,   120,     3,    71,
      72,    73,    74,     0,    75,    76,    77,   117,     0,     0,
      78,    14,    15,    79,     0,    17,    18,    19,    20,    21,
     118,    23,    24,     0,     0,     0,    81,    82,     0,    83,
     -20,     0,     0,    84,    85,    86,   121,    31,     0,    88,
      33,    34,     0,   703,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,     0,
       0,     0,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,   119,    66,     0,
      67,    68,    69,   120,     3,    71,    72,    73,    74,     0,
      75,    76,    77,   117,     0,     0,    78,    14,    15,    79,
       0,    17,    18,    19,    20,    21,   118,    23,    24,     0,
       0,     0,    81,    82,     0,    83,   -20,     0,     0,    84,
      85,    86,   121,    31,     0,    88,    33,    34,   211,     0,
      35,    36,    37,    38,     0,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,    48,    49,    50,    51,     0,     0,     0,    55,    56,
      57,    58,    59,    60,    61,     0,     0,     0,     0,    62,
      63,    64,    65,   119,    66,     0,    67,    68,    69,   120,
       0,    71,    72,    73,    74,     0,    75,    76,    77,     0,
       0,     0,    78,     0,     0,    79,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    81,    82,
       0,    83,     0,     3,     0,    84,    85,    86,   121,     0,
       0,    88,   117,   -86,     0,     0,    14,    15,     0,     0,
      17,    18,    19,    20,    21,   118,    23,    24,     0,     0,
       0,     0,     0,     0,     0,   -20,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,     0,     0,     0,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,   119,    66,     0,    67,    68,    69,   120,     0,
      71,    72,    73,    74,     0,    75,    76,    77,     0,     0,
       0,    78,     0,     0,    79,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,     3,
      83,     0,     0,     0,    84,    85,    86,   121,   117,     0,
      88,   286,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   118,    23,    24,     0,     0,     0,     0,     0,     0,
       0,   -20,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,   119,    66,
       0,    67,    68,    69,   120,     0,    71,    72,    73,    74,
       0,    75,    76,    77,     0,     0,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     3,    83,     0,     0,     0,
      84,    85,    86,   121,   117,     0,    88,   289,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   118,    23,    24,
       0,     0,     0,     0,     0,     0,     0,   -20,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,   783,
       0,   784,   785,     0,     0,     0,   786,   787,    47,     0,
       0,     0,    48,    49,    50,    51,     0,     0,     0,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,   119,    66,     0,    67,    68,    69,
     120,     0,    71,    72,    73,    74,     0,    75,    76,    77,
       0,     0,     0,    78,   788,     0,    79,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   789,   790,    81,
      82,     3,    83,     0,     0,     0,    84,    85,    86,   121,
     117,     0,    88,     0,    14,    15,     0,     0,    17,    18,
      19,    20,    21,   118,    23,    24,     0,     0,     0,     0,
       0,     0,     0,   -20,     0,     0,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
     119,    66,  -158,    67,    68,    69,   120,  -158,    71,    72,
      73,    74,     0,    75,    76,    77,     0,     0,     0,    78,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    81,    82,     3,    83,     0,
       0,     0,    84,    85,    86,   121,   117,     0,    88,     0,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   118,
      23,    24,     0,     0,     0,     0,     0,     0,     0,   -20,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,     0,     0,
       0,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,   465,    62,    63,    64,    65,   119,    66,     0,    67,
      68,    69,   120,     3,    71,    72,    73,    74,     0,    75,
      76,    77,   117,     0,     0,    78,    14,    15,    79,     0,
      17,    18,    19,    20,    21,   118,    23,    24,     0,     0,
       0,    81,    82,     0,    83,   -20,     0,     0,    84,    85,
      86,   121,    31,     0,    88,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,     0,     0,     0,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,   520,    62,    63,
      64,    65,   119,    66,     0,    67,    68,    69,   120,     3,
      71,    72,    73,    74,     0,    75,    76,    77,   117,     0,
       0,    78,    14,    15,    79,     0,    17,    18,    19,    20,
      21,   118,    23,    24,     0,     0,     0,    81,    82,     0,
      83,   -20,     0,     0,    84,    85,    86,   121,    31,     0,
      88,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,   119,    66,
       0,    67,    68,    69,   120,   630,    71,    72,    73,    74,
       0,    75,    76,    77,   294,   295,     0,    78,     0,     0,
      79,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    81,    82,     0,    83,     0,     0,     0,
      84,    85,    86,   121,     0,     0,    88,   320,   321,   322,
       0,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,     0,     0,     0,     0,     0,     0,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,   320,   321,   322,     0,     0,     0,
       0,     0,     0,     0,     0,   327,     0,     0,     0,     0,
       0,   323,   324,   325,   326,     0,     0,   336,   337,   338,
     339,   340,     0,     0,     0,     0,     0,   341,   342,   343,
     344,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   327,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,     0,
       0,     0,     0,     0,   341,   342,   343,   344,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,     0,     0,     0,     0,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,   320,   321,   322,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   323,   324,
     325,   326,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   327,
       0,     0,   328,   329,   330,     0,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,     0,     0,     0,     0,
       0,   341,   342,   343,   344,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,     0,     0,     0,
       0,     0,     0,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,   320,   321,
     322,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   323,   324,   325,   326,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   327,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,     0,     0,     0,     0,     0,   341,   342,
     343,   344,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,     0,     0,     0,     0,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,     0,   320,   321,   322,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   323,   324,   325,   610,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   327,     0,     0,   328,   329,   330,     0,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
       0,     0,     0,     0,     0,   341,   342,   343,   344,     0,
       0,     0,   611,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,     0,     0,     0,     0,     0,
       0,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,   320,   321,   322,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   323,   324,   325,   617,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   327,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,     0,     0,     0,     0,     0,   341,   342,   343,   344,
       0,     0,     0,   618,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,     0,     0,
       0,     0,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,     0,   320,   321,   322,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   323,   324,   325,   326,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   327,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,     0,     0,     0,     0,     0,   341,   342,   343,
     344,     0,     0,     0,   699,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,     0,     0,     0,
       0,     0,     0,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,   320,   321,
     322,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   323,   324,   325,   326,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   327,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,     0,     0,     0,     0,     0,   341,   342,
     343,   344,     0,     0,     0,   702,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,   393,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   394,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   529,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   530,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   546,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   554,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   555,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   634,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   640,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   704,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   714,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   718,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   719,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   720,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   841,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,     0,   882,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,     0,     0,
       0,     0,     0,     0,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,     0,   260,
     261,   262,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   263,   264,   265,   266,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   267,     0,     0,
     268,   269,   270,     0,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,     0,     0,     0,     0,     0,   281,
     282,   283,   284,     0,   285,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,     0,     0,     0,
       0,     0,     0,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,   320,   321,
     322,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   323,   324,   325,   326,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   327,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,     0,     0,     0,     0,     0,   341,   342,
     343,   344,     0,   354,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,     0,     0,
       0,     0,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,     0,   320,   321,   322,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   323,   324,   325,   326,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   327,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,     0,     0,     0,     0,     0,   341,   342,   343,
     344,     0,   638,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,     0,     0,     0,     0,     0,
       0,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,   320,   321,   322,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   323,   324,   325,   326,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   327,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,     0,     0,     0,     0,     0,   341,   342,   343,   344,
       0,   639,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,     0,     0,     0,     0,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,     0,   320,   321,   322,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   323,   324,   325,   326,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   327,     0,     0,   328,   329,   330,     0,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
       0,     0,     0,     0,     0,   341,   342,   343,   344,     0,
     715,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,     0,     0,     0,     0,     0,     0,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,   320,   321,   322,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   323,   324,   325,   326,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   327,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,     0,
       0,     0,     0,     0,   341,   342,   343,   344,     0,   716,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,     0,     0,     0,     0,     0,     0,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,     0,   320,   321,   322,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     323,   324,   325,   326,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   327,     0,     0,   328,   329,   330,     0,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,     0,     0,
       0,     0,     0,   341,   342,   343,   344,     0,   726,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,     0,     0,     0,     0,     0,     0,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,   320,   321,   322,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   323,
     324,   325,   326,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     327,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,     0,     0,     0,
       0,     0,   341,   342,   343,   344,     0,   894,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,     0,     0,     0,     0,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,   320,   321,   322,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   323,   324,
     325,   326,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   327,
       0,     0,   328,   329,   330,     0,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,     0,     0,     0,     0,
       0,   341,   342,   343,   344,     0,   921,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,     0,
       0,     0,     0,     0,     0,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
     320,   321,   322,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   323,   324,   325,
     326,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   327,     0,
       0,   328,   329,   330,     0,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,     0,     0,     0,     0,     0,
     341,   342,   343,   344,     0,   929,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,     0,   932,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,     0,     0,     0,
       0,     0,     0,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,   320,   321,
     322,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   323,   324,   325,   326,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   327,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,     0,     0,     0,     0,     0,   341,   342,
     343,   344,     0,   934,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,     0,     0,
       0,     0,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,     0,   320,   321,   322,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   323,   324,   325,   326,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   327,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,     0,     0,     0,     0,     0,   341,   342,   343,
     344,     0,   940,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,     0,     0,     0,     0,     0,
       0,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,   320,   321,   322,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   323,   324,   325,   326,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   327,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,     0,     0,     0,     0,     0,   341,   342,   343,   344,
     607,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,     0,     0,     0,     0,     0,     0,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,   320,   321,   322,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   323,   324,   325,   326,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   327,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,     0,
       0,     0,     0,     0,   341,   342,   343,   344,   614,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,     0,     0,     0,     0,     0,     0,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,   320,   321,   322,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   323,
     324,   325,   326,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     327,     0,     0,   328,   329,   330,   393,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,     0,     0,     0,
       0,     0,   341,   342,   343,   344,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,     0,     0,
       0,     0,     0,     0,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,     0,   320,
     321,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   323,   324,   325,   326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
     328,   329,   330,   606,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,     0,     0,     0,     0,     0,
       0,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,   320,   321,   322,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   323,   324,   325,   326,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   327,     0,     0,   328,   329,   330,
     613,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,     0,     0,     0,     0,     0,   341,   342,   343,   344,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,     0,     0,     0,     0,     0,     0,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,     0,   320,   321,   322,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     323,   324,   325,   326,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   327,     0,     0,   328,   329,   330,   851,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,     0,     0,
       0,     0,     0,   341,   342,   343,   344,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,     0,
       0,     0,     0,     0,     0,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
     320,   321,   322,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   323,   324,   325,
     326,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   327,     0,
       0,   328,   329,   330,   883,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,     0,     0,     0,     0,     0,
     341,   342,   343,   344,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,     0,     0,     0,     0,
       0,     0,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,     0,   320,   321,   322,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   323,   324,   325,   326,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   327,     0,     0,   328,   329,
     330,   884,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,     0,     0,     0,     0,     0,   341,   342,   343,
     344,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,     0,     0,     0,     0,     0,     0,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,   320,   321,   322,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   323,   324,   325,   326,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   327,     0,     0,   328,   329,   330,   885,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,     0,
       0,     0,     0,     0,   341,   342,   343,   344,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
       0,     0,     0,     0,     0,     0,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,   320,   321,   322,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   323,   324,
     325,   326,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   327,
       0,     0,   328,   329,   330,   889,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,     0,     0,     0,     0,
       0,   341,   342,   343,   344,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,     0,     0,     0,
       0,     0,     0,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,   320,   321,
     322,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   323,   324,   325,   326,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   327,     0,     0,   328,
     329,   330,   890,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,     0,     0,     0,     0,     0,   341,   342,
     343,   344,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,     0,     0,     0,     0,     0,     0,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,     0,   320,   321,   322,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   323,   324,   325,   326,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   327,     0,     0,   328,   329,   330,     0,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
       0,     0,     0,     0,     0,   341,   342,   343,   344,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,     0,     0,     0,     0,     0,     0,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,   320,   321,   322,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   323,
     324,   325,   326,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     327,     0,     0,     0,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   294,   295,     0,
       0,     0,   341,   342,   343,   344,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
     320,   321,   322,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   323,   324,     0,
     326,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   327,     0,
       0,     0,     0,   330,     0,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   294,   295,     0,     0,     0,
     341,   342,   343,   344,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,   320,   321,
     322,   294,   295,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   323,   324,     0,  -219,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,   320,   321,   322,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   327,     0,     0,     0,
       0,   323,   324,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,     0,     0,     0,     0,     0,   341,   342,
     343,   344,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   327,     0,     0,     0,     0,     0,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   294,
     295,     0,     0,     0,   341,   342,   343,   344,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   306,     0,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,   320,   321,   322,   294,   295,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,   320,   321,
     322,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     327,     0,     0,     0,     0,     0,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,     0,     0,     0,
       0,     0,   341,   342,   343,   344,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   327,     0,     0,     0,
       0,   294,   295,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,     0,     0,     0,     0,     0,   341,   342,
     343,   344,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,   320,   321,   322,   294,   295,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
     320,   321,   322,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   327,     0,     0,     0,   294,   295,     0,     0,
     332,   333,   334,   335,   336,   337,   338,   339,   340,     0,
       0,     0,     0,     0,   341,   342,   343,   344,     0,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   327,   320,
     321,   322,     0,     0,     0,     0,     0,   333,   334,   335,
     336,   337,   338,   339,   340,     0,     0,     0,     0,     0,
     341,   342,   343,   344,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   334,   335,   336,
     337,   338,   339,   340,     0,     0,     0,     0,     0,   341,
     342,   343,   344
};

static const yytype_int16 yycheck[] =
{
       2,     0,   219,   404,     6,     0,     0,   404,     3,   634,
     404,   228,   404,    15,    16,    17,    18,   404,     5,     3,
     131,   404,   404,     0,    14,    50,   404,     4,     5,    40,
      41,    14,   107,    50,    14,    50,    14,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,   123,    51,
      50,    14,   113,    55,    56,    57,    58,    59,    60,   164,
      14,    14,   140,   162,   653,    52,    53,    54,    14,   162,
     140,    14,    34,   140,     0,    52,    53,    54,   743,    81,
      82,   681,    84,    85,    86,    93,    88,   165,    50,   689,
     140,    90,    27,   118,   164,    90,    90,   164,   140,    34,
     140,   118,   163,   118,   693,   113,   143,    56,    57,    44,
      87,   119,   107,    90,   164,    50,   162,   119,   118,   121,
     594,   163,   596,   113,   164,   164,   116,   164,   123,   131,
     120,   121,   135,   113,   159,   113,   116,   120,   116,   141,
     142,   121,   159,   121,   159,    24,    25,    26,    27,    28,
      29,   119,   163,   121,   819,    34,   118,   120,   135,   113,
     113,    87,   116,   165,    90,    44,   120,   121,    47,    48,
     113,   164,   573,   160,   120,   164,   573,   120,   113,   573,
     115,   573,   162,   160,   773,   120,   573,   116,   137,   113,
     573,   573,   121,   195,   196,   573,   120,   159,   415,    93,
     149,   150,   151,   152,   153,   113,   140,   681,   162,   135,
     159,   160,   161,   162,   164,   689,   128,   152,   162,   113,
     818,   115,   217,   681,   822,   119,   120,   825,   163,   163,
     828,   689,   209,   217,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   534,   882,   152,   261,
     262,   263,   264,   265,   266,   260,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   159,   209,   163,   874,   397,    24,    25,    26,
      27,    40,    41,   141,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   164,   906,   162,   321,
     322,   323,   324,   325,   326,   320,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,    93,   162,   162,   113,   113,   115,   626,   113,
     681,    45,   120,   120,    87,    49,   120,   113,   689,   115,
      34,   363,   113,    37,   120,   367,    93,    14,   119,   120,
     648,   373,   374,   375,   351,    37,   113,    24,    25,    26,
      27,    28,    29,   120,   152,   113,   113,    34,   116,   391,
      37,   393,   119,   120,   162,   397,   152,    44,   141,   141,
      47,    48,   135,   661,   681,   404,   664,   163,   113,   404,
     404,   162,   689,   691,   692,   120,    14,    93,   159,   162,
     162,   164,   164,   164,   141,   351,    24,    25,    26,    27,
      28,    29,   126,   113,   164,   162,    34,   113,   132,    37,
     120,   658,   659,   119,   120,   162,    44,   164,   141,    47,
      48,   675,   676,   677,    24,    25,    26,    27,    28,    29,
     113,   162,   115,   465,    34,   116,   113,   120,   115,   686,
     121,   164,    93,   120,    44,    93,   209,    47,    48,    37,
      24,    25,    26,    27,    28,    29,   162,   113,   766,   115,
      34,   769,   113,   113,   120,   113,     9,   116,   119,   120,
      44,   119,   120,    47,    48,   152,   581,    11,   162,    24,
      25,    26,    27,    28,    29,   113,   163,   115,   520,    34,
     737,   113,   120,   115,   113,   527,   152,   162,   120,    44,
     162,   120,    47,    48,   536,   537,   538,   163,   540,   541,
     542,   162,   529,   530,   141,   547,   763,   162,   113,   113,
     115,   115,   529,   530,   152,   120,   120,   113,    14,   115,
     152,   141,   130,   131,   120,   163,   134,   135,    24,    25,
      26,    27,    28,    29,   573,    56,    57,   162,   573,   573,
     159,   141,   162,    93,   164,   164,   581,   152,    44,   584,
     585,    47,    48,   163,   113,   594,   152,   596,   165,   113,
     594,   120,   596,   113,   606,   162,   162,    93,   610,   119,
     120,   613,   687,    27,   113,   617,   113,   116,   351,   163,
      34,   120,   121,   120,   113,   162,   162,   113,    27,   907,
      44,   120,   627,   119,   120,    34,    50,   162,    42,   113,
      14,    93,   116,   627,   162,    44,   120,   121,   163,   134,
      24,    25,    26,    27,    28,    29,   137,   113,   749,   115,
     751,   113,   162,   754,   120,    14,   661,   119,   120,   664,
      44,   152,   153,    47,    48,   162,   134,   165,   159,   160,
     161,   162,   681,   162,   162,   165,    27,   681,    56,    57,
     689,   686,   159,    34,   164,   689,   152,   164,   162,   113,
     159,   115,   159,    44,   165,   164,   120,   164,   159,    50,
     159,   713,   141,   164,   113,   164,   115,   141,   705,   706,
     722,   120,   162,   162,   162,   141,   162,   714,   705,   706,
     717,   165,   165,   159,   159,   162,     4,   714,   152,   113,
     717,   115,   162,   130,   131,   162,   120,   134,   135,   163,
     745,   162,   165,   152,   749,   165,   751,   165,   165,   754,
     165,   745,   159,   165,   165,   749,   164,   751,   140,   137,
     754,   165,   113,   165,   115,   165,   165,   165,   152,   120,
     782,   783,   784,   785,   165,   165,   809,   789,   790,   792,
     165,   159,   160,   161,   162,   818,   162,   164,    43,   822,
     802,   164,   825,   143,   159,   828,   162,    36,   148,   149,
     143,   152,   165,   808,   809,   792,    24,    25,    26,    27,
      28,    29,   163,   818,   113,   809,   113,   822,   165,   165,
     825,   165,   164,   828,   818,   165,    44,   162,   822,    47,
      48,   825,   143,   162,   828,   848,   162,   140,   851,   118,
     165,   113,   165,   840,   194,    27,   120,   165,   198,   861,
     134,   134,    34,   840,    56,    57,   792,   143,    34,   113,
     118,   848,    44,   165,   851,   852,   143,   143,    50,   165,
     883,   884,   885,   886,   887,   165,   889,   890,   165,   113,
     165,    90,   164,   164,   896,   628,   629,    28,   900,   724,
     165,   903,   165,   378,   165,   164,   883,   884,   885,   886,
     887,   888,   889,   890,   891,   164,   918,   573,   651,   652,
     227,   908,   848,   673,   585,   851,   852,   596,   819,   797,
      76,   908,   909,   910,   911,   912,   913,   914,   915,    -1,
      -1,   113,    -1,   115,   284,   137,   391,    -1,   120,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,   883,   884,   885,
     886,   887,   888,   889,   890,   891,    -1,   159,   160,   161,
     162,    -1,    -1,    -1,    -1,   708,    -1,    -1,    -1,    -1,
     152,    -1,    14,   909,   910,   911,   912,   913,   914,   915,
      -1,   163,    24,    25,    26,    27,    28,    29,   731,   732,
      -1,    27,   735,    -1,   344,    -1,    -1,    -1,    34,   349,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    44,    -1,
     360,    -1,    -1,    -1,    50,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,   767,   768,    -1,    27,   771,   772,
     380,   381,   382,    -1,    34,    -1,    -1,   151,   152,   153,
      -1,    -1,    -1,    -1,    44,   159,   160,   161,   162,   792,
      50,   401,   402,   403,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   412,   413,   414,    27,    -1,    -1,    27,    -1,
      -1,   113,    34,   115,    -1,    34,    -1,   113,   120,   115,
      -1,    -1,    44,    -1,   120,    44,    -1,    -1,    50,   832,
      -1,    50,   835,   836,    -1,    -1,   839,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   848,    -1,    -1,   851,   852,
     152,    -1,    -1,   113,    -1,   115,   152,    -1,    -1,    -1,
     120,    -1,    -1,    -1,    -1,    -1,    -1,   163,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     883,   884,   885,   886,   887,   888,   889,   890,   891,    -1,
      -1,   113,   152,   115,   113,    -1,   115,    -1,   120,    -1,
      -1,   120,    -1,   163,    -1,    -1,   909,   910,   911,   912,
     913,   914,   915,    -1,    -1,    -1,    -1,    -1,   528,    -1,
      -1,   531,    -1,   926,   927,    -1,    -1,    -1,    -1,    -1,
     152,    -1,    -1,   152,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   163,    -1,    -1,   163,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   564,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   598,    -1,
      -1,    -1,    -1,   603,   604,   605,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     0,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    34,    35,   654,    37,    38,    39,    -1,    -1,
      -1,    -1,    44,    45,    46,    47,    48,    49,    -1,    51,
      52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    -1,    -1,   694,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    88,   707,    -1,    -1,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,    -1,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,    -1,    -1,
     132,   133,    -1,    -1,   136,    -1,   138,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   764,    -1,    -1,   149,   150,    -1,
     152,    -1,    -1,    -1,   156,   157,   158,   159,    -1,    -1,
     162,    -1,   164,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   795,   796,    -1,    -1,    -1,
      -1,    -1,    -1,   803,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     1,    -1,    -1,    -1,     5,    -1,    -1,    -1,
     830,    -1,    -1,    -1,    -1,    14,    -1,    -1,    -1,    18,
      19,    -1,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      69,    70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,
      -1,   901,    -1,    -1,   904,    -1,    -1,    -1,    -1,    88,
      -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,   919,
      99,   100,   101,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,    -1,   127,   128,
     129,    -1,    -1,    -1,   133,    -1,    -1,   136,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     149,   150,    -1,   152,    -1,    -1,    -1,   156,   157,   158,
     159,    -1,    -1,   162,    -1,     1,   165,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    34,    35,
      -1,    37,    38,    39,    -1,    -1,    -1,    -1,    44,    45,
      46,    47,    48,    49,    -1,    51,    52,    53,    54,    -1,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,    -1,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,    -1,    -1,   132,   133,    -1,    -1,
     136,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,    -1,   152,    -1,    -1,    -1,
     156,   157,   158,   159,    -1,     1,   162,     3,   164,     5,
       6,     7,     8,    -1,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    -1,    -1,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,    -1,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
      -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,    -1,   152,    -1,    -1,    -1,
     156,   157,   158,   159,    -1,     1,   162,     3,   164,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,    -1,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
      -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,    -1,   152,    -1,    -1,    -1,
     156,   157,   158,   159,    -1,    -1,   162,   163,   164,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,    -1,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,    -1,   127,   128,   129,    -1,    -1,
      -1,   133,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,
     152,    -1,    -1,    -1,   156,   157,   158,   159,    -1,    -1,
     162,   163,   164,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    69,    70,    71,    72,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    -1,    -1,    -1,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,   110,   111,   112,   113,    -1,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,    -1,   127,
     128,   129,    -1,    -1,    -1,   133,    -1,    -1,   136,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,    -1,   152,    -1,    -1,    -1,   156,   157,
     158,   159,    -1,    -1,   162,   163,   164,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,    73,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,
      -1,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,    -1,   127,   128,   129,    -1,    -1,    -1,   133,
      -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,    -1,   152,    -1,
      -1,    -1,   156,   157,   158,   159,    -1,    -1,   162,   163,
     164,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,
      -1,    -1,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,    -1,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,    -1,   127,   128,   129,
      -1,    -1,    -1,   133,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,   152,    -1,    -1,    -1,   156,   157,   158,   159,
      -1,    -1,   162,   163,   164,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,    -1,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
      -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,    -1,   152,    -1,    -1,    -1,
     156,   157,   158,   159,    -1,    -1,   162,   163,   164,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,    -1,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,    -1,   127,   128,   129,    -1,    -1,
      -1,   133,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,
     152,    -1,    -1,    -1,   156,   157,   158,   159,    -1,    -1,
     162,   163,   164,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    69,    70,    71,    72,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    -1,    -1,    -1,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,   110,   111,   112,   113,    -1,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,    -1,   127,
     128,   129,    -1,    -1,    -1,   133,    -1,    -1,   136,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,    -1,   152,    -1,    -1,    -1,   156,   157,
     158,   159,    -1,    -1,   162,   163,   164,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,    73,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,
      -1,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,    -1,   127,   128,   129,    -1,    -1,    -1,   133,
      -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,    -1,   152,    -1,
      -1,    -1,   156,   157,   158,   159,    -1,    -1,   162,   163,
     164,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,
      -1,    -1,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,    -1,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,    -1,   127,   128,   129,
      -1,    -1,    -1,   133,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,   152,    -1,    -1,    -1,   156,   157,   158,   159,
      -1,    -1,   162,   163,   164,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,    -1,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
      -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,    -1,   152,    -1,    -1,    -1,
     156,   157,   158,   159,    -1,    -1,   162,   163,   164,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,    -1,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,    -1,   127,   128,   129,    -1,    -1,
      -1,   133,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,
     152,    -1,    -1,    -1,   156,   157,   158,   159,    -1,    -1,
     162,   163,   164,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    69,    70,    71,    72,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    -1,    -1,    -1,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,   110,   111,   112,   113,    -1,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,    -1,   127,
     128,   129,    -1,    -1,    -1,   133,    -1,    -1,   136,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,    -1,   152,    -1,    -1,    -1,   156,   157,
     158,   159,    -1,    -1,   162,   163,   164,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,    73,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,
      -1,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,    -1,   127,   128,   129,    -1,    -1,    -1,   133,
      -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,    -1,   152,    -1,
      -1,    -1,   156,   157,   158,   159,    -1,    -1,   162,   163,
     164,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,
      -1,    -1,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,    -1,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,    -1,   127,   128,   129,
      -1,    -1,    -1,   133,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,   152,    -1,    -1,    -1,   156,   157,   158,   159,
      -1,    -1,   162,   163,   164,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,    -1,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
      -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,    -1,   152,    -1,    -1,    -1,
     156,   157,   158,   159,    -1,    -1,   162,   163,   164,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,    -1,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,    -1,   127,   128,   129,    -1,    -1,
      -1,   133,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,
     152,    -1,    -1,    -1,   156,   157,   158,   159,    -1,    -1,
     162,   163,   164,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    69,    70,    71,    72,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    -1,    -1,    -1,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,   110,   111,   112,   113,    -1,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,    -1,   127,
     128,   129,    -1,    -1,    -1,   133,    -1,    -1,   136,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,    -1,   152,    -1,    -1,    -1,   156,   157,
     158,   159,    -1,    -1,   162,   163,   164,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,    73,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,
      -1,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,    -1,   127,   128,   129,    -1,    -1,    -1,   133,
      -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,    -1,   152,    -1,
      -1,    -1,   156,   157,   158,   159,    -1,    -1,   162,   163,
     164,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,
      -1,    -1,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,    -1,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,    -1,   127,   128,   129,
      -1,    -1,    -1,   133,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,   152,    -1,    -1,    -1,   156,   157,   158,   159,
      -1,    -1,   162,   163,   164,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    -1,    -1,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,    -1,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
      -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,    -1,   152,    -1,    -1,    -1,
     156,   157,   158,   159,    -1,    -1,   162,   163,   164,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,    -1,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,    -1,   127,   128,   129,    -1,    -1,
      -1,   133,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,
     152,    -1,    -1,    -1,   156,   157,   158,   159,    -1,    -1,
     162,   163,   164,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    69,    70,    71,    72,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    -1,    -1,    -1,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,   110,   111,   112,   113,    -1,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,    -1,   127,
     128,   129,    -1,    -1,    -1,   133,    -1,    -1,   136,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,    -1,   152,    -1,    -1,    -1,   156,   157,
     158,   159,    -1,    -1,   162,   163,   164,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,    73,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,
      -1,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,    -1,   127,   128,   129,    -1,    -1,    -1,   133,
      -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,    -1,   152,    -1,
      -1,    -1,   156,   157,   158,   159,    -1,    -1,   162,   163,
     164,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,
      -1,    -1,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,    -1,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,    -1,   127,   128,   129,
      -1,    -1,    -1,   133,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,   152,    -1,    -1,    -1,   156,   157,   158,   159,
      -1,     1,   162,    -1,   164,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    14,    -1,    -1,    -1,    18,    19,
      -1,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,
      -1,    -1,    92,    93,    94,    95,    -1,    -1,    -1,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,    -1,   127,   128,   129,
      -1,    -1,    -1,   133,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,   152,    -1,     5,    -1,   156,   157,   158,   159,
      -1,    -1,   162,    14,   164,    -1,    -1,    18,    19,    -1,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      51,    52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,
      71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,
      -1,    92,    93,    94,    95,    -1,    -1,    -1,    99,   100,
     101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,    -1,   117,   118,   119,   120,
       5,   122,   123,   124,   125,    -1,   127,   128,   129,    14,
      -1,    -1,   133,    18,    19,   136,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,   149,   150,
      -1,   152,    37,    -1,    -1,   156,   157,   158,   159,    44,
      -1,   162,    47,    48,    -1,   166,    51,    52,    53,    54,
      -1,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    69,    70,    71,    72,    73,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,
      95,    -1,    -1,    -1,    99,   100,   101,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,
     115,    -1,   117,   118,   119,   120,     5,   122,   123,   124,
     125,    -1,   127,   128,   129,    14,    -1,    -1,   133,    18,
      19,   136,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    -1,    -1,    -1,   149,   150,    -1,   152,    37,    -1,
      -1,   156,   157,   158,   159,    44,    -1,   162,    47,    48,
      -1,   166,    51,    52,    53,    54,    -1,    56,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      69,    70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,
      -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,    -1,
      99,   100,   101,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,   110,   111,   112,   113,   114,   115,    -1,   117,   118,
     119,   120,     5,   122,   123,   124,   125,    -1,   127,   128,
     129,    14,    -1,    -1,   133,    18,    19,   136,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    -1,    -1,    -1,
     149,   150,    -1,   152,    37,    -1,    -1,   156,   157,   158,
     159,    44,    -1,   162,    47,    48,    -1,   166,    51,    52,
      53,    54,    -1,    56,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,
      73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,
      93,    94,    95,    -1,    -1,    -1,    99,   100,   101,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,
     113,   114,   115,    -1,   117,   118,   119,   120,     5,   122,
     123,   124,   125,    -1,   127,   128,   129,    14,    -1,    -1,
     133,    18,    19,   136,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    -1,    -1,    -1,   149,   150,    -1,   152,
      37,    -1,    -1,   156,   157,   158,   159,    44,    -1,   162,
      47,    48,    -1,   166,    51,    52,    53,    54,    -1,    56,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    69,    70,    71,    72,    73,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,    -1,
      -1,    -1,    99,   100,   101,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,   110,   111,   112,   113,   114,   115,    -1,
     117,   118,   119,   120,     5,   122,   123,   124,   125,    -1,
     127,   128,   129,    14,    -1,    -1,   133,    18,    19,   136,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,   149,   150,    -1,   152,    37,    -1,    -1,   156,
     157,   158,   159,    44,    -1,   162,    47,    48,   165,    -1,
      51,    52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,
      71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,
      -1,    92,    93,    94,    95,    -1,    -1,    -1,    99,   100,
     101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,    -1,   117,   118,   119,   120,
      -1,   122,   123,   124,   125,    -1,   127,   128,   129,    -1,
      -1,    -1,   133,    -1,    -1,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,
      -1,   152,    -1,     5,    -1,   156,   157,   158,   159,    -1,
      -1,   162,    14,   164,    -1,    -1,    18,    19,    -1,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,
      92,    93,    94,    95,    -1,    -1,    -1,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,   114,   115,    -1,   117,   118,   119,   120,    -1,
     122,   123,   124,   125,    -1,   127,   128,   129,    -1,    -1,
      -1,   133,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,     5,
     152,    -1,    -1,    -1,   156,   157,   158,   159,    14,    -1,
     162,   163,    18,    19,    -1,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,
      -1,    -1,    -1,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,   115,
      -1,   117,   118,   119,   120,    -1,   122,   123,   124,   125,
      -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,     5,   152,    -1,    -1,    -1,
     156,   157,   158,   159,    14,    -1,   162,   163,    18,    19,
      -1,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    -1,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,    79,
      -1,    81,    82,    -1,    -1,    -1,    86,    87,    88,    -1,
      -1,    -1,    92,    93,    94,    95,    -1,    -1,    -1,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,   114,   115,    -1,   117,   118,   119,
     120,    -1,   122,   123,   124,   125,    -1,   127,   128,   129,
      -1,    -1,    -1,   133,   134,    -1,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,     5,   152,    -1,    -1,    -1,   156,   157,   158,   159,
      14,    -1,   162,    -1,    18,    19,    -1,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,    73,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    93,
      94,    95,    -1,    -1,    -1,    99,   100,   101,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,    -1,   127,   128,   129,    -1,    -1,    -1,   133,
      -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,     5,   152,    -1,
      -1,    -1,   156,   157,   158,   159,    14,    -1,   162,    -1,
      18,    19,    -1,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    69,    70,    71,    72,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,
      -1,    99,   100,   101,   102,   103,   104,   105,    -1,    -1,
      -1,   109,   110,   111,   112,   113,   114,   115,    -1,   117,
     118,   119,   120,     5,   122,   123,   124,   125,    -1,   127,
     128,   129,    14,    -1,    -1,   133,    18,    19,   136,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    -1,
      -1,   149,   150,    -1,   152,    37,    -1,    -1,   156,   157,
     158,   159,    44,    -1,   162,    47,    48,    -1,    -1,    51,
      52,    53,    54,    -1,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,
      92,    93,    94,    95,    -1,    -1,    -1,    99,   100,   101,
     102,   103,   104,   105,    -1,    -1,    -1,   109,   110,   111,
     112,   113,   114,   115,    -1,   117,   118,   119,   120,     5,
     122,   123,   124,   125,    -1,   127,   128,   129,    14,    -1,
      -1,   133,    18,    19,   136,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    -1,    -1,    -1,   149,   150,    -1,
     152,    37,    -1,    -1,   156,   157,   158,   159,    44,    -1,
     162,    47,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    92,    93,    94,    95,
      -1,    -1,    -1,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,   115,
      -1,   117,   118,   119,   120,    10,   122,   123,   124,   125,
      -1,   127,   128,   129,    56,    57,    -1,   133,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,    -1,   152,    -1,    -1,    -1,
     156,   157,   158,   159,    -1,    -1,   162,    89,    90,    91,
      -1,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    89,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,   106,   107,   108,   109,    -1,    -1,   149,   150,   151,
     152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,   161,
     162,    -1,    -1,    21,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   137,    -1,    -1,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,    -1,
      -1,    -1,    -1,    -1,   159,   160,   161,   162,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      -1,    -1,    -1,    -1,    -1,    -1,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    89,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      21,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
      -1,    -1,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,    -1,    -1,    -1,    -1,
      -1,   159,   160,   161,   162,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    89,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,
     161,   162,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    89,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,    -1,    -1,   140,   141,   142,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
      -1,    -1,    -1,    -1,    -1,   159,   160,   161,   162,    -1,
      -1,    -1,   166,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,
      -1,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    89,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   137,    -1,    -1,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,    -1,    -1,    -1,    -1,   159,   160,   161,   162,
      -1,    -1,    -1,   166,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    -1,    -1,    -1,    -1,
      -1,    -1,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    89,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,   141,
     142,    -1,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,   161,
     162,    -1,    -1,    -1,   166,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    89,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,
     161,   162,    -1,    -1,    -1,   166,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,    -1,   165,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,   164,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    89,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,
     161,   162,    -1,   164,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    -1,    -1,    -1,    -1,
      -1,    -1,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    89,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,   141,
     142,    -1,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,   161,
     162,    -1,   164,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,
      -1,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    89,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   137,    -1,    -1,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,    -1,    -1,    -1,    -1,   159,   160,   161,   162,
      -1,   164,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    89,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,    -1,    -1,   140,   141,   142,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
      -1,    -1,    -1,    -1,    -1,   159,   160,   161,   162,    -1,
     164,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    89,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   106,   107,   108,   109,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   137,    -1,    -1,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,    -1,
      -1,    -1,    -1,    -1,   159,   160,   161,   162,    -1,   164,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    89,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   137,    -1,    -1,   140,   141,   142,    -1,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,    -1,    -1,
      -1,    -1,    -1,   159,   160,   161,   162,    -1,   164,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    -1,    -1,    -1,    -1,    -1,    -1,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    89,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,
     107,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     137,    -1,    -1,   140,   141,   142,    -1,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,    -1,    -1,    -1,
      -1,    -1,   159,   160,   161,   162,    -1,   164,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      -1,    -1,    -1,    -1,    -1,    -1,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    89,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
      -1,    -1,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,    -1,    -1,    -1,    -1,
      -1,   159,   160,   161,   162,    -1,   164,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    -1,
      -1,    -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      89,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,
     109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,
      -1,   140,   141,   142,    -1,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,
     159,   160,   161,   162,    -1,   164,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    -1,   164,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    89,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,
     141,   142,    -1,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,
     161,   162,    -1,   164,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    -1,    -1,    -1,    -1,
      -1,    -1,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    89,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,   141,
     142,    -1,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,   161,
     162,    -1,   164,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,
      -1,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    89,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   137,    -1,    -1,   140,   141,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,    -1,    -1,    -1,    -1,   159,   160,   161,   162,
     163,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    89,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   106,   107,   108,   109,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   137,    -1,    -1,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,    -1,
      -1,    -1,    -1,    -1,   159,   160,   161,   162,   163,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    -1,    -1,    -1,    -1,    -1,    -1,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    89,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,
     107,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     137,    -1,    -1,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,    -1,    -1,    -1,
      -1,    -1,   159,   160,   161,   162,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,
      -1,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    89,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   137,    -1,    -1,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,    -1,    -1,    -1,    -1,   159,   160,   161,   162,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    89,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   137,    -1,    -1,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,    -1,    -1,
      -1,    -1,    -1,   159,   160,   161,   162,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    -1,
      -1,    -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      89,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,
     109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,
      -1,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,
     159,   160,   161,   162,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    -1,    -1,    -1,    -1,
      -1,    -1,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    89,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,   161,
     162,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    89,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   106,   107,   108,   109,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   137,    -1,    -1,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,    -1,
      -1,    -1,    -1,    -1,   159,   160,   161,   162,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      -1,    -1,    -1,    -1,    -1,    -1,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    89,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
      -1,    -1,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,    -1,    -1,    -1,    -1,
      -1,   159,   160,   161,   162,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    89,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,
     161,   162,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    89,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,    -1,    -1,   140,   141,   142,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
      -1,    -1,    -1,    -1,    -1,   159,   160,   161,   162,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    -1,    -1,    -1,    -1,    -1,    -1,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    89,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,
     107,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,    -1,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,    56,    57,    -1,
      -1,    -1,   159,   160,   161,   162,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      89,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,   107,    -1,
     109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,
      -1,    -1,    -1,   142,    -1,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,    56,    57,    -1,    -1,    -1,
     159,   160,   161,   162,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    89,    90,
      91,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   106,   107,    -1,   109,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    89,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,   106,   107,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,
     161,   162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,    56,
      57,    -1,    -1,    -1,   159,   160,   161,   162,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    74,    -1,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    89,    90,    91,    56,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    89,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,    -1,    -1,    -1,
      -1,    -1,   159,   160,   161,   162,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,    56,    57,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,   160,
     161,   162,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    89,    90,    91,    56,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      89,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    56,    57,    -1,    -1,
     145,   146,   147,   148,   149,   150,   151,   152,   153,    -1,
      -1,    -1,    -1,    -1,   159,   160,   161,   162,    -1,    79,
      80,    81,    82,    83,    84,    85,    86,    87,   137,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,
     149,   150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,
     159,   160,   161,   162,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,    -1,    -1,    -1,   159,
     160,   161,   162
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,     6,     7,     8,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    33,    34,    35,    38,
      39,    44,    46,    47,    48,    51,    52,    53,    54,    56,
      57,    68,    69,    70,    71,    72,    73,    88,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   110,   111,   112,   113,   115,   117,   118,   119,
     120,   122,   123,   124,   125,   127,   128,   129,   133,   136,
     138,   149,   150,   152,   156,   157,   158,   159,   162,   164,
     168,   169,   172,   173,   174,   177,   178,   183,   186,   187,
     190,   192,   193,   200,   201,   214,   218,   219,   220,   222,
     223,   225,   230,   232,   233,   234,   164,    14,    27,   114,
     120,   159,   200,   219,   224,   228,   229,   230,   231,   113,
     120,   162,   200,   201,   120,   159,   179,   180,   183,   180,
     231,   162,   162,   162,    93,   113,   119,   120,   162,   212,
     164,   164,   164,   231,   231,   231,   231,    34,   113,   182,
     184,   113,   120,   182,   164,   162,   159,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   113,   115,
     120,   231,   180,   180,   180,   231,   231,   231,   231,   231,
     231,     1,   191,   231,   162,   162,   162,   233,   162,   231,
     231,   113,   115,   120,   231,   231,   231,   163,   179,   181,
     183,   165,   226,   227,   231,     0,   169,    37,   164,    14,
     113,   120,   116,   121,    45,    49,   126,   132,    14,    27,
     113,   120,   200,   220,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      89,    90,    91,   106,   107,   108,   109,   137,   140,   141,
     142,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   159,   160,   161,   162,   164,   163,   226,   231,   163,
     226,    14,    14,   200,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      89,    90,    91,   106,   107,   108,   109,   137,   140,   141,
     142,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   159,   160,   161,   162,   224,   231,   113,   116,   162,
     163,   181,    11,     9,   164,   231,   231,   191,   162,   162,
     162,   191,   191,    21,    21,   113,   120,   162,    10,    31,
      32,   180,   185,   141,   141,   162,   231,   113,   170,   171,
     162,   162,   162,   165,   191,   231,   231,   191,   163,   179,
     183,   140,   165,   143,   165,   113,   120,   162,   200,   201,
     120,   162,   212,   162,   159,   164,   113,   120,    42,   194,
     194,   120,   162,   212,   162,    14,   120,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   130,
     131,   134,   135,   134,   200,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   109,   231,   231,   191,   163,
     163,    14,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   130,   131,   134,   135,   134,   200,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     109,   231,   231,   191,   165,   191,   163,   162,   162,   165,
     165,   164,   191,   165,   165,   231,   162,   141,   141,   231,
     162,   162,   162,   231,   231,   231,   165,   141,   163,   171,
     191,   191,   191,   165,   165,   165,   165,   227,   231,   224,
     113,   120,   116,   121,   162,   191,   191,   191,    14,   120,
     163,   173,   174,   175,   176,   177,   178,   192,   193,   200,
     214,   219,   222,   223,   159,   159,    24,    25,    26,    27,
     113,   120,   195,   196,   159,   164,   159,   164,   162,   191,
     191,   191,   120,   162,   212,   162,   143,   163,   166,   231,
     109,   166,   165,   143,   163,   166,   231,   109,   166,   165,
     165,   231,   191,   180,   180,   191,   165,     4,   221,   221,
      10,   231,   231,   231,   165,   231,   231,   231,   164,   164,
     165,   159,   231,   165,   165,   165,   143,   164,   215,   165,
     191,   165,   165,   165,   162,   164,   163,   176,    14,    14,
     200,   197,   198,   200,   197,   113,   120,   113,   120,   113,
     120,   113,   120,   140,    24,    25,    26,    27,    34,   163,
     177,   199,   202,   203,   204,   213,   218,   219,   163,   199,
     191,   165,   165,   165,   162,   191,   191,   191,   231,   166,
     166,   231,   166,   166,   165,   165,    43,   164,   221,   200,
     201,   179,   179,   162,   165,   164,   164,   184,   165,   165,
     165,    36,    40,    41,   188,   189,   164,   113,   120,   216,
     217,   221,   165,   179,   179,   215,   191,    14,   163,   198,
     113,   163,   196,    50,   118,   159,   208,   209,   210,   159,
     210,   159,   210,    34,   159,   210,   163,   177,   202,   203,
     204,   213,   113,   200,   212,   163,   165,   221,   221,   215,
     191,   165,   165,   165,   164,   180,   180,   191,   179,   231,
     180,   180,   162,    79,    81,    82,    86,    87,   134,   147,
     148,   231,   143,   163,   189,   162,   162,   140,   179,   179,
     179,   165,   141,   162,   164,   208,   120,    27,    44,    50,
     113,   163,   177,   200,   201,   205,   206,   207,   211,   140,
     164,   163,   211,   164,   163,   211,   164,   163,   211,   164,
     212,   191,   221,   179,   179,   221,   165,   179,   179,   215,
     165,   165,   231,   231,   231,   231,   134,   134,   143,   231,
     231,   143,   181,   191,   191,   217,   231,   191,   113,   200,
     206,   141,   164,   113,   118,   163,   206,   207,   208,   209,
     163,   163,   163,   191,   165,   179,   164,   179,   179,   164,
     179,   180,   165,   143,   143,   143,   143,   143,   181,   143,
     143,   181,   165,   165,   164,   165,   141,   164,   113,   231,
     141,   162,   164,   141,   162,   164,   165,   215,   184,   181,
     181,   181,   181,   181,   181,   181,   164,   231,   141,   162,
     164,   164,   231,   191,   231,   191,   215,   221,   180,   164,
     231,   191,   164,   165,   164,   165,   164,   179,   164,   179,
     164,   165,   164,   164,   164
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   167,   168,   168,   169,   169,   169,   169,   169,   169,
     169,   169,   169,   169,   169,   169,   169,   170,   170,   171,
     172,   172,   173,   173,   173,   173,   173,   173,   173,   174,
     174,   174,   175,   175,   176,   176,   176,   176,   176,   176,
     176,   176,   176,   177,   177,   178,   178,   179,   179,   180,
     180,   181,   181,   181,   181,   182,   182,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   184,   184,   185,   185,   185,   186,   186,   187,   188,
     188,   189,   189,   189,   189,   189,   189,   189,   189,   189,
     189,   189,   189,   189,   189,   189,   189,   189,   189,   189,
     189,   190,   191,   191,   191,   192,   192,   193,   193,   193,
     193,   193,   193,   194,   194,   195,   195,   196,   196,   196,
     196,   196,   196,   196,   196,   196,   196,   197,   197,   198,
     198,   198,   199,   199,   199,   199,   199,   199,   199,   199,
     199,   199,   200,   200,   200,   200,   200,   200,   201,   201,
     202,   202,   202,   203,   203,   203,   203,   203,   203,   204,
     204,   204,   205,   205,   205,   205,   205,   206,   206,   206,
     206,   206,   206,   206,   206,   206,   206,   207,   208,   208,
     209,   210,   210,   210,   210,   211,   211,   211,   211,   212,
     212,   212,   213,   213,   213,   213,   214,   214,   214,   214,
     214,   214,   215,   215,   216,   216,   217,   217,   218,   218,
     219,   219,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   221,   221,   222,   222,   222,   222,   223,   223,   223,
     223,   224,   224,   225,   225,   226,   226,   226,   227,   228,
     229,   229,   230,   230,   230,   230,   230,   230,   230,   230,
     230,   230,   230,   230,   230,   230,   230,   230,   230,   230,
     230,   230,   230,   230,   230,   230,   230,   230,   230,   230,
     230,   230,   230,   230,   230,   230,   230,   230,   230,   230,
     230,   230,   230,   230,   230,   230,   230,   230,   230,   230,
     230,   230,   230,   230,   230,   230,   230,   230,   230,   230,
     230,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   231,   231,   231,   231,   231,   231,
     231,   231,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     233,   233,   234,   234,   234,   234,   234,   234,   234,   234,
     234
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     4,     1,     1,     2,     4,
       0,     1,     4,     3,     4,     3,     4,     4,     5,     5,
       3,     4,     1,     2,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     5,     6,     5,     6,     3,     2,     1,
       1,     1,     1,     2,     2,     0,     1,     1,     2,     5,
       1,     2,     3,     2,     2,     2,     3,    11,     7,     5,
       7,     5,     7,     9,     7,     2,     2,     2,     2,     1,
       2,     0,     2,     4,     4,     4,     1,     2,     7,     1,
       2,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     5,     4,     5,     4,     4,     3,     4,     3,     3,
       2,     7,     0,     1,     1,     6,     6,     6,     6,     4,
       4,     5,     5,     2,     0,     1,     3,     1,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     1,     2,     3,
       5,     6,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     2,     2,     2,     0,     1,
       3,     4,     3,     3,     4,     3,     3,     4,     3,     3,
       4,     3,     4,     3,     6,     5,     7,     3,     5,     6,
       3,     5,     6,     2,     4,     1,     1,     2,     1,     2,
       2,     1,     1,     3,     3,     1,     1,     2,     2,     2,
       2,     1,     7,     7,     7,     7,     8,     8,     8,     8,
       7,     7,     2,     0,     1,     3,     4,     4,     0,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     0,     6,     6,     7,     7,     7,     7,     8,
       8,     3,     2,     3,     2,     1,     3,     2,     3,     3,
       3,     2,     1,     1,     3,     1,     2,     2,     2,     3,
       2,     3,     4,     1,     1,     1,     1,     1,     8,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     4,     3,     1,     2,
       2,     2,     2,     2,     5,     5,     5,     2,     1,     3,
       2,     6,     6,     7,     7,     1,     1,     2,     2,     4,
       4,     1,     1,     1,     1,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     5,     2,     2,     4,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     5,     5,     4,     4,     4,     3,
       3,     2,     1,     1,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       2,     2,     4,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     5,     5,     4,     4,     4,     3,     3,     2,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  YY_LOCATION_PRINT (yyo, *yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                       , &(yylsp[(yyi + 1) - (yynrhs)])                       , yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
#  else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                yy_state_t *yyssp, int yytoken)
{
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Actual size of YYARG. */
  int yycount = 0;
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      YYPTRDIFF_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
      yysize = yysize0;
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYPTRDIFF_T yysize1
                    = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    /* Don't count the "%s"s in the final size, but reserve room for
       the terminator.  */
    YYPTRDIFF_T yysize1 = yysize + (yystrlen (yyformat) - 2 * yycount) + 1;
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yytype)
    {
    case 113: /* "identifier"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6218 "parser.cpp"
        break;

    case 114: /* "typed hash identifier"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6224 "parser.cpp"
        break;

    case 115: /* "complex type identifier"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6230 "parser.cpp"
        break;

    case 116: /* "variable reference"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6236 "parser.cpp"
        break;

    case 117: /* "backquote expression"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6242 "parser.cpp"
        break;

    case 118: /* "in-object member reference"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6248 "parser.cpp"
        break;

    case 119: /* "identifier or keyword used as function or method identifier"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6254 "parser.cpp"
        break;

    case 120: /* "namespace or class-scoped reference"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6260 "parser.cpp"
        break;

    case 121: /* "namespace-scoped global variable reference"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6266 "parser.cpp"
        break;

    case 122: /* "context reference"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6272 "parser.cpp"
        break;

    case 123: /* "named context reference"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6278 "parser.cpp"
        break;

    case 124: /* "cast operator"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6284 "parser.cpp"
        break;

    case 125: /* QORE_OR_NOTHING_CAST  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6290 "parser.cpp"
        break;

    case 126: /* "simple class declaration"  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6296 "parser.cpp"
        break;

    case 127: /* "date/time value"  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).datetime)) ((*yyvaluep).datetime)->deref(); }
#line 6302 "parser.cpp"
        break;

    case 128: /* "quoted string"  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6308 "parser.cpp"
        break;

    case 129: /* "binary constant value"  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).binary)) ((*yyvaluep).binary)->deref(); }
#line 6314 "parser.cpp"
        break;

    case 130: /* "regular expression substitution expression"  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).RegexSubst); }
#line 6320 "parser.cpp"
        break;

    case 131: /* "transliteration expression"  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).Trans); }
#line 6326 "parser.cpp"
        break;

    case 132: /* "scoped class declaration"  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).nscope); }
#line 6332 "parser.cpp"
        break;

    case 133: /* "call to base class method"  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).nscope); }
#line 6338 "parser.cpp"
        break;

    case 134: /* "regular expression"  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).Regex); }
#line 6344 "parser.cpp"
        break;

    case 135: /* "regular expression extraction expression"  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).Regex); }
#line 6350 "parser.cpp"
        break;

    case 136: /* "implicit argument reference"  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).implicit_arg)) ((*yyvaluep).implicit_arg)->deref(); }
#line 6356 "parser.cpp"
        break;

    case 137: /* "keyword used as hash key or object member reference"  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6362 "parser.cpp"
        break;

    case 138: /* "%try-module error token"  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).trymod); }
#line 6368 "parser.cpp"
        break;

    case 173: /* gvardecl  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).gv); }
#line 6374 "parser.cpp"
        break;

    case 174: /* top_namespace_decl  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).ns); }
#line 6380 "parser.cpp"
        break;

    case 175: /* namespace_decls  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).nsnlist)) ((*yyvaluep).nsnlist)->deref(); }
#line 6386 "parser.cpp"
        break;

    case 176: /* namespace_decl  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).nsn)) ((*yyvaluep).nsn)->deref(); }
#line 6392 "parser.cpp"
        break;

    case 177: /* unscoped_const_decl  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).constnode); }
#line 6398 "parser.cpp"
        break;

    case 178: /* scoped_const_decl  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).constnode); }
#line 6404 "parser.cpp"
        break;

    case 179: /* block  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).sblock); }
#line 6410 "parser.cpp"
        break;

    case 180: /* statement_or_block  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).sblock); }
#line 6416 "parser.cpp"
        break;

    case 181: /* statements  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).sblock); }
#line 6422 "parser.cpp"
        break;

    case 182: /* optname  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6428 "parser.cpp"
        break;

    case 183: /* statement  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).statement); }
#line 6434 "parser.cpp"
        break;

    case 184: /* context_mods  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).cmods); }
#line 6440 "parser.cpp"
        break;

    case 185: /* context_mod  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).cmod); }
#line 6446 "parser.cpp"
        break;

    case 186: /* return_statement  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).statement); }
#line 6452 "parser.cpp"
        break;

    case 187: /* switch_statement  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).statement); }
#line 6458 "parser.cpp"
        break;

    case 188: /* case_block  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).switchstmt); }
#line 6464 "parser.cpp"
        break;

    case 189: /* case_code  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).casenode); }
#line 6470 "parser.cpp"
        break;

    case 190: /* try_statement  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).statement); }
#line 6476 "parser.cpp"
        break;

    case 191: /* myexp  */
#line 1824 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 6482 "parser.cpp"
        break;

    case 192: /* hashdecl_def  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).hashdecldef); }
#line 6488 "parser.cpp"
        break;

    case 193: /* class_def  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).classdef); }
#line 6494 "parser.cpp"
        break;

    case 194: /* inheritance_list  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).sclist); }
#line 6500 "parser.cpp"
        break;

    case 195: /* superclass_list  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).sclist); }
#line 6506 "parser.cpp"
        break;

    case 196: /* superclass  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).sclnode); }
#line 6512 "parser.cpp"
        break;

    case 197: /* hashdecl_attrs  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).hashdeclpriv)) ((*yyvaluep).hashdeclpriv)->deref(); }
#line 6518 "parser.cpp"
        break;

    case 198: /* hashdecl_member  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 6524 "parser.cpp"
        break;

    case 199: /* class_attributes  */
#line 1820 "parser.ypp"
            { qore_class_private::get(*((*yyvaluep).qoreclass))->deref(true, true); }
#line 6530 "parser.cpp"
        break;

    case 200: /* uncqtypedef  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).parsertype); }
#line 6536 "parser.cpp"
        break;

    case 201: /* qtypedef  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).parsertype); }
#line 6542 "parser.cpp"
        break;

    case 202: /* internal_member_list  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 6548 "parser.cpp"
        break;

    case 203: /* private_member_list  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 6554 "parser.cpp"
        break;

    case 204: /* public_member_list  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 6560 "parser.cpp"
        break;

    case 205: /* classvardecl  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).classvarinfo); }
#line 6566 "parser.cpp"
        break;

    case 206: /* member2  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 6572 "parser.cpp"
        break;

    case 207: /* transient_member2  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 6578 "parser.cpp"
        break;

    case 208: /* member  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 6584 "parser.cpp"
        break;

    case 209: /* transient_member  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 6590 "parser.cpp"
        break;

    case 210: /* member_list  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 6596 "parser.cpp"
        break;

    case 211: /* member_list2  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 6602 "parser.cpp"
        break;

    case 212: /* ident_openparen  */
#line 1821 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6608 "parser.cpp"
        break;

    case 213: /* inline_methoddef  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).methodnode); }
#line 6614 "parser.cpp"
        break;

    case 214: /* outofline_methoddef  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).methoddef); }
#line 6620 "parser.cpp"
        break;

    case 215: /* base_constructor_list  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).bcalist); }
#line 6626 "parser.cpp"
        break;

    case 216: /* base_constructors  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).bcalist); }
#line 6632 "parser.cpp"
        break;

    case 217: /* base_constructor  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).bcanode); }
#line 6638 "parser.cpp"
        break;

    case 221: /* return_value  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).returnTypeInfo); }
#line 6644 "parser.cpp"
        break;

    case 222: /* sub_def  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).parsefunc); }
#line 6650 "parser.cpp"
        break;

    case 223: /* scoped_sub_def  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).sparsefunc); }
#line 6656 "parser.cpp"
        break;

    case 224: /* list  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).parse_list)) ((*yyvaluep).parse_list)->deref(); }
#line 6662 "parser.cpp"
        break;

    case 225: /* list_n  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).parse_list)) ((*yyvaluep).parse_list)->deref(); }
#line 6668 "parser.cpp"
        break;

    case 226: /* hash  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).hash); }
#line 6674 "parser.cpp"
        break;

    case 227: /* hash_element  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).hashelement); }
#line 6680 "parser.cpp"
        break;

    case 228: /* alt_hash  */
#line 1819 "parser.ypp"
            { delete ((*yyvaluep).hash); }
#line 6686 "parser.cpp"
        break;

    case 229: /* immediate_typed_hash  */
#line 1823 "parser.ypp"
            { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(nullptr); }
#line 6692 "parser.cpp"
        break;

    case 230: /* exp_c  */
#line 1824 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 6698 "parser.cpp"
        break;

    case 231: /* exp  */
#line 1824 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 6704 "parser.cpp"
        break;

    case 232: /* exp_n  */
#line 1824 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 6710 "parser.cpp"
        break;

    case 233: /* string  */
#line 1822 "parser.ypp"
            { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6716 "parser.cpp"
        break;

    case 234: /* scalar  */
#line 1824 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 6722 "parser.cpp"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (yyscan_t yyscanner)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    yy_state_fast_t yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss;
    yy_state_t *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYPTRDIFF_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 4:
#line 1832 "parser.ypp"
                {
           (yyvsp[0].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 7026 "parser.cpp"
    break;

  case 5:
#line 1835 "parser.ypp"
                         {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].sparsefunc)->loc, "function", (yyvsp[0].sparsefunc)->name.ostr);
           (yyvsp[0].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 7036 "parser.cpp"
    break;

  case 6:
#line 1840 "parser.ypp"
                    {
           qore_root_ns_private::parseAddClass((yyvsp[0].classdef)->loc, *((yyvsp[0].classdef)->name), (yyvsp[0].classdef)->oc);

           // see if class definitions are allowed
           if (parse_check_parse_option(PO_NO_CLASS_DEFS))
              parse_error(*(yyvsp[0].classdef)->loc, "illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
           delete (yyvsp[0].classdef);
        }
#line 7049 "parser.cpp"
    break;

  case 7:
#line 1848 "parser.ypp"
                       {
           qore_root_ns_private::parseAddHashDecl((yyvsp[0].hashdecldef)->loc, *((yyvsp[0].hashdecldef)->name), (yyvsp[0].hashdecldef)->takeHashDecl());
           delete (yyvsp[0].hashdecldef);
        }
#line 7058 "parser.cpp"
    break;

  case 8:
#line 1852 "parser.ypp"
                            {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].constnode)->loc, "constant", (yyvsp[0].constnode)->name.ostr);
           qore_root_ns_private::parseAddConstant((yyvsp[0].constnode)->loc, *getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
           delete (yyvsp[0].constnode);
        }
#line 7069 "parser.cpp"
    break;

  case 9:
#line 1858 "parser.ypp"
                              {
           qore_root_ns_private::parseAddConstant((yyvsp[0].constnode)->loc, *getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
           delete (yyvsp[0].constnode);
        }
#line 7078 "parser.cpp"
    break;

  case 10:
#line 1862 "parser.ypp"
                              {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].methoddef)->loc, "method", (yyvsp[0].methoddef)->name.ostr);
           (yyvsp[0].methoddef)->parseAddToClassAndDel();
        }
#line 7088 "parser.cpp"
    break;

  case 11:
#line 1867 "parser.ypp"
                    {
           if ((yyvsp[0].statement)) {
              if ((yyvsp[0].statement)->isParseDeclaration())
                 delete (yyvsp[0].statement);
              else
                 qore_program_private::addStatement(*(getProgram()), (yyvsp[0].statement));
           }
        }
#line 7101 "parser.cpp"
    break;

  case 13:
#line 1876 "parser.ypp"
                             {
            (yyvsp[-1].sblock)->finalizeBlock((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            qore_program_private::addStatement(*(getProgram()), (yyvsp[-1].sblock));
        }
#line 7110 "parser.cpp"
    break;

  case 14:
#line 1880 "parser.ypp"
                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_root_ns_private::parseAddNamespace((yyvsp[0].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
        }
#line 7122 "parser.cpp"
    break;

  case 15:
#line 1887 "parser.ypp"
                                          {
            QoreModuleDefContext* qmd = get_module_def_context();
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");
            else {
                QoreUserModuleDefContextHelper* uqmd = static_cast<QoreUserModuleDefContextHelper*>(qmd);
                uqmd->close();
            }
            // registered internally
        }
#line 7137 "parser.cpp"
    break;

  case 16:
#line 1897 "parser.ypp"
                           {
            bool has_dollar = (yyvsp[0].trymod)->var[0] == '$';
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            if (!has_dollar) {
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS)) {
                    parse_error(*loc, "%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].trymod)->var);
                }
            } else {
                (yyvsp[0].trymod)->fixName();
                if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[0].trymod)->var);
            }

            if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
                parse_error(*loc, "'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
            } else {
                VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode(loc, (yyvsp[0].trymod)->takeName());
                QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(loc, left, (yyvsp[0].trymod)->takeExceptionHash());
                qore_program_private::addStatement(*(getProgram()), new ExpressionStatement(loc, exp));
            }
            delete (yyvsp[0].trymod);
        }
#line 7164 "parser.cpp"
    break;

  case 17:
#line 1922 "parser.ypp"
                    {
        }
#line 7171 "parser.cpp"
    break;

  case 18:
#line 1924 "parser.ypp"
                                   {
        }
#line 7178 "parser.cpp"
    break;

  case 19:
#line 1929 "parser.ypp"
                               {
            QoreModuleDefContext* qmd = get_module_def_context();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line);
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[-3].string), (yyvsp[-1].qv).getTypeName());
            else
                qmd->set(loc, (yyvsp[-3].string), (yyvsp[-1].qv));

            free((yyvsp[-3].string));
            (yyvsp[-1].qv).discard(nullptr);
        }
#line 7194 "parser.cpp"
    break;

  case 20:
#line 1943 "parser.ypp"
        { (yyval.b) = false; }
#line 7200 "parser.cpp"
    break;

  case 21:
#line 1944 "parser.ypp"
                     {
           (yyval.b) = true;
        }
#line 7208 "parser.cpp"
    break;

  case 22:
#line 1950 "parser.ypp"
                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true);
            delete (yyvsp[-1].parsertype);
        }
#line 7221 "parser.cpp"
    break;

  case 23:
#line 1958 "parser.ypp"
                                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 7232 "parser.cpp"
    break;

  case 24:
#line 1964 "parser.ypp"
                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true);
            delete (yyvsp[-1].parsertype);
        }
#line 7243 "parser.cpp"
    break;

  case 25:
#line 1970 "parser.ypp"
                                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 7252 "parser.cpp"
    break;

  case 26:
#line 1974 "parser.ypp"
                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false);
            delete (yyvsp[-1].parsertype);
        }
#line 7265 "parser.cpp"
    break;

  case 27:
#line 1982 "parser.ypp"
                                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false);
            delete (yyvsp[-1].parsertype);
        }
#line 7276 "parser.cpp"
    break;

  case 28:
#line 1988 "parser.ypp"
                                    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].b) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.gv) = new GVarListDecl(loc, (yyvsp[-1].parse_list), (yyvsp[-4].b));
        }
#line 7285 "parser.cpp"
    break;

  case 29:
#line 1995 "parser.ypp"
                                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[-4].i4), *p);
            (yyvsp[-1].nsnlist)->add(*p);
            delete (yyvsp[-1].nsnlist);
            (yyval.ns) = p->ns;
        }
#line 7298 "parser.cpp"
    break;

  case 30:
#line 2003 "parser.ypp"
                                          {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].i4) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[-1]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[-2].i4), *p);
            (yyval.ns) = p->ns;
        }
#line 7309 "parser.cpp"
    break;

  case 31:
#line 2009 "parser.ypp"
                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[-3].i4), *p);
            (yyval.ns) = p->ns;
        }
#line 7320 "parser.cpp"
    break;

  case 32:
#line 2018 "parser.ypp"
                       {
           (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 7330 "parser.cpp"
    break;

  case 33:
#line 2023 "parser.ypp"
                                         {
           (yyval.nsnlist) = (yyvsp[-1].nsnlist);
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 7340 "parser.cpp"
    break;

  case 34:
#line 2031 "parser.ypp"
                          {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].constnode)->loc, "constant", (yyvsp[0].constnode)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 7350 "parser.cpp"
    break;

  case 35:
#line 2036 "parser.ypp"
                              {
           (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 7358 "parser.cpp"
    break;

  case 36:
#line 2039 "parser.ypp"
                    {
            (yyval.nsn) = new NSNode((yyvsp[0].classdef));
            // see if class definitions are allowed
            if (parse_check_parse_option(PO_NO_CLASS_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "illegal class definition \"%s\" (conflicts with parse option PO_NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
            }
        }
#line 7371 "parser.cpp"
    break;

  case 37:
#line 2047 "parser.ypp"
                       {
           (yyval.nsn) = new NSNode((yyvsp[0].hashdecldef));
        }
#line 7379 "parser.cpp"
    break;

  case 38:
#line 2050 "parser.ypp"
                  {
           (yyval.nsn) = new NSNode((yyvsp[0].parsefunc));
        }
#line 7387 "parser.cpp"
    break;

  case 39:
#line 2053 "parser.ypp"
                         {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].sparsefunc)->loc, "function", (yyvsp[0].sparsefunc)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[0].sparsefunc));
        }
#line 7397 "parser.cpp"
    break;

  case 40:
#line 2058 "parser.ypp"
                       {
           (yyval.nsn) = new NSNode((yyvsp[-1].gv));
        }
#line 7405 "parser.cpp"
    break;

  case 41:
#line 2061 "parser.ypp"
                             {
            (yyval.nsn) = new NSNode((yyvsp[0].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
            }
        }
#line 7418 "parser.cpp"
    break;

  case 42:
#line 2069 "parser.ypp"
                              {
           (yyval.nsn) = new NSNode((yyvsp[0].methoddef));
        }
#line 7426 "parser.cpp"
    break;

  case 43:
#line 2075 "parser.ypp"
                                         {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv));
        }
#line 7434 "parser.cpp"
    break;

  case 44:
#line 2078 "parser.ypp"
                                                      {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv), true);
        }
#line 7442 "parser.cpp"
    break;

  case 45:
#line 2084 "parser.ypp"
                                         {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv));
        }
#line 7450 "parser.cpp"
    break;

  case 46:
#line 2087 "parser.ypp"
                                                      {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv), true);
        }
#line 7458 "parser.cpp"
    break;

  case 47:
#line 2094 "parser.ypp"
        { (yyval.sblock) = (yyvsp[-1].sblock); }
#line 7464 "parser.cpp"
    break;

  case 48:
#line 2097 "parser.ypp"
        { (yyval.sblock) = new StatementBlock((yylsp[-1]).first_line, (yylsp[-1]).last_line); }
#line 7470 "parser.cpp"
    break;

  case 49:
#line 2102 "parser.ypp"
        { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 7476 "parser.cpp"
    break;

  case 50:
#line 2105 "parser.ypp"
        { (yyval.sblock) = (yyvsp[0].sblock); }
#line 7482 "parser.cpp"
    break;

  case 51:
#line 2110 "parser.ypp"
        { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 7488 "parser.cpp"
    break;

  case 52:
#line 2112 "parser.ypp"
        { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock)); }
#line 7494 "parser.cpp"
    break;

  case 53:
#line 2114 "parser.ypp"
        { (yyvsp[-1].sblock)->addStatement((yyvsp[0].sblock)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 7500 "parser.cpp"
    break;

  case 54:
#line 2116 "parser.ypp"
        { (yyvsp[-1].sblock)->addStatement((yyvsp[0].statement)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 7506 "parser.cpp"
    break;

  case 55:
#line 2121 "parser.ypp"
        { (yyval.string) = 0; }
#line 7512 "parser.cpp"
    break;

  case 56:
#line 2122 "parser.ypp"
                     { (yyval.string) = (yyvsp[0].string); }
#line 7518 "parser.cpp"
    break;

  case 57:
#line 2126 "parser.ypp"
            { (yyval.statement) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 7524 "parser.cpp"
    break;

  case 58:
#line 2127 "parser.ypp"
                    {
            qore_program_private* pgm = qore_program_private::get(*getProgram());
            // if the expression has no effect and it's not a variable declaration
            qore_type_t t = (yyvsp[-1].qv).getType();
            bool ok = false;
            if (t == NT_PARSE_LIST) {
                QoreParseListNode* l = (yyvsp[-1].qv).get<QoreParseListNode>();
                // rewrite expression if it's a list without parentheses under certain conditions
                (yyvsp[-1].qv).set(check_rewrite_list(l));

                if (l->isVariableList())
                    ok = true;
            }

            const QoreProgramLocation* loc = pgm->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);

            if (!ok) {
                if (!value_has_effect_as_root((yyvsp[-1].qv)) && (t != NT_VARREF || !(yyvsp[-1].qv).get<VarRefNode>()->parseIsDecl())) {
                    if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                        parse_error(*loc, "expression has no effect as top-level statement (%s)", (yyvsp[-1].qv).getTypeName());
                    }
                } else if (!(yyvsp[-1].qv).hasEffect() && (t != NT_VARREF || !(yyvsp[-1].qv).get<VarRefNode>()->parseIsDecl())) {
                    parse_error(*loc, "statement has no effect (%s)", (yyvsp[-1].qv).getTypeName());
                }
            }

            ignore_return_value((yyvsp[-1].qv));
            (yyval.statement) = new ExpressionStatement(loc, (yyvsp[-1].qv));
        }
#line 7558 "parser.cpp"
    break;

  case 59:
#line 2157 "parser.ypp"
                                       {
            NamedScope *ns = new NamedScope((yyvsp[-4].string));
            assert(ns->size() > 1);
            printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.statement) = new ExpressionStatement(loc, new StaticMethodCallNode(loc, ns, make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].qv))));
        }
#line 7570 "parser.cpp"
    break;

  case 60:
#line 2165 "parser.ypp"
        { (yyval.statement) = (yyvsp[0].statement); }
#line 7576 "parser.cpp"
    break;

  case 61:
#line 2166 "parser.ypp"
                          {
           (yyval.statement) = new RethrowStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7584 "parser.cpp"
    break;

  case 62:
#line 2169 "parser.ypp"
                            {
           (yyval.statement) = new ThrowStatement((yylsp[-2]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].qv));
        }
#line 7592 "parser.cpp"
    break;

  case 63:
#line 2172 "parser.ypp"
                                         {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Unconditional);
        }
#line 7600 "parser.cpp"
    break;

  case 64:
#line 2175 "parser.ypp"
                                            {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Success);
        }
#line 7608 "parser.cpp"
    break;

  case 65:
#line 2178 "parser.ypp"
                                          {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Error);
        }
#line 7616 "parser.cpp"
    break;

  case 66:
#line 2181 "parser.ypp"
                                                          {
           (yyval.statement) = new ContextStatement((yylsp[-2]).first_line, (yylsp[0]).last_line, 0, 0, (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 7624 "parser.cpp"
    break;

  case 67:
#line 2184 "parser.ypp"
                                                                                               {
           (yyval.statement) = new SummarizeStatement((yylsp[-10]).first_line, (yylsp[0]).last_line, (yyvsp[-9].string), (yyvsp[-7].qv), (yyvsp[-1].cmods), (yyvsp[0].sblock), (yyvsp[-3].qv));
        }
#line 7632 "parser.cpp"
    break;

  case 68:
#line 2187 "parser.ypp"
                                                                          {
           (yyval.statement) = new ContextStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].string), (yyvsp[-3].qv), (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 7640 "parser.cpp"
    break;

  case 69:
#line 2190 "parser.ypp"
                                                          {
           (yyval.statement) = new IfStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7648 "parser.cpp"
    break;

  case 70:
#line 2193 "parser.ypp"
                                                                            {
           (yyval.statement) = new IfStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-4].qv), (yyvsp[-2].sblock), (yyvsp[0].sblock));
        }
#line 7656 "parser.cpp"
    break;

  case 71:
#line 2196 "parser.ypp"
                                                   {
           (yyval.statement) = new WhileStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7664 "parser.cpp"
    break;

  case 72:
#line 2199 "parser.ypp"
                                                              {
           (yyval.statement) = new DoWhileStatement((yylsp[-6]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), (yyvsp[-5].sblock));
        }
#line 7672 "parser.cpp"
    break;

  case 73:
#line 2202 "parser.ypp"
                                                                       {
           (yyval.statement) = new ForStatement((yylsp[-8]).first_line, (yylsp[0]).last_line, (yyvsp[-6].qv), (yyvsp[-4].qv), (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7680 "parser.cpp"
    break;

  case 74:
#line 2205 "parser.ypp"
                                                                {
           (yyval.statement) = new ForEachStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].qv), (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7688 "parser.cpp"
    break;

  case 75:
#line 2208 "parser.ypp"
                               { (yyval.statement) = (yyvsp[-1].statement); }
#line 7694 "parser.cpp"
    break;

  case 76:
#line 2209 "parser.ypp"
                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            // see if thread exit is allowed
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL)) {
                parse_error(*loc, "illegal use of \"thread_exit\" (conflicts with parse option PO_NO_THREAD_CONTROL)");
            }
            (yyval.statement) = new ThreadExitStatement(loc);
        }
#line 7707 "parser.cpp"
    break;

  case 77:
#line 2217 "parser.ypp"
                        {
            (yyval.statement) = new BreakStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7715 "parser.cpp"
    break;

  case 78:
#line 2220 "parser.ypp"
                           {
            (yyval.statement) = new ContinueStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7723 "parser.cpp"
    break;

  case 79:
#line 2223 "parser.ypp"
                           { (yyval.statement) = (yyvsp[0].statement); }
#line 7729 "parser.cpp"
    break;

  case 80:
#line 2224 "parser.ypp"
                           { (yyval.statement) = 0; }
#line 7735 "parser.cpp"
    break;

  case 81:
#line 2229 "parser.ypp"
        { (yyval.cmods) = 0; }
#line 7741 "parser.cpp"
    break;

  case 82:
#line 2230 "parser.ypp"
                                   {
           if (!(yyvsp[-1].cmods))
              (yyval.cmods) = new ContextModList((yyvsp[0].cmod));
           else {
              (yyvsp[-1].cmods)->addContextMod((yyvsp[0].cmod));
              (yyval.cmods) = (yyvsp[-1].cmods);
           }
        }
#line 7754 "parser.cpp"
    break;

  case 83:
#line 2242 "parser.ypp"
        { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[-1].qv)); }
#line 7760 "parser.cpp"
    break;

  case 84:
#line 2244 "parser.ypp"
        { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[-1].qv)); }
#line 7766 "parser.cpp"
    break;

  case 85:
#line 2246 "parser.ypp"
        { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[-1].qv)); }
#line 7772 "parser.cpp"
    break;

  case 86:
#line 2250 "parser.ypp"
                       { (yyval.statement) = new ReturnStatement((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 7778 "parser.cpp"
    break;

  case 87:
#line 2252 "parser.ypp"
                       { (yyval.statement) = new ReturnStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].qv)); }
#line 7784 "parser.cpp"
    break;

  case 88:
#line 2257 "parser.ypp"
        {
           (yyvsp[-1].switchstmt)->setSwitch((yyvsp[-4].qv));
           (yyval.statement) = (yyvsp[-1].switchstmt);
           (yyval.statement)->finalizeBlock((yylsp[-6]).first_line, (yylsp[0]).last_line);
        }
#line 7794 "parser.cpp"
    break;

  case 89:
#line 2266 "parser.ypp"
        {
           (yyval.switchstmt) = new SwitchStatement((yyvsp[0].casenode));
        }
#line 7802 "parser.cpp"
    break;

  case 90:
#line 2270 "parser.ypp"
        {
           (yyvsp[-1].switchstmt)->addCase((yyvsp[0].casenode));
           (yyval.switchstmt) = (yyvsp[-1].switchstmt);
        }
#line 7811 "parser.cpp"
    break;

  case 91:
#line 2278 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">=", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
#line 7821 "parser.cpp"
    break;

  case 92:
#line 2284 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">=", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
#line 7831 "parser.cpp"
    break;

  case 93:
#line 2290 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<=", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
#line 7841 "parser.cpp"
    break;

  case 94:
#line 2296 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<=", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
#line 7851 "parser.cpp"
    break;

  case 95:
#line 2302 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, "==", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalEqualsOperatorNode::softEqual);
        }
#line 7861 "parser.cpp"
    break;

  case 96:
#line 2308 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, "==", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalEqualsOperatorNode::softEqual);
        }
#line 7871 "parser.cpp"
    break;

  case 97:
#line 2314 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalLessThanOperatorNode::doLessThan);
        }
#line 7881 "parser.cpp"
    break;

  case 98:
#line 2320 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalLessThanOperatorNode::doLessThan);
        }
#line 7891 "parser.cpp"
    break;

  case 99:
#line 2326 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
#line 7901 "parser.cpp"
    break;

  case 100:
#line 2332 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
#line 7911 "parser.cpp"
    break;

  case 101:
#line 2338 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 7920 "parser.cpp"
    break;

  case 102:
#line 2343 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-1].Regex), nullptr);
        }
#line 7929 "parser.cpp"
    break;

  case 103:
#line 2348 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 7938 "parser.cpp"
    break;

  case 104:
#line 2353 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[-1].Regex), nullptr);
        }
#line 7947 "parser.cpp"
    break;

  case 105:
#line 2358 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 7956 "parser.cpp"
    break;

  case 106:
#line 2363 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-1].Regex), nullptr);
        }
#line 7965 "parser.cpp"
    break;

  case 107:
#line 2368 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, 0, (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7975 "parser.cpp"
    break;

  case 108:
#line 2374 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            check_case(loc, 0, (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[-1].qv), nullptr);
        }
#line 7985 "parser.cpp"
    break;

  case 109:
#line 2380 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), (yyvsp[0].sblock), true);
        }
#line 7994 "parser.cpp"
    break;

  case 110:
#line 2385 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), nullptr, true);
        }
#line 8003 "parser.cpp"
    break;

  case 111:
#line 2392 "parser.ypp"
                                                                              {
            char* param = 0;
            const QoreTypeInfo* typeInfo = nullptr;
            QoreParseTypeInfo* parseTypeInfo = nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-2].qv).getType() == NT_VARREF) {
                VarRefNode* varRefNode = (yyvsp[-2].qv).get<VarRefNode>();
                param = varRefNode->takeName();
                if (varRefNode->isDecl()) {
                    VarRefDeclNode* varRefDeclNode = static_cast<VarRefDeclNode*>(varRefNode);
                    parseTypeInfo = varRefDeclNode->takeParseTypeInfo();
                    if (!parseTypeInfo)
                        typeInfo = varRefDeclNode->getTypeInfo();
                }
            } else if ((yyvsp[-2].qv).getType() == NT_BAREWORD) {
                param = (yyvsp[-2].qv).get<BarewordNode>()->takeString();
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "local variable '%s' in catch parameter list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", param);
            } else if ((yyvsp[-2].qv)) {
                parse_error(*loc, "only one parameter accepted in catch block for exception hash");
            }
            (yyvsp[-2].qv).discard(nullptr);
            const QoreProgramLocation* vloc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].qv) ? (yylsp[-2]).first_line : 0, (yyvsp[-2].qv) ? (yylsp[-2]).last_line : 0);
            (yyval.statement) = new TryStatement(loc, (yyvsp[-5].sblock), (yyvsp[0].sblock), param, typeInfo, parseTypeInfo, vloc);
        }
#line 8033 "parser.cpp"
    break;

  case 112:
#line 2419 "parser.ypp"
                     { (yyval.qv).set(nullptr); }
#line 8039 "parser.cpp"
    break;

  case 113:
#line 2420 "parser.ypp"
                     { (yyval.qv).set((yyvsp[0].qv)); }
#line 8045 "parser.cpp"
    break;

  case 114:
#line 2421 "parser.ypp"
                     { (yyval.qv).set(nullptr); }
#line 8051 "parser.cpp"
    break;

  case 115:
#line 2425 "parser.ypp"
                                                                     {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_hashdeclmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[-3].string), (yyvsp[-1].hashdeclpriv));
        }
#line 8061 "parser.cpp"
    break;

  case 116:
#line 2430 "parser.ypp"
                                                                       {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_hashdeclmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[-3].string), (yyvsp[-1].hashdeclpriv));
        }
#line 8071 "parser.cpp"
    break;

  case 117:
#line 2438 "parser.ypp"
                                                                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_classmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
            qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-4].string), (yyvsp[-1].qoreclass));
        }
#line 8082 "parser.cpp"
    break;

  case 118:
#line 2444 "parser.ypp"
                                                                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[-4].nscope)->ostr);
            check_classmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-4].nscope), (yyvsp[-1].qoreclass));
            qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
        }
#line 8095 "parser.cpp"
    break;

  case 119:
#line 2452 "parser.ypp"
                                                          {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[-1]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreClass;
            qore_class_private::get(*qc)->loc = loc;
            check_classmod(loc, (yyvsp[-3].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-2].string), qc);
        }
#line 8109 "parser.cpp"
    break;

  case 120:
#line 2461 "parser.ypp"
                                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[-1]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[-2].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreClass;
            qore_class_private::get(*qc)->loc = loc;
            check_classmod(loc, (yyvsp[-3].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-2].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
        }
#line 8125 "parser.cpp"
    break;

  case 121:
#line 2472 "parser.ypp"
                                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreClass;
            qore_class_private::get(*qc)->loc = loc;
            check_classmod(loc, (yyvsp[-4].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-3].string), qc);
        }
#line 8139 "parser.cpp"
    break;

  case 122:
#line 2481 "parser.ypp"
                                                                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[-3].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreClass;
            qore_class_private::get(*qc)->loc = loc;
            check_classmod(loc, (yyvsp[-4].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-3].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
        }
#line 8155 "parser.cpp"
    break;

  case 123:
#line 2495 "parser.ypp"
                                     {
           (yyval.sclist) = (yyvsp[0].sclist);
        }
#line 8163 "parser.cpp"
    break;

  case 124:
#line 2498 "parser.ypp"
          { // NOTHING
           (yyval.sclist) = 0;
        }
#line 8171 "parser.cpp"
    break;

  case 125:
#line 2504 "parser.ypp"
                   {
           (yyval.sclist) = new BCList((yyvsp[0].sclnode));
        }
#line 8179 "parser.cpp"
    break;

  case 126:
#line 2507 "parser.ypp"
                                         {
           (yyvsp[-2].sclist)->push_back((yyvsp[0].sclnode));
           (yyval.sclist) = (yyvsp[-2].sclist);
        }
#line 8188 "parser.cpp"
    break;

  case 127:
#line 2514 "parser.ypp"
                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Public);
        }
#line 8197 "parser.cpp"
    break;

  case 128:
#line 2518 "parser.ypp"
                     {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Public);
        }
#line 8206 "parser.cpp"
    break;

  case 129:
#line 2522 "parser.ypp"
                                {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Public);
        }
#line 8215 "parser.cpp"
    break;

  case 130:
#line 2526 "parser.ypp"
                                {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Public);
        }
#line 8224 "parser.cpp"
    break;

  case 131:
#line 2530 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Private);
        }
#line 8233 "parser.cpp"
    break;

  case 132:
#line 2534 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Private);
        }
#line 8242 "parser.cpp"
    break;

  case 133:
#line 2538 "parser.ypp"
                                          {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Private);
        }
#line 8251 "parser.cpp"
    break;

  case 134:
#line 2542 "parser.ypp"
                                          {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Private);
        }
#line 8260 "parser.cpp"
    break;

  case 135:
#line 2546 "parser.ypp"
                                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Internal);
        }
#line 8269 "parser.cpp"
    break;

  case 136:
#line 2550 "parser.ypp"
                                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Internal);
        }
#line 8278 "parser.cpp"
    break;

  case 137:
#line 2557 "parser.ypp"
                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.hashdeclpriv) = new typed_hash_decl_private(loc);
            if ((yyvsp[0].memberinfo)) {
                (yyval.hashdeclpriv)->parseAdd((yyvsp[0].memberinfo)->getHashMemPair());
                delete (yyvsp[0].memberinfo);
            }
        }
#line 8291 "parser.cpp"
    break;

  case 138:
#line 2565 "parser.ypp"
                                         {
           if ((yyvsp[0].memberinfo)) {
              if ((yyvsp[-1].hashdeclpriv)->hasMember((yyvsp[0].memberinfo)->name)) {
                 parse_error(*(yyvsp[0].memberinfo)->loc, "duplicate hashdecl member declaration '%s'", (yyvsp[0].memberinfo)->name);
              }
              else {
                 // add new member to list
                 (yyvsp[-1].hashdeclpriv)->parseAdd((yyvsp[0].memberinfo)->getHashMemPair());
              }
              delete (yyvsp[0].memberinfo);
           }

           (yyval.hashdeclpriv) = (yyvsp[-1].hashdeclpriv);
        }
#line 8310 "parser.cpp"
    break;

  case 139:
#line 2582 "parser.ypp"
                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
        }
#line 8320 "parser.cpp"
    break;

  case 140:
#line 2587 "parser.ypp"
                                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            delete (yyvsp[-4].parsertype);
        }
#line 8330 "parser.cpp"
    break;

  case 141:
#line 2592 "parser.ypp"
                                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

            if (!(yyvsp[-5].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* aloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti->subtypes.size()) {
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(aloc, (yyvsp[-2].qv)));
                }
                else {
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(aloc, (yyvsp[-2].qv)));
                }
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new HashDeclMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
        }
#line 8359 "parser.cpp"
    break;

  case 142:
#line 2619 "parser.ypp"
                         {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = (yyvsp[0].methodnode)->getLoc();
           (yyvsp[0].methodnode)->addAndDelete((yyval.qoreclass));
        }
#line 8369 "parser.cpp"
    break;

  case 143:
#line 2624 "parser.ypp"
                               {
            (yyval.qoreclass) = new QoreClass;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::get(*(yyval.qoreclass))->loc = loc;
            (yyvsp[0].memberlist)->merge((yyval.qoreclass), Internal);
            delete (yyvsp[0].memberlist);
        }
#line 8381 "parser.cpp"
    break;

  case 144:
#line 2631 "parser.ypp"
                              {
            (yyval.qoreclass) = new QoreClass;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::get(*(yyval.qoreclass))->loc = loc;
            (yyvsp[0].memberlist)->merge((yyval.qoreclass), Private);
            delete (yyvsp[0].memberlist);
        }
#line 8393 "parser.cpp"
    break;

  case 145:
#line 2638 "parser.ypp"
                             {
            (yyval.qoreclass) = new QoreClass;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::get(*(yyval.qoreclass))->loc = loc;
            (yyvsp[0].memberlist)->merge((yyval.qoreclass), Public);
            delete (yyvsp[0].memberlist);
        }
#line 8405 "parser.cpp"
    break;

  case 146:
#line 2645 "parser.ypp"
                              {
            (yyval.qoreclass) = new QoreClass;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::get(*(yyval.qoreclass))->loc = loc;
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue(), Public);
            delete (yyvsp[0].constnode);
        }
#line 8417 "parser.cpp"
    break;

  case 147:
#line 2652 "parser.ypp"
                                            {
            (yyvsp[0].methodnode)->addAndDelete((yyvsp[-1].qoreclass));
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
        }
#line 8426 "parser.cpp"
    break;

  case 148:
#line 2656 "parser.ypp"
                                                {
            (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Internal);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].memberlist);
        }
#line 8436 "parser.cpp"
    break;

  case 149:
#line 2661 "parser.ypp"
                                               {
            (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Private);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].memberlist);
        }
#line 8446 "parser.cpp"
    break;

  case 150:
#line 2666 "parser.ypp"
                                              {
            (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Public);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].memberlist);
        }
#line 8456 "parser.cpp"
    break;

  case 151:
#line 2671 "parser.ypp"
                                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue(), Public);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].constnode);
        }
#line 8467 "parser.cpp"
    break;

  case 152:
#line 2680 "parser.ypp"
                   {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string), false);
        }
#line 8475 "parser.cpp"
    break;

  case 153:
#line 2683 "parser.ypp"
                     {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[0].string), false));
        }
#line 8483 "parser.cpp"
    break;

  case 154:
#line 2686 "parser.ypp"
                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[0].string), false);
        }
#line 8492 "parser.cpp"
    break;

  case 155:
#line 2690 "parser.ypp"
                         {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string), true);
        }
#line 8500 "parser.cpp"
    break;

  case 156:
#line 2693 "parser.ypp"
                         {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[0].string), true));
        }
#line 8508 "parser.cpp"
    break;

  case 157:
#line 2696 "parser.ypp"
                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[0].string), true);
        }
#line 8517 "parser.cpp"
    break;

  case 158:
#line 2704 "parser.ypp"
        { (yyval.parsertype) = 0; }
#line 8523 "parser.cpp"
    break;

  case 159:
#line 2705 "parser.ypp"
                      {
           (yyval.parsertype) = (yyvsp[0].parsertype);
        }
#line 8531 "parser.cpp"
    break;

  case 160:
#line 2711 "parser.ypp"
                                                          { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8537 "parser.cpp"
    break;

  case 161:
#line 2712 "parser.ypp"
                                                          { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8543 "parser.cpp"
    break;

  case 162:
#line 2713 "parser.ypp"
                                                          { (yyval.memberlist) = new EmptyMemberList; }
#line 8549 "parser.cpp"
    break;

  case 163:
#line 2717 "parser.ypp"
                                                  { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8555 "parser.cpp"
    break;

  case 164:
#line 2718 "parser.ypp"
                                                  { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8561 "parser.cpp"
    break;

  case 165:
#line 2719 "parser.ypp"
                                                  { (yyval.memberlist) = new EmptyMemberList; }
#line 8567 "parser.cpp"
    break;

  case 166:
#line 2720 "parser.ypp"
                                                  { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8573 "parser.cpp"
    break;

  case 167:
#line 2721 "parser.ypp"
                                                  { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8579 "parser.cpp"
    break;

  case 168:
#line 2722 "parser.ypp"
                                                  { (yyval.memberlist) = new EmptyMemberList; }
#line 8585 "parser.cpp"
    break;

  case 169:
#line 2726 "parser.ypp"
                                            { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8591 "parser.cpp"
    break;

  case 170:
#line 2727 "parser.ypp"
                                            { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8597 "parser.cpp"
    break;

  case 171:
#line 2728 "parser.ypp"
                                            { (yyval.memberlist) = new EmptyMemberList; }
#line 8603 "parser.cpp"
    break;

  case 172:
#line 2732 "parser.ypp"
                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
        }
#line 8613 "parser.cpp"
    break;

  case 173:
#line 2737 "parser.ypp"
                                    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo(loc));
        }
#line 8622 "parser.cpp"
    break;

  case 174:
#line 2741 "parser.ypp"
                                                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
            delete (yyvsp[-4].parsertype);
        }
#line 8633 "parser.cpp"
    break;

  case 175:
#line 2747 "parser.ypp"
                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo(loc, nullptr, nullptr, (yyvsp[-1].qv)));
        }
#line 8642 "parser.cpp"
    break;

  case 176:
#line 2751 "parser.ypp"
                                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

            if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[-2].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[-2].qv)));
            }

            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-4].string), new QoreVarInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
        }
#line 8667 "parser.cpp"
    break;

  case 177:
#line 2774 "parser.ypp"
                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].parsertype) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
        }
#line 8679 "parser.cpp"
    break;

  case 178:
#line 2781 "parser.ypp"
                                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].parsertype) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            delete (yyvsp[-4].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-3].string));
        }
#line 8691 "parser.cpp"
    break;

  case 179:
#line 2788 "parser.ypp"
                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = (yyvsp[-5].parsertype) ? ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)) : nullptr;

            if (!(yyvsp[-5].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti && pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[-2].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[-2].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-4].string));
        }
#line 8720 "parser.cpp"
    break;

  case 180:
#line 2812 "parser.ypp"
                                     {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
        }
#line 8732 "parser.cpp"
    break;

  case 181:
#line 2819 "parser.ypp"
                                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            delete (yyvsp[-4].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
        }
#line 8744 "parser.cpp"
    break;

  case 182:
#line 2826 "parser.ypp"
                                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

            if (!(yyvsp[-5].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[-2].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[-2].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-4].string));
        }
#line 8773 "parser.cpp"
    break;

  case 183:
#line 2850 "parser.ypp"
                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
        }
#line 8784 "parser.cpp"
    break;

  case 184:
#line 2856 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, nullptr, nullptr, (yyvsp[-1].qv)));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
        }
#line 8795 "parser.cpp"
    break;

  case 185:
#line 2862 "parser.ypp"
                       {
            (yyval.memberinfo) = (yyvsp[0].classvarinfo);
        }
#line 8803 "parser.cpp"
    break;

  case 186:
#line 2865 "parser.ypp"
                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[0].constnode)->pub)
                parse_error(*loc, "cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[0].constnode)->name.ostr);
            (yyval.memberinfo) = new MemberInfo(loc, (yyvsp[0].constnode)->name.takeName(), (yyvsp[0].constnode)->value);
            delete (yyvsp[0].constnode);
        }
#line 8815 "parser.cpp"
    break;

  case 187:
#line 2875 "parser.ypp"
                              {
            (yyval.memberinfo) = (yyvsp[0].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
#line 8824 "parser.cpp"
    break;

  case 188:
#line 2882 "parser.ypp"
                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[0].string), new QoreMemberInfo(loc));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 8835 "parser.cpp"
    break;

  case 189:
#line 2888 "parser.ypp"
                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, nullptr, new QoreParseTypeInfo((yyvsp[0].string))));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
        }
#line 8846 "parser.cpp"
    break;

  case 190:
#line 2897 "parser.ypp"
                             {
            (yyval.memberinfo) = (yyvsp[0].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
#line 8855 "parser.cpp"
    break;

  case 191:
#line 2904 "parser.ypp"
               {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8863 "parser.cpp"
    break;

  case 192:
#line 2907 "parser.ypp"
                           {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8871 "parser.cpp"
    break;

  case 193:
#line 2910 "parser.ypp"
                                 {
           (yyvsp[-2].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-2].memberlist);
        }
#line 8880 "parser.cpp"
    break;

  case 194:
#line 2914 "parser.ypp"
                                           {
           (yyvsp[-2].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-2].memberlist);
        }
#line 8889 "parser.cpp"
    break;

  case 195:
#line 2921 "parser.ypp"
                {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8897 "parser.cpp"
    break;

  case 196:
#line 2924 "parser.ypp"
                            {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8905 "parser.cpp"
    break;

  case 197:
#line 2927 "parser.ypp"
                               {
           (yyvsp[-1].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-1].memberlist);
        }
#line 8914 "parser.cpp"
    break;

  case 198:
#line 2931 "parser.ypp"
                                         {
           (yyvsp[-1].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-1].memberlist);
        }
#line 8923 "parser.cpp"
    break;

  case 199:
#line 2938 "parser.ypp"
                       {
           (yyval.string) = (yyvsp[-1].string);
        }
#line 8931 "parser.cpp"
    break;

  case 200:
#line 2941 "parser.ypp"
                       {
           (yyval.string) = strdup("keys");
        }
#line 8939 "parser.cpp"
    break;

  case 201:
#line 2944 "parser.ypp"
                                  {
           (yyval.string) = (yyvsp[0].string);
        }
#line 8947 "parser.cpp"
    break;

  case 202:
#line 2950 "parser.ypp"
                                                                                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            check_method(loc, (yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[-5].string), new_method_variant(loc, (yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8963 "parser.cpp"
    break;

  case 203:
#line 2961 "parser.ypp"
                                                                                          {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            check_method(loc, (yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[-4].string), new_method_variant(loc, (yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8983 "parser.cpp"
    break;

  case 204:
#line 2976 "parser.ypp"
                                                                                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            check_method(loc, (yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[-5].string), new_method_variant(loc, (yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8995 "parser.cpp"
    break;

  case 205:
#line 2983 "parser.ypp"
                                                                                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            check_method(loc, (yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[-4].string), new_method_variant(loc, (yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 9011 "parser.cpp"
    break;

  case 206:
#line 2997 "parser.ypp"
                                                                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
        }
#line 9027 "parser.cpp"
    break;

  case 207:
#line 3008 "parser.ypp"
                                                                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
        }
#line 9045 "parser.cpp"
    break;

  case 208:
#line 3021 "parser.ypp"
                                                                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0);
        }
#line 9056 "parser.cpp"
    break;

  case 209:
#line 3027 "parser.ypp"
                                                                                          {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, 0);
        }
#line 9070 "parser.cpp"
    break;

  case 210:
#line 3036 "parser.ypp"
                                                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
        }
#line 9079 "parser.cpp"
    break;

  case 211:
#line 3040 "parser.ypp"
                                                                           {
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
        }
#line 9091 "parser.cpp"
    break;

  case 212:
#line 3050 "parser.ypp"
                              {
           (yyval.bcalist) = (yyvsp[0].bcalist);
        }
#line 9099 "parser.cpp"
    break;

  case 213:
#line 3053 "parser.ypp"
          { // nothing
           (yyval.bcalist) = 0;
        }
#line 9107 "parser.cpp"
    break;

  case 214:
#line 3059 "parser.ypp"
                         {
           (yyval.bcalist) = new BCAList((yyvsp[0].bcanode));
        }
#line 9115 "parser.cpp"
    break;

  case 215:
#line 3062 "parser.ypp"
                                                 {
           (yyvsp[-2].bcalist)->push_back((yyvsp[0].bcanode));
           (yyval.bcalist) = (yyvsp[-2].bcalist);
        }
#line 9124 "parser.cpp"
    break;

  case 216:
#line 3069 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.bcanode) = new BCANode((yyvsp[-3].string), make_args(loc, (yyvsp[-1].qv)), loc);
        }
#line 9133 "parser.cpp"
    break;

  case 217:
#line 3073 "parser.ypp"
                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[-3].string)), make_args(loc, (yyvsp[-1].qv)), loc);
        }
#line 9142 "parser.cpp"
    break;

  case 218:
#line 3081 "parser.ypp"
        { (yyval.i4) = 0; }
#line 9148 "parser.cpp"
    break;

  case 219:
#line 3082 "parser.ypp"
                           {
           (yyval.i4) = (yyvsp[0].i4);
        }
#line 9156 "parser.cpp"
    break;

  case 220:
#line 3087 "parser.ypp"
                        { (yyval.i4) = (yyvsp[0].i4); }
#line 9162 "parser.cpp"
    break;

  case 221:
#line 3088 "parser.ypp"
                                           {
            if (((yyvsp[-1].i4) | (yyvsp[0].i4)) == (yyvsp[-1].i4)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "modifier given twice");
            }
            (yyval.i4) = (yyvsp[-1].i4) | (yyvsp[0].i4);
        }
#line 9174 "parser.cpp"
    break;

  case 222:
#line 3098 "parser.ypp"
                    { (yyval.i4) = OFM_PRIVATE; }
#line 9180 "parser.cpp"
    break;

  case 223:
#line 3099 "parser.ypp"
                               { (yyval.i4) = OFM_PRIVATE; }
#line 9186 "parser.cpp"
    break;

  case 224:
#line 3100 "parser.ypp"
                              { (yyval.i4) = OFM_INTERNAL; }
#line 9192 "parser.cpp"
    break;

  case 225:
#line 3101 "parser.ypp"
                     { (yyval.i4) = OFM_STATIC; }
#line 9198 "parser.cpp"
    break;

  case 226:
#line 3102 "parser.ypp"
                           { (yyval.i4) = OFM_SYNCED; }
#line 9204 "parser.cpp"
    break;

  case 227:
#line 3103 "parser.ypp"
                         { (yyval.i4) = OFM_DEPRECATED; }
#line 9210 "parser.cpp"
    break;

  case 228:
#line 3104 "parser.ypp"
                     { (yyval.i4) = OFM_PUBLIC; }
#line 9216 "parser.cpp"
    break;

  case 229:
#line 3105 "parser.ypp"
                    { (yyval.i4) = OFM_FINAL; }
#line 9222 "parser.cpp"
    break;

  case 230:
#line 3106 "parser.ypp"
                       { (yyval.i4) = OFM_ABSTRACT; }
#line 9228 "parser.cpp"
    break;

  case 231:
#line 3110 "parser.ypp"
                             {
            // see if the deprecated "returns" keyword can be used
            if (!parse_check_parse_option(PO_ALLOW_RETURNS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "illegal use of the deprecated \"returns\" keyword (enable by setting parse option PO_ALLOW_RETURNS)");
            }

            if (!(yyvsp[0].parsertype)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "missing type declaration after 'returns'");
                (yyval.returnTypeInfo) = 0;
            } else {
                (yyval.returnTypeInfo) = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[0].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[0].parsertype)));
                delete (yyvsp[0].parsertype);
            }
        }
#line 9249 "parser.cpp"
    break;

  case 232:
#line 3127 "parser.ypp"
        {
            (yyval.returnTypeInfo) = 0;
        }
#line 9257 "parser.cpp"
    break;

  case 233:
#line 3133 "parser.ypp"
                                                             {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), false, flags));
        }
#line 9268 "parser.cpp"
    break;

  case 234:
#line 3139 "parser.ypp"
                                                              {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, false, flags));
        }
#line 9283 "parser.cpp"
    break;

  case 235:
#line 3149 "parser.ypp"
                                                                                {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-6].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
#line 9300 "parser.cpp"
    break;

  case 236:
#line 3161 "parser.ypp"
                                                                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, (yyvsp[-6].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-6].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
#line 9320 "parser.cpp"
    break;

  case 237:
#line 3179 "parser.ypp"
                                                            {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), false, flags));
        }
#line 9331 "parser.cpp"
    break;

  case 238:
#line 3185 "parser.ypp"
                                                             {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, false, flags));
        }
#line 9346 "parser.cpp"
    break;

  case 239:
#line 3195 "parser.ypp"
                                                                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-7].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-7].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), (yyvsp[-7].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-7].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
#line 9363 "parser.cpp"
    break;

  case 240:
#line 3207 "parser.ypp"
                                                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-7].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-7].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, (yyvsp[-7].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-7].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
#line 9383 "parser.cpp"
    break;

  case 241:
#line 3225 "parser.ypp"
                    {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[-2].qv), (yyvsp[0].qv), loc1, loc3);
        }
#line 9393 "parser.cpp"
    break;

  case 242:
#line 3230 "parser.ypp"
                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            QoreParseListNode* l;
            if ((yyvsp[-1].qv).getType() == NT_PARSE_LIST) {
                l = (yyvsp[-1].qv).get<QoreParseListNode>();
                if (l->isFinalized()) {
                    QoreParseListNode* nl = new QoreParseListNode(loc);
                    nl->add(l, loc);
                    l = nl;
                }
            }
            else {
                l = new QoreParseListNode(loc);
                l->add((yyvsp[-1].qv), loc);
            }
            (yyval.parse_list) = l;
        }
#line 9415 "parser.cpp"
    break;

  case 243:
#line 3250 "parser.ypp"
                      {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[-2].qv), (yyvsp[0].qv), loc1, loc3);
        }
#line 9425 "parser.cpp"
    break;

  case 244:
#line 3255 "parser.ypp"
                    {
            QoreParseListNode* l;
            if ((yyvsp[-1].qv).getType() == NT_PARSE_LIST)
                l = (yyvsp[-1].qv).get<QoreParseListNode>();
            else {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
                l = new QoreParseListNode(loc);
                l->add((yyvsp[-1].qv), loc);
            }
            (yyval.parse_list) = l;
        }
#line 9441 "parser.cpp"
    break;

  case 245:
#line 3269 "parser.ypp"
                     {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.hash) = new QoreParseHashNode(loc);
            (yyvsp[0].hashelement)->addDelete((yyval.hash));
        }
#line 9451 "parser.cpp"
    break;

  case 246:
#line 3274 "parser.ypp"
                                {
            (yyvsp[0].hashelement)->addDelete((yyvsp[-2].hash));
            (yyval.hash) = (yyvsp[-2].hash);
        }
#line 9460 "parser.cpp"
    break;

  case 247:
#line 3279 "parser.ypp"
        { /* empty ',' on end of hash */ (yyval.hash) = (yyvsp[-1].hash); }
#line 9466 "parser.cpp"
    break;

  case 248:
#line 3284 "parser.ypp"
        { (yyval.hashelement) = new HashElement((yyvsp[-2].qv), (yyvsp[0].qv), (yylsp[-2]).first_line, (yylsp[0]).last_line); }
#line 9472 "parser.cpp"
    break;

  case 249:
#line 3288 "parser.ypp"
                     {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[-1].hash)->setCurly();
            (yyvsp[-1].hash)->finalizeBlock((yylsp[-2]).first_line, (yylsp[0]).last_line);

            (yyval.hash) = (yyvsp[-1].hash);
        }
#line 9484 "parser.cpp"
    break;

  case 250:
#line 3298 "parser.ypp"
                                               {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[-1].hash)->setCurly();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[-2].string));
            free((yyvsp[-2].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), (yyvsp[-1].hash));
        }
#line 9498 "parser.cpp"
    break;

  case 251:
#line 3307 "parser.ypp"
                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[-1].string));
            free((yyvsp[-1].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), new QoreParseHashNode(loc, true));
        }
#line 9509 "parser.cpp"
    break;

  case 252:
#line 3317 "parser.ypp"
        { (yyval.qv).set((yyvsp[0].qv)); }
#line 9515 "parser.cpp"
    break;

  case 253:
#line 3319 "parser.ypp"
        { (yyval.qv).set((yyvsp[0].binary)); }
#line 9521 "parser.cpp"
    break;

  case 254:
#line 3321 "parser.ypp"
        { (yyval.qv).set((yyvsp[-1].hash)); }
#line 9527 "parser.cpp"
    break;

  case 255:
#line 3323 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ScopedRefNode(loc, (yyvsp[0].string)));
        }
#line 9536 "parser.cpp"
    break;

  case 256:
#line 3327 "parser.ypp"
                           {
            if (!(yyvsp[-1].parsertype) && !strcmp((yyvsp[0].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-1].parsertype) ? (yylsp[-1]).first_line : (yylsp[0]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-1].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[0].string), get_var_type()));

            delete (yyvsp[-1].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9555 "parser.cpp"
    break;

  case 257:
#line 3341 "parser.ypp"
                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-1].parsertype) ? (yylsp[-1]).first_line : (yylsp[0]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-1].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[0].string), get_var_type()));

            delete (yyvsp[-1].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9571 "parser.cpp"
    break;

  case 258:
#line 3352 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype))));
            delete (yyvsp[-1].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 9583 "parser.cpp"
    break;

  case 259:
#line 3359 "parser.ypp"
                                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            VarRefDeclNode* v = new VarRefDeclNode(loc, (yyvsp[0].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
            v->setExplicitScope();
            (yyval.qv).set(v);
            delete (yyvsp[-1].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 9597 "parser.cpp"
    break;

  case 260:
#line 3368 "parser.ypp"
                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            // see if types are required
            if (parse_check_parse_option(PO_REQUIRE_TYPES))
                parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
            VarRefNode* v = new VarRefNode(loc, (yyvsp[0].string), VT_LOCAL);
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 9613 "parser.cpp"
    break;

  case 261:
#line 3379 "parser.ypp"
                                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            VarRefNode* v;
            if ((yyvsp[-1].parsertype)) {
                v = new VarRefDeclNode(loc, (yyvsp[0].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
                delete (yyvsp[-1].parsertype);
            }
            else {
                // see if types are required
                if (parse_check_parse_option(PO_REQUIRE_TYPES))
                    parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
                v = new VarRefNode(loc, (yyvsp[0].string), VT_LOCAL);
            }
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9636 "parser.cpp"
    break;

  case 262:
#line 3397 "parser.ypp"
                              {
            (yyvsp[-1].parse_list)->setVariableList();
            QoreParseListNode::nvec_t& vl = (yyvsp[-1].parse_list)->getValues();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            for (unsigned i = 0; i < vl.size(); ++i) {
                QoreValue& n = vl[i];
                qore_type_t t = n.getType();
                if (t == NT_BAREWORD) {
                    BarewordNode* b = n.get<BarewordNode>();
                    if (parse_check_parse_option(PO_REQUIRE_TYPES))
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
                    if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                        parse_error(*loc, "local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
                    VarRefNode* v = new VarRefNode(loc, b->takeString(), VT_LOCAL);
                    v->setExplicitScope();
                    b->deref();
                    n = v;
                }
                else if (t == NT_VARREF) {
                    VarRefNode* v = n.get<VarRefNode>();
                    // see if types are required
                    if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
                    if (v->explicitScope()) {
                        if (v->getType() == VT_LOCAL)
                            parse_error(*loc, "illegal use of 'my %s' in local variable declaration list", v->getName());
                        else if (v->getType() == VT_GLOBAL)
                            parse_error(*loc, "illegal use of 'our %s' in local variable declaration list", v->getName());
                    }
                    else
                        v->makeLocal();
                    v->setExplicitScope();
                }
                else
                    parse_error(*loc, "element %d in list following 'my' is not a variable reference (%s)", i, n.getTypeName());
            }
            (yyval.qv).set((yyvsp[-1].parse_list));
        }
#line 9679 "parser.cpp"
    break;

  case 263:
#line 3435 "parser.ypp"
                   {
            (yyval.qv).set((yyvsp[0].gv)->makeVar());
        }
#line 9687 "parser.cpp"
    break;

  case 264:
#line 3439 "parser.ypp"
        {
            if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[0].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new BarewordNode(loc, (yyvsp[0].string)));
        }
#line 9699 "parser.cpp"
    break;

  case 265:
#line 3447 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ContextrefNode(loc, (yyvsp[0].string)));
        }
#line 9708 "parser.cpp"
    break;

  case 266:
#line 3452 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ContextRowNode(loc));
        }
#line 9717 "parser.cpp"
    break;

  case 267:
#line 3457 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ComplexContextrefNode(loc, (yyvsp[0].string)));
        }
#line 9726 "parser.cpp"
    break;

  case 268:
#line 3462 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new FindNode(loc, (yyvsp[-6].qv), (yyvsp[-4].qv), (yyvsp[-1].qv)));
        }
#line 9735 "parser.cpp"
    break;

  case 269:
#line 3467 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreExistsOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9744 "parser.cpp"
    break;

  case 270:
#line 3472 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreElementsOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9753 "parser.cpp"
    break;

  case 271:
#line 3476 "parser.ypp"
                       {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreKeysOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9762 "parser.cpp"
    break;

  case 272:
#line 3480 "parser.ypp"
                          {  // unshift list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreUnshiftOperatorNode(loc, lv, l->shift()));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9781 "parser.cpp"
    break;

  case 273:
#line 3494 "parser.ypp"
                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreShiftOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9790 "parser.cpp"
    break;

  case 274:
#line 3498 "parser.ypp"
                       {  // push lvalue-list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QorePushOperatorNode(loc, lv, l->shift()));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9809 "parser.cpp"
    break;

  case 275:
#line 3512 "parser.ypp"
                      {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QorePopOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9818 "parser.cpp"
    break;

  case 276:
#line 3516 "parser.ypp"
                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreChompOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9827 "parser.cpp"
    break;

  case 277:
#line 3520 "parser.ypp"
                       {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreTrimOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9836 "parser.cpp"
    break;

  case 278:
#line 3524 "parser.ypp"
                         {  // splice lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreSpliceOperatorNode(loc, lv, l->shift(), l->shift(), l->shift()));
                discard(l, 0);
            }
        }
#line 9865 "parser.cpp"
    break;

  case 279:
#line 3548 "parser.ypp"
                          {  // extract lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreExtractOperatorNode(loc, lv, l->shift(), l->shift(), l->shift()));
                discard(l, 0);
            }
        }
#line 9894 "parser.cpp"
    break;

  case 280:
#line 3572 "parser.ypp"
                      {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            int len = l ? (int)l->size() : 0;
            if (!l || len < 2 || len > 3) {
                parse_error(*loc, "invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else {
                // get first expression from list
                QoreValue exp = l->shift();
                qore_type_t t = exp.getType();
                (yyval.qv).set(nullptr);
                bool is_curly = false;
                if (t == NT_PARSE_HASH) {
                    QoreParseHashNode* phn = exp.get<QoreParseHashNode>();
                    if (phn->isCurly()) {
                        is_curly = true;
                        (yyval.qv).set(parse_hash_map(loc, phn, l));
                    }
                }

                if (!(yyval.qv) && !is_curly) {
                    (yyval.qv).set(parse_map(loc, exp, l));
                }
            }
        }
#line 9927 "parser.cpp"
    break;

  case 281:
#line 3600 "parser.ypp"
                        {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldrOperatorNode(loc, code_exp, arg));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9948 "parser.cpp"
    break;

  case 282:
#line 3616 "parser.ypp"
                        {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldlOperatorNode(loc, code_exp, arg));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9969 "parser.cpp"
    break;

  case 283:
#line 3632 "parser.ypp"
                         {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue arg = l->shift();
                QoreValue select_exp = l->shift();
                (yyval.qv).set(new QoreSelectOperatorNode(loc, arg, select_exp));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9990 "parser.cpp"
    break;

  case 284:
#line 3648 "parser.ypp"
                          {  // pre-increment
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QorePreIncrementOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9999 "parser.cpp"
    break;

  case 285:
#line 3652 "parser.ypp"
                          {  // pre-decrement
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QorePreDecrementOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10008 "parser.cpp"
    break;

  case 286:
#line 3656 "parser.ypp"
                                        {
            printd(5, "parsing in-object base class method call %s()\n", (yyvsp[-3].nscope)->ostr);
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            if (!strcmp((yyvsp[-3].nscope)->getIdentifier(), "copy"))
                parse_error(*loc, "illegal call to base class copy method '%s'", (yyvsp[-3].nscope)->ostr);

            (yyval.qv).set(new SelfFunctionCallNode(loc, (yyvsp[-3].nscope), make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].qv))));
        }
#line 10021 "parser.cpp"
    break;

  case 287:
#line 3664 "parser.ypp"
                                            {
            printd(5, "parsing call %s()\n", (yyvsp[-2].string));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new FunctionCallNode(loc, (yyvsp[-2].string), make_args(argsloc, (yyvsp[-1].qv))));
        }
#line 10032 "parser.cpp"
    break;

  case 288:
#line 3671 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new SelfVarrefNode(loc, (yyvsp[0].string)));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 10043 "parser.cpp"
    break;

  case 289:
#line 3677 "parser.ypp"
                            {
            // FIXME: need to expand constant expression checking to determine
            //        if the expression can throw an exception at run-time
            // first check for constant expressions
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreUnaryMinusOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10055 "parser.cpp"
    break;

  case 290:
#line 3685 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreUnaryPlusOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10064 "parser.cpp"
    break;

  case 291:
#line 3689 "parser.ypp"
                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreBinaryNotOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10073 "parser.cpp"
    break;

  case 292:
#line 3693 "parser.ypp"
                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreLogicalNotOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10082 "parser.cpp"
    break;

  case 293:
#line 3697 "parser.ypp"
                   {
            qore_type_t t = (yyvsp[0].qv).getType();
            //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2.getTypeName());

            if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
                (yyval.qv).set((yyvsp[0].qv).get<FunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_SELF_CALL) {
                (yyval.qv).set((yyvsp[0].qv).get<SelfFunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_STATIC_METHOD_CALL) {
                (yyval.qv).set((yyvsp[0].qv).get<StaticMethodCallNode>()->makeReferenceNodeAndDeref());
            }
            else {
                bool make_ref = true;

                if (t == NT_OPERATOR) {
                    QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[0].qv).getInternalNode());
                    if (deon) {
                        (yyval.qv).set(deon->makeCallReference());
                        make_ref = false;
                    }
                }

                if (make_ref) {
                    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                    //printd(5, "type=%s\n", $2.getTypeName());
                    (yyval.qv).set(new ParseReferenceNode(loc, (yyvsp[0].qv)));
                }
            }
        }
#line 10118 "parser.cpp"
    break;

  case 294:
#line 3728 "parser.ypp"
                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[-3].string)), make_args(argsloc, (yyvsp[-1].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 10130 "parser.cpp"
    break;

  case 295:
#line 3735 "parser.ypp"
                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[-3].string)), make_args(argsloc, (yyvsp[-1].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 10142 "parser.cpp"
    break;

  case 296:
#line 3742 "parser.ypp"
                                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new ParseNewComplexTypeNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), false), make_args(argsloc, (yyvsp[-1].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 10154 "parser.cpp"
    break;

  case 297:
#line 3749 "parser.ypp"
                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreBackgroundOperatorNode(loc, (yyvsp[0].qv)));
            // check to see if the expression is legal
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
                parse_error(*loc, "illegal use of 'background' operator (conflicts with parse option PO_NO_THREAD_CONTROL)");
            else if (!value_has_effect_as_root((yyvsp[0].qv))) {
                if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                    parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[0].qv).getTypeName());
                }
            } else if (!(yyvsp[0].qv).hasEffect()) {
                parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[0].qv).getTypeName());
            }
        }
#line 10173 "parser.cpp"
    break;

  case 298:
#line 3763 "parser.ypp"
                    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new BackquoteNode(loc, (yyvsp[0].string)));
            if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
                parse_error(*loc, "illegal use of backquote operator (conflicts with parse option PO_NO_EXTERNAL_PROCESS)");
        }
#line 10184 "parser.cpp"
    break;

  case 299:
#line 3769 "parser.ypp"
                      {
            (yyval.qv).set((yyvsp[-1].qv));
            switch ((yyvsp[-1].qv).getType()) {
                case NT_PARSE_LIST:
                    (yyvsp[-1].qv).get<QoreParseListNode>()->setFinalized();
                    break;
                case NT_FUNCTION_CALL:
                    (yyvsp[-1].qv).get<FunctionCallNode>()->setFinalized();
                    break;
                case NT_BAREWORD:
                    (yyvsp[-1].qv).get<BarewordNode>()->setFinalized();
                    break;
                case NT_OPERATOR:
                    (yyvsp[-1].qv).get<QoreOperatorNode>()->setInParentheses();
                    break;
            }
        }
#line 10206 "parser.cpp"
    break;

  case 300:
#line 3786 "parser.ypp"
                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreParseListNode* l = new QoreParseListNode(loc);
            l->setFinalized();
            (yyval.qv).set(l);
        }
#line 10217 "parser.cpp"
    break;

  case 301:
#line 3792 "parser.ypp"
                                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
#line 10227 "parser.cpp"
    break;

  case 302:
#line 3797 "parser.ypp"
                                                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
#line 10240 "parser.cpp"
    break;

  case 303:
#line 3805 "parser.ypp"
                                                                    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) | OFM_SYNCED, flags)));
        }
#line 10254 "parser.cpp"
    break;

  case 304:
#line 3814 "parser.ypp"
                                                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, (yyvsp[-6].i4) | OFM_SYNCED, flags)));
        }
#line 10272 "parser.cpp"
    break;

  case 305:
#line 3827 "parser.ypp"
                           {
            (yyval.qv).set((yyvsp[0].implicit_arg));
            inc_numeric_argv_ref();
        }
#line 10281 "parser.cpp"
    break;

  case 306:
#line 3831 "parser.ypp"
                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreImplicitElementNode(loc));
        }
#line 10290 "parser.cpp"
    break;

  case 307:
#line 3835 "parser.ypp"
                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreDeleteOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10299 "parser.cpp"
    break;

  case 308:
#line 3839 "parser.ypp"
                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreRemoveOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10308 "parser.cpp"
    break;

  case 309:
#line 3843 "parser.ypp"
                                {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), false), (yyvsp[-1].qv)));
        }
#line 10317 "parser.cpp"
    break;

  case 310:
#line 3847 "parser.ypp"
                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), true), (yyvsp[-1].qv)));
        }
#line 10326 "parser.cpp"
    break;

  case 311:
#line 3854 "parser.ypp"
                                        { (yyval.qv).set((yyvsp[0].qv)); }
#line 10332 "parser.cpp"
    break;

  case 312:
#line 3855 "parser.ypp"
                                        { (yyval.qv).set((yyvsp[0].parse_list)); }
#line 10338 "parser.cpp"
    break;

  case 313:
#line 3856 "parser.ypp"
                                        { (yyval.qv).set((yyvsp[0].hash)); }
#line 10344 "parser.cpp"
    break;

  case 314:
#line 3857 "parser.ypp"
                                        { (yyval.qv).set((yyvsp[0].node)); }
#line 10350 "parser.cpp"
    break;

  case 315:
#line 3858 "parser.ypp"
                                        { (yyval.qv).set(new QoreParseHashNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), true)); }
#line 10356 "parser.cpp"
    break;

  case 316:
#line 3859 "parser.ypp"
                                        { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10362 "parser.cpp"
    break;

  case 317:
#line 3860 "parser.ypp"
                                        { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10368 "parser.cpp"
    break;

  case 318:
#line 3861 "parser.ypp"
                                        { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10374 "parser.cpp"
    break;

  case 319:
#line 3862 "parser.ypp"
                                        { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10380 "parser.cpp"
    break;

  case 320:
#line 3863 "parser.ypp"
                                        { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10386 "parser.cpp"
    break;

  case 321:
#line 3864 "parser.ypp"
                                        { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10392 "parser.cpp"
    break;

  case 322:
#line 3865 "parser.ypp"
                                        { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10398 "parser.cpp"
    break;

  case 323:
#line 3866 "parser.ypp"
                                        { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10404 "parser.cpp"
    break;

  case 324:
#line 3867 "parser.ypp"
                                        { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10410 "parser.cpp"
    break;

  case 325:
#line 3868 "parser.ypp"
                                        { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10416 "parser.cpp"
    break;

  case 326:
#line 3869 "parser.ypp"
                                        { (yyval.qv).set(process_assignment((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10422 "parser.cpp"
    break;

  case 327:
#line 3870 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10435 "parser.cpp"
    break;

  case 328:
#line 3878 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        (yyval.qv).set((yyvsp[0].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getParseTypeInfo()));
        delete (yyvsp[0].parsertype);
    }
#line 10447 "parser.cpp"
    break;

  case 329:
#line 3885 "parser.ypp"
                                        { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10453 "parser.cpp"
    break;

  case 330:
#line 3886 "parser.ypp"
                                        { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10459 "parser.cpp"
    break;

  case 331:
#line 3887 "parser.ypp"
                                        { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10465 "parser.cpp"
    break;

  case 332:
#line 3888 "parser.ypp"
                                        { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 10471 "parser.cpp"
    break;

  case 333:
#line 3889 "parser.ypp"
                                        { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 10477 "parser.cpp"
    break;

  case 334:
#line 3890 "parser.ypp"
                                        { (yyval.qv).set(processCall((yylsp[-3]).first_line, (yylsp[0]).last_line, (yyvsp[-3].qv), (yyvsp[-1].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line))); }
#line 10483 "parser.cpp"
    break;

  case 335:
#line 3891 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_log_or(loc, (yyvsp[-2].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10493 "parser.cpp"
    break;

  case 336:
#line 3896 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10499 "parser.cpp"
    break;

  case 337:
#line 3897 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10505 "parser.cpp"
    break;

  case 338:
#line 3898 "parser.ypp"
                                        { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10511 "parser.cpp"
    break;

  case 339:
#line 3899 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10521 "parser.cpp"
    break;

  case 340:
#line 3904 "parser.ypp"
                                        { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10527 "parser.cpp"
    break;

  case 341:
#line 3905 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[-2].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10538 "parser.cpp"
    break;

  case 342:
#line 3911 "parser.ypp"
                                        { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10544 "parser.cpp"
    break;

  case 343:
#line 3912 "parser.ypp"
                                        { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10550 "parser.cpp"
    break;

  case 344:
#line 3913 "parser.ypp"
                                        { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10556 "parser.cpp"
    break;

  case 345:
#line 3914 "parser.ypp"
                                        { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].RegexSubst))); }
#line 10562 "parser.cpp"
    break;

  case 346:
#line 3915 "parser.ypp"
                                        { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Trans))); }
#line 10568 "parser.cpp"
    break;

  case 347:
#line 3916 "parser.ypp"
                                        { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10574 "parser.cpp"
    break;

  case 348:
#line 3917 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10580 "parser.cpp"
    break;

  case 349:
#line 3918 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10586 "parser.cpp"
    break;

  case 350:
#line 3919 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10592 "parser.cpp"
    break;

  case 351:
#line 3920 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10598 "parser.cpp"
    break;

  case 352:
#line 3921 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10604 "parser.cpp"
    break;

  case 353:
#line 3922 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10610 "parser.cpp"
    break;

  case 354:
#line 3923 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10616 "parser.cpp"
    break;

  case 355:
#line 3924 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10622 "parser.cpp"
    break;

  case 356:
#line 3925 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10628 "parser.cpp"
    break;

  case 357:
#line 3926 "parser.ypp"
                                        { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10634 "parser.cpp"
    break;

  case 358:
#line 3927 "parser.ypp"
                                        { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10640 "parser.cpp"
    break;

  case 359:
#line 3928 "parser.ypp"
                                        { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10646 "parser.cpp"
    break;

  case 360:
#line 3929 "parser.ypp"
                                        { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10652 "parser.cpp"
    break;

  case 361:
#line 3930 "parser.ypp"
                                        { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10658 "parser.cpp"
    break;

  case 362:
#line 3931 "parser.ypp"
                                        { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10664 "parser.cpp"
    break;

  case 363:
#line 3932 "parser.ypp"
                                        { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10670 "parser.cpp"
    break;

  case 364:
#line 3933 "parser.ypp"
                                        { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), QoreValue())); }
#line 10676 "parser.cpp"
    break;

  case 365:
#line 3934 "parser.ypp"
                                        { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), QoreValue(), (yyvsp[-1].qv))); }
#line 10682 "parser.cpp"
    break;

  case 366:
#line 3935 "parser.ypp"
                                        {
        parse_error(*qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].qv), QoreValue(), QoreValue()));
    }
#line 10691 "parser.cpp"
    break;

  case 367:
#line 3939 "parser.ypp"
                                        {
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[-1].qv).getType() == NT_OPERATOR) {
           QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[-1].qv).getInternalNode());
           if (ron) {
              std::unique_ptr<QoreRangeOperatorNode> holder(ron);
              (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
           }
        }
        if (!(yyval.qv)) {
           (yyval.qv).set(new QoreSquareBracketsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].qv), (yyvsp[-1].qv)));
        }
    }
#line 10710 "parser.cpp"
    break;

  case 368:
#line 3953 "parser.ypp"
                                        { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].qv), (yyvsp[-1].qv))); }
#line 10716 "parser.cpp"
    break;

  case 369:
#line 3954 "parser.ypp"
                                        { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10722 "parser.cpp"
    break;

  case 370:
#line 3955 "parser.ypp"
                                        { (yyval.qv).set(process_dot((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10728 "parser.cpp"
    break;

  case 371:
#line 3956 "parser.ypp"
                                        { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv), (yyvsp[0].String))); }
#line 10734 "parser.cpp"
    break;

  case 372:
#line 3960 "parser.ypp"
                                          { (yyval.qv).set((yyvsp[0].qv)); }
#line 10740 "parser.cpp"
    break;

  case 373:
#line 3961 "parser.ypp"
                                          { (yyval.qv).set((yyvsp[0].parse_list)); }
#line 10746 "parser.cpp"
    break;

  case 374:
#line 3962 "parser.ypp"
                                          { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10752 "parser.cpp"
    break;

  case 375:
#line 3963 "parser.ypp"
                                          { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10758 "parser.cpp"
    break;

  case 376:
#line 3964 "parser.ypp"
                                          { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10764 "parser.cpp"
    break;

  case 377:
#line 3965 "parser.ypp"
                                          { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10770 "parser.cpp"
    break;

  case 378:
#line 3966 "parser.ypp"
                                          { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10776 "parser.cpp"
    break;

  case 379:
#line 3967 "parser.ypp"
                                          { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10782 "parser.cpp"
    break;

  case 380:
#line 3968 "parser.ypp"
                                          { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10788 "parser.cpp"
    break;

  case 381:
#line 3969 "parser.ypp"
                                          { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10794 "parser.cpp"
    break;

  case 382:
#line 3970 "parser.ypp"
                                          { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10800 "parser.cpp"
    break;

  case 383:
#line 3971 "parser.ypp"
                                          { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10806 "parser.cpp"
    break;

  case 384:
#line 3972 "parser.ypp"
                                          { (yyval.qv).set(process_assignment((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10812 "parser.cpp"
    break;

  case 385:
#line 3973 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10825 "parser.cpp"
    break;

  case 386:
#line 3981 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        (yyval.qv).set((yyvsp[0].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getParseTypeInfo()));
        delete (yyvsp[0].parsertype);
    }
#line 10837 "parser.cpp"
    break;

  case 387:
#line 3988 "parser.ypp"
                                          { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10843 "parser.cpp"
    break;

  case 388:
#line 3989 "parser.ypp"
                                          { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10849 "parser.cpp"
    break;

  case 389:
#line 3990 "parser.ypp"
                                          { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10855 "parser.cpp"
    break;

  case 390:
#line 3991 "parser.ypp"
                                          { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 10861 "parser.cpp"
    break;

  case 391:
#line 3992 "parser.ypp"
                                          { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 10867 "parser.cpp"
    break;

  case 392:
#line 3993 "parser.ypp"
                                          { (yyval.qv).set(processCall((yylsp[-3]).first_line, (yylsp[0]).last_line, (yyvsp[-3].qv), (yyvsp[-1].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line))); }
#line 10873 "parser.cpp"
    break;

  case 393:
#line 3994 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_log_or(loc, (yyvsp[-2].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10883 "parser.cpp"
    break;

  case 394:
#line 3999 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10889 "parser.cpp"
    break;

  case 395:
#line 4000 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10895 "parser.cpp"
    break;

  case 396:
#line 4001 "parser.ypp"
                                          { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10901 "parser.cpp"
    break;

  case 397:
#line 4002 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10911 "parser.cpp"
    break;

  case 398:
#line 4007 "parser.ypp"
                                          { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10917 "parser.cpp"
    break;

  case 399:
#line 4008 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[-2].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10928 "parser.cpp"
    break;

  case 400:
#line 4014 "parser.ypp"
                                          { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10934 "parser.cpp"
    break;

  case 401:
#line 4015 "parser.ypp"
                                          { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10940 "parser.cpp"
    break;

  case 402:
#line 4016 "parser.ypp"
                                          { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10946 "parser.cpp"
    break;

  case 403:
#line 4017 "parser.ypp"
                                          { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].RegexSubst))); }
#line 10952 "parser.cpp"
    break;

  case 404:
#line 4018 "parser.ypp"
                                          { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Trans))); }
#line 10958 "parser.cpp"
    break;

  case 405:
#line 4019 "parser.ypp"
                                          { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10964 "parser.cpp"
    break;

  case 406:
#line 4020 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10970 "parser.cpp"
    break;

  case 407:
#line 4021 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10976 "parser.cpp"
    break;

  case 408:
#line 4022 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10982 "parser.cpp"
    break;

  case 409:
#line 4023 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10988 "parser.cpp"
    break;

  case 410:
#line 4024 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10994 "parser.cpp"
    break;

  case 411:
#line 4025 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11000 "parser.cpp"
    break;

  case 412:
#line 4026 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11006 "parser.cpp"
    break;

  case 413:
#line 4027 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11012 "parser.cpp"
    break;

  case 414:
#line 4028 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11018 "parser.cpp"
    break;

  case 415:
#line 4029 "parser.ypp"
                                          { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11024 "parser.cpp"
    break;

  case 416:
#line 4030 "parser.ypp"
                                          { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11030 "parser.cpp"
    break;

  case 417:
#line 4031 "parser.ypp"
                                          { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11036 "parser.cpp"
    break;

  case 418:
#line 4032 "parser.ypp"
                                          { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11042 "parser.cpp"
    break;

  case 419:
#line 4033 "parser.ypp"
                                          { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11048 "parser.cpp"
    break;

  case 420:
#line 4034 "parser.ypp"
                                          { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11054 "parser.cpp"
    break;

  case 421:
#line 4035 "parser.ypp"
                                          { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11060 "parser.cpp"
    break;

  case 422:
#line 4036 "parser.ypp"
                                          { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), QoreValue())); }
#line 11066 "parser.cpp"
    break;

  case 423:
#line 4037 "parser.ypp"
                                          { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), QoreValue(), (yyvsp[-1].qv))); }
#line 11072 "parser.cpp"
    break;

  case 424:
#line 4038 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
        parse_error(*loc, "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[-3].qv), QoreValue(), QoreValue()));
    }
#line 11082 "parser.cpp"
    break;

  case 425:
#line 4043 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[-1].qv).getType() == NT_OPERATOR) {
           QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[-1].qv).getInternalNode());
           if (ron) {
              std::unique_ptr<QoreRangeOperatorNode> holder(ron);
              (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[-3].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
           }
        }
        if (!(yyval.qv))
           (yyval.qv).set(new QoreSquareBracketsOperatorNode(loc, (yyvsp[-3].qv), (yyvsp[-1].qv)));
    }
#line 11101 "parser.cpp"
    break;

  case 426:
#line 4057 "parser.ypp"
                                          { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].qv), (yyvsp[-1].qv))); }
#line 11107 "parser.cpp"
    break;

  case 427:
#line 4058 "parser.ypp"
                                          { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11113 "parser.cpp"
    break;

  case 428:
#line 4059 "parser.ypp"
                                          { (yyval.qv).set(process_dot((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11119 "parser.cpp"
    break;

  case 429:
#line 4060 "parser.ypp"
                                          { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv), (yyvsp[0].String))); }
#line 11125 "parser.cpp"
    break;

  case 430:
#line 4064 "parser.ypp"
                    {
           (yyval.String) = (yyvsp[0].String);
        }
#line 11133 "parser.cpp"
    break;

  case 431:
#line 4067 "parser.ypp"
                             {
            (yyval.String) = (yyvsp[-1].String);
            (yyval.String)->concat((yyvsp[0].String));
            (yyvsp[0].String)->deref();
        }
#line 11143 "parser.cpp"
    break;

  case 432:
#line 4075 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].decimal)); }
#line 11149 "parser.cpp"
    break;

  case 433:
#line 4076 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].integer)); }
#line 11155 "parser.cpp"
    break;

  case 434:
#line 4077 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].String)); }
#line 11161 "parser.cpp"
    break;

  case 435:
#line 4078 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].datetime)); }
#line 11167 "parser.cpp"
    break;

  case 436:
#line 4079 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].num)); }
#line 11173 "parser.cpp"
    break;

  case 437:
#line 4080 "parser.ypp"
                      { (yyval.qv).set(nullptr); }
#line 11179 "parser.cpp"
    break;

  case 438:
#line 4081 "parser.ypp"
                      { (yyval.qv).set(&Null); }
#line 11185 "parser.cpp"
    break;

  case 439:
#line 4082 "parser.ypp"
                      { (yyval.qv).set(true); }
#line 11191 "parser.cpp"
    break;

  case 440:
#line 4083 "parser.ypp"
                      { (yyval.qv).set(false); }
#line 11197 "parser.cpp"
    break;


#line 11201 "parser.cpp"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *, YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (&yylloc, yyscanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 4086 "parser.ypp"

