/* A Bison parser, made by GNU Bison 3.0.5.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 1 "parser.ypp" /* yacc.c:339  */
 /* -*- mode: c++; indent-tabs-mode: nil -*-

    parser.ypp

    Qore Programming Language

    Copyright (C) 2003 - 2019 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

    Note that the Qore library is released under a choice of three open-source
    licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
    information.
*/

#include "qore/Qore.h"
#include "qore/intern/BreakStatement.h"
#include "qore/intern/ContinueStatement.h"
#include "qore/intern/ReturnStatement.h"
#include "qore/intern/RethrowStatement.h"
#include "qore/intern/ThreadExitStatement.h"
#include "qore/intern/ExpressionStatement.h"
#include "qore/intern/DoWhileStatement.h"
#include "qore/intern/SummarizeStatement.h"
#include "qore/intern/ContextStatement.h"
#include "qore/intern/IfStatement.h"
#include "qore/intern/WhileStatement.h"
#include "qore/intern/ForStatement.h"
#include "qore/intern/ForEachStatement.h"
#include "qore/intern/TryStatement.h"
#include "qore/intern/ThrowStatement.h"
#include "qore/intern/StatementBlock.h"
#include "qore/intern/ParserSupport.h"
#include "qore/intern/SwitchStatement.h"
#include "qore/intern/CaseNodeWithOperator.h"
#include "qore/intern/CaseNodeRegex.h"
#include "qore/intern/OnBlockExitStatement.h"
#include "qore/intern/ConstantList.h"
#include "qore/intern/GlobalVariableList.h"
#include "qore/intern/QoreNamespaceIntern.h"
#include "qore/intern/QoreParseHashNode.h"
#include "qore/intern/QoreParseListNode.h"
#include "qore/intern/ModuleInfo.h"

#include "parser.hpp"

#include "qore/intern/QoreClassIntern.h"
#include "qore/intern/qore_program_private.h"
#include "qore/intern/typed_hash_decl_private.h"
#include "qore/intern/qore_list_private.h"

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <memory>
#include <sstream>
#include <utility>
#include <vector>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                      \
   do                                                        \
      if (N) {                                               \
         (Current).first_line = YYRHSLOC(Rhs, 1).first_line; \
         (Current).first_col  = YYRHSLOC(Rhs, 1).first_col;  \
         (Current).last_line  = YYRHSLOC(Rhs, N).last_line;  \
         (Current).last_col   = YYRHSLOC(Rhs, N).last_col;   \
      }                                                      \
      else {                                                 \
         (Current).first_line = (Current).last_line =        \
            YYRHSLOC(Rhs, 0).last_line;                      \
         (Current).first_col = (Current).last_col =          \
            YYRHSLOC(Rhs, 0).last_col;                       \
      }                                                      \
   while (0)

class HashElement {
public:
    QoreValue key;
    QoreValue value;
    const QoreProgramLocation* loc;

    DLLLOCAL HashElement(QoreValue k, QoreValue v, int sl, int el) : key(k), value(v), loc(qore_program_private::get(*getProgram())->getLocation(sl, el)) {
        //traceout("HashElement::HashElement()");
    }

    DLLLOCAL ~HashElement() {
        key.discard(nullptr);
        value.discard(nullptr);
    }

    DLLLOCAL void addDelete(QoreParseHashNode* h) {
        h->add(key, value, loc);
        key.clear();
        value.clear();
        delete this;
    }
};

// for constant definitions
class ConstNode {
public:
    const QoreProgramLocation* loc;
    NamedScope name;
    QoreValue value;
    bool pub;

    DLLLOCAL ConstNode(const QoreProgramLocation* loc, char* n, QoreValue v, bool p = false) : loc(loc), name(n), value(v), pub(p) {
        // see if constant definitions are allowed
        if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
            parse_error(*loc, "illegal constant definition \"%s\" (conflicts with parse option PO_NO_CONSTANT_DEFS)", n);
    }
    DLLLOCAL QoreValue takeValue() {
        QoreValue rv = value;
        value.clear();
        return rv;
    }
    DLLLOCAL const char* getName() const {
        return name.getIdentifier();
    }
    DLLLOCAL bool isPublic() const {
        return pub;
    }
};

class ObjClassDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    QoreClass* oc;

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, NamedScope *n, QoreClass* o) : loc(loc), name(n), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, char* n, QoreClass* o) : loc(loc), name(new NamedScope(n)), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ~ObjClassDef() {
        delete name;
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a class may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your class");
    }
};

class HashDeclDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    TypedHashDecl* hashdecl;

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, NamedScope *n, typed_hash_decl_private* hp) :
            loc(loc), name(n), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, char* n, typed_hash_decl_private* hp) :
            loc(loc), name(new NamedScope(n)), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL ~HashDeclDef() {
        delete name;
        if (hashdecl)
            typed_hash_decl_private::get(*hashdecl)->deref();
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a hashdecl may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your hashdecl");
    }

    DLLLOCAL TypedHashDecl* takeHashDecl() {
        TypedHashDecl* rv = hashdecl;
        hashdecl = nullptr;
        return rv;
    }
};

class ParseUserFunctionBase {
public:
    const QoreProgramLocation* loc;
    UserFunctionVariant* variant;

    DLLLOCAL ParseUserFunctionBase(const QoreProgramLocation* loc, UserFunctionVariant* v) : loc(loc), variant(v) {
    }

    DLLLOCAL ~ParseUserFunctionBase() {
        if (variant)
            variant->deref();
    }

    DLLLOCAL void setPublic() {
        variant->setModulePublic();
    }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
    char* name;

    DLLLOCAL ParseUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL ~ParseUserFunction() {
        if (name)
            free(name);
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
            const char* nsn = ns.name.c_str();
            parse_error(*loc, "function '%s%s%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
        }

        delete this;
    }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
    NamedScope name;

    DLLLOCAL ParseScopedUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
            parse_error(*loc, "function '%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", name.ostr);

        delete this;
    }
};

struct GVarDecl {
    const QoreProgramLocation* loc;
    bool pub;

    DLLLOCAL GVarDecl(const QoreProgramLocation* loc, bool p) : loc(loc), pub(p) {
    }

    DLLLOCAL virtual ~GVarDecl() {
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

    DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
    char* name;
    const QoreTypeInfo* typeInfo;
    QoreParseTypeInfo* parseTypeInfo;

    DLLLOCAL GVarSingleDecl(const QoreProgramLocation* loc, char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti, bool p, bool bare) : GVarDecl(loc, p), name(n), typeInfo(ti), parseTypeInfo(pti) {
        //printd(5, "GVarSingleDecl::GVarSingleDecl() '%s' %d-%d\n", n, loc.start_line, loc.end_line);
        if (bare) {
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "global variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", n);
        }
        else {
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", n);
        }
    }

    DLLLOCAL virtual ~GVarSingleDecl() {
        if (name)
            free(name);

        delete parseTypeInfo;
    }

    DLLLOCAL char* takeName() {
        char* rv = name;
        name = 0;
        return rv;
    }

    DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        ns.parseAddGlobalVarDecl(loc, takeName(), typeInfo, takeParseTypeInfo(), pub);
        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        GlobalVarRefNode* gv = typeInfo
            ? new GlobalVarRefNode(loc, takeName(), typeInfo)
            : new GlobalVarRefNode(loc, takeName(), takeParseTypeInfo());
        if (pub)
            gv->setPublic();

        delete this;
        return gv;
    }
};

struct GVarListDecl : public GVarDecl {
    QoreParseListNode* l;

    DLLLOCAL GVarListDecl(const QoreProgramLocation* loc, QoreParseListNode* list, bool p) : GVarDecl(loc, p), l(list) {
        bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                if (!bareok)
                    parse_error(*loc, "global variable '%s' in global variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
            }
            else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (vrn->explicitScope()) {
                    if (vrn->getType() == VT_LOCAL)
                        parse_error(*loc, "illegal use of 'my %s' in global variable declaration list", vrn->getName());
                    else if (vrn->getType() == VT_GLOBAL)
                        parse_error(*loc, "illegal use of 'our %s' in global variable declaration list", vrn->getName());
                }
            }
            else
                parse_error(*loc, "element %d in list following 'our' is not a variable reference (%s)", i, n.getTypeName());
        }
    }

    DLLLOCAL virtual ~GVarListDecl() {
        if (l) {
            l->deref(nullptr);
        }
    }

    DLLLOCAL QoreParseListNode* takeList() {
        QoreParseListNode* rv = l;
        l = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                ns.parseAddGlobalVarDecl(loc, b->takeString(), 0, 0, pub);
            }
            else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
                    if (vrdn)
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), vrdn->getTypeInfo(), vrdn->takeParseTypeInfo(), pub);
                    else
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), 0, 0, pub);
                }
            }
        }

        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        l->setVariableList();
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue& n = vl[i];
            qore_type_t t = n.getType();
            VarRefNode* vrn = nullptr;
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                GlobalVarRefNode* v = new GlobalVarRefNode(loc, b->takeString());
                b->deref();
                n = vrn = v;
            }
            else if (t == NT_VARREF) {
                vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    vrn->makeGlobal();
                    vrn->setExplicitScope();
                }
            }

            if (vrn && pub)
                vrn->setPublic();
        }

        QoreParseListNode* rv = takeList();
        delete this;
        return rv;
    }
};

static int check_method(const QoreProgramLocation* loc, const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error(*loc, "%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error(*loc, "base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PUBLIC     (1 << 0)
#define OFM_PRIVATE    (1 << 1)
#define OFM_INTERNAL   (1 << 2)
#define OFM_SYNCED     (1 << 3)
#define OFM_STATIC     (1 << 4)
#define OFM_DEPRECATED (1 << 5)
#define OFM_FINAL      (1 << 6)
#define OFM_ABSTRACT   (1 << 7)

static inline MethodVariantBase* new_method_variant(const QoreProgramLocation* loc, const char* name, int mod, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) {
    //printd(5, "new_method_variant() '%s' b: %p\n", name, b);

    int64 flags = QCF_NO_FLAGS;

    if (get_pop_argv_ref())
        flags |= QCF_USES_EXTRA_ARGS;

    ClassAccess access = Public;
    if (mod & OFM_PRIVATE) {
        if (mod & OFM_INTERNAL)
            parse_error(*loc, "%s() methods cannot be both private:hierarchy and private:internal", name);
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Private;
    }
    else if (mod & OFM_INTERNAL) {
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Internal;
    }

    if (mod & OFM_DEPRECATED)
        flags |= QCF_DEPRECATED;

    if (!strcmp(name, "constructor")) {
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        return new UserConstructorVariant(access, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
    }
    if (bcal) {
        parse_error(*loc, "only constructors may have base class constructor arguments");
        delete bcal;
        bcal = 0;
    }
    if (!strcmp(name, "destructor")) {
        if (params) {
            parse_error(*loc, "parameters cannot be defined for destructors");
            params.discard(nullptr);
        }
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        if (access > Public)
            parse_error(*loc, "destructors cannot be private");
        return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
    }
    if (!strcmp(name, "copy")) {
        if (mod & OFM_FINAL) {
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        }
        if (mod & OFM_ABSTRACT) {
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        }
        return new UserCopyVariant(access, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
    }

    if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; they are not inherited anyway", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract; they are not inherited anyway", name);
    }

    if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
        parse_error(*loc, "method '%s()' is declared both final and abstract", name);

    return new UserMethodVariant(access, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
    const QoreProgramLocation* loc;
    MethodVariantBase* m;
    NamedScope name;
    bool static_flag;

    DLLLOCAL MethodDef(const QoreProgramLocation* loc, int mod, char* n, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : loc(loc), m(0), name(n), static_flag(mod & OFM_STATIC) {
        if (check_method(loc, name.getIdentifier(), bcal, returnTypeInfo)) {
            params.discard(nullptr);
            delete bcal;
            delete b;
            delete returnTypeInfo;
            return;
        }

        m = new_method_variant(loc, name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b);
    }

    DLLLOCAL ~MethodDef() {
        delete m;
    }

    DLLLOCAL void parseAddToClassAndDel() {
        if (m) {
            // if there are any errors, the function below will delete memory
            // the following method takes ownership of "m" unconditionally
            qore_root_ns_private::parseAddMethodToClass(loc, name, m, static_flag);
            m = 0;
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        // the following method takes ownership of "m" unconditionally
        ns.parseAddMethodToClass(loc, name, m, static_flag);
        m = 0;
    }
};

static QoreValue parse_hash_map(const QoreProgramLocation* loc, QoreParseHashNode* exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> exph(exp, nullptr);
    ReferenceHolder<> lh(l, nullptr);

    // check hash expression
    size_t len = exp->size();

    if (len == 0) {
        qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_INVALID_OPERATION, "INVALID-OPERATION",
                "empty hash as an argument to the hash map operator, this expression will always evaluate to an empty hash");
        return new QoreHashNode;
    }

    if (len != 1) {
        parse_error(*loc, "invalid initial argument to hash map operator, expected a single key value pair; got %d hash elements instead", len);
        return QoreValue();
    }

    if (l->size() == 1) {
        QoreValue iter = l->shift();
        return new QoreHashMapOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter);
    }

    QoreValue iter = l->shift();
    QoreValue select = l->shift();
    return new QoreHashMapSelectOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter, select);
}

static AbstractQoreNode* parse_map(const QoreProgramLocation* loc, QoreValue exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> lh(l, 0);

    if (l->size() == 1) {
        QoreValue arg = l->shift();
        return new QoreMapOperatorNode(loc, exp, arg);
    }

    QoreValue iterator_exp = l->shift();
    QoreValue select_exp = l->shift();
    return new QoreMapSelectOperatorNode(loc, exp, iterator_exp, select_exp);
}

#define NSN_NONE     0
#define NSN_OCD      1
#define NSN_HASHDECL 2
#define NSN_CONST    3
#define NSN_NS       4
#define NSN_FUNC     5
#define NSN_SFUNC    6
#define NSN_VAR      7
#define NSN_METH     8

struct NSNode {
    int type;
    union {
        ObjClassDef* ocd;
        HashDeclDef* hashdecl;
        ConstNode* cn;
        QoreNamespace* ns;
        ParseUserFunction* func;
        ParseScopedUserFunction* sfunc;
        GVarDecl* gv;
        MethodDef* meth;
    } n;

    DLLLOCAL NSNode(ObjClassDef* o) { type = NSN_OCD; n.ocd = o; }
    DLLLOCAL NSNode(HashDeclDef* h) { type = NSN_HASHDECL; n.hashdecl = h; }
    DLLLOCAL NSNode(ConstNode* c) { type = NSN_CONST; n.cn = c; }
    DLLLOCAL NSNode(QoreNamespace* s) { type = NSN_NS; n.ns = s; }
    DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
        n.func = f;
    }
    DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
        n.sfunc = f;
    }

    DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
        n.gv = gv;
    }

    DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
        n.meth = m;
    }

    DLLLOCAL void deref() {
        switch (type) {
            case NSN_OCD:
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                delete n.hashdecl;
                break;
            case NSN_CONST:
                delete n.cn;
                break;
            case NSN_NS:
                delete n.ns;
                break;
            case NSN_FUNC:
                delete n.func;
                break;
            case NSN_SFUNC:
                delete n.sfunc;
                break;
            case NSN_VAR:
                delete n.gv;
                break;
            case NSN_METH:
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        switch (type) {
            case NSN_OCD:
                //printd(5, "ocd: %s %d-%d c: %d-%d\n", n.ocd->oc->getName(), n.ocd->loc.start_line, n.ocd->loc.end_line, qore_class_private::get(*n.ocd->oc)->loc.start_line, qore_class_private::get(*n.ocd->oc)->loc.end_line);
                ns.parseAddPendingClass(n.ocd->loc, *(n.ocd->name), n.ocd->oc);
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                ns.parseAddPendingHashDecl(n.hashdecl->loc, *(n.hashdecl->name), n.hashdecl->takeHashDecl());
                delete n.hashdecl;
                break;
            case NSN_CONST:
                ns.parseAddConstant(n.cn->loc, n.cn->name, n.cn->value, n.cn->pub);
                delete n.cn;
                break;
            case NSN_NS:
                ns.parseAddNamespace(n.ns);
                break;
            case NSN_FUNC:
                n.func->add(ns);
                break;
            case NSN_SFUNC:
                n.sfunc->add(ns);
                break;
            case NSN_VAR:
                n.gv->add(ns);
                break;
            case NSN_METH:
                n.meth->add(ns);
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
    DLLLOCAL void deref() {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->deref();

        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->add(ns);
    }
};

static QoreParseListNode* splice_expressions(QoreValue a1, QoreValue a2, const QoreProgramLocation* loc1, const QoreProgramLocation* loc2) {
    //tracein("splice_expressions()");
    if (a1.getType() == NT_PARSE_LIST) {
        QoreParseListNode* l = a1.get<QoreParseListNode>();
        if (!l->isFinalized()) {
            //printd(5, "LIST x\n");
            l->add(a2, loc2);
            return l;
        }
    }
    QoreParseListNode* l = new QoreParseListNode(qore_program_private::get(*getProgram())->getLocation(*loc1, loc2->start_line, loc2->end_line));
    l->add(a1, loc1);
    l->add(a2, loc2);
    return l;
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;
typedef std::pair<char*, HashDeclMemberInfo*> hashmem_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2
#define MI_HashMem 3

struct MemberInfo {
protected:
    DLLLOCAL MemberInfo(const QoreProgramLocation* loc) : loc(loc) {
    }

public:
    const QoreProgramLocation* loc;
    char* name;
    unsigned char type;
    union {
        QoreMemberInfo* memberInfo;
        QoreVarInfo* varInfo;
        HashDeclMemberInfo* hashMemberInfo;
        QoreSimpleValue exp;
    } u;

    DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : loc(mi->loc), name(n), type(MI_Member) {
        u.memberInfo = mi;
        if (!(mi && mi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*mi->loc, "member '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL MemberInfo(const QoreProgramLocation* loc, char* n, QoreValue exp) : loc(loc), name(n), type(MI_Constant) {
        u.exp = exp;
    }

    DLLLOCAL MemberInfo(char* n, HashDeclMemberInfo* mi) : loc(mi->loc), name(n), type(MI_HashMem) {
        u.hashMemberInfo = mi;
    }

    DLLLOCAL ~MemberInfo() {
        if (name)
            free(name);
        switch (type) {
            case MI_Member:
                delete u.memberInfo;
                break;
            case MI_Var:
                delete u.varInfo;
                break;
            case MI_HashMem:
                delete u.hashMemberInfo;
                break;
            case MI_Constant:
                u.exp.discard(nullptr);
                break;
        }
    }

    DLLLOCAL member_pair_t getPair() {
        assert(type == MI_Member);
        member_pair_t m = std::make_pair(name, u.memberInfo);
        name = nullptr;
        u.memberInfo = nullptr;
        return m;
    }

    DLLLOCAL var_pair_t getVarPair() {
        assert(type == MI_Var);
        var_pair_t m = std::make_pair(name, u.varInfo);
        name = nullptr;
        u.varInfo = nullptr;
        return m;
    }

    DLLLOCAL hashmem_pair_t getHashMemPair() {
        assert(type == MI_HashMem);
        hashmem_pair_t m = std::make_pair(name, u.hashMemberInfo);
        name = nullptr;
        u.hashMemberInfo = nullptr;
        return m;
    }

    DLLLOCAL QoreValue takeExp() {
        assert(type == MI_Constant);
        QoreValue rv = u.exp;
        u.exp.clear();
        return rv;
    }

    DLLLOCAL void setTransient() {
        assert(type == MI_Member);
        u.memberInfo->setTransient();
    }
};

struct ClassVarInfo : public MemberInfo {
    DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) : MemberInfo(vi->loc) {
        name = n;
        type = MI_Var;
        u.varInfo = vi;
        if (!(vi && vi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*vi->loc, "class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL char* takeName() {
        char* n = name;
        name = nullptr;
        return n;
    }
};

class MemberList {
protected:
    // for new class members
    QoreMemberMap mmap;
    // for new class constants
    ConstantList cmap;
    // for new class static variables
    QoreVarMap vmap;

    DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
    }

public:
    DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
        if (!member)
            return;

        if (member->type == MI_Member)
            mmap.addNoCheck(member->getPair());
        else if (member->type == MI_Constant)
            cmap.parseAdd(member->loc, member->name, member->takeExp());
        else
            vmap.addNoCheck(member->getVarPair());

        delete member;
    }

    DLLLOCAL ~MemberList() {
    }

    // takes over ownership of name and typeInfo
    DLLLOCAL int add(MemberInfo* member) {
        if (!member)
            return -1;

        if (member->type == MI_Member) {
            if (mmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate member declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            mmap.addNoCheck(member->getPair());
            delete member;
        }
        else if (member->type == MI_Constant) {
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate constant declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "constant declaration collides with static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new constant to list
            cmap.parseAdd(member->loc, member->name, member->takeExp());
            delete member;
        }
        else {
            assert(member->type == MI_Var);
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "duplicate static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "static class variable declaration collides with constant declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            vmap.addNoCheck(member->getVarPair());
            delete member;
        }

        return 0;
    }

    DLLLOCAL void merge(QoreClass* qc, ClassAccess access) {
        mmap.moveAllTo(qc, access);
        vmap.moveAllTo(qc, access);

        // merge constants
        qore_class_private::get(*qc)->parseAssimilateConstants(cmap, access);
    }
};

class EmptyMemberList : public MemberList {
public:
   DLLLOCAL EmptyMemberList() {
   }
};

struct ParserTypeStruct {
protected:
    DLLLOCAL ParserTypeStruct() {
    }

public:
    const QoreTypeInfo* typeInfo = nullptr;
    QoreParseTypeInfo* parseTypeInfo = nullptr;

    DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : parseTypeInfo(n_parseTypeInfo) {
    }

    DLLLOCAL ParserTypeStruct(char* id, bool or_nothing) : typeInfo(or_nothing ? getBuiltinUserOrNothingTypeInfo(id) : getBuiltinUserTypeInfo(id)) {
        //printd(0, "ParserTypeStruct::ParserTypeStruct('%s', %d) t: %p %s\n", id, or_nothing, typeInfo, QoreTypeInfo::getName(typeInfo));
        if (typeInfo) {
            free(id);
            return;
        }

        parseTypeInfo = new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL ~ParserTypeStruct() {
        delete parseTypeInfo;
    }

    DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
        return typeInfo;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static const QoreTypeInfo* getTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getTypeInfo() : nullptr;
    }

    DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static QoreParseTypeInfo* getParseTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getParseTypeInfo() : nullptr;
    }

    DLLLOCAL const char* getClassName() {
        assert(parseTypeInfo);
        return parseTypeInfo->cscope->ostr;
    }

    DLLLOCAL static ParserTypeStruct* getType(const QoreProgramLocation* loc, char* id, bool or_nothing) {
        return new ParserTypeStruct(getParseType(loc, id, or_nothing));
    }

    DLLLOCAL static void getSubTypes(const QoreProgramLocation* loc, const char* str, parse_type_vec_t& subtypes, bool raise_error = true) {
        QoreString buf;
        bool or_nothing = false;
        bool comma = false;

        const char* p = str;
        while (true) {
            if (*p == '\0') {
                if (buf.empty()) {
                    if (comma && raise_error)
                        parse_error(*loc, "empty subtype specification in type");
                }
                else
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                break;
            }
            switch (*p) {
                case '<': {
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    const char* e = strrchr(str, '>');
                    if (!e || e < p) {
                        if (raise_error)
                            parse_error(*loc, "unbalanced angle brackets in subtype specification in '%s'", str);
                        return;
                    }
                    buf.concat(p, e - p + 1);
                    //printd(5, "ST: '%s' (str: '%s') p: %p '%s'\n", buf.c_str(), str, p, p);
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                    buf.reset();
                    or_nothing = false;
                    //printd(5, "ST: p: %p -> %p\n", p, e);
                    p = e;
                    break;
                }
                case ',':
                    buf.trim();
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing, raise_error));
                    buf.reset();
                    or_nothing = false;
                    comma = true;
                break;
                case '*': {
                    if (buf.empty())
                        or_nothing = true;
                    else
                        buf.concat('*');
                    if (comma)
                        comma = false;
                    break;
                }
                case ' ':
                case '\t':
                    if (!buf.empty())
                        buf.concat(*p);
                    break;
                default:
                    buf.concat(*p);
                    if (comma)
                        comma = false;
                break;
            }
            ++p;
        }
    }

    DLLLOCAL static QoreParseTypeInfo* getParseType(const QoreProgramLocation* loc, char* id, bool or_nothing, bool raise_error = true) {
        //printd(0, "gPT() '%s'\n", id);
        char* p0 = strchr(id, '<');
        if (p0) {
            char* p1 = strrchr(id, '>');
            if (p1 > (p0 + 1)) {
                // terminate main type string
                *p0 = '\0';
                // terminate type args
                *p1 = '\0';

                parse_type_vec_t subtypes;
                getSubTypes(loc, p0 + 1, subtypes, raise_error);
                return new QoreParseTypeInfo(id, or_nothing, std::move(subtypes));
            }
        }
        return new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL static const QoreTypeInfo* getRuntimeType(const char* str) {
        assert(str);
        assert(str[0]);
        char* p;
        bool or_nothing;
        if (str[0] == '*') {
            or_nothing = true;
            p = strdup(str + 1);
        } else {
            or_nothing = false;
            p = strdup(str);
        }
        std::unique_ptr<QoreParseTypeInfo> pt(ParserTypeStruct::getParseType(&loc_builtin, p, or_nothing, false));
        return QoreParseTypeInfo::resolveRuntime(pt.get());
    }
};

const QoreTypeInfo* qore_get_type_from_string(const char* str) {
    // issue #3318: does not use ProgramRuntimeParseAccessHelper as it is notmally not needed, if this is
    // necessary, then the call to this function must be wrapped using this class
    return ParserTypeStruct::getRuntimeType(str);
}

static AbstractQoreNode* process_dot(int sline, int eline, QoreValue l, QoreValue r) {
    qore_type_t rtype = r.getType();
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    switch (rtype) {
        case NT_BAREWORD: {
            BarewordNode* b = r.get<BarewordNode>();
            if (!b->isFinalized()) {
                AbstractQoreNode* rv = new QoreHashObjectDereferenceOperatorNode(loc, l, b->makeQoreStringNode());
                b->deref();
                return rv;
            }
            break;
        }

        case NT_FUNCTION_CALL: {
            FunctionCallNode* f = r.get<FunctionCallNode>();
            assert(!f->getFunction());
            if (!f->isFinalized()) {
                MethodCallNode* m = new MethodCallNode(loc, f->takeName(), f->takeParseArgs());
                f->deref();

                return new QoreDotEvalOperatorNode(loc, l, m);
            }
            break;
        }
    }

    return new QoreHashObjectDereferenceOperatorNode(loc, l, r);
}

static int check_strong_encapsulation(const QoreProgramLocation* loc, const char* type, const char* name) {
    if (parse_check_parse_option(PO_STRONG_ENCAPSULATION)) {
        parse_error(*loc, "illegal out of line %s definition \"%s\" (conflicts with parse option PO_STRONG_ENCAPSULATION)", type, name);
        return -1;
    }
    return 0;
}

static int check_case(const QoreProgramLocation* loc, const char* op, QoreValue exp) {
    // ignore if NULL (= NOTHING)
    if (exp.hasEffect()) {
        if (op)
            parse_error(*loc, "case expression with '%s' needs run-time evaluation", op);
        else
            parse_error(*loc, "case expression needs run-time evaluation", op);
        return -1;
    }
    return 0;
}

static void check_funcmod(const QoreProgramLocation* loc, int mod) {
    if (mod & (OFM_PRIVATE|OFM_INTERNAL))
        parse_error(*loc, "illegal 'private' modifier in function declaration");
    if (mod & OFM_STATIC)
        parse_error(*loc, "illegal 'static' modifier in function declaration");
    if (mod & OFM_FINAL)
        parse_error(*loc, "illegal 'final' modifier in function declaration");
    if (mod & OFM_ABSTRACT)
        parse_error(*loc, "illegal 'abstract' modifier in function declaration");
}

static void check_classmod(const QoreProgramLocation* loc, int mod, QoreClass& qc) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in class declaration");
}

static void check_hashdeclmod(const QoreProgramLocation* loc, int mod, typed_hash_decl_private& hashdecl) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in hashdecl");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in hashdecl");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in hashdecl");
   if (mod & OFM_PUBLIC)
      hashdecl.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in hashdecl");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in hashdecl");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in hashdecl");
}

static void check_nsmod(const QoreProgramLocation* loc, int mod, qore_ns_private& ns) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // if pn is a function node it's effect actually cannot be evaluated
    // at this moment because the function flags have not yet been set
    // and so has_effect() always returns 'true'
    return pn ? pn->has_effect() : true;
}

bool node_has_effect_as_root(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffectAsRoot();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // the same comment as in the above function node_has_effect() applies also here
    return pn ? pn->has_effect_as_root() : true;
}

bool value_has_effect_as_root(const QoreValue& n) {
    return node_has_effect_as_root(n.getInternalNode());
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }

   DLLLOCAL ~MethodNode() {
      free(name);
      delete m;
   }

   DLLLOCAL void addAndDelete(QoreClass* qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }

   DLLLOCAL const QoreProgramLocation* getLoc() const {
      return m->getUserVariantBase()->getUserSignature()->getParseLocation();
   }
};

static QoreValue is_rewritable_op(QoreValue n) {
    qore_type_t nt = n.getType();
    if (nt == NT_OPERATOR) {
        QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n.getInternalNode());
        if (op)
            return op->getRight();
    }

    return QoreValue();
}

static QoreValue check_rewrite_list(QoreParseListNode* l) {
    if (!parse_check_parse_option(PO_BROKEN_LIST_PARSING))
        return l;

    // rewrite expression if it's a list without parentheses and
    // the first expression has one of the following operators:
    // =, +=, -=
    if (l->isFinalized())
        return l;

    QoreValue e0 = l->get(0);

    QoreValue r = is_rewritable_op(e0);
    if (!r.isNothing()) {
        QoreValue last = e0;
        QoreValue top = e0;
        while (true) {
            QoreValue nr = is_rewritable_op(r);
            if (nr.isNothing()) {
                break;
            }
            last = r;
            r = nr;
        }
        assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last.getInternalNode()));
        // take first element from list (the tree) and make it the new expression
        QoreBinaryLValueOperatorNode* op = last.get<QoreBinaryLValueOperatorNode>();
        l->swap(0, op->swapRight(l));
        return top;
    }

    return l;
}

// cannot be static
void ignore_return_value(QoreSimpleValue& n) {
    qore_type_t t = n.getType();
    if (t == NT_OPERATOR) {
        n.get<QoreOperatorNode>()->ignoreReturnValue();
    }
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}

static QoreOperatorNode* process_assignment(int sline, int eline, QoreValue $1, QoreValue $3) {
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    return ($1.getType() == NT_PARSE_LIST)
        ? static_cast<QoreOperatorNode*>(new QoreListAssignmentOperatorNode(loc, $1, $3))
        : static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
}

static QoreOperatorNode* process_weak_assignment(const QoreProgramLocation* loc, QoreValue $1, QoreValue $3) {
   if ($1.getType() == NT_LIST) {
       parse_error(*loc, "the ':=' operator is not valid with list assignments");
       return static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
   }
   return static_cast<QoreOperatorNode*>(new QoreWeakAssignmentOperatorNode(loc, $1, $3));
}

static AbstractQoreNode* processCall(int sline, int eline, QoreValue $1, QoreValue $3, const QoreProgramLocation* argloc) {
    AbstractQoreNode* $$;
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);

    //printd(5, "1: %s, 3: %s\n", $1.getTypeName(), $3.getTypeName());
    qore_type_t t = $1.getType();
    if (t == NT_BAREWORD) {
        BarewordNode* b = $1.get<BarewordNode>();
        // take string from node and delete node
        char* str = b->takeString();
        b->deref();
        printd(5, "parsing call %s() args: %s\n", str, $3.getTypeName());
        $$ = new FunctionCallNode(loc, str, make_args(argloc, $3));
    }
    else if (t == NT_CONSTANT) {
        ScopedRefNode* c = $1.get<ScopedRefNode>();
        // take NamedScope from node and delete node
        NamedScope *ns = c->takeName();
        c->deref();
        assert(ns->size() > 1);
        printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
        $$ = new StaticMethodCallNode(loc, ns, make_args(argloc, $3));
    }
    else if (t == NT_SELF_VARREF) {
        SelfVarrefNode* v = $1.get<SelfVarrefNode>();
        // take string from node and delete node
        char* str = v->takeString();
        v->deref();
        //printd(5, "parsing in-object method call %s()\n", str);
        $$ = new SelfFunctionCallNode(loc, str, make_args(argloc, $3));
    }
    else {
        QoreHashObjectDereferenceOperatorNode* hodon;

        if (t == NT_OPERATOR) {
            hodon = dynamic_cast<QoreHashObjectDereferenceOperatorNode*>($1.getInternalNode());
            if (hodon) {
                QoreValue r = hodon->getRight();
                if (r.getType() != NT_STRING)
                    hodon = nullptr;
            }
        }
        else
            hodon = nullptr;

        if (hodon) {
            // create an object method call node
            // take the string
            QoreStringNode* str = hodon->swapRight(QoreValue()).get<QoreStringNode>();
            assert(str->getEncoding() == QCS_DEFAULT);
            char* cstr = str->giveBuffer();
            assert(cstr);
            str->deref();

            MethodCallNode* mc = new MethodCallNode(loc, cstr, make_args(argloc, $3));

            // destroy the original operator and create a new operator object
            assert(hodon->is_unique());
            QoreValue l = hodon->swapLeft(QoreValue());
            hodon->deref(nullptr);

            $$ = new QoreDotEvalOperatorNode(loc, l, mc);
        }
        else {
            $$ = nullptr;
            if ($1.getType() == NT_VARREF) {
                VarRefNode* r = $1.get<VarRefNode>();
                qore_var_t vartype = r->getType();

                if (vartype != VT_UNRESOLVED) {
                    $$ = r->makeNewCall($3);
                    //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
                    if (!$$) {
                        parseException(*loc, "INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
                    }
                }
            }
            if (!$$) {
                $$ = new CallReferenceCallNode(loc, $1, make_args(argloc, $3));
                printd(5, "made new CallReferenceCallNode: %p exp: %s\n", $$, $1.getTypeName());
            }
        }
    }
    return $$;
}

static void check_operator(const QoreProgramLocation* loc, const QoreOperatorNode* n, const char* parent, const char* child) {
    if (parse_check_parse_option(PO_BROKEN_LOGIC_PRECEDENCE)) {
        if (!n->getInParentheses()) {
            qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_BROKEN_LOGIC_PRECEDENCE, "BROKEN-LOGIC-PRECEDENCE", "%s gets under %s in the parse tree as an impact of broken-logic-precedence flag being set - please consider using parenthesis to enforce the desired operator precedence", child, parent);
        }
    }
}

static void check_operator_log_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreLogicalOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "logical OR");
    }
}

static void check_operator_bin_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary OR");
    }
}

static void check_operator_bin_xor(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryXorOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary XOR");
    }
}


#line 1572 "parser.cpp" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_HPP_INCLUDED
# define YY_YY_PARSER_HPP_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOK_RETURN = 258,
    TOK_RETURNS = 259,
    TOK_MY = 260,
    TOK_DO = 261,
    TOK_TRY = 262,
    TOK_THROW = 263,
    TOK_CATCH = 264,
    TOK_WHERE = 265,
    TOK_WHILE = 266,
    TOK_IF = 267,
    TOK_FOR = 268,
    TOK_SUB = 269,
    TOK_THREAD_EXIT = 270,
    TOK_BREAK = 271,
    TOK_CONTINUE = 272,
    TOK_CONTEXT_ROW = 273,
    TOK_FIND = 274,
    TOK_FOREACH = 275,
    TOK_IN = 276,
    TOK_DELETE = 277,
    TOK_REMOVE = 278,
    TOK_PRIVATE = 279,
    TOK_PRIVATEINTERNAL = 280,
    TOK_PRIVATEHIERARCHY = 281,
    TOK_PUBLIC = 282,
    TOK_SYNCHRONIZED = 283,
    TOK_DEPRECATED = 284,
    TOK_CONTEXT = 285,
    TOK_SORT_BY = 286,
    TOK_SORT_DESCENDING_BY = 287,
    TOK_SUB_CONTEXT = 288,
    TOK_CONST = 289,
    TOK_SUMMARIZE = 290,
    TOK_BY = 291,
    TOK_OUR = 292,
    TOK_RETHROW = 293,
    TOK_SWITCH = 294,
    TOK_CASE = 295,
    TOK_DEFAULT = 296,
    TOK_INHERITS = 297,
    TOK_ELSE = 298,
    TOK_STATIC = 299,
    TOK_NAMESPACE = 300,
    TOK_MODULE = 301,
    TOK_FINAL = 302,
    TOK_ABSTRACT = 303,
    TOK_HASHDECL = 304,
    TOK_TRANSIENT = 305,
    TOK_UNREFERENCE = 306,
    P_INCREMENT = 307,
    P_DECREMENT = 308,
    PLUS_EQUALS = 309,
    MINUS_EQUALS = 310,
    AND_EQUALS = 311,
    OR_EQUALS = 312,
    MODULA_EQUALS = 313,
    MULTIPLY_EQUALS = 314,
    DIVIDE_EQUALS = 315,
    XOR_EQUALS = 316,
    SHIFT_LEFT_EQUALS = 317,
    SHIFT_RIGHT_EQUALS = 318,
    TOK_UNSHIFT = 319,
    TOK_PUSH = 320,
    TOK_POP = 321,
    TOK_SHIFT = 322,
    TOK_CHOMP = 323,
    TOK_TRIM = 324,
    LOGICAL_AND = 325,
    LOGICAL_OR = 326,
    BROKEN_LOGICAL_OR = 327,
    BROKEN_BINARY_OR = 328,
    BROKEN_BINARY_XOR = 329,
    LOGICAL_EQ = 330,
    LOGICAL_NE = 331,
    LOGICAL_LE = 332,
    LOGICAL_GE = 333,
    LOGICAL_CMP = 334,
    ABSOLUTE_EQ = 335,
    ABSOLUTE_NE = 336,
    REGEX_MATCH = 337,
    REGEX_NMATCH = 338,
    TOK_EXISTS = 339,
    TOK_INSTANCEOF = 340,
    SHIFT_RIGHT = 341,
    SHIFT_LEFT = 342,
    TOK_ELEMENTS = 343,
    TOK_KEYS = 344,
    TOK_NEW = 345,
    TOK_BACKGROUND = 346,
    TOK_ON_EXIT = 347,
    TOK_ON_SUCCESS = 348,
    TOK_ON_ERROR = 349,
    TOK_MAP = 350,
    TOK_FOLDR = 351,
    TOK_FOLDL = 352,
    TOK_SELECT = 353,
    TOK_SPLICE = 354,
    TOK_EXTRACT = 355,
    IMPLICIT_ELEMENT = 356,
    NULL_COALESCING = 357,
    VALUE_COALESCING = 358,
    WEAK_ASSIGNMENT = 359,
    RANGE = 360,
    INTEGER = 361,
    QFLOAT = 362,
    NUMBER = 363,
    IDENTIFIER = 364,
    HASHDECL_IDENTIFIER_OPENCURLY = 365,
    ANGLE_IDENTIFIER = 366,
    VAR_REF = 367,
    BACKQUOTE = 368,
    SELF_REF = 369,
    KW_IDENTIFIER_OPENPAREN = 370,
    SCOPED_REF = 371,
    SCOPED_VREF = 372,
    CONTEXT_REF = 373,
    COMPLEX_CONTEXT_REF = 374,
    QORE_CAST = 375,
    CLASS_STRING = 376,
    DATETIME = 377,
    QUOTED_WORD = 378,
    BINARY = 379,
    REGEX_SUBST = 380,
    REGEX_TRANS = 381,
    CLASS_SCOPED_REF = 382,
    BASE_CLASS_CALL = 383,
    REGEX = 384,
    REGEX_EXTRACT = 385,
    IMPLICIT_ARG_REF = 386,
    DOT_KW_IDENTIFIER = 387,
    TRY_MODULE_ERROR = 388,
    IFX = 389,
    NEG = 390,
    UPLUS = 391
  };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_MY 260
#define TOK_DO 261
#define TOK_TRY 262
#define TOK_THROW 263
#define TOK_CATCH 264
#define TOK_WHERE 265
#define TOK_WHILE 266
#define TOK_IF 267
#define TOK_FOR 268
#define TOK_SUB 269
#define TOK_THREAD_EXIT 270
#define TOK_BREAK 271
#define TOK_CONTINUE 272
#define TOK_CONTEXT_ROW 273
#define TOK_FIND 274
#define TOK_FOREACH 275
#define TOK_IN 276
#define TOK_DELETE 277
#define TOK_REMOVE 278
#define TOK_PRIVATE 279
#define TOK_PRIVATEINTERNAL 280
#define TOK_PRIVATEHIERARCHY 281
#define TOK_PUBLIC 282
#define TOK_SYNCHRONIZED 283
#define TOK_DEPRECATED 284
#define TOK_CONTEXT 285
#define TOK_SORT_BY 286
#define TOK_SORT_DESCENDING_BY 287
#define TOK_SUB_CONTEXT 288
#define TOK_CONST 289
#define TOK_SUMMARIZE 290
#define TOK_BY 291
#define TOK_OUR 292
#define TOK_RETHROW 293
#define TOK_SWITCH 294
#define TOK_CASE 295
#define TOK_DEFAULT 296
#define TOK_INHERITS 297
#define TOK_ELSE 298
#define TOK_STATIC 299
#define TOK_NAMESPACE 300
#define TOK_MODULE 301
#define TOK_FINAL 302
#define TOK_ABSTRACT 303
#define TOK_HASHDECL 304
#define TOK_TRANSIENT 305
#define TOK_UNREFERENCE 306
#define P_INCREMENT 307
#define P_DECREMENT 308
#define PLUS_EQUALS 309
#define MINUS_EQUALS 310
#define AND_EQUALS 311
#define OR_EQUALS 312
#define MODULA_EQUALS 313
#define MULTIPLY_EQUALS 314
#define DIVIDE_EQUALS 315
#define XOR_EQUALS 316
#define SHIFT_LEFT_EQUALS 317
#define SHIFT_RIGHT_EQUALS 318
#define TOK_UNSHIFT 319
#define TOK_PUSH 320
#define TOK_POP 321
#define TOK_SHIFT 322
#define TOK_CHOMP 323
#define TOK_TRIM 324
#define LOGICAL_AND 325
#define LOGICAL_OR 326
#define BROKEN_LOGICAL_OR 327
#define BROKEN_BINARY_OR 328
#define BROKEN_BINARY_XOR 329
#define LOGICAL_EQ 330
#define LOGICAL_NE 331
#define LOGICAL_LE 332
#define LOGICAL_GE 333
#define LOGICAL_CMP 334
#define ABSOLUTE_EQ 335
#define ABSOLUTE_NE 336
#define REGEX_MATCH 337
#define REGEX_NMATCH 338
#define TOK_EXISTS 339
#define TOK_INSTANCEOF 340
#define SHIFT_RIGHT 341
#define SHIFT_LEFT 342
#define TOK_ELEMENTS 343
#define TOK_KEYS 344
#define TOK_NEW 345
#define TOK_BACKGROUND 346
#define TOK_ON_EXIT 347
#define TOK_ON_SUCCESS 348
#define TOK_ON_ERROR 349
#define TOK_MAP 350
#define TOK_FOLDR 351
#define TOK_FOLDL 352
#define TOK_SELECT 353
#define TOK_SPLICE 354
#define TOK_EXTRACT 355
#define IMPLICIT_ELEMENT 356
#define NULL_COALESCING 357
#define VALUE_COALESCING 358
#define WEAK_ASSIGNMENT 359
#define RANGE 360
#define INTEGER 361
#define QFLOAT 362
#define NUMBER 363
#define IDENTIFIER 364
#define HASHDECL_IDENTIFIER_OPENCURLY 365
#define ANGLE_IDENTIFIER 366
#define VAR_REF 367
#define BACKQUOTE 368
#define SELF_REF 369
#define KW_IDENTIFIER_OPENPAREN 370
#define SCOPED_REF 371
#define SCOPED_VREF 372
#define CONTEXT_REF 373
#define COMPLEX_CONTEXT_REF 374
#define QORE_CAST 375
#define CLASS_STRING 376
#define DATETIME 377
#define QUOTED_WORD 378
#define BINARY 379
#define REGEX_SUBST 380
#define REGEX_TRANS 381
#define CLASS_SCOPED_REF 382
#define BASE_CLASS_CALL 383
#define REGEX 384
#define REGEX_EXTRACT 385
#define IMPLICIT_ARG_REF 386
#define DOT_KW_IDENTIFIER 387
#define TRY_MODULE_ERROR 388
#define IFX 389
#define NEG 390
#define UPLUS 391

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 1513 "parser.ypp" /* yacc.c:355  */

    QoreSimpleValue qv;
    bool b;
    int i4;
    int64 integer;
    double decimal;
    QoreStringNode* String;
    char* string;
    BinaryNode* binary;
    AbstractQoreNode* node;
    QoreParseHashNode* hash;
    QoreParseListNode* parse_list;
    AbstractStatement* statement;
    struct MemberInfo* memberinfo;
    struct ClassVarInfo* classvarinfo;
    StatementBlock *sblock;
    ContextModList* cmods;
    ContextMod *cmod;
    class HashElement* hashelement;
    QoreFunction* userfunc;
    struct MethodNode* methodnode;
    class MemberList* memberlist;
    QoreClass* qoreclass;
    typed_hash_decl_private* hashdeclpriv;
    class ConstNode* constnode;
    QoreNamespace *ns;
    struct NSNodeList* nsnlist;
    struct NSNode* nsn;
    class ObjClassDef* classdef;
    class HashDeclDef* hashdecldef;
    DateTimeNode* datetime;
    QoreRegexSubst* RegexSubst;
    QoreTransliteration* Trans;
    SwitchStatement* switchstmt;
    CaseNode* casenode;
    BCList* sclist;
    class BCNode* sclnode;
    BCAList* bcalist;
    BCANode* bcanode;
    NamedScope *nscope;
    QoreRegex* Regex;
    QoreImplicitArgumentNode* implicit_arg;
    RetTypeInfo* returnTypeInfo;
    struct ParserTypeStruct* parsertype;
    class ParseUserFunction* parsefunc;
    class ParseScopedUserFunction* sparsefunc;
    struct GVarDecl* gv;
    QoreNumberNode* num;
    TryModuleError* trymod;
    struct MethodDef* methoddef;

#line 1936 "parser.cpp" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int yyparse (yyscan_t yyscanner);

#endif /* !YY_YY_PARSER_HPP_INCLUDED  */

/* Copy the second part of user declarations.  */
#line 1565 "parser.ypp" /* yacc.c:358  */


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE* loc, yyscan_t scanner, const char* str) {
    //printd(5, "yyerror() location: %d:%d - %d:%d \"%s\"\n", loc->first_line, loc->first_col, loc->last_line, loc->last_col, str);
    const QoreProgramLocation* qloc = qore_program_private::get(*getProgram())->getLocation(loc->first_line, loc->last_line);
    parse_error(*qloc, "%s", str);
}


#line 1979 "parser.cpp" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  209
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   13345

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  162
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  68
/* YYNRULES -- Number of rules.  */
#define YYNRULES  435
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  937

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   391

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   153,     2,     2,     2,   146,   141,     2,
     157,   160,   147,   144,   135,   145,   156,   148,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   138,   159,
     142,   136,   143,   137,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   155,   152,   161,   140,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   154,   139,   158,   151,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     149,   150
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1823,  1823,  1824,  1828,  1831,  1836,  1844,  1848,  1854,
    1858,  1863,  1871,  1872,  1876,  1883,  1893,  1920,  1922,  1927,
    1941,  1942,  1948,  1956,  1962,  1968,  1972,  1980,  1986,  1993,
    2001,  2007,  2016,  2021,  2029,  2034,  2037,  2045,  2048,  2051,
    2056,  2059,  2067,  2073,  2076,  2082,  2085,  2091,  2094,  2099,
    2102,  2107,  2109,  2111,  2113,  2119,  2120,  2124,  2125,  2154,
    2161,  2163,  2166,  2169,  2172,  2175,  2178,  2181,  2184,  2187,
    2190,  2193,  2196,  2199,  2202,  2205,  2206,  2214,  2217,  2220,
    2221,  2226,  2227,  2238,  2240,  2242,  2247,  2249,  2253,  2262,
    2266,  2274,  2280,  2286,  2292,  2298,  2304,  2310,  2316,  2322,
    2328,  2334,  2339,  2344,  2349,  2354,  2359,  2364,  2370,  2376,
    2381,  2389,  2416,  2417,  2418,  2422,  2427,  2435,  2441,  2449,
    2458,  2469,  2478,  2492,  2495,  2501,  2504,  2511,  2515,  2519,
    2523,  2527,  2531,  2535,  2539,  2543,  2547,  2554,  2562,  2579,
    2584,  2589,  2616,  2621,  2628,  2635,  2642,  2649,  2653,  2658,
    2663,  2668,  2677,  2680,  2683,  2687,  2690,  2693,  2701,  2702,
    2708,  2709,  2710,  2714,  2715,  2716,  2717,  2718,  2719,  2723,
    2724,  2725,  2729,  2734,  2738,  2744,  2748,  2771,  2778,  2785,
    2809,  2816,  2823,  2847,  2853,  2859,  2862,  2872,  2879,  2885,
    2894,  2901,  2904,  2907,  2911,  2918,  2921,  2924,  2928,  2935,
    2938,  2941,  2947,  2958,  2973,  2980,  2994,  3005,  3018,  3024,
    3033,  3037,  3047,  3050,  3056,  3059,  3066,  3070,  3078,  3079,
    3084,  3085,  3095,  3096,  3097,  3098,  3099,  3100,  3101,  3102,
    3103,  3107,  3119,  3125,  3131,  3141,  3153,  3171,  3177,  3187,
    3199,  3217,  3222,  3242,  3247,  3261,  3266,  3270,  3275,  3280,
    3290,  3299,  3308,  3310,  3312,  3314,  3319,  3333,  3344,  3351,
    3360,  3371,  3389,  3427,  3430,  3438,  3443,  3448,  3453,  3458,
    3463,  3468,  3472,  3486,  3490,  3504,  3508,  3512,  3516,  3540,
    3564,  3592,  3608,  3624,  3640,  3644,  3648,  3656,  3662,  3669,
    3676,  3681,  3685,  3689,  3720,  3727,  3734,  3741,  3755,  3761,
    3778,  3784,  3789,  3797,  3806,  3819,  3823,  3827,  3831,  3835,
    3842,  3843,  3844,  3845,  3846,  3847,  3848,  3849,  3850,  3851,
    3852,  3853,  3854,  3855,  3856,  3857,  3858,  3866,  3873,  3874,
    3875,  3876,  3877,  3878,  3879,  3884,  3885,  3886,  3887,  3892,
    3893,  3899,  3900,  3901,  3902,  3903,  3904,  3905,  3906,  3907,
    3908,  3909,  3910,  3911,  3912,  3913,  3914,  3915,  3916,  3917,
    3918,  3919,  3920,  3921,  3922,  3923,  3927,  3941,  3942,  3943,
    3944,  3948,  3949,  3950,  3951,  3952,  3953,  3954,  3955,  3956,
    3957,  3958,  3959,  3960,  3961,  3969,  3976,  3977,  3978,  3979,
    3980,  3981,  3982,  3987,  3988,  3989,  3990,  3995,  3996,  4002,
    4003,  4004,  4005,  4006,  4007,  4008,  4009,  4010,  4011,  4012,
    4013,  4014,  4015,  4016,  4017,  4018,  4019,  4020,  4021,  4022,
    4023,  4024,  4025,  4026,  4031,  4045,  4046,  4047,  4048,  4052,
    4055,  4063,  4064,  4065,  4066,  4067
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"", "\"my\"",
  "\"do\"", "\"try\"", "\"throw\"", "\"catch\"", "\"where\"", "\"while\"",
  "\"if\"", "\"for\"", "\"sub\"", "\"thread_exit\"", "\"break\"",
  "\"continue\"", "\"%%\"", "\"find\"", "\"foreach\"", "\"in\"",
  "\"delete\"", "\"remove\"", "\"private\"", "\"private:internal\"",
  "\"private:hierarchy\"", "\"public\"", "\"synchronized\"",
  "\"deprecated\"", "\"context\"", "\"sortBy\"", "\"sortDescendingBy\"",
  "\"subcontext\"", "\"const\"", "\"summarize\"", "\"by\"", "\"our\"",
  "\"rethrow\"", "\"switch\"", "\"case\"", "\"default\"", "\"inherits\"",
  "\"else\"", "\"static\"", "\"namespace\"", "\"module\"", "\"final\"",
  "\"abstract\"", "\"hashdecl\"", "\"transient\"", "\"unreference\"",
  "\"++ operator\"", "\"-- operator\"", "\"+= operator\"",
  "\"-= operator\"", "\"&= operator\"", "\"|= operator\"",
  "\"%= operator\"", "\"*= operator\"", "\"/= operator\"",
  "\"^= operator\"", "\"<<= operator\"", "\">>= operator\"", "\"unshift\"",
  "\"push\"", "\"pop\"", "\"shift\"", "\"chomp\"", "\"trim\"",
  "\"&& operator\"", "\"|| operator\"", "\"|| operator (compat)\"",
  "\"| operator (compat)\"", "\"^ operator (compat)\"", "\"== operator\"",
  "\"!= operator\"", "\"<= operator\"", "\">= operator\"",
  "\"<=> operator\"", "\"=== operator\"", "\"!== operator\"",
  "\"=~ operator\"", "\"!~ operator\"", "\"exists\"", "\"instanceof\"",
  "\">> operator\"", "\"<< operator\"", "\"elements\"", "\"keys\"",
  "\"new\"", "\"background\"", "\"on_exit\"", "\"on_success\"",
  "\"on_error\"", "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"",
  "\"splice\"", "\"extract\"", "\"$# operator\"", "\"?? operator\"",
  "\"?* operator\"", "\":= operator\"", "\".. operator\"",
  "\"integer value\"", "\"floating-point value\"",
  "\"arbitrary-precision number\"", "\"identifier\"",
  "\"typed hash identifier\"", "\"complex type identifier\"",
  "\"variable reference\"", "\"backquote expression\"",
  "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"simple class declaration\"",
  "\"date/time value\"", "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'|'",
  "'^'", "'&'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "UPLUS", "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'",
  "';'", "')'", "']'", "$accept", "top_level_commands",
  "top_level_command", "module_decls", "module_decl", "ppub", "gvardecl",
  "top_namespace_decl", "namespace_decls", "namespace_decl",
  "unscoped_const_decl", "scoped_const_decl", "block",
  "statement_or_block", "statements", "optname", "statement",
  "context_mods", "context_mod", "return_statement", "switch_statement",
  "case_block", "case_code", "try_statement", "myexp", "hashdecl_def",
  "class_def", "inheritance_list", "superclass_list", "superclass",
  "hashdecl_attrs", "hashdecl_member", "class_attributes", "uncqtypedef",
  "qtypedef", "internal_member_list", "private_member_list",
  "public_member_list", "classvardecl", "member2", "transient_member2",
  "member", "transient_member", "member_list", "member_list2",
  "ident_openparen", "inline_methoddef", "outofline_methoddef",
  "base_constructor_list", "base_constructors", "base_constructor",
  "nsc_modifiers", "method_modifiers", "method_modifier", "return_value",
  "sub_def", "scoped_sub_def", "list", "list_n", "hash", "hash_element",
  "alt_hash", "immediate_typed_hash", "exp_c", "exp", "exp_n", "string",
  "scalar", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,    44,    61,    63,    58,   124,
      94,    38,    60,    62,    43,    45,    37,    42,    47,   390,
     391,   126,    92,    33,   123,    91,    46,    40,   125,    59,
      41,    93
};
# endif

#define YYPACT_NINF -676

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-676)))

#define YYTABLE_NINF -219

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-219)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    1549,  -149,  6682,   675,  5675,  5675,  7672,   -10,    28,    62,
     260,  -127,   -32,   125,  -676,  7672,  7672,  7672,  7672,  -676,
    -676,  -676,   179,  -676,  -676,   254,  -676,   -27,   254,   228,
     229,  -676,   271,  -676,  -676,  7672,  7672,  7672,  7672,  7672,
    7672,  7672,  7672,  7672,  7672,  7672,   535,  7672,  5675,  5675,
    5675,  7672,  7672,  7672,  7672,  7672,  7672,  -676,  -676,  -676,
    -676,   169,  -676,  -676,  -676,  1391,    43,  -676,  -676,   283,
    -676,   330,  -676,   292,  -676,  -676,  7672,  7672,   582,  7672,
    7672,  7672,  5039,  6538,  -676,  1236,  -676,   426,  -676,  -676,
    -676,  -676,  -676,   305,  -676,  -676,  -676,  -676,    71,   -29,
    -676,    80,   588,  -676,  -676,  -676,  -676,  -676, 10063,  -676,
    -676,  -676,   309,   442,  6826,   236,  6967,    55,   699,  -676,
    -676,  -676,  -676, 12635,   252,  -676,  7672,   371,   381,    45,
    5198,  -676,   484,  -676,   485, 10171,  7672,  7672,  5830,   339,
     340,  -676,   349,  1391,  1391,  -676,  -676,  -676,  7885,  7991,
     304,   304,    24,  -676,   351,  1704,   390,   403,   359,  -676,
    7672,   408,   402,   402, 12635, 12635,   304,   304,   304,   304,
    5756,   304,   304,   383,   385,   392,   304,  -676,  -676,  -676,
   12635, 12635, 12635, 12635, 12635, 12635,  -676,   393, 12635,  1391,
    7672,  -676,  1391,   304,   304,  -676,  -676,  -676,   304,   304,
     304,  -676,  -676,  5357,  -676,  -676,   -70,  -676,  8537,  -676,
    -676,   678,  -676,   290,  -676,   395,  -676,  -676,   248,    40,
     513,   513,   454,  -676,  -676,   407,    30,  -676,  -676,  -676,
    7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,
    7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,
    7672,  7672,   713,   436,   553,  7672,  7672,  7672,  7672,  7672,
    7672,  -676,  7249,  7672,  7672,  7672,  7672,  7672,  7672,  7672,
    7672,  7672,  7672,  7672,  7672,  7672,  7390,  7672,  1391,  -676,
    -676,   -48, 11681,  -676,    51,   410,   416,   561,  -676,  -676,
    7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,
    7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,  7672,
    7672,  7672,   723,   457,   553,  7672,  7672,  7672,  7672,  7672,
    7672,  -676,  7249,  7672,  7672,  7672,  7672,  7672,  7672,  7672,
    7672,  7672,  7672,  7672,  7672,  7672,  7531,  7672,  1391,   435,
   12635,  -676,  -676,  1391,  -676,  5516,   440,   441,  -676,  8646,
    8755,   446,  -676,  -676,  1391,   463,   464,  7672,   449,   486,
     495,  7672,   481,   491,   498,  -676,  -676,  7672,  7672,  7672,
    8864,   516,   -51,  -676,  1391,  1391,  1391,  -676,   503,  8973,
     507,  -676,  -676,  -676,  7249,  -676,  7672,  -676,   108,   372,
    7672,   281,   462,   523,  1391,  1391,  1391,   367,  -676,   536,
     551,   171,   262,   431,   531,  1391,  1391,  1391,   538,   532,
   12741, 12741, 12741, 12741, 12741, 12741, 12741, 12741, 12741, 12741,
   13067, 13031, 13067,   925,   925,  5756,  5756,  5756,  5756,  5756,
    5756,  5756,  -676,  -676,  -676,  -676,  -676,  -676,  1067,  1067,
   12934, 12934, 12741, 12886, 12741, 12741, 11787, 13152, 13188,   925,
    5756,  5756,   529,   529,   649,   304,   304, 11467,  5974,  8097,
    -676,   546,  -676,  -676,   557, 12741, 12741, 12741, 12741, 12741,
   12741, 12741, 12741, 12741, 12741, 13067, 13031, 13067,   925,   925,
    5756,  5756,  5756,  5756,  5756,  5756,  5756,  -676,  -676,  -676,
    -676,  -676,  -676,  1067,  1067, 12934, 12934, 12741, 12886, 12741,
   12741, 11893, 13152, 13188,   925,  5756,  5756,   529,   529,   649,
     304,   304, 11574,  6115,  8207,  -676,   548,  -676,   556,  -676,
    7672,  1391,  5675,  5675,  5830,   570,   666,   666,  7779,  7672,
    7672,  7672,  9082,  7672,  7672,  7672, 10279, 10387,  9191,   563,
    7672,  -676,  -676,   577,   589,   599,   -58,  -676,  -676,  -676,
   12741,   602,  -676,  -676,  -676,  -676,  1391,   603,   618,   625,
     432,   591,  -676,   623,  -676,   404,  -676,  -676,  -676,  -676,
    -676,    32,  -676,   936,  -676,  -676,   553,   553,   303,   318,
     326,   334,  -676,  -676,   653,  -676,    69,  -676,    94,  -676,
    1391,   635,   638,   651,   660,  1391,  1391,  1391,  7672,  -676,
    -676,  8317,  6256,  -676,  -676,  7672,  -676,  -676,  8427,  6397,
    -676,  -676,   659,  9300,   663,  -676,   769,   661,   666,   553,
     672,   672,   676,  9409, 10495, 10603,  -676,  9518,  9627,  9736,
    -676,  -676,   800,   311, 10711,  -676,  -676,  -676,   376,  -676,
     666,  -676,   677,   672,   672,   706,  1391,  -676,  -676,  -676,
     652,   712,    50,   227,  -676,   738,   328,  -676,  -676,  -676,
    -676,  -676,  -676,  -676,  -676,   171,    16,    17,    18,    -3,
     741,  -676,  -676,   443,  -676,  -676,  -676,  -676,   655,  1068,
    -676,   475,   696,   666,   666,   706,  1391,   697,   704,   710,
   12789,  -676,  -676, 12789,  -676,  -676,   714,  5675,  5675,  1391,
     672,  -676,  -676,  -676,  -676,  7672,  5675,  -676,  -676,  1704,
    -676,  -676,  -676,   717,  7108,   743,    15,  -676,  -676,   719,
     726,   747,  -676,   672,   672,  -676,  -676,   672,   724,   725,
    -676,  -676,     8,  -676,  -676,   773,   772,    65,  -676,  -676,
     -59,   510,   -33,   534,    47,   780,   549,    49,  -676,  -676,
    -676,  -676,  -676,  -676,   340,    54,  1391,  -676,   666,   672,
     672,   666,   731,   672,   672,   706,  -676,  -676,  -676,   732,
    -676,  9845,  -676,  -676,  7672,  7672,  7672,  7672,   765,   766,
     759,  7672,  7672, 11999,  1859,  -676,  -676,  1391,  1391,   376,
    -676,  -676,  -676,   706,  7672,  1391,  -676,  -676,  -676,   875,
     562,   622,   203,  -676,  -676,   801,   797,  -676,  -676,  -676,
     749,   -30,  -676,  -676,   827,  -676,  -676,   835,  -676,  -676,
     908,  -676,  1391,   752,   672,  -676,  -676,   466,   672,  -676,
    -676,   483,  5675,  -676,  9954, 12105, 12211, 12317,   776,   777,
    2018, 12423, 12529,  2177,  2336,   756,   757,  -676, 10819,   758,
     211,   810,  -676,  7672,  -676,   183,   201,  -676,  -676,  -676,
    -676,  -676,  -676,  -676,  -676,   761,   706,  -676,  -676,  -676,
    -676,  -676,  -676,  -676,  -676,  2495,  2654,  2813,  2972,  3131,
    3290,  3449,  3608,  3767,  -676,  -676,  -676,   763,  7672,  -676,
     214, 10927,  7672,  1391,  -676,  7672,  1391,  -676,   706,   666,
    1704,  3926,  4085,  4244,  4403,  4562,  4721,  4880,  -676, 11035,
    7672,  1391,  -676,  -676, 11143,   771, 11251,   774,   580,   606,
    -676,  -676, 11359,   779,  -676,   778,  -676,   781,  -676,  -676,
    -676,  -676,  -676,   782,  -676,  -676,  -676
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,   158,   158,     0,     0,   158,     0,     0,     0,
       0,     0,     0,     0,   266,   158,   158,   158,   158,   222,
     224,   223,   228,   226,   227,    55,    81,     0,    55,     0,
       0,   225,     0,   229,   230,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,     0,   158,     0,     0,
       0,   158,   158,   158,   158,   158,   158,   306,   432,   431,
     435,   264,   154,   298,   288,     0,   255,   265,   267,     0,
     434,   429,   253,     0,   305,    16,   158,   158,     0,   158,
     158,   158,     0,   158,    57,     0,     2,     0,   263,    14,
       9,     8,    11,     0,    79,    60,     7,     6,   159,     0,
      10,     0,   219,   220,     4,     5,   372,   371,     0,   433,
     252,    80,     0,   228,   158,   255,   158,   159,     0,   311,
     312,   313,   310,    87,   260,   153,   158,   159,     0,   255,
       0,    50,     0,    49,     0,     0,   158,   158,     0,     0,
       0,   201,     0,     0,     0,    76,    77,    78,     0,     0,
     307,   308,     0,    56,     0,     0,     0,     0,     0,    61,
     158,     0,   284,   285,   272,   274,   275,   273,   276,   277,
     269,   270,   271,     0,     0,     0,   297,    63,    64,    65,
     280,   281,   282,   283,   278,   279,   114,     0,   113,     0,
     158,   430,     0,   290,   289,   155,   157,   156,   291,   293,
     292,    12,    52,     0,    51,   300,     0,   245,     0,     1,
       3,   158,    75,     0,   258,     0,   256,   257,     0,     0,
     124,   124,     0,   228,   152,   153,     0,   221,   389,   390,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,     0,     0,     0,   158,   158,   158,   158,   158,
     158,   428,   244,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,     0,    58,
     251,     0,     0,   314,     0,     0,     0,     0,   331,   332,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   158,     0,     0,     0,   158,   158,   158,   158,   158,
     158,   370,   242,   158,   158,   158,   158,   158,   158,   158,
     158,   158,   158,   158,   158,   158,   158,   158,     0,   311,
       0,   259,   261,     0,    48,     0,     0,     0,    62,     0,
       0,     0,   200,   199,     0,     0,     0,   158,     0,     0,
       0,   158,     0,     0,     0,    66,    82,   158,   158,   158,
       0,     0,     0,    17,     0,     0,     0,   287,     0,     0,
       0,    13,    53,    54,   247,   254,   158,   299,    25,    23,
     158,   159,     0,     0,     0,     0,     0,   218,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     392,   393,   394,   395,   396,   408,   411,   412,   413,   407,
     409,   410,   402,   403,   400,   404,   401,   385,   415,   414,
     386,   387,   384,   426,   243,   383,     0,   397,   399,   398,
     406,   405,   416,   417,   418,   420,   419,     0,   158,     0,
     427,     0,   250,   249,     0,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   334,   335,   336,   337,   338,
     350,   353,   354,   355,   349,   351,   352,   344,   345,   342,
     346,   343,   327,   357,   356,   328,   329,   326,   368,   241,
     325,     0,   339,   341,   340,   348,   347,   358,   359,   360,
     362,   361,     0,   158,     0,   369,     0,   262,     0,    47,
     158,     0,     0,     0,     0,     0,   232,   232,     0,   158,
     158,   158,     0,   158,   158,   158,     0,     0,     0,     0,
     158,    15,    18,     0,     0,     0,   213,   309,   286,   246,
     248,   311,    24,    22,    27,    26,     0,     0,     0,     0,
       0,   153,    31,     0,    41,   218,    32,    35,    34,    37,
      36,     0,    42,   219,    38,    39,     0,     0,     0,     0,
       0,     0,   127,   128,   123,   125,   218,   119,   218,   120,
       0,     0,     0,     0,     0,     0,     0,     0,   158,   425,
     423,     0,   158,   424,   391,   158,   367,   365,     0,   158,
     366,   333,     0,     0,     0,    71,    69,     0,   232,   158,
       0,     0,     0,     0,     0,     0,    81,     0,     0,     0,
      43,    45,     0,     0,     0,   294,   296,   295,     0,    59,
     232,    28,     0,     0,     0,   213,     0,    40,    29,    33,
       0,     0,     0,     0,   137,     0,     0,   131,   132,   135,
     136,   133,   134,   129,   130,     0,   222,   224,   223,   228,
       0,   121,   146,   218,   143,   144,   145,   142,     0,   219,
     122,   218,     0,   232,   232,   213,     0,     0,     0,     0,
     388,   422,   421,   330,   364,   363,     0,     0,     0,     0,
       0,   159,   231,   301,   233,   158,     0,    44,    46,     0,
      83,    84,    85,     0,   158,     0,     0,    89,    19,     0,
       0,   212,   214,     0,     0,   302,   234,     0,     0,     0,
     115,   138,     0,   116,   126,     0,   188,   158,   191,   192,
       0,   158,     0,   158,     0,     0,   158,     0,   117,   151,
     148,   149,   150,   147,   152,     0,     0,   118,   232,     0,
       0,   232,     0,     0,     0,   213,    72,   111,    70,     0,
     237,     0,    74,    68,   158,   158,   158,   158,     0,     0,
       0,   158,   158,     0,     0,    88,    90,     0,     0,     0,
     210,   238,   211,   213,   158,     0,   139,   190,   189,     0,
       0,   158,   152,   165,   186,   159,     0,   185,   195,   196,
     158,     0,   163,   162,   158,   160,   168,   158,   166,   171,
     158,   169,     0,     0,     0,   303,   235,     0,     0,   304,
     236,     0,     0,   268,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   215,     0,     0,
     152,     0,   187,   158,   183,     0,     0,   164,   197,   198,
     193,   194,   161,   167,   170,     0,   213,   239,   208,   206,
     240,   209,   207,    73,    81,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   216,   217,   140,     0,   158,   173,
       0,     0,   158,     0,   180,   158,     0,   177,   213,   232,
       0,     0,     0,     0,     0,     0,     0,     0,   141,     0,
     158,     0,   172,   184,     0,     0,     0,     0,     0,     0,
      67,   175,     0,     0,   181,     0,   178,     0,   205,   203,
     204,   202,   174,     0,   182,   179,   176
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -676,  -676,   847,  -676,   583,  -676,  -390,  -388,  -676,   384,
       1,  -386,   327,    13,  -125,   926,   259,  -597,  -676,  -676,
    -676,  -676,   243,  -676,   234,  -376,  -375,   745,  -676,   302,
     391,  -243,   387,   380,    -1,  -536,  -459,  -327,  -676,    58,
    -599,  -675,   158,  -357,  -236,  -205,  -273,  -373,  -615,  -676,
     184,  -482,     6,   -99,  -479,  -372,  -371,  -114,  -676,   308,
     592,  -676,  -676,    23,    -2,  -676,   901,  -676
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    85,    86,   372,   373,    87,    88,    89,   565,   566,
     804,    91,   131,   132,   203,   154,   133,   155,   366,    93,
      94,   716,   717,    95,   187,    96,    97,   402,   584,   585,
     653,   654,   673,   117,    99,   674,   675,   676,   807,   808,
     809,   738,   739,   740,   810,   144,   677,   100,   640,   721,
     722,   101,   118,   103,   620,   104,   105,   119,   106,   206,
     207,   120,   121,   122,   188,   108,   109,   110
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     123,    90,   128,   227,   135,   345,   102,   563,   395,   564,
     111,   568,   339,   148,   149,   150,   151,   406,   134,   227,
     735,   569,   570,   107,   572,   574,   575,   107,   107,   709,
     727,   745,   145,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   408,   176,   650,   735,   621,   180,
     181,   182,   183,   184,   185,   714,   715,  -153,   371,  -153,
     797,   177,   178,   179,   729,   384,   735,   735,   735,   285,
     761,   107,   107,   107,   193,   194,   811,   198,   199,   200,
     638,   208,   156,   216,   736,   213,    90,   384,   217,   157,
     385,   102,   799,   666,   667,   668,   669,    23,    24,   670,
     812,   639,   811,   670,   678,   107,   678,   541,   107,   800,
     462,   736,   282,    31,   282,   801,    33,    34,   666,   667,
     668,   669,    23,    24,   340,   218,   815,   146,   670,   219,
     736,   736,   736,   359,   349,   350,   860,   750,    31,   700,
     360,    33,    34,   139,   794,   750,   409,   136,   215,   399,
     831,   746,  -153,   107,  -153,  -153,   400,  -153,   370,  -153,
    -153,   723,  -153,   140,   214,   795,   409,   796,   365,   141,
     737,   741,   743,   785,   802,   563,    62,   564,   107,   568,
     214,   125,   811,  -152,   811,   137,   384,   215,   379,   569,
     570,   678,   572,   574,   575,   578,   579,   580,   581,   678,
     189,   220,   343,   596,   759,   760,   818,   221,   821,   463,
     392,   859,    78,   152,   751,   859,   -21,  -152,   859,   138,
    -152,   859,   751,   803,  -152,  -152,   107,   671,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
    -153,   899,   680,   438,   439,   440,   441,   442,   443,    92,
     444,   445,   446,   447,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   459,   460,   551,   900,  -152,   824,
     582,  -152,   827,   918,   147,  -152,  -152,   583,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   483,   484,   485,   486,
     742,   744,   747,   493,   494,   495,   496,   497,   498,   892,
     499,   500,   501,   502,   503,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   514,   515,   224,   895,    62,   853,
     893,   204,   894,   125,    92,  -153,   752,   888,  -153,   139,
     910,   714,   715,  -153,   752,   528,   288,   289,   896,   532,
     897,  -152,   854,   153,  -152,   536,   537,   538,   107,   140,
     889,   911,   351,   912,    78,   141,   142,   355,   356,   139,
      98,   560,   282,   127,   550,   730,   160,   159,   340,   204,
     552,    19,    20,    21,    22,    23,    24,   553,   567,   140,
     753,    27,   397,   573,   -20,   141,   393,   398,   753,   202,
     731,    31,   657,   731,    33,    34,   586,   143,   560,   658,
     919,   587,   281,   378,   284,   161,   380,   659,    19,    20,
      21,    22,    23,    24,   660,   661,   321,   224,    27,    62,
     190,   -20,   662,   663,   125,   395,   406,   394,    31,   192,
     664,    33,    34,    71,  -219,  -219,   601,   202,   335,   336,
     337,   338,   383,   211,   212,    98,   143,   666,   667,   668,
     669,    23,    24,   756,   227,    78,   224,   670,    62,   -21,
     341,  -153,   226,   561,  -153,   719,   733,    31,  -153,  -153,
      33,    34,   720,   342,   347,   346,   352,   353,   287,   666,
     667,   668,   669,    23,    24,   814,   354,   817,   361,   670,
     820,   608,   461,   224,    78,    62,   369,   371,   613,    31,
     561,   139,    33,    34,   596,   562,   367,   623,   624,   625,
     382,   627,   628,   629,   321,   615,   616,   799,   634,   368,
     374,   140,   375,   139,   670,   107,   107,   141,   142,   376,
     822,    78,   396,   377,   800,   401,   335,   336,   337,   338,
     801,   799,   648,   140,   407,   436,   567,   394,   670,   141,
     404,   573,   516,   405,   554,   464,   799,   518,   800,   555,
     227,   288,   289,   670,   801,   588,   491,   672,   525,   672,
     589,   391,   679,   800,   679,   517,   690,   520,   521,   801,
     498,   748,   222,   693,   383,   524,   529,   498,   543,   544,
     545,   405,    19,    20,    21,   223,    23,    24,   702,   802,
     130,    62,   530,   526,   527,   868,   125,   139,   557,   558,
     559,   531,    31,   757,   437,    33,    34,   130,   533,   591,
     592,   593,   871,   802,   173,    62,   174,   140,   534,   799,
     125,   175,   540,   141,   594,   535,   670,    78,   802,   844,
      62,   321,   224,   546,    62,   125,   800,   548,   813,   125,
     619,   850,   382,    62,   749,   332,   333,   334,   125,   679,
     556,    78,   749,   335,   336,   337,   338,   679,   590,   597,
     576,   195,   816,   196,   492,   595,    78,   224,   197,    62,
      78,   288,   289,   771,   225,   577,   604,   819,   611,    78,
     767,   768,   783,   286,   595,   880,   612,   633,   883,   772,
     107,   107,   773,    19,    20,    21,   223,    23,    24,   107,
     618,   802,   107,    62,   130,    78,   806,   635,   125,   928,
     806,   139,   806,    31,   139,   806,    33,    34,   646,   636,
     901,   902,   903,   904,   905,   614,   906,   907,   617,   637,
     130,   140,   641,   643,   754,   930,    62,   141,   393,    78,
     141,   125,   834,   835,   836,   837,   799,   571,   644,   841,
     842,   321,   647,   670,   124,   645,    62,   388,   665,    62,
     642,   125,   848,   800,   389,   683,   333,   334,   684,   801,
     806,   139,    78,   335,   336,   337,   338,   107,   224,   806,
      62,   685,   698,   806,   139,   125,   806,   686,   639,   806,
     699,   140,    78,   697,   682,    78,   130,   141,   404,   687,
     688,   689,   126,   705,   140,   390,   713,   724,   432,   433,
     141,   594,   434,   435,   638,   873,    78,   732,   487,   488,
     156,   891,   489,   490,   799,   107,   758,   763,   802,   852,
      62,   670,   799,   107,   764,   125,   107,   107,   858,   670,
     765,   800,   858,   766,   774,   858,   787,   801,   858,   800,
     728,   784,   789,   788,   793,   801,   909,   736,   798,   359,
     914,   828,   832,   916,   838,   839,    78,   840,   107,   107,
     107,   107,   107,   107,   107,   107,   107,   857,   922,   745,
     855,   856,   866,   920,   878,   879,   884,   885,   887,   890,
     762,   898,   908,   107,   107,   107,   107,   107,   107,   107,
     107,   925,   210,   769,   927,   799,   802,   934,    62,   933,
     935,   936,   670,   125,   802,   571,    62,   703,   704,   649,
     651,   125,   800,   652,   158,   542,   655,   655,   801,   786,
      19,    20,    21,   223,    23,    24,   403,   734,   656,   861,
     725,   726,   191,   847,    78,   681,   549,   288,   289,     0,
      31,     0,    78,    33,    34,   862,     0,     0,     0,     0,
     823,     0,     0,   863,     0,     0,     0,     0,     0,   701,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,   802,     0,    62,
       0,   845,   846,     0,   125,     0,     0,   770,     0,   849,
       0,     0,     0,   655,     0,     0,   655,     0,     0,     0,
       0,     0,     0,   204,     0,   224,     0,    62,     0,     0,
     790,   791,   225,     0,   792,    78,   865,   321,   755,     0,
       0,     0,     0,     0,     0,     0,   864,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,    78,     0,     0,   825,   826,     0,     0,
     829,   830,    19,    20,    21,   223,    23,    24,     0,   204,
       0,     0,   204,   383,     0,     0,     0,     0,     0,     0,
       0,   202,    31,     0,     0,    33,    34,   805,     0,   288,
     289,   805,     0,   805,     0,     0,   805,   915,     0,     0,
     917,     0,     0,     0,   204,   204,   204,   204,   204,   383,
     204,   204,   383,     0,     0,   923,     0,     0,     0,     0,
       0,   867,     0,     0,   869,   870,     0,     0,   872,     0,
     383,   383,   383,   383,   383,   383,   383,   202,     0,     0,
     202,   382,     0,     0,     0,     0,     0,     0,     0,     0,
     851,   805,     0,     0,     0,     0,     0,     0,     0,     0,
     805,     0,     0,     0,   805,     0,     0,   805,     0,   321,
     805,     0,   202,   202,   202,   202,   202,   382,   202,   202,
     382,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,     0,     0,   382,   382,
     382,   382,   382,   382,   382,     0,   209,     1,     0,     2,
       0,     3,     4,     5,     6,   929,   931,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,    22,    23,    24,    25,     0,     0,    26,
      27,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,  -218,    32,    33,    34,  -218,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,     0,    62,  -158,    63,
      64,    65,    66,  -158,    67,    68,    69,  -218,    70,    71,
      72,     0,     0,  -218,    73,     0,     0,    74,     0,    75,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     0,    78,     0,     0,     0,    79,    80,    81,
      82,     0,   186,    83,     0,    84,     3,     0,     0,     0,
       0,     0,     0,     0,     0,   112,     0,     0,     0,    14,
      15,     0,     0,    17,    18,    19,    20,    21,   113,    23,
      24,     0,     0,     0,     0,     0,     0,     0,   -20,     0,
       0,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,     0,     0,     0,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,   114,    62,  -158,    63,    64,    65,   115,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   116,     0,     0,    83,     0,
       1,  -112,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
       0,     0,    26,    27,    28,     0,   -20,    29,    30,     0,
       0,     0,     0,    31,  -218,    32,    33,    34,  -218,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,     0,
      62,  -158,    63,    64,    65,    66,  -158,    67,    68,    69,
    -218,    70,    71,    72,     0,     0,  -218,    73,     0,     0,
      74,     0,    75,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,    82,     0,     1,    83,     2,    84,     3,
       4,     5,     6,     0,   362,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,   363,   364,    26,     0,    28,
       0,   -20,    29,    30,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,     0,    62,  -158,    63,    64,    65,
     129,  -158,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       0,    78,     0,     0,     0,    79,    80,    81,   130,     0,
       1,    83,     2,    84,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   112,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,   113,    23,    24,    25,
       0,     0,    26,     0,    28,     0,   -20,    29,    30,  -110,
    -110,     0,     0,    31,     0,     0,    33,    34,     0,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,     0,
      62,  -158,    63,    64,    65,   129,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   130,     0,     0,    83,  -110,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -106,  -106,
       0,     0,    31,     0,     0,    33,    34,     0,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,     0,    62,
    -158,    63,    64,    65,   129,  -158,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     0,     0,    79,
      80,    81,   130,     0,     0,    83,  -106,    84,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   112,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,    20,    21,   113,    23,    24,    25,     0,     0,
      26,     0,    28,     0,   -20,    29,    30,  -108,  -108,     0,
       0,    31,     0,     0,    33,    34,     0,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,     0,    62,  -158,
      63,    64,    65,   129,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   130,     0,     0,    83,  -108,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -109,  -109,     0,     0,
      31,     0,     0,    33,    34,     0,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,     0,    62,  -158,    63,
      64,    65,   129,  -158,    67,    68,    69,     0,    70,    71,
      72,     0,     0,     0,    73,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     0,    78,     0,     0,     0,    79,    80,    81,
     130,     0,     0,    83,  -109,    84,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   112,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
      20,    21,   113,    23,    24,    25,     0,     0,    26,     0,
      28,     0,   -20,    29,    30,   -96,   -96,     0,     0,    31,
       0,     0,    33,    34,     0,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,     0,    62,  -158,    63,    64,
      65,   129,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   130,
       0,     0,    83,   -96,    84,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,   -94,   -94,     0,     0,    31,     0,
       0,    33,    34,     0,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,     0,    62,  -158,    63,    64,    65,
     129,  -158,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       0,    78,     0,     0,     0,    79,    80,    81,   130,     0,
       0,    83,   -94,    84,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   112,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     113,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,   -92,   -92,     0,     0,    31,     0,     0,
      33,    34,     0,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     0,     0,     0,     0,    58,
      59,    60,    61,     0,    62,  -158,    63,    64,    65,   129,
    -158,    67,    68,    69,     0,    70,    71,    72,     0,     0,
       0,    73,     0,     0,    74,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,     0,
      78,     0,     0,     0,    79,    80,    81,   130,     0,     0,
      83,   -92,    84,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   112,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   113,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -102,  -102,     0,     0,    31,     0,     0,    33,
      34,     0,     0,     0,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,     0,     0,     0,     0,    58,    59,
      60,    61,     0,    62,  -158,    63,    64,    65,   129,  -158,
      67,    68,    69,     0,    70,    71,    72,     0,     0,     0,
      73,     0,     0,    74,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    76,    77,     0,    78,
       0,     0,     0,    79,    80,    81,   130,     0,     0,    83,
    -102,    84,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   112,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   113,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,  -104,  -104,     0,     0,    31,     0,     0,    33,    34,
       0,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,     0,    62,  -158,    63,    64,    65,   129,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   130,     0,     0,    83,  -104,
      84,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
    -105,  -105,     0,     0,    31,     0,     0,    33,    34,     0,
       0,     0,    35,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     0,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,     0,     0,     0,     0,    58,    59,    60,    61,
       0,    62,  -158,    63,    64,    65,   129,  -158,    67,    68,
      69,     0,    70,    71,    72,     0,     0,     0,    73,     0,
       0,    74,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    76,    77,     0,    78,     0,     0,
       0,    79,    80,    81,   130,     0,     0,    83,  -105,    84,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   112,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,   113,    23,    24,    25,
       0,     0,    26,     0,    28,     0,   -20,    29,    30,   -98,
     -98,     0,     0,    31,     0,     0,    33,    34,     0,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,     0,
      62,  -158,    63,    64,    65,   129,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   130,     0,     0,    83,   -98,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -100,  -100,
       0,     0,    31,     0,     0,    33,    34,     0,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,     0,    62,
    -158,    63,    64,    65,   129,  -158,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     0,     0,    79,
      80,    81,   130,     0,     0,    83,  -100,    84,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   112,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,    20,    21,   113,    23,    24,    25,     0,     0,
      26,     0,    28,     0,   -20,    29,    30,  -107,  -107,     0,
       0,    31,     0,     0,    33,    34,     0,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,     0,    62,  -158,
      63,    64,    65,   129,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   130,     0,     0,    83,  -107,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,   -95,   -95,     0,     0,
      31,     0,     0,    33,    34,     0,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,     0,    62,  -158,    63,
      64,    65,   129,  -158,    67,    68,    69,     0,    70,    71,
      72,     0,     0,     0,    73,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     0,    78,     0,     0,     0,    79,    80,    81,
     130,     0,     0,    83,   -95,    84,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   112,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
      20,    21,   113,    23,    24,    25,     0,     0,    26,     0,
      28,     0,   -20,    29,    30,   -93,   -93,     0,     0,    31,
       0,     0,    33,    34,     0,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,     0,    62,  -158,    63,    64,
      65,   129,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   130,
       0,     0,    83,   -93,    84,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   112,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   113,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,   -91,   -91,     0,     0,    31,     0,
       0,    33,    34,     0,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,     0,    62,  -158,    63,    64,    65,
     129,  -158,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       0,    78,     0,     0,     0,    79,    80,    81,   130,     0,
       0,    83,   -91,    84,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   112,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,    20,    21,
     113,    23,    24,    25,     0,     0,    26,     0,    28,     0,
     -20,    29,    30,  -101,  -101,     0,     0,    31,     0,     0,
      33,    34,     0,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     0,     0,     0,     0,    58,
      59,    60,    61,     0,    62,  -158,    63,    64,    65,   129,
    -158,    67,    68,    69,     0,    70,    71,    72,     0,     0,
       0,    73,     0,     0,    74,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    76,    77,     0,
      78,     0,     0,     0,    79,    80,    81,   130,     0,     0,
      83,  -101,    84,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   112,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   113,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -103,  -103,     0,     0,    31,     0,     0,    33,
      34,     0,     0,     0,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,     0,     0,     0,     0,    58,    59,
      60,    61,     0,    62,  -158,    63,    64,    65,   129,  -158,
      67,    68,    69,     0,    70,    71,    72,     0,     0,     0,
      73,     0,     0,    74,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    76,    77,     0,    78,
       0,     0,     0,    79,    80,    81,   130,     0,     0,    83,
    -103,    84,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   112,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,   113,    23,
      24,    25,     0,     0,    26,     0,    28,     0,   -20,    29,
      30,   -97,   -97,     0,     0,    31,     0,     0,    33,    34,
       0,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,     0,    58,    59,    60,
      61,     0,    62,  -158,    63,    64,    65,   129,  -158,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     0,    78,     0,
       0,     0,    79,    80,    81,   130,     0,     0,    83,   -97,
      84,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   112,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   113,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
     -99,   -99,     0,     0,    31,     0,     0,    33,    34,     0,
       0,     0,    35,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     0,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,     0,     0,     0,     0,    58,    59,    60,    61,
       0,    62,  -158,    63,    64,    65,   129,  -158,    67,    68,
      69,     0,    70,    71,    72,     0,     0,     0,    73,     0,
       0,    74,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    76,    77,     0,    78,     0,     0,
       0,    79,    80,    81,   130,     0,     0,    83,   -99,    84,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   112,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,   113,    23,    24,    25,
       0,     0,    26,     0,    28,     0,   -20,    29,    30,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,     0,
      62,  -158,    63,    64,    65,   129,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,    78,     0,     0,     0,
      79,    80,    81,   130,     0,     0,    83,   201,    84,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   112,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   113,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,     0,    62,
    -158,    63,    64,    65,   129,  -158,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     0,     0,    79,
      80,    81,   130,     0,     0,    83,   344,    84,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   112,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,    20,    21,   113,    23,    24,    25,     0,     0,
      26,     0,    28,     0,   -20,    29,    30,     0,     0,     0,
       0,    31,     0,     0,    33,    34,     0,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,     0,    62,  -158,
      63,    64,    65,   129,  -158,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     0,    78,     0,     0,     0,    79,    80,
      81,   130,     0,     0,    83,   381,    84,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     112,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   113,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,     0,    62,  -158,    63,
      64,    65,   129,  -158,    67,    68,    69,     0,    70,    71,
      72,     0,     0,     0,    73,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     0,    78,     0,     0,     0,    79,    80,    81,
     130,     0,     0,    83,   519,    84,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   112,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
      20,    21,   113,    23,    24,    25,     0,     0,    26,     0,
      28,     0,   -20,    29,    30,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,     0,    62,  -158,    63,    64,
      65,   129,  -158,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,   288,   289,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,    78,     0,     0,     0,    79,    80,    81,   130,
       0,   186,    83,     0,    84,     3,     0,     0,     0,     0,
       0,   314,   315,   316,   112,     0,     0,     0,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   113,    23,    24,
       0,     0,     0,     0,     0,     0,     0,   -20,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,     0,    35,    36,     0,     0,     0,     0,   321,     0,
       0,     0,     0,     0,    37,    38,    39,    40,    41,    42,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,    43,     0,     0,     0,    44,    45,
      46,    47,     0,     0,     0,    51,    52,    53,    54,    55,
      56,    57,     0,     0,     0,     0,    58,    59,    60,    61,
     114,    62,  -158,    63,    64,    65,   115,  -158,    67,    68,
      69,     0,    70,    71,    72,     0,     0,     0,    73,     0,
       0,    74,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    76,    77,     0,    78,     0,     3,
       0,    79,    80,    81,   116,     0,     0,    83,   112,  -112,
       0,     0,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   113,    23,    24,     0,     0,     0,     0,     0,     0,
       0,   -20,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,    44,    45,    46,    47,     0,     0,     0,    51,
      52,    53,    54,    55,    56,    57,     0,     0,     0,     0,
      58,    59,    60,    61,   114,    62,     0,    63,    64,    65,
     115,     0,    67,    68,    69,     0,    70,    71,    72,     0,
       0,     0,    73,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,    77,
       3,    78,     0,     0,     0,    79,    80,    81,   116,   112,
       0,    83,     0,    14,    15,   600,     0,    17,    18,    19,
      20,    21,   113,    23,    24,     0,     0,     0,     0,     0,
       0,     0,   -20,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,    44,    45,    46,    47,     0,     0,     0,
      51,    52,    53,    54,    55,    56,    57,     0,     0,     0,
       0,    58,    59,    60,    61,   114,    62,     0,    63,    64,
      65,   115,     0,    67,    68,    69,     0,    70,    71,    72,
       0,     0,     0,    73,     0,     0,    74,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     3,    78,     0,     0,     0,    79,    80,    81,   116,
     112,     0,    83,     0,    14,    15,   607,     0,    17,    18,
      19,    20,    21,   113,    23,    24,     0,     0,     0,     0,
       0,     0,     0,   -20,     0,     0,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,     0,     0,
       0,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,   114,    62,     0,    63,
      64,    65,   115,     0,    67,    68,    69,     0,    70,    71,
      72,     0,     0,     0,    73,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     3,    78,     0,     0,     0,    79,    80,    81,
     116,   112,     0,    83,     0,    14,    15,   692,     0,    17,
      18,    19,    20,    21,   113,    23,    24,     0,     0,     0,
       0,     0,     0,     0,   -20,     0,     0,     0,     0,     0,
       0,    31,     0,     0,    33,    34,     0,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,     0,
       0,     0,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,   114,    62,     0,
      63,    64,    65,   115,     0,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     3,    78,     0,     0,     0,    79,    80,
      81,   116,   112,     0,    83,     0,    14,    15,   695,     0,
      17,    18,    19,    20,    21,   113,    23,    24,     0,     0,
       0,     0,     0,     0,     0,   -20,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,    44,    45,    46,    47,
       0,     0,     0,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,   114,    62,
       0,    63,    64,    65,   115,     0,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,     0,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    78,     0,     3,     0,    79,
      80,    81,   116,     0,     0,    83,   112,     0,   205,     0,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   113,
      23,    24,     0,     0,     0,     0,     0,     0,     0,   -20,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,     0,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
      44,    45,    46,    47,     0,     0,     0,    51,    52,    53,
      54,    55,    56,    57,     0,     0,     0,     0,    58,    59,
      60,    61,   114,    62,     0,    63,    64,    65,   115,     0,
      67,    68,    69,     0,    70,    71,    72,     0,     0,     0,
      73,     0,     0,    74,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    76,    77,     0,    78,
       0,     3,     0,    79,    80,    81,   116,     0,     0,    83,
     112,   -86,     0,     0,    14,    15,     0,     0,    17,    18,
      19,    20,    21,   113,    23,    24,     0,     0,     0,     0,
       0,     0,     0,   -20,     0,     0,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,     0,    35,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,    44,    45,    46,    47,     0,     0,
       0,    51,    52,    53,    54,    55,    56,    57,     0,     0,
       0,     0,    58,    59,    60,    61,   114,    62,     0,    63,
      64,    65,   115,     0,    67,    68,    69,     0,    70,    71,
      72,     0,     0,     0,    73,     0,     0,    74,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      76,    77,     3,    78,     0,     0,     0,    79,    80,    81,
     116,   112,     0,    83,   280,    14,    15,     0,     0,    17,
      18,    19,    20,    21,   113,    23,    24,     0,     0,     0,
       0,     0,     0,     0,   -20,     0,     0,     0,     0,     0,
       0,    31,     0,     0,    33,    34,     0,     0,     0,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,    44,    45,    46,    47,     0,
       0,     0,    51,    52,    53,    54,    55,    56,    57,     0,
       0,     0,     0,    58,    59,    60,    61,   114,    62,     0,
      63,    64,    65,   115,     0,    67,    68,    69,     0,    70,
      71,    72,     0,     0,     0,    73,     0,     0,    74,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    76,    77,     3,    78,     0,     0,     0,    79,    80,
      81,   116,   112,     0,    83,   283,    14,    15,     0,     0,
      17,    18,    19,    20,    21,   113,    23,    24,     0,     0,
       0,     0,     0,     0,     0,   -20,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,     0,
       0,     0,     0,   775,     0,   776,   777,     0,     0,     0,
     778,   779,    43,     0,     0,     0,    44,    45,    46,    47,
       0,     0,     0,    51,    52,    53,    54,    55,    56,    57,
       0,     0,     0,     0,    58,    59,    60,    61,   114,    62,
       0,    63,    64,    65,   115,     0,    67,    68,    69,     0,
      70,    71,    72,     0,     0,     0,    73,   780,     0,    74,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     781,   782,    76,    77,     3,    78,     0,     0,     0,    79,
      80,    81,   116,   112,     0,    83,     0,    14,    15,     0,
       0,    17,    18,    19,    20,    21,   113,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,    44,    45,    46,
      47,     0,     0,     0,    51,    52,    53,    54,    55,    56,
      57,     0,     0,     0,     0,    58,    59,    60,    61,   114,
      62,  -158,    63,    64,    65,   115,  -158,    67,    68,    69,
       0,    70,    71,    72,     0,     0,     0,    73,     0,     0,
      74,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     3,    78,     0,     0,     0,
      79,    80,    81,   116,   112,     0,    83,     0,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   113,    23,    24,
       0,     0,     0,     0,     0,     0,     0,   -20,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,     0,    35,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     0,    44,    45,
      46,    47,     0,     0,     0,    51,    52,    53,    54,    55,
      56,    57,     0,     0,     0,   458,    58,    59,    60,    61,
     114,    62,     0,    63,    64,    65,   115,     0,    67,    68,
      69,     0,    70,    71,    72,     0,     0,     0,    73,     0,
       0,    74,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    76,    77,     3,    78,     0,     0,
       0,    79,    80,    81,   116,   112,     0,    83,     0,    14,
      15,     0,     0,    17,    18,    19,    20,    21,   113,    23,
      24,     0,     0,     0,     0,     0,     0,     0,   -20,     0,
       0,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,     0,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,    44,
      45,    46,    47,     0,     0,     0,    51,    52,    53,    54,
      55,    56,    57,     0,     0,     0,   513,    58,    59,    60,
      61,   114,    62,     0,    63,    64,    65,   115,     0,    67,
      68,    69,     0,    70,    71,    72,     0,     0,     0,    73,
       0,     0,    74,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    77,     3,    78,     0,
       0,     0,    79,    80,    81,   116,   112,     0,    83,     0,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   113,
      23,    24,     0,     0,     0,     0,     0,     0,     0,   -20,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,     0,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
      44,    45,    46,    47,     0,     0,     0,    51,    52,    53,
      54,    55,    56,    57,     0,     0,     0,     0,    58,    59,
      60,    61,   114,    62,     0,    63,    64,    65,   115,   622,
      67,    68,    69,     0,    70,    71,    72,     0,     0,     0,
      73,     0,     0,    74,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    76,    77,     0,    78,
       0,     0,     0,    79,    80,    81,   116,     0,     0,    83,
       0,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,     0,     0,     0,     0,     0,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,     0,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,   318,   319,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   357,     0,     0,     0,
       0,   321,     0,     0,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,     0,     0,
       0,     0,     0,   335,   336,   337,   338,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   358,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,     0,     0,     0,     0,
       0,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,   318,   319,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,     0,     0,     0,     0,   335,   336,   337,   338,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   602,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,     0,     0,   603,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   609,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,     0,     0,   610,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,     0,     0,   691,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,     0,     0,   694,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,   386,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,     0,   387,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,   318,
     319,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
       0,   322,   323,   324,     0,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,     0,     0,   522,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,     0,     0,   523,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,     0,
       0,     0,     0,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,     0,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,   318,   319,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,   322,
     323,   324,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,     0,     0,     0,     0,     0,   335,   336,
     337,   338,     0,     0,   539,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,     0,     0,
       0,     0,     0,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,     0,   314,   315,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,   318,   319,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,     0,     0,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,     0,     0,     0,     0,     0,   335,   336,   337,
     338,     0,     0,   547,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,     0,     0,     0,
       0,     0,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   317,   318,   319,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,   322,   323,   324,
       0,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
       0,     0,   626,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,     0,     0,     0,     0,
       0,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,   318,   319,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,     0,     0,     0,     0,   335,   336,   337,   338,     0,
       0,   632,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,     0,     0,     0,     0,     0,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,     0,   314,   315,   316,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   317,   318,   319,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,     0,     0,   322,   323,   324,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,     0,
       0,     0,     0,     0,   335,   336,   337,   338,     0,     0,
     696,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,     0,     0,     0,     0,     0,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,     0,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,   318,   319,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,     0,     0,
       0,     0,     0,   335,   336,   337,   338,     0,     0,   706,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,     0,     0,     0,     0,     0,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     317,   318,   319,   320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,   322,   323,   324,     0,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338,     0,     0,   710,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,     0,   711,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   317,   318,
     319,   320,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   321,     0,
       0,   322,   323,   324,     0,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,     0,     0,     0,     0,
     335,   336,   337,   338,     0,     0,   712,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,     0,     0,   833,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,     0,
       0,     0,     0,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,     0,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,   318,   319,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,   322,
     323,   324,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,     0,     0,     0,     0,     0,   335,   336,
     337,   338,     0,     0,   874,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,     0,     0,     0,
       0,     0,     0,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,     0,   254,   255,
     256,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   257,   258,   259,   260,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   261,     0,     0,   262,   263,
     264,     0,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,     0,     0,     0,     0,     0,   275,   276,   277,
     278,     0,   279,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,     0,     0,     0,     0,
       0,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,   318,   319,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,     0,     0,     0,     0,   335,   336,   337,   338,     0,
     348,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,     0,     0,     0,     0,     0,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,     0,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,   318,   319,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,     0,     0,
       0,     0,     0,   335,   336,   337,   338,     0,   630,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,   631,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,     0,   707,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,     0,     0,
       0,     0,     0,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,     0,   314,   315,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,   318,   319,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,     0,     0,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,     0,     0,     0,     0,     0,   335,   336,   337,
     338,     0,   708,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,     0,     0,     0,     0,
       0,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,   318,   319,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,     0,     0,     0,     0,   335,   336,   337,   338,     0,
     718,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,     0,     0,     0,     0,     0,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,     0,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,   318,   319,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,     0,     0,
       0,     0,     0,   335,   336,   337,   338,     0,   886,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,     0,   913,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,     0,   921,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,     0,     0,
       0,     0,     0,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,     0,   314,   315,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,   318,   319,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,     0,     0,   322,   323,
     324,     0,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,     0,     0,     0,     0,     0,   335,   336,   337,
     338,     0,   924,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,     0,     0,     0,     0,
       0,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,   318,   319,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,   322,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,     0,     0,     0,     0,   335,   336,   337,   338,     0,
     926,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,     0,     0,     0,     0,     0,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,     0,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,   318,   319,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,   322,   323,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,     0,     0,
       0,     0,     0,   335,   336,   337,   338,     0,   932,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,     0,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,   599,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,     0,
       0,     0,     0,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,     0,   314,
     315,   316,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,   318,   319,   320,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,   322,
     323,   324,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,     0,     0,     0,     0,     0,   335,   336,
     337,   338,   606,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,     0,     0,     0,     0,
       0,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,   318,   319,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,   322,   323,   324,   386,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,     0,     0,     0,     0,   335,   336,   337,   338,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,   598,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,     0,     0,
       0,     0,     0,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,     0,   314,   315,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,   318,   319,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,     0,     0,   322,   323,
     324,   605,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,     0,     0,     0,     0,     0,   335,   336,   337,
     338,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,     0,     0,     0,     0,     0,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,     0,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,   318,   319,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,   322,   323,   324,   843,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,     0,     0,
       0,     0,     0,   335,   336,   337,   338,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,   875,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,     0,     0,     0,     0,
       0,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   317,   318,   319,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,   322,   323,   324,   876,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,     0,     0,     0,     0,   335,   336,   337,   338,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,     0,     0,     0,     0,     0,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
     318,   319,   320,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,   322,   323,   324,   877,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,     0,     0,
       0,     0,     0,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,     0,   314,   315,
     316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,   318,   319,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,     0,     0,   322,   323,
     324,   881,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,     0,     0,     0,     0,     0,   335,   336,   337,
     338,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,     0,     0,     0,     0,     0,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,     0,   314,   315,   316,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   317,   318,   319,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,   322,   323,   324,   882,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,     0,     0,
       0,     0,     0,   335,   336,   337,   338,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,     0,
     314,   315,   316,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   317,   318,   319,
     320,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
     322,   323,   324,     0,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,     0,     0,     0,     0,     0,   335,
     336,   337,   338,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,     0,     0,     0,     0,
       0,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   288,   289,   317,   318,   319,   320,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   321,   314,   315,   316,   323,   324,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,   317,   318,     0,   320,   335,   336,   337,   338,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,     0,     0,   324,     0,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   288,   289,
       0,     0,     0,   335,   336,   337,   338,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
       0,   314,   315,   316,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   288,   289,   317,   318,
       0,  -219,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   321,   314,
     315,   316,     0,     0,     0,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,     0,   317,   318,     0,     0,
     335,   336,   337,   338,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,     0,
       0,     0,     0,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   288,   289,     0,     0,     0,   335,   336,
     337,   338,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   300,     0,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,     0,   314,   315,   316,   288,
     289,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,     0,   314,   315,   316,     0,     0,     0,     0,     0,
       0,     0,     0,   321,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
       0,     0,     0,     0,     0,   335,   336,   337,   338,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,     0,     0,   288,   289,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,     0,     0,     0,     0,
       0,   335,   336,   337,   338,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,     0,   314,   315,   316,
     288,   289,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,     0,   314,   315,   316,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,     0,     0,     0,
       0,     0,   326,   327,   328,   329,   330,   331,   332,   333,
     334,     0,     0,     0,     0,     0,   335,   336,   337,   338,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,     0,     0,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,   333,   334,     0,     0,     0,
       0,     0,   335,   336,   337,   338
};

static const yytype_int16 yycheck[] =
{
       2,     0,     3,   102,     6,   130,     0,   397,   213,   397,
     159,   397,   126,    15,    16,    17,    18,   222,     5,   118,
      50,   397,   397,     0,   397,   397,   397,     4,     5,   626,
     645,    34,   159,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    14,    47,    14,    50,   527,    51,
      52,    53,    54,    55,    56,    40,    41,    14,   109,    14,
     735,    48,    49,    50,    14,   135,    50,    50,    50,    14,
     685,    48,    49,    50,    76,    77,   135,    79,    80,    81,
     138,    83,   109,   112,   114,    14,    85,   135,   117,   116,
     160,    85,    27,    24,    25,    26,    27,    28,    29,    34,
     159,   159,   135,    34,   586,    82,   588,   158,    85,    44,
     158,   114,   114,    44,   116,    50,    47,    48,    24,    25,
      26,    27,    28,    29,   126,    45,   159,   159,    34,    49,
     114,   114,   114,   109,   136,   137,   811,   673,    44,   618,
     116,    47,    48,    89,   136,   681,   116,   157,   116,   109,
     765,   154,   109,   130,   109,   112,   116,   112,   160,   116,
     117,   640,   117,   109,   109,   157,   116,   159,   155,   115,
     154,   154,   154,   158,   109,   565,   111,   565,   155,   565,
     109,   116,   135,    14,   135,   157,   135,   116,   190,   565,
     565,   673,   565,   565,   565,    24,    25,    26,    27,   681,
     157,   121,   157,   408,   683,   684,   159,   127,   159,   158,
     211,   810,   147,    34,   673,   814,    37,   109,   817,   157,
     112,   820,   681,   158,   116,   117,   203,   158,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
      14,   866,   158,   255,   256,   257,   258,   259,   260,     0,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   390,   874,   109,   758,
     109,   112,   761,   898,   159,   116,   117,   116,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     667,   668,   669,   315,   316,   317,   318,   319,   320,   136,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   109,   136,   111,   136,
     157,    82,   159,   116,    85,   109,   673,   136,   112,    89,
     136,    40,    41,   117,   681,   357,    52,    53,   157,   361,
     159,   109,   159,   109,   112,   367,   368,   369,   345,   109,
     159,   157,   138,   159,   147,   115,   116,   143,   144,    89,
       0,    14,   384,     3,   386,   158,   157,   159,   390,   130,
     109,    24,    25,    26,    27,    28,    29,   116,   397,   109,
     673,    34,   154,   397,    37,   115,   116,   159,   681,    82,
     653,    44,   109,   656,    47,    48,   154,   157,    14,   116,
     899,   159,   114,   189,   116,   154,   192,   109,    24,    25,
      26,    27,    28,    29,   116,   109,   132,   109,    34,   111,
     157,    37,   116,   109,   116,   650,   651,   157,    44,   157,
     116,    47,    48,   123,    52,    53,   458,   130,   154,   155,
     156,   157,   203,    37,   159,    85,   157,    24,    25,    26,
      27,    28,    29,   678,   573,   147,   109,    34,   111,    37,
     109,   109,   102,   116,   112,   109,   158,    44,   116,   117,
      47,    48,   116,   112,     9,    11,   157,   157,   118,    24,
      25,    26,    27,    28,    29,   741,   157,   743,   157,    34,
     746,   513,   278,   109,   147,   111,   157,   109,   520,    44,
     116,    89,    47,    48,   729,   158,   136,   529,   530,   531,
     203,   533,   534,   535,   132,   522,   523,    27,   540,   136,
     157,   109,   157,    89,    34,   522,   523,   115,   116,   157,
     755,   147,   157,   160,    44,    42,   154,   155,   156,   157,
      50,    27,   158,   109,   157,   129,   565,   157,    34,   115,
     116,   565,   338,   157,   112,    14,    27,   343,    44,   117,
     679,    52,    53,    34,    50,   154,   129,   586,   354,   588,
     159,   211,   586,    44,   588,   160,   598,   157,   157,    50,
     602,   158,    14,   605,   345,   159,   157,   609,   374,   375,
     376,   157,    24,    25,    26,    27,    28,    29,   619,   109,
     154,   111,   136,   160,   160,   159,   116,    89,   394,   395,
     396,   136,    44,   158,   254,    47,    48,   154,   157,   405,
     406,   407,   159,   109,   109,   111,   111,   109,   157,    27,
     116,   116,   136,   115,   116,   157,    34,   147,   109,   784,
     111,   132,   109,   160,   111,   116,    44,   160,   158,   116,
       4,   109,   345,   111,   673,   146,   147,   148,   116,   673,
     157,   147,   681,   154,   155,   156,   157,   681,   157,   157,
     154,   109,   158,   111,   314,   157,   147,   109,   116,   111,
     147,    52,    53,   705,   116,   154,   160,   158,   160,   147,
     697,   698,   714,    14,   157,   840,   160,   154,   843,   706,
     697,   698,   709,    24,    25,    26,    27,    28,    29,   706,
     160,   109,   709,   111,   154,   147,   737,   160,   116,   159,
     741,    89,   743,    44,    89,   746,    47,    48,   157,   160,
     875,   876,   877,   878,   879,   521,   881,   882,   524,   160,
     154,   109,   160,   160,   109,   159,   111,   115,   116,   147,
     115,   116,   774,   775,   776,   777,    27,   397,   160,   781,
     782,   132,   159,    34,   109,   160,   111,   109,   135,   111,
     556,   116,   794,    44,   116,   160,   147,   148,   160,    50,
     801,    89,   147,   154,   155,   156,   157,   784,   109,   810,
     111,   160,    43,   814,    89,   116,   817,   157,   159,   820,
     159,   109,   147,   160,   590,   147,   154,   115,   116,   595,
     596,   597,   157,   157,   109,   157,    36,   160,   125,   126,
     115,   116,   129,   130,   138,   832,   147,   109,   125,   126,
     109,   853,   129,   130,    27,   832,   160,   160,   109,   801,
     111,    34,    27,   840,   160,   116,   843,   844,   810,    34,
     160,    44,   814,   159,   157,   817,   157,    50,   820,    44,
     646,   138,   135,   157,   160,    50,   888,   114,   116,   109,
     892,   160,   160,   895,   129,   129,   147,   138,   875,   876,
     877,   878,   879,   880,   881,   882,   883,   158,   910,    34,
     109,   114,   160,   900,   138,   138,   160,   160,   160,   109,
     686,   160,   159,   900,   901,   902,   903,   904,   905,   906,
     907,   160,    85,   699,   160,    27,   109,   159,   111,   160,
     159,   159,    34,   116,   109,   565,   111,   620,   621,   565,
      14,   116,    44,   573,    28,   372,   576,   577,    50,   716,
      24,    25,    26,    27,    28,    29,   221,   665,   577,   811,
     643,   644,    71,   789,   147,   588,   384,    52,    53,    -1,
      44,    -1,   147,    47,    48,   158,    -1,    -1,    -1,    -1,
     756,    -1,    -1,   158,    -1,    -1,    -1,    -1,    -1,   619,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,   787,   788,    -1,   116,    -1,    -1,   700,    -1,   795,
      -1,    -1,    -1,   653,    -1,    -1,   656,    -1,    -1,    -1,
      -1,    -1,    -1,   784,    -1,   109,    -1,   111,    -1,    -1,
     723,   724,   116,    -1,   727,   147,   822,   132,   678,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   158,   142,   143,   144,
     145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,
     155,   156,   157,   147,    -1,    -1,   759,   760,    -1,    -1,
     763,   764,    24,    25,    26,    27,    28,    29,    -1,   840,
      -1,    -1,   843,   844,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   784,    44,    -1,    -1,    47,    48,   737,    -1,    52,
      53,   741,    -1,   743,    -1,    -1,   746,   893,    -1,    -1,
     896,    -1,    -1,    -1,   875,   876,   877,   878,   879,   880,
     881,   882,   883,    -1,    -1,   911,    -1,    -1,    -1,    -1,
      -1,   824,    -1,    -1,   827,   828,    -1,    -1,   831,    -1,
     901,   902,   903,   904,   905,   906,   907,   840,    -1,    -1,
     843,   844,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     800,   801,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     810,    -1,    -1,    -1,   814,    -1,    -1,   817,    -1,   132,
     820,    -1,   875,   876,   877,   878,   879,   880,   881,   882,
     883,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    -1,    -1,    -1,   901,   902,
     903,   904,   905,   906,   907,    -1,     0,     1,    -1,     3,
      -1,     5,     6,     7,     8,   918,   919,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      34,    35,    -1,    37,    38,    39,    -1,    -1,    -1,    -1,
      44,    45,    46,    47,    48,    49,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      64,    65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      84,    -1,    -1,    -1,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,    -1,    -1,   131,    -1,   133,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     144,   145,    -1,   147,    -1,    -1,    -1,   151,   152,   153,
     154,    -1,     1,   157,    -1,   159,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    14,    -1,    -1,    -1,    18,
      19,    -1,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    64,    65,    66,    67,    68,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    88,
      89,    90,    91,    -1,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,    -1,
      -1,    -1,   151,   152,   153,   154,    -1,    -1,   157,    -1,
       1,   160,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    33,    34,    35,    -1,    37,    38,    39,    -1,
      -1,    -1,    -1,    44,    45,    46,    47,    48,    49,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    64,    65,    66,    67,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,    -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,    -1,    -1,
     131,    -1,   133,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,    -1,   147,    -1,    -1,    -1,
     151,   152,   153,   154,    -1,     1,   157,     3,   159,     5,
       6,     7,     8,    -1,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    -1,    -1,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,    65,
      66,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,
      -1,    -1,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,    -1,    -1,    -1,    -1,
     106,   107,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,   145,
      -1,   147,    -1,    -1,    -1,   151,   152,   153,   154,    -1,
       1,   157,     3,   159,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,    40,
      41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    64,    65,    66,    67,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,    -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,    -1,   147,    -1,    -1,    -1,
     151,   152,   153,   154,    -1,    -1,   157,   158,   159,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    64,    65,    66,    67,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
      -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   144,   145,    -1,   147,    -1,    -1,    -1,   151,
     152,   153,   154,    -1,    -1,   157,   158,   159,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      33,    -1,    35,    -1,    37,    38,    39,    40,    41,    -1,
      -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    64,    65,    66,    67,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   144,   145,    -1,   147,    -1,    -1,    -1,   151,   152,
     153,   154,    -1,    -1,   157,   158,   159,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      64,    65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      84,    -1,    -1,    -1,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     144,   145,    -1,   147,    -1,    -1,    -1,   151,   152,   153,
     154,    -1,    -1,   157,   158,   159,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    33,    -1,
      35,    -1,    37,    38,    39,    40,    41,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,
      65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,    -1,    -1,    -1,
      -1,   106,   107,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,
     145,    -1,   147,    -1,    -1,    -1,   151,   152,   153,   154,
      -1,    -1,   157,   158,   159,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,    65,
      66,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,
      -1,    -1,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,    -1,    -1,    -1,    -1,
     106,   107,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,   145,
      -1,   147,    -1,    -1,    -1,   151,   152,   153,   154,    -1,
      -1,   157,   158,   159,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,
      37,    38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,
      47,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,    65,    66,
      67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,
      -1,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,    -1,    -1,    -1,    -1,   106,
     107,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,   145,    -1,
     147,    -1,    -1,    -1,   151,   152,   153,   154,    -1,    -1,
     157,   158,   159,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    65,    66,    67,
      68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,
      -1,    -1,    -1,   151,   152,   153,   154,    -1,    -1,   157,
     158,   159,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,
      39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    64,    65,    66,    67,    68,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,    -1,
      -1,    -1,   151,   152,   153,   154,    -1,    -1,   157,   158,
     159,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    64,    65,    66,    67,    68,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   144,   145,    -1,   147,    -1,    -1,
      -1,   151,   152,   153,   154,    -1,    -1,   157,   158,   159,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,    40,
      41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    64,    65,    66,    67,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,    -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,    -1,   147,    -1,    -1,    -1,
     151,   152,   153,   154,    -1,    -1,   157,   158,   159,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    64,    65,    66,    67,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
      -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   144,   145,    -1,   147,    -1,    -1,    -1,   151,
     152,   153,   154,    -1,    -1,   157,   158,   159,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      33,    -1,    35,    -1,    37,    38,    39,    40,    41,    -1,
      -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    64,    65,    66,    67,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   144,   145,    -1,   147,    -1,    -1,    -1,   151,   152,
     153,   154,    -1,    -1,   157,   158,   159,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      64,    65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      84,    -1,    -1,    -1,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     144,   145,    -1,   147,    -1,    -1,    -1,   151,   152,   153,
     154,    -1,    -1,   157,   158,   159,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    33,    -1,
      35,    -1,    37,    38,    39,    40,    41,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,
      65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,    -1,    -1,    -1,
      -1,   106,   107,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,
     145,    -1,   147,    -1,    -1,    -1,   151,   152,   153,   154,
      -1,    -1,   157,   158,   159,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    33,    -1,    35,
      -1,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,    65,
      66,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,
      -1,    -1,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,    -1,    -1,    -1,    -1,
     106,   107,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,   145,
      -1,   147,    -1,    -1,    -1,   151,   152,   153,   154,    -1,
      -1,   157,   158,   159,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,
      37,    38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,
      47,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,    65,    66,
      67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,
      -1,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,    -1,    -1,    -1,    -1,   106,
     107,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,   145,    -1,
     147,    -1,    -1,    -1,   151,   152,   153,   154,    -1,    -1,
     157,   158,   159,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    65,    66,    67,
      68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,
      -1,    -1,    -1,   151,   152,   153,   154,    -1,    -1,   157,
     158,   159,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,
      39,    40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    64,    65,    66,    67,    68,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,    -1,
      -1,    -1,   151,   152,   153,   154,    -1,    -1,   157,   158,
     159,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    64,    65,    66,    67,    68,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   144,   145,    -1,   147,    -1,    -1,
      -1,   151,   152,   153,   154,    -1,    -1,   157,   158,   159,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    33,    -1,    35,    -1,    37,    38,    39,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    64,    65,    66,    67,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,    -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,    -1,   147,    -1,    -1,    -1,
     151,   152,   153,   154,    -1,    -1,   157,   158,   159,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    33,    -1,    35,    -1,    37,    38,    39,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    64,    65,    66,    67,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
      -1,    -1,    -1,    -1,   106,   107,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   144,   145,    -1,   147,    -1,    -1,    -1,   151,
     152,   153,   154,    -1,    -1,   157,   158,   159,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      33,    -1,    35,    -1,    37,    38,    39,    -1,    -1,    -1,
      -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    64,    65,    66,    67,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   144,   145,    -1,   147,    -1,    -1,    -1,   151,   152,
     153,   154,    -1,    -1,   157,   158,   159,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    33,
      -1,    35,    -1,    37,    38,    39,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      64,    65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      84,    -1,    -1,    -1,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     144,   145,    -1,   147,    -1,    -1,    -1,   151,   152,   153,
     154,    -1,    -1,   157,   158,   159,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    33,    -1,
      35,    -1,    37,    38,    39,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,
      65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,    -1,    -1,    -1,
      -1,   106,   107,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,
     145,    -1,   147,    -1,    -1,    -1,   151,   152,   153,   154,
      -1,     1,   157,    -1,   159,     5,    -1,    -1,    -1,    -1,
      -1,    85,    86,    87,    14,    -1,    -1,    -1,    18,    19,
      -1,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,   132,    -1,
      -1,    -1,    -1,    -1,    64,    65,    66,    67,    68,    69,
     144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,
     154,   155,   156,   157,    84,    -1,    -1,    -1,    88,    89,
      90,    91,    -1,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,    -1,    -1,    -1,    -1,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   144,   145,    -1,   147,    -1,     5,
      -1,   151,   152,   153,   154,    -1,    -1,   157,    14,   159,
      -1,    -1,    18,    19,    -1,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,
      -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,    65,
      66,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,
      -1,    -1,    88,    89,    90,    91,    -1,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,    -1,    -1,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
     116,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,   145,
       5,   147,    -1,    -1,    -1,   151,   152,   153,   154,    14,
      -1,   157,    -1,    18,    19,   161,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,
      65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    -1,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,    -1,    -1,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,   116,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,
     145,     5,   147,    -1,    -1,    -1,   151,   152,   153,   154,
      14,    -1,   157,    -1,    18,    19,   161,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      64,    65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      84,    -1,    -1,    -1,    88,    89,    90,    91,    -1,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,   110,   111,    -1,   113,
     114,   115,   116,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     144,   145,     5,   147,    -1,    -1,    -1,   151,   152,   153,
     154,    14,    -1,   157,    -1,    18,    19,   161,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    64,    65,    66,    67,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,    -1,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,   116,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   144,   145,     5,   147,    -1,    -1,    -1,   151,   152,
     153,   154,    14,    -1,   157,    -1,    18,    19,   161,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    64,    65,    66,    67,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,
      -1,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
      -1,    -1,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,   116,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   144,   145,    -1,   147,    -1,     5,    -1,   151,
     152,   153,   154,    -1,    -1,   157,    14,    -1,   160,    -1,
      18,    19,    -1,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    65,    66,    67,
      68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,
      88,    89,    90,    91,    -1,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,   116,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,
      -1,     5,    -1,   151,   152,   153,   154,    -1,    -1,   157,
      14,   159,    -1,    -1,    18,    19,    -1,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      64,    65,    66,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      84,    -1,    -1,    -1,    88,    89,    90,    91,    -1,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,   110,   111,    -1,   113,
     114,   115,   116,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     144,   145,     5,   147,    -1,    -1,    -1,   151,   152,   153,
     154,    14,    -1,   157,   158,    18,    19,    -1,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    64,    65,    66,    67,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    84,    -1,    -1,    -1,    88,    89,    90,    91,    -1,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,   116,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   144,   145,     5,   147,    -1,    -1,    -1,   151,   152,
     153,   154,    14,    -1,   157,   158,    18,    19,    -1,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    64,    65,    66,    67,    68,    69,    -1,    -1,
      -1,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,    -1,
      82,    83,    84,    -1,    -1,    -1,    88,    89,    90,    91,
      -1,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
      -1,    -1,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,   116,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,   129,    -1,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,     5,   147,    -1,    -1,    -1,   151,
     152,   153,   154,    14,    -1,   157,    -1,    18,    19,    -1,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    64,    65,    66,    67,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,
      91,    -1,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,    -1,    -1,    -1,    -1,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,     5,   147,    -1,    -1,    -1,
     151,   152,   153,   154,    14,    -1,   157,    -1,    18,    19,
      -1,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    64,    65,    66,    67,    68,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,
      90,    91,    -1,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,    -1,    -1,    -1,   105,   106,   107,   108,   109,
     110,   111,    -1,   113,   114,   115,   116,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   144,   145,     5,   147,    -1,    -1,
      -1,   151,   152,   153,   154,    14,    -1,   157,    -1,    18,
      19,    -1,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    64,    65,    66,    67,    68,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    88,
      89,    90,    91,    -1,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,    -1,    -1,    -1,   105,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,   116,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   144,   145,     5,   147,    -1,
      -1,    -1,   151,   152,   153,   154,    14,    -1,   157,    -1,
      18,    19,    -1,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,    47,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    65,    66,    67,
      68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,
      88,    89,    90,    91,    -1,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,   116,    10,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,
      -1,    -1,    -1,   151,   152,   153,   154,    -1,    -1,   157,
      -1,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    21,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,    -1,    -1,
      -1,    -1,    -1,   154,   155,   156,   157,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    21,    -1,    -1,    -1,    -1,   132,    -1,    -1,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,
     155,   156,   157,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   135,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    -1,    -1,    -1,   161,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    -1,    -1,    -1,   161,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    -1,    -1,    -1,   161,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    -1,    -1,    -1,   161,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    -1,    -1,   160,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,
      -1,   135,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,
     154,   155,   156,   157,    -1,    -1,   160,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,
     155,   156,   157,    -1,    -1,   160,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    -1,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,   155,
     156,   157,    -1,    -1,   160,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,    -1,    -1,    -1,    -1,    -1,   154,   155,   156,
     157,    -1,    -1,   160,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    -1,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   132,    -1,    -1,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,    -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,
      -1,    -1,   160,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   135,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,    -1,
      -1,   160,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    -1,    85,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,    -1,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,    -1,
      -1,    -1,    -1,    -1,   154,   155,   156,   157,    -1,    -1,
     160,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,    -1,    -1,
      -1,    -1,    -1,   154,   155,   156,   157,    -1,    -1,   160,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     132,    -1,    -1,   135,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,    -1,    -1,    -1,
      -1,    -1,   154,   155,   156,   157,    -1,    -1,   160,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    -1,    -1,   160,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,   103,
     104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,
      -1,   135,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,
     154,   155,   156,   157,    -1,    -1,   160,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,
     155,   156,   157,    -1,    -1,   160,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    -1,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,   155,
     156,   157,    -1,    -1,   160,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,    -1,    -1,    -1,    -1,    -1,   154,   155,   156,
     157,    -1,   159,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   135,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,    -1,
     159,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,    -1,    -1,
      -1,    -1,    -1,   154,   155,   156,   157,    -1,   159,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    -1,   159,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,
     155,   156,   157,    -1,   159,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,    -1,    -1,    -1,    -1,    -1,   154,   155,   156,
     157,    -1,   159,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   135,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,    -1,
     159,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,    -1,    -1,
      -1,    -1,    -1,   154,   155,   156,   157,    -1,   159,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    -1,   159,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,
     155,   156,   157,    -1,   159,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,    -1,    -1,    -1,    -1,    -1,   154,   155,   156,
     157,    -1,   159,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   135,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,    -1,
     159,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,    -1,    -1,
      -1,    -1,    -1,   154,   155,   156,   157,    -1,   159,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,   158,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    -1,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,   155,
     156,   157,   158,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,    -1,    -1,    -1,    -1,    -1,   154,   155,   156,
     157,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,    -1,    -1,
      -1,    -1,    -1,   154,   155,   156,   157,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,
     155,   156,   157,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,    -1,    -1,    -1,    -1,    -1,   154,   155,   156,
     157,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,    -1,    -1,
      -1,    -1,    -1,   154,   155,   156,   157,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,    -1,    -1,    -1,    -1,    -1,   154,
     155,   156,   157,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    52,    53,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,   132,    85,    86,    87,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
      -1,   102,   103,    -1,   105,   154,   155,   156,   157,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,    -1,    -1,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,    52,    53,
      -1,    -1,    -1,   154,   155,   156,   157,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    52,    53,   102,   103,
      -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,   132,    85,
      86,    87,    -1,    -1,    -1,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,    -1,   102,   103,    -1,    -1,
     154,   155,   156,   157,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,
      -1,    -1,    -1,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,    52,    53,    -1,    -1,    -1,   154,   155,
     156,   157,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    85,    86,    87,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,    -1,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,    -1,    -1,    52,    53,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,   154,   155,   156,   157,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    -1,    85,    86,    87,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    -1,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,   144,   145,   146,   147,
     148,    -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,   148,    -1,    -1,    -1,
      -1,    -1,   154,   155,   156,   157
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,     6,     7,     8,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    33,    34,    35,    38,
      39,    44,    46,    47,    48,    52,    53,    64,    65,    66,
      67,    68,    69,    84,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   106,   107,
     108,   109,   111,   113,   114,   115,   116,   118,   119,   120,
     122,   123,   124,   128,   131,   133,   144,   145,   147,   151,
     152,   153,   154,   157,   159,   163,   164,   167,   168,   169,
     172,   173,   178,   181,   182,   185,   187,   188,   195,   196,
     209,   213,   214,   215,   217,   218,   220,   225,   227,   228,
     229,   159,    14,    27,   110,   116,   154,   195,   214,   219,
     223,   224,   225,   226,   109,   116,   157,   195,   196,   116,
     154,   174,   175,   178,   175,   226,   157,   157,   157,    89,
     109,   115,   116,   157,   207,   159,   159,   159,   226,   226,
     226,   226,    34,   109,   177,   179,   109,   116,   177,   159,
     157,   154,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   109,   111,   116,   226,   175,   175,   175,
     226,   226,   226,   226,   226,   226,     1,   186,   226,   157,
     157,   228,   157,   226,   226,   109,   111,   116,   226,   226,
     226,   158,   174,   176,   178,   160,   221,   222,   226,     0,
     164,    37,   159,    14,   109,   116,   112,   117,    45,    49,
     121,   127,    14,    27,   109,   116,   195,   215,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    85,    86,    87,   102,   103,   104,
     105,   132,   135,   136,   137,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   154,   155,   156,   157,   159,
     158,   221,   226,   158,   221,    14,    14,   195,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    85,    86,    87,   102,   103,   104,
     105,   132,   135,   136,   137,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   154,   155,   156,   157,   219,
     226,   109,   112,   157,   158,   176,    11,     9,   159,   226,
     226,   186,   157,   157,   157,   186,   186,    21,    21,   109,
     116,   157,    10,    31,    32,   175,   180,   136,   136,   157,
     226,   109,   165,   166,   157,   157,   157,   160,   186,   226,
     186,   158,   174,   178,   135,   160,   138,   160,   109,   116,
     157,   195,   196,   116,   157,   207,   157,   154,   159,   109,
     116,    42,   189,   189,   116,   157,   207,   157,    14,   116,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   125,   126,   129,   130,   129,   195,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   105,   226,
     226,   186,   158,   158,    14,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   125,   126,   129,
     130,   129,   195,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   105,   226,   226,   186,   160,   186,   158,
     157,   157,   160,   160,   159,   186,   160,   160,   226,   157,
     136,   136,   226,   157,   157,   157,   226,   226,   226,   160,
     136,   158,   166,   186,   186,   186,   160,   160,   160,   222,
     226,   219,   109,   116,   112,   117,   157,   186,   186,   186,
      14,   116,   158,   168,   169,   170,   171,   172,   173,   187,
     188,   195,   209,   214,   217,   218,   154,   154,    24,    25,
      26,    27,   109,   116,   190,   191,   154,   159,   154,   159,
     157,   186,   186,   186,   116,   157,   207,   157,   138,   158,
     161,   226,   105,   161,   160,   138,   158,   161,   226,   105,
     161,   160,   160,   226,   186,   175,   175,   186,   160,     4,
     216,   216,    10,   226,   226,   226,   160,   226,   226,   226,
     159,   159,   160,   154,   226,   160,   160,   160,   138,   159,
     210,   160,   186,   160,   160,   160,   157,   159,   158,   171,
      14,    14,   195,   192,   193,   195,   192,   109,   116,   109,
     116,   109,   116,   109,   116,   135,    24,    25,    26,    27,
      34,   158,   172,   194,   197,   198,   199,   208,   213,   214,
     158,   194,   186,   160,   160,   160,   157,   186,   186,   186,
     226,   161,   161,   226,   161,   161,   160,   160,    43,   159,
     216,   195,   196,   174,   174,   157,   160,   159,   159,   179,
     160,   160,   160,    36,    40,    41,   183,   184,   159,   109,
     116,   211,   212,   216,   160,   174,   174,   210,   186,    14,
     158,   193,   109,   158,   191,    50,   114,   154,   203,   204,
     205,   154,   205,   154,   205,    34,   154,   205,   158,   172,
     197,   198,   199,   208,   109,   195,   207,   158,   160,   216,
     216,   210,   186,   160,   160,   160,   159,   175,   175,   186,
     174,   226,   175,   175,   157,    75,    77,    78,    82,    83,
     129,   142,   143,   226,   138,   158,   184,   157,   157,   135,
     174,   174,   174,   160,   136,   157,   159,   203,   116,    27,
      44,    50,   109,   158,   172,   195,   196,   200,   201,   202,
     206,   135,   159,   158,   206,   159,   158,   206,   159,   158,
     206,   159,   207,   186,   216,   174,   174,   216,   160,   174,
     174,   210,   160,   160,   226,   226,   226,   226,   129,   129,
     138,   226,   226,   138,   176,   186,   186,   212,   226,   186,
     109,   195,   201,   136,   159,   109,   114,   158,   201,   202,
     203,   204,   158,   158,   158,   186,   160,   174,   159,   174,
     174,   159,   174,   175,   160,   138,   138,   138,   138,   138,
     176,   138,   138,   176,   160,   160,   159,   160,   136,   159,
     109,   226,   136,   157,   159,   136,   157,   159,   160,   210,
     179,   176,   176,   176,   176,   176,   176,   176,   159,   226,
     136,   157,   159,   159,   226,   186,   226,   186,   210,   216,
     175,   159,   226,   186,   159,   160,   159,   160,   159,   174,
     159,   174,   159,   160,   159,   159,   159
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   162,   163,   163,   164,   164,   164,   164,   164,   164,
     164,   164,   164,   164,   164,   164,   164,   165,   165,   166,
     167,   167,   168,   168,   168,   168,   168,   168,   168,   169,
     169,   169,   170,   170,   171,   171,   171,   171,   171,   171,
     171,   171,   171,   172,   172,   173,   173,   174,   174,   175,
     175,   176,   176,   176,   176,   177,   177,   178,   178,   178,
     178,   178,   178,   178,   178,   178,   178,   178,   178,   178,
     178,   178,   178,   178,   178,   178,   178,   178,   178,   178,
     178,   179,   179,   180,   180,   180,   181,   181,   182,   183,
     183,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     184,   185,   186,   186,   186,   187,   187,   188,   188,   188,
     188,   188,   188,   189,   189,   190,   190,   191,   191,   191,
     191,   191,   191,   191,   191,   191,   191,   192,   192,   193,
     193,   193,   194,   194,   194,   194,   194,   194,   194,   194,
     194,   194,   195,   195,   195,   195,   195,   195,   196,   196,
     197,   197,   197,   198,   198,   198,   198,   198,   198,   199,
     199,   199,   200,   200,   200,   200,   200,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   202,   203,   203,
     204,   205,   205,   205,   205,   206,   206,   206,   206,   207,
     207,   207,   208,   208,   208,   208,   209,   209,   209,   209,
     209,   209,   210,   210,   211,   211,   212,   212,   213,   213,
     214,   214,   215,   215,   215,   215,   215,   215,   215,   215,
     215,   216,   216,   217,   217,   217,   217,   218,   218,   218,
     218,   219,   219,   220,   220,   221,   221,   221,   222,   223,
     224,   224,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   227,   227,   227,   227,   227,   227,   227,   227,   227,
     227,   227,   227,   227,   227,   227,   227,   227,   227,   227,
     227,   227,   227,   227,   227,   227,   227,   227,   227,   227,
     227,   227,   227,   227,   227,   227,   227,   227,   227,   227,
     227,   227,   227,   227,   227,   227,   227,   227,   227,   227,
     227,   227,   227,   227,   227,   227,   227,   227,   227,   228,
     228,   229,   229,   229,   229,   229
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     4,     1,     1,     2,     4,
       0,     1,     4,     3,     4,     3,     4,     4,     5,     5,
       3,     4,     1,     2,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     5,     6,     5,     6,     3,     2,     1,
       1,     1,     1,     2,     2,     0,     1,     1,     2,     5,
       1,     2,     3,     2,     2,     2,     3,    11,     7,     5,
       7,     5,     7,     9,     7,     2,     2,     2,     2,     1,
       2,     0,     2,     4,     4,     4,     1,     2,     7,     1,
       2,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     5,     4,     5,     4,     4,     3,     4,     3,     3,
       2,     7,     0,     1,     1,     6,     6,     6,     6,     4,
       4,     5,     5,     2,     0,     1,     3,     1,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     1,     2,     3,
       5,     6,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     2,     2,     2,     0,     1,
       3,     4,     3,     3,     4,     3,     3,     4,     3,     3,
       4,     3,     4,     3,     6,     5,     7,     3,     5,     6,
       3,     5,     6,     2,     4,     1,     1,     2,     1,     2,
       2,     1,     1,     3,     3,     1,     1,     2,     2,     2,
       2,     1,     7,     7,     7,     7,     8,     8,     8,     8,
       7,     7,     2,     0,     1,     3,     4,     4,     0,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     0,     6,     6,     7,     7,     7,     7,     8,
       8,     3,     2,     3,     2,     1,     3,     2,     3,     3,
       3,     2,     1,     1,     3,     1,     2,     2,     2,     3,
       2,     3,     4,     1,     1,     1,     1,     1,     8,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     4,     3,     1,     2,
       2,     2,     2,     2,     5,     5,     5,     2,     1,     3,
       2,     6,     6,     7,     7,     1,     1,     2,     2,     4,
       1,     1,     1,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       5,     2,     2,     4,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     5,     5,     4,     4,     4,     3,     3,
       2,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     5,     2,
       2,     4,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     5,     5,     4,     4,     4,     3,     3,     2,     1,
       2,     1,     1,     1,     1,     1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static unsigned
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  unsigned res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                       , &(yylsp[(yyi + 1) - (yynrhs)])                       , yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yytype)
    {
          case 109: /* "identifier"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6045 "parser.cpp" /* yacc.c:1258  */
        break;

    case 110: /* "typed hash identifier"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6051 "parser.cpp" /* yacc.c:1258  */
        break;

    case 111: /* "complex type identifier"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6057 "parser.cpp" /* yacc.c:1258  */
        break;

    case 112: /* "variable reference"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6063 "parser.cpp" /* yacc.c:1258  */
        break;

    case 113: /* "backquote expression"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6069 "parser.cpp" /* yacc.c:1258  */
        break;

    case 114: /* "in-object member reference"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6075 "parser.cpp" /* yacc.c:1258  */
        break;

    case 115: /* "identifier or keyword used as function or method identifier"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6081 "parser.cpp" /* yacc.c:1258  */
        break;

    case 116: /* "namespace or class-scoped reference"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6087 "parser.cpp" /* yacc.c:1258  */
        break;

    case 117: /* "namespace-scoped global variable reference"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6093 "parser.cpp" /* yacc.c:1258  */
        break;

    case 118: /* "context reference"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6099 "parser.cpp" /* yacc.c:1258  */
        break;

    case 119: /* "named context reference"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6105 "parser.cpp" /* yacc.c:1258  */
        break;

    case 120: /* "cast operator"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6111 "parser.cpp" /* yacc.c:1258  */
        break;

    case 121: /* "simple class declaration"  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6117 "parser.cpp" /* yacc.c:1258  */
        break;

    case 122: /* "date/time value"  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).datetime)) ((*yyvaluep).datetime)->deref(); }
#line 6123 "parser.cpp" /* yacc.c:1258  */
        break;

    case 123: /* "quoted string"  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6129 "parser.cpp" /* yacc.c:1258  */
        break;

    case 124: /* "binary constant value"  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).binary)) ((*yyvaluep).binary)->deref(); }
#line 6135 "parser.cpp" /* yacc.c:1258  */
        break;

    case 125: /* "regular expression substitution expression"  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).RegexSubst); }
#line 6141 "parser.cpp" /* yacc.c:1258  */
        break;

    case 126: /* "transliteration expression"  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).Trans); }
#line 6147 "parser.cpp" /* yacc.c:1258  */
        break;

    case 127: /* "scoped class declaration"  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).nscope); }
#line 6153 "parser.cpp" /* yacc.c:1258  */
        break;

    case 128: /* "call to base class method"  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).nscope); }
#line 6159 "parser.cpp" /* yacc.c:1258  */
        break;

    case 129: /* "regular expression"  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).Regex); }
#line 6165 "parser.cpp" /* yacc.c:1258  */
        break;

    case 130: /* "regular expression extraction expression"  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).Regex); }
#line 6171 "parser.cpp" /* yacc.c:1258  */
        break;

    case 131: /* "implicit argument reference"  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).implicit_arg)) ((*yyvaluep).implicit_arg)->deref(); }
#line 6177 "parser.cpp" /* yacc.c:1258  */
        break;

    case 132: /* "keyword used as hash key or object member reference"  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6183 "parser.cpp" /* yacc.c:1258  */
        break;

    case 133: /* "%try-module error token"  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).trymod); }
#line 6189 "parser.cpp" /* yacc.c:1258  */
        break;

    case 168: /* gvardecl  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).gv); }
#line 6195 "parser.cpp" /* yacc.c:1258  */
        break;

    case 169: /* top_namespace_decl  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).ns); }
#line 6201 "parser.cpp" /* yacc.c:1258  */
        break;

    case 170: /* namespace_decls  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).nsnlist)) ((*yyvaluep).nsnlist)->deref(); }
#line 6207 "parser.cpp" /* yacc.c:1258  */
        break;

    case 171: /* namespace_decl  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).nsn)) ((*yyvaluep).nsn)->deref(); }
#line 6213 "parser.cpp" /* yacc.c:1258  */
        break;

    case 172: /* unscoped_const_decl  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).constnode); }
#line 6219 "parser.cpp" /* yacc.c:1258  */
        break;

    case 173: /* scoped_const_decl  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).constnode); }
#line 6225 "parser.cpp" /* yacc.c:1258  */
        break;

    case 174: /* block  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).sblock); }
#line 6231 "parser.cpp" /* yacc.c:1258  */
        break;

    case 175: /* statement_or_block  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).sblock); }
#line 6237 "parser.cpp" /* yacc.c:1258  */
        break;

    case 176: /* statements  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).sblock); }
#line 6243 "parser.cpp" /* yacc.c:1258  */
        break;

    case 177: /* optname  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6249 "parser.cpp" /* yacc.c:1258  */
        break;

    case 178: /* statement  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).statement); }
#line 6255 "parser.cpp" /* yacc.c:1258  */
        break;

    case 179: /* context_mods  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).cmods); }
#line 6261 "parser.cpp" /* yacc.c:1258  */
        break;

    case 180: /* context_mod  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).cmod); }
#line 6267 "parser.cpp" /* yacc.c:1258  */
        break;

    case 181: /* return_statement  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).statement); }
#line 6273 "parser.cpp" /* yacc.c:1258  */
        break;

    case 182: /* switch_statement  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).statement); }
#line 6279 "parser.cpp" /* yacc.c:1258  */
        break;

    case 183: /* case_block  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).switchstmt); }
#line 6285 "parser.cpp" /* yacc.c:1258  */
        break;

    case 184: /* case_code  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).casenode); }
#line 6291 "parser.cpp" /* yacc.c:1258  */
        break;

    case 185: /* try_statement  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).statement); }
#line 6297 "parser.cpp" /* yacc.c:1258  */
        break;

    case 186: /* myexp  */
#line 1820 "parser.ypp" /* yacc.c:1258  */
      { ((*yyvaluep).qv).discard(nullptr); }
#line 6303 "parser.cpp" /* yacc.c:1258  */
        break;

    case 187: /* hashdecl_def  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).hashdecldef); }
#line 6309 "parser.cpp" /* yacc.c:1258  */
        break;

    case 188: /* class_def  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).classdef); }
#line 6315 "parser.cpp" /* yacc.c:1258  */
        break;

    case 189: /* inheritance_list  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).sclist); }
#line 6321 "parser.cpp" /* yacc.c:1258  */
        break;

    case 190: /* superclass_list  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).sclist); }
#line 6327 "parser.cpp" /* yacc.c:1258  */
        break;

    case 191: /* superclass  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).sclnode); }
#line 6333 "parser.cpp" /* yacc.c:1258  */
        break;

    case 192: /* hashdecl_attrs  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).hashdeclpriv)) ((*yyvaluep).hashdeclpriv)->deref(); }
#line 6339 "parser.cpp" /* yacc.c:1258  */
        break;

    case 193: /* hashdecl_member  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberinfo); }
#line 6345 "parser.cpp" /* yacc.c:1258  */
        break;

    case 194: /* class_attributes  */
#line 1816 "parser.ypp" /* yacc.c:1258  */
      { qore_class_private::get(*((*yyvaluep).qoreclass))->deref(true, true); }
#line 6351 "parser.cpp" /* yacc.c:1258  */
        break;

    case 195: /* uncqtypedef  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).parsertype); }
#line 6357 "parser.cpp" /* yacc.c:1258  */
        break;

    case 196: /* qtypedef  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).parsertype); }
#line 6363 "parser.cpp" /* yacc.c:1258  */
        break;

    case 197: /* internal_member_list  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberlist); }
#line 6369 "parser.cpp" /* yacc.c:1258  */
        break;

    case 198: /* private_member_list  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberlist); }
#line 6375 "parser.cpp" /* yacc.c:1258  */
        break;

    case 199: /* public_member_list  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberlist); }
#line 6381 "parser.cpp" /* yacc.c:1258  */
        break;

    case 200: /* classvardecl  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).classvarinfo); }
#line 6387 "parser.cpp" /* yacc.c:1258  */
        break;

    case 201: /* member2  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberinfo); }
#line 6393 "parser.cpp" /* yacc.c:1258  */
        break;

    case 202: /* transient_member2  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberinfo); }
#line 6399 "parser.cpp" /* yacc.c:1258  */
        break;

    case 203: /* member  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberinfo); }
#line 6405 "parser.cpp" /* yacc.c:1258  */
        break;

    case 204: /* transient_member  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberinfo); }
#line 6411 "parser.cpp" /* yacc.c:1258  */
        break;

    case 205: /* member_list  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberlist); }
#line 6417 "parser.cpp" /* yacc.c:1258  */
        break;

    case 206: /* member_list2  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).memberlist); }
#line 6423 "parser.cpp" /* yacc.c:1258  */
        break;

    case 207: /* ident_openparen  */
#line 1817 "parser.ypp" /* yacc.c:1258  */
      { free(((*yyvaluep).string)); }
#line 6429 "parser.cpp" /* yacc.c:1258  */
        break;

    case 208: /* inline_methoddef  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).methodnode); }
#line 6435 "parser.cpp" /* yacc.c:1258  */
        break;

    case 209: /* outofline_methoddef  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).methoddef); }
#line 6441 "parser.cpp" /* yacc.c:1258  */
        break;

    case 210: /* base_constructor_list  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).bcalist); }
#line 6447 "parser.cpp" /* yacc.c:1258  */
        break;

    case 211: /* base_constructors  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).bcalist); }
#line 6453 "parser.cpp" /* yacc.c:1258  */
        break;

    case 212: /* base_constructor  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).bcanode); }
#line 6459 "parser.cpp" /* yacc.c:1258  */
        break;

    case 216: /* return_value  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).returnTypeInfo); }
#line 6465 "parser.cpp" /* yacc.c:1258  */
        break;

    case 217: /* sub_def  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).parsefunc); }
#line 6471 "parser.cpp" /* yacc.c:1258  */
        break;

    case 218: /* scoped_sub_def  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).sparsefunc); }
#line 6477 "parser.cpp" /* yacc.c:1258  */
        break;

    case 219: /* list  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).parse_list)) ((*yyvaluep).parse_list)->deref(); }
#line 6483 "parser.cpp" /* yacc.c:1258  */
        break;

    case 220: /* list_n  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).parse_list)) ((*yyvaluep).parse_list)->deref(); }
#line 6489 "parser.cpp" /* yacc.c:1258  */
        break;

    case 221: /* hash  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).hash); }
#line 6495 "parser.cpp" /* yacc.c:1258  */
        break;

    case 222: /* hash_element  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).hashelement); }
#line 6501 "parser.cpp" /* yacc.c:1258  */
        break;

    case 223: /* alt_hash  */
#line 1815 "parser.ypp" /* yacc.c:1258  */
      { delete ((*yyvaluep).hash); }
#line 6507 "parser.cpp" /* yacc.c:1258  */
        break;

    case 224: /* immediate_typed_hash  */
#line 1819 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(nullptr); }
#line 6513 "parser.cpp" /* yacc.c:1258  */
        break;

    case 225: /* exp_c  */
#line 1820 "parser.ypp" /* yacc.c:1258  */
      { ((*yyvaluep).qv).discard(nullptr); }
#line 6519 "parser.cpp" /* yacc.c:1258  */
        break;

    case 226: /* exp  */
#line 1820 "parser.ypp" /* yacc.c:1258  */
      { ((*yyvaluep).qv).discard(nullptr); }
#line 6525 "parser.cpp" /* yacc.c:1258  */
        break;

    case 227: /* exp_n  */
#line 1820 "parser.ypp" /* yacc.c:1258  */
      { ((*yyvaluep).qv).discard(nullptr); }
#line 6531 "parser.cpp" /* yacc.c:1258  */
        break;

    case 228: /* string  */
#line 1818 "parser.ypp" /* yacc.c:1258  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6537 "parser.cpp" /* yacc.c:1258  */
        break;

    case 229: /* scalar  */
#line 1820 "parser.ypp" /* yacc.c:1258  */
      { ((*yyvaluep).qv).discard(nullptr); }
#line 6543 "parser.cpp" /* yacc.c:1258  */
        break;


      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (yyscan_t yyscanner)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yyls1, yysize * sizeof (*yylsp),
                    &yystacksize);

        yyls = yyls1;
        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 1828 "parser.ypp" /* yacc.c:1648  */
    {
           (yyvsp[0].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 6840 "parser.cpp" /* yacc.c:1648  */
    break;

  case 5:
#line 1831 "parser.ypp" /* yacc.c:1648  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].sparsefunc)->loc, "function", (yyvsp[0].sparsefunc)->name.ostr);
           (yyvsp[0].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 6850 "parser.cpp" /* yacc.c:1648  */
    break;

  case 6:
#line 1836 "parser.ypp" /* yacc.c:1648  */
    {
           qore_root_ns_private::parseAddClass((yyvsp[0].classdef)->loc, *((yyvsp[0].classdef)->name), (yyvsp[0].classdef)->oc);

           // see if class definitions are allowed
           if (parse_check_parse_option(PO_NO_CLASS_DEFS))
              parse_error(*(yyvsp[0].classdef)->loc, "illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
           delete (yyvsp[0].classdef);
        }
#line 6863 "parser.cpp" /* yacc.c:1648  */
    break;

  case 7:
#line 1844 "parser.ypp" /* yacc.c:1648  */
    {
           qore_root_ns_private::parseAddHashDecl((yyvsp[0].hashdecldef)->loc, *((yyvsp[0].hashdecldef)->name), (yyvsp[0].hashdecldef)->takeHashDecl());
           delete (yyvsp[0].hashdecldef);
        }
#line 6872 "parser.cpp" /* yacc.c:1648  */
    break;

  case 8:
#line 1848 "parser.ypp" /* yacc.c:1648  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].constnode)->loc, "constant", (yyvsp[0].constnode)->name.ostr);
           qore_root_ns_private::parseAddConstant((yyvsp[0].constnode)->loc, *getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
           delete (yyvsp[0].constnode);
        }
#line 6883 "parser.cpp" /* yacc.c:1648  */
    break;

  case 9:
#line 1854 "parser.ypp" /* yacc.c:1648  */
    {
           qore_root_ns_private::parseAddConstant((yyvsp[0].constnode)->loc, *getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
           delete (yyvsp[0].constnode);
        }
#line 6892 "parser.cpp" /* yacc.c:1648  */
    break;

  case 10:
#line 1858 "parser.ypp" /* yacc.c:1648  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].methoddef)->loc, "method", (yyvsp[0].methoddef)->name.ostr);
           (yyvsp[0].methoddef)->parseAddToClassAndDel();
        }
#line 6902 "parser.cpp" /* yacc.c:1648  */
    break;

  case 11:
#line 1863 "parser.ypp" /* yacc.c:1648  */
    {
           if ((yyvsp[0].statement)) {
              if ((yyvsp[0].statement)->isParseDeclaration())
                 delete (yyvsp[0].statement);
              else
                 qore_program_private::addStatement(*(getProgram()), (yyvsp[0].statement));
           }
        }
#line 6915 "parser.cpp" /* yacc.c:1648  */
    break;

  case 13:
#line 1872 "parser.ypp" /* yacc.c:1648  */
    {
            (yyvsp[-1].sblock)->finalizeBlock((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            qore_program_private::addStatement(*(getProgram()), (yyvsp[-1].sblock));
        }
#line 6924 "parser.cpp" /* yacc.c:1648  */
    break;

  case 14:
#line 1876 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_root_ns_private::parseAddNamespace((yyvsp[0].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
        }
#line 6936 "parser.cpp" /* yacc.c:1648  */
    break;

  case 15:
#line 1883 "parser.ypp" /* yacc.c:1648  */
    {
            QoreModuleDefContext* qmd = get_module_def_context();
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");
            else {
                QoreUserModuleDefContextHelper* uqmd = static_cast<QoreUserModuleDefContextHelper*>(qmd);
                uqmd->close();
            }
            // registered internally
        }
#line 6951 "parser.cpp" /* yacc.c:1648  */
    break;

  case 16:
#line 1893 "parser.ypp" /* yacc.c:1648  */
    {
            bool has_dollar = (yyvsp[0].trymod)->var[0] == '$';
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            if (!has_dollar) {
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS)) {
                    parse_error(*loc, "%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].trymod)->var);
                }
            }
            else {
                (yyvsp[0].trymod)->fixName();
                if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[0].trymod)->var);
            }

            if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
                parse_error(*loc, "'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
            }
            else {
                VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode(loc, (yyvsp[0].trymod)->takeName());
                QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(loc, left, (yyvsp[0].trymod)->takeExceptionHash());
                qore_program_private::addStatement(*(getProgram()), new ExpressionStatement(loc, exp));
            }
            delete (yyvsp[0].trymod);
        }
#line 6980 "parser.cpp" /* yacc.c:1648  */
    break;

  case 17:
#line 1920 "parser.ypp" /* yacc.c:1648  */
    {
        }
#line 6987 "parser.cpp" /* yacc.c:1648  */
    break;

  case 18:
#line 1922 "parser.ypp" /* yacc.c:1648  */
    {
        }
#line 6994 "parser.cpp" /* yacc.c:1648  */
    break;

  case 19:
#line 1927 "parser.ypp" /* yacc.c:1648  */
    {
            QoreModuleDefContext* qmd = get_module_def_context();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line);
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[-3].string), (yyvsp[-1].qv).getTypeName());
            else
                qmd->set(loc, (yyvsp[-3].string), (yyvsp[-1].qv));

            free((yyvsp[-3].string));
            (yyvsp[-1].qv).discard(nullptr);
        }
#line 7010 "parser.cpp" /* yacc.c:1648  */
    break;

  case 20:
#line 1941 "parser.ypp" /* yacc.c:1648  */
    { (yyval.b) = false; }
#line 7016 "parser.cpp" /* yacc.c:1648  */
    break;

  case 21:
#line 1942 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.b) = true;
        }
#line 7024 "parser.cpp" /* yacc.c:1648  */
    break;

  case 22:
#line 1948 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true);
            delete (yyvsp[-1].parsertype);
        }
#line 7037 "parser.cpp" /* yacc.c:1648  */
    break;

  case 23:
#line 1956 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 7048 "parser.cpp" /* yacc.c:1648  */
    break;

  case 24:
#line 1962 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true);
            delete (yyvsp[-1].parsertype);
        }
#line 7059 "parser.cpp" /* yacc.c:1648  */
    break;

  case 25:
#line 1968 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 7068 "parser.cpp" /* yacc.c:1648  */
    break;

  case 26:
#line 1972 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false);
            delete (yyvsp[-1].parsertype);
        }
#line 7081 "parser.cpp" /* yacc.c:1648  */
    break;

  case 27:
#line 1980 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false);
            delete (yyvsp[-1].parsertype);
        }
#line 7092 "parser.cpp" /* yacc.c:1648  */
    break;

  case 28:
#line 1986 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].b) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.gv) = new GVarListDecl(loc, (yyvsp[-1].parse_list), (yyvsp[-4].b));
        }
#line 7101 "parser.cpp" /* yacc.c:1648  */
    break;

  case 29:
#line 1993 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[-4].i4), *p);
            (yyvsp[-1].nsnlist)->add(*p);
            delete (yyvsp[-1].nsnlist);
            (yyval.ns) = p->ns;
        }
#line 7114 "parser.cpp" /* yacc.c:1648  */
    break;

  case 30:
#line 2001 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].i4) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[-1]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[-2].i4), *p);
            (yyval.ns) = p->ns;
        }
#line 7125 "parser.cpp" /* yacc.c:1648  */
    break;

  case 31:
#line 2007 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[-3].i4), *p);
            (yyval.ns) = p->ns;
        }
#line 7136 "parser.cpp" /* yacc.c:1648  */
    break;

  case 32:
#line 2016 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 7146 "parser.cpp" /* yacc.c:1648  */
    break;

  case 33:
#line 2021 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.nsnlist) = (yyvsp[-1].nsnlist);
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 7156 "parser.cpp" /* yacc.c:1648  */
    break;

  case 34:
#line 2029 "parser.ypp" /* yacc.c:1648  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].constnode)->loc, "constant", (yyvsp[0].constnode)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 7166 "parser.cpp" /* yacc.c:1648  */
    break;

  case 35:
#line 2034 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 7174 "parser.cpp" /* yacc.c:1648  */
    break;

  case 36:
#line 2037 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.nsn) = new NSNode((yyvsp[0].classdef));
            // see if class definitions are allowed
            if (parse_check_parse_option(PO_NO_CLASS_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "illegal class definition \"%s\" (conflicts with parse option PO_NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
            }
        }
#line 7187 "parser.cpp" /* yacc.c:1648  */
    break;

  case 37:
#line 2045 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].hashdecldef));
        }
#line 7195 "parser.cpp" /* yacc.c:1648  */
    break;

  case 38:
#line 2048 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].parsefunc));
        }
#line 7203 "parser.cpp" /* yacc.c:1648  */
    break;

  case 39:
#line 2051 "parser.ypp" /* yacc.c:1648  */
    {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].sparsefunc)->loc, "function", (yyvsp[0].sparsefunc)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[0].sparsefunc));
        }
#line 7213 "parser.cpp" /* yacc.c:1648  */
    break;

  case 40:
#line 2056 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.nsn) = new NSNode((yyvsp[-1].gv));
        }
#line 7221 "parser.cpp" /* yacc.c:1648  */
    break;

  case 41:
#line 2059 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.nsn) = new NSNode((yyvsp[0].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
            }
        }
#line 7234 "parser.cpp" /* yacc.c:1648  */
    break;

  case 42:
#line 2067 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].methoddef));
        }
#line 7242 "parser.cpp" /* yacc.c:1648  */
    break;

  case 43:
#line 2073 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv));
        }
#line 7250 "parser.cpp" /* yacc.c:1648  */
    break;

  case 44:
#line 2076 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv), true);
        }
#line 7258 "parser.cpp" /* yacc.c:1648  */
    break;

  case 45:
#line 2082 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv));
        }
#line 7266 "parser.cpp" /* yacc.c:1648  */
    break;

  case 46:
#line 2085 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv), true);
        }
#line 7274 "parser.cpp" /* yacc.c:1648  */
    break;

  case 47:
#line 2092 "parser.ypp" /* yacc.c:1648  */
    { (yyval.sblock) = (yyvsp[-1].sblock); }
#line 7280 "parser.cpp" /* yacc.c:1648  */
    break;

  case 48:
#line 2095 "parser.ypp" /* yacc.c:1648  */
    { (yyval.sblock) = new StatementBlock((yylsp[-1]).first_line, (yylsp[-1]).last_line); }
#line 7286 "parser.cpp" /* yacc.c:1648  */
    break;

  case 49:
#line 2100 "parser.ypp" /* yacc.c:1648  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 7292 "parser.cpp" /* yacc.c:1648  */
    break;

  case 50:
#line 2103 "parser.ypp" /* yacc.c:1648  */
    { (yyval.sblock) = (yyvsp[0].sblock); }
#line 7298 "parser.cpp" /* yacc.c:1648  */
    break;

  case 51:
#line 2108 "parser.ypp" /* yacc.c:1648  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 7304 "parser.cpp" /* yacc.c:1648  */
    break;

  case 52:
#line 2110 "parser.ypp" /* yacc.c:1648  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock)); }
#line 7310 "parser.cpp" /* yacc.c:1648  */
    break;

  case 53:
#line 2112 "parser.ypp" /* yacc.c:1648  */
    { (yyvsp[-1].sblock)->addStatement((yyvsp[0].sblock)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 7316 "parser.cpp" /* yacc.c:1648  */
    break;

  case 54:
#line 2114 "parser.ypp" /* yacc.c:1648  */
    { (yyvsp[-1].sblock)->addStatement((yyvsp[0].statement)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 7322 "parser.cpp" /* yacc.c:1648  */
    break;

  case 55:
#line 2119 "parser.ypp" /* yacc.c:1648  */
    { (yyval.string) = 0; }
#line 7328 "parser.cpp" /* yacc.c:1648  */
    break;

  case 56:
#line 2120 "parser.ypp" /* yacc.c:1648  */
    { (yyval.string) = (yyvsp[0].string); }
#line 7334 "parser.cpp" /* yacc.c:1648  */
    break;

  case 57:
#line 2124 "parser.ypp" /* yacc.c:1648  */
    { (yyval.statement) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 7340 "parser.cpp" /* yacc.c:1648  */
    break;

  case 58:
#line 2125 "parser.ypp" /* yacc.c:1648  */
    {
            // if the expression has no effect and it's not a variable declaration
            qore_type_t t = (yyvsp[-1].qv).getType();
            bool ok = false;
            if (t == NT_PARSE_LIST) {
                QoreParseListNode* l = (yyvsp[-1].qv).get<QoreParseListNode>();
                // rewrite expression if it's a list without parentheses under certain conditions
                (yyvsp[-1].qv).set(check_rewrite_list(l));

                if (l->isVariableList())
                    ok = true;
            }

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);

            if (!ok) {
                if (!value_has_effect_as_root((yyvsp[-1].qv)) && (t != NT_VARREF || !(yyvsp[-1].qv).get<VarRefNode>()->parseIsDecl())) {
                    if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                        parse_error(*loc, "expression has no effect as top-level statement (%s)", (yyvsp[-1].qv).getTypeName());
                    }
                } else if (!(yyvsp[-1].qv).hasEffect() && (t != NT_VARREF || !(yyvsp[-1].qv).get<VarRefNode>()->parseIsDecl())) {
                    parse_error(*loc, "statement has no effect (%s)", (yyvsp[-1].qv).getTypeName());
                }
            }

            ignore_return_value((yyvsp[-1].qv));
            (yyval.statement) = new ExpressionStatement(loc, (yyvsp[-1].qv));
        }
#line 7373 "parser.cpp" /* yacc.c:1648  */
    break;

  case 59:
#line 2154 "parser.ypp" /* yacc.c:1648  */
    {
            NamedScope *ns = new NamedScope((yyvsp[-4].string));
            assert(ns->size() > 1);
            printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.statement) = new ExpressionStatement(loc, new StaticMethodCallNode(loc, ns, make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].qv))));
        }
#line 7385 "parser.cpp" /* yacc.c:1648  */
    break;

  case 60:
#line 2162 "parser.ypp" /* yacc.c:1648  */
    { (yyval.statement) = (yyvsp[0].statement); }
#line 7391 "parser.cpp" /* yacc.c:1648  */
    break;

  case 61:
#line 2163 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new RethrowStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7399 "parser.cpp" /* yacc.c:1648  */
    break;

  case 62:
#line 2166 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new ThrowStatement((yylsp[-2]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].qv));
        }
#line 7407 "parser.cpp" /* yacc.c:1648  */
    break;

  case 63:
#line 2169 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Unconditional);
        }
#line 7415 "parser.cpp" /* yacc.c:1648  */
    break;

  case 64:
#line 2172 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Success);
        }
#line 7423 "parser.cpp" /* yacc.c:1648  */
    break;

  case 65:
#line 2175 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Error);
        }
#line 7431 "parser.cpp" /* yacc.c:1648  */
    break;

  case 66:
#line 2178 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new ContextStatement((yylsp[-2]).first_line, (yylsp[0]).last_line, 0, 0, (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 7439 "parser.cpp" /* yacc.c:1648  */
    break;

  case 67:
#line 2181 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new SummarizeStatement((yylsp[-10]).first_line, (yylsp[0]).last_line, (yyvsp[-9].string), (yyvsp[-7].qv), (yyvsp[-1].cmods), (yyvsp[0].sblock), (yyvsp[-3].qv));
        }
#line 7447 "parser.cpp" /* yacc.c:1648  */
    break;

  case 68:
#line 2184 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new ContextStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].string), (yyvsp[-3].qv), (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 7455 "parser.cpp" /* yacc.c:1648  */
    break;

  case 69:
#line 2187 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new IfStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7463 "parser.cpp" /* yacc.c:1648  */
    break;

  case 70:
#line 2190 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new IfStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-4].qv), (yyvsp[-2].sblock), (yyvsp[0].sblock));
        }
#line 7471 "parser.cpp" /* yacc.c:1648  */
    break;

  case 71:
#line 2193 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new WhileStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7479 "parser.cpp" /* yacc.c:1648  */
    break;

  case 72:
#line 2196 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new DoWhileStatement((yylsp[-6]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), (yyvsp[-5].sblock));
        }
#line 7487 "parser.cpp" /* yacc.c:1648  */
    break;

  case 73:
#line 2199 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new ForStatement((yylsp[-8]).first_line, (yylsp[0]).last_line, (yyvsp[-6].qv), (yyvsp[-4].qv), (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7495 "parser.cpp" /* yacc.c:1648  */
    break;

  case 74:
#line 2202 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.statement) = new ForEachStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].qv), (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7503 "parser.cpp" /* yacc.c:1648  */
    break;

  case 75:
#line 2205 "parser.ypp" /* yacc.c:1648  */
    { (yyval.statement) = (yyvsp[-1].statement); }
#line 7509 "parser.cpp" /* yacc.c:1648  */
    break;

  case 76:
#line 2206 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            // see if thread exit is allowed
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL)) {
                parse_error(*loc, "illegal use of \"thread_exit\" (conflicts with parse option PO_NO_THREAD_CONTROL)");
            }
            (yyval.statement) = new ThreadExitStatement(loc);
        }
#line 7522 "parser.cpp" /* yacc.c:1648  */
    break;

  case 77:
#line 2214 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.statement) = new BreakStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7530 "parser.cpp" /* yacc.c:1648  */
    break;

  case 78:
#line 2217 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.statement) = new ContinueStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 7538 "parser.cpp" /* yacc.c:1648  */
    break;

  case 79:
#line 2220 "parser.ypp" /* yacc.c:1648  */
    { (yyval.statement) = (yyvsp[0].statement); }
#line 7544 "parser.cpp" /* yacc.c:1648  */
    break;

  case 80:
#line 2221 "parser.ypp" /* yacc.c:1648  */
    { (yyval.statement) = 0; }
#line 7550 "parser.cpp" /* yacc.c:1648  */
    break;

  case 81:
#line 2226 "parser.ypp" /* yacc.c:1648  */
    { (yyval.cmods) = 0; }
#line 7556 "parser.cpp" /* yacc.c:1648  */
    break;

  case 82:
#line 2227 "parser.ypp" /* yacc.c:1648  */
    {
           if (!(yyvsp[-1].cmods))
              (yyval.cmods) = new ContextModList((yyvsp[0].cmod));
           else {
              (yyvsp[-1].cmods)->addContextMod((yyvsp[0].cmod));
              (yyval.cmods) = (yyvsp[-1].cmods);
           }
        }
#line 7569 "parser.cpp" /* yacc.c:1648  */
    break;

  case 83:
#line 2239 "parser.ypp" /* yacc.c:1648  */
    { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[-1].qv)); }
#line 7575 "parser.cpp" /* yacc.c:1648  */
    break;

  case 84:
#line 2241 "parser.ypp" /* yacc.c:1648  */
    { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[-1].qv)); }
#line 7581 "parser.cpp" /* yacc.c:1648  */
    break;

  case 85:
#line 2243 "parser.ypp" /* yacc.c:1648  */
    { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[-1].qv)); }
#line 7587 "parser.cpp" /* yacc.c:1648  */
    break;

  case 86:
#line 2247 "parser.ypp" /* yacc.c:1648  */
    { (yyval.statement) = new ReturnStatement((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 7593 "parser.cpp" /* yacc.c:1648  */
    break;

  case 87:
#line 2249 "parser.ypp" /* yacc.c:1648  */
    { (yyval.statement) = new ReturnStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].qv)); }
#line 7599 "parser.cpp" /* yacc.c:1648  */
    break;

  case 88:
#line 2254 "parser.ypp" /* yacc.c:1648  */
    {
           (yyvsp[-1].switchstmt)->setSwitch((yyvsp[-4].qv));
           (yyval.statement) = (yyvsp[-1].switchstmt);
           (yyval.statement)->finalizeBlock((yylsp[-6]).first_line, (yylsp[0]).last_line);
        }
#line 7609 "parser.cpp" /* yacc.c:1648  */
    break;

  case 89:
#line 2263 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.switchstmt) = new SwitchStatement((yyvsp[0].casenode));
        }
#line 7617 "parser.cpp" /* yacc.c:1648  */
    break;

  case 90:
#line 2267 "parser.ypp" /* yacc.c:1648  */
    {
           (yyvsp[-1].switchstmt)->addCase((yyvsp[0].casenode));
           (yyval.switchstmt) = (yyvsp[-1].switchstmt);
        }
#line 7626 "parser.cpp" /* yacc.c:1648  */
    break;

  case 91:
#line 2275 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">=", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
#line 7636 "parser.cpp" /* yacc.c:1648  */
    break;

  case 92:
#line 2281 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">=", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
#line 7646 "parser.cpp" /* yacc.c:1648  */
    break;

  case 93:
#line 2287 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<=", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
#line 7656 "parser.cpp" /* yacc.c:1648  */
    break;

  case 94:
#line 2293 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<=", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
#line 7666 "parser.cpp" /* yacc.c:1648  */
    break;

  case 95:
#line 2299 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, "==", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalEqualsOperatorNode::softEqual);
        }
#line 7676 "parser.cpp" /* yacc.c:1648  */
    break;

  case 96:
#line 2305 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, "==", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalEqualsOperatorNode::softEqual);
        }
#line 7686 "parser.cpp" /* yacc.c:1648  */
    break;

  case 97:
#line 2311 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalLessThanOperatorNode::doLessThan);
        }
#line 7696 "parser.cpp" /* yacc.c:1648  */
    break;

  case 98:
#line 2317 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalLessThanOperatorNode::doLessThan);
        }
#line 7706 "parser.cpp" /* yacc.c:1648  */
    break;

  case 99:
#line 2323 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
#line 7716 "parser.cpp" /* yacc.c:1648  */
    break;

  case 100:
#line 2329 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
#line 7726 "parser.cpp" /* yacc.c:1648  */
    break;

  case 101:
#line 2335 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 7735 "parser.cpp" /* yacc.c:1648  */
    break;

  case 102:
#line 2340 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-1].Regex), nullptr);
        }
#line 7744 "parser.cpp" /* yacc.c:1648  */
    break;

  case 103:
#line 2345 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 7753 "parser.cpp" /* yacc.c:1648  */
    break;

  case 104:
#line 2350 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[-1].Regex), nullptr);
        }
#line 7762 "parser.cpp" /* yacc.c:1648  */
    break;

  case 105:
#line 2355 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 7771 "parser.cpp" /* yacc.c:1648  */
    break;

  case 106:
#line 2360 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-1].Regex), nullptr);
        }
#line 7780 "parser.cpp" /* yacc.c:1648  */
    break;

  case 107:
#line 2365 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, 0, (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 7790 "parser.cpp" /* yacc.c:1648  */
    break;

  case 108:
#line 2371 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            check_case(loc, 0, (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[-1].qv), nullptr);
        }
#line 7800 "parser.cpp" /* yacc.c:1648  */
    break;

  case 109:
#line 2377 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), (yyvsp[0].sblock), true);
        }
#line 7809 "parser.cpp" /* yacc.c:1648  */
    break;

  case 110:
#line 2382 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), nullptr, true);
        }
#line 7818 "parser.cpp" /* yacc.c:1648  */
    break;

  case 111:
#line 2389 "parser.ypp" /* yacc.c:1648  */
    {
            char* param = 0;
            const QoreTypeInfo* typeInfo = nullptr;
            QoreParseTypeInfo* parseTypeInfo = nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-2].qv).getType() == NT_VARREF) {
                VarRefNode* varRefNode = (yyvsp[-2].qv).get<VarRefNode>();
                param = varRefNode->takeName();
                if (varRefNode->isDecl()) {
                    VarRefDeclNode* varRefDeclNode = static_cast<VarRefDeclNode*>(varRefNode);
                    parseTypeInfo = varRefDeclNode->takeParseTypeInfo();
                    if (!parseTypeInfo)
                        typeInfo = varRefDeclNode->getTypeInfo();
                }
            } else if ((yyvsp[-2].qv).getType() == NT_BAREWORD) {
                param = (yyvsp[-2].qv).get<BarewordNode>()->takeString();
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "local variable '%s' in catch parameter list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", param);
            } else if ((yyvsp[-2].qv)) {
                parse_error(*loc, "only one parameter accepted in catch block for exception hash");
            }
            (yyvsp[-2].qv).discard(nullptr);
            const QoreProgramLocation* vloc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].qv) ? (yylsp[-2]).first_line : 0, (yyvsp[-2].qv) ? (yylsp[-2]).last_line : 0);
            (yyval.statement) = new TryStatement(loc, (yyvsp[-5].sblock), (yyvsp[0].sblock), param, typeInfo, parseTypeInfo, vloc);
        }
#line 7848 "parser.cpp" /* yacc.c:1648  */
    break;

  case 112:
#line 2416 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(nullptr); }
#line 7854 "parser.cpp" /* yacc.c:1648  */
    break;

  case 113:
#line 2417 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].qv)); }
#line 7860 "parser.cpp" /* yacc.c:1648  */
    break;

  case 114:
#line 2418 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(nullptr); }
#line 7866 "parser.cpp" /* yacc.c:1648  */
    break;

  case 115:
#line 2422 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_hashdeclmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[-3].string), (yyvsp[-1].hashdeclpriv));
        }
#line 7876 "parser.cpp" /* yacc.c:1648  */
    break;

  case 116:
#line 2427 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_hashdeclmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[-3].string), (yyvsp[-1].hashdeclpriv));
        }
#line 7886 "parser.cpp" /* yacc.c:1648  */
    break;

  case 117:
#line 2435 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_classmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
            qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-4].string), (yyvsp[-1].qoreclass));
        }
#line 7897 "parser.cpp" /* yacc.c:1648  */
    break;

  case 118:
#line 2441 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[-4].nscope)->ostr);
            check_classmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-4].nscope), (yyvsp[-1].qoreclass));
            qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
        }
#line 7910 "parser.cpp" /* yacc.c:1648  */
    break;

  case 119:
#line 2449 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[-1]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreClass;
            qore_class_private::get(*qc)->loc = loc;
            check_classmod(loc, (yyvsp[-3].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-2].string), qc);
        }
#line 7924 "parser.cpp" /* yacc.c:1648  */
    break;

  case 120:
#line 2458 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[-1]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[-2].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreClass;
            qore_class_private::get(*qc)->loc = loc;
            check_classmod(loc, (yyvsp[-3].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-2].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
        }
#line 7940 "parser.cpp" /* yacc.c:1648  */
    break;

  case 121:
#line 2469 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreClass;
            qore_class_private::get(*qc)->loc = loc;
            check_classmod(loc, (yyvsp[-4].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-3].string), qc);
        }
#line 7954 "parser.cpp" /* yacc.c:1648  */
    break;

  case 122:
#line 2478 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[-3].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreClass;
            qore_class_private::get(*qc)->loc = loc;
            check_classmod(loc, (yyvsp[-4].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-3].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
        }
#line 7970 "parser.cpp" /* yacc.c:1648  */
    break;

  case 123:
#line 2492 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.sclist) = (yyvsp[0].sclist);
        }
#line 7978 "parser.cpp" /* yacc.c:1648  */
    break;

  case 124:
#line 2495 "parser.ypp" /* yacc.c:1648  */
    { // NOTHING
           (yyval.sclist) = 0;
        }
#line 7986 "parser.cpp" /* yacc.c:1648  */
    break;

  case 125:
#line 2501 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.sclist) = new BCList((yyvsp[0].sclnode));
        }
#line 7994 "parser.cpp" /* yacc.c:1648  */
    break;

  case 126:
#line 2504 "parser.ypp" /* yacc.c:1648  */
    {
           (yyvsp[-2].sclist)->push_back((yyvsp[0].sclnode));
           (yyval.sclist) = (yyvsp[-2].sclist);
        }
#line 8003 "parser.cpp" /* yacc.c:1648  */
    break;

  case 127:
#line 2511 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Public);
        }
#line 8012 "parser.cpp" /* yacc.c:1648  */
    break;

  case 128:
#line 2515 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Public);
        }
#line 8021 "parser.cpp" /* yacc.c:1648  */
    break;

  case 129:
#line 2519 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Public);
        }
#line 8030 "parser.cpp" /* yacc.c:1648  */
    break;

  case 130:
#line 2523 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Public);
        }
#line 8039 "parser.cpp" /* yacc.c:1648  */
    break;

  case 131:
#line 2527 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Private);
        }
#line 8048 "parser.cpp" /* yacc.c:1648  */
    break;

  case 132:
#line 2531 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Private);
        }
#line 8057 "parser.cpp" /* yacc.c:1648  */
    break;

  case 133:
#line 2535 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Private);
        }
#line 8066 "parser.cpp" /* yacc.c:1648  */
    break;

  case 134:
#line 2539 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Private);
        }
#line 8075 "parser.cpp" /* yacc.c:1648  */
    break;

  case 135:
#line 2543 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Internal);
        }
#line 8084 "parser.cpp" /* yacc.c:1648  */
    break;

  case 136:
#line 2547 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Internal);
        }
#line 8093 "parser.cpp" /* yacc.c:1648  */
    break;

  case 137:
#line 2554 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.hashdeclpriv) = new typed_hash_decl_private(loc);
            if ((yyvsp[0].memberinfo)) {
                (yyval.hashdeclpriv)->parseAdd((yyvsp[0].memberinfo)->getHashMemPair());
                delete (yyvsp[0].memberinfo);
            }
        }
#line 8106 "parser.cpp" /* yacc.c:1648  */
    break;

  case 138:
#line 2562 "parser.ypp" /* yacc.c:1648  */
    {
           if ((yyvsp[0].memberinfo)) {
              if ((yyvsp[-1].hashdeclpriv)->hasMember((yyvsp[0].memberinfo)->name)) {
                 parse_error(*(yyvsp[0].memberinfo)->loc, "duplicate hashdecl member declaration '%s'", (yyvsp[0].memberinfo)->name);
              }
              else {
                 // add new member to list
                 (yyvsp[-1].hashdeclpriv)->parseAdd((yyvsp[0].memberinfo)->getHashMemPair());
              }
              delete (yyvsp[0].memberinfo);
           }

           (yyval.hashdeclpriv) = (yyvsp[-1].hashdeclpriv);
        }
#line 8125 "parser.cpp" /* yacc.c:1648  */
    break;

  case 139:
#line 2579 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
        }
#line 8135 "parser.cpp" /* yacc.c:1648  */
    break;

  case 140:
#line 2584 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            delete (yyvsp[-4].parsertype);
        }
#line 8145 "parser.cpp" /* yacc.c:1648  */
    break;

  case 141:
#line 2589 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

            if (!(yyvsp[-5].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* aloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti->subtypes.size()) {
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(aloc, (yyvsp[-2].qv)));
                }
                else {
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(aloc, (yyvsp[-2].qv)));
                }
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new HashDeclMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
        }
#line 8174 "parser.cpp" /* yacc.c:1648  */
    break;

  case 142:
#line 2616 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.qoreclass) = new QoreClass;
           qore_class_private::get(*(yyval.qoreclass))->loc = (yyvsp[0].methodnode)->getLoc();
           (yyvsp[0].methodnode)->addAndDelete((yyval.qoreclass));
        }
#line 8184 "parser.cpp" /* yacc.c:1648  */
    break;

  case 143:
#line 2621 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.qoreclass) = new QoreClass;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::get(*(yyval.qoreclass))->loc = loc;
            (yyvsp[0].memberlist)->merge((yyval.qoreclass), Internal);
            delete (yyvsp[0].memberlist);
        }
#line 8196 "parser.cpp" /* yacc.c:1648  */
    break;

  case 144:
#line 2628 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.qoreclass) = new QoreClass;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::get(*(yyval.qoreclass))->loc = loc;
            (yyvsp[0].memberlist)->merge((yyval.qoreclass), Private);
            delete (yyvsp[0].memberlist);
        }
#line 8208 "parser.cpp" /* yacc.c:1648  */
    break;

  case 145:
#line 2635 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.qoreclass) = new QoreClass;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::get(*(yyval.qoreclass))->loc = loc;
            (yyvsp[0].memberlist)->merge((yyval.qoreclass), Public);
            delete (yyvsp[0].memberlist);
        }
#line 8220 "parser.cpp" /* yacc.c:1648  */
    break;

  case 146:
#line 2642 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.qoreclass) = new QoreClass;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::get(*(yyval.qoreclass))->loc = loc;
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue(), Public);
            delete (yyvsp[0].constnode);
        }
#line 8232 "parser.cpp" /* yacc.c:1648  */
    break;

  case 147:
#line 2649 "parser.ypp" /* yacc.c:1648  */
    {
            (yyvsp[0].methodnode)->addAndDelete((yyvsp[-1].qoreclass));
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
        }
#line 8241 "parser.cpp" /* yacc.c:1648  */
    break;

  case 148:
#line 2653 "parser.ypp" /* yacc.c:1648  */
    {
            (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Internal);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].memberlist);
        }
#line 8251 "parser.cpp" /* yacc.c:1648  */
    break;

  case 149:
#line 2658 "parser.ypp" /* yacc.c:1648  */
    {
            (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Private);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].memberlist);
        }
#line 8261 "parser.cpp" /* yacc.c:1648  */
    break;

  case 150:
#line 2663 "parser.ypp" /* yacc.c:1648  */
    {
            (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Public);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].memberlist);
        }
#line 8271 "parser.cpp" /* yacc.c:1648  */
    break;

  case 151:
#line 2668 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue(), Public);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].constnode);
        }
#line 8282 "parser.cpp" /* yacc.c:1648  */
    break;

  case 152:
#line 2677 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string), false);
        }
#line 8290 "parser.cpp" /* yacc.c:1648  */
    break;

  case 153:
#line 2680 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[0].string), false));
        }
#line 8298 "parser.cpp" /* yacc.c:1648  */
    break;

  case 154:
#line 2683 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[0].string), false);
        }
#line 8307 "parser.cpp" /* yacc.c:1648  */
    break;

  case 155:
#line 2687 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string), true);
        }
#line 8315 "parser.cpp" /* yacc.c:1648  */
    break;

  case 156:
#line 2690 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[0].string), true));
        }
#line 8323 "parser.cpp" /* yacc.c:1648  */
    break;

  case 157:
#line 2693 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[0].string), true);
        }
#line 8332 "parser.cpp" /* yacc.c:1648  */
    break;

  case 158:
#line 2701 "parser.ypp" /* yacc.c:1648  */
    { (yyval.parsertype) = 0; }
#line 8338 "parser.cpp" /* yacc.c:1648  */
    break;

  case 159:
#line 2702 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.parsertype) = (yyvsp[0].parsertype);
        }
#line 8346 "parser.cpp" /* yacc.c:1648  */
    break;

  case 160:
#line 2708 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8352 "parser.cpp" /* yacc.c:1648  */
    break;

  case 161:
#line 2709 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8358 "parser.cpp" /* yacc.c:1648  */
    break;

  case 162:
#line 2710 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = new EmptyMemberList; }
#line 8364 "parser.cpp" /* yacc.c:1648  */
    break;

  case 163:
#line 2714 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8370 "parser.cpp" /* yacc.c:1648  */
    break;

  case 164:
#line 2715 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8376 "parser.cpp" /* yacc.c:1648  */
    break;

  case 165:
#line 2716 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = new EmptyMemberList; }
#line 8382 "parser.cpp" /* yacc.c:1648  */
    break;

  case 166:
#line 2717 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8388 "parser.cpp" /* yacc.c:1648  */
    break;

  case 167:
#line 2718 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8394 "parser.cpp" /* yacc.c:1648  */
    break;

  case 168:
#line 2719 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = new EmptyMemberList; }
#line 8400 "parser.cpp" /* yacc.c:1648  */
    break;

  case 169:
#line 2723 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8406 "parser.cpp" /* yacc.c:1648  */
    break;

  case 170:
#line 2724 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 8412 "parser.cpp" /* yacc.c:1648  */
    break;

  case 171:
#line 2725 "parser.ypp" /* yacc.c:1648  */
    { (yyval.memberlist) = new EmptyMemberList; }
#line 8418 "parser.cpp" /* yacc.c:1648  */
    break;

  case 172:
#line 2729 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
        }
#line 8428 "parser.cpp" /* yacc.c:1648  */
    break;

  case 173:
#line 2734 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo(loc));
        }
#line 8437 "parser.cpp" /* yacc.c:1648  */
    break;

  case 174:
#line 2738 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
            delete (yyvsp[-4].parsertype);
        }
#line 8448 "parser.cpp" /* yacc.c:1648  */
    break;

  case 175:
#line 2744 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo(loc, nullptr, nullptr, (yyvsp[-1].qv)));
        }
#line 8457 "parser.cpp" /* yacc.c:1648  */
    break;

  case 176:
#line 2748 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

            if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[-2].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[-2].qv)));
            }

            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-4].string), new QoreVarInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
        }
#line 8482 "parser.cpp" /* yacc.c:1648  */
    break;

  case 177:
#line 2771 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].parsertype) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
        }
#line 8494 "parser.cpp" /* yacc.c:1648  */
    break;

  case 178:
#line 2778 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].parsertype) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            delete (yyvsp[-4].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-3].string));
        }
#line 8506 "parser.cpp" /* yacc.c:1648  */
    break;

  case 179:
#line 2785 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = (yyvsp[-5].parsertype) ? ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)) : nullptr;

            if (!(yyvsp[-5].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti && pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[-2].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[-2].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-4].string));
        }
#line 8535 "parser.cpp" /* yacc.c:1648  */
    break;

  case 180:
#line 2809 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
        }
#line 8547 "parser.cpp" /* yacc.c:1648  */
    break;

  case 181:
#line 2816 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            delete (yyvsp[-4].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
        }
#line 8559 "parser.cpp" /* yacc.c:1648  */
    break;

  case 182:
#line 2823 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

            if (!(yyvsp[-5].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[-2].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[-2].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-4].string));
        }
#line 8588 "parser.cpp" /* yacc.c:1648  */
    break;

  case 183:
#line 2847 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
        }
#line 8599 "parser.cpp" /* yacc.c:1648  */
    break;

  case 184:
#line 2853 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, nullptr, nullptr, (yyvsp[-1].qv)));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
        }
#line 8610 "parser.cpp" /* yacc.c:1648  */
    break;

  case 185:
#line 2859 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.memberinfo) = (yyvsp[0].classvarinfo);
        }
#line 8618 "parser.cpp" /* yacc.c:1648  */
    break;

  case 186:
#line 2862 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[0].constnode)->pub)
                parse_error(*loc, "cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[0].constnode)->name.ostr);
            (yyval.memberinfo) = new MemberInfo(loc, (yyvsp[0].constnode)->name.takeName(), (yyvsp[0].constnode)->value);
            delete (yyvsp[0].constnode);
        }
#line 8630 "parser.cpp" /* yacc.c:1648  */
    break;

  case 187:
#line 2872 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.memberinfo) = (yyvsp[0].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
#line 8639 "parser.cpp" /* yacc.c:1648  */
    break;

  case 188:
#line 2879 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[0].string), new QoreMemberInfo(loc));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 8650 "parser.cpp" /* yacc.c:1648  */
    break;

  case 189:
#line 2885 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, nullptr, new QoreParseTypeInfo((yyvsp[0].string))));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
        }
#line 8661 "parser.cpp" /* yacc.c:1648  */
    break;

  case 190:
#line 2894 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.memberinfo) = (yyvsp[0].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
#line 8670 "parser.cpp" /* yacc.c:1648  */
    break;

  case 191:
#line 2901 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8678 "parser.cpp" /* yacc.c:1648  */
    break;

  case 192:
#line 2904 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8686 "parser.cpp" /* yacc.c:1648  */
    break;

  case 193:
#line 2907 "parser.ypp" /* yacc.c:1648  */
    {
           (yyvsp[-2].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-2].memberlist);
        }
#line 8695 "parser.cpp" /* yacc.c:1648  */
    break;

  case 194:
#line 2911 "parser.ypp" /* yacc.c:1648  */
    {
           (yyvsp[-2].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-2].memberlist);
        }
#line 8704 "parser.cpp" /* yacc.c:1648  */
    break;

  case 195:
#line 2918 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8712 "parser.cpp" /* yacc.c:1648  */
    break;

  case 196:
#line 2921 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 8720 "parser.cpp" /* yacc.c:1648  */
    break;

  case 197:
#line 2924 "parser.ypp" /* yacc.c:1648  */
    {
           (yyvsp[-1].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-1].memberlist);
        }
#line 8729 "parser.cpp" /* yacc.c:1648  */
    break;

  case 198:
#line 2928 "parser.ypp" /* yacc.c:1648  */
    {
           (yyvsp[-1].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-1].memberlist);
        }
#line 8738 "parser.cpp" /* yacc.c:1648  */
    break;

  case 199:
#line 2935 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.string) = (yyvsp[-1].string);
        }
#line 8746 "parser.cpp" /* yacc.c:1648  */
    break;

  case 200:
#line 2938 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.string) = strdup("keys");
        }
#line 8754 "parser.cpp" /* yacc.c:1648  */
    break;

  case 201:
#line 2941 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.string) = (yyvsp[0].string);
        }
#line 8762 "parser.cpp" /* yacc.c:1648  */
    break;

  case 202:
#line 2947 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            check_method(loc, (yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[-5].string), new_method_variant(loc, (yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8778 "parser.cpp" /* yacc.c:1648  */
    break;

  case 203:
#line 2958 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            check_method(loc, (yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[-4].string), new_method_variant(loc, (yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8798 "parser.cpp" /* yacc.c:1648  */
    break;

  case 204:
#line 2973 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            check_method(loc, (yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[-5].string), new_method_variant(loc, (yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8810 "parser.cpp" /* yacc.c:1648  */
    break;

  case 205:
#line 2980 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            check_method(loc, (yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[-4].string), new_method_variant(loc, (yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 8826 "parser.cpp" /* yacc.c:1648  */
    break;

  case 206:
#line 2994 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
        }
#line 8842 "parser.cpp" /* yacc.c:1648  */
    break;

  case 207:
#line 3005 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
        }
#line 8860 "parser.cpp" /* yacc.c:1648  */
    break;

  case 208:
#line 3018 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0);
        }
#line 8871 "parser.cpp" /* yacc.c:1648  */
    break;

  case 209:
#line 3024 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, 0);
        }
#line 8885 "parser.cpp" /* yacc.c:1648  */
    break;

  case 210:
#line 3033 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
        }
#line 8894 "parser.cpp" /* yacc.c:1648  */
    break;

  case 211:
#line 3037 "parser.ypp" /* yacc.c:1648  */
    {
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
        }
#line 8906 "parser.cpp" /* yacc.c:1648  */
    break;

  case 212:
#line 3047 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.bcalist) = (yyvsp[0].bcalist);
        }
#line 8914 "parser.cpp" /* yacc.c:1648  */
    break;

  case 213:
#line 3050 "parser.ypp" /* yacc.c:1648  */
    { // nothing
           (yyval.bcalist) = 0;
        }
#line 8922 "parser.cpp" /* yacc.c:1648  */
    break;

  case 214:
#line 3056 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.bcalist) = new BCAList((yyvsp[0].bcanode));
        }
#line 8930 "parser.cpp" /* yacc.c:1648  */
    break;

  case 215:
#line 3059 "parser.ypp" /* yacc.c:1648  */
    {
           (yyvsp[-2].bcalist)->push_back((yyvsp[0].bcanode));
           (yyval.bcalist) = (yyvsp[-2].bcalist);
        }
#line 8939 "parser.cpp" /* yacc.c:1648  */
    break;

  case 216:
#line 3066 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.bcanode) = new BCANode((yyvsp[-3].string), make_args(loc, (yyvsp[-1].qv)), loc);
        }
#line 8948 "parser.cpp" /* yacc.c:1648  */
    break;

  case 217:
#line 3070 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[-3].string)), make_args(loc, (yyvsp[-1].qv)), loc);
        }
#line 8957 "parser.cpp" /* yacc.c:1648  */
    break;

  case 218:
#line 3078 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = 0; }
#line 8963 "parser.cpp" /* yacc.c:1648  */
    break;

  case 219:
#line 3079 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.i4) = (yyvsp[0].i4);
        }
#line 8971 "parser.cpp" /* yacc.c:1648  */
    break;

  case 220:
#line 3084 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = (yyvsp[0].i4); }
#line 8977 "parser.cpp" /* yacc.c:1648  */
    break;

  case 221:
#line 3085 "parser.ypp" /* yacc.c:1648  */
    {
            if (((yyvsp[-1].i4) | (yyvsp[0].i4)) == (yyvsp[-1].i4)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "modifier given twice");
            }
            (yyval.i4) = (yyvsp[-1].i4) | (yyvsp[0].i4);
        }
#line 8989 "parser.cpp" /* yacc.c:1648  */
    break;

  case 222:
#line 3095 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = OFM_PRIVATE; }
#line 8995 "parser.cpp" /* yacc.c:1648  */
    break;

  case 223:
#line 3096 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = OFM_PRIVATE; }
#line 9001 "parser.cpp" /* yacc.c:1648  */
    break;

  case 224:
#line 3097 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = OFM_INTERNAL; }
#line 9007 "parser.cpp" /* yacc.c:1648  */
    break;

  case 225:
#line 3098 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = OFM_STATIC; }
#line 9013 "parser.cpp" /* yacc.c:1648  */
    break;

  case 226:
#line 3099 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = OFM_SYNCED; }
#line 9019 "parser.cpp" /* yacc.c:1648  */
    break;

  case 227:
#line 3100 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = OFM_DEPRECATED; }
#line 9025 "parser.cpp" /* yacc.c:1648  */
    break;

  case 228:
#line 3101 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = OFM_PUBLIC; }
#line 9031 "parser.cpp" /* yacc.c:1648  */
    break;

  case 229:
#line 3102 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = OFM_FINAL; }
#line 9037 "parser.cpp" /* yacc.c:1648  */
    break;

  case 230:
#line 3103 "parser.ypp" /* yacc.c:1648  */
    { (yyval.i4) = OFM_ABSTRACT; }
#line 9043 "parser.cpp" /* yacc.c:1648  */
    break;

  case 231:
#line 3107 "parser.ypp" /* yacc.c:1648  */
    {
            if (!(yyvsp[0].parsertype)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "missing type declaration after 'returns'");
                (yyval.returnTypeInfo) = 0;
            }
            else {
                (yyval.returnTypeInfo) = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[0].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[0].parsertype)));
                delete (yyvsp[0].parsertype);
            }
        }
#line 9059 "parser.cpp" /* yacc.c:1648  */
    break;

  case 232:
#line 3119 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.returnTypeInfo) = 0;
        }
#line 9067 "parser.cpp" /* yacc.c:1648  */
    break;

  case 233:
#line 3125 "parser.ypp" /* yacc.c:1648  */
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), false, flags));
        }
#line 9078 "parser.cpp" /* yacc.c:1648  */
    break;

  case 234:
#line 3131 "parser.ypp" /* yacc.c:1648  */
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, false, flags));
        }
#line 9093 "parser.cpp" /* yacc.c:1648  */
    break;

  case 235:
#line 3141 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-6].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
#line 9110 "parser.cpp" /* yacc.c:1648  */
    break;

  case 236:
#line 3153 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, (yyvsp[-6].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-6].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
#line 9130 "parser.cpp" /* yacc.c:1648  */
    break;

  case 237:
#line 3171 "parser.ypp" /* yacc.c:1648  */
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), false, flags));
        }
#line 9141 "parser.cpp" /* yacc.c:1648  */
    break;

  case 238:
#line 3177 "parser.ypp" /* yacc.c:1648  */
    {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, false, flags));
        }
#line 9156 "parser.cpp" /* yacc.c:1648  */
    break;

  case 239:
#line 3187 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-7].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-7].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), (yyvsp[-7].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-7].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
#line 9173 "parser.cpp" /* yacc.c:1648  */
    break;

  case 240:
#line 3199 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-7].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-7].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, (yyvsp[-7].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-7].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
#line 9193 "parser.cpp" /* yacc.c:1648  */
    break;

  case 241:
#line 3217 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[-2].qv), (yyvsp[0].qv), loc1, loc3);
        }
#line 9203 "parser.cpp" /* yacc.c:1648  */
    break;

  case 242:
#line 3222 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            QoreParseListNode* l;
            if ((yyvsp[-1].qv).getType() == NT_PARSE_LIST) {
                l = (yyvsp[-1].qv).get<QoreParseListNode>();
                if (l->isFinalized()) {
                    QoreParseListNode* nl = new QoreParseListNode(loc);
                    nl->add(l, loc);
                    l = nl;
                }
            }
            else {
                l = new QoreParseListNode(loc);
                l->add((yyvsp[-1].qv), loc);
            }
            (yyval.parse_list) = l;
        }
#line 9225 "parser.cpp" /* yacc.c:1648  */
    break;

  case 243:
#line 3242 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[-2].qv), (yyvsp[0].qv), loc1, loc3);
        }
#line 9235 "parser.cpp" /* yacc.c:1648  */
    break;

  case 244:
#line 3247 "parser.ypp" /* yacc.c:1648  */
    {
            QoreParseListNode* l;
            if ((yyvsp[-1].qv).getType() == NT_PARSE_LIST)
                l = (yyvsp[-1].qv).get<QoreParseListNode>();
            else {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
                l = new QoreParseListNode(loc);
                l->add((yyvsp[-1].qv), loc);
            }
            (yyval.parse_list) = l;
        }
#line 9251 "parser.cpp" /* yacc.c:1648  */
    break;

  case 245:
#line 3261 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.hash) = new QoreParseHashNode(loc);
            (yyvsp[0].hashelement)->addDelete((yyval.hash));
        }
#line 9261 "parser.cpp" /* yacc.c:1648  */
    break;

  case 246:
#line 3266 "parser.ypp" /* yacc.c:1648  */
    {
            (yyvsp[0].hashelement)->addDelete((yyvsp[-2].hash));
            (yyval.hash) = (yyvsp[-2].hash);
        }
#line 9270 "parser.cpp" /* yacc.c:1648  */
    break;

  case 247:
#line 3271 "parser.ypp" /* yacc.c:1648  */
    { /* empty ',' on end of hash */ (yyval.hash) = (yyvsp[-1].hash); }
#line 9276 "parser.cpp" /* yacc.c:1648  */
    break;

  case 248:
#line 3276 "parser.ypp" /* yacc.c:1648  */
    { (yyval.hashelement) = new HashElement((yyvsp[-2].qv), (yyvsp[0].qv), (yylsp[-2]).first_line, (yylsp[0]).last_line); }
#line 9282 "parser.cpp" /* yacc.c:1648  */
    break;

  case 249:
#line 3280 "parser.ypp" /* yacc.c:1648  */
    {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[-1].hash)->setCurly();
            (yyvsp[-1].hash)->finalizeBlock((yylsp[-2]).first_line, (yylsp[0]).last_line);

            (yyval.hash) = (yyvsp[-1].hash);
        }
#line 9294 "parser.cpp" /* yacc.c:1648  */
    break;

  case 250:
#line 3290 "parser.ypp" /* yacc.c:1648  */
    {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[-1].hash)->setCurly();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[-2].string));
            free((yyvsp[-2].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), (yyvsp[-1].hash));
        }
#line 9308 "parser.cpp" /* yacc.c:1648  */
    break;

  case 251:
#line 3299 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[-1].string));
            free((yyvsp[-1].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), new QoreParseHashNode(loc, true));
        }
#line 9319 "parser.cpp" /* yacc.c:1648  */
    break;

  case 252:
#line 3309 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].qv)); }
#line 9325 "parser.cpp" /* yacc.c:1648  */
    break;

  case 253:
#line 3311 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].binary)); }
#line 9331 "parser.cpp" /* yacc.c:1648  */
    break;

  case 254:
#line 3313 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[-1].hash)); }
#line 9337 "parser.cpp" /* yacc.c:1648  */
    break;

  case 255:
#line 3315 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ScopedRefNode(loc, (yyvsp[0].string)));
        }
#line 9346 "parser.cpp" /* yacc.c:1648  */
    break;

  case 256:
#line 3319 "parser.ypp" /* yacc.c:1648  */
    {
            if (!(yyvsp[-1].parsertype) && !strcmp((yyvsp[0].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-1].parsertype) ? (yylsp[-1]).first_line : (yylsp[0]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-1].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[0].string), get_var_type()));

            delete (yyvsp[-1].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9365 "parser.cpp" /* yacc.c:1648  */
    break;

  case 257:
#line 3333 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-1].parsertype) ? (yylsp[-1]).first_line : (yylsp[0]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-1].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[0].string), get_var_type()));

            delete (yyvsp[-1].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9381 "parser.cpp" /* yacc.c:1648  */
    break;

  case 258:
#line 3344 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype))));
            delete (yyvsp[-1].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 9393 "parser.cpp" /* yacc.c:1648  */
    break;

  case 259:
#line 3351 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            VarRefDeclNode* v = new VarRefDeclNode(loc, (yyvsp[0].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
            v->setExplicitScope();
            (yyval.qv).set(v);
            delete (yyvsp[-1].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 9407 "parser.cpp" /* yacc.c:1648  */
    break;

  case 260:
#line 3360 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            // see if types are required
            if (parse_check_parse_option(PO_REQUIRE_TYPES))
                parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
            VarRefNode* v = new VarRefNode(loc, (yyvsp[0].string), VT_LOCAL);
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 9423 "parser.cpp" /* yacc.c:1648  */
    break;

  case 261:
#line 3371 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            VarRefNode* v;
            if ((yyvsp[-1].parsertype)) {
                v = new VarRefDeclNode(loc, (yyvsp[0].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
                delete (yyvsp[-1].parsertype);
            }
            else {
                // see if types are required
                if (parse_check_parse_option(PO_REQUIRE_TYPES))
                    parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
                v = new VarRefNode(loc, (yyvsp[0].string), VT_LOCAL);
            }
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9446 "parser.cpp" /* yacc.c:1648  */
    break;

  case 262:
#line 3389 "parser.ypp" /* yacc.c:1648  */
    {
            (yyvsp[-1].parse_list)->setVariableList();
            QoreParseListNode::nvec_t& vl = (yyvsp[-1].parse_list)->getValues();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            for (unsigned i = 0; i < vl.size(); ++i) {
                QoreValue& n = vl[i];
                qore_type_t t = n.getType();
                if (t == NT_BAREWORD) {
                    BarewordNode* b = n.get<BarewordNode>();
                    if (parse_check_parse_option(PO_REQUIRE_TYPES))
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
                    if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                        parse_error(*loc, "local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
                    VarRefNode* v = new VarRefNode(loc, b->takeString(), VT_LOCAL);
                    v->setExplicitScope();
                    b->deref();
                    n = v;
                }
                else if (t == NT_VARREF) {
                    VarRefNode* v = n.get<VarRefNode>();
                    // see if types are required
                    if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
                    if (v->explicitScope()) {
                        if (v->getType() == VT_LOCAL)
                            parse_error(*loc, "illegal use of 'my %s' in local variable declaration list", v->getName());
                        else if (v->getType() == VT_GLOBAL)
                            parse_error(*loc, "illegal use of 'our %s' in local variable declaration list", v->getName());
                    }
                    else
                        v->makeLocal();
                    v->setExplicitScope();
                }
                else
                    parse_error(*loc, "element %d in list following 'my' is not a variable reference (%s)", i, n.getTypeName());
            }
            (yyval.qv).set((yyvsp[-1].parse_list));
        }
#line 9489 "parser.cpp" /* yacc.c:1648  */
    break;

  case 263:
#line 3427 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.qv).set((yyvsp[0].gv)->makeVar());
        }
#line 9497 "parser.cpp" /* yacc.c:1648  */
    break;

  case 264:
#line 3431 "parser.ypp" /* yacc.c:1648  */
    {
            if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[0].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new BarewordNode(loc, (yyvsp[0].string)));
        }
#line 9509 "parser.cpp" /* yacc.c:1648  */
    break;

  case 265:
#line 3439 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ContextrefNode(loc, (yyvsp[0].string)));
        }
#line 9518 "parser.cpp" /* yacc.c:1648  */
    break;

  case 266:
#line 3444 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ContextRowNode(loc));
        }
#line 9527 "parser.cpp" /* yacc.c:1648  */
    break;

  case 267:
#line 3449 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ComplexContextrefNode(loc, (yyvsp[0].string)));
        }
#line 9536 "parser.cpp" /* yacc.c:1648  */
    break;

  case 268:
#line 3454 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new FindNode(loc, (yyvsp[-6].qv), (yyvsp[-4].qv), (yyvsp[-1].qv)));
        }
#line 9545 "parser.cpp" /* yacc.c:1648  */
    break;

  case 269:
#line 3459 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreExistsOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9554 "parser.cpp" /* yacc.c:1648  */
    break;

  case 270:
#line 3464 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreElementsOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9563 "parser.cpp" /* yacc.c:1648  */
    break;

  case 271:
#line 3468 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreKeysOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9572 "parser.cpp" /* yacc.c:1648  */
    break;

  case 272:
#line 3472 "parser.ypp" /* yacc.c:1648  */
    {  // unshift list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreUnshiftOperatorNode(loc, lv, l->shift()));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9591 "parser.cpp" /* yacc.c:1648  */
    break;

  case 273:
#line 3486 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreShiftOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9600 "parser.cpp" /* yacc.c:1648  */
    break;

  case 274:
#line 3490 "parser.ypp" /* yacc.c:1648  */
    {  // push lvalue-list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QorePushOperatorNode(loc, lv, l->shift()));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9619 "parser.cpp" /* yacc.c:1648  */
    break;

  case 275:
#line 3504 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QorePopOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9628 "parser.cpp" /* yacc.c:1648  */
    break;

  case 276:
#line 3508 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreChompOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9637 "parser.cpp" /* yacc.c:1648  */
    break;

  case 277:
#line 3512 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreTrimOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9646 "parser.cpp" /* yacc.c:1648  */
    break;

  case 278:
#line 3516 "parser.ypp" /* yacc.c:1648  */
    {  // splice lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreSpliceOperatorNode(loc, lv, l->shift(), l->shift(), l->shift()));
                discard(l, 0);
            }
        }
#line 9675 "parser.cpp" /* yacc.c:1648  */
    break;

  case 279:
#line 3540 "parser.ypp" /* yacc.c:1648  */
    {  // extract lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreExtractOperatorNode(loc, lv, l->shift(), l->shift(), l->shift()));
                discard(l, 0);
            }
        }
#line 9704 "parser.cpp" /* yacc.c:1648  */
    break;

  case 280:
#line 3564 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            int len = l ? (int)l->size() : 0;
            if (!l || len < 2 || len > 3) {
                parse_error(*loc, "invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else {
                // get first expression from list
                QoreValue exp = l->shift();
                qore_type_t t = exp.getType();
                (yyval.qv).set(nullptr);
                bool is_curly = false;
                if (t == NT_PARSE_HASH) {
                    QoreParseHashNode* phn = exp.get<QoreParseHashNode>();
                    if (phn->isCurly()) {
                        is_curly = true;
                        (yyval.qv).set(parse_hash_map(loc, phn, l));
                    }
                }

                if (!(yyval.qv) && !is_curly) {
                    (yyval.qv).set(parse_map(loc, exp, l));
                }
            }
        }
#line 9737 "parser.cpp" /* yacc.c:1648  */
    break;

  case 281:
#line 3592 "parser.ypp" /* yacc.c:1648  */
    {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldrOperatorNode(loc, code_exp, arg));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9758 "parser.cpp" /* yacc.c:1648  */
    break;

  case 282:
#line 3608 "parser.ypp" /* yacc.c:1648  */
    {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldlOperatorNode(loc, code_exp, arg));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9779 "parser.cpp" /* yacc.c:1648  */
    break;

  case 283:
#line 3624 "parser.ypp" /* yacc.c:1648  */
    {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue arg = l->shift();
                QoreValue select_exp = l->shift();
                (yyval.qv).set(new QoreSelectOperatorNode(loc, arg, select_exp));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 9800 "parser.cpp" /* yacc.c:1648  */
    break;

  case 284:
#line 3640 "parser.ypp" /* yacc.c:1648  */
    {  // pre-increment
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QorePreIncrementOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9809 "parser.cpp" /* yacc.c:1648  */
    break;

  case 285:
#line 3644 "parser.ypp" /* yacc.c:1648  */
    {  // pre-decrement
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QorePreDecrementOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9818 "parser.cpp" /* yacc.c:1648  */
    break;

  case 286:
#line 3648 "parser.ypp" /* yacc.c:1648  */
    {
            printd(5, "parsing in-object base class method call %s()\n", (yyvsp[-3].nscope)->ostr);
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            if (!strcmp((yyvsp[-3].nscope)->getIdentifier(), "copy"))
                parse_error(*loc, "illegal call to base class copy method '%s'", (yyvsp[-3].nscope)->ostr);

            (yyval.qv).set(new SelfFunctionCallNode(loc, (yyvsp[-3].nscope), make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].qv))));
        }
#line 9831 "parser.cpp" /* yacc.c:1648  */
    break;

  case 287:
#line 3656 "parser.ypp" /* yacc.c:1648  */
    {
            printd(5, "parsing call %s()\n", (yyvsp[-2].string));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new FunctionCallNode(loc, (yyvsp[-2].string), make_args(argsloc, (yyvsp[-1].qv))));
        }
#line 9842 "parser.cpp" /* yacc.c:1648  */
    break;

  case 288:
#line 3663 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new SelfVarrefNode(loc, (yyvsp[0].string)));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9853 "parser.cpp" /* yacc.c:1648  */
    break;

  case 289:
#line 3669 "parser.ypp" /* yacc.c:1648  */
    {
            // FIXME: need to expand constant expression checking to determine
            //        if the expression can throw an exception at run-time
            // first check for constant expressions
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreUnaryMinusOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9865 "parser.cpp" /* yacc.c:1648  */
    break;

  case 290:
#line 3677 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreUnaryPlusOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9874 "parser.cpp" /* yacc.c:1648  */
    break;

  case 291:
#line 3681 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreBinaryNotOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9883 "parser.cpp" /* yacc.c:1648  */
    break;

  case 292:
#line 3685 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreLogicalNotOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 9892 "parser.cpp" /* yacc.c:1648  */
    break;

  case 293:
#line 3689 "parser.ypp" /* yacc.c:1648  */
    {
            qore_type_t t = (yyvsp[0].qv).getType();
            //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2.getTypeName());

            if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
                (yyval.qv).set((yyvsp[0].qv).get<FunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_SELF_CALL) {
                (yyval.qv).set((yyvsp[0].qv).get<SelfFunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_STATIC_METHOD_CALL) {
                (yyval.qv).set((yyvsp[0].qv).get<StaticMethodCallNode>()->makeReferenceNodeAndDeref());
            }
            else {
                bool make_ref = true;

                if (t == NT_OPERATOR) {
                    QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[0].qv).getInternalNode());
                    if (deon) {
                        (yyval.qv).set(deon->makeCallReference());
                        make_ref = false;
                    }
                }

                if (make_ref) {
                    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                    //printd(5, "type=%s\n", $2.getTypeName());
                    (yyval.qv).set(new ParseReferenceNode(loc, (yyvsp[0].qv)));
                }
            }
        }
#line 9928 "parser.cpp" /* yacc.c:1648  */
    break;

  case 294:
#line 3720 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[-3].string)), make_args(argsloc, (yyvsp[-1].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 9940 "parser.cpp" /* yacc.c:1648  */
    break;

  case 295:
#line 3727 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[-3].string)), make_args(argsloc, (yyvsp[-1].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 9952 "parser.cpp" /* yacc.c:1648  */
    break;

  case 296:
#line 3734 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new ParseNewComplexTypeNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), false), make_args(argsloc, (yyvsp[-1].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 9964 "parser.cpp" /* yacc.c:1648  */
    break;

  case 297:
#line 3741 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreBackgroundOperatorNode(loc, (yyvsp[0].qv)));
            // check to see if the expression is legal
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
                parse_error(*loc, "illegal use of 'background' operator (conflicts with parse option PO_NO_THREAD_CONTROL)");
            else if (!value_has_effect_as_root((yyvsp[0].qv))) {
                if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                    parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[0].qv).getTypeName());
                }
            } else if (!(yyvsp[0].qv).hasEffect()) {
                parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[0].qv).getTypeName());
            }
        }
#line 9983 "parser.cpp" /* yacc.c:1648  */
    break;

  case 298:
#line 3755 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new BackquoteNode(loc, (yyvsp[0].string)));
            if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
                parse_error(*loc, "illegal use of backquote operator (conflicts with parse option PO_NO_EXTERNAL_PROCESS)");
        }
#line 9994 "parser.cpp" /* yacc.c:1648  */
    break;

  case 299:
#line 3761 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.qv).set((yyvsp[-1].qv));
            switch ((yyvsp[-1].qv).getType()) {
                case NT_PARSE_LIST:
                    (yyvsp[-1].qv).get<QoreParseListNode>()->setFinalized();
                    break;
                case NT_FUNCTION_CALL:
                    (yyvsp[-1].qv).get<FunctionCallNode>()->setFinalized();
                    break;
                case NT_BAREWORD:
                    (yyvsp[-1].qv).get<BarewordNode>()->setFinalized();
                    break;
                case NT_OPERATOR:
                    (yyvsp[-1].qv).get<QoreOperatorNode>()->setInParentheses();
                    break;
            }
        }
#line 10016 "parser.cpp" /* yacc.c:1648  */
    break;

  case 300:
#line 3778 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreParseListNode* l = new QoreParseListNode(loc);
            l->setFinalized();
            (yyval.qv).set(l);
        }
#line 10027 "parser.cpp" /* yacc.c:1648  */
    break;

  case 301:
#line 3784 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
#line 10037 "parser.cpp" /* yacc.c:1648  */
    break;

  case 302:
#line 3789 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
#line 10050 "parser.cpp" /* yacc.c:1648  */
    break;

  case 303:
#line 3797 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) | OFM_SYNCED, flags)));
        }
#line 10064 "parser.cpp" /* yacc.c:1648  */
    break;

  case 304:
#line 3806 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, (yyvsp[-6].i4) | OFM_SYNCED, flags)));
        }
#line 10082 "parser.cpp" /* yacc.c:1648  */
    break;

  case 305:
#line 3819 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.qv).set((yyvsp[0].implicit_arg));
            inc_numeric_argv_ref();
        }
#line 10091 "parser.cpp" /* yacc.c:1648  */
    break;

  case 306:
#line 3823 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreImplicitElementNode(loc));
        }
#line 10100 "parser.cpp" /* yacc.c:1648  */
    break;

  case 307:
#line 3827 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreDeleteOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10109 "parser.cpp" /* yacc.c:1648  */
    break;

  case 308:
#line 3831 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreRemoveOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10118 "parser.cpp" /* yacc.c:1648  */
    break;

  case 309:
#line 3835 "parser.ypp" /* yacc.c:1648  */
    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), false), (yyvsp[-1].qv)));
        }
#line 10127 "parser.cpp" /* yacc.c:1648  */
    break;

  case 310:
#line 3842 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].qv)); }
#line 10133 "parser.cpp" /* yacc.c:1648  */
    break;

  case 311:
#line 3843 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].parse_list)); }
#line 10139 "parser.cpp" /* yacc.c:1648  */
    break;

  case 312:
#line 3844 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].hash)); }
#line 10145 "parser.cpp" /* yacc.c:1648  */
    break;

  case 313:
#line 3845 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].node)); }
#line 10151 "parser.cpp" /* yacc.c:1648  */
    break;

  case 314:
#line 3846 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreParseHashNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), true)); }
#line 10157 "parser.cpp" /* yacc.c:1648  */
    break;

  case 315:
#line 3847 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10163 "parser.cpp" /* yacc.c:1648  */
    break;

  case 316:
#line 3848 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10169 "parser.cpp" /* yacc.c:1648  */
    break;

  case 317:
#line 3849 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10175 "parser.cpp" /* yacc.c:1648  */
    break;

  case 318:
#line 3850 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10181 "parser.cpp" /* yacc.c:1648  */
    break;

  case 319:
#line 3851 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10187 "parser.cpp" /* yacc.c:1648  */
    break;

  case 320:
#line 3852 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10193 "parser.cpp" /* yacc.c:1648  */
    break;

  case 321:
#line 3853 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10199 "parser.cpp" /* yacc.c:1648  */
    break;

  case 322:
#line 3854 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10205 "parser.cpp" /* yacc.c:1648  */
    break;

  case 323:
#line 3855 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10211 "parser.cpp" /* yacc.c:1648  */
    break;

  case 324:
#line 3856 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10217 "parser.cpp" /* yacc.c:1648  */
    break;

  case 325:
#line 3857 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(process_assignment((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10223 "parser.cpp" /* yacc.c:1648  */
    break;

  case 326:
#line 3858 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10236 "parser.cpp" /* yacc.c:1648  */
    break;

  case 327:
#line 3866 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        (yyval.qv).set((yyvsp[0].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getParseTypeInfo()));
        delete (yyvsp[0].parsertype);
    }
#line 10248 "parser.cpp" /* yacc.c:1648  */
    break;

  case 328:
#line 3873 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10254 "parser.cpp" /* yacc.c:1648  */
    break;

  case 329:
#line 3874 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10260 "parser.cpp" /* yacc.c:1648  */
    break;

  case 330:
#line 3875 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10266 "parser.cpp" /* yacc.c:1648  */
    break;

  case 331:
#line 3876 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 10272 "parser.cpp" /* yacc.c:1648  */
    break;

  case 332:
#line 3877 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 10278 "parser.cpp" /* yacc.c:1648  */
    break;

  case 333:
#line 3878 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(processCall((yylsp[-3]).first_line, (yylsp[0]).last_line, (yyvsp[-3].qv), (yyvsp[-1].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line))); }
#line 10284 "parser.cpp" /* yacc.c:1648  */
    break;

  case 334:
#line 3879 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_log_or(loc, (yyvsp[-2].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10294 "parser.cpp" /* yacc.c:1648  */
    break;

  case 335:
#line 3884 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10300 "parser.cpp" /* yacc.c:1648  */
    break;

  case 336:
#line 3885 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10306 "parser.cpp" /* yacc.c:1648  */
    break;

  case 337:
#line 3886 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10312 "parser.cpp" /* yacc.c:1648  */
    break;

  case 338:
#line 3887 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10322 "parser.cpp" /* yacc.c:1648  */
    break;

  case 339:
#line 3892 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10328 "parser.cpp" /* yacc.c:1648  */
    break;

  case 340:
#line 3893 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[-2].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10339 "parser.cpp" /* yacc.c:1648  */
    break;

  case 341:
#line 3899 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10345 "parser.cpp" /* yacc.c:1648  */
    break;

  case 342:
#line 3900 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10351 "parser.cpp" /* yacc.c:1648  */
    break;

  case 343:
#line 3901 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10357 "parser.cpp" /* yacc.c:1648  */
    break;

  case 344:
#line 3902 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].RegexSubst))); }
#line 10363 "parser.cpp" /* yacc.c:1648  */
    break;

  case 345:
#line 3903 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Trans))); }
#line 10369 "parser.cpp" /* yacc.c:1648  */
    break;

  case 346:
#line 3904 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10375 "parser.cpp" /* yacc.c:1648  */
    break;

  case 347:
#line 3905 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10381 "parser.cpp" /* yacc.c:1648  */
    break;

  case 348:
#line 3906 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10387 "parser.cpp" /* yacc.c:1648  */
    break;

  case 349:
#line 3907 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10393 "parser.cpp" /* yacc.c:1648  */
    break;

  case 350:
#line 3908 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10399 "parser.cpp" /* yacc.c:1648  */
    break;

  case 351:
#line 3909 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10405 "parser.cpp" /* yacc.c:1648  */
    break;

  case 352:
#line 3910 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10411 "parser.cpp" /* yacc.c:1648  */
    break;

  case 353:
#line 3911 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10417 "parser.cpp" /* yacc.c:1648  */
    break;

  case 354:
#line 3912 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10423 "parser.cpp" /* yacc.c:1648  */
    break;

  case 355:
#line 3913 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10429 "parser.cpp" /* yacc.c:1648  */
    break;

  case 356:
#line 3914 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10435 "parser.cpp" /* yacc.c:1648  */
    break;

  case 357:
#line 3915 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10441 "parser.cpp" /* yacc.c:1648  */
    break;

  case 358:
#line 3916 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10447 "parser.cpp" /* yacc.c:1648  */
    break;

  case 359:
#line 3917 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10453 "parser.cpp" /* yacc.c:1648  */
    break;

  case 360:
#line 3918 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10459 "parser.cpp" /* yacc.c:1648  */
    break;

  case 361:
#line 3919 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10465 "parser.cpp" /* yacc.c:1648  */
    break;

  case 362:
#line 3920 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10471 "parser.cpp" /* yacc.c:1648  */
    break;

  case 363:
#line 3921 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), QoreValue())); }
#line 10477 "parser.cpp" /* yacc.c:1648  */
    break;

  case 364:
#line 3922 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), QoreValue(), (yyvsp[-1].qv))); }
#line 10483 "parser.cpp" /* yacc.c:1648  */
    break;

  case 365:
#line 3923 "parser.ypp" /* yacc.c:1648  */
    {
        parse_error(*qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].qv), QoreValue(), QoreValue()));
    }
#line 10492 "parser.cpp" /* yacc.c:1648  */
    break;

  case 366:
#line 3927 "parser.ypp" /* yacc.c:1648  */
    {
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[-1].qv).getType() == NT_OPERATOR) {
           QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[-1].qv).getInternalNode());
           if (ron) {
              std::unique_ptr<QoreRangeOperatorNode> holder(ron);
              (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
           }
        }
        if (!(yyval.qv)) {
           (yyval.qv).set(new QoreSquareBracketsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].qv), (yyvsp[-1].qv)));
        }
    }
#line 10511 "parser.cpp" /* yacc.c:1648  */
    break;

  case 367:
#line 3941 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].qv), (yyvsp[-1].qv))); }
#line 10517 "parser.cpp" /* yacc.c:1648  */
    break;

  case 368:
#line 3942 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10523 "parser.cpp" /* yacc.c:1648  */
    break;

  case 369:
#line 3943 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(process_dot((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10529 "parser.cpp" /* yacc.c:1648  */
    break;

  case 370:
#line 3944 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv), (yyvsp[0].String))); }
#line 10535 "parser.cpp" /* yacc.c:1648  */
    break;

  case 371:
#line 3948 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].qv)); }
#line 10541 "parser.cpp" /* yacc.c:1648  */
    break;

  case 372:
#line 3949 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].parse_list)); }
#line 10547 "parser.cpp" /* yacc.c:1648  */
    break;

  case 373:
#line 3950 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10553 "parser.cpp" /* yacc.c:1648  */
    break;

  case 374:
#line 3951 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10559 "parser.cpp" /* yacc.c:1648  */
    break;

  case 375:
#line 3952 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10565 "parser.cpp" /* yacc.c:1648  */
    break;

  case 376:
#line 3953 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10571 "parser.cpp" /* yacc.c:1648  */
    break;

  case 377:
#line 3954 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10577 "parser.cpp" /* yacc.c:1648  */
    break;

  case 378:
#line 3955 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10583 "parser.cpp" /* yacc.c:1648  */
    break;

  case 379:
#line 3956 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10589 "parser.cpp" /* yacc.c:1648  */
    break;

  case 380:
#line 3957 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10595 "parser.cpp" /* yacc.c:1648  */
    break;

  case 381:
#line 3958 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10601 "parser.cpp" /* yacc.c:1648  */
    break;

  case 382:
#line 3959 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10607 "parser.cpp" /* yacc.c:1648  */
    break;

  case 383:
#line 3960 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(process_assignment((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10613 "parser.cpp" /* yacc.c:1648  */
    break;

  case 384:
#line 3961 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10626 "parser.cpp" /* yacc.c:1648  */
    break;

  case 385:
#line 3969 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        (yyval.qv).set((yyvsp[0].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getParseTypeInfo()));
        delete (yyvsp[0].parsertype);
    }
#line 10638 "parser.cpp" /* yacc.c:1648  */
    break;

  case 386:
#line 3976 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10644 "parser.cpp" /* yacc.c:1648  */
    break;

  case 387:
#line 3977 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10650 "parser.cpp" /* yacc.c:1648  */
    break;

  case 388:
#line 3978 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10656 "parser.cpp" /* yacc.c:1648  */
    break;

  case 389:
#line 3979 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 10662 "parser.cpp" /* yacc.c:1648  */
    break;

  case 390:
#line 3980 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 10668 "parser.cpp" /* yacc.c:1648  */
    break;

  case 391:
#line 3981 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(processCall((yylsp[-3]).first_line, (yylsp[0]).last_line, (yyvsp[-3].qv), (yyvsp[-1].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line))); }
#line 10674 "parser.cpp" /* yacc.c:1648  */
    break;

  case 392:
#line 3982 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_log_or(loc, (yyvsp[-2].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10684 "parser.cpp" /* yacc.c:1648  */
    break;

  case 393:
#line 3987 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10690 "parser.cpp" /* yacc.c:1648  */
    break;

  case 394:
#line 3988 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10696 "parser.cpp" /* yacc.c:1648  */
    break;

  case 395:
#line 3989 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10702 "parser.cpp" /* yacc.c:1648  */
    break;

  case 396:
#line 3990 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10712 "parser.cpp" /* yacc.c:1648  */
    break;

  case 397:
#line 3995 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10718 "parser.cpp" /* yacc.c:1648  */
    break;

  case 398:
#line 3996 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[-2].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 10729 "parser.cpp" /* yacc.c:1648  */
    break;

  case 399:
#line 4002 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10735 "parser.cpp" /* yacc.c:1648  */
    break;

  case 400:
#line 4003 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10741 "parser.cpp" /* yacc.c:1648  */
    break;

  case 401:
#line 4004 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10747 "parser.cpp" /* yacc.c:1648  */
    break;

  case 402:
#line 4005 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].RegexSubst))); }
#line 10753 "parser.cpp" /* yacc.c:1648  */
    break;

  case 403:
#line 4006 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Trans))); }
#line 10759 "parser.cpp" /* yacc.c:1648  */
    break;

  case 404:
#line 4007 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 10765 "parser.cpp" /* yacc.c:1648  */
    break;

  case 405:
#line 4008 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10771 "parser.cpp" /* yacc.c:1648  */
    break;

  case 406:
#line 4009 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10777 "parser.cpp" /* yacc.c:1648  */
    break;

  case 407:
#line 4010 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10783 "parser.cpp" /* yacc.c:1648  */
    break;

  case 408:
#line 4011 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10789 "parser.cpp" /* yacc.c:1648  */
    break;

  case 409:
#line 4012 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10795 "parser.cpp" /* yacc.c:1648  */
    break;

  case 410:
#line 4013 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10801 "parser.cpp" /* yacc.c:1648  */
    break;

  case 411:
#line 4014 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10807 "parser.cpp" /* yacc.c:1648  */
    break;

  case 412:
#line 4015 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10813 "parser.cpp" /* yacc.c:1648  */
    break;

  case 413:
#line 4016 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10819 "parser.cpp" /* yacc.c:1648  */
    break;

  case 414:
#line 4017 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10825 "parser.cpp" /* yacc.c:1648  */
    break;

  case 415:
#line 4018 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10831 "parser.cpp" /* yacc.c:1648  */
    break;

  case 416:
#line 4019 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10837 "parser.cpp" /* yacc.c:1648  */
    break;

  case 417:
#line 4020 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10843 "parser.cpp" /* yacc.c:1648  */
    break;

  case 418:
#line 4021 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10849 "parser.cpp" /* yacc.c:1648  */
    break;

  case 419:
#line 4022 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10855 "parser.cpp" /* yacc.c:1648  */
    break;

  case 420:
#line 4023 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10861 "parser.cpp" /* yacc.c:1648  */
    break;

  case 421:
#line 4024 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), QoreValue())); }
#line 10867 "parser.cpp" /* yacc.c:1648  */
    break;

  case 422:
#line 4025 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), QoreValue(), (yyvsp[-1].qv))); }
#line 10873 "parser.cpp" /* yacc.c:1648  */
    break;

  case 423:
#line 4026 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
        parse_error(*loc, "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[-3].qv), QoreValue(), QoreValue()));
    }
#line 10883 "parser.cpp" /* yacc.c:1648  */
    break;

  case 424:
#line 4031 "parser.ypp" /* yacc.c:1648  */
    {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[-1].qv).getType() == NT_OPERATOR) {
           QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[-1].qv).getInternalNode());
           if (ron) {
              std::unique_ptr<QoreRangeOperatorNode> holder(ron);
              (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[-3].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
           }
        }
        if (!(yyval.qv))
           (yyval.qv).set(new QoreSquareBracketsOperatorNode(loc, (yyvsp[-3].qv), (yyvsp[-1].qv)));
    }
#line 10902 "parser.cpp" /* yacc.c:1648  */
    break;

  case 425:
#line 4045 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].qv), (yyvsp[-1].qv))); }
#line 10908 "parser.cpp" /* yacc.c:1648  */
    break;

  case 426:
#line 4046 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10914 "parser.cpp" /* yacc.c:1648  */
    break;

  case 427:
#line 4047 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(process_dot((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10920 "parser.cpp" /* yacc.c:1648  */
    break;

  case 428:
#line 4048 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv), (yyvsp[0].String))); }
#line 10926 "parser.cpp" /* yacc.c:1648  */
    break;

  case 429:
#line 4052 "parser.ypp" /* yacc.c:1648  */
    {
           (yyval.String) = (yyvsp[0].String);
        }
#line 10934 "parser.cpp" /* yacc.c:1648  */
    break;

  case 430:
#line 4055 "parser.ypp" /* yacc.c:1648  */
    {
            (yyval.String) = (yyvsp[-1].String);
            (yyval.String)->concat((yyvsp[0].String));
            (yyvsp[0].String)->deref();
        }
#line 10944 "parser.cpp" /* yacc.c:1648  */
    break;

  case 431:
#line 4063 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].decimal)); }
#line 10950 "parser.cpp" /* yacc.c:1648  */
    break;

  case 432:
#line 4064 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].integer)); }
#line 10956 "parser.cpp" /* yacc.c:1648  */
    break;

  case 433:
#line 4065 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].String)); }
#line 10962 "parser.cpp" /* yacc.c:1648  */
    break;

  case 434:
#line 4066 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].datetime)); }
#line 10968 "parser.cpp" /* yacc.c:1648  */
    break;

  case 435:
#line 4067 "parser.ypp" /* yacc.c:1648  */
    { (yyval.qv).set((yyvsp[0].num)); }
#line 10974 "parser.cpp" /* yacc.c:1648  */
    break;


#line 10978 "parser.cpp" /* yacc.c:1648  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (&yylloc, yyscanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 4070 "parser.ypp" /* yacc.c:1907  */

