/* A Bison parser, made by GNU Bison 2.7.12-4996.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.7.12-4996"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
/* Line 371 of yacc.c  */
#line 1 "parser.ypp"
 /* -*- mode: c++; indent-tabs-mode: nil -*-

   parser.ypp

   Qore Programming Language

   Copyright 2003 - 2013 David Nichols

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <qore/Qore.h>
#include <qore/intern/BreakStatement.h>
#include <qore/intern/ContinueStatement.h>
#include <qore/intern/ReturnStatement.h>
#include <qore/intern/RethrowStatement.h>
#include <qore/intern/ThreadExitStatement.h>
#include <qore/intern/ExpressionStatement.h>
#include <qore/intern/DoWhileStatement.h>
#include <qore/intern/SummarizeStatement.h>
#include <qore/intern/ContextStatement.h>
#include <qore/intern/IfStatement.h>
#include <qore/intern/WhileStatement.h>
#include <qore/intern/ForStatement.h>
#include <qore/intern/ForEachStatement.h>
#include <qore/intern/TryStatement.h>
#include <qore/intern/ThrowStatement.h>
#include <qore/intern/StatementBlock.h>
#include <qore/intern/ParserSupport.h>
#include <qore/intern/SwitchStatement.h>
#include <qore/intern/CaseNodeWithOperator.h>
#include <qore/intern/CaseNodeRegex.h>
#include <qore/intern/OnBlockExitStatement.h>
#include <qore/intern/ConstantList.h>
#include <qore/intern/GlobalVariableList.h>
#include <qore/intern/QoreNamespaceIntern.h>

#include "parser.hpp"

#include <qore/intern/QoreClassIntern.h>
#include <qore/intern/qore_program_private.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <memory>
#include <utility>
#include <vector>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                                \
          do                                                           \
            if (N) {                                                   \
                (Current).first_line   = YYRHSLOC(Rhs, 1).first_line;  \
                (Current).last_line    = YYRHSLOC(Rhs, N).last_line;   \
            }                                                          \
            else {                                                     \
                (Current).first_line   = (Current).last_line   =       \
                  YYRHSLOC(Rhs, 0).last_line;                          \
            }                                                          \
          while (0)

class HashElement {
public:
   char* key;
   AbstractQoreNode* value;
 
   DLLLOCAL HashElement(AbstractQoreNode* k, AbstractQoreNode* v) {
      //tracein("HashElement::HashElement()");
      if (!k || k->getType() != NT_STRING) {
	 parse_error("hash member name must be a string value!");
	 key = strdup("");
      }
      else
	 key = strdup(reinterpret_cast<QoreStringNode*>(k)->getBuffer());
      k->deref(0);
      value = v;
      //traceout("HashElement::HashElement()");
   }

   DLLLOCAL HashElement(int tag, char* constant, AbstractQoreNode* v) {
      //tracein("HashElement::HashElement()");
      key = (char* )malloc(sizeof(char) * strlen(constant) + 2);
      key[0] = tag; // mark as constant
      strcpy(key + 1, constant);
      value = v;
      free(constant);
      //traceout("HashElement::HashElement()");
   }

   DLLLOCAL ~HashElement() {
      free(key);
   }
};

static AbstractQoreNode* makeErrorTree(AbstractQoreNode* left, AbstractQoreNode* right) {
   discard(left, 0);
   discard(right, 0);
   return &False;
}

// for constant definitions
class ConstNode {
public:
   NamedScope name;
   AbstractQoreNode* value;
   bool pub;

   DLLLOCAL ConstNode(char* n, AbstractQoreNode* v, bool p = false) : name(n), value(v), pub(p) {
      // see if constant definitions are allowed
      if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
         parse_error("illegal constant definition \"%s\" (conflicts with parse option NO_CONSTANT_DEFS)", n);
   }
   DLLLOCAL AbstractQoreNode* takeValue() {
      AbstractQoreNode* rv = value;
      value = 0;
      return rv;
   }
   DLLLOCAL const std::string &getName() const {
      return name.getIdentifierStr();
   }
   DLLLOCAL bool isPublic() const {
      return pub;
   }
};

class ObjClassDef {
public:
   NamedScope *name;
   QoreClass *oc;

   DLLLOCAL inline ObjClassDef(NamedScope *n, QoreClass *o) : name(n), oc(o) {}
   DLLLOCAL inline ObjClassDef(char* n, QoreClass *o) : name(new NamedScope(n)), oc(o) {}
   DLLLOCAL inline ~ObjClassDef() { delete name; }
};

class ParseUserFunctionBase {
public:
   UserFunctionVariant* variant;

   DLLLOCAL ParseUserFunctionBase(UserFunctionVariant* v) : variant(v) {
   }

   DLLLOCAL ~ParseUserFunctionBase() {
      if (variant)
         variant->deref();
   }

   DLLLOCAL void setPublic() {
      variant->setModulePublic();
   }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
   char* name;

   DLLLOCAL ParseUserFunction(char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(n_variant), name(n_name) {
   }

   DLLLOCAL ~ParseUserFunction() {
      if (name)
         free(name);
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
         const char* nsn = ns.name.c_str();
         parse_error("function '%s%s%s()' cannot be defined (conflicts with parse option NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
      }

      delete this;
   }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
   NamedScope name;

   DLLLOCAL ParseScopedUserFunction(char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(n_variant), name(n_name) {
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
         parse_error("function '%s()' cannot be defined (conflicts with parse option NO_SUBROUTINE_DEFS)", name.ostr);

      delete this;
   }
};

struct GVarDecl {
   bool pub;

   DLLLOCAL GVarDecl(bool p) : pub(p) {
   }

   DLLLOCAL virtual ~GVarDecl() {
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

   DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
   char* name;
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL GVarSingleDecl(char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti, bool p, bool bare) : GVarDecl(p), name(n), typeInfo(ti), parseTypeInfo(pti) {
      if (bare) {
         if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error("global variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", n);
      }
      else {
         if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error("reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", n);
      }
   }

   DLLLOCAL virtual ~GVarSingleDecl() {
      if (name)
         free(name);

      delete parseTypeInfo;
   }

   DLLLOCAL char* takeName() {
      char* rv = name;
      name = 0;
      return rv;
   }

   DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = 0;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ns.parseAddGlobalVarDecl(takeName(), typeInfo, takeParseTypeInfo(), pub);
      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      GlobalVarRefNode* gv = typeInfo
         ? new GlobalVarRefNode(takeName(), typeInfo)
         : new GlobalVarRefNode(takeName(), takeParseTypeInfo());
      if (pub)
         gv->setPublic();

      delete this;
      return gv;
   }   
};

struct GVarListDecl : public GVarDecl {
   QoreListNode* l;

   DLLLOCAL GVarListDecl(QoreListNode* list, bool p) : GVarDecl(p), l(list) {
      bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            if (!bareok)
               parse_error("global variable '%s' in global variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (vrn->explicitScope()) {
               if (vrn->getType() == VT_LOCAL)
                  parse_error("illegal use of 'my %s' in global variable declaration list", vrn->getName());
               else if (vrn->getType() == VT_GLOBAL)
                  parse_error("illegal use of 'our %s' in global variable declaration list", vrn->getName());
            }
         }
         else
            parse_error("element %d in list following 'our' is not a variable reference (%s)", li.index(), get_type_name(n));
      }
   }

   DLLLOCAL virtual ~GVarListDecl() {
      if (l)
         l->deref(0);
   }

   DLLLOCAL QoreListNode* takeList() {
      QoreListNode* rv = l;
      l = 0;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            ns.parseAddGlobalVarDecl(b->takeString(), 0, 0, pub);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
               if (vrdn)
                  ns.parseAddGlobalVarDecl(vrn->takeName(), vrdn->getTypeInfo(), vrdn->takeParseTypeInfo(), pub);
               else
                  ns.parseAddGlobalVarDecl(vrn->takeName(), 0, 0, pub);
            }
         }
      }

      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      l->setVariableList();
      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         VarRefNode* vrn = 0;
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            GlobalVarRefNode* v = new GlobalVarRefNode(b->takeString());
            b->deref();
            AbstractQoreNode** p = li.getValuePtr();
            *p = vrn = v;
         }
         else if (t == NT_VARREF) {
            vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               vrn->makeGlobal();
               vrn->setExplicitScope();
            }
         }

         if (vrn && pub)
            vrn->setPublic();
      }

      QoreListNode* rv = takeList();
      delete this;
      return rv;
   }
};

static int checkMethod(const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error("%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error("base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PRIVATE    (1 << 0)
#define OFM_SYNCED     (1 << 1)
#define OFM_STATIC     (1 << 2)
#define OFM_DEPRECATED (1 << 3)
#define OFM_PUBLIC     (1 << 4)
#define OFM_FINAL      (1 << 5)
#define OFM_ABSTRACT   (1 << 6)

static inline MethodVariantBase* newMethodVariant(const char* name, int mod, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b, int64 flags = QC_NO_FLAGS) {
   //printd(5, "newMethodVariant() '%s' b: %p\n", name, b);

   if (get_pop_argv_ref())
      flags |= QC_USES_EXTRA_ARGS;

   if (!strcmp(name, "constructor")) {
      if (mod & OFM_SYNCED)
         parse_error("%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error("return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      return new UserConstructorVariant(mod & OFM_PRIVATE, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
   }
   if (bcal) {
      parse_error("only constructors may have base class constructor arguments");
      delete bcal;
      bcal = 0;
   }
   if (!strcmp(name, "destructor")) {
      if (params) {
	 parse_error("parameters cannot be defined for destructors");
	 params->deref(0);
      }
      if (mod & OFM_SYNCED)
         parse_error("%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error("return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      if (mod & OFM_PRIVATE)
	 parse_error("destructors cannot be private");
      return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
   }
   if (!strcmp(name, "copy")) {
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (!(mod & OFM_SYNCED))
         return new UserCopyVariant(mod & OFM_PRIVATE, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
   }

   if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; they are not inherited anyway", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract; they are not inherited anyway", name);
   }

   if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
      parse_error("method '%s()' is declared both final and abstract", name);

   return new UserMethodVariant(mod & OFM_PRIVATE, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
   MethodVariantBase* m;
   NamedScope name;
   bool static_flag;

   DLLLOCAL MethodDef(int mod, char* n, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : m(0), name(n), static_flag(mod & OFM_STATIC) {
      if (checkMethod(name.getIdentifier(), bcal, returnTypeInfo)) {
         if (params)
            params->deref(0);
         delete bcal;
         delete b;
         delete returnTypeInfo;
         return;
      }

      m = newMethodVariant(name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b, mod & OFM_DEPRECATED);
   }

   DLLLOCAL ~MethodDef() {
      delete m;
   }

   DLLLOCAL void parseAddToClassAndDel() {
      if (m) {
         // if there are any errors, the function below will delete memory
         // the following method takes ownership of "m" unconditionally
         qore_root_ns_private::parseAddMethodToClass(name, m, static_flag);
         m = 0;
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      // the following method takes ownership of "m" unconditionally
      ns.parseAddMethodToClass(name, m, static_flag);
      m = 0;
   }
};

#define NSN_NONE  0
#define NSN_OCD   1
#define NSN_CONST 2
#define NSN_NS    3
#define NSN_FUNC  4
#define NSN_SFUNC 5
#define NSN_VAR   6
#define NSN_METH  7

struct NSNode {
   int type;
   union {
      ObjClassDef* ocd;
      ConstNode* cn;
      QoreNamespace* ns;
      ParseUserFunction* func;
      ParseScopedUserFunction* sfunc;
      GVarDecl* gv;
      MethodDef* meth;
   } n;

   DLLLOCAL NSNode(ObjClassDef *o) { type = NSN_OCD; n.ocd = o; }
   DLLLOCAL NSNode(ConstNode  *c) { type = NSN_CONST; n.cn = c; }
   DLLLOCAL NSNode(QoreNamespace  *s) { type = NSN_NS; n.ns = s; }
   DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
      n.func = f;
   }
   DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
      n.sfunc = f;
   }

   DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
      n.gv = gv;
   }

   DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
      n.meth = m;
   }

   DLLLOCAL void deref() {
      switch (type) {
         case NSN_OCD:
            delete n.ocd;
            break;
         case NSN_CONST:
            delete n.cn;
            break;
         case NSN_NS:
            delete n.ns;
            break;
         case NSN_FUNC:
            delete n.func;
            break;
         case NSN_SFUNC:
            delete n.sfunc;
            break;
         case NSN_VAR:
            delete n.gv;
            break;
         case NSN_METH:
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      switch (type) {
         case NSN_OCD:
            ns.parseAddPendingClass(*(n.ocd->name), n.ocd->oc);
            delete n.ocd;
            break;
         case NSN_CONST:
            ns.parseAddConstant(n.cn->name, n.cn->value, n.cn->pub);
            delete n.cn;
            break;
         case NSN_NS:
            ns.parseAddNamespace(n.ns);
            break;
         case NSN_FUNC:
            n.func->add(ns);
            break;
         case NSN_SFUNC:
            n.sfunc->add(ns);
            break;
         case NSN_VAR:
            n.gv->add(ns);
            break;
         case NSN_METH:
            n.meth->add(ns);
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
   DLLLOCAL void deref() {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->deref();

      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->add(ns);
   }
};

static QoreListNode* make_list(AbstractQoreNode* a1, AbstractQoreNode* a2) {
   QoreListNode* l = new QoreListNode;
   l->push(a1);
   l->push(a2);
   return l;
}

static QoreListNode* splice_expressions(AbstractQoreNode* a1, AbstractQoreNode* a2) {
   //tracein("splice_expressions()");
   if (a1 && a1->getType() == NT_LIST) {
      QoreListNode* l = reinterpret_cast<QoreListNode*>(a1);
      if (!l->isFinalized()) {
	 //printd(5, "LIST x\n");
	 l->push(a2);
	 return l;
      }
   }
   return make_list(a1, a2);
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2

struct MemberInfo {
protected:
   DLLLOCAL MemberInfo() {
   }

public:
   //enum mi_e { Member, Constant, Var };

   char* name;
   unsigned char type;
   union {
      QoreMemberInfo* memberInfo;
      QoreVarInfo* varInfo;
      AbstractQoreNode* exp;
   } u;

   DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : name(n), type(MI_Member)  {
      u.memberInfo = mi; 
      if (!mi->parseHasTypeInfo() && parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("member '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL MemberInfo(char* n) : name(n), type(MI_Member)  {
      u.memberInfo = 0; 
      if (parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("member '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL MemberInfo(char* n, AbstractQoreNode* exp) : name(n), type(MI_Constant) {
      u.exp = exp;
   }
   DLLLOCAL ~MemberInfo() {
      if (name)
	 free(name);
      switch (type) {
	 case MI_Member:
	    delete u.memberInfo;
	    break;
	 case MI_Var:
	    delete u.varInfo;
	    break;
	 case MI_Constant:
	    if (u.exp)
	       u.exp->deref(0);
	    break;
      }
   }
   DLLLOCAL member_pair_t getPair() {
      assert(type == MI_Member);
      member_pair_t m = std::make_pair(name, u.memberInfo);
      name = 0;
      u.memberInfo = 0;
      return m;
   }
   DLLLOCAL var_pair_t getVarPair() {
      assert(type == MI_Var);
      var_pair_t m = std::make_pair(name, u.varInfo);
      name = 0;
      u.varInfo = 0;
      return m;
   }
   DLLLOCAL AbstractQoreNode* takeExp() {
      assert(type == MI_Constant);
      AbstractQoreNode* rv = u.exp;
      u.exp = 0;
      return rv;
   }
};

struct ClassVarInfo : public MemberInfo {
   DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) {
      name = n;
      type = MI_Var;
      u.varInfo = vi; 
      if (!vi->parseHasTypeInfo() && parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL char* takeName() {
      char* n = name;
      name = 0;
      return n;
   }
   DLLLOCAL QoreVarInfo* takeVarInfo() {
      assert(u.varInfo);
      QoreVarInfo* rv = u.varInfo;
      u.varInfo = 0;
      return rv;
   }
};

class MemberList {
protected:
   // for new class members
   QoreMemberMap mmap;
   // for new class constants
   ConstantList cmap;
   // for new class static variables
   QoreVarMap vmap;
   
   DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
   }

public:
   DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
      if (!member)
	 return;

      if (member->type == MI_Member)
	 mmap.insert(member->getPair());
      else if (member->type == MI_Constant)
	 cmap.parseAdd(member->name, member->takeExp());
      else
	 vmap.insert(member->getVarPair());

      delete member;
   }

   DLLLOCAL ~MemberList() {
   }

   // takes over ownership of name and typeInfo
   DLLLOCAL int add(MemberInfo* member) {
      if (!member)
	 return -1;

      //std::auto_ptr<MemberInfo> mem(member);

      if (member->type == MI_Member) {
	 if (mmap.find(member->name) != mmap.end()) {
	    parse_error("duplicate member declaration '%s'", member->name);
            delete member;
	    return -1;
	 }

	 // add new member to list
	 mmap.insert(member->getPair());
      }
      else if (member->type == MI_Constant) {
	 if (cmap.inList(member->name)) {
	    parse_error("duplicate constant declaration '%s'", member->name);
            delete member;
	    return -1;
	 }
	 if (vmap.find(member->name)) {
	    parse_error("constant declaration collides with static class variable declaration '%s'", member->name);
	    return -1;
	 }	 

	 // add new constant to list
	 cmap.parseAdd(member->name, member->takeExp());
         delete member;
      }
      else {
	 assert(member->type == MI_Var);
	 if (vmap.find(member->name)) {
	    parse_error("duplicate static class variable declaration '%s'", member->name);
	    return -1;
	 }
	 if (cmap.inList(member->name)) {
	    parse_error("static class variable declaration collides with constant declaration '%s'", member->name);
	    return -1;
	 }

	 // add new member to list
	 vmap.insert(member->getVarPair());
      }

      return 0;
   }

   DLLLOCAL void mergePrivate(QoreClass *qc) {
      {
	 member_map_t::iterator i;
	 // merge private members
	 while ((i = mmap.begin()) != mmap.end()) {
	    qore_class_private::parseAddPrivateMember(*qc, i->first, i->second);
	    mmap.erase(i);
	 }
      }

      {
	 var_map_t::iterator i;
	 // merge private static class variables
	 while ((i = vmap.begin()) != vmap.end()) {
	    qore_class_private::parseAddPrivateStaticVar(qc, i->first, i->second);
	    vmap.erase(i);
	 }
      }

      // merge private constants
      qc->parseAssimilatePrivateConstants(cmap);
   }

   DLLLOCAL void mergePublic(QoreClass *qc) {
      // merge public members
      if (mmap.empty())
	 qc->parseSetEmptyPublicMemberDeclaration();
      else {
	 member_map_t::iterator i;

	 while ((i = mmap.begin()) != mmap.end()) {
	    qore_class_private::parseAddPublicMember(*qc, i->first, i->second);
	    mmap.erase(i);
	 }
      }

      {
	 var_map_t::iterator i;
	 // merge public static class variables
	 while ((i = vmap.begin()) != vmap.end()) {
	    qore_class_private::parseAddPublicStaticVar(qc, i->first, i->second);
	    vmap.erase(i);
	 }
      }

      // merge public constants
      qc->parseAssimilatePublicConstants(cmap);
   }
};

class EmptyPublicMemberList : public MemberList {
public:
   DLLLOCAL EmptyPublicMemberList() {
   }
};

struct ParserTypeStruct {
protected:
   DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : typeInfo(0), parseTypeInfo(n_parseTypeInfo) {
   }

   DLLLOCAL ParserTypeStruct() {
   }

public:
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL ParserTypeStruct(const QoreTypeInfo* n_typeInfo) : typeInfo(n_typeInfo), parseTypeInfo(0) {
   }

   DLLLOCAL ParserTypeStruct(char* id) {
      const QoreTypeInfo* t = getBuiltinUserTypeInfo(id);
      //printd(0, "ParserTypeStruct::ParserTypeStruct('%s') t: %p %s\n", id, t, t->getName());
      if (t) {
	 free(id);
	 typeInfo = t;
	 parseTypeInfo = 0;
	 return;
      }

      typeInfo = 0;
      parseTypeInfo = new QoreParseTypeInfo(id);
   }

   DLLLOCAL ~ParserTypeStruct() {
      delete parseTypeInfo;
   }

   DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
      if (!this)
	 return 0;

      return typeInfo;
   }

   DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
      if (!this)
	 return 0;

      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = 0;
      return rv;
   }

   DLLLOCAL const char* getClassName() {
      assert(this);
      assert(parseTypeInfo);
      return parseTypeInfo->cscope->ostr;
   }
};

struct ParserScopedTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserScopedTypeStruct(char* sr) : ParserTypeStruct(new QoreParseTypeInfo(sr)) {
   }
};

struct ParserOrNothingTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserOrNothingTypeStruct(char* id) {
      const QoreTypeInfo* t = getBuiltinUserOrNothingTypeInfo(id);
      if (t) {
	 free(id);
	 typeInfo = t;
	 parseTypeInfo = 0;
	 return;
      }

      typeInfo = 0;
      parseTypeInfo = new QoreParseTypeInfo(id, true);
   }
};

struct ParserScopedOrNothingTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserScopedOrNothingTypeStruct(char* sr) : ParserTypeStruct(new QoreParseTypeInfo(sr, true)) {
   }
};

static AbstractQoreNode* process_dot(AbstractQoreNode* l, AbstractQoreNode* r) {
   qore_type_t rtype = r->getType();
   if (rtype == NT_BAREWORD) {
      BarewordNode* b = reinterpret_cast<BarewordNode*>(r);
      AbstractQoreNode* rv = new QoreTreeNode(l, OP_OBJECT_REF, b->makeQoreStringNode());
      b->deref();
      return rv;
   }

   if (rtype == NT_FUNCTION_CALL) {
      FunctionCallNode* f = reinterpret_cast<FunctionCallNode*>(r);
      assert(!f->getFunction());
      if (!f->isFinalized()) {
         MethodCallNode* m = new MethodCallNode(f->takeName(), f->take_args());
         f->deref();

         return new QoreDotEvalOperatorNode(l, m);
      }
   }

   return new QoreTreeNode(l, OP_OBJECT_REF, r);
}

// returns true if the node needs run-time evaluation, false if not
static bool needsEval(AbstractQoreNode* n) {
   if (!n)
      return false;

   qore_type_t ntype = n->getType();

   // if it's a constant or a function reference
   if (ntype == NT_BAREWORD || ntype == NT_CONSTANT || ntype == NT_FUNCREF)
      return false;

   if (ntype == NT_LIST) {
      QoreListNode* l = reinterpret_cast<QoreListNode*>(n);
      if (l->needs_eval()) {
	 for (unsigned i = 0; i <l->size(); i++) {
	    if (needsEval(l->retrieve_entry(i)))
	       return true;
	 }
	 // here we set needs_eval to false so the list won't be evaluated again
	 l->clearNeedsEval();
      }
      return false;
   }

   if (ntype == NT_HASH) {
      QoreHashNode* h = reinterpret_cast<QoreHashNode*>(n);
      if (h->needs_eval()) {
	 HashIterator hi(h);
	 while (hi.next())
	    if (needsEval(hi.getValue()))
	       return true;
	 // here we set needs_eval to false so the hash won't be evaluated again
	 h->clearNeedsEval();
      }
      return false;
   }
   
   if (ntype == NT_TREE) {
      QoreTreeNode* tree = reinterpret_cast<QoreTreeNode*>(n);

      if (needsEval(tree->left) || (tree->right && needsEval(tree->right)))
	 return true;
      return tree->getOp()->hasEffect();
   }

   //printd(5, "needsEval() type %s = true\n", n->getTypeName());
   // we don't return needs_eval() here because some node types are not meant to be evaluated directly but are also not values
   return !n->is_value();
}

static int check_case(const char* op, AbstractQoreNode* exp) {
   // ignore if NULL (= NOTHING)
   if (exp && needsEval(exp)) {
      if (op)
	 parse_error("case expression with '%s' needs run-time evaluation", op);
      else
	 parse_error("case expression needs run-time evaluation", op);
      return -1;
   }
   return 0;
}

static void check_funcmod(int mod) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in function declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in function declaration");
   if (mod & OFM_FINAL)
      parse_error("illegal 'final' modifier in function declaration");
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in function declaration");
}

static void check_classmod(int mod, QoreClass& qc) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error("illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error("illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in class declaration");
}

static void check_nsmod(int mod, qore_ns_private& ns) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error("illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error("illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error("illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
   if (!n || n->is_value())
      return false;

   if (n->getType() == NT_OPERATOR)
      return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

   const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
   return pn ? pn->has_effect() : true;
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL inline MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }
   DLLLOCAL inline ~MethodNode() {
      free(name);
      delete m;
   }
   DLLLOCAL inline void addAndDelete(QoreClass *qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }
};

static AbstractQoreNode* is_rewritable_op(AbstractQoreNode* n) {
   qore_type_t nt = get_node_type(n);
   if (nt == NT_OPERATOR) {
      QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n);
      if (op)
         return op->getRight();
   }

   return 0;
}

static AbstractQoreNode* checkRewriteList(QoreListNode* l) {
   // rewrite expression if it's a list without parentheses and
   // the first expression has one of the following operators:
   // =, +=, -=
   if (l->isFinalized())
      return l;

   AbstractQoreNode* e0 = l->retrieve_entry(0);

   AbstractQoreNode* r = is_rewritable_op(e0);
   if (r) {
      AbstractQoreNode* last = e0;
      AbstractQoreNode* top = e0;
      while (true) {
         AbstractQoreNode* nr = is_rewritable_op(r);
         if (!nr)
            break;
         last = r;
         r = nr;
      }
      assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last));
      // take first element from list (the tree) and make it the new expression
      QoreBinaryLValueOperatorNode* op = reinterpret_cast<QoreBinaryLValueOperatorNode*>(last);
      l->swap(0, op->swapRight(l));
      return top;
   }

   return l;
}

void ignore_return_value(AbstractQoreNode* n) {
   qore_type_t t = get_node_type(n);
   if (t == NT_TREE)
      reinterpret_cast<QoreTreeNode*>(n)->ignoreReturnValue();
   else if (t == NT_OPERATOR)
      reinterpret_cast<QoreOperatorNode*>(n)->ignoreReturnValue();
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}


/* Line 371 of yacc.c  */
#line 1237 "parser.cpp"

# ifndef YY_NULL
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULL nullptr
#  else
#   define YY_NULL 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_HPP_INCLUDED
# define YY_YY_PARSER_HPP_INCLUDED
/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOK_RETURN = 258,
     TOK_RETURNS = 259,
     TOK_MY = 260,
     TOK_DO = 261,
     TOK_TRY = 262,
     TOK_THROW = 263,
     TOK_CATCH = 264,
     TOK_WHERE = 265,
     TOK_WHILE = 266,
     TOK_IF = 267,
     TOK_FOR = 268,
     TOK_SUB = 269,
     TOK_THREAD_EXIT = 270,
     TOK_BREAK = 271,
     TOK_CONTINUE = 272,
     TOK_CONTEXT_ROW = 273,
     TOK_FIND = 274,
     TOK_FOREACH = 275,
     TOK_IN = 276,
     TOK_DELETE = 277,
     TOK_REMOVE = 278,
     TOK_PRIVATE = 279,
     TOK_PUBLIC = 280,
     TOK_SYNCHRONIZED = 281,
     TOK_DEPRECATED = 282,
     TOK_CONTEXT = 283,
     TOK_SORT_BY = 284,
     TOK_SORT_DESCENDING_BY = 285,
     TOK_SUB_CONTEXT = 286,
     TOK_CONST = 287,
     TOK_SUMMARIZE = 288,
     TOK_BY = 289,
     TOK_OUR = 290,
     TOK_RETHROW = 291,
     TOK_SWITCH = 292,
     TOK_CASE = 293,
     TOK_DEFAULT = 294,
     TOK_INHERITS = 295,
     TOK_ELSE = 296,
     TOK_STATIC = 297,
     TOK_NAMESPACE = 298,
     TOK_MODULE = 299,
     TOK_FINAL = 300,
     TOK_ABSTRACT = 301,
     TOK_UNREFERENCE = 302,
     P_INCREMENT = 303,
     P_DECREMENT = 304,
     PLUS_EQUALS = 305,
     MINUS_EQUALS = 306,
     AND_EQUALS = 307,
     OR_EQUALS = 308,
     MODULA_EQUALS = 309,
     MULTIPLY_EQUALS = 310,
     DIVIDE_EQUALS = 311,
     XOR_EQUALS = 312,
     SHIFT_LEFT_EQUALS = 313,
     SHIFT_RIGHT_EQUALS = 314,
     TOK_UNSHIFT = 315,
     TOK_PUSH = 316,
     TOK_POP = 317,
     TOK_SHIFT = 318,
     TOK_CHOMP = 319,
     TOK_TRIM = 320,
     LOGICAL_AND = 321,
     LOGICAL_OR = 322,
     LOGICAL_EQ = 323,
     LOGICAL_NE = 324,
     LOGICAL_LE = 325,
     LOGICAL_GE = 326,
     LOGICAL_CMP = 327,
     ABSOLUTE_EQ = 328,
     ABSOLUTE_NE = 329,
     REGEX_MATCH = 330,
     REGEX_NMATCH = 331,
     TOK_EXISTS = 332,
     TOK_INSTANCEOF = 333,
     SHIFT_RIGHT = 334,
     SHIFT_LEFT = 335,
     TOK_ELEMENTS = 336,
     TOK_KEYS = 337,
     TOK_NEW = 338,
     TOK_BACKGROUND = 339,
     TOK_ON_EXIT = 340,
     TOK_ON_SUCCESS = 341,
     TOK_ON_ERROR = 342,
     TOK_MAP = 343,
     TOK_FOLDR = 344,
     TOK_FOLDL = 345,
     TOK_SELECT = 346,
     TOK_SPLICE = 347,
     TOK_EXTRACT = 348,
     IMPLICIT_ELEMENT = 349,
     INTEGER = 350,
     QFLOAT = 351,
     NUMBER = 352,
     IDENTIFIER = 353,
     VAR_REF = 354,
     BACKQUOTE = 355,
     SELF_REF = 356,
     KW_IDENTIFIER_OPENPAREN = 357,
     SCOPED_REF = 358,
     SCOPED_VREF = 359,
     CONTEXT_REF = 360,
     COMPLEX_CONTEXT_REF = 361,
     QORE_CAST = 362,
     CLASS_STRING = 363,
     DATETIME = 364,
     QUOTED_WORD = 365,
     BINARY = 366,
     REGEX_SUBST = 367,
     REGEX_TRANS = 368,
     CLASS_SCOPED_REF = 369,
     BASE_CLASS_CALL = 370,
     REGEX = 371,
     REGEX_EXTRACT = 372,
     IMPLICIT_ARG_REF = 373,
     DOT_KW_IDENTIFIER = 374,
     TRY_MODULE_ERROR = 375,
     IFX = 376,
     NEG = 377
   };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_MY 260
#define TOK_DO 261
#define TOK_TRY 262
#define TOK_THROW 263
#define TOK_CATCH 264
#define TOK_WHERE 265
#define TOK_WHILE 266
#define TOK_IF 267
#define TOK_FOR 268
#define TOK_SUB 269
#define TOK_THREAD_EXIT 270
#define TOK_BREAK 271
#define TOK_CONTINUE 272
#define TOK_CONTEXT_ROW 273
#define TOK_FIND 274
#define TOK_FOREACH 275
#define TOK_IN 276
#define TOK_DELETE 277
#define TOK_REMOVE 278
#define TOK_PRIVATE 279
#define TOK_PUBLIC 280
#define TOK_SYNCHRONIZED 281
#define TOK_DEPRECATED 282
#define TOK_CONTEXT 283
#define TOK_SORT_BY 284
#define TOK_SORT_DESCENDING_BY 285
#define TOK_SUB_CONTEXT 286
#define TOK_CONST 287
#define TOK_SUMMARIZE 288
#define TOK_BY 289
#define TOK_OUR 290
#define TOK_RETHROW 291
#define TOK_SWITCH 292
#define TOK_CASE 293
#define TOK_DEFAULT 294
#define TOK_INHERITS 295
#define TOK_ELSE 296
#define TOK_STATIC 297
#define TOK_NAMESPACE 298
#define TOK_MODULE 299
#define TOK_FINAL 300
#define TOK_ABSTRACT 301
#define TOK_UNREFERENCE 302
#define P_INCREMENT 303
#define P_DECREMENT 304
#define PLUS_EQUALS 305
#define MINUS_EQUALS 306
#define AND_EQUALS 307
#define OR_EQUALS 308
#define MODULA_EQUALS 309
#define MULTIPLY_EQUALS 310
#define DIVIDE_EQUALS 311
#define XOR_EQUALS 312
#define SHIFT_LEFT_EQUALS 313
#define SHIFT_RIGHT_EQUALS 314
#define TOK_UNSHIFT 315
#define TOK_PUSH 316
#define TOK_POP 317
#define TOK_SHIFT 318
#define TOK_CHOMP 319
#define TOK_TRIM 320
#define LOGICAL_AND 321
#define LOGICAL_OR 322
#define LOGICAL_EQ 323
#define LOGICAL_NE 324
#define LOGICAL_LE 325
#define LOGICAL_GE 326
#define LOGICAL_CMP 327
#define ABSOLUTE_EQ 328
#define ABSOLUTE_NE 329
#define REGEX_MATCH 330
#define REGEX_NMATCH 331
#define TOK_EXISTS 332
#define TOK_INSTANCEOF 333
#define SHIFT_RIGHT 334
#define SHIFT_LEFT 335
#define TOK_ELEMENTS 336
#define TOK_KEYS 337
#define TOK_NEW 338
#define TOK_BACKGROUND 339
#define TOK_ON_EXIT 340
#define TOK_ON_SUCCESS 341
#define TOK_ON_ERROR 342
#define TOK_MAP 343
#define TOK_FOLDR 344
#define TOK_FOLDL 345
#define TOK_SELECT 346
#define TOK_SPLICE 347
#define TOK_EXTRACT 348
#define IMPLICIT_ELEMENT 349
#define INTEGER 350
#define QFLOAT 351
#define NUMBER 352
#define IDENTIFIER 353
#define VAR_REF 354
#define BACKQUOTE 355
#define SELF_REF 356
#define KW_IDENTIFIER_OPENPAREN 357
#define SCOPED_REF 358
#define SCOPED_VREF 359
#define CONTEXT_REF 360
#define COMPLEX_CONTEXT_REF 361
#define QORE_CAST 362
#define CLASS_STRING 363
#define DATETIME 364
#define QUOTED_WORD 365
#define BINARY 366
#define REGEX_SUBST 367
#define REGEX_TRANS 368
#define CLASS_SCOPED_REF 369
#define BASE_CLASS_CALL 370
#define REGEX 371
#define REGEX_EXTRACT 372
#define IMPLICIT_ARG_REF 373
#define DOT_KW_IDENTIFIER 374
#define TRY_MODULE_ERROR 375
#define IFX 376
#define NEG 377



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{
/* Line 387 of yacc.c  */
#line 1176 "parser.ypp"

   bool b;
   int i4;
   int64 integer;
   double decimal;
   QoreStringNode* String;
   char* string;
   BinaryNode* binary;
   AbstractQoreNode* node;
   QoreHashNode* hash;
   QoreListNode* list;
   AbstractStatement *statement;
   struct MemberInfo* memberinfo;
   struct ClassVarInfo* classvarinfo;
   StatementBlock *sblock;
   ContextModList* cmods;
   ContextMod *cmod;
   class HashElement *hashelement;
   QoreFunction *userfunc;	
   struct MethodNode* methodnode;
   class MemberList* memberlist;
   QoreClass *qoreclass;
   class ConstNode* constnode;
   QoreNamespace *ns;
   struct NSNodeList* nsnlist;
   struct NSNode* nsn;
   class ObjClassDef *classdef;
   DateTimeNode* datetime;
   RegexSubstNode* RegexSubst;
   RegexTransNode* RegexTrans;
   SwitchStatement *switchstmt;
   CaseNode* casenode;
   BCList* sclist;
   class BCNode* sclnode;
   BCAList* bcalist;
   BCANode* bcanode;
   NamedScope *nscope;
   QoreRegexNode* Regex;
   QoreImplicitArgumentNode* implicit_arg;
   RetTypeInfo* returnTypeInfo;
   struct ParserTypeStruct *parsertype;
   class ParseUserFunction* parsefunc;
   class ParseScopedUserFunction* sparsefunc;
   struct GVarDecl* gv;
   QoreNumberNode* num;
   TryModuleError* trymod;
   struct MethodDef* methoddef;


/* Line 387 of yacc.c  */
#line 1574 "parser.cpp"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (yyscan_t yyscanner);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */

#endif /* !YY_YY_PARSER_HPP_INCLUDED  */

/* Copy the second part of user declarations.  */
/* Line 390 of yacc.c  */
#line 1225 "parser.ypp"


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE *loc, yyscan_t scanner, const char* str) {
   //printd(5, "yyerror() location: %d-%d: \"%s\"\n", loc->first_line, loc->last_line, str);
   parse_error("%s", str);
}


/* Line 390 of yacc.c  */
#line 1627 "parser.cpp"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef __attribute__
/* This feature is available in gcc versions 2.5 and later.  */
# if (! defined __GNUC__ || __GNUC__ < 2 \
      || (__GNUC__ == 2 && __GNUC_MINOR__ < 5))
#  define __attribute__(Spec) /* empty */
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif


/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(N) (N)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  195
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   8719

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  148
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  57
/* YYNRULES -- Number of rules.  */
#define YYNRULES  325
/* YYNRULES -- Number of states.  */
#define YYNSTATES  735

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   377

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   139,     2,     2,     2,   133,   126,     2,
     143,   146,   134,   131,   122,   132,   142,   135,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   125,   145,
     129,   123,   130,   124,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   141,   138,   147,   128,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   140,   127,   144,   137,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   136
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    26,    28,    33,    35,    37,    40,    45,    46,
      48,    53,    57,    62,    66,    71,    76,    82,    88,    92,
      97,    99,   102,   104,   106,   108,   110,   112,   115,   117,
     119,   125,   132,   138,   145,   149,   152,   154,   156,   158,
     160,   163,   166,   167,   169,   172,   178,   180,   183,   187,
     190,   193,   196,   200,   212,   220,   226,   234,   240,   248,
     258,   266,   269,   272,   275,   278,   280,   283,   284,   287,
     292,   297,   302,   304,   307,   315,   317,   320,   326,   331,
     337,   342,   348,   353,   359,   364,   370,   375,   381,   386,
     392,   397,   402,   406,   411,   415,   419,   422,   430,   431,
     433,   435,   442,   449,   454,   459,   465,   471,   474,   475,
     477,   481,   483,   485,   488,   491,   494,   497,   499,   501,
     503,   505,   508,   511,   514,   517,   519,   521,   524,   527,
     528,   530,   534,   539,   543,   548,   552,   557,   561,   568,
     574,   582,   586,   592,   599,   603,   609,   616,   619,   624,
     626,   628,   630,   633,   635,   639,   641,   644,   647,   650,
     652,   660,   668,   676,   684,   693,   702,   711,   720,   728,
     736,   739,   740,   742,   746,   751,   756,   757,   759,   761,
     764,   766,   768,   770,   772,   774,   776,   778,   781,   782,
     789,   796,   804,   812,   820,   828,   837,   846,   850,   853,
     855,   859,   862,   866,   870,   874,   876,   878,   880,   884,
     886,   889,   892,   895,   899,   902,   906,   911,   913,   915,
     917,   919,   921,   930,   934,   938,   942,   946,   950,   954,
     958,   962,   966,   970,   974,   977,   980,   984,   988,   991,
     994,   997,  1000,  1003,  1006,  1009,  1012,  1015,  1018,  1021,
    1024,  1027,  1033,  1036,  1039,  1042,  1045,  1050,  1055,  1059,
    1061,  1065,  1069,  1073,  1077,  1081,  1085,  1089,  1093,  1097,
    1101,  1105,  1109,  1113,  1117,  1121,  1125,  1129,  1133,  1137,
    1141,  1145,  1149,  1153,  1157,  1161,  1165,  1168,  1171,  1174,
    1177,  1183,  1189,  1192,  1194,  1199,  1204,  1208,  1211,  1215,
    1218,  1225,  1232,  1240,  1248,  1250,  1252,  1255,  1258,  1263,
    1265,  1268,  1270,  1272,  1274,  1276
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     149,     0,    -1,   150,    -1,   149,   150,    -1,   197,    -1,
     198,    -1,   173,    -1,   159,    -1,   158,    -1,   189,    -1,
     164,    -1,   140,   162,   144,    -1,   155,    -1,    44,   140,
     151,   144,    -1,   120,    -1,   152,    -1,   151,   152,    -1,
      98,   123,   202,   145,    -1,    -1,    25,    -1,   153,    35,
     178,   103,    -1,   153,    35,   103,    -1,   153,    35,   178,
      98,    -1,   153,    35,    98,    -1,   153,    35,   179,   104,
      -1,   153,    35,   179,    99,    -1,   153,    35,   143,   199,
     146,    -1,   193,    43,   140,   156,   144,    -1,   193,    43,
     145,    -1,   193,    43,   140,   144,    -1,   157,    -1,   156,
     157,    -1,   159,    -1,   158,    -1,   173,    -1,   197,    -1,
     198,    -1,   154,   145,    -1,   155,    -1,   189,    -1,    32,
      98,   123,   202,   145,    -1,    25,    32,    98,   123,   202,
     145,    -1,    32,   103,   123,   202,   145,    -1,    25,    32,
     103,   123,   202,   145,    -1,   140,   162,   144,    -1,   140,
     144,    -1,   164,    -1,   160,    -1,   164,    -1,   160,    -1,
     162,   160,    -1,   162,   164,    -1,    -1,    98,    -1,   202,
     145,    -1,   103,   143,   172,   146,   145,    -1,   171,    -1,
      36,   145,    -1,     8,   202,   145,    -1,    85,   161,    -1,
      86,   161,    -1,    87,   161,    -1,    31,   165,   161,    -1,
      33,   163,   143,   202,   146,    34,   143,   202,   146,   165,
     161,    -1,    28,   163,   143,   202,   146,   165,   161,    -1,
      12,   143,   202,   146,   161,    -1,    12,   143,   202,   146,
     161,    41,   161,    -1,    11,   143,   202,   146,   161,    -1,
       6,   161,    11,   143,   202,   146,   145,    -1,    13,   143,
     172,   145,   172,   145,   172,   146,   161,    -1,    20,   202,
      21,   143,   202,   146,   161,    -1,   167,   145,    -1,    15,
     145,    -1,    16,   145,    -1,    17,   145,    -1,   168,    -1,
       1,   145,    -1,    -1,   165,   166,    -1,    10,   143,   202,
     146,    -1,    29,   143,   202,   146,    -1,    30,   143,   202,
     146,    -1,     3,    -1,     3,   202,    -1,    37,   143,   202,
     146,   140,   169,   144,    -1,   170,    -1,   169,   170,    -1,
      38,    71,   202,   125,   162,    -1,    38,    71,   202,   125,
      -1,    38,    70,   202,   125,   162,    -1,    38,    70,   202,
     125,    -1,    38,    68,   202,   125,   162,    -1,    38,    68,
     202,   125,    -1,    38,   129,   202,   125,   162,    -1,    38,
     129,   202,   125,    -1,    38,   130,   202,   125,   162,    -1,
      38,   130,   202,   125,    -1,    38,    75,   116,   125,   162,
      -1,    38,    75,   116,   125,    -1,    38,    76,   116,   125,
     162,    -1,    38,    76,   116,   125,    -1,    38,   116,   125,
     162,    -1,    38,   116,   125,    -1,    38,   202,   125,   162,
      -1,    38,   202,   125,    -1,    39,   125,   162,    -1,    39,
     125,    -1,     7,   161,     9,   143,   172,   146,   161,    -1,
      -1,   202,    -1,     1,    -1,   193,   108,   174,   140,   177,
     144,    -1,   193,   114,   174,   140,   177,   144,    -1,   193,
     108,   174,   145,    -1,   193,   114,   174,   145,    -1,   193,
     108,   174,   140,   144,    -1,   193,   114,   174,   140,   144,
      -1,    40,   175,    -1,    -1,   176,    -1,   175,   122,   176,
      -1,    98,    -1,   103,    -1,    25,    98,    -1,    25,   103,
      -1,    24,    98,    -1,    24,   103,    -1,   188,    -1,   180,
      -1,   181,    -1,   158,    -1,   177,   188,    -1,   177,   180,
      -1,   177,   181,    -1,   177,   158,    -1,    98,    -1,   103,
      -1,   134,    98,    -1,   134,   103,    -1,    -1,   178,    -1,
      24,   185,   145,    -1,    24,   140,   186,   144,    -1,    25,
     185,   145,    -1,    25,   140,   186,   144,    -1,    25,   140,
     144,    -1,    42,   178,    98,   145,    -1,    42,    98,   145,
      -1,    42,   178,    98,   123,   202,   145,    -1,    42,    98,
     123,   202,   145,    -1,    42,   178,    98,   143,   172,   146,
     145,    -1,   179,   101,   145,    -1,   179,   101,   123,   202,
     145,    -1,   179,   101,   143,   172,   146,   145,    -1,   178,
      98,   145,    -1,   178,    98,   123,   202,   145,    -1,   178,
      98,   143,   172,   146,   145,    -1,    98,   145,    -1,    98,
     123,   202,   145,    -1,   182,    -1,   158,    -1,   101,    -1,
     101,   103,    -1,   184,    -1,   185,   122,   184,    -1,   183,
      -1,   186,   183,    -1,    98,   143,    -1,    82,   143,    -1,
     102,    -1,   193,   187,   172,   146,   190,   196,   160,    -1,
     193,   178,   187,   172,   146,   190,   160,    -1,   193,   187,
     172,   146,   190,   196,   145,    -1,   193,   178,   187,   172,
     146,   190,   145,    -1,   194,   103,   143,   172,   146,   190,
     196,   160,    -1,   194,   178,   103,   143,   172,   146,   190,
     160,    -1,   194,   103,   143,   172,   146,   190,   196,   145,
      -1,   194,   178,   103,   143,   172,   146,   190,   145,    -1,
     103,   143,   172,   146,   190,   196,   160,    -1,   178,   103,
     143,   172,   146,   190,   160,    -1,   125,   191,    -1,    -1,
     192,    -1,   191,   122,   192,    -1,    98,   143,   172,   146,
      -1,   103,   143,   172,   146,    -1,    -1,   194,    -1,   195,
      -1,   194,   195,    -1,    24,    -1,    42,    -1,    26,    -1,
      27,    -1,    25,    -1,    45,    -1,    46,    -1,     4,   179,
      -1,    -1,    14,   187,   172,   146,   196,   160,    -1,   178,
      14,   187,   172,   146,   160,    -1,   194,    14,   187,   172,
     146,   196,   160,    -1,   194,   178,    14,   187,   172,   146,
     160,    -1,    14,   103,   143,   172,   146,   196,   160,    -1,
     178,    14,   103,   143,   172,   146,   160,    -1,   194,    14,
     103,   143,   172,   146,   196,   160,    -1,   194,   178,    14,
     103,   143,   172,   146,   160,    -1,   202,   122,   202,    -1,
     202,   122,    -1,   201,    -1,   200,   122,   201,    -1,   200,
     122,    -1,   204,   125,   202,    -1,    98,   125,   202,    -1,
     103,   125,   202,    -1,   204,    -1,   111,    -1,   199,    -1,
     143,   200,   146,    -1,   103,    -1,   179,    99,    -1,   179,
     104,    -1,   178,    98,    -1,     5,   178,    98,    -1,     5,
      98,    -1,     5,   179,    99,    -1,     5,   143,   199,   146,
      -1,   154,    -1,    98,    -1,   105,    -1,    18,    -1,   106,
      -1,    19,   202,    21,   202,    10,   143,   202,   146,    -1,
     202,    50,   202,    -1,   202,    51,   202,    -1,   202,    52,
     202,    -1,   202,    53,   202,    -1,   202,    54,   202,    -1,
     202,    55,   202,    -1,   202,    56,   202,    -1,   202,    57,
     202,    -1,   202,    58,   202,    -1,   202,    59,   202,    -1,
     202,   123,   202,    -1,    77,   202,    -1,    81,   202,    -1,
     202,    78,    98,    -1,   202,    78,   103,    -1,    82,   202,
      -1,    60,   202,    -1,    63,   202,    -1,    61,   202,    -1,
      62,   202,    -1,    64,   202,    -1,    65,   202,    -1,    92,
     202,    -1,    93,   202,    -1,    88,   202,    -1,    89,   202,
      -1,    90,   202,    -1,    91,   202,    -1,   202,   124,   202,
     125,   202,    -1,    48,   202,    -1,   202,    48,    -1,    49,
     202,    -1,   202,    49,    -1,   202,   143,   172,   146,    -1,
     115,   143,   172,   146,    -1,   102,   172,   146,    -1,   101,
      -1,   202,    66,   202,    -1,   202,    67,   202,    -1,   202,
     127,   202,    -1,   202,   126,   202,    -1,   202,   128,   202,
      -1,   202,    75,   116,    -1,   202,    76,   116,    -1,   202,
      75,   112,    -1,   202,    75,   113,    -1,   202,    75,   117,
      -1,   202,   130,   202,    -1,   202,   129,   202,    -1,   202,
      72,   202,    -1,   202,    68,   202,    -1,   202,    73,   202,
      -1,   202,    74,   202,    -1,   202,    69,   202,    -1,   202,
      70,   202,    -1,   202,    71,   202,    -1,   202,    80,   202,
      -1,   202,    79,   202,    -1,   202,   131,   202,    -1,   202,
     132,   202,    -1,   202,   133,   202,    -1,   202,   135,   202,
      -1,   202,   134,   202,    -1,   132,   202,    -1,   137,   202,
      -1,   139,   202,    -1,   138,   202,    -1,    83,    98,   143,
     172,   146,    -1,    83,   103,   143,   172,   146,    -1,    84,
     202,    -1,   100,    -1,   202,   141,   202,   147,    -1,   202,
     140,   202,   144,    -1,   202,   142,   202,    -1,   202,   119,
      -1,   143,   202,   146,    -1,   143,   146,    -1,    14,   143,
     172,   146,   196,   160,    -1,   178,    14,   143,   172,   146,
     160,    -1,   194,    14,   143,   172,   146,   196,   160,    -1,
     194,   178,    14,   143,   172,   146,   160,    -1,   118,    -1,
      94,    -1,    22,   202,    -1,    23,   202,    -1,   107,   143,
     202,   146,    -1,   110,    -1,   110,   203,    -1,    96,    -1,
      95,    -1,   203,    -1,   109,    -1,    97,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1454,  1454,  1455,  1459,  1462,  1465,  1473,  1477,  1481,
    1484,  1492,  1498,  1504,  1511,  1536,  1538,  1543,  1556,  1557,
    1563,  1568,  1571,  1576,  1579,  1584,  1589,  1595,  1602,  1607,
    1615,  1620,  1628,  1631,  1634,  1640,  1643,  1646,  1649,  1655,
    1660,  1663,  1669,  1672,  1678,  1681,  1686,  1689,  1694,  1696,
    1698,  1700,  1706,  1707,  1711,  1730,  1736,  1738,  1741,  1744,
    1747,  1750,  1753,  1756,  1759,  1762,  1765,  1768,  1771,  1774,
    1777,  1780,  1781,  1788,  1791,  1794,  1795,  1800,  1801,  1812,
    1814,  1816,  1821,  1823,  1827,  1837,  1841,  1849,  1854,  1860,
    1865,  1871,  1876,  1882,  1887,  1893,  1898,  1904,  1908,  1913,
    1917,  1922,  1926,  1931,  1936,  1942,  1946,  1953,  1971,  1972,
    1973,  1977,  1982,  1987,  1994,  2001,  2008,  2018,  2021,  2027,
    2030,  2037,  2040,  2043,  2046,  2049,  2052,  2058,  2062,  2067,
    2072,  2077,  2081,  2086,  2091,  2112,  2115,  2118,  2121,  2128,
    2129,  2135,  2138,  2144,  2147,  2150,  2156,  2160,  2163,  2168,
    2171,  2186,  2193,  2200,  2218,  2225,  2232,  2250,  2256,  2262,
    2265,  2274,  2279,  2287,  2290,  2297,  2300,  2307,  2310,  2313,
    2319,  2329,  2343,  2349,  2362,  2372,  2384,  2389,  2397,  2400,
    2409,  2412,  2418,  2421,  2428,  2431,  2438,  2439,  2444,  2445,
    2453,  2454,  2455,  2456,  2457,  2458,  2459,  2463,  2474,  2479,
    2484,  2493,  2504,  2520,  2525,  2534,  2545,  2562,  2564,  2579,
    2584,  2591,  2596,  2598,  2600,  2604,  2606,  2608,  2610,  2612,
    2614,  2627,  2640,  2644,  2652,  2662,  2679,  2717,  2720,  2727,
    2729,  2731,  2733,  2735,  2738,  2741,  2744,  2747,  2750,  2753,
    2756,  2759,  2762,  2765,  2774,  2776,  2778,  2781,  2784,  2786,
    2798,  2801,  2813,  2816,  2819,  2822,  2842,  2862,  2881,  2895,
    2909,  2923,  2927,  2930,  2933,  2936,  2939,  3018,  3025,  3029,
    3035,  3036,  3037,  3038,  3039,  3040,  3043,  3046,  3050,  3053,
    3055,  3056,  3057,  3058,  3059,  3060,  3061,  3062,  3063,  3064,
    3065,  3066,  3067,  3068,  3069,  3070,  3071,  3077,  3078,  3079,
    3109,  3114,  3119,  3127,  3132,  3133,  3134,  3137,  3140,  3153,
    3154,  3158,  3165,  3173,  3185,  3189,  3192,  3195,  3198,  3204,
    3207,  3214,  3215,  3216,  3217,  3218
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"", "\"my\"",
  "\"do\"", "\"try\"", "\"throw\"", "\"catch\"", "\"where\"", "\"while\"",
  "\"if\"", "\"for\"", "\"sub\"", "\"thread_exit\"", "\"break\"",
  "\"continue\"", "\"%%\"", "\"find\"", "\"foreach\"", "\"in\"",
  "\"delete\"", "\"remove\"", "\"private\"", "\"public\"",
  "\"synchronized\"", "\"deprecated\"", "\"context\"", "\"sortBy\"",
  "\"sortDescendingBy\"", "\"subcontext\"", "\"const\"", "\"summarize\"",
  "\"by\"", "\"our\"", "\"rethrow\"", "\"switch\"", "\"case\"",
  "\"default\"", "\"inherits\"", "\"else\"", "\"static\"", "\"namespace\"",
  "\"module\"", "\"final\"", "\"abstract\"", "\"unreference\"",
  "\"++ operator\"", "\"-- operator\"", "\"+= operator\"",
  "\"-= operator\"", "\"&= operator\"", "\"|= operator\"",
  "\"%= operator\"", "\"*= operator\"", "\"/= operator\"",
  "\"^= operator\"", "\"<<= operator\"", "\">>= operator\"", "\"unshift\"",
  "\"push\"", "\"pop\"", "\"shift\"", "\"chomp\"", "\"trim\"",
  "\"&& operator\"", "\"|| operator\"", "\"== operator\"",
  "\"!= operator\"", "\"<= operator\"", "\">= operator\"",
  "\"<=> operator\"", "\"=== operator\"", "\"!== operator\"",
  "\"=~ operator\"", "\"!~ operator\"", "\"exists\"", "\"instanceof\"",
  "\">> operator\"", "\"<< operator\"", "\"elements\"", "\"keys\"",
  "\"new\"", "\"background\"", "\"on_exit\"", "\"on_success\"",
  "\"on_error\"", "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"",
  "\"splice\"", "\"extract\"", "\"$#\"", "\"integer value\"",
  "\"floating-point value\"", "\"arbitrary-precision number\"",
  "\"identifier\"", "\"variable reference\"", "\"backquote expression\"",
  "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"simple class declaration\"",
  "\"date/time value\"", "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'&'",
  "'|'", "'^'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'", "';'", "')'",
  "']'", "$accept", "top_level_commands", "top_level_command",
  "module_decls", "module_decl", "ppub", "gvardecl", "top_namespace_decl",
  "namespace_decls", "namespace_decl", "unscoped_const_decl",
  "scoped_const_decl", "block", "statement_or_block", "statements",
  "optname", "statement", "context_mods", "context_mod",
  "return_statement", "switch_statement", "case_block", "case_code",
  "try_statement", "myexp", "class_def", "inheritance_list",
  "superclass_list", "superclass", "class_attributes", "uncqtypedef",
  "qtypedef", "private_member_list", "public_member_list", "classvardecl",
  "member2", "member", "member_list", "member_list2", "ident_openparen",
  "inline_methoddef", "outofline_methoddef", "base_constructor_list",
  "base_constructors", "base_constructor", "nsc_modifiers",
  "method_modifiers", "method_modifier", "return_value", "sub_def",
  "scoped_sub_def", "list", "hash", "hash_element", "exp", "string",
  "scalar", YY_NULL
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,    44,    61,    63,    58,    38,   124,    94,    60,
      62,    43,    45,    37,    42,    47,   377,   126,    92,    33,
     123,    91,    46,    40,   125,    59,    41,    93
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   148,   149,   149,   150,   150,   150,   150,   150,   150,
     150,   150,   150,   150,   150,   151,   151,   152,   153,   153,
     154,   154,   154,   154,   154,   154,   154,   155,   155,   155,
     156,   156,   157,   157,   157,   157,   157,   157,   157,   157,
     158,   158,   159,   159,   160,   160,   161,   161,   162,   162,
     162,   162,   163,   163,   164,   164,   164,   164,   164,   164,
     164,   164,   164,   164,   164,   164,   164,   164,   164,   164,
     164,   164,   164,   164,   164,   164,   164,   165,   165,   166,
     166,   166,   167,   167,   168,   169,   169,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   171,   172,   172,
     172,   173,   173,   173,   173,   173,   173,   174,   174,   175,
     175,   176,   176,   176,   176,   176,   176,   177,   177,   177,
     177,   177,   177,   177,   177,   178,   178,   178,   178,   179,
     179,   180,   180,   181,   181,   181,   182,   182,   182,   182,
     182,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   184,   184,   185,   185,   186,   186,   187,   187,   187,
     188,   188,   188,   188,   189,   189,   189,   189,   189,   189,
     190,   190,   191,   191,   192,   192,   193,   193,   194,   194,
     195,   195,   195,   195,   195,   195,   195,   196,   196,   197,
     197,   197,   197,   198,   198,   198,   198,   199,   199,   200,
     200,   200,   201,   201,   201,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   203,
     203,   204,   204,   204,   204,   204
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     4,     1,     1,     2,     4,     0,     1,
       4,     3,     4,     3,     4,     4,     5,     5,     3,     4,
       1,     2,     1,     1,     1,     1,     1,     2,     1,     1,
       5,     6,     5,     6,     3,     2,     1,     1,     1,     1,
       2,     2,     0,     1,     2,     5,     1,     2,     3,     2,
       2,     2,     3,    11,     7,     5,     7,     5,     7,     9,
       7,     2,     2,     2,     2,     1,     2,     0,     2,     4,
       4,     4,     1,     2,     7,     1,     2,     5,     4,     5,
       4,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     4,     3,     4,     3,     3,     2,     7,     0,     1,
       1,     6,     6,     4,     4,     5,     5,     2,     0,     1,
       3,     1,     1,     2,     2,     2,     2,     1,     1,     1,
       1,     2,     2,     2,     2,     1,     1,     2,     2,     0,
       1,     3,     4,     3,     4,     3,     4,     3,     6,     5,
       7,     3,     5,     6,     3,     5,     6,     2,     4,     1,
       1,     1,     2,     1,     3,     1,     2,     2,     2,     1,
       7,     7,     7,     7,     8,     8,     8,     8,     7,     7,
       2,     0,     1,     3,     4,     4,     0,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     6,
       6,     7,     7,     7,     7,     8,     8,     3,     2,     1,
       3,     2,     3,     3,     3,     1,     1,     1,     3,     1,
       2,     2,     2,     3,     2,     3,     4,     1,     1,     1,
       1,     1,     8,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     3,     3,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     5,     2,     2,     2,     2,     4,     4,     3,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     2,     2,
       5,     5,     2,     1,     4,     4,     3,     2,     3,     2,
       6,     6,     7,     7,     1,     1,     2,     2,     4,     1,
       2,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,   139,   139,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,   230,   139,   139,   139,   139,   190,
     194,   192,   193,    52,    77,     0,    52,     0,     0,   191,
       0,   195,   196,   139,   139,   139,   139,   139,   139,   139,
     139,   139,   139,   139,     0,   139,     0,     0,     0,   139,
     139,   139,   139,   139,   139,   315,   322,   321,   325,   228,
     303,   269,     0,   219,   229,   231,     0,   324,   319,   216,
       0,   314,    14,   139,     0,   139,   139,   139,     0,   139,
       0,     2,     0,   227,    12,     8,     7,    10,     0,    75,
      56,     6,   140,     0,     9,     0,   187,   188,     4,     5,
     217,     0,   323,   215,    76,     0,   194,   219,   140,     0,
      83,   224,   136,   139,   140,     0,   219,     0,    47,     0,
      46,     0,     0,   139,   139,     0,     0,     0,   169,     0,
       0,     0,    72,    73,    74,     0,     0,   316,   317,     0,
      53,     0,     0,     0,     0,     0,    57,   139,     0,   262,
     264,   249,   251,   252,   250,   253,   254,   244,   245,   248,
       0,     0,   302,    59,    60,    61,   257,   258,   259,   260,
     255,   256,   110,     0,   109,     0,   139,   320,     0,   296,
     137,   138,   297,   299,   298,    49,     0,    48,   228,   219,
     309,     0,   209,     0,   215,     1,     3,   139,    71,     0,
     222,     0,   220,   221,     0,   118,   118,     0,   194,   135,
     136,     0,   189,   263,   265,   139,   139,   139,   139,   139,
     139,   139,   139,   139,   139,   139,   139,   139,   139,   139,
     139,   139,   139,   139,     0,     0,     0,   139,   139,   307,
     208,   139,   139,   139,   139,   139,   139,   139,   139,   139,
     139,   139,   139,   139,   139,   139,     0,    54,     0,     0,
       0,   217,     0,   223,   225,     0,    45,     0,     0,     0,
      58,     0,     0,     0,   168,   167,     0,     0,     0,   139,
       0,     0,     0,   139,     0,     0,     0,    62,    78,   139,
     139,   139,     0,     0,     0,    15,     0,     0,   268,     0,
       0,     0,    11,    50,    51,   139,   139,   211,   218,   308,
     139,    23,    21,   139,   140,     0,     0,     0,     0,     0,
     186,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   270,   271,   283,   286,   287,   288,   282,   284,   285,
     277,   278,   275,   279,   276,   246,   247,   290,   289,   207,
     243,     0,   273,   272,   274,   281,   280,   291,   292,   293,
     295,   294,     0,     0,   306,     0,     0,   226,     0,    44,
     139,     0,     0,     0,     0,     0,   198,   198,     0,   139,
     139,   139,     0,   139,   139,   139,     0,     0,     0,     0,
     139,    13,    16,     0,     0,   181,   318,   267,   213,   214,
       0,     0,   210,     0,   212,   217,    22,    20,    25,    24,
       0,     0,     0,     0,     0,   136,    29,     0,    38,   186,
      30,    33,    32,    34,     0,    39,   187,    35,    36,     0,
       0,   121,   122,   117,   119,   186,   113,   186,   114,     0,
       0,     0,     0,     0,     0,     0,     0,   139,   305,   304,
     266,     0,     0,     0,    67,    65,     0,   198,   139,     0,
       0,     0,     0,     0,     0,    77,     0,     0,     0,    40,
      42,     0,     0,     0,   300,   301,     0,    55,   198,    26,
       0,     0,     0,   181,     0,    37,    27,    31,     0,     0,
       0,   125,   126,   123,   124,     0,   190,   194,     0,   115,
     130,   186,   128,   129,   127,     0,   187,   116,   186,     0,
     198,   198,   181,     0,     0,     0,     0,   261,     0,     0,
       0,     0,     0,   140,   197,   310,   199,   139,     0,    41,
      43,     0,    79,    80,    81,     0,   139,     0,     0,    85,
      17,     0,     0,   180,   182,     0,     0,   311,   200,     0,
       0,     0,   120,   161,   139,   163,     0,     0,   139,     0,
     111,   134,   132,   133,   131,   135,     0,     0,   112,   198,
       0,     0,   198,     0,     0,     0,   181,    68,   107,    66,
       0,   203,     0,    70,    64,   139,   139,   139,   139,     0,
       0,     0,   139,   139,     0,     0,    84,    86,     0,     0,
       0,   178,   204,   179,   181,   162,     0,     0,   135,   160,
     140,     0,   159,   165,   139,     0,   141,   145,   139,   143,
       0,     0,     0,   312,   201,     0,     0,   313,   202,     0,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   135,     0,   139,   157,
       0,     0,   142,   166,   164,   144,     0,   181,   205,   176,
     174,   206,   177,   175,    69,    77,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   184,   185,   139,   147,     0,
       0,   139,     0,   154,   139,     0,   151,   181,   198,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   139,     0,
     146,   158,     0,     0,     0,     0,     0,     0,    63,   149,
       0,     0,   155,     0,   152,     0,   173,   171,   172,   170,
     148,     0,   156,   153,   150
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    80,    81,   294,   295,    82,    83,    84,   429,   430,
     619,    86,   118,   119,   186,   141,   120,   142,   288,    88,
      89,   548,   549,    90,   173,    91,   323,   443,   444,   511,
     108,    93,   512,   513,   622,   623,   565,   566,   624,   131,
     514,    94,   488,   553,   554,    95,   109,    97,   469,    98,
      99,   100,   191,   192,   101,   102,   103
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -474
static const yytype_int16 yypact[] =
{
    4789,  -116,  5325,   364,  5071,  5071,  5697,   -67,   -59,   -28,
       4,  -101,   -12,    -3,  -474,  5697,  5697,  5697,  5697,  -474,
     162,  -474,  -474,    52,  -474,   157,    52,     7,    53,  -474,
      58,  -474,  -474,  5697,  5697,  5697,  5697,  5697,  5697,  5697,
    5697,  5697,  5697,  5697,   198,  5697,  5071,  5071,  5071,  5697,
    5697,  5697,  5697,  5697,  5697,  -474,  -474,  -474,  -474,    68,
    -474,  -474,   986,    10,  -474,  -474,    66,  -474,    73,  -474,
     114,  -474,  -474,  5697,   233,  5697,  5697,  5697,  5071,  5199,
    1336,  -474,   224,  -474,  -474,  -474,  -474,  -474,    89,  -474,
    -474,  -474,    77,   339,  -474,    97,    43,  -474,  -474,  -474,
    -474,  7044,  -474,  -474,  -474,   128,   238,    91,    28,   634,
    8346,   199,  -474,  5697,   186,   200,    -4,  4357,  -474,   299,
    -474,   303,  7077,  5697,  5697,  1195,   177,   185,  -474,   187,
     986,   986,  -474,  -474,  -474,  5891,  5987,   218,   218,   360,
    -474,   208,  4930,   248,   254,   230,  -474,  5697,   287,   396,
     396,  8346,  8346,   218,   218,   218,   218,   678,   218,   218,
     243,   252,   218,  -474,  -474,  -474,  8346,  8346,  8346,  8346,
    8346,  8346,  -474,   251,  8346,   986,  5697,  -474,   986,   218,
    -474,  -474,   218,   218,   218,  -474,  4501,  -474,    39,   265,
    -474,   -66,  -474,  6120,   282,  -474,  -474,   391,  -474,   240,
    -474,   266,  -474,  -474,   333,   385,   385,   358,  -474,  -474,
     274,    16,  -474,  -474,  -474,  5697,  5697,  5697,  5697,  5697,
    5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,
    5697,  5697,  5697,  5697,   505,   310,   399,  5697,  5697,  -474,
    5575,  5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,  5697,
    5697,  5697,  5697,  5697,  5697,  5697,   986,  -474,   286,   293,
     423,   304,  8346,  -474,  -474,   986,  -474,  4645,   306,   322,
    -474,  6153,  6252,   321,  -474,  -474,   986,   305,   323,  5697,
     334,   365,   368,  5697,   344,   352,   356,  -474,  -474,  5697,
    5697,  5697,  6285,   383,   -72,  -474,   986,   986,  -474,   370,
    6384,   371,  -474,  -474,  -474,  5697,  5697,   540,  -474,  -474,
    5697,   377,   410,  5697,   442,   450,   367,   986,   986,   986,
     330,  -474,   167,   459,   463,   381,   986,   986,   986,   429,
     398,  8379,  8379,  8379,  8379,  8379,  8379,  8379,  8379,  8379,
    8379,  8500,  8500,   678,   678,   678,   678,   678,   678,   678,
    -474,  -474,  -474,  -474,  -474,  -474,  -474,   797,   797,  8379,
     828,  7863,  8576,  8576,  8576,   678,   678,   993,   993,   635,
     218,   218,  7830,  6020,  -474,   374,   407,  -474,   380,  -474,
    5697,   986,  5071,  5071,  1195,   382,   538,   538,  5795,  5697,
    5697,  5697,  6417,  5697,  5697,  5697,  7175,  7208,  6516,   420,
    5697,  -474,  -474,   416,   422,   -35,  -474,  -474,  8379,  8379,
     462,   465,  -474,   282,  8379,   438,  -474,  -474,  -474,  -474,
     986,   445,   451,   469,   461,   473,  -474,   474,  -474,   458,
    -474,  -474,  -474,  -474,    41,  -474,   719,  -474,  -474,   536,
     542,  -474,  -474,   519,  -474,   136,  -474,   161,  -474,   986,
     496,   498,   506,   508,   986,   986,   986,  5697,  -474,  -474,
    -474,   509,  6549,   518,  -474,   612,   510,   538,   -37,   525,
     525,   528,  6648,  7306,  7339,  -474,  6681,  6780,  6813,  -474,
    -474,   640,    78,  7437,  -474,  -474,   564,  -474,   538,  -474,
     529,   525,   525,   557,   986,  -474,  -474,  -474,   471,   483,
      45,  -474,  -474,  -474,  -474,   167,   -47,    30,   590,  -474,
    -474,   378,  -474,  -474,  -474,   211,   587,  -474,   389,   545,
     538,   538,   557,   986,   558,   559,   562,  8467,   567,  5071,
    5071,   986,   525,  -474,  -474,  -474,  -474,  5697,  5071,  -474,
    -474,  4930,  -474,  -474,  -474,   560,  5453,   584,    40,  -474,
    -474,   570,   572,   595,  -474,   525,   525,  -474,  -474,   525,
     579,   507,  -474,   625,   308,  -474,   -21,   631,   236,   -18,
    -474,  -474,  -474,  -474,  -474,   185,   204,   986,  -474,   538,
     525,   525,   538,   585,   525,   525,   557,  -474,  -474,  -474,
     588,  -474,  6912,  -474,  -474,  5697,  5697,  5697,  5697,   614,
     622,   616,  5697,  5697,  7959,  1477,  -474,  -474,   986,   986,
     564,  -474,  -474,  -474,   557,  -474,   717,   166,   -20,  -474,
     652,   650,  -474,  -474,   250,   651,  -474,  -474,   454,  -474,
     986,   607,   525,  -474,  -474,   523,   525,  -474,  -474,   532,
    5071,  -474,  6945,  7992,  8088,  8121,   630,   637,  1621,  8217,
    8250,  1765,  1909,   613,   620,  -474,    56,   665,  5697,  -474,
      13,   184,  -474,  -474,  -474,  -474,   621,   557,  -474,  -474,
    -474,  -474,  -474,  -474,  -474,  -474,  2053,  2197,  2341,  2485,
    2629,  2773,  2917,  3061,  3205,  -474,  -474,  5697,  -474,   223,
    7470,  5697,   986,  -474,  5697,   986,  -474,   557,   538,  4930,
    3349,  3493,  3637,  3781,  3925,  4069,  4213,  7568,  5697,   986,
    -474,  -474,  7601,   626,  7699,   627,   533,   541,  -474,  -474,
    7732,   628,  -474,   636,  -474,   638,  -474,  -474,  -474,  -474,
    -474,   639,  -474,  -474,  -474
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -474,  -474,   691,  -474,   485,  -474,  -311,  -309,  -474,   351,
       1,  -299,   155,    17,  -100,   756,    18,  -473,  -474,  -474,
    -474,  -474,   237,  -474,   617,  -297,   580,  -474,   283,   342,
       3,     2,  -144,  -110,  -474,  -459,   168,   289,   231,  -180,
     -99,  -295,  -435,  -474,   188,  -235,    12,   -89,  -230,  -275,
    -274,  -105,  -474,   493,    -2,   733,   -51
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -187
static const yytype_int16 yytable[] =
{
     110,    85,   541,    92,   122,   115,   114,   212,   261,   427,
    -136,   428,    96,   135,   136,   137,   138,   267,    87,   318,
     212,   432,   121,   433,  -136,   435,   293,   327,   194,   104,
     329,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   258,   162,   132,   437,   438,   166,   167,   168,
     169,   170,   171,  -135,   563,   498,   307,   207,   559,   561,
     174,   209,   567,   163,   164,   165,   112,    19,   208,    21,
      22,   179,   401,   182,   183,   184,   123,   193,   546,   547,
     308,    85,  -135,    92,   124,    29,   126,   582,    31,    32,
     486,   199,    96,   564,  -136,  -136,   187,    74,    87,   211,
    -136,   625,   127,   658,   625,  -136,   128,   129,  -136,  -136,
     487,   262,   260,  -136,  -136,   125,   546,   547,   427,   330,
     428,   271,   272,   174,   626,   659,   200,   629,   174,   174,
     432,   563,   433,   133,   435,   187,   691,  -135,  -135,   265,
     204,   209,   134,  -135,   201,   292,   210,   130,   330,   455,
     140,   639,   146,   175,   437,   438,   692,   470,   693,   287,
     506,   507,    21,    22,   305,   663,  -135,  -135,   508,   663,
     568,  -135,  -135,   174,   300,   200,   174,    74,    29,   687,
     201,    31,    32,    68,   606,   506,   507,    21,    22,  -136,
    -136,   439,   440,   508,   139,  -136,   147,   -19,   148,   315,
     314,   688,   699,    29,   304,   205,    31,    32,   415,   176,
     515,   206,   515,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   698,   185,   198,   357,   358,   532,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   174,   143,   413,   178,   555,   197,
     144,   616,   716,   174,   656,   441,   213,   214,   508,   112,
     442,   130,   185,   -19,   174,   616,   515,   388,   617,  -136,
     509,   392,   508,   515,   263,   304,   126,   396,   397,   398,
     580,   581,   617,   126,   174,   174,   160,  -135,  -135,   264,
      74,   161,   127,   408,   409,   517,   128,   694,   414,   575,
     268,   262,   269,   128,   112,   174,   174,   174,   318,   327,
     274,   431,   126,   434,   174,   174,   174,   695,   275,   696,
     276,   180,   436,   616,   618,   577,   181,   239,   127,   112,
     508,   303,   128,   316,   424,    74,   708,   212,   618,   632,
     617,   283,   635,   112,    19,    20,    21,    22,   253,   254,
     255,   256,    25,  -136,  -136,   -18,   709,   572,   710,  -136,
      74,   289,    29,   291,   572,    31,    32,   290,   462,   174,
     627,   455,   174,   317,    74,   293,   296,   472,   473,   474,
     306,   476,   477,   478,   662,   297,   630,   298,   483,   464,
     465,   573,   506,   507,    21,    22,   618,   310,   573,   319,
     508,   112,   574,   506,   507,    21,    22,   328,   174,   574,
      29,   508,   303,    31,    32,   322,   354,   212,   209,   317,
     431,    29,   434,   425,    31,    32,   326,   376,   202,   500,
     126,   436,    74,   203,  -187,  -187,   510,   174,   510,   380,
     377,   386,   174,   174,   174,   527,   127,   516,   281,   516,
     128,   325,   111,   282,    74,   381,   384,   112,   717,   387,
     534,   533,   424,   320,   426,  -135,  -135,   389,   321,   616,
    -135,  -135,    19,    20,    21,    22,   508,   393,   390,   311,
      25,   391,   174,   -18,   312,   394,   617,   355,    74,   395,
      29,   326,   356,    31,    32,   652,   400,   113,  -136,  -136,
     420,   126,   571,  -136,  -136,   239,   405,   407,   576,   571,
     460,   174,   570,   516,   449,    74,   461,   127,   467,   174,
     516,   128,   453,   578,   313,   592,   253,   254,   255,   256,
     416,   456,   468,   126,   604,   417,   588,   589,   681,   418,
     454,   684,   618,   126,   419,   593,   209,   112,   594,   127,
     482,   425,   484,   128,   129,   126,   621,   620,   485,   127,
     621,   620,   454,   128,   316,   174,   700,   701,   702,   703,
     704,   127,   705,   706,   489,   128,   325,   305,    74,   126,
     306,   491,    74,   642,   643,   644,   645,   492,   665,   445,
     649,   650,   496,   447,   446,   127,   174,   174,   448,   128,
     453,    19,   208,    21,    22,   493,   494,   350,   351,   495,
     657,   352,   353,   187,   535,   536,   621,   620,   174,    29,
     621,   620,    31,    32,   501,    56,    57,    58,   410,   502,
     503,   505,   520,   411,   521,   504,   557,   558,   259,    67,
      68,   523,   522,   530,   487,   531,   690,   674,    19,   208,
      21,    22,   551,   117,   529,   117,   187,   552,   669,   187,
     304,   537,   117,   117,   545,   556,    29,   672,   726,    31,
      32,   117,   486,   213,   214,   707,   728,   591,   143,   712,
     174,   579,   714,   174,   187,   187,   187,   187,   187,   304,
     187,   187,   304,   595,   584,   585,   720,   174,   586,   605,
     611,   612,   587,   608,   613,   609,   718,   610,   304,   304,
     304,   304,   304,   304,   304,   614,   213,   214,   615,   281,
     646,   636,   209,   499,   640,   633,   634,   112,   647,   637,
     638,   648,   273,    19,   208,    21,    22,   277,   278,   567,
     660,   661,   563,   667,   239,   679,   236,   237,   238,   685,
     185,    29,   680,   689,    31,    32,   686,   697,    74,   251,
     252,   196,   723,   725,   731,   253,   254,   255,   256,   402,
     497,   732,   145,   733,   734,   607,   324,   668,   562,   518,
     670,   671,   299,   664,   673,   301,   569,   239,   655,   628,
     412,   177,     0,   185,     0,     0,   185,   303,     0,   248,
     249,   250,   251,   252,     0,     0,     0,   209,   253,   254,
     255,   256,   210,     0,     0,     0,     0,     0,     0,     0,
       0,   185,   185,   185,   185,   185,   303,   185,   185,   303,
       0,     0,     0,     0,     0,   213,   214,     0,     0,     0,
       0,     0,     0,    74,     0,   303,   303,   303,   303,   303,
     303,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   727,   729,   375,     0,     0,   213,   214,     0,     0,
       0,     0,   378,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   385,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,     0,
       0,     0,     0,   403,   404,     0,   239,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   248,   249,
     250,   251,   252,     0,   421,   422,   423,   253,   254,   255,
     256,     0,     0,   450,   451,   452,     0,   239,     0,     0,
       0,   241,   242,     0,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     3,     0,     0,     0,     0,     0,     0,   463,     0,
     105,   466,     0,     0,    14,    15,     0,     0,    17,    18,
      19,   106,    21,    22,     0,     0,     0,     0,     0,     0,
       0,   -18,     0,     0,     0,     0,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,   490,     0,     0,
       0,   213,   214,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,   519,    42,    43,    44,
      45,   524,   525,   526,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,  -139,    60,    61,    62,   107,
    -139,    64,    65,    66,     0,    67,    68,    69,     0,     0,
       0,    70,     0,     0,    71,     0,     0,     0,     0,     0,
       0,   560,   239,     0,     0,     0,     0,     0,    73,     0,
      74,     0,     0,    75,    76,    77,   250,   251,   252,    79,
       0,     0,  -108,   253,   254,   255,   256,     0,     0,     0,
     583,     0,     0,     0,     0,     0,     0,     0,   590,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   631,     0,   172,     0,     0,     0,
       3,     0,     0,     0,     0,     0,     0,     0,     0,   105,
       0,     0,     0,    14,    15,     0,     0,    17,    18,    19,
     106,    21,    22,     0,     0,   653,   654,     0,     0,     0,
     -18,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,   666,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
       0,     0,     0,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   107,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,   713,
      70,     0,   715,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   721,    73,     0,    74,
       0,     0,    75,    76,    77,     0,   195,     1,    79,     2,
    -108,     3,     4,     5,     6,     0,     0,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,    22,    23,     0,     0,    24,    25,    26,
       0,   -18,    27,    28,     0,     0,     0,     0,    29,  -186,
      30,    31,    32,     0,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,  -139,    60,    61,    62,    63,
    -139,    64,    65,    66,  -186,    67,    68,    69,     0,     0,
    -186,    70,     0,     0,    71,     0,    72,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    73,     0,
      74,     0,     0,    75,    76,    77,    78,     0,     1,    79,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,  -106,  -106,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,  -106,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,  -102,
    -102,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,  -102,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,  -104,  -104,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,  -104,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   105,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   106,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -18,    27,    28,  -105,  -105,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,   116,  -139,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,   117,
       0,     0,    79,  -105,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   105,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   106,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -18,    27,
      28,   -92,   -92,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,  -139,    60,    61,    62,   116,  -139,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,    74,     0,     0,
      75,    76,    77,   117,     0,     0,    79,   -92,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,   -90,   -90,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,   -90,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,   -88,
     -88,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,   -88,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,   -98,   -98,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,   -98,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   105,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   106,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -18,    27,    28,  -100,  -100,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,   116,  -139,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,   117,
       0,     0,    79,  -100,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   105,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   106,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -18,    27,
      28,  -101,  -101,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,  -139,    60,    61,    62,   116,  -139,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,    74,     0,     0,
      75,    76,    77,   117,     0,     0,    79,  -101,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,   -94,   -94,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,   -94,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,   -96,
     -96,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,   -96,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,  -103,  -103,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,  -103,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   105,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   106,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -18,    27,    28,   -91,   -91,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,   116,  -139,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,   117,
       0,     0,    79,   -91,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   105,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   106,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -18,    27,
      28,   -89,   -89,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,  -139,    60,    61,    62,   116,  -139,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,    74,     0,     0,
      75,    76,    77,   117,     0,     0,    79,   -89,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,   -87,   -87,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,   -87,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,   -97,
     -97,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,   -97,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,   -99,   -99,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,   -99,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   105,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   106,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -18,    27,    28,   -93,   -93,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,   116,  -139,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,   117,
       0,     0,    79,   -93,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   105,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   106,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -18,    27,
      28,   -95,   -95,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,  -139,    60,    61,    62,   116,  -139,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,    74,     0,     0,
      75,    76,    77,   117,     0,     0,    79,   -95,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   105,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   106,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -18,    27,    28,     0,     0,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,  -139,    60,    61,    62,
     116,  -139,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,   117,     0,     0,
      79,   266,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,     0,
       0,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     0,    74,     0,     0,    75,    76,
      77,   117,     0,     0,    79,   302,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   105,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     106,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -18,    27,    28,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   116,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     0,    74,
       0,     0,    75,    76,    77,   117,     0,     0,    79,   379,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,    20,    21,    22,    23,     0,     0,
      24,    25,    26,     0,   -18,    27,    28,     0,     0,     0,
       0,    29,  -186,    30,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,  -139,    60,
      61,    62,    63,  -139,    64,    65,    66,  -186,    67,    68,
      69,     0,     0,  -186,    70,     0,     0,    71,     0,    72,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,     0,    74,     0,     0,    75,    76,    77,    78,
       0,     1,    79,     2,     0,     3,     4,     5,     6,     0,
     284,     7,     8,     9,   105,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,   106,    21,    22,    23,   285,
     286,    24,     0,    26,     0,   -18,    27,    28,     0,     0,
       0,     0,    29,     0,     0,    31,    32,     0,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,  -139,
      60,    61,    62,   116,  -139,    64,    65,    66,     0,    67,
      68,    69,     0,     0,     0,    70,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,     0,    74,     0,     0,    75,    76,    77,
     117,     0,     1,    79,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   105,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   106,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -18,    27,    28,     0,
       0,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    -139,    60,    61,    62,   116,  -139,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,     3,    74,     0,     0,    75,    76,
      77,   117,     0,   105,    79,     0,     0,    14,    15,     0,
       0,    17,    18,    19,   106,    21,    22,     0,     0,     0,
       0,     0,     0,     0,   -18,     0,     0,     0,     0,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,     0,     0,     0,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,   188,     0,    60,
      61,    62,   189,     0,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       3,    73,     0,    74,     0,     0,    75,    76,    77,   105,
       0,     0,    79,    14,    15,   190,     0,    17,    18,    19,
     106,    21,    22,     0,     0,     0,     0,     0,     0,     0,
     -18,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
       0,     0,     0,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,     0,    60,    61,    62,   107,     0,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,     3,    74,
       0,     0,    75,    76,    77,     0,     0,   105,    79,     0,
     -82,    14,    15,     0,     0,    17,    18,    19,   106,    21,
      22,     0,     0,     0,     0,     0,     0,     0,   -18,     0,
       0,     0,     0,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,   596,     0,   597,   598,     0,     0,     0,   599,   600,
      41,     0,     0,     0,    42,    43,    44,    45,     0,     0,
       0,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,     0,    60,    61,    62,   107,     0,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,   601,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       3,     0,   602,   603,     0,    73,     0,    74,     0,   105,
      75,    76,    77,    14,    15,     0,    79,    17,    18,    19,
     106,    21,    22,     0,     0,     0,     0,     0,     0,     0,
     -18,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
       0,     0,     0,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,  -139,    60,    61,    62,   107,  -139,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     3,     0,     0,     0,     0,    73,     0,    74,
       0,   105,    75,    76,    77,    14,    15,     0,    79,    17,
      18,    19,   106,    21,    22,     0,     0,     0,     0,     0,
       0,     0,   -18,     0,     0,     0,     0,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,     0,     0,     0,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,     0,    60,    61,    62,
     107,     0,    64,    65,    66,   471,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,    74,     0,     0,    75,    76,    77,     0,     0,     0,
      79,     0,     0,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,     0,   236,   237,   238,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   279,     0,   239,     0,     0,   240,   241,   242,
       0,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,     0,     0,     0,     0,   253,   254,   255,   256,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,     0,   236,
     237,   238,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   280,     0,
     239,     0,     0,   240,   241,   242,     0,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,     0,     0,     0,
       0,   253,   254,   255,   256,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,     0,     0,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,     0,     0,     0,   459,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
       0,   236,   237,   238,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,     0,     0,   309,     0,     0,     0,
       0,     0,   239,     0,     0,   240,   241,   242,     0,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,     0,
       0,     0,     0,   253,   254,   255,   256,     0,     0,   382,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,     0,
     236,   237,   238,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,     0,   236,   237,   238,     0,     0,     0,     0,
       0,   239,     0,     0,   240,   241,   242,     0,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,     0,     0,
       0,     0,   253,   254,   255,   256,     0,     0,   383,     0,
       0,     0,     0,     0,   239,     0,     0,   240,   241,   242,
       0,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,     0,     0,     0,     0,   253,   254,   255,   256,     0,
       0,   399,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,     0,   236,   237,   238,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,     0,     0,
       0,     0,     0,   239,     0,     0,   240,   241,   242,     0,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
       0,     0,     0,     0,   253,   254,   255,   256,     0,     0,
     406,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,     0,   475,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,     0,   236,   237,   238,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
       0,     0,     0,     0,     0,   239,     0,     0,   240,   241,
     242,     0,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,     0,     0,     0,     0,   253,   254,   255,   256,
       0,     0,   481,     0,     0,     0,     0,     0,   239,     0,
       0,   240,   241,   242,     0,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,     0,     0,     0,     0,   253,
     254,   255,   256,     0,     0,   528,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,     0,   236,
     237,   238,     0,     0,     0,     0,     0,   239,     0,     0,
     240,   241,   242,     0,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,     0,   538,     0,     0,     0,     0,     0,
     239,     0,     0,   240,   241,   242,     0,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,     0,     0,     0,
       0,   253,   254,   255,   256,     0,     0,   542,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
       0,   236,   237,   238,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,     0,     0,   543,     0,     0,     0,
       0,     0,   239,     0,     0,   240,   241,   242,     0,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,     0,
       0,     0,     0,   253,   254,   255,   256,     0,     0,   544,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,     0,
     236,   237,   238,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,     0,   236,   237,   238,     0,     0,     0,     0,
       0,   239,     0,     0,   240,   241,   242,     0,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,     0,     0,
       0,     0,   253,   254,   255,   256,     0,     0,   641,     0,
       0,     0,     0,     0,   239,     0,     0,   240,   241,   242,
       0,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,     0,     0,     0,     0,   253,   254,   255,   256,     0,
       0,   675,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,     0,   236,   237,   238,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,     0,     0,
       0,     0,     0,   239,     0,     0,   240,   241,   242,     0,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
       0,     0,     0,     0,   253,   254,   255,   256,     0,   257,
       0,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,   270,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,     0,   236,   237,   238,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,     0,
       0,     0,     0,     0,   239,     0,     0,   240,   241,   242,
       0,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,     0,     0,     0,     0,   253,   254,   255,   256,     0,
     479,     0,     0,     0,     0,     0,     0,   239,     0,     0,
     240,   241,   242,     0,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,   480,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,     0,   236,   237,   238,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
       0,     0,     0,     0,     0,   239,     0,     0,   240,   241,
     242,     0,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,     0,     0,     0,     0,   253,   254,   255,   256,
       0,   539,     0,     0,     0,     0,     0,     0,   239,     0,
       0,   240,   241,   242,     0,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,     0,     0,     0,     0,   253,
     254,   255,   256,     0,   540,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,   550,     0,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,     0,   711,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,     0,   236,
     237,   238,     0,     0,     0,     0,     0,   239,     0,     0,
     240,   241,   242,     0,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,   719,     0,     0,     0,     0,     0,     0,
     239,     0,     0,   240,   241,   242,     0,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,     0,     0,     0,
       0,   253,   254,   255,   256,     0,   722,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,     0,
     236,   237,   238,     0,     0,     0,     0,     0,   239,     0,
       0,   240,   241,   242,     0,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,     0,     0,     0,     0,   253,
     254,   255,   256,     0,   724,     0,     0,     0,     0,     0,
       0,   239,     0,     0,   240,   241,   242,     0,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,     0,     0,
       0,     0,   253,   254,   255,   256,     0,   730,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
       0,   236,   237,   238,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,     0,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,   458,     0,     0,     0,     0,     0,
       0,     0,   239,     0,     0,   240,   241,   242,   457,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,     0,
       0,     0,     0,   253,   254,   255,   256,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,     0,
     236,   237,   238,     0,     0,     0,     0,     0,   239,     0,
       0,   240,   241,   242,   651,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,     0,     0,     0,     0,   253,
     254,   255,   256,     0,     0,     0,     0,     0,     0,     0,
       0,   239,     0,     0,   240,   241,   242,   676,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,     0,     0,
       0,     0,   253,   254,   255,   256,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   236,   237,   238,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,     0,   236,
     237,   238,     0,     0,     0,     0,     0,   239,     0,     0,
     240,   241,   242,   677,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,     0,     0,     0,     0,   253,   254,
     255,   256,     0,     0,     0,     0,     0,     0,     0,     0,
     239,     0,     0,   240,   241,   242,   678,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,     0,     0,     0,
       0,   253,   254,   255,   256,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,     0,     0,     0,     0,     0,   239,     0,     0,   240,
     241,   242,   682,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,     0,     0,     0,     0,     0,     0,     0,   239,
       0,     0,   240,   241,   242,   683,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,     0,   236,   237,   238,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   236,   237,   238,
       0,     0,     0,     0,     0,   239,     0,     0,   240,   241,
     242,     0,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,     0,     0,     0,     0,   253,   254,   255,   256,
       0,     0,     0,     0,     0,     0,     0,     0,   239,     0,
       0,     0,   241,   242,     0,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   213,   214,     0,     0,   253,
     254,   255,   256,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,   236,   237,   238,   213,   214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   236,   237,
     238,     0,     0,     0,     0,     0,   239,     0,     0,     0,
       0,   242,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,     0,     0,     0,     0,   253,   254,   255,
     256,     0,     0,     0,     0,     0,     0,     0,     0,   239,
       0,     0,     0,     0,   213,   214,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,     0,     0,     0,     0,
     253,   254,   255,   256,   227,   228,   229,   230,   231,   232,
     233,   234,   235,     0,   236,   237,   238,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   239,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   246,   247,   248,   249,   250,
     251,   252,     0,     0,     0,     0,   253,   254,   255,   256
};

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-474)))

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-187)))

static const yytype_int16 yycheck[] =
{
       2,     0,   475,     0,     6,     3,     3,    96,   113,   320,
      14,   320,     0,    15,    16,    17,    18,   117,     0,   199,
     109,   320,     5,   320,    14,   320,    98,   207,    79,   145,
      14,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    14,    45,   145,   320,   320,    49,    50,    51,
      52,    53,    54,    14,   101,    14,   122,    14,   493,    14,
      62,    98,    32,    46,    47,    48,   103,    24,    25,    26,
      27,    73,   144,    75,    76,    77,   143,    79,    38,    39,
     146,    80,    14,    80,   143,    42,    82,   522,    45,    46,
     125,    14,    80,   140,    98,    99,    78,   134,    80,    96,
     104,   122,    98,   123,   122,    14,   102,   103,    98,    99,
     145,   113,   109,   103,   104,   143,    38,    39,   429,   103,
     429,   123,   124,   125,   145,   145,    98,   145,   130,   131,
     429,   101,   429,   145,   429,   117,   123,    98,    99,   143,
      43,    98,   145,   104,   103,   147,   103,   143,   103,   329,
      98,   586,   145,   143,   429,   429,   143,   387,   145,   142,
      24,    25,    26,    27,   125,   624,    98,    99,    32,   628,
     140,   103,   104,   175,   176,    98,   178,   134,    42,   123,
     103,    45,    46,   110,   144,    24,    25,    26,    27,    98,
      99,    24,    25,    32,    32,   104,   143,    35,   140,   197,
     197,   145,   675,    42,   186,   108,    45,    46,   313,   143,
     445,   114,   447,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   667,    78,   145,   237,   238,   467,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,    98,   307,   143,   488,    35,
     103,    25,   697,   265,    98,    98,    48,    49,    32,   103,
     103,   143,   117,    35,   276,    25,   511,   279,    42,    14,
     144,   283,    32,   518,    98,   267,    82,   289,   290,   291,
     520,   521,    42,    82,   296,   297,    98,    98,    99,    99,
     134,   103,    98,   305,   306,   144,   102,   123,   310,    98,
      11,   313,     9,   102,   103,   317,   318,   319,   498,   499,
     143,   320,    82,   320,   326,   327,   328,   143,   143,   145,
     143,    98,   320,    25,    98,   515,   103,   119,    98,   103,
      32,   186,   102,   103,    14,   134,   123,   436,    98,   579,
      42,   143,   582,   103,    24,    25,    26,    27,   140,   141,
     142,   143,    32,    98,    99,    35,   143,   511,   145,   104,
     134,   123,    42,   143,   518,    45,    46,   123,   380,   381,
     144,   561,   384,   143,   134,    98,   143,   389,   390,   391,
     125,   393,   394,   395,   144,   143,   576,   146,   400,   382,
     383,   511,    24,    25,    26,    27,    98,   125,   518,   143,
      32,   103,   511,    24,    25,    26,    27,   143,   420,   518,
      42,    32,   267,    45,    46,    40,   116,   516,    98,   143,
     429,    42,   429,   103,    45,    46,   143,    14,    99,   436,
      82,   429,   134,   104,    48,    49,   445,   449,   447,   143,
     146,   146,   454,   455,   456,   457,    98,   445,    98,   447,
     102,   103,    98,   103,   134,   143,   145,   103,   698,   146,
     468,   468,    14,   140,   144,    98,    99,   143,   145,    25,
     103,   104,    24,    25,    26,    27,    32,   143,   123,    98,
      32,   123,   494,    35,   103,   143,    42,    98,   134,   143,
      42,   143,   103,    45,    46,   605,   123,   143,    98,    99,
     143,    82,   511,   103,   104,   119,   146,   146,   515,   518,
     146,   523,   144,   511,   143,   134,   146,    98,   146,   531,
     518,   102,   103,   144,   143,   537,   140,   141,   142,   143,
      98,   143,     4,    82,   546,   103,   529,   530,   648,    99,
     143,   651,    98,    82,   104,   538,    98,   103,   541,    98,
     140,   103,   146,   102,   103,    82,   564,   564,   146,    98,
     568,   568,   143,   102,   103,   577,   676,   677,   678,   679,
     680,    98,   682,   683,   146,   102,   103,   125,   134,    82,
     125,   146,   134,   595,   596,   597,   598,   146,   144,   140,
     602,   603,   144,   140,   145,    98,   608,   609,   145,   102,
     103,    24,    25,    26,    27,   146,   143,   112,   113,   145,
     617,   116,   117,   605,   469,   470,   624,   624,   630,    42,
     628,   628,    45,    46,    98,    95,    96,    97,    98,   103,
      98,   122,   146,   103,   146,   103,   491,   492,    14,   109,
     110,   143,   146,    41,   145,   145,   658,   640,    24,    25,
      26,    27,    98,   140,   146,   140,   648,   103,   145,   651,
     652,   143,   140,   140,    34,   146,    42,   145,   145,    45,
      46,   140,   125,    48,    49,   687,   145,   532,    98,   691,
     692,   146,   694,   695,   676,   677,   678,   679,   680,   681,
     682,   683,   684,   143,   146,   146,   708,   709,   146,   125,
     555,   556,   145,   143,   559,   143,   699,   122,   700,   701,
     702,   703,   704,   705,   706,   146,    48,    49,   103,    98,
     116,   146,    98,    14,   146,   580,   581,   103,   116,   584,
     585,   125,   125,    24,    25,    26,    27,   130,   131,    32,
      98,   101,   101,   146,   119,   125,    78,    79,    80,   146,
     605,    42,   125,    98,    45,    46,   146,   146,   134,   134,
     135,    80,   146,   146,   146,   140,   141,   142,   143,   294,
     429,   145,    26,   145,   145,   548,   206,   632,   505,   447,
     635,   636,   175,   625,   639,   178,   507,   119,   610,   568,
     307,    68,    -1,   648,    -1,    -1,   651,   652,    -1,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    98,   140,   141,
     142,   143,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   676,   677,   678,   679,   680,   681,   682,   683,   684,
      -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,   134,    -1,   700,   701,   702,   703,   704,
     705,   706,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   716,   717,   256,    -1,    -1,    48,    49,    -1,    -1,
      -1,    -1,   265,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   276,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    -1,
      -1,    -1,    -1,   296,   297,    -1,   119,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,
     133,   134,   135,    -1,   317,   318,   319,   140,   141,   142,
     143,    -1,    -1,   326,   327,   328,    -1,   119,    -1,    -1,
      -1,   123,   124,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,
      -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,
      14,   384,    -1,    -1,    18,    19,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,   420,    -1,    -1,
      -1,    48,    49,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,   449,    81,    82,    83,
      84,   454,   455,   456,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,   109,   110,   111,    -1,    -1,
      -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,
      -1,   494,   119,    -1,    -1,    -1,    -1,    -1,   132,    -1,
     134,    -1,    -1,   137,   138,   139,   133,   134,   135,   143,
      -1,    -1,   146,   140,   141,   142,   143,    -1,    -1,    -1,
     523,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   577,    -1,     1,    -1,    -1,    -1,
       5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    14,
      -1,    -1,    -1,    18,    19,    -1,    -1,    22,    23,    24,
      25,    26,    27,    -1,    -1,   608,   609,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,   630,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,   692,
     115,    -1,   695,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   709,   132,    -1,   134,
      -1,    -1,   137,   138,   139,    -1,     0,     1,   143,     3,
     145,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    -1,    31,    32,    33,
      -1,    35,    36,    37,    -1,    -1,    -1,    -1,    42,    43,
      44,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,    -1,    -1,
     114,   115,    -1,    -1,   118,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,
     134,    -1,    -1,   137,   138,   139,   140,    -1,     1,   143,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,    -1,   143,   144,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,   134,    -1,    -1,
     137,   138,   139,   140,    -1,    -1,   143,   144,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,    -1,   143,   144,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,   134,    -1,    -1,
     137,   138,   139,   140,    -1,    -1,   143,   144,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,    -1,   143,   144,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,   134,    -1,    -1,
     137,   138,   139,   140,    -1,    -1,   143,   144,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,    -1,   143,   144,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,   134,    -1,    -1,
     137,   138,   139,   140,    -1,    -1,   143,   144,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    -1,    -1,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,   140,    -1,    -1,
     143,   144,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    -1,
      -1,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    -1,   143,   144,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    -1,   137,   138,   139,   140,    -1,    -1,   143,   144,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    32,    33,    -1,    35,    36,    37,    -1,    -1,    -1,
      -1,    42,    43,    44,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,    -1,    -1,   114,   115,    -1,    -1,   118,    -1,   120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,   140,
      -1,     1,   143,     3,    -1,     5,     6,     7,     8,    -1,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    35,    36,    37,    -1,    -1,
      -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,   134,    -1,    -1,   137,   138,   139,
     140,    -1,     1,   143,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    -1,
      -1,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,     5,   134,    -1,    -1,   137,   138,
     139,   140,    -1,    14,   143,    -1,    -1,    18,    19,    -1,
      -1,    22,    23,    24,    25,    26,    27,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    -1,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      81,    82,    83,    84,    -1,    -1,    -1,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,   105,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       5,   132,    -1,   134,    -1,    -1,   137,   138,   139,    14,
      -1,    -1,   143,    18,    19,   146,    -1,    22,    23,    24,
      25,    26,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,     5,   134,
      -1,    -1,   137,   138,   139,    -1,    -1,    14,   143,    -1,
     145,    18,    19,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,
      -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    -1,    75,    76,
      77,    -1,    -1,    -1,    81,    82,    83,    84,    -1,    -1,
      -1,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,   105,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,   116,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,   129,   130,    -1,   132,    -1,   134,    -1,    14,
     137,   138,   139,    18,    19,    -1,   143,    22,    23,    24,
      25,    26,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    81,    82,    83,    84,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,   132,    -1,   134,
      -1,    14,   137,   138,   139,    18,    19,    -1,   143,    22,
      23,    24,    25,    26,    27,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    81,    82,
      83,    84,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,   105,   106,   107,    10,   109,   110,   111,    -1,
      -1,    -1,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,   134,    -1,    -1,   137,   138,   139,    -1,    -1,    -1,
     143,    -1,    -1,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    21,    -1,   119,    -1,    -1,   122,   123,   124,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,    -1,
     119,    -1,    -1,   122,   123,   124,    -1,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    -1,    -1,    -1,
      -1,   140,   141,   142,   143,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    -1,    -1,    -1,   147,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    -1,    -1,   146,    -1,    -1,    -1,
      -1,    -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,    -1,
      -1,    -1,    -1,   140,   141,   142,   143,    -1,    -1,   146,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    80,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,    -1,    -1,   146,    -1,
      -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,
      -1,   146,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    80,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,    -1,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
      -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,    -1,
     146,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,    -1,   146,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    80,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,
     124,    -1,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,
      -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,   122,   123,   124,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,
     141,   142,   143,    -1,    -1,   146,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,
     122,   123,   124,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,
     119,    -1,    -1,   122,   123,   124,    -1,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    -1,    -1,    -1,
      -1,   140,   141,   142,   143,    -1,    -1,   146,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    -1,    -1,   146,    -1,    -1,    -1,
      -1,    -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,    -1,
      -1,    -1,    -1,   140,   141,   142,   143,    -1,    -1,   146,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    80,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,    -1,    -1,   146,    -1,
      -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,
      -1,   146,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    80,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,    -1,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
      -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,   145,
      -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,   145,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    80,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    -1,
      -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,   124,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,    -1,
     145,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,
     122,   123,   124,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,   145,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    80,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,
     124,    -1,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,
      -1,   145,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,   122,   123,   124,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,
     141,   142,   143,    -1,   145,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,   145,    -1,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    -1,   145,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,
     122,   123,   124,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,   145,    -1,    -1,    -1,    -1,    -1,    -1,
     119,    -1,    -1,   122,   123,   124,    -1,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    -1,    -1,    -1,
      -1,   140,   141,   142,   143,    -1,   145,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,   122,   123,   124,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,
     141,   142,   143,    -1,   145,    -1,    -1,    -1,    -1,    -1,
      -1,   119,    -1,    -1,   122,   123,   124,    -1,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,    -1,   145,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,    -1,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,   144,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   119,    -1,    -1,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,    -1,
      -1,    -1,    -1,   140,   141,   142,   143,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,
     141,   142,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   119,    -1,    -1,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,   140,   141,   142,   143,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    80,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,
     142,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     119,    -1,    -1,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    -1,    -1,    -1,
      -1,   140,   141,   142,   143,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    80,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,   123,
     124,    -1,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,   143,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,    -1,   123,   124,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    48,    49,    -1,    -1,   140,
     141,   142,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    80,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      80,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,    -1,
      -1,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,
     143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,    -1,    -1,    48,    49,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,    -1,    -1,    -1,    -1,
     140,   141,   142,   143,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    80,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   129,   130,   131,   132,   133,
     134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,   143
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,     6,     7,     8,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    22,    23,    24,
      25,    26,    27,    28,    31,    32,    33,    36,    37,    42,
      44,    45,    46,    48,    49,    60,    61,    62,    63,    64,
      65,    77,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
     100,   101,   102,   103,   105,   106,   107,   109,   110,   111,
     115,   118,   120,   132,   134,   137,   138,   139,   140,   143,
     149,   150,   153,   154,   155,   158,   159,   164,   167,   168,
     171,   173,   178,   179,   189,   193,   194,   195,   197,   198,
     199,   202,   203,   204,   145,    14,    25,   103,   178,   194,
     202,    98,   103,   143,   178,   179,   103,   140,   160,   161,
     164,   161,   202,   143,   143,   143,    82,    98,   102,   103,
     143,   187,   145,   145,   145,   202,   202,   202,   202,    32,
      98,   163,   165,    98,   103,   163,   145,   143,   140,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
      98,   103,   202,   161,   161,   161,   202,   202,   202,   202,
     202,   202,     1,   172,   202,   143,   143,   203,   143,   202,
      98,   103,   202,   202,   202,   160,   162,   164,    98,   103,
     146,   200,   201,   202,   204,     0,   150,    35,   145,    14,
      98,   103,    99,   104,    43,   108,   114,    14,    25,    98,
     103,   178,   195,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    78,    79,    80,   119,
     122,   123,   124,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   140,   141,   142,   143,   145,    14,    14,
     178,   199,   202,    98,    99,   143,   144,   162,    11,     9,
     145,   202,   202,   172,   143,   143,   143,   172,   172,    21,
      21,    98,   103,   143,    10,    29,    30,   161,   166,   123,
     123,   143,   202,    98,   151,   152,   143,   143,   146,   172,
     202,   172,   144,   160,   164,   125,   125,   122,   146,   146,
     125,    98,   103,   143,   178,   179,   103,   143,   187,   143,
     140,   145,    40,   174,   174,   103,   143,   187,   143,    14,
     103,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     112,   113,   116,   117,   116,    98,   103,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   172,    14,   146,   172,   144,
     143,   143,   146,   146,   145,   172,   146,   146,   202,   143,
     123,   123,   202,   143,   143,   143,   202,   202,   202,   146,
     123,   144,   152,   172,   172,   146,   146,   146,   202,   202,
      98,   103,   201,   204,   202,   199,    98,   103,    99,   104,
     143,   172,   172,   172,    14,   103,   144,   154,   155,   156,
     157,   158,   159,   173,   178,   189,   194,   197,   198,    24,
      25,    98,   103,   175,   176,   140,   145,   140,   145,   143,
     172,   172,   172,   103,   143,   187,   143,   125,   144,   147,
     146,   146,   202,   172,   161,   161,   172,   146,     4,   196,
     196,    10,   202,   202,   202,   146,   202,   202,   202,   145,
     145,   146,   140,   202,   146,   146,   125,   145,   190,   146,
     172,   146,   146,   146,   143,   145,   144,   157,    14,    14,
     178,    98,   103,    98,   103,   122,    24,    25,    32,   144,
     158,   177,   180,   181,   188,   193,   194,   144,   177,   172,
     146,   146,   146,   143,   172,   172,   172,   202,   146,   146,
      41,   145,   196,   178,   179,   160,   160,   143,   146,   145,
     145,   165,   146,   146,   146,    34,    38,    39,   169,   170,
     145,    98,   103,   191,   192,   196,   146,   160,   160,   190,
     172,    14,   176,   101,   140,   184,   185,    32,   140,   185,
     144,   158,   180,   181,   188,    98,   178,   187,   144,   146,
     196,   196,   190,   172,   146,   146,   146,   145,   161,   161,
     172,   160,   202,   161,   161,   143,    68,    70,    71,    75,
      76,   116,   129,   130,   202,   125,   144,   170,   143,   143,
     122,   160,   160,   160,   146,   103,    25,    42,    98,   158,
     178,   179,   182,   183,   186,   122,   145,   144,   186,   145,
     187,   172,   196,   160,   160,   196,   146,   160,   160,   190,
     146,   146,   202,   202,   202,   202,   116,   116,   125,   202,
     202,   125,   162,   172,   172,   192,    98,   178,   123,   145,
      98,   101,   144,   183,   184,   144,   172,   146,   160,   145,
     160,   160,   145,   160,   161,   146,   125,   125,   125,   125,
     125,   162,   125,   125,   162,   146,   146,   123,   145,    98,
     202,   123,   143,   145,   123,   143,   145,   146,   190,   165,
     162,   162,   162,   162,   162,   162,   162,   202,   123,   143,
     145,   145,   202,   172,   202,   172,   190,   196,   161,   145,
     202,   172,   145,   146,   145,   146,   145,   160,   145,   160,
     145,   146,   145,   145,   145
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  However,
   YYFAIL appears to be in use.  Nevertheless, it is formally deprecated
   in Bison 2.4.2's NEWS entry, where a plan to phase it out is
   discussed.  */

#define YYFAIL		goto yyerrlab
#if defined YYFAIL
  /* This is here to suppress warnings from the GCC cpp's
     -Wunused-macros.  Normally we don't worry about that warning, but
     some users do, and we want to make it easy for users to remove
     YYFAIL uses, which will produce warnings from Bison 2.5.  */
#endif

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))

/* Error token number */
#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (YYID (N))                                                     \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (YYID (0))
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

__attribute__((__unused__))
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static unsigned
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
#else
static unsigned
yy_location_print_ (yyo, yylocp)
    FILE *yyo;
    YYLTYPE const * const yylocp;
#endif
{
  unsigned res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += fprintf (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += fprintf (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += fprintf (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += fprintf (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += fprintf (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */
#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc, yyscanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
  YYUSE (yylocationp);
  YYUSE (yyscanner);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
#else
static void
yy_reduce_print (yyvsp, yylsp, yyrule, yyscanner)
    YYSTYPE *yyvsp;
    YYLTYPE *yylsp;
    int yyrule;
    yyscan_t yyscanner;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       , &(yylsp[(yyi + 1) - (yynrhs)])		       , yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, yylsp, Rule, yyscanner); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULL, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULL;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - Assume YYFAIL is not used.  It's too flawed to consider.  See
       <http://lists.gnu.org/archive/html/bison-patches/2009-12/msg00024.html>
       for details.  YYERROR is fine as it does not invoke this
       function.
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULL, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp, yyscanner)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
    yyscan_t yyscanner;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {
      case 98: /* "identifier" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4919 "parser.cpp"
        break;
      case 99: /* "variable reference" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4926 "parser.cpp"
        break;
      case 100: /* "backquote expression" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4933 "parser.cpp"
        break;
      case 101: /* "in-object member reference" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4940 "parser.cpp"
        break;
      case 102: /* "identifier or keyword used as function or method identifier" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4947 "parser.cpp"
        break;
      case 103: /* "namespace or class-scoped reference" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4954 "parser.cpp"
        break;
      case 104: /* "namespace-scoped global variable reference" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4961 "parser.cpp"
        break;
      case 105: /* "context reference" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4968 "parser.cpp"
        break;
      case 106: /* "named context reference" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4975 "parser.cpp"
        break;
      case 107: /* "cast operator" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4982 "parser.cpp"
        break;
      case 108: /* "simple class declaration" */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 4989 "parser.cpp"
        break;
      case 109: /* "date/time value" */
/* Line 1393 of yacc.c  */
#line 1449 "parser.ypp"
        { if (((*yyvaluep).datetime)) ((*yyvaluep).datetime)->deref(); };
/* Line 1393 of yacc.c  */
#line 4996 "parser.cpp"
        break;
      case 110: /* "quoted string" */
/* Line 1393 of yacc.c  */
#line 1449 "parser.ypp"
        { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); };
/* Line 1393 of yacc.c  */
#line 5003 "parser.cpp"
        break;
      case 111: /* "binary constant value" */
/* Line 1393 of yacc.c  */
#line 1449 "parser.ypp"
        { if (((*yyvaluep).binary)) ((*yyvaluep).binary)->deref(); };
/* Line 1393 of yacc.c  */
#line 5010 "parser.cpp"
        break;
      case 112: /* "regular expression substitution expression" */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).RegexSubst); };
/* Line 1393 of yacc.c  */
#line 5017 "parser.cpp"
        break;
      case 113: /* "transliteration expression" */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).RegexTrans); };
/* Line 1393 of yacc.c  */
#line 5024 "parser.cpp"
        break;
      case 114: /* "scoped class declaration" */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).nscope); };
/* Line 1393 of yacc.c  */
#line 5031 "parser.cpp"
        break;
      case 115: /* "call to base class method" */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).nscope); };
/* Line 1393 of yacc.c  */
#line 5038 "parser.cpp"
        break;
      case 116: /* "regular expression" */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).Regex); };
/* Line 1393 of yacc.c  */
#line 5045 "parser.cpp"
        break;
      case 117: /* "regular expression extraction expression" */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).Regex); };
/* Line 1393 of yacc.c  */
#line 5052 "parser.cpp"
        break;
      case 118: /* "implicit argument reference" */
/* Line 1393 of yacc.c  */
#line 1449 "parser.ypp"
        { if (((*yyvaluep).implicit_arg)) ((*yyvaluep).implicit_arg)->deref(); };
/* Line 1393 of yacc.c  */
#line 5059 "parser.cpp"
        break;
      case 119: /* "keyword used as hash key or object member reference" */
/* Line 1393 of yacc.c  */
#line 1449 "parser.ypp"
        { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); };
/* Line 1393 of yacc.c  */
#line 5066 "parser.cpp"
        break;
      case 120: /* "%try-module error token" */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).trymod); };
/* Line 1393 of yacc.c  */
#line 5073 "parser.cpp"
        break;
      case 154: /* gvardecl */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).gv); };
/* Line 1393 of yacc.c  */
#line 5080 "parser.cpp"
        break;
      case 155: /* top_namespace_decl */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).ns); };
/* Line 1393 of yacc.c  */
#line 5087 "parser.cpp"
        break;
      case 156: /* namespace_decls */
/* Line 1393 of yacc.c  */
#line 1449 "parser.ypp"
        { if (((*yyvaluep).nsnlist)) ((*yyvaluep).nsnlist)->deref(); };
/* Line 1393 of yacc.c  */
#line 5094 "parser.cpp"
        break;
      case 157: /* namespace_decl */
/* Line 1393 of yacc.c  */
#line 1449 "parser.ypp"
        { if (((*yyvaluep).nsn)) ((*yyvaluep).nsn)->deref(); };
/* Line 1393 of yacc.c  */
#line 5101 "parser.cpp"
        break;
      case 158: /* unscoped_const_decl */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).constnode); };
/* Line 1393 of yacc.c  */
#line 5108 "parser.cpp"
        break;
      case 159: /* scoped_const_decl */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).constnode); };
/* Line 1393 of yacc.c  */
#line 5115 "parser.cpp"
        break;
      case 160: /* block */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).sblock); };
/* Line 1393 of yacc.c  */
#line 5122 "parser.cpp"
        break;
      case 161: /* statement_or_block */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).sblock); };
/* Line 1393 of yacc.c  */
#line 5129 "parser.cpp"
        break;
      case 162: /* statements */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).sblock); };
/* Line 1393 of yacc.c  */
#line 5136 "parser.cpp"
        break;
      case 163: /* optname */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 5143 "parser.cpp"
        break;
      case 164: /* statement */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).statement); };
/* Line 1393 of yacc.c  */
#line 5150 "parser.cpp"
        break;
      case 165: /* context_mods */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).cmods); };
/* Line 1393 of yacc.c  */
#line 5157 "parser.cpp"
        break;
      case 166: /* context_mod */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).cmod); };
/* Line 1393 of yacc.c  */
#line 5164 "parser.cpp"
        break;
      case 167: /* return_statement */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).statement); };
/* Line 1393 of yacc.c  */
#line 5171 "parser.cpp"
        break;
      case 168: /* switch_statement */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).statement); };
/* Line 1393 of yacc.c  */
#line 5178 "parser.cpp"
        break;
      case 169: /* case_block */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).switchstmt); };
/* Line 1393 of yacc.c  */
#line 5185 "parser.cpp"
        break;
      case 170: /* case_code */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).casenode); };
/* Line 1393 of yacc.c  */
#line 5192 "parser.cpp"
        break;
      case 171: /* try_statement */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).statement); };
/* Line 1393 of yacc.c  */
#line 5199 "parser.cpp"
        break;
      case 172: /* myexp */
/* Line 1393 of yacc.c  */
#line 1450 "parser.ypp"
        { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); };
/* Line 1393 of yacc.c  */
#line 5206 "parser.cpp"
        break;
      case 173: /* class_def */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).classdef); };
/* Line 1393 of yacc.c  */
#line 5213 "parser.cpp"
        break;
      case 174: /* inheritance_list */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).sclist); };
/* Line 1393 of yacc.c  */
#line 5220 "parser.cpp"
        break;
      case 175: /* superclass_list */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).sclist); };
/* Line 1393 of yacc.c  */
#line 5227 "parser.cpp"
        break;
      case 176: /* superclass */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).sclnode); };
/* Line 1393 of yacc.c  */
#line 5234 "parser.cpp"
        break;
      case 177: /* class_attributes */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).qoreclass); };
/* Line 1393 of yacc.c  */
#line 5241 "parser.cpp"
        break;
      case 178: /* uncqtypedef */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).parsertype); };
/* Line 1393 of yacc.c  */
#line 5248 "parser.cpp"
        break;
      case 179: /* qtypedef */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).parsertype); };
/* Line 1393 of yacc.c  */
#line 5255 "parser.cpp"
        break;
      case 180: /* private_member_list */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).memberlist); };
/* Line 1393 of yacc.c  */
#line 5262 "parser.cpp"
        break;
      case 181: /* public_member_list */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).memberlist); };
/* Line 1393 of yacc.c  */
#line 5269 "parser.cpp"
        break;
      case 182: /* classvardecl */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).classvarinfo); };
/* Line 1393 of yacc.c  */
#line 5276 "parser.cpp"
        break;
      case 183: /* member2 */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).memberinfo); };
/* Line 1393 of yacc.c  */
#line 5283 "parser.cpp"
        break;
      case 184: /* member */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).memberinfo); };
/* Line 1393 of yacc.c  */
#line 5290 "parser.cpp"
        break;
      case 185: /* member_list */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).memberlist); };
/* Line 1393 of yacc.c  */
#line 5297 "parser.cpp"
        break;
      case 186: /* member_list2 */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).memberlist); };
/* Line 1393 of yacc.c  */
#line 5304 "parser.cpp"
        break;
      case 187: /* ident_openparen */
/* Line 1393 of yacc.c  */
#line 1448 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1393 of yacc.c  */
#line 5311 "parser.cpp"
        break;
      case 188: /* inline_methoddef */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).methodnode); };
/* Line 1393 of yacc.c  */
#line 5318 "parser.cpp"
        break;
      case 189: /* outofline_methoddef */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).methoddef); };
/* Line 1393 of yacc.c  */
#line 5325 "parser.cpp"
        break;
      case 190: /* base_constructor_list */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).bcalist); };
/* Line 1393 of yacc.c  */
#line 5332 "parser.cpp"
        break;
      case 191: /* base_constructors */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).bcalist); };
/* Line 1393 of yacc.c  */
#line 5339 "parser.cpp"
        break;
      case 192: /* base_constructor */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).bcanode); };
/* Line 1393 of yacc.c  */
#line 5346 "parser.cpp"
        break;
      case 196: /* return_value */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).returnTypeInfo); };
/* Line 1393 of yacc.c  */
#line 5353 "parser.cpp"
        break;
      case 197: /* sub_def */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).parsefunc); };
/* Line 1393 of yacc.c  */
#line 5360 "parser.cpp"
        break;
      case 198: /* scoped_sub_def */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).sparsefunc); };
/* Line 1393 of yacc.c  */
#line 5367 "parser.cpp"
        break;
      case 199: /* list */
/* Line 1393 of yacc.c  */
#line 1450 "parser.ypp"
        { if (((*yyvaluep).list)) ((*yyvaluep).list)->deref(0); };
/* Line 1393 of yacc.c  */
#line 5374 "parser.cpp"
        break;
      case 200: /* hash */
/* Line 1393 of yacc.c  */
#line 1450 "parser.ypp"
        { if (((*yyvaluep).hash)) ((*yyvaluep).hash)->deref(0); };
/* Line 1393 of yacc.c  */
#line 5381 "parser.cpp"
        break;
      case 201: /* hash_element */
/* Line 1393 of yacc.c  */
#line 1447 "parser.ypp"
        { delete ((*yyvaluep).hashelement); };
/* Line 1393 of yacc.c  */
#line 5388 "parser.cpp"
        break;
      case 202: /* exp */
/* Line 1393 of yacc.c  */
#line 1450 "parser.ypp"
        { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); };
/* Line 1393 of yacc.c  */
#line 5395 "parser.cpp"
        break;
      case 203: /* string */
/* Line 1393 of yacc.c  */
#line 1449 "parser.ypp"
        { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); };
/* Line 1393 of yacc.c  */
#line 5402 "parser.cpp"
        break;
      case 204: /* scalar */
/* Line 1393 of yacc.c  */
#line 1450 "parser.ypp"
        { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); };
/* Line 1393 of yacc.c  */
#line 5409 "parser.cpp"
        break;

      default:
        break;
    }
}




/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (yyscan_t yyscanner)
#else
int
yyparse (yyscanner)
    yyscan_t yyscanner;
#endif
#endif
{
/* The lookahead symbol.  */
int yychar;


#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
static YYSTYPE yyval_default;
# define YY_INITIAL_VALUE(Value) = Value
#endif
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval YY_INITIAL_VALUE(yyval_default);

/* Location data for the lookahead symbol.  */
YYLTYPE yylloc = yyloc_default;


    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.
       `yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);

	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
	YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
/* Line 1787 of yacc.c  */
#line 1459 "parser.ypp"
    {
           (yyvsp[(1) - (1)].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 5:
/* Line 1787 of yacc.c  */
#line 1462 "parser.ypp"
    {
           (yyvsp[(1) - (1)].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 6:
/* Line 1787 of yacc.c  */
#line 1465 "parser.ypp"
    {
           qore_root_ns_private::parseAddClass(*((yyvsp[(1) - (1)].classdef)->name), (yyvsp[(1) - (1)].classdef)->oc);

	   // see if class definitions are allowed
	   if (parse_check_parse_option(PO_NO_CLASS_DEFS))
	      parse_error("illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
	   delete (yyvsp[(1) - (1)].classdef);
	}
    break;

  case 7:
/* Line 1787 of yacc.c  */
#line 1473 "parser.ypp"
    {
           qore_root_ns_private::parseAddConstant(*getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
	   delete (yyvsp[(1) - (1)].constnode);
	}
    break;

  case 8:
/* Line 1787 of yacc.c  */
#line 1477 "parser.ypp"
    {
           qore_root_ns_private::parseAddConstant(*getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
	   delete (yyvsp[(1) - (1)].constnode);
	}
    break;

  case 9:
/* Line 1787 of yacc.c  */
#line 1481 "parser.ypp"
    {
           (yyvsp[(1) - (1)].methoddef)->parseAddToClassAndDel();
        }
    break;

  case 10:
/* Line 1787 of yacc.c  */
#line 1484 "parser.ypp"
    {
	   if ((yyvsp[(1) - (1)].statement)) {
	      if ((yyvsp[(1) - (1)].statement)->isParseDeclaration())
		 delete (yyvsp[(1) - (1)].statement);
	      else
	         qore_program_private::addStatement(*(getProgram()), (yyvsp[(1) - (1)].statement));
	   }
	}
    break;

  case 11:
/* Line 1787 of yacc.c  */
#line 1492 "parser.ypp"
    {
	   // set line range
	   (yyvsp[(2) - (3)].sblock)->loc.start_line = (yylsp[(1) - (3)]).first_line;
	   (yyvsp[(2) - (3)].sblock)->loc.end_line = (yylsp[(2) - (3)]).last_line;
	   qore_program_private::addStatement(*(getProgram()), (yyvsp[(2) - (3)].sblock));
        }
    break;

  case 12:
/* Line 1787 of yacc.c  */
#line 1498 "parser.ypp"
    {
           qore_root_ns_private::parseAddNamespace((yyvsp[(1) - (1)].ns)); 
	   // see if ns declaration is legal
	   if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
	      parse_error("illegal namespace definition \"%s\" (conflicts with parse option NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
	}
    break;

  case 13:
/* Line 1787 of yacc.c  */
#line 1504 "parser.ypp"
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");

           // registered internally
        }
    break;

  case 14:
/* Line 1787 of yacc.c  */
#line 1511 "parser.ypp"
    {
           bool has_dollar = (yyvsp[(1) - (1)].trymod)->var[0] == '$';
           if (!has_dollar) {
              if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error("%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (1)].trymod)->var);
           }
           else {
              (yyvsp[(1) - (1)].trymod)->fixName();
              if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error("%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].trymod)->var);
           }

           if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
              parse_error("'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
              delete (yyvsp[(1) - (1)].trymod);
           }
           else {
              VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].trymod)->takeName());
              QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(left, (yyvsp[(1) - (1)].trymod)->takeExceptionHash());
              qore_program_private::addStatement(*(getProgram()), new ExpressionStatement((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, exp));
           }
        }
    break;

  case 15:
/* Line 1787 of yacc.c  */
#line 1536 "parser.ypp"
    {
        }
    break;

  case 16:
/* Line 1787 of yacc.c  */
#line 1538 "parser.ypp"
    {
        }
    break;

  case 17:
/* Line 1787 of yacc.c  */
#line 1543 "parser.ypp"
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[(1) - (4)].string), get_type_name((yyvsp[(3) - (4)].node)));
           else
              qmd->set((yyvsp[(1) - (4)].string), (yyvsp[(3) - (4)].node));

           free((yyvsp[(1) - (4)].string));
           (yyvsp[(3) - (4)].node)->deref(0);
        }
    break;

  case 18:
/* Line 1787 of yacc.c  */
#line 1556 "parser.ypp"
    { (yyval.b) = false; }
    break;

  case 19:
/* Line 1787 of yacc.c  */
#line 1557 "parser.ypp"
    {
           (yyval.b) = true;
        }
    break;

  case 20:
/* Line 1787 of yacc.c  */
#line 1563 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(3) - (4)].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[(4) - (4)].string), t, t ? 0 : (yyvsp[(3) - (4)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (4)].b), true);
           delete (yyvsp[(3) - (4)].parsertype);
	}
    break;

  case 21:
/* Line 1787 of yacc.c  */
#line 1568 "parser.ypp"
    {
           (yyval.gv) = new GVarSingleDecl((yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
        }
    break;

  case 22:
/* Line 1787 of yacc.c  */
#line 1571 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(3) - (4)].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[(4) - (4)].string), t, t ? 0 : (yyvsp[(3) - (4)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (4)].b), true);
           delete (yyvsp[(3) - (4)].parsertype);
	}
    break;

  case 23:
/* Line 1787 of yacc.c  */
#line 1576 "parser.ypp"
    {
           (yyval.gv) = new GVarSingleDecl((yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
	}
    break;

  case 24:
/* Line 1787 of yacc.c  */
#line 1579 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(3) - (4)].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[(4) - (4)].string), t, t ? 0 : (yyvsp[(3) - (4)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (4)].b), false);
           delete (yyvsp[(3) - (4)].parsertype);
	}
    break;

  case 25:
/* Line 1787 of yacc.c  */
#line 1584 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(3) - (4)].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[(4) - (4)].string), t, t ? 0 : (yyvsp[(3) - (4)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (4)].b), false);
           delete (yyvsp[(3) - (4)].parsertype);
	}
    break;

  case 26:
/* Line 1787 of yacc.c  */
#line 1589 "parser.ypp"
    {
           (yyval.gv) = new GVarListDecl((yyvsp[(4) - (5)].list), (yyvsp[(1) - (5)].b));
        }
    break;

  case 27:
/* Line 1787 of yacc.c  */
#line 1595 "parser.ypp"
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[(1) - (5)].i4), *p);
           (yyvsp[(4) - (5)].nsnlist)->add(*p);
           delete (yyvsp[(4) - (5)].nsnlist);
           (yyval.ns) = p->ns;
        }
    break;

  case 28:
/* Line 1787 of yacc.c  */
#line 1602 "parser.ypp"
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[(1) - (3)].i4), *p);
           (yyval.ns) = p->ns;
        }
    break;

  case 29:
/* Line 1787 of yacc.c  */
#line 1607 "parser.ypp"
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[(1) - (4)].i4), *p);
           (yyval.ns) = p->ns;
        }
    break;

  case 30:
/* Line 1787 of yacc.c  */
#line 1615 "parser.ypp"
    {
	   (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[(1) - (1)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(1) - (1)].nsn));
        }
    break;

  case 31:
/* Line 1787 of yacc.c  */
#line 1620 "parser.ypp"
    {
           (yyval.nsnlist) = (yyvsp[(1) - (2)].nsnlist);
           if ((yyvsp[(2) - (2)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(2) - (2)].nsn));
	}
    break;

  case 32:
/* Line 1787 of yacc.c  */
#line 1628 "parser.ypp"
    {
	   (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
        }
    break;

  case 33:
/* Line 1787 of yacc.c  */
#line 1631 "parser.ypp"
    {
	   (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
	}
    break;

  case 34:
/* Line 1787 of yacc.c  */
#line 1634 "parser.ypp"
    {
	   (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].classdef));
	   // see if class definitions are allowed
	   if (parse_check_parse_option(PO_NO_CLASS_DEFS))
	      parse_error("illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
	}
    break;

  case 35:
/* Line 1787 of yacc.c  */
#line 1640 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].parsefunc));
        }
    break;

  case 36:
/* Line 1787 of yacc.c  */
#line 1643 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].sparsefunc));
        }
    break;

  case 37:
/* Line 1787 of yacc.c  */
#line 1646 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (2)].gv));
        }
    break;

  case 38:
/* Line 1787 of yacc.c  */
#line 1649 "parser.ypp"
    { 
	   (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].ns)); 
	   // see if ns declaration is legal
	   if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
	      parse_error("illegal namespace definition \"%s\" (conflicts with parse option NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
	}
    break;

  case 39:
/* Line 1787 of yacc.c  */
#line 1655 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].methoddef));
        }
    break;

  case 40:
/* Line 1787 of yacc.c  */
#line 1660 "parser.ypp"
    { 
	   (yyval.constnode) = new ConstNode((yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].node)); 
	}
    break;

  case 41:
/* Line 1787 of yacc.c  */
#line 1663 "parser.ypp"
    { 
	   (yyval.constnode) = new ConstNode((yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].node), true); 
	}
    break;

  case 42:
/* Line 1787 of yacc.c  */
#line 1669 "parser.ypp"
    {
	   (yyval.constnode) = new ConstNode((yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].node)); 
	}
    break;

  case 43:
/* Line 1787 of yacc.c  */
#line 1672 "parser.ypp"
    {
	   (yyval.constnode) = new ConstNode((yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].node), true); 
	}
    break;

  case 44:
/* Line 1787 of yacc.c  */
#line 1679 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(2) - (3)].sblock); }
    break;

  case 45:
/* Line 1787 of yacc.c  */
#line 1682 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line); }
    break;

  case 46:
/* Line 1787 of yacc.c  */
#line 1687 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 47:
/* Line 1787 of yacc.c  */
#line 1690 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(1) - (1)].sblock); }
    break;

  case 48:
/* Line 1787 of yacc.c  */
#line 1695 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 49:
/* Line 1787 of yacc.c  */
#line 1697 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].sblock)); }
    break;

  case 50:
/* Line 1787 of yacc.c  */
#line 1699 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].sblock)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 51:
/* Line 1787 of yacc.c  */
#line 1701 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].statement)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 52:
/* Line 1787 of yacc.c  */
#line 1706 "parser.ypp"
    { (yyval.string) = 0; }
    break;

  case 53:
/* Line 1787 of yacc.c  */
#line 1707 "parser.ypp"
    { (yyval.string) = (yyvsp[(1) - (1)].string); }
    break;

  case 54:
/* Line 1787 of yacc.c  */
#line 1711 "parser.ypp"
    {
	   // if the expression has no effect and it's not a variable declaration
	   qore_type_t t = (yyvsp[(1) - (2)].node) ? (yyvsp[(1) - (2)].node)->getType() : 0;
	   bool ok = false;
	   if (t == NT_LIST) {
	      QoreListNode* l = reinterpret_cast<QoreListNode*>((yyvsp[(1) - (2)].node));
	      // rewrite expression if it's a list without parentheses under certain conditions
	      (yyvsp[(1) - (2)].node) = checkRewriteList(l);

	      if (l->isVariableList())
		 ok = true;
	   }

	   if (!ok && !node_has_effect((yyvsp[(1) - (2)].node)) && (t != NT_VARREF || !reinterpret_cast<VarRefNode*>((yyvsp[(1) - (2)].node))->parseIsDecl()))
	      parse_error("statement has no effect (%s)", (yyvsp[(1) - (2)].node) ? (yyvsp[(1) - (2)].node)->getTypeName() : "NOTHING");
           ignore_return_value((yyvsp[(1) - (2)].node));
	   (yyval.statement) = new ExpressionStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line, (yyvsp[(1) - (2)].node));
	}
    break;

  case 55:
/* Line 1787 of yacc.c  */
#line 1730 "parser.ypp"
    {
	   NamedScope *ns = new NamedScope((yyvsp[(1) - (5)].string));
	   assert(ns->size() > 1);
	   printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
	   (yyval.statement) = new ExpressionStatement((yylsp[(1) - (5)]).first_line, (yylsp[(1) - (5)]).last_line, new StaticMethodCallNode(ns, makeArgs((yyvsp[(3) - (5)].node))));
	}
    break;

  case 56:
/* Line 1787 of yacc.c  */
#line 1737 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 57:
/* Line 1787 of yacc.c  */
#line 1738 "parser.ypp"
    {
	   (yyval.statement) = new RethrowStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
	}
    break;

  case 58:
/* Line 1787 of yacc.c  */
#line 1741 "parser.ypp"
    {
	   (yyval.statement) = new ThrowStatement((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line, (yyvsp[(2) - (3)].node));
	}
    break;

  case 59:
/* Line 1787 of yacc.c  */
#line 1744 "parser.ypp"
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Unconditional);
	}
    break;

  case 60:
/* Line 1787 of yacc.c  */
#line 1747 "parser.ypp"
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Success);
	}
    break;

  case 61:
/* Line 1787 of yacc.c  */
#line 1750 "parser.ypp"
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Error);
	}
    break;

  case 62:
/* Line 1787 of yacc.c  */
#line 1753 "parser.ypp"
    {
	   (yyval.statement) = new ContextStatement((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, 0, 0, (yyvsp[(2) - (3)].cmods), (yyvsp[(3) - (3)].sblock));
	}
    break;

  case 63:
/* Line 1787 of yacc.c  */
#line 1756 "parser.ypp"
    {
	   (yyval.statement) = new SummarizeStatement((yylsp[(1) - (11)]).first_line, (yylsp[(11) - (11)]).last_line, (yyvsp[(2) - (11)].string), (yyvsp[(4) - (11)].node), (yyvsp[(10) - (11)].cmods), (yyvsp[(11) - (11)].sblock), (yyvsp[(8) - (11)].node));
	}
    break;

  case 64:
/* Line 1787 of yacc.c  */
#line 1759 "parser.ypp"
    {
	   (yyval.statement) = new ContextStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].string), (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].cmods), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 65:
/* Line 1787 of yacc.c  */
#line 1762 "parser.ypp"
    {	
	   (yyval.statement) = new IfStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock));
	}
    break;

  case 66:
/* Line 1787 of yacc.c  */
#line 1765 "parser.ypp"
    {
	   (yyval.statement) = new IfStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].sblock), (yyvsp[(7) - (7)].sblock));
	}
    break;

  case 67:
/* Line 1787 of yacc.c  */
#line 1768 "parser.ypp"
    {
	   (yyval.statement) = new WhileStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock));
	}
    break;

  case 68:
/* Line 1787 of yacc.c  */
#line 1771 "parser.ypp"
    {
	   (yyval.statement) = new DoWhileStatement((yylsp[(1) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), (yyvsp[(2) - (7)].sblock));
	}
    break;

  case 69:
/* Line 1787 of yacc.c  */
#line 1774 "parser.ypp"
    {
	   (yyval.statement) = new ForStatement((yylsp[(1) - (9)]).first_line, (yylsp[(9) - (9)]).last_line, (yyvsp[(3) - (9)].node), (yyvsp[(5) - (9)].node), (yyvsp[(7) - (9)].node), (yyvsp[(9) - (9)].sblock));
	}
    break;

  case 70:
/* Line 1787 of yacc.c  */
#line 1777 "parser.ypp"
    {
	   (yyval.statement) = new ForEachStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].node), (yyvsp[(5) - (7)].node), (yyvsp[(7) - (7)].sblock));
	}
    break;

  case 71:
/* Line 1787 of yacc.c  */
#line 1780 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (2)].statement); }
    break;

  case 72:
/* Line 1787 of yacc.c  */
#line 1781 "parser.ypp"
    {
	   // see if thread exit is allowed
	   if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
	      parse_error("illegal use of \"thread_exit\" (conflicts with parse option NO_THREAD_CONTROL)");

	   (yyval.statement) = new ThreadExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line); 
	}
    break;

  case 73:
/* Line 1787 of yacc.c  */
#line 1788 "parser.ypp"
    {
	  (yyval.statement) = new BreakStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
	}
    break;

  case 74:
/* Line 1787 of yacc.c  */
#line 1791 "parser.ypp"
    {
	  (yyval.statement) = new ContinueStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
	}
    break;

  case 75:
/* Line 1787 of yacc.c  */
#line 1794 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 76:
/* Line 1787 of yacc.c  */
#line 1795 "parser.ypp"
    { (yyval.statement) = 0; }
    break;

  case 77:
/* Line 1787 of yacc.c  */
#line 1800 "parser.ypp"
    { (yyval.cmods) = 0; }
    break;

  case 78:
/* Line 1787 of yacc.c  */
#line 1801 "parser.ypp"
    { 
	   if (!(yyvsp[(1) - (2)].cmods)) 
	      (yyval.cmods) = new ContextModList((yyvsp[(2) - (2)].cmod)); 
	   else { 
	      (yyvsp[(1) - (2)].cmods)->addContextMod((yyvsp[(2) - (2)].cmod)); 
	      (yyval.cmods) = (yyvsp[(1) - (2)].cmods); 
	   }
	}
    break;

  case 79:
/* Line 1787 of yacc.c  */
#line 1813 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[(3) - (4)].node)); }
    break;

  case 80:
/* Line 1787 of yacc.c  */
#line 1815 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[(3) - (4)].node)); }
    break;

  case 81:
/* Line 1787 of yacc.c  */
#line 1817 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[(3) - (4)].node)); }
    break;

  case 82:
/* Line 1787 of yacc.c  */
#line 1821 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line); }
    break;

  case 83:
/* Line 1787 of yacc.c  */
#line 1823 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].node)); }
    break;

  case 84:
/* Line 1787 of yacc.c  */
#line 1828 "parser.ypp"
    {
	   (yyvsp[(6) - (7)].switchstmt)->setSwitch((yyvsp[(3) - (7)].node));
	   (yyval.statement) = (yyvsp[(6) - (7)].switchstmt);
	   (yyval.statement)->loc.start_line = (yylsp[(1) - (7)]).first_line;
	   (yyval.statement)->loc.end_line = (yylsp[(7) - (7)]).last_line;
        }
    break;

  case 85:
/* Line 1787 of yacc.c  */
#line 1838 "parser.ypp"
    {
	   (yyval.switchstmt) = new SwitchStatement((yyvsp[(1) - (1)].casenode));
	}
    break;

  case 86:
/* Line 1787 of yacc.c  */
#line 1842 "parser.ypp"
    {
	   (yyvsp[(1) - (2)].switchstmt)->addCase((yyvsp[(2) - (2)].casenode));
	   (yyval.switchstmt) = (yyvsp[(1) - (2)].switchstmt);
        }
    break;

  case 87:
/* Line 1787 of yacc.c  */
#line 1850 "parser.ypp"
    {
	   check_case(">=", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_GE);
        }
    break;

  case 88:
/* Line 1787 of yacc.c  */
#line 1855 "parser.ypp"
    {
	   check_case(">=", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_GE);
        }
    break;

  case 89:
/* Line 1787 of yacc.c  */
#line 1861 "parser.ypp"
    {
	   check_case("<=", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_LE);
        }
    break;

  case 90:
/* Line 1787 of yacc.c  */
#line 1866 "parser.ypp"
    {
	   check_case("<=", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_LE);
        }
    break;

  case 91:
/* Line 1787 of yacc.c  */
#line 1872 "parser.ypp"
    {
	   check_case("==", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_EQ);
        }
    break;

  case 92:
/* Line 1787 of yacc.c  */
#line 1877 "parser.ypp"
    {
	   check_case("==", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_EQ);
        }
    break;

  case 93:
/* Line 1787 of yacc.c  */
#line 1883 "parser.ypp"
    {
	   check_case("<", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_LT);
        }
    break;

  case 94:
/* Line 1787 of yacc.c  */
#line 1888 "parser.ypp"
    {
	   check_case("<", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_LT);
        }
    break;

  case 95:
/* Line 1787 of yacc.c  */
#line 1894 "parser.ypp"
    {
	   check_case(">", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_GT);
        }
    break;

  case 96:
/* Line 1787 of yacc.c  */
#line 1899 "parser.ypp"
    {
	   check_case(">", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_GT);
        }
    break;

  case 97:
/* Line 1787 of yacc.c  */
#line 1905 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
	}
    break;

  case 98:
/* Line 1787 of yacc.c  */
#line 1909 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[(3) - (4)].Regex), 0);
	}
    break;

  case 99:
/* Line 1787 of yacc.c  */
#line 1914 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeNegRegex((yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
	}
    break;

  case 100:
/* Line 1787 of yacc.c  */
#line 1918 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeNegRegex((yyvsp[(3) - (4)].Regex), 0);
	}
    break;

  case 101:
/* Line 1787 of yacc.c  */
#line 1923 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[(2) - (4)].Regex), (yyvsp[(4) - (4)].sblock));
	}
    break;

  case 102:
/* Line 1787 of yacc.c  */
#line 1927 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[(2) - (3)].Regex), 0);
	}
    break;

  case 103:
/* Line 1787 of yacc.c  */
#line 1932 "parser.ypp"
    {
	   check_case(0, (yyvsp[(2) - (4)].node));
	   (yyval.casenode) = new CaseNode((yyvsp[(2) - (4)].node), (yyvsp[(4) - (4)].sblock));
	}
    break;

  case 104:
/* Line 1787 of yacc.c  */
#line 1937 "parser.ypp"
    {
	   check_case(0, (yyvsp[(2) - (3)].node));
	   (yyval.casenode) = new CaseNode((yyvsp[(2) - (3)].node), 0);
	}
    break;

  case 105:
/* Line 1787 of yacc.c  */
#line 1943 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNode(0, (yyvsp[(3) - (3)].sblock));
	}
    break;

  case 106:
/* Line 1787 of yacc.c  */
#line 1947 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNode(0, 0);
	}
    break;

  case 107:
/* Line 1787 of yacc.c  */
#line 1953 "parser.ypp"
    {
	   char* param = 0;
	   if ((yyvsp[(5) - (7)].node)) {
	      if ((yyvsp[(5) - (7)].node)->getType() == NT_VARREF) 
		 param = reinterpret_cast<VarRefNode*>((yyvsp[(5) - (7)].node))->takeName();
	      else if ((yyvsp[(5) - (7)].node)->getType() == NT_BAREWORD) {
		 param = reinterpret_cast<BarewordNode*>((yyvsp[(5) - (7)].node))->takeString();
		 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
		    parse_error("local variable '%s' in catch parameter list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", param);
	      }
	      else
		 parse_error("only one parameter accepted in catch block for exception hash");
	      (yyvsp[(5) - (7)].node)->deref(0);
	   }
	   (yyval.statement) = new TryStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].sblock), (yyvsp[(7) - (7)].sblock), param);
	}
    break;

  case 108:
/* Line 1787 of yacc.c  */
#line 1971 "parser.ypp"
    { (yyval.node) = 0; }
    break;

  case 109:
/* Line 1787 of yacc.c  */
#line 1972 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].node); }
    break;

  case 110:
/* Line 1787 of yacc.c  */
#line 1973 "parser.ypp"
    { (yyval.node) = 0; }
    break;

  case 111:
/* Line 1787 of yacc.c  */
#line 1977 "parser.ypp"
    {
           check_classmod((yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
           qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (6)].string), (yyvsp[(5) - (6)].qoreclass));
	}
    break;

  case 112:
/* Line 1787 of yacc.c  */
#line 1982 "parser.ypp"
    {
           check_classmod((yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (6)].nscope), (yyvsp[(5) - (6)].qoreclass));
           qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
	}
    break;

  case 113:
/* Line 1787 of yacc.c  */
#line 1987 "parser.ypp"
    {
           // class name is set automatically from name saved in scanner
	   QoreClass *qc = new QoreClass;
           check_classmod((yyvsp[(1) - (4)].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (4)].string), qc);
	}
    break;

  case 114:
/* Line 1787 of yacc.c  */
#line 1994 "parser.ypp"
    {
           // class name is set automatically from name saved in scanner
	   QoreClass *qc = new QoreClass;
           check_classmod((yyvsp[(1) - (4)].i4), *qc);
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (4)].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
	}
    break;

  case 115:
/* Line 1787 of yacc.c  */
#line 2001 "parser.ypp"
    {
           // class name is set automatically from name saved in scanner
	   QoreClass *qc = new QoreClass;
           check_classmod((yyvsp[(1) - (5)].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (5)].string), qc);
	}
    break;

  case 116:
/* Line 1787 of yacc.c  */
#line 2008 "parser.ypp"
    {
           // class name is set automatically from name saved in scanner
	   QoreClass *qc = new QoreClass;
           check_classmod((yyvsp[(1) - (5)].i4), *qc);
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (5)].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
	}
    break;

  case 117:
/* Line 1787 of yacc.c  */
#line 2018 "parser.ypp"
    {
	   (yyval.sclist) = (yyvsp[(2) - (2)].sclist);
        }
    break;

  case 118:
/* Line 1787 of yacc.c  */
#line 2021 "parser.ypp"
    { // NOTHING
           (yyval.sclist) = 0;
	}
    break;

  case 119:
/* Line 1787 of yacc.c  */
#line 2027 "parser.ypp"
    {
	   (yyval.sclist) = new BCList((yyvsp[(1) - (1)].sclnode));
	}
    break;

  case 120:
/* Line 1787 of yacc.c  */
#line 2030 "parser.ypp"
    {
	   (yyvsp[(1) - (3)].sclist)->push_back((yyvsp[(3) - (3)].sclnode));
	   (yyval.sclist) = (yyvsp[(1) - (3)].sclist);
        }
    break;

  case 121:
/* Line 1787 of yacc.c  */
#line 2037 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode((yyvsp[(1) - (1)].string), false);
	}
    break;

  case 122:
/* Line 1787 of yacc.c  */
#line 2040 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[(1) - (1)].string)), false);
	}
    break;

  case 123:
/* Line 1787 of yacc.c  */
#line 2043 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode((yyvsp[(2) - (2)].string), false);
	}
    break;

  case 124:
/* Line 1787 of yacc.c  */
#line 2046 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[(2) - (2)].string)), false);
	}
    break;

  case 125:
/* Line 1787 of yacc.c  */
#line 2049 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode((yyvsp[(2) - (2)].string), true);
	}
    break;

  case 126:
/* Line 1787 of yacc.c  */
#line 2052 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[(2) - (2)].string)), true);
	}
    break;

  case 127:
/* Line 1787 of yacc.c  */
#line 2058 "parser.ypp"
    { 
           (yyval.qoreclass) = new QoreClass;
	   (yyvsp[(1) - (1)].methodnode)->addAndDelete((yyval.qoreclass));
	}
    break;

  case 128:
/* Line 1787 of yacc.c  */
#line 2062 "parser.ypp"
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyvsp[(1) - (1)].memberlist)->mergePrivate((yyval.qoreclass));
	   delete (yyvsp[(1) - (1)].memberlist);
	}
    break;

  case 129:
/* Line 1787 of yacc.c  */
#line 2067 "parser.ypp"
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyvsp[(1) - (1)].memberlist)->mergePublic((yyval.qoreclass));
	   delete (yyvsp[(1) - (1)].memberlist);
	}
    break;

  case 130:
/* Line 1787 of yacc.c  */
#line 2072 "parser.ypp"
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyval.qoreclass)->parseAddPublicConstant((yyvsp[(1) - (1)].constnode)->getName(), (yyvsp[(1) - (1)].constnode)->takeValue());
	   delete (yyvsp[(1) - (1)].constnode);
	}
    break;

  case 131:
/* Line 1787 of yacc.c  */
#line 2077 "parser.ypp"
    { 
	   (yyvsp[(2) - (2)].methodnode)->addAndDelete((yyvsp[(1) - (2)].qoreclass));
	   (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass); 
	}
    break;

  case 132:
/* Line 1787 of yacc.c  */
#line 2081 "parser.ypp"
    { 
	   (yyvsp[(2) - (2)].memberlist)->mergePrivate((yyvsp[(1) - (2)].qoreclass));
	   (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
	   delete (yyvsp[(2) - (2)].memberlist);
	}
    break;

  case 133:
/* Line 1787 of yacc.c  */
#line 2086 "parser.ypp"
    {
	   (yyvsp[(2) - (2)].memberlist)->mergePublic((yyvsp[(1) - (2)].qoreclass));
	   (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass); 
	   delete (yyvsp[(2) - (2)].memberlist);
	}
    break;

  case 134:
/* Line 1787 of yacc.c  */
#line 2091 "parser.ypp"
    {
	   (yyval.qoreclass)->parseAddPublicConstant((yyvsp[(2) - (2)].constnode)->getName(), (yyvsp[(2) - (2)].constnode)->takeValue());
	   (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
	   delete (yyvsp[(2) - (2)].constnode);
	}
    break;

  case 135:
/* Line 1787 of yacc.c  */
#line 2112 "parser.ypp"
    {
	   (yyval.parsertype) = new ParserTypeStruct((yyvsp[(1) - (1)].string));
	}
    break;

  case 136:
/* Line 1787 of yacc.c  */
#line 2115 "parser.ypp"
    {
	   (yyval.parsertype) = new ParserScopedTypeStruct((yyvsp[(1) - (1)].string));
        }
    break;

  case 137:
/* Line 1787 of yacc.c  */
#line 2118 "parser.ypp"
    {
	   (yyval.parsertype) = new ParserOrNothingTypeStruct((yyvsp[(2) - (2)].string));
        }
    break;

  case 138:
/* Line 1787 of yacc.c  */
#line 2121 "parser.ypp"
    {
	   (yyval.parsertype) = new ParserScopedOrNothingTypeStruct((yyvsp[(2) - (2)].string));
        }
    break;

  case 139:
/* Line 1787 of yacc.c  */
#line 2128 "parser.ypp"
    { (yyval.parsertype) = 0; }
    break;

  case 140:
/* Line 1787 of yacc.c  */
#line 2129 "parser.ypp"
    {
           (yyval.parsertype) = (yyvsp[(1) - (1)].parsertype);
        }
    break;

  case 141:
/* Line 1787 of yacc.c  */
#line 2135 "parser.ypp"
    {
	   (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist);
	}
    break;

  case 142:
/* Line 1787 of yacc.c  */
#line 2138 "parser.ypp"
    {
	   (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist);
	}
    break;

  case 143:
/* Line 1787 of yacc.c  */
#line 2144 "parser.ypp"
    {
	   (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist);
	}
    break;

  case 144:
/* Line 1787 of yacc.c  */
#line 2147 "parser.ypp"
    {
	   (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist);
	}
    break;

  case 145:
/* Line 1787 of yacc.c  */
#line 2150 "parser.ypp"
    {
	   (yyval.memberlist) = new EmptyPublicMemberList;
	}
    break;

  case 146:
/* Line 1787 of yacc.c  */
#line 2156 "parser.ypp"
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (4)].string), new QoreVarInfo((yylsp[(2) - (4)]).first_line, (yylsp[(3) - (4)]).last_line, (yyvsp[(2) - (4)].parsertype)->getTypeInfo(), (yyvsp[(2) - (4)].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[(2) - (4)].parsertype);
	}
    break;

  case 147:
/* Line 1787 of yacc.c  */
#line 2160 "parser.ypp"
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (3)].string), new QoreVarInfo((yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line));
	}
    break;

  case 148:
/* Line 1787 of yacc.c  */
#line 2163 "parser.ypp"
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (6)].string), new QoreVarInfo((yylsp[(2) - (6)]).first_line, (yylsp[(5) - (6)]).last_line, (yyvsp[(2) - (6)].parsertype)->getTypeInfo(), (yyvsp[(2) - (6)].parsertype)->getParseTypeInfo(), (yyvsp[(5) - (6)].node)));
	   //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
	   delete (yyvsp[(2) - (6)].parsertype);
        }
    break;

  case 149:
/* Line 1787 of yacc.c  */
#line 2168 "parser.ypp"
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (5)].string), new QoreVarInfo((yylsp[(2) - (5)]).first_line, (yylsp[(4) - (5)]).last_line, (yyvsp[(4) - (5)].node)));
	}
    break;

  case 150:
/* Line 1787 of yacc.c  */
#line 2171 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(2) - (7)].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[(2) - (7)].parsertype)->getClassName())), makeArgs((yyvsp[(5) - (7)].node)));

	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (7)].string), new QoreVarInfo((yylsp[(2) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(2) - (7)].parsertype)->getTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[(2) - (7)].parsertype);
	}
    break;

  case 151:
/* Line 1787 of yacc.c  */
#line 2186 "parser.ypp"
    {
	   int fl = (yyvsp[(1) - (3)].parsertype) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(fl, (yylsp[(2) - (3)]).last_line, (yyvsp[(1) - (3)].parsertype)->getTypeInfo(), (yyvsp[(1) - (3)].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[(1) - (3)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (3)].string));
	}
    break;

  case 152:
/* Line 1787 of yacc.c  */
#line 2193 "parser.ypp"
    {
	   int fl = (yyvsp[(1) - (5)].parsertype) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(fl, (yylsp[(4) - (5)]).last_line, (yyvsp[(1) - (5)].parsertype)->getTypeInfo(), (yyvsp[(1) - (5)].parsertype)->getParseTypeInfo(), (yyvsp[(4) - (5)].node)));
	   delete (yyvsp[(1) - (5)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (5)].string));
	}
    break;

  case 153:
/* Line 1787 of yacc.c  */
#line 2200 "parser.ypp"
    {
	   int fl = (yyvsp[(1) - (6)].parsertype) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line;
	   const QoreTypeInfo* t = (yyvsp[(1) - (6)].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (!(yyvsp[(1) - (6)].parsertype))
	      parse_error("cannot call constructor without declaring the class");
	   else if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[(1) - (6)].parsertype)->getClassName())), makeArgs((yyvsp[(4) - (6)].node)));

	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(fl, (yylsp[(4) - (6)]).last_line, (yyvsp[(1) - (6)].parsertype)->getTypeInfo(), (yyvsp[(1) - (6)].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[(1) - (6)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (6)].string));
	}
    break;

  case 154:
/* Line 1787 of yacc.c  */
#line 2218 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (3)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(fl, (yylsp[(2) - (3)]).last_line, (yyvsp[(1) - (3)].parsertype)->getTypeInfo(), (yyvsp[(1) - (3)].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[(1) - (3)].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (3)].string));
	}
    break;

  case 155:
/* Line 1787 of yacc.c  */
#line 2225 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (5)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(fl, (yylsp[(4) - (5)]).last_line, (yyvsp[(1) - (5)].parsertype)->getTypeInfo(), (yyvsp[(1) - (5)].parsertype)->getParseTypeInfo(), (yyvsp[(4) - (5)].node)));
	   delete (yyvsp[(1) - (5)].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (5)].string));
	}
    break;

  case 156:
/* Line 1787 of yacc.c  */
#line 2232 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (6)]).first_line;
	   const QoreTypeInfo* t = (yyvsp[(1) - (6)].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (!(yyvsp[(1) - (6)].parsertype))
	      parse_error("cannot call constructor without declaring the class");
	   else if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[(1) - (6)].parsertype)->getClassName())), makeArgs((yyvsp[(4) - (6)].node)));

	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(fl, (yylsp[(4) - (6)]).last_line, (yyvsp[(1) - (6)].parsertype)->getTypeInfo(), (yyvsp[(1) - (6)].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[(1) - (6)].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (6)].string));
	}
    break;

  case 157:
/* Line 1787 of yacc.c  */
#line 2250 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (2)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo(fl, (yylsp[(1) - (2)]).last_line));
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (2)].string));
	}
    break;

  case 158:
/* Line 1787 of yacc.c  */
#line 2256 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (4)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (4)].string), new QoreMemberInfo(fl, (yylsp[(3) - (4)]).last_line, (yyvsp[(3) - (4)].node)));
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (4)].string));
	}
    break;

  case 159:
/* Line 1787 of yacc.c  */
#line 2262 "parser.ypp"
    {
	   (yyval.memberinfo) = (yyvsp[(1) - (1)].classvarinfo);
	}
    break;

  case 160:
/* Line 1787 of yacc.c  */
#line 2265 "parser.ypp"
    {
           if ((yyvsp[(1) - (1)].constnode)->pub)
              parse_error("cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[(1) - (1)].constnode)->name.ostr);
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (1)].constnode)->name.takeName(), (yyvsp[(1) - (1)].constnode)->value);
	   delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 161:
/* Line 1787 of yacc.c  */
#line 2274 "parser.ypp"
    {
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (1)].string));
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
        }
    break;

  case 162:
/* Line 1787 of yacc.c  */
#line 2279 "parser.ypp"
    {
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].string)));
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (2)].string));
	}
    break;

  case 163:
/* Line 1787 of yacc.c  */
#line 2287 "parser.ypp"
    {
	   (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 164:
/* Line 1787 of yacc.c  */
#line 2290 "parser.ypp"
    {
	   (yyvsp[(1) - (3)].memberlist)->add((yyvsp[(3) - (3)].memberinfo));
	   (yyval.memberlist) = (yyvsp[(1) - (3)].memberlist);
	}
    break;

  case 165:
/* Line 1787 of yacc.c  */
#line 2297 "parser.ypp"
    {
	   (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 166:
/* Line 1787 of yacc.c  */
#line 2300 "parser.ypp"
    {
	   (yyvsp[(1) - (2)].memberlist)->add((yyvsp[(2) - (2)].memberinfo));
	   (yyval.memberlist) = (yyvsp[(1) - (2)].memberlist);
	}
    break;

  case 167:
/* Line 1787 of yacc.c  */
#line 2307 "parser.ypp"
    {
	   (yyval.string) = (yyvsp[(1) - (2)].string);
        }
    break;

  case 168:
/* Line 1787 of yacc.c  */
#line 2310 "parser.ypp"
    {
           (yyval.string) = strdup("keys");
        }
    break;

  case 169:
/* Line 1787 of yacc.c  */
#line 2313 "parser.ypp"
    {
	   (yyval.string) = (yyvsp[(1) - (1)].string);
        }
    break;

  case 170:
/* Line 1787 of yacc.c  */
#line 2319 "parser.ypp"
    {
           if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(7) - (7)].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   checkMethod((yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
	   (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), newMethodVariant((yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock), (yyvsp[(1) - (7)].i4) & OFM_DEPRECATED), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
	}
    break;

  case 171:
/* Line 1787 of yacc.c  */
#line 2329 "parser.ypp"
    {
           if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(7) - (7)].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (7)].parsertype);
	   
	   checkMethod((yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

	   (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), newMethodVariant((yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock), (yyvsp[(1) - (7)].i4) & OFM_DEPRECATED), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
	}
    break;

  case 172:
/* Line 1787 of yacc.c  */
#line 2343 "parser.ypp"
    {
           if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           checkMethod((yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
           (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), newMethodVariant((yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), 0, (yyvsp[(1) - (7)].i4) & OFM_DEPRECATED), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 173:
/* Line 1787 of yacc.c  */
#line 2349 "parser.ypp"
    {
           if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getTypeInfo());
           delete (yyvsp[(2) - (7)].parsertype);

           checkMethod((yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

           (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), newMethodVariant((yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].bcalist), rt, 0, (yyvsp[(1) - (7)].i4) & OFM_DEPRECATED), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 174:
/* Line 1787 of yacc.c  */
#line 2362 "parser.ypp"
    {
           if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(8) - (8)].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }

           (yyval.methoddef) = new MethodDef((yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].node), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(8) - (8)].sblock));
	}
    break;

  case 175:
/* Line 1787 of yacc.c  */
#line 2372 "parser.ypp"
    {
           if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(8) - (8)].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (8)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (8)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (8)].parsertype);

	   (yyval.methoddef) = new MethodDef((yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].node), (yyvsp[(7) - (8)].bcalist), rt, (yyvsp[(8) - (8)].sblock));
	}
    break;

  case 176:
/* Line 1787 of yacc.c  */
#line 2384 "parser.ypp"
    {
           if (!(yyvsp[(1) - (8)].i4) & OFM_ABSTRACT)
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           (yyval.methoddef) = new MethodDef((yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].node), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), 0);
        }
    break;

  case 177:
/* Line 1787 of yacc.c  */
#line 2389 "parser.ypp"
    {
           if (!(yyvsp[(1) - (8)].i4) & OFM_ABSTRACT)
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (8)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (8)].parsertype)->getTypeInfo());
           delete (yyvsp[(2) - (8)].parsertype);

           (yyval.methoddef) = new MethodDef((yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].node), (yyvsp[(7) - (8)].bcalist), rt, 0);
        }
    break;

  case 178:
/* Line 1787 of yacc.c  */
#line 2397 "parser.ypp"
    {
	   (yyval.methoddef) = new MethodDef(0, (yyvsp[(1) - (7)].string), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock));
	}
    break;

  case 179:
/* Line 1787 of yacc.c  */
#line 2400 "parser.ypp"
    {
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(1) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(1) - (7)].parsertype);

	   (yyval.methoddef) = new MethodDef(0, (yyvsp[(2) - (7)].string), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock));
	}
    break;

  case 180:
/* Line 1787 of yacc.c  */
#line 2409 "parser.ypp"
    {
	   (yyval.bcalist) = (yyvsp[(2) - (2)].bcalist);
	}
    break;

  case 181:
/* Line 1787 of yacc.c  */
#line 2412 "parser.ypp"
    { // nothing
	   (yyval.bcalist) = 0;
	}
    break;

  case 182:
/* Line 1787 of yacc.c  */
#line 2418 "parser.ypp"
    {
	   (yyval.bcalist) = new BCAList((yyvsp[(1) - (1)].bcanode));
	}
    break;

  case 183:
/* Line 1787 of yacc.c  */
#line 2421 "parser.ypp"
    {
	   (yyvsp[(1) - (3)].bcalist)->push_back((yyvsp[(3) - (3)].bcanode));
	   (yyval.bcalist) = (yyvsp[(1) - (3)].bcalist);
	}
    break;

  case 184:
/* Line 1787 of yacc.c  */
#line 2428 "parser.ypp"
    {
	   (yyval.bcanode) = new BCANode((yyvsp[(1) - (4)].string), makeArgs((yyvsp[(3) - (4)].node)));
	}
    break;

  case 185:
/* Line 1787 of yacc.c  */
#line 2431 "parser.ypp"
    {
	   (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[(1) - (4)].string)), makeArgs((yyvsp[(3) - (4)].node)));
	}
    break;

  case 186:
/* Line 1787 of yacc.c  */
#line 2438 "parser.ypp"
    { (yyval.i4) = 0; }
    break;

  case 187:
/* Line 1787 of yacc.c  */
#line 2439 "parser.ypp"
    {
           (yyval.i4) = (yyvsp[(1) - (1)].i4);
        }
    break;

  case 188:
/* Line 1787 of yacc.c  */
#line 2444 "parser.ypp"
    { (yyval.i4) = (yyvsp[(1) - (1)].i4); }
    break;

  case 189:
/* Line 1787 of yacc.c  */
#line 2445 "parser.ypp"
    {
	   if (((yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4)) == (yyvsp[(1) - (2)].i4))
	      parse_error("modifier given twice");
	   (yyval.i4) = (yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4); 
	}
    break;

  case 190:
/* Line 1787 of yacc.c  */
#line 2453 "parser.ypp"
    { (yyval.i4) = OFM_PRIVATE; }
    break;

  case 191:
/* Line 1787 of yacc.c  */
#line 2454 "parser.ypp"
    { (yyval.i4) = OFM_STATIC; }
    break;

  case 192:
/* Line 1787 of yacc.c  */
#line 2455 "parser.ypp"
    { (yyval.i4) = OFM_SYNCED; }
    break;

  case 193:
/* Line 1787 of yacc.c  */
#line 2456 "parser.ypp"
    { (yyval.i4) = OFM_DEPRECATED; }
    break;

  case 194:
/* Line 1787 of yacc.c  */
#line 2457 "parser.ypp"
    { (yyval.i4) = OFM_PUBLIC; }
    break;

  case 195:
/* Line 1787 of yacc.c  */
#line 2458 "parser.ypp"
    { (yyval.i4) = OFM_FINAL; }
    break;

  case 196:
/* Line 1787 of yacc.c  */
#line 2459 "parser.ypp"
    { (yyval.i4) = OFM_ABSTRACT; }
    break;

  case 197:
/* Line 1787 of yacc.c  */
#line 2463 "parser.ypp"
    {
	   if (!(yyvsp[(2) - (2)].parsertype)) {
	      parse_error("missing type declaration after 'returns'");
	      (yyval.returnTypeInfo) = 0;
	   }
	   else {
	      (yyval.returnTypeInfo) = new RetTypeInfo((yyvsp[(2) - (2)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (2)].parsertype)->getTypeInfo());
	      delete (yyvsp[(2) - (2)].parsertype);
	   }
	}
    break;

  case 198:
/* Line 1787 of yacc.c  */
#line 2474 "parser.ypp"
    {
	   (yyval.returnTypeInfo) = 0;
	}
    break;

  case 199:
/* Line 1787 of yacc.c  */
#line 2479 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.parsefunc) = new ParseUserFunction((yyvsp[(2) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].node), (yyvsp[(5) - (6)].returnTypeInfo), false, flags));
	}
    break;

  case 200:
/* Line 1787 of yacc.c  */
#line 2484 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(1) - (6)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (6)].parsertype)->getTypeInfo());
	   delete (yyvsp[(1) - (6)].parsertype);

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[(3) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].node), rt, false, flags));
	}
    break;

  case 201:
/* Line 1787 of yacc.c  */
#line 2493 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (7)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
           
	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags)); 
           if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
	}
    break;

  case 202:
/* Line 1787 of yacc.c  */
#line 2504 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (7)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (7)].parsertype);

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[(4) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), rt, (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags)); 
           if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
	}
    break;

  case 203:
/* Line 1787 of yacc.c  */
#line 2520 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[(2) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].returnTypeInfo), false, flags));
	}
    break;

  case 204:
/* Line 1787 of yacc.c  */
#line 2525 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(1) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(1) - (7)].parsertype);

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), rt, false, flags));
	}
    break;

  case 205:
/* Line 1787 of yacc.c  */
#line 2534 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (8)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
           
	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[(3) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].node), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags)); 
           if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
	}
    break;

  case 206:
/* Line 1787 of yacc.c  */
#line 2545 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (8)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (8)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (8)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (8)].parsertype);

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[(4) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(6) - (8)]).first_line, (yylsp[(6) - (8)]).last_line, (yyvsp[(6) - (8)].node), rt, (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags)); 
           if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
	}
    break;

  case 207:
/* Line 1787 of yacc.c  */
#line 2563 "parser.ypp"
    { (yyval.list) = splice_expressions((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 208:
/* Line 1787 of yacc.c  */
#line 2564 "parser.ypp"
    {
	   QoreListNode* l;
	   if ((yyvsp[(1) - (2)].node) && (yyvsp[(1) - (2)].node)->getType() == NT_LIST) 
	      l = reinterpret_cast<QoreListNode*>((yyvsp[(1) - (2)].node));
	   else {
	      l = new QoreListNode;
	      l->push((yyvsp[(1) - (2)].node));
	      // parse_error("problem in parsing ',' in list: left side of comma is not a list (type: '%s')", $1 ? $1->getTypeName() : "NOTHING");
	      // so we don't insert null values in the parse tree
	   }
	   (yyval.list) = l;
        }
    break;

  case 209:
/* Line 1787 of yacc.c  */
#line 2579 "parser.ypp"
    {
	   (yyval.hash) = new QoreHashNode;
	   (yyval.hash)->setKeyValue((yyvsp[(1) - (1)].hashelement)->key, (yyvsp[(1) - (1)].hashelement)->value, 0);
	   delete (yyvsp[(1) - (1)].hashelement);
	}
    break;

  case 210:
/* Line 1787 of yacc.c  */
#line 2584 "parser.ypp"
    {
	   if ((yyvsp[(1) - (3)].hash)->existsKey((yyvsp[(3) - (3)].hashelement)->key))
	      QoreHashNode::doDuplicateKeyWarning((yyvsp[(3) - (3)].hashelement)->key);
	   (yyvsp[(1) - (3)].hash)->setKeyValue((yyvsp[(3) - (3)].hashelement)->key, (yyvsp[(3) - (3)].hashelement)->value, 0);
	   delete (yyvsp[(3) - (3)].hashelement);
	   (yyval.hash) = (yyvsp[(1) - (3)].hash);
	}
    break;

  case 211:
/* Line 1787 of yacc.c  */
#line 2592 "parser.ypp"
    { /* empty ',' on end of hash */ (yyval.hash)=(yyvsp[(1) - (2)].hash); }
    break;

  case 212:
/* Line 1787 of yacc.c  */
#line 2597 "parser.ypp"
    { (yyval.hashelement) = new HashElement((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 213:
/* Line 1787 of yacc.c  */
#line 2599 "parser.ypp"
    { (yyval.hashelement) = new HashElement(HE_TAG_CONST, (yyvsp[(1) - (3)].string), (yyvsp[(3) - (3)].node)); }
    break;

  case 214:
/* Line 1787 of yacc.c  */
#line 2601 "parser.ypp"
    { (yyval.hashelement) = new HashElement(HE_TAG_SCOPED_CONST, (yyvsp[(1) - (3)].string), (yyvsp[(3) - (3)].node)); }
    break;

  case 215:
/* Line 1787 of yacc.c  */
#line 2605 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].node); }
    break;

  case 216:
/* Line 1787 of yacc.c  */
#line 2607 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].binary); }
    break;

  case 217:
/* Line 1787 of yacc.c  */
#line 2609 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].list); }
    break;

  case 218:
/* Line 1787 of yacc.c  */
#line 2611 "parser.ypp"
    { (yyval.node) = (yyvsp[(2) - (3)].hash); }
    break;

  case 219:
/* Line 1787 of yacc.c  */
#line 2613 "parser.ypp"
    { (yyval.node) = new ScopedRefNode((yyvsp[(1) - (1)].string)); }
    break;

  case 220:
/* Line 1787 of yacc.c  */
#line 2614 "parser.ypp"
    {
	   if (!(yyvsp[(1) - (2)].parsertype) && !strcmp((yyvsp[(2) - (2)].string), "argv"))
	      inc_argv_ref();

	   if ((yyvsp[(1) - (2)].parsertype))
	      (yyval.node) = new VarRefDeclNode((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].string), get_var_type(), (yyvsp[(1) - (2)].parsertype)->getTypeInfo(), (yyvsp[(1) - (2)].parsertype)->getParseTypeInfo());
	   else
	      (yyval.node) = new VarRefNode((yyvsp[(2) - (2)].string), get_var_type());

	   delete (yyvsp[(1) - (2)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
	}
    break;

  case 221:
/* Line 1787 of yacc.c  */
#line 2627 "parser.ypp"
    {
	   if (!(yyvsp[(1) - (2)].parsertype) && !strcmp((yyvsp[(2) - (2)].string), "argv"))
	      inc_argv_ref();

	   if ((yyvsp[(1) - (2)].parsertype))
	      (yyval.node) = new VarRefDeclNode((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].string), get_var_type(), (yyvsp[(1) - (2)].parsertype)->getTypeInfo(), (yyvsp[(1) - (2)].parsertype)->getParseTypeInfo());
	   else
	      (yyval.node) = new VarRefNode((yyvsp[(2) - (2)].string), get_var_type());

	   delete (yyvsp[(1) - (2)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
	}
    break;

  case 222:
/* Line 1787 of yacc.c  */
#line 2640 "parser.ypp"
    {
	   (yyval.node) = new VarRefDeclNode((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].string), get_var_type(), (yyvsp[(1) - (2)].parsertype)->getTypeInfo(), (yyvsp[(1) - (2)].parsertype)->getParseTypeInfo());
	   delete (yyvsp[(1) - (2)].parsertype);
	}
    break;

  case 223:
/* Line 1787 of yacc.c  */
#line 2644 "parser.ypp"
    {
	   VarRefDeclNode* v = new VarRefDeclNode((yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(3) - (3)].string), VT_LOCAL, (yyvsp[(2) - (3)].parsertype)->getTypeInfo(), (yyvsp[(2) - (3)].parsertype)->getParseTypeInfo());
	   v->setExplicitScope();
	   (yyval.node) = v;
	   delete (yyvsp[(2) - (3)].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(3) - (3)].string));
	}
    break;

  case 224:
/* Line 1787 of yacc.c  */
#line 2652 "parser.ypp"
    {
	   // see if types are required
	   if (parse_check_parse_option(PO_REQUIRE_TYPES))
	      parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(2) - (2)].string));
	   VarRefNode* v = new VarRefNode((yyvsp[(2) - (2)].string), VT_LOCAL);
	   v->setExplicitScope();
	   (yyval.node) = v;
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (2)].string));
	}
    break;

  case 225:
/* Line 1787 of yacc.c  */
#line 2662 "parser.ypp"
    {
	   VarRefNode* v;
	   if ((yyvsp[(2) - (3)].parsertype)) {
	      v = new VarRefDeclNode((yylsp[(3) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(3) - (3)].string), VT_LOCAL, (yyvsp[(2) - (3)].parsertype)->getTypeInfo(), (yyvsp[(2) - (3)].parsertype)->getParseTypeInfo());
	      delete (yyvsp[(2) - (3)].parsertype);
	   }
	   else {
	      // see if types are required
	      if (parse_check_parse_option(PO_REQUIRE_TYPES))
		 parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(3) - (3)].string));
	      v = new VarRefNode((yyvsp[(3) - (3)].string), VT_LOCAL);
	   }
	   v->setExplicitScope();
	   (yyval.node) = v;
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(3) - (3)].string));
	}
    break;

  case 226:
/* Line 1787 of yacc.c  */
#line 2679 "parser.ypp"
    {
	   (yyvsp[(3) - (4)].list)->setVariableList();
	   ListIterator li((yyvsp[(3) - (4)].list));
	   while (li.next()) {
	      AbstractQoreNode* n = li.getValue();
	      qore_type_t t = get_node_type(n);
	      if (t == NT_BAREWORD) {
		 BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
		 if (parse_check_parse_option(PO_REQUIRE_TYPES))
		    parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
		 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
		    parse_error("local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
		 VarRefNode* v = new VarRefNode(b->takeString(), VT_LOCAL);
		 v->setExplicitScope();
		 b->deref();
		 AbstractQoreNode** p = li.getValuePtr();
		 *p = v;
	      }
	      else if (t == NT_VARREF) {
		 VarRefNode* v = reinterpret_cast<VarRefNode*>(n);
		 // see if types are required
		 if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
		    parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
		 if (v->explicitScope()) {
		    if (v->getType() == VT_LOCAL)
		       parse_error("illegal use of 'my %s' in local variable declaration list", v->getName());
		    else if (v->getType() == VT_GLOBAL)
		       parse_error("illegal use of 'our %s' in local variable declaration list", v->getName());
		 }
		 else
		    v->makeLocal();
		 v->setExplicitScope();
	      }
	      else
		 parse_error("element %d in list following 'my' is not a variable reference (%s)", li.index(), get_type_name(n));
	   }
	   (yyval.node) = (yyvsp[(3) - (4)].list);
        }
    break;

  case 227:
/* Line 1787 of yacc.c  */
#line 2717 "parser.ypp"
    {
           (yyval.node) = (yyvsp[(1) - (1)].gv)->makeVar();
        }
    break;

  case 228:
/* Line 1787 of yacc.c  */
#line 2721 "parser.ypp"
    {
	   if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[(1) - (1)].string), "argv"))
	      inc_argv_ref();

	   (yyval.node) = new BarewordNode((yyvsp[(1) - (1)].string), (yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
	}
    break;

  case 229:
/* Line 1787 of yacc.c  */
#line 2728 "parser.ypp"
    { (yyval.node) = new ContextrefNode((yyvsp[(1) - (1)].string)); }
    break;

  case 230:
/* Line 1787 of yacc.c  */
#line 2730 "parser.ypp"
    { (yyval.node) = new ContextRowNode; }
    break;

  case 231:
/* Line 1787 of yacc.c  */
#line 2732 "parser.ypp"
    { (yyval.node) = new ComplexContextrefNode((yyvsp[(1) - (1)].string)); }
    break;

  case 232:
/* Line 1787 of yacc.c  */
#line 2734 "parser.ypp"
    { (yyval.node) = new FindNode((yyvsp[(2) - (8)].node), (yyvsp[(4) - (8)].node), (yyvsp[(7) - (8)].node)); }
    break;

  case 233:
/* Line 1787 of yacc.c  */
#line 2735 "parser.ypp"
    {
           (yyval.node) = new QorePlusEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 234:
/* Line 1787 of yacc.c  */
#line 2738 "parser.ypp"
    {
           (yyval.node) = new QoreMinusEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 235:
/* Line 1787 of yacc.c  */
#line 2741 "parser.ypp"
    {
           (yyval.node) = new QoreAndEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 236:
/* Line 1787 of yacc.c  */
#line 2744 "parser.ypp"
    {
           (yyval.node) = new QoreOrEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 237:
/* Line 1787 of yacc.c  */
#line 2747 "parser.ypp"
    {
           (yyval.node) = new QoreModulaEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 238:
/* Line 1787 of yacc.c  */
#line 2750 "parser.ypp"
    {
           (yyval.node) = new QoreMultiplyEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 239:
/* Line 1787 of yacc.c  */
#line 2753 "parser.ypp"
    {
           (yyval.node) = new QoreDivideEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 240:
/* Line 1787 of yacc.c  */
#line 2756 "parser.ypp"
    {
           (yyval.node) = new QoreXorEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 241:
/* Line 1787 of yacc.c  */
#line 2759 "parser.ypp"
    {
           (yyval.node) = new QoreShiftLeftEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 242:
/* Line 1787 of yacc.c  */
#line 2762 "parser.ypp"
    {
           (yyval.node) = new QoreShiftRightEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 243:
/* Line 1787 of yacc.c  */
#line 2765 "parser.ypp"
    {
	   if ((yyvsp[(1) - (3)].node) && (yyvsp[(1) - (3)].node)->getType() == NT_LIST) {
	      (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LIST_ASSIGNMENT, (yyvsp[(3) - (3)].node));
	   }
	   else {
	      (yyval.node) = new QoreAssignmentOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	   }
	   //print_tree($1, 0);
	}
    break;

  case 244:
/* Line 1787 of yacc.c  */
#line 2775 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_EXISTS, 0); }
    break;

  case 245:
/* Line 1787 of yacc.c  */
#line 2777 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_ELEMENTS, 0); }
    break;

  case 246:
/* Line 1787 of yacc.c  */
#line 2778 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[(3) - (3)].string)));
	}
    break;

  case 247:
/* Line 1787 of yacc.c  */
#line 2781 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[(3) - (3)].string)));
	}
    break;

  case 248:
/* Line 1787 of yacc.c  */
#line 2785 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_KEYS, 0); }
    break;

  case 249:
/* Line 1787 of yacc.c  */
#line 2786 "parser.ypp"
    {  // unshift list, element
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].node)->getTypeName());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreTreeNode(lv, OP_UNSHIFT, l->shift());
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 250:
/* Line 1787 of yacc.c  */
#line 2798 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_SHIFT, 0); 
	}
    break;

  case 251:
/* Line 1787 of yacc.c  */
#line 2801 "parser.ypp"
    {  // push lvalue-list, element
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].node)->getTypeName());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreTreeNode(lv, OP_PUSH, l->shift());
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 252:
/* Line 1787 of yacc.c  */
#line 2813 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_POP, 0); 
	}
    break;

  case 253:
/* Line 1787 of yacc.c  */
#line 2816 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_CHOMP, 0); 
	}
    break;

  case 254:
/* Line 1787 of yacc.c  */
#line 2819 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_TRIM, 0); 
	}
    break;

  case 255:
/* Line 1787 of yacc.c  */
#line 2822 "parser.ypp"
    {  // splice lvalue-list, offset, [length, list]
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l) {
	      parse_error("invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else if (l->size() < 2) {
	      parse_error("too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else if (l->size() > 4) {
	      parse_error("too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreSpliceOperatorNode(lv, l->shift(), l->shift(), l->shift());
	      discard(l, 0);
	   }
	}
    break;

  case 256:
/* Line 1787 of yacc.c  */
#line 2842 "parser.ypp"
    {  // extract lvalue-list, offset, [length, list]
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l) {
	      parse_error("invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else if (l->size() < 2) {
	      parse_error("too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else if (l->size() > 4) {
	      parse_error("too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreExtractOperatorNode(lv, l->shift(), l->shift(), l->shift());
	      discard(l, 0);
	   }
	}
    break;

  case 257:
/* Line 1787 of yacc.c  */
#line 2862 "parser.ypp"
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   int len = l ? (int)l->size() : 0;
	   if (!l || len < 2 || len > 3) {
	      parse_error("invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else if (len == 2) {
	      AbstractQoreNode* map_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(map_exp, OP_MAP, arg);
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	   else {
	      AbstractQoreNode* map_exp = l->shift();
	      (yyval.node) = new QoreTreeNode(map_exp, OP_MAP_SELECT, l);
	   }
	}
    break;

  case 258:
/* Line 1787 of yacc.c  */
#line 2881 "parser.ypp"
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* code_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(code_exp, OP_FOLDR, arg);
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 259:
/* Line 1787 of yacc.c  */
#line 2895 "parser.ypp"
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* code_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(code_exp, OP_FOLDL, arg);
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 260:
/* Line 1787 of yacc.c  */
#line 2909 "parser.ypp"
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* arg = l->shift();
	      AbstractQoreNode* select_exp = l->shift();
	      (yyval.node) = new QoreTreeNode(arg, OP_SELECT, select_exp);
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 261:
/* Line 1787 of yacc.c  */
#line 2924 "parser.ypp"
    { //$$ = new QoreTreeNode($1, OP_QUESTION_MARK, make_list($3, $5));
           (yyval.node) = new QoreQuestionMarkOperatorNode((yyvsp[(1) - (5)].node), (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].node));
        }
    break;

  case 262:
/* Line 1787 of yacc.c  */
#line 2927 "parser.ypp"
    {  // pre-increment
           (yyval.node) = new QorePreIncrementOperatorNode((yyvsp[(2) - (2)].node));
        }
    break;

  case 263:
/* Line 1787 of yacc.c  */
#line 2930 "parser.ypp"
    {  // post-increment
           (yyval.node) = new QorePostIncrementOperatorNode((yyvsp[(1) - (2)].node));
        }
    break;

  case 264:
/* Line 1787 of yacc.c  */
#line 2933 "parser.ypp"
    {  // pre-decrement
           (yyval.node) = new QorePreDecrementOperatorNode((yyvsp[(2) - (2)].node));
        }
    break;

  case 265:
/* Line 1787 of yacc.c  */
#line 2936 "parser.ypp"
    {   // post-decrement
           (yyval.node) = new QorePostDecrementOperatorNode((yyvsp[(1) - (2)].node));
        }
    break;

  case 266:
/* Line 1787 of yacc.c  */
#line 2939 "parser.ypp"
    {
	   //printd(5, "1=%s (%p), 3=%s (%p)\n", $1->getTypeName(), $1, $3 ? $3->getTypeName() : "n/a", $3); 
	   qore_type_t t = get_node_type((yyvsp[(1) - (4)].node));
	   if (t == NT_BAREWORD) {
	      BarewordNode* b = reinterpret_cast<BarewordNode*>((yyvsp[(1) - (4)].node));
	      // take string from node and delete node
	      char* str = b->takeString();
	      b->deref();
	      printd(5, "parsing call %s() args=%p %s\n", str, (yyvsp[(3) - (4)].node), (yyvsp[(3) - (4)].node) ? (yyvsp[(3) - (4)].node)->getTypeName() : "n/a");
	      (yyval.node) = new FunctionCallNode(str, makeArgs((yyvsp[(3) - (4)].node)));
	   }
	   else if (t == NT_CONSTANT) {
	      ScopedRefNode* c = reinterpret_cast<ScopedRefNode*>((yyvsp[(1) - (4)].node));
	      // take NamedScope from node and delete node
	      NamedScope *ns = c->takeName();
	      c->deref();
	      assert(ns->size() > 1);
	      printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
	      (yyval.node) = new StaticMethodCallNode(ns, makeArgs((yyvsp[(3) - (4)].node)));
	   }
	   else if (t == NT_SELF_VARREF) {
	      SelfVarrefNode* v = reinterpret_cast<SelfVarrefNode*>((yyvsp[(1) - (4)].node));
	      // take string from node and delete node
	      char* str = v->takeString();
	      v->deref();
	      printd(5, "parsing in-object method call %s()\n", str);
	      (yyval.node) = new SelfFunctionCallNode(str, makeArgs((yyvsp[(3) - (4)].node)));
	   }
	   else {
	      QoreTreeNode* tree;
	      
	      if (t == NT_TREE) {
		 tree = reinterpret_cast<QoreTreeNode*>((yyvsp[(1) - (4)].node));
		 if (!(tree->getOp() == OP_OBJECT_REF && tree->right && tree->right->getType() == NT_STRING))
		    tree = 0;
	      }
	      else
		 tree = 0;

	      if (tree) {
		 // create an object method call node
		 // take the string
		 QoreStringNode* str = reinterpret_cast<QoreStringNode*>(tree->right);
		 char* cstr = str->giveBuffer();
		 str->deref();
		 
		 //printd(5, "method call to %s: tree=%s, args=%p %s\n", cstr, tree->left->getTypeName(), $3, $3 ? $3->getTypeName() : "n/a");

		 MethodCallNode* mc = new MethodCallNode(cstr, makeArgs((yyvsp[(3) - (4)].node)));
                 
                 // destroy the tree and create a new operator object
                 assert(tree->is_unique());
                 AbstractQoreNode* l = tree->left;
                 tree->right = 0;
                 tree->left = 0;
                 tree->deref(0);

		 (yyval.node) = new QoreDotEvalOperatorNode(l, mc);
	      }
	      else {
		 (yyval.node) = 0;
		 if ((yyvsp[(1) - (4)].node) && (yyvsp[(1) - (4)].node)->getType() == NT_VARREF) {
		    VarRefNode* r = reinterpret_cast<VarRefNode*>((yyvsp[(1) - (4)].node));
		    qore_var_t vartype = r->getType();

		    if (vartype != VT_UNRESOLVED) {
		       (yyval.node) = r->makeNewCall((yyvsp[(3) - (4)].node));
		       //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
		       if (!(yyval.node))
			  parseException("INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
		    }
		 }
		 if (!(yyval.node)) {
		    (yyval.node) = new CallReferenceCallNode((yyvsp[(1) - (4)].node), makeArgs((yyvsp[(3) - (4)].node)));
		    printd(5, "made new CallReferenceCallNode: %p exp=%p %s\n", (yyval.node), (yyvsp[(1) - (4)].node), get_type_name((yyvsp[(1) - (4)].node)));
		 }
	      }
	   }
	}
    break;

  case 267:
/* Line 1787 of yacc.c  */
#line 3018 "parser.ypp"
    {
	   printd(5, "parsing in-object base class method call %s()\n", (yyvsp[(1) - (4)].nscope)->ostr);
	   if (!strcmp((yyvsp[(1) - (4)].nscope)->getIdentifier(), "copy"))
	      parse_error("illegal call to base class copy method '%s'", (yyvsp[(1) - (4)].nscope)->ostr);

	   (yyval.node) = new SelfFunctionCallNode((yyvsp[(1) - (4)].nscope), makeArgs((yyvsp[(3) - (4)].node)));
	}
    break;

  case 268:
/* Line 1787 of yacc.c  */
#line 3025 "parser.ypp"
    {
	   printd(5, "parsing call %s()\n", (yyvsp[(1) - (3)].string));
	   (yyval.node) = new FunctionCallNode((yyvsp[(1) - (3)].string), makeArgs((yyvsp[(2) - (3)].node)));
        }
    break;

  case 269:
/* Line 1787 of yacc.c  */
#line 3030 "parser.ypp"
    {
	   (yyval.node) = new SelfVarrefNode((yyvsp[(1) - (1)].string)); 
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
	}
    break;

  case 270:
/* Line 1787 of yacc.c  */
#line 3035 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_AND, (yyvsp[(3) - (3)].node)); }
    break;

  case 271:
/* Line 1787 of yacc.c  */
#line 3036 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 272:
/* Line 1787 of yacc.c  */
#line 3037 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 273:
/* Line 1787 of yacc.c  */
#line 3038 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_AND, (yyvsp[(3) - (3)].node)); }
    break;

  case 274:
/* Line 1787 of yacc.c  */
#line 3039 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_XOR, (yyvsp[(3) - (3)].node)); }
    break;

  case 275:
/* Line 1787 of yacc.c  */
#line 3040 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_MATCH, (yyvsp[(3) - (3)].Regex));
	}
    break;

  case 276:
/* Line 1787 of yacc.c  */
#line 3043 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_NMATCH, (yyvsp[(3) - (3)].Regex));
	}
    break;

  case 277:
/* Line 1787 of yacc.c  */
#line 3046 "parser.ypp"
    {
	   //printf("REGEX_SUBST: '%s'\n", $3->getPattern()->getBuffer());
	   (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_SUBST, (yyvsp[(3) - (3)].RegexSubst));
	}
    break;

  case 278:
/* Line 1787 of yacc.c  */
#line 3050 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_TRANS, (yyvsp[(3) - (3)].RegexTrans));
	}
    break;

  case 279:
/* Line 1787 of yacc.c  */
#line 3054 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_EXTRACT, (yyvsp[(3) - (3)].Regex)); }
    break;

  case 280:
/* Line 1787 of yacc.c  */
#line 3055 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 281:
/* Line 1787 of yacc.c  */
#line 3056 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 282:
/* Line 1787 of yacc.c  */
#line 3057 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_CMP, (yyvsp[(3) - (3)].node)); }
    break;

  case 283:
/* Line 1787 of yacc.c  */
#line 3058 "parser.ypp"
    { (yyval.node) = new QoreLogicalEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 284:
/* Line 1787 of yacc.c  */
#line 3059 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_ABSOLUTE_EQ, (yyvsp[(3) - (3)].node)); }
    break;

  case 285:
/* Line 1787 of yacc.c  */
#line 3060 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_ABSOLUTE_NE, (yyvsp[(3) - (3)].node)); }
    break;

  case 286:
/* Line 1787 of yacc.c  */
#line 3061 "parser.ypp"
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 287:
/* Line 1787 of yacc.c  */
#line 3062 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 288:
/* Line 1787 of yacc.c  */
#line 3063 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 289:
/* Line 1787 of yacc.c  */
#line 3064 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_SHIFT_LEFT, (yyvsp[(3) - (3)].node)); }
    break;

  case 290:
/* Line 1787 of yacc.c  */
#line 3065 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_SHIFT_RIGHT, (yyvsp[(3) - (3)].node)); }
    break;

  case 291:
/* Line 1787 of yacc.c  */
#line 3066 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_PLUS, (yyvsp[(3) - (3)].node)); }
    break;

  case 292:
/* Line 1787 of yacc.c  */
#line 3067 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_MINUS, (yyvsp[(3) - (3)].node)); }
    break;

  case 293:
/* Line 1787 of yacc.c  */
#line 3068 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_MODULA, (yyvsp[(3) - (3)].node)); }
    break;

  case 294:
/* Line 1787 of yacc.c  */
#line 3069 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_DIV, (yyvsp[(3) - (3)].node)); }
    break;

  case 295:
/* Line 1787 of yacc.c  */
#line 3070 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_MULT, (yyvsp[(3) - (3)].node)); }
    break;

  case 296:
/* Line 1787 of yacc.c  */
#line 3071 "parser.ypp"
    { 
	   // FIXME: need to expand constant expression checking to determine
	   //        if the expression can throw an exception at run-time
	   // first check for constant expressions
	   (yyval.node) = QoreUnaryMinusOperatorNode::makeNode((yyvsp[(2) - (2)].node));
	}
    break;

  case 297:
/* Line 1787 of yacc.c  */
#line 3077 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_BIN_NOT, 0); }
    break;

  case 298:
/* Line 1787 of yacc.c  */
#line 3078 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_NOT, 0); }
    break;

  case 299:
/* Line 1787 of yacc.c  */
#line 3079 "parser.ypp"
    {
	   qore_type_t t = (yyvsp[(2) - (2)].node) ? (yyvsp[(2) - (2)].node)->getType() : 0;
	   //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2->getTypeName());

	   if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
	      (yyval.node) = reinterpret_cast<FunctionCallNode*>((yyvsp[(2) - (2)].node))->makeReferenceNodeAndDeref();
	   }
	   else if (t == NT_SELF_CALL) {
	      (yyval.node) = reinterpret_cast<SelfFunctionCallNode*>((yyvsp[(2) - (2)].node))->makeReferenceNodeAndDeref();
	   }
	   else if (t == NT_STATIC_METHOD_CALL) {
	      (yyval.node) = reinterpret_cast<StaticMethodCallNode*>((yyvsp[(2) - (2)].node))->makeReferenceNodeAndDeref();
	   }
	   else {
	      bool make_ref = true;

	      if (t == NT_OPERATOR) {
                 QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[(2) - (2)].node));
                 if (deon) {
                    (yyval.node) = deon->makeCallReference();
                    make_ref = false;
                 }
	      }

	      if (make_ref) {
		 //printd(5, "type=%s\n", $2->getTypeName());
		 (yyval.node) = new ParseReferenceNode((yyvsp[(2) - (2)].node));
	      }
	   }
	}
    break;

  case 300:
/* Line 1787 of yacc.c  */
#line 3109 "parser.ypp"
    {
	   (yyval.node) = new ScopedObjectCallNode(new NamedScope((yyvsp[(2) - (5)].string)), makeArgs((yyvsp[(4) - (5)].node)));
	   if (parse_check_parse_option(PO_NO_NEW))
	      parse_error("illegal use of the 'new' operator (conflicts with parse option NO_NEW)");
        }
    break;

  case 301:
/* Line 1787 of yacc.c  */
#line 3114 "parser.ypp"
    {
	   (yyval.node) = new ScopedObjectCallNode(new NamedScope((yyvsp[(2) - (5)].string)), makeArgs((yyvsp[(4) - (5)].node)));
	   if (parse_check_parse_option(PO_NO_NEW))
	      parse_error("illegal use of the 'new' operator (conflicts with parse option NO_NEW)");
        }
    break;

  case 302:
/* Line 1787 of yacc.c  */
#line 3119 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_BACKGROUND, 0);
	   // check to see if the expression is legal
	   if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
	      parse_error("illegal use of \"background\" operator (conflicts with parse option NO_THREAD_CONTROL)");
	   else if (!node_has_effect((yyvsp[(2) - (2)].node)))
	      parse_error("argument to background operator (%s) has no effect", get_type_name((yyvsp[(2) - (2)].node)));
	}
    break;

  case 303:
/* Line 1787 of yacc.c  */
#line 3127 "parser.ypp"
    {
	   (yyval.node) = new BackquoteNode((yyvsp[(1) - (1)].string));
	   if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
	      parse_error("illegal use of backquote operator (conflicts with parse option NO_EXTERNAL_PROCESS)");
	}
    break;

  case 304:
/* Line 1787 of yacc.c  */
#line 3132 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (4)].node), OP_LIST_REF, (yyvsp[(3) - (4)].node)); }
    break;

  case 305:
/* Line 1787 of yacc.c  */
#line 3133 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (4)].node), OP_OBJECT_REF, (yyvsp[(3) - (4)].node)); }
    break;

  case 306:
/* Line 1787 of yacc.c  */
#line 3134 "parser.ypp"
    {
	   (yyval.node) = process_dot((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node));
	}
    break;

  case 307:
/* Line 1787 of yacc.c  */
#line 3137 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(1) - (2)].node), OP_OBJECT_REF, (yyvsp[(2) - (2)].String));
	}
    break;

  case 308:
/* Line 1787 of yacc.c  */
#line 3140 "parser.ypp"
    { 
	   (yyval.node) = (yyvsp[(2) - (3)].node);
	   if ((yyvsp[(2) - (3)].node)) {
              switch ((yyvsp[(2) - (3)].node)->getType()) {
                 case NT_LIST:
                    reinterpret_cast<QoreListNode*>((yyvsp[(2) - (3)].node))->setFinalized();
                    break;
                 case NT_FUNCTION_CALL:
                    reinterpret_cast<FunctionCallNode*>((yyvsp[(2) - (3)].node))->setFinalized();
                    break;
              }
           }
	}
    break;

  case 309:
/* Line 1787 of yacc.c  */
#line 3153 "parser.ypp"
    { QoreListNode* l = new QoreListNode; l->setFinalized(); (yyval.node) = l; }
    break;

  case 310:
/* Line 1787 of yacc.c  */
#line 3154 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].node), (yyvsp[(5) - (6)].returnTypeInfo), false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
	}
    break;

  case 311:
/* Line 1787 of yacc.c  */
#line 3158 "parser.ypp"
    {
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(1) - (6)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (6)].parsertype)->getTypeInfo());
	   delete (yyvsp[(1) - (6)].parsertype);

	   int ar = get_pop_argv_ref();
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].node), rt, false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
	}
    break;

  case 312:
/* Line 1787 of yacc.c  */
#line 3165 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (7)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags));
	}
    break;

  case 313:
/* Line 1787 of yacc.c  */
#line 3173 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (7)].i4));

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (7)].parsertype);

	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), rt, (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags));
	}
    break;

  case 314:
/* Line 1787 of yacc.c  */
#line 3185 "parser.ypp"
    { 
	   (yyval.node) = (yyvsp[(1) - (1)].implicit_arg);
	   inc_numeric_argv_ref();
	}
    break;

  case 315:
/* Line 1787 of yacc.c  */
#line 3189 "parser.ypp"
    {
	   (yyval.node) = new QoreImplicitElementNode;
	}
    break;

  case 316:
/* Line 1787 of yacc.c  */
#line 3192 "parser.ypp"
    {
	   (yyval.node) = new QoreDeleteOperatorNode((yyvsp[(2) - (2)].node));
	}
    break;

  case 317:
/* Line 1787 of yacc.c  */
#line 3195 "parser.ypp"
    {
	   (yyval.node) = new QoreRemoveOperatorNode((yyvsp[(2) - (2)].node));
	}
    break;

  case 318:
/* Line 1787 of yacc.c  */
#line 3198 "parser.ypp"
    {
           (yyval.node) = new QoreCastOperatorNode((yyvsp[(1) - (4)].string), (yyvsp[(3) - (4)].node));
	}
    break;

  case 319:
/* Line 1787 of yacc.c  */
#line 3204 "parser.ypp"
    {
	   (yyval.String) = (yyvsp[(1) - (1)].String);
	}
    break;

  case 320:
/* Line 1787 of yacc.c  */
#line 3207 "parser.ypp"
    {
	   (yyval.String) = (yyvsp[(1) - (2)].String);
	   (yyval.String)->concat((yyvsp[(2) - (2)].String));
	   (yyvsp[(2) - (2)].String)->deref();
	}
    break;

  case 321:
/* Line 1787 of yacc.c  */
#line 3214 "parser.ypp"
    { (yyval.node) = new QoreFloatNode((yyvsp[(1) - (1)].decimal)); }
    break;

  case 322:
/* Line 1787 of yacc.c  */
#line 3215 "parser.ypp"
    { (yyval.node) = new QoreBigIntNode((yyvsp[(1) - (1)].integer)); }
    break;

  case 323:
/* Line 1787 of yacc.c  */
#line 3216 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].String); }
    break;

  case 324:
/* Line 1787 of yacc.c  */
#line 3217 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].datetime); }
    break;

  case 325:
/* Line 1787 of yacc.c  */
#line 3218 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].num); }
    break;


/* Line 1787 of yacc.c  */
#line 8868 "parser.cpp"
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (&yylloc, yyscanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, &yylloc, yyscanner);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[1] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner);
    }
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


/* Line 2050 of yacc.c  */
#line 3221 "parser.ypp"

