/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 1 "parser.ypp" /* yacc.c:339  */
 /* -*- mode: c++; indent-tabs-mode: nil -*-

   parser.ypp

   Qore Programming Language

   Copyright (C) 2003 - 2016 David Nichols

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.

  Note that the Qore library is released under a choice of three open-source
  licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
  information.
*/

#include <qore/Qore.h>
#include <qore/intern/BreakStatement.h>
#include <qore/intern/ContinueStatement.h>
#include <qore/intern/ReturnStatement.h>
#include <qore/intern/RethrowStatement.h>
#include <qore/intern/ThreadExitStatement.h>
#include <qore/intern/ExpressionStatement.h>
#include <qore/intern/DoWhileStatement.h>
#include <qore/intern/SummarizeStatement.h>
#include <qore/intern/ContextStatement.h>
#include <qore/intern/IfStatement.h>
#include <qore/intern/WhileStatement.h>
#include <qore/intern/ForStatement.h>
#include <qore/intern/ForEachStatement.h>
#include <qore/intern/TryStatement.h>
#include <qore/intern/ThrowStatement.h>
#include <qore/intern/StatementBlock.h>
#include <qore/intern/ParserSupport.h>
#include <qore/intern/SwitchStatement.h>
#include <qore/intern/CaseNodeWithOperator.h>
#include <qore/intern/CaseNodeRegex.h>
#include <qore/intern/OnBlockExitStatement.h>
#include <qore/intern/ConstantList.h>
#include <qore/intern/GlobalVariableList.h>
#include <qore/intern/QoreNamespaceIntern.h>
#include <qore/intern/QoreParseHashNode.h>

#include "parser.hpp"

#include <qore/intern/QoreClassIntern.h>
#include <qore/intern/qore_program_private.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <memory>
#include <utility>
#include <vector>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                                \
          do                                                           \
            if (N) {                                                   \
                (Current).first_line   = YYRHSLOC(Rhs, 1).first_line;  \
                (Current).last_line    = YYRHSLOC(Rhs, N).last_line;   \
            }                                                          \
            else {                                                     \
                (Current).first_line   = (Current).last_line   =       \
                  YYRHSLOC(Rhs, 0).last_line;                          \
            }                                                          \
          while (0)

class HashElement {
public:
   AbstractQoreNode* key;
   AbstractQoreNode* value;
   QoreProgramLocation loc;

   DLLLOCAL HashElement(AbstractQoreNode* k, AbstractQoreNode* v, int sl, int el) : key(k), value(v), loc(sl, el) {
      //traceout("HashElement::HashElement()");
   }

   DLLLOCAL ~HashElement() {
      discard(key, 0);
      discard(value, 0);
   }

   DLLLOCAL void addDelete(QoreParseHashNode* h) {
      h->add(key, value, loc);
      key = value = 0;
      delete this;
   }
};

static AbstractQoreNode* makeErrorTree(AbstractQoreNode* left, AbstractQoreNode* right) {
   discard(left, 0);
   discard(right, 0);
   return &False;
}

// for constant definitions
class ConstNode {
public:
   NamedScope name;
   AbstractQoreNode* value;
   bool pub;

   DLLLOCAL ConstNode(char* n, AbstractQoreNode* v, bool p = false) : name(n), value(v), pub(p) {
      // see if constant definitions are allowed
      if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
         parse_error("illegal constant definition \"%s\" (conflicts with parse option NO_CONSTANT_DEFS)", n);
   }
   DLLLOCAL AbstractQoreNode* takeValue() {
      AbstractQoreNode* rv = value;
      value = 0;
      return rv;
   }
   DLLLOCAL const std::string &getName() const {
      return name.getIdentifierStr();
   }
   DLLLOCAL bool isPublic() const {
      return pub;
   }
};

class ObjClassDef {
public:
   NamedScope *name;
   QoreClass* oc;

   DLLLOCAL inline ObjClassDef(NamedScope *n, QoreClass* o) : name(n), oc(o) {}
   DLLLOCAL inline ObjClassDef(char* n, QoreClass* o) : name(new NamedScope(n)), oc(o) {}
   DLLLOCAL inline ~ObjClassDef() { delete name; }
};

class ParseUserFunctionBase {
public:
   UserFunctionVariant* variant;

   DLLLOCAL ParseUserFunctionBase(UserFunctionVariant* v) : variant(v) {
   }

   DLLLOCAL ~ParseUserFunctionBase() {
      if (variant)
         variant->deref();
   }

   DLLLOCAL void setPublic() {
      variant->setModulePublic();
   }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
   char* name;

   DLLLOCAL ParseUserFunction(char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(n_variant), name(n_name) {
   }

   DLLLOCAL ~ParseUserFunction() {
      if (name)
         free(name);
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
         const char* nsn = ns.name.c_str();
         parse_error("function '%s%s%s()' cannot be defined (conflicts with parse option NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
      }

      delete this;
   }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
   NamedScope name;

   DLLLOCAL ParseScopedUserFunction(char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(n_variant), name(n_name) {
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
         parse_error("function '%s()' cannot be defined (conflicts with parse option NO_SUBROUTINE_DEFS)", name.ostr);

      delete this;
   }
};

struct GVarDecl {
   bool pub;

   DLLLOCAL GVarDecl(bool p) : pub(p) {
   }

   DLLLOCAL virtual ~GVarDecl() {
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

   DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
   char* name;
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL GVarSingleDecl(char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti, bool p, bool bare) : GVarDecl(p), name(n), typeInfo(ti), parseTypeInfo(pti) {
      if (bare) {
         if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error("global variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", n);
      }
      else {
         if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error("reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", n);
      }
   }

   DLLLOCAL virtual ~GVarSingleDecl() {
      if (name)
         free(name);

      delete parseTypeInfo;
   }

   DLLLOCAL char* takeName() {
      char* rv = name;
      name = 0;
      return rv;
   }

   DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = 0;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ns.parseAddGlobalVarDecl(takeName(), typeInfo, takeParseTypeInfo(), pub);
      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      GlobalVarRefNode* gv = typeInfo
         ? new GlobalVarRefNode(takeName(), typeInfo)
         : new GlobalVarRefNode(takeName(), takeParseTypeInfo());
      if (pub)
         gv->setPublic();

      delete this;
      return gv;
   }
};

struct GVarListDecl : public GVarDecl {
   QoreListNode* l;

   DLLLOCAL GVarListDecl(QoreListNode* list, bool p) : GVarDecl(p), l(list) {
      bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            if (!bareok)
               parse_error("global variable '%s' in global variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (vrn->explicitScope()) {
               if (vrn->getType() == VT_LOCAL)
                  parse_error("illegal use of 'my %s' in global variable declaration list", vrn->getName());
               else if (vrn->getType() == VT_GLOBAL)
                  parse_error("illegal use of 'our %s' in global variable declaration list", vrn->getName());
            }
         }
         else
            parse_error("element %d in list following 'our' is not a variable reference (%s)", li.index(), get_type_name(n));
      }
   }

   DLLLOCAL virtual ~GVarListDecl() {
      if (l)
         l->deref(0);
   }

   DLLLOCAL QoreListNode* takeList() {
      QoreListNode* rv = l;
      l = 0;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            ns.parseAddGlobalVarDecl(b->takeString(), 0, 0, pub);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
               if (vrdn)
                  ns.parseAddGlobalVarDecl(vrn->takeName(), vrdn->getTypeInfo(), vrdn->takeParseTypeInfo(), pub);
               else
                  ns.parseAddGlobalVarDecl(vrn->takeName(), 0, 0, pub);
            }
         }
      }

      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      l->setVariableList();
      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         VarRefNode* vrn = 0;
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            GlobalVarRefNode* v = new GlobalVarRefNode(b->takeString());
            b->deref();
            AbstractQoreNode** p = li.getValuePtr();
            *p = vrn = v;
         }
         else if (t == NT_VARREF) {
            vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               vrn->makeGlobal();
               vrn->setExplicitScope();
            }
         }

         if (vrn && pub)
            vrn->setPublic();
      }

      QoreListNode* rv = takeList();
      delete this;
      return rv;
   }
};

static int checkMethod(const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error("%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error("base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PRIVATE    (1 << 0)
#define OFM_SYNCED     (1 << 1)
#define OFM_STATIC     (1 << 2)
#define OFM_DEPRECATED (1 << 3)
#define OFM_PUBLIC     (1 << 4)
#define OFM_FINAL      (1 << 5)
#define OFM_ABSTRACT   (1 << 6)

static inline MethodVariantBase* newMethodVariant(const char* name, int mod, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) {
   //printd(5, "newMethodVariant() '%s' b: %p\n", name, b);
   int64 flags = QC_NO_FLAGS;

   if (get_pop_argv_ref())
      flags |= QC_USES_EXTRA_ARGS;

   if (mod & OFM_DEPRECATED)
      flags |= QC_DEPRECATED;

   if (!strcmp(name, "constructor")) {
      if (mod & OFM_SYNCED)
         parse_error("%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error("return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      return new UserConstructorVariant(mod & OFM_PRIVATE, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
   }
   if (bcal) {
      parse_error("only constructors may have base class constructor arguments");
      delete bcal;
      bcal = 0;
   }
   if (!strcmp(name, "destructor")) {
      if (params) {
	 parse_error("parameters cannot be defined for destructors");
	 params->deref(0);
      }
      if (mod & OFM_SYNCED)
         parse_error("%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error("return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      if (mod & OFM_PRIVATE)
	 parse_error("destructors cannot be private");
      return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
   }
   if (!strcmp(name, "copy")) {
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      return new UserCopyVariant(mod & OFM_PRIVATE, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
   }

   if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; they are not inherited anyway", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract; they are not inherited anyway", name);
   }

   if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
      parse_error("method '%s()' is declared both final and abstract", name);

   return new UserMethodVariant(mod & OFM_PRIVATE, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
   MethodVariantBase* m;
   NamedScope name;
   bool static_flag;

   DLLLOCAL MethodDef(int mod, char* n, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : m(0), name(n), static_flag(mod & OFM_STATIC) {
      if (checkMethod(name.getIdentifier(), bcal, returnTypeInfo)) {
         if (params)
            params->deref(0);
         delete bcal;
         delete b;
         delete returnTypeInfo;
         return;
      }

      m = newMethodVariant(name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b);
   }

   DLLLOCAL ~MethodDef() {
      delete m;
   }

   DLLLOCAL void parseAddToClassAndDel() {
      if (m) {
         // if there are any errors, the function below will delete memory
         // the following method takes ownership of "m" unconditionally
         qore_root_ns_private::parseAddMethodToClass(name, m, static_flag);
         m = 0;
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      // the following method takes ownership of "m" unconditionally
      ns.parseAddMethodToClass(name, m, static_flag);
      m = 0;
   }
};

static AbstractQoreNode* parse_hash_map(QoreParseHashNode* exp, QoreListNode* l) {
   assert(l && (l->size() == 1 || l->size() == 2));
   ReferenceHolder<> exph(exp, 0);
   ReferenceHolder<> lh(l, 0);

   // check hash expression
   size_t len = exp->size();

   if (len == 0) {
       qore_program_private::makeParseWarning(getProgram(), QP_WARN_INVALID_OPERATION, "INVALID-OPERATION",
            "empty hash as an argument to the hash map operator, this expression will always evaluate to an empty hash");
       return new QoreHashNode();
   }

   if (len != 1) {
      parse_error("invalid initial argument to hash map operator, expected a single key value pair; got %d hash elements instead", len);
      return &True;
   }

   if (l->size() == 1) {
      AbstractQoreNode* iter = l->shift();
      return new QoreHashMapOperatorNode(exp->takeFirstKeyNode(), exp->takeFirstValueNode(), iter);
   }

   AbstractQoreNode* iter = l->shift();
   AbstractQoreNode* select = l->shift();
   return new QoreHashMapSelectOperatorNode(exp->takeFirstKeyNode(), exp->takeFirstValueNode(), iter, select);
}

static AbstractQoreNode* parse_map(AbstractQoreNode* exp, QoreListNode* l) {
   assert(l && (l->size() == 1 || l->size() == 2));
   ReferenceHolder<> lh(l, 0);

   if (l->size() == 1) {
      AbstractQoreNode* arg = l->shift();
      return new QoreMapOperatorNode(exp, arg);
   }

   AbstractQoreNode* iterator_exp = l->shift();
   AbstractQoreNode* select_exp = l->shift();
   return new QoreMapSelectOperatorNode(exp, iterator_exp, select_exp);
}

#define NSN_NONE  0
#define NSN_OCD   1
#define NSN_CONST 2
#define NSN_NS    3
#define NSN_FUNC  4
#define NSN_SFUNC 5
#define NSN_VAR   6
#define NSN_METH  7

struct NSNode {
   int type;
   union {
      ObjClassDef* ocd;
      ConstNode* cn;
      QoreNamespace* ns;
      ParseUserFunction* func;
      ParseScopedUserFunction* sfunc;
      GVarDecl* gv;
      MethodDef* meth;
   } n;

   DLLLOCAL NSNode(ObjClassDef *o) { type = NSN_OCD; n.ocd = o; }
   DLLLOCAL NSNode(ConstNode  *c) { type = NSN_CONST; n.cn = c; }
   DLLLOCAL NSNode(QoreNamespace  *s) { type = NSN_NS; n.ns = s; }
   DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
      n.func = f;
   }
   DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
      n.sfunc = f;
   }

   DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
      n.gv = gv;
   }

   DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
      n.meth = m;
   }

   DLLLOCAL void deref() {
      switch (type) {
         case NSN_OCD:
            delete n.ocd;
            break;
         case NSN_CONST:
            delete n.cn;
            break;
         case NSN_NS:
            delete n.ns;
            break;
         case NSN_FUNC:
            delete n.func;
            break;
         case NSN_SFUNC:
            delete n.sfunc;
            break;
         case NSN_VAR:
            delete n.gv;
            break;
         case NSN_METH:
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      switch (type) {
         case NSN_OCD:
            ns.parseAddPendingClass(*(n.ocd->name), n.ocd->oc);
            delete n.ocd;
            break;
         case NSN_CONST:
            ns.parseAddConstant(n.cn->name, n.cn->value, n.cn->pub);
            delete n.cn;
            break;
         case NSN_NS:
            ns.parseAddNamespace(n.ns);
            break;
         case NSN_FUNC:
            n.func->add(ns);
            break;
         case NSN_SFUNC:
            n.sfunc->add(ns);
            break;
         case NSN_VAR:
            n.gv->add(ns);
            break;
         case NSN_METH:
            n.meth->add(ns);
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
   DLLLOCAL void deref() {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->deref();

      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->add(ns);
   }
};

static QoreListNode* make_list(AbstractQoreNode* a1, AbstractQoreNode* a2) {
   QoreListNode* l = new QoreListNode;
   l->push(a1);
   l->push(a2);
   return l;
}

static QoreListNode* splice_expressions(AbstractQoreNode* a1, AbstractQoreNode* a2) {
   //tracein("splice_expressions()");
   if (a1 && a1->getType() == NT_LIST) {
      QoreListNode* l = reinterpret_cast<QoreListNode*>(a1);
      if (!l->isFinalized()) {
	 //printd(5, "LIST x\n");
	 l->push(a2);
	 return l;
      }
   }
   return make_list(a1, a2);
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2

struct MemberInfo {
protected:
   DLLLOCAL MemberInfo() {
   }

public:
   char* name;
   unsigned char type;
   union {
      QoreMemberInfo* memberInfo;
      QoreVarInfo* varInfo;
      AbstractQoreNode* exp;
   } u;

   DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : name(n), type(MI_Member)  {
      u.memberInfo = mi;
      if (!mi->parseHasTypeInfo() && parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("member '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL MemberInfo(char* n, AbstractQoreNode* exp) : name(n), type(MI_Constant) {
      u.exp = exp;
   }
   DLLLOCAL ~MemberInfo() {
      if (name)
	 free(name);
      switch (type) {
	 case MI_Member:
	    delete u.memberInfo;
	    break;
	 case MI_Var:
	    delete u.varInfo;
	    break;
	 case MI_Constant:
	    if (u.exp)
	       u.exp->deref(0);
	    break;
      }
   }
   DLLLOCAL member_pair_t getPair() {
      assert(type == MI_Member);
      member_pair_t m = std::make_pair(name, u.memberInfo);
      name = 0;
      u.memberInfo = 0;
      return m;
   }
   DLLLOCAL var_pair_t getVarPair() {
      assert(type == MI_Var);
      var_pair_t m = std::make_pair(name, u.varInfo);
      name = 0;
      u.varInfo = 0;
      return m;
   }
   DLLLOCAL AbstractQoreNode* takeExp() {
      assert(type == MI_Constant);
      AbstractQoreNode* rv = u.exp;
      u.exp = 0;
      return rv;
   }
};

struct ClassVarInfo : public MemberInfo {
   DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) {
      name = n;
      type = MI_Var;
      u.varInfo = vi;
      if (!vi->parseHasTypeInfo() && parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL char* takeName() {
      char* n = name;
      name = 0;
      return n;
   }
};

class MemberList {
protected:
   // for new class members
   QoreMemberMap mmap;
   // for new class constants
   ConstantList cmap;
   // for new class static variables
   QoreVarMap vmap;

   DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
   }

public:
   DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
      if (!member)
	 return;

      if (member->type == MI_Member)
         mmap.addNoCheck(member->getPair());
      else if (member->type == MI_Constant)
	 cmap.parseAdd(member->name, member->takeExp());
      else
	 vmap.addNoCheck(member->getVarPair());

      delete member;
   }

   DLLLOCAL ~MemberList() {
   }

   // takes over ownership of name and typeInfo
   DLLLOCAL int add(MemberInfo* member) {
      if (!member)
	 return -1;

      //std::auto_ptr<MemberInfo> mem(member);

      if (member->type == MI_Member) {
         if (mmap.inList(member->name)) {
            parse_error("duplicate member declaration '%s'", member->name);
            delete member;
            return -1;
         }

         // add new member to list
         mmap.addNoCheck(member->getPair());
         delete member;
      }
      else if (member->type == MI_Constant) {
	 if (cmap.inList(member->name)) {
	    parse_error("duplicate constant declaration '%s'", member->name);
            delete member;
	    return -1;
	 }
	 if (vmap.find(member->name)) {
	    parse_error("constant declaration collides with static class variable declaration '%s'", member->name);
            delete member;
	    return -1;
	 }

	 // add new constant to list
	 cmap.parseAdd(member->name, member->takeExp());
         delete member;
      }
      else {
	 assert(member->type == MI_Var);
	 if (vmap.find(member->name)) {
	    parse_error("duplicate static class variable declaration '%s'", member->name);
            delete member;
	    return -1;
	 }
	 if (cmap.inList(member->name)) {
	    parse_error("static class variable declaration collides with constant declaration '%s'", member->name);
            delete member;
	    return -1;
	 }

	 // add new member to list
	 vmap.addNoCheck(member->getVarPair());
         delete member;
      }

      return 0;
   }

   DLLLOCAL void mergePrivate(QoreClass* qc) {
      mmap.moveAllToPrivate(qc);
      vmap.moveAllToPrivate(qc);

      // merge private constants
      qc->parseAssimilatePrivateConstants(cmap);
   }

   DLLLOCAL void mergePublic(QoreClass* qc) {
      mmap.moveAllToPublic(qc);
      vmap.moveAllToPublic(qc);

      // merge public constants
      qc->parseAssimilatePublicConstants(cmap);
   }
};

class EmptyPublicMemberList : public MemberList {
public:
   DLLLOCAL EmptyPublicMemberList() {
   }
};

class EmptyPrivateMemberList : public MemberList {
public:
   DLLLOCAL EmptyPrivateMemberList() {
   }
};

struct ParserTypeStruct {
protected:
   DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : typeInfo(0), parseTypeInfo(n_parseTypeInfo) {
   }

   DLLLOCAL ParserTypeStruct() {
   }

public:
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL ParserTypeStruct(const QoreTypeInfo* n_typeInfo) : typeInfo(n_typeInfo), parseTypeInfo(0) {
   }

   DLLLOCAL ParserTypeStruct(char* id) {
      const QoreTypeInfo* t = getBuiltinUserTypeInfo(id);
      //printd(0, "ParserTypeStruct::ParserTypeStruct('%s') t: %p %s\n", id, t, t->getName());
      if (t) {
	 free(id);
	 typeInfo = t;
	 parseTypeInfo = 0;
	 return;
      }

      typeInfo = 0;
      parseTypeInfo = new QoreParseTypeInfo(id);
   }

   DLLLOCAL ~ParserTypeStruct() {
      delete parseTypeInfo;
   }

   DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
      if (!qore_check_this(this))
	 return 0;

      return typeInfo;
   }

   DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
      if (!qore_check_this(this))
	 return 0;

      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = 0;
      return rv;
   }

   DLLLOCAL const char* getClassName() {
      assert(this);
      assert(parseTypeInfo);
      return parseTypeInfo->cscope->ostr;
   }
};

struct ParserScopedTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserScopedTypeStruct(char* sr) : ParserTypeStruct(new QoreParseTypeInfo(sr)) {
   }
};

struct ParserOrNothingTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserOrNothingTypeStruct(char* id) {
      const QoreTypeInfo* t = getBuiltinUserOrNothingTypeInfo(id);
      if (t) {
	 free(id);
	 typeInfo = t;
	 parseTypeInfo = 0;
	 return;
      }

      typeInfo = 0;
      parseTypeInfo = new QoreParseTypeInfo(id, true);
   }
};

struct ParserScopedOrNothingTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserScopedOrNothingTypeStruct(char* sr) : ParserTypeStruct(new QoreParseTypeInfo(sr, true)) {
   }
};

static AbstractQoreNode* process_dot(AbstractQoreNode* l, AbstractQoreNode* r) {
   qore_type_t rtype = r->getType();
   switch (rtype) {
      case NT_BAREWORD: {
         BarewordNode* b = reinterpret_cast<BarewordNode*>(r);
         if (!b->isFinalized()) {
            AbstractQoreNode* rv = new QoreTreeNode(l, OP_OBJECT_REF, b->makeQoreStringNode());
            b->deref();
            return rv;
         }
         break;
      }

      case NT_FUNCTION_CALL: {
         FunctionCallNode* f = reinterpret_cast<FunctionCallNode*>(r);
         assert(!f->getFunction());
         if (!f->isFinalized()) {
            MethodCallNode* m = new MethodCallNode(f->takeName(), f->takeArgs());
            f->deref();

            return new QoreDotEvalOperatorNode(l, m);
         }
         break;
      }
   }

   return new QoreTreeNode(l, OP_OBJECT_REF, r);
}

// returns true if the node needs run-time evaluation, false if not
static bool needsEval(AbstractQoreNode* n) {
   if (!n)
      return false;

   qore_type_t ntype = n->getType();

   // if it's a constant or a function reference
   if (ntype == NT_BAREWORD || ntype == NT_CONSTANT || ntype == NT_FUNCREF)
      return false;

   if (ntype == NT_LIST) {
      QoreListNode* l = reinterpret_cast<QoreListNode*>(n);
      if (l->needs_eval()) {
	 for (unsigned i = 0; i <l->size(); i++) {
	    if (needsEval(l->retrieve_entry(i)))
	       return true;
	 }
	 // here we set needs_eval to false so the list won't be evaluated again
	 l->clearNeedsEval();
      }
      return false;
   }

   if (ntype == NT_HASH) {
      QoreHashNode* h = reinterpret_cast<QoreHashNode*>(n);
      if (h->needs_eval()) {
	 HashIterator hi(h);
	 while (hi.next())
	    if (needsEval(hi.getValue()))
	       return true;
	 // here we set needs_eval to false so the hash won't be evaluated again
	 h->clearNeedsEval();
      }
      return false;
   }

   if (ntype == NT_TREE) {
      QoreTreeNode* tree = reinterpret_cast<QoreTreeNode*>(n);

      if (needsEval(tree->left) || (tree->right && needsEval(tree->right)))
	 return true;
      return tree->getOp()->hasEffect();
   }

   //printd(5, "needsEval() type %s = true\n", n->getTypeName());
   // we don't return needs_eval() here because some node types are not meant to be evaluated directly but are also not values
   return !n->is_value();
}

static int check_case(const char* op, AbstractQoreNode* exp) {
   // ignore if NULL (= NOTHING)
   if (exp && needsEval(exp)) {
      if (op)
	 parse_error("case expression with '%s' needs run-time evaluation", op);
      else
	 parse_error("case expression needs run-time evaluation", op);
      return -1;
   }
   return 0;
}

static void check_funcmod(int mod) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in function declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in function declaration");
   if (mod & OFM_FINAL)
      parse_error("illegal 'final' modifier in function declaration");
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in function declaration");
}

static void check_classmod(int mod, QoreClass& qc) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error("illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error("illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in class declaration");
}

static void check_nsmod(int mod, qore_ns_private& ns) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error("illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error("illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error("illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
   if (!n || n->is_value())
      return false;

   if (n->getType() == NT_OPERATOR)
      return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

   const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
   return pn ? pn->has_effect() : true;
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }
   DLLLOCAL ~MethodNode() {
      free(name);
      delete m;
   }
   DLLLOCAL void addAndDelete(QoreClass* qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }
};

static AbstractQoreNode* is_rewritable_op(AbstractQoreNode* n) {
   qore_type_t nt = get_node_type(n);
   if (nt == NT_OPERATOR) {
      QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n);
      if (op)
         return op->getRight();
   }

   return 0;
}

static AbstractQoreNode* checkRewriteList(QoreListNode* l) {
   if (!parse_check_parse_option(PO_BROKEN_LIST_PARSING))
      return l;

   // rewrite expression if it's a list without parentheses and
   // the first expression has one of the following operators:
   // =, +=, -=
   if (l->isFinalized())
      return l;

   AbstractQoreNode* e0 = l->retrieve_entry(0);

   AbstractQoreNode* r = is_rewritable_op(e0);
   if (r) {
      AbstractQoreNode* last = e0;
      AbstractQoreNode* top = e0;
      while (true) {
         AbstractQoreNode* nr = is_rewritable_op(r);
         if (!nr)
            break;
         last = r;
         r = nr;
      }
      assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last));
      // take first element from list (the tree) and make it the new expression
      QoreBinaryLValueOperatorNode* op = reinterpret_cast<QoreBinaryLValueOperatorNode*>(last);
      l->swap(0, op->swapRight(l));
      return top;
   }

   return l;
}

void ignore_return_value(AbstractQoreNode* n) {
   qore_type_t t = get_node_type(n);
   if (t == NT_TREE)
      reinterpret_cast<QoreTreeNode*>(n)->ignoreReturnValue();
   else if (t == NT_OPERATOR)
      reinterpret_cast<QoreOperatorNode*>(n)->ignoreReturnValue();
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}

static AbstractQoreNode* processAssignment(AbstractQoreNode* $1, AbstractQoreNode* $3) {
   if ($1 && $1->getType() == NT_LIST) {
      return new QoreTreeNode($1, OP_LIST_ASSIGNMENT, $3);
   }
   else {
      return new QoreAssignmentOperatorNode($1, $3);
   }
   //print_tree($1, 0);
}

static AbstractQoreNode* processCall(AbstractQoreNode* $1, AbstractQoreNode* $3) {
    AbstractQoreNode* $$;
   //printd(5, "1=%s (%p), 3=%s (%p)\n", $1->getTypeName(), $1, $3 ? $3->getTypeName() : "n/a", $3);
   qore_type_t t = get_node_type($1);
   if (t == NT_BAREWORD) {
      BarewordNode* b = reinterpret_cast<BarewordNode*>($1);
      // take string from node and delete node
      char* str = b->takeString();
      b->deref();
      printd(5, "parsing call %s() args=%p %s\n", str, $3, $3 ? $3->getTypeName() : "n/a");
      $$ = new FunctionCallNode(str, make_args($3));
   }
   else if (t == NT_CONSTANT) {
      ScopedRefNode* c = reinterpret_cast<ScopedRefNode*>($1);
      // take NamedScope from node and delete node
      NamedScope *ns = c->takeName();
      c->deref();
      assert(ns->size() > 1);
      printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
      $$ = new StaticMethodCallNode(ns, make_args($3));
   }
   else if (t == NT_SELF_VARREF) {
      SelfVarrefNode* v = reinterpret_cast<SelfVarrefNode*>($1);
      // take string from node and delete node
      char* str = v->takeString();
      v->deref();
      printd(5, "parsing in-object method call %s()\n", str);
      $$ = new SelfFunctionCallNode(str, make_args($3));
   }
   else {
      QoreTreeNode* tree;

      if (t == NT_TREE) {
     tree = reinterpret_cast<QoreTreeNode*>($1);
     if (!(tree->getOp() == OP_OBJECT_REF && tree->right && tree->right->getType() == NT_STRING))
        tree = 0;
      }
      else
     tree = 0;

      if (tree) {
     // create an object method call node
     // take the string
     QoreStringNode* str = reinterpret_cast<QoreStringNode*>(tree->right);
     char* cstr = str->giveBuffer();
     str->deref();

     //printd(5, "method call to %s: tree=%s, args=%p %s\n", cstr, tree->left->getTypeName(), $3, $3 ? $3->getTypeName() : "n/a");

     MethodCallNode* mc = new MethodCallNode(cstr, make_args($3));

             // destroy the tree and create a new operator object
             assert(tree->is_unique());
             AbstractQoreNode* l = tree->left;
             tree->right = 0;
             tree->left = 0;
             tree->deref(0);

     $$ = new QoreDotEvalOperatorNode(l, mc);
      }
      else {
     $$ = 0;
     if ($1 && $1->getType() == NT_VARREF) {
        VarRefNode* r = reinterpret_cast<VarRefNode*>($1);
        qore_var_t vartype = r->getType();

        if (vartype != VT_UNRESOLVED) {
           $$ = r->makeNewCall($3);
           //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
           if (!$$)
          parseException("INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
        }
     }
     if (!$$) {
        $$ = new CallReferenceCallNode($1, make_args($3));
        printd(5, "made new CallReferenceCallNode: %p exp=%p %s\n", $$, $1, get_type_name($1));
     }
      }
   }
   return $$;
}


#line 1346 "parser.cpp" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_HPP_INCLUDED
# define YY_YY_PARSER_HPP_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOK_RETURN = 258,
    TOK_RETURNS = 259,
    TOK_MY = 260,
    TOK_DO = 261,
    TOK_TRY = 262,
    TOK_THROW = 263,
    TOK_CATCH = 264,
    TOK_WHERE = 265,
    TOK_WHILE = 266,
    TOK_IF = 267,
    TOK_FOR = 268,
    TOK_SUB = 269,
    TOK_THREAD_EXIT = 270,
    TOK_BREAK = 271,
    TOK_CONTINUE = 272,
    TOK_CONTEXT_ROW = 273,
    TOK_FIND = 274,
    TOK_FOREACH = 275,
    TOK_IN = 276,
    TOK_DELETE = 277,
    TOK_REMOVE = 278,
    TOK_PRIVATE = 279,
    TOK_PUBLIC = 280,
    TOK_SYNCHRONIZED = 281,
    TOK_DEPRECATED = 282,
    TOK_CONTEXT = 283,
    TOK_SORT_BY = 284,
    TOK_SORT_DESCENDING_BY = 285,
    TOK_SUB_CONTEXT = 286,
    TOK_CONST = 287,
    TOK_SUMMARIZE = 288,
    TOK_BY = 289,
    TOK_OUR = 290,
    TOK_RETHROW = 291,
    TOK_SWITCH = 292,
    TOK_CASE = 293,
    TOK_DEFAULT = 294,
    TOK_INHERITS = 295,
    TOK_ELSE = 296,
    TOK_STATIC = 297,
    TOK_NAMESPACE = 298,
    TOK_MODULE = 299,
    TOK_FINAL = 300,
    TOK_ABSTRACT = 301,
    TOK_UNREFERENCE = 302,
    P_INCREMENT = 303,
    P_DECREMENT = 304,
    PLUS_EQUALS = 305,
    MINUS_EQUALS = 306,
    AND_EQUALS = 307,
    OR_EQUALS = 308,
    MODULA_EQUALS = 309,
    MULTIPLY_EQUALS = 310,
    DIVIDE_EQUALS = 311,
    XOR_EQUALS = 312,
    SHIFT_LEFT_EQUALS = 313,
    SHIFT_RIGHT_EQUALS = 314,
    TOK_UNSHIFT = 315,
    TOK_PUSH = 316,
    TOK_POP = 317,
    TOK_SHIFT = 318,
    TOK_CHOMP = 319,
    TOK_TRIM = 320,
    LOGICAL_AND = 321,
    LOGICAL_OR = 322,
    BROKEN_LOGICAL_OR = 323,
    BROKEN_BINARY_OR = 324,
    BROKEN_BINARY_XOR = 325,
    LOGICAL_EQ = 326,
    LOGICAL_NE = 327,
    LOGICAL_LE = 328,
    LOGICAL_GE = 329,
    LOGICAL_CMP = 330,
    ABSOLUTE_EQ = 331,
    ABSOLUTE_NE = 332,
    REGEX_MATCH = 333,
    REGEX_NMATCH = 334,
    TOK_EXISTS = 335,
    TOK_INSTANCEOF = 336,
    SHIFT_RIGHT = 337,
    SHIFT_LEFT = 338,
    TOK_ELEMENTS = 339,
    TOK_KEYS = 340,
    TOK_NEW = 341,
    TOK_BACKGROUND = 342,
    TOK_ON_EXIT = 343,
    TOK_ON_SUCCESS = 344,
    TOK_ON_ERROR = 345,
    TOK_MAP = 346,
    TOK_FOLDR = 347,
    TOK_FOLDL = 348,
    TOK_SELECT = 349,
    TOK_SPLICE = 350,
    TOK_EXTRACT = 351,
    IMPLICIT_ELEMENT = 352,
    NULL_COALESCING = 353,
    VALUE_COALESCING = 354,
    INTEGER = 355,
    QFLOAT = 356,
    NUMBER = 357,
    IDENTIFIER = 358,
    VAR_REF = 359,
    BACKQUOTE = 360,
    SELF_REF = 361,
    KW_IDENTIFIER_OPENPAREN = 362,
    SCOPED_REF = 363,
    SCOPED_VREF = 364,
    CONTEXT_REF = 365,
    COMPLEX_CONTEXT_REF = 366,
    QORE_CAST = 367,
    CLASS_STRING = 368,
    DATETIME = 369,
    QUOTED_WORD = 370,
    BINARY = 371,
    REGEX_SUBST = 372,
    REGEX_TRANS = 373,
    CLASS_SCOPED_REF = 374,
    BASE_CLASS_CALL = 375,
    REGEX = 376,
    REGEX_EXTRACT = 377,
    IMPLICIT_ARG_REF = 378,
    DOT_KW_IDENTIFIER = 379,
    TRY_MODULE_ERROR = 380,
    IFX = 381,
    NEG = 382,
    UPLUS = 383
  };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_MY 260
#define TOK_DO 261
#define TOK_TRY 262
#define TOK_THROW 263
#define TOK_CATCH 264
#define TOK_WHERE 265
#define TOK_WHILE 266
#define TOK_IF 267
#define TOK_FOR 268
#define TOK_SUB 269
#define TOK_THREAD_EXIT 270
#define TOK_BREAK 271
#define TOK_CONTINUE 272
#define TOK_CONTEXT_ROW 273
#define TOK_FIND 274
#define TOK_FOREACH 275
#define TOK_IN 276
#define TOK_DELETE 277
#define TOK_REMOVE 278
#define TOK_PRIVATE 279
#define TOK_PUBLIC 280
#define TOK_SYNCHRONIZED 281
#define TOK_DEPRECATED 282
#define TOK_CONTEXT 283
#define TOK_SORT_BY 284
#define TOK_SORT_DESCENDING_BY 285
#define TOK_SUB_CONTEXT 286
#define TOK_CONST 287
#define TOK_SUMMARIZE 288
#define TOK_BY 289
#define TOK_OUR 290
#define TOK_RETHROW 291
#define TOK_SWITCH 292
#define TOK_CASE 293
#define TOK_DEFAULT 294
#define TOK_INHERITS 295
#define TOK_ELSE 296
#define TOK_STATIC 297
#define TOK_NAMESPACE 298
#define TOK_MODULE 299
#define TOK_FINAL 300
#define TOK_ABSTRACT 301
#define TOK_UNREFERENCE 302
#define P_INCREMENT 303
#define P_DECREMENT 304
#define PLUS_EQUALS 305
#define MINUS_EQUALS 306
#define AND_EQUALS 307
#define OR_EQUALS 308
#define MODULA_EQUALS 309
#define MULTIPLY_EQUALS 310
#define DIVIDE_EQUALS 311
#define XOR_EQUALS 312
#define SHIFT_LEFT_EQUALS 313
#define SHIFT_RIGHT_EQUALS 314
#define TOK_UNSHIFT 315
#define TOK_PUSH 316
#define TOK_POP 317
#define TOK_SHIFT 318
#define TOK_CHOMP 319
#define TOK_TRIM 320
#define LOGICAL_AND 321
#define LOGICAL_OR 322
#define BROKEN_LOGICAL_OR 323
#define BROKEN_BINARY_OR 324
#define BROKEN_BINARY_XOR 325
#define LOGICAL_EQ 326
#define LOGICAL_NE 327
#define LOGICAL_LE 328
#define LOGICAL_GE 329
#define LOGICAL_CMP 330
#define ABSOLUTE_EQ 331
#define ABSOLUTE_NE 332
#define REGEX_MATCH 333
#define REGEX_NMATCH 334
#define TOK_EXISTS 335
#define TOK_INSTANCEOF 336
#define SHIFT_RIGHT 337
#define SHIFT_LEFT 338
#define TOK_ELEMENTS 339
#define TOK_KEYS 340
#define TOK_NEW 341
#define TOK_BACKGROUND 342
#define TOK_ON_EXIT 343
#define TOK_ON_SUCCESS 344
#define TOK_ON_ERROR 345
#define TOK_MAP 346
#define TOK_FOLDR 347
#define TOK_FOLDL 348
#define TOK_SELECT 349
#define TOK_SPLICE 350
#define TOK_EXTRACT 351
#define IMPLICIT_ELEMENT 352
#define NULL_COALESCING 353
#define VALUE_COALESCING 354
#define INTEGER 355
#define QFLOAT 356
#define NUMBER 357
#define IDENTIFIER 358
#define VAR_REF 359
#define BACKQUOTE 360
#define SELF_REF 361
#define KW_IDENTIFIER_OPENPAREN 362
#define SCOPED_REF 363
#define SCOPED_VREF 364
#define CONTEXT_REF 365
#define COMPLEX_CONTEXT_REF 366
#define QORE_CAST 367
#define CLASS_STRING 368
#define DATETIME 369
#define QUOTED_WORD 370
#define BINARY 371
#define REGEX_SUBST 372
#define REGEX_TRANS 373
#define CLASS_SCOPED_REF 374
#define BASE_CLASS_CALL 375
#define REGEX 376
#define REGEX_EXTRACT 377
#define IMPLICIT_ARG_REF 378
#define DOT_KW_IDENTIFIER 379
#define TRY_MODULE_ERROR 380
#define IFX 381
#define NEG 382
#define UPLUS 383

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 1287 "parser.ypp" /* yacc.c:355  */

   bool b;
   int i4;
   int64 integer;
   double decimal;
   QoreStringNode* String;
   char* string;
   BinaryNode* binary;
   AbstractQoreNode* node;
   QoreParseHashNode* hash;
   QoreListNode* list;
   AbstractStatement* statement;
   struct MemberInfo* memberinfo;
   struct ClassVarInfo* classvarinfo;
   StatementBlock *sblock;
   ContextModList* cmods;
   ContextMod *cmod;
   class HashElement* hashelement;
   QoreFunction* userfunc;
   struct MethodNode* methodnode;
   class MemberList* memberlist;
   QoreClass* qoreclass;
   class ConstNode* constnode;
   QoreNamespace *ns;
   struct NSNodeList* nsnlist;
   struct NSNode* nsn;
   class ObjClassDef *classdef;
   DateTimeNode* datetime;
   RegexSubstNode* RegexSubst;
   RegexTransNode* RegexTrans;
   SwitchStatement* switchstmt;
   CaseNode* casenode;
   BCList* sclist;
   class BCNode* sclnode;
   BCAList* bcalist;
   BCANode* bcanode;
   NamedScope *nscope;
   QoreRegexNode* Regex;
   QoreImplicitArgumentNode* implicit_arg;
   RetTypeInfo* returnTypeInfo;
   struct ParserTypeStruct* parsertype;
   class ParseUserFunction* parsefunc;
   class ParseScopedUserFunction* sparsefunc;
   struct GVarDecl* gv;
   QoreNumberNode* num;
   TryModuleError* trymod;
   struct MethodDef* methoddef;

#line 1691 "parser.cpp" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int yyparse (yyscan_t yyscanner);

#endif /* !YY_YY_PARSER_HPP_INCLUDED  */

/* Copy the second part of user declarations.  */
#line 1336 "parser.ypp" /* yacc.c:358  */


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE *loc, yyscan_t scanner, const char* str) {
   //printd(5, "yyerror() location: %d-%d: \"%s\"\n", loc->first_line, loc->last_line, str);
   parse_error("%s", str);
}


#line 1733 "parser.cpp" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  201
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   11401

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  154
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  61
/* YYNRULES -- Number of rules.  */
#define YYNRULES  392
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  853

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   383

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   145,     2,     2,     2,   138,   133,     2,
     149,   152,   139,   136,   127,   137,   148,   140,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   130,   151,
     134,   128,   135,   129,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   147,   144,   153,   132,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   146,   131,   150,   143,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   141,   142
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1579,  1579,  1580,  1584,  1587,  1590,  1598,  1602,  1606,
    1609,  1617,  1618,  1624,  1630,  1637,  1662,  1664,  1669,  1682,
    1683,  1689,  1694,  1697,  1702,  1705,  1710,  1715,  1721,  1728,
    1733,  1741,  1746,  1754,  1757,  1760,  1766,  1769,  1772,  1775,
    1781,  1786,  1789,  1795,  1798,  1804,  1807,  1812,  1815,  1820,
    1822,  1824,  1826,  1832,  1833,  1837,  1838,  1857,  1863,  1865,
    1868,  1871,  1874,  1877,  1880,  1883,  1886,  1889,  1892,  1895,
    1898,  1901,  1904,  1907,  1908,  1915,  1918,  1921,  1922,  1927,
    1928,  1939,  1941,  1943,  1948,  1950,  1954,  1964,  1968,  1976,
    1981,  1987,  1992,  1998,  2003,  2009,  2014,  2020,  2025,  2031,
    2035,  2040,  2044,  2049,  2053,  2058,  2063,  2069,  2073,  2080,
    2106,  2107,  2108,  2112,  2117,  2122,  2129,  2136,  2143,  2153,
    2156,  2162,  2165,  2172,  2175,  2178,  2181,  2184,  2187,  2193,
    2197,  2202,  2207,  2212,  2216,  2221,  2226,  2234,  2237,  2240,
    2243,  2250,  2251,  2257,  2258,  2259,  2263,  2264,  2265,  2269,
    2273,  2276,  2281,  2284,  2299,  2306,  2313,  2331,  2338,  2345,
    2363,  2369,  2375,  2378,  2387,  2392,  2400,  2403,  2410,  2413,
    2420,  2423,  2426,  2432,  2442,  2456,  2462,  2475,  2485,  2497,
    2502,  2510,  2513,  2522,  2525,  2531,  2534,  2541,  2544,  2551,
    2552,  2557,  2558,  2566,  2567,  2568,  2569,  2570,  2571,  2572,
    2576,  2587,  2592,  2597,  2606,  2617,  2633,  2638,  2647,  2658,
    2675,  2677,  2698,  2700,  2715,  2719,  2723,  2728,  2733,  2739,
    2741,  2743,  2745,  2747,  2760,  2773,  2777,  2785,  2795,  2812,
    2850,  2853,  2860,  2862,  2864,  2866,  2868,  2870,  2872,  2874,
    2886,  2889,  2901,  2904,  2907,  2910,  2930,  2950,  2973,  2987,
    3001,  3015,  3018,  3021,  3028,  3032,  3038,  3044,  3048,  3049,
    3050,  3080,  3085,  3090,  3098,  3103,  3119,  3120,  3124,  3131,
    3139,  3151,  3155,  3158,  3161,  3164,  3170,  3171,  3172,  3173,
    3174,  3175,  3176,  3177,  3178,  3179,  3180,  3181,  3182,  3183,
    3184,  3185,  3186,  3187,  3188,  3189,  3190,  3191,  3192,  3193,
    3194,  3195,  3196,  3197,  3198,  3199,  3200,  3201,  3202,  3203,
    3204,  3205,  3206,  3207,  3208,  3209,  3210,  3211,  3212,  3213,
    3214,  3215,  3216,  3217,  3218,  3219,  3220,  3221,  3222,  3223,
    3224,  3225,  3229,  3230,  3231,  3232,  3233,  3234,  3235,  3236,
    3237,  3238,  3239,  3240,  3241,  3242,  3243,  3244,  3245,  3246,
    3247,  3248,  3249,  3250,  3251,  3252,  3253,  3254,  3255,  3256,
    3257,  3258,  3259,  3260,  3261,  3262,  3263,  3264,  3265,  3266,
    3267,  3268,  3269,  3270,  3271,  3272,  3273,  3274,  3275,  3276,
    3277,  3278,  3279,  3280,  3281,  3282,  3286,  3289,  3296,  3297,
    3298,  3299,  3300
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"", "\"my\"",
  "\"do\"", "\"try\"", "\"throw\"", "\"catch\"", "\"where\"", "\"while\"",
  "\"if\"", "\"for\"", "\"sub\"", "\"thread_exit\"", "\"break\"",
  "\"continue\"", "\"%%\"", "\"find\"", "\"foreach\"", "\"in\"",
  "\"delete\"", "\"remove\"", "\"private\"", "\"public\"",
  "\"synchronized\"", "\"deprecated\"", "\"context\"", "\"sortBy\"",
  "\"sortDescendingBy\"", "\"subcontext\"", "\"const\"", "\"summarize\"",
  "\"by\"", "\"our\"", "\"rethrow\"", "\"switch\"", "\"case\"",
  "\"default\"", "\"inherits\"", "\"else\"", "\"static\"", "\"namespace\"",
  "\"module\"", "\"final\"", "\"abstract\"", "\"unreference\"",
  "\"++ operator\"", "\"-- operator\"", "\"+= operator\"",
  "\"-= operator\"", "\"&= operator\"", "\"|= operator\"",
  "\"%= operator\"", "\"*= operator\"", "\"/= operator\"",
  "\"^= operator\"", "\"<<= operator\"", "\">>= operator\"", "\"unshift\"",
  "\"push\"", "\"pop\"", "\"shift\"", "\"chomp\"", "\"trim\"",
  "\"&& operator\"", "\"|| operator\"", "\"|| operator (compat)\"",
  "\"| operator (compat)\"", "\"^ operator (compat)\"", "\"== operator\"",
  "\"!= operator\"", "\"<= operator\"", "\">= operator\"",
  "\"<=> operator\"", "\"=== operator\"", "\"!== operator\"",
  "\"=~ operator\"", "\"!~ operator\"", "\"exists\"", "\"instanceof\"",
  "\">> operator\"", "\"<< operator\"", "\"elements\"", "\"keys\"",
  "\"new\"", "\"background\"", "\"on_exit\"", "\"on_success\"",
  "\"on_error\"", "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"",
  "\"splice\"", "\"extract\"", "\"$# operator\"", "\"?? operator\"",
  "\"?* operator\"", "\"integer value\"", "\"floating-point value\"",
  "\"arbitrary-precision number\"", "\"identifier\"",
  "\"variable reference\"", "\"backquote expression\"",
  "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"simple class declaration\"",
  "\"date/time value\"", "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'|'",
  "'^'", "'&'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "UPLUS", "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'",
  "';'", "')'", "']'", "$accept", "top_level_commands",
  "top_level_command", "module_decls", "module_decl", "ppub", "gvardecl",
  "top_namespace_decl", "namespace_decls", "namespace_decl",
  "unscoped_const_decl", "scoped_const_decl", "block",
  "statement_or_block", "statements", "optname", "statement",
  "context_mods", "context_mod", "return_statement", "switch_statement",
  "case_block", "case_code", "try_statement", "myexp", "class_def",
  "inheritance_list", "superclass_list", "superclass", "class_attributes",
  "uncqtypedef", "qtypedef", "private_member_list", "public_member_list",
  "classvardecl", "member2", "member", "member_list", "member_list2",
  "ident_openparen", "inline_methoddef", "outofline_methoddef",
  "base_constructor_list", "base_constructors", "base_constructor",
  "nsc_modifiers", "method_modifiers", "method_modifier", "return_value",
  "sub_def", "scoped_sub_def", "list", "list_n", "hash", "hash_element",
  "alt_hash", "exp_c", "exp", "exp_n", "string", "scalar", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,    44,    61,    63,
      58,   124,    94,    38,    60,    62,    43,    45,    37,    42,
      47,   382,   383,   126,    92,    33,   123,    91,    46,    40,
     125,    59,    41,    93
};
# endif

#define YYPACT_NINF -586

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-586)))

#define YYTABLE_NINF -190

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-190)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    1481,  -124,  5818,   -16,  5399,  5399,  6353,   -87,   -79,   -67,
     257,    49,    64,    65,  -586,  6353,  6353,  6353,  6353,  -586,
      82,  -586,  -586,    -6,  -586,   165,    -6,    91,    33,  -586,
      97,  -586,  -586,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,   218,  6353,  5399,  5399,  5399,  6353,
    6353,  6353,  6353,  6353,  6353,  -586,  -586,  -586,  -586,    31,
    -586,  -586,  1331,    16,  -586,  -586,   116,  -586,   182,  -586,
     155,  -586,  -586,  6353,  6353,   281,  6353,  6353,  6353,  4795,
    5682,  -586,  1164,  -586,   288,  -586,  -586,  -586,  -586,  -586,
     179,  -586,  -586,  -586,    43,   306,  -586,    61,   509,  -586,
    -586,  -586,  -586,  -586,  8444,  -586,  -586,  -586,   190,   296,
      44,  5954,    40,   612,  -586,  -586,  -586, 10816,    51,  -586,
    6353,   238,   241,    28,  4946,  -586,   337,  -586,   340,  8548,
    6353,  6353,  5546,   212,   213,  -586,   232,  1331,  1331,  -586,
    -586,  -586,  6558,  6660,    46,    46,   308,  -586,   253,  1628,
     246,   262,   254,  -586,  6353,   315,   345,   345, 10816, 10816,
      46,    46,    46,    46,  5476,    46,    46,   280,   287,    46,
    -586,  -586,  -586, 10816, 10816, 10816, 10816, 10816, 10816,  -586,
     276, 10816,  1331,  6353,  -586,  1331,    46,    46,  -586,  -586,
      46,    46,    46,  -586,  -586,  5097,  -586,  -586,   -54,  -586,
    6974,  -586,  -586,   224,  -586,   284,  -586,   293,  -586,  -586,
     319,   403,   403,   454,  -586,  -586,   303,    41,  -586,  -586,
    -586,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,   237,   338,   324,  6353,  6353,  6353,  6353,
    -586,  6220,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  1331,  -586,  -586,
     -14,  9898,   313,   323,   460,  -586,  -586,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,   279,
     357,   363,  6353,  6353,  6353,  6353,  -586,  6220,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  1331,   334, 10816,  -586,  -586,  1331,  -586,
    5248,   362,   365,  -586,  7079,  7184,   367,  -586,  -586,  1331,
     385,   400,  6353,   379,   361,   425,  6353,   407,   410,   430,
    -586,  -586,  6353,  6353,  6353,  7289,   461,   -34,  -586,  1331,
    1331,  -586,   441,  7394,   442,  -586,  -586,  -586,  6220,  -586,
    6353,  -586,   225,   267,  6353,   382,   416,   439,  1331,  1331,
    1331,   311,  -586,    55,   375,   376,   448,  1331,  1331,  1331,
     462,   450, 10918, 10918, 10918, 10918, 10918, 10918, 10918, 10918,
   10918, 10918, 11091, 11055, 11091, 11252, 11252,  5476,  5476,  5476,
    5476,  5476,  5476,  5476,  -586,  -586,  -586,  -586,  -586,  -586,
    -586,   483,   483, 10962, 10962, 10918, 10918, 10000, 11172, 11208,
   11252,  5476,  5476,   718,   718,   838,    46,    46,  9692,  6762,
    -586,   449,  -586,   451, 10918, 10918, 10918, 10918, 10918, 10918,
   10918, 10918, 10918, 10918, 11091, 11055, 11091, 11252, 11252,  5476,
    5476,  5476,  5476,  5476,  5476,  5476,  -586,  -586,  -586,  -586,
    -586,  -586,  -586,   483,   483, 10962, 10962, 10918, 10918, 10102,
   11172, 11208, 11252,  5476,  5476,   718,   718,   838,    46,    46,
    9795,  6868,  -586,   452,  -586,   457,  -586,  6353,  1331,  5399,
    5399,  5546,   458,   586,   586,  6456,  6353,  6353,  6353,  7499,
    6353,  6353,  6353,  8652,  8756,  7604,   456,  6353,  -586,  -586,
     463,   464,    60,  -586,  -586,  -586, 10918,   472,  -586,  -586,
    -586,  -586,  1331,   473,   475,   488,   106,   465,  -586,   491,
    -586,   399,  -586,  -586,  -586,  -586,    42,  -586,   653,  -586,
    -586,   421,   437,  -586,  -586,   479,  -586,   353,  -586,   422,
    -586,  1331,   492,   493,   494,   498,  1331,  1331,  1331,  6353,
    -586,  -586,  -586,  6353,  -586,  -586,  -586,   499,  7709,   497,
    -586,   572,   500,   586,   -18,   507,   507,   506,  7814,  8860,
    8964,  -586,  7919,  8024,  8129,  -586,  -586,   609,   134,  9068,
    -586,  -586,   438,  -586,   586,  -586,   504,   507,   507,   536,
    1331,  -586,  -586,  -586,   163,   301,    52,  -586,  -586,  -586,
    -586,    55,   -60,    21,   567,  -586,  -586,   431,  -586,  -586,
    -586,     3,   550,  -586,   455,   521,   586,   586,   536,  1331,
     524,   530,   532,   950,   950,   535,  5399,  5399,  1331,   507,
    -586,  -586,  -586,  -586,  6353,  5399,  -586,  -586,  1628,  -586,
    -586,  -586,   539,  6087,   559,    29,  -586,  -586,   551,   552,
     575,  -586,   507,   507,  -586,  -586,   507,   554,   332,  -586,
     595,   380,  -586,   -46,   601,   566,    34,  -586,  -586,  -586,
    -586,  -586,   213,    23,  1331,  -586,   586,   507,   507,   586,
     556,   507,   507,   536,  -586,  -586,  -586,   557,  -586,  8234,
    -586,  -586,  6353,  6353,  6353,  6353,   598,   600,   592,  6353,
    6353, 10204,  1775,  -586,  -586,  1331,  1331,   438,  -586,  -586,
    -586,   536,  -586,   691,    -1,    47,  -586,  -586,   622,   621,
    -586,  -586,   682,   623,  -586,  -586,   752,  -586,  1331,   576,
     507,  -586,  -586,   417,   507,  -586,  -586,   432,  5399,  -586,
    8339, 10306, 10408, 10510,   603,   604,  1926, 10612, 10714,  2077,
    2228,   578,   583,  -586,    90,   634,  6353,  -586,    48,   302,
    -586,  -586,  -586,  -586,   588,   536,  -586,  -586,  -586,  -586,
    -586,  -586,  -586,  -586,  2379,  2530,  2681,  2832,  2983,  3134,
    3285,  3436,  3587,  -586,  -586,  6353,  -586,   347,  9172,  6353,
    1331,  -586,  6353,  1331,  -586,   536,   586,  1628,  3738,  3889,
    4040,  4191,  4342,  4493,  4644,  9276,  6353,  1331,  -586,  -586,
    9380,   589,  9484,   591,   434,   436,  -586,  -586,  9588,   593,
    -586,   587,  -586,   596,  -586,  -586,  -586,  -586,  -586,   599,
    -586,  -586,  -586
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,   141,   141,     0,     0,   141,     0,     0,     0,
       0,     0,     0,     0,   233,   141,   141,   141,   141,   193,
     197,   195,   196,    53,    79,     0,    53,     0,     0,   194,
       0,   198,   199,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,   141,     0,   141,     0,     0,     0,   141,
     141,   141,   141,   141,   141,   272,   389,   388,   392,   231,
     264,   255,     0,   222,   232,   234,     0,   391,   386,   220,
       0,   271,    15,   141,   141,     0,   141,   141,   141,     0,
     141,    55,     0,     2,     0,   230,    13,     8,     7,    10,
       0,    77,    58,     6,   142,     0,     9,     0,   190,   191,
       4,     5,   333,   332,     0,   390,   219,    78,     0,   197,
     222,   141,   142,     0,   277,   278,   276,    85,   227,   138,
     141,   142,     0,   222,     0,    48,     0,    47,     0,     0,
     141,   141,     0,     0,     0,   172,     0,     0,     0,    74,
      75,    76,     0,     0,   273,   274,     0,    54,     0,     0,
       0,     0,     0,    59,   141,     0,   251,   252,   239,   241,
     242,   240,   243,   244,   236,   237,   238,     0,     0,   263,
      61,    62,    63,   247,   248,   249,   250,   245,   246,   112,
       0,   111,     0,   141,   387,     0,   257,   256,   139,   140,
     258,   260,   259,    11,    50,     0,    49,   266,     0,   214,
       0,     1,     3,   141,    73,     0,   225,     0,   223,   224,
       0,   120,   120,     0,   197,   137,   138,     0,   192,   350,
     351,   141,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,     0,     0,     0,   141,   141,   141,   141,
     385,   213,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,   141,   141,   141,   141,     0,    56,   279,
       0,     0,     0,     0,     0,   296,   297,   141,   141,   141,
     141,   141,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,   141,   141,   141,   141,   141,   141,     0,
       0,     0,   141,   141,   141,   141,   331,   211,   141,   141,
     141,   141,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,     0,   277,     0,   226,   228,     0,    46,
       0,     0,     0,    60,     0,     0,     0,   171,   170,     0,
       0,     0,   141,     0,     0,     0,   141,     0,     0,     0,
      64,    80,   141,   141,   141,     0,     0,     0,    16,     0,
       0,   254,     0,     0,     0,    12,    51,    52,   216,   221,
     141,   265,    24,    22,   141,   142,     0,     0,     0,     0,
       0,   189,    29,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   353,   354,   355,   356,   357,   369,   372,   373,
     374,   368,   370,   371,   363,   364,   361,   365,   362,   345,
     346,   376,   375,   347,   348,   212,   344,     0,   358,   360,
     359,   367,   366,   377,   378,   379,   381,   380,     0,     0,
     384,     0,   218,     0,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   299,   300,   301,   302,   303,   315,
     318,   319,   320,   314,   316,   317,   309,   310,   307,   311,
     308,   291,   292,   322,   321,   293,   294,   210,   290,     0,
     304,   306,   305,   313,   312,   323,   324,   325,   327,   326,
       0,     0,   330,     0,   229,     0,    45,   141,     0,     0,
       0,     0,     0,   201,   201,     0,   141,   141,   141,     0,
     141,   141,   141,     0,     0,     0,     0,   141,    14,    17,
       0,     0,   184,   275,   253,   215,   217,   277,    23,    21,
      26,    25,     0,     0,     0,     0,     0,   138,    30,     0,
      39,   189,    31,    34,    33,    35,     0,    40,   190,    36,
      37,     0,     0,   123,   124,   119,   121,   189,   115,   189,
     116,     0,     0,     0,     0,     0,     0,     0,     0,   141,
     383,   382,   352,   141,   329,   328,   298,     0,     0,     0,
      69,    67,     0,   201,   141,     0,     0,     0,     0,     0,
       0,    79,     0,     0,     0,    41,    43,     0,     0,     0,
     261,   262,     0,    57,   201,    27,     0,     0,     0,   184,
       0,    38,    28,    32,     0,     0,     0,   127,   128,   125,
     126,     0,   193,   197,     0,   117,   132,   189,   130,   131,
     129,     0,   190,   118,   189,     0,   201,   201,   184,     0,
       0,     0,     0,   349,   295,     0,     0,     0,     0,     0,
     142,   200,   267,   202,   141,     0,    42,    44,     0,    81,
      82,    83,     0,   141,     0,     0,    87,    18,     0,     0,
     183,   185,     0,     0,   268,   203,     0,     0,     0,   122,
     164,   141,   166,     0,     0,   141,     0,   113,   136,   134,
     135,   133,   137,     0,     0,   114,   201,     0,     0,   201,
       0,     0,     0,   184,    70,   109,    68,     0,   206,     0,
      72,    66,   141,   141,   141,   141,     0,     0,     0,   141,
     141,     0,     0,    86,    88,     0,     0,     0,   181,   207,
     182,   184,   165,     0,     0,   137,   145,   163,   142,     0,
     162,   168,   141,     0,   143,   148,   141,   146,     0,     0,
       0,   269,   204,     0,     0,   270,   205,     0,     0,   235,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   186,   137,     0,   141,   160,     0,     0,
     144,   169,   167,   147,     0,   184,   208,   179,   177,   209,
     180,   178,    71,    79,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   187,   188,   141,   150,     0,     0,   141,
       0,   157,   141,     0,   154,   184,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   141,     0,   149,   161,
       0,     0,     0,     0,     0,     0,    65,   152,     0,     0,
     158,     0,   155,     0,   176,   174,   175,   173,   151,     0,
     159,   156,   153
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -586,  -586,   667,  -586,   395,  -586,  -373,  -372,  -586,   214,
       1,  -358,   243,    13,  -104,   727,    77,  -585,  -586,  -586,
    -586,  -586,    89,  -586,   594,  -357,   545,  -586,   137,   200,
       2,     0,  -470,  -417,  -586,  -540,    19,   140,    75,  -194,
    -360,  -355,  -516,  -586,    37,  -456,     7,   -88,  -492,  -353,
    -352,   -76,  -586,   654,   401,  -586,    17,    -2,  -586,   700,
    -586
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    82,    83,   357,   358,    84,    85,    86,   541,   542,
     737,    88,   125,   126,   195,   148,   127,   149,   351,    90,
      91,   665,   666,    92,   180,    93,   384,   555,   556,   627,
     112,    95,   628,   629,   740,   741,   682,   683,   742,   138,
     630,    96,   604,   670,   671,    97,   113,    99,   585,   100,
     101,   114,   102,   198,   199,   115,   116,   181,   104,   105,
     106
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     117,    87,    94,   122,   129,   121,   658,    98,   539,   540,
     218,   379,   586,   142,   143,   144,   145,   103,   128,   388,
     330,   103,   103,   544,   545,   218,   547,   107,   549,   550,
    -138,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,  -138,   169,   324,  -137,   680,   173,   174,   175,
     176,   177,   178,   684,   272,   390,   614,   205,  -138,   170,
     171,   172,   130,   103,   103,   103,   678,   663,   664,   356,
     131,   186,   187,   368,   190,   191,   192,    89,   200,   551,
     552,   743,   132,    87,    94,   215,   681,   118,   133,    98,
     119,   649,   119,   676,   275,   276,   103,   147,   369,   103,
     217,   631,   774,   631,   210,   744,   692,   119,   133,   271,
     135,   119,   672,   368,   146,   274,   518,   -20,   325,  -138,
    -138,    75,   699,    75,  -138,  -138,   134,   680,   334,   335,
     135,  -138,  -138,   120,  -137,  -137,   442,  -138,    75,  -137,
    -137,   103,    75,   206,   697,   698,   206,  -138,  -138,   391,
     207,   207,   355,  -138,  -137,  -137,   196,   689,   553,    89,
     391,   743,   350,   554,   689,   182,   103,   685,   539,   540,
     306,   631,   663,   664,   211,   776,   809,   328,   631,   723,
     212,   363,   154,   544,   545,   747,   547,   757,   549,   550,
     602,   133,   320,   321,   322,   323,   567,   810,   777,   811,
     139,   196,   781,   376,   750,   375,   781,   753,   817,   134,
     690,   603,   103,   135,   136,   140,   141,   690,   805,   392,
     393,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   806,   153,   155,   421,   422,   423,   424,   133,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   183,   134,   691,   150,   816,
     135,   377,   367,   151,   691,   444,   445,   446,   447,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,   465,    68,   527,   834,
     473,   474,   475,   476,   185,   477,   478,   479,   480,   481,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   167,   194,   203,   835,   536,   168,   372,  -137,  -137,
     204,   -20,   373,  -137,  -137,    19,    20,    21,    22,   137,
     505,   326,   133,    25,   509,   327,   -19,   103,   331,   332,
     513,   514,   515,    29,   414,   415,    31,    32,   416,   417,
     134,   337,   338,    75,   135,   136,   271,   194,   526,   133,
    -138,  -138,   325,   374,   352,  -138,  -138,   622,   623,    21,
      22,   339,   543,   546,   188,   624,   133,   134,   548,   189,
     353,   135,   377,  -190,  -190,    29,   466,   467,    31,    32,
     468,   469,   346,   354,   134,   733,   137,   367,   135,   386,
     208,   344,   624,   536,   215,   209,   345,   133,   356,   537,
     379,   388,   734,    19,    20,    21,    22,   419,   361,   359,
     812,    25,   420,   378,   -19,   134,   360,   694,   366,   135,
     565,    29,   380,   383,    31,    32,   622,   623,    21,    22,
      75,   813,   389,   814,   624,   622,   623,    21,    22,   418,
     218,   538,   378,   624,    29,   381,   471,    31,    32,   306,
     382,   472,   387,    29,   443,   826,    31,    32,   470,   622,
     623,    21,    22,   735,   567,   528,   494,   624,   119,   507,
     529,   320,   321,   322,   323,   578,   827,    29,   828,   748,
      31,    32,   215,   625,   588,   589,   590,   537,   592,   593,
     594,   497,   580,   581,   498,   599,   103,   103,   501,    75,
     530,   557,   559,   213,   617,   531,   558,   560,   506,   618,
     736,   275,   276,    19,   214,    21,    22,   503,    75,   133,
     619,   668,   543,   546,   218,   620,   669,   133,   548,   612,
     616,    29,   504,   508,    31,    32,   510,   134,   626,   511,
     626,   135,   386,   124,   632,   134,   632,   643,   787,   135,
     565,   644,   633,   366,    19,   214,    21,    22,   124,   512,
     124,   687,   124,   790,   651,   844,   650,   846,   532,   517,
     584,   733,    29,   522,   524,    31,    32,   561,   624,   568,
     566,   572,   598,   387,   576,   695,   621,   306,   734,   577,
     583,   566,   215,   647,   610,   600,   601,   216,   770,   315,
     316,   317,   318,   319,   605,   607,   273,   608,   688,   320,
     321,   322,   323,   693,   632,   688,    19,   214,    21,    22,
     609,   632,   611,   662,   636,   637,   638,   639,    75,   646,
     603,   648,   709,   124,    29,   654,   673,    31,    32,   705,
     706,   721,   799,   103,   103,   802,   602,   615,   710,   735,
     150,   711,   103,   696,   119,   103,   701,    19,   214,    21,
      22,   739,   702,   738,   703,   739,   704,   738,   712,   722,
     818,   819,   820,   821,   822,    29,   823,   824,    31,    32,
     725,   726,   727,   732,   344,    75,   731,   733,   754,   758,
     760,   761,   762,   763,   624,   215,   745,   767,   768,   764,
     119,   765,   766,   684,   734,   778,   336,   779,   785,   680,
     803,   340,   341,   797,   798,   804,   775,   807,   850,   103,
     815,   841,   739,   843,   738,   849,   739,   851,   738,   202,
     852,    75,   519,   152,   724,   613,   215,   385,   679,   634,
     746,   216,   782,   686,   773,   270,   275,   276,   184,   525,
       0,   792,     0,     0,   808,   103,   362,   733,     0,   364,
       0,     0,     0,   103,   624,   735,   103,   103,     0,     0,
     119,     0,    75,     0,   734,     0,     0,     0,     0,   196,
       0,     0,     0,   825,     0,     0,     0,   830,     0,     0,
     832,   103,   103,   103,   103,   103,   103,   103,   103,   103,
       0,    75,     0,     0,   838,     0,     0,     0,   652,   653,
     836,     0,   780,     0,   103,   103,   103,   103,   103,   103,
     103,   103,   306,   196,     0,     0,   196,   367,     0,     0,
     674,   675,     0,     0,     0,   735,   317,   318,   319,     0,
     119,   441,     0,     0,   320,   321,   322,   323,     0,     0,
       0,   196,   196,   196,   196,   196,   367,   196,   196,   367,
       0,     0,     0,     0,     0,     0,   275,   276,     0,     0,
       0,    75,   708,     0,     0,   367,   367,   367,   367,   367,
     367,   367,   783,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   728,   729,   493,     0,   730,
       0,     0,   495,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   502,     0,     0,     0,     0,     0,     0,
     751,   752,     0,     0,   755,   756,     0,     0,     0,     0,
       0,     0,     0,   520,   521,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   194,     0,     0,     0,     0,
       0,     0,   533,   534,   535,     0,     0,   318,   319,     0,
       0,   562,   563,   564,   320,   321,   322,   323,     0,     0,
       0,     0,     0,   786,     0,     0,   788,   789,   275,   276,
     791,     0,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,   194,   366,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,   194,   194,   194,
     194,   194,   366,   194,   194,   366,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   366,   366,   366,   366,   366,   366,   366,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   845,   847,   309,
       0,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,   579,     0,     0,   582,   320,   321,   322,   323,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   606,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   635,     0,     0,     0,     0,
     640,   641,   642,     0,   201,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,    22,    23,     0,     0,    24,    25,    26,     0,   -19,
      27,    28,     0,     0,   677,     0,    29,  -189,    30,    31,
      32,     0,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,   700,     0,     0,     0,     0,     0,     0,
       0,     0,   707,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,     0,     0,    56,    57,    58,    59,  -141,    60,
      61,    62,    63,  -141,    64,    65,    66,  -189,    67,    68,
      69,     0,     0,  -189,    70,     0,     0,    71,   749,    72,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      73,    74,     0,    75,     0,     0,     0,    76,    77,    78,
      79,     0,     0,    80,     0,    81,     0,     0,     0,   771,
     772,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   179,     0,     0,     0,     3,     0,     0,     0,
       0,     0,   784,     0,     0,   108,     0,     0,     0,    14,
      15,     0,     0,    17,    18,    19,   109,    21,    22,     0,
       0,     0,     0,     0,     0,     0,   -19,     0,     0,     0,
       0,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,   831,     0,     0,   833,     0,     0,
       0,    41,     0,     0,     0,    42,    43,    44,    45,     0,
       0,   839,    49,    50,    51,    52,    53,    54,    55,     0,
       0,    56,    57,    58,    59,  -141,    60,    61,    62,   110,
    -141,    64,    65,    66,     0,    67,    68,    69,     0,     0,
       0,    70,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,    74,     0,
      75,     0,     0,     0,    76,    77,    78,   111,     0,     0,
      80,     0,     1,  -110,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,    22,    23,
       0,     0,    24,    25,    26,     0,   -19,    27,    28,     0,
       0,     0,     0,    29,  -189,    30,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,     0,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,     0,
       0,    56,    57,    58,    59,  -141,    60,    61,    62,    63,
    -141,    64,    65,    66,  -189,    67,    68,    69,     0,     0,
    -189,    70,     0,     0,    71,     0,    72,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,    74,     0,
      75,     0,     0,     0,    76,    77,    78,    79,     0,     1,
      80,     2,    81,     3,     4,     5,     6,     0,   347,     7,
       8,     9,   108,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,   109,    21,    22,    23,   348,   349,    24,
       0,    26,     0,   -19,    27,    28,     0,     0,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,  -141,    60,    61,    62,   123,  -141,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     0,
       0,    76,    77,    78,   124,     0,     1,    80,     2,    81,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   108,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     109,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -19,    27,    28,  -108,  -108,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,     0,     0,    56,    57,    58,    59,  -141,
      60,    61,    62,   123,  -141,    64,    65,    66,     0,    67,
      68,    69,     0,     0,     0,    70,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,    74,     0,    75,     0,     0,     0,    76,    77,
      78,   124,     0,     0,    80,  -108,    81,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     108,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,   109,    21,    22,    23,     0,     0,    24,     0,    26,
       0,   -19,    27,    28,  -104,  -104,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,     0,     0,    56,    57,    58,    59,
    -141,    60,    61,    62,   123,  -141,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,    74,     0,    75,     0,     0,     0,    76,
      77,    78,   124,     0,     0,    80,  -104,    81,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   108,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   109,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -19,    27,    28,  -106,  -106,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,     0,     0,    56,    57,    58,
      59,  -141,    60,    61,    62,   123,  -141,    64,    65,    66,
       0,    67,    68,    69,     0,     0,     0,    70,     0,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,    74,     0,    75,     0,     0,     0,
      76,    77,    78,   124,     0,     0,    80,  -106,    81,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   108,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,   109,    21,    22,    23,     0,     0,    24,
       0,    26,     0,   -19,    27,    28,  -107,  -107,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,  -141,    60,    61,    62,   123,  -141,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     0,
       0,    76,    77,    78,   124,     0,     0,    80,  -107,    81,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   108,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   109,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -19,    27,    28,   -94,   -94,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,     0,     0,    56,
      57,    58,    59,  -141,    60,    61,    62,   123,  -141,    64,
      65,    66,     0,    67,    68,    69,     0,     0,     0,    70,
       0,     0,    71,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,    74,     0,    75,     0,
       0,     0,    76,    77,    78,   124,     0,     0,    80,   -94,
      81,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   108,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,   109,    21,    22,    23,     0,
       0,    24,     0,    26,     0,   -19,    27,    28,   -92,   -92,
       0,     0,    29,     0,     0,    31,    32,     0,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,     0,     0,
      56,    57,    58,    59,  -141,    60,    61,    62,   123,  -141,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    73,    74,     0,    75,
       0,     0,     0,    76,    77,    78,   124,     0,     0,    80,
     -92,    81,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   108,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   109,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -19,    27,    28,   -90,
     -90,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,     0,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,     0,
       0,    56,    57,    58,    59,  -141,    60,    61,    62,   123,
    -141,    64,    65,    66,     0,    67,    68,    69,     0,     0,
       0,    70,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,    74,     0,
      75,     0,     0,     0,    76,    77,    78,   124,     0,     0,
      80,   -90,    81,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   108,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,   109,    21,    22,
      23,     0,     0,    24,     0,    26,     0,   -19,    27,    28,
    -100,  -100,     0,     0,    29,     0,     0,    31,    32,     0,
      33,    34,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,    36,    37,    38,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
       0,     0,    56,    57,    58,    59,  -141,    60,    61,    62,
     123,  -141,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    73,    74,
       0,    75,     0,     0,     0,    76,    77,    78,   124,     0,
       0,    80,  -100,    81,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   108,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   109,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -19,    27,
      28,  -102,  -102,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,     0,     0,    56,    57,    58,    59,  -141,    60,    61,
      62,   123,  -141,    64,    65,    66,     0,    67,    68,    69,
       0,     0,     0,    70,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
      74,     0,    75,     0,     0,     0,    76,    77,    78,   124,
       0,     0,    80,  -102,    81,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   108,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,   109,
      21,    22,    23,     0,     0,    24,     0,    26,     0,   -19,
      27,    28,  -103,  -103,     0,     0,    29,     0,     0,    31,
      32,     0,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,     0,     0,    56,    57,    58,    59,  -141,    60,
      61,    62,   123,  -141,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      73,    74,     0,    75,     0,     0,     0,    76,    77,    78,
     124,     0,     0,    80,  -103,    81,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   108,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     109,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -19,    27,    28,   -96,   -96,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,     0,     0,    56,    57,    58,    59,  -141,
      60,    61,    62,   123,  -141,    64,    65,    66,     0,    67,
      68,    69,     0,     0,     0,    70,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,    74,     0,    75,     0,     0,     0,    76,    77,
      78,   124,     0,     0,    80,   -96,    81,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     108,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,   109,    21,    22,    23,     0,     0,    24,     0,    26,
       0,   -19,    27,    28,   -98,   -98,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,     0,     0,    56,    57,    58,    59,
    -141,    60,    61,    62,   123,  -141,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,    74,     0,    75,     0,     0,     0,    76,
      77,    78,   124,     0,     0,    80,   -98,    81,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   108,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   109,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -19,    27,    28,  -105,  -105,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,     0,     0,    56,    57,    58,
      59,  -141,    60,    61,    62,   123,  -141,    64,    65,    66,
       0,    67,    68,    69,     0,     0,     0,    70,     0,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,    74,     0,    75,     0,     0,     0,
      76,    77,    78,   124,     0,     0,    80,  -105,    81,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   108,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,   109,    21,    22,    23,     0,     0,    24,
       0,    26,     0,   -19,    27,    28,   -93,   -93,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,  -141,    60,    61,    62,   123,  -141,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     0,
       0,    76,    77,    78,   124,     0,     0,    80,   -93,    81,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   108,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   109,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -19,    27,    28,   -91,   -91,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,     0,     0,    56,
      57,    58,    59,  -141,    60,    61,    62,   123,  -141,    64,
      65,    66,     0,    67,    68,    69,     0,     0,     0,    70,
       0,     0,    71,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,    74,     0,    75,     0,
       0,     0,    76,    77,    78,   124,     0,     0,    80,   -91,
      81,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   108,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,   109,    21,    22,    23,     0,
       0,    24,     0,    26,     0,   -19,    27,    28,   -89,   -89,
       0,     0,    29,     0,     0,    31,    32,     0,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,     0,     0,
      56,    57,    58,    59,  -141,    60,    61,    62,   123,  -141,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    73,    74,     0,    75,
       0,     0,     0,    76,    77,    78,   124,     0,     0,    80,
     -89,    81,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   108,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   109,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -19,    27,    28,   -99,
     -99,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,     0,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,     0,
       0,    56,    57,    58,    59,  -141,    60,    61,    62,   123,
    -141,    64,    65,    66,     0,    67,    68,    69,     0,     0,
       0,    70,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,    74,     0,
      75,     0,     0,     0,    76,    77,    78,   124,     0,     0,
      80,   -99,    81,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   108,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,   109,    21,    22,
      23,     0,     0,    24,     0,    26,     0,   -19,    27,    28,
    -101,  -101,     0,     0,    29,     0,     0,    31,    32,     0,
      33,    34,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,    36,    37,    38,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
       0,     0,    56,    57,    58,    59,  -141,    60,    61,    62,
     123,  -141,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    73,    74,
       0,    75,     0,     0,     0,    76,    77,    78,   124,     0,
       0,    80,  -101,    81,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   108,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   109,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -19,    27,
      28,   -95,   -95,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,     0,     0,    56,    57,    58,    59,  -141,    60,    61,
      62,   123,  -141,    64,    65,    66,     0,    67,    68,    69,
       0,     0,     0,    70,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
      74,     0,    75,     0,     0,     0,    76,    77,    78,   124,
       0,     0,    80,   -95,    81,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   108,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,   109,
      21,    22,    23,     0,     0,    24,     0,    26,     0,   -19,
      27,    28,   -97,   -97,     0,     0,    29,     0,     0,    31,
      32,     0,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,     0,     0,    56,    57,    58,    59,  -141,    60,
      61,    62,   123,  -141,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      73,    74,     0,    75,     0,     0,     0,    76,    77,    78,
     124,     0,     0,    80,   -97,    81,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   108,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     109,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -19,    27,    28,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,     0,     0,    56,    57,    58,    59,  -141,
      60,    61,    62,   123,  -141,    64,    65,    66,     0,    67,
      68,    69,     0,     0,     0,    70,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,    74,     0,    75,     0,     0,     0,    76,    77,
      78,   124,     0,     0,    80,   193,    81,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     108,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,   109,    21,    22,    23,     0,     0,    24,     0,    26,
       0,   -19,    27,    28,     0,     0,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,     0,     0,    56,    57,    58,    59,
    -141,    60,    61,    62,   123,  -141,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,    74,     0,    75,     0,     0,     0,    76,
      77,    78,   124,     0,     0,    80,   329,    81,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   108,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   109,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -19,    27,    28,     0,     0,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,     0,     0,    56,    57,    58,
      59,  -141,    60,    61,    62,   123,  -141,    64,    65,    66,
       0,    67,    68,    69,     0,     0,     0,    70,     0,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,    74,     0,    75,     0,     0,     0,
      76,    77,    78,   124,     0,     0,    80,   365,    81,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   108,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,   109,    21,    22,    23,     0,     0,    24,
       0,    26,     0,   -19,    27,    28,     0,     0,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,  -141,    60,    61,    62,   123,  -141,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     0,
       0,    76,    77,    78,   124,     0,     0,    80,   496,    81,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   108,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   109,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -19,    27,    28,     0,     0,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,     0,     0,    56,
      57,    58,    59,  -141,    60,    61,    62,   123,  -141,    64,
      65,    66,     0,    67,    68,    69,     0,     0,     0,    70,
       0,     0,    71,     0,   275,   276,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,    74,     0,    75,     0,
       0,     0,    76,    77,    78,   124,     0,   179,    80,     0,
      81,     3,     0,     0,     0,     0,     0,   301,   302,   303,
     108,     0,     0,     0,    14,    15,     0,     0,    17,    18,
      19,   109,    21,    22,     0,     0,     0,     0,     0,     0,
       0,   -19,     0,     0,     0,     0,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,     0,     0,     0,
     306,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,    41,     0,     0,     0,
      42,    43,    44,    45,     0,     0,     0,    49,    50,    51,
      52,    53,    54,    55,     0,     0,    56,    57,    58,    59,
    -141,    60,    61,    62,   110,  -141,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,    74,     0,    75,     0,     3,     0,    76,
      77,    78,   111,     0,     0,    80,   108,  -110,     0,     0,
      14,    15,     0,     0,    17,    18,    19,   109,    21,    22,
       0,     0,     0,     0,     0,     0,     0,   -19,     0,     0,
       0,     0,     0,     0,    29,     0,     0,    31,    32,     0,
      33,    34,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,    36,    37,    38,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
       0,     0,     0,    49,    50,    51,    52,    53,    54,    55,
       0,     0,    56,    57,    58,    59,     0,    60,    61,    62,
     110,     0,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    73,    74,
       0,    75,     0,     3,     0,    76,    77,    78,   111,     0,
       0,    80,   108,     0,   197,     0,    14,    15,     0,     0,
      17,    18,    19,   109,    21,    22,     0,     0,     0,     0,
       0,     0,     0,   -19,     0,     0,     0,     0,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,     0,     0,     0,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,     0,    60,    61,    62,   110,     0,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     3,
       0,    76,    77,    78,   111,     0,     0,    80,   108,   -84,
       0,     0,    14,    15,     0,     0,    17,    18,    19,   109,
      21,    22,     0,     0,     0,     0,     0,     0,     0,   -19,
       0,     0,     0,     0,     0,     0,    29,     0,     0,    31,
      32,     0,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,     0,     0,     0,    49,    50,    51,    52,    53,
      54,    55,     0,     0,    56,    57,    58,    59,     0,    60,
      61,    62,   110,     0,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      73,    74,     3,    75,     0,     0,     0,    76,    77,    78,
     111,   108,     0,    80,   269,    14,    15,     0,     0,    17,
      18,    19,   109,    21,    22,     0,     0,     0,     0,     0,
       0,     0,   -19,     0,     0,     0,     0,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,   713,     0,
     714,   715,     0,     0,     0,   716,   717,    41,     0,     0,
       0,    42,    43,    44,    45,     0,     0,     0,    49,    50,
      51,    52,    53,    54,    55,     0,     0,    56,    57,    58,
      59,     0,    60,    61,    62,   110,     0,    64,    65,    66,
       0,    67,    68,    69,     0,     0,     0,    70,   718,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   719,   720,    73,    74,     3,    75,     0,     0,     0,
      76,    77,    78,   111,   108,     0,    80,     0,    14,    15,
       0,     0,    17,    18,    19,   109,    21,    22,     0,     0,
       0,     0,     0,     0,     0,   -19,     0,     0,     0,     0,
       0,     0,    29,     0,     0,    31,    32,     0,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,     0,     0,
       0,    49,    50,    51,    52,    53,    54,    55,     0,     0,
      56,    57,    58,    59,  -141,    60,    61,    62,   110,  -141,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    73,    74,     3,    75,
       0,     0,     0,    76,    77,    78,   111,   108,     0,    80,
       0,    14,    15,     0,     0,    17,    18,    19,   109,    21,
      22,     0,     0,     0,     0,     0,     0,     0,   -19,     0,
       0,     0,     0,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,    42,    43,    44,
      45,     0,     0,     0,    49,    50,    51,    52,    53,    54,
      55,     0,     0,    56,    57,    58,    59,     0,    60,    61,
      62,   110,     0,    64,    65,    66,   587,    67,    68,    69,
       0,     0,     0,    70,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
      74,     0,    75,     0,     0,     0,    76,    77,    78,   111,
       0,     0,    80,     0,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   342,
     306,     0,     0,   307,   308,   309,     0,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
       0,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,     0,     0,     0,   571,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,     0,
       0,   575,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,   370,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   371,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   499,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   500,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   516,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   523,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   591,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   597,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   645,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   655,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   659,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   660,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   661,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   759,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   793,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,     0,     0,     0,     0,     0,     0,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,     0,   245,   246,   247,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   248,   249,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   250,     0,
       0,   251,   252,   253,     0,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,     0,     0,     0,     0,     0,
     264,   265,   266,   267,     0,   268,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,   333,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,     0,   595,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     306,     0,     0,   307,   308,   309,     0,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,     0,   596,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
       0,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
       0,   656,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,   657,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,   667,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,     0,   829,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     306,     0,     0,   307,   308,   309,     0,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,     0,   837,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
       0,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
       0,   840,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,   842,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,   848,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,   570,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,     0,     0,     0,     0,     0,
       0,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,     0,   301,   302,   303,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   304,   305,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   306,
       0,     0,   307,   308,   309,     0,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,     0,     0,     0,     0,
       0,   320,   321,   322,   323,   574,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,   370,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
     569,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,   573,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,   769,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     306,     0,     0,   307,   308,   309,   794,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,   795,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
     796,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,   800,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,   801,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     306,     0,     0,   307,   308,   309,     0,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   306,   301,   302,   303,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
     304,   305,     0,     0,   320,   321,   322,   323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,     0,
       0,     0,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   275,   276,     0,     0,     0,   320,   321,
     322,   323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   287,     0,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,     0,   301,   302,   303,   275,
     276,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,     0,   301,   302,   303,     0,     0,     0,     0,   306,
       0,     0,     0,     0,     0,     0,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,     0,     0,     0,     0,
       0,   320,   321,   322,   323,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   306,     0,     0,     0,     0,
     275,   276,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,     0,     0,     0,     0,     0,   320,   321,   322,
     323,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,   275,   276,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,   306,     0,     0,     0,
     275,   276,     0,     0,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,     0,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   306,   301,   302,   303,     0,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323
};

static const yytype_int16 yycheck[] =
{
       2,     0,     0,     3,     6,     3,   591,     0,   381,   381,
      98,   205,   504,    15,    16,    17,    18,     0,     5,   213,
     124,     4,     5,   381,   381,   113,   381,   151,   381,   381,
      14,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    14,    45,   120,    14,   106,    49,    50,    51,
      52,    53,    54,    32,    14,    14,    14,    14,    14,    46,
      47,    48,   149,    46,    47,    48,    14,    38,    39,   103,
     149,    73,    74,   127,    76,    77,    78,     0,    80,    24,
      25,   127,   149,    82,    82,   103,   146,   103,    85,    82,
     108,   583,   108,   609,    48,    49,    79,   103,   152,    82,
      98,   557,   103,   559,    43,   151,   103,   108,    85,   111,
     107,   108,   604,   127,    32,   113,   150,    35,   120,   103,
     104,   139,   638,   139,   108,   109,   103,   106,   130,   131,
     107,   103,   104,   149,   103,   104,   150,   109,   139,   108,
     109,   124,   139,   103,   636,   637,   103,   103,   104,   108,
     108,   108,   154,   109,   103,   104,    79,   627,   103,    82,
     108,   127,   149,   108,   634,   149,   149,   146,   541,   541,
     124,   627,    38,    39,   113,   128,   128,   149,   634,   150,
     119,   183,   149,   541,   541,   151,   541,   703,   541,   541,
     130,    85,   146,   147,   148,   149,   390,   149,   151,   151,
     151,   124,   742,   203,   696,   203,   746,   699,   793,   103,
     627,   151,   195,   107,   108,   151,   151,   634,   128,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   151,   151,   146,   246,   247,   248,   249,    85,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   149,   103,   627,   103,   785,
     107,   108,   195,   108,   634,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   115,   374,   815,
     302,   303,   304,   305,   149,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   103,    79,    35,   816,    14,   108,   103,   103,   104,
     151,    35,   108,   108,   109,    24,    25,    26,    27,   149,
     342,   103,    85,    32,   346,   104,    35,   330,    11,     9,
     352,   353,   354,    42,   117,   118,    45,    46,   121,   122,
     103,   149,   149,   139,   107,   108,   368,   124,   370,    85,
     103,   104,   374,   149,   128,   108,   109,    24,    25,    26,
      27,   149,   381,   381,   103,    32,    85,   103,   381,   108,
     128,   107,   108,    48,    49,    42,   117,   118,    45,    46,
     121,   122,   149,   149,   103,    25,   149,   330,   107,   108,
     104,   103,    32,    14,   103,   109,   108,    85,   103,   108,
     614,   615,    42,    24,    25,    26,    27,   103,   152,   149,
     128,    32,   108,   149,    35,   103,   149,   631,   195,   107,
     108,    42,   149,    40,    45,    46,    24,    25,    26,    27,
     139,   149,   149,   151,    32,    24,    25,    26,    27,   121,
     548,   150,   149,    32,    42,   146,   103,    45,    46,   124,
     151,   108,   149,    42,    14,   128,    45,    46,   121,    24,
      25,    26,    27,   103,   678,   103,   152,    32,   108,   128,
     108,   146,   147,   148,   149,   497,   149,    42,   151,   693,
      45,    46,   103,   150,   506,   507,   508,   108,   510,   511,
     512,   149,   499,   500,   149,   517,   499,   500,   151,   139,
     104,   146,   146,    14,   103,   109,   151,   151,   149,   108,
     150,    48,    49,    24,    25,    26,    27,   152,   139,    85,
     103,   103,   541,   541,   632,   108,   108,    85,   541,   150,
     548,    42,   152,   128,    45,    46,   149,   103,   557,   149,
     559,   107,   108,   146,   557,   103,   559,   569,   151,   107,
     108,   573,   150,   330,    24,    25,    26,    27,   146,   149,
     146,   150,   146,   151,   584,   151,   584,   151,   149,   128,
       4,    25,    42,   152,   152,    45,    46,   149,    32,   149,
     149,   152,   146,   149,   152,   150,   127,   124,    42,   152,
     152,   149,   103,    41,   149,   152,   152,   108,   722,   136,
     137,   138,   139,   140,   152,   152,    14,   152,   627,   146,
     147,   148,   149,   631,   627,   634,    24,    25,    26,    27,
     152,   634,   151,    34,   152,   152,   152,   149,   139,   152,
     151,   151,   654,   146,    42,   149,   152,    45,    46,   646,
     647,   663,   766,   646,   647,   769,   130,    14,   655,   103,
     103,   658,   655,   152,   108,   658,   152,    24,    25,    26,
      27,   681,   152,   681,   152,   685,   151,   685,   149,   130,
     794,   795,   796,   797,   798,    42,   800,   801,    45,    46,
     149,   149,   127,   108,   103,   139,   152,    25,   152,   152,
     712,   713,   714,   715,    32,   103,   150,   719,   720,   121,
     108,   121,   130,    32,    42,   103,   132,   106,   152,   106,
     152,   137,   138,   130,   130,   152,   734,   103,   151,   722,
     152,   152,   742,   152,   742,   152,   746,   151,   746,    82,
     151,   139,   357,    26,   665,   541,   103,   212,   621,   559,
     685,   108,   743,   623,   727,   111,    48,    49,    68,   368,
      -1,   758,    -1,    -1,   776,   758,   182,    25,    -1,   185,
      -1,    -1,    -1,   766,    32,   103,   769,   770,    -1,    -1,
     108,    -1,   139,    -1,    42,    -1,    -1,    -1,    -1,   722,
      -1,    -1,    -1,   805,    -1,    -1,    -1,   809,    -1,    -1,
     812,   794,   795,   796,   797,   798,   799,   800,   801,   802,
      -1,   139,    -1,    -1,   826,    -1,    -1,    -1,   585,   586,
     817,    -1,   150,    -1,   817,   818,   819,   820,   821,   822,
     823,   824,   124,   766,    -1,    -1,   769,   770,    -1,    -1,
     607,   608,    -1,    -1,    -1,   103,   138,   139,   140,    -1,
     108,   267,    -1,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,   794,   795,   796,   797,   798,   799,   800,   801,   802,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,
      -1,   139,   649,    -1,    -1,   818,   819,   820,   821,   822,
     823,   824,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   672,   673,   323,    -1,   676,
      -1,    -1,   328,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   339,    -1,    -1,    -1,    -1,    -1,    -1,
     697,   698,    -1,    -1,   701,   702,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   359,   360,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   722,    -1,    -1,    -1,    -1,
      -1,    -1,   378,   379,   380,    -1,    -1,   139,   140,    -1,
      -1,   387,   388,   389,   146,   147,   148,   149,    -1,    -1,
      -1,    -1,    -1,   750,    -1,    -1,   753,   754,    48,    49,
     757,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   766,
      -1,    -1,   769,   770,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,   794,   795,   796,
     797,   798,   799,   800,   801,   802,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   818,   819,   820,   821,   822,   823,   824,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   834,   835,   129,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,   498,    -1,    -1,   501,   146,   147,   148,   149,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,    -1,
     566,   567,   568,    -1,     0,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    -1,    31,    32,    33,    -1,    35,
      36,    37,    -1,    -1,   610,    -1,    42,    43,    44,    45,
      46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   648,    -1,    80,    -1,    -1,    -1,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    -1,    -1,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,    -1,   119,   120,    -1,    -1,   123,   694,   125,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,
     146,    -1,    -1,   149,    -1,   151,    -1,    -1,    -1,   725,
     726,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     1,    -1,    -1,    -1,     5,    -1,    -1,    -1,
      -1,    -1,   748,    -1,    -1,    14,    -1,    -1,    -1,    18,
      19,    -1,    -1,    22,    23,    24,    25,    26,    27,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      -1,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   810,    -1,    -1,   813,    -1,    -1,
      -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,    -1,
      -1,   827,    91,    92,    93,    94,    95,    96,    97,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,    -1,   114,   115,   116,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,
     149,    -1,     1,   152,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    32,    33,    -1,    35,    36,    37,    -1,
      -1,    -1,    -1,    42,    43,    44,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,    -1,    -1,
     119,   120,    -1,    -1,   123,    -1,   125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,     1,
     149,     3,   151,     5,     6,     7,     8,    -1,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    35,    36,    37,    -1,    -1,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,   143,   144,   145,   146,    -1,     1,   149,     3,   151,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,    -1,   114,
     115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,
     145,   146,    -1,    -1,   149,   150,   151,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    -1,    31,    -1,    33,
      -1,    35,    36,    37,    38,    39,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,    -1,
     114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,
     144,   145,   146,    -1,    -1,   149,   150,   151,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,
      -1,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
      -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
     143,   144,   145,   146,    -1,    -1,   149,   150,   151,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    -1,    31,
      -1,    33,    -1,    35,    36,    37,    38,    39,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,   143,   144,   145,   146,    -1,    -1,   149,   150,   151,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    -1,    -1,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,
      -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,   143,   144,   145,   146,    -1,    -1,   149,   150,
     151,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      -1,    31,    -1,    33,    -1,    35,    36,    37,    38,    39,
      -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      80,    -1,    -1,    -1,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,
     120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,   149,
     150,   151,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,    -1,   114,   115,   116,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,
     149,   150,   151,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,
      38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      -1,    -1,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,    -1,   114,   115,   116,    -1,
      -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,
      -1,   149,   150,   151,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,    -1,   114,   115,   116,
      -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,
      -1,    -1,   149,   150,   151,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,
      36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,
      46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    -1,    -1,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,    -1,   114,   115,
     116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,
     146,    -1,    -1,   149,   150,   151,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,    -1,   114,
     115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,
     145,   146,    -1,    -1,   149,   150,   151,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    -1,    31,    -1,    33,
      -1,    35,    36,    37,    38,    39,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,    -1,
     114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,
     144,   145,   146,    -1,    -1,   149,   150,   151,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,
      -1,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
      -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
     143,   144,   145,   146,    -1,    -1,   149,   150,   151,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    -1,    31,
      -1,    33,    -1,    35,    36,    37,    38,    39,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,   143,   144,   145,   146,    -1,    -1,   149,   150,   151,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    -1,    -1,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,
      -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,   143,   144,   145,   146,    -1,    -1,   149,   150,
     151,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      -1,    31,    -1,    33,    -1,    35,    36,    37,    38,    39,
      -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      80,    -1,    -1,    -1,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,
     120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,   149,
     150,   151,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,    -1,   114,   115,   116,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,
     149,   150,   151,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,
      38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      -1,    -1,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,    -1,   114,   115,   116,    -1,
      -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,
      -1,   149,   150,   151,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,    -1,   114,   115,   116,
      -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,
      -1,    -1,   149,   150,   151,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,
      36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,
      46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    -1,    -1,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,    -1,   114,   115,
     116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,
     146,    -1,    -1,   149,   150,   151,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,    -1,   114,
     115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,
     145,   146,    -1,    -1,   149,   150,   151,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    -1,    31,    -1,    33,
      -1,    35,    36,    37,    -1,    -1,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,    -1,
     114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,
     144,   145,   146,    -1,    -1,   149,   150,   151,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    -1,    -1,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,
      -1,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
      -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
     143,   144,   145,   146,    -1,    -1,   149,   150,   151,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    -1,    31,
      -1,    33,    -1,    35,    36,    37,    -1,    -1,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,   143,   144,   145,   146,    -1,    -1,   149,   150,   151,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    -1,    -1,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    -1,    -1,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,
      -1,    -1,   123,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,   143,   144,   145,   146,    -1,     1,   149,    -1,
     151,     5,    -1,    -1,    -1,    -1,    -1,    81,    82,    83,
      14,    -1,    -1,    -1,    18,    19,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
     124,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    80,    -1,    -1,    -1,
      84,    85,    86,    87,    -1,    -1,    -1,    91,    92,    93,
      94,    95,    96,    97,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,    -1,
     114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,    -1,   139,    -1,     5,    -1,   143,
     144,   145,   146,    -1,    -1,   149,    14,   151,    -1,    -1,
      18,    19,    -1,    -1,    22,    23,    24,    25,    26,    27,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,
      -1,    -1,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,
      -1,    -1,    -1,    91,    92,    93,    94,    95,    96,    97,
      -1,    -1,   100,   101,   102,   103,    -1,   105,   106,   107,
     108,    -1,   110,   111,   112,    -1,   114,   115,   116,    -1,
      -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
      -1,   139,    -1,     5,    -1,   143,   144,   145,   146,    -1,
      -1,   149,    14,    -1,   152,    -1,    18,    19,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    -1,    -1,    -1,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,    -1,   105,   106,   107,   108,    -1,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,     5,
      -1,   143,   144,   145,   146,    -1,    -1,   149,    14,   151,
      -1,    -1,    18,    19,    -1,    -1,    22,    23,    24,    25,
      26,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,
      -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,    45,
      46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,
      86,    87,    -1,    -1,    -1,    91,    92,    93,    94,    95,
      96,    97,    -1,    -1,   100,   101,   102,   103,    -1,   105,
     106,   107,   108,    -1,   110,   111,   112,    -1,   114,   115,
     116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     136,   137,     5,   139,    -1,    -1,    -1,   143,   144,   145,
     146,    14,    -1,   149,   150,    18,    19,    -1,    -1,    22,
      23,    24,    25,    26,    27,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    74,    -1,    -1,    -1,    78,    79,    80,    -1,    -1,
      -1,    84,    85,    86,    87,    -1,    -1,    -1,    91,    92,
      93,    94,    95,    96,    97,    -1,    -1,   100,   101,   102,
     103,    -1,   105,   106,   107,   108,    -1,   110,   111,   112,
      -1,   114,   115,   116,    -1,    -1,    -1,   120,   121,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   134,   135,   136,   137,     5,   139,    -1,    -1,    -1,
     143,   144,   145,   146,    14,    -1,   149,    -1,    18,    19,
      -1,    -1,    22,    23,    24,    25,    26,    27,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    -1,
      -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      80,    -1,    -1,    -1,    84,    85,    86,    87,    -1,    -1,
      -1,    91,    92,    93,    94,    95,    96,    97,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,
     120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,   137,     5,   139,
      -1,    -1,    -1,   143,   144,   145,   146,    14,    -1,   149,
      -1,    18,    19,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,
      -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,
      87,    -1,    -1,    -1,    91,    92,    93,    94,    95,    96,
      97,    -1,    -1,   100,   101,   102,   103,    -1,   105,   106,
     107,   108,    -1,   110,   111,   112,    10,   114,   115,   116,
      -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,
      -1,    -1,   149,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    21,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,    -1,    -1,   153,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,   153,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,   151,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,   151,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,   151,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    -1,   151,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      -1,   151,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,   151,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,   151,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,   151,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    -1,   151,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      -1,   151,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,   151,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,   151,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,   150,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,
      -1,    -1,   127,   128,   129,    -1,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,
      -1,   146,   147,   148,   149,   150,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   124,    81,    82,    83,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      98,    99,    -1,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,
      -1,    -1,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    48,    49,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,
      -1,   146,   147,   148,   149,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,
      48,    49,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,
     149,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,
      48,    49,    -1,    -1,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   124,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,     6,     7,     8,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    22,    23,    24,
      25,    26,    27,    28,    31,    32,    33,    36,    37,    42,
      44,    45,    46,    48,    49,    60,    61,    62,    63,    64,
      65,    80,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,   100,   101,   102,   103,
     105,   106,   107,   108,   110,   111,   112,   114,   115,   116,
     120,   123,   125,   136,   137,   139,   143,   144,   145,   146,
     149,   151,   155,   156,   159,   160,   161,   164,   165,   170,
     173,   174,   177,   179,   184,   185,   195,   199,   200,   201,
     203,   204,   206,   210,   212,   213,   214,   151,    14,    25,
     108,   146,   184,   200,   205,   209,   210,   211,   103,   108,
     149,   184,   185,   108,   146,   166,   167,   170,   167,   211,
     149,   149,   149,    85,   103,   107,   108,   149,   193,   151,
     151,   151,   211,   211,   211,   211,    32,   103,   169,   171,
     103,   108,   169,   151,   149,   146,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   103,   108,   211,
     167,   167,   167,   211,   211,   211,   211,   211,   211,     1,
     178,   211,   149,   149,   213,   149,   211,   211,   103,   108,
     211,   211,   211,   150,   166,   168,   170,   152,   207,   208,
     211,     0,   156,    35,   151,    14,   103,   108,   104,   109,
      43,   113,   119,    14,    25,   103,   108,   184,   201,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    81,    82,    83,    98,    99,
     124,   127,   128,   129,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   146,   147,   148,   149,   151,   150,
     207,   211,    14,    14,   184,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    81,    82,    83,    98,    99,   124,   127,   128,   129,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     146,   147,   148,   149,   205,   211,   103,   104,   149,   150,
     168,    11,     9,   151,   211,   211,   178,   149,   149,   149,
     178,   178,    21,    21,   103,   108,   149,    10,    29,    30,
     167,   172,   128,   128,   149,   211,   103,   157,   158,   149,
     149,   152,   178,   211,   178,   150,   166,   170,   127,   152,
     130,   152,   103,   108,   149,   184,   185,   108,   149,   193,
     149,   146,   151,    40,   180,   180,   108,   149,   193,   149,
      14,   108,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   117,   118,   121,   122,   121,   103,
     108,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   178,   150,    14,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   117,   118,   121,   122,
     121,   103,   108,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   178,   152,   178,   150,   149,   149,   152,
     152,   151,   178,   152,   152,   211,   149,   128,   128,   211,
     149,   149,   149,   211,   211,   211,   152,   128,   150,   158,
     178,   178,   152,   152,   152,   208,   211,   205,   103,   108,
     104,   109,   149,   178,   178,   178,    14,   108,   150,   160,
     161,   162,   163,   164,   165,   179,   184,   195,   200,   203,
     204,    24,    25,   103,   108,   181,   182,   146,   151,   146,
     151,   149,   178,   178,   178,   108,   149,   193,   149,   130,
     150,   153,   152,   130,   150,   153,   152,   152,   211,   178,
     167,   167,   178,   152,     4,   202,   202,    10,   211,   211,
     211,   152,   211,   211,   211,   151,   151,   152,   146,   211,
     152,   152,   130,   151,   196,   152,   178,   152,   152,   152,
     149,   151,   150,   163,    14,    14,   184,   103,   108,   103,
     108,   127,    24,    25,    32,   150,   164,   183,   186,   187,
     194,   199,   200,   150,   183,   178,   152,   152,   152,   149,
     178,   178,   178,   211,   211,   152,   152,    41,   151,   202,
     184,   185,   166,   166,   149,   152,   151,   151,   171,   152,
     152,   152,    34,    38,    39,   175,   176,   151,   103,   108,
     197,   198,   202,   152,   166,   166,   196,   178,    14,   182,
     106,   146,   190,   191,    32,   146,   191,   150,   164,   186,
     187,   194,   103,   184,   193,   150,   152,   202,   202,   196,
     178,   152,   152,   152,   151,   167,   167,   178,   166,   211,
     167,   167,   149,    71,    73,    74,    78,    79,   121,   134,
     135,   211,   130,   150,   176,   149,   149,   127,   166,   166,
     166,   152,   108,    25,    42,   103,   150,   164,   184,   185,
     188,   189,   192,   127,   151,   150,   192,   151,   193,   178,
     202,   166,   166,   202,   152,   166,   166,   196,   152,   152,
     211,   211,   211,   211,   121,   121,   130,   211,   211,   130,
     168,   178,   178,   198,   103,   184,   128,   151,   103,   106,
     150,   189,   190,   150,   178,   152,   166,   151,   166,   166,
     151,   166,   167,   152,   130,   130,   130,   130,   130,   168,
     130,   130,   168,   152,   152,   128,   151,   103,   211,   128,
     149,   151,   128,   149,   151,   152,   196,   171,   168,   168,
     168,   168,   168,   168,   168,   211,   128,   149,   151,   151,
     211,   178,   211,   178,   196,   202,   167,   151,   211,   178,
     151,   152,   151,   152,   151,   166,   151,   166,   151,   152,
     151,   151,   151
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   154,   155,   155,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   157,   157,   158,   159,
     159,   160,   160,   160,   160,   160,   160,   160,   161,   161,
     161,   162,   162,   163,   163,   163,   163,   163,   163,   163,
     163,   164,   164,   165,   165,   166,   166,   167,   167,   168,
     168,   168,   168,   169,   169,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   170,   170,   171,
     171,   172,   172,   172,   173,   173,   174,   175,   175,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   177,
     178,   178,   178,   179,   179,   179,   179,   179,   179,   180,
     180,   181,   181,   182,   182,   182,   182,   182,   182,   183,
     183,   183,   183,   183,   183,   183,   183,   184,   184,   184,
     184,   185,   185,   186,   186,   186,   187,   187,   187,   188,
     188,   188,   188,   188,   189,   189,   189,   189,   189,   189,
     189,   189,   189,   189,   190,   190,   191,   191,   192,   192,
     193,   193,   193,   194,   194,   194,   194,   195,   195,   195,
     195,   195,   195,   196,   196,   197,   197,   198,   198,   199,
     199,   200,   200,   201,   201,   201,   201,   201,   201,   201,
     202,   202,   203,   203,   203,   203,   204,   204,   204,   204,
     205,   205,   206,   206,   207,   207,   207,   208,   209,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   213,   213,   214,   214,
     214,   214,   214
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     1,     4,     1,     1,     2,     4,     0,
       1,     4,     3,     4,     3,     4,     4,     5,     5,     3,
       4,     1,     2,     1,     1,     1,     1,     1,     2,     1,
       1,     5,     6,     5,     6,     3,     2,     1,     1,     1,
       1,     2,     2,     0,     1,     1,     2,     5,     1,     2,
       3,     2,     2,     2,     3,    11,     7,     5,     7,     5,
       7,     9,     7,     2,     2,     2,     2,     1,     2,     0,
       2,     4,     4,     4,     1,     2,     7,     1,     2,     5,
       4,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     5,     4,     4,     3,     4,     3,     3,     2,     7,
       0,     1,     1,     6,     6,     4,     4,     5,     5,     2,
       0,     1,     3,     1,     1,     2,     2,     2,     2,     1,
       1,     1,     1,     2,     2,     2,     2,     1,     1,     2,
       2,     0,     1,     3,     4,     3,     3,     4,     3,     4,
       3,     6,     5,     7,     3,     5,     6,     3,     5,     6,
       2,     4,     1,     1,     1,     2,     1,     3,     1,     2,
       2,     2,     1,     7,     7,     7,     7,     8,     8,     8,
       8,     7,     7,     2,     0,     1,     3,     4,     4,     0,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     6,     6,     7,     7,     7,     7,     8,     8,
       3,     2,     3,     2,     1,     3,     2,     3,     3,     1,
       1,     3,     1,     2,     2,     2,     3,     2,     3,     4,
       1,     1,     1,     1,     1,     8,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     4,     3,     1,     2,     2,     2,     2,
       2,     5,     5,     2,     1,     3,     2,     6,     6,     7,
       7,     1,     1,     2,     2,     4,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     2,     2,     4,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     4,     4,
       3,     2,     1,     1,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       2,     2,     4,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     4,     4,     3,     2,     1,     2,     1,     1,
       1,     1,     1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static unsigned
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  unsigned res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                       , &(yylsp[(yyi + 1) - (yynrhs)])                       , yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yytype)
    {
          case 103: /* "identifier"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5366 "parser.cpp" /* yacc.c:1257  */
        break;

    case 104: /* "variable reference"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5372 "parser.cpp" /* yacc.c:1257  */
        break;

    case 105: /* "backquote expression"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5378 "parser.cpp" /* yacc.c:1257  */
        break;

    case 106: /* "in-object member reference"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5384 "parser.cpp" /* yacc.c:1257  */
        break;

    case 107: /* "identifier or keyword used as function or method identifier"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5390 "parser.cpp" /* yacc.c:1257  */
        break;

    case 108: /* "namespace or class-scoped reference"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5396 "parser.cpp" /* yacc.c:1257  */
        break;

    case 109: /* "namespace-scoped global variable reference"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5402 "parser.cpp" /* yacc.c:1257  */
        break;

    case 110: /* "context reference"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5408 "parser.cpp" /* yacc.c:1257  */
        break;

    case 111: /* "named context reference"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5414 "parser.cpp" /* yacc.c:1257  */
        break;

    case 112: /* "cast operator"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5420 "parser.cpp" /* yacc.c:1257  */
        break;

    case 113: /* "simple class declaration"  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5426 "parser.cpp" /* yacc.c:1257  */
        break;

    case 114: /* "date/time value"  */
#line 1574 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).datetime)) ((*yyvaluep).datetime)->deref(); }
#line 5432 "parser.cpp" /* yacc.c:1257  */
        break;

    case 115: /* "quoted string"  */
#line 1574 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 5438 "parser.cpp" /* yacc.c:1257  */
        break;

    case 116: /* "binary constant value"  */
#line 1574 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).binary)) ((*yyvaluep).binary)->deref(); }
#line 5444 "parser.cpp" /* yacc.c:1257  */
        break;

    case 117: /* "regular expression substitution expression"  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).RegexSubst); }
#line 5450 "parser.cpp" /* yacc.c:1257  */
        break;

    case 118: /* "transliteration expression"  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).RegexTrans); }
#line 5456 "parser.cpp" /* yacc.c:1257  */
        break;

    case 119: /* "scoped class declaration"  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).nscope); }
#line 5462 "parser.cpp" /* yacc.c:1257  */
        break;

    case 120: /* "call to base class method"  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).nscope); }
#line 5468 "parser.cpp" /* yacc.c:1257  */
        break;

    case 121: /* "regular expression"  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).Regex); }
#line 5474 "parser.cpp" /* yacc.c:1257  */
        break;

    case 122: /* "regular expression extraction expression"  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).Regex); }
#line 5480 "parser.cpp" /* yacc.c:1257  */
        break;

    case 123: /* "implicit argument reference"  */
#line 1574 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).implicit_arg)) ((*yyvaluep).implicit_arg)->deref(); }
#line 5486 "parser.cpp" /* yacc.c:1257  */
        break;

    case 124: /* "keyword used as hash key or object member reference"  */
#line 1574 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 5492 "parser.cpp" /* yacc.c:1257  */
        break;

    case 125: /* "%try-module error token"  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).trymod); }
#line 5498 "parser.cpp" /* yacc.c:1257  */
        break;

    case 160: /* gvardecl  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).gv); }
#line 5504 "parser.cpp" /* yacc.c:1257  */
        break;

    case 161: /* top_namespace_decl  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).ns); }
#line 5510 "parser.cpp" /* yacc.c:1257  */
        break;

    case 162: /* namespace_decls  */
#line 1574 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).nsnlist)) ((*yyvaluep).nsnlist)->deref(); }
#line 5516 "parser.cpp" /* yacc.c:1257  */
        break;

    case 163: /* namespace_decl  */
#line 1574 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).nsn)) ((*yyvaluep).nsn)->deref(); }
#line 5522 "parser.cpp" /* yacc.c:1257  */
        break;

    case 164: /* unscoped_const_decl  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).constnode); }
#line 5528 "parser.cpp" /* yacc.c:1257  */
        break;

    case 165: /* scoped_const_decl  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).constnode); }
#line 5534 "parser.cpp" /* yacc.c:1257  */
        break;

    case 166: /* block  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sblock); }
#line 5540 "parser.cpp" /* yacc.c:1257  */
        break;

    case 167: /* statement_or_block  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sblock); }
#line 5546 "parser.cpp" /* yacc.c:1257  */
        break;

    case 168: /* statements  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sblock); }
#line 5552 "parser.cpp" /* yacc.c:1257  */
        break;

    case 169: /* optname  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5558 "parser.cpp" /* yacc.c:1257  */
        break;

    case 170: /* statement  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 5564 "parser.cpp" /* yacc.c:1257  */
        break;

    case 171: /* context_mods  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).cmods); }
#line 5570 "parser.cpp" /* yacc.c:1257  */
        break;

    case 172: /* context_mod  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).cmod); }
#line 5576 "parser.cpp" /* yacc.c:1257  */
        break;

    case 173: /* return_statement  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 5582 "parser.cpp" /* yacc.c:1257  */
        break;

    case 174: /* switch_statement  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 5588 "parser.cpp" /* yacc.c:1257  */
        break;

    case 175: /* case_block  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).switchstmt); }
#line 5594 "parser.cpp" /* yacc.c:1257  */
        break;

    case 176: /* case_code  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).casenode); }
#line 5600 "parser.cpp" /* yacc.c:1257  */
        break;

    case 177: /* try_statement  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).statement); }
#line 5606 "parser.cpp" /* yacc.c:1257  */
        break;

    case 178: /* myexp  */
#line 1575 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); }
#line 5612 "parser.cpp" /* yacc.c:1257  */
        break;

    case 179: /* class_def  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).classdef); }
#line 5618 "parser.cpp" /* yacc.c:1257  */
        break;

    case 180: /* inheritance_list  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sclist); }
#line 5624 "parser.cpp" /* yacc.c:1257  */
        break;

    case 181: /* superclass_list  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sclist); }
#line 5630 "parser.cpp" /* yacc.c:1257  */
        break;

    case 182: /* superclass  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sclnode); }
#line 5636 "parser.cpp" /* yacc.c:1257  */
        break;

    case 183: /* class_attributes  */
#line 1572 "parser.ypp" /* yacc.c:1257  */
      { qore_class_private::get(*((*yyvaluep).qoreclass))->deref(); }
#line 5642 "parser.cpp" /* yacc.c:1257  */
        break;

    case 184: /* uncqtypedef  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).parsertype); }
#line 5648 "parser.cpp" /* yacc.c:1257  */
        break;

    case 185: /* qtypedef  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).parsertype); }
#line 5654 "parser.cpp" /* yacc.c:1257  */
        break;

    case 186: /* private_member_list  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 5660 "parser.cpp" /* yacc.c:1257  */
        break;

    case 187: /* public_member_list  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 5666 "parser.cpp" /* yacc.c:1257  */
        break;

    case 188: /* classvardecl  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).classvarinfo); }
#line 5672 "parser.cpp" /* yacc.c:1257  */
        break;

    case 189: /* member2  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberinfo); }
#line 5678 "parser.cpp" /* yacc.c:1257  */
        break;

    case 190: /* member  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberinfo); }
#line 5684 "parser.cpp" /* yacc.c:1257  */
        break;

    case 191: /* member_list  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 5690 "parser.cpp" /* yacc.c:1257  */
        break;

    case 192: /* member_list2  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).memberlist); }
#line 5696 "parser.cpp" /* yacc.c:1257  */
        break;

    case 193: /* ident_openparen  */
#line 1573 "parser.ypp" /* yacc.c:1257  */
      { free(((*yyvaluep).string)); }
#line 5702 "parser.cpp" /* yacc.c:1257  */
        break;

    case 194: /* inline_methoddef  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).methodnode); }
#line 5708 "parser.cpp" /* yacc.c:1257  */
        break;

    case 195: /* outofline_methoddef  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).methoddef); }
#line 5714 "parser.cpp" /* yacc.c:1257  */
        break;

    case 196: /* base_constructor_list  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).bcalist); }
#line 5720 "parser.cpp" /* yacc.c:1257  */
        break;

    case 197: /* base_constructors  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).bcalist); }
#line 5726 "parser.cpp" /* yacc.c:1257  */
        break;

    case 198: /* base_constructor  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).bcanode); }
#line 5732 "parser.cpp" /* yacc.c:1257  */
        break;

    case 202: /* return_value  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).returnTypeInfo); }
#line 5738 "parser.cpp" /* yacc.c:1257  */
        break;

    case 203: /* sub_def  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).parsefunc); }
#line 5744 "parser.cpp" /* yacc.c:1257  */
        break;

    case 204: /* scoped_sub_def  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).sparsefunc); }
#line 5750 "parser.cpp" /* yacc.c:1257  */
        break;

    case 205: /* list  */
#line 1575 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).list)) ((*yyvaluep).list)->deref(0); }
#line 5756 "parser.cpp" /* yacc.c:1257  */
        break;

    case 207: /* hash  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).hash); }
#line 5762 "parser.cpp" /* yacc.c:1257  */
        break;

    case 208: /* hash_element  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).hashelement); }
#line 5768 "parser.cpp" /* yacc.c:1257  */
        break;

    case 209: /* alt_hash  */
#line 1571 "parser.ypp" /* yacc.c:1257  */
      { delete ((*yyvaluep).hash); }
#line 5774 "parser.cpp" /* yacc.c:1257  */
        break;

    case 210: /* exp_c  */
#line 1575 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); }
#line 5780 "parser.cpp" /* yacc.c:1257  */
        break;

    case 211: /* exp  */
#line 1575 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); }
#line 5786 "parser.cpp" /* yacc.c:1257  */
        break;

    case 212: /* exp_n  */
#line 1575 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); }
#line 5792 "parser.cpp" /* yacc.c:1257  */
        break;

    case 213: /* string  */
#line 1574 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 5798 "parser.cpp" /* yacc.c:1257  */
        break;

    case 214: /* scalar  */
#line 1575 "parser.ypp" /* yacc.c:1257  */
      { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); }
#line 5804 "parser.cpp" /* yacc.c:1257  */
        break;


      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (yyscan_t yyscanner)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yyls1, yysize * sizeof (*yylsp),
                    &yystacksize);

        yyls = yyls1;
        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 1584 "parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[0].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 6100 "parser.cpp" /* yacc.c:1646  */
    break;

  case 5:
#line 1587 "parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[0].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 6108 "parser.cpp" /* yacc.c:1646  */
    break;

  case 6:
#line 1590 "parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddClass(*((yyvsp[0].classdef)->name), (yyvsp[0].classdef)->oc);

	   // see if class definitions are allowed
	   if (parse_check_parse_option(PO_NO_CLASS_DEFS))
	      parse_error("illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
	   delete (yyvsp[0].classdef);
	}
#line 6121 "parser.cpp" /* yacc.c:1646  */
    break;

  case 7:
#line 1598 "parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddConstant(*getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
	   delete (yyvsp[0].constnode);
	}
#line 6130 "parser.cpp" /* yacc.c:1646  */
    break;

  case 8:
#line 1602 "parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddConstant(*getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
	   delete (yyvsp[0].constnode);
	}
#line 6139 "parser.cpp" /* yacc.c:1646  */
    break;

  case 9:
#line 1606 "parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[0].methoddef)->parseAddToClassAndDel();
        }
#line 6147 "parser.cpp" /* yacc.c:1646  */
    break;

  case 10:
#line 1609 "parser.ypp" /* yacc.c:1646  */
    {
	   if ((yyvsp[0].statement)) {
	      if ((yyvsp[0].statement)->isParseDeclaration())
		 delete (yyvsp[0].statement);
	      else
	         qore_program_private::addStatement(*(getProgram()), (yyvsp[0].statement));
	   }
	}
#line 6160 "parser.cpp" /* yacc.c:1646  */
    break;

  case 12:
#line 1618 "parser.ypp" /* yacc.c:1646  */
    {
	   // set line range
	   (yyvsp[-1].sblock)->loc.start_line = (yylsp[-2]).first_line;
	   (yyvsp[-1].sblock)->loc.end_line = (yylsp[-1]).last_line;
	   qore_program_private::addStatement(*(getProgram()), (yyvsp[-1].sblock));
        }
#line 6171 "parser.cpp" /* yacc.c:1646  */
    break;

  case 13:
#line 1624 "parser.ypp" /* yacc.c:1646  */
    {
           qore_root_ns_private::parseAddNamespace((yyvsp[0].ns));
	   // see if ns declaration is legal
	   if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
	      parse_error("illegal namespace definition \"%s\" (conflicts with parse option NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
	}
#line 6182 "parser.cpp" /* yacc.c:1646  */
    break;

  case 14:
#line 1630 "parser.ypp" /* yacc.c:1646  */
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");

           // registered internally
        }
#line 6194 "parser.cpp" /* yacc.c:1646  */
    break;

  case 15:
#line 1637 "parser.ypp" /* yacc.c:1646  */
    {
           bool has_dollar = (yyvsp[0].trymod)->var[0] == '$';
           if (!has_dollar) {
              if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error("%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].trymod)->var);
           }
           else {
              (yyvsp[0].trymod)->fixName();
              if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error("%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[0].trymod)->var);
           }

           if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
              parse_error("'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
              delete (yyvsp[0].trymod);
           }
           else {
              VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].trymod)->takeName());
              QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(left, (yyvsp[0].trymod)->takeExceptionHash());
              qore_program_private::addStatement(*(getProgram()), new ExpressionStatement((yylsp[0]).first_line, (yylsp[0]).last_line, exp));
           }
        }
#line 6221 "parser.cpp" /* yacc.c:1646  */
    break;

  case 16:
#line 1662 "parser.ypp" /* yacc.c:1646  */
    {
        }
#line 6228 "parser.cpp" /* yacc.c:1646  */
    break;

  case 17:
#line 1664 "parser.ypp" /* yacc.c:1646  */
    {
        }
#line 6235 "parser.cpp" /* yacc.c:1646  */
    break;

  case 18:
#line 1669 "parser.ypp" /* yacc.c:1646  */
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[-3].string), get_type_name((yyvsp[-1].node)));
           else
              qmd->set((yyvsp[-3].string), (yyvsp[-1].node));

           free((yyvsp[-3].string));
           (yyvsp[-1].node)->deref(0);
        }
#line 6250 "parser.cpp" /* yacc.c:1646  */
    break;

  case 19:
#line 1682 "parser.ypp" /* yacc.c:1646  */
    { (yyval.b) = false; }
#line 6256 "parser.cpp" /* yacc.c:1646  */
    break;

  case 20:
#line 1683 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.b) = true;
        }
#line 6264 "parser.cpp" /* yacc.c:1646  */
    break;

  case 21:
#line 1689 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-1].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), t, t ? 0 : (yyvsp[-1].parsertype)->getParseTypeInfo(), (yyvsp[-3].b), true);
           delete (yyvsp[-1].parsertype);
	}
#line 6274 "parser.cpp" /* yacc.c:1646  */
    break;

  case 22:
#line 1694 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 6282 "parser.cpp" /* yacc.c:1646  */
    break;

  case 23:
#line 1697 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-1].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), t, t ? 0 : (yyvsp[-1].parsertype)->getParseTypeInfo(), (yyvsp[-3].b), true);
           delete (yyvsp[-1].parsertype);
	}
#line 6292 "parser.cpp" /* yacc.c:1646  */
    break;

  case 24:
#line 1702 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
	}
#line 6300 "parser.cpp" /* yacc.c:1646  */
    break;

  case 25:
#line 1705 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-1].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), t, t ? 0 : (yyvsp[-1].parsertype)->getParseTypeInfo(), (yyvsp[-3].b), false);
           delete (yyvsp[-1].parsertype);
	}
#line 6310 "parser.cpp" /* yacc.c:1646  */
    break;

  case 26:
#line 1710 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-1].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[0].string), t, t ? 0 : (yyvsp[-1].parsertype)->getParseTypeInfo(), (yyvsp[-3].b), false);
           delete (yyvsp[-1].parsertype);
	}
#line 6320 "parser.cpp" /* yacc.c:1646  */
    break;

  case 27:
#line 1715 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.gv) = new GVarListDecl((yyvsp[-1].list), (yyvsp[-4].b));
        }
#line 6328 "parser.cpp" /* yacc.c:1646  */
    break;

  case 28:
#line 1721 "parser.ypp" /* yacc.c:1646  */
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[-4].i4), *p);
           (yyvsp[-1].nsnlist)->add(*p);
           delete (yyvsp[-1].nsnlist);
           (yyval.ns) = p->ns;
        }
#line 6340 "parser.cpp" /* yacc.c:1646  */
    break;

  case 29:
#line 1728 "parser.ypp" /* yacc.c:1646  */
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[-2].i4), *p);
           (yyval.ns) = p->ns;
        }
#line 6350 "parser.cpp" /* yacc.c:1646  */
    break;

  case 30:
#line 1733 "parser.ypp" /* yacc.c:1646  */
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[-3].i4), *p);
           (yyval.ns) = p->ns;
        }
#line 6360 "parser.cpp" /* yacc.c:1646  */
    break;

  case 31:
#line 1741 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 6370 "parser.cpp" /* yacc.c:1646  */
    break;

  case 32:
#line 1746 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsnlist) = (yyvsp[-1].nsnlist);
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
	}
#line 6380 "parser.cpp" /* yacc.c:1646  */
    break;

  case 33:
#line 1754 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 6388 "parser.cpp" /* yacc.c:1646  */
    break;

  case 34:
#line 1757 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.nsn) = new NSNode((yyvsp[0].constnode));
	}
#line 6396 "parser.cpp" /* yacc.c:1646  */
    break;

  case 35:
#line 1760 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.nsn) = new NSNode((yyvsp[0].classdef));
	   // see if class definitions are allowed
	   if (parse_check_parse_option(PO_NO_CLASS_DEFS))
	      parse_error("illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
	}
#line 6407 "parser.cpp" /* yacc.c:1646  */
    break;

  case 36:
#line 1766 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].parsefunc));
        }
#line 6415 "parser.cpp" /* yacc.c:1646  */
    break;

  case 37:
#line 1769 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].sparsefunc));
        }
#line 6423 "parser.cpp" /* yacc.c:1646  */
    break;

  case 38:
#line 1772 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[-1].gv));
        }
#line 6431 "parser.cpp" /* yacc.c:1646  */
    break;

  case 39:
#line 1775 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.nsn) = new NSNode((yyvsp[0].ns));
	   // see if ns declaration is legal
	   if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
	      parse_error("illegal namespace definition \"%s\" (conflicts with parse option NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
	}
#line 6442 "parser.cpp" /* yacc.c:1646  */
    break;

  case 40:
#line 1781 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.nsn) = new NSNode((yyvsp[0].methoddef));
        }
#line 6450 "parser.cpp" /* yacc.c:1646  */
    break;

  case 41:
#line 1786 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.constnode) = new ConstNode((yyvsp[-3].string), (yyvsp[-1].node));
	}
#line 6458 "parser.cpp" /* yacc.c:1646  */
    break;

  case 42:
#line 1789 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.constnode) = new ConstNode((yyvsp[-3].string), (yyvsp[-1].node), true);
	}
#line 6466 "parser.cpp" /* yacc.c:1646  */
    break;

  case 43:
#line 1795 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.constnode) = new ConstNode((yyvsp[-3].string), (yyvsp[-1].node));
	}
#line 6474 "parser.cpp" /* yacc.c:1646  */
    break;

  case 44:
#line 1798 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.constnode) = new ConstNode((yyvsp[-3].string), (yyvsp[-1].node), true);
	}
#line 6482 "parser.cpp" /* yacc.c:1646  */
    break;

  case 45:
#line 1805 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = (yyvsp[-1].sblock); }
#line 6488 "parser.cpp" /* yacc.c:1646  */
    break;

  case 46:
#line 1808 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[-1]).first_line, (yylsp[-1]).last_line); }
#line 6494 "parser.cpp" /* yacc.c:1646  */
    break;

  case 47:
#line 1813 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 6500 "parser.cpp" /* yacc.c:1646  */
    break;

  case 48:
#line 1816 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = (yyvsp[0].sblock); }
#line 6506 "parser.cpp" /* yacc.c:1646  */
    break;

  case 49:
#line 1821 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 6512 "parser.cpp" /* yacc.c:1646  */
    break;

  case 50:
#line 1823 "parser.ypp" /* yacc.c:1646  */
    { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock)); }
#line 6518 "parser.cpp" /* yacc.c:1646  */
    break;

  case 51:
#line 1825 "parser.ypp" /* yacc.c:1646  */
    { (yyvsp[-1].sblock)->addStatement((yyvsp[0].sblock)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 6524 "parser.cpp" /* yacc.c:1646  */
    break;

  case 52:
#line 1827 "parser.ypp" /* yacc.c:1646  */
    { (yyvsp[-1].sblock)->addStatement((yyvsp[0].statement)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 6530 "parser.cpp" /* yacc.c:1646  */
    break;

  case 53:
#line 1832 "parser.ypp" /* yacc.c:1646  */
    { (yyval.string) = 0; }
#line 6536 "parser.cpp" /* yacc.c:1646  */
    break;

  case 54:
#line 1833 "parser.ypp" /* yacc.c:1646  */
    { (yyval.string) = (yyvsp[0].string); }
#line 6542 "parser.cpp" /* yacc.c:1646  */
    break;

  case 55:
#line 1837 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 6548 "parser.cpp" /* yacc.c:1646  */
    break;

  case 56:
#line 1838 "parser.ypp" /* yacc.c:1646  */
    {
	   // if the expression has no effect and it's not a variable declaration
	   qore_type_t t = (yyvsp[-1].node) ? (yyvsp[-1].node)->getType() : 0;
	   bool ok = false;
	   if (t == NT_LIST) {
	      QoreListNode* l = reinterpret_cast<QoreListNode*>((yyvsp[-1].node));
	      // rewrite expression if it's a list without parentheses under certain conditions
	      (yyvsp[-1].node) = checkRewriteList(l);

	      if (l->isVariableList())
		 ok = true;
	   }

	   if (!ok && !node_has_effect((yyvsp[-1].node)) && (t != NT_VARREF || !reinterpret_cast<VarRefNode*>((yyvsp[-1].node))->parseIsDecl()))
	      parse_error("statement has no effect (%s)", (yyvsp[-1].node) ? (yyvsp[-1].node)->getTypeName() : "NOTHING");
           ignore_return_value((yyvsp[-1].node));
	   (yyval.statement) = new ExpressionStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].node));
	}
#line 6571 "parser.cpp" /* yacc.c:1646  */
    break;

  case 57:
#line 1857 "parser.ypp" /* yacc.c:1646  */
    {
	   NamedScope *ns = new NamedScope((yyvsp[-4].string));
	   assert(ns->size() > 1);
	   printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
	   (yyval.statement) = new ExpressionStatement((yylsp[-4]).first_line, (yylsp[-4]).last_line, new StaticMethodCallNode(ns, make_args((yyvsp[-2].node))));
	}
#line 6582 "parser.cpp" /* yacc.c:1646  */
    break;

  case 58:
#line 1864 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = (yyvsp[0].statement); }
#line 6588 "parser.cpp" /* yacc.c:1646  */
    break;

  case 59:
#line 1865 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new RethrowStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
	}
#line 6596 "parser.cpp" /* yacc.c:1646  */
    break;

  case 60:
#line 1868 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ThrowStatement((yylsp[-2]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].node));
	}
#line 6604 "parser.cpp" /* yacc.c:1646  */
    break;

  case 61:
#line 1871 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Unconditional);
	}
#line 6612 "parser.cpp" /* yacc.c:1646  */
    break;

  case 62:
#line 1874 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Success);
	}
#line 6620 "parser.cpp" /* yacc.c:1646  */
    break;

  case 63:
#line 1877 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Error);
	}
#line 6628 "parser.cpp" /* yacc.c:1646  */
    break;

  case 64:
#line 1880 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ContextStatement((yylsp[-2]).first_line, (yylsp[0]).last_line, 0, 0, (yyvsp[-1].cmods), (yyvsp[0].sblock));
	}
#line 6636 "parser.cpp" /* yacc.c:1646  */
    break;

  case 65:
#line 1883 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new SummarizeStatement((yylsp[-10]).first_line, (yylsp[0]).last_line, (yyvsp[-9].string), (yyvsp[-7].node), (yyvsp[-1].cmods), (yyvsp[0].sblock), (yyvsp[-3].node));
	}
#line 6644 "parser.cpp" /* yacc.c:1646  */
    break;

  case 66:
#line 1886 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ContextStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].string), (yyvsp[-3].node), (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 6652 "parser.cpp" /* yacc.c:1646  */
    break;

  case 67:
#line 1889 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new IfStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 6660 "parser.cpp" /* yacc.c:1646  */
    break;

  case 68:
#line 1892 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new IfStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-4].node), (yyvsp[-2].sblock), (yyvsp[0].sblock));
	}
#line 6668 "parser.cpp" /* yacc.c:1646  */
    break;

  case 69:
#line 1895 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new WhileStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 6676 "parser.cpp" /* yacc.c:1646  */
    break;

  case 70:
#line 1898 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new DoWhileStatement((yylsp[-6]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), (yyvsp[-5].sblock));
	}
#line 6684 "parser.cpp" /* yacc.c:1646  */
    break;

  case 71:
#line 1901 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ForStatement((yylsp[-8]).first_line, (yylsp[0]).last_line, (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 6692 "parser.cpp" /* yacc.c:1646  */
    break;

  case 72:
#line 1904 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.statement) = new ForEachStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].node), (yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 6700 "parser.cpp" /* yacc.c:1646  */
    break;

  case 73:
#line 1907 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = (yyvsp[-1].statement); }
#line 6706 "parser.cpp" /* yacc.c:1646  */
    break;

  case 74:
#line 1908 "parser.ypp" /* yacc.c:1646  */
    {
	   // see if thread exit is allowed
	   if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
	      parse_error("illegal use of \"thread_exit\" (conflicts with parse option NO_THREAD_CONTROL)");

	   (yyval.statement) = new ThreadExitStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
	}
#line 6718 "parser.cpp" /* yacc.c:1646  */
    break;

  case 75:
#line 1915 "parser.ypp" /* yacc.c:1646  */
    {
	  (yyval.statement) = new BreakStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
	}
#line 6726 "parser.cpp" /* yacc.c:1646  */
    break;

  case 76:
#line 1918 "parser.ypp" /* yacc.c:1646  */
    {
	  (yyval.statement) = new ContinueStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
	}
#line 6734 "parser.cpp" /* yacc.c:1646  */
    break;

  case 77:
#line 1921 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = (yyvsp[0].statement); }
#line 6740 "parser.cpp" /* yacc.c:1646  */
    break;

  case 78:
#line 1922 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = 0; }
#line 6746 "parser.cpp" /* yacc.c:1646  */
    break;

  case 79:
#line 1927 "parser.ypp" /* yacc.c:1646  */
    { (yyval.cmods) = 0; }
#line 6752 "parser.cpp" /* yacc.c:1646  */
    break;

  case 80:
#line 1928 "parser.ypp" /* yacc.c:1646  */
    {
	   if (!(yyvsp[-1].cmods))
	      (yyval.cmods) = new ContextModList((yyvsp[0].cmod));
	   else {
	      (yyvsp[-1].cmods)->addContextMod((yyvsp[0].cmod));
	      (yyval.cmods) = (yyvsp[-1].cmods);
	   }
	}
#line 6765 "parser.cpp" /* yacc.c:1646  */
    break;

  case 81:
#line 1940 "parser.ypp" /* yacc.c:1646  */
    { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[-1].node)); }
#line 6771 "parser.cpp" /* yacc.c:1646  */
    break;

  case 82:
#line 1942 "parser.ypp" /* yacc.c:1646  */
    { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[-1].node)); }
#line 6777 "parser.cpp" /* yacc.c:1646  */
    break;

  case 83:
#line 1944 "parser.ypp" /* yacc.c:1646  */
    { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[-1].node)); }
#line 6783 "parser.cpp" /* yacc.c:1646  */
    break;

  case 84:
#line 1948 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = new ReturnStatement((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 6789 "parser.cpp" /* yacc.c:1646  */
    break;

  case 85:
#line 1950 "parser.ypp" /* yacc.c:1646  */
    { (yyval.statement) = new ReturnStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].node)); }
#line 6795 "parser.cpp" /* yacc.c:1646  */
    break;

  case 86:
#line 1955 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-1].switchstmt)->setSwitch((yyvsp[-4].node));
	   (yyval.statement) = (yyvsp[-1].switchstmt);
	   (yyval.statement)->loc.start_line = (yylsp[-6]).first_line;
	   (yyval.statement)->loc.end_line = (yylsp[0]).last_line;
        }
#line 6806 "parser.cpp" /* yacc.c:1646  */
    break;

  case 87:
#line 1965 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.switchstmt) = new SwitchStatement((yyvsp[0].casenode));
	}
#line 6814 "parser.cpp" /* yacc.c:1646  */
    break;

  case 88:
#line 1969 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-1].switchstmt)->addCase((yyvsp[0].casenode));
	   (yyval.switchstmt) = (yyvsp[-1].switchstmt);
        }
#line 6823 "parser.cpp" /* yacc.c:1646  */
    break;

  case 89:
#line 1977 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(">=", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_GE);
        }
#line 6832 "parser.cpp" /* yacc.c:1646  */
    break;

  case 90:
#line 1982 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(">=", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_GE);
        }
#line 6841 "parser.cpp" /* yacc.c:1646  */
    break;

  case 91:
#line 1988 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("<=", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_LE);
        }
#line 6850 "parser.cpp" /* yacc.c:1646  */
    break;

  case 92:
#line 1993 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("<=", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_LE);
        }
#line 6859 "parser.cpp" /* yacc.c:1646  */
    break;

  case 93:
#line 1999 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("==", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_EQ);
        }
#line 6868 "parser.cpp" /* yacc.c:1646  */
    break;

  case 94:
#line 2004 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("==", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_EQ);
        }
#line 6877 "parser.cpp" /* yacc.c:1646  */
    break;

  case 95:
#line 2010 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("<", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_LT);
        }
#line 6886 "parser.cpp" /* yacc.c:1646  */
    break;

  case 96:
#line 2015 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case("<", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_LT);
        }
#line 6895 "parser.cpp" /* yacc.c:1646  */
    break;

  case 97:
#line 2021 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(">", (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-2].node), (yyvsp[0].sblock), OP_LOG_GT);
        }
#line 6904 "parser.cpp" /* yacc.c:1646  */
    break;

  case 98:
#line 2026 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(">", (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[-1].node), 0, OP_LOG_GT);
        }
#line 6913 "parser.cpp" /* yacc.c:1646  */
    break;

  case 99:
#line 2032 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[-2].Regex), (yyvsp[0].sblock));
	}
#line 6921 "parser.cpp" /* yacc.c:1646  */
    break;

  case 100:
#line 2036 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[-1].Regex), 0);
	}
#line 6929 "parser.cpp" /* yacc.c:1646  */
    break;

  case 101:
#line 2041 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeNegRegex((yyvsp[-2].Regex), (yyvsp[0].sblock));
	}
#line 6937 "parser.cpp" /* yacc.c:1646  */
    break;

  case 102:
#line 2045 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeNegRegex((yyvsp[-1].Regex), 0);
	}
#line 6945 "parser.cpp" /* yacc.c:1646  */
    break;

  case 103:
#line 2050 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[-2].Regex), (yyvsp[0].sblock));
	}
#line 6953 "parser.cpp" /* yacc.c:1646  */
    break;

  case 104:
#line 2054 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[-1].Regex), 0);
	}
#line 6961 "parser.cpp" /* yacc.c:1646  */
    break;

  case 105:
#line 2059 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(0, (yyvsp[-2].node));
	   (yyval.casenode) = new CaseNode((yyvsp[-2].node), (yyvsp[0].sblock));
	}
#line 6970 "parser.cpp" /* yacc.c:1646  */
    break;

  case 106:
#line 2064 "parser.ypp" /* yacc.c:1646  */
    {
	   check_case(0, (yyvsp[-1].node));
	   (yyval.casenode) = new CaseNode((yyvsp[-1].node), 0);
	}
#line 6979 "parser.cpp" /* yacc.c:1646  */
    break;

  case 107:
#line 2070 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNode(0, (yyvsp[0].sblock));
	}
#line 6987 "parser.cpp" /* yacc.c:1646  */
    break;

  case 108:
#line 2074 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.casenode) = new CaseNode(0, 0);
	}
#line 6995 "parser.cpp" /* yacc.c:1646  */
    break;

  case 109:
#line 2080 "parser.ypp" /* yacc.c:1646  */
    {
           char* param = 0;
           const QoreTypeInfo *typeInfo = 0;
           if ((yyvsp[-2].node)) {
              if ((yyvsp[-2].node)->getType() == NT_VARREF) {
                 VarRefNode *varRefNode = static_cast<VarRefNode*>((yyvsp[-2].node));
                 param = varRefNode->takeName();
                 if (varRefNode->isDecl()) {
                    VarRefDeclNode *varRefDeclNode = static_cast<VarRefDeclNode*>(varRefNode);
                    if (varRefDeclNode->getParseTypeInfo() || varRefDeclNode->getTypeInfo()->parseAccepts(hashTypeInfo) == QTI_NOT_EQUAL) {
                       parse_error("the type of catch parameter '%s' must be 'hash'", param);
                    }
                    typeInfo = varRefDeclNode->getTypeInfo();
                 }
              } else if ((yyvsp[-2].node)->getType() == NT_BAREWORD) {
                 param = reinterpret_cast<BarewordNode*>((yyvsp[-2].node))->takeString();
                 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error("local variable '%s' in catch parameter list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", param);
              } else
                 parse_error("only one parameter accepted in catch block for exception hash");
           (yyvsp[-2].node)->deref(0);
           }
           (yyval.statement) = new TryStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].sblock), (yyvsp[0].sblock), param, typeInfo);
        }
#line 7024 "parser.cpp" /* yacc.c:1646  */
    break;

  case 110:
#line 2106 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 7030 "parser.cpp" /* yacc.c:1646  */
    break;

  case 111:
#line 2107 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 7036 "parser.cpp" /* yacc.c:1646  */
    break;

  case 112:
#line 2108 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = 0; }
#line 7042 "parser.cpp" /* yacc.c:1646  */
    break;

  case 113:
#line 2112 "parser.ypp" /* yacc.c:1646  */
    {
           check_classmod((yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
           qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[-4].string), (yyvsp[-1].qoreclass));
	}
#line 7052 "parser.cpp" /* yacc.c:1646  */
    break;

  case 114:
#line 2117 "parser.ypp" /* yacc.c:1646  */
    {
           check_classmod((yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
	   (yyval.classdef) = new ObjClassDef((yyvsp[-4].nscope), (yyvsp[-1].qoreclass));
           qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
	}
#line 7062 "parser.cpp" /* yacc.c:1646  */
    break;

  case 115:
#line 2122 "parser.ypp" /* yacc.c:1646  */
    {
           // class name is set automatically from name saved in scanner
	   QoreClass* qc = new QoreClass;
           check_classmod((yyvsp[-3].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[-2].string), qc);
	}
#line 7074 "parser.cpp" /* yacc.c:1646  */
    break;

  case 116:
#line 2129 "parser.ypp" /* yacc.c:1646  */
    {
           // class name is set automatically from name saved in scanner
	   QoreClass* qc = new QoreClass;
           check_classmod((yyvsp[-3].i4), *qc);
	   (yyval.classdef) = new ObjClassDef((yyvsp[-2].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
	}
#line 7086 "parser.cpp" /* yacc.c:1646  */
    break;

  case 117:
#line 2136 "parser.ypp" /* yacc.c:1646  */
    {
           // class name is set automatically from name saved in scanner
	   QoreClass* qc = new QoreClass;
           check_classmod((yyvsp[-4].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[-3].string), qc);
	}
#line 7098 "parser.cpp" /* yacc.c:1646  */
    break;

  case 118:
#line 2143 "parser.ypp" /* yacc.c:1646  */
    {
           // class name is set automatically from name saved in scanner
	   QoreClass* qc = new QoreClass;
           check_classmod((yyvsp[-4].i4), *qc);
	   (yyval.classdef) = new ObjClassDef((yyvsp[-3].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
	}
#line 7110 "parser.cpp" /* yacc.c:1646  */
    break;

  case 119:
#line 2153 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclist) = (yyvsp[0].sclist);
        }
#line 7118 "parser.cpp" /* yacc.c:1646  */
    break;

  case 120:
#line 2156 "parser.ypp" /* yacc.c:1646  */
    { // NOTHING
           (yyval.sclist) = 0;
	}
#line 7126 "parser.cpp" /* yacc.c:1646  */
    break;

  case 121:
#line 2162 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclist) = new BCList((yyvsp[0].sclnode));
	}
#line 7134 "parser.cpp" /* yacc.c:1646  */
    break;

  case 122:
#line 2165 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-2].sclist)->push_back((yyvsp[0].sclnode));
	   (yyval.sclist) = (yyvsp[-2].sclist);
        }
#line 7143 "parser.cpp" /* yacc.c:1646  */
    break;

  case 123:
#line 2172 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode((yyvsp[0].string), false);
	}
#line 7151 "parser.cpp" /* yacc.c:1646  */
    break;

  case 124:
#line 2175 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[0].string)), false);
	}
#line 7159 "parser.cpp" /* yacc.c:1646  */
    break;

  case 125:
#line 2178 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode((yyvsp[0].string), false);
	}
#line 7167 "parser.cpp" /* yacc.c:1646  */
    break;

  case 126:
#line 2181 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[0].string)), false);
	}
#line 7175 "parser.cpp" /* yacc.c:1646  */
    break;

  case 127:
#line 2184 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode((yyvsp[0].string), true);
	}
#line 7183 "parser.cpp" /* yacc.c:1646  */
    break;

  case 128:
#line 2187 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[0].string)), true);
	}
#line 7191 "parser.cpp" /* yacc.c:1646  */
    break;

  case 129:
#line 2193 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.qoreclass) = new QoreClass;
	   (yyvsp[0].methodnode)->addAndDelete((yyval.qoreclass));
	}
#line 7200 "parser.cpp" /* yacc.c:1646  */
    break;

  case 130:
#line 2197 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyvsp[0].memberlist)->mergePrivate((yyval.qoreclass));
	   delete (yyvsp[0].memberlist);
	}
#line 7210 "parser.cpp" /* yacc.c:1646  */
    break;

  case 131:
#line 2202 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyvsp[0].memberlist)->mergePublic((yyval.qoreclass));
	   delete (yyvsp[0].memberlist);
	}
#line 7220 "parser.cpp" /* yacc.c:1646  */
    break;

  case 132:
#line 2207 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyval.qoreclass)->parseAddPublicConstant((yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue());
	   delete (yyvsp[0].constnode);
	}
#line 7230 "parser.cpp" /* yacc.c:1646  */
    break;

  case 133:
#line 2212 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[0].methodnode)->addAndDelete((yyvsp[-1].qoreclass));
	   (yyval.qoreclass) = (yyvsp[-1].qoreclass);
	}
#line 7239 "parser.cpp" /* yacc.c:1646  */
    break;

  case 134:
#line 2216 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[0].memberlist)->mergePrivate((yyvsp[-1].qoreclass));
	   (yyval.qoreclass) = (yyvsp[-1].qoreclass);
	   delete (yyvsp[0].memberlist);
	}
#line 7249 "parser.cpp" /* yacc.c:1646  */
    break;

  case 135:
#line 2221 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[0].memberlist)->mergePublic((yyvsp[-1].qoreclass));
	   (yyval.qoreclass) = (yyvsp[-1].qoreclass);
	   delete (yyvsp[0].memberlist);
	}
#line 7259 "parser.cpp" /* yacc.c:1646  */
    break;

  case 136:
#line 2226 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.qoreclass)->parseAddPublicConstant((yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue());
	   (yyval.qoreclass) = (yyvsp[-1].qoreclass);
	   delete (yyvsp[0].constnode);
	}
#line 7269 "parser.cpp" /* yacc.c:1646  */
    break;

  case 137:
#line 2234 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string));
	}
#line 7277 "parser.cpp" /* yacc.c:1646  */
    break;

  case 138:
#line 2237 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.parsertype) = new ParserScopedTypeStruct((yyvsp[0].string));
        }
#line 7285 "parser.cpp" /* yacc.c:1646  */
    break;

  case 139:
#line 2240 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.parsertype) = new ParserOrNothingTypeStruct((yyvsp[0].string));
        }
#line 7293 "parser.cpp" /* yacc.c:1646  */
    break;

  case 140:
#line 2243 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.parsertype) = new ParserScopedOrNothingTypeStruct((yyvsp[0].string));
        }
#line 7301 "parser.cpp" /* yacc.c:1646  */
    break;

  case 141:
#line 2250 "parser.ypp" /* yacc.c:1646  */
    { (yyval.parsertype) = 0; }
#line 7307 "parser.cpp" /* yacc.c:1646  */
    break;

  case 142:
#line 2251 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.parsertype) = (yyvsp[0].parsertype);
        }
#line 7315 "parser.cpp" /* yacc.c:1646  */
    break;

  case 143:
#line 2257 "parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 7321 "parser.cpp" /* yacc.c:1646  */
    break;

  case 144:
#line 2258 "parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 7327 "parser.cpp" /* yacc.c:1646  */
    break;

  case 145:
#line 2259 "parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = new EmptyPrivateMemberList; }
#line 7333 "parser.cpp" /* yacc.c:1646  */
    break;

  case 146:
#line 2263 "parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 7339 "parser.cpp" /* yacc.c:1646  */
    break;

  case 147:
#line 2264 "parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 7345 "parser.cpp" /* yacc.c:1646  */
    break;

  case 148:
#line 2265 "parser.ypp" /* yacc.c:1646  */
    { (yyval.memberlist) = new EmptyPublicMemberList; }
#line 7351 "parser.cpp" /* yacc.c:1646  */
    break;

  case 149:
#line 2269 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo((yylsp[-2]).first_line, (yylsp[-1]).last_line, (yyvsp[-2].parsertype)->getTypeInfo(), (yyvsp[-2].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[-2].parsertype);
	}
#line 7360 "parser.cpp" /* yacc.c:1646  */
    break;

  case 150:
#line 2273 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo((yylsp[-1]).first_line, (yylsp[-1]).last_line));
	}
#line 7368 "parser.cpp" /* yacc.c:1646  */
    break;

  case 151:
#line 2276 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo((yylsp[-4]).first_line, (yylsp[-1]).last_line, (yyvsp[-4].parsertype)->getTypeInfo(), (yyvsp[-4].parsertype)->getParseTypeInfo(), (yyvsp[-1].node)));
	   //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
	   delete (yyvsp[-4].parsertype);
        }
#line 7378 "parser.cpp" /* yacc.c:1646  */
    break;

  case 152:
#line 2281 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo((yylsp[-3]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].node)));
	}
#line 7386 "parser.cpp" /* yacc.c:1646  */
    break;

  case 153:
#line 2284 "parser.ypp" /* yacc.c:1646  */
    {
	   const QoreTypeInfo* t = (yyvsp[-5].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[-5].parsertype)->getClassName())), make_args((yyvsp[-2].node)));

	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-4].string), new QoreVarInfo((yylsp[-5]).first_line, (yylsp[-2]).last_line, (yyvsp[-5].parsertype)->getTypeInfo(), (yyvsp[-5].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[-5].parsertype);
	}
#line 7404 "parser.cpp" /* yacc.c:1646  */
    break;

  case 154:
#line 2299 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yyvsp[-2].parsertype) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-2].parsertype)->getTypeInfo(), (yyvsp[-2].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[-2].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
	}
#line 7416 "parser.cpp" /* yacc.c:1646  */
    break;

  case 155:
#line 2306 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yyvsp[-4].parsertype) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-4].parsertype)->getTypeInfo(), (yyvsp[-4].parsertype)->getParseTypeInfo(), (yyvsp[-1].node)));
	   delete (yyvsp[-4].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-3].string));
	}
#line 7428 "parser.cpp" /* yacc.c:1646  */
    break;

  case 156:
#line 2313 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line;
	   const QoreTypeInfo* t = (yyvsp[-5].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (!(yyvsp[-5].parsertype))
	      parse_error("cannot call constructor without declaring the class");
	   else if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[-5].parsertype)->getClassName())), make_args((yyvsp[-2].node)));

	   (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(fl, (yylsp[-2]).last_line, (yyvsp[-5].parsertype)->getTypeInfo(), (yyvsp[-5].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[-5].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-4].string));
	}
#line 7451 "parser.cpp" /* yacc.c:1646  */
    break;

  case 157:
#line 2331 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-2]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-2].parsertype)->getTypeInfo(), (yyvsp[-2].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[-2].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
	}
#line 7463 "parser.cpp" /* yacc.c:1646  */
    break;

  case 158:
#line 2338 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-4]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-4].parsertype)->getTypeInfo(), (yyvsp[-4].parsertype)->getParseTypeInfo(), (yyvsp[-1].node)));
	   delete (yyvsp[-4].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
	}
#line 7475 "parser.cpp" /* yacc.c:1646  */
    break;

  case 159:
#line 2345 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-5]).first_line;
	   const QoreTypeInfo* t = (yyvsp[-5].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (!(yyvsp[-5].parsertype))
	      parse_error("cannot call constructor without declaring the class");
	   else if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[-5].parsertype)->getClassName())), make_args((yyvsp[-2].node)));

	   (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(fl, (yylsp[-2]).last_line, (yyvsp[-5].parsertype)->getTypeInfo(), (yyvsp[-5].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[-5].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-4].string));
	}
#line 7498 "parser.cpp" /* yacc.c:1646  */
    break;

  case 160:
#line 2363 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-1]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line));
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
	}
#line 7509 "parser.cpp" /* yacc.c:1646  */
    break;

  case 161:
#line 2369 "parser.ypp" /* yacc.c:1646  */
    {
	   int fl = (yylsp[-3]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(fl, (yylsp[-1]).last_line, (yyvsp[-1].node)));
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
	}
#line 7520 "parser.cpp" /* yacc.c:1646  */
    break;

  case 162:
#line 2375 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberinfo) = (yyvsp[0].classvarinfo);
	}
#line 7528 "parser.cpp" /* yacc.c:1646  */
    break;

  case 163:
#line 2378 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[0].constnode)->pub)
              parse_error("cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[0].constnode)->name.ostr);
	   (yyval.memberinfo) = new MemberInfo((yyvsp[0].constnode)->name.takeName(), (yyvsp[0].constnode)->value);
	   delete (yyvsp[0].constnode);
        }
#line 7539 "parser.cpp" /* yacc.c:1646  */
    break;

  case 164:
#line 2387 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberinfo) = new MemberInfo((yyvsp[0].string), new QoreMemberInfo((yylsp[0]).first_line, (yylsp[0]).last_line));
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 7549 "parser.cpp" /* yacc.c:1646  */
    break;

  case 165:
#line 2392 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string)));
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
	}
#line 7559 "parser.cpp" /* yacc.c:1646  */
    break;

  case 166:
#line 2400 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 7567 "parser.cpp" /* yacc.c:1646  */
    break;

  case 167:
#line 2403 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-2].memberlist)->add((yyvsp[0].memberinfo));
	   (yyval.memberlist) = (yyvsp[-2].memberlist);
	}
#line 7576 "parser.cpp" /* yacc.c:1646  */
    break;

  case 168:
#line 2410 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 7584 "parser.cpp" /* yacc.c:1646  */
    break;

  case 169:
#line 2413 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-1].memberlist)->add((yyvsp[0].memberinfo));
	   (yyval.memberlist) = (yyvsp[-1].memberlist);
	}
#line 7593 "parser.cpp" /* yacc.c:1646  */
    break;

  case 170:
#line 2420 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.string) = (yyvsp[-1].string);
        }
#line 7601 "parser.cpp" /* yacc.c:1646  */
    break;

  case 171:
#line 2423 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.string) = strdup("keys");
        }
#line 7609 "parser.cpp" /* yacc.c:1646  */
    break;

  case 172:
#line 2426 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.string) = (yyvsp[0].string);
        }
#line 7617 "parser.cpp" /* yacc.c:1646  */
    break;

  case 173:
#line 2432 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   checkMethod((yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
	   (yyval.methodnode) = new MethodNode((yyvsp[-5].string), newMethodVariant((yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
	}
#line 7632 "parser.cpp" /* yacc.c:1646  */
    break;

  case 174:
#line 2442 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);

	   checkMethod((yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

	   (yyval.methodnode) = new MethodNode((yyvsp[-4].string), newMethodVariant((yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
	}
#line 7651 "parser.cpp" /* yacc.c:1646  */
    break;

  case 175:
#line 2456 "parser.ypp" /* yacc.c:1646  */
    {
           if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           checkMethod((yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
           (yyval.methodnode) = new MethodNode((yyvsp[-5].string), newMethodVariant((yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 7662 "parser.cpp" /* yacc.c:1646  */
    break;

  case 176:
#line 2462 "parser.ypp" /* yacc.c:1646  */
    {
           if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
           delete (yyvsp[-5].parsertype);

           checkMethod((yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

           (yyval.methodnode) = new MethodNode((yyvsp[-4].string), newMethodVariant((yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 7677 "parser.cpp" /* yacc.c:1646  */
    break;

  case 177:
#line 2475 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }

           (yyval.methoddef) = new MethodDef((yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
	}
#line 7692 "parser.cpp" /* yacc.c:1646  */
    break;

  case 178:
#line 2485 "parser.ypp" /* yacc.c:1646  */
    {
           if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
              if ((yyvsp[0].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
	   delete (yyvsp[-6].parsertype);

	   (yyval.methoddef) = new MethodDef((yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
	}
#line 7709 "parser.cpp" /* yacc.c:1646  */
    break;

  case 179:
#line 2497 "parser.ypp" /* yacc.c:1646  */
    {
           if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           (yyval.methoddef) = new MethodDef((yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0);
        }
#line 7719 "parser.cpp" /* yacc.c:1646  */
    break;

  case 180:
#line 2502 "parser.ypp" /* yacc.c:1646  */
    {
           if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
           delete (yyvsp[-6].parsertype);

           (yyval.methoddef) = new MethodDef((yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, 0);
        }
#line 7732 "parser.cpp" /* yacc.c:1646  */
    break;

  case 181:
#line 2510 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.methoddef) = new MethodDef(0, (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].node), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
	}
#line 7740 "parser.cpp" /* yacc.c:1646  */
    break;

  case 182:
#line 2513 "parser.ypp" /* yacc.c:1646  */
    {
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
	   delete (yyvsp[-6].parsertype);

	   (yyval.methoddef) = new MethodDef(0, (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
	}
#line 7751 "parser.cpp" /* yacc.c:1646  */
    break;

  case 183:
#line 2522 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.bcalist) = (yyvsp[0].bcalist);
	}
#line 7759 "parser.cpp" /* yacc.c:1646  */
    break;

  case 184:
#line 2525 "parser.ypp" /* yacc.c:1646  */
    { // nothing
	   (yyval.bcalist) = 0;
	}
#line 7767 "parser.cpp" /* yacc.c:1646  */
    break;

  case 185:
#line 2531 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.bcalist) = new BCAList((yyvsp[0].bcanode));
	}
#line 7775 "parser.cpp" /* yacc.c:1646  */
    break;

  case 186:
#line 2534 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-2].bcalist)->push_back((yyvsp[0].bcanode));
	   (yyval.bcalist) = (yyvsp[-2].bcalist);
	}
#line 7784 "parser.cpp" /* yacc.c:1646  */
    break;

  case 187:
#line 2541 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.bcanode) = new BCANode((yyvsp[-3].string), make_args((yyvsp[-1].node)));
	}
#line 7792 "parser.cpp" /* yacc.c:1646  */
    break;

  case 188:
#line 2544 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[-3].string)), make_args((yyvsp[-1].node)));
	}
#line 7800 "parser.cpp" /* yacc.c:1646  */
    break;

  case 189:
#line 2551 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = 0; }
#line 7806 "parser.cpp" /* yacc.c:1646  */
    break;

  case 190:
#line 2552 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.i4) = (yyvsp[0].i4);
        }
#line 7814 "parser.cpp" /* yacc.c:1646  */
    break;

  case 191:
#line 2557 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = (yyvsp[0].i4); }
#line 7820 "parser.cpp" /* yacc.c:1646  */
    break;

  case 192:
#line 2558 "parser.ypp" /* yacc.c:1646  */
    {
	   if (((yyvsp[-1].i4) | (yyvsp[0].i4)) == (yyvsp[-1].i4))
	      parse_error("modifier given twice");
	   (yyval.i4) = (yyvsp[-1].i4) | (yyvsp[0].i4);
	}
#line 7830 "parser.cpp" /* yacc.c:1646  */
    break;

  case 193:
#line 2566 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_PRIVATE; }
#line 7836 "parser.cpp" /* yacc.c:1646  */
    break;

  case 194:
#line 2567 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_STATIC; }
#line 7842 "parser.cpp" /* yacc.c:1646  */
    break;

  case 195:
#line 2568 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_SYNCED; }
#line 7848 "parser.cpp" /* yacc.c:1646  */
    break;

  case 196:
#line 2569 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_DEPRECATED; }
#line 7854 "parser.cpp" /* yacc.c:1646  */
    break;

  case 197:
#line 2570 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_PUBLIC; }
#line 7860 "parser.cpp" /* yacc.c:1646  */
    break;

  case 198:
#line 2571 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_FINAL; }
#line 7866 "parser.cpp" /* yacc.c:1646  */
    break;

  case 199:
#line 2572 "parser.ypp" /* yacc.c:1646  */
    { (yyval.i4) = OFM_ABSTRACT; }
#line 7872 "parser.cpp" /* yacc.c:1646  */
    break;

  case 200:
#line 2576 "parser.ypp" /* yacc.c:1646  */
    {
	   if (!(yyvsp[0].parsertype)) {
	      parse_error("missing type declaration after 'returns'");
	      (yyval.returnTypeInfo) = 0;
	   }
	   else {
	      (yyval.returnTypeInfo) = new RetTypeInfo((yyvsp[0].parsertype)->getParseTypeInfo(), (yyvsp[0].parsertype)->getTypeInfo());
	      delete (yyvsp[0].parsertype);
	   }
	}
#line 7887 "parser.cpp" /* yacc.c:1646  */
    break;

  case 201:
#line 2587 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.returnTypeInfo) = 0;
	}
#line 7895 "parser.cpp" /* yacc.c:1646  */
    break;

  case 202:
#line 2592 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.parsefunc) = new ParseUserFunction((yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), false, flags));
	}
#line 7905 "parser.cpp" /* yacc.c:1646  */
    break;

  case 203:
#line 2597 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, false, flags));
	}
#line 7919 "parser.cpp" /* yacc.c:1646  */
    break;

  case 204:
#line 2606 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-6].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-6].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) & OFM_SYNCED, flags));
           if ((yyvsp[-6].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
	}
#line 7935 "parser.cpp" /* yacc.c:1646  */
    break;

  case 205:
#line 2617 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-6].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-6].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, (yyvsp[-6].i4) & OFM_SYNCED, flags));
           if ((yyvsp[-6].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
	}
#line 7954 "parser.cpp" /* yacc.c:1646  */
    break;

  case 206:
#line 2633 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), false, flags));
	}
#line 7964 "parser.cpp" /* yacc.c:1646  */
    break;

  case 207:
#line 2638 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
	   delete (yyvsp[-6].parsertype);

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, false, flags));
	}
#line 7978 "parser.cpp" /* yacc.c:1646  */
    break;

  case 208:
#line 2647 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-7].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-7].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), (yyvsp[-7].i4) & OFM_SYNCED, flags));
           if ((yyvsp[-7].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
	}
#line 7994 "parser.cpp" /* yacc.c:1646  */
    break;

  case 209:
#line 2658 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-7].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-7].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-6].parsertype)->getParseTypeInfo(), (yyvsp[-6].parsertype)->getTypeInfo());
	   delete (yyvsp[-6].parsertype);

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, (yyvsp[-7].i4) & OFM_SYNCED, flags));
           if ((yyvsp[-7].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
	}
#line 8013 "parser.cpp" /* yacc.c:1646  */
    break;

  case 210:
#line 2676 "parser.ypp" /* yacc.c:1646  */
    { (yyval.list) = splice_expressions((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8019 "parser.cpp" /* yacc.c:1646  */
    break;

  case 211:
#line 2677 "parser.ypp" /* yacc.c:1646  */
    {
	   QoreListNode* l;
	   if ((yyvsp[-1].node) && (yyvsp[-1].node)->getType() == NT_LIST) {
	      l = reinterpret_cast<QoreListNode*>((yyvsp[-1].node));
              if (l->isFinalized()) {
                 QoreListNode* nl = new QoreListNode;
                 nl->push(l);
                 l = nl;
              }
           }
	   else {
	      l = new QoreListNode;
	      l->push((yyvsp[-1].node));
	      // parse_error("problem in parsing ',' in list: left side of comma is not a list (type: '%s')", $1 ? $1->getTypeName() : "NOTHING");
	      // so we don't insert null values in the parse tree
	   }
	   (yyval.list) = l;
        }
#line 8042 "parser.cpp" /* yacc.c:1646  */
    break;

  case 212:
#line 2699 "parser.ypp" /* yacc.c:1646  */
    { (yyval.list) = splice_expressions((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8048 "parser.cpp" /* yacc.c:1646  */
    break;

  case 213:
#line 2700 "parser.ypp" /* yacc.c:1646  */
    {
       QoreListNode* l;
       if ((yyvsp[-1].node) && (yyvsp[-1].node)->getType() == NT_LIST)
          l = reinterpret_cast<QoreListNode*>((yyvsp[-1].node));
       else {
          l = new QoreListNode;
          l->push((yyvsp[-1].node));
          // parse_error("problem in parsing ',' in list: left side of comma is not a list (type: '%s')", $1 ? $1->getTypeName() : "NOTHING");
          // so we don't insert null values in the parse tree
       }
       (yyval.list) = l;
        }
#line 8065 "parser.cpp" /* yacc.c:1646  */
    break;

  case 214:
#line 2715 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.hash) = new QoreParseHashNode;
           (yyvsp[0].hashelement)->addDelete((yyval.hash));
	}
#line 8074 "parser.cpp" /* yacc.c:1646  */
    break;

  case 215:
#line 2719 "parser.ypp" /* yacc.c:1646  */
    {
           (yyvsp[0].hashelement)->addDelete((yyvsp[-2].hash));
	   (yyval.hash) = (yyvsp[-2].hash);
	}
#line 8083 "parser.cpp" /* yacc.c:1646  */
    break;

  case 216:
#line 2724 "parser.ypp" /* yacc.c:1646  */
    { /* empty ',' on end of hash */ (yyval.hash) = (yyvsp[-1].hash); }
#line 8089 "parser.cpp" /* yacc.c:1646  */
    break;

  case 217:
#line 2729 "parser.ypp" /* yacc.c:1646  */
    { (yyval.hashelement) = new HashElement((yyvsp[-2].node), (yyvsp[0].node), (yylsp[-2]).first_line, (yylsp[0]).last_line); }
#line 8095 "parser.cpp" /* yacc.c:1646  */
    break;

  case 218:
#line 2733 "parser.ypp" /* yacc.c:1646  */
    {
           // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
           (yyvsp[-1].hash)->setCurly();
           (yyval.hash) = (yyvsp[-1].hash);
        }
#line 8105 "parser.cpp" /* yacc.c:1646  */
    break;

  case 219:
#line 2740 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].node); }
#line 8111 "parser.cpp" /* yacc.c:1646  */
    break;

  case 220:
#line 2742 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].binary); }
#line 8117 "parser.cpp" /* yacc.c:1646  */
    break;

  case 221:
#line 2744 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[-1].hash); }
#line 8123 "parser.cpp" /* yacc.c:1646  */
    break;

  case 222:
#line 2746 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ScopedRefNode((yyvsp[0].string)); }
#line 8129 "parser.cpp" /* yacc.c:1646  */
    break;

  case 223:
#line 2747 "parser.ypp" /* yacc.c:1646  */
    {
	   if (!(yyvsp[-1].parsertype) && !strcmp((yyvsp[0].string), "argv"))
	      inc_argv_ref();

	   if ((yyvsp[-1].parsertype))
	      (yyval.node) = new VarRefDeclNode((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), get_var_type(), (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	   else
	      (yyval.node) = new VarRefNode((yyvsp[0].string), get_var_type());

	   delete (yyvsp[-1].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
	}
#line 8147 "parser.cpp" /* yacc.c:1646  */
    break;

  case 224:
#line 2760 "parser.ypp" /* yacc.c:1646  */
    {
	   if (!(yyvsp[-1].parsertype) && !strcmp((yyvsp[0].string), "argv"))
	      inc_argv_ref();

	   if ((yyvsp[-1].parsertype))
	      (yyval.node) = new VarRefDeclNode((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), get_var_type(), (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	   else
	      (yyval.node) = new VarRefNode((yyvsp[0].string), get_var_type());

	   delete (yyvsp[-1].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
	}
#line 8165 "parser.cpp" /* yacc.c:1646  */
    break;

  case 225:
#line 2773 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new VarRefDeclNode((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), get_var_type(), (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	   delete (yyvsp[-1].parsertype);
	}
#line 8174 "parser.cpp" /* yacc.c:1646  */
    break;

  case 226:
#line 2777 "parser.ypp" /* yacc.c:1646  */
    {
	   VarRefDeclNode* v = new VarRefDeclNode((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), VT_LOCAL, (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	   v->setExplicitScope();
	   (yyval.node) = v;
	   delete (yyvsp[-1].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
	}
#line 8187 "parser.cpp" /* yacc.c:1646  */
    break;

  case 227:
#line 2785 "parser.ypp" /* yacc.c:1646  */
    {
	   // see if types are required
	   if (parse_check_parse_option(PO_REQUIRE_TYPES))
	      parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
	   VarRefNode* v = new VarRefNode((yyvsp[0].string), VT_LOCAL);
	   v->setExplicitScope();
	   (yyval.node) = v;
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
	}
#line 8202 "parser.cpp" /* yacc.c:1646  */
    break;

  case 228:
#line 2795 "parser.ypp" /* yacc.c:1646  */
    {
	   VarRefNode* v;
	   if ((yyvsp[-1].parsertype)) {
	      v = new VarRefDeclNode((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].string), VT_LOCAL, (yyvsp[-1].parsertype)->getTypeInfo(), (yyvsp[-1].parsertype)->getParseTypeInfo());
	      delete (yyvsp[-1].parsertype);
	   }
	   else {
	      // see if types are required
	      if (parse_check_parse_option(PO_REQUIRE_TYPES))
		 parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
	      v = new VarRefNode((yyvsp[0].string), VT_LOCAL);
	   }
	   v->setExplicitScope();
	   (yyval.node) = v;
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
	}
#line 8224 "parser.cpp" /* yacc.c:1646  */
    break;

  case 229:
#line 2812 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyvsp[-1].list)->setVariableList();
	   ListIterator li((yyvsp[-1].list));
	   while (li.next()) {
	      AbstractQoreNode* n = li.getValue();
	      qore_type_t t = get_node_type(n);
	      if (t == NT_BAREWORD) {
		 BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
		 if (parse_check_parse_option(PO_REQUIRE_TYPES))
		    parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
		 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
		    parse_error("local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
		 VarRefNode* v = new VarRefNode(b->takeString(), VT_LOCAL);
		 v->setExplicitScope();
		 b->deref();
		 AbstractQoreNode** p = li.getValuePtr();
		 *p = v;
	      }
	      else if (t == NT_VARREF) {
		 VarRefNode* v = reinterpret_cast<VarRefNode*>(n);
		 // see if types are required
		 if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
		    parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
		 if (v->explicitScope()) {
		    if (v->getType() == VT_LOCAL)
		       parse_error("illegal use of 'my %s' in local variable declaration list", v->getName());
		    else if (v->getType() == VT_GLOBAL)
		       parse_error("illegal use of 'our %s' in local variable declaration list", v->getName());
		 }
		 else
		    v->makeLocal();
		 v->setExplicitScope();
	      }
	      else
		 parse_error("element %d in list following 'my' is not a variable reference (%s)", li.index(), get_type_name(n));
	   }
	   (yyval.node) = (yyvsp[-1].list);
        }
#line 8267 "parser.cpp" /* yacc.c:1646  */
    break;

  case 230:
#line 2850 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = (yyvsp[0].gv)->makeVar();
        }
#line 8275 "parser.cpp" /* yacc.c:1646  */
    break;

  case 231:
#line 2854 "parser.ypp" /* yacc.c:1646  */
    {
	   if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[0].string), "argv"))
	      inc_argv_ref();

	   (yyval.node) = new BarewordNode((yyvsp[0].string), (yylsp[0]).first_line, (yylsp[0]).last_line);
	}
#line 8286 "parser.cpp" /* yacc.c:1646  */
    break;

  case 232:
#line 2861 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ContextrefNode((yyvsp[0].string)); }
#line 8292 "parser.cpp" /* yacc.c:1646  */
    break;

  case 233:
#line 2863 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ContextRowNode; }
#line 8298 "parser.cpp" /* yacc.c:1646  */
    break;

  case 234:
#line 2865 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new ComplexContextrefNode((yyvsp[0].string)); }
#line 8304 "parser.cpp" /* yacc.c:1646  */
    break;

  case 235:
#line 2867 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new FindNode((yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-1].node)); }
#line 8310 "parser.cpp" /* yacc.c:1646  */
    break;

  case 236:
#line 2869 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_EXISTS, 0); }
#line 8316 "parser.cpp" /* yacc.c:1646  */
    break;

  case 237:
#line 2871 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_ELEMENTS, 0); }
#line 8322 "parser.cpp" /* yacc.c:1646  */
    break;

  case 238:
#line 2873 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_KEYS, 0); }
#line 8328 "parser.cpp" /* yacc.c:1646  */
    break;

  case 239:
#line 2874 "parser.ypp" /* yacc.c:1646  */
    {  // unshift list, element
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[0].node)->getTypeName());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreTreeNode(lv, OP_UNSHIFT, l->shift());
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 8345 "parser.cpp" /* yacc.c:1646  */
    break;

  case 240:
#line 2886 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_SHIFT, 0);
	}
#line 8353 "parser.cpp" /* yacc.c:1646  */
    break;

  case 241:
#line 2889 "parser.ypp" /* yacc.c:1646  */
    {  // push lvalue-list, element
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[0].node)->getTypeName());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreTreeNode(lv, OP_PUSH, l->shift());
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 8370 "parser.cpp" /* yacc.c:1646  */
    break;

  case 242:
#line 2901 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_POP, 0);
	}
#line 8378 "parser.cpp" /* yacc.c:1646  */
    break;

  case 243:
#line 2904 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreChompOperatorNode((yyvsp[0].node));
	}
#line 8386 "parser.cpp" /* yacc.c:1646  */
    break;

  case 244:
#line 2907 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreTrimOperatorNode((yyvsp[0].node));
	}
#line 8394 "parser.cpp" /* yacc.c:1646  */
    break;

  case 245:
#line 2910 "parser.ypp" /* yacc.c:1646  */
    {  // splice lvalue-list, offset, [length, list]
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l) {
	      parse_error("invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else if (l->size() < 2) {
	      parse_error("too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else if (l->size() > 4) {
	      parse_error("too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreSpliceOperatorNode(lv, l->shift(), l->shift(), l->shift());
	      discard(l, 0);
	   }
	}
#line 8419 "parser.cpp" /* yacc.c:1646  */
    break;

  case 246:
#line 2930 "parser.ypp" /* yacc.c:1646  */
    {  // extract lvalue-list, offset, [length, list]
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l) {
	      parse_error("invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else if (l->size() < 2) {
	      parse_error("too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else if (l->size() > 4) {
	      parse_error("too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreExtractOperatorNode(lv, l->shift(), l->shift(), l->shift());
	      discard(l, 0);
	   }
	}
#line 8444 "parser.cpp" /* yacc.c:1646  */
    break;

  case 247:
#line 2950 "parser.ypp" /* yacc.c:1646  */
    {
	   pop_ignore_numeric_argv_ref();
           QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   int len = l ? (int)l->size() : 0;
           if (!l || len < 2 || len > 3) {
	      parse_error("invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
           }
           else {
              // get first expression from list
              AbstractQoreNode* exp = l->shift();
              qore_type_t t = get_node_type(exp);
              (yyval.node) = 0;
              if (t == NT_PARSE_HASH) {
                 QoreParseHashNode* phn = reinterpret_cast<QoreParseHashNode*>(exp);
                 if (phn->isCurly())
                    (yyval.node) = parse_hash_map(phn, l);
              }

              if (!(yyval.node))
                 (yyval.node) = parse_map(exp, l);
           }
        }
#line 8472 "parser.cpp" /* yacc.c:1646  */
    break;

  case 248:
#line 2973 "parser.ypp" /* yacc.c:1646  */
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* code_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(code_exp, OP_FOLDR, arg);
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 8491 "parser.cpp" /* yacc.c:1646  */
    break;

  case 249:
#line 2987 "parser.ypp" /* yacc.c:1646  */
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* code_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(code_exp, OP_FOLDL, arg);
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 8510 "parser.cpp" /* yacc.c:1646  */
    break;

  case 250:
#line 3001 "parser.ypp" /* yacc.c:1646  */
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[0].node) && (yyvsp[0].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[0].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", get_type_name((yyvsp[0].node)));
	      (yyval.node) = makeErrorTree((yyvsp[0].node), 0);
	   }
	   else {
	      AbstractQoreNode* arg = l->shift();
	      AbstractQoreNode* select_exp = l->shift();
	      (yyval.node) = new QoreTreeNode(arg, OP_SELECT, select_exp);
	      (yyvsp[0].node)->deref(0);
	   }
	}
#line 8529 "parser.cpp" /* yacc.c:1646  */
    break;

  case 251:
#line 3015 "parser.ypp" /* yacc.c:1646  */
    {  // pre-increment
           (yyval.node) = new QorePreIncrementOperatorNode((yyvsp[0].node));
        }
#line 8537 "parser.cpp" /* yacc.c:1646  */
    break;

  case 252:
#line 3018 "parser.ypp" /* yacc.c:1646  */
    {  // pre-decrement
           (yyval.node) = new QorePreDecrementOperatorNode((yyvsp[0].node));
        }
#line 8545 "parser.cpp" /* yacc.c:1646  */
    break;

  case 253:
#line 3021 "parser.ypp" /* yacc.c:1646  */
    {
	   printd(5, "parsing in-object base class method call %s()\n", (yyvsp[-3].nscope)->ostr);
	   if (!strcmp((yyvsp[-3].nscope)->getIdentifier(), "copy"))
	      parse_error("illegal call to base class copy method '%s'", (yyvsp[-3].nscope)->ostr);

	   (yyval.node) = new SelfFunctionCallNode((yyvsp[-3].nscope), make_args((yyvsp[-1].node)));
	}
#line 8557 "parser.cpp" /* yacc.c:1646  */
    break;

  case 254:
#line 3028 "parser.ypp" /* yacc.c:1646  */
    {
	   printd(5, "parsing call %s()\n", (yyvsp[-2].string));
	   (yyval.node) = new FunctionCallNode((yyvsp[-2].string), make_args((yyvsp[-1].node)));
        }
#line 8566 "parser.cpp" /* yacc.c:1646  */
    break;

  case 255:
#line 3033 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new SelfVarrefNode((yyvsp[0].string), (yylsp[0]).first_line, (yylsp[0]).last_line);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
	}
#line 8576 "parser.cpp" /* yacc.c:1646  */
    break;

  case 256:
#line 3038 "parser.ypp" /* yacc.c:1646  */
    {
	   // FIXME: need to expand constant expression checking to determine
	   //        if the expression can throw an exception at run-time
	   // first check for constant expressions
	   (yyval.node) = QoreUnaryMinusOperatorNode::makeNode((yyvsp[0].node));
	}
#line 8587 "parser.cpp" /* yacc.c:1646  */
    break;

  case 257:
#line 3045 "parser.ypp" /* yacc.c:1646  */
    {
            (yyval.node) = QoreUnaryMinusOperatorNode::makeNode(QoreUnaryMinusOperatorNode::makeNode((yyvsp[0].node)));
        }
#line 8595 "parser.cpp" /* yacc.c:1646  */
    break;

  case 258:
#line 3048 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_BIN_NOT, 0); }
#line 8601 "parser.cpp" /* yacc.c:1646  */
    break;

  case 259:
#line 3049 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalNotOperatorNode((yyvsp[0].node)); }
#line 8607 "parser.cpp" /* yacc.c:1646  */
    break;

  case 260:
#line 3050 "parser.ypp" /* yacc.c:1646  */
    {
	   qore_type_t t = (yyvsp[0].node) ? (yyvsp[0].node)->getType() : 0;
	   //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2->getTypeName());

	   if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
	      (yyval.node) = reinterpret_cast<FunctionCallNode*>((yyvsp[0].node))->makeReferenceNodeAndDeref();
	   }
	   else if (t == NT_SELF_CALL) {
	      (yyval.node) = reinterpret_cast<SelfFunctionCallNode*>((yyvsp[0].node))->makeReferenceNodeAndDeref();
	   }
	   else if (t == NT_STATIC_METHOD_CALL) {
	      (yyval.node) = reinterpret_cast<StaticMethodCallNode*>((yyvsp[0].node))->makeReferenceNodeAndDeref();
	   }
	   else {
	      bool make_ref = true;

	      if (t == NT_OPERATOR) {
                 QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[0].node));
                 if (deon) {
                    (yyval.node) = deon->makeCallReference();
                    make_ref = false;
                 }
	      }

	      if (make_ref) {
		 //printd(5, "type=%s\n", $2->getTypeName());
		 (yyval.node) = new ParseReferenceNode((yyvsp[0].node));
	      }
	   }
	}
#line 8642 "parser.cpp" /* yacc.c:1646  */
    break;

  case 261:
#line 3080 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new ScopedObjectCallNode(new NamedScope((yyvsp[-3].string)), make_args((yyvsp[-1].node)));
	   if (parse_check_parse_option(PO_NO_NEW))
	      parse_error("illegal use of the 'new' operator (conflicts with parse option NO_NEW)");
        }
#line 8652 "parser.cpp" /* yacc.c:1646  */
    break;

  case 262:
#line 3085 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new ScopedObjectCallNode(new NamedScope((yyvsp[-3].string)), make_args((yyvsp[-1].node)));
	   if (parse_check_parse_option(PO_NO_NEW))
	      parse_error("illegal use of the 'new' operator (conflicts with parse option NO_NEW)");
        }
#line 8662 "parser.cpp" /* yacc.c:1646  */
    break;

  case 263:
#line 3090 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[0].node), OP_BACKGROUND, 0);
	   // check to see if the expression is legal
	   if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
	      parse_error("illegal use of \"background\" operator (conflicts with parse option NO_THREAD_CONTROL)");
	   else if (!node_has_effect((yyvsp[0].node)))
	      parse_error("argument to background operator (%s) has no effect", get_type_name((yyvsp[0].node)));
	}
#line 8675 "parser.cpp" /* yacc.c:1646  */
    break;

  case 264:
#line 3098 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new BackquoteNode((yyvsp[0].string));
	   if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
	      parse_error("illegal use of backquote operator (conflicts with parse option NO_EXTERNAL_PROCESS)");
	}
#line 8685 "parser.cpp" /* yacc.c:1646  */
    break;

  case 265:
#line 3103 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = (yyvsp[-1].node);
	   if ((yyvsp[-1].node)) {
              switch ((yyvsp[-1].node)->getType()) {
                 case NT_LIST:
                    reinterpret_cast<QoreListNode*>((yyvsp[-1].node))->setFinalized();
                    break;
                 case NT_FUNCTION_CALL:
                    reinterpret_cast<FunctionCallNode*>((yyvsp[-1].node))->setFinalized();
                    break;
                 case NT_BAREWORD:
                    reinterpret_cast<BarewordNode*>((yyvsp[-1].node))->setFinalized();
                    break;
              }
           }
	}
#line 8706 "parser.cpp" /* yacc.c:1646  */
    break;

  case 266:
#line 3119 "parser.ypp" /* yacc.c:1646  */
    { QoreListNode* l = new QoreListNode; l->setFinalized(); (yyval.node) = l; }
#line 8712 "parser.cpp" /* yacc.c:1646  */
    break;

  case 267:
#line 3120 "parser.ypp" /* yacc.c:1646  */
    {
	   int ar = get_pop_argv_ref();
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
	}
#line 8721 "parser.cpp" /* yacc.c:1646  */
    break;

  case 268:
#line 3124 "parser.ypp" /* yacc.c:1646  */
    {
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);

	   int ar = get_pop_argv_ref();
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
	}
#line 8733 "parser.cpp" /* yacc.c:1646  */
    break;

  case 269:
#line 3131 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-6].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-6].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].node), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) | OFM_SYNCED, flags));
	}
#line 8746 "parser.cpp" /* yacc.c:1646  */
    break;

  case 270:
#line 3139 "parser.ypp" /* yacc.c:1646  */
    {
	   check_funcmod((yyvsp[-6].i4));

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[-5].parsertype)->getParseTypeInfo(), (yyvsp[-5].parsertype)->getTypeInfo());
	   delete (yyvsp[-5].parsertype);

	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[-6].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].node), rt, (yyvsp[-6].i4) | OFM_SYNCED, flags));
	}
#line 8763 "parser.cpp" /* yacc.c:1646  */
    break;

  case 271:
#line 3151 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = (yyvsp[0].implicit_arg);
	   inc_numeric_argv_ref();
	}
#line 8772 "parser.cpp" /* yacc.c:1646  */
    break;

  case 272:
#line 3155 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreImplicitElementNode;
	}
#line 8780 "parser.cpp" /* yacc.c:1646  */
    break;

  case 273:
#line 3158 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreDeleteOperatorNode((yyvsp[0].node));
	}
#line 8788 "parser.cpp" /* yacc.c:1646  */
    break;

  case 274:
#line 3161 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.node) = new QoreRemoveOperatorNode((yyvsp[0].node));
	}
#line 8796 "parser.cpp" /* yacc.c:1646  */
    break;

  case 275:
#line 3164 "parser.ypp" /* yacc.c:1646  */
    {
           (yyval.node) = new QoreCastOperatorNode((yyvsp[-3].string), (yyvsp[-1].node));
	}
#line 8804 "parser.cpp" /* yacc.c:1646  */
    break;

  case 277:
#line 3171 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].list); }
#line 8810 "parser.cpp" /* yacc.c:1646  */
    break;

  case 278:
#line 3172 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].hash); }
#line 8816 "parser.cpp" /* yacc.c:1646  */
    break;

  case 279:
#line 3173 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreParseHashNode(true); }
#line 8822 "parser.cpp" /* yacc.c:1646  */
    break;

  case 280:
#line 3174 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePlusEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8828 "parser.cpp" /* yacc.c:1646  */
    break;

  case 281:
#line 3175 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMinusEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8834 "parser.cpp" /* yacc.c:1646  */
    break;

  case 282:
#line 3176 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreAndEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8840 "parser.cpp" /* yacc.c:1646  */
    break;

  case 283:
#line 3177 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreOrEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8846 "parser.cpp" /* yacc.c:1646  */
    break;

  case 284:
#line 3178 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreModuloEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8852 "parser.cpp" /* yacc.c:1646  */
    break;

  case 285:
#line 3179 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMultiplyEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8858 "parser.cpp" /* yacc.c:1646  */
    break;

  case 286:
#line 3180 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreDivideEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8864 "parser.cpp" /* yacc.c:1646  */
    break;

  case 287:
#line 3181 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreXorEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8870 "parser.cpp" /* yacc.c:1646  */
    break;

  case 288:
#line 3182 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftLeftEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8876 "parser.cpp" /* yacc.c:1646  */
    break;

  case 289:
#line 3183 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftRightEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8882 "parser.cpp" /* yacc.c:1646  */
    break;

  case 290:
#line 3184 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = processAssignment((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8888 "parser.cpp" /* yacc.c:1646  */
    break;

  case 291:
#line 3185 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[0].string))); }
#line 8894 "parser.cpp" /* yacc.c:1646  */
    break;

  case 292:
#line 3186 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[0].string))); }
#line 8900 "parser.cpp" /* yacc.c:1646  */
    break;

  case 293:
#line 3187 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreNullCoalescingOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8906 "parser.cpp" /* yacc.c:1646  */
    break;

  case 294:
#line 3188 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreValueCoalescingOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 8912 "parser.cpp" /* yacc.c:1646  */
    break;

  case 295:
#line 3189 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreQuestionMarkOperatorNode((yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 8918 "parser.cpp" /* yacc.c:1646  */
    break;

  case 296:
#line 3190 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePostIncrementOperatorNode((yyvsp[-1].node)); }
#line 8924 "parser.cpp" /* yacc.c:1646  */
    break;

  case 297:
#line 3191 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePostDecrementOperatorNode((yyvsp[-1].node)); }
#line 8930 "parser.cpp" /* yacc.c:1646  */
    break;

  case 298:
#line 3192 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = processCall((yyvsp[-3].node), (yyvsp[-1].node)); }
#line 8936 "parser.cpp" /* yacc.c:1646  */
    break;

  case 299:
#line 3193 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_AND, (yyvsp[0].node)); }
#line 8942 "parser.cpp" /* yacc.c:1646  */
    break;

  case 300:
#line 3194 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_OR, (yyvsp[0].node)); }
#line 8948 "parser.cpp" /* yacc.c:1646  */
    break;

  case 301:
#line 3195 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_OR, (yyvsp[0].node)); }
#line 8954 "parser.cpp" /* yacc.c:1646  */
    break;

  case 302:
#line 3196 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_OR, (yyvsp[0].node)); }
#line 8960 "parser.cpp" /* yacc.c:1646  */
    break;

  case 303:
#line 3197 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_XOR, (yyvsp[0].node)); }
#line 8966 "parser.cpp" /* yacc.c:1646  */
    break;

  case 304:
#line 3198 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_OR, (yyvsp[0].node)); }
#line 8972 "parser.cpp" /* yacc.c:1646  */
    break;

  case 305:
#line 3199 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_AND, (yyvsp[0].node)); }
#line 8978 "parser.cpp" /* yacc.c:1646  */
    break;

  case 306:
#line 3200 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_XOR, (yyvsp[0].node)); }
#line 8984 "parser.cpp" /* yacc.c:1646  */
    break;

  case 307:
#line 3201 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_MATCH, (yyvsp[0].Regex)); }
#line 8990 "parser.cpp" /* yacc.c:1646  */
    break;

  case 308:
#line 3202 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_NMATCH, (yyvsp[0].Regex)); }
#line 8996 "parser.cpp" /* yacc.c:1646  */
    break;

  case 309:
#line 3203 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_SUBST, (yyvsp[0].RegexSubst)); }
#line 9002 "parser.cpp" /* yacc.c:1646  */
    break;

  case 310:
#line 3204 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_TRANS, (yyvsp[0].RegexTrans)); }
#line 9008 "parser.cpp" /* yacc.c:1646  */
    break;

  case 311:
#line 3205 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_EXTRACT, (yyvsp[0].Regex)); }
#line 9014 "parser.cpp" /* yacc.c:1646  */
    break;

  case 312:
#line 3206 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9020 "parser.cpp" /* yacc.c:1646  */
    break;

  case 313:
#line 3207 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9026 "parser.cpp" /* yacc.c:1646  */
    break;

  case 314:
#line 3208 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_CMP, (yyvsp[0].node)); }
#line 9032 "parser.cpp" /* yacc.c:1646  */
    break;

  case 315:
#line 3209 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9038 "parser.cpp" /* yacc.c:1646  */
    break;

  case 316:
#line 3210 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_ABSOLUTE_EQ, (yyvsp[0].node)); }
#line 9044 "parser.cpp" /* yacc.c:1646  */
    break;

  case 317:
#line 3211 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_ABSOLUTE_NE, (yyvsp[0].node)); }
#line 9050 "parser.cpp" /* yacc.c:1646  */
    break;

  case 318:
#line 3212 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9056 "parser.cpp" /* yacc.c:1646  */
    break;

  case 319:
#line 3213 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9062 "parser.cpp" /* yacc.c:1646  */
    break;

  case 320:
#line 3214 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9068 "parser.cpp" /* yacc.c:1646  */
    break;

  case 321:
#line 3215 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_SHIFT_LEFT, (yyvsp[0].node)); }
#line 9074 "parser.cpp" /* yacc.c:1646  */
    break;

  case 322:
#line 3216 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_SHIFT_RIGHT, (yyvsp[0].node)); }
#line 9080 "parser.cpp" /* yacc.c:1646  */
    break;

  case 323:
#line 3217 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_PLUS, (yyvsp[0].node)); }
#line 9086 "parser.cpp" /* yacc.c:1646  */
    break;

  case 324:
#line 3218 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_MINUS, (yyvsp[0].node)); }
#line 9092 "parser.cpp" /* yacc.c:1646  */
    break;

  case 325:
#line 3219 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreModuloOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9098 "parser.cpp" /* yacc.c:1646  */
    break;

  case 326:
#line 3220 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreDivisionOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9104 "parser.cpp" /* yacc.c:1646  */
    break;

  case 327:
#line 3221 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_MULT, (yyvsp[0].node)); }
#line 9110 "parser.cpp" /* yacc.c:1646  */
    break;

  case 328:
#line 3222 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreSquareBracketsOperatorNode((yyvsp[-3].node), (yyvsp[-1].node)); }
#line 9116 "parser.cpp" /* yacc.c:1646  */
    break;

  case 329:
#line 3223 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-3].node), OP_OBJECT_REF, (yyvsp[-1].node)); }
#line 9122 "parser.cpp" /* yacc.c:1646  */
    break;

  case 330:
#line 3224 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = process_dot((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9128 "parser.cpp" /* yacc.c:1646  */
    break;

  case 331:
#line 3225 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-1].node), OP_OBJECT_REF, (yyvsp[0].String)); }
#line 9134 "parser.cpp" /* yacc.c:1646  */
    break;

  case 333:
#line 3230 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].list); }
#line 9140 "parser.cpp" /* yacc.c:1646  */
    break;

  case 334:
#line 3231 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePlusEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9146 "parser.cpp" /* yacc.c:1646  */
    break;

  case 335:
#line 3232 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMinusEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9152 "parser.cpp" /* yacc.c:1646  */
    break;

  case 336:
#line 3233 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreAndEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9158 "parser.cpp" /* yacc.c:1646  */
    break;

  case 337:
#line 3234 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreOrEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9164 "parser.cpp" /* yacc.c:1646  */
    break;

  case 338:
#line 3235 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreModuloEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9170 "parser.cpp" /* yacc.c:1646  */
    break;

  case 339:
#line 3236 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreMultiplyEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9176 "parser.cpp" /* yacc.c:1646  */
    break;

  case 340:
#line 3237 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreDivideEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9182 "parser.cpp" /* yacc.c:1646  */
    break;

  case 341:
#line 3238 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreXorEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9188 "parser.cpp" /* yacc.c:1646  */
    break;

  case 342:
#line 3239 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftLeftEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9194 "parser.cpp" /* yacc.c:1646  */
    break;

  case 343:
#line 3240 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreShiftRightEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9200 "parser.cpp" /* yacc.c:1646  */
    break;

  case 344:
#line 3241 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = processAssignment((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9206 "parser.cpp" /* yacc.c:1646  */
    break;

  case 345:
#line 3242 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[0].string))); }
#line 9212 "parser.cpp" /* yacc.c:1646  */
    break;

  case 346:
#line 3243 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[0].string))); }
#line 9218 "parser.cpp" /* yacc.c:1646  */
    break;

  case 347:
#line 3244 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreNullCoalescingOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9224 "parser.cpp" /* yacc.c:1646  */
    break;

  case 348:
#line 3245 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreValueCoalescingOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9230 "parser.cpp" /* yacc.c:1646  */
    break;

  case 349:
#line 3246 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreQuestionMarkOperatorNode((yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].node)); }
#line 9236 "parser.cpp" /* yacc.c:1646  */
    break;

  case 350:
#line 3247 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePostIncrementOperatorNode((yyvsp[-1].node)); }
#line 9242 "parser.cpp" /* yacc.c:1646  */
    break;

  case 351:
#line 3248 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QorePostDecrementOperatorNode((yyvsp[-1].node)); }
#line 9248 "parser.cpp" /* yacc.c:1646  */
    break;

  case 352:
#line 3249 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = processCall((yyvsp[-3].node), (yyvsp[-1].node)); }
#line 9254 "parser.cpp" /* yacc.c:1646  */
    break;

  case 353:
#line 3250 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_AND, (yyvsp[0].node)); }
#line 9260 "parser.cpp" /* yacc.c:1646  */
    break;

  case 354:
#line 3251 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_OR, (yyvsp[0].node)); }
#line 9266 "parser.cpp" /* yacc.c:1646  */
    break;

  case 355:
#line 3252 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_OR, (yyvsp[0].node)); }
#line 9272 "parser.cpp" /* yacc.c:1646  */
    break;

  case 356:
#line 3253 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_OR, (yyvsp[0].node)); }
#line 9278 "parser.cpp" /* yacc.c:1646  */
    break;

  case 357:
#line 3254 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_XOR, (yyvsp[0].node)); }
#line 9284 "parser.cpp" /* yacc.c:1646  */
    break;

  case 358:
#line 3255 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_OR, (yyvsp[0].node)); }
#line 9290 "parser.cpp" /* yacc.c:1646  */
    break;

  case 359:
#line 3256 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_AND, (yyvsp[0].node)); }
#line 9296 "parser.cpp" /* yacc.c:1646  */
    break;

  case 360:
#line 3257 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_BIN_XOR, (yyvsp[0].node)); }
#line 9302 "parser.cpp" /* yacc.c:1646  */
    break;

  case 361:
#line 3258 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_MATCH, (yyvsp[0].Regex)); }
#line 9308 "parser.cpp" /* yacc.c:1646  */
    break;

  case 362:
#line 3259 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_NMATCH, (yyvsp[0].Regex)); }
#line 9314 "parser.cpp" /* yacc.c:1646  */
    break;

  case 363:
#line 3260 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_SUBST, (yyvsp[0].RegexSubst)); }
#line 9320 "parser.cpp" /* yacc.c:1646  */
    break;

  case 364:
#line 3261 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_TRANS, (yyvsp[0].RegexTrans)); }
#line 9326 "parser.cpp" /* yacc.c:1646  */
    break;

  case 365:
#line 3262 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_REGEX_EXTRACT, (yyvsp[0].Regex)); }
#line 9332 "parser.cpp" /* yacc.c:1646  */
    break;

  case 366:
#line 3263 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9338 "parser.cpp" /* yacc.c:1646  */
    break;

  case 367:
#line 3264 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9344 "parser.cpp" /* yacc.c:1646  */
    break;

  case 368:
#line 3265 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_LOG_CMP, (yyvsp[0].node)); }
#line 9350 "parser.cpp" /* yacc.c:1646  */
    break;

  case 369:
#line 3266 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9356 "parser.cpp" /* yacc.c:1646  */
    break;

  case 370:
#line 3267 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_ABSOLUTE_EQ, (yyvsp[0].node)); }
#line 9362 "parser.cpp" /* yacc.c:1646  */
    break;

  case 371:
#line 3268 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_ABSOLUTE_NE, (yyvsp[0].node)); }
#line 9368 "parser.cpp" /* yacc.c:1646  */
    break;

  case 372:
#line 3269 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9374 "parser.cpp" /* yacc.c:1646  */
    break;

  case 373:
#line 3270 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9380 "parser.cpp" /* yacc.c:1646  */
    break;

  case 374:
#line 3271 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9386 "parser.cpp" /* yacc.c:1646  */
    break;

  case 375:
#line 3272 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_SHIFT_LEFT, (yyvsp[0].node)); }
#line 9392 "parser.cpp" /* yacc.c:1646  */
    break;

  case 376:
#line 3273 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_SHIFT_RIGHT, (yyvsp[0].node)); }
#line 9398 "parser.cpp" /* yacc.c:1646  */
    break;

  case 377:
#line 3274 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_PLUS, (yyvsp[0].node)); }
#line 9404 "parser.cpp" /* yacc.c:1646  */
    break;

  case 378:
#line 3275 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_MINUS, (yyvsp[0].node)); }
#line 9410 "parser.cpp" /* yacc.c:1646  */
    break;

  case 379:
#line 3276 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreModuloOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9416 "parser.cpp" /* yacc.c:1646  */
    break;

  case 380:
#line 3277 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreDivisionOperatorNode((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9422 "parser.cpp" /* yacc.c:1646  */
    break;

  case 381:
#line 3278 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-2].node), OP_MULT, (yyvsp[0].node)); }
#line 9428 "parser.cpp" /* yacc.c:1646  */
    break;

  case 382:
#line 3279 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreSquareBracketsOperatorNode((yyvsp[-3].node), (yyvsp[-1].node)); }
#line 9434 "parser.cpp" /* yacc.c:1646  */
    break;

  case 383:
#line 3280 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-3].node), OP_OBJECT_REF, (yyvsp[-1].node)); }
#line 9440 "parser.cpp" /* yacc.c:1646  */
    break;

  case 384:
#line 3281 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = process_dot((yyvsp[-2].node), (yyvsp[0].node)); }
#line 9446 "parser.cpp" /* yacc.c:1646  */
    break;

  case 385:
#line 3282 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreTreeNode((yyvsp[-1].node), OP_OBJECT_REF, (yyvsp[0].String)); }
#line 9452 "parser.cpp" /* yacc.c:1646  */
    break;

  case 386:
#line 3286 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.String) = (yyvsp[0].String);
	}
#line 9460 "parser.cpp" /* yacc.c:1646  */
    break;

  case 387:
#line 3289 "parser.ypp" /* yacc.c:1646  */
    {
	   (yyval.String) = (yyvsp[-1].String);
	   (yyval.String)->concat((yyvsp[0].String));
	   (yyvsp[0].String)->deref();
	}
#line 9470 "parser.cpp" /* yacc.c:1646  */
    break;

  case 388:
#line 3296 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreFloatNode((yyvsp[0].decimal)); }
#line 9476 "parser.cpp" /* yacc.c:1646  */
    break;

  case 389:
#line 3297 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = new QoreBigIntNode((yyvsp[0].integer)); }
#line 9482 "parser.cpp" /* yacc.c:1646  */
    break;

  case 390:
#line 3298 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].String); }
#line 9488 "parser.cpp" /* yacc.c:1646  */
    break;

  case 391:
#line 3299 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].datetime); }
#line 9494 "parser.cpp" /* yacc.c:1646  */
    break;

  case 392:
#line 3300 "parser.ypp" /* yacc.c:1646  */
    { (yyval.node) = (yyvsp[0].num); }
#line 9500 "parser.cpp" /* yacc.c:1646  */
    break;


#line 9504 "parser.cpp" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (&yylloc, yyscanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[1] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 3303 "parser.ypp" /* yacc.c:1906  */

