/* A Bison parser, made by GNU Bison 2.7.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2012 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.7"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
/* Line 371 of yacc.c  */
#line 1 "parser.ypp"
 /* -*- mode: c++; indent-tabs-mode: nil -*-

   parser.ypp

   Qore Programming Language

   Copyright (C) 2003 - 2016 David Nichols

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.

  Note that the Qore library is released under a choice of three open-source
  licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
  information.
*/

#include <qore/Qore.h>
#include <qore/intern/BreakStatement.h>
#include <qore/intern/ContinueStatement.h>
#include <qore/intern/ReturnStatement.h>
#include <qore/intern/RethrowStatement.h>
#include <qore/intern/ThreadExitStatement.h>
#include <qore/intern/ExpressionStatement.h>
#include <qore/intern/DoWhileStatement.h>
#include <qore/intern/SummarizeStatement.h>
#include <qore/intern/ContextStatement.h>
#include <qore/intern/IfStatement.h>
#include <qore/intern/WhileStatement.h>
#include <qore/intern/ForStatement.h>
#include <qore/intern/ForEachStatement.h>
#include <qore/intern/TryStatement.h>
#include <qore/intern/ThrowStatement.h>
#include <qore/intern/StatementBlock.h>
#include <qore/intern/ParserSupport.h>
#include <qore/intern/SwitchStatement.h>
#include <qore/intern/CaseNodeWithOperator.h>
#include <qore/intern/CaseNodeRegex.h>
#include <qore/intern/OnBlockExitStatement.h>
#include <qore/intern/ConstantList.h>
#include <qore/intern/GlobalVariableList.h>
#include <qore/intern/QoreNamespaceIntern.h>
#include <qore/intern/QoreParseHashNode.h>

#include "parser.hpp"

#include <qore/intern/QoreClassIntern.h>
#include <qore/intern/qore_program_private.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <memory>
#include <utility>
#include <vector>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                                \
          do                                                           \
            if (N) {                                                   \
                (Current).first_line   = YYRHSLOC(Rhs, 1).first_line;  \
                (Current).last_line    = YYRHSLOC(Rhs, N).last_line;   \
            }                                                          \
            else {                                                     \
                (Current).first_line   = (Current).last_line   =       \
                  YYRHSLOC(Rhs, 0).last_line;                          \
            }                                                          \
          while (0)

class HashElement {
public:
   AbstractQoreNode* key;
   AbstractQoreNode* value;
   QoreProgramLocation loc;

   DLLLOCAL HashElement(AbstractQoreNode* k, AbstractQoreNode* v, int sl, int el) : key(k), value(v), loc(sl, el) {
      //traceout("HashElement::HashElement()");
   }

   DLLLOCAL ~HashElement() {
      discard(key, 0);
      discard(value, 0);
   }

   DLLLOCAL void addDelete(QoreParseHashNode* h) {
      h->add(key, value, loc);
      key = value = 0;
      delete this;
   }
};

static AbstractQoreNode* makeErrorTree(AbstractQoreNode* left, AbstractQoreNode* right) {
   discard(left, 0);
   discard(right, 0);
   return &False;
}

// for constant definitions
class ConstNode {
public:
   NamedScope name;
   AbstractQoreNode* value;
   bool pub;

   DLLLOCAL ConstNode(char* n, AbstractQoreNode* v, bool p = false) : name(n), value(v), pub(p) {
      // see if constant definitions are allowed
      if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
         parse_error("illegal constant definition \"%s\" (conflicts with parse option NO_CONSTANT_DEFS)", n);
   }
   DLLLOCAL AbstractQoreNode* takeValue() {
      AbstractQoreNode* rv = value;
      value = 0;
      return rv;
   }
   DLLLOCAL const std::string &getName() const {
      return name.getIdentifierStr();
   }
   DLLLOCAL bool isPublic() const {
      return pub;
   }
};

class ObjClassDef {
public:
   NamedScope *name;
   QoreClass* oc;

   DLLLOCAL inline ObjClassDef(NamedScope *n, QoreClass* o) : name(n), oc(o) {}
   DLLLOCAL inline ObjClassDef(char* n, QoreClass* o) : name(new NamedScope(n)), oc(o) {}
   DLLLOCAL inline ~ObjClassDef() { delete name; }
};

class ParseUserFunctionBase {
public:
   UserFunctionVariant* variant;

   DLLLOCAL ParseUserFunctionBase(UserFunctionVariant* v) : variant(v) {
   }

   DLLLOCAL ~ParseUserFunctionBase() {
      if (variant)
         variant->deref();
   }

   DLLLOCAL void setPublic() {
      variant->setModulePublic();
   }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
   char* name;

   DLLLOCAL ParseUserFunction(char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(n_variant), name(n_name) {
   }

   DLLLOCAL ~ParseUserFunction() {
      if (name)
         free(name);
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
         const char* nsn = ns.name.c_str();
         parse_error("function '%s%s%s()' cannot be defined (conflicts with parse option NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
      }

      delete this;
   }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
   NamedScope name;

   DLLLOCAL ParseScopedUserFunction(char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(n_variant), name(n_name) {
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      qore_root_ns_private::addPendingVariant(ns, name, variant);
      variant = 0;
      // make sure definition was legal
      if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
         parse_error("function '%s()' cannot be defined (conflicts with parse option NO_SUBROUTINE_DEFS)", name.ostr);

      delete this;
   }
};

struct GVarDecl {
   bool pub;

   DLLLOCAL GVarDecl(bool p) : pub(p) {
   }

   DLLLOCAL virtual ~GVarDecl() {
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

   DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
   char* name;
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL GVarSingleDecl(char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti, bool p, bool bare) : GVarDecl(p), name(n), typeInfo(ti), parseTypeInfo(pti) {
      if (bare) {
         if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error("global variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", n);
      }
      else {
         if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
            parse_error("reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", n);
      }
   }

   DLLLOCAL virtual ~GVarSingleDecl() {
      if (name)
         free(name);

      delete parseTypeInfo;
   }

   DLLLOCAL char* takeName() {
      char* rv = name;
      name = 0;
      return rv;
   }

   DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = 0;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ns.parseAddGlobalVarDecl(takeName(), typeInfo, takeParseTypeInfo(), pub);
      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      GlobalVarRefNode* gv = typeInfo
         ? new GlobalVarRefNode(takeName(), typeInfo)
         : new GlobalVarRefNode(takeName(), takeParseTypeInfo());
      if (pub)
         gv->setPublic();

      delete this;
      return gv;
   }
};

struct GVarListDecl : public GVarDecl {
   QoreListNode* l;

   DLLLOCAL GVarListDecl(QoreListNode* list, bool p) : GVarDecl(p), l(list) {
      bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            if (!bareok)
               parse_error("global variable '%s' in global variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (vrn->explicitScope()) {
               if (vrn->getType() == VT_LOCAL)
                  parse_error("illegal use of 'my %s' in global variable declaration list", vrn->getName());
               else if (vrn->getType() == VT_GLOBAL)
                  parse_error("illegal use of 'our %s' in global variable declaration list", vrn->getName());
            }
         }
         else
            parse_error("element %d in list following 'our' is not a variable reference (%s)", li.index(), get_type_name(n));
      }
   }

   DLLLOCAL virtual ~GVarListDecl() {
      if (l)
         l->deref(0);
   }

   DLLLOCAL QoreListNode* takeList() {
      QoreListNode* rv = l;
      l = 0;
      return rv;
   }

   DLLLOCAL virtual void add(qore_ns_private& ns) {
      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            ns.parseAddGlobalVarDecl(b->takeString(), 0, 0, pub);
         }
         else if (t == NT_VARREF) {
            VarRefNode* vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
               if (vrdn)
                  ns.parseAddGlobalVarDecl(vrn->takeName(), vrdn->getTypeInfo(), vrdn->takeParseTypeInfo(), pub);
               else
                  ns.parseAddGlobalVarDecl(vrn->takeName(), 0, 0, pub);
            }
         }
      }

      delete this;
   }

   DLLLOCAL virtual AbstractQoreNode* makeVar() {
      l->setVariableList();
      ListIterator li(l);
      while (li.next()) {
         AbstractQoreNode* n = li.getValue();
         qore_type_t t = get_node_type(n);
         VarRefNode* vrn = 0;
         if (t == NT_BAREWORD) {
            BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
            GlobalVarRefNode* v = new GlobalVarRefNode(b->takeString());
            b->deref();
            AbstractQoreNode** p = li.getValuePtr();
            *p = vrn = v;
         }
         else if (t == NT_VARREF) {
            vrn = reinterpret_cast<VarRefNode*>(n);
            if (!vrn->explicitScope()) {
               vrn->makeGlobal();
               vrn->setExplicitScope();
            }
         }

         if (vrn && pub)
            vrn->setPublic();
      }

      QoreListNode* rv = takeList();
      delete this;
      return rv;
   }
};

static int checkMethod(const char* name, BCAList* bcal, RetTypeInfo* returnTypeInfo) {
   bool con = !strcmp(name, "constructor");
   bool dst = !con && !strcmp(name, "destructor");

   // see if a return type is given for special methods
   if (returnTypeInfo && (con || dst)) {
      parse_error("%s methods may not declare a return type", name);
      return -1;
   }

   if (bcal && !con) {
      parse_error("base class constructor lists are only legal when defining constructor() methods");
      return -1;
   }

   return 0;
}

#define OFM_PRIVATE    (1 << 0)
#define OFM_SYNCED     (1 << 1)
#define OFM_STATIC     (1 << 2)
#define OFM_DEPRECATED (1 << 3)
#define OFM_PUBLIC     (1 << 4)
#define OFM_FINAL      (1 << 5)
#define OFM_ABSTRACT   (1 << 6)

static inline MethodVariantBase* newMethodVariant(const char* name, int mod, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) {
   //printd(5, "newMethodVariant() '%s' b: %p\n", name, b);
   int64 flags = QC_NO_FLAGS;

   if (get_pop_argv_ref())
      flags |= QC_USES_EXTRA_ARGS;

   if (mod & OFM_DEPRECATED)
      flags |= QC_DEPRECATED;

   if (!strcmp(name, "constructor")) {
      if (mod & OFM_SYNCED)
         parse_error("%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error("return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      return new UserConstructorVariant(mod & OFM_PRIVATE, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
   }
   if (bcal) {
      parse_error("only constructors may have base class constructor arguments");
      delete bcal;
      bcal = 0;
   }
   if (!strcmp(name, "destructor")) {
      if (params) {
	 parse_error("parameters cannot be defined for destructors");
	 params->deref(0);
      }
      if (mod & OFM_SYNCED)
         parse_error("%s() methods cannot be synchronized", name);
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract", name);
      if (returnTypeInfo) {
         parse_error("return type information cannot be defined for %s() methods", name);
         delete returnTypeInfo;
      }
      if (mod & OFM_PRIVATE)
	 parse_error("destructors cannot be private");
      return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
   }
   if (!strcmp(name, "copy")) {
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; declare the class final instead", name);
      return new UserCopyVariant(mod & OFM_PRIVATE, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
   }

   if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
      if (mod & OFM_FINAL)
         parse_error("%s() methods cannot be declared final; they are not inherited anyway", name);
      if (mod & OFM_ABSTRACT)
         parse_error("%s() methods cannot be declared abstract; they are not inherited anyway", name);
   }

   if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
      parse_error("method '%s()' is declared both final and abstract", name);

   return new UserMethodVariant(mod & OFM_PRIVATE, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
   MethodVariantBase* m;
   NamedScope name;
   bool static_flag;

   DLLLOCAL MethodDef(int mod, char* n, int n_sig_first_line, int n_sig_last_line, AbstractQoreNode* params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : m(0), name(n), static_flag(mod & OFM_STATIC) {
      if (checkMethod(name.getIdentifier(), bcal, returnTypeInfo)) {
         if (params)
            params->deref(0);
         delete bcal;
         delete b;
         delete returnTypeInfo;
         return;
      }

      m = newMethodVariant(name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b);
   }

   DLLLOCAL ~MethodDef() {
      delete m;
   }

   DLLLOCAL void parseAddToClassAndDel() {
      if (m) {
         // if there are any errors, the function below will delete memory
         // the following method takes ownership of "m" unconditionally
         qore_root_ns_private::parseAddMethodToClass(name, m, static_flag);
         m = 0;
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      // the following method takes ownership of "m" unconditionally
      ns.parseAddMethodToClass(name, m, static_flag);
      m = 0;
   }
};

static AbstractQoreNode* parse_hash_map(QoreParseHashNode* exp, QoreListNode* l) {
   assert(l && (l->size() == 1 || l->size() == 2));
   ReferenceHolder<> exph(exp, 0);
   ReferenceHolder<> lh(l, 0);

   // check hash expression
   size_t len = exp->size();

   if (len == 0) {
       qore_program_private::makeParseWarning(getProgram(), QP_WARN_INVALID_OPERATION, "INVALID-OPERATION",
            "empty hash as an argument to the hash map operator, this expression will always evaluate to an empty hash");
       return new QoreHashNode();
   }

   if (len != 1) {
      parse_error("invalid initial argument to hash map operator, expected a single key value pair; got %d hash elements instead", len);
      return &True;
   }

   if (l->size() == 1) {
      AbstractQoreNode* iter = l->shift();
      return new QoreHashMapOperatorNode(exp->takeFirstKeyNode(), exp->takeFirstValueNode(), iter);
   }

   AbstractQoreNode* iter = l->shift();
   AbstractQoreNode* select = l->shift();
   return new QoreHashMapSelectOperatorNode(exp->takeFirstKeyNode(), exp->takeFirstValueNode(), iter, select);
}

static AbstractQoreNode* parse_map(AbstractQoreNode* exp, QoreListNode* l) {
   assert(l && (l->size() == 1 || l->size() == 2));
   ReferenceHolder<> lh(l, 0);

   if (l->size() == 1) {
      AbstractQoreNode* arg = l->shift();
      return new QoreMapOperatorNode(exp, arg);
   }

   AbstractQoreNode* iterator_exp = l->shift();
   AbstractQoreNode* select_exp = l->shift();
   return new QoreMapSelectOperatorNode(exp, iterator_exp, select_exp);
}

#define NSN_NONE  0
#define NSN_OCD   1
#define NSN_CONST 2
#define NSN_NS    3
#define NSN_FUNC  4
#define NSN_SFUNC 5
#define NSN_VAR   6
#define NSN_METH  7

struct NSNode {
   int type;
   union {
      ObjClassDef* ocd;
      ConstNode* cn;
      QoreNamespace* ns;
      ParseUserFunction* func;
      ParseScopedUserFunction* sfunc;
      GVarDecl* gv;
      MethodDef* meth;
   } n;

   DLLLOCAL NSNode(ObjClassDef *o) { type = NSN_OCD; n.ocd = o; }
   DLLLOCAL NSNode(ConstNode  *c) { type = NSN_CONST; n.cn = c; }
   DLLLOCAL NSNode(QoreNamespace  *s) { type = NSN_NS; n.ns = s; }
   DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
      n.func = f;
   }
   DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
      n.sfunc = f;
   }

   DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
      n.gv = gv;
   }

   DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
      n.meth = m;
   }

   DLLLOCAL void deref() {
      switch (type) {
         case NSN_OCD:
            delete n.ocd;
            break;
         case NSN_CONST:
            delete n.cn;
            break;
         case NSN_NS:
            delete n.ns;
            break;
         case NSN_FUNC:
            delete n.func;
            break;
         case NSN_SFUNC:
            delete n.sfunc;
            break;
         case NSN_VAR:
            delete n.gv;
            break;
         case NSN_METH:
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      switch (type) {
         case NSN_OCD:
            ns.parseAddPendingClass(*(n.ocd->name), n.ocd->oc);
            delete n.ocd;
            break;
         case NSN_CONST:
            ns.parseAddConstant(n.cn->name, n.cn->value, n.cn->pub);
            delete n.cn;
            break;
         case NSN_NS:
            ns.parseAddNamespace(n.ns);
            break;
         case NSN_FUNC:
            n.func->add(ns);
            break;
         case NSN_SFUNC:
            n.sfunc->add(ns);
            break;
         case NSN_VAR:
            n.gv->add(ns);
            break;
         case NSN_METH:
            n.meth->add(ns);
            delete n.meth;
            break;
         default:
            assert(false);
            // no break
      }
      delete this;
   }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
   DLLLOCAL void deref() {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->deref();

      delete this;
   }

   DLLLOCAL void add(qore_ns_private& ns) {
      for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
         (*i)->add(ns);
   }
};

static QoreListNode* make_list(AbstractQoreNode* a1, AbstractQoreNode* a2) {
   QoreListNode* l = new QoreListNode;
   l->push(a1);
   l->push(a2);
   return l;
}

static QoreListNode* splice_expressions(AbstractQoreNode* a1, AbstractQoreNode* a2) {
   //tracein("splice_expressions()");
   if (a1 && a1->getType() == NT_LIST) {
      QoreListNode* l = reinterpret_cast<QoreListNode*>(a1);
      if (!l->isFinalized()) {
	 //printd(5, "LIST x\n");
	 l->push(a2);
	 return l;
      }
   }
   return make_list(a1, a2);
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2

struct MemberInfo {
protected:
   DLLLOCAL MemberInfo() {
   }

public:
   char* name;
   unsigned char type;
   union {
      QoreMemberInfo* memberInfo;
      QoreVarInfo* varInfo;
      AbstractQoreNode* exp;
   } u;

   DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : name(n), type(MI_Member)  {
      u.memberInfo = mi;
      if (!mi->parseHasTypeInfo() && parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("member '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL MemberInfo(char* n, AbstractQoreNode* exp) : name(n), type(MI_Constant) {
      u.exp = exp;
   }
   DLLLOCAL ~MemberInfo() {
      if (name)
	 free(name);
      switch (type) {
	 case MI_Member:
	    delete u.memberInfo;
	    break;
	 case MI_Var:
	    delete u.varInfo;
	    break;
	 case MI_Constant:
	    if (u.exp)
	       u.exp->deref(0);
	    break;
      }
   }
   DLLLOCAL member_pair_t getPair() {
      assert(type == MI_Member);
      member_pair_t m = std::make_pair(name, u.memberInfo);
      name = 0;
      u.memberInfo = 0;
      return m;
   }
   DLLLOCAL var_pair_t getVarPair() {
      assert(type == MI_Var);
      var_pair_t m = std::make_pair(name, u.varInfo);
      name = 0;
      u.varInfo = 0;
      return m;
   }
   DLLLOCAL AbstractQoreNode* takeExp() {
      assert(type == MI_Constant);
      AbstractQoreNode* rv = u.exp;
      u.exp = 0;
      return rv;
   }
};

struct ClassVarInfo : public MemberInfo {
   DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) {
      name = n;
      type = MI_Var;
      u.varInfo = vi;
      if (!vi->parseHasTypeInfo() && parse_check_parse_option(PO_REQUIRE_TYPES))
	 parse_error("class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
   }
   DLLLOCAL char* takeName() {
      char* n = name;
      name = 0;
      return n;
   }
};

class MemberList {
protected:
   // for new class members
   QoreMemberMap mmap;
   // for new class constants
   ConstantList cmap;
   // for new class static variables
   QoreVarMap vmap;

   DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
   }

public:
   DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
      if (!member)
	 return;

      if (member->type == MI_Member)
         mmap.addNoCheck(member->getPair());
      else if (member->type == MI_Constant)
	 cmap.parseAdd(member->name, member->takeExp());
      else
	 vmap.addNoCheck(member->getVarPair());

      delete member;
   }

   DLLLOCAL ~MemberList() {
   }

   // takes over ownership of name and typeInfo
   DLLLOCAL int add(MemberInfo* member) {
      if (!member)
	 return -1;

      //std::auto_ptr<MemberInfo> mem(member);

      if (member->type == MI_Member) {
         if (mmap.inList(member->name)) {
            parse_error("duplicate member declaration '%s'", member->name);
            delete member;
            return -1;
         }

         // add new member to list
         mmap.addNoCheck(member->getPair());
         delete member;
      }
      else if (member->type == MI_Constant) {
	 if (cmap.inList(member->name)) {
	    parse_error("duplicate constant declaration '%s'", member->name);
            delete member;
	    return -1;
	 }
	 if (vmap.find(member->name)) {
	    parse_error("constant declaration collides with static class variable declaration '%s'", member->name);
            delete member;
	    return -1;
	 }

	 // add new constant to list
	 cmap.parseAdd(member->name, member->takeExp());
         delete member;
      }
      else {
	 assert(member->type == MI_Var);
	 if (vmap.find(member->name)) {
	    parse_error("duplicate static class variable declaration '%s'", member->name);
            delete member;
	    return -1;
	 }
	 if (cmap.inList(member->name)) {
	    parse_error("static class variable declaration collides with constant declaration '%s'", member->name);
            delete member;
	    return -1;
	 }

	 // add new member to list
	 vmap.addNoCheck(member->getVarPair());
         delete member;
      }

      return 0;
   }

   DLLLOCAL void mergePrivate(QoreClass* qc) {
      mmap.moveAllToPrivate(qc);
      vmap.moveAllToPrivate(qc);

      // merge private constants
      qc->parseAssimilatePrivateConstants(cmap);
   }

   DLLLOCAL void mergePublic(QoreClass* qc) {
      mmap.moveAllToPublic(qc);
      vmap.moveAllToPublic(qc);

      // merge public constants
      qc->parseAssimilatePublicConstants(cmap);
   }
};

class EmptyPublicMemberList : public MemberList {
public:
   DLLLOCAL EmptyPublicMemberList() {
   }
};

class EmptyPrivateMemberList : public MemberList {
public:
   DLLLOCAL EmptyPrivateMemberList() {
   }
};

struct ParserTypeStruct {
protected:
   DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : typeInfo(0), parseTypeInfo(n_parseTypeInfo) {
   }

   DLLLOCAL ParserTypeStruct() {
   }

public:
   const QoreTypeInfo* typeInfo;
   QoreParseTypeInfo* parseTypeInfo;

   DLLLOCAL ParserTypeStruct(const QoreTypeInfo* n_typeInfo) : typeInfo(n_typeInfo), parseTypeInfo(0) {
   }

   DLLLOCAL ParserTypeStruct(char* id) {
      const QoreTypeInfo* t = getBuiltinUserTypeInfo(id);
      //printd(0, "ParserTypeStruct::ParserTypeStruct('%s') t: %p %s\n", id, t, t->getName());
      if (t) {
	 free(id);
	 typeInfo = t;
	 parseTypeInfo = 0;
	 return;
      }

      typeInfo = 0;
      parseTypeInfo = new QoreParseTypeInfo(id);
   }

   DLLLOCAL ~ParserTypeStruct() {
      delete parseTypeInfo;
   }

   DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
      if (!qore_check_this(this))
	 return 0;

      return typeInfo;
   }

   DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
      if (!qore_check_this(this))
	 return 0;

      QoreParseTypeInfo* rv = parseTypeInfo;
      parseTypeInfo = 0;
      return rv;
   }

   DLLLOCAL const char* getClassName() {
      assert(this);
      assert(parseTypeInfo);
      return parseTypeInfo->cscope->ostr;
   }
};

struct ParserScopedTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserScopedTypeStruct(char* sr) : ParserTypeStruct(new QoreParseTypeInfo(sr)) {
   }
};

struct ParserOrNothingTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserOrNothingTypeStruct(char* id) {
      const QoreTypeInfo* t = getBuiltinUserOrNothingTypeInfo(id);
      if (t) {
	 free(id);
	 typeInfo = t;
	 parseTypeInfo = 0;
	 return;
      }

      typeInfo = 0;
      parseTypeInfo = new QoreParseTypeInfo(id, true);
   }
};

struct ParserScopedOrNothingTypeStruct : public ParserTypeStruct {
   DLLLOCAL ParserScopedOrNothingTypeStruct(char* sr) : ParserTypeStruct(new QoreParseTypeInfo(sr, true)) {
   }
};

static AbstractQoreNode* process_dot(AbstractQoreNode* l, AbstractQoreNode* r) {
   qore_type_t rtype = r->getType();
   switch (rtype) {
      case NT_BAREWORD: {
         BarewordNode* b = reinterpret_cast<BarewordNode*>(r);
         if (!b->isFinalized()) {
            AbstractQoreNode* rv = new QoreTreeNode(l, OP_OBJECT_REF, b->makeQoreStringNode());
            b->deref();
            return rv;
         }
         break;
      }

      case NT_FUNCTION_CALL: {
         FunctionCallNode* f = reinterpret_cast<FunctionCallNode*>(r);
         assert(!f->getFunction());
         if (!f->isFinalized()) {
            MethodCallNode* m = new MethodCallNode(f->takeName(), f->takeArgs());
            f->deref();

            return new QoreDotEvalOperatorNode(l, m);
         }
         break;
      }
   }

   return new QoreTreeNode(l, OP_OBJECT_REF, r);
}

// returns true if the node needs run-time evaluation, false if not
static bool needsEval(AbstractQoreNode* n) {
   if (!n)
      return false;

   qore_type_t ntype = n->getType();

   // if it's a constant or a function reference
   if (ntype == NT_BAREWORD || ntype == NT_CONSTANT || ntype == NT_FUNCREF)
      return false;

   if (ntype == NT_LIST) {
      QoreListNode* l = reinterpret_cast<QoreListNode*>(n);
      if (l->needs_eval()) {
	 for (unsigned i = 0; i <l->size(); i++) {
	    if (needsEval(l->retrieve_entry(i)))
	       return true;
	 }
	 // here we set needs_eval to false so the list won't be evaluated again
	 l->clearNeedsEval();
      }
      return false;
   }

   if (ntype == NT_HASH) {
      QoreHashNode* h = reinterpret_cast<QoreHashNode*>(n);
      if (h->needs_eval()) {
	 HashIterator hi(h);
	 while (hi.next())
	    if (needsEval(hi.getValue()))
	       return true;
	 // here we set needs_eval to false so the hash won't be evaluated again
	 h->clearNeedsEval();
      }
      return false;
   }

   if (ntype == NT_TREE) {
      QoreTreeNode* tree = reinterpret_cast<QoreTreeNode*>(n);

      if (needsEval(tree->left) || (tree->right && needsEval(tree->right)))
	 return true;
      return tree->getOp()->hasEffect();
   }

   //printd(5, "needsEval() type %s = true\n", n->getTypeName());
   // we don't return needs_eval() here because some node types are not meant to be evaluated directly but are also not values
   return !n->is_value();
}

static int check_case(const char* op, AbstractQoreNode* exp) {
   // ignore if NULL (= NOTHING)
   if (exp && needsEval(exp)) {
      if (op)
	 parse_error("case expression with '%s' needs run-time evaluation", op);
      else
	 parse_error("case expression needs run-time evaluation", op);
      return -1;
   }
   return 0;
}

static void check_funcmod(int mod) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in function declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in function declaration");
   if (mod & OFM_FINAL)
      parse_error("illegal 'final' modifier in function declaration");
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in function declaration");
}

static void check_classmod(int mod, QoreClass& qc) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error("illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error("illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in class declaration");
}

static void check_nsmod(int mod, qore_ns_private& ns) {
   if (mod & OFM_PRIVATE)
      parse_error("illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error("illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error("illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error("illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error("illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error("illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
   if (!n || n->is_value())
      return false;

   if (n->getType() == NT_OPERATOR)
      return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

   const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
   return pn ? pn->has_effect() : true;
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }
   DLLLOCAL ~MethodNode() {
      free(name);
      delete m;
   }
   DLLLOCAL void addAndDelete(QoreClass* qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }
};

static AbstractQoreNode* is_rewritable_op(AbstractQoreNode* n) {
   qore_type_t nt = get_node_type(n);
   if (nt == NT_OPERATOR) {
      QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n);
      if (op)
         return op->getRight();
   }

   return 0;
}

static AbstractQoreNode* checkRewriteList(QoreListNode* l) {
   if (!parse_check_parse_option(PO_BROKEN_LIST_PARSING))
      return l;

   // rewrite expression if it's a list without parentheses and
   // the first expression has one of the following operators:
   // =, +=, -=
   if (l->isFinalized())
      return l;

   AbstractQoreNode* e0 = l->retrieve_entry(0);

   AbstractQoreNode* r = is_rewritable_op(e0);
   if (r) {
      AbstractQoreNode* last = e0;
      AbstractQoreNode* top = e0;
      while (true) {
         AbstractQoreNode* nr = is_rewritable_op(r);
         if (!nr)
            break;
         last = r;
         r = nr;
      }
      assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last));
      // take first element from list (the tree) and make it the new expression
      QoreBinaryLValueOperatorNode* op = reinterpret_cast<QoreBinaryLValueOperatorNode*>(last);
      l->swap(0, op->swapRight(l));
      return top;
   }

   return l;
}

void ignore_return_value(AbstractQoreNode* n) {
   qore_type_t t = get_node_type(n);
   if (t == NT_TREE)
      reinterpret_cast<QoreTreeNode*>(n)->ignoreReturnValue();
   else if (t == NT_OPERATOR)
      reinterpret_cast<QoreOperatorNode*>(n)->ignoreReturnValue();
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}

static AbstractQoreNode* processAssignment(AbstractQoreNode* $1, AbstractQoreNode* $3) {
   if ($1 && $1->getType() == NT_LIST) {
      return new QoreTreeNode($1, OP_LIST_ASSIGNMENT, $3);
   }
   else {
      return new QoreAssignmentOperatorNode($1, $3);
   }
   //print_tree($1, 0);
}

static AbstractQoreNode* processCall(AbstractQoreNode* $1, AbstractQoreNode* $3) {
    AbstractQoreNode* $$;
   //printd(5, "1=%s (%p), 3=%s (%p)\n", $1->getTypeName(), $1, $3 ? $3->getTypeName() : "n/a", $3);
   qore_type_t t = get_node_type($1);
   if (t == NT_BAREWORD) {
      BarewordNode* b = reinterpret_cast<BarewordNode*>($1);
      // take string from node and delete node
      char* str = b->takeString();
      b->deref();
      printd(5, "parsing call %s() args=%p %s\n", str, $3, $3 ? $3->getTypeName() : "n/a");
      $$ = new FunctionCallNode(str, make_args($3));
   }
   else if (t == NT_CONSTANT) {
      ScopedRefNode* c = reinterpret_cast<ScopedRefNode*>($1);
      // take NamedScope from node and delete node
      NamedScope *ns = c->takeName();
      c->deref();
      assert(ns->size() > 1);
      printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
      $$ = new StaticMethodCallNode(ns, make_args($3));
   }
   else if (t == NT_SELF_VARREF) {
      SelfVarrefNode* v = reinterpret_cast<SelfVarrefNode*>($1);
      // take string from node and delete node
      char* str = v->takeString();
      v->deref();
      printd(5, "parsing in-object method call %s()\n", str);
      $$ = new SelfFunctionCallNode(str, make_args($3));
   }
   else {
      QoreTreeNode* tree;

      if (t == NT_TREE) {
     tree = reinterpret_cast<QoreTreeNode*>($1);
     if (!(tree->getOp() == OP_OBJECT_REF && tree->right && tree->right->getType() == NT_STRING))
        tree = 0;
      }
      else
     tree = 0;

      if (tree) {
     // create an object method call node
     // take the string
     QoreStringNode* str = reinterpret_cast<QoreStringNode*>(tree->right);
     char* cstr = str->giveBuffer();
     str->deref();

     //printd(5, "method call to %s: tree=%s, args=%p %s\n", cstr, tree->left->getTypeName(), $3, $3 ? $3->getTypeName() : "n/a");

     MethodCallNode* mc = new MethodCallNode(cstr, make_args($3));

             // destroy the tree and create a new operator object
             assert(tree->is_unique());
             AbstractQoreNode* l = tree->left;
             tree->right = 0;
             tree->left = 0;
             tree->deref(0);

     $$ = new QoreDotEvalOperatorNode(l, mc);
      }
      else {
     $$ = 0;
     if ($1 && $1->getType() == NT_VARREF) {
        VarRefNode* r = reinterpret_cast<VarRefNode*>($1);
        qore_var_t vartype = r->getType();

        if (vartype != VT_UNRESOLVED) {
           $$ = r->makeNewCall($3);
           //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
           if (!$$)
          parseException("INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
        }
     }
     if (!$$) {
        $$ = new CallReferenceCallNode($1, make_args($3));
        printd(5, "made new CallReferenceCallNode: %p exp=%p %s\n", $$, $1, get_type_name($1));
     }
      }
   }
   return $$;
}


/* Line 371 of yacc.c  */
#line 1348 "parser.cpp"

# ifndef YY_NULL
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULL nullptr
#  else
#   define YY_NULL 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_HPP_INCLUDED
# define YY_YY_PARSER_HPP_INCLUDED
/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOK_RETURN = 258,
     TOK_RETURNS = 259,
     TOK_MY = 260,
     TOK_DO = 261,
     TOK_TRY = 262,
     TOK_THROW = 263,
     TOK_CATCH = 264,
     TOK_WHERE = 265,
     TOK_WHILE = 266,
     TOK_IF = 267,
     TOK_FOR = 268,
     TOK_SUB = 269,
     TOK_THREAD_EXIT = 270,
     TOK_BREAK = 271,
     TOK_CONTINUE = 272,
     TOK_CONTEXT_ROW = 273,
     TOK_FIND = 274,
     TOK_FOREACH = 275,
     TOK_IN = 276,
     TOK_DELETE = 277,
     TOK_REMOVE = 278,
     TOK_PRIVATE = 279,
     TOK_PUBLIC = 280,
     TOK_SYNCHRONIZED = 281,
     TOK_DEPRECATED = 282,
     TOK_CONTEXT = 283,
     TOK_SORT_BY = 284,
     TOK_SORT_DESCENDING_BY = 285,
     TOK_SUB_CONTEXT = 286,
     TOK_CONST = 287,
     TOK_SUMMARIZE = 288,
     TOK_BY = 289,
     TOK_OUR = 290,
     TOK_RETHROW = 291,
     TOK_SWITCH = 292,
     TOK_CASE = 293,
     TOK_DEFAULT = 294,
     TOK_INHERITS = 295,
     TOK_ELSE = 296,
     TOK_STATIC = 297,
     TOK_NAMESPACE = 298,
     TOK_MODULE = 299,
     TOK_FINAL = 300,
     TOK_ABSTRACT = 301,
     TOK_UNREFERENCE = 302,
     P_INCREMENT = 303,
     P_DECREMENT = 304,
     PLUS_EQUALS = 305,
     MINUS_EQUALS = 306,
     AND_EQUALS = 307,
     OR_EQUALS = 308,
     MODULA_EQUALS = 309,
     MULTIPLY_EQUALS = 310,
     DIVIDE_EQUALS = 311,
     XOR_EQUALS = 312,
     SHIFT_LEFT_EQUALS = 313,
     SHIFT_RIGHT_EQUALS = 314,
     TOK_UNSHIFT = 315,
     TOK_PUSH = 316,
     TOK_POP = 317,
     TOK_SHIFT = 318,
     TOK_CHOMP = 319,
     TOK_TRIM = 320,
     LOGICAL_AND = 321,
     LOGICAL_OR = 322,
     BROKEN_LOGICAL_OR = 323,
     BROKEN_BINARY_OR = 324,
     BROKEN_BINARY_XOR = 325,
     LOGICAL_EQ = 326,
     LOGICAL_NE = 327,
     LOGICAL_LE = 328,
     LOGICAL_GE = 329,
     LOGICAL_CMP = 330,
     ABSOLUTE_EQ = 331,
     ABSOLUTE_NE = 332,
     REGEX_MATCH = 333,
     REGEX_NMATCH = 334,
     TOK_EXISTS = 335,
     TOK_INSTANCEOF = 336,
     SHIFT_RIGHT = 337,
     SHIFT_LEFT = 338,
     TOK_ELEMENTS = 339,
     TOK_KEYS = 340,
     TOK_NEW = 341,
     TOK_BACKGROUND = 342,
     TOK_ON_EXIT = 343,
     TOK_ON_SUCCESS = 344,
     TOK_ON_ERROR = 345,
     TOK_MAP = 346,
     TOK_FOLDR = 347,
     TOK_FOLDL = 348,
     TOK_SELECT = 349,
     TOK_SPLICE = 350,
     TOK_EXTRACT = 351,
     IMPLICIT_ELEMENT = 352,
     NULL_COALESCING = 353,
     VALUE_COALESCING = 354,
     INTEGER = 355,
     QFLOAT = 356,
     NUMBER = 357,
     IDENTIFIER = 358,
     VAR_REF = 359,
     BACKQUOTE = 360,
     SELF_REF = 361,
     KW_IDENTIFIER_OPENPAREN = 362,
     SCOPED_REF = 363,
     SCOPED_VREF = 364,
     CONTEXT_REF = 365,
     COMPLEX_CONTEXT_REF = 366,
     QORE_CAST = 367,
     CLASS_STRING = 368,
     DATETIME = 369,
     QUOTED_WORD = 370,
     BINARY = 371,
     REGEX_SUBST = 372,
     REGEX_TRANS = 373,
     CLASS_SCOPED_REF = 374,
     BASE_CLASS_CALL = 375,
     REGEX = 376,
     REGEX_EXTRACT = 377,
     IMPLICIT_ARG_REF = 378,
     DOT_KW_IDENTIFIER = 379,
     TRY_MODULE_ERROR = 380,
     IFX = 381,
     NEG = 382,
     UPLUS = 383
   };
#endif
/* Tokens.  */
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_MY 260
#define TOK_DO 261
#define TOK_TRY 262
#define TOK_THROW 263
#define TOK_CATCH 264
#define TOK_WHERE 265
#define TOK_WHILE 266
#define TOK_IF 267
#define TOK_FOR 268
#define TOK_SUB 269
#define TOK_THREAD_EXIT 270
#define TOK_BREAK 271
#define TOK_CONTINUE 272
#define TOK_CONTEXT_ROW 273
#define TOK_FIND 274
#define TOK_FOREACH 275
#define TOK_IN 276
#define TOK_DELETE 277
#define TOK_REMOVE 278
#define TOK_PRIVATE 279
#define TOK_PUBLIC 280
#define TOK_SYNCHRONIZED 281
#define TOK_DEPRECATED 282
#define TOK_CONTEXT 283
#define TOK_SORT_BY 284
#define TOK_SORT_DESCENDING_BY 285
#define TOK_SUB_CONTEXT 286
#define TOK_CONST 287
#define TOK_SUMMARIZE 288
#define TOK_BY 289
#define TOK_OUR 290
#define TOK_RETHROW 291
#define TOK_SWITCH 292
#define TOK_CASE 293
#define TOK_DEFAULT 294
#define TOK_INHERITS 295
#define TOK_ELSE 296
#define TOK_STATIC 297
#define TOK_NAMESPACE 298
#define TOK_MODULE 299
#define TOK_FINAL 300
#define TOK_ABSTRACT 301
#define TOK_UNREFERENCE 302
#define P_INCREMENT 303
#define P_DECREMENT 304
#define PLUS_EQUALS 305
#define MINUS_EQUALS 306
#define AND_EQUALS 307
#define OR_EQUALS 308
#define MODULA_EQUALS 309
#define MULTIPLY_EQUALS 310
#define DIVIDE_EQUALS 311
#define XOR_EQUALS 312
#define SHIFT_LEFT_EQUALS 313
#define SHIFT_RIGHT_EQUALS 314
#define TOK_UNSHIFT 315
#define TOK_PUSH 316
#define TOK_POP 317
#define TOK_SHIFT 318
#define TOK_CHOMP 319
#define TOK_TRIM 320
#define LOGICAL_AND 321
#define LOGICAL_OR 322
#define BROKEN_LOGICAL_OR 323
#define BROKEN_BINARY_OR 324
#define BROKEN_BINARY_XOR 325
#define LOGICAL_EQ 326
#define LOGICAL_NE 327
#define LOGICAL_LE 328
#define LOGICAL_GE 329
#define LOGICAL_CMP 330
#define ABSOLUTE_EQ 331
#define ABSOLUTE_NE 332
#define REGEX_MATCH 333
#define REGEX_NMATCH 334
#define TOK_EXISTS 335
#define TOK_INSTANCEOF 336
#define SHIFT_RIGHT 337
#define SHIFT_LEFT 338
#define TOK_ELEMENTS 339
#define TOK_KEYS 340
#define TOK_NEW 341
#define TOK_BACKGROUND 342
#define TOK_ON_EXIT 343
#define TOK_ON_SUCCESS 344
#define TOK_ON_ERROR 345
#define TOK_MAP 346
#define TOK_FOLDR 347
#define TOK_FOLDL 348
#define TOK_SELECT 349
#define TOK_SPLICE 350
#define TOK_EXTRACT 351
#define IMPLICIT_ELEMENT 352
#define NULL_COALESCING 353
#define VALUE_COALESCING 354
#define INTEGER 355
#define QFLOAT 356
#define NUMBER 357
#define IDENTIFIER 358
#define VAR_REF 359
#define BACKQUOTE 360
#define SELF_REF 361
#define KW_IDENTIFIER_OPENPAREN 362
#define SCOPED_REF 363
#define SCOPED_VREF 364
#define CONTEXT_REF 365
#define COMPLEX_CONTEXT_REF 366
#define QORE_CAST 367
#define CLASS_STRING 368
#define DATETIME 369
#define QUOTED_WORD 370
#define BINARY 371
#define REGEX_SUBST 372
#define REGEX_TRANS 373
#define CLASS_SCOPED_REF 374
#define BASE_CLASS_CALL 375
#define REGEX 376
#define REGEX_EXTRACT 377
#define IMPLICIT_ARG_REF 378
#define DOT_KW_IDENTIFIER 379
#define TRY_MODULE_ERROR 380
#define IFX 381
#define NEG 382
#define UPLUS 383



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{
/* Line 387 of yacc.c  */
#line 1287 "parser.ypp"

   bool b;
   int i4;
   int64 integer;
   double decimal;
   QoreStringNode* String;
   char* string;
   BinaryNode* binary;
   AbstractQoreNode* node;
   QoreParseHashNode* hash;
   QoreListNode* list;
   AbstractStatement* statement;
   struct MemberInfo* memberinfo;
   struct ClassVarInfo* classvarinfo;
   StatementBlock *sblock;
   ContextModList* cmods;
   ContextMod *cmod;
   class HashElement* hashelement;
   QoreFunction* userfunc;
   struct MethodNode* methodnode;
   class MemberList* memberlist;
   QoreClass* qoreclass;
   class ConstNode* constnode;
   QoreNamespace *ns;
   struct NSNodeList* nsnlist;
   struct NSNode* nsn;
   class ObjClassDef *classdef;
   DateTimeNode* datetime;
   RegexSubstNode* RegexSubst;
   RegexTransNode* RegexTrans;
   SwitchStatement* switchstmt;
   CaseNode* casenode;
   BCList* sclist;
   class BCNode* sclnode;
   BCAList* bcalist;
   BCANode* bcanode;
   NamedScope *nscope;
   QoreRegexNode* Regex;
   QoreImplicitArgumentNode* implicit_arg;
   RetTypeInfo* returnTypeInfo;
   struct ParserTypeStruct* parsertype;
   class ParseUserFunction* parsefunc;
   class ParseScopedUserFunction* sparsefunc;
   struct GVarDecl* gv;
   QoreNumberNode* num;
   TryModuleError* trymod;
   struct MethodDef* methoddef;


/* Line 387 of yacc.c  */
#line 1697 "parser.cpp"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (yyscan_t yyscanner);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */

#endif /* !YY_YY_PARSER_HPP_INCLUDED  */

/* Copy the second part of user declarations.  */
/* Line 390 of yacc.c  */
#line 1336 "parser.ypp"


#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE *loc, yyscan_t scanner, const char* str) {
   //printd(5, "yyerror() location: %d-%d: \"%s\"\n", loc->first_line, loc->last_line, str);
   parse_error("%s", str);
}


/* Line 390 of yacc.c  */
#line 1750 "parser.cpp"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(N) (N)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  201
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   11401

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  154
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  61
/* YYNRULES -- Number of rules.  */
#define YYNRULES  392
/* YYNRULES -- Number of states.  */
#define YYNSTATES  853

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   383

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   145,     2,     2,     2,   138,   133,     2,
     149,   152,   139,   136,   127,   137,   148,   140,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   130,   151,
     134,   128,   135,   129,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   147,   144,   153,   132,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   146,   131,   150,   143,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   141,   142
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    25,    29,    31,    36,    38,    40,    43,    48,
      49,    51,    56,    60,    65,    69,    74,    79,    85,    91,
      95,   100,   102,   105,   107,   109,   111,   113,   115,   118,
     120,   122,   128,   135,   141,   148,   152,   155,   157,   159,
     161,   163,   166,   169,   170,   172,   174,   177,   183,   185,
     188,   192,   195,   198,   201,   205,   217,   225,   231,   239,
     245,   253,   263,   271,   274,   277,   280,   283,   285,   288,
     289,   292,   297,   302,   307,   309,   312,   320,   322,   325,
     331,   336,   342,   347,   353,   358,   364,   369,   375,   380,
     386,   391,   397,   402,   407,   411,   416,   420,   424,   427,
     435,   436,   438,   440,   447,   454,   459,   464,   470,   476,
     479,   480,   482,   486,   488,   490,   493,   496,   499,   502,
     504,   506,   508,   510,   513,   516,   519,   522,   524,   526,
     529,   532,   533,   535,   539,   544,   548,   552,   557,   561,
     566,   570,   577,   583,   591,   595,   601,   608,   612,   618,
     625,   628,   633,   635,   637,   639,   642,   644,   648,   650,
     653,   656,   659,   661,   669,   677,   685,   693,   702,   711,
     720,   729,   737,   745,   748,   749,   751,   755,   760,   765,
     766,   768,   770,   773,   775,   777,   779,   781,   783,   785,
     787,   790,   791,   798,   805,   813,   821,   829,   837,   846,
     855,   859,   862,   866,   869,   871,   875,   878,   882,   886,
     888,   890,   894,   896,   899,   902,   905,   909,   912,   916,
     921,   923,   925,   927,   929,   931,   940,   943,   946,   949,
     952,   955,   958,   961,   964,   967,   970,   973,   976,   979,
     982,   985,   988,   991,   996,  1000,  1002,  1005,  1008,  1011,
    1014,  1017,  1023,  1029,  1032,  1034,  1038,  1041,  1048,  1055,
    1063,  1071,  1073,  1075,  1078,  1081,  1086,  1088,  1090,  1092,
    1095,  1099,  1103,  1107,  1111,  1115,  1119,  1123,  1127,  1131,
    1135,  1139,  1143,  1147,  1151,  1155,  1161,  1164,  1167,  1172,
    1176,  1180,  1184,  1188,  1192,  1196,  1200,  1204,  1208,  1212,
    1216,  1220,  1224,  1228,  1232,  1236,  1240,  1244,  1248,  1252,
    1256,  1260,  1264,  1268,  1272,  1276,  1280,  1284,  1288,  1293,
    1298,  1302,  1305,  1307,  1309,  1313,  1317,  1321,  1325,  1329,
    1333,  1337,  1341,  1345,  1349,  1353,  1357,  1361,  1365,  1369,
    1375,  1378,  1381,  1386,  1390,  1394,  1398,  1402,  1406,  1410,
    1414,  1418,  1422,  1426,  1430,  1434,  1438,  1442,  1446,  1450,
    1454,  1458,  1462,  1466,  1470,  1474,  1478,  1482,  1486,  1490,
    1494,  1498,  1502,  1507,  1512,  1516,  1519,  1521,  1524,  1526,
    1528,  1530,  1532
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     155,     0,    -1,   156,    -1,   155,   156,    -1,   203,    -1,
     204,    -1,   179,    -1,   165,    -1,   164,    -1,   195,    -1,
     170,    -1,   146,   150,    -1,   146,   168,   150,    -1,   161,
      -1,    44,   146,   157,   150,    -1,   125,    -1,   158,    -1,
     157,   158,    -1,   103,   128,   211,   151,    -1,    -1,    25,
      -1,   159,    35,   184,   108,    -1,   159,    35,   108,    -1,
     159,    35,   184,   103,    -1,   159,    35,   103,    -1,   159,
      35,   185,   109,    -1,   159,    35,   185,   104,    -1,   159,
      35,   149,   205,   152,    -1,   199,    43,   146,   162,   150,
      -1,   199,    43,   151,    -1,   199,    43,   146,   150,    -1,
     163,    -1,   162,   163,    -1,   165,    -1,   164,    -1,   179,
      -1,   203,    -1,   204,    -1,   160,   151,    -1,   161,    -1,
     195,    -1,    32,   103,   128,   211,   151,    -1,    25,    32,
     103,   128,   211,   151,    -1,    32,   108,   128,   211,   151,
      -1,    25,    32,   108,   128,   211,   151,    -1,   146,   168,
     150,    -1,   146,   150,    -1,   170,    -1,   166,    -1,   170,
      -1,   166,    -1,   168,   166,    -1,   168,   170,    -1,    -1,
     103,    -1,   151,    -1,   212,   151,    -1,   108,   149,   178,
     152,   151,    -1,   177,    -1,    36,   151,    -1,     8,   211,
     151,    -1,    88,   167,    -1,    89,   167,    -1,    90,   167,
      -1,    31,   171,   167,    -1,    33,   169,   149,   211,   152,
      34,   149,   211,   152,   171,   167,    -1,    28,   169,   149,
     211,   152,   171,   167,    -1,    12,   149,   211,   152,   167,
      -1,    12,   149,   211,   152,   167,    41,   167,    -1,    11,
     149,   211,   152,   167,    -1,     6,   167,    11,   149,   211,
     152,   151,    -1,    13,   149,   178,   151,   178,   151,   178,
     152,   167,    -1,    20,   211,    21,   149,   211,   152,   167,
      -1,   173,   151,    -1,    15,   151,    -1,    16,   151,    -1,
      17,   151,    -1,   174,    -1,     1,   151,    -1,    -1,   171,
     172,    -1,    10,   149,   211,   152,    -1,    29,   149,   211,
     152,    -1,    30,   149,   211,   152,    -1,     3,    -1,     3,
     211,    -1,    37,   149,   211,   152,   146,   175,   150,    -1,
     176,    -1,   175,   176,    -1,    38,    74,   211,   130,   168,
      -1,    38,    74,   211,   130,    -1,    38,    73,   211,   130,
     168,    -1,    38,    73,   211,   130,    -1,    38,    71,   211,
     130,   168,    -1,    38,    71,   211,   130,    -1,    38,   134,
     211,   130,   168,    -1,    38,   134,   211,   130,    -1,    38,
     135,   211,   130,   168,    -1,    38,   135,   211,   130,    -1,
      38,    78,   121,   130,   168,    -1,    38,    78,   121,   130,
      -1,    38,    79,   121,   130,   168,    -1,    38,    79,   121,
     130,    -1,    38,   121,   130,   168,    -1,    38,   121,   130,
      -1,    38,   211,   130,   168,    -1,    38,   211,   130,    -1,
      39,   130,   168,    -1,    39,   130,    -1,     7,   167,     9,
     149,   178,   152,   167,    -1,    -1,   211,    -1,     1,    -1,
     199,   113,   180,   146,   183,   150,    -1,   199,   119,   180,
     146,   183,   150,    -1,   199,   113,   180,   151,    -1,   199,
     119,   180,   151,    -1,   199,   113,   180,   146,   150,    -1,
     199,   119,   180,   146,   150,    -1,    40,   181,    -1,    -1,
     182,    -1,   181,   127,   182,    -1,   103,    -1,   108,    -1,
      25,   103,    -1,    25,   108,    -1,    24,   103,    -1,    24,
     108,    -1,   194,    -1,   186,    -1,   187,    -1,   164,    -1,
     183,   194,    -1,   183,   186,    -1,   183,   187,    -1,   183,
     164,    -1,   103,    -1,   108,    -1,   139,   103,    -1,   139,
     108,    -1,    -1,   184,    -1,    24,   191,   151,    -1,    24,
     146,   192,   150,    -1,    24,   146,   150,    -1,    25,   191,
     151,    -1,    25,   146,   192,   150,    -1,    25,   146,   150,
      -1,    42,   184,   103,   151,    -1,    42,   103,   151,    -1,
      42,   184,   103,   128,   211,   151,    -1,    42,   103,   128,
     211,   151,    -1,    42,   184,   103,   149,   178,   152,   151,
      -1,   185,   106,   151,    -1,   185,   106,   128,   211,   151,
      -1,   185,   106,   149,   178,   152,   151,    -1,   184,   103,
     151,    -1,   184,   103,   128,   211,   151,    -1,   184,   103,
     149,   178,   152,   151,    -1,   103,   151,    -1,   103,   128,
     211,   151,    -1,   188,    -1,   164,    -1,   106,    -1,   106,
     108,    -1,   190,    -1,   191,   127,   190,    -1,   189,    -1,
     192,   189,    -1,   103,   149,    -1,    85,   149,    -1,   107,
      -1,   199,   193,   178,   152,   196,   202,   166,    -1,   199,
     184,   193,   178,   152,   196,   166,    -1,   199,   193,   178,
     152,   196,   202,   151,    -1,   199,   184,   193,   178,   152,
     196,   151,    -1,   200,   108,   149,   178,   152,   196,   202,
     166,    -1,   200,   184,   108,   149,   178,   152,   196,   166,
      -1,   200,   108,   149,   178,   152,   196,   202,   151,    -1,
     200,   184,   108,   149,   178,   152,   196,   151,    -1,   108,
     149,   178,   152,   196,   202,   166,    -1,   184,   108,   149,
     178,   152,   196,   166,    -1,   130,   197,    -1,    -1,   198,
      -1,   197,   127,   198,    -1,   103,   149,   178,   152,    -1,
     108,   149,   178,   152,    -1,    -1,   200,    -1,   201,    -1,
     200,   201,    -1,    24,    -1,    42,    -1,    26,    -1,    27,
      -1,    25,    -1,    45,    -1,    46,    -1,     4,   185,    -1,
      -1,    14,   193,   178,   152,   202,   166,    -1,   184,    14,
     193,   178,   152,   166,    -1,   200,    14,   193,   178,   152,
     202,   166,    -1,   200,   184,    14,   193,   178,   152,   166,
      -1,    14,   108,   149,   178,   152,   202,   166,    -1,   184,
      14,   108,   149,   178,   152,   166,    -1,   200,    14,   108,
     149,   178,   152,   202,   166,    -1,   200,   184,    14,   108,
     149,   178,   152,   166,    -1,   211,   127,   211,    -1,   211,
     127,    -1,   212,   127,   211,    -1,   212,   127,    -1,   208,
      -1,   207,   127,   208,    -1,   207,   127,    -1,   211,   130,
     211,    -1,   146,   207,   150,    -1,   214,    -1,   116,    -1,
     149,   207,   152,    -1,   108,    -1,   185,   104,    -1,   185,
     109,    -1,   184,   103,    -1,     5,   184,   103,    -1,     5,
     103,    -1,     5,   185,   104,    -1,     5,   149,   205,   152,
      -1,   160,    -1,   103,    -1,   110,    -1,    18,    -1,   111,
      -1,    19,   211,    21,   211,    10,   149,   211,   152,    -1,
      80,   211,    -1,    84,   211,    -1,    85,   211,    -1,    60,
     211,    -1,    63,   211,    -1,    61,   211,    -1,    62,   211,
      -1,    64,   211,    -1,    65,   211,    -1,    95,   211,    -1,
      96,   211,    -1,    91,   211,    -1,    92,   211,    -1,    93,
     211,    -1,    94,   211,    -1,    48,   211,    -1,    49,   211,
      -1,   120,   149,   178,   152,    -1,   107,   178,   152,    -1,
     106,    -1,   137,   211,    -1,   136,   211,    -1,   143,   211,
      -1,   145,   211,    -1,   144,   211,    -1,    86,   103,   149,
     178,   152,    -1,    86,   108,   149,   178,   152,    -1,    87,
     211,    -1,   105,    -1,   149,   211,   152,    -1,   149,   152,
      -1,    14,   149,   178,   152,   202,   166,    -1,   184,    14,
     149,   178,   152,   166,    -1,   200,    14,   149,   178,   152,
     202,   166,    -1,   200,   184,    14,   149,   178,   152,   166,
      -1,   123,    -1,    97,    -1,    22,   211,    -1,    23,   211,
      -1,   112,   149,   211,   152,    -1,   210,    -1,   205,    -1,
     209,    -1,   146,   150,    -1,   211,    50,   211,    -1,   211,
      51,   211,    -1,   211,    52,   211,    -1,   211,    53,   211,
      -1,   211,    54,   211,    -1,   211,    55,   211,    -1,   211,
      56,   211,    -1,   211,    57,   211,    -1,   211,    58,   211,
      -1,   211,    59,   211,    -1,   211,   128,   211,    -1,   211,
      81,   103,    -1,   211,    81,   108,    -1,   211,    98,   211,
      -1,   211,    99,   211,    -1,   211,   129,   211,   130,   211,
      -1,   211,    48,    -1,   211,    49,    -1,   211,   149,   178,
     152,    -1,   211,    66,   211,    -1,   211,    67,   211,    -1,
     211,    68,   211,    -1,   211,    69,   211,    -1,   211,    70,
     211,    -1,   211,   131,   211,    -1,   211,   133,   211,    -1,
     211,   132,   211,    -1,   211,    78,   121,    -1,   211,    79,
     121,    -1,   211,    78,   117,    -1,   211,    78,   118,    -1,
     211,    78,   122,    -1,   211,   135,   211,    -1,   211,   134,
     211,    -1,   211,    75,   211,    -1,   211,    71,   211,    -1,
     211,    76,   211,    -1,   211,    77,   211,    -1,   211,    72,
     211,    -1,   211,    73,   211,    -1,   211,    74,   211,    -1,
     211,    83,   211,    -1,   211,    82,   211,    -1,   211,   136,
     211,    -1,   211,   137,   211,    -1,   211,   138,   211,    -1,
     211,   140,   211,    -1,   211,   139,   211,    -1,   211,   147,
     211,   153,    -1,   211,   146,   211,   150,    -1,   211,   148,
     211,    -1,   211,   124,    -1,   210,    -1,   206,    -1,   212,
      50,   211,    -1,   212,    51,   211,    -1,   212,    52,   211,
      -1,   212,    53,   211,    -1,   212,    54,   211,    -1,   212,
      55,   211,    -1,   212,    56,   211,    -1,   212,    57,   211,
      -1,   212,    58,   211,    -1,   212,    59,   211,    -1,   212,
     128,   211,    -1,   212,    81,   103,    -1,   212,    81,   108,
      -1,   212,    98,   211,    -1,   212,    99,   211,    -1,   212,
     129,   211,   130,   211,    -1,   212,    48,    -1,   212,    49,
      -1,   212,   149,   178,   152,    -1,   212,    66,   211,    -1,
     212,    67,   211,    -1,   212,    68,   211,    -1,   212,    69,
     211,    -1,   212,    70,   211,    -1,   212,   131,   211,    -1,
     212,   133,   211,    -1,   212,   132,   211,    -1,   212,    78,
     121,    -1,   212,    79,   121,    -1,   212,    78,   117,    -1,
     212,    78,   118,    -1,   212,    78,   122,    -1,   212,   135,
     211,    -1,   212,   134,   211,    -1,   212,    75,   211,    -1,
     212,    71,   211,    -1,   212,    76,   211,    -1,   212,    77,
     211,    -1,   212,    72,   211,    -1,   212,    73,   211,    -1,
     212,    74,   211,    -1,   212,    83,   211,    -1,   212,    82,
     211,    -1,   212,   136,   211,    -1,   212,   137,   211,    -1,
     212,   138,   211,    -1,   212,   140,   211,    -1,   212,   139,
     211,    -1,   212,   147,   211,   153,    -1,   212,   146,   211,
     150,    -1,   212,   148,   211,    -1,   212,   124,    -1,   115,
      -1,   115,   213,    -1,   101,    -1,   100,    -1,   213,    -1,
     114,    -1,   102,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1578,  1578,  1579,  1583,  1586,  1589,  1597,  1601,  1605,
    1608,  1616,  1617,  1623,  1629,  1636,  1661,  1663,  1668,  1681,
    1682,  1688,  1693,  1696,  1701,  1704,  1709,  1714,  1720,  1727,
    1732,  1740,  1745,  1753,  1756,  1759,  1765,  1768,  1771,  1774,
    1780,  1785,  1788,  1794,  1797,  1803,  1806,  1811,  1814,  1819,
    1821,  1823,  1825,  1831,  1832,  1836,  1837,  1856,  1862,  1864,
    1867,  1870,  1873,  1876,  1879,  1882,  1885,  1888,  1891,  1894,
    1897,  1900,  1903,  1906,  1907,  1914,  1917,  1920,  1921,  1926,
    1927,  1938,  1940,  1942,  1947,  1949,  1953,  1963,  1967,  1975,
    1980,  1986,  1991,  1997,  2002,  2008,  2013,  2019,  2024,  2030,
    2034,  2039,  2043,  2048,  2052,  2057,  2062,  2068,  2072,  2079,
    2105,  2106,  2107,  2111,  2116,  2121,  2128,  2135,  2142,  2152,
    2155,  2161,  2164,  2171,  2174,  2177,  2180,  2183,  2186,  2192,
    2196,  2201,  2206,  2211,  2215,  2220,  2225,  2233,  2236,  2239,
    2242,  2249,  2250,  2256,  2257,  2258,  2262,  2263,  2264,  2268,
    2272,  2275,  2280,  2283,  2298,  2305,  2312,  2330,  2337,  2344,
    2362,  2368,  2374,  2377,  2386,  2391,  2399,  2402,  2409,  2412,
    2419,  2422,  2425,  2431,  2441,  2455,  2461,  2474,  2484,  2496,
    2501,  2509,  2512,  2521,  2524,  2530,  2533,  2540,  2543,  2550,
    2551,  2556,  2557,  2565,  2566,  2567,  2568,  2569,  2570,  2571,
    2575,  2586,  2591,  2596,  2605,  2616,  2632,  2637,  2646,  2657,
    2674,  2676,  2697,  2699,  2714,  2718,  2722,  2727,  2732,  2738,
    2740,  2742,  2744,  2746,  2759,  2772,  2776,  2784,  2794,  2811,
    2849,  2852,  2859,  2861,  2863,  2865,  2867,  2869,  2871,  2873,
    2885,  2888,  2900,  2903,  2906,  2909,  2929,  2949,  2972,  2986,
    3000,  3014,  3017,  3020,  3027,  3031,  3037,  3043,  3047,  3048,
    3049,  3079,  3084,  3089,  3097,  3102,  3118,  3119,  3123,  3130,
    3138,  3150,  3154,  3157,  3160,  3163,  3169,  3170,  3171,  3172,
    3173,  3174,  3175,  3176,  3177,  3178,  3179,  3180,  3181,  3182,
    3183,  3184,  3185,  3186,  3187,  3188,  3189,  3190,  3191,  3192,
    3193,  3194,  3195,  3196,  3197,  3198,  3199,  3200,  3201,  3202,
    3203,  3204,  3205,  3206,  3207,  3208,  3209,  3210,  3211,  3212,
    3213,  3214,  3215,  3216,  3217,  3218,  3219,  3220,  3221,  3222,
    3223,  3224,  3228,  3229,  3230,  3231,  3232,  3233,  3234,  3235,
    3236,  3237,  3238,  3239,  3240,  3241,  3242,  3243,  3244,  3245,
    3246,  3247,  3248,  3249,  3250,  3251,  3252,  3253,  3254,  3255,
    3256,  3257,  3258,  3259,  3260,  3261,  3262,  3263,  3264,  3265,
    3266,  3267,  3268,  3269,  3270,  3271,  3272,  3273,  3274,  3275,
    3276,  3277,  3278,  3279,  3280,  3281,  3285,  3288,  3295,  3296,
    3297,  3298,  3299
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"return\"", "\"returns\"", "\"my\"",
  "\"do\"", "\"try\"", "\"throw\"", "\"catch\"", "\"where\"", "\"while\"",
  "\"if\"", "\"for\"", "\"sub\"", "\"thread_exit\"", "\"break\"",
  "\"continue\"", "\"%%\"", "\"find\"", "\"foreach\"", "\"in\"",
  "\"delete\"", "\"remove\"", "\"private\"", "\"public\"",
  "\"synchronized\"", "\"deprecated\"", "\"context\"", "\"sortBy\"",
  "\"sortDescendingBy\"", "\"subcontext\"", "\"const\"", "\"summarize\"",
  "\"by\"", "\"our\"", "\"rethrow\"", "\"switch\"", "\"case\"",
  "\"default\"", "\"inherits\"", "\"else\"", "\"static\"", "\"namespace\"",
  "\"module\"", "\"final\"", "\"abstract\"", "\"unreference\"",
  "\"++ operator\"", "\"-- operator\"", "\"+= operator\"",
  "\"-= operator\"", "\"&= operator\"", "\"|= operator\"",
  "\"%= operator\"", "\"*= operator\"", "\"/= operator\"",
  "\"^= operator\"", "\"<<= operator\"", "\">>= operator\"", "\"unshift\"",
  "\"push\"", "\"pop\"", "\"shift\"", "\"chomp\"", "\"trim\"",
  "\"&& operator\"", "\"|| operator\"", "\"|| operator (compat)\"",
  "\"| operator (compat)\"", "\"^ operator (compat)\"", "\"== operator\"",
  "\"!= operator\"", "\"<= operator\"", "\">= operator\"",
  "\"<=> operator\"", "\"=== operator\"", "\"!== operator\"",
  "\"=~ operator\"", "\"!~ operator\"", "\"exists\"", "\"instanceof\"",
  "\">> operator\"", "\"<< operator\"", "\"elements\"", "\"keys\"",
  "\"new\"", "\"background\"", "\"on_exit\"", "\"on_success\"",
  "\"on_error\"", "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"",
  "\"splice\"", "\"extract\"", "\"$# operator\"", "\"?? operator\"",
  "\"?* operator\"", "\"integer value\"", "\"floating-point value\"",
  "\"arbitrary-precision number\"", "\"identifier\"",
  "\"variable reference\"", "\"backquote expression\"",
  "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"simple class declaration\"",
  "\"date/time value\"", "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'|'",
  "'^'", "'&'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "UPLUS", "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'",
  "';'", "')'", "']'", "$accept", "top_level_commands",
  "top_level_command", "module_decls", "module_decl", "ppub", "gvardecl",
  "top_namespace_decl", "namespace_decls", "namespace_decl",
  "unscoped_const_decl", "scoped_const_decl", "block",
  "statement_or_block", "statements", "optname", "statement",
  "context_mods", "context_mod", "return_statement", "switch_statement",
  "case_block", "case_code", "try_statement", "myexp", "class_def",
  "inheritance_list", "superclass_list", "superclass", "class_attributes",
  "uncqtypedef", "qtypedef", "private_member_list", "public_member_list",
  "classvardecl", "member2", "member", "member_list", "member_list2",
  "ident_openparen", "inline_methoddef", "outofline_methoddef",
  "base_constructor_list", "base_constructors", "base_constructor",
  "nsc_modifiers", "method_modifiers", "method_modifier", "return_value",
  "sub_def", "scoped_sub_def", "list", "list_n", "hash", "hash_element",
  "alt_hash", "exp_c", "exp", "exp_n", "string", "scalar", YY_NULL
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,    44,    61,    63,
      58,   124,    94,    38,    60,    62,    43,    45,    37,    42,
      47,   382,   383,   126,    92,    33,   123,    91,    46,    40,
     125,    59,    41,    93
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   154,   155,   155,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   157,   157,   158,   159,
     159,   160,   160,   160,   160,   160,   160,   160,   161,   161,
     161,   162,   162,   163,   163,   163,   163,   163,   163,   163,
     163,   164,   164,   165,   165,   166,   166,   167,   167,   168,
     168,   168,   168,   169,   169,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   170,   170,   170,   170,   171,
     171,   172,   172,   172,   173,   173,   174,   175,   175,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   177,
     178,   178,   178,   179,   179,   179,   179,   179,   179,   180,
     180,   181,   181,   182,   182,   182,   182,   182,   182,   183,
     183,   183,   183,   183,   183,   183,   183,   184,   184,   184,
     184,   185,   185,   186,   186,   186,   187,   187,   187,   188,
     188,   188,   188,   188,   189,   189,   189,   189,   189,   189,
     189,   189,   189,   189,   190,   190,   191,   191,   192,   192,
     193,   193,   193,   194,   194,   194,   194,   195,   195,   195,
     195,   195,   195,   196,   196,   197,   197,   198,   198,   199,
     199,   200,   200,   201,   201,   201,   201,   201,   201,   201,
     202,   202,   203,   203,   203,   203,   204,   204,   204,   204,
     205,   205,   206,   206,   207,   207,   207,   208,   209,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   213,   213,   214,   214,
     214,   214,   214
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     1,     4,     1,     1,     2,     4,     0,
       1,     4,     3,     4,     3,     4,     4,     5,     5,     3,
       4,     1,     2,     1,     1,     1,     1,     1,     2,     1,
       1,     5,     6,     5,     6,     3,     2,     1,     1,     1,
       1,     2,     2,     0,     1,     1,     2,     5,     1,     2,
       3,     2,     2,     2,     3,    11,     7,     5,     7,     5,
       7,     9,     7,     2,     2,     2,     2,     1,     2,     0,
       2,     4,     4,     4,     1,     2,     7,     1,     2,     5,
       4,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     5,     4,     4,     3,     4,     3,     3,     2,     7,
       0,     1,     1,     6,     6,     4,     4,     5,     5,     2,
       0,     1,     3,     1,     1,     2,     2,     2,     2,     1,
       1,     1,     1,     2,     2,     2,     2,     1,     1,     2,
       2,     0,     1,     3,     4,     3,     3,     4,     3,     4,
       3,     6,     5,     7,     3,     5,     6,     3,     5,     6,
       2,     4,     1,     1,     1,     2,     1,     3,     1,     2,
       2,     2,     1,     7,     7,     7,     7,     8,     8,     8,
       8,     7,     7,     2,     0,     1,     3,     4,     4,     0,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     6,     6,     7,     7,     7,     7,     8,     8,
       3,     2,     3,     2,     1,     3,     2,     3,     3,     1,
       1,     3,     1,     2,     2,     2,     3,     2,     3,     4,
       1,     1,     1,     1,     1,     8,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     4,     3,     1,     2,     2,     2,     2,
       2,     5,     5,     2,     1,     3,     2,     6,     6,     7,
       7,     1,     1,     2,     2,     4,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     2,     2,     4,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     4,     4,
       3,     2,     1,     1,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       2,     2,     4,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     4,     4,     3,     2,     1,     2,     1,     1,
       1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     0,   141,   141,     0,     0,   141,     0,     0,     0,
       0,     0,     0,     0,   233,   141,   141,   141,   141,   193,
     197,   195,   196,    53,    79,     0,    53,     0,     0,   194,
       0,   198,   199,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,   141,     0,   141,     0,     0,     0,   141,
     141,   141,   141,   141,   141,   272,   389,   388,   392,   231,
     264,   255,     0,   222,   232,   234,     0,   391,   386,   220,
       0,   271,    15,   141,   141,     0,   141,   141,   141,     0,
     141,    55,     0,     2,     0,   230,    13,     8,     7,    10,
       0,    77,    58,     6,   142,     0,     9,     0,   190,   191,
       4,     5,   333,   332,     0,   390,   219,    78,     0,   197,
     222,   141,   142,     0,   277,   278,   276,    85,   227,   138,
     141,   142,     0,   222,     0,    48,     0,    47,     0,     0,
     141,   141,     0,     0,     0,   172,     0,     0,     0,    74,
      75,    76,     0,     0,   273,   274,     0,    54,     0,     0,
       0,     0,     0,    59,   141,     0,   251,   252,   239,   241,
     242,   240,   243,   244,   236,   237,   238,     0,     0,   263,
      61,    62,    63,   247,   248,   249,   250,   245,   246,   112,
       0,   111,     0,   141,   387,     0,   257,   256,   139,   140,
     258,   260,   259,    11,    50,     0,    49,   266,     0,   214,
       0,     1,     3,   141,    73,     0,   225,     0,   223,   224,
       0,   120,   120,     0,   197,   137,   138,     0,   192,   350,
     351,   141,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,     0,     0,     0,   141,   141,   141,   141,
     385,   213,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,   141,   141,   141,   141,     0,    56,   279,
       0,     0,     0,     0,     0,   296,   297,   141,   141,   141,
     141,   141,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,   141,   141,   141,   141,   141,   141,     0,
       0,     0,   141,   141,   141,   141,   331,   211,   141,   141,
     141,   141,   141,   141,   141,   141,   141,   141,   141,   141,
     141,   141,   141,     0,   277,     0,   226,   228,     0,    46,
       0,     0,     0,    60,     0,     0,     0,   171,   170,     0,
       0,     0,   141,     0,     0,     0,   141,     0,     0,     0,
      64,    80,   141,   141,   141,     0,     0,     0,    16,     0,
       0,   254,     0,     0,     0,    12,    51,    52,   216,   221,
     141,   265,    24,    22,   141,   142,     0,     0,     0,     0,
       0,   189,    29,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   353,   354,   355,   356,   357,   369,   372,   373,
     374,   368,   370,   371,   363,   364,   361,   365,   362,   345,
     346,   376,   375,   347,   348,   212,   344,     0,   358,   360,
     359,   367,   366,   377,   378,   379,   381,   380,     0,     0,
     384,     0,   218,     0,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   299,   300,   301,   302,   303,   315,
     318,   319,   320,   314,   316,   317,   309,   310,   307,   311,
     308,   291,   292,   322,   321,   293,   294,   210,   290,     0,
     304,   306,   305,   313,   312,   323,   324,   325,   327,   326,
       0,     0,   330,     0,   229,     0,    45,   141,     0,     0,
       0,     0,     0,   201,   201,     0,   141,   141,   141,     0,
     141,   141,   141,     0,     0,     0,     0,   141,    14,    17,
       0,     0,   184,   275,   253,   215,   217,   277,    23,    21,
      26,    25,     0,     0,     0,     0,     0,   138,    30,     0,
      39,   189,    31,    34,    33,    35,     0,    40,   190,    36,
      37,     0,     0,   123,   124,   119,   121,   189,   115,   189,
     116,     0,     0,     0,     0,     0,     0,     0,     0,   141,
     383,   382,   352,   141,   329,   328,   298,     0,     0,     0,
      69,    67,     0,   201,   141,     0,     0,     0,     0,     0,
       0,    79,     0,     0,     0,    41,    43,     0,     0,     0,
     261,   262,     0,    57,   201,    27,     0,     0,     0,   184,
       0,    38,    28,    32,     0,     0,     0,   127,   128,   125,
     126,     0,   193,   197,     0,   117,   132,   189,   130,   131,
     129,     0,   190,   118,   189,     0,   201,   201,   184,     0,
       0,     0,     0,   349,   295,     0,     0,     0,     0,     0,
     142,   200,   267,   202,   141,     0,    42,    44,     0,    81,
      82,    83,     0,   141,     0,     0,    87,    18,     0,     0,
     183,   185,     0,     0,   268,   203,     0,     0,     0,   122,
     164,   141,   166,     0,     0,   141,     0,   113,   136,   134,
     135,   133,   137,     0,     0,   114,   201,     0,     0,   201,
       0,     0,     0,   184,    70,   109,    68,     0,   206,     0,
      72,    66,   141,   141,   141,   141,     0,     0,     0,   141,
     141,     0,     0,    86,    88,     0,     0,     0,   181,   207,
     182,   184,   165,     0,     0,   137,   145,   163,   142,     0,
     162,   168,   141,     0,   143,   148,   141,   146,     0,     0,
       0,   269,   204,     0,     0,   270,   205,     0,     0,   235,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   186,   137,     0,   141,   160,     0,     0,
     144,   169,   167,   147,     0,   184,   208,   179,   177,   209,
     180,   178,    71,    79,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   187,   188,   141,   150,     0,     0,   141,
       0,   157,   141,     0,   154,   184,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   141,     0,   149,   161,
       0,     0,     0,     0,     0,     0,    65,   152,     0,     0,
     158,     0,   155,     0,   176,   174,   175,   173,   151,     0,
     159,   156,   153
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    82,    83,   357,   358,    84,    85,    86,   541,   542,
     737,    88,   125,   126,   195,   148,   127,   149,   351,    90,
      91,   665,   666,    92,   180,    93,   384,   555,   556,   627,
     112,    95,   628,   629,   740,   741,   682,   683,   742,   138,
     630,    96,   604,   670,   671,    97,   113,    99,   585,   100,
     101,   114,   102,   198,   199,   115,   116,   181,   104,   105,
     106
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -586
static const yytype_int16 yypact[] =
{
    1481,  -124,  5818,   -16,  5399,  5399,  6353,   -87,   -79,   -67,
     257,    49,    64,    65,  -586,  6353,  6353,  6353,  6353,  -586,
      82,  -586,  -586,    -6,  -586,   165,    -6,    91,    33,  -586,
      97,  -586,  -586,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,   218,  6353,  5399,  5399,  5399,  6353,
    6353,  6353,  6353,  6353,  6353,  -586,  -586,  -586,  -586,    31,
    -586,  -586,  1331,    16,  -586,  -586,   116,  -586,   182,  -586,
     155,  -586,  -586,  6353,  6353,   281,  6353,  6353,  6353,  4795,
    5682,  -586,  1164,  -586,   288,  -586,  -586,  -586,  -586,  -586,
     179,  -586,  -586,  -586,    43,   306,  -586,    61,   509,  -586,
    -586,  -586,  -586,  -586,  8444,  -586,  -586,  -586,   190,   296,
      44,  5954,    40,   612,  -586,  -586,  -586, 10816,    51,  -586,
    6353,   238,   241,    28,  4946,  -586,   337,  -586,   340,  8548,
    6353,  6353,  5546,   212,   213,  -586,   232,  1331,  1331,  -586,
    -586,  -586,  6558,  6660,    46,    46,   308,  -586,   253,  1628,
     246,   262,   254,  -586,  6353,   315,   345,   345, 10816, 10816,
      46,    46,    46,    46,  5476,    46,    46,   280,   287,    46,
    -586,  -586,  -586, 10816, 10816, 10816, 10816, 10816, 10816,  -586,
     276, 10816,  1331,  6353,  -586,  1331,    46,    46,  -586,  -586,
      46,    46,    46,  -586,  -586,  5097,  -586,  -586,   -54,  -586,
    6974,  -586,  -586,   224,  -586,   284,  -586,   293,  -586,  -586,
     319,   403,   403,   454,  -586,  -586,   303,    41,  -586,  -586,
    -586,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,   237,   338,   324,  6353,  6353,  6353,  6353,
    -586,  6220,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  1331,  -586,  -586,
     -14,  9898,   313,   323,   460,  -586,  -586,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,   279,
     357,   363,  6353,  6353,  6353,  6353,  -586,  6220,  6353,  6353,
    6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,  6353,
    6353,  6353,  6353,  1331,   334, 10816,  -586,  -586,  1331,  -586,
    5248,   362,   365,  -586,  7079,  7184,   367,  -586,  -586,  1331,
     385,   400,  6353,   379,   361,   425,  6353,   407,   410,   430,
    -586,  -586,  6353,  6353,  6353,  7289,   461,   -34,  -586,  1331,
    1331,  -586,   441,  7394,   442,  -586,  -586,  -586,  6220,  -586,
    6353,  -586,   225,   267,  6353,   382,   416,   439,  1331,  1331,
    1331,   311,  -586,    55,   375,   376,   448,  1331,  1331,  1331,
     462,   450, 10918, 10918, 10918, 10918, 10918, 10918, 10918, 10918,
   10918, 10918, 11091, 11055, 11091, 11252, 11252,  5476,  5476,  5476,
    5476,  5476,  5476,  5476,  -586,  -586,  -586,  -586,  -586,  -586,
    -586,   483,   483, 10962, 10962, 10918, 10918, 10000, 11172, 11208,
   11252,  5476,  5476,   718,   718,   838,    46,    46,  9692,  6762,
    -586,   449,  -586,   451, 10918, 10918, 10918, 10918, 10918, 10918,
   10918, 10918, 10918, 10918, 11091, 11055, 11091, 11252, 11252,  5476,
    5476,  5476,  5476,  5476,  5476,  5476,  -586,  -586,  -586,  -586,
    -586,  -586,  -586,   483,   483, 10962, 10962, 10918, 10918, 10102,
   11172, 11208, 11252,  5476,  5476,   718,   718,   838,    46,    46,
    9795,  6868,  -586,   452,  -586,   457,  -586,  6353,  1331,  5399,
    5399,  5546,   458,   586,   586,  6456,  6353,  6353,  6353,  7499,
    6353,  6353,  6353,  8652,  8756,  7604,   456,  6353,  -586,  -586,
     463,   464,    60,  -586,  -586,  -586, 10918,   472,  -586,  -586,
    -586,  -586,  1331,   473,   475,   488,   106,   465,  -586,   491,
    -586,   399,  -586,  -586,  -586,  -586,    42,  -586,   653,  -586,
    -586,   421,   437,  -586,  -586,   479,  -586,   353,  -586,   422,
    -586,  1331,   492,   493,   494,   498,  1331,  1331,  1331,  6353,
    -586,  -586,  -586,  6353,  -586,  -586,  -586,   499,  7709,   497,
    -586,   572,   500,   586,   -18,   507,   507,   506,  7814,  8860,
    8964,  -586,  7919,  8024,  8129,  -586,  -586,   609,   134,  9068,
    -586,  -586,   438,  -586,   586,  -586,   504,   507,   507,   536,
    1331,  -586,  -586,  -586,   163,   301,    52,  -586,  -586,  -586,
    -586,    55,   -60,    21,   567,  -586,  -586,   431,  -586,  -586,
    -586,     3,   550,  -586,   455,   521,   586,   586,   536,  1331,
     524,   530,   532,   950,   950,   535,  5399,  5399,  1331,   507,
    -586,  -586,  -586,  -586,  6353,  5399,  -586,  -586,  1628,  -586,
    -586,  -586,   539,  6087,   559,    29,  -586,  -586,   551,   552,
     575,  -586,   507,   507,  -586,  -586,   507,   554,   332,  -586,
     595,   380,  -586,   -46,   601,   566,    34,  -586,  -586,  -586,
    -586,  -586,   213,    23,  1331,  -586,   586,   507,   507,   586,
     556,   507,   507,   536,  -586,  -586,  -586,   557,  -586,  8234,
    -586,  -586,  6353,  6353,  6353,  6353,   598,   600,   592,  6353,
    6353, 10204,  1775,  -586,  -586,  1331,  1331,   438,  -586,  -586,
    -586,   536,  -586,   691,    -1,    47,  -586,  -586,   622,   621,
    -586,  -586,   682,   623,  -586,  -586,   752,  -586,  1331,   576,
     507,  -586,  -586,   417,   507,  -586,  -586,   432,  5399,  -586,
    8339, 10306, 10408, 10510,   603,   604,  1926, 10612, 10714,  2077,
    2228,   578,   583,  -586,    90,   634,  6353,  -586,    48,   302,
    -586,  -586,  -586,  -586,   588,   536,  -586,  -586,  -586,  -586,
    -586,  -586,  -586,  -586,  2379,  2530,  2681,  2832,  2983,  3134,
    3285,  3436,  3587,  -586,  -586,  6353,  -586,   347,  9172,  6353,
    1331,  -586,  6353,  1331,  -586,   536,   586,  1628,  3738,  3889,
    4040,  4191,  4342,  4493,  4644,  9276,  6353,  1331,  -586,  -586,
    9380,   589,  9484,   591,   434,   436,  -586,  -586,  9588,   593,
    -586,   587,  -586,   596,  -586,  -586,  -586,  -586,  -586,   599,
    -586,  -586,  -586
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -586,  -586,   667,  -586,   395,  -586,  -373,  -372,  -586,   214,
       1,  -358,   243,    13,  -104,   727,    77,  -585,  -586,  -586,
    -586,  -586,    89,  -586,   594,  -357,   545,  -586,   137,   200,
       2,     0,  -470,  -417,  -586,  -540,    19,   140,    75,  -194,
    -360,  -355,  -516,  -586,    37,  -456,     7,   -88,  -492,  -353,
    -352,   -76,  -586,   654,   401,  -586,    17,    -2,  -586,   700,
    -586
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -190
static const yytype_int16 yytable[] =
{
     117,    87,    94,   122,   129,   121,   658,    98,   539,   540,
     218,   379,   586,   142,   143,   144,   145,   103,   128,   388,
     330,   103,   103,   544,   545,   218,   547,   107,   549,   550,
    -138,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,  -138,   169,   324,  -137,   680,   173,   174,   175,
     176,   177,   178,   684,   272,   390,   614,   205,  -138,   170,
     171,   172,   130,   103,   103,   103,   678,   663,   664,   356,
     131,   186,   187,   368,   190,   191,   192,    89,   200,   551,
     552,   743,   132,    87,    94,   215,   681,   118,   133,    98,
     119,   649,   119,   676,   275,   276,   103,   147,   369,   103,
     217,   631,   774,   631,   210,   744,   692,   119,   133,   271,
     135,   119,   672,   368,   146,   274,   518,   -20,   325,  -138,
    -138,    75,   699,    75,  -138,  -138,   134,   680,   334,   335,
     135,  -138,  -138,   120,  -137,  -137,   442,  -138,    75,  -137,
    -137,   103,    75,   206,   697,   698,   206,  -138,  -138,   391,
     207,   207,   355,  -138,  -137,  -137,   196,   689,   553,    89,
     391,   743,   350,   554,   689,   182,   103,   685,   539,   540,
     306,   631,   663,   664,   211,   776,   809,   328,   631,   723,
     212,   363,   154,   544,   545,   747,   547,   757,   549,   550,
     602,   133,   320,   321,   322,   323,   567,   810,   777,   811,
     139,   196,   781,   376,   750,   375,   781,   753,   817,   134,
     690,   603,   103,   135,   136,   140,   141,   690,   805,   392,
     393,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   806,   153,   155,   421,   422,   423,   424,   133,   425,
     426,   427,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   183,   134,   691,   150,   816,
     135,   377,   367,   151,   691,   444,   445,   446,   447,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,   465,    68,   527,   834,
     473,   474,   475,   476,   185,   477,   478,   479,   480,   481,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   167,   194,   203,   835,   536,   168,   372,  -137,  -137,
     204,   -20,   373,  -137,  -137,    19,    20,    21,    22,   137,
     505,   326,   133,    25,   509,   327,   -19,   103,   331,   332,
     513,   514,   515,    29,   414,   415,    31,    32,   416,   417,
     134,   337,   338,    75,   135,   136,   271,   194,   526,   133,
    -138,  -138,   325,   374,   352,  -138,  -138,   622,   623,    21,
      22,   339,   543,   546,   188,   624,   133,   134,   548,   189,
     353,   135,   377,  -190,  -190,    29,   466,   467,    31,    32,
     468,   469,   346,   354,   134,   733,   137,   367,   135,   386,
     208,   344,   624,   536,   215,   209,   345,   133,   356,   537,
     379,   388,   734,    19,    20,    21,    22,   419,   361,   359,
     812,    25,   420,   378,   -19,   134,   360,   694,   366,   135,
     565,    29,   380,   383,    31,    32,   622,   623,    21,    22,
      75,   813,   389,   814,   624,   622,   623,    21,    22,   418,
     218,   538,   378,   624,    29,   381,   471,    31,    32,   306,
     382,   472,   387,    29,   443,   826,    31,    32,   470,   622,
     623,    21,    22,   735,   567,   528,   494,   624,   119,   507,
     529,   320,   321,   322,   323,   578,   827,    29,   828,   748,
      31,    32,   215,   625,   588,   589,   590,   537,   592,   593,
     594,   497,   580,   581,   498,   599,   103,   103,   501,    75,
     530,   557,   559,   213,   617,   531,   558,   560,   506,   618,
     736,   275,   276,    19,   214,    21,    22,   503,    75,   133,
     619,   668,   543,   546,   218,   620,   669,   133,   548,   612,
     616,    29,   504,   508,    31,    32,   510,   134,   626,   511,
     626,   135,   386,   124,   632,   134,   632,   643,   787,   135,
     565,   644,   633,   366,    19,   214,    21,    22,   124,   512,
     124,   687,   124,   790,   651,   844,   650,   846,   532,   517,
     584,   733,    29,   522,   524,    31,    32,   561,   624,   568,
     566,   572,   598,   387,   576,   695,   621,   306,   734,   577,
     583,   566,   215,   647,   610,   600,   601,   216,   770,   315,
     316,   317,   318,   319,   605,   607,   273,   608,   688,   320,
     321,   322,   323,   693,   632,   688,    19,   214,    21,    22,
     609,   632,   611,   662,   636,   637,   638,   639,    75,   646,
     603,   648,   709,   124,    29,   654,   673,    31,    32,   705,
     706,   721,   799,   103,   103,   802,   602,   615,   710,   735,
     150,   711,   103,   696,   119,   103,   701,    19,   214,    21,
      22,   739,   702,   738,   703,   739,   704,   738,   712,   722,
     818,   819,   820,   821,   822,    29,   823,   824,    31,    32,
     725,   726,   727,   732,   344,    75,   731,   733,   754,   758,
     760,   761,   762,   763,   624,   215,   745,   767,   768,   764,
     119,   765,   766,   684,   734,   778,   336,   779,   785,   680,
     803,   340,   341,   797,   798,   804,   775,   807,   850,   103,
     815,   841,   739,   843,   738,   849,   739,   851,   738,   202,
     852,    75,   519,   152,   724,   613,   215,   385,   679,   634,
     746,   216,   782,   686,   773,   270,   275,   276,   184,   525,
       0,   792,     0,     0,   808,   103,   362,   733,     0,   364,
       0,     0,     0,   103,   624,   735,   103,   103,     0,     0,
     119,     0,    75,     0,   734,     0,     0,     0,     0,   196,
       0,     0,     0,   825,     0,     0,     0,   830,     0,     0,
     832,   103,   103,   103,   103,   103,   103,   103,   103,   103,
       0,    75,     0,     0,   838,     0,     0,     0,   652,   653,
     836,     0,   780,     0,   103,   103,   103,   103,   103,   103,
     103,   103,   306,   196,     0,     0,   196,   367,     0,     0,
     674,   675,     0,     0,     0,   735,   317,   318,   319,     0,
     119,   441,     0,     0,   320,   321,   322,   323,     0,     0,
       0,   196,   196,   196,   196,   196,   367,   196,   196,   367,
       0,     0,     0,     0,     0,     0,   275,   276,     0,     0,
       0,    75,   708,     0,     0,   367,   367,   367,   367,   367,
     367,   367,   783,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   728,   729,   493,     0,   730,
       0,     0,   495,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   502,     0,     0,     0,     0,     0,     0,
     751,   752,     0,     0,   755,   756,     0,     0,     0,     0,
       0,     0,     0,   520,   521,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   194,     0,     0,     0,     0,
       0,     0,   533,   534,   535,     0,     0,   318,   319,     0,
       0,   562,   563,   564,   320,   321,   322,   323,     0,     0,
       0,     0,     0,   786,     0,     0,   788,   789,   275,   276,
     791,     0,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,   194,   366,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,   194,   194,   194,
     194,   194,   366,   194,   194,   366,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   366,   366,   366,   366,   366,   366,   366,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   845,   847,   309,
       0,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,   579,     0,     0,   582,   320,   321,   322,   323,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   606,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   635,     0,     0,     0,     0,
     640,   641,   642,     0,   201,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,    22,    23,     0,     0,    24,    25,    26,     0,   -19,
      27,    28,     0,     0,   677,     0,    29,  -189,    30,    31,
      32,     0,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,   700,     0,     0,     0,     0,     0,     0,
       0,     0,   707,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,     0,     0,    56,    57,    58,    59,  -141,    60,
      61,    62,    63,  -141,    64,    65,    66,  -189,    67,    68,
      69,     0,     0,  -189,    70,     0,     0,    71,   749,    72,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      73,    74,     0,    75,     0,     0,     0,    76,    77,    78,
      79,     0,     0,    80,     0,    81,     0,     0,     0,   771,
     772,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   179,     0,     0,     0,     3,     0,     0,     0,
       0,     0,   784,     0,     0,   108,     0,     0,     0,    14,
      15,     0,     0,    17,    18,    19,   109,    21,    22,     0,
       0,     0,     0,     0,     0,     0,   -19,     0,     0,     0,
       0,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,   831,     0,     0,   833,     0,     0,
       0,    41,     0,     0,     0,    42,    43,    44,    45,     0,
       0,   839,    49,    50,    51,    52,    53,    54,    55,     0,
       0,    56,    57,    58,    59,  -141,    60,    61,    62,   110,
    -141,    64,    65,    66,     0,    67,    68,    69,     0,     0,
       0,    70,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,    74,     0,
      75,     0,     0,     0,    76,    77,    78,   111,     0,     0,
      80,     0,     1,  -110,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,    20,    21,    22,    23,
       0,     0,    24,    25,    26,     0,   -19,    27,    28,     0,
       0,     0,     0,    29,  -189,    30,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,     0,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,     0,
       0,    56,    57,    58,    59,  -141,    60,    61,    62,    63,
    -141,    64,    65,    66,  -189,    67,    68,    69,     0,     0,
    -189,    70,     0,     0,    71,     0,    72,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,    74,     0,
      75,     0,     0,     0,    76,    77,    78,    79,     0,     1,
      80,     2,    81,     3,     4,     5,     6,     0,   347,     7,
       8,     9,   108,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,   109,    21,    22,    23,   348,   349,    24,
       0,    26,     0,   -19,    27,    28,     0,     0,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,  -141,    60,    61,    62,   123,  -141,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     0,
       0,    76,    77,    78,   124,     0,     1,    80,     2,    81,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   108,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     109,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -19,    27,    28,  -108,  -108,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,     0,     0,    56,    57,    58,    59,  -141,
      60,    61,    62,   123,  -141,    64,    65,    66,     0,    67,
      68,    69,     0,     0,     0,    70,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,    74,     0,    75,     0,     0,     0,    76,    77,
      78,   124,     0,     0,    80,  -108,    81,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     108,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,   109,    21,    22,    23,     0,     0,    24,     0,    26,
       0,   -19,    27,    28,  -104,  -104,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,     0,     0,    56,    57,    58,    59,
    -141,    60,    61,    62,   123,  -141,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,    74,     0,    75,     0,     0,     0,    76,
      77,    78,   124,     0,     0,    80,  -104,    81,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   108,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   109,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -19,    27,    28,  -106,  -106,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,     0,     0,    56,    57,    58,
      59,  -141,    60,    61,    62,   123,  -141,    64,    65,    66,
       0,    67,    68,    69,     0,     0,     0,    70,     0,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,    74,     0,    75,     0,     0,     0,
      76,    77,    78,   124,     0,     0,    80,  -106,    81,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   108,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,   109,    21,    22,    23,     0,     0,    24,
       0,    26,     0,   -19,    27,    28,  -107,  -107,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,  -141,    60,    61,    62,   123,  -141,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     0,
       0,    76,    77,    78,   124,     0,     0,    80,  -107,    81,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   108,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   109,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -19,    27,    28,   -94,   -94,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,     0,     0,    56,
      57,    58,    59,  -141,    60,    61,    62,   123,  -141,    64,
      65,    66,     0,    67,    68,    69,     0,     0,     0,    70,
       0,     0,    71,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,    74,     0,    75,     0,
       0,     0,    76,    77,    78,   124,     0,     0,    80,   -94,
      81,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   108,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,   109,    21,    22,    23,     0,
       0,    24,     0,    26,     0,   -19,    27,    28,   -92,   -92,
       0,     0,    29,     0,     0,    31,    32,     0,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,     0,     0,
      56,    57,    58,    59,  -141,    60,    61,    62,   123,  -141,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    73,    74,     0,    75,
       0,     0,     0,    76,    77,    78,   124,     0,     0,    80,
     -92,    81,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   108,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   109,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -19,    27,    28,   -90,
     -90,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,     0,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,     0,
       0,    56,    57,    58,    59,  -141,    60,    61,    62,   123,
    -141,    64,    65,    66,     0,    67,    68,    69,     0,     0,
       0,    70,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,    74,     0,
      75,     0,     0,     0,    76,    77,    78,   124,     0,     0,
      80,   -90,    81,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   108,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,   109,    21,    22,
      23,     0,     0,    24,     0,    26,     0,   -19,    27,    28,
    -100,  -100,     0,     0,    29,     0,     0,    31,    32,     0,
      33,    34,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,    36,    37,    38,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
       0,     0,    56,    57,    58,    59,  -141,    60,    61,    62,
     123,  -141,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    73,    74,
       0,    75,     0,     0,     0,    76,    77,    78,   124,     0,
       0,    80,  -100,    81,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   108,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   109,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -19,    27,
      28,  -102,  -102,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,     0,     0,    56,    57,    58,    59,  -141,    60,    61,
      62,   123,  -141,    64,    65,    66,     0,    67,    68,    69,
       0,     0,     0,    70,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
      74,     0,    75,     0,     0,     0,    76,    77,    78,   124,
       0,     0,    80,  -102,    81,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   108,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,   109,
      21,    22,    23,     0,     0,    24,     0,    26,     0,   -19,
      27,    28,  -103,  -103,     0,     0,    29,     0,     0,    31,
      32,     0,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,     0,     0,    56,    57,    58,    59,  -141,    60,
      61,    62,   123,  -141,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      73,    74,     0,    75,     0,     0,     0,    76,    77,    78,
     124,     0,     0,    80,  -103,    81,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   108,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     109,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -19,    27,    28,   -96,   -96,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,     0,     0,    56,    57,    58,    59,  -141,
      60,    61,    62,   123,  -141,    64,    65,    66,     0,    67,
      68,    69,     0,     0,     0,    70,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,    74,     0,    75,     0,     0,     0,    76,    77,
      78,   124,     0,     0,    80,   -96,    81,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     108,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,   109,    21,    22,    23,     0,     0,    24,     0,    26,
       0,   -19,    27,    28,   -98,   -98,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,     0,     0,    56,    57,    58,    59,
    -141,    60,    61,    62,   123,  -141,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,    74,     0,    75,     0,     0,     0,    76,
      77,    78,   124,     0,     0,    80,   -98,    81,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   108,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   109,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -19,    27,    28,  -105,  -105,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,     0,     0,    56,    57,    58,
      59,  -141,    60,    61,    62,   123,  -141,    64,    65,    66,
       0,    67,    68,    69,     0,     0,     0,    70,     0,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,    74,     0,    75,     0,     0,     0,
      76,    77,    78,   124,     0,     0,    80,  -105,    81,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   108,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,   109,    21,    22,    23,     0,     0,    24,
       0,    26,     0,   -19,    27,    28,   -93,   -93,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,  -141,    60,    61,    62,   123,  -141,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     0,
       0,    76,    77,    78,   124,     0,     0,    80,   -93,    81,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   108,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   109,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -19,    27,    28,   -91,   -91,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,     0,     0,    56,
      57,    58,    59,  -141,    60,    61,    62,   123,  -141,    64,
      65,    66,     0,    67,    68,    69,     0,     0,     0,    70,
       0,     0,    71,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,    74,     0,    75,     0,
       0,     0,    76,    77,    78,   124,     0,     0,    80,   -91,
      81,     1,     0,     2,     0,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   108,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,   109,    21,    22,    23,     0,
       0,    24,     0,    26,     0,   -19,    27,    28,   -89,   -89,
       0,     0,    29,     0,     0,    31,    32,     0,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,     0,     0,
      56,    57,    58,    59,  -141,    60,    61,    62,   123,  -141,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    73,    74,     0,    75,
       0,     0,     0,    76,    77,    78,   124,     0,     0,    80,
     -89,    81,     1,     0,     2,     0,     3,     4,     5,     6,
       0,     0,     7,     8,     9,   108,    11,    12,    13,    14,
      15,    16,     0,    17,    18,    19,   109,    21,    22,    23,
       0,     0,    24,     0,    26,     0,   -19,    27,    28,   -99,
     -99,     0,     0,    29,     0,     0,    31,    32,     0,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,     0,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,     0,
       0,    56,    57,    58,    59,  -141,    60,    61,    62,   123,
    -141,    64,    65,    66,     0,    67,    68,    69,     0,     0,
       0,    70,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,    74,     0,
      75,     0,     0,     0,    76,    77,    78,   124,     0,     0,
      80,   -99,    81,     1,     0,     2,     0,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   108,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,   109,    21,    22,
      23,     0,     0,    24,     0,    26,     0,   -19,    27,    28,
    -101,  -101,     0,     0,    29,     0,     0,    31,    32,     0,
      33,    34,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,    36,    37,    38,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
       0,     0,    56,    57,    58,    59,  -141,    60,    61,    62,
     123,  -141,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    73,    74,
       0,    75,     0,     0,     0,    76,    77,    78,   124,     0,
       0,    80,  -101,    81,     1,     0,     2,     0,     3,     4,
       5,     6,     0,     0,     7,     8,     9,   108,    11,    12,
      13,    14,    15,    16,     0,    17,    18,    19,   109,    21,
      22,    23,     0,     0,    24,     0,    26,     0,   -19,    27,
      28,   -95,   -95,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,     0,     0,    56,    57,    58,    59,  -141,    60,    61,
      62,   123,  -141,    64,    65,    66,     0,    67,    68,    69,
       0,     0,     0,    70,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
      74,     0,    75,     0,     0,     0,    76,    77,    78,   124,
       0,     0,    80,   -95,    81,     1,     0,     2,     0,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   108,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,   109,
      21,    22,    23,     0,     0,    24,     0,    26,     0,   -19,
      27,    28,   -97,   -97,     0,     0,    29,     0,     0,    31,
      32,     0,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,     0,     0,    56,    57,    58,    59,  -141,    60,
      61,    62,   123,  -141,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      73,    74,     0,    75,     0,     0,     0,    76,    77,    78,
     124,     0,     0,    80,   -97,    81,     1,     0,     2,     0,
       3,     4,     5,     6,     0,     0,     7,     8,     9,   108,
      11,    12,    13,    14,    15,    16,     0,    17,    18,    19,
     109,    21,    22,    23,     0,     0,    24,     0,    26,     0,
     -19,    27,    28,     0,     0,     0,     0,    29,     0,     0,
      31,    32,     0,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,     0,     0,    56,    57,    58,    59,  -141,
      60,    61,    62,   123,  -141,    64,    65,    66,     0,    67,
      68,    69,     0,     0,     0,    70,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    73,    74,     0,    75,     0,     0,     0,    76,    77,
      78,   124,     0,     0,    80,   193,    81,     1,     0,     2,
       0,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     108,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,   109,    21,    22,    23,     0,     0,    24,     0,    26,
       0,   -19,    27,    28,     0,     0,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,     0,     0,    56,    57,    58,    59,
    -141,    60,    61,    62,   123,  -141,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,    74,     0,    75,     0,     0,     0,    76,
      77,    78,   124,     0,     0,    80,   329,    81,     1,     0,
       2,     0,     3,     4,     5,     6,     0,     0,     7,     8,
       9,   108,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,   109,    21,    22,    23,     0,     0,    24,     0,
      26,     0,   -19,    27,    28,     0,     0,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,     0,     0,    56,    57,    58,
      59,  -141,    60,    61,    62,   123,  -141,    64,    65,    66,
       0,    67,    68,    69,     0,     0,     0,    70,     0,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    73,    74,     0,    75,     0,     0,     0,
      76,    77,    78,   124,     0,     0,    80,   365,    81,     1,
       0,     2,     0,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   108,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,   109,    21,    22,    23,     0,     0,    24,
       0,    26,     0,   -19,    27,    28,     0,     0,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,  -141,    60,    61,    62,   123,  -141,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     0,
       0,    76,    77,    78,   124,     0,     0,    80,   496,    81,
       1,     0,     2,     0,     3,     4,     5,     6,     0,     0,
       7,     8,     9,   108,    11,    12,    13,    14,    15,    16,
       0,    17,    18,    19,   109,    21,    22,    23,     0,     0,
      24,     0,    26,     0,   -19,    27,    28,     0,     0,     0,
       0,    29,     0,     0,    31,    32,     0,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,     0,     0,    56,
      57,    58,    59,  -141,    60,    61,    62,   123,  -141,    64,
      65,    66,     0,    67,    68,    69,     0,     0,     0,    70,
       0,     0,    71,     0,   275,   276,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,    74,     0,    75,     0,
       0,     0,    76,    77,    78,   124,     0,   179,    80,     0,
      81,     3,     0,     0,     0,     0,     0,   301,   302,   303,
     108,     0,     0,     0,    14,    15,     0,     0,    17,    18,
      19,   109,    21,    22,     0,     0,     0,     0,     0,     0,
       0,   -19,     0,     0,     0,     0,     0,     0,    29,     0,
       0,    31,    32,     0,    33,    34,     0,     0,     0,     0,
     306,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,    41,     0,     0,     0,
      42,    43,    44,    45,     0,     0,     0,    49,    50,    51,
      52,    53,    54,    55,     0,     0,    56,    57,    58,    59,
    -141,    60,    61,    62,   110,  -141,    64,    65,    66,     0,
      67,    68,    69,     0,     0,     0,    70,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,    74,     0,    75,     0,     3,     0,    76,
      77,    78,   111,     0,     0,    80,   108,  -110,     0,     0,
      14,    15,     0,     0,    17,    18,    19,   109,    21,    22,
       0,     0,     0,     0,     0,     0,     0,   -19,     0,     0,
       0,     0,     0,     0,    29,     0,     0,    31,    32,     0,
      33,    34,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,    36,    37,    38,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,    42,    43,    44,    45,
       0,     0,     0,    49,    50,    51,    52,    53,    54,    55,
       0,     0,    56,    57,    58,    59,     0,    60,    61,    62,
     110,     0,    64,    65,    66,     0,    67,    68,    69,     0,
       0,     0,    70,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    73,    74,
       0,    75,     0,     3,     0,    76,    77,    78,   111,     0,
       0,    80,   108,     0,   197,     0,    14,    15,     0,     0,
      17,    18,    19,   109,    21,    22,     0,     0,     0,     0,
       0,     0,     0,   -19,     0,     0,     0,     0,     0,     0,
      29,     0,     0,    31,    32,     0,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,    42,    43,    44,    45,     0,     0,     0,    49,
      50,    51,    52,    53,    54,    55,     0,     0,    56,    57,
      58,    59,     0,    60,    61,    62,   110,     0,    64,    65,
      66,     0,    67,    68,    69,     0,     0,     0,    70,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,     0,    75,     0,     3,
       0,    76,    77,    78,   111,     0,     0,    80,   108,   -84,
       0,     0,    14,    15,     0,     0,    17,    18,    19,   109,
      21,    22,     0,     0,     0,     0,     0,     0,     0,   -19,
       0,     0,     0,     0,     0,     0,    29,     0,     0,    31,
      32,     0,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,    42,    43,
      44,    45,     0,     0,     0,    49,    50,    51,    52,    53,
      54,    55,     0,     0,    56,    57,    58,    59,     0,    60,
      61,    62,   110,     0,    64,    65,    66,     0,    67,    68,
      69,     0,     0,     0,    70,     0,     0,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      73,    74,     3,    75,     0,     0,     0,    76,    77,    78,
     111,   108,     0,    80,   269,    14,    15,     0,     0,    17,
      18,    19,   109,    21,    22,     0,     0,     0,     0,     0,
       0,     0,   -19,     0,     0,     0,     0,     0,     0,    29,
       0,     0,    31,    32,     0,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    36,    37,
      38,    39,    40,     0,     0,     0,     0,     0,   713,     0,
     714,   715,     0,     0,     0,   716,   717,    41,     0,     0,
       0,    42,    43,    44,    45,     0,     0,     0,    49,    50,
      51,    52,    53,    54,    55,     0,     0,    56,    57,    58,
      59,     0,    60,    61,    62,   110,     0,    64,    65,    66,
       0,    67,    68,    69,     0,     0,     0,    70,   718,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   719,   720,    73,    74,     3,    75,     0,     0,     0,
      76,    77,    78,   111,   108,     0,    80,     0,    14,    15,
       0,     0,    17,    18,    19,   109,    21,    22,     0,     0,
       0,     0,     0,     0,     0,   -19,     0,     0,     0,     0,
       0,     0,    29,     0,     0,    31,    32,     0,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,    42,    43,    44,    45,     0,     0,
       0,    49,    50,    51,    52,    53,    54,    55,     0,     0,
      56,    57,    58,    59,  -141,    60,    61,    62,   110,  -141,
      64,    65,    66,     0,    67,    68,    69,     0,     0,     0,
      70,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    73,    74,     3,    75,
       0,     0,     0,    76,    77,    78,   111,   108,     0,    80,
       0,    14,    15,     0,     0,    17,    18,    19,   109,    21,
      22,     0,     0,     0,     0,     0,     0,     0,   -19,     0,
       0,     0,     0,     0,     0,    29,     0,     0,    31,    32,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,    36,    37,    38,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,    42,    43,    44,
      45,     0,     0,     0,    49,    50,    51,    52,    53,    54,
      55,     0,     0,    56,    57,    58,    59,     0,    60,    61,
      62,   110,     0,    64,    65,    66,   587,    67,    68,    69,
       0,     0,     0,    70,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
      74,     0,    75,     0,     0,     0,    76,    77,    78,   111,
       0,     0,    80,     0,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   342,
     306,     0,     0,   307,   308,   309,     0,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
       0,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,     0,     0,     0,   571,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,     0,
       0,   575,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,   370,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   371,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   499,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   500,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   516,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   523,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   591,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   597,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   645,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   655,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   659,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   660,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   661,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,     0,   759,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,     0,
       0,     0,     0,     0,     0,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,     0,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   304,   305,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   306,     0,     0,   307,   308,   309,     0,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
       0,     0,     0,     0,     0,   320,   321,   322,   323,     0,
       0,   793,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,     0,     0,     0,     0,     0,     0,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,     0,   245,   246,   247,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   248,   249,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   250,     0,
       0,   251,   252,   253,     0,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,     0,     0,     0,     0,     0,
     264,   265,   266,   267,     0,   268,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,   333,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,     0,   595,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     306,     0,     0,   307,   308,   309,     0,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,     0,   596,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
       0,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
       0,   656,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,   657,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,   667,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,     0,   829,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     306,     0,     0,   307,   308,   309,     0,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,     0,   837,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
       0,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
       0,   840,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,     0,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,     0,   842,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,   848,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,   570,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,     0,     0,     0,     0,     0,
       0,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,     0,   301,   302,   303,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   304,   305,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   306,
       0,     0,   307,   308,   309,     0,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,     0,     0,     0,     0,
       0,   320,   321,   322,   323,   574,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,   370,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
     569,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,   573,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,   769,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     306,     0,     0,   307,   308,   309,   794,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   306,     0,     0,   307,   308,   309,   795,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
       0,     0,     0,     0,     0,     0,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
       0,   301,   302,   303,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   304,   305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   306,     0,     0,   307,   308,   309,
     796,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,     0,     0,     0,     0,     0,   320,   321,   322,   323,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     304,   305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,   307,
     308,   309,   800,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,     0,     0,     0,     0,     0,     0,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,     0,   301,   302,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   304,   305,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   306,     0,
       0,   307,   308,   309,   801,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,     0,     0,     0,     0,     0,
     320,   321,   322,   323,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,     0,     0,     0,     0,
       0,     0,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,     0,   301,   302,   303,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     306,     0,     0,   307,   308,   309,     0,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,     0,     0,     0,
       0,     0,   320,   321,   322,   323,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,     0,     0,
       0,     0,     0,     0,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,     0,     0,     0,     0,   304,   305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   306,   301,   302,   303,   308,   309,     0,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,     0,
     304,   305,     0,     0,   320,   321,   322,   323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,     0,
       0,     0,     0,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   275,   276,     0,     0,     0,   320,   321,
     322,   323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   287,     0,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,     0,   301,   302,   303,   275,
     276,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,     0,   301,   302,   303,     0,     0,     0,     0,   306,
       0,     0,     0,     0,     0,     0,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,     0,     0,     0,     0,
       0,   320,   321,   322,   323,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   306,     0,     0,     0,     0,
     275,   276,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,     0,     0,     0,     0,     0,   320,   321,   322,
     323,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,     0,   301,   302,   303,   275,   276,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,     0,   301,
     302,   303,     0,     0,     0,     0,   306,     0,     0,     0,
     275,   276,     0,     0,   311,   312,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323,     0,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   306,   301,   302,   303,     0,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,   318,   319,     0,
       0,     0,     0,     0,   320,   321,   322,   323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   306,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   313,   314,   315,   316,
     317,   318,   319,     0,     0,     0,     0,     0,   320,   321,
     322,   323
};

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-586)))

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-190)))

static const yytype_int16 yycheck[] =
{
       2,     0,     0,     3,     6,     3,   591,     0,   381,   381,
      98,   205,   504,    15,    16,    17,    18,     0,     5,   213,
     124,     4,     5,   381,   381,   113,   381,   151,   381,   381,
      14,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    14,    45,   120,    14,   106,    49,    50,    51,
      52,    53,    54,    32,    14,    14,    14,    14,    14,    46,
      47,    48,   149,    46,    47,    48,    14,    38,    39,   103,
     149,    73,    74,   127,    76,    77,    78,     0,    80,    24,
      25,   127,   149,    82,    82,   103,   146,   103,    85,    82,
     108,   583,   108,   609,    48,    49,    79,   103,   152,    82,
      98,   557,   103,   559,    43,   151,   103,   108,    85,   111,
     107,   108,   604,   127,    32,   113,   150,    35,   120,   103,
     104,   139,   638,   139,   108,   109,   103,   106,   130,   131,
     107,   103,   104,   149,   103,   104,   150,   109,   139,   108,
     109,   124,   139,   103,   636,   637,   103,   103,   104,   108,
     108,   108,   154,   109,   103,   104,    79,   627,   103,    82,
     108,   127,   149,   108,   634,   149,   149,   146,   541,   541,
     124,   627,    38,    39,   113,   128,   128,   149,   634,   150,
     119,   183,   149,   541,   541,   151,   541,   703,   541,   541,
     130,    85,   146,   147,   148,   149,   390,   149,   151,   151,
     151,   124,   742,   203,   696,   203,   746,   699,   793,   103,
     627,   151,   195,   107,   108,   151,   151,   634,   128,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   151,   151,   146,   246,   247,   248,   249,    85,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   149,   103,   627,   103,   785,
     107,   108,   195,   108,   634,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   115,   374,   815,
     302,   303,   304,   305,   149,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   103,    79,    35,   816,    14,   108,   103,   103,   104,
     151,    35,   108,   108,   109,    24,    25,    26,    27,   149,
     342,   103,    85,    32,   346,   104,    35,   330,    11,     9,
     352,   353,   354,    42,   117,   118,    45,    46,   121,   122,
     103,   149,   149,   139,   107,   108,   368,   124,   370,    85,
     103,   104,   374,   149,   128,   108,   109,    24,    25,    26,
      27,   149,   381,   381,   103,    32,    85,   103,   381,   108,
     128,   107,   108,    48,    49,    42,   117,   118,    45,    46,
     121,   122,   149,   149,   103,    25,   149,   330,   107,   108,
     104,   103,    32,    14,   103,   109,   108,    85,   103,   108,
     614,   615,    42,    24,    25,    26,    27,   103,   152,   149,
     128,    32,   108,   149,    35,   103,   149,   631,   195,   107,
     108,    42,   149,    40,    45,    46,    24,    25,    26,    27,
     139,   149,   149,   151,    32,    24,    25,    26,    27,   121,
     548,   150,   149,    32,    42,   146,   103,    45,    46,   124,
     151,   108,   149,    42,    14,   128,    45,    46,   121,    24,
      25,    26,    27,   103,   678,   103,   152,    32,   108,   128,
     108,   146,   147,   148,   149,   497,   149,    42,   151,   693,
      45,    46,   103,   150,   506,   507,   508,   108,   510,   511,
     512,   149,   499,   500,   149,   517,   499,   500,   151,   139,
     104,   146,   146,    14,   103,   109,   151,   151,   149,   108,
     150,    48,    49,    24,    25,    26,    27,   152,   139,    85,
     103,   103,   541,   541,   632,   108,   108,    85,   541,   150,
     548,    42,   152,   128,    45,    46,   149,   103,   557,   149,
     559,   107,   108,   146,   557,   103,   559,   569,   151,   107,
     108,   573,   150,   330,    24,    25,    26,    27,   146,   149,
     146,   150,   146,   151,   584,   151,   584,   151,   149,   128,
       4,    25,    42,   152,   152,    45,    46,   149,    32,   149,
     149,   152,   146,   149,   152,   150,   127,   124,    42,   152,
     152,   149,   103,    41,   149,   152,   152,   108,   722,   136,
     137,   138,   139,   140,   152,   152,    14,   152,   627,   146,
     147,   148,   149,   631,   627,   634,    24,    25,    26,    27,
     152,   634,   151,    34,   152,   152,   152,   149,   139,   152,
     151,   151,   654,   146,    42,   149,   152,    45,    46,   646,
     647,   663,   766,   646,   647,   769,   130,    14,   655,   103,
     103,   658,   655,   152,   108,   658,   152,    24,    25,    26,
      27,   681,   152,   681,   152,   685,   151,   685,   149,   130,
     794,   795,   796,   797,   798,    42,   800,   801,    45,    46,
     149,   149,   127,   108,   103,   139,   152,    25,   152,   152,
     712,   713,   714,   715,    32,   103,   150,   719,   720,   121,
     108,   121,   130,    32,    42,   103,   132,   106,   152,   106,
     152,   137,   138,   130,   130,   152,   734,   103,   151,   722,
     152,   152,   742,   152,   742,   152,   746,   151,   746,    82,
     151,   139,   357,    26,   665,   541,   103,   212,   621,   559,
     685,   108,   743,   623,   727,   111,    48,    49,    68,   368,
      -1,   758,    -1,    -1,   776,   758,   182,    25,    -1,   185,
      -1,    -1,    -1,   766,    32,   103,   769,   770,    -1,    -1,
     108,    -1,   139,    -1,    42,    -1,    -1,    -1,    -1,   722,
      -1,    -1,    -1,   805,    -1,    -1,    -1,   809,    -1,    -1,
     812,   794,   795,   796,   797,   798,   799,   800,   801,   802,
      -1,   139,    -1,    -1,   826,    -1,    -1,    -1,   585,   586,
     817,    -1,   150,    -1,   817,   818,   819,   820,   821,   822,
     823,   824,   124,   766,    -1,    -1,   769,   770,    -1,    -1,
     607,   608,    -1,    -1,    -1,   103,   138,   139,   140,    -1,
     108,   267,    -1,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,   794,   795,   796,   797,   798,   799,   800,   801,   802,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,
      -1,   139,   649,    -1,    -1,   818,   819,   820,   821,   822,
     823,   824,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   672,   673,   323,    -1,   676,
      -1,    -1,   328,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   339,    -1,    -1,    -1,    -1,    -1,    -1,
     697,   698,    -1,    -1,   701,   702,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   359,   360,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   722,    -1,    -1,    -1,    -1,
      -1,    -1,   378,   379,   380,    -1,    -1,   139,   140,    -1,
      -1,   387,   388,   389,   146,   147,   148,   149,    -1,    -1,
      -1,    -1,    -1,   750,    -1,    -1,   753,   754,    48,    49,
     757,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   766,
      -1,    -1,   769,   770,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,   794,   795,   796,
     797,   798,   799,   800,   801,   802,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   818,   819,   820,   821,   822,   823,   824,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   834,   835,   129,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,   498,    -1,    -1,   501,   146,   147,   148,   149,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,    -1,
     566,   567,   568,    -1,     0,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    -1,    31,    32,    33,    -1,    35,
      36,    37,    -1,    -1,   610,    -1,    42,    43,    44,    45,
      46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,   639,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   648,    -1,    80,    -1,    -1,    -1,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    -1,    -1,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,    -1,   119,   120,    -1,    -1,   123,   694,   125,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,
     146,    -1,    -1,   149,    -1,   151,    -1,    -1,    -1,   725,
     726,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     1,    -1,    -1,    -1,     5,    -1,    -1,    -1,
      -1,    -1,   748,    -1,    -1,    14,    -1,    -1,    -1,    18,
      19,    -1,    -1,    22,    23,    24,    25,    26,    27,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      -1,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   810,    -1,    -1,   813,    -1,    -1,
      -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,    -1,
      -1,   827,    91,    92,    93,    94,    95,    96,    97,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,    -1,   114,   115,   116,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,
     149,    -1,     1,   152,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    32,    33,    -1,    35,    36,    37,    -1,
      -1,    -1,    -1,    42,    43,    44,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,    -1,    -1,
     119,   120,    -1,    -1,   123,    -1,   125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,     1,
     149,     3,   151,     5,     6,     7,     8,    -1,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    35,    36,    37,    -1,    -1,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,   143,   144,   145,   146,    -1,     1,   149,     3,   151,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,    -1,   114,
     115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,
     145,   146,    -1,    -1,   149,   150,   151,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    -1,    31,    -1,    33,
      -1,    35,    36,    37,    38,    39,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,    -1,
     114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,
     144,   145,   146,    -1,    -1,   149,   150,   151,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,
      -1,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
      -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
     143,   144,   145,   146,    -1,    -1,   149,   150,   151,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    -1,    31,
      -1,    33,    -1,    35,    36,    37,    38,    39,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,   143,   144,   145,   146,    -1,    -1,   149,   150,   151,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    -1,    -1,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,
      -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,   143,   144,   145,   146,    -1,    -1,   149,   150,
     151,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      -1,    31,    -1,    33,    -1,    35,    36,    37,    38,    39,
      -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      80,    -1,    -1,    -1,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,
     120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,   149,
     150,   151,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,    -1,   114,   115,   116,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,
     149,   150,   151,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,
      38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      -1,    -1,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,    -1,   114,   115,   116,    -1,
      -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,
      -1,   149,   150,   151,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,    -1,   114,   115,   116,
      -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,
      -1,    -1,   149,   150,   151,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,
      36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,
      46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    -1,    -1,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,    -1,   114,   115,
     116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,
     146,    -1,    -1,   149,   150,   151,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,    -1,   114,
     115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,
     145,   146,    -1,    -1,   149,   150,   151,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    -1,    31,    -1,    33,
      -1,    35,    36,    37,    38,    39,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,    -1,
     114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,
     144,   145,   146,    -1,    -1,   149,   150,   151,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    38,    39,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,
      -1,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
      -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
     143,   144,   145,   146,    -1,    -1,   149,   150,   151,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    -1,    31,
      -1,    33,    -1,    35,    36,    37,    38,    39,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,   143,   144,   145,   146,    -1,    -1,   149,   150,   151,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    -1,    -1,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,
      -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,   143,   144,   145,   146,    -1,    -1,   149,   150,
     151,     1,    -1,     3,    -1,     5,     6,     7,     8,    -1,
      -1,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      -1,    31,    -1,    33,    -1,    35,    36,    37,    38,    39,
      -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      80,    -1,    -1,    -1,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,
     120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,
      -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,   149,
     150,   151,     1,    -1,     3,    -1,     5,     6,     7,     8,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,    38,
      39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,    -1,   114,   115,   116,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,    -1,
     139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,    -1,
     149,   150,   151,     1,    -1,     3,    -1,     5,     6,     7,
       8,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,    37,
      38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      -1,    -1,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,    -1,   114,   115,   116,    -1,
      -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
      -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,    -1,
      -1,   149,   150,   151,     1,    -1,     3,    -1,     5,     6,
       7,     8,    -1,    -1,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,    36,
      37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,    -1,   114,   115,   116,
      -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,
      -1,    -1,   149,   150,   151,     1,    -1,     3,    -1,     5,
       6,     7,     8,    -1,    -1,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,    35,
      36,    37,    38,    39,    -1,    -1,    42,    -1,    -1,    45,
      46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    -1,    -1,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,    -1,   114,   115,
     116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,
     146,    -1,    -1,   149,   150,   151,     1,    -1,     3,    -1,
       5,     6,     7,     8,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    -1,    31,    -1,    33,    -1,
      35,    36,    37,    -1,    -1,    -1,    -1,    42,    -1,    -1,
      45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,    -1,   114,
     115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,   144,
     145,   146,    -1,    -1,   149,   150,   151,     1,    -1,     3,
      -1,     5,     6,     7,     8,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    -1,    31,    -1,    33,
      -1,    35,    36,    37,    -1,    -1,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,    -1,
     114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,   143,
     144,   145,   146,    -1,    -1,   149,   150,   151,     1,    -1,
       3,    -1,     5,     6,     7,     8,    -1,    -1,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    -1,    31,    -1,
      33,    -1,    35,    36,    37,    -1,    -1,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,
      -1,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
      -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,    -1,
     143,   144,   145,   146,    -1,    -1,   149,   150,   151,     1,
      -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    -1,    31,
      -1,    33,    -1,    35,    36,    37,    -1,    -1,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,    -1,
      -1,   143,   144,   145,   146,    -1,    -1,   149,   150,   151,
       1,    -1,     3,    -1,     5,     6,     7,     8,    -1,    -1,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    -1,
      31,    -1,    33,    -1,    35,    36,    37,    -1,    -1,    -1,
      -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    -1,    -1,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,
      -1,    -1,   123,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,
      -1,    -1,   143,   144,   145,   146,    -1,     1,   149,    -1,
     151,     5,    -1,    -1,    -1,    -1,    -1,    81,    82,    83,
      14,    -1,    -1,    -1,    18,    19,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,
      -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,    -1,
     124,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    65,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    80,    -1,    -1,    -1,
      84,    85,    86,    87,    -1,    -1,    -1,    91,    92,    93,
      94,    95,    96,    97,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,    -1,
     114,   115,   116,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,    -1,   139,    -1,     5,    -1,   143,
     144,   145,   146,    -1,    -1,   149,    14,   151,    -1,    -1,
      18,    19,    -1,    -1,    22,    23,    24,    25,    26,    27,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,
      -1,    -1,    -1,    -1,    42,    -1,    -1,    45,    46,    -1,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,    87,
      -1,    -1,    -1,    91,    92,    93,    94,    95,    96,    97,
      -1,    -1,   100,   101,   102,   103,    -1,   105,   106,   107,
     108,    -1,   110,   111,   112,    -1,   114,   115,   116,    -1,
      -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
      -1,   139,    -1,     5,    -1,   143,   144,   145,   146,    -1,
      -1,   149,    14,    -1,   152,    -1,    18,    19,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,
      42,    -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    84,    85,    86,    87,    -1,    -1,    -1,    91,
      92,    93,    94,    95,    96,    97,    -1,    -1,   100,   101,
     102,   103,    -1,   105,   106,   107,   108,    -1,   110,   111,
     112,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,    -1,   139,    -1,     5,
      -1,   143,   144,   145,   146,    -1,    -1,   149,    14,   151,
      -1,    -1,    18,    19,    -1,    -1,    22,    23,    24,    25,
      26,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,
      -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,    45,
      46,    -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,
      86,    87,    -1,    -1,    -1,    91,    92,    93,    94,    95,
      96,    97,    -1,    -1,   100,   101,   102,   103,    -1,   105,
     106,   107,   108,    -1,   110,   111,   112,    -1,   114,   115,
     116,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     136,   137,     5,   139,    -1,    -1,    -1,   143,   144,   145,
     146,    14,    -1,   149,   150,    18,    19,    -1,    -1,    22,
      23,    24,    25,    26,    27,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    42,
      -1,    -1,    45,    46,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    74,    -1,    -1,    -1,    78,    79,    80,    -1,    -1,
      -1,    84,    85,    86,    87,    -1,    -1,    -1,    91,    92,
      93,    94,    95,    96,    97,    -1,    -1,   100,   101,   102,
     103,    -1,   105,   106,   107,   108,    -1,   110,   111,   112,
      -1,   114,   115,   116,    -1,    -1,    -1,   120,   121,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   134,   135,   136,   137,     5,   139,    -1,    -1,    -1,
     143,   144,   145,   146,    14,    -1,   149,    -1,    18,    19,
      -1,    -1,    22,    23,    24,    25,    26,    27,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    -1,
      -1,    -1,    42,    -1,    -1,    45,    46,    -1,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      80,    -1,    -1,    -1,    84,    85,    86,    87,    -1,    -1,
      -1,    91,    92,    93,    94,    95,    96,    97,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,    -1,   114,   115,   116,    -1,    -1,    -1,
     120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,   137,     5,   139,
      -1,    -1,    -1,   143,   144,   145,   146,    14,    -1,   149,
      -1,    18,    19,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,
      -1,    -1,    -1,    -1,    -1,    42,    -1,    -1,    45,    46,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    80,    -1,    -1,    -1,    84,    85,    86,
      87,    -1,    -1,    -1,    91,    92,    93,    94,    95,    96,
      97,    -1,    -1,   100,   101,   102,   103,    -1,   105,   106,
     107,   108,    -1,   110,   111,   112,    10,   114,   115,   116,
      -1,    -1,    -1,   120,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,
     137,    -1,   139,    -1,    -1,    -1,   143,   144,   145,   146,
      -1,    -1,   149,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    21,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,    -1,    -1,   153,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,   153,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,    -1,   152,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,
      -1,   152,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,   151,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,   151,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,   151,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    -1,   151,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      -1,   151,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,   151,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,   151,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,   151,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    -1,   151,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      -1,   151,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    -1,   151,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,   151,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,   150,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,
      -1,    -1,   127,   128,   129,    -1,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,
      -1,   146,   147,   148,   149,   150,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,
      -1,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,   127,   128,   129,    -1,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,    -1,    -1,    -1,    -1,    98,    99,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   124,    81,    82,    83,   128,   129,    -1,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      98,    99,    -1,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,
      -1,    -1,    -1,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    48,    49,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    -1,    -1,    -1,    -1,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,    -1,    -1,    -1,    -1,
      -1,   146,   147,   148,   149,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,
      48,    49,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,   148,
     149,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,
      48,    49,    -1,    -1,   132,   133,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149,    -1,    71,    72,    73,    74,    75,    76,    77,
      78,    79,   124,    81,    82,    83,    -1,    -1,    -1,    -1,
      -1,   133,   134,   135,   136,   137,   138,   139,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   134,   135,   136,   137,
     138,   139,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,
     148,   149
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,     6,     7,     8,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    22,    23,    24,
      25,    26,    27,    28,    31,    32,    33,    36,    37,    42,
      44,    45,    46,    48,    49,    60,    61,    62,    63,    64,
      65,    80,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,   100,   101,   102,   103,
     105,   106,   107,   108,   110,   111,   112,   114,   115,   116,
     120,   123,   125,   136,   137,   139,   143,   144,   145,   146,
     149,   151,   155,   156,   159,   160,   161,   164,   165,   170,
     173,   174,   177,   179,   184,   185,   195,   199,   200,   201,
     203,   204,   206,   210,   212,   213,   214,   151,    14,    25,
     108,   146,   184,   200,   205,   209,   210,   211,   103,   108,
     149,   184,   185,   108,   146,   166,   167,   170,   167,   211,
     149,   149,   149,    85,   103,   107,   108,   149,   193,   151,
     151,   151,   211,   211,   211,   211,    32,   103,   169,   171,
     103,   108,   169,   151,   149,   146,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   103,   108,   211,
     167,   167,   167,   211,   211,   211,   211,   211,   211,     1,
     178,   211,   149,   149,   213,   149,   211,   211,   103,   108,
     211,   211,   211,   150,   166,   168,   170,   152,   207,   208,
     211,     0,   156,    35,   151,    14,   103,   108,   104,   109,
      43,   113,   119,    14,    25,   103,   108,   184,   201,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    81,    82,    83,    98,    99,
     124,   127,   128,   129,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   146,   147,   148,   149,   151,   150,
     207,   211,    14,    14,   184,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    81,    82,    83,    98,    99,   124,   127,   128,   129,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     146,   147,   148,   149,   205,   211,   103,   104,   149,   150,
     168,    11,     9,   151,   211,   211,   178,   149,   149,   149,
     178,   178,    21,    21,   103,   108,   149,    10,    29,    30,
     167,   172,   128,   128,   149,   211,   103,   157,   158,   149,
     149,   152,   178,   211,   178,   150,   166,   170,   127,   152,
     130,   152,   103,   108,   149,   184,   185,   108,   149,   193,
     149,   146,   151,    40,   180,   180,   108,   149,   193,   149,
      14,   108,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   117,   118,   121,   122,   121,   103,
     108,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   178,   150,    14,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   117,   118,   121,   122,
     121,   103,   108,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   178,   152,   178,   150,   149,   149,   152,
     152,   151,   178,   152,   152,   211,   149,   128,   128,   211,
     149,   149,   149,   211,   211,   211,   152,   128,   150,   158,
     178,   178,   152,   152,   152,   208,   211,   205,   103,   108,
     104,   109,   149,   178,   178,   178,    14,   108,   150,   160,
     161,   162,   163,   164,   165,   179,   184,   195,   200,   203,
     204,    24,    25,   103,   108,   181,   182,   146,   151,   146,
     151,   149,   178,   178,   178,   108,   149,   193,   149,   130,
     150,   153,   152,   130,   150,   153,   152,   152,   211,   178,
     167,   167,   178,   152,     4,   202,   202,    10,   211,   211,
     211,   152,   211,   211,   211,   151,   151,   152,   146,   211,
     152,   152,   130,   151,   196,   152,   178,   152,   152,   152,
     149,   151,   150,   163,    14,    14,   184,   103,   108,   103,
     108,   127,    24,    25,    32,   150,   164,   183,   186,   187,
     194,   199,   200,   150,   183,   178,   152,   152,   152,   149,
     178,   178,   178,   211,   211,   152,   152,    41,   151,   202,
     184,   185,   166,   166,   149,   152,   151,   151,   171,   152,
     152,   152,    34,    38,    39,   175,   176,   151,   103,   108,
     197,   198,   202,   152,   166,   166,   196,   178,    14,   182,
     106,   146,   190,   191,    32,   146,   191,   150,   164,   186,
     187,   194,   103,   184,   193,   150,   152,   202,   202,   196,
     178,   152,   152,   152,   151,   167,   167,   178,   166,   211,
     167,   167,   149,    71,    73,    74,    78,    79,   121,   134,
     135,   211,   130,   150,   176,   149,   149,   127,   166,   166,
     166,   152,   108,    25,    42,   103,   150,   164,   184,   185,
     188,   189,   192,   127,   151,   150,   192,   151,   193,   178,
     202,   166,   166,   202,   152,   166,   166,   196,   152,   152,
     211,   211,   211,   211,   121,   121,   130,   211,   211,   130,
     168,   178,   178,   198,   103,   184,   128,   151,   103,   106,
     150,   189,   190,   150,   178,   152,   166,   151,   166,   166,
     151,   166,   167,   152,   130,   130,   130,   130,   130,   168,
     130,   130,   168,   152,   152,   128,   151,   103,   211,   128,
     149,   151,   128,   149,   151,   152,   196,   171,   168,   168,
     168,   168,   168,   168,   168,   211,   128,   149,   151,   151,
     211,   178,   211,   178,   196,   202,   167,   151,   211,   178,
     151,   152,   151,   152,   151,   166,   151,   166,   151,   152,
     151,   151,   151
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  However,
   YYFAIL appears to be in use.  Nevertheless, it is formally deprecated
   in Bison 2.4.2's NEWS entry, where a plan to phase it out is
   discussed.  */

#define YYFAIL		goto yyerrlab
#if defined YYFAIL
  /* This is here to suppress warnings from the GCC cpp's
     -Wunused-macros.  Normally we don't worry about that warning, but
     some users do, and we want to make it easy for users to remove
     YYFAIL uses, which will produce warnings from Bison 2.5.  */
#endif

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))

/* Error token number */
#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (YYID (N))                                                     \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (YYID (0))
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

__attribute__((__unused__))
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static unsigned
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
#else
static unsigned
yy_location_print_ (yyo, yylocp)
    FILE *yyo;
    YYLTYPE const * const yylocp;
#endif
{
  unsigned res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += fprintf (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += fprintf (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += fprintf (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += fprintf (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += fprintf (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */
#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc, yyscanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
  YYUSE (yylocationp);
  YYUSE (yyscanner);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
        break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner)
#else
static void
yy_reduce_print (yyvsp, yylsp, yyrule, yyscanner)
    YYSTYPE *yyvsp;
    YYLTYPE *yylsp;
    int yyrule;
    yyscan_t yyscanner;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       , &(yylsp[(yyi + 1) - (yynrhs)])		       , yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, yylsp, Rule, yyscanner); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULL, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULL;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - Assume YYFAIL is not used.  It's too flawed to consider.  See
       <http://lists.gnu.org/archive/html/bison-patches/2009-12/msg00024.html>
       for details.  YYERROR is fine as it does not invoke this
       function.
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULL, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp, yyscanner)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
    yyscan_t yyscanner;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {
      case 103: /* "identifier" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5671 "parser.cpp"
        break;
      case 104: /* "variable reference" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5678 "parser.cpp"
        break;
      case 105: /* "backquote expression" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5685 "parser.cpp"
        break;
      case 106: /* "in-object member reference" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5692 "parser.cpp"
        break;
      case 107: /* "identifier or keyword used as function or method identifier" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5699 "parser.cpp"
        break;
      case 108: /* "namespace or class-scoped reference" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5706 "parser.cpp"
        break;
      case 109: /* "namespace-scoped global variable reference" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5713 "parser.cpp"
        break;
      case 110: /* "context reference" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5720 "parser.cpp"
        break;
      case 111: /* "named context reference" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5727 "parser.cpp"
        break;
      case 112: /* "cast operator" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5734 "parser.cpp"
        break;
      case 113: /* "simple class declaration" */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5741 "parser.cpp"
        break;
      case 114: /* "date/time value" */
/* Line 1398 of yacc.c  */
#line 1573 "parser.ypp"
        { if (((*yyvaluep).datetime)) ((*yyvaluep).datetime)->deref(); };
/* Line 1398 of yacc.c  */
#line 5748 "parser.cpp"
        break;
      case 115: /* "quoted string" */
/* Line 1398 of yacc.c  */
#line 1573 "parser.ypp"
        { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); };
/* Line 1398 of yacc.c  */
#line 5755 "parser.cpp"
        break;
      case 116: /* "binary constant value" */
/* Line 1398 of yacc.c  */
#line 1573 "parser.ypp"
        { if (((*yyvaluep).binary)) ((*yyvaluep).binary)->deref(); };
/* Line 1398 of yacc.c  */
#line 5762 "parser.cpp"
        break;
      case 117: /* "regular expression substitution expression" */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).RegexSubst); };
/* Line 1398 of yacc.c  */
#line 5769 "parser.cpp"
        break;
      case 118: /* "transliteration expression" */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).RegexTrans); };
/* Line 1398 of yacc.c  */
#line 5776 "parser.cpp"
        break;
      case 119: /* "scoped class declaration" */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).nscope); };
/* Line 1398 of yacc.c  */
#line 5783 "parser.cpp"
        break;
      case 120: /* "call to base class method" */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).nscope); };
/* Line 1398 of yacc.c  */
#line 5790 "parser.cpp"
        break;
      case 121: /* "regular expression" */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).Regex); };
/* Line 1398 of yacc.c  */
#line 5797 "parser.cpp"
        break;
      case 122: /* "regular expression extraction expression" */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).Regex); };
/* Line 1398 of yacc.c  */
#line 5804 "parser.cpp"
        break;
      case 123: /* "implicit argument reference" */
/* Line 1398 of yacc.c  */
#line 1573 "parser.ypp"
        { if (((*yyvaluep).implicit_arg)) ((*yyvaluep).implicit_arg)->deref(); };
/* Line 1398 of yacc.c  */
#line 5811 "parser.cpp"
        break;
      case 124: /* "keyword used as hash key or object member reference" */
/* Line 1398 of yacc.c  */
#line 1573 "parser.ypp"
        { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); };
/* Line 1398 of yacc.c  */
#line 5818 "parser.cpp"
        break;
      case 125: /* "%try-module error token" */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).trymod); };
/* Line 1398 of yacc.c  */
#line 5825 "parser.cpp"
        break;
      case 160: /* gvardecl */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).gv); };
/* Line 1398 of yacc.c  */
#line 5832 "parser.cpp"
        break;
      case 161: /* top_namespace_decl */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).ns); };
/* Line 1398 of yacc.c  */
#line 5839 "parser.cpp"
        break;
      case 162: /* namespace_decls */
/* Line 1398 of yacc.c  */
#line 1573 "parser.ypp"
        { if (((*yyvaluep).nsnlist)) ((*yyvaluep).nsnlist)->deref(); };
/* Line 1398 of yacc.c  */
#line 5846 "parser.cpp"
        break;
      case 163: /* namespace_decl */
/* Line 1398 of yacc.c  */
#line 1573 "parser.ypp"
        { if (((*yyvaluep).nsn)) ((*yyvaluep).nsn)->deref(); };
/* Line 1398 of yacc.c  */
#line 5853 "parser.cpp"
        break;
      case 164: /* unscoped_const_decl */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).constnode); };
/* Line 1398 of yacc.c  */
#line 5860 "parser.cpp"
        break;
      case 165: /* scoped_const_decl */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).constnode); };
/* Line 1398 of yacc.c  */
#line 5867 "parser.cpp"
        break;
      case 166: /* block */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).sblock); };
/* Line 1398 of yacc.c  */
#line 5874 "parser.cpp"
        break;
      case 167: /* statement_or_block */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).sblock); };
/* Line 1398 of yacc.c  */
#line 5881 "parser.cpp"
        break;
      case 168: /* statements */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).sblock); };
/* Line 1398 of yacc.c  */
#line 5888 "parser.cpp"
        break;
      case 169: /* optname */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 5895 "parser.cpp"
        break;
      case 170: /* statement */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).statement); };
/* Line 1398 of yacc.c  */
#line 5902 "parser.cpp"
        break;
      case 171: /* context_mods */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).cmods); };
/* Line 1398 of yacc.c  */
#line 5909 "parser.cpp"
        break;
      case 172: /* context_mod */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).cmod); };
/* Line 1398 of yacc.c  */
#line 5916 "parser.cpp"
        break;
      case 173: /* return_statement */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).statement); };
/* Line 1398 of yacc.c  */
#line 5923 "parser.cpp"
        break;
      case 174: /* switch_statement */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).statement); };
/* Line 1398 of yacc.c  */
#line 5930 "parser.cpp"
        break;
      case 175: /* case_block */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).switchstmt); };
/* Line 1398 of yacc.c  */
#line 5937 "parser.cpp"
        break;
      case 176: /* case_code */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).casenode); };
/* Line 1398 of yacc.c  */
#line 5944 "parser.cpp"
        break;
      case 177: /* try_statement */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).statement); };
/* Line 1398 of yacc.c  */
#line 5951 "parser.cpp"
        break;
      case 178: /* myexp */
/* Line 1398 of yacc.c  */
#line 1574 "parser.ypp"
        { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); };
/* Line 1398 of yacc.c  */
#line 5958 "parser.cpp"
        break;
      case 179: /* class_def */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).classdef); };
/* Line 1398 of yacc.c  */
#line 5965 "parser.cpp"
        break;
      case 180: /* inheritance_list */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).sclist); };
/* Line 1398 of yacc.c  */
#line 5972 "parser.cpp"
        break;
      case 181: /* superclass_list */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).sclist); };
/* Line 1398 of yacc.c  */
#line 5979 "parser.cpp"
        break;
      case 182: /* superclass */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).sclnode); };
/* Line 1398 of yacc.c  */
#line 5986 "parser.cpp"
        break;
      case 183: /* class_attributes */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).qoreclass); };
/* Line 1398 of yacc.c  */
#line 5993 "parser.cpp"
        break;
      case 184: /* uncqtypedef */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).parsertype); };
/* Line 1398 of yacc.c  */
#line 6000 "parser.cpp"
        break;
      case 185: /* qtypedef */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).parsertype); };
/* Line 1398 of yacc.c  */
#line 6007 "parser.cpp"
        break;
      case 186: /* private_member_list */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).memberlist); };
/* Line 1398 of yacc.c  */
#line 6014 "parser.cpp"
        break;
      case 187: /* public_member_list */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).memberlist); };
/* Line 1398 of yacc.c  */
#line 6021 "parser.cpp"
        break;
      case 188: /* classvardecl */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).classvarinfo); };
/* Line 1398 of yacc.c  */
#line 6028 "parser.cpp"
        break;
      case 189: /* member2 */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).memberinfo); };
/* Line 1398 of yacc.c  */
#line 6035 "parser.cpp"
        break;
      case 190: /* member */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).memberinfo); };
/* Line 1398 of yacc.c  */
#line 6042 "parser.cpp"
        break;
      case 191: /* member_list */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).memberlist); };
/* Line 1398 of yacc.c  */
#line 6049 "parser.cpp"
        break;
      case 192: /* member_list2 */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).memberlist); };
/* Line 1398 of yacc.c  */
#line 6056 "parser.cpp"
        break;
      case 193: /* ident_openparen */
/* Line 1398 of yacc.c  */
#line 1572 "parser.ypp"
        { free(((*yyvaluep).string)); };
/* Line 1398 of yacc.c  */
#line 6063 "parser.cpp"
        break;
      case 194: /* inline_methoddef */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).methodnode); };
/* Line 1398 of yacc.c  */
#line 6070 "parser.cpp"
        break;
      case 195: /* outofline_methoddef */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).methoddef); };
/* Line 1398 of yacc.c  */
#line 6077 "parser.cpp"
        break;
      case 196: /* base_constructor_list */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).bcalist); };
/* Line 1398 of yacc.c  */
#line 6084 "parser.cpp"
        break;
      case 197: /* base_constructors */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).bcalist); };
/* Line 1398 of yacc.c  */
#line 6091 "parser.cpp"
        break;
      case 198: /* base_constructor */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).bcanode); };
/* Line 1398 of yacc.c  */
#line 6098 "parser.cpp"
        break;
      case 202: /* return_value */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).returnTypeInfo); };
/* Line 1398 of yacc.c  */
#line 6105 "parser.cpp"
        break;
      case 203: /* sub_def */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).parsefunc); };
/* Line 1398 of yacc.c  */
#line 6112 "parser.cpp"
        break;
      case 204: /* scoped_sub_def */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).sparsefunc); };
/* Line 1398 of yacc.c  */
#line 6119 "parser.cpp"
        break;
      case 205: /* list */
/* Line 1398 of yacc.c  */
#line 1574 "parser.ypp"
        { if (((*yyvaluep).list)) ((*yyvaluep).list)->deref(0); };
/* Line 1398 of yacc.c  */
#line 6126 "parser.cpp"
        break;
      case 207: /* hash */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).hash); };
/* Line 1398 of yacc.c  */
#line 6133 "parser.cpp"
        break;
      case 208: /* hash_element */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).hashelement); };
/* Line 1398 of yacc.c  */
#line 6140 "parser.cpp"
        break;
      case 209: /* alt_hash */
/* Line 1398 of yacc.c  */
#line 1571 "parser.ypp"
        { delete ((*yyvaluep).hash); };
/* Line 1398 of yacc.c  */
#line 6147 "parser.cpp"
        break;
      case 210: /* exp_c */
/* Line 1398 of yacc.c  */
#line 1574 "parser.ypp"
        { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); };
/* Line 1398 of yacc.c  */
#line 6154 "parser.cpp"
        break;
      case 211: /* exp */
/* Line 1398 of yacc.c  */
#line 1574 "parser.ypp"
        { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); };
/* Line 1398 of yacc.c  */
#line 6161 "parser.cpp"
        break;
      case 212: /* exp_n */
/* Line 1398 of yacc.c  */
#line 1574 "parser.ypp"
        { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); };
/* Line 1398 of yacc.c  */
#line 6168 "parser.cpp"
        break;
      case 213: /* string */
/* Line 1398 of yacc.c  */
#line 1573 "parser.ypp"
        { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); };
/* Line 1398 of yacc.c  */
#line 6175 "parser.cpp"
        break;
      case 214: /* scalar */
/* Line 1398 of yacc.c  */
#line 1574 "parser.ypp"
        { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(0); };
/* Line 1398 of yacc.c  */
#line 6182 "parser.cpp"
        break;

      default:
        break;
    }
}




/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (yyscan_t yyscanner)
#else
int
yyparse (yyscanner)
    yyscan_t yyscanner;
#endif
#endif
{
/* The lookahead symbol.  */
int yychar;


#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
static YYSTYPE yyval_default;
# define YY_INITIAL_VALUE(Value) = Value
#endif
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval YY_INITIAL_VALUE(yyval_default);

/* Location data for the lookahead symbol.  */
YYLTYPE yylloc = yyloc_default;


    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.
       `yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);

	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
	YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
/* Line 1792 of yacc.c  */
#line 1583 "parser.ypp"
    {
           (yyvsp[(1) - (1)].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 5:
/* Line 1792 of yacc.c  */
#line 1586 "parser.ypp"
    {
           (yyvsp[(1) - (1)].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
    break;

  case 6:
/* Line 1792 of yacc.c  */
#line 1589 "parser.ypp"
    {
           qore_root_ns_private::parseAddClass(*((yyvsp[(1) - (1)].classdef)->name), (yyvsp[(1) - (1)].classdef)->oc);

	   // see if class definitions are allowed
	   if (parse_check_parse_option(PO_NO_CLASS_DEFS))
	      parse_error("illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
	   delete (yyvsp[(1) - (1)].classdef);
	}
    break;

  case 7:
/* Line 1792 of yacc.c  */
#line 1597 "parser.ypp"
    {
           qore_root_ns_private::parseAddConstant(*getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
	   delete (yyvsp[(1) - (1)].constnode);
	}
    break;

  case 8:
/* Line 1792 of yacc.c  */
#line 1601 "parser.ypp"
    {
           qore_root_ns_private::parseAddConstant(*getRootNS(), (yyvsp[(1) - (1)].constnode)->name, (yyvsp[(1) - (1)].constnode)->value, (yyvsp[(1) - (1)].constnode)->pub);
	   delete (yyvsp[(1) - (1)].constnode);
	}
    break;

  case 9:
/* Line 1792 of yacc.c  */
#line 1605 "parser.ypp"
    {
           (yyvsp[(1) - (1)].methoddef)->parseAddToClassAndDel();
        }
    break;

  case 10:
/* Line 1792 of yacc.c  */
#line 1608 "parser.ypp"
    {
	   if ((yyvsp[(1) - (1)].statement)) {
	      if ((yyvsp[(1) - (1)].statement)->isParseDeclaration())
		 delete (yyvsp[(1) - (1)].statement);
	      else
	         qore_program_private::addStatement(*(getProgram()), (yyvsp[(1) - (1)].statement));
	   }
	}
    break;

  case 12:
/* Line 1792 of yacc.c  */
#line 1617 "parser.ypp"
    {
	   // set line range
	   (yyvsp[(2) - (3)].sblock)->loc.start_line = (yylsp[(1) - (3)]).first_line;
	   (yyvsp[(2) - (3)].sblock)->loc.end_line = (yylsp[(2) - (3)]).last_line;
	   qore_program_private::addStatement(*(getProgram()), (yyvsp[(2) - (3)].sblock));
        }
    break;

  case 13:
/* Line 1792 of yacc.c  */
#line 1623 "parser.ypp"
    {
           qore_root_ns_private::parseAddNamespace((yyvsp[(1) - (1)].ns));
	   // see if ns declaration is legal
	   if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
	      parse_error("illegal namespace definition \"%s\" (conflicts with parse option NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
	}
    break;

  case 14:
/* Line 1792 of yacc.c  */
#line 1629 "parser.ypp"
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");

           // registered internally
        }
    break;

  case 15:
/* Line 1792 of yacc.c  */
#line 1636 "parser.ypp"
    {
           bool has_dollar = (yyvsp[(1) - (1)].trymod)->var[0] == '$';
           if (!has_dollar) {
              if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error("%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (1)].trymod)->var);
           }
           else {
              (yyvsp[(1) - (1)].trymod)->fixName();
              if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                 parse_error("%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].trymod)->var);
           }

           if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
              parse_error("'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
              delete (yyvsp[(1) - (1)].trymod);
           }
           else {
              VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].trymod)->takeName());
              QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(left, (yyvsp[(1) - (1)].trymod)->takeExceptionHash());
              qore_program_private::addStatement(*(getProgram()), new ExpressionStatement((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, exp));
           }
        }
    break;

  case 16:
/* Line 1792 of yacc.c  */
#line 1661 "parser.ypp"
    {
        }
    break;

  case 17:
/* Line 1792 of yacc.c  */
#line 1663 "parser.ypp"
    {
        }
    break;

  case 18:
/* Line 1792 of yacc.c  */
#line 1668 "parser.ypp"
    {
           QoreModuleDefContext* qmd = get_module_def_context();
           if (!qmd)
              qore_program_private::makeParseWarning(getProgram(), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[(1) - (4)].string), get_type_name((yyvsp[(3) - (4)].node)));
           else
              qmd->set((yyvsp[(1) - (4)].string), (yyvsp[(3) - (4)].node));

           free((yyvsp[(1) - (4)].string));
           (yyvsp[(3) - (4)].node)->deref(0);
        }
    break;

  case 19:
/* Line 1792 of yacc.c  */
#line 1681 "parser.ypp"
    { (yyval.b) = false; }
    break;

  case 20:
/* Line 1792 of yacc.c  */
#line 1682 "parser.ypp"
    {
           (yyval.b) = true;
        }
    break;

  case 21:
/* Line 1792 of yacc.c  */
#line 1688 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(3) - (4)].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[(4) - (4)].string), t, t ? 0 : (yyvsp[(3) - (4)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (4)].b), true);
           delete (yyvsp[(3) - (4)].parsertype);
	}
    break;

  case 22:
/* Line 1792 of yacc.c  */
#line 1693 "parser.ypp"
    {
           (yyval.gv) = new GVarSingleDecl((yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
        }
    break;

  case 23:
/* Line 1792 of yacc.c  */
#line 1696 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(3) - (4)].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[(4) - (4)].string), t, t ? 0 : (yyvsp[(3) - (4)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (4)].b), true);
           delete (yyvsp[(3) - (4)].parsertype);
	}
    break;

  case 24:
/* Line 1792 of yacc.c  */
#line 1701 "parser.ypp"
    {
           (yyval.gv) = new GVarSingleDecl((yyvsp[(3) - (3)].string), 0, 0, (yyvsp[(1) - (3)].b), true);
	}
    break;

  case 25:
/* Line 1792 of yacc.c  */
#line 1704 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(3) - (4)].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[(4) - (4)].string), t, t ? 0 : (yyvsp[(3) - (4)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (4)].b), false);
           delete (yyvsp[(3) - (4)].parsertype);
	}
    break;

  case 26:
/* Line 1792 of yacc.c  */
#line 1709 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(3) - (4)].parsertype)->getTypeInfo();
           (yyval.gv) = new GVarSingleDecl((yyvsp[(4) - (4)].string), t, t ? 0 : (yyvsp[(3) - (4)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (4)].b), false);
           delete (yyvsp[(3) - (4)].parsertype);
	}
    break;

  case 27:
/* Line 1792 of yacc.c  */
#line 1714 "parser.ypp"
    {
           (yyval.gv) = new GVarListDecl((yyvsp[(4) - (5)].list), (yyvsp[(1) - (5)].b));
        }
    break;

  case 28:
/* Line 1792 of yacc.c  */
#line 1720 "parser.ypp"
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[(1) - (5)].i4), *p);
           (yyvsp[(4) - (5)].nsnlist)->add(*p);
           delete (yyvsp[(4) - (5)].nsnlist);
           (yyval.ns) = p->ns;
        }
    break;

  case 29:
/* Line 1792 of yacc.c  */
#line 1727 "parser.ypp"
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[(1) - (3)].i4), *p);
           (yyval.ns) = p->ns;
        }
    break;

  case 30:
/* Line 1792 of yacc.c  */
#line 1732 "parser.ypp"
    {
           qore_ns_private* p = new qore_ns_private;
           check_nsmod((yyvsp[(1) - (4)].i4), *p);
           (yyval.ns) = p->ns;
        }
    break;

  case 31:
/* Line 1792 of yacc.c  */
#line 1740 "parser.ypp"
    {
	   (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[(1) - (1)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(1) - (1)].nsn));
        }
    break;

  case 32:
/* Line 1792 of yacc.c  */
#line 1745 "parser.ypp"
    {
           (yyval.nsnlist) = (yyvsp[(1) - (2)].nsnlist);
           if ((yyvsp[(2) - (2)].nsn))
              (yyval.nsnlist)->push_back((yyvsp[(2) - (2)].nsn));
	}
    break;

  case 33:
/* Line 1792 of yacc.c  */
#line 1753 "parser.ypp"
    {
	   (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
        }
    break;

  case 34:
/* Line 1792 of yacc.c  */
#line 1756 "parser.ypp"
    {
	   (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].constnode));
	}
    break;

  case 35:
/* Line 1792 of yacc.c  */
#line 1759 "parser.ypp"
    {
	   (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].classdef));
	   // see if class definitions are allowed
	   if (parse_check_parse_option(PO_NO_CLASS_DEFS))
	      parse_error("illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[(1) - (1)].classdef)->oc->getName());
	}
    break;

  case 36:
/* Line 1792 of yacc.c  */
#line 1765 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].parsefunc));
        }
    break;

  case 37:
/* Line 1792 of yacc.c  */
#line 1768 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].sparsefunc));
        }
    break;

  case 38:
/* Line 1792 of yacc.c  */
#line 1771 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (2)].gv));
        }
    break;

  case 39:
/* Line 1792 of yacc.c  */
#line 1774 "parser.ypp"
    {
	   (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].ns));
	   // see if ns declaration is legal
	   if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
	      parse_error("illegal namespace definition \"%s\" (conflicts with parse option NO_NAMESPACE_DEFINITION)", (yyvsp[(1) - (1)].ns)->getName());
	}
    break;

  case 40:
/* Line 1792 of yacc.c  */
#line 1780 "parser.ypp"
    {
           (yyval.nsn) = new NSNode((yyvsp[(1) - (1)].methoddef));
        }
    break;

  case 41:
/* Line 1792 of yacc.c  */
#line 1785 "parser.ypp"
    {
	   (yyval.constnode) = new ConstNode((yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].node));
	}
    break;

  case 42:
/* Line 1792 of yacc.c  */
#line 1788 "parser.ypp"
    {
	   (yyval.constnode) = new ConstNode((yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].node), true);
	}
    break;

  case 43:
/* Line 1792 of yacc.c  */
#line 1794 "parser.ypp"
    {
	   (yyval.constnode) = new ConstNode((yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].node));
	}
    break;

  case 44:
/* Line 1792 of yacc.c  */
#line 1797 "parser.ypp"
    {
	   (yyval.constnode) = new ConstNode((yyvsp[(3) - (6)].string), (yyvsp[(5) - (6)].node), true);
	}
    break;

  case 45:
/* Line 1792 of yacc.c  */
#line 1804 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(2) - (3)].sblock); }
    break;

  case 46:
/* Line 1792 of yacc.c  */
#line 1807 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line); }
    break;

  case 47:
/* Line 1792 of yacc.c  */
#line 1812 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 48:
/* Line 1792 of yacc.c  */
#line 1815 "parser.ypp"
    { (yyval.sblock) = (yyvsp[(1) - (1)].sblock); }
    break;

  case 49:
/* Line 1792 of yacc.c  */
#line 1820 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].statement)); }
    break;

  case 50:
/* Line 1792 of yacc.c  */
#line 1822 "parser.ypp"
    { (yyval.sblock) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line, (yyvsp[(1) - (1)].sblock)); }
    break;

  case 51:
/* Line 1792 of yacc.c  */
#line 1824 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].sblock)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 52:
/* Line 1792 of yacc.c  */
#line 1826 "parser.ypp"
    { (yyvsp[(1) - (2)].sblock)->addStatement((yyvsp[(2) - (2)].statement)); (yyval.sblock) = (yyvsp[(1) - (2)].sblock); }
    break;

  case 53:
/* Line 1792 of yacc.c  */
#line 1831 "parser.ypp"
    { (yyval.string) = 0; }
    break;

  case 54:
/* Line 1792 of yacc.c  */
#line 1832 "parser.ypp"
    { (yyval.string) = (yyvsp[(1) - (1)].string); }
    break;

  case 55:
/* Line 1792 of yacc.c  */
#line 1836 "parser.ypp"
    { (yyval.statement) = new StatementBlock((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line); }
    break;

  case 56:
/* Line 1792 of yacc.c  */
#line 1837 "parser.ypp"
    {
	   // if the expression has no effect and it's not a variable declaration
	   qore_type_t t = (yyvsp[(1) - (2)].node) ? (yyvsp[(1) - (2)].node)->getType() : 0;
	   bool ok = false;
	   if (t == NT_LIST) {
	      QoreListNode* l = reinterpret_cast<QoreListNode*>((yyvsp[(1) - (2)].node));
	      // rewrite expression if it's a list without parentheses under certain conditions
	      (yyvsp[(1) - (2)].node) = checkRewriteList(l);

	      if (l->isVariableList())
		 ok = true;
	   }

	   if (!ok && !node_has_effect((yyvsp[(1) - (2)].node)) && (t != NT_VARREF || !reinterpret_cast<VarRefNode*>((yyvsp[(1) - (2)].node))->parseIsDecl()))
	      parse_error("statement has no effect (%s)", (yyvsp[(1) - (2)].node) ? (yyvsp[(1) - (2)].node)->getTypeName() : "NOTHING");
           ignore_return_value((yyvsp[(1) - (2)].node));
	   (yyval.statement) = new ExpressionStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line, (yyvsp[(1) - (2)].node));
	}
    break;

  case 57:
/* Line 1792 of yacc.c  */
#line 1856 "parser.ypp"
    {
	   NamedScope *ns = new NamedScope((yyvsp[(1) - (5)].string));
	   assert(ns->size() > 1);
	   printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
	   (yyval.statement) = new ExpressionStatement((yylsp[(1) - (5)]).first_line, (yylsp[(1) - (5)]).last_line, new StaticMethodCallNode(ns, make_args((yyvsp[(3) - (5)].node))));
	}
    break;

  case 58:
/* Line 1792 of yacc.c  */
#line 1863 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 59:
/* Line 1792 of yacc.c  */
#line 1864 "parser.ypp"
    {
	   (yyval.statement) = new RethrowStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
	}
    break;

  case 60:
/* Line 1792 of yacc.c  */
#line 1867 "parser.ypp"
    {
	   (yyval.statement) = new ThrowStatement((yylsp[(1) - (3)]).first_line, (yylsp[(2) - (3)]).last_line, (yyvsp[(2) - (3)].node));
	}
    break;

  case 61:
/* Line 1792 of yacc.c  */
#line 1870 "parser.ypp"
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Unconditional);
	}
    break;

  case 62:
/* Line 1792 of yacc.c  */
#line 1873 "parser.ypp"
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Success);
	}
    break;

  case 63:
/* Line 1792 of yacc.c  */
#line 1876 "parser.ypp"
    {
	   (yyval.statement) = new OnBlockExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].sblock), OBE_Error);
	}
    break;

  case 64:
/* Line 1792 of yacc.c  */
#line 1879 "parser.ypp"
    {
	   (yyval.statement) = new ContextStatement((yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, 0, 0, (yyvsp[(2) - (3)].cmods), (yyvsp[(3) - (3)].sblock));
	}
    break;

  case 65:
/* Line 1792 of yacc.c  */
#line 1882 "parser.ypp"
    {
	   (yyval.statement) = new SummarizeStatement((yylsp[(1) - (11)]).first_line, (yylsp[(11) - (11)]).last_line, (yyvsp[(2) - (11)].string), (yyvsp[(4) - (11)].node), (yyvsp[(10) - (11)].cmods), (yyvsp[(11) - (11)].sblock), (yyvsp[(8) - (11)].node));
	}
    break;

  case 66:
/* Line 1792 of yacc.c  */
#line 1885 "parser.ypp"
    {
	   (yyval.statement) = new ContextStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].string), (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].cmods), (yyvsp[(7) - (7)].sblock));
        }
    break;

  case 67:
/* Line 1792 of yacc.c  */
#line 1888 "parser.ypp"
    {
	   (yyval.statement) = new IfStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock));
	}
    break;

  case 68:
/* Line 1792 of yacc.c  */
#line 1891 "parser.ypp"
    {
	   (yyval.statement) = new IfStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].sblock), (yyvsp[(7) - (7)].sblock));
	}
    break;

  case 69:
/* Line 1792 of yacc.c  */
#line 1894 "parser.ypp"
    {
	   (yyval.statement) = new WhileStatement((yylsp[(1) - (5)]).first_line, (yylsp[(5) - (5)]).last_line, (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock));
	}
    break;

  case 70:
/* Line 1792 of yacc.c  */
#line 1897 "parser.ypp"
    {
	   (yyval.statement) = new DoWhileStatement((yylsp[(1) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), (yyvsp[(2) - (7)].sblock));
	}
    break;

  case 71:
/* Line 1792 of yacc.c  */
#line 1900 "parser.ypp"
    {
	   (yyval.statement) = new ForStatement((yylsp[(1) - (9)]).first_line, (yylsp[(9) - (9)]).last_line, (yyvsp[(3) - (9)].node), (yyvsp[(5) - (9)].node), (yyvsp[(7) - (9)].node), (yyvsp[(9) - (9)].sblock));
	}
    break;

  case 72:
/* Line 1792 of yacc.c  */
#line 1903 "parser.ypp"
    {
	   (yyval.statement) = new ForEachStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].node), (yyvsp[(5) - (7)].node), (yyvsp[(7) - (7)].sblock));
	}
    break;

  case 73:
/* Line 1792 of yacc.c  */
#line 1906 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (2)].statement); }
    break;

  case 74:
/* Line 1792 of yacc.c  */
#line 1907 "parser.ypp"
    {
	   // see if thread exit is allowed
	   if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
	      parse_error("illegal use of \"thread_exit\" (conflicts with parse option NO_THREAD_CONTROL)");

	   (yyval.statement) = new ThreadExitStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
	}
    break;

  case 75:
/* Line 1792 of yacc.c  */
#line 1914 "parser.ypp"
    {
	  (yyval.statement) = new BreakStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
	}
    break;

  case 76:
/* Line 1792 of yacc.c  */
#line 1917 "parser.ypp"
    {
	  (yyval.statement) = new ContinueStatement((yylsp[(1) - (2)]).first_line, (yylsp[(1) - (2)]).last_line);
	}
    break;

  case 77:
/* Line 1792 of yacc.c  */
#line 1920 "parser.ypp"
    { (yyval.statement) = (yyvsp[(1) - (1)].statement); }
    break;

  case 78:
/* Line 1792 of yacc.c  */
#line 1921 "parser.ypp"
    { (yyval.statement) = 0; }
    break;

  case 79:
/* Line 1792 of yacc.c  */
#line 1926 "parser.ypp"
    { (yyval.cmods) = 0; }
    break;

  case 80:
/* Line 1792 of yacc.c  */
#line 1927 "parser.ypp"
    {
	   if (!(yyvsp[(1) - (2)].cmods))
	      (yyval.cmods) = new ContextModList((yyvsp[(2) - (2)].cmod));
	   else {
	      (yyvsp[(1) - (2)].cmods)->addContextMod((yyvsp[(2) - (2)].cmod));
	      (yyval.cmods) = (yyvsp[(1) - (2)].cmods);
	   }
	}
    break;

  case 81:
/* Line 1792 of yacc.c  */
#line 1939 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[(3) - (4)].node)); }
    break;

  case 82:
/* Line 1792 of yacc.c  */
#line 1941 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[(3) - (4)].node)); }
    break;

  case 83:
/* Line 1792 of yacc.c  */
#line 1943 "parser.ypp"
    { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[(3) - (4)].node)); }
    break;

  case 84:
/* Line 1792 of yacc.c  */
#line 1947 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line); }
    break;

  case 85:
/* Line 1792 of yacc.c  */
#line 1949 "parser.ypp"
    { (yyval.statement) = new ReturnStatement((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].node)); }
    break;

  case 86:
/* Line 1792 of yacc.c  */
#line 1954 "parser.ypp"
    {
	   (yyvsp[(6) - (7)].switchstmt)->setSwitch((yyvsp[(3) - (7)].node));
	   (yyval.statement) = (yyvsp[(6) - (7)].switchstmt);
	   (yyval.statement)->loc.start_line = (yylsp[(1) - (7)]).first_line;
	   (yyval.statement)->loc.end_line = (yylsp[(7) - (7)]).last_line;
        }
    break;

  case 87:
/* Line 1792 of yacc.c  */
#line 1964 "parser.ypp"
    {
	   (yyval.switchstmt) = new SwitchStatement((yyvsp[(1) - (1)].casenode));
	}
    break;

  case 88:
/* Line 1792 of yacc.c  */
#line 1968 "parser.ypp"
    {
	   (yyvsp[(1) - (2)].switchstmt)->addCase((yyvsp[(2) - (2)].casenode));
	   (yyval.switchstmt) = (yyvsp[(1) - (2)].switchstmt);
        }
    break;

  case 89:
/* Line 1792 of yacc.c  */
#line 1976 "parser.ypp"
    {
	   check_case(">=", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_GE);
        }
    break;

  case 90:
/* Line 1792 of yacc.c  */
#line 1981 "parser.ypp"
    {
	   check_case(">=", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_GE);
        }
    break;

  case 91:
/* Line 1792 of yacc.c  */
#line 1987 "parser.ypp"
    {
	   check_case("<=", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_LE);
        }
    break;

  case 92:
/* Line 1792 of yacc.c  */
#line 1992 "parser.ypp"
    {
	   check_case("<=", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_LE);
        }
    break;

  case 93:
/* Line 1792 of yacc.c  */
#line 1998 "parser.ypp"
    {
	   check_case("==", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_EQ);
        }
    break;

  case 94:
/* Line 1792 of yacc.c  */
#line 2003 "parser.ypp"
    {
	   check_case("==", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_EQ);
        }
    break;

  case 95:
/* Line 1792 of yacc.c  */
#line 2009 "parser.ypp"
    {
	   check_case("<", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_LT);
        }
    break;

  case 96:
/* Line 1792 of yacc.c  */
#line 2014 "parser.ypp"
    {
	   check_case("<", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_LT);
        }
    break;

  case 97:
/* Line 1792 of yacc.c  */
#line 2020 "parser.ypp"
    {
	   check_case(">", (yyvsp[(3) - (5)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].sblock), OP_LOG_GT);
        }
    break;

  case 98:
/* Line 1792 of yacc.c  */
#line 2025 "parser.ypp"
    {
	   check_case(">", (yyvsp[(3) - (4)].node));
	   (yyval.casenode) = new CaseNodeWithOperator((yyvsp[(3) - (4)].node), 0, OP_LOG_GT);
        }
    break;

  case 99:
/* Line 1792 of yacc.c  */
#line 2031 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
	}
    break;

  case 100:
/* Line 1792 of yacc.c  */
#line 2035 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[(3) - (4)].Regex), 0);
	}
    break;

  case 101:
/* Line 1792 of yacc.c  */
#line 2040 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeNegRegex((yyvsp[(3) - (5)].Regex), (yyvsp[(5) - (5)].sblock));
	}
    break;

  case 102:
/* Line 1792 of yacc.c  */
#line 2044 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeNegRegex((yyvsp[(3) - (4)].Regex), 0);
	}
    break;

  case 103:
/* Line 1792 of yacc.c  */
#line 2049 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[(2) - (4)].Regex), (yyvsp[(4) - (4)].sblock));
	}
    break;

  case 104:
/* Line 1792 of yacc.c  */
#line 2053 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNodeRegex((yyvsp[(2) - (3)].Regex), 0);
	}
    break;

  case 105:
/* Line 1792 of yacc.c  */
#line 2058 "parser.ypp"
    {
	   check_case(0, (yyvsp[(2) - (4)].node));
	   (yyval.casenode) = new CaseNode((yyvsp[(2) - (4)].node), (yyvsp[(4) - (4)].sblock));
	}
    break;

  case 106:
/* Line 1792 of yacc.c  */
#line 2063 "parser.ypp"
    {
	   check_case(0, (yyvsp[(2) - (3)].node));
	   (yyval.casenode) = new CaseNode((yyvsp[(2) - (3)].node), 0);
	}
    break;

  case 107:
/* Line 1792 of yacc.c  */
#line 2069 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNode(0, (yyvsp[(3) - (3)].sblock));
	}
    break;

  case 108:
/* Line 1792 of yacc.c  */
#line 2073 "parser.ypp"
    {
	   (yyval.casenode) = new CaseNode(0, 0);
	}
    break;

  case 109:
/* Line 1792 of yacc.c  */
#line 2079 "parser.ypp"
    {
           char* param = 0;
           const QoreTypeInfo *typeInfo = 0;
           if ((yyvsp[(5) - (7)].node)) {
              if ((yyvsp[(5) - (7)].node)->getType() == NT_VARREF) {
                 VarRefNode *varRefNode = static_cast<VarRefNode*>((yyvsp[(5) - (7)].node));
                 param = varRefNode->takeName();
                 if (varRefNode->isDecl()) {
                    VarRefDeclNode *varRefDeclNode = static_cast<VarRefDeclNode*>(varRefNode);
                    if (varRefDeclNode->getParseTypeInfo() || varRefDeclNode->getTypeInfo()->parseAccepts(hashTypeInfo) == QTI_NOT_EQUAL) {
                       parse_error("the type of catch parameter '%s' must be 'hash'", param);
                    }
                    typeInfo = varRefDeclNode->getTypeInfo();
                 }
              } else if ((yyvsp[(5) - (7)].node)->getType() == NT_BAREWORD) {
                 param = reinterpret_cast<BarewordNode*>((yyvsp[(5) - (7)].node))->takeString();
                 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error("local variable '%s' in catch parameter list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", param);
              } else
                 parse_error("only one parameter accepted in catch block for exception hash");
           (yyvsp[(5) - (7)].node)->deref(0);
           }
           (yyval.statement) = new TryStatement((yylsp[(1) - (7)]).first_line, (yylsp[(7) - (7)]).last_line, (yyvsp[(2) - (7)].sblock), (yyvsp[(7) - (7)].sblock), param, typeInfo);
        }
    break;

  case 110:
/* Line 1792 of yacc.c  */
#line 2105 "parser.ypp"
    { (yyval.node) = 0; }
    break;

  case 111:
/* Line 1792 of yacc.c  */
#line 2106 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].node); }
    break;

  case 112:
/* Line 1792 of yacc.c  */
#line 2107 "parser.ypp"
    { (yyval.node) = 0; }
    break;

  case 113:
/* Line 1792 of yacc.c  */
#line 2111 "parser.ypp"
    {
           check_classmod((yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
           qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (6)].string), (yyvsp[(5) - (6)].qoreclass));
	}
    break;

  case 114:
/* Line 1792 of yacc.c  */
#line 2116 "parser.ypp"
    {
           check_classmod((yyvsp[(1) - (6)].i4), *((yyvsp[(5) - (6)].qoreclass)));
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (6)].nscope), (yyvsp[(5) - (6)].qoreclass));
           qore_class_private::parseSetBaseClassList(*((yyvsp[(5) - (6)].qoreclass)), (yyvsp[(3) - (6)].sclist));
	}
    break;

  case 115:
/* Line 1792 of yacc.c  */
#line 2121 "parser.ypp"
    {
           // class name is set automatically from name saved in scanner
	   QoreClass* qc = new QoreClass;
           check_classmod((yyvsp[(1) - (4)].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (4)].string), qc);
	}
    break;

  case 116:
/* Line 1792 of yacc.c  */
#line 2128 "parser.ypp"
    {
           // class name is set automatically from name saved in scanner
	   QoreClass* qc = new QoreClass;
           check_classmod((yyvsp[(1) - (4)].i4), *qc);
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (4)].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (4)].sclist));
	}
    break;

  case 117:
/* Line 1792 of yacc.c  */
#line 2135 "parser.ypp"
    {
           // class name is set automatically from name saved in scanner
	   QoreClass* qc = new QoreClass;
           check_classmod((yyvsp[(1) - (5)].i4), *qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (5)].string), qc);
	}
    break;

  case 118:
/* Line 1792 of yacc.c  */
#line 2142 "parser.ypp"
    {
           // class name is set automatically from name saved in scanner
	   QoreClass* qc = new QoreClass;
           check_classmod((yyvsp[(1) - (5)].i4), *qc);
	   (yyval.classdef) = new ObjClassDef((yyvsp[(2) - (5)].nscope), qc);
           qore_class_private::parseSetBaseClassList(*qc, (yyvsp[(3) - (5)].sclist));
	}
    break;

  case 119:
/* Line 1792 of yacc.c  */
#line 2152 "parser.ypp"
    {
	   (yyval.sclist) = (yyvsp[(2) - (2)].sclist);
        }
    break;

  case 120:
/* Line 1792 of yacc.c  */
#line 2155 "parser.ypp"
    { // NOTHING
           (yyval.sclist) = 0;
	}
    break;

  case 121:
/* Line 1792 of yacc.c  */
#line 2161 "parser.ypp"
    {
	   (yyval.sclist) = new BCList((yyvsp[(1) - (1)].sclnode));
	}
    break;

  case 122:
/* Line 1792 of yacc.c  */
#line 2164 "parser.ypp"
    {
	   (yyvsp[(1) - (3)].sclist)->push_back((yyvsp[(3) - (3)].sclnode));
	   (yyval.sclist) = (yyvsp[(1) - (3)].sclist);
        }
    break;

  case 123:
/* Line 1792 of yacc.c  */
#line 2171 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode((yyvsp[(1) - (1)].string), false);
	}
    break;

  case 124:
/* Line 1792 of yacc.c  */
#line 2174 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[(1) - (1)].string)), false);
	}
    break;

  case 125:
/* Line 1792 of yacc.c  */
#line 2177 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode((yyvsp[(2) - (2)].string), false);
	}
    break;

  case 126:
/* Line 1792 of yacc.c  */
#line 2180 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[(2) - (2)].string)), false);
	}
    break;

  case 127:
/* Line 1792 of yacc.c  */
#line 2183 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode((yyvsp[(2) - (2)].string), true);
	}
    break;

  case 128:
/* Line 1792 of yacc.c  */
#line 2186 "parser.ypp"
    {
	   (yyval.sclnode) = new BCNode(new NamedScope((yyvsp[(2) - (2)].string)), true);
	}
    break;

  case 129:
/* Line 1792 of yacc.c  */
#line 2192 "parser.ypp"
    {
           (yyval.qoreclass) = new QoreClass;
	   (yyvsp[(1) - (1)].methodnode)->addAndDelete((yyval.qoreclass));
	}
    break;

  case 130:
/* Line 1792 of yacc.c  */
#line 2196 "parser.ypp"
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyvsp[(1) - (1)].memberlist)->mergePrivate((yyval.qoreclass));
	   delete (yyvsp[(1) - (1)].memberlist);
	}
    break;

  case 131:
/* Line 1792 of yacc.c  */
#line 2201 "parser.ypp"
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyvsp[(1) - (1)].memberlist)->mergePublic((yyval.qoreclass));
	   delete (yyvsp[(1) - (1)].memberlist);
	}
    break;

  case 132:
/* Line 1792 of yacc.c  */
#line 2206 "parser.ypp"
    {
	   (yyval.qoreclass) = new QoreClass;
	   (yyval.qoreclass)->parseAddPublicConstant((yyvsp[(1) - (1)].constnode)->getName(), (yyvsp[(1) - (1)].constnode)->takeValue());
	   delete (yyvsp[(1) - (1)].constnode);
	}
    break;

  case 133:
/* Line 1792 of yacc.c  */
#line 2211 "parser.ypp"
    {
	   (yyvsp[(2) - (2)].methodnode)->addAndDelete((yyvsp[(1) - (2)].qoreclass));
	   (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
	}
    break;

  case 134:
/* Line 1792 of yacc.c  */
#line 2215 "parser.ypp"
    {
	   (yyvsp[(2) - (2)].memberlist)->mergePrivate((yyvsp[(1) - (2)].qoreclass));
	   (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
	   delete (yyvsp[(2) - (2)].memberlist);
	}
    break;

  case 135:
/* Line 1792 of yacc.c  */
#line 2220 "parser.ypp"
    {
	   (yyvsp[(2) - (2)].memberlist)->mergePublic((yyvsp[(1) - (2)].qoreclass));
	   (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
	   delete (yyvsp[(2) - (2)].memberlist);
	}
    break;

  case 136:
/* Line 1792 of yacc.c  */
#line 2225 "parser.ypp"
    {
	   (yyval.qoreclass)->parseAddPublicConstant((yyvsp[(2) - (2)].constnode)->getName(), (yyvsp[(2) - (2)].constnode)->takeValue());
	   (yyval.qoreclass) = (yyvsp[(1) - (2)].qoreclass);
	   delete (yyvsp[(2) - (2)].constnode);
	}
    break;

  case 137:
/* Line 1792 of yacc.c  */
#line 2233 "parser.ypp"
    {
	   (yyval.parsertype) = new ParserTypeStruct((yyvsp[(1) - (1)].string));
	}
    break;

  case 138:
/* Line 1792 of yacc.c  */
#line 2236 "parser.ypp"
    {
	   (yyval.parsertype) = new ParserScopedTypeStruct((yyvsp[(1) - (1)].string));
        }
    break;

  case 139:
/* Line 1792 of yacc.c  */
#line 2239 "parser.ypp"
    {
	   (yyval.parsertype) = new ParserOrNothingTypeStruct((yyvsp[(2) - (2)].string));
        }
    break;

  case 140:
/* Line 1792 of yacc.c  */
#line 2242 "parser.ypp"
    {
	   (yyval.parsertype) = new ParserScopedOrNothingTypeStruct((yyvsp[(2) - (2)].string));
        }
    break;

  case 141:
/* Line 1792 of yacc.c  */
#line 2249 "parser.ypp"
    { (yyval.parsertype) = 0; }
    break;

  case 142:
/* Line 1792 of yacc.c  */
#line 2250 "parser.ypp"
    {
           (yyval.parsertype) = (yyvsp[(1) - (1)].parsertype);
        }
    break;

  case 143:
/* Line 1792 of yacc.c  */
#line 2256 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 144:
/* Line 1792 of yacc.c  */
#line 2257 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 145:
/* Line 1792 of yacc.c  */
#line 2258 "parser.ypp"
    { (yyval.memberlist) = new EmptyPrivateMemberList; }
    break;

  case 146:
/* Line 1792 of yacc.c  */
#line 2262 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(2) - (3)].memberlist); }
    break;

  case 147:
/* Line 1792 of yacc.c  */
#line 2263 "parser.ypp"
    { (yyval.memberlist) = (yyvsp[(3) - (4)].memberlist); }
    break;

  case 148:
/* Line 1792 of yacc.c  */
#line 2264 "parser.ypp"
    { (yyval.memberlist) = new EmptyPublicMemberList; }
    break;

  case 149:
/* Line 1792 of yacc.c  */
#line 2268 "parser.ypp"
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (4)].string), new QoreVarInfo((yylsp[(2) - (4)]).first_line, (yylsp[(3) - (4)]).last_line, (yyvsp[(2) - (4)].parsertype)->getTypeInfo(), (yyvsp[(2) - (4)].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[(2) - (4)].parsertype);
	}
    break;

  case 150:
/* Line 1792 of yacc.c  */
#line 2272 "parser.ypp"
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (3)].string), new QoreVarInfo((yylsp[(2) - (3)]).first_line, (yylsp[(2) - (3)]).last_line));
	}
    break;

  case 151:
/* Line 1792 of yacc.c  */
#line 2275 "parser.ypp"
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (6)].string), new QoreVarInfo((yylsp[(2) - (6)]).first_line, (yylsp[(5) - (6)]).last_line, (yyvsp[(2) - (6)].parsertype)->getTypeInfo(), (yyvsp[(2) - (6)].parsertype)->getParseTypeInfo(), (yyvsp[(5) - (6)].node)));
	   //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
	   delete (yyvsp[(2) - (6)].parsertype);
        }
    break;

  case 152:
/* Line 1792 of yacc.c  */
#line 2280 "parser.ypp"
    {
	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(2) - (5)].string), new QoreVarInfo((yylsp[(2) - (5)]).first_line, (yylsp[(4) - (5)]).last_line, (yyvsp[(4) - (5)].node)));
	}
    break;

  case 153:
/* Line 1792 of yacc.c  */
#line 2283 "parser.ypp"
    {
	   const QoreTypeInfo* t = (yyvsp[(2) - (7)].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[(2) - (7)].parsertype)->getClassName())), make_args((yyvsp[(5) - (7)].node)));

	   (yyval.classvarinfo) = new ClassVarInfo((yyvsp[(3) - (7)].string), new QoreVarInfo((yylsp[(2) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(2) - (7)].parsertype)->getTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[(2) - (7)].parsertype);
	}
    break;

  case 154:
/* Line 1792 of yacc.c  */
#line 2298 "parser.ypp"
    {
	   int fl = (yyvsp[(1) - (3)].parsertype) ? (yylsp[(1) - (3)]).first_line : (yylsp[(2) - (3)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(fl, (yylsp[(2) - (3)]).last_line, (yyvsp[(1) - (3)].parsertype)->getTypeInfo(), (yyvsp[(1) - (3)].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[(1) - (3)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (3)].string));
	}
    break;

  case 155:
/* Line 1792 of yacc.c  */
#line 2305 "parser.ypp"
    {
	   int fl = (yyvsp[(1) - (5)].parsertype) ? (yylsp[(1) - (5)]).first_line : (yylsp[(2) - (5)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(fl, (yylsp[(4) - (5)]).last_line, (yyvsp[(1) - (5)].parsertype)->getTypeInfo(), (yyvsp[(1) - (5)].parsertype)->getParseTypeInfo(), (yyvsp[(4) - (5)].node)));
	   delete (yyvsp[(1) - (5)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (5)].string));
	}
    break;

  case 156:
/* Line 1792 of yacc.c  */
#line 2312 "parser.ypp"
    {
	   int fl = (yyvsp[(1) - (6)].parsertype) ? (yylsp[(1) - (6)]).first_line : (yylsp[(2) - (6)]).first_line;
	   const QoreTypeInfo* t = (yyvsp[(1) - (6)].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (!(yyvsp[(1) - (6)].parsertype))
	      parse_error("cannot call constructor without declaring the class");
	   else if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[(1) - (6)].parsertype)->getClassName())), make_args((yyvsp[(4) - (6)].node)));

	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(fl, (yylsp[(4) - (6)]).last_line, (yyvsp[(1) - (6)].parsertype)->getTypeInfo(), (yyvsp[(1) - (6)].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[(1) - (6)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (6)].string));
	}
    break;

  case 157:
/* Line 1792 of yacc.c  */
#line 2330 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (3)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (3)].string), new QoreMemberInfo(fl, (yylsp[(2) - (3)]).last_line, (yyvsp[(1) - (3)].parsertype)->getTypeInfo(), (yyvsp[(1) - (3)].parsertype)->getParseTypeInfo()));
	   delete (yyvsp[(1) - (3)].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (3)].string));
	}
    break;

  case 158:
/* Line 1792 of yacc.c  */
#line 2337 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (5)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (5)].string), new QoreMemberInfo(fl, (yylsp[(4) - (5)]).last_line, (yyvsp[(1) - (5)].parsertype)->getTypeInfo(), (yyvsp[(1) - (5)].parsertype)->getParseTypeInfo(), (yyvsp[(4) - (5)].node)));
	   delete (yyvsp[(1) - (5)].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (5)].string));
	}
    break;

  case 159:
/* Line 1792 of yacc.c  */
#line 2344 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (6)]).first_line;
	   const QoreTypeInfo* t = (yyvsp[(1) - (6)].parsertype)->getTypeInfo();
	   ScopedObjectCallNode* new_call = 0;

	   if (!(yyvsp[(1) - (6)].parsertype))
	      parse_error("cannot call constructor without declaring the class");
	   else if (t)
	      parse_error("cannot call constructor for non-class base type '%s'", t->getName());
	   else
	      new_call = new ScopedObjectCallNode(new NamedScope(strdup((yyvsp[(1) - (6)].parsertype)->getClassName())), make_args((yyvsp[(4) - (6)].node)));

	   (yyval.memberinfo) = new MemberInfo((yyvsp[(2) - (6)].string), new QoreMemberInfo(fl, (yylsp[(4) - (6)]).last_line, (yyvsp[(1) - (6)].parsertype)->getTypeInfo(), (yyvsp[(1) - (6)].parsertype)->getParseTypeInfo(), new_call));

	   delete (yyvsp[(1) - (6)].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (6)].string));
	}
    break;

  case 160:
/* Line 1792 of yacc.c  */
#line 2362 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (2)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo(fl, (yylsp[(1) - (2)]).last_line));
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (2)].string));
	}
    break;

  case 161:
/* Line 1792 of yacc.c  */
#line 2368 "parser.ypp"
    {
	   int fl = (yylsp[(1) - (4)]).first_line;
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (4)].string), new QoreMemberInfo(fl, (yylsp[(3) - (4)]).last_line, (yyvsp[(3) - (4)].node)));
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(1) - (4)].string));
	}
    break;

  case 162:
/* Line 1792 of yacc.c  */
#line 2374 "parser.ypp"
    {
	   (yyval.memberinfo) = (yyvsp[(1) - (1)].classvarinfo);
	}
    break;

  case 163:
/* Line 1792 of yacc.c  */
#line 2377 "parser.ypp"
    {
           if ((yyvsp[(1) - (1)].constnode)->pub)
              parse_error("cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[(1) - (1)].constnode)->name.ostr);
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (1)].constnode)->name.takeName(), (yyvsp[(1) - (1)].constnode)->value);
	   delete (yyvsp[(1) - (1)].constnode);
        }
    break;

  case 164:
/* Line 1792 of yacc.c  */
#line 2386 "parser.ypp"
    {
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (1)].string), new QoreMemberInfo((yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line));
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
        }
    break;

  case 165:
/* Line 1792 of yacc.c  */
#line 2391 "parser.ypp"
    {
	   (yyval.memberinfo) = new MemberInfo((yyvsp[(1) - (2)].string), new QoreMemberInfo((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].string)));
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (2)].string));
	}
    break;

  case 166:
/* Line 1792 of yacc.c  */
#line 2399 "parser.ypp"
    {
	   (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 167:
/* Line 1792 of yacc.c  */
#line 2402 "parser.ypp"
    {
	   (yyvsp[(1) - (3)].memberlist)->add((yyvsp[(3) - (3)].memberinfo));
	   (yyval.memberlist) = (yyvsp[(1) - (3)].memberlist);
	}
    break;

  case 168:
/* Line 1792 of yacc.c  */
#line 2409 "parser.ypp"
    {
	   (yyval.memberlist) = new MemberList((yyvsp[(1) - (1)].memberinfo));
        }
    break;

  case 169:
/* Line 1792 of yacc.c  */
#line 2412 "parser.ypp"
    {
	   (yyvsp[(1) - (2)].memberlist)->add((yyvsp[(2) - (2)].memberinfo));
	   (yyval.memberlist) = (yyvsp[(1) - (2)].memberlist);
	}
    break;

  case 170:
/* Line 1792 of yacc.c  */
#line 2419 "parser.ypp"
    {
	   (yyval.string) = (yyvsp[(1) - (2)].string);
        }
    break;

  case 171:
/* Line 1792 of yacc.c  */
#line 2422 "parser.ypp"
    {
           (yyval.string) = strdup("keys");
        }
    break;

  case 172:
/* Line 1792 of yacc.c  */
#line 2425 "parser.ypp"
    {
	   (yyval.string) = (yyvsp[(1) - (1)].string);
        }
    break;

  case 173:
/* Line 1792 of yacc.c  */
#line 2431 "parser.ypp"
    {
           if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(7) - (7)].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   checkMethod((yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
	   (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), newMethodVariant((yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock)), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
	}
    break;

  case 174:
/* Line 1792 of yacc.c  */
#line 2441 "parser.ypp"
    {
           if ((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(7) - (7)].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (7)].parsertype);

	   checkMethod((yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

	   (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), newMethodVariant((yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock)), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
	}
    break;

  case 175:
/* Line 1792 of yacc.c  */
#line 2455 "parser.ypp"
    {
           if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           checkMethod((yyvsp[(2) - (7)].string), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo));
           (yyval.methodnode) = new MethodNode((yyvsp[(2) - (7)].string), newMethodVariant((yyvsp[(2) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), 0), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 176:
/* Line 1792 of yacc.c  */
#line 2461 "parser.ypp"
    {
           if (!((yyvsp[(1) - (7)].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getTypeInfo());
           delete (yyvsp[(2) - (7)].parsertype);

           checkMethod((yyvsp[(3) - (7)].string), (yyvsp[(6) - (7)].bcalist), rt);

           (yyval.methodnode) = new MethodNode((yyvsp[(3) - (7)].string), newMethodVariant((yyvsp[(3) - (7)].string), (yyvsp[(1) - (7)].i4), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].bcalist), rt, 0), (yyvsp[(1) - (7)].i4) & OFM_STATIC);
        }
    break;

  case 177:
/* Line 1792 of yacc.c  */
#line 2474 "parser.ypp"
    {
           if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(8) - (8)].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }

           (yyval.methoddef) = new MethodDef((yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].node), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(8) - (8)].sblock));
	}
    break;

  case 178:
/* Line 1792 of yacc.c  */
#line 2484 "parser.ypp"
    {
           if ((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT) {
              if ((yyvsp[(8) - (8)].sblock))
                 parse_error("'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
              else
                 parse_error("'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
           }
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (8)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (8)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (8)].parsertype);

	   (yyval.methoddef) = new MethodDef((yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].node), (yyvsp[(7) - (8)].bcalist), rt, (yyvsp[(8) - (8)].sblock));
	}
    break;

  case 179:
/* Line 1792 of yacc.c  */
#line 2496 "parser.ypp"
    {
           if (!((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           (yyval.methoddef) = new MethodDef((yyvsp[(1) - (8)].i4), (yyvsp[(2) - (8)].string), (yylsp[(4) - (8)]).first_line, (yylsp[(4) - (8)]).last_line, (yyvsp[(4) - (8)].node), (yyvsp[(6) - (8)].bcalist), (yyvsp[(7) - (8)].returnTypeInfo), 0);
        }
    break;

  case 180:
/* Line 1792 of yacc.c  */
#line 2501 "parser.ypp"
    {
           if (!((yyvsp[(1) - (8)].i4) & OFM_ABSTRACT))
              parse_error("non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
           RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (8)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (8)].parsertype)->getTypeInfo());
           delete (yyvsp[(2) - (8)].parsertype);

           (yyval.methoddef) = new MethodDef((yyvsp[(1) - (8)].i4), (yyvsp[(3) - (8)].string), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].node), (yyvsp[(7) - (8)].bcalist), rt, 0);
        }
    break;

  case 181:
/* Line 1792 of yacc.c  */
#line 2509 "parser.ypp"
    {
	   (yyval.methoddef) = new MethodDef(0, (yyvsp[(1) - (7)].string), (yylsp[(3) - (7)]).first_line, (yylsp[(3) - (7)]).last_line, (yyvsp[(3) - (7)].node), (yyvsp[(5) - (7)].bcalist), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(7) - (7)].sblock));
	}
    break;

  case 182:
/* Line 1792 of yacc.c  */
#line 2512 "parser.ypp"
    {
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(1) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(1) - (7)].parsertype);

	   (yyval.methoddef) = new MethodDef(0, (yyvsp[(2) - (7)].string), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].bcalist), rt, (yyvsp[(7) - (7)].sblock));
	}
    break;

  case 183:
/* Line 1792 of yacc.c  */
#line 2521 "parser.ypp"
    {
	   (yyval.bcalist) = (yyvsp[(2) - (2)].bcalist);
	}
    break;

  case 184:
/* Line 1792 of yacc.c  */
#line 2524 "parser.ypp"
    { // nothing
	   (yyval.bcalist) = 0;
	}
    break;

  case 185:
/* Line 1792 of yacc.c  */
#line 2530 "parser.ypp"
    {
	   (yyval.bcalist) = new BCAList((yyvsp[(1) - (1)].bcanode));
	}
    break;

  case 186:
/* Line 1792 of yacc.c  */
#line 2533 "parser.ypp"
    {
	   (yyvsp[(1) - (3)].bcalist)->push_back((yyvsp[(3) - (3)].bcanode));
	   (yyval.bcalist) = (yyvsp[(1) - (3)].bcalist);
	}
    break;

  case 187:
/* Line 1792 of yacc.c  */
#line 2540 "parser.ypp"
    {
	   (yyval.bcanode) = new BCANode((yyvsp[(1) - (4)].string), make_args((yyvsp[(3) - (4)].node)));
	}
    break;

  case 188:
/* Line 1792 of yacc.c  */
#line 2543 "parser.ypp"
    {
	   (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[(1) - (4)].string)), make_args((yyvsp[(3) - (4)].node)));
	}
    break;

  case 189:
/* Line 1792 of yacc.c  */
#line 2550 "parser.ypp"
    { (yyval.i4) = 0; }
    break;

  case 190:
/* Line 1792 of yacc.c  */
#line 2551 "parser.ypp"
    {
           (yyval.i4) = (yyvsp[(1) - (1)].i4);
        }
    break;

  case 191:
/* Line 1792 of yacc.c  */
#line 2556 "parser.ypp"
    { (yyval.i4) = (yyvsp[(1) - (1)].i4); }
    break;

  case 192:
/* Line 1792 of yacc.c  */
#line 2557 "parser.ypp"
    {
	   if (((yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4)) == (yyvsp[(1) - (2)].i4))
	      parse_error("modifier given twice");
	   (yyval.i4) = (yyvsp[(1) - (2)].i4) | (yyvsp[(2) - (2)].i4);
	}
    break;

  case 193:
/* Line 1792 of yacc.c  */
#line 2565 "parser.ypp"
    { (yyval.i4) = OFM_PRIVATE; }
    break;

  case 194:
/* Line 1792 of yacc.c  */
#line 2566 "parser.ypp"
    { (yyval.i4) = OFM_STATIC; }
    break;

  case 195:
/* Line 1792 of yacc.c  */
#line 2567 "parser.ypp"
    { (yyval.i4) = OFM_SYNCED; }
    break;

  case 196:
/* Line 1792 of yacc.c  */
#line 2568 "parser.ypp"
    { (yyval.i4) = OFM_DEPRECATED; }
    break;

  case 197:
/* Line 1792 of yacc.c  */
#line 2569 "parser.ypp"
    { (yyval.i4) = OFM_PUBLIC; }
    break;

  case 198:
/* Line 1792 of yacc.c  */
#line 2570 "parser.ypp"
    { (yyval.i4) = OFM_FINAL; }
    break;

  case 199:
/* Line 1792 of yacc.c  */
#line 2571 "parser.ypp"
    { (yyval.i4) = OFM_ABSTRACT; }
    break;

  case 200:
/* Line 1792 of yacc.c  */
#line 2575 "parser.ypp"
    {
	   if (!(yyvsp[(2) - (2)].parsertype)) {
	      parse_error("missing type declaration after 'returns'");
	      (yyval.returnTypeInfo) = 0;
	   }
	   else {
	      (yyval.returnTypeInfo) = new RetTypeInfo((yyvsp[(2) - (2)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (2)].parsertype)->getTypeInfo());
	      delete (yyvsp[(2) - (2)].parsertype);
	   }
	}
    break;

  case 201:
/* Line 1792 of yacc.c  */
#line 2586 "parser.ypp"
    {
	   (yyval.returnTypeInfo) = 0;
	}
    break;

  case 202:
/* Line 1792 of yacc.c  */
#line 2591 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.parsefunc) = new ParseUserFunction((yyvsp[(2) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].node), (yyvsp[(5) - (6)].returnTypeInfo), false, flags));
	}
    break;

  case 203:
/* Line 1792 of yacc.c  */
#line 2596 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(1) - (6)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (6)].parsertype)->getTypeInfo());
	   delete (yyvsp[(1) - (6)].parsertype);

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[(3) - (6)].string), new UserFunctionVariant((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].node), rt, false, flags));
	}
    break;

  case 204:
/* Line 1792 of yacc.c  */
#line 2605 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (7)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags));
           if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
	}
    break;

  case 205:
/* Line 1792 of yacc.c  */
#line 2616 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (7)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (7)].parsertype);

	   (yyval.parsefunc) = new ParseUserFunction((yyvsp[(4) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), rt, (yyvsp[(1) - (7)].i4) & OFM_SYNCED, flags));
           if ((yyvsp[(1) - (7)].i4) & OFM_PUBLIC)
              (yyval.parsefunc)->setPublic();
	}
    break;

  case 206:
/* Line 1792 of yacc.c  */
#line 2632 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
           (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[(2) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].returnTypeInfo), false, flags));
	}
    break;

  case 207:
/* Line 1792 of yacc.c  */
#line 2637 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(1) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(1) - (7)].parsertype);

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[(3) - (7)].string), new UserFunctionVariant((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), rt, false, flags));
	}
    break;

  case 208:
/* Line 1792 of yacc.c  */
#line 2646 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (8)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[(3) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(5) - (8)]).first_line, (yylsp[(5) - (8)]).last_line, (yyvsp[(5) - (8)].node), (yyvsp[(7) - (8)].returnTypeInfo), (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags));
           if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
	}
    break;

  case 209:
/* Line 1792 of yacc.c  */
#line 2657 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (8)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (8)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (8)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (8)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (8)].parsertype);

	   (yyval.sparsefunc) = new ParseScopedUserFunction((yyvsp[(4) - (8)].string), new UserFunctionVariant((yyvsp[(8) - (8)].sblock), (yylsp[(6) - (8)]).first_line, (yylsp[(6) - (8)]).last_line, (yyvsp[(6) - (8)].node), rt, (yyvsp[(1) - (8)].i4) & OFM_SYNCED, flags));
           if ((yyvsp[(1) - (8)].i4) & OFM_PUBLIC)
              (yyval.sparsefunc)->setPublic();
	}
    break;

  case 210:
/* Line 1792 of yacc.c  */
#line 2675 "parser.ypp"
    { (yyval.list) = splice_expressions((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 211:
/* Line 1792 of yacc.c  */
#line 2676 "parser.ypp"
    {
	   QoreListNode* l;
	   if ((yyvsp[(1) - (2)].node) && (yyvsp[(1) - (2)].node)->getType() == NT_LIST) {
	      l = reinterpret_cast<QoreListNode*>((yyvsp[(1) - (2)].node));
              if (l->isFinalized()) {
                 QoreListNode* nl = new QoreListNode;
                 nl->push(l);
                 l = nl;
              }
           }
	   else {
	      l = new QoreListNode;
	      l->push((yyvsp[(1) - (2)].node));
	      // parse_error("problem in parsing ',' in list: left side of comma is not a list (type: '%s')", $1 ? $1->getTypeName() : "NOTHING");
	      // so we don't insert null values in the parse tree
	   }
	   (yyval.list) = l;
        }
    break;

  case 212:
/* Line 1792 of yacc.c  */
#line 2698 "parser.ypp"
    { (yyval.list) = splice_expressions((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 213:
/* Line 1792 of yacc.c  */
#line 2699 "parser.ypp"
    {
       QoreListNode* l;
       if ((yyvsp[(1) - (2)].node) && (yyvsp[(1) - (2)].node)->getType() == NT_LIST)
          l = reinterpret_cast<QoreListNode*>((yyvsp[(1) - (2)].node));
       else {
          l = new QoreListNode;
          l->push((yyvsp[(1) - (2)].node));
          // parse_error("problem in parsing ',' in list: left side of comma is not a list (type: '%s')", $1 ? $1->getTypeName() : "NOTHING");
          // so we don't insert null values in the parse tree
       }
       (yyval.list) = l;
        }
    break;

  case 214:
/* Line 1792 of yacc.c  */
#line 2714 "parser.ypp"
    {
	   (yyval.hash) = new QoreParseHashNode;
           (yyvsp[(1) - (1)].hashelement)->addDelete((yyval.hash));
	}
    break;

  case 215:
/* Line 1792 of yacc.c  */
#line 2718 "parser.ypp"
    {
           (yyvsp[(3) - (3)].hashelement)->addDelete((yyvsp[(1) - (3)].hash));
	   (yyval.hash) = (yyvsp[(1) - (3)].hash);
	}
    break;

  case 216:
/* Line 1792 of yacc.c  */
#line 2723 "parser.ypp"
    { /* empty ',' on end of hash */ (yyval.hash) = (yyvsp[(1) - (2)].hash); }
    break;

  case 217:
/* Line 1792 of yacc.c  */
#line 2728 "parser.ypp"
    { (yyval.hashelement) = new HashElement((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node), (yylsp[(1) - (3)]).first_line, (yylsp[(3) - (3)]).last_line); }
    break;

  case 218:
/* Line 1792 of yacc.c  */
#line 2732 "parser.ypp"
    {
           // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
           (yyvsp[(2) - (3)].hash)->setCurly();
           (yyval.hash) = (yyvsp[(2) - (3)].hash);
        }
    break;

  case 219:
/* Line 1792 of yacc.c  */
#line 2739 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].node); }
    break;

  case 220:
/* Line 1792 of yacc.c  */
#line 2741 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].binary); }
    break;

  case 221:
/* Line 1792 of yacc.c  */
#line 2743 "parser.ypp"
    { (yyval.node) = (yyvsp[(2) - (3)].hash); }
    break;

  case 222:
/* Line 1792 of yacc.c  */
#line 2745 "parser.ypp"
    { (yyval.node) = new ScopedRefNode((yyvsp[(1) - (1)].string)); }
    break;

  case 223:
/* Line 1792 of yacc.c  */
#line 2746 "parser.ypp"
    {
	   if (!(yyvsp[(1) - (2)].parsertype) && !strcmp((yyvsp[(2) - (2)].string), "argv"))
	      inc_argv_ref();

	   if ((yyvsp[(1) - (2)].parsertype))
	      (yyval.node) = new VarRefDeclNode((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].string), get_var_type(), (yyvsp[(1) - (2)].parsertype)->getTypeInfo(), (yyvsp[(1) - (2)].parsertype)->getParseTypeInfo());
	   else
	      (yyval.node) = new VarRefNode((yyvsp[(2) - (2)].string), get_var_type());

	   delete (yyvsp[(1) - (2)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
	}
    break;

  case 224:
/* Line 1792 of yacc.c  */
#line 2759 "parser.ypp"
    {
	   if (!(yyvsp[(1) - (2)].parsertype) && !strcmp((yyvsp[(2) - (2)].string), "argv"))
	      inc_argv_ref();

	   if ((yyvsp[(1) - (2)].parsertype))
	      (yyval.node) = new VarRefDeclNode((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].string), get_var_type(), (yyvsp[(1) - (2)].parsertype)->getTypeInfo(), (yyvsp[(1) - (2)].parsertype)->getParseTypeInfo());
	   else
	      (yyval.node) = new VarRefNode((yyvsp[(2) - (2)].string), get_var_type());

	   delete (yyvsp[(1) - (2)].parsertype);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(2) - (2)].string));
	}
    break;

  case 225:
/* Line 1792 of yacc.c  */
#line 2772 "parser.ypp"
    {
	   (yyval.node) = new VarRefDeclNode((yylsp[(1) - (2)]).first_line, (yylsp[(2) - (2)]).last_line, (yyvsp[(2) - (2)].string), get_var_type(), (yyvsp[(1) - (2)].parsertype)->getTypeInfo(), (yyvsp[(1) - (2)].parsertype)->getParseTypeInfo());
	   delete (yyvsp[(1) - (2)].parsertype);
	}
    break;

  case 226:
/* Line 1792 of yacc.c  */
#line 2776 "parser.ypp"
    {
	   VarRefDeclNode* v = new VarRefDeclNode((yylsp[(2) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(3) - (3)].string), VT_LOCAL, (yyvsp[(2) - (3)].parsertype)->getTypeInfo(), (yyvsp[(2) - (3)].parsertype)->getParseTypeInfo());
	   v->setExplicitScope();
	   (yyval.node) = v;
	   delete (yyvsp[(2) - (3)].parsertype);
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(3) - (3)].string));
	}
    break;

  case 227:
/* Line 1792 of yacc.c  */
#line 2784 "parser.ypp"
    {
	   // see if types are required
	   if (parse_check_parse_option(PO_REQUIRE_TYPES))
	      parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(2) - (2)].string));
	   VarRefNode* v = new VarRefNode((yyvsp[(2) - (2)].string), VT_LOCAL);
	   v->setExplicitScope();
	   (yyval.node) = v;
	   if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[(2) - (2)].string));
	}
    break;

  case 228:
/* Line 1792 of yacc.c  */
#line 2794 "parser.ypp"
    {
	   VarRefNode* v;
	   if ((yyvsp[(2) - (3)].parsertype)) {
	      v = new VarRefDeclNode((yylsp[(3) - (3)]).first_line, (yylsp[(3) - (3)]).last_line, (yyvsp[(3) - (3)].string), VT_LOCAL, (yyvsp[(2) - (3)].parsertype)->getTypeInfo(), (yyvsp[(2) - (3)].parsertype)->getParseTypeInfo());
	      delete (yyvsp[(2) - (3)].parsertype);
	   }
	   else {
	      // see if types are required
	      if (parse_check_parse_option(PO_REQUIRE_TYPES))
		 parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[(3) - (3)].string));
	      v = new VarRefNode((yyvsp[(3) - (3)].string), VT_LOCAL);
	   }
	   v->setExplicitScope();
	   (yyval.node) = v;
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(3) - (3)].string));
	}
    break;

  case 229:
/* Line 1792 of yacc.c  */
#line 2811 "parser.ypp"
    {
	   (yyvsp[(3) - (4)].list)->setVariableList();
	   ListIterator li((yyvsp[(3) - (4)].list));
	   while (li.next()) {
	      AbstractQoreNode* n = li.getValue();
	      qore_type_t t = get_node_type(n);
	      if (t == NT_BAREWORD) {
		 BarewordNode* b = reinterpret_cast<BarewordNode*>(n);
		 if (parse_check_parse_option(PO_REQUIRE_TYPES))
		    parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
		 if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
		    parse_error("local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
		 VarRefNode* v = new VarRefNode(b->takeString(), VT_LOCAL);
		 v->setExplicitScope();
		 b->deref();
		 AbstractQoreNode** p = li.getValuePtr();
		 *p = v;
	      }
	      else if (t == NT_VARREF) {
		 VarRefNode* v = reinterpret_cast<VarRefNode*>(n);
		 // see if types are required
		 if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
		    parse_error("local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
		 if (v->explicitScope()) {
		    if (v->getType() == VT_LOCAL)
		       parse_error("illegal use of 'my %s' in local variable declaration list", v->getName());
		    else if (v->getType() == VT_GLOBAL)
		       parse_error("illegal use of 'our %s' in local variable declaration list", v->getName());
		 }
		 else
		    v->makeLocal();
		 v->setExplicitScope();
	      }
	      else
		 parse_error("element %d in list following 'my' is not a variable reference (%s)", li.index(), get_type_name(n));
	   }
	   (yyval.node) = (yyvsp[(3) - (4)].list);
        }
    break;

  case 230:
/* Line 1792 of yacc.c  */
#line 2849 "parser.ypp"
    {
           (yyval.node) = (yyvsp[(1) - (1)].gv)->makeVar();
        }
    break;

  case 231:
/* Line 1792 of yacc.c  */
#line 2853 "parser.ypp"
    {
	   if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[(1) - (1)].string), "argv"))
	      inc_argv_ref();

	   (yyval.node) = new BarewordNode((yyvsp[(1) - (1)].string), (yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
	}
    break;

  case 232:
/* Line 1792 of yacc.c  */
#line 2860 "parser.ypp"
    { (yyval.node) = new ContextrefNode((yyvsp[(1) - (1)].string)); }
    break;

  case 233:
/* Line 1792 of yacc.c  */
#line 2862 "parser.ypp"
    { (yyval.node) = new ContextRowNode; }
    break;

  case 234:
/* Line 1792 of yacc.c  */
#line 2864 "parser.ypp"
    { (yyval.node) = new ComplexContextrefNode((yyvsp[(1) - (1)].string)); }
    break;

  case 235:
/* Line 1792 of yacc.c  */
#line 2866 "parser.ypp"
    { (yyval.node) = new FindNode((yyvsp[(2) - (8)].node), (yyvsp[(4) - (8)].node), (yyvsp[(7) - (8)].node)); }
    break;

  case 236:
/* Line 1792 of yacc.c  */
#line 2868 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_EXISTS, 0); }
    break;

  case 237:
/* Line 1792 of yacc.c  */
#line 2870 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_ELEMENTS, 0); }
    break;

  case 238:
/* Line 1792 of yacc.c  */
#line 2872 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_KEYS, 0); }
    break;

  case 239:
/* Line 1792 of yacc.c  */
#line 2873 "parser.ypp"
    {  // unshift list, element
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].node)->getTypeName());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreTreeNode(lv, OP_UNSHIFT, l->shift());
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 240:
/* Line 1792 of yacc.c  */
#line 2885 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_SHIFT, 0);
	}
    break;

  case 241:
/* Line 1792 of yacc.c  */
#line 2888 "parser.ypp"
    {  // push lvalue-list, element
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[(2) - (2)].node)->getTypeName());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreTreeNode(lv, OP_PUSH, l->shift());
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 242:
/* Line 1792 of yacc.c  */
#line 2900 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_POP, 0);
	}
    break;

  case 243:
/* Line 1792 of yacc.c  */
#line 2903 "parser.ypp"
    {
           (yyval.node) = new QoreChompOperatorNode((yyvsp[(2) - (2)].node));
	}
    break;

  case 244:
/* Line 1792 of yacc.c  */
#line 2906 "parser.ypp"
    {
           (yyval.node) = new QoreTrimOperatorNode((yyvsp[(2) - (2)].node));
	}
    break;

  case 245:
/* Line 1792 of yacc.c  */
#line 2909 "parser.ypp"
    {  // splice lvalue-list, offset, [length, list]
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l) {
	      parse_error("invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else if (l->size() < 2) {
	      parse_error("too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else if (l->size() > 4) {
	      parse_error("too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreSpliceOperatorNode(lv, l->shift(), l->shift(), l->shift());
	      discard(l, 0);
	   }
	}
    break;

  case 246:
/* Line 1792 of yacc.c  */
#line 2929 "parser.ypp"
    {  // extract lvalue-list, offset, [length, list]
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l) {
	      parse_error("invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else if (l->size() < 2) {
	      parse_error("too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else if (l->size() > 4) {
	      parse_error("too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* lv = l->shift();
	      (yyval.node) = new QoreExtractOperatorNode(lv, l->shift(), l->shift(), l->shift());
	      discard(l, 0);
	   }
	}
    break;

  case 247:
/* Line 1792 of yacc.c  */
#line 2949 "parser.ypp"
    {
	   pop_ignore_numeric_argv_ref();
           QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   int len = l ? (int)l->size() : 0;
           if (!l || len < 2 || len > 3) {
	      parse_error("invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
           }
           else {
              // get first expression from list
              AbstractQoreNode* exp = l->shift();
              qore_type_t t = get_node_type(exp);
              (yyval.node) = 0;
              if (t == NT_PARSE_HASH) {
                 QoreParseHashNode* phn = reinterpret_cast<QoreParseHashNode*>(exp);
                 if (phn->isCurly())
                    (yyval.node) = parse_hash_map(phn, l);
              }

              if (!(yyval.node))
                 (yyval.node) = parse_map(exp, l);
           }
        }
    break;

  case 248:
/* Line 1792 of yacc.c  */
#line 2972 "parser.ypp"
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* code_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(code_exp, OP_FOLDR, arg);
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 249:
/* Line 1792 of yacc.c  */
#line 2986 "parser.ypp"
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* code_exp = l->shift();
	      AbstractQoreNode* arg = l->shift();
	      (yyval.node) = new QoreTreeNode(code_exp, OP_FOLDL, arg);
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 250:
/* Line 1792 of yacc.c  */
#line 3000 "parser.ypp"
    {
	   pop_ignore_numeric_argv_ref();
	   QoreListNode* l = (yyvsp[(2) - (2)].node) && (yyvsp[(2) - (2)].node)->getType() == NT_LIST ? reinterpret_cast<QoreListNode*>((yyvsp[(2) - (2)].node)) : 0;
	   if (!l || l->size() != 2) {
	      parse_error("invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", get_type_name((yyvsp[(2) - (2)].node)));
	      (yyval.node) = makeErrorTree((yyvsp[(2) - (2)].node), 0);
	   }
	   else {
	      AbstractQoreNode* arg = l->shift();
	      AbstractQoreNode* select_exp = l->shift();
	      (yyval.node) = new QoreTreeNode(arg, OP_SELECT, select_exp);
	      (yyvsp[(2) - (2)].node)->deref(0);
	   }
	}
    break;

  case 251:
/* Line 1792 of yacc.c  */
#line 3014 "parser.ypp"
    {  // pre-increment
           (yyval.node) = new QorePreIncrementOperatorNode((yyvsp[(2) - (2)].node));
        }
    break;

  case 252:
/* Line 1792 of yacc.c  */
#line 3017 "parser.ypp"
    {  // pre-decrement
           (yyval.node) = new QorePreDecrementOperatorNode((yyvsp[(2) - (2)].node));
        }
    break;

  case 253:
/* Line 1792 of yacc.c  */
#line 3020 "parser.ypp"
    {
	   printd(5, "parsing in-object base class method call %s()\n", (yyvsp[(1) - (4)].nscope)->ostr);
	   if (!strcmp((yyvsp[(1) - (4)].nscope)->getIdentifier(), "copy"))
	      parse_error("illegal call to base class copy method '%s'", (yyvsp[(1) - (4)].nscope)->ostr);

	   (yyval.node) = new SelfFunctionCallNode((yyvsp[(1) - (4)].nscope), make_args((yyvsp[(3) - (4)].node)));
	}
    break;

  case 254:
/* Line 1792 of yacc.c  */
#line 3027 "parser.ypp"
    {
	   printd(5, "parsing call %s()\n", (yyvsp[(1) - (3)].string));
	   (yyval.node) = new FunctionCallNode((yyvsp[(1) - (3)].string), make_args((yyvsp[(2) - (3)].node)));
        }
    break;

  case 255:
/* Line 1792 of yacc.c  */
#line 3032 "parser.ypp"
    {
	   (yyval.node) = new SelfVarrefNode((yyvsp[(1) - (1)].string), (yylsp[(1) - (1)]).first_line, (yylsp[(1) - (1)]).last_line);
	   if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
	      parse_error("reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[(1) - (1)].string));
	}
    break;

  case 256:
/* Line 1792 of yacc.c  */
#line 3037 "parser.ypp"
    {
	   // FIXME: need to expand constant expression checking to determine
	   //        if the expression can throw an exception at run-time
	   // first check for constant expressions
	   (yyval.node) = QoreUnaryMinusOperatorNode::makeNode((yyvsp[(2) - (2)].node));
	}
    break;

  case 257:
/* Line 1792 of yacc.c  */
#line 3044 "parser.ypp"
    {
            (yyval.node) = QoreUnaryMinusOperatorNode::makeNode(QoreUnaryMinusOperatorNode::makeNode((yyvsp[(2) - (2)].node)));
        }
    break;

  case 258:
/* Line 1792 of yacc.c  */
#line 3047 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_BIN_NOT, 0); }
    break;

  case 259:
/* Line 1792 of yacc.c  */
#line 3048 "parser.ypp"
    { (yyval.node) = new QoreLogicalNotOperatorNode((yyvsp[(2) - (2)].node)); }
    break;

  case 260:
/* Line 1792 of yacc.c  */
#line 3049 "parser.ypp"
    {
	   qore_type_t t = (yyvsp[(2) - (2)].node) ? (yyvsp[(2) - (2)].node)->getType() : 0;
	   //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2->getTypeName());

	   if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
	      (yyval.node) = reinterpret_cast<FunctionCallNode*>((yyvsp[(2) - (2)].node))->makeReferenceNodeAndDeref();
	   }
	   else if (t == NT_SELF_CALL) {
	      (yyval.node) = reinterpret_cast<SelfFunctionCallNode*>((yyvsp[(2) - (2)].node))->makeReferenceNodeAndDeref();
	   }
	   else if (t == NT_STATIC_METHOD_CALL) {
	      (yyval.node) = reinterpret_cast<StaticMethodCallNode*>((yyvsp[(2) - (2)].node))->makeReferenceNodeAndDeref();
	   }
	   else {
	      bool make_ref = true;

	      if (t == NT_OPERATOR) {
                 QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[(2) - (2)].node));
                 if (deon) {
                    (yyval.node) = deon->makeCallReference();
                    make_ref = false;
                 }
	      }

	      if (make_ref) {
		 //printd(5, "type=%s\n", $2->getTypeName());
		 (yyval.node) = new ParseReferenceNode((yyvsp[(2) - (2)].node));
	      }
	   }
	}
    break;

  case 261:
/* Line 1792 of yacc.c  */
#line 3079 "parser.ypp"
    {
	   (yyval.node) = new ScopedObjectCallNode(new NamedScope((yyvsp[(2) - (5)].string)), make_args((yyvsp[(4) - (5)].node)));
	   if (parse_check_parse_option(PO_NO_NEW))
	      parse_error("illegal use of the 'new' operator (conflicts with parse option NO_NEW)");
        }
    break;

  case 262:
/* Line 1792 of yacc.c  */
#line 3084 "parser.ypp"
    {
	   (yyval.node) = new ScopedObjectCallNode(new NamedScope((yyvsp[(2) - (5)].string)), make_args((yyvsp[(4) - (5)].node)));
	   if (parse_check_parse_option(PO_NO_NEW))
	      parse_error("illegal use of the 'new' operator (conflicts with parse option NO_NEW)");
        }
    break;

  case 263:
/* Line 1792 of yacc.c  */
#line 3089 "parser.ypp"
    {
	   (yyval.node) = new QoreTreeNode((yyvsp[(2) - (2)].node), OP_BACKGROUND, 0);
	   // check to see if the expression is legal
	   if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
	      parse_error("illegal use of \"background\" operator (conflicts with parse option NO_THREAD_CONTROL)");
	   else if (!node_has_effect((yyvsp[(2) - (2)].node)))
	      parse_error("argument to background operator (%s) has no effect", get_type_name((yyvsp[(2) - (2)].node)));
	}
    break;

  case 264:
/* Line 1792 of yacc.c  */
#line 3097 "parser.ypp"
    {
	   (yyval.node) = new BackquoteNode((yyvsp[(1) - (1)].string));
	   if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
	      parse_error("illegal use of backquote operator (conflicts with parse option NO_EXTERNAL_PROCESS)");
	}
    break;

  case 265:
/* Line 1792 of yacc.c  */
#line 3102 "parser.ypp"
    {
	   (yyval.node) = (yyvsp[(2) - (3)].node);
	   if ((yyvsp[(2) - (3)].node)) {
              switch ((yyvsp[(2) - (3)].node)->getType()) {
                 case NT_LIST:
                    reinterpret_cast<QoreListNode*>((yyvsp[(2) - (3)].node))->setFinalized();
                    break;
                 case NT_FUNCTION_CALL:
                    reinterpret_cast<FunctionCallNode*>((yyvsp[(2) - (3)].node))->setFinalized();
                    break;
                 case NT_BAREWORD:
                    reinterpret_cast<BarewordNode*>((yyvsp[(2) - (3)].node))->setFinalized();
                    break;
              }
           }
	}
    break;

  case 266:
/* Line 1792 of yacc.c  */
#line 3118 "parser.ypp"
    { QoreListNode* l = new QoreListNode; l->setFinalized(); (yyval.node) = l; }
    break;

  case 267:
/* Line 1792 of yacc.c  */
#line 3119 "parser.ypp"
    {
	   int ar = get_pop_argv_ref();
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(3) - (6)]).first_line, (yylsp[(3) - (6)]).last_line, (yyvsp[(3) - (6)].node), (yyvsp[(5) - (6)].returnTypeInfo), false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
	}
    break;

  case 268:
/* Line 1792 of yacc.c  */
#line 3123 "parser.ypp"
    {
	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(1) - (6)].parsertype)->getParseTypeInfo(), (yyvsp[(1) - (6)].parsertype)->getTypeInfo());
	   delete (yyvsp[(1) - (6)].parsertype);

	   int ar = get_pop_argv_ref();
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[(6) - (6)].sblock), (yylsp[(4) - (6)]).first_line, (yylsp[(4) - (6)]).last_line, (yyvsp[(4) - (6)].node), rt, false, ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS));
	}
    break;

  case 269:
/* Line 1792 of yacc.c  */
#line 3130 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (7)].i4));
	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(4) - (7)]).first_line, (yylsp[(4) - (7)]).last_line, (yyvsp[(4) - (7)].node), (yyvsp[(6) - (7)].returnTypeInfo), (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags));
	}
    break;

  case 270:
/* Line 1792 of yacc.c  */
#line 3138 "parser.ypp"
    {
	   check_funcmod((yyvsp[(1) - (7)].i4));

	   RetTypeInfo* rt = new RetTypeInfo((yyvsp[(2) - (7)].parsertype)->getParseTypeInfo(), (yyvsp[(2) - (7)].parsertype)->getTypeInfo());
	   delete (yyvsp[(2) - (7)].parsertype);

	   int ar = get_pop_argv_ref();
	   int64 flags = ar > 0 ? QC_USES_EXTRA_ARGS : QC_NO_FLAGS;
	   if ((yyvsp[(1) - (7)].i4) & OFM_DEPRECATED)
	      flags |= QC_DEPRECATED;
	   (yyval.node) = new QoreClosureParseNode(new UserClosureFunction((yyvsp[(7) - (7)].sblock), (yylsp[(5) - (7)]).first_line, (yylsp[(5) - (7)]).last_line, (yyvsp[(5) - (7)].node), rt, (yyvsp[(1) - (7)].i4) | OFM_SYNCED, flags));
	}
    break;

  case 271:
/* Line 1792 of yacc.c  */
#line 3150 "parser.ypp"
    {
	   (yyval.node) = (yyvsp[(1) - (1)].implicit_arg);
	   inc_numeric_argv_ref();
	}
    break;

  case 272:
/* Line 1792 of yacc.c  */
#line 3154 "parser.ypp"
    {
	   (yyval.node) = new QoreImplicitElementNode;
	}
    break;

  case 273:
/* Line 1792 of yacc.c  */
#line 3157 "parser.ypp"
    {
	   (yyval.node) = new QoreDeleteOperatorNode((yyvsp[(2) - (2)].node));
	}
    break;

  case 274:
/* Line 1792 of yacc.c  */
#line 3160 "parser.ypp"
    {
	   (yyval.node) = new QoreRemoveOperatorNode((yyvsp[(2) - (2)].node));
	}
    break;

  case 275:
/* Line 1792 of yacc.c  */
#line 3163 "parser.ypp"
    {
           (yyval.node) = new QoreCastOperatorNode((yyvsp[(1) - (4)].string), (yyvsp[(3) - (4)].node));
	}
    break;

  case 277:
/* Line 1792 of yacc.c  */
#line 3170 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].list); }
    break;

  case 278:
/* Line 1792 of yacc.c  */
#line 3171 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].hash); }
    break;

  case 279:
/* Line 1792 of yacc.c  */
#line 3172 "parser.ypp"
    { (yyval.node) = new QoreParseHashNode(true); }
    break;

  case 280:
/* Line 1792 of yacc.c  */
#line 3173 "parser.ypp"
    { (yyval.node) = new QorePlusEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 281:
/* Line 1792 of yacc.c  */
#line 3174 "parser.ypp"
    { (yyval.node) = new QoreMinusEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 282:
/* Line 1792 of yacc.c  */
#line 3175 "parser.ypp"
    { (yyval.node) = new QoreAndEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 283:
/* Line 1792 of yacc.c  */
#line 3176 "parser.ypp"
    { (yyval.node) = new QoreOrEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 284:
/* Line 1792 of yacc.c  */
#line 3177 "parser.ypp"
    { (yyval.node) = new QoreModuloEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 285:
/* Line 1792 of yacc.c  */
#line 3178 "parser.ypp"
    { (yyval.node) = new QoreMultiplyEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 286:
/* Line 1792 of yacc.c  */
#line 3179 "parser.ypp"
    { (yyval.node) = new QoreDivideEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 287:
/* Line 1792 of yacc.c  */
#line 3180 "parser.ypp"
    { (yyval.node) = new QoreXorEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 288:
/* Line 1792 of yacc.c  */
#line 3181 "parser.ypp"
    { (yyval.node) = new QoreShiftLeftEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 289:
/* Line 1792 of yacc.c  */
#line 3182 "parser.ypp"
    { (yyval.node) = new QoreShiftRightEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 290:
/* Line 1792 of yacc.c  */
#line 3183 "parser.ypp"
    { (yyval.node) = processAssignment((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 291:
/* Line 1792 of yacc.c  */
#line 3184 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[(3) - (3)].string))); }
    break;

  case 292:
/* Line 1792 of yacc.c  */
#line 3185 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[(3) - (3)].string))); }
    break;

  case 293:
/* Line 1792 of yacc.c  */
#line 3186 "parser.ypp"
    { (yyval.node) = new QoreNullCoalescingOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 294:
/* Line 1792 of yacc.c  */
#line 3187 "parser.ypp"
    { (yyval.node) = new QoreValueCoalescingOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 295:
/* Line 1792 of yacc.c  */
#line 3188 "parser.ypp"
    { (yyval.node) = new QoreQuestionMarkOperatorNode((yyvsp[(1) - (5)].node), (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].node)); }
    break;

  case 296:
/* Line 1792 of yacc.c  */
#line 3189 "parser.ypp"
    { (yyval.node) = new QorePostIncrementOperatorNode((yyvsp[(1) - (2)].node)); }
    break;

  case 297:
/* Line 1792 of yacc.c  */
#line 3190 "parser.ypp"
    { (yyval.node) = new QorePostDecrementOperatorNode((yyvsp[(1) - (2)].node)); }
    break;

  case 298:
/* Line 1792 of yacc.c  */
#line 3191 "parser.ypp"
    { (yyval.node) = processCall((yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node)); }
    break;

  case 299:
/* Line 1792 of yacc.c  */
#line 3192 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_AND, (yyvsp[(3) - (3)].node)); }
    break;

  case 300:
/* Line 1792 of yacc.c  */
#line 3193 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 301:
/* Line 1792 of yacc.c  */
#line 3194 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 302:
/* Line 1792 of yacc.c  */
#line 3195 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 303:
/* Line 1792 of yacc.c  */
#line 3196 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_XOR, (yyvsp[(3) - (3)].node)); }
    break;

  case 304:
/* Line 1792 of yacc.c  */
#line 3197 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 305:
/* Line 1792 of yacc.c  */
#line 3198 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_AND, (yyvsp[(3) - (3)].node)); }
    break;

  case 306:
/* Line 1792 of yacc.c  */
#line 3199 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_XOR, (yyvsp[(3) - (3)].node)); }
    break;

  case 307:
/* Line 1792 of yacc.c  */
#line 3200 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_MATCH, (yyvsp[(3) - (3)].Regex)); }
    break;

  case 308:
/* Line 1792 of yacc.c  */
#line 3201 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_NMATCH, (yyvsp[(3) - (3)].Regex)); }
    break;

  case 309:
/* Line 1792 of yacc.c  */
#line 3202 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_SUBST, (yyvsp[(3) - (3)].RegexSubst)); }
    break;

  case 310:
/* Line 1792 of yacc.c  */
#line 3203 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_TRANS, (yyvsp[(3) - (3)].RegexTrans)); }
    break;

  case 311:
/* Line 1792 of yacc.c  */
#line 3204 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_EXTRACT, (yyvsp[(3) - (3)].Regex)); }
    break;

  case 312:
/* Line 1792 of yacc.c  */
#line 3205 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 313:
/* Line 1792 of yacc.c  */
#line 3206 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 314:
/* Line 1792 of yacc.c  */
#line 3207 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_CMP, (yyvsp[(3) - (3)].node)); }
    break;

  case 315:
/* Line 1792 of yacc.c  */
#line 3208 "parser.ypp"
    { (yyval.node) = new QoreLogicalEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 316:
/* Line 1792 of yacc.c  */
#line 3209 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_ABSOLUTE_EQ, (yyvsp[(3) - (3)].node)); }
    break;

  case 317:
/* Line 1792 of yacc.c  */
#line 3210 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_ABSOLUTE_NE, (yyvsp[(3) - (3)].node)); }
    break;

  case 318:
/* Line 1792 of yacc.c  */
#line 3211 "parser.ypp"
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 319:
/* Line 1792 of yacc.c  */
#line 3212 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 320:
/* Line 1792 of yacc.c  */
#line 3213 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 321:
/* Line 1792 of yacc.c  */
#line 3214 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_SHIFT_LEFT, (yyvsp[(3) - (3)].node)); }
    break;

  case 322:
/* Line 1792 of yacc.c  */
#line 3215 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_SHIFT_RIGHT, (yyvsp[(3) - (3)].node)); }
    break;

  case 323:
/* Line 1792 of yacc.c  */
#line 3216 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_PLUS, (yyvsp[(3) - (3)].node)); }
    break;

  case 324:
/* Line 1792 of yacc.c  */
#line 3217 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_MINUS, (yyvsp[(3) - (3)].node)); }
    break;

  case 325:
/* Line 1792 of yacc.c  */
#line 3218 "parser.ypp"
    { (yyval.node) = new QoreModuloOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 326:
/* Line 1792 of yacc.c  */
#line 3219 "parser.ypp"
    { (yyval.node) = new QoreDivisionOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 327:
/* Line 1792 of yacc.c  */
#line 3220 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_MULT, (yyvsp[(3) - (3)].node)); }
    break;

  case 328:
/* Line 1792 of yacc.c  */
#line 3221 "parser.ypp"
    { (yyval.node) = new QoreSquareBracketsOperatorNode((yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node)); }
    break;

  case 329:
/* Line 1792 of yacc.c  */
#line 3222 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (4)].node), OP_OBJECT_REF, (yyvsp[(3) - (4)].node)); }
    break;

  case 330:
/* Line 1792 of yacc.c  */
#line 3223 "parser.ypp"
    { (yyval.node) = process_dot((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 331:
/* Line 1792 of yacc.c  */
#line 3224 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (2)].node), OP_OBJECT_REF, (yyvsp[(2) - (2)].String)); }
    break;

  case 333:
/* Line 1792 of yacc.c  */
#line 3229 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].list); }
    break;

  case 334:
/* Line 1792 of yacc.c  */
#line 3230 "parser.ypp"
    { (yyval.node) = new QorePlusEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 335:
/* Line 1792 of yacc.c  */
#line 3231 "parser.ypp"
    { (yyval.node) = new QoreMinusEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 336:
/* Line 1792 of yacc.c  */
#line 3232 "parser.ypp"
    { (yyval.node) = new QoreAndEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 337:
/* Line 1792 of yacc.c  */
#line 3233 "parser.ypp"
    { (yyval.node) = new QoreOrEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 338:
/* Line 1792 of yacc.c  */
#line 3234 "parser.ypp"
    { (yyval.node) = new QoreModuloEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 339:
/* Line 1792 of yacc.c  */
#line 3235 "parser.ypp"
    { (yyval.node) = new QoreMultiplyEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 340:
/* Line 1792 of yacc.c  */
#line 3236 "parser.ypp"
    { (yyval.node) = new QoreDivideEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 341:
/* Line 1792 of yacc.c  */
#line 3237 "parser.ypp"
    { (yyval.node) = new QoreXorEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 342:
/* Line 1792 of yacc.c  */
#line 3238 "parser.ypp"
    { (yyval.node) = new QoreShiftLeftEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 343:
/* Line 1792 of yacc.c  */
#line 3239 "parser.ypp"
    { (yyval.node) = new QoreShiftRightEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 344:
/* Line 1792 of yacc.c  */
#line 3240 "parser.ypp"
    { (yyval.node) = processAssignment((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 345:
/* Line 1792 of yacc.c  */
#line 3241 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[(3) - (3)].string))); }
    break;

  case 346:
/* Line 1792 of yacc.c  */
#line 3242 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_INSTANCEOF, new ClassRefNode((yyvsp[(3) - (3)].string))); }
    break;

  case 347:
/* Line 1792 of yacc.c  */
#line 3243 "parser.ypp"
    { (yyval.node) = new QoreNullCoalescingOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 348:
/* Line 1792 of yacc.c  */
#line 3244 "parser.ypp"
    { (yyval.node) = new QoreValueCoalescingOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 349:
/* Line 1792 of yacc.c  */
#line 3245 "parser.ypp"
    { (yyval.node) = new QoreQuestionMarkOperatorNode((yyvsp[(1) - (5)].node), (yyvsp[(3) - (5)].node), (yyvsp[(5) - (5)].node)); }
    break;

  case 350:
/* Line 1792 of yacc.c  */
#line 3246 "parser.ypp"
    { (yyval.node) = new QorePostIncrementOperatorNode((yyvsp[(1) - (2)].node)); }
    break;

  case 351:
/* Line 1792 of yacc.c  */
#line 3247 "parser.ypp"
    { (yyval.node) = new QorePostDecrementOperatorNode((yyvsp[(1) - (2)].node)); }
    break;

  case 352:
/* Line 1792 of yacc.c  */
#line 3248 "parser.ypp"
    { (yyval.node) = processCall((yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node)); }
    break;

  case 353:
/* Line 1792 of yacc.c  */
#line 3249 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_AND, (yyvsp[(3) - (3)].node)); }
    break;

  case 354:
/* Line 1792 of yacc.c  */
#line 3250 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 355:
/* Line 1792 of yacc.c  */
#line 3251 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 356:
/* Line 1792 of yacc.c  */
#line 3252 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 357:
/* Line 1792 of yacc.c  */
#line 3253 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_XOR, (yyvsp[(3) - (3)].node)); }
    break;

  case 358:
/* Line 1792 of yacc.c  */
#line 3254 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_OR, (yyvsp[(3) - (3)].node)); }
    break;

  case 359:
/* Line 1792 of yacc.c  */
#line 3255 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_AND, (yyvsp[(3) - (3)].node)); }
    break;

  case 360:
/* Line 1792 of yacc.c  */
#line 3256 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_BIN_XOR, (yyvsp[(3) - (3)].node)); }
    break;

  case 361:
/* Line 1792 of yacc.c  */
#line 3257 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_MATCH, (yyvsp[(3) - (3)].Regex)); }
    break;

  case 362:
/* Line 1792 of yacc.c  */
#line 3258 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_NMATCH, (yyvsp[(3) - (3)].Regex)); }
    break;

  case 363:
/* Line 1792 of yacc.c  */
#line 3259 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_SUBST, (yyvsp[(3) - (3)].RegexSubst)); }
    break;

  case 364:
/* Line 1792 of yacc.c  */
#line 3260 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_TRANS, (yyvsp[(3) - (3)].RegexTrans)); }
    break;

  case 365:
/* Line 1792 of yacc.c  */
#line 3261 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_REGEX_EXTRACT, (yyvsp[(3) - (3)].Regex)); }
    break;

  case 366:
/* Line 1792 of yacc.c  */
#line 3262 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 367:
/* Line 1792 of yacc.c  */
#line 3263 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 368:
/* Line 1792 of yacc.c  */
#line 3264 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_LOG_CMP, (yyvsp[(3) - (3)].node)); }
    break;

  case 369:
/* Line 1792 of yacc.c  */
#line 3265 "parser.ypp"
    { (yyval.node) = new QoreLogicalEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 370:
/* Line 1792 of yacc.c  */
#line 3266 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_ABSOLUTE_EQ, (yyvsp[(3) - (3)].node)); }
    break;

  case 371:
/* Line 1792 of yacc.c  */
#line 3267 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_ABSOLUTE_NE, (yyvsp[(3) - (3)].node)); }
    break;

  case 372:
/* Line 1792 of yacc.c  */
#line 3268 "parser.ypp"
    { (yyval.node) = new QoreLogicalNotEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 373:
/* Line 1792 of yacc.c  */
#line 3269 "parser.ypp"
    { (yyval.node) = new QoreLogicalLessThanOrEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 374:
/* Line 1792 of yacc.c  */
#line 3270 "parser.ypp"
    { (yyval.node) = new QoreLogicalGreaterThanOrEqualsOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 375:
/* Line 1792 of yacc.c  */
#line 3271 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_SHIFT_LEFT, (yyvsp[(3) - (3)].node)); }
    break;

  case 376:
/* Line 1792 of yacc.c  */
#line 3272 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_SHIFT_RIGHT, (yyvsp[(3) - (3)].node)); }
    break;

  case 377:
/* Line 1792 of yacc.c  */
#line 3273 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_PLUS, (yyvsp[(3) - (3)].node)); }
    break;

  case 378:
/* Line 1792 of yacc.c  */
#line 3274 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_MINUS, (yyvsp[(3) - (3)].node)); }
    break;

  case 379:
/* Line 1792 of yacc.c  */
#line 3275 "parser.ypp"
    { (yyval.node) = new QoreModuloOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 380:
/* Line 1792 of yacc.c  */
#line 3276 "parser.ypp"
    { (yyval.node) = new QoreDivisionOperatorNode((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 381:
/* Line 1792 of yacc.c  */
#line 3277 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (3)].node), OP_MULT, (yyvsp[(3) - (3)].node)); }
    break;

  case 382:
/* Line 1792 of yacc.c  */
#line 3278 "parser.ypp"
    { (yyval.node) = new QoreSquareBracketsOperatorNode((yyvsp[(1) - (4)].node), (yyvsp[(3) - (4)].node)); }
    break;

  case 383:
/* Line 1792 of yacc.c  */
#line 3279 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (4)].node), OP_OBJECT_REF, (yyvsp[(3) - (4)].node)); }
    break;

  case 384:
/* Line 1792 of yacc.c  */
#line 3280 "parser.ypp"
    { (yyval.node) = process_dot((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 385:
/* Line 1792 of yacc.c  */
#line 3281 "parser.ypp"
    { (yyval.node) = new QoreTreeNode((yyvsp[(1) - (2)].node), OP_OBJECT_REF, (yyvsp[(2) - (2)].String)); }
    break;

  case 386:
/* Line 1792 of yacc.c  */
#line 3285 "parser.ypp"
    {
	   (yyval.String) = (yyvsp[(1) - (1)].String);
	}
    break;

  case 387:
/* Line 1792 of yacc.c  */
#line 3288 "parser.ypp"
    {
	   (yyval.String) = (yyvsp[(1) - (2)].String);
	   (yyval.String)->concat((yyvsp[(2) - (2)].String));
	   (yyvsp[(2) - (2)].String)->deref();
	}
    break;

  case 388:
/* Line 1792 of yacc.c  */
#line 3295 "parser.ypp"
    { (yyval.node) = new QoreFloatNode((yyvsp[(1) - (1)].decimal)); }
    break;

  case 389:
/* Line 1792 of yacc.c  */
#line 3296 "parser.ypp"
    { (yyval.node) = new QoreBigIntNode((yyvsp[(1) - (1)].integer)); }
    break;

  case 390:
/* Line 1792 of yacc.c  */
#line 3297 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].String); }
    break;

  case 391:
/* Line 1792 of yacc.c  */
#line 3298 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].datetime); }
    break;

  case 392:
/* Line 1792 of yacc.c  */
#line 3299 "parser.ypp"
    { (yyval.node) = (yyvsp[(1) - (1)].num); }
    break;


/* Line 1792 of yacc.c  */
#line 9920 "parser.cpp"
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (&yylloc, yyscanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, &yylloc, yyscanner);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[1] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner);
    }
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


/* Line 2055 of yacc.c  */
#line 3302 "parser.ypp"

